/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.qftest.launch;

import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import de.qfs.lib.util.ProcessManager;
import de.qfs.lib.util.VersionNumber;
import de.qfs.qftest.Activator;
import de.qfs.qftest.launch.QFSLaunchConstants;
import de.qfs.qftest.launch.VariablesPropertyDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.externaltools.internal.launchConfigurations.ExternalToolsCoreUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsMainTab;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public class QFSMainTab
extends ExternalToolsMainTab {
    private static HashMap<String, Pair<Boolean, String>> versionMap = new HashMap();
    private ILaunchConfiguration launchConfiguration;
    private Combo launchConfigCombobox;
    private Table propsTable;
    private Button removePropButton;
    private Button editPropButton;
    private Composite comp;

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createLocationComponent(mainComposite);
        this.createLaunchConfigComboComponent(mainComposite);
        this.createVariablesComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 1);
        Dialog.applyDialogFont((Control)parent);
    }

    public static HashMap<String, Pair<Boolean, String>> getVersionMap() {
        return versionMap;
    }

    public String getName() {
        return "Main";
    }

    protected String getLocationLabel() {
        return "QF-Test executable:";
    }

    protected void createWorkDirectoryComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = "QF-Test version directory";
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.workDirectoryField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.workDirectoryField.setLayoutData((Object)data);
        this.workDirectoryField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.workDirectoryField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.workspaceWorkingDirectoryButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Browse_Wor_kspace____6, null);
        this.workspaceWorkingDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.workspaceWorkingDirectoryButton, String.valueOf(group.getText()) + " " + this.workspaceWorkingDirectoryButton.getText());
        this.fileWorkingDirectoryButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Browse_F_ile_System____7, null);
        this.fileWorkingDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fileWorkingDirectoryButton, String.valueOf(group.getText()) + " " + this.fileWorkingDirectoryButton.getText());
        this.variablesWorkingDirectoryButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_32, null);
        this.variablesWorkingDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.variablesWorkingDirectoryButton, String.valueOf(group.getText()) + " " + this.variablesWorkingDirectoryButton.getText());
    }

    protected void createLaunchConfigComboComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Run configuration to be used as SUT:");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.launchConfigCombobox = SWTFactory.createCombo((Composite)group, (int)12, (int)1, null);
        this.launchConfigCombobox.addModifyListener((ModifyListener)this.fListener);
        this.fillLaunchConfigs();
    }

    public void fillLaunchConfigs() {
        try {
            this.launchConfigCombobox.add("QF-Test only");
            ILaunchConfiguration[] configurations = this.getLaunchManager().getLaunchConfigurations();
            int i = 0;
            while (i < configurations.length) {
                ILaunchConfiguration configuration = configurations[i];
                String s = String.valueOf(configuration.getType().getName()) + " : " + configuration.getName();
                if (this.isValidLaunchType(configuration)) {
                    this.launchConfigCombobox.add(configuration.getName());
                }
                ++i;
            }
            this.launchConfigCombobox.setVisibleItemCount(Math.min(configurations.length, 20));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.qfs.qftest", "fill launch config", (Throwable)e));
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        this.fInitializing = true;
        this.updateUsedLaunchConfig(configuration);
        this.updateLocation(configuration);
        this.updateVariables(configuration);
        this.fInitializing = false;
        this.setDirty(false);
    }

    protected void updateUsedLaunchConfig(ILaunchConfiguration configuration) {
        String usedConfigName = "QF-Test only";
        try {
            usedConfigName = configuration.getAttribute("qfs_used_launch_config", "QF-Test only");
            this.launchConfigCombobox.setText(usedConfigName);
        }
        catch (CoreException ce) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.qfs.qftest", "update launch config", (Throwable)ce));
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String usedLaunchConfigName = this.launchConfigCombobox.getText();
        if (usedLaunchConfigName.length() == 0) {
            configuration.setAttribute("qfs_used_launch_config", null);
        } else {
            configuration.setAttribute("qfs_used_launch_config", usedLaunchConfigName);
        }
        String location = this.locationField.getText().trim();
        if (location.length() == 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", location);
        }
        if (this.propsTable != null) {
            ArrayList<String> properties = new ArrayList<String>();
            TableItem[] tableItemArray = this.propsTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                String name = item.getText(0);
                String value = item.getText(1);
                if (name != null && name.trim().length() > 0) {
                    String prop = String.valueOf(name.trim()) + "=" + (value == null ? "" : value);
                    properties.add(prop);
                }
                ++n2;
            }
            configuration.setAttribute("qfs_startup_nodes", properties);
        }
        configuration.setAttribute("editedByExternalToolsMainTab", false);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean newConfig = false;
        try {
            newConfig = launchConfig.getAttribute("editedByExternalToolsMainTab", false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (this.validateLocation(newConfig)) {
            boolean isValidVersion = QFSMainTab.isValidQFTestVersion(launchConfig);
            if (!isValidVersion) {
                this.setErrorMessage("QF-Test version has to be newer or equal 4.1.0!");
            }
            return isValidVersion;
        }
        return false;
    }

    public boolean isValidLaunchType(ILaunchConfiguration launchConfig) {
        String id = null;
        try {
            id = launchConfig.getType().getIdentifier();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return id != null && !id.equals("de.qfs.qftest.launchConfigurationType_ID");
    }

    public static boolean isValidQFTestVersion(ILaunchConfiguration launchConfig) {
        IPath workingDirectory = null;
        try {
            workingDirectory = ExternalToolsCoreUtil.getLocation((ILaunchConfiguration)launchConfig);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.qfs.qftest", "get work dir location", (Throwable)e));
            return false;
        }
        IPath location = null;
        if (workingDirectory != null) {
            String exe;
            if (Misc.OS_IS_WINDOWS) {
                exe = workingDirectory.lastSegment();
                if ("qftest.exe".equals(exe) || "qftestc.exe".equals(exe) || "qftest64.exe".equals(exe) || "qftestc64.exe".equals(exe) || "qftest32.exe".equals(exe) || "qftestc32.exe".equals(exe)) {
                    location = workingDirectory;
                }
            } else {
                File resolvedLocation;
                exe = workingDirectory.lastSegment();
                if ("qftest".equals(exe) || "qftestc".equals(exe) || "qftest.ksh".equals(exe)) {
                    location = workingDirectory;
                } else if (Misc.OS_IS_MAC_OS_X && (resolvedLocation = QFSMainTab.locationOfMacExecutable(new File(workingDirectory.toOSString()))) != null) {
                    location = new Path(resolvedLocation.getAbsolutePath());
                }
            }
        }
        if (location != null && location.toFile() != null && location.toFile().exists()) {
            String cmdLine = location.toOSString();
            IPath qftestFolder = location.uptoSegment(location.segmentCount() - 2);
            Pair version = versionMap.get(qftestFolder.toOSString());
            if (version == null) {
                version = new Pair((Object)false, (Object)"");
                try {
                    String versionCheckOutput = ProcessManager.runProcess((String[])new String[]{cmdLine, "-batch", "-version", "-nomessagewindow"}, (int)5000);
                    if (versionCheckOutput != null) {
                        Pattern versionPattern = Pattern.compile("This is .*? release\\s+([0-9]+\\.[0-9]+\\.[0-9]+(?:-[a-zA-Z0-9\\-]+)?)");
                        String[] stringArray = versionCheckOutput.split("\r?\n");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String versionStr;
                            String line = stringArray[n2];
                            Matcher versionMatcher = versionPattern.matcher(line);
                            if (versionMatcher.find() && QFSLaunchConstants.QFS_MIN_VERSION.compareTo(VersionNumber.fromString((String)(versionStr = versionMatcher.group(1)))) <= 0) {
                                version = new Pair((Object)true, (Object)versionStr);
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            versionMap.put(qftestFolder.toOSString(), version);
            return (Boolean)version.getFirst();
        }
        return false;
    }

    protected static File locationOfExecutable(String expandedLocation) {
        File macLocation;
        File location = new File(expandedLocation);
        if (Misc.OS_IS_MAC_OS_X && (macLocation = QFSMainTab.locationOfMacExecutable(location)) != null) {
            return macLocation;
        }
        return location;
    }

    private static File locationOfMacExecutable(File location) {
        File baseDir;
        String workingDirAsString = location.getAbsolutePath();
        int appPathEndIndex = workingDirAsString.indexOf(".app");
        if (appPathEndIndex > -1) {
            workingDirAsString = workingDirAsString.substring(0, appPathEndIndex);
        }
        if ((baseDir = new File(workingDirAsString = String.valueOf(workingDirAsString) + ".app/Contents/Resources/qftest/qftest-current/bin")) != null && baseDir.exists()) {
            return new File(baseDir, "qftest");
        }
        return null;
    }

    protected boolean validateLocation(boolean newConfig) {
        boolean wasExpanded;
        String expandedLocation;
        String location;
        block11: {
            location = this.locationField.getText().trim();
            if (location.length() < 1) {
                if (newConfig) {
                    this.setErrorMessage(null);
                    this.setMessage("Please specify the location of the QF-Test executable");
                } else {
                    this.setErrorMessage("QF-Test executable location cannot be empty");
                    this.setMessage(null);
                }
                return false;
            }
            expandedLocation = null;
            wasExpanded = false;
            try {
                expandedLocation = this.resolveValue(location);
                if (expandedLocation != null) break block11;
                return true;
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getStatus().getMessage());
                return false;
            }
        }
        wasExpanded = !expandedLocation.equals(location);
        File file = QFSMainTab.locationOfExecutable(expandedLocation);
        if (!file.exists()) {
            if (!newConfig) {
                this.setErrorMessage("QF-Test executable location does not exist");
            }
            return false;
        }
        if (!file.isFile()) {
            if (!newConfig) {
                this.setErrorMessage("QF-Test executable location is not a file");
            }
            return false;
        }
        String exePath = file.getAbsolutePath();
        if (!wasExpanded && !exePath.equals(expandedLocation)) {
            this.locationField.setText(exePath);
        }
        return true;
    }

    protected void createVariablesComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Startup nodes:");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(1808);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.comp = SWTFactory.createComposite((Composite)group, (Font)parent.getFont(), (int)2, (int)0, (int)1808, (int)0, (int)0);
        TableViewer tableViewer = new TableViewer(this.comp, 67586);
        tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem[] selection = QFSMainTab.this.propsTable.getSelection();
                if (selection.length == 1) {
                    QFSMainTab.this.editProperty(selection[0].getText(0), selection[0].getText(1));
                }
            }
        });
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableItem[] items = QFSMainTab.this.propsTable.getSelection();
                if (items == null || items.length == 0) {
                    QFSMainTab.this.editPropButton.setEnabled(false);
                    QFSMainTab.this.removePropButton.setEnabled(false);
                } else if (items.length == 1) {
                    QFSMainTab.this.editPropButton.setEnabled(true);
                    QFSMainTab.this.removePropButton.setEnabled(true);
                } else {
                    QFSMainTab.this.editPropButton.setEnabled(false);
                    QFSMainTab.this.removePropButton.setEnabled(true);
                }
            }
        });
        this.propsTable = tableViewer.getTable();
        this.propsTable.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        this.propsTable.setLinesVisible(true);
        this.propsTable.setHeaderVisible(true);
        final TableColumn propColumn = new TableColumn(this.propsTable, 0, 0);
        propColumn.setWidth(400);
        propColumn.setText("Test-suite");
        final TableColumn valueColumn = new TableColumn(this.propsTable, 0, 1);
        valueColumn.setWidth(200);
        valueColumn.setText("QF-Test ID of node");
        final Table tref = this.propsTable;
        final Composite tableComposite = this.comp;
        tableComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = tableComposite.getClientArea();
                Point size = tref.computeSize(-1, -1);
                ScrollBar vBar = tref.getVerticalBar();
                int width = area.width - tref.computeTrim((int)0, (int)0, (int)0, (int)0).width - 2;
                if (size.y > area.height + tref.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tref.getSize();
                if (oldSize.x > area.width) {
                    propColumn.setWidth(width / 2 - 1);
                    valueColumn.setWidth(width - propColumn.getWidth());
                    tref.setSize(area.width, area.height);
                } else {
                    tref.setSize(area.width, area.height);
                    propColumn.setWidth(width / 2 - 1);
                    valueColumn.setWidth(width - propColumn.getWidth());
                }
            }
        });
        Button addPropButton = new Button(this.comp, 0);
        addPropButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addPropButton.setText("Add..");
        addPropButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QFSMainTab.this.addProperty();
            }
        });
        new Label(this.comp, 0);
        this.editPropButton = new Button(this.comp, 0);
        this.editPropButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.editPropButton.setText("Edit..");
        this.editPropButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection;
                if (QFSMainTab.this.propsTable.getSelectionCount() > 0 && (selection = QFSMainTab.this.propsTable.getSelection()).length == 1) {
                    QFSMainTab.this.editProperty(selection[0].getText(0), selection[0].getText(1));
                }
            }
        });
        new Label(this.comp, 0);
        this.editPropButton.setEnabled(false);
        this.removePropButton = new Button(this.comp, 0);
        this.removePropButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.removePropButton.setText("Remove");
        this.removePropButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QFSMainTab.this.propsTable.getSelectionCount() > 0) {
                    QFSMainTab.this.propsTable.remove(QFSMainTab.this.propsTable.getSelectionIndices());
                    QFSMainTab.this.entriesChanged();
                }
            }
        });
        this.removePropButton.setEnabled(false);
    }

    private void addProperty() {
        VariablesPropertyDialog dialog = this.getVariablesPropertyDialog("Add", "", "");
        if (dialog.open() == 0) {
            TableItem item = new TableItem(this.propsTable, 0);
            item.setText(0, dialog.getName());
            item.setText(1, dialog.getValue());
            this.entriesChanged();
        }
    }

    private void editProperty(String name, String value) {
        VariablesPropertyDialog dialog = this.getVariablesPropertyDialog("Edit", name, value);
        if (dialog.open() == 0) {
            TableItem[] item = this.propsTable.getSelection();
            item[0].setText(0, dialog.getName());
            item[0].setText(1, dialog.getValue());
            this.entriesChanged();
        }
    }

    protected void updateVariables(ILaunchConfiguration configuration) {
        try {
            if (this.propsTable != null) {
                this.propsTable.removeAll();
                List properties = configuration.getAttribute("qfs_startup_nodes", Collections.EMPTY_LIST);
                for (String property : properties) {
                    int index = property.indexOf(61);
                    String name = property;
                    String value = "";
                    if (index > -1) {
                        name = property.substring(0, index);
                        if (index > 1) {
                            value = property.substring(index + 1);
                        }
                    }
                    TableItem item = new TableItem(this.propsTable, 0);
                    item.setText(0, name);
                    item.setText(1, value);
                }
            }
        }
        catch (CoreException ce) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.qfs.qftest", "update variables", (Throwable)ce));
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
    }

    private void entriesChanged() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    private VariablesPropertyDialog getVariablesPropertyDialog(String title, String initName, String initValue) {
        return new VariablesPropertyDialog(this.getShell(), title, initName, initValue, null, "Test-suite:", "QF-Test ID of node:");
    }

    private void validateVaribles(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        manager.validateStringVariables(expression);
    }

    private String resolveValue(String expression) throws CoreException {
        String expanded = null;
        try {
            expanded = this.getValue(expression);
        }
        catch (CoreException e) {
            this.validateVaribles(expression);
            return null;
        }
        return expanded;
    }

    private String getValue(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        return manager.performStringSubstitution(expression);
    }
}

