/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.qftest.launch;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VariablesPropertyDialog
extends Dialog {
    private final String title;
    private final String initialName;
    private final String initialValue;
    private final String variablesNameLabel;
    private final String variableValueLabel;
    private final VerifyListener verifyListener;
    protected Text nameText;
    protected Text valueText;
    private String name;
    private String value;

    public VariablesPropertyDialog(Shell shell, String title, String initialName, String initialValue, VerifyListener verifyListener, String variablesNameLabel, String variableValueLabel) {
        super(shell);
        this.title = title;
        this.initialName = initialName;
        this.initialValue = initialValue;
        this.verifyListener = verifyListener;
        this.variablesNameLabel = variablesNameLabel;
        this.variableValueLabel = variableValueLabel;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = 7;
        gridLayout.marginWidth = 12;
        comp.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(comp, 0);
        nameLabel.setText(this.variablesNameLabel);
        nameLabel.setFont(comp.getFont());
        this.nameText = new Text(comp, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.setFont(comp.getFont());
        this.nameText.setText(this.initialName == null ? "" : this.initialName);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariablesPropertyDialog.this.updateButtons();
            }
        });
        Label valueLabel = new Label(comp, 0);
        valueLabel.setText(this.variableValueLabel);
        valueLabel.setFont(comp.getFont());
        this.valueText = new Text(comp, 2052);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.valueText.setLayoutData((Object)gd);
        this.valueText.setFont(comp.getFont());
        this.valueText.setText(this.initialValue == null ? "" : this.initialValue);
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariablesPropertyDialog.this.updateButtons();
            }
        });
        return comp;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.name = this.nameText.getText();
            this.value = this.valueText.getText();
        } else {
            this.name = null;
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void updateButtons() {
        String name = this.nameText.getText().trim();
        String value = this.valueText.getText().trim();
        Event e = new Event();
        e.widget = this.nameText;
        VerifyEvent ev = new VerifyEvent(e);
        ev.doit = true;
        if (this.verifyListener != null) {
            ev.text = name;
            this.verifyListener.verifyText(ev);
        }
        this.getButton(0).setEnabled(name.length() > 0 && ev.doit);
    }

    public void create() {
        super.create();
        this.updateButtons();
    }
}

