/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.qftest.navigation;

import de.qfs.qftest.navigation.PropertiesTreeData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;

public class PropertiesContentProvider
implements ITreeContentProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final Object PROPERTIES_EXT = "qft";
    private final Map cachedModelMap = new HashMap();
    private StructuredViewer viewer;

    public PropertiesContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        return children != null ? children : NO_CHILDREN;
    }

    private synchronized Properties updateModel(IFile modelFile) {
        if (PROPERTIES_EXT.equals(modelFile.getFileExtension())) {
            Properties model = new Properties();
            if (modelFile.exists()) {
                try {
                    model.load(modelFile.getContents());
                    ArrayList<PropertiesTreeData> properties = new ArrayList<PropertiesTreeData>();
                    Enumeration<?> names = model.propertyNames();
                    while (names.hasMoreElements()) {
                        String propertyName = (String)names.nextElement();
                        properties.add(new PropertiesTreeData(propertyName, model.getProperty(propertyName), modelFile));
                    }
                    PropertiesTreeData[] propertiesTreeData = properties.toArray(new PropertiesTreeData[properties.size()]);
                    this.cachedModelMap.put(modelFile, propertiesTreeData);
                    return model;
                }
                catch (IOException iOException) {
                }
                catch (CoreException coreException) {}
            } else {
                this.cachedModelMap.remove(modelFile);
            }
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof PropertiesTreeData) {
            PropertiesTreeData data = (PropertiesTreeData)element;
            return data.getFile();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.cachedModelMap.clear();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        if (oldInput != null && !oldInput.equals(newInput)) {
            this.cachedModelMap.clear();
        }
        this.viewer = (StructuredViewer)aViewer;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean visit(IResourceDelta delta) {
        IResource source = delta.getResource();
        switch (source.getType()) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
            case 1: {
                final IFile file = (IFile)source;
                if (PROPERTIES_EXT.equals(file.getFileExtension())) {
                    this.updateModel(file);
                    new UIJob("Update Properties Model in CommonViewer"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (PropertiesContentProvider.this.viewer != null && !PropertiesContentProvider.this.viewer.getControl().isDisposed()) {
                                PropertiesContentProvider.this.viewer.refresh((Object)file);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return false;
            }
        }
        return false;
    }
}

