#!/bin/bash

if [ -n "$QFSUT_DEBUG" ]; then
    echo command: "$@"
fi

# determine QF-Test installation directory
binary=$0
if [ -n "$QFSUT_DEBUG" ]; then
    echo binary: $binary
fi
while [ -L "$binary" ]; do
    link=`ls -ld "$binary"`
    link=`expr "$link" : '.*-> \(.*\)$'`
    if [ -n "$QFSUT_DEBUG" ]; then
        echo following link: $link
    fi
    case $link in
    /*)
        binary=$link
        ;;
    *)
        binary=`dirname "$binary"`/$link
        ;;
    esac
done

bindir=`dirname "$binary"`
bindir=`cd "$bindir"; pwd`
basedir=`dirname "$bindir"`
topdir=`dirname "$basedir"`
if [ -n "$QFSUT_DEBUG" ]; then
    echo bindir: $bindir
    echo basedir: $basedir
    echo topdir: $topdir
fi

# parse arguments
serverhost=
clientname=

# java executable ist first
javaexe=$1; shift
if [ -n "$QFSUT_DEBUG" ]; then
    echo "got java executable: $javaexe"
fi

# serverhost is next
case $1 in
    \${customArgs*)
       if [ -n "$QFSUT_DEBUG" ]; then
           echo "ignoring unspecified custom arg: $1"
       fi
       ;;
    *)
       serverhost=$1
       if [ -n "$QFSUT_DEBUG" ]; then
           echo "got serverhost: $serverhost"
       fi
       ;;
esac
shift

# then clientname
case $1 in
    \${customArgs*)
       if [ -n "$QFSUT_DEBUG" ]; then
           echo "ignoring unspecified custom arg: $1"
       fi
       ;;
    *)
       clientname=$1
       if [ -n "$QFSUT_DEBUG" ]; then
           echo "got clientname: $clientname"
       fi
       ;;
esac
shift

# if we got serverhost and clientname, set up environment for qftest
if [ -n "$serverhost" -a -n "$clientname" ]; then
    export QFTEST_HOME="$topdir"
    export QFTEST_VERSIONDIR="$basedir"
    export QFTEST_SYSTEMDIR="$topdir"
    if [ -d "$HOME/.qftest/log" ]; then
        export QFTEST_LOGDIR="$HOME/.qftest/log"
    elif [ -d "$topdir/log" ]; then
        export QFTEST_LOGDIR="$topdir/log"
    else
        export QFTEST_LOGDIR="$TMP"
    fi
    export QFTEST_INSTRUMENT_EVENT_QUEUE=true
    export QFTEST_SWT_VIA_AGENT=true
    if [ -n "$JAVA_TOOL_OPTIONS" ]; then
        export JAVA_TOOL_OPTIONS="$JAVA_TOOL_OPTIONS -javaagent:$basedir/misc/qfconnect.jar"
    else
        export JAVA_TOOL_OPTIONS="-javaagent:$basedir/misc/qfconnect.jar"
    fi
    export QFTEST_SERVERHOST="$serverhost"
    export QFTEST_SERVERNAME=qftest
    export QFTEST_CLIENTNAME="$clientname"
    export QFTEST_CLIENTID=0
    if [ -n "$QFSUT_DEBUG" ]; then
        echo "patching environment"
        echo "QFTEST_HOME=$QFTEST_HOME"
        echo "QFTEST_VERSIONDIR=$QFTEST_VERSIONDIR"
        echo "QFTEST_SYSTEMDIR=$QFTEST_SYSTEMDIR"
        echo "QFTEST_LOGDIR=$QFTEST_LOGDIR"
        echo "QFTEST_INSTRUMENT_EVENT_QUEUE=$QFTEST_INSTRUMENT_EVENT_QUEUE"
        echo "QFTEST_SWT_VIA_AGENT=$QFTEST_SWT_VIA_AGENT"
        echo "JAVA_TOOL_OPTIONS=$JAVA_TOOL_OPTIONS"
        echo "QFTEST_SERVERHOST=$QFTEST_SERVERHOST"
        echo "QFTEST_SERVERNAME=$QFTEST_SERVERNAME"
        echo "QFTEST_CLIENTNAME=$QFTEST_CLIENTNAME"
        echo "QFTEST_CLIENTID=$QFTEST_CLIENTID"
    fi
fi

# delegate to java
if [ -n "$QFSUT_DEBUG" ]; then
    echo running "$javaexe" "$@"
fi
"$javaexe" "$@"
