#!/bin/sh

# **********************************************
# Start script for the CarConfig example.
# Arguments:
# [-engine <swing>] UI engine to use (swing/fx)
# [-lang <language>] It's either English or German.
# [-fontsize <fontsize>]  To setup font size.
# [-loadtest]  To start load test mode.
# [-login]  To start with login dialog. Use tester/tester to login.
# [-splash]  To start with splash screen.
# **********************************************
DEMODIR=$(cd -P -- "$(dirname -- "$0")" && pwd -P)
echo DEMODIR: "${DEMODIR}"
QF_JRE_FX=

if [ -n "$QFTEST_JAVA" ]; then
  JAVA_BIN="$QFTEST_JAVA"
  QF_JRE_FX=`dirname "$QFTEST_JAVA"`/../javafx
  echo "Got fxdir:" $QF_JRE_FX
else
  echo "Trying to find embedded JRE"
  if [ "$(uname)" = "Darwin" ]; then
    plugin_jre=$(bash -c "f='$DEMODIR/../../../../../Plugins/*.j*/Contents/Home';IFS=;echo \$f")
    embedded_jre=$(bash -c "f='$DEMODIR/../../jre/osx64*/Contents/Home';IFS=;echo \$f")
    if [ -e "$plugin_jre/bin/java" ]; then
        JAVA_BIN="$plugin_jre/bin/java"
        QF_JRE_FX="$plugin_jre/javafx"
    elif [ -e "$embedded_jre/bin/java" ]; then
        JAVA_BIN="$embedded_jre/bin/java"
        QF_JRE_FX="$embedded_jre/javafx"
    else
      echo "No embedded Java runtime found. Using default installed java."
      JAVA_BIN=java
    fi
  else
    QF_JRE_REL="$DEMODIR/../../jre"
    QF_JRE_REL_LIN64="$QF_JRE_REL/linux64"
    if [ -e "$QF_JRE_REL" ]; then
      if [ -e "$QF_JRE_REL_LIN64" ]; then
        JAVA_BIN="$QF_JRE_REL_LIN64/bin/java"
        QF_JRE_FX="$QF_JRE_REL_LIN64/javafx"
      else
        echo "No embedded Java runtime found. Using default installed java."
        JAVA_BIN=java
      fi
    else
      echo "No embedded Java runtime found. Using default installed java."
      JAVA_BIN=java
    fi
  fi
fi
echo "Using following java runtime:" $JAVA_BIN
echo "Using following JavaFX modules:" $QF_JRE_FX

vmargs=
if [ "$(uname)" = "Darwin" ]; then
  vmargs="-Xdock:icon=carconfig.icns -Xdock:name=CarConfigurator"
fi

cd "`dirname "$0"`"
if [ -n QF_JRE_FX ]; then
   "$JAVA_BIN" --module-path "$QF_JRE_FX/lib" --add-modules=javafx.controls,javafx.swing,javafx.fxml "-Djava.library.path=$QF_JRE_FX/lib" $vmargs -cp "../../qflib/qfdemo.jar:../../qflib/qflib.jar:../../lib/looks.jar:../../lib/batik.jar" "de.qfs.apps.qftest.demo.multi.carconfigurator.main.CarConfigurator" $@
else
    "$JAVA_BIN" $vmargs -cp "../../qflib/qfdemo.jar:../../qflib/qflib.jar:../../lib/looks.jar:../../lib/batik.jar" "de.qfs.apps.qftest.demo.multi.carconfigurator.main.CarConfigurator" $@
fi
