sidx_dump={"version":"0.9.5","fields":["content","h-1","h0","h1","h2","h3","hash"],"ref":"id","documentStore":{"docs":{"0":{"id":0,"content":"Mobile Manual","hash":"","h0":"Preface | QF‑Test Manual"},"1":{"id":1,"content":"Mobile Manual","hash":"home-link","h0":"Preface | QF‑Test Manual"},"2":{"id":2,"content":"Preface As the name indicates, Quality First Software GmbH is dedicated to quality assurance for the software development process. Our contribution to this area is the product QF‑Test the manual of which you are currently reading. QF‑Test is a professional tool for automating functional tests for Java or web applications with a graphical user interface. Depending on size and structure of a company the ungrateful task of testing sometimes falls to a QA department or team, sometimes to the developers and sometimes to the unlucky customer. Users of QF‑Test are therefore usually developers or testers with varying knowledge about software development and testing in general and Java or web GUIs in particular. The video 'Overview' gives a general overview of QF‑Test. You will find a more technical overview in the video 'Technical insights'. This manual is the primary source of information for QF‑Test. We have tried to explain things in a way that is understandable for all users, independent of their technical knowledge, yet provide a complete and concise reference. In case of Java specific questions, testers may fare best by contacting their developers who will surely be able to assist. Initially QF‑Test did only support Java Swing GUIs. With version 2.0 support for Eclipse/SWT was added and web support with version 3.0. Parts of QF‑Test and this manual owe to this history and most things are explained from the perspective of testing a Swing GUI. In most cases the concepts are universal apply similarly to all GUIs. Where things differ, specific notes explain the particularities of a web or SWT GUI.","hash":"sec_preface","h0":"Preface"},"3":{"id":3,"content":"How to use this manual A web-browser for the HTML manual can be launched directly from QF‑Test. The »Help«-»Manual...« menu item will take you to the entry page of the manual and »Help«-»News...« will bring up the section documenting the latest changes. Context-sensitive help is also available for all kinds of tree nodes, attributes and configurable options by clicking with the right mouse button and selecting »What's this?« from the popup menu. This may not work if the system's browser is not accessible from QF‑Test. The manual consists of three parts. These parts are: User manual This part explains how to install and run QF‑Test and how to work with its user interface. It shows how to create and organize tests, then continues with more advanced material. To avoid duplication of text, the user manual often refers to the reference manual for detailed explanation. We recommend that you follow these links. Reference manual This is a complete reference that covers all configurable options, all parts of a test suite, etc. When looking for specific information, this is the place to go. The reference manual also serves as the source for context-sensitive help. Technical reference The part about technical details contains in-depth and background information about miscellaneous topics as well as a comprehensive API reference for the scripting interface. Beginners will rarely need to take a look at this part, but for the advanced user and the technically interested it is a valuable resource. A learning-by-doing tutorial is also accessible from the »Help«-»Tutorial...« menu item and is located at qftest-10.0.2-mobile/doc/tutorial/en/tutorial.html. The following notations are used throughout the manual: »Menu«-»Submenu« represents a menu or menu item. Modifier⁠+⁠Key stands for a keystroke, where the modifier is one (or a combination) of Shift/⇧, Control/⌃, Alt/⌥, or ⌘. Monospaced font is used for names of directories and files, user input and program output. In the manual, the following keyboard shortcuts are available: →: Jump to next page ←: Jump to previous page L: Jump to translation of current page T: Jump to table of contents S: Show/hide navigation F: Focus search field During a search, the following keyboard shortcuts are also available: ↓: Jump to next search result ↑: Jump to previous search result Escape: Cancel search Results of a local search contain all requested terms in the same section. If possible, terms with the same root word are also found and partial words are completed. If you require an exact term to be present in the search result, enclose it in double quotes (\"…\").","hash":"sec_howtouse","h1":"How to use this manual"},"4":{"id":4,"content":"Mobile Manual","hash":"","h0":"User manual | QF‑Test Manual"},"5":{"id":5,"content":"Mobile Manual","hash":"home-link","h0":"User manual | QF‑Test Manual"},"6":{"id":6,"content":"User manual","hash":"sec_user","h1":"User manual"},"7":{"id":7,"content":"Mobile Manual","hash":"","h0":"Installation and startup | QF‑Test Manual"},"8":{"id":8,"content":"Mobile Manual","hash":"home-link","h0":"Installation and startup | QF‑Test Manual"},"9":{"id":9,"content":"Installation and startup The installation of QF‑Test on the supported operating systems is explained in detail in the subsequent sections. The following packages are available for download: Windows (\"Windows Installation\") On Windows QF‑Test is normally installed via the setup program QF‑Test-10.0.2-mobile.exe which requires administrator privileges. If you are lacking the required permissions or prefer to keep all QF‑Test files together in one place you can unpack the self-extracting archive QF‑Test-10.0.2-mobile-sfx.exe instead. Linux (\"Linux Installation\") On Linux and other Linux systems please unpack the archive QF‑Test-10.0.2-mobile.tar.gz. macOS (\"macOS Installation\") The disk-image QF‑Test-10.0.2-mobile.dmg is provided for the installation on macOS. It is possible to have different versions of QF‑Test installed in parallel. Existing configuration files will not be overwritten during setup. In \"Location of files\" you can find best practices about the QF‑Test installation.","hash":"usec_installation","h0":"Installation and startup"},"10":{"id":10,"content":"System requirements","hash":"usec_install_system","h1":"System requirements"},"11":{"id":11,"content":"Hard- and Software QF‑Test itself runs with Java 21. The required 64bit Java Runtime Environment (JRE) is provided with QF‑Test, so Java does not need to be installed on your system unless required by the SUT. If your system under test (SUT) uses Java it should typically use its own JRE, not that of QF‑Test. The Java command for the SUT can be configured separately when creating the setup sequence for your SUT. Supported Java versions for the SUT are listed below. For a QF‑Test installation you need to reserve about 1 GB on your hard disk. The required RAM to work with QF‑Test is in the same region but depends on the sizes of your test suites and the length of your test run, see \"I've got a long-running test and QF‑Test runs out of memory. How can I prevent that?\". Note that you need to add the resources required by the SUT.","hash":"sec_hard_and_software","h2":"Hard- and Software"},"12":{"id":12,"content":"Supported technologies - QF‑Test The following table summarizes the officially supported versions of operating systems and required software for this QF‑Test version 10.0.2-mobile. Support for additional systems and versions may be available on request but is not owed by QFS. Another option to get support for older software can be to use one of the older QF‑Test versions that are still available for download at www.qftest.com/produkt/download.html. Support for 32 bit software was deprecated for removal in QF‑Test version 7.0 and removed in QF‑Test version 8. Testing of native 32 bit Windows applications remains supported. Java 21 is shipped with QF‑Test. QF‑Test runs on JDK/JRE 21 or higher on the following operating systems:","hash":"usec_techversions_qftest","h2":"Supported technologies - QF‑Test"},"13":{"id":13,"content":"Technology Version restriction Restrictions for SUT technologies Windows10, 11, Server 2016, Server 2019, Server 2022no iOS Linux no windows or iOS macOSmacOS 12 or higherno windows or SWT Table 1.1: Supported operating systems for QF‑Test","hash":"usec_techversion_qftest_table","h2":"Supported technologies - QF‑Test"},"14":{"id":14,"content":"Supported technologies - System under Test The following table summarizes the officially supported versions of operating systems and required software for this QF‑Test version 10.0.2-mobile. Support for additional systems and versions may be available on request but is not owed by QFS. Another option to get support for older software can be to use one of the older QF‑Test versions that are still available for download at www.qftest.com/produkt/download.html. The system under test can be run on the same operating systems as QF‑Test, for restrictions see Supported operating systems for QF‑Test. Support for 32bit software was deprecated in QF‑Test version 7.0 and removed in version 8.0. However, testing of 32bit native Windows applications remains supported.","hash":"usec_techversions_sut","h2":"Supported technologies - System under Test"},"15":{"id":15,"content":"Technology Version restriction Comment JDK/JRE 8 - 26 for the SUT Swing All platforms. JavaFX8 or higherAll platforms. SWT3.7 - 4.38 (i.e. 2025-12)64bit x86 on Windows and Linux GTK only, GTK3 with SWT 4.6 and higher. For 32bit Eclipse/SWT versions please use QF‑Test 7.1 or older. For Eclipse/SWT 3.5 - 3.6 simply download https://archive.qfs.de/pub/qftest/swt_legacy.zip and extract the contents into the swt directory of your QF‑Test installation. Table 1.2: Supported Java technologies","hash":"table_1.2","h2":"Supported technologies - System under Test"},"16":{"id":16,"content":"Technology Version restriction Comment Chrome Version 131 via QF-Driver, current versions via Chrome DevTools Protocol (CDP-Driver) and automatic ChromeDriver download (WebDriver). Headless Chrome supported. See also Browser connection mode Firefox (WebDriver) As supported by the included GeckoDriver, i.e. currently 128esr and higher. Headless Firefox supported Microsoft EdgeCurrent versions via Chrome DevTools Protocol (CDP-Driver) and automatic MSEdgeDriver download (WebDriver). Headless Edge supported. OperaCurrent versions via Chrome DevTools Protocol (CDP-Driver). Safari WebDriver with Safari JxBrowserversion 6, 7 and 8, embedded into Swing, JavaFX or SWT Electron 1.7 and newer Web component libraries Detailed list of supported toolkits in \"Special support for various web frameworks\" Table 1.3: Supported web browsers and toolkits","hash":"table_1.3","h2":"Supported technologies - System under Test"},"17":{"id":17,"content":"Technology Version restriction Comment Native Windows applications QF‑Test can test applications supporting Microsoft UI Automation or the Microsoft Active Accessibility (MSAA) interface. For more information see \"Getting started\" Android Android API 24 or höher, which means Android version 7 Nougat or later. For more information see Preconditions and known restrictions iOS iOS 15 or higher - there may be system related restrictions due to the installed Xcode version. iOS applications can only be tested on a macOS system where a Xcode development environment, version 13 or higher, is installed. For more information see Preconditions and known restrictions PDF For general information see PDF document testing Table 1.4: Other supported technologies","hash":"table_1.4","h2":"Supported technologies - System under Test"},"18":{"id":18,"content":"Windows Installation On Windows QF‑Test can be installed in two variants.","hash":"usec_install_windows","h1":"Windows Installation"},"19":{"id":19,"content":"Installing via the Windows setup file QF‑Test-10.0.2-mobile.exe This setup requires administrator privileges and follows the Windows standard of separating read-only program files from writable configuration files. If an older QF‑Test version is detected it is also possible to skirt Windows standards and install QF‑Test and its system configuration together at the place of the old installation. Windows compliant installation Program files are saved to C:\\Program Files\\QFS\\QF‑Test or whichever target directory you choose. The system configuration with writable data is stored in %PROGRAMDATA%\\QFS\\QF‑Test, irrespective of the selected target directory. %PROGRAMDATA% usually refers to the directory C:\\ProgramData but the name may vary depending on the Windows system. By default is is hidden in Windows Explorer. A simple way to navigate to this directory is to enter %PROGRAMDATA% into the address bar of Windows Explorer. In a PowerShell window use cd $env:PROGRAMDATA, in a cmd console window cd /d %PROGRAMDATA% to change to the respective drive and directory. Installation together with an existing QF‑Test version If an older QF‑Test installation is found and there is no system configuration in %PROGRAMDATA%\\QFS\\QF‑Test yet, you choose to follow the Windows compliant installation using %PROGRAMDATA% or to stick with the existing structure and install QF‑Test there. In the first case, after selecting the target directory for the QF‑Test program files, the system configuration files are copied - just this once - from the existing installation to %PROGRAMDATA%\\QFS\\QF‑Test. When installing into the existing structure, QF‑Test is installed into that directory and shares the system configuration that is already present there. In both cases the directory %PROGRAMDATA%\\QFS\\QF‑Test\\qftestpath is added to the system PATH and the program files qftest.exe and qftestc.exe are copied there. This allows to start QF‑Test from anywhere. Independent of the installation choice both old and new QF‑Test can be run in parallel. In case of the Windows compliant installation with %PROGRAMDATA% the old and new system configuration are independent. If the old structure is kept, all versions share the same system configuration. In the medium to long term we advise to move to %PROGRAMDATA% because the old structure requires changing access rights in the program directory, which is questionable. However, while migrating tests from QF‑Test 4.1 to 4.2 it may be convenient to keep both versions close together. The move to a Windows compliant installation using %PROGRAMDATA% can also be made in the course of a later installation. Silent Installation For an automatic distribution on test systems it might be necessary to install QF‑Test silently. QF‑Test supports this kind of installation because the installer is based on Inno Setup. This allows to use nearly all documented parameters from https://jrsoftware.org/ishelp/index.php?topic=setupcmdline at the installation of QF‑Test. You can perform a silent default installation with QF‑Test-10.0.2-mobile.exe /VERYSILENT. If you want to not create a Deskop icon you can run QF‑Test-10.0.2-mobile.exe /VERYSILENT /MERGETASKS=\"!desktopicon\". This executes a standard installation without the task \"desktopicon\". Both the minisetup-admin.exe and minisetup-noadmin.exe can also be installed silently. For example via minisetup-admin.exe /VERYSILENT. Please note that the installation for all users always requires elevated administrative rights. To also automatically accept the Windows UAC dialog the calling process must already have elevated rights. The parameter /CURRENTUSER does not help here, because the installation always requires elevated rights independent of installing for all or just the current user. An exception of this rule is minisetup-noadmin.exe, which allows to configure an already installed QF‑Test for the current user only. It does not need elevated rights. Instead of performing a silent installation you can also use the portable self-extracting archive QF‑Test-10.0.2-mobile-sfx.exe.","hash":"sec_installing_via_the_windows_setup_file_qf_test_exe","h2":"Installing via the Windows setup file QF‑Test-10.0.2-mobile.exe"},"20":{"id":20,"content":"Unpacking the self-extracting archive QF‑Test-10.0.2-mobile-sfx.exe If you don't have administrator privileges or want to keep all QF‑Test files together in a single place, unpack the archive QF‑Test-10.0.2-mobile-sfx.exe at a suitable place. To do so, copy the file to the desired location and execute it there. If 7-Zip is installed on your system you can also right-click the archive to open and extract it with 7-Zip. This will create a directory named qftest at the target location which we will refer to as the root directory of QF‑Test and that will also hold QF‑Test's system configuration files. After unpacking the files you can run the program minisetup-noadmin.exe in the subdirectory qftest-10.0.2-mobile. It will create associations for the file extensions belonging to QF‑Test and optionally a startup menu entry and a desktop icon for QF‑Test. If you have administrator privileges you can run minisetup-admin.exe instead which applies the same settings for all users and also adds the directory %PROGRAMDATA%\\QFS\\QF‑Test\\qftestpath to the system PATH and copies the program files qftest.exe and qftestc.exe there. If you'd rather have a fully portable installation instead, you can create a folder named userdir in the qftest directory which will then serve as the user-specific configuration directory in place of %APPDATA%\\QFS\\QF‑Test so that really all files belonging to QF‑Test are kept together in one place and no changes are made to the system.","hash":"sec_unpacking_the_self_extracting_archive_qf_test_sfx_exe","h2":"Unpacking the self-extracting archive QF‑Test-10.0.2-mobile-sfx.exe"},"21":{"id":21,"content":"Completing the installation and configuring Java As the last step each of the setup programs will offer to configure the Java program for QF‑Test which is done with the help of a small dialog in which you can make your choices. With a portable installation you can run the program qftest\\qftest-10.0.2-mobile\\bin\\qfconfig.exe to achieve the same. A 64bit Java 21 Runtime Environment is installed with QF‑Test into its installation folder. It is recommended to use it. The dialog also lets you adjust the maximum amount of memory to be used by QF‑Test with a default of 1024 MB. The third value to be configured is the language for QF‑Test. Normally the language is determined by the system settings, but you can also choose to always use the English or the German version. The values above are stored in the file launcherwin.cfg in QF‑Test's system configuration directory from where they are read by the qftest.exe start program. You can run the configuration program any time from the system menu to change these settings.","hash":"sec_completing_the_installation_and_configuring_java","h2":"Completing the installation and configuring Java"},"22":{"id":22,"content":"Linux Installation First select a convenient directory that will contain this release of QF‑Test as well as future updates. Common choices are /opt or /usr/local. Make sure you have write access to this directory and change to it. When upgrading to a new QF‑Test version, use the same directory again. Unpack the .tar.gz archive with tar xfzv QF‑Test-10.0.2-mobile.tar.gz. This will create a directory named qftest, which we will refer to as the main or root directory of QF‑Test. On a Linux system this also serves as the system directory holding the system configuration files of QF‑Test. After unpacking a QF‑Test archive for the first time, QF‑Test's root directory will hold only the version-specific subdirectory qftest-10.0.2-mobile. When upgrading, a new subdirectory for the current version will be added. To finish the installation, change to the specific directory for the current QF‑Test version with cd qftest/qftest-10.0.2-mobile and run the setup script provided (setup.sh). The setup script will create the directories log, jython groovy and javascript under QF‑Test's root directory unless they already exist. Additionally it will offer to create a symbolic link from the /usr/local/bin directory (or /usr/bin if there is no /usr/local/bin) to the shell run script for the qftest command. You need to have write permission to the /usr/local/bin directory for the link to be created. On Linux QF‑Test should normally use its own JRE. Alternatively the default java program for QF‑Test can be defined now. Either way it can be overridden at execution time with the -java <executable> (deprecated) argument. The setup script searches PATH and proposes to use the first java program it detects. If you want to use a different program or if none was found, you can enter one. The script determines the JDK version automatically. Next setting to perform is the maximum amount of memory to be used by QF‑Test. As default 1024 MB are taken. Alternatively QF‑Test can be started with the -J-XmxZZZm command line argument, where ZZZ defines the memory in MB. Finally the language for QF‑Test can be configured. By default the language depends on the system settings, but you can also choose to always use the English or the German version. Note that this setting will affect all QF‑Test users. Alternatively you can run QF‑Test with the -J-Duser.language=XX option using en for English or de for German. Those of the above settings that differ from the default are written to the file launcher.cfg in QF‑Test's root directory. This file is read by the qftest launch-script and also evaluated during an update of QF‑Test.","hash":"usec_install_linux","h1":"Linux Installation"},"23":{"id":23,"content":"macOS Installation To install QF‑Test on a macOS System, simply mount the QF‑Test-10.0.2-mobile.dmg disk image and copy the QF‑Test app to your Applications directory (or any other folder) and start it from there. To configure custom program arguments like memory used by QF‑Test or the language there is a separate options-page in the QF‑Test options (General->Startup). You can configure the settings there and they will then be applied after restarting QF‑Test.","hash":"usec_install_macos","h1":"macOS Installation"},"24":{"id":24,"content":"The license file QF‑Test requires a license file to run, which you should have received from Quality First Software GmbH. Since QF‑Test 4.0 the preferred way to activate or update your QF‑Test license is by way of the menu »Help«-»Update license...«. The traditional way as described below is also still valid. Place the license file into the system directory of QF‑Test. On Windows, depending on the type of installation, this will be %PROGRAMDATA%\\QFS\\QF‑Test (see \"Windows Installation\") or the root directory of your QF‑Test installation as on Linux. Make sure the file is named license with no extension. Some mail clients try to guess the file type and add an extension on their own. When upgrading to a new QF‑Test version you can simply keep the license file provided that it is valid for the new version. For a complete list of the directories relevant to QF‑Test please open the info dialog via the menu »Help«-»Info« and select the \"System info\" tab. The video 'License update' shows how to update a license. If you need to upgrade your license, for example to increase the number of concurrent QF‑Test instances or when upgrading to a new version, you will receive a file called license.new from Quality First Software GmbH which is typically not a valid license in itself but must be combined with your current license. To do so, proceed as follows: Place the file license.new in the same directory as the current license. Make sure that this directory and the file license are writable by you. Start QF‑Test in interactive mode. QF‑Test will detect the license update, verify its validity and offer to upgrade your license file. If you agree, the current license will be renamed to license.old and the new, combined license will be written to license. When you are satisfied that everything is OK, you can remove the files license.old and license.new. If QF‑Test doesn't seem to recognize the license upgrade, make sure that the timestamp of the file license.new is newer than that of the file license. Also make sure that no other instance of QF‑Test is running on your computer. In case you need to specify a special name or location for the license file or work with more than one license, this can be achieved with help of the -license <file> argument as described in \"Command line arguments and exit codes\".","hash":"usec_licensefile","h1":"The license file"},"25":{"id":25,"content":"The configuration files By default, all QF‑Test installations share the same configuration files, so you can easily switch between several QF‑Test versions and editions. For a complete list of the directories relevant to QF‑Test please open the info dialog via the menu »Help«-»Info« and select the \"System info\" tab. QF‑Test saves all of its window configuration and those global options that represent personal preferences together in a file named config located in the QF‑Test user configuration directory which also holds run logs for tests run in interactive mode, profile directories for web testing and temporary files for editing and running scripts. On Windows the user configuration directory defaults to %APPDATA%\\QFS\\QF‑Test for new installations. If that directory doesn't exist and you already used a QF‑Test version older than 4.2 on the same system that created the directory .qftest in your home directory for the user configuration, QF‑Test will continue to use that .qftest directory. You can manually move the content of the directory .qftest to %APPDATA%\\QFS\\QF‑Test and delete .qftest afterwards. QF‑Test since version 4.2.0 will then use this directory only. You should not move the files if you still want to use a version older than 4.2.0! On Linux the user configuration directory is always ~/.qftest. On macOS it is located at /Users/<username>/Library/Application Support/de.qfs.apps.qftest. The personal config file is not read when QF‑Test is run in batch mode (see \"Starting QF‑Test\"). Irrespective of the system default you can always specify an explicit location for the user configuration directory as a whole with the -userdir <directory> command line argument and just for the user config file with -usercfg <file>. System specific options that need to be shared between users are saved in a file called qftest.cfg in the system configuration directory which also serves as the home for the license file, script modules, Java plugins and other customization files. On Windows the location of the system configuration directory depends on the installation variant (c.f. \"Windows Installation\"). It is either located in %PROGRAMDATA%\\QFS\\QF‑Test or in the root directory of QF‑Test. On Linux and macOS the default system configuration directory is the root directory of QF‑Test. The location of the system config file can be changed with the command line argument and -systemcfg <file> and that of the entire system directory with -systemdir <directory>.","hash":"usec_configfile","h1":"The configuration files"},"26":{"id":26,"content":"Starting QF‑Test QF‑Test can be run in two modes. In normal mode QF‑Test is the editor for test suites and run logs and the control center for running programs, capturing events and executing tests. When run with the -batch argument, QF‑Test goes into \"batch\" mode. Instead of opening an editor window, the test suites given on the command line are loaded and executed automatically without the need for supervision. The result of the test is reflected in QF‑Test's exit code, optional run logs (see \"The run log\") and reports (see \"Reports and test documentation\"). The setup script for Linux offers to create a symbolic link from /usr/local/bin to the qftest start script in the qftest-10.0.2-mobile/bin directory under QF‑Test's root directory. That way you can simply enter qftest at the shell prompt to launch the application. On Windows a menu shortcut is created as well as an optional desktop icon. You can either launch QF‑Test from one of these or by double-clicking a test suite or a run log, since these files are associated with the QF‑Test application. To run QF‑Test from the console type qftest. When run from the command line, QF‑Test offers a wide range of arguments for customization, like selecting the Java VM to use. These are explained in detail in \"Command line arguments and exit codes\". In case different versions of QF‑Test are installed at the same time, a specific version can be started by calling the qftest executable directly from the respective qftest-X.Y.Z/bin directory. In case QF‑Test is not starting up anymore because of some incorrect settings under Options->General->Startup the default startup settings need to be restored. This can be done through running the following two commands from a macOS shell terminal. defaults write de.qfs.qftest /de/qfs/qftest/ \\ -dict-add JVMOptions/ '{\"Xmx\"=\"-Xmx1024m\";\"Xms\"=\"-Xms16m\";}' defaults write de.qfs.qftest /de/qfs/qftest/ \\ -dict-add JVMArguments/ '{\"args\"=\"\";}' Example 1.1: Resetting startup settings to defaults under macOS","hash":"usec_execution","h1":"Starting QF‑Test"},"27":{"id":27,"content":"Mobile Manual","hash":"","h0":"The user interface | QF‑Test Manual"},"28":{"id":28,"content":"Mobile Manual","hash":"home-link","h0":"The user interface | QF‑Test Manual"},"29":{"id":29,"content":"The user interface This chapter explains the structure of QF‑Test's main window. When you are done reading, it might be a good idea to run QF‑Test and try things out. In the »Help« menu there is an entry labeled »Tutorial« that should bring up your web browser with a hands-on, learning-by-doing tutorial. Should this fail because QF‑Test cannot determine your system's standard browser, the tutorial can be found in the directory qftest-10.0.2-mobile/doc/tutorial. The first part of the video 'Main window and the System under Test' shows the structure of the QF‑Test main window.","hash":"usec_gui","h0":"The user interface"},"30":{"id":30,"content":"The test suite Automating a GUI test basically requires two things: control structure and data. The control structure defines what to do and when to do it. The data for a test consists of information about the SUT's GUI components, the events that will be triggered and the expected results. QF‑Test combines all of these into one data structure, a tree hierarchy that we call a test suite. The elements of the tree are called nodes. Nodes can contain child nodes (often just called children) and are themselves contained in a parent node (or just parent). The root node of the tree represents the test suite as a whole. There are more than 60 different kinds of nodes all of which are explained in detail in the reference manual. Some nodes are used as containers for data while others control the execution of a test. All of them have their own unique set of attributes. The attributes of the currently selected node are displayed to the right of the tree in a detail view which can be toggled on and off via the »View«-»Details« menu item.","hash":"usec_gui_suite","h1":"The test suite"},"31":{"id":31,"content":"Figure 2.1: Structure of a test suite The image above shows an example for a simple test suite. The attributes of the node named \"Simple test\" can be edited in the detail view to the right. The basic structure of a test suite and thus the child nodes of the Test suite root node is fixed. An arbitrary number of Test set and Test case with or without Dependency nodes are followed by the Procedures, Extras and Windows and components nodes. The Procedures node holds Packages and Procedures which are explained further in \"Procedures and Packages\". The Extras node is a kind of playground or clipboard where all kinds of nodes can be added for experimentation or temporary storage. The windows and components of the SUT's user interface are represented as Window and Component nodes which are located below the Windows and components node. To get detailed information about a node or one of its attributes, click on it with the right mouse button and select »What's this?« from the context menu. This will bring up a browser displaying the corresponding section of the reference manual.","hash":"figure_2.1","h4":"Figure 2.1: Structure of a test suite"},"32":{"id":32,"content":"Basic editing Editing a test suite falls into two categories: operations such as Cut/Copy/Paste on the tree’s nodes and changing a node’s attributes. There are surprisingly many ways to perform these actions, and opinions about the best approach vary, so QF‑Test provides several central options that influence this behavior.","hash":"usec_gui_editing","h1":"Basic editing"},"33":{"id":33,"content":"Checking the validity of attribute values One decision to make is whether QF‑Test should prevent users from confirming invalid values. While this can be useful, it means that users are kept on a short leash and forced to finish editing one node’s attributes before moving to another. The alternative is to allow illegal values so users can navigate freely between nodes or test suites to look up or copy values from one place and use them in another. The downside is that illegal values can cause problems later when tests simply cannot proceed for that reason. Since QF‑Test version 10, the default is the less \"raised-finger\" approach of modeless editing, giving all power - but also all responsibility - to the user. With the option Ask before implicitly accepting detail modifications set to \"Never,\" attribute edits are implicitly committed whenever focus leaves the current node details, and the use of modal dialogs to enforce consistency is minimized. New nodes are inserted immediately into the tree with the focus on the first detail attribute. Invalid attributes are highlighted with a reddish background color. The option \"Highlight invalid attributes while typing\" determines whether the highlight is continuously updated on every keystroke or only when focus leaves the field. To enforce strict validity of attributes, set the option Ask before implicitly accepting detail modifications to \"Only if values are suspect or invalid\" or even \"Always.\" When inserting a new node, a dialog opens first for editing the details of the newly inserted node before it is added to the tree, and when navigating away from a node with modified but uncommitted attributes, the attributes are \"ripped out\" into a modal dialog to enforce a decision about whether or not to keep the changes before moving on. Either way, the OK and Cancel buttons in the details are no longer necessary and they can now be removed from the UI via the option Show \"OK\" and \"Cancel\" buttons. You can explicitly commit by pressing Ctrl⁠+⁠Return and cancel by pressing Escape. Regardless of option settings, you can explicitly open a dialog for editing the details of the selected node via »Edit«-»Properties« or Alt⁠+⁠Return. Other useful key bindings may come in handy when editing multi-line text attributes: Ctrl⁠+⁠TAB and Shift⁠+⁠Ctrl⁠+⁠TAB move the focus out of the text field to the next or previous field, respectively.","hash":"sec_checking_the_validity_of_attribute_values","h2":"Checking the validity of attribute values"},"34":{"id":34,"content":"Undo An extremely useful feature is the »Edit«-»Undo« function (Ctrl⁠+⁠Z) which will take back any kind of change made to the test suite, including recordings or use of the replace dialog. Changes are undone step by step. If you find you went too far and undid more than you wanted, you can use »Edit«-»Redo« (Ctrl⁠+⁠Y) to undo the undone. The number of steps that can be taken back are limited only by available memory and can be configured with the option Number of undo levels per suite (default 30).","hash":"sec_undo","h2":"Undo"},"35":{"id":35,"content":"Navigating the tree Though the key-bindings for tree navigation are similar to those of most tree components, it won't hurt to mention them here. Besides, QF‑Test comes with a few non-standard bindings that may come in handy. The cursor keys are used for basic navigation. Up and Down are obvious. Right either expands a closed node or moves down one row while Left closes an open node or moves to its parent. QF‑Test's trees support a special variant of multi-selection. Multiple discontinuous regions can be selected, but only among siblings, i.e. children of the same node. If multi-selection across the whole tree were allowed, cutting and pasting nodes would become a real brain-teaser. Keys to try are Shift⁠+⁠Up and Shift⁠+⁠Down to extend the selection, Ctrl⁠+⁠Up and Ctrl⁠+⁠Down to move without affecting the selection and Space to toggle the selection of the current node. Similarly, mouse-clicks with Shift extend the selection while clicks with Ctrl toggle the selection of the node being clicked on. Special bindings include Alt⁠+⁠Right and Alt⁠+⁠Left which recursively expand or collapse a node and all of its children. Alt⁠+⁠Down and Alt⁠+⁠Up can be used to move to the next or previous sibling of a node, skipping the intermediate child nodes. QF‑Test keeps a history of recently visited nodes. Ctrl⁠+⁠Backspace will take you back to the previously selected node. Also worthy of note are Ctrl⁠+⁠Right and Ctrl⁠+⁠Left which will scroll the tree to the right or left if it doesn't fit its frame.","hash":"sec_navigating_the_tree","h2":"Navigating the tree"},"36":{"id":36,"content":"Insertion marker When inserting a new node or pasting in a copy of some other nodes, the insertion marker shows the place where the nodes will end up.","hash":"usec_insert","h2":"Insertion marker"},"37":{"id":37,"content":"Figure 2.2: Insertion marker Nodes are always inserted after the selected node. If the selected node is expanded, the new node is inserted as the first child of the selected node, otherwise it becomes a sibling of same. This behavior will take a little to get used to, especially for long-time users of the Windows explorer. However, there is no other way to insert a node at a definite position. In the example shown in \"Insertion marker\" above, a new node would be inserted as the first child of the sequence called \"Events\", just before the Mouse event.","hash":"fig_insertmark","h4":"Figure 2.2: Insertion marker"},"38":{"id":38,"content":"Moving nodes Nodes can be copied and pasted or moved around within a test suite or to another suite. The standard keyboard shortcuts for cut, copy and paste, Ctrl⁠+⁠X, Ctrl⁠+⁠C and Ctrl⁠+⁠V are available as well as entries in the context menu. Alternatively, nodes can be moved using standard Drag&Drop operations. The default operation will move the selected node(s). If the CTRL key is held down during the drop, the nodes are copied instead. While dragging the mouse over the tree of a test suite, the insertion marker shows where the nodes will be dropped when the mouse button is released and whether the operation is allowed. A green marker signals a legal operation, a red marker an illegal one. Nothing will happen if the nodes are dropped on an illegal target position. During the drag you can expand or collapse nodes by dragging the mouse cursor over the expansion toggle and keeping it there for a moment. That way you can easily navigate to the desired target location without interrupting and restarting the drag. The Drag&Drop operation can be aborted at any time by pressing Esc.","hash":"usec_copy_paste","h2":"Moving nodes"},"39":{"id":39,"content":"Transforming nodes Some nodes can be transformed into different node types, which is a lot more convenient than first creating the desired target node and then copying over the required attributes. Examples of interchangeable nodes are Sequence and Test step or Server script and SUT script. The transformation of a node is possible only if its childnodes and its current position in the tree are also valid for the desired target node. The potential transformation targets can be selected from the entry »Transform node into« in the context menu. If the entry is not available there are no valid target nodes. In that case, moving the node to the Extras node first may help. You can find more details about the conversion mechanism under Details about transforming nodes.","hash":"usec_transform_nodes","h2":"Transforming nodes"},"40":{"id":40,"content":"Tables In various places QF‑Test employs tables to view and edit a set of values, e.g. when defining variables or for checks of multiple elements.","hash":"usec_tables","h2":"Tables"},"41":{"id":41,"content":"Figure 2.3: Example table The buttons above the tables have the following keyboard shortcuts and effects: Shift⁠+⁠Insert Insert a new row. Shift⁠+⁠Return, Alt⁠+⁠Return Edit a row. Opens a dialog with fields for every cell of the selected row. Shift⁠+⁠Delete Delete the selected row. Shift⁠+⁠Ctrl⁠+⁠Up Move the selected row up by one. Shift⁠+⁠Ctrl⁠+⁠Down Move the selected row down by one. Some tables also offer the ability to add and remove columns and edit the column title. For these, the following additional buttons are available: Insert a new column. Delete the selected column. Edit the title of the selected column. To enter a value directly into the selected cell just start typing. This way you overwrite the current value of the cell. To edit the current value, either double click the cell or press F2. To finish editing press Return, to cancel and restore the old value press Escape. If you try to enter an invalid value the cell's border will turn red and you can't accept the value. Multi-selection of table rows is supported via mouse-clicks with Shift/Ctrl and Shift/Ctrl⁠+⁠Up/Down. Cut copy and paste of the selected rows is done with Ctrl⁠+⁠X/C/V. Pasting is restricted to tables with a similar column structure. In the table's context menu additional actions might be available, e.g. show line numbers, locate component, etc. A mouse click in a column header will activate sorting of table rows. A double-click in a column header will resize the column to fit the largest value in the column or opens the editor for the header text (data table).","hash":"expl_table","h4":"Figure 2.3: Example table"},"42":{"id":42,"content":"Packing and Unpacking During test development it is often necessary to move several nodes into a new parent node. A typical situation could be the re-factoring of procedures to re-organize them in packages or to wrap a workflow into a Try/Catch block. For such requirements QF‑Test allows the user to pack nodes into others. This can be achieved by selecting the nodes to pack, right-clicking and selecting »Pack nodes« and the desired parent node. QF‑Test also allows the user to unpack such nodes and remove their parent. This can be used to remove unnecessary packages or test sets from the structure or to dispense with sequences or Try/Catch blocks that are no longer required. For unpacking right-click the node to unpack and select »Unpack nodes«. The packing and unpacking actions are only shown in the menu if the desired target structure is legal.","hash":"usec_basicEditPack","h2":"Packing and Unpacking"},"43":{"id":43,"content":"Sorting Nodes QF‑Test allows sorting nodes. This can be achieved by clicking at a node with the right mouse button and selecting »Sort child nodes«. Alternatively you can also select multiple nodes, perform a right mouse click and then choose »Sort nodes«, which will sort the current selected nodes. To guarantee a better overview the sorting algorithm puts ciphers prior to capital letter and those prior to small letters. Sorting doesn't modify the base structure of QF‑Test nodes. It also follows the rule to keep Package nodes always prior to Dependency nodes and those always prior to Procedure nodes. The base structure of a test suite will not be altered during sorting. You can sort test cases or procedures but the Procedures node will always stay prior to the Windows and components node.","hash":"usec_basicEditSort","h2":"Sorting Nodes"},"44":{"id":44,"content":"Advanced editing This section explains how to use the more advanced editing techniques such as search/replace and multiple views on the same test suite.","hash":"usec_gui_advanced_editing","h1":"Advanced editing"},"45":{"id":45,"content":"Searching QF‑Test provides two kinds of search operations, a general search through all nodes and attributes of a test suite or run log and in incremental search through the contents of a text area, including script consoles or program output.","hash":"usec_searching","h2":"Searching"},"46":{"id":46,"content":"General search Though search and replace operations in QF‑Test have much in common, there are significant differences, especially in the scope of the operation. Searching normally starts at the selected node and traverses the whole tree depth-first to the end. After asking for confirmation the search continues from the root of the tree to the original start of the search so each node is traversed exactly once. This is not unlike search operations in common text processors and should be intuitive to use.","hash":"usec_gensearch","h2":"General search"},"47":{"id":47,"content":"By default QF‑Test shows the search dialog in 'simple' mode, which allows searching for any appearance of a given text.","hash":"parameter_search_text","h2":"General search"},"48":{"id":48,"content":"Figure 2.4: The simple search dialog For a more specific search QF‑Test allows limiting the search to specific attributes, node types or specific states of nodes. Therefore you have to switch to the 'advanced' mode by clicking the 'Switch mode' button in the toolbar of the search dialog.","hash":"figure_2.4","h4":"Figure 2.4: The simple search dialog"},"49":{"id":49,"content":"Figure 2.5: The advanced search dialog By default QF‑Test will search all attributes in all kinds of nodes for the requested string.","hash":"figure_2.5","h4":"Figure 2.5: The advanced search dialog"},"50":{"id":50,"content":"Use the \"In attribute\" option to limit the search to a specific attribute.","hash":"parameter_search_attribute","h4":"Figure 2.5: The advanced search dialog"},"51":{"id":51,"content":"The \"Node type\" option allows to limit the search to nodes of a specific kind.","hash":"parameter_search_nodetype","h4":"Figure 2.5: The advanced search dialog"},"52":{"id":52,"content":"The option \"Scope of search operation\" tells QF‑Test where to search for the given expression, below the selected node(s), in the current test suite or in all currently opened suites.","hash":"parameter_search_range","h4":"Figure 2.5: The advanced search dialog"},"53":{"id":53,"content":"Activating options in \"Only nodes with the following states\" limits the search to nodes that have all of the activated states, e.g. a green mark and a breakpoint.","hash":"parameter_search_nodestates","h4":"Figure 2.5: The advanced search dialog"},"54":{"id":54,"content":"If \"Match whole attribute\" is selected, a search for the word \"tree\", for example, will not match an attribute value of \"treeNode\".","hash":"parameter_search_whole","h4":"Figure 2.5: The advanced search dialog"},"55":{"id":55,"content":"Regular expressions are explained in \"Regular expressions\". To search for values of boolean attributes like Replay as \"hard\" event, use \"true\" or \"false\" (no quotes). If you want to search for an empty value you have to check \"Match whole attribute\". If the search is successful, the resultant node is selected and a message in the status line displays the name of the attribute that contains the value. As already mentioned the searching process usually starts from the currently selected node. In case you want to select other nodes during your search process you can continue the previous search by using the \"Search continue\" button. Once you have closed the search dialog you can still continue the search pressing F3. You can even trigger the same search from a new node pressing Ctrl⁠+⁠G. A very useful feature is the ability to quickly locate all Procedure call nodes that call a given Procedure or all event nodes that refer to a given Component node, etc. Simply select the entry »Locate references...« from the context menu of a node that can be called or referred to. This will show a new frame showing all available references of it. You can reach the node in the test suite via a double click at the row in the list.","hash":"parameter_search_regexp","h4":"Figure 2.5: The advanced search dialog"},"56":{"id":56,"content":"Figure 2.6: Result list for 'Locate references' It is also possible to get a list of all found nodes via pressing the \"Show result list\" button in the search dialog. From this dialog you can then reach any single node in your test suite.","hash":"figure_2.6","h4":"Figure 2.6: Result list for 'Locate references'"},"57":{"id":57,"content":"Incremental text search In addition to searching the tree, components containing text like terminal areas or respective attributes in the details view can be searched independently by use of QF‑Test's incremental search feature. This feature can be invoked either by selecting »Search...« from the component's context menu or by pressing Ctrl⁠+⁠F when the component is selected and owns the keyboard focus. Then the incremental search popup dialog appears at the upper right corner of the respective component. The figure below shows an incremental search for the terminal with highlighted search hits.","hash":"usec_incsearch","h2":"Incremental text search"},"58":{"id":58,"content":"Figure 2.7: Incremental search The search can be limited to a certain part of the contained text by selecting the region to be searched and invoking »Search in selection...« from the component's context menu or pressing Ctrl⁠+⁠Shift⁠+⁠F. Beside this, the way the incremental search works as well as the available options should be self-explanatory.","hash":"figure_2.7","h4":"Figure 2.7: Incremental search"},"59":{"id":59,"content":"Replacing","hash":"usec_replace","h2":"Replacing"},"60":{"id":60,"content":"Once you understand how the scope of the replace operation differs from searching, the replace dialog should be just as intuitive to use as the search dialog. When the replace operation is in progress, you have a choice of replacing one match at a time or all matches at once. To avoid unexpected results when selecting the latter, there needs to be a way to limit the nodes that will possibly be affected. To that end, replace operations can be limited to the currently selected nodes and their direct or indirect child nodes. For a replace operation that covers the whole tree, either select the root node or choose the respective \"Scope of replace operation\" option in the dialog.","hash":"parameter_search_replace","h2":"Replacing"},"61":{"id":61,"content":"Figure 2.8: The replace dialog The options are identical to the ones for searching. When \"Match whole attribute\" is turned off, multiple replacements within one attribute are possible. When replacing \"a\" with \"b\" for example, \"banana\" would change to \"bbnbnb\". Be sure to read \"Regular expressions\" about how to use regular expressions for replacing. If the search is successful, the resultant node is selected and a confirmation dialog is brought up that shows the target attribute and its value before and after the change.","hash":"figure_2.8","h4":"Figure 2.8: The replace dialog"},"62":{"id":62,"content":"Figure 2.9: The replace query dialog It offers the following choices: When Replace is selected, the attribute's value is changed and the search carries on, showing the query again for the next match. Replace all means change this value and all the rest of the matches in one go without asking again. Skip leaves this attribute unchanged. The search continues and the query dialog is shown again in case of another match. Obviously Cancel ends the replace operation. If you know what to expect you can skip the query entirely by selecting Replace all in the replace dialog. After the attributes have been changed, the number of affected nodes is shown in a message dialog. After performing the actual replacement QF‑Test will show a list of all touched nodes. You can also open a list of all nodes, which will be touched before the actual replacement pressing the \"Show result list\" button in the replace dialog. Whether values are replaced one by one or all at once also affects the way the undo function will take these changes back. All changes of a Replace all operation are taken back in one step, while single changes are undone one at a time.","hash":"figure_2.9","h4":"Figure 2.9: The replace query dialog"},"63":{"id":63,"content":"Complex searches and replace operations Sometimes a simple search is not enough. Imagine, for example, that you want to set a Timeout of 3000 milliseconds for all text checks on a certain component. You know the component's QF‑Test ID, but if you search for that QF‑Test ID you will also find events and other kinds of checks referencing it. And if you search for the node text 'Check text' you will find all Check text nodes, not just those for the given component. Instead of providing several combinable levels of search criteria QF‑Test offers complete flexibility through its marks. First perform a search for your first criterion, e.g. the node text and select 'Show result list'. In the resulting dialog select all entries in the table by pressing Ctrl⁠+⁠A, press 'Set mark' to assign the blue mark to all result nodes and close the dialog. You can now perform a second search or a replacement with the scope limited to nodes with a given mark. In our example you would perform a replacement of the empty string with '3000' on all Timeout attributes with the search scope set the all nodes with the blue mark in the whole tree.","hash":"usec_tunesearch","h2":"Complex searches and replace operations"},"64":{"id":64,"content":"Multiple views It is possible to open multiple views that show different parts of the same tree structure simultaneously. This can be useful when managing large test suites or to compare the attributes of different nodes. Additional views are opened via the »View«-»New window...« menu item. The current node will be the root node for the new view. Additional views are similar to the primary views, but with a limited range of menus.","hash":"sec_multiple_views","h2":"Multiple views"},"65":{"id":65,"content":"Hiding toolbar buttons You can reduce the number of buttons shown in the toolbar by right-clicking the button you want to hide and selecting »Hide toolbar button« from the popup menu. In order to restore the original toolbar right-click it somewhere and select »Show all tooolbar buttons«. In case you hid all toolbar buttons, please select »View«-»Show toolbar«.","hash":"sec_hiding_toolbar_buttons","h2":"Hiding toolbar buttons"},"66":{"id":66,"content":"Mobile Manual","hash":"","h0":"Quickstart your application | QF‑Test Manual"},"67":{"id":67,"content":"Mobile Manual","hash":"home-link","h0":"Quickstart your application | QF‑Test Manual"},"68":{"id":68,"content":"Quickstart your application This chapter provides instructions on how to quickly set up your application as the SUT (System Under Test). The video 'The Quickstart Wizard Java' shows how to work with the Quickstart Wizard for Java applications. The video 'The Quickstart Wizard Web' shows the Quickstart Wizard for web applications. Quickstart Wizard for Android applications: Create a QF‑Test setup sequence for Android testing. Quickstart Wizard for iOS applications: Create a QF‑Test Setup sequence for iOS testing. In order to make you application recognized by QF‑Test as SUT it basically needs to be started out of QF‑Test. There are a number of special process nodes available within the »Insert«-»Process nodes« to perform this task but the straight forward way is to use the Quickstart Wizard as described below. For those with an aversion to wizard dialogs, the manual way is explained at \"Various methods to start the SUT\".","hash":"usec_quickstart","h0":"Quickstart your application"},"69":{"id":69,"content":"Setup sequence creation – The Quickstart Wizard With the Quickstart Wizard QF‑Test offers a convenient utility for creating a startup sequence for your application. You can open the Quickstart Wizard via the »Extras«-»Quickstart Wizard...« menu item or the toolbar button. Please follow the steps which should be self explanatory.","hash":"usec_quickstart_wizard","h1":"Setup sequence creation – The Quickstart Wizard"},"70":{"id":70,"content":"Figure 3.1: Quickstart Wizard As result the Wizard delivers a startup sequence under the \"Extras\", as shown in the following figure:","hash":"figure_3.1","h4":"Figure 3.1: Quickstart Wizard"},"71":{"id":71,"content":"Figure 3.2: Startup sequence created by the Quickstart Wizard The created setup sequence varies depending on the specific type of the application. But all of them follow the same standard. At the beginning you will find a Set variable node which specifies the name of the SUT client for QF‑Test. This node is followed by a Wait for client to connect node that checks whether its necessary to start the application. The subsequent If evaluates the result of its predecessor and contains the start steps for your application. The actual launch takes place in the start node which is specific to the type of application. That node is followed by an other Wait for client to connect node which ensures that QF‑Test connects to your application during the startup procedure. (Details about the different start node types and attributes can be found in \"Various methods to start the SUT\".)","hash":"figure_3.2","h4":"Figure 3.2: Startup sequence created by the Quickstart Wizard"},"72":{"id":72,"content":"Executing the setup sequence The setup sequence can be executed directly after creation via selecting the green setup sequence node in the tree and pressing \"Replay\" toolbar button . When executing the setup sequence your application should start up and the \"Start recording\" button in the QF‑Test toolbar should become activated which indicates that QF‑Test is properly connected to the SUT. Now you are able to record and replay your first test sequences as described in \"Capture and replay\". There is also a learning by doing tutorial available from the QF‑Test help menu which guides you through all features of QF‑Test. In case you are facing an error message or the red \"Start recording\" button stays inactive, please proceed with the following paragraph.","hash":"sec_executing_the_setup_sequence","h1":"Executing the setup sequence"},"73":{"id":73,"content":"In case the client does not connect ... If your application (or the browser window in case of web testing) doesn't come up at all: The error dialog QF‑Test typically displays should provide a first indication. Please look for error messages in the terminal window. If there is no terminal window visible in the bottom area of QF‑Test, it can be activated through the menu item »View«-»Terminal«-»Show«. Additional information about program output can be found in \"Program output and the Clients menu\". Be sure to double-check the attribute values in the setup sequence nodes are correct. Possibly a typo has crept in somewhere. Details about the different start node types and attributes can be found in \"Various methods to start the SUT\". If the SUT gets visible but QF‑Test is not able to connect to the client (ClientNotConnectedException): Please double-check the terminal output content (see also above) for possible error messages. In case the case the red record button in the toolbar gets activated after the error message occurred, the timeout value in the Wait for client to connect node needs to be increased. Check the run log in general for possible additional error indications (see \"The run log\"). After possibly having adapted your test suite or settings retry executing your setup sequence. If you are not getting any further you might want to consider trying a sample test suite from the tutorial or you contact our support.","hash":"troubleshooting","h1":"In case the client does not connect ..."},"74":{"id":74,"content":"Program output and the Clients menu The standard output and error streams of all processes started by QF‑Test are captured and stored in the run log under the node that represents the respective starter node. In this QF‑Test does not distinguish between SUT clients and arbitrary processes or shell scripts started with a Start process or Execute shell command node. The main window contains a shared terminal view that shows the output of all processes started by a test that was run from this window. The »View«-»Terminal« sub-menu holds items to configure whether this terminal is visible, whether the tree or the terminal should use the are in the lower left corner, whether long lines are wrapped and whether it is automatically scrolled to the end when new output arrives. Other items let you clear the terminal or save its contents to a file. The maximum amount of text that the terminal holds is configurable in the option Maximum size of shared terminal (kB). In addition to the shared terminal, for each active or recently terminated process there is an individual terminal window that shows its output. These individual terminal windows can be opened from the »Clients« menu. The shared terminal's intention is to provide visual feedback whenever new output arrives, while the individual terminals are better suited for actually studying that output. Active processes can also be stopped with the help of the »Clients« menu, either individually in the respective sub-menu or all at once with »Clients«-»Stop all clients«. The number of terminated clients that are kept in the »Clients« menu is set with the option Number of terminated clients in menu. If your processes generate lots of output and you are low on memory you may want to reduce that number. The »Clients« menu also serves well in case you are not sure which specific QF‑Test product you need to purchase. The GUI technologies used by your applications are shown in '[ ]' next to the active client name. The example below shows two clients using Java swing and web which suggests to buy a QF‑Test/swing+web license.","hash":"usec_clientterminal","h1":"Program output and the Clients menu"},"75":{"id":75,"content":"Figure 3.3: GUI technology information","hash":"figure_3.3","h4":"Figure 3.3: GUI technology information"},"76":{"id":76,"content":"Mobile Manual","hash":"","h0":"Capture and replay | QF‑Test Manual"},"77":{"id":77,"content":"Mobile Manual","hash":"home-link","h0":"Capture and replay | QF‑Test Manual"},"78":{"id":78,"content":"Capture and replay Once the SUT is up and running under QF‑Test, the next step is to record sequences of events and play them back. The video 'Capture and Replay' explains capturing and replaying of sequences. The video 'Creating a test case' shows how to create a test case. Recordings on Android or iOS applications will be done in a special recording window. For Android and iOS, actions on the SUT mentioned in this chapter refer to the recording window. For more information about die recording window for Android please see \"Record actions and checks for Android\", for iOS \"Record actions and checks for iOS\".","hash":"usec_capturereplay","h0":"Capture and replay"},"79":{"id":79,"content":"Recording sequences In order to record a sequence of events in the SUT, the SUT must have been run from QF‑Test (see \"Quickstart your application\") and the connection between QF‑Test and the SUT must be established. A visual indicator of this is the color of the record button which turns red when it is enabled.","hash":"usec_recording","h1":"Recording sequences"},"80":{"id":80,"content":"Figure 4.1: Disabled and enabled Record button To record a sequence, simply start recording be pressing the record button or selecting »Record«-»Start«. Then switch to the SUT, execute a few commands, switch back to QF‑Test and stop the recording with the stop button or »Record«-»Stop«. The recorded events will be added to the test suite, either directly at the position indicated by the insertion marker or as a new Sequence under the Extras node, depending on the setting of the Insert recording at current selection option. Pause the recording with »Record«-»Pause« or the pause button if you need to execute some steps in the SUT that should not be recorded and you don't want to stop and restart the recording. Recording mode can be started and stopped directly in the SUT by use of the Hotkey for recording. Default key is F11. Any Components referred to by the newly recorded events are added automatically to the Windows and components node if they are not there already. There are many options that influence the way QF‑Test records events and how it treats the components of the GUI. All of these are explained in detail in \"Recording options\" of the reference manual. Once you are familiar with QF‑Test you should take the time to skim through it. Here's some general advice for recording: Record short sequences at a time. After recording, take a look at the sequence, try to understand what you got and whether it represents the actions you took. Edit the sequence to remove unnecessary events, especially those at the beginning and end caused by switching windows. QF‑Test has excellent filters that should catch nearly all of these, but some might remain and have to be removed manually. Finally, try out the new sequence to see whether it replays OK. Then you can cut/copy/paste as needed to integrate it into larger parts. For SUT's running on macOS QF‑Test disables use of the screen menu bar and activates normal menu bar behavior like on other platforms. This is due to the fact that QF‑Test cannot fully access the screen menu bar which prevents proper capture/replay of menu actions. In case the typical Mac screen menu bar behavior is necessary for any reason, this can be forced by adding the line qfs.apple.noScreenMenuBar=false to the file qfconnect.properties that is located in QF‑Test's root directory. After restarting the SUT the screen menu bar is supposed to work as normal on Mac.","hash":"figure_4.1","h4":"Figure 4.1: Disabled and enabled Record button"},"81":{"id":81,"content":"Running tests To run some tests, select the node or nodes to execute and press Return or the play button or select »Run«-»Start«. QF‑Test will mark each node with a small arrow as it is executed and also show progress messages in the status bar. This can slow down execution a little and can be turned off with the options Mark nodes during replay and Show replay messages in status line. When the test is finished, the result is shown in the status bar. If things are fine you should see \"No errors\", otherwise the number of warnings, errors and exceptions is shown. Additionally, a message dialog is shown in case of errors or exceptions to make sure you don't miss these. As for recording there are many options that influence the replay of tests. Some of these are only for convenience while others have a major impact on the outcome of the tests. Be sure to read \"Replay options\" some time to familiarize yourself with these. To abort execution before the test is finished, press the stop button or select »Run«-»Stop«. You can also suspend execution temporarily via the pause button or by selecting »Run«-»Pause«. This will also enable the debugger (see \"Problem analysis and debugging\"). To continue, press pause again. While a test is run at full speed it can be tricky to stop or interrupt it, especially when the mouse cursor is actually moved across the screen or the SUT's windows are raised on every event. To regain control, press the Hotkey for pausing test run (\"Don't Panic\" key) (the default is Alt⁠+⁠F12). This will pause all running tests immediately. To continue, press the same combination again. While building a test suite you will often want to execute some sequences to get the SUT to a point where you can continue recording. Sometimes you may want to skip certain nodes at this stage because they don't get you where you want, but you don't want to delete them or move them to some other place. In that case use the »Edit«-»Toggle disabled state« menu item to disable the node(s). When you want to use them again later you can re-enable them. The current error state during replay as well as the final result is shown in the status line at the bottom of the QF‑Test main window. The visibility of this status line can be controlled via »View«-»Show status line«. In case Test set or Test case nodes (\"Test set and Test case nodes\" describes their usage) are executed the status line also contains relevant result counters from the following list.","hash":"usec_executing","h1":"Running tests"},"82":{"id":82,"content":"Counter Icon Description Total number of test cases. This counter value starts with a '>' symbol in case there are skipped test sets. Number of test cases with exceptions. Number of test cases with errors. Number of test cases with expected errors. Expected to fail if... marks a test case expected to fail. Number of successful test cases. Number of skipped test cases. A test case is skipped when its (optional) Condition fails. This counter value starts with a '>' symbol in case there are skipped test sets. Number of skipped test sets. A test set is skipped when its (optional) Condition fails. Number of not implemented test cases. A test case is not implemented when it doesn't contain nodes that were executed during the test run. Number of executed test cases. Percent test cases passed. Table 4.1: Test result counter in the status line The final test result counts also appear in the report which can be created for any test run. Reports are discussed in \"Reports and test documentation\". The counter values above can also be accessed as variables during the test run. A TestRunListener can help to keep track of counter values and trigger dependent actions.","hash":"table_4.1","h1":"Running tests"},"83":{"id":83,"content":"Recording checks Though it can be quite entertaining to record sequences and watch the magic dance of the SUT as they are played back, the task at hand is to find out whether the SUT actually works as expected. This is where checks come into play. The most common check, the Check text node, reads the text displayed by a component, e.g. a text field, and compares it to a given value. If the values differ, an error is signaled. How checks work is explained in detail in the Reference manual. There is a range available from simple text check to advance Check image and even custom check types can be implemented. Here we are going to concentrate on the most convenient way to create checks, which is to record them. While recording, the SUT is in record mode, which means that all events are collected and sent to QF‑Test. With the help of the check button or by selecting »Record«-»Check« you can bring it into check mode, recognizable through the different mouse cursor. In this mode, recording events is suspended. Instead, the mouse cursor is tracked and the component under it is highlighted. When you click on the component, a check for the component is recorded using the value that is currently displayed. To get back to record mode, select the check button or menu item again. There are different kinds of checks that can be performed. Which kinds of checks are applicable depends on the selected component. Some components don't display any text, so a Check text node doesn't make sense for, say, a scroll bar. Clicking on a component with the right mouse button while in check mode brings up a menu of applicable checks for this component. Select one of the items to create the respective check node. Clicking with the left mouse button always records the default check, which is the topmost one in the popup menu. If you hold down the Shift or Ctrl key while clicking with the right mouse button, the check menu will stay open after making a selection. That way, you can easily record multiple kinds of checks for the same component. Checks integrate well with events and you'll soon develop a recording style a'la click, click, type, click, check, click, click, check... Having to switch back and forth between QF‑Test and the SUT every time you want to create a check can be a real pain. That is where the Hotkey for checks option comes into play. It defines a key which toggles the SUT between record mode and check mode. The default value is F12, but if this key has some defined meaning for your application you can change it to whatever you like. To record a sequence of interspersed events and checks, simply start recording, switch to the SUT and record the sequence. Whenever you want to add some checks, just press F12 (or whatever you defined), record the checks, then switch back to record mode by pressing F12 again and continue. This way you can work with the SUT for the whole sequence and need to switch back to QF‑Test only to stop the recording. One word of warning should be repeated: Don't let this convenience tempt you into recording extremely long sequences. When something changes that causes such a sequence to fail you will be hard put to find out what went wrong and how to cope.","hash":"usec_recordchecks","h1":"Recording checks"},"84":{"id":84,"content":"Fetching data from the UI It is often necessary to read a value from the user interface of the SUT to use as input for a test. QF‑Test offers a set of fetch nodes for this task, available at »Insert«-»Miscellaneous«: Fetch text to read the component or element text, Fetch index to read the element index, Fetch geometry to read the component or element geometry. The determined values are stored in a local or global variable which can be declared in the fetch node. Instead of inserting a fetch node by hand, it can be quicker to first record a mouse event node on the desired component and then use the transform operation to convert it into the needed fetch node.","hash":"usec_fetching_data","h1":"Fetching data from the UI"},"85":{"id":85,"content":"Recording components As already described component information is automatically stored when recording events or checks. However, there are situations where capturing of just components proves useful. To activate component recording mode you simply need to press the record components button or select »Record«-»Record components« from the menu. Then switch to the SUT window where you will notice that the component below the mouse cursor is now highlighted. Clicking with the left mouse button on a component will record the single component while pushing the right button instead will pop up a menu with choices to record the nested components as well or all components in the window. Multiple components can be captured in this way. Then switch back to QF‑Test and release the record components button or deactivate »Record«-»Record components«. Now the recorded component information is stored in shape of respective Component nodes under the Windows and components node. Component recording mode can be alternatively controlled by a configurable hotkey. Default binding is F11, the option that configures it is Hotkey for components. Pressing F11 (default setting) in the SUT window starts component recording. Further details can be found in the documentation for the option Hotkey for components. Only one test suite at a time can receive the recorded components. If more than one test suite is open and each is shown in an individual window, i.e. workbench mode is deactivated, either the test suite in which the recording is stopped (toolbar button or menu) or - when using F11, the test suite that can be selected via the menu item »Record«-»Suite is receiver for recording« will receive the components. The component recording feature can also be used to quickly locate a component independent of whether it has been recorded before. When creating event or checks by hand or changing the target component, the QF‑Test component ID attribute needs to be specified. When a component is recorded, its QF‑Test ID is saved in the clipboard and can be pasted directly into the QF‑Test component ID field with Ctrl⁠+⁠V. You can also jump directly to the Component node with Shift⁠+⁠Ctrl⁠+⁠Backspace or by choosing the »Edit«-»Select next node« menu item or clicking the respective toolbar button. The context menu which appears when clicking with the right mouse button on a component also contains an entry »Show in Inspector« which allows component inspection and an entry »Show methods« which opens a dialog showing the methods of the UI element (see \"Inspecting components\"). Components play a central role in the structure of a test suite which is explained further in \"Components\".","hash":"usec_componentrecording","h1":"Recording components"},"86":{"id":86,"content":"Mobile Manual","hash":"","h0":"Components | QF‑Test Manual"},"87":{"id":87,"content":"Mobile Manual","hash":"home-link","h0":"Components | QF‑Test Manual"},"88":{"id":88,"content":"Components Though they often go unnoticed, at least until the first ComponentNotFoundException occurs, the Component nodes are the heart of a test suite, since stable component recognition is the central challenge of a good GUI testing tool. QF‑Test takes care of it most of the time, but some special situations require manual definitions or interventions. Thus it is important to understand components and their handling in QF‑Test and this chapter aims to explain the fundamentals. Videos The video 'Component recognition' first explains the criteria for component recognition, then (starting at min 13:07) the use of generic components using regular expressions, followed by generic components using variables in component recognition attributes. There are two videos available explaining in detail how to deal with a ComponentNotFoundException: 'ComponentNotFoundException - Simple case' 'ComponentNotFoundException - Complex case' The video 'Dealing with the explosion of complexity in web test automation' gives you a good idea of how QF‑Test handles a deeply nested DOM structure. Live recording of the special webinar 'Component recognition'. GUI actions and components Actions by the end-user on the Components of a GUI are transformed into events by QF‑Test. Every event has a target component. For a mouse click this is the component under the mouse cursor, for a key press it is the component that has keyboard focus. When an event is recorded by QF‑Test, additional information about the target component is recorded as well, so that the event can later be replayed for the same component. Recognition Component recognition is one of the most complex part of QF‑Test. The reason is the need to allow for some degree of change. QF‑Test is a tool designed for regression testing, so when a new version of the SUT is tested, tests should continue to run, ideally unchanged. So when the GUI of the SUT changes, QF‑Test needs to adapt. If, for example, the \"OK\" and \"Cancel\" buttons were moved from the bottom of the detail view to its top, QF‑Test would still be able to replay events for these buttons correctly. The extent to which QF‑Test is able to adapt depends on the available recognition criteria. In this area software developers often can, with relatively low effort, make a great contribution to the creation of robust regression tests.","hash":"usec_components","h0":"Components"},"89":{"id":89,"content":"Component recognition is one of the most complex part of QF‑Test. The reason is the need to allow for some degree of change. QF‑Test is a tool designed for regression testing, so when a new version of the SUT is tested, tests should continue to run, ideally unchanged. So when the GUI of the SUT changes, QF‑Test needs to adapt. If, for example, the \"OK\" and \"Cancel\" buttons were moved from the bottom of the detail view to its top, QF‑Test would still be able to replay events for these buttons correctly. The extent to which QF‑Test is able to adapt depends on the available recognition criteria. In this area software developers often can, with relatively low effort, make a great contribution to the creation of robust regression tests. The following criteria are available for component recognition: Class, correlates with the component's function Name, based on the Component identifiers Feature, a piece of text belonging to the component Extra features, further recognition features like a description or tooltip Index Geometry Component hierarchy These criteria figure into recognition with varying importance. Especially important are a component's class and Component identifiers. With the latter, developers can make a great contribution to test stability (see How to achieve robust component recognition). For more information, see Weighting of recognition features for recorded components. Storing recognition information Information about recognition can be stored by QF‑Test either in a Component node or directly in the event nodes as a SmartID. In Component nodes versus SmartID you will learn which option is preferrable for which use case. By default, QF‑Test will record Component nodes. Child elements and nested components There are some components that QF‑Test addresses relative to a parent component. Among these are table cells, list entries, tree nodes, button icons, or a checkbox inside a table cell. QF‑Test has special ways of addressing these components. This topic is explained in detail in Sub-items: Addressing relative to a parent component. Also, QF‑Test offers the ability to define Scope to limit actions (clicks, text entry, checks) to components contained within.","hash":"usec_components_criteria","h1":"Components"},"90":{"id":90,"content":"Mobile Manual","hash":"","h0":"Components of a GUI | QF‑Test Manual"},"91":{"id":91,"content":"Mobile Manual","hash":"home-link","h0":"Components of a GUI | QF‑Test Manual"},"92":{"id":92,"content":"Components of a GUI The graphical user interface (GUI) of an application consists of one or more windows which hold a number of components. These components are nested in a hierarchical structure. Components that hold other components are called containers. As QF‑Test is itself a complex application, its main window will serve well as an example:","hash":"usec_components_gui","h0":"Components of a GUI"},"93":{"id":93,"content":"Figure 5.1: Components of a GUI The window contains a menu bar which holds the menus for QF‑Test. Below that is the toolbar with its toolbar buttons. The main area employs a split pane to separate the tree view from the details. The tree view consists of a label (\"Test suite\") and the tree itself. The detail view contains a complex hierarchy of various components like text fields, buttons, a table, etc. Actually there are many more components that are not obvious. The tree, for example, is nested in a scroll pane which will show scroll bars if the tree grows beyond the visible area. Also, various kinds of panes mainly serve as containers and background for other components, like the region that contains the \"OK\" and \"Cancel\" buttons in the detail view. Unless explicitly stated otherwise, the term \"component\" in this manual refers to elements of a GUI, regardless of what the individual components are called in the respective GUI technology.","hash":"figure_5.1","h4":"Figure 5.1: Components of a GUI"},"94":{"id":94,"content":"Mobile Manual","hash":"","h0":"Component nodes versus SmartID | QF‑Test Manual"},"95":{"id":95,"content":"Mobile Manual","hash":"home-link","h0":"Component nodes versus SmartID | QF‑Test Manual"},"96":{"id":96,"content":"Component nodes versus SmartID Regognition criteria can be linked to events in tests in two different ways. With the classic method, the criteria are stored as attributes of a Component node (see Component node). These are then referenced in the tests via their QF‑Test component ID. Alternatively, GUI elements can be addressed directly by the recognition criteria via SmartID. Components are not necessary in that case. SmartIDs and classic recorded Component nodes can be used alternatingly, and even combined when necessary. The following points may help you decide whether to use SmartIDs or record components. Improved readability of tests Test-driven development Keyword-driven testing Stability of recognition Maintainability Performance","hash":"usec_components_step_vs_smartid","h0":"Component nodes versus SmartID"},"97":{"id":97,"content":"Improved readability of tests SmartIDs offer advantages over recorded Component nodes in the following situation: The referenced GUI components should be directly recognizable in event and check steps. If the Component identifiers of the components are cryptic, but usable descriptions are available, SmartIDs have the advantage.","hash":"component_step_vs_smartid_readability","h1":"Improved readability of tests"},"98":{"id":98,"content":"Figure 5.2: Readability of SmartIDs","hash":"figure_5.2","h4":"Figure 5.2: Readability of SmartIDs"},"99":{"id":99,"content":"Figure 5.3: Readability of identifiers The readability of a test can also be improved in procedures, if description-based SmartIDs can be used instead of cryptic identifiers. SmartIDs also can increase readability for fields with the same recognition criteria but differently labeled container panels. In the following example, the SmartIDs #Shipping address@#Last name and #Billing address@#Last name could be used.","hash":"figure_5.3","h4":"Figure 5.3: Readability of identifiers"},"100":{"id":100,"content":"Figure 5.4: Readability of SmartIDs in panels with description","hash":"figure_5.4","h4":"Figure 5.4: Readability of SmartIDs in panels with description"},"101":{"id":101,"content":"Test-driven development With test driven development, the big advantage offered by SmartIDs is that no Components need to be created. Additionally, in test driven development Component identifiers are often defined in the technical design and can then be used for test creation. For example, if the component identifier is btnOK, the component can be referenced via the SmartID #btnOK.","hash":"component_step_vs_smartid_tdd","h1":"Test-driven development"},"102":{"id":102,"content":"Keyword-driven testing Keyword-driven tests are implemented on a technical level with procedure calls and parameters. This way, the test creator does not record any components and is dependent on visual information from the GUI for identifying components. This could be the label of the component or its function (class). In a SmartID, these possibilities for recognition can also be combined with each other and with an index.","hash":"component_step_vs_smartid_keyword_driven_testing","h1":"Keyword-driven testing"},"103":{"id":103,"content":"Stability of recognition The stability of recognition is equally good with recorded components and SmartIDs if the SmartID uses the name, if possible in combination with the class. At it's core, stability of recognition depends on the probability of change of the used criteria. If, for example, the label of a component is stable across versions of an application, the recognition via a label-based SmartID (Feature or qfs:label* variants) will be stable as well. Recorded Component nodes use a predefined algorithm for recognition. It gives different importance to individual recognition criteria. Class, name, and hierarchy have the highest priority. If no name is present, hierarchy, label, index, and geometry (in descending importance) are combined into a probability. That probability is the basis for deciding if a GUI element is the wanted component. This algorithm has proven very good for most usage scenarios. However, there are cases in which subordinate recognition criteria (like the label) offer greater stability than the higher-weighted criteria. With recorded Component nodes, we could intervene via a resolver, see The resolvers module. However, the strengths of the SmartID get to shine here, because it can specifically target a stable recognition criterium (or even a combination of multiple criteria). This is the case when, for example, the label is more stable than the Component identifiers. SmartIDs also have advantages when there is a big chance of changes to the component hierarchy during version changes (or even just during application start) or if recognition features of parent components change. SmartIDs don't consider the component hierarchy by default.","hash":"component_step_vs_smartid_stability","h1":"Stability of recognition"},"104":{"id":104,"content":"Maintainability Regarding the maintainability, recorded Component nodes have the upper hand, because recognition criteria are stored centrally in the node, and later changes only need to be performed in this one place. With SmartIDs however, recognition criteria are stored decentrally. It is possible to perform changes across tests via the powerful search-and-replace feature. For SmartIDs with the same recognition criteria for different components, manual tweaking may still be necessary.","hash":"component_step_vs_smartid_maintainability","h1":"Maintainability"},"105":{"id":105,"content":"Performance SmartIDs that use Component identifiers can keep up well with a Component node performance-wise, because the recognized Names are indexed. However, if the SmartID uses the label (Feature or qfs:label* variants) or other Extra features, performance will not be as good as with recorded Component nodes, since the GUI elements are not filtered by Class name beforehand and all GUI elements with matching classes must be searched.","hash":"component_step_vs_smartid_performance","h1":"Performance"},"106":{"id":106,"content":"Combining Component nodes and SmartIDs Recorded Component nodes can be combined with SmartIDs. You can find details about this in Sub-items: Addressing relative to a parent component and Component QF‑Test ID as SmartID. Recorded components can be used to overlay the SmartID syntax by setting their QF‑Test ID to a SmartID including prefix \"#\". This allows simple, data-driven or pre-generated tests to be created with SmartID and only at neuralgic points to define individual components more specifically without having to adapt the tests or procedures for this.","hash":"sec_combining_component_nodes_and_smartids","h1":"Combining Component nodes and SmartIDs"},"107":{"id":107,"content":"Mobile Manual","hash":"","h0":"How to achieve robust component recognition | QF‑Test Manual"},"108":{"id":108,"content":"Mobile Manual","hash":"home-link","h0":"How to achieve robust component recognition | QF‑Test Manual"},"109":{"id":109,"content":"How to achieve robust component recognition The most important feature of a GUI test tool is the recognition of the graphical components. QF‑Test offers a lot of configuration options for this. This section presents an overview over the most common strategies and settings to make component recognition as stable as possible. You should define a component recognition strategy for your project before starting to implement tests in QF‑Test. Otherwise, test maintenance can create larger expenses. The recognition of components in the SUT during test playback is very complex. The challenge lies in the changes the interface of the SUT can go through all the time even during normal use. Windows are opened and closed or varied in size, changing the position and size of components within. Menus and combo boxes are opened and closed, components are added or removed, made visible or inisible, activated or disabled. In addition, the application under test itself will develop over time, which will reflect in changes to its interface. All these changes must be handled flexibly by QF‑Test to be able to match components as reliably as possible. In many cases, QF‑Test can manage this with the default settings. QF‑Test uses an intelligent, probability-based algorithm to achieve a stable and fault tolerant component recognition. It assesses the attributes described in \"The following criteria are available for component recognition:\" and weights them. However, if no good recognition attributes are available, even the best algorithm will struggle. For this case, there are possiblilites for configuration and optimization which are described in Opportunities for optimization. The first question is whether the default settings are already sufficient, so:","hash":"sec_bpComponentRecognition","h0":"How to achieve robust component recognition"},"110":{"id":110,"content":"How to judge robust component recognition This section is intended to enable you to assess whether the current component recognition will, in all likelihood, be robust. The following are important elements of robust component recognition: Class of the component Name label (Feature or qfs:label* variants) moderate hierarchy depth of the component tree In most cases, the class and the name are the most robust criteria for recognition. (In rare cases, however, they change from one version of the application to the next. We consider this messy case in Opportunities for optimization, item 2.) Usually the label of the component also rarely changes and is thus also well suited. Detailed information on all the detection features can be found in Recognition criteria. With the class, QF‑Test tries to derive which functionality a component has from the class used by the developer. Based on this generic class, QF‑Test optimizes the inclusion and provides function-specific checks (for example, checking an entire row for a table). First, let's show you how to quickly see if generic classes have been detected and if names or labels are present based on the recorded Component nodes.","hash":"components_robust_recognition_judge","h1":"How to judge robust component recognition"},"111":{"id":111,"content":"Figure 5.5: Component tree 1 The class is the black text of the Component nodes. If the class starts with an uppercase letter followed by a lowercase letter, it is generally one of the Generic classes, for example Button. For browser elements, if the class consists only of uppercase letters, QF‑Test could not determine the functionality. In the example HTML and BODY. Whether names or labels are present can be seen from the brown texts. This is the QF‑Test component ID, which allows the following conclusions to be drawn: If the class does not show up in the QF‑Test ID, it means that either a Name is present (in the example, CalculatorPanel and CalculatedPrice) or, if no generic class was recognized, a label (Feature or qfs:label* variants) is present. In the example, CarConfigWeb. If the QF‑Test ID starts with the class, no Name could be determined and the following part is the label of the component (Feature or qfs:label* variants). In the example labelTotal and buttonOK. If neither name nor label are found, the QF‑Test ID repeats the class in lowercase letters. In the example html. If multiple components would be assigned the same QF‑Test ID with the described algorithm, an ongoing number will be appended. In the example buttonOK2 A certain hierarchy for components is helpful for recognition. Only deep nestings are problematic. For component recognition, only few hierarchy levels are actually relevant. The others can be ignored. The video 'Dealing with the explosion of complexity in web test automation' visualizes the problem of deep nestings - and also the solutions. The example above only has a shallow hierarchy depth. This is optimal. The component tree in the example above was created with the following settings in the section »Record«-»Components«: Prepend QF‑Test ID of window parent to component QF‑Test ID disabled, which corresponds to the default setting. Prepend parent QF‑Test ID to component QF‑Test ID set to Never, which also corresponds to the default setting. Access these settings via the menu item »Edit«-»Settings« As an alternative to evaluating the QF‑Test ID in the component tree you can get a list of all components with their names via the QF‑Test search. To do this, in the search dialog, set In Attribute to Name and Node type to Component and click on Show Result List. If you record something, the components you interact with will automatically be recorded. To record all components at once for analysis, choose »Record«-»Record components«. Then right-click in the GUI and select Whole window. (After the analysis it makes sense to delete the components to avoid unnecessary ballast.) Here are two more example component trees with evaluation of how robust the component recognition is.","hash":"figure_5.5","h4":"Figure 5.5: Component tree 1"},"112":{"id":112,"content":"Example 1","hash":"sec_example_1","h1":"Example 1"},"113":{"id":113,"content":"Figure 5.6: Stable component recognition - Example 1 Positive: Generic classes are recognized: MenuBar, TabPanel, Panel, Label, and TextField. Positive: Names were determined for the text fields marked green, identifiable by the QF‑Test ID (brown text) not starting with the class, for example BasePrice. Positive: For the text fields and buttons marked yellow, no names were determined, identifiable by the QF‑Test ID (brown text) starting with the class (textfield, button). But the second part of the QF‑Test ID shows that at least a label was found. Not important: the labels don't have names. However, they are rarely relevant for testing. Not important: the containers 'HTML' and 'BODY' don't have a generic class. They could be mapped to 'Panel'. In this case, this would neither improve recognition nor unlock additional functionality in QF‑Test (such as additional checks for check recording). Positive: No superfluous containers except for BODY.","hash":"figure_5.6","h4":"Figure 5.6: Stable component recognition - Example 1"},"114":{"id":114,"content":"Example 2","hash":"sec_example_2","h1":"Example 2"},"115":{"id":115,"content":"Figure 5.7: Stable component recognition - Example 2 Positive: Names or labels could be determined for test-relevant components, identifiable by the QF‑Test ID (brown text) not starting with the class, for example BasePrice and DiscountValue_input. Negative: Generic classes were only recognized for few components. A component mapping with a CustomWebResolver is missing here, see Improving component recognition with a CustomWebResolver. Negative: Superfluous hierarchy levels. The DIV, TR TD, CENTER, and TABLE components should be mapped to Panel (see The Install CustomWebResolver node) or ignored (see Install CustomWebResolver node – Syntax, parameter ignoreTags).","hash":"figure_5.7","h4":"Figure 5.7: Stable component recognition - Example 2"},"116":{"id":116,"content":"Opportunities for optimization If generic classes and names are available for the relevant components, you can assume that component detection is robust in the vast majority of cases and skip the rest of this section. If there are problems with recognition, there are two fundamentally different cases to consider: Is the component displayed (in time)? This case is unrelated to component recognition itself. It occurs if QF‑Test is too fast for the application, so to speak. In this case, you should explicitly wait for the appearance of the component in your test case. Find more information at Timing synchronisation. Is the displayed component recognized? There are several options here: Web: Assignment of generic classes to GUI element classes For web applications, please first perform component assignment as described in The Install CustomWebResolver node. If this does not lead to sufficient stability, then continue reading in this section. Unstable Component Identifiers Component identifiers have been assigned, but they are not stable across application versions. In this case, it is better to remove the identifiers using resolvers and work with the remaining detection criteria if stable identifiers cannot be set by the developers. In the case of web tests, a corresponding setting in CWR parameter 'customIdAttributes' (see Install CustomWebResolver node – Syntax) can help. No component identifiers No Component identifiers has been assigned and the other criteria are not sufficiently stable. Here it is also often worthwhile to contact development and explain to them the relevance of component identifiers for regression tests - or to convince the person who is responsible for development and testing in terms of budget that a small amount of additional work in development for entering the identifiers can mean a significant reduction in effort in the test department. If this is not possible, there may be other stable recognition criteria which QF‑Test does not use by default. These can be announced via a name resolver (see \"The NameResolver Interface\"). Component identifiers contain stable parts Only parts of the Component identifiers are stable. If a computer-readable schema is available, this may be a case for a name resolver (see \"The NameResolver Interface\"). For a web application, this can also be defined via the CWR configuration category 'autoIdPatterns' (see Install CustomWebResolver node – Syntax). The components have labels wich QF‑Test does not recognize out of the box There is no name and the default QF‑Test algorithm does not detect a feature or extra feature 'qfs:label', even though there are possible candidates available. In this case you can announce the labels through a FeatureResolver (see \"The FeatureResolver Interface\") or ExtraFeatureResolver (see \"The ExtraFeatureResolver Interface\"). Web components sometimes have an attribute which can be used as a label. This can be announced through the CustomWebResolver category 'attributesToQftFeature' (see Install CustomWebResolver node – Syntax). Parts of the feature or extra feature 'qfs:label' are stable In this case you can either use regular expressions directly in the Component node or in the SmartIDs. But the solution could also be a FeatureResolver (see \"The FeatureResolver Interface\") or ExtraFeatureResolver (see \"The ExtraFeatureResolver Interface\"). Parent components are unstable The component itself is stable, but one of its parent containers is not stable. Here, regular expressions or resolvers for the affected containers can help. If all test-relevant components have names, the option Name override mode (record) in section »Record«-»Components«-»Name override mode« can also be set to \"Override everything\". The use of SmartIDs is also an option here. Additional or missing parent components The component itself is stable, but its containing hierarchy is not stable because containers can appear or disappear. If all test-relevant components have names, the option Name override mode (record) in section »Record«-»Components«-»Name override mode« can be set to \"Override everything\". Alternatively, the component can be moved up in the component tree hierarchy, so it is no longer influenced by the unstable containers. The use of SmartIDs is an option here as well. Component structure or index The attribute Class index plays a subordinate role, but comes to effect if the component recognition must do without name and feature or the extra feature 'qfs:label'. If the Class index is unstable as well, it can be deleted so the geometry comes to effect. In this case the window size of the application to be tested should always be set to the same value after lauch (see Component event).","hash":"usec_components_optimization","h1":"Opportunities for optimization"},"117":{"id":117,"content":"Mobile Manual","hash":"","h0":"Recognition criteria | QF‑Test Manual"},"118":{"id":118,"content":"Mobile Manual","hash":"home-link","h0":"Recognition criteria | QF‑Test Manual"},"119":{"id":119,"content":"Recognition criteria","hash":"usec_component_recognition_criteria","h1":"Recognition criteria"},"120":{"id":120,"content":"Mobile Manual","hash":"","h0":"Class | QF‑Test Manual"},"121":{"id":121,"content":"Mobile Manual","hash":"home-link","h0":"Class | QF‑Test Manual"},"122":{"id":122,"content":"Class The class of a component is a very important attribute as it describes the type of the recorded component. Once QF‑Test records a button, it will only look for a button on replay, not for a table or a tree. Thus the component class conveniently serves to partition the components of a GUI. This improves performance and reliability of component recognition, but also helps you associate the component information recorded by QF‑Test with the actual component in the GUI. Besides its role in component identification, the class of a component is also important for registering various kinds of resolvers that can have great influence on the way QF‑Test handles components. Resolvers are explained in detail in \"The NameResolver Interface\". The Name is used here for generating the QF‑Test component ID. Examples for this can be found in How to judge robust component recognition. In a SmartID components can also be directly addressed via their Names, without recording a Component node. The influence of the class on the QF‑Test ID of the component is described below, usage as SmartID in \"SmartID\".","hash":"usec_componentclass","h0":"Class"},"123":{"id":123,"content":"Generic classes Each UI toolkit usially defines its own system-specific classes for components like Buttons or Tables. In case of Buttons, that definition could be javax.swing.JButton for Java Swing, or org.eclipse.swt.widgets.Button for Java SWT, or javafx.scene.control.ButtonBase For JavaFX, or INPUT:SUBMIT for web applications. In order to allow your tests to run independently of the utilised concrete technology QF‑Test unifies those classes via so-called generic classes, for example all buttons are simply called Button now. You can find a detailed description of generic classes in \"Generic classes\". In addition to the generic class, systen specific classes are recorded as Extra features, but with the status \"ignore\". In case of recognition problems because of too many similiar components, these can be enabled to sharpen recognition, even if detracting from flexibility. If QF‑Test can assign a component a generic class, this will gain the following advantages for test creation and execution: Independence from concrete technical classes With generic classes, a certain independence from the concrete technical classes is established. This concept allows you to create tests independent of the concrete technology. Improved component recognition If the functionality of the component is known, the most suitable recognition criteria can be stored. Example button: The button label is the first choice for the Feature and the extra feature 'qfs:label'. Example text field: It does not make sense to use the text value for recognition. Instead, QF‑Test searches for a label nearby and stores this in the extra feature 'qfs:label'. The generic class itself also is a differentiation criterium. This is especially noticeable in web applications, where most components will be recorded with the class DIV, matching their HTML tag by default. Optimal mouse position during replay The generic class also influences the optimal mouse position during event replay. Example button: The mouse click is ideally placed in the middle of the button. Example text field: The mouse click is ideally placed in the same place where the tester clicked during recording, so text can be inserted in exactly the same place if needed. Class-specific checks In addition, QF‑Test offers additional class-specific checks during recording. For example, text fields can be checked for their editable state. Check items however only make sense for lists, tables or trees.","hash":"usec_componentclassgeneric","h0":"Generic classes"},"124":{"id":124,"content":"Mobile Manual","hash":"","h0":"Name | QF‑Test Manual"},"125":{"id":125,"content":"Mobile Manual","hash":"home-link","h0":"Name | QF‑Test Manual"},"126":{"id":126,"content":"Name In case the developers have assigned Component identifiers to a component, QF‑Test will recognize this and use it, if suitable, for the attribute Name. If a value for Name was found, it will also be used for generating the QF‑Test ID of the component. Examples for this can be found in How to achieve robust component recognition. The value of the Name attribute is also the first choice during recording of SmartIDs. The reason for the tremendous impact of names is the fact that they make component recognition reliable over time. Obviously, locating a component that has a unique name assigned is trivial. Without the help of a name, QF‑Test uses lots of different kinds of information to locate a component. The algorithm is fault-tolerant and configurable and has been fine-tuned with excellent results. However, every other kind of information besides the name is subject to change as the SUT evolves. At some time, when the changes are significant or small changes have accumulated, component recognition will fail and manual intervention will be required to update the test suite. Another aspect of names is that they make testing of multi-lingual applications independent of the current language because the name is internal to the application and does not need to be translated. Test automation can be improved tremendously if the developers of the SUT have either planned ahead or are willing to help by defining names for at least some of the components of the SUT. Such names have two effects: They make it easier for QF‑Test to locate components even after significant changes were made to the SUT and they are highly visible in the test suite because they serve as the basis for the QF‑Test IDs QF‑Test assigns to components. The latter should not be underestimated, especially for components without inherent features like text fields. Nodes that insert text into components called \"textName\", \"textAddress\" or \"textAccount\" are far more readable and maintainable than similar nodes for \"text\", \"text2\" or \"text3\". Indeed, coordinated naming of components is one of the most important factors for the efficiency of test automation and the return of investment on QF‑Test. If development or management is reluctant to spend the little effort required to set names, please try to have them read this chapter of the manual. If developers used another consistent scheme for assigning identifiers which QF‑Test does not recognize out of the box, please take a look at Influencing the 'Name' attribute by implementing a NameResolver. When determining distinct Names, the options Name override mode (replay) and Name override mode (record) can be set to \"Override everything\", which makes the component recognition independent from the component hierarchy. Because of name caching, this will gain maximum performance. To simplify assigning of identifiers, QF‑Test offers a feature to suggest identifiers for components whose testing would benefit from it. Read more about this in Hotkey for components. Changes to identifiers in the application under test should be avoided as much as possible, as this undermines component recognition and can mean a lot of rework in the tests. Please note that if changes do occur, they should be made in the Name attribute of the component and not in the QF‑Test ID attribute, which is only used to reference the component in the tests! Another possible difficulty can be that the name change occurs directly in the test in the reference to the component, for example when a mouse click occurs in the QF‑Test component ID attribute. The test then fails with an UnresolvedComponentIdException .","hash":"usec_components_name","h0":"Name"},"127":{"id":127,"content":"Component identifiers Component identifiers are called differently in the different UI technologies. In the manual, the term 'name' is also used for them. In addition, the criteria for whether and how the identifiers are transferred to the 'name' attribute are slightly different depending on the technology. The following is valid for the default settings, especially of Name override mode (replay) and Name override mode (record) (default value: \"Hierarchical resolution\"). The use of resolvers could change the described behavior as well. Java Swing/AWT The component identifier is called 'Name' here. If set, it will be transferred to the Name attribute. If there are duplicate component identifiers inside a container, QF‑Test will create the Extra feature qfs:matchindex with the appropriate index for the duplicates. All AWT and Swing components are derived from the AWT class Component. That is why their setName method is the standard for Swing SUTs. Thanks to this standard, many developers make use of it even without considering test automation, which is a great help. JavaFX The component identifier is called 'ID', here. If set, it will be transferred to the Name attribute. If there are duplicate component identifiers inside a container, QF‑Test will create the Extra feature qfs:matchindex with the appropriate index for the duplicates. For JavaFX, setId is used to assign names to components (here called \"nodes\"). Alternatively, IDs can be set in FXML via the attribute fx:id. Although IDs of nodes are supposed to be unique, this is not enforced. Java SWT The component identifier is also called 'Name', here. If set, it will be transferred to the Name attribute. If there are duplicate component identifiers inside a container, QF‑Test will create the Extra feature qfs:matchindex with the appropriate index for the duplicates. Unfortunately SWT has no inherent concept for naming components. An accepted standard convention is to use the method setData(String key, Object value) with the String \"name\" as the key and the designated name as the value. If present, QF‑Test will retrieve that data and use it as the name for the component. Obviously, with no default naming standard, very few SWT applications today have names in place, including Eclipse itself. Fortunately QF‑Test can derive names for the major components of Eclipse/RCP based applications from the underlying models with good results - provided that IDs were specified for those models. See the Automatic component names for Eclipse/RCP applications option for more details. Web The natural candidate for naming the DOM nodes of a web application is the 'id' attribute of a DOM node - not to be confused with the QF‑Test ID attribute of QF‑Test's Component nodes. Unfortunately the HTML standard does not enforce IDs to be unique. Besides, 'id' attributes are a double-edged sword because they can play a major role in the internal JavaScript operations of a web application. Thus there is a good chance that 'id' attributes are defined, but they cannot be defined as freely as the names in a Swing, JavaFX or SWT application. Worse, many DHTML and Ajax frameworks need to generate 'id' attributes automatically, which can make them unsuited for naming. The option Use ID attribute as name determines whether QF‑Test uses 'id' attributes as names. Fortunately, component identifiers can be realized via different attributes of the GUI element. Mostly it is the attribute 'id', sometimes also 'name' - but other attributes can be used as well. The option Use ID attribute as name determines whether QF‑Test uses 'id' attributes for names or not. Please keep in mind that the option Eliminate all numerals from 'ID' attributes can also cause originally unique identifiers to not be unique anymore after the deletion of the numbers. When checking if the resolved Name is unique, the component's parent containers will be considered when judging uniqueness if the options Name override mode (replay) and Name override mode (record) are set to the default value \"Hierarchical resolution\". The automatically generated 'id' attributes sometimes contain a static part which can be used as identifier. This can be configured through the CWR category autoIdPatterns, see Install CustomWebResolver node – Syntax. Also, this procedure can be used with the customIdAttributes parameter to use any other HTML attribute as a component identifier. In case of web applications that use a UI toolkit supported by QF‑Test, you can look at \"Setting unique IDs\" to learn more about setting unique identifiers for each toolkit. Win The component identifier is called 'AutomationId' here. If set, it will be transferred to the Name attribute. If there are duplicate component identifiers inside a container, QF‑Test will create an Extra feature named qfs:matchindex and an appropriate index for the duplicates. Android The component identifier is called 'ID', here. It will only be transferred to the Name attribute if it is not a trivial class name (see Android - list of trivial component identifiers). If there are duplicate component identifiers inside a container, QF‑Test will create the Extra feature qfs:matchindex with the appropriate value for the duplicates.","hash":"usec_components_identifier","h0":"Component identifiers"},"128":{"id":128,"content":"About setting identifiers There is one critical requirement for identifiers: They must not change over time, not from one version of the SUT to another, not from one invocation of the SUT to the next and not while the SUT executes, for example when a component is destroyed and later created anew. Once an identifier is set it must be persistent. Unfortunately there is no scheme for setting identifiers automatically that fulfills this requirement. Such schemes typically create identifiers based on the class of a component and an incrementing counter and invariably fail because the result depends on the order of creation of the components. Because identifiers play such a central role in component identification, non-persistent identifiers, specifically automatically generated ones, can cause a lot of trouble. If development cannot be convinced to replace them with a consistent scheme or at least drop them, such identifiers can be suppressed with the help of a NameResolver as described in \"The NameResolver Interface\". QF‑Test does not require ubiquitous use of identifiers. In fact, over-generous use can even be counter-productive because QF‑Test also has a concept for components being \"interesting\" or not. Components that are not considered interesting are abstracted away so they can cause no problem if they change. Typical examples for such components are panels used solely for layout. If a component has a non-trivial identifier QF‑Test will always consider it interesting, so naming trivial components can cause failures if they are removed from the component hierarchy in a later version. Global uniqueness of identifiers is also not required. Each class of components has its own namespace, so there is no conflict if a button and a text field have the same identifier. Besides, only the identifiers of components contained within the same window should be unique because this gives the highest tolerance to change. If your component identifiers are unique on a per-window basis, set the options Name override mode (replay) and Name override mode (record) to \"Override everything\". If identifiers are not unique per window but identically named components are at least located inside differently named ancestors, \"Hierarchical resolution\" is the next best choice for those options. Two questions remain: Which components should have identifiers assigned and which identifiers to use? As a rule of thumb, all components that a user directly interacts with should have an identifier, for example buttons, menus, text fields, etc. Components that are not created directly, but are automatically generated as children of complex components don't need an identifier, for example the scroll bars of a JScrollPane, or the list of a JComboBox. The component itself should have an identifier, however. If components were not named in the first place and development is only willing to spend as little effort as possible to assign identifiers to help with test automation, a good strategy is to assign identifiers to windows, complex components like trees and tables, and to panels that comprise a number of components representing a kind of form. As long as the structure and geometry of the components within such forms is relatively consistent, this will result in a good compromise for component recognition and useful QF‑Test ID attributes. Individual components causing trouble due to changing attributes can either be named by development when identified or taken care of with a NameResolver.","hash":"usec_howtosetname","h0":"About setting identifiers"},"129":{"id":129,"content":"Influencing the 'Name' attribute by implementing a NameResolver In GUI testing projects you can face a lot of interesting naming concepts. Sometimes the components in an application have no names, but the testers know an algorithm how to name them reliably. Sometimes existing names change from time to time or are completely dynamic, for example you can get a name 'button1' after the first recording and after the second recording you get 'button2'. Another situation could be that the current version of the application is part of the name of a dialog window. Sometimes the tester knows an algorithm for setting unique Namen. In such cases you should take a closer look at The NameResolver Interface in the chapter The resolvers module. A NameResolver can be used to change or remove names set by developers for the QF‑Test perspective. They are only removed for QF‑Test not from the real source code. You can think about utilizing NameResolvers in following cases: The SUT has dynamically changing names. You know a method to set the names uniquely. You want to map names to other names (for example due to new versions or for testing other languages.) You want to tune the names of components, for example to remove some parts and get nicer QF‑Test component IDs in QF‑Test. If you can achieve per-window uniqueness of names with the help of a NameResolver you can also think about setting the options Name override mode (replay) and Name override mode (record) to \"Override everything\". Whenever possible it is preferable that developers set the names directly in their source code as they best know the context of that component. Implementing a NameResolver can become an excruciating task if the developers change the content of the GUI a lot. NameResolvers are described in detail in \"The NameResolver Interface\".","hash":"sec_bpCRNameRes","h0":"Influencing the 'Name' attribute by implementing a NameResolver"},"130":{"id":130,"content":"Mobile Manual","hash":"","h0":"Feature | QF‑Test Manual"},"131":{"id":131,"content":"Mobile Manual","hash":"home-link","h0":"Feature | QF‑Test Manual"},"132":{"id":132,"content":"Feature The Feature attribute stores, roughly said, a text that is useful for recognition and is directly connected to the component itself. This can be either the text of the component (for example the label on a button), a programmatically assigned identifier or label of a component (for example CheckBox, RadioButton, TextField), a title (Window, 'Dialog', 'TitledPanel'), or for a Web page the URL. Frequently, the value of the Feature is identical to the Extra feature qfs:label. This is because the label of the component is stored in qfs:label and this is often the text that is directly connected to the component. The redundancy still makes sense, since a status can be set for the extra feature: 'Ignore', 'Should match', or 'Must match'. The Feature implicitly always has the status 'Should match'. For backwards compatibility reasons it cannot be replaced by qfs:label. If no Name can be determined, the Feature is used for generating the QF‑Test component ID. Examples for this can be found in How to judge robust component recognition. Components can also be addressed directly in a SmartID via the Feature without recording a Component node.","hash":"usec_components_feature","h0":"Feature"},"133":{"id":133,"content":"Using regular expressions for working with dynamic window titles The Video 'Component recognition' shows the use of regular expressions with window titles starting from minute 13:07. In a lot of applications the developers do not use unique names and QF‑Test keeps recording the same components again and again in different places. Playback with previously recorded components may still work, unless the window geometry changes significantly. In this case it is very likely that the title of the main window changes frequently, for example to display a version string, a user name, a file name or some other variable information. If you want to keep your tests working and prevent recording multiple variants of this window and all its components, you have to select the respective Window node and edit its Feature attribute to replace the dynamic parts of the title with a regular expression. Be sure to check 'Use regexp'. Now your tests should work again. Here you can see the use of a regular expression for a component of the CarConfigurator. Its Feature attribute has to start with 'Edit' followed by an optional dynamic part:","hash":"sec_bpCRRegex","h0":"Using regular expressions for working with dynamic window titles"},"134":{"id":134,"content":"Figure 5.8: Using a regular expression in the Feature attribute QF‑Test uses regular expressions in many places. You can find detailed information in \"Regular expressions\" to learn more about how to use them.","hash":"fig_advBpCrRegexps","h4":"Figure 5.8: Using a regular expression in the Feature attribute"},"135":{"id":135,"content":"Feature for web components For web components, the Feature is determined according to the following logic: HTML elements of class Frame or Document use the URL as Feature attribute. If none of the following special cases apply, the id attribute of the HTML element is used, if it exists and is sufficiently unique. Otherwise, the inner text of the HTML element, truncated if necessary, is used as Feature attribute. Special cases:","hash":"usec_components_feature_web","h0":"Feature for web components"},"136":{"id":136,"content":"HTML elements of class Frame or Document use the URL as Feature attribute. If none of the following special cases apply, the id attribute of the HTML element is used, if it exists and is sufficiently unique. Otherwise, the inner text of the HTML element, truncated if necessary, is used as Feature attribute. Special cases: HTML tag name Value of the Feature attribute TEXTText of the HTML element, truncated if necessary AText of the HTML element (truncated if necessary), otherwise the window title or the URL FIELDSETText of a contained HTML element with tag name \"LEGEND\" FORMValue of the \"name\" attribute IMGValue of the \"alt\" attribute, otherwise \"src\", otherwise part of the URL INPUTValue of the \"name\" attribute. For radio buttons with identical names, the value of the attribute \"name\" with the value of the \"value\" attribute appended BUTTONValue of the \"name\" attribute, otherwise text of the HTML element, truncated if necessary LABELText of the HTML element, truncated if necessary SELECTValue of the \"name\" attribute OPTIONIf the option OPT_WEB_USE_OPTION_LABEL is set, value of the \"label\" attribute, otherwise the text of the HTML element, truncated if necessary OPTGROUPValue of the \"label\" attribute IFRAMEValue of the \"id\" attribute, otherwise \"name\", otherwise \"src\" Table 5.1: Feature attribute special cases for web components In rare special cases, the Feature attribute may also receive a value which is not described by the logic above.","hash":"table_5.1","h0":"Feature for web components"},"137":{"id":137,"content":"Mobile Manual","hash":"","h0":"Extra features | QF‑Test Manual"},"138":{"id":138,"content":"Mobile Manual","hash":"home-link","h0":"Extra features | QF‑Test Manual"},"139":{"id":139,"content":"Extra features The table Extra features stores various information useful for the recognition of the component. In the chapter about Extra features you will find a list of the default entries. But you can also add your own via an ExtraFeatureResolver (see \"The ExtraFeatureResolver Interface\"). Some of the additional features are recorded preventatively and are not usually used for component recognition. This mostly concerns information about the component class, which QF‑Test uses to derive the Generic classes. By default, they have the status \"Ignore\". This can be changed if the original value is of interest in special cases. Among the Extra features, the qfs:label* variants are interesting for recognition.","hash":"usec_components_extrafeatures","h0":"Extra features"},"140":{"id":140,"content":"qfs:label* variants For component recognition labels are very important. There are a number of different types such as the text of the component itself, for example with a button. Or a label component programmatically assigned to another component using labelFor for example. Then there are label components close the component, a tooltip or even an icon description. Up to QF‑Test version 6 the best label is saved in the extra feature qfs:label. From QF‑Test version 7.0 all labels identified for a certain component will be stored in the extra features, starting with qfs:label and a string showing the type, for example qfs:labelText for the text of a button or qfs:labelLeft for the label left of a text field. The advantage of the specific qfs:label* types is replay performance on the one hand, because QF‑Test can search directly for the specific label, and flexibility on the other hand. When you want to use the new algorithm for the extra feature qfs:label on existing component nodes please change the name to qfs:labelBest, telling QF‑Test to look for the best of the available labels. You will find more information about the transition in the chapter The ExtraFeatureResolver Interface. The following table shows the available positional labels:","hash":"usec_components_qfslabel","h0":"qfs:label* variants"},"141":{"id":141,"content":"qfs:labelTopleftqfs:labelTop- qfs:labelLeftthe componentqfs:labelRight -qfs:labelBottom- Table 5.2: qfs:label* positional variants The following list shows the available qfs:label* types and the qualifier to be used when you want the address the component directly via SmartID. Descriptions are below the list. The entries in the column \"Category\" correspond to the terms used in the section \"qfs:label\" in Generic classes.","hash":"table_5.2","h0":"qfs:label* variants"},"142":{"id":142,"content":"qfs:label variant SmartID qualifier Category qfs:labelText #text= Own text qfs:labelFor #for= Associated label qfs:labelLeft #left= Label close to it qfs:labelTop #top= Label close to it qfs:labelTopleft #topleft= Label close to it qfs:labelRight #right= Label close to it qfs:labelBottom #bottom= Label close to it qfs:labelInherited #inherited= Label close to it qfs:labelTooltip #tooltip= Tooltip qfs:labelImage #image= Description of icon qfs:labelTitle #title= Title qfs:labelPlaceholder #placeholder= Prompt Table 5.3: qfs:label* variants qfs:labelText The text of the component itself. qfs:labelFor Text of a label assinged to the component in the code. For example via labelFor with web applications. qfs:labelLeft The text of a 'Label' component to the left of the component. qfs:labelTop The text of a 'Label' component above the component. qfs:labelTopleft The text of a 'Label' component top left of the component. qfs:labelRight The text of a 'Label' component to the right of the component. qfs:labelBottom The text of a 'Label' component beneath the component. qfs:labelInherited The text of a 'Label' component for a different component. Example: \"Street: Main road 11\", street name and number are split into separate TextFields. The field for street number here receives \"qfs:labelInherited\" with the value \"Street:\". qfs:labelTooltip The tooltip of the component itself. qfs:labelImage The name of the icon belonging to the component. qfs:labelTitle The title of the component, for example of a Window or a titled panel of the component class \"Panel:titledPanel\". qfs:labelPlaceholder Only web applications. The placeholder showing when no text has been entered by the user. The influence of the extra feature qfs:label* variant representing Best label on the QF‑Test component ID is described in Generating the component QF‑Test ID. For information about switching from the old to the new algorithm please refer to The ExtraFeatureResolver Interface.","hash":"qfslabels_overview_table","h0":"qfs:label* variants"},"143":{"id":143,"content":"Best label When analyzing a component QF‑Test looks for different types of labels which might be used for the component. The labels found will be saved in the Extra features table, the names starting with qfs:label (see \"qfs:label* variants\"). The one with the best ranking (best label) will get the status \"Should match\", the others \"Ignore\". The order of the entries in above table rouhly represents the ranking for most component classes. The exact order can be found in the section \"qfs:label*\" of the properties of the Generic classes. Distance and overlapping also have an influence of the ranking with qfs:label* variants of the category \"Label close to it\". The value of the label ranking highest will additionally be stored as an extra feature with the name qfs:labelBest and the state \"Ignore\". In a SmartID this extra feature can be referenced by the qualifier qlabel. See also SmartID syntax for Extra features.","hash":"usec_components_qfslabelbest","h0":"Best label"},"144":{"id":144,"content":"qfs:text qfs:text contains the text of the component itself. For text fields or PDF components, this is an additional information which could not be used for component recognition without an additional resolver up until QF‑Test version 5.3.","hash":"usec_components_qfstext","h0":"qfs:text"},"145":{"id":145,"content":"value","hash":"usec_components_value","h0":"value"},"146":{"id":146,"content":"Mobile Manual","hash":"","h0":"Index | QF‑Test Manual"},"147":{"id":147,"content":"Mobile Manual","hash":"home-link","h0":"Index | QF‑Test Manual"},"148":{"id":148,"content":"Index The index of a component can also be used for recognition. However, you need to differentiate between the Class index of a Component node and the index used in a SmartID: The first always refers to GUI elements of this Class name in reference to the parent component. In the case of SmartIDs, the index refers to the eligible components for the specified SmartID (see SmartID with index).","hash":"usec_components_index","h0":"Index"},"149":{"id":149,"content":"Mobile Manual","hash":"","h0":"Geometry | QF‑Test Manual"},"150":{"id":150,"content":"Mobile Manual","hash":"home-link","h0":"Geometry | QF‑Test Manual"},"151":{"id":151,"content":"Geometry Geometry only has a small part in component recognition if other criteria are available. It also is possible for a component to neither have a name, nor a label or usable extra features or index. If then even an application-specific resolver (see \"The resolvers module\") cannot provide any recognition criteria, the recognition will rely on the component class (which is always available), the component hierarchy, and position and size of the component. If in this case you take care that the window sizes during replay are the same as during recording (see Component event), the component recognition should be stable. However, the modification effort for version changes of the application can be somewhat higher, since position changes of components must be explicitly traced.","hash":"usec_components_geometry","h0":"Geometry"},"152":{"id":152,"content":"Mobile Manual","hash":"","h0":"Component hierarchy | QF‑Test Manual"},"153":{"id":153,"content":"Mobile Manual","hash":"home-link","h0":"Component hierarchy | QF‑Test Manual"},"154":{"id":154,"content":"Component hierarchy The nesting is used in Component event for recognition as well. With Component nodes, the containers of a component are recorded as well. Whether they should be used for recognition with a present Name attribute can be controlled with the options Name override mode (replay) and Name override mode (record). The best setting for each is described in About setting identifiers. Component Nodes can be moved from deep nestings to higher-level nodes in the component tree, as long as this flattening of the component hierarchy does not affect recognition. Sometimes this approach can even lead to better recognition stability, especially if the recognition criteria for the parent nodes are unstable, or if parent components do not always exist (for example scroll panels that are inserted into the GUI hierarchy only as needed). With a SmartID, the component hierarchy can also be used for recognition. Here, the to be used component (or even multiple components) is explicitly specified in the SmartID. More information can be found in SmartID syntax for component hierarchies. Via Scope, the search area for components can be limited to a certain level of the hierarchy during replay.","hash":"usec_components_hierarchy","h0":"Component hierarchy"},"155":{"id":155,"content":"Mobile Manual","hash":"","h0":"Component node | QF‑Test Manual"},"156":{"id":156,"content":"Mobile Manual","hash":"home-link","h0":"Component node | QF‑Test Manual"},"157":{"id":157,"content":"Component node When Component nodes are used in place of SmartIDs QF‑Test stores the recognition criteria of the recorded components in Window and Component nodes, whose hierarchical order matches the structure in the GUI of the SUT. These nodes are located below the Windows and components node. The following image shows a section of the Component nodes that are part of the QF‑Test main window:","hash":"usec_componentstep","h0":"Component node"},"158":{"id":158,"content":"Figure 5.9: Component hierarchy of a Swing SUT In the detail area of a Component node, the Recognition criteria are stored. In addition, it contains the QF‑Test ID attribute. This is the reference ID for all nodes in the tests that refer to that component.","hash":"figure_5.9","h4":"Figure 5.9: Component hierarchy of a Swing SUT"},"159":{"id":159,"content":"Figure 5.10: Component node Each node in a test suite has a QF‑Test ID attribute, which does not have any special meaning and is managed automatically for most nodes. For Component nodes on the other hand, the QF‑Test ID has an important functionality. Other nodes with a target component, like events or checks, have the attribute QF‑Test component ID, which refers to the QF‑Test ID of the Component. This indirect reference of GUI elements is very useful: If the interface of the SUT changes in a way that QF‑Test cannot automatically compensate for, only the Component nodes of the unrecognized components need to be adjusted. Then, the test will run again. It is very important to understand that the QF‑Test ID of a Component is only an artificial concept for the internal use in QF‑Test, not to be confused with the attribute Name, which serves to identify the component in the SUT, which will be explained further in the next section. The actual value of the QF‑Test ID is completely irrelevant and has no relation to the GUI of the SUT. The only important thing is that the QF‑Test ID is unique and that other nodes correctly refer to it. On the other hand, the QF‑Test ID of the Component node is displayed in the tree view, and not only for the Component itself, but even for events and other nodes that refer to it. That is why Components should have expressive QF‑Test IDs that indicate the actual component in the GUI. When QF‑Test creates a Component, it has to automatically assign it a QF‑Test ID. It does its best to construct a meaningful identifier from the available information. Details about this can be found in Generating the component QF‑Test ID. Should a generated QF‑Test ID not be to your liking, you can change it. If you choose a value that is already taken QF‑Test will output a warning. If you have already recorded events referring to this component, QF‑Test offers to automatically adjust their QF‑Test component ID attribute. This automatic mechanism does not work for references with variables in the QF‑Test component ID attribute. A frequent mistake is to change the attribute QF‑Test component ID of an event instead of the QF‑Test ID itself. This destroys the connection between event and its target component, leading to an UnresolvedComponentIdException. So, you should only do this if you actually want to change the target component. Frequently, tests are assembled from existing procedures. For this it is often helpful to use the process described in Recording components. The QF‑Test component ID recorded this way will be stored in the operating system clipboard to be easily inserted into the corresponding procedure parameter. Using Recording components you can also first create the entire component structure of the SUT to get an overview and assign sensible QF‑Test IDs. During recordings, theses QF‑Test IDs will then be used.","hash":"figure_5.10","h4":"Figure 5.10: Component node"},"160":{"id":160,"content":"Mobile Manual","hash":"","h0":"SmartID | QF‑Test Manual"},"161":{"id":161,"content":"Mobile Manual","hash":"home-link","h0":"SmartID | QF‑Test Manual"},"162":{"id":162,"content":"SmartID SmartIDs enable simple and flexible recognition of components based directly on the ID without storing recognition criteria in a separate place. This noticeably slims down the recorded component tree in \"Windows and Components\". When using SmartIDs only, the component tree is not used anymore at all. However, you have to consider the price of this flexibility and ease and the possible - depending on the situtation - impact on performance and maintainability. In February 2024, a special webinar took place about SmartID. Here you can find the special webinar video recording available on our QF‑Test YouTube channel. SmartIDs use the same recognition criteria which are stored during classic component recognition in a Component node. The difference is that, of all the possible recognition criteria, one or multiple are explicitly selected and entered in place of the reference to a recorded Component, for example, directly in the attribute QF‑Test component ID of a mouse click node. The goal of SmartIDs is to slim down the component tree - which is useful, but not at all costs. The idea is to keep simple things simple, but if addressing a component gets difficult, Component nodes are preferable. As an alternative you can handle issues of uniqueness or performance via the scope concept as shown in Scope. The SmartID is characterized by a leading #. The simplest version of a SmartID is either the name or the label of a component with a prefixed #. For example, #username to select a component with the name username or #User name if User name is the label of the component. Typically, the SmartID consists of #, followed by the class of the component delimited by a colon. When the SmartID value is a label, a qualifier and = come after the colon, then the value of the SmartID. For example #TextField:left=username. The qualifier denotes the type of the SmartID value. When replaying a SmartID without qualifier the option Priority for recording SmartIDs with qualifier sets the priority for the recognition criteria. When recording, based on the setting of the option Always record qualifier for SmartID, either no identifier, or the first identifier found based on the defined prioritization will be recorded. The following qualifier exist: name: Name, see as well SmartID syntax for Name. feature: Feature, see as well SmartID syntax for Feature. label: Feature is a special form, accepting feature or one of the qfs:label* variants. The names of the Extra features, respectively their short forms, for example qlabel for Best label. See as well SmartID syntax for Extra features. Specifying the class and the qualifier help with readability and performance. The option Always record class for SmartID influences whether the component class will be recorded. The option only has effect on components where the class belongs to one of the Generic classes. With other classes it is mandatory, for example #DIV:compid. The SmartID takes the place ot the QF‑Test component ID, for example in the QF‑Test component ID attribute of event or check nodes. It can, just like the QF‑Test component ID, be stored in variables, passed in parameters, or used in scripts. For complex components like tables, lists or trees, the SmartID can also replace the QF‑Test component ID. The index describing the child element remains unchanged. Following a SmartID, a child component can be addressed either via another SmartID or an XPath, see Addressing via XPath and/or CSS selectors. SmartIDs can be used with all client technologies. As with generic components you need to consider that updating a component is not as comfortable as with a Component node. However, QF‑Test provides a powerful \"Search and Replace\" feature, which can also be used to bulk-modify SmartIDs. For a brief introduction to SmartID, also read our blog post SmartID - The next generation of component recognition .","hash":"usec_smartid","h0":"SmartID"},"163":{"id":163,"content":"Use cases for SmartIDs The application areas are generally the same as those of Generic components. SmartIDs mostly replace generic components and are easier to use. Readability When directly recording test cases, the use of SmartIDs can make recorded event and check nodes more readable. Especially if the recorded component names are cryptic and stable labels are available, it makes sense to change the recording order of recognition criteria to \"First label, then name\" by setting the option Priority for recording SmartIDs with qualifier to label,name. Ignoring the component hierarchy Some applications have deeply nested component hierarchies. SmartIDs make it easy to reduce the component tree, which is especially helpful if the hierarchy is not stable across versions. (Until now, Generic components were used in these cases. This is still possible, even in parallel to SmartIDs.) Test-driven development For test-driven development, SmartIDs offer the big advantage of not having to create any Component node nodes. In addition, Component identifiers are often defined in the technical design during test-driven development. These can then be used for test creation. Keyword-based tests Keyword-based tests are implemented via procedure calls and parameters. The test creator does not record components and depends on visual information from the GUI to identify components. This could be the component label or its function (class). Further information can be found in Keyword-driven testing with QF‑Test. Integration with other testing tools When controlling test execution in QF‑Test via other testing tools like Robot Framework, the recognition criteria can be specified directly via SmartIDs.","hash":"sec_use_cases_for_smartids","h1":"Use cases for SmartIDs"},"164":{"id":164,"content":"SmartID syntax for Class name The Class is specified in the SmartID directly after the # and followed by a :, for example #Button:. You do not need to specify the class in the SmartID when you address a component typically used in tests. It is sufficient to specify the Component identifiers or a component label (either Feature or one of the qfs:label* variants), for example #btnOK, where \"btnOK\" is the identifier of the button, or #Save, where \"Save\" is the label of the Button. It makes the handling of the SmartID easier. However, to a certain extent at the expense of performance, as without a specified class QF‑Test has to check more candidates for matches. Because of better performance QF‑Test records the class with the SmartID by default. If you want to suppress it, please set the option Always record class for SmartID to 'false'. \"Generic classes\" documents the properties for each class, including where you have to specify the class with a SmartID. Any class not mentioned in the chapter has to be specified in the SmartID, too. Example: #DIV:addresses where \"addresses\" is the Name of the DIV element in a web application. Panels with a label are a special case, being useful for nested SmartIDs (see \"SmartID syntax for component hierarchies\") or scopes (see \"Scope\"). For this reason the class type Panel:TitledPanel belongs to the SmartID classes and does not need to be explicitly specified. If you use a predefined class type in addition to the generic class, you can write this combination as usual, for example #Button:ComboBoxButton:. You can find the prefedined class types in Generic classes. For your own class types any internal colons must be escaped via \\, for example #Panel\\:myPanel:. You can find more information about the combination possibilities in \"SmartIDs - general syntax\". .","hash":"usec_smartid_class","h1":"SmartID syntax for Class name"},"165":{"id":165,"content":"SmartID syntax for Name A Name can be specified in the SmartID directly after the #, for example #txtUsername. If the class of the component belongs to the Generic classes, just stating the name is sufficient. Otherwise, the Class must be prefaced, for example #DIV:txtUsername. The name can contain SmartID-specific special characters , but they must be escaped with a prefixed \\. To force component recognition to refer to the Name, the SmartID can be prefixed with Name=, for example #Name=txtUsername. Upper/lower casing does not matter for Name=. You can find more information about the combination possibilities in \"SmartIDs - general syntax\" .","hash":"usec_smartid_name","h1":"SmartID syntax for Name"},"166":{"id":166,"content":"SmartID syntax for Feature The recognition criterium Feature can be specified in the SmartID directly after the #, for example #User name. If the class of the component belongs to the Generic classes, just stating the name is sufficient. Otherwise, the Class must be prefaced, for example #DIV:User name. The feature can contain SmartID-specific special characters , but they must be escaped with a prefixed \\. To force component recognition to refer to the Feature, the SmartID can be prefixed with Feature=, for example #Feature=User name. Upper/lower casing does not matter for Feature=. You can find more information about the combination possibilities in \"SmartIDs - general syntax\" .","hash":"usec_smartid_feature","h1":"SmartID syntax for Feature"},"167":{"id":167,"content":"SmartID syntax for Extra features Recognition criteria from the group of Extra features are also available for SmartIDs. They can be referenced via qualifiers inserted before the SmartID value. An equal sign = separates the qualifier and the SmartID. For all Extra features the name of the extra feature corresponds to the qualifier. They are case-sensitive. The SmartID value corresponds to the value of the extra Feature, also case-sensitive. Examples: The SmartID #module=module1 references a component with an extra feature named module and the value module1. The SmartID #my\\:foo=Any\\&thing references a component with an extra feature named my:foo and the value Any&thing. Short forms exist for the qualifiers for qfs:label* variants. They will be explained further down in the chapter. SmartID specific special characters \":\", \"@\", \"&\" und \"%\" (see SmartIDs - special characters) in the value, the qualifier or the class name of the SmartID have to be escaped with a prefixed \\. You can find more information about the combination possibilities in \"SmartIDs - general syntax\" . Extra feature qfs:label qfs:label* variants representing the labels of a component have prominant role for component recognition. When a component has labels use can use either the Best label or a specific label. The advantage of a specific label is performance at replay, because QF‑Test knows which label to go for and does not have to check all possibilities. When you want to reference a specific label you need to write the hash tag, # then the qualifier, i.e. the short form of the name of the Extra feature (see qfs:label* variants), followed by \"=\" and the SmartID value, for example #left=First name. You can address the best label directly after the hash tag or via the qualifier qlabel=. When you write #label=, the value of the SmartID can either refer to the Feature or one of the qfs:label* variants. The qualifiers are not case-sensitive. SmartIDs without a qualifier, for example #First name will be evaluated following the priority set via the option Priority for recording SmartIDs with qualifier, by default Name - Feature - 'Best label'. Beispiele: #left=First name - The label to the left of the component has to be \"First name\". #qlabel=First name - The Best label for the component has to be \"First name\". #label=First name - Either the Best label for the component or the Feature has to be \"First name\". #First name - Either the name or the Best label for the component or the Feature has to be \"First name\". Extra features qfs:text and text The extra features qfs:text and text have a special status as well. Both can be addressed via the qualifier text=. If you want to explicitly use qfs:text you can use qtext=. Examples: #text=Anna, #qtext=Benno Looking closely, with the qualifier #text= QF‑Test will first look for the Extra feature #qfs:labelText=, then for qfs:text and text. As the latter two have a special use with text components for which nor #qfs:labelText= will be recorded, there won't hardly be any conficts. If you want to use the extra features qfs:text and text without the prefix #text= you need to set the option Priority for recording SmartIDs with qualifier accordingly, for example to \"name,feature,qlabel,text\". Extra Feature qfs:type The extra feature qfs:type denotes the type of a class. If a type is not predefined by QF‑Test (see Generic classes) any colons contained within must be escaped via \\.","hash":"usec_smartid_extrafeatures","h1":"SmartID syntax for Extra features"},"168":{"id":168,"content":"SmartID with index All SmartIDs can be equipped with an index in case multiple components match the same SmartID. For this, the technical order of the components in the hierarchy counts. This does not have to be the same as the visual order. The count of the index starts at 0. The index is specified in between angled brackets. If no index is given, 0 is used implicitly. Examples: #Name<2>, #TextField:<2>","hash":"usec_smartid_index","h1":"SmartID with index"},"169":{"id":169,"content":"Special cases For components of the class Label, the standard order does not apply. Because they are mostly used as label for other component classes and are stored there in the feature or extra feature \"qfs:label\", components of the class Label are treated as subordinate. Label components must be addressed explicitly with the prefixed class Label:, for example #Label:First Name. You can find information about the SmartID syntax in general in \"SmartIDs - general syntax\".","hash":"usec_smartid_specialcases","h1":"Special cases"},"170":{"id":170,"content":"SmartID syntax for component hierarchies The Component hierarchy can also be used with SmartIDs for recognition. As divider between hierarchy levels, @ is used. Examples: Component inside container The SmartID #Customer information@#Name references a component with the SmartID #Name in a parent component (like a TitledPanel) with the SmartID #Customer information. Component inside \"normal\" component Sometimes, components like a Button will not have any good recognition criteria themselves but can be addressed well via their parent component. A typical example is the Button for expanding the list of a combo box: #ComboBoxSmartID@#Button: Component inside Sub-Element Links or buttons inside list oder table elements can be addressed with nested SmartIDs: #ListSmartID&22@#Link:<1> Here, the part before \"@\" addresses a list element, #Link:<1> addresses the second link inside.","hash":"usec_smartid_hierarchy","h1":"SmartID syntax for component hierarchies"},"171":{"id":171,"content":"Recording and replaying SmartIDs To record SmartIDs instead of component notes, please activate the option SmartID recording or simply check the menu item »Recording«-»SmartID recording«. When recording SmartIDs, by default QF‑Test first checks if a Name is present. If it is the case, it will be used for the SmartID. If not, QF‑Test will search for a label (in Feature or Extra features). Using the option Priority for recording SmartIDs with qualifier the criteria and their order can be changed. If the determined SmartID is valid for multiple components, QF‑Test will try to create a nested SmartID (see also Component hierarchy), otherwise, an index will be appended. For many cases recording SmartIDs is straightforward. However, depending on the target component and the information available it may happen that no SmartID can be recorded so that a classic Component node node gets recorded instead. This is the case if, for example, the GUI element cannot be assigned a generic class or if QF‑Test can determine neither a Name nor a Feature nor the extra feature qfs:label* variants. By default the generic class is prefixed to the recorded SmartID. This not only improves readability, it also has a significant effect on replay performance. This can be turned off via the option Always record class for SmartID. Please note that the 'Label' or 'Panel' prefixes are always recorded to ensure correct replay. Replaying nodes with SmartIDs is no different than with recorded components. Both variants can be used inside the same test case. SmartIDs can also be used in combination with recorded components to address descendant components. The example recordedList&10@#Button: illustrates the combination of the QF‑Test ID of a recorded list with an Index and the SmartID of the Button contained inside the list element.","hash":"usec_smartid_recordreplay","h1":"Recording and replaying SmartIDs"},"172":{"id":172,"content":"Component QF‑Test ID as SmartID It is possible to set the QF‑Test ID of a recorded Component to a SmartID icluding prefixed #. This can be used to essentially reroute this SmartID and perform the recognition via the classic recognition criteria of the recorded component. Recording individual components makes the most sense if the SmartID gets long and cumbersome, has bad performance, or is hard to make unique. The SmartID indicator # can be used for consistency's sake, but it does not have to be.","hash":"usec_components_qftestid_as_smartid","h1":"Component QF‑Test ID as SmartID"},"173":{"id":173,"content":"Mobile Manual","hash":"","h0":"Scope | QF‑Test Manual"},"174":{"id":174,"content":"Mobile Manual","hash":"home-link","h0":"Scope | QF‑Test Manual"},"175":{"id":175,"content":"Scope A scope can be used to narrow the search area for components. This is useful to make component references unique or to improve the readability of a test. Example: There are three panels with address data with identically labeled text fields. The scope can now be set to one of the panels. Now the specified SmartIDs refer exclusively to the fields in this panel. Scope can also be used to speed up component detection under certain circumstances, especially for windows or web pages that contain a large number of components. An example of this is web applications that load all GUI elements with the status \"invisible\" from the start, and only make the relevant ones visible. Here it can be useful to use the scope to limit component detection to at least the visible window. The scope is set in the comment of a node, via the SmartID or even the QF‑Test ID of the recorded component with prefixed @scope, for example @scope #myDialog. If the scope should apply to multiple event or check nodes, the scope is set in the comments of a node (for example Sequence, Test step, or Test case) which contains these nodes directly or indirectly via procedure calls. The scope currently active can be referenced via a SmartID consisting just of the hash symbol #. If a component is not part of the scope, a ComponentNotFoundException will occur. Scopes can be bypassed when needed by inserting the doctag @noscope in the comments of the respective event or check node or by inserting noscope: at the start of the SmartID. For example, its possible to click a button \"Save\" via the SmartID #noscope:Save, even though the button is outside of the scope set for the sequence in which the click event is located (see \"SmartIDs - general syntax\"). Scopes can be nested, whereby the inner scope must lie in the outer scope and further restrict it. This, too, can be bypassed with the doctag @noscope. To do this, the doctags @noscope and @scope NEWSCOPE are specified in the comments of the node whose components lie in a scope outside the current one (NEWSCOPE denotes the new scope). The order of the doctags does not matter. The scope always refers only to the respective nodes and nodes executed within it. Therefore the nodes of a procedure called from inside a scope must either be inside this scope or be marked with #noscope:... or doctag @noscope. Scopes can be set via SmartIDs or via the QF‑Test ID of a recorded Component. Still, they are only respected when referencing a component via SmartID. Referencing a recorded Component will always ignore the current scope.","hash":"usec_scope","h0":"Scope"},"176":{"id":176,"content":"Mobile Manual","hash":"","h0":"Generic components | QF‑Test Manual"},"177":{"id":177,"content":"Mobile Manual","hash":"home-link","h0":"Generic components | QF‑Test Manual"},"178":{"id":178,"content":"Generic components Before the introduction of the SmartID in QF‑Test Version 6.0, generic components were the pattern of choice for avoiding recording components. With SmartIDs, this goal can be achieved easier and more flexibly. Still, the concept of generic components is described here for backwards compatibility. A typical use case is the testing of localized applications. Another situation could be the use of a GUI framework during development. This generates, for example, a lot of similar dialogs which differ by only a few components. But you must re-record them for each dialog, for example global navigation buttons, because they are located inside a new window each time. With generic components, you use variables in the component properties or simply delete non-dynamic parts of them. The following is a general approach for generalizing components: Record some components you want to generalize and compare them. Create a new generic component with 'generic' in the QF‑Test ID so you can find it again later. Remove all attributes you do not want to use for recognition from this generic component. Define the recognition criterium, like 'name', 'feature' or 'index'. Place a variable in this attribute, for example $(name). To avoid false positives, deactivate geometry recognition by placing a '-' in the 'X' and 'Y' attributes. Specify '@generic' in the Comment attribute so this component is not inadvertently removed by the 'Remove unused components' action. Create a procedure for accessing this generic component and use the variable from before as procedure parameter. Generic components are very useful for replay of tests, but QF‑Test does not use them for recording. It always records concrete components and you need to manually replace these with generic components afterwards.","hash":"sec_bpCRGeneric","h0":"Generic components"},"179":{"id":179,"content":"Mobile Manual","hash":"","h0":"Sub-items: Addressing relative to a parent component | QF‑Test Manual"},"180":{"id":180,"content":"Mobile Manual","hash":"home-link","h0":"Sub-items: Addressing relative to a parent component | QF‑Test Manual"},"181":{"id":181,"content":"Sub-items: Addressing relative to a parent component In QF‑Test it is possible to address components in relation to a parent component. This is most interesting if the child component can only be unequivocally addressed in combination with its parent. There are various usage scenarios for this and also various ways to implement. Addressing via index With tables, lists, and trees it makes sense to use an index for sub-items. The main component is specified via the QF‑Test component ID or a SmartID. The index for the sub-item is appended. Examples: listid@Entry, #Table@Column Heading&5 If the main component is addressed via a SmartID, tabs in a TabPanel or list items of a ComboBox can be referenced simplified. Examples #Tab:Tab1, #Item:EntryX More information can be found in Addressing via index. Addressing sub-items via SmartID SmartIDs can be attached to the QF‑Test component ID or to the SmartID identifying the parent component. As divider between parent and child component, @ is used. The nesting can also be multi-level. The individual components can also be given an index. Examples: #Dialog:@#OK, comboboxid@#Button:, #Table:&0&0@#CheckBox:. Addressing sub-items via QPath A QPath can be used simliarly to the attached SmartID, but is not as powerful as it by far. A QPath can be attached to a QF‑Test component ID. As divider, @ is used. The QF‑Test component ID can also be given an index. Examples: buttonid@:Icon, tableid&0&0@:CheckBox More information can be found in Addressing via QPath. Addressing sub-items via XPath and CSS selectors Scope The parent component can also be specified via a scope, see Scope. Recording sub-items as nodes In the case of tables, lists and trees it can also make sense to record the sub-item as Item node. It depends on the situation if a sub-item is addressed via index or if it makes more sense to record it. You can use both methods as preferred and even combine them. The rule of thumb is that an Item node is better for components with few, constant elements, like columns of a table or tabs in a tab panel. The syntax is preferrable if QF‑Test variables are used in indexes or if the names of elements vary or are editable. The option Sub-item type determines if QF‑Test creates Item nodes during recording or uses the QF‑Test ID syntax. With the default setting \"Intelligent\", QF‑Test follows the rules above. More information about recording sub-items can be found in Addressing via Items nodes. Possible combinations Note: In the following listing, the SmartID of the parent component may already consist of nested references.","hash":"usec_subitems","h0":"Sub-items: Addressing relative to a parent component"},"182":{"id":182,"content":"Note: In the following listing, the SmartID of the parent component may already consist of nested references. Reference of the parent component Reference of the child component Example QF‑Test component ID Index list item with text index: listid@Entry SmartID Index table cell with numeric indexes: #Table:&0&2 QF‑Test component ID SmartID Icon in button: buttonid@#Icon: SmartID SmartID Text field in dialog: #Dialog:@#TextField: SmartID with index SmartID Button in table cell: #Table:&0&2@#Button: QF‑Test component ID with index SmartID Button in table cell: tableID&0&2@#Button: QF‑Test component ID with index QPath Button in table cell: tableID&0&2@:Button QF‑Test component ID with or without index XPath and/or CSS selector genericHtml@:css=${quoteitem:$(css)} SmartID with or without index XPath and/or CSS selector #genericDocument@:xpath=${quoteitem:$(xpath)} Scopes SmartID Scope as doctag in a Test step, SmartID in check node Table 5.4: Addressing sub-items","hash":"table_5.4","h0":"Sub-items: Addressing relative to a parent component"},"183":{"id":183,"content":"Addressing via index The sub-item is described using a special syntax. The QF‑Test component ID which is used in the test consists of the QF‑Test ID or the SmartID of the complex component (tree, table, etc.), followed by a special separator and the index of the sub-item. The kind of separator determines if the index is numeric, textual, or a regular expression (see \"Regular expressions\"):","hash":"sec_directsubitemeasy","h1":"Addressing via index"},"184":{"id":184,"content":"Separator Index format @ Text index & Numeric index % Regular expression Table 5.5: Separator and index format for accessing sub-items To access a table cell with the Primary index and the Secondary index, simply append another separator, followed by the second index. The two indices can be different types. With trees the index consists of the path of tree nodes leading to the node you want to address. The nodes are separated by a valid index separator, followed by \"/\". When a separator holds for more than one tree node in a row, you do not need to repeat it before each \"/\". The special meaning of the separators '@', '&' and '%' makes them special characters which must be escaped if they appear in the index itself. More about the topic can be found in Quoting and escaping special characters. Negative index In most cases you can use a negative index to start the count from the end. SmartIDs: Easy indexes for TabPanels and lists With SmartIDs, tabs in tab panels can be addressed according to above syntax, for example via #TabPanel:@Tab1, where Tab1 is the name of the tab. Alternatively, the shortcut #Tab:Tab1 can be used. If no other component has the SmartID #Tab1, the tab can even be addressed by #Tab1. List entries can be addressed according to above syntax via #List:@EntryX. As a shortcut, #Item:EntryX is possible, too, or just #EntryX when no other component on the page has the SmartID EntryX. The shortcuts can also be applied to drop down lists of combo boxes. Both shortcuts are very comfortable, but the high flexibility has its price in performance. How much it is depends on a number of factors, so the decision between comfort and performance must be made on a case-by-case basis. Examples","hash":"table_5.5","h1":"Addressing via index"},"185":{"id":185,"content":"Component Index Comment Table @Name&5 Table cell in the sixth row and the column with the title \"Name\". Full QF‑Test ID of the component: tableid@Name&5 List &0 Numeric index: first entry in a list. Full SmartID: #List:&0 List @Europe Text index: list entry with the text \"Europe\". Full SmartID: Default syntax: #List:@Europe Shortcut 1 (alternative): #Item:Europe Shortcut 2 (alternative) when no other component has the SmartID Europe: #Europe Tree @/root/b1/b1-2/leaf Text index: tree path addressing all nodes via their text. Full QF‑Test ID of the component: treeid@/root/b1/b1-2/leaf Tree &/0/5/1/3/ Numeric index: tree path addressing all nodes via the numeric index. Full SmartID: #Tree:&/0/5/1/3/ Tree %/W.*/A.* Regular expressions for the tree nodes. Tree &/0@/Ast1%/B.* Mixed indices: numeric index for the first, text index for the second and regular expression for the third node. Table &-1&-1 Negative indices: bottom row, right-most column. TabPanel @Tab1 Text index: addressed via the tab label. Full SmartID: Default syntax: #TabPanel:@Tab1 Shortcut 1 (alternative): #Tab:@Tab1 Shortcut 2 (alternative) when no other component has the same SmartID: #Tab1 Table 5.6: Indices for sub item","hash":"table_5.6","h1":"Addressing via index"},"186":{"id":186,"content":"Addressing via QPath Each QF‑Test component ID attribute in an event or check node (with or without sub-item) can be appended one or more indexes in the form of @:ClassName<idx>, whereby <idx> is optional. This instructs QF‑Test to first determine the target component (and if needed the sub-item) for the part of the QF‑Test component ID attribute in front of the @: and then to search for visible components of class ClassName within. If <idx> is specified, this is interpreted as 0-based index of the list of visible candidates. No <idx> is equivalent to <0>. The QPath syntax expects a generic class after the @:. An overview over generic classes can be found in \"Generic classes\". If the component cannot be recorded with a generic class, the QPath must contain the complete class name. In JavaFX for example, some of them are called ImageView, VBox, GridPane, or BorderPane. The following example references the second ImageView on the third position of a list: panelSecond.list&2@:javafx.scene.image.ImageView<1>","hash":"usec_multilevelsubitemsqpath","h1":"Addressing via QPath"},"187":{"id":187,"content":"Addressing via Items nodes An Item is defined by two things: The component it belongs to and an index inside the component. The parent node of the Item defines the component. The index can be either a number or a text. Numeric indexes start with 0. For example, in a JList component the element with index 1 corresponds to the second list entry. For trees, simple numeric indexes are almost useless, since by opening and closing branches, the indexes of all nodes below are changed. A text index defines an element by the text it displays in the interface. a list item called \"Entry1\" in a JList component would be recorded with the text index \"Entry1\". The textual representation is more flexible than the numeric one, but can cause problems if the displayed texts of the elements in a component are not unique. In these cases, the first matching element is selected. A text index can also be a regular expression (see \"Regular expressions\"). In this case, the first element matching the expression is selected. The option Sub-item format determines which format is used during element recording. Almost all kinds of Item have only one index. This is not sufficient for the cell of a JTable component, since tables are two-dimensional structures. Two indexes are needed to exactly describe a cell. The first, the Primary index, determines the table column, the second, the Secondary index, the row.","hash":"usec_subitems_node","h1":"Addressing via Items nodes"},"188":{"id":188,"content":"Figure 5.11: An Item for a table cell Tree nodes also occupy a special position. As described above, the hierarchical structure cannot be easily mapped to a linear structure. In addition, tree nodes with the same names often occur in trees. If, on the other hand, the direct and indirect parent nodes are included in the name, uniqueness can usually be achieved. QF‑Test uses a special syntax to represent tree nodes. An index starting with a '/' character is interpreted as a path index. Just think of a file system: The file named \"/tmp/file1\" can either be represented flat as \"file1\", which can lead to conflicts with other files named \"file1\" in other directories. Alternatively, the full and unique path \"/tmp/file1\" can be used. QF‑Test also supports numeric indexes with this syntax: A numeric index of the form \"/2/3\" denotes the fourth child node of the third child node of the root node. A combined form to address the third node in the \"tmp\" node using \"/tmp/2\", for example, is currently not possible. This special syntax makes '/' a special character for Items in a tree component. If this character appears in a name itself, it therefore must be escaped. More about this topic can be found in \"Quoting and escaping special characters\". Everything said in \"Component node\" about the QF‑Test ID attribute of Components also applies to the QF‑Test ID attribute of an Item. This attribute must be unique and is referenced by events and checks. When QF‑Test automatically assigns the QF‑Test ID of an Item, it creates it by taking the QF‑Test ID of the Component of the parent node and appending the index (or indexes). This kind of QF‑Test ID is normally well readable and understandable. Unfortunately, it also is the source of a frequent misunderstanding: If you want to change the index of a recorded Item to refer to another element, you must not change the attribute QF‑Test component ID of the node which refers to it. Instead you must change the Primary index of the Item node.","hash":"figure_5.11","h4":"Figure 5.11: An Item for a table cell"},"189":{"id":189,"content":"Mobile Manual","hash":"","h0":"Troubleshooting component recognition problems | QF‑Test Manual"},"190":{"id":190,"content":"Mobile Manual","hash":"home-link","h0":"Troubleshooting component recognition problems | QF‑Test Manual"},"191":{"id":191,"content":"Troubleshooting component recognition problems","hash":"usec_troubleshooting","h0":"Troubleshooting component recognition problems"},"192":{"id":192,"content":"Timing synchronisation If you get exceptions because a component was not found, one of the reasons may be that you did not wait for the component long enough. A mouse click has a certain default waiting time, but this is not always sufficient. Therefore you should check if there are enough synchronization points, like Wait for component to appear or Check nodes with waiting times to only execute the test steps if the SUT is really ready for it. A Wait for component to appear node can be used when a new component appears. The maximum wait time (in milliseconds) is set in Timeout. A Check node is used to wait for a state change of components. The maximum wait time (in milliseconds) is set in Timeout here as well. Sometimes it is also necessary to loop, waiting for the state change and, if not already done, performing an action, for example, clicking a \"Refresh\" button. You can also wait for the number of rows in a table to change in a loop. Many applications use indicators that symbolize waiting times, for example progress bars or \"egg timers\". Here you can wait first for the component to appear and then for it to disappear. The maximum wait time is set in the Timeout attributes. As soon as the desired application state is reached, QF‑Test continues execution. These waiting times can therefore be chosen generously. You should only change the option for default waiting times (\"Timeouts\") if generally longer waiting times make sense across your whole application. As a last resort you can also use with a fixed delay. When the attribute Delay before/after is set, QF‑Test will wait the entire given time. Delay before/after should therefore only be used if there is no state change detectable by QF‑Test in the application which QF‑Test could wait for.","hash":"usec_components_sync","h1":"Timing synchronisation"},"193":{"id":193,"content":"Recognition If your SUT changes in a way that makes it impossible for QF‑Test to find a component again, your test will fail with a ComponentNotFoundException. This should not be confused with an UnresolvedComponentIdException, which can be caused by removing a Component node from the test suite or by changing the attribute QF‑Test component ID of an Event node to a non-existing QF‑Test ID. There are two videos that comprehensively explain how to handle a ComponentNotFoundException: 'ComponentNotFoundException - Simple case' 'ComponentNotFoundException - Complex case' When run into an ComponentNotFoundException, run the test again with the test debugger enabled so that the test stops and you can examine the node that caused the problem. This is where it pays to have QF‑Test ID attributes that are meaningful, because you need to understand which component the test was trying to address. If you can't make any sense of what the node in question is supposed to be, disable it and see if the test goes through without it. It could be a spurious effect that was not filtered during the recording and that does not contribute anything to the actual test. Basically, your tests should always be reduced to the minimum number of nodes that can be used to achieve the desired effect. If the node must be preserved, next take a look at the SUT to see if the target component is currently visible. If not, you will need to adjust your test accordingly to handle this situation. If the component is visible, use the screenshot in the log to verify that this was the case at the time of the failure and try executing the failed node again as a single step. If execution now works you have a timing problem which you can solve by including a Wait for component to appear node, a Check node with Timeout, or another waiting action (see Timing synchronisation). If the component is visible and the replay continuously fails, the reason is a change in the component or one of its parents. Now you must determine what changed and where. For this, record a new click on the component and compare the new and old Component node in the hierarchy below Windows and components. You can jump directly from the Event node to the associated Component by pressing Ctrl⁠+⁠W or by selecting »Find component« from the context menu. You can use Ctrl⁠+⁠Backspace or »Edit«-»Select previous node« to jump back again. A smart move is to denote the Components to be compared using markers with »Edit«-»Mark« to easily find them again. The crux is where the hierarchy of the two nodes branches. If they are located under different Window nodes, the difference is in the respective Windows themselves. Otherwise, there is a common predecessor just above the branch. The crucial difference is then found in the respective nodes directly below this common predecessor. When you have found the place of divergence, compare the attributes of the respective nodes from top to bottom and look for differences. You can use »View«-»New window...« to open another QF‑Test window and place the detail views of both nodes next to each other. The only differences that will always lead to an error during recognition are changes to the attributes Class name or Name. Differences to Feature, structure or geomertry can usually be compensated for, provided they do not accumulate. A change to the Class name should seldomly happen when using Generic classes. Using generic classes offers a range of advantages, but in the case of web applications it is sometimes only introduced after creating first tests (see Improving component recognition with a CustomWebResolver). In this case you must adapt the Class name attribute of the already created Component nodes to this change. The Component identifiers can change, too. If the change seems to be on purpose, for example correcting a grammatical error, you can adjust the Name attribute accordingly. More probably it is an automatically generated Component identifiers which could change again at any time. Here it can make sense as well to discuss the issue with the developers and find a solution on the development side. Otherwise, for web applications the Name can be influenced by Install CustomWebResolver node – Syntax via the catagories autoIdPatterns and customIdAttributes. In all technologies the Name can be influenced using a NameResolver as described in \"The NameResolver Interface\". It can be suppressed entirely or reduced to the relevant parts. Changes to the attribute Feature are not unusual, especially for Window nodes. There, the Feature corresponds to the title of the window. Combined with a significant change to geometry, this can cause the recognition to fail. This can be fixed by adjusting the Feature attribute to the new circumstances, or - preferably - by using a regular expression (see \"Regular expressions\") which covers all variants. Depending on the type and scope of the changes, there are two basic options for correction: Adjust the attributes of the old node and remove the newly recorded nodes. If the changes to the SUT were small enough and the component recognition still works, changes can also be performed automatically via the QF‑Test feature Update Components. Keep the new nodes and remove the old ones. For this you first must make sure that all nodes that refer to the old components are updated to the new QF‑Test ID. This can be achieved with a little trick: Change the QF‑Test ID of the old Component node to the QF‑Test ID of the new one. QF‑Test will initially complain that the QF‑Test ID is not unique, which you can ignore, and then will offer to update all references, which you need to confirm with \"Yes\". Then, you can remove the old node. The automatic adjustment of references in other test suite only works if they belong to the same project or if the attribute Dependencies (reverse includes) of the Test suite node is set correctly.","hash":"sec_recognition","h1":"Recognition"},"194":{"id":194,"content":"Mobile Manual","hash":"","h0":"Weighting of recognition features for recorded components | QF‑Test Manual"},"195":{"id":195,"content":"Mobile Manual","hash":"home-link","h0":"Weighting of recognition features for recorded components | QF‑Test Manual"},"196":{"id":196,"content":"Weighting of recognition features for recorded components When searching for a component, QF‑Test calculates the probability with which each component in the SUT corresponds to the searched component. The component with the highest probability is then used, as long as that this probability is above a freely configurable threshold. First, the probabilities of the windows in the SUT are examined. Then, the search is continued in the window with sufficiently high probability. The same procedure is followed level by level, i.e. for each direct and indirect parent node of the searched Component node, but from top to bottom. At each level, the components matching the attribute Class name are determined and their probability is calculated. Invisible components are not considered. At each level, the probability of a component is calculated in several stages: Every calculation starts with a value of 99 percent, which is first reduced by deviations from geometry specifications. This serves as the base probability for the next stages. The following three stages can either result in a \"match\", \"no match\", or be skipped. If no value is specified for a stage, it is skipped; the probability remains unchanged. Each of the three steps has a freely configurable bonus in case of a match or a penalty in case of a deviation. A bonus in effect increases the probability score to more than its value, a penalty reduces it to below its value. First, the structure of the Components is checked, (not of Windows, which do not have this information). All components of the currently evaluated container component whose class matches the given Class name or a derived class are collected in a list (including invisible components). For a match, the amount of previously identified components with the matching class as well as the index of the component in this list must match. Then, the Feature and possible Extra features are checked. If the test of an Extra feature with status \"must match\" fails, the component is discarded. Finally, the Name of the component is checked. If a Name exists, this is the deciding check since bonus and penalty have the highest values here. For dialogs, there is another step that checks the modality of the dialog. Normally, a dialog is either modal or non-modal, so a mismatch would prevent detection. However, one and the same dialog could be presented modally or non-modally depending on context. If your SUT contains such a dialog, you must set \"Modal penalty\" to a value above the minimum probability. If the calculated probability does not reach a minimum value, the component is discarded. The component with the highest probability is used. If there is a discrepancy in the component's structure, feature, or name, a message is written to the log, as this may indicate that it is not the correct component after all. Most of the time, however, this just indicates that the SUT has changed slightly. The component should then be updated before the changes accumulate and the component is no longer recognized. Even though the search for the name already dominates this process, you can increase its importance even more by setting the options Name override mode (replay) and Name override mode (record) to \"Override everything\". Then QF‑Test will simplify the search for a component if it has a name. Instead of, as explained above, working through all parent containers from the outside in, they are skipped and the window is directly searched for a component matching the name and class. This increases the independence from the GUI structure; The component will even be recognized if a new hierarchy level between window and component is introduced or removed. This method requires that, if a name is given, it is unique at least among the visible components of the same class in one window. If such uniqueness is not given, \"Hierarchical resolution\" is the next best setting for the two options. It requires that two components with the same name have at least differently named parent containers. This setting preserves most of the benefits and flexibility of names. However, it will fail recognition if a named component is moved from its parent container.","hash":"sec_recognition","h0":"Weighting of recognition features for recorded components"},"197":{"id":197,"content":"Mobile Manual","hash":"","h0":"Component tree maintenance | QF‑Test Manual"},"198":{"id":198,"content":"Mobile Manual","hash":"home-link","h0":"Component tree maintenance | QF‑Test Manual"},"199":{"id":199,"content":"Component tree maintenance During the course of test creation, some unused components can collect in the component tree. From time to time you can Clean up the component tree. On the other hand, recognition characteristics can change because of changes in the application interface. Before changes accumulate across multiple interface changes and break recognition, it makes sense to Update Components in the affected windows and dialogs.","hash":"usec_component_maintenance","h0":"Component tree maintenance"},"200":{"id":200,"content":"Clean up the component tree Each time a sequence is recorded, new nodes are created for the components which are not yet part of the test suite. If the sequence is deleted later, theses Components remain which gives Components a certain tendency to accumulate. The context menu for Window and Component nodes has two entries called »Mark unused components...« and »Remove unused components«, which mark or remove entirely those Components which no other node in this test suite refers to. Be careful if you use variables in QF‑Test component ID attributes since the automatic mechanism does not resolve them. If Components from other test suites are referenced, these should be part of the same project or the attribute Dependencies (reverse includes) of the Test suite must be set correctly.","hash":"usec_cleancomponenttree","h1":"Clean up the component tree"},"201":{"id":201,"content":"Update Components It is almost unavoidable that components of the SUT change with time. As described, this is not a big problem as long as identifiers were consequently used, since QF‑Test can then handle almost every kind of change. Without identifiers, changes will accumulate with time and can reach a point at which the recognition fails. To avoid this problem, you should adjust the Components in QF‑Test to the current SUT from time to time. This can be done with the help of the menu entry »Update component(s)« which you can find in the context menu of any node below the Windows and components node. This feature can change a lot of information at once, so it can be difficult to judge if everything went well or if a component was recognized wrongly. You should always create a backup copy before updating lots of components. You should also proceed Window by Window and make sure that the components you want to update are visible in the SUT (excluding menu entries). After every step make sure that the tests still run cleanly. Provided there is a connection to the SUT the following dialog will appear when using this function:","hash":"usec_update_components","h1":"Update Components"},"202":{"id":202,"content":"Figure 5.12: Update components dialog If you are connected to multiple SUT clients you need to select one for the update. Decide if you only want to update the selected Components themselves or their child nodes as well. You can also include components that are not currently visible in the SUT. This is most useful for menu entries. The QF‑Test ID of an updated node is retained if \"Keep QF‑Test ID of original node\" is selected. Otherwise, the node is given a QF‑Test ID generated by QF‑Test, if meaningful information is available. Other nodes that refer to this QF‑Test ID are automatically adjusted. QF‑Test also checks dependencies in the test suites that belong to the same project or that are listed in the attribute Dependencies (reverse includes) of the Test suite node. These test suites are automatically loaded and indirect dependencies are also resolved. In this case, the modified test suites are automatically opened so that the changes can be saved or undone. After confirming with \"OK\", QF‑Test will attempt to find the affected components in the SUT and collect current information. Components which cannot be found are skipped. Then the Component nodes are adjusted to the current structure of the SUT GUI, which can also result in nodes being moved. For large hierarchies of components, this extremely complex operation can take some time, up to a few minutes in extreme cases. This feature is most useful if identifiers are used for the first time in the SUT. If you have already created some tests before convincing developers to assign identifiers, you can use this to apply these identifiers to your Components and at the same time adjust the QF‑Test IDs. This works best if you can get a version of the SUT which is identical to the previous version except for the identifiers. Very important note: Updating whole windows or hierarchies of components above a certain size often leads to an attempt to update components that are not present or invisible at that moment. In such a case it is very important to prevent false positive hits for these components. You can do this by temporarily setting the '... bonus' and '... penalty' options for recognition (\"Component recognition\"). In particular, set the 'Feature penalty' to a value below the 'Minimum probability' value, for example to 49, if you otherwise use the default values. Do not forget to restore the original values afterwards. If you need to change the setting of the Name override mode (replay) and Name override mode (record) options, for example because component identifiers have turned out to be ambiguous, first change only the option for recording. When the update is finished, follow up the option for playback accordingly.","hash":"figure_5.12","h4":"Figure 5.12: Update components dialog"},"203":{"id":203,"content":"Mobile Manual","hash":"","h0":"Inspecting components | QF‑Test Manual"},"204":{"id":204,"content":"Mobile Manual","hash":"home-link","h0":"Inspecting components | QF‑Test Manual"},"205":{"id":205,"content":"Inspecting components Sometimes it is useful to get extra information about the components saved in the section Windows and components or to view the saved information interacting directly with the application. It is particularly relevant when mapping components of web applications. This should be done before starting to write tests, as described in Improving component recognition with a CustomWebResolver. The UI inspector can be used to examine the UI elements, currently for Android and web applications. When working with scripts, it is sometimes helpful to be able to display a list of the methods of a GUI element.","hash":"usec_componentinspection","h0":"Inspecting components"},"206":{"id":206,"content":"Show methods Every GUI object has certain (public) methods and fields which can be accessed in a SUT script as soon as it has access to the object (see \"Accessing the SUT's GUI components\"). To display these, select the »Show methods for component...« from the context menu of a node below the Windows and components branch or right-click the component itself in component recording mode (see \"Recording components\").","hash":"usec_show_methods","h1":"Show methods"},"207":{"id":207,"content":"UI Inspector The UI inspector shows the component hierarchy of the client and the properties of every component. This can be useful to resolve component recognition problems. Furthermore, it also makes it easier to set up resolvers thanks to the information displayed in the detailed view. In April 2024, a special webinar took place about this topic. Here you can find the special webinar video recording available on our QF‑Test YouTube channel. The UI Inspector is available for Android and Web applications. As of QF‑Test version 7.1, Windows and Swing/AWT are also supported and from version 7.1.3, FX is also supported. The node representation in the component tree will already give an overview of the most important information. If the class name (\"Class\") is written in blue, the component will be considered as interesting. This in turn will determine whether a Component node will be created for the component. In case a generic class (see \"Generic classes\") can be determined, the generic class will be represented in bold. Furthermore the original class will be added in brackets. By default, all generic classes will be regarded as interesting. Invisible components will be displayed in grey.","hash":"usec_inspector","h1":"UI Inspector"},"208":{"id":208,"content":"Figure 5.13: UI Inspector Opening the inspector In order to open the UI inspector you have the following possibilities: Via the menu »Clients«-»Show inspector«. Via the menu entry »Show inspector« in the context menu upon component recording. Via the context menu »Show inspector« of any Component node or any node containing a QF‑Test component ID or a SmartID. Directly from the SUT via (configurable) keyboard shortcuts. By default Umschalt⁠+⁠Strg⁠+⁠F11 for Windows/Linux and ⌃⇧⁠+⁠F11 for Mac. See \"UI Inspector\". In the recording window via the crosshairs-button in the toolbar, see QF‑Test Android recording window. UI Inspector toolbar The buttons in the toolbar have the following meaning: Select a component to inspect it. During component selection, the record- and check functionality of QF‑Test is deactivated. Furthermore actions will not be forwarded to the SUT. That way the information in the UI inspector can be analysed via mouse clicks. Navigating in the component tree. Together with inspector mode the history function also gets activated, thus remembering selections made in the UI inspector and the client, which makes it possible to jump forward and backwards in the component tree. Refresh component tree. Updating is required when components have changed or an resolver has been installed. Show invisible components in the component tree. Components with visible childs will always be displayed. Show geometry information in the component tree. UI Inspector details The UI inspector view gives an overview of the most important properties of a component. The view is divided into three sections: General This section covers the basic properties of a component, for example its class.","hash":"figure_5.13","h4":"Figure 5.13: UI Inspector"},"209":{"id":209,"content":"This section covers the basic properties of a component, for example its class. Figure 5.14: General information Engine-related The engine-related details cover additional technical information of a component. The information shown differs depending on the technology used. For Android applications information concerning the content description, resource ID, package name as well as information about the window type and its arrangement is shown.","hash":"figure_5.14","h4":"Figure 5.13: UI Inspector"},"210":{"id":210,"content":"The engine-related details cover additional technical information of a component. The information shown differs depending on the technology used. For Android applications information concerning the content description, resource ID, package name as well as information about the window type and its arrangement is shown. Figure 5.15: Android-specific information QF‑Test specific The information shown in this section relates to the Component node node. The information can be used to verify whether a resolver works as expected.","hash":"figure_5.15","h4":"Figure 5.13: UI Inspector"},"211":{"id":211,"content":"The information shown in this section relates to the Component node node. The information can be used to verify whether a resolver works as expected. Figure 5.16: QF‑Test specific information The detail view can also show information about two different components next to each other, making it easy to compare them. So right click one component in the hierarchy tree and choose »Compare« from the context menu. Via »Reset comparison« in the context menu or via the 'Close' button in the detail view you can leave the comparison mode again.","hash":"figure_5.16","h4":"Figure 5.13: UI Inspector"},"212":{"id":212,"content":"Mobile Manual","hash":"","h0":"Variables | QF‑Test Manual"},"213":{"id":213,"content":"Mobile Manual","hash":"home-link","h0":"Variables | QF‑Test Manual"},"214":{"id":214,"content":"Variables There is a brief overview video available covering the most important aspects of variable handling in QF‑Test. Variables are the primary means to add flexibility to a test suite. Though they are used mainly as parameters for Procedures, they are also useful in many other cases. Variables can be used in all attributes with text input fields. Many checkboxes can be converted to text input through the button at the top left. Then you can insert a boolean value either directly or via a variable.","hash":"usec_variables","h0":"Variables"},"215":{"id":215,"content":"Variable references There are multiple ways to reference variables:","hash":"usec_var_references","h1":"Variable references"},"216":{"id":216,"content":"Referencing simple variables $(variable name) returns the string value of a variable. If the value is not a string but is evaluated as part of a string or the result is used as text, the text representation of the value is used instead.","hash":"usec_var_references_single_var","h2":"Referencing simple variables"},"217":{"id":217,"content":"Referencing group variables ${group:name} accesses a variable in a variable group. Use it to access variables in a group which contains data from an external source (see External data). Some groups, like qftest, env and system, are always defined and have special meanings (see Special groups). Again, depending on context, the text representation of the variable value may be returned, regardless of its type.","hash":"usec_var_references_group","h2":"Referencing group variables"},"218":{"id":218,"content":"Referencing variables in scripts and script expressions Accessing QF‑Test variables in scripts and Script expressions (for example $[Jython expression] or the Condition of an If node) is described in Variables. The run context methods rc.get* There are multiple methods in the run context module for accessing variables like rc.get*, such as rc.getStr, rc.getInt, rc.getNum, rc.getBool or rc.getObj. A detailed description of all these methods is given in The rc module: Run context API. The run context property rc.vars The run context includes the Map-like object rc.vars for easy access to the current values of QF‑Test variables. Designed as an alternative to rc.getObj('name'), it lets you write rc.vars.name instead. When you use this expression to assign a value, it has the same effect of setting a local variable as rc.setLocal. The run context property rc.groups Similar to rc.vars, you can use rc.groups to access group variables: Instead of rc.getObj('group','name') or rc.getObj('qftest','dir.version') you can use rc.groups.group.name or rc.groups.qftest.dir.version. When you use this expression to assign a value, it has the same effect of setting a value in a group as rc.setGroupObject. Note that elements in special groups may not allow write access. In that case, a ReadOnlyPropertyException is thrown. $(variable name) and ${group:name} in Jython scripts In Jython scripts and script expressions, QF‑Test variables can technically be referenced with the same syntax as in normal nodes. Since the Jython script is a string, the text value of the variable is directly embedded into the Jython code during expansion. This way of referencing is not recommended. If the variable value contains items like backslashes (\\) or line breaks, it can lead to unintended results.","hash":"usec_var_references_script","h2":"Referencing variables in scripts and script expressions"},"219":{"id":219,"content":"Variable lookup To understand the reasons of why and how variables are defined in multiple places, you first have to learn about how the values of variables are determined. Each variable definition is placed on one of two stacks of so-called bindings. One stack is used for direct definitions and one for fallback bindings or default values. When the value of a variable is requested, for example via $(...), QF‑Test first searches the stack of direct bindings from top to bottom, then the stack of fallbacks, also top-down. The first value found is used. If there is no binding at all for a name, an UnboundVariableException is thrown unless you use the special syntax ${default:varname:defaultvalue} to provide a default value for this case as described in Special groups.","hash":"usec_var_lookup","h1":"Variable lookup"},"220":{"id":220,"content":"Topmost bindings (highest precedence) ... Bottommost bindings (lowest precedence) Topmost bindings (highest precedence) ... Bottommost bindings (lowest precedence) Primary stack (Direct bindings) Secondary stack (Default values) Figure 6.1: Direct and fallback bindings The mechanism supports recursive or self-referencing variable definitions. For example, setting a variable named classpath to the value some/path/archive.jar:$(classpath) will extend a binding for classpath with lower precedence. If no such binding exists, a RecursiveVariableException is thrown.","hash":"figure_6.1","h1":"Variable lookup"},"221":{"id":221,"content":"Defining variables Variables can be defined in various places. Variable definition tables Two-column Tables are used, for example, in a Procedure call to define the parameter names and values to be passed, or in a Procedure node to set default values. In each row, one variable with a name and a value can be defined. In many other nodes, like Test suite, Test set and Test case, variables can be defined in tables, as well. Procedure return values A Procedure can return a value. It will be assigned to the variable with the name given in the Procedure call node Variable for return value attribute. The called procedure can control the type of the returned object via the attribute Explicit object type of the Return node. Check results One possible result handling in a check node is to assign the result to a variable named in the attribute Variable for result, for example in a Boolean check node. Return values of capture nodes Capture nodes like Fetch text assign the received value to a variable named in the attribute Variable name. Set variable nodes Variables can also be defined through Set variable nodes. The attribute Explicit object type sets the type of the returned object. Script nodes Variables can be set in scripts via the methods rc.setLocal, rc.setGlobal, rc.setLocalJson etc. These can then be used in QF‑Test nodes. setGroupObject can be used to set variables in a variable group. For more information, see Scripting and The rc module: Run context API. Option dialog Variables can be set and changed in the options dialog section \"Variables\" (see Variables). This is especially useful for global, system and command line variables.","hash":"sec_defining_variables","h1":"Defining variables"},"222":{"id":222,"content":"Variables can be set and changed in the options dialog section \"Variables\" (see Variables). This is especially useful for global, system and command line variables. Figure 6.2: Definition of system variables in the options dialog","hash":"figure_6.2","h1":"Defining variables"},"223":{"id":223,"content":"Variable levels Variables can be declared on different levels. There is the foundational difference in evaluation order of variable definitions between the primary and secondary stack. Both stacks then each have more fixed levels.","hash":"usec_variable_levels","h1":"Variable levels"},"224":{"id":224,"content":"Primary stack For the primary stack, the following order applies:","hash":"sec_primary_stack","h2":"Primary stack"},"225":{"id":225,"content":"Local test case variables Local test case variables are located in the upper part of the primary stack. When a node is entered during test execution, the defined variables (but not the fallback values!) are placed on top of the stack and removed again when leaving the stack. For each node that has a variable definition table, a separate level is created on the primary stack, and the variables defined in the table placed there. Variables from local (not global!) assignments are added or updated in one of the existing levels, for example the return value of a procedure, the result variable of a check or capture node or variables created via Set variable or script nodes. The variable is added/updated in the level of the topmost procedure node, or if not available, of the test case node – if the variable does not already exist in a higher level (e.g. sequence, test step, loop, if node). In that case, the value of the variable is updated in that higher level. To define local variables, the attribute Local variable must be enabled in the respective node. This can be preconfigured in the QF‑Test options (see Variables). In scripts, local variables are set with the methods rc.setLocal, rc.setLocalJson or rc.vars.name = value (see The rc module: Run context API).","hash":"sec_local_test_case_variables","h2":"Local test case variables"},"226":{"id":226,"content":"Global variables If the attribute Local variable is not active in nodes that can define variables, these variables are created on the level of global variables. In scripts, global variables are set with the methods rc.setGlobal or rc.setGlobalJson (see The rc module: Run context API). A global variable can also be created despite Local variable being set if no context is available for local variables. This is the case, for example, if a node is executed directly from the 'Extras' node. A global variable remains unchanged until it is explicitly updated or cleared or QF‑Test is quit. That means that global variables \"survive\" individual test runs. They serve to exchange values between independent test cases or procedures. Keep in mind that global variables must be defined by running the test before they can be referenced. If you want to modify global variables without running a test, you can do this either through the debug mode (see Displaying variables in debug mode – Example) or the option dialog section \"Variables\". To clear any global variables before a test run, use the menu entry »Run«-»Clear global variables«. If QF‑Test is running in batch mode (see Starting QF‑Test) global variables are cleared before running any test passed through the command line argument -test <n>|<ID>.","hash":"usec_variable_levels_globals","h2":"Global variables"},"227":{"id":227,"content":"Command line argument variables Command line argument variables can be set when launching QF‑Test. These are ranked above variables defined in the Test suite node. On the command line the variables are set via the argument -variable <name>=<value>, see Command line arguments and exit codes.","hash":"sec_command_line_argument_variables","h2":"Command line argument variables"},"228":{"id":228,"content":"Test suite node variables Variables on this level of the stack are defined in the Test suite node of the current test suite. Typically, these variables are valid for all tests of the suite and can be overridden via the command line during a batch run if needed. A typical example is the choice of browser for running a web application that should differ between interactive test development and batch execution.","hash":"sec_test_suite_node_variables","h2":"Test suite node variables"},"229":{"id":229,"content":"Seconday stack The following order applies to the secondary stack:","hash":"sec_seconday_stack","h2":"Seconday stack"},"230":{"id":230,"content":"Fallback values When entering a node for which fallback values are defined, these are placed on top of the secondary stack. When a node from another test suite is called, the variables of the Test suite node of the original test suite are removed from the primary stack and placed on top of the secondary stack. When leaving the node (respectively the test suite), the variables are again removed from the secondary stack and, in the case of a test suite, moved to the primary stack into the respective level. Entries are only placed on the secondary stack if fallback values were definied for a node or the originating test suite has variable definitions in its Test suite node.","hash":"sec_fallback_values","h2":"Fallback values"},"231":{"id":231,"content":"System-specific variables Here, path names and JDK- or OS-specific values or similar can be defined. This set of definitions is always located at the bottom of the secondary stack and therefore has the lowest binding priority. System-specific variables are set in the option dialog section \"Variables\". They are stored in the system configuration file together with other system options.","hash":"sec_system_specific_variables","h2":"System-specific variables"},"232":{"id":232,"content":"Displaying variables in debug mode – Example Consider the following example:","hash":"usec_variables_debug","h1":"Displaying variables in debug mode – Example"},"233":{"id":233,"content":"Figure 6.3: Variable example The Sequence \"Login\" contains a Procedure call of the Procedure \"login\" which expects two parameters: user and password. The Parameter default values of the Procedure are user=username and password=pwd. The Procedure call overrides these with user=myname and password=mypassword. The \"login\" Procedure itself contains Procedure calls of other Procedures. Here, no parameters are passed. The procedures \"setUser\" and \"setPassword\" have one entry each in Parameter default values. The following figure shows the overview of variable definitions when executing the procedure\"setUser\".","hash":"figure_6.3","h4":"Figure 6.3: Variable example"},"234":{"id":234,"content":"Figure 6.4: Variable definitions Let's take a closer look at the individual rows of the table: Procedure setUser: No variables defined. Procedure call setUser: No variables are passed because it is not required (different from e.g. Java). When checking the variable definitions, QF‑Test goes through the table from top to bottom - regardless of procedure or test case borders. As soon as a variable with the matching name is found, the corresponding value is used. Procedure login: No variables defined. Procedure call login: Two variables are defined in this procedure call. The row was selected, so you can see the defined variables and their values on the right. At the current execution point of the test, the variable \"name\" will be used next. Since the first ocurrence of a variable with that name is in this row, the corresponding value \"myName\" will be used. Sequence Login: No variables defined. Test case Test: No variables defined. Global variables: The variable \"client\" was defined in the Dependency node, because it is needed in all test cases that interact with the application under test. Global variables remain unchanged until they are explicitly updated or cleared. Command line: Three variables were defined on the command line. One of them is the name of the browser that should be used for the current test run. Test suite: The name of the browser stored here would be used as a fallback if no other browser was defined in the rows above. Secondary stack: Signals the end of the primary stack and the beginning of the secondary stack below. Procedure setUser: A default value for the variable \"name\" is stored here. It would be used if no variable of that name existed in the rows above. Procedure login: Here default values for \"name\" and \"password\" are stored, as well. They would be used if no variables with those names existed in the rows above. System: No variables defined.","hash":"figure_6.4","h4":"Figure 6.4: Variable definitions"},"235":{"id":235,"content":"Data types of variables With a few exceptions, all attribute fields in QF‑Test nodes interpret entered values as plain text. Those exceptions are the conditions of If, Test case and Test set nodes, as well as script code attributes which expect valid expressions of a specific syntax. Since the attributes are usually interpreted as text, a special syntax is needed to access variables or for calculations and string manipulations (see Variable references and Script expressions). In script nodes, all data types that are available in their scripting language can be used independently of QF‑Test. Inside the script interpreters, the data objects of any script can be used, see Variables. However, these will not show up in the variable stack of QF‑Test and are not visible in the debug-mode variable definitions table or logged in the run log. You can use the run context methods rc.setLocal and rc.setGlobal to put a variable from a script onto the QF‑Test variable stack. This way, QF‑Test variables can be assigned strings, but also values with other data types. To set non-string values in a Set variable node you can use Script expressions in the attribute Default value, or you can enter the text representation of the value there and set the desired object type in Explicit object type. To access these variables, various methods are available. For QF‑Test nodes, these are described in Variable references. For scripts and script expressions, methods are described in Variables, and special ones for Jython scripts in Jython Variables. A detailed description of all run context methods can be found in The rc module: Run context API.","hash":"usec_var_datatypes","h1":"Data types of variables"},"236":{"id":236,"content":"JSON data Data is often provided as JSON objects when working with HTTP requests or WebAPI. If you want to serialize such an object, which means to convert it into a JSON string and store it in a QF‑Test variable, you can use the methods rc.setLocalJson() and rc.setGlobalJson() of the run context (see The rc module: Run context API) in a script node. If you want to convert a JSON string into a JSON object, you can use rc.getJson() in a script node (see The rc module: Run context API). JSON objects can be modified and handled with the methods described in The JSON module.","hash":"usec_var_json","h2":"JSON data"},"237":{"id":237,"content":"External data You can access external data via Load properties, Excel data file, Database, CSV data file and Load resources nodes. These assign a set of definitions to a group name. You can access the value of a resource or property via the description name with the syntax ${group:name}. You can also access external data in a Data driver via Excel data file, Database and CSV data file. In that case however, no group is created. Instead, a loop iteration is generated for each row of data, in which the values of the data set are bound to QF‑Test variables named according to the data column titles. They can be accessed via the syntax $(column title). When run in batch mode (see Starting QF‑Test) QF‑Test clears the resources and properties before the execution of each test given with the -test <n>|<ID> command line argument. In interactive mode, QF‑Test keeps them around to ease building a suite, but for a true trial run you should clear them via the »Run«-»Clear resources and properties« menu first.","hash":"usec_externaldata","h1":"External data"},"238":{"id":238,"content":"Special groups The following variable groups are always available. Their values can be accessed via the syntax ${group name:variable name}, or rc.groups.group.variable in scripts. system The group system gives access to the system properties of the Java VM (for programmers: java.lang.System.getProperties()), e.g. ${system:user.home} for the user's home directory or ${system:java.class.path} for the class path with which QF‑Test was started. Which names are defined in the group system depends on the utilised JDK. The group always refers to the VM QF‑Test was started with, because variable expansion takes place there. env On operating systems which support environment variables like PATH, TMP or JAVA_HOME (practically all systems QF‑Test runs on), these environment variables can be accessed with the help of the group env. decrypt Via the decrypt group you can temporarily decrypt a string for the further usage in QF‑Test, e.g. for text field inputs, API tokens or database passwords. In the run log, QF‑Test will replace the expanded value by the placeholder ***. A value in a Set variable step can be encrypted by right-clicking and selecting »Encrypt text« from the popup menu. For specific values in QF‑Test steps the run log always contains the final value. Please inspect the final run log before sharing it. Also pay attention to the remarks for the Salt for crypting passwords option. default You can specify a default value for a variable with the group default. The syntax is ${default:varname:defaultvalue}. This is extremely useful for things like generic components or in almost every place where there is a reasonable default for a variable because the default value is then tightly coupled with the use of the variable and doesn't have to be specified at Sequence or test suite level. Of course you should only use this syntax if the variable lookup in question is more or less unique. If you are using the same variable with the same default in different places it is preferable to use normal syntax and explicitly set the default, so that the default for all values can be changed in a single place. as Like in a Set variable oder Return step it is possible to change the typ of an object using the as group. The syntax is ${as:type:value}, whereas it is possible to reference values from variables in value using $(...). Valid values for type are: string, str, boolean, number, object, pattern, int, integer, long, float, double, cmdline, and json. id The group id can be used to reference QF‑Test component IDs. Values in this group simply expand to themselves, i.e. \"${id:whatever}\" expands to \"whatever\". Though QF‑Test component IDs can be referenced without the help of this group, its use increases the readability of tests. Most notably however, QF‑Test component ID references in this group will be updated automatically in case the referenced target component gets moved or its QF‑Test ID changed. idlocal The group idlocal is similar to the id group but includes the path to the current test suite, i.e. \"${idlocal:x}\" expands to \"path/to/current/suite/suite.qft#x\". This enforces use of the component referenced in the suite that is current at the time of expansion, irrespective of whether there is a component with the same %attId; in the target suite of a procedure call. quoteitem Via the quoteitem group you can conveniently escape special characters like '@', '&' and '%' in the name of a textual sub-item index to prevent it from being treated as several items, e.g. \"${quoteitem:user@host.org}\" will result in \"user\\@host.org\". quoteregex, quoteregexp The group quoteregex with its alias quoteregexp can be used to escape characters with special meaning in Regular expressions. This is often useful when building regular expressions dynamically or when referencing subitems with special characters in their name by a regular expression index, e.g. \"componentid%${quoteregex:foo(baa)}.*\" allows you to address the first occurrence of items beginning with 'foo(baa)'. quotesmartid The quotesmartid group is similar to quoteitem. In addition to the item syntax special characters '@', '&' and '%' it also escapes the characters ':', '=', '<' and '>' that have special meaning in SmartIDs, e.g. \"${quotesmartid:Name: A & B}\" will result in \"Name\\: A \\& B\". qftest The special group named qftest provides miscellaneous values that may be useful during a test run. The following tables list the values currently defined.","hash":"usec_special_groups","h1":"Special groups"},"239":{"id":239,"content":"The special group named qftest provides miscellaneous values that may be useful during a test run. The following tables list the values currently defined. Name Meaning 32 or 32bit No longer relevant because support for 32bit Java for QF‑Test was dropped in version 8.0 true if QF‑Test is running in a 32bit Java VM - which is not the same as running on a 32bit Operating System - false otherwise. 64 or 64bit No longer relevant because support for 32bit Java for QF‑Test was dropped in version 8.0 true if QF‑Test is running in a 64bit Java VM, false otherwise. batch true if QF‑Test is running in batch mode, false for interactive mode. client.baseEngineName.<name> The base name of the primary engine of the client started with the Client attribute set to <name>, e.g. fx. client.browser.<name> The name/type of the browser of the client started with the Client attribute set to <name>, e.g. safari. Only available for Web clients. client.connectionMode.<name> The name of the connection mode of the client started with the Client attribute set to <name>. Possible values are qfdriver, cdpdriver, webdriver, and embedded. Only available for Web clients. client.engine.<name> The primary engine of the client started with the Client attribute set to <name>. The result consists of the base name of the engine and a numerical index, e.g. fx0. client.engineNames.<name> A list of all connected engines of the client started with the Client attribute set to <name>, e.g.[fx0, web_fx0]. client.exitCode.<name> The exit-code of the last process started with the Client attribute set to <name>. In case the process is still alive the result is the empty string. client.deviceName.<name> A name for the (emulated) device started with the Client attribute set to <name>. Only available for Android clients after instrumentation, for emulated devices equal to the AVD name. client.deviceType.<name> The type of the (emulated) device started with the Client attribute set to <name>. Can be emulator for an emulation and device for a connected real device. Only available for Android clients after instrumentation. client.mainVersion.<name> The main version of the browser or device operating system of the client started with the Client attribute set to <name>, e.g. 121. Only available for Web clients after first browser open and for Android clients after instrumentation. client.output.<name> The output of the last process started with the Client attribute set to <name>. The maximum size for buffered output is defined by the option Maximum size of client terminal (kB). client.SDKVersion.<name> The SDK version of the device operating system of the client started with the Client attribute set to <name>, e.g. 121. Only available for Android clients after instrumentation. client.stdOut.<name> The output on the standard output stream (stdout) of the last process (started with the Client attribute set to <name>). The maximum size for buffered output is defined by the option Maximum size of client terminal (kB). client.stdErr.<name> The output on the standard error stream (stderr) of the last process (started with the Client attribute set to <name>). The maximum size for buffered output is defined by the option Maximum size of client terminal (kB). client.version.<name> The version of the browser or device operating system of the client started with the Client attribute set to <name>, e.g. 121.10.2967.10. Only available for Web clients after first browser open and for Android clients after instrumentation. clients A list of the names of all active process clients, separated by a newline. clients.all A list of the names of all process clients, separated by a newline. This includes live clients as well as the recent dead clients similar to those listed in the \"Clients\" menu. count.exceptions Number of exceptions in the current test run. count.errors Number of errors in the current test run. count.warnings Number of warnings in the current test run. count.testCases Total number of total test cases (run and skipped) in the current test run. count.testCases.exception Number of test cases with exceptions in the current test run. count.testCases.error Number of test cases with errors in the current test run. count.testCases.expectedToFail Number of test cases expected to fail in the current test run. count.testCases.ok Number of successful test cases in the current test run. count.testCases.ok.percentage Percentage of successful test cases in the current test run. count.testCases.skipped Number of skipped test cases in the current test run. count.testCases.notImplemented Number of not implemented test cases in the current test run. count.testCases.run Number of run test cases in the current test run. count.testSets.skipped Number of skipped test sets in the current test run. dir.cache Cache directory of QF‑Test dir.groovy Directory of Groovy dir.javascript Directory of JavaScript dir.jython Directory of Jython dir.log Log directory of QF‑Test dir.plugin Plugin directory of QF‑Test dir.root Root directory of QF‑Test dir.runlog Run log directory of QF‑Test dir.system System-specific configuration directory of QF‑Test. dir.user User-specific configuration directory of QF‑Test dir.version Version-specific directory of QF‑Test engine.<componentId> Retrieves the GUI engine responsible for the given component (see GUI engines). language The language in which QF‑Test displays its graphical user interface. license The path to the license file systemCfg The path to the system configuration file userCfg The path to the user specific configuration file executable The qftest executable matching the currently running QF‑Test version, including the full path to its bin directory and with .exe appended on Windows. Useful if you need to run QF‑Test from QF‑Test for example to call a daemon or create reports. isInRerun \"true\", if current execution is in rerun mode, \"false\" otherwise, see Rerunning failing nodes immediately. isInRerunFromLog \"true\", if test run has been re-started from run log, \"false\" otherwise, see Triggering rerun from a run log. java Standard Java program (javaw under Windows, java under Linux) or the explicit Java argument if QF‑Test is started with -java <executable> (deprecated) java.mainVersion The major version of the JRE that QF‑Test currently runs on, using 8 for Java 1.8 so the result is something like 8, 11 or 17. java.subVersion The sub-version of the JRE that QF‑Test currently runs on. For Java 8 the sub-version taken from after the '_', so for java.version 1.8.0_302 this results in 302. For Java 9 or higher this is the minor version, e.g. 9 in case of java.version 11.0.9. linux \"true\" under Linux, \"false\" otherwise macOS \"true\" under macOS, \"false\" otherwise os.fullVersion The whole version of the operating system os.mainVersion The main version of the operating system, e.g. \"10\" for Windows 10 os.name The name of the operating system os.version The version of the operating system. In some cases that's not the whole one then you should use os.fullversion instead. project.dir The directory to the current project. This variable is not defined in case the current test suite is not part of a project. rerunCounter Number of current rerun attempt, default is 0, for details see Rerunning failing nodes immediately. return The most recent value returned from a Procedure through a Return node. runID The runid of the current test run. See Reports for further information about the runid. screen.height Screen height in pixels screen.width Screen width in pixels skipNode This magic value is not for the casual user. It causes QF‑Test to skip execution of the current node. Its primary use is as the value for a variable defined in the Text attribute of a Text input node which also has its Clear target component first attribute set. An empty value would clear the field whereas $_{qftest:skipnode} leaves the field unchanged. But skipnode is also applicable for fine-grained execution control by placing a variable in the comment of a node and selectively passing $_{qftest:skipnode} to that variable. Please note that you almost always want to use lazy syntax '$_' with this variable. Otherwise its expansion as the parameter in a Procedure call node would cause skipping the whole call. suite.dir Directory of the current suite suite.file As string, the file name of the current suite without directory. If accessed as Object, the File object of the current suite. suite.path File name of the current suite including directory suite.name Get the name of the current test suite. testCase.name The name of the current Test case, empty if no Test case is currently being executed. testCase.id The QF‑Test ID of the current Test case, empty if no Test case is currently being executed. testCase.qName The qualified name of the current Test case, including the names of its parent Test sets. Empty if no Test case is currently being executed. testCase.reportName The expanded report name of the current Test case, empty if no Test case is currently being executed. testCase.splitLogName The qualified name of the current Test case converted to a filename, including the names of its parent Test sets as directories. Empty if no Test case is currently being executed. testSet.name The name of the current Test set, empty if no Test set is currently being executed. testSet.id The QF‑Test ID of the current Test set, empty if no Test set is currently being executed. testSet.qName The qualified name of the current Test set, including the names of its parent Test sets. Empty if no Test set is currently being executed. testSet.reportName The expanded report name of the current Test set, empty if no Test set is currently being executed. testSet.splitLogName The qualified name of the current Test set converted to a filename, including the names of its parent Test sets as directories. Empty if no Test set is currently being executed. testStep.name The name of the current Test step, empty if no Test step is currently being executed. testStep.qName The qualified name of the current Test step, including the names of its parent Test steps, but not including Test cases or Test sets. Empty if no Test step is currently being executed. testStep.reportName The expanded report name of the current Test step, empty if no Test step is currently being executed. thread The index of the current thread. Always 0 except if QF‑Test is started with the argument -threads <number>. threads The number of parallel threads. Always 1 except if QF‑Test is started with the argument -threads <number>. version QF‑Test version version.build QF‑Test build number name The name of the QF‑Test edition windows \"true\" under Windows, \"false\" otherwise Table 6.1: Definitions in the special group qftest","hash":"table_6.1","h1":"Special groups"},"240":{"id":240,"content":"Immediate and lazy binding There is a very subtle issue in using QF‑Test variables that requires further explanation: When a new set of variable bindings is pushed on one of the variable stacks, there are two possibilities for handling variable references in the value of a binding, for example when the variable named 'x' is bound to the value '$(y)'. The value '$(y)' can be stored literally, in which case it will be expanded some time in the future when '$(x)' is referenced somewhere, or it can be expanded immediately, so that the value of the variable 'y' is bound instead. The first approach is called 'lazy' or 'late binding', the second approach 'immediate binding'. The difference, of course, is the time and thus the context in which a variable is expanded. In most cases there is no difference at all, but there are situations where it is essential to use either lazy or immediate binding. Consider the following two examples: A utility test suite contains a procedure for starting the SUT with different JDK versions. The variable 'jdk' is passed as a parameter to this procedure. For ease of use, the author of the test suite defines some additional useful variables at test suite level, for example a variable for the java executable named 'javabin' with the value '/opt/java/$(jdk)/bin/java'. At the time 'javabin' is bound in the test suite variables, 'jdk' may be undefined, so immediate binding would cause an exception. But even if 'jdk' were bound to some value, immediate binding would not have the desired effect, because the java executable is supposed to be the one from the JDK defined later by passing the parameter 'jdk' to a procedure. Thus lazy binding is the method of choice here. Imagine another utility test suite with a procedure to copy a file. Two parameters called 'source' and 'dest' specify the source file and destination directory. The caller of the procedure wants to copy a file called 'data.csv' from the same directory as the calling test suite to some other place. The natural idea is to bind the variable 'source' to the value '${qftest:suite.dir}/data.csv' in the procedure call. With immediate binding, '${qftest:suite.dir}' will indeed expand to the directory in which the calling suite resides. However, if lazy binding were used, the actual expansion would take place inside the procedure. In that case, '${qftest:suite.dir}' would expand to the directory of the utility suite, which most likely is not what the caller intended. In versions of QF‑Test up to and including 2.2 all variable expansion was lazy. As the examples above show, both variants are sometimes necessary. Since immediate binding is more intuitive it is now the default. This can be changed with the option When binding variables, expand values immediately. The option Fall back to lazy binding if immediate binding fails complements this and helps to ease migration of old test suites to the use of Immediate Binding. The warnings issued in this context help locating the few spots where you should use explicit lazy binding as described below. Except for very rare cases where lazy binding is required but immediate binding also works so that the fallback is not triggered, all tests should work out of the box. In the few cases where it makes a difference whether a variable is expanded immediately or lazily, the expansion of choice can be selected individually, independent of the setting of the above option, by using an alternative variable syntax. For immediate binding use '$!' instead of just '$'. Lazy binding is selected with '$_'. For example, to define a variable at test suite level that specifies a file located in this test suite's directory, use '$!{qftest:suite.dir}/somefile'. If immediate binding is the default and you require lazy binding as in the 'jdk' example above, use '$_(jdk)'. With lazy binding the order of variable or parameter definitions in a node or a data driver did not matter because nothing was expanded during the binding stage. With immediate bindings, variables are expanded top-to-bottom or, in a data driver, left-to-right. This means that if you define x=1 and y=$(x) it will work, with y being set to 1, if x is defined first. If y is defined first the definition will either fail or trigger the lazy definition fallback described above.","hash":"usec_immediatebindings","h1":"Immediate and lazy binding"},"241":{"id":241,"content":"Mobile Manual","hash":"","h0":"Problem analysis and debugging | QF‑Test Manual"},"242":{"id":242,"content":"Mobile Manual","hash":"home-link","h0":"Problem analysis and debugging | QF‑Test Manual"},"243":{"id":243,"content":"Problem analysis and debugging The whole point of creating automated tests is to uncover problems in the SUT. Therefore we can justifiably expect the tests to fail occasionally. After the execution of a test has finished, a message will appear in the status line that will hopefully say \"No errors\". If something went wrong, the numbers of warnings, errors and exceptions that occurred is shown. Additionally an error dialog may pop up. In that case you will need to find out what went wrong. For some problems the cause may be obvious, but very often it is not. First and foremost in this case is the need to determine whether the test failed due to a bug in the SUT or whether the SUT behaved correctly but the logic of the tests was wrong. The dilemma here is that any potential problem in the SUT must be duly reported as soon as possible, yet every false bug report is a waste of time and will cause resentment among the developers. Therefore, each problem needs to be thoroughly analyzed and every alleged bug in the SUT should ideally be reproducible before a report is submitted. QF‑Test supports testers in this crucial task in two ways. A detailed log is created for each test run that holds all the relevant information for post mortem error analysis, including screenshots taken at the time that an error occurred. The integrated test debugger helps with analyzing and understanding the flow of control and information during a test run. The video 'Error analysis' shows a brief example for error handling.","hash":"usec_debugging","h0":"Problem analysis and debugging"},"244":{"id":244,"content":"The run log During test replay QF‑Test creates a run log that records everything that is going on. The run logs for recent tests are accessible from the »Run« menu, the current or most recent run log can also be opened by typing Ctrl⁠+⁠L or the respective button in the toolbar. See \"Run log options\" for information about options influencing run log creation. The structure of a run log is similar to that of a test suite, but there are subtle differences. Nodes are added to the run log when they are executed. Setup and Cleanup nodes, for example, are typically executed more than once, in which case multiple copies will be recored in the run log as shown below:","hash":"usec_runlog","h1":"The run log"},"245":{"id":245,"content":"Test suite Run log Figure 7.1: A simple test and its run log A run log is the essential resource for determining what went wrong in a test, where it went wrong and maybe even get an idea about why it went wrong. Therefore the emphasis is on completeness of information rather than readability and a run log should not be confused with a report or summary. Report generation is covered in \"Reports and test documentation\". In addition to the nodes copied from the test suite, a run log contains failure information, optional annotations, various kinds of messages as well as information about variable expansion and run-time behavior. The information gathered from a long test run accumulates and can eat up enormous amounts of memory and QF‑Test has several means to cope with that. The best one, which is also the default, is to create split run logs as described in \"Split run logs\". The resulting *.qzp files in ZIP format not only preserve memory on disk - partial run logs can be saved during test execution and removed from memory to free up necessary space. The same applies when processing logs, e.g. for report creation. The older option Create compact run log as well as the alternative file formats *.qrz and *.qrl add flexibility but are mostly retained for compatibility reasons.","hash":"figure_7.1","h1":"The run log"},"246":{"id":246,"content":"Error states There are three kinds of failures differing in the level of severity: Warnings Warnings indicate problems that are typically not serious, but might lead to trouble in the future and may need looking at. For example, QF‑Test issues a warning, if the best match for a component barely meets the requirements and differs in some significant way. Errors Errors are considered to be serious defects that require closer inspection. They indicate that the SUT does not fulfill some requirement. A typical cause for an error is a mismatch in a Check text node. Exceptions Exceptions are the most serious kinds of errors. An exception is thrown when a situation occurs in which QF‑Test cannot simply continue with the execution of the test. Most exceptions indicate problems with the logic of the test, though they can just as well be caused by the SUT. A ComponentNotFoundException, for example, is thrown when no component in the SUT matches the intended target for an event. A list of all possible exceptions is available in \"Exceptions\". Each node of a run log has an associated state which can be one of normal, warning, error or exception. This state is visually represented by a frame around the node's icon which is orange for warning, red for error and bold red for exception.","hash":"sec_error_states","h2":"Error states"},"247":{"id":247,"content":"Figure 7.2: Error states in a run log As shown in the (somewhat reduced) screenshot above, error states propagate from bottom to top. The exception state takes precedence over the error state, which in turn overrides warning. The most severe kind of error that propagates to the top of the tree determines the final result of a test and QF‑Test's exit code when run in batch mode (see \"Exit codes for QF‑Test\"). If necessary, the propagation of errors can be restricted for all kinds of Sequence nodes with the help of the Maximum error level attribute. This can be useful for sequences which are known to contain errors that should not be taken into account just yet. Exceptions can be handled with the help of the Try and Catch nodes. The Maximum error level attribute of the Catch node determines the state to propagate for a caught exception.","hash":"figure_7.2","h4":"Figure 7.2: Error states in a run log"},"248":{"id":248,"content":"Navigating the run log tree All of the basic editing methods for a run log are similar to those for a test suite. One significant difference is that can neither add or remove any nodes nor edit the attributes of the nodes copied from the test suite. You can add annotations though, for example to document the reason for an error if it is known. The first question to answer when looking at a run log is \"What happened\"? The Button, or »Edit«-»Find next error«, Ctrl⁠+⁠N for short, moves the selection to the next place at which an error actually occurred. Respectively, or »Edit«-»Find previous error« (Ctrl⁠+⁠P) moves backwards. The option Skip suppressed errors determines whether to ignore errors that didn't propagate up to the root node. There's a menu item shortcut »Edit«-»Skip suppressed errors« to quickly toggle the latter option. The next question might be \"Where did this happen?\". Though a run log is similar in many ways to a test suite, the connection isn't always obvious. The function »Edit«-»Find node in test suite« (Ctrl⁠+⁠T) will take you to the exact node in the test suite that is represented by the selected node in the run log, always provided that the test suite can be located and hasn't changed in a way that prevents this. If the run log is loaded from a file, the corresponding test suite may not be located at the same place as when the test was executed. If the test suite cannot be found, a dialog will pop up that lets you select a different file. In case you select a wrong file or some other test suite is found instead of the one the run log was created from, you may end up at some totally different node, or none at all. In that case you can use the menu item »Edit«-»Locate corresponding test suite« to explicitly change the test suite. If you want to set the link between the file path of the executed test suite and the file path where you develop the test suite permanently you can do so in the options menu for the log-file as explained in Directory map for test suites.","hash":"usec_lognavigation","h2":"Navigating the run log tree"},"249":{"id":249,"content":"Run-time behavior QF‑Test tracks the start time and the time spent for each node executed during a test, the latter in two forms: 'Real time spent' is the wall time elapsed between entry and exit of the respective node. It includes explicit delays introduced in nodes via the 'Delay before/after' attribute, user interrupts when debugging tests or other overhead like taking screenshots. The actual time spent testing is collected in the 'Duration' attribute, making it a better indicator for the performance of the SUT. To get a better understanding of the run-time behavior of a test run you can activate display of duration indicators via the toolbar button , the menu »View«-»Show relative duration indicators« or the option Show relative duration indicators. A colored bar is shown for each node with the length based on the percentage of time spent in the node relative to the time of its parent node. Bottlenecks in the performance of a test run can be located by drilling down into the nodes with the longest bars:","hash":"usec_runtimebehavior","h2":"Run-time behavior"},"250":{"id":250,"content":"Figure 7.3: Display of duration indicators in the run log Via the option Duration indicator kind or the sub-menu »View«-»Duration indicator kind« the display can be toggled to show the relative duration, real time or both. The latter is especially helpful but takes a bit of getting used to.","hash":"figure_7.3","h4":"Figure 7.3: Display of duration indicators in the run log"},"251":{"id":251,"content":"Showing return values If the option Show return values of procedures is active (in a run log also accessible via the »View« menu), return values of Procedures are displayed in the tree after the respective Procedure call node.","hash":"usec_procret","h2":"Showing return values"},"252":{"id":252,"content":"Accepting values of failed checks as good A noteworthy feature of QF‑Test's run log is the ability to quickly accept the actual values of a failed Check node as good. When QF‑Test logs a failed Check it includes the complete current state of the Check node's target component in the SUT. This is much more useful than the failure message alone, which, for example, might just tell you that a table column has 10 rows instead of the expected 9, but not what its contents are. If you are analyzing a failed Check and see that the value in the SUT was actually correct and the expected value stored in the test suite wrong, you can press Ctrl⁠+⁠U or select »Update check node with current data« from the context menu to accept the data from the failed Check as the new correct value for the Check node. Warning: QF‑Test currently doesn't preserve regular expressions in Check text or Check items nodes, they will simply get overwritten.","hash":"usec_acceptcheck","h2":"Accepting values of failed checks as good"},"253":{"id":253,"content":"Split run logs Run logs for long-running tests can get very large and consume an enormous amount of memory, even more so in case many screenshots are kept. Compact run logs can help, but not enough to make tests that run for days on end possible without turning off the run log entirely. The best way to overcome the memory problem are split run logs. For split run logs, whenever a certain part of a test has finished, QF‑Test takes the run log for that part, removes it from the main run log, saves it to a separate file and replaces it with a single node that references that file. The partial logs are complete run logs in themselves and can be viewed and archived independently, though normally they are accessed through the main run log. When navigating the main run log or when creating reports, QF‑Test transparently loads the partial run logs from the separate files as required and removes them from memory when no longer needed. This makes it possible to navigate huge run logs while still retaining a relatively small memory footprint. Of course operations like searching or report creation that need to traverse the whole run log become slower, but jumping from error to error remains quite fast and loading the main run log is sped up drastically. There are two ways for storing a main run log and its partial logs: All combined together in a single ZIP file with the extension .qzp or with the partial logs in a separate directory. The latter is named after the main run log with the extension .qrl or .qrz removed and the suffix _logs appended. Inside a .qzp ZIP file the same layout is used so that it is possible to zip or unzip files manually without breaking the internal references in the run log. This compatibility is also the reason why by default partial logs inside the ZIP are are stored compressed with the extension .qrz. This is slightly less efficient than storing uncompressed .qrl files, but that way a .qzp run log can be unzipped without its overall size exploding. To make use of split run logs you can explicitly define points at which a run log is broken and split into parts. This is done via the Name for separate run log attribute of Data driver, Test case, Test set, Test call or Test step nodes. When used with a Data driver, the logs for each iteration are saved separately, in the other cases the node with the Name for separate run log attribute is split off. Otherwise partial run logs are split off automatically when they reach a certain size. This functionality can be configured via the option Minimum size for automatic splitting (kB). When working with split run logs it is advisable to turn Create compact run log off, in order to keep all details in the run log. This will consume a bit more disc space, but is very helpful when analyzing errors. Split run logs are also very handy for tracking the progress of a test in batch mode. In that context it is extremely useful that the file names for the partial logs can be created using the same placeholders as when specifying the name of the main run log on the command line. In particular the error state of the partial log can be made part of its filename. Please see the documentation for the attribute Name for separate run log for details.","hash":"usec_splitlogs","h2":"Split run logs"},"254":{"id":254,"content":"Run log options There are several options affecting the creation of run logs and their content. Among others, you can choose whether to create compact or detailed run logs, whether to log screenshots of the whole screen and/or the client windows or whether to suppress run logs altogether. All options are explained in detail in \"Run log options\".","hash":"usec_logoptions","h2":"Run log options"},"255":{"id":255,"content":"Creating a test suite from the run log If several people are involved in the test development process, it might be useful to generate a test suite from the run log directly. The generated test suite could be used to reproduce a test run on-the-fly without having the entire structure of test suites. You can create a test suite from the run log via performing a right mouse click at any node in the run log and selecting »Create test suite« from the context menu. QF‑Test creates a new file containing all executed steps of the respective tests under Extras as well as the used components. QF‑Test only adds the executed steps to the new test suite. Variables will be expanded immediately, so you can only see their value in the new file. Organizational nodes like procedures or control structures will not become created. You have to set a couple of options in order to get this feature properly working (Under Run log -> Content): Create compact run log needs to be switched off. Log variable expansion needs to be switched on. Log parent nodes of components needs to be switched on. If you have access to all test suites, you can use also use information from them for creating the new one. Therefore select »Create test suite from existing structure« from the context menu. In contrast to the approach described above, it is not required to switch on the option Log parent nodes of components.","hash":"usec_logcreatetestsuite","h2":"Creating a test suite from the run log"},"256":{"id":256,"content":"Merging run logs During test development you might face the requirement, that you have a run log with the test results for your test-cycle. But in several cases you might need to rerun one test case which was failing due to subtle reasons during the previous test run. Once that rerun has taken place you would like to update your test-report to have that new execution in that test-report instead the previous one. For this purpose it's possible to merge run logs via command line. A typical merge command looks like this: qftest -batch -mergelogs -mergelogs.mode=replace -mergelogs.masterlog full_log.qzp -mergelogs.resultlog newresult_log.qzp rerun.qzp Example 7.1: Sample call of merging run logs for update The command above takes the result of the rerun from the run log rerun.qzp, searches for the test case in the run log full_log.qzp and store the updated run log to newresult_log.qzp. If you set the parameter mergelogs.mode to merge the new test cases will be added to the existing structure and the original test cases will remain in the run log. Another case might be to add run logs of several test runs into one large run log in order to get a more readable report. This kind of merging is also implemented and can be achieved by another command line call like this: qftest -batch -mergelogs -mergelogs.mode=append -mergelogs.resultlog newresult_log.qzp run1.qzp run2.qzp Example 7.2: Sample call of merging run logs for adding The call above takes the run logs run1.qzp and run2.qzp and creates a run log newresult_log.qzp which contains the results from both run logs. In this mode the parameter mergelogs.masterlog is optional. If the parameter is set, the corresponding run log will be used as a root for a resulting run log.","hash":"usec_mergerunlogs","h2":"Merging run logs"},"257":{"id":257,"content":"The debugger As in any development environment, at some point the need will arise to debug problems introduced into a test suite which cannot readily be solved by a straight-forward analysis of the elements and structure of the suite. To this end, QF‑Test includes an intuitive debugger. Those of you familiar with debugging programs in Java or other programming languages will find this debugger similar in function and usefulness.","hash":"usec_debugger","h1":"The debugger"},"258":{"id":258,"content":"Entering the debugger The QF‑Test debugger can be started directly by selecting a node (or some nodes) to execute and pressing the step-in or step-over buttons, or by using the menu operations »Debugger«-»Step in« and »Debugger«-»Step over« or the keyboard shortcuts F7 and F8. See \"Debugger commands\" for a detailed explanation of these operations. If you are running tests on your test suite and use the play button to start execution (see \"Running tests\"), the debugger will normally not be entered. However, the debugger will be activated automatically when any one of the following occur: A user-defined breakpoint is reached (see \"Manipulating breakpoints\" on turning on/off breakpoints). Execution is interrupted manually by pressing the pause button or F9 or selecting the »Run«-»Pause« menu item. A caught or uncaught exception is thrown, an error happens or a warning is logged and the respective option to break under that condition is set (see option Automatic breaks). When the debugger suspends execution of the test, the node about to be executed will be shown with a colored frame around its icon that reflects the cause for the break. If the debugger is stopped due to manual intervention, a user breakpoint or when stepping, the frame will be black. When stopping due to a warning, error or exception the frame will be orange, red or thick red respectively, exactly like the error indicators in the run log. When the debugger is entered due to a warning, error or exception it will move execution back to the beginning of the node that caused it, giving you a chance to fix the cause of the problem and re-execute that node. If this is undesirable or impossible you can simply skip the node (see \"Debugger commands\"). In the default workbench mode the debugger will be integrated into the normal test suite view. For non-workbench mode please refer to The debugger window.","hash":"sec_entering_the_debugger","h2":"Entering the debugger"},"259":{"id":259,"content":"Displaying the current variable values In debugging mode the Variables and their values for the current point of test execution will be displayed in the lower part of the test suite window. The list has two parts: the primary (top part) and the fallback variable stacks. Variables with the same name can be bound by any number of nodes. The value actually used in the test is determined by the order of the nodes, top-down. This means when several nodes bind variables with the same name the value of the one which is furthest up the list will be used. A single click on a node brings up its variable bindings in the right half of the variable display. There, the variable values can be edited, new variables can be added or existing ones removed. These changes immediately affect the current test run, but are of a temporary nature. They are not propagated to the nodes in which the variables were bound in the first place. The variable value is always a String after editing. You can double-click on the node in the variable definitions list to quickly navigate to the node in its associated test suite to set the value permanently. The variable values are strings by default. In case a variable has a different type you will see it surrounded by brackets before the actual value. When you edit a value in the variable definitions list please be aware it will automatically be transformed to a string - recognizable by the parenthesis indicating the type having disappered. For the primary stack all nodes are shown, even if they are not binding any variables, for the secundary stack only the nodes binding variables. With the option »View«-»Terminal«-»Prefer tree over terminal« you can control whether variables definitions will fill the whole bottom part of the test suite window or only the right part below the node details.","hash":"usec_debugger_variable_stack","h2":"Displaying the current variable values"},"260":{"id":260,"content":"Debugger commands Most of the debugger commands are similar to those of any other debugger. However, some additional commands are included that deal with special situations. Step-wise debugging of a test suite is available through three operations: The step-in button (F7, »Debugger«-»Step in«) executes the currently selected node and will set the execution mark to the next deepest node, regardless of how deep that node may lie in the node structure. This operation is useful, for example, to step into and debug a Procedure or Sequence. The step-over button (F8, »Debugger«-»Step over«) executes the currently selected node as well as any child nodes that lie under it and then sets the execution mark to the next node at the same level. This is helpful for being able to execute an entire Procedure or Sequence without stepping through each step individually. The step-out button (Ctrl⁠+⁠F7, »Debugger«-»Step out«) executes the currently selected node as well as any other nodes at the same level (including any child nodes of these nodes) and then sets the execution mark to the next node at the next higher level. This type of operation is useful when, for example, you are debugging a Procedure or Sequence and don't want to step through the rest of the nodes in it. By simply using step-out, you can execute the rest of the nodes and return. The skip functions expand the QF‑Test debugger in a powerful way which is not typically possible for a debugger in a standard programming environment. In short, they allow you to jump over one or more nodes without having to execute those nodes at all. The skip-over button (Shift⁠+⁠F9, »Debugger«-»Skip over«) jumps over the current node without executing it, moving the execution mark to the next node. The skip-out button (Ctrl⁠+⁠F9, »Debugger«-»Skip out«) ends the execution of the current Procedure or Sequence and jumps to the next node at the next higher level. Even more powerful is the ability to continue the test run at any arbitrary node, even in a completely different test suite. QF‑Test will keep as much of the current execution context as possible, including variable bindings. The closer the new target location is to the current point of execution, the more information can be salvaged. You can switch execution to a different node by pressing Ctrl⁠+⁠, or by selecting the menu item »Run«-»Continue execution from here« or the respective item in the context menu. When you do so, execution will not continue immediately, only the next node to be executed will change. You can continue the test as usual by single-stepping or resuming the test run. The following additional commands are available: The rethrow-exception button (»Debugger«-»Rethrow exception«) is only active when the debugger was entered due to an exception. It lets you rethrow the exception to be handled by the test suite just as if the debugger had never caught it in the first place. The locate-current-node button (»Debugger«-»Locate current node«) quickly moves the selection in the tree-view to the node that is about to be executed. It is a useful shortcut in case you get lost while moving around the test suite.","hash":"usec_dbgcommands","h2":"Debugger commands"},"261":{"id":261,"content":"Manipulating breakpoints Setting a breakpoint on a node will tell the debugger to suspend execution just before it enters that node. Breakpoints are displayed in the tree-view by prepending \"(B)\" to the name of a node. Breakpoints can be set or removed individually with Ctrl⁠+⁠F8 or with the »Debugger«-»Breakpoint on/off« menu item. After finishing a debugging session you can use »Debugger«-»Clear all breakpoints« to remove any breakpoints that might have been left hanging around. This command will remove all breakpoints from all test suites. Breakpoints are transient and will not be saved with the test suite.","hash":"usec_dbgbreak","h2":"Manipulating breakpoints"},"262":{"id":262,"content":"The debugger window When you are not working in workbench mode (Activate workbench view) the debugger has to be run in a dedicated debugger window by selecting »Debugger«-»Show debugger window« once the debugger has been entered. The debugger can be run either from within the normal test suite view, or by opening a dedicated debugger window by selecting »Debugger«-»Show debugger window« once the debugger has been entered. You can also cause the debugger window to open automatically whenever the debugger is entered by setting the option Always open debugger window in the global options dialog or under the »Debugger«-»Options« menu. If you open or close the debugger window explicitly, this is considered a \"manual override\" and this option will be ignored for the rest of the test run. The debugger window is similar to a normal test suite window. You can select nodes and edit their attributes, but you cannot delete or insert nodes, there are no file operations and no recorder. For the more complex operations you can quickly jump from the debugger window to the same node in the respective test suite window by pressing Ctrl⁠+⁠T or selecting »Find node in test suite« from the »Edit« menu or the context menu.","hash":"usec_debuggerwindow","h2":"The debugger window"},"263":{"id":263,"content":"Mobile Manual","hash":"","h0":"Organizing the test suite | QF‑Test Manual"},"264":{"id":264,"content":"Mobile Manual","hash":"home-link","h0":"Organizing the test suite | QF‑Test Manual"},"265":{"id":265,"content":"Organizing the test suite Creating useful, reliable tests requires more than just recording sequences and playing them back. You can fill a test suite with lots of sequences in a short time, but you are bound to lose track of what you've got sooner or later if you do not organize your tests in some logical structure. QF‑Test provides you with a number of structure elements to achieve this. Before you start recording sequences and put them into a structure make sure that you You have a good idea of what you are testing. You are testing the right thing. Your tests are reliable and repeatable. Your tests are easy to maintain. The results of your tests are conclusive. The essential prerequisite of getting the components right has been discussed in \"Components\". Here we are going to concentrate on structuring the actual test sets, test cases, test steps, sequences, events, checks, etc.","hash":"usec_organization","h0":"Organizing the test suite"},"266":{"id":266,"content":"Test suite structure","hash":"usec_testsuite_structure","h1":"Test suite structure"},"267":{"id":267,"content":"Figure 8.1: Test suite structure QF‑Test provides structure elements on different levels: The QF‑Test files for saving the tests and components in the file directory. These can be bundled in projects. The Test suite has a set structure starting with the testing section that can hold any number of Test set nodes, which in turn can have any number of Test case nodes or more Test sets. Next comes the Procedures section, where you can place any number of Procedure nodes. QF‑Test provides Package nodes as structure element in this section. A package node can hold any number of procedure nodes or more package nodes. After that you will find the Extras where you place any type of node and try out tests before moving them to the testing section. The last section, Windows and components, is reserved for the components referenced by the tests. QF‑Test provides a number of structure elements for the tests themselves like Test case and Test set nodes as well as Setup and Cleanup nodes for setting up the preconditions for the tests, cleaning up after the test and error handling.","hash":"figure_8.1","h4":"Figure 8.1: Test suite structure"},"268":{"id":268,"content":"Test set and Test case nodes","hash":"usec_testcase","h1":"Test set and Test case nodes"},"269":{"id":269,"content":"Test management with Test set and Test case nodes The Test set and Test case nodes provide a small-scale, pragmatic form of test management right inside QF‑Test. Their main feature is the smart dependency management described in Dependency nodes that allows Test cases to be implemented completely independent from each other. With properly written Dependencies, cleanup of the SUT for previously executed tests is handled automatically along with the setup for the next test and all error handling.","hash":"usec_testcase_management","h2":"Test management with Test set and Test case nodes"},"270":{"id":270,"content":"Concept Conceptually a Test case node represents a single elementary test case. As such it is the main link between test planning, execution and result analysis. With the help of Dependencies, Test cases can be isolated from each other so that they can be run in any arbitrary order. QF‑Test automatically takes care of the necessary test setup. Cleanup is also automatic and will be performed only when necessary in order to minimize overhead in the transition from one test to the next. This enables things like running subsets of functional test suites as build tests or retesting only failed Test cases. Test sets basically are bundles of Test cases that belong together and typically have similar requirements for setup and cleanup. Test sets can be nested. The whole structure of Test sets and Test cases is very similar to Package and Procedure nodes. The Test suite root node can be considered a special kind of Test set. Test suite, Test set and Test case nodes can be called from other places using a Test call node. That way, tests that run only a subset of other tests can easily be created and managed. Test call nodes are allowed everywhere, but should not be executed from within a Test case node because that would break the atomicity of a Test case from the report's point of view. A warning is issued if Test case execution is nested.","hash":"usec_testcase_concepts","h2":"Concept"},"271":{"id":271,"content":"Variables and special attributes","hash":"usec_testcase_vars","h2":"Variables and special attributes"},"272":{"id":272,"content":"Default value As both Test sets and Test case can be called via a Test call node they each have a set of default parameters similar to those of a Procedure. These will be bound on the secondary variable stack and can be overridden in the Test call node.","hash":"sec_default_value","h2":"Default value"},"273":{"id":273,"content":"Variable definitions A Test case has an additional set of variable bindings. These are direct bindings for the primary variable stack that will be defined during the execution of the Test case and cannot be overridden via a Test call node or the command line parameter -variable <name>=<value>. Primary and secondary variable stack are described in \"Variable lookup\".","hash":"sec_variable_definitions","h2":"Variable definitions"},"274":{"id":274,"content":"Characteristic variables The list of Characteristic variables is a set of names of variables that are part of the characteristics of the test for data-driven testing. Each execution of the Test case with a different set of values for these variables is considered a separate test case. The expanded values of these variables are shown in the run log and report for improved error analysis.","hash":"sec_characteristic_variables","h2":"Characteristic variables"},"275":{"id":275,"content":"Condition Another useful attribute is the Condition which is similar to the Condition of an If node. If the Condition is not empty, the test will only be executed if the expression evaluates to true. Otherwise the test will be reported as skipped.","hash":"sec_condition","h2":"Condition"},"276":{"id":276,"content":"Expected to fail if... Sometimes a Test case is expected to fail for a certain period of time e.g. when it is created prior to the implementation of the respective feature or before a bug-fix is available in the SUT. The Expected to fail if... attribute allows marking such Test cases so they are counted separately and don't influence the percentage error statistics.","hash":"sec_expected_to_fail_if","h2":"Expected to fail if..."},"277":{"id":277,"content":"Sequence and Test step nodes The primary building block of a test are the Sequence and Test step nodes which execute their child nodes one by one in the order as they appear. They are used to structure the child nodes of a Test case. The difference between Sequence and Test step nodes is that Test step nodes will show up in the report whereas Sequences will not.","hash":"sec_sequence_and_test_step_nodes","h1":"Sequence and Test step nodes"},"278":{"id":278,"content":"Setup and Cleanup nodes Since it is in the nature of testing that tests may fail from time to time it is crucial to have structure elements that will help you set up a defined initial state for a test. Setup and Cleanup nodes are for simple cases and are inserted as child nodes of Test case nodes. However, in most cases Dependency nodes, that contain Setup and Cleanup nodes, will prove far more efficient. Test case nodes with well designed Setup and Cleanup nodes have the following properties important to successful testing: The Test case can be executed independently of previous test cases that may have failed. Test case nodes can be added at any position in Test suite and Test set nodes without influencing other Test cases You can work on a Test case or just run it without having to execute previous Test cases to get the SUT into the state required by your test. You can execute any number of Test case nodes in case you do not want to run the whole Test set or Test suite. In the simplest case exactly the same initial condition is required by all the Test case nodes of a Test set. This can be implemented via the following structure:","hash":"usec_setup_cleanup","h1":"Setup and Cleanup nodes"},"279":{"id":279,"content":"Figure 8.2: Test structure with simple Setup and Cleanup In the run log you can see that for each Test case node first the Setup node and then the Cleanup node is run:","hash":"fig_simple_setup_cleanup_suite","h4":"Figure 8.2: Test structure with simple Setup and Cleanup"},"280":{"id":280,"content":"Figure 8.3: Test execution with simple Setup and Cleanup In this simple example the cleanup is done in any case, even if the next test could be executed with the state the previous test left the SUT in. QF‑Test provides a more comprehensive structure for setting up the SUT and handling cleanup much more efficiently, and even including error handling. This is explained in chapter \"Dependency nodes\" in detail.","hash":"fig_simple_setup_cleanup_log","h4":"Figure 8.3: Test execution with simple Setup and Cleanup"},"281":{"id":281,"content":"Procedures and Packages In a way, writing good tests is a little like programming. After mastering the initial steps, tests and source code alike tend to proliferate. Things work fine until some building block that was taken for granted changes. Without a proper structure, programs as well as tests tend to collapse back upon themselves at this point as the effort of adapting them to the new situation is greater than the one needed for recreating them from scratch. The key to avoiding this kind of problem is reuse or avoidance of redundancy. Generating redundancy is one of the main dangers of relying too much on recording alone. To give an example, imagine you are recording various sequences to interact with the components in a dialog. To keep these sequences independent of each other, you start each one by opening the dialog and finish it by closing the dialog again. This is good thinking, but it creates redundancy because multiple copies of the events needed to open and close the dialog are contained in these sequences. Imagine what happens if the SUT changes in a way that invalidates these sequences. Let's say a little confirmation window is suddenly shown before the dialog is actually closed. Now you need to go through the whole suite, locate all of the sequences that close the dialog and change them accommodate the confirmation window. Pure horror. To stress the analogy again, this kind of programming style is called Spaghetti Programming and it leads to the same kind of maintenance problems. These can be avoided by collecting the identical pieces in one place and referring to them wherever they are needed. Then the modifications required to adapt to a change like the one described above are restricted to this place only.","hash":"usec_procedures","h1":"Procedures and Packages"},"282":{"id":282,"content":"Figure 8.4: Packages and Procedures QF‑Test comes with a set of nodes that help to achieve this kind of modularization, namely the Procedure, Procedure call and Package nodes. A Procedure is similar to a Sequence except that its Name attribute is a handle by which a Procedure call node can refer to it. When a Procedure call is executed, the Procedure it refers to is looked up and execution continues there. Once the last child node of the Procedure has finished, the Procedure call has completed as well. Packages are just a way to give even more structure to Procedures. A hierarchy of Packages and Procedures, rooted at the special Procedures node, is used to group sets of Procedures with a common context together and to separate them from other Procedures used in different areas. A Procedure that always does exactly the same, no matter where it is called from, is only marginally useful. To expand on the above example, let's say we want to extend the Procedure that opens the dialog to also set some initial values in some of its fields. Of course we don't want to have these initial values hard-coded in the Procedure node, but want to specify them when we call the Procedure to get different values in different contexts. To that end, parameters can be defined for the Procedure. When the Procedure call is executed, it specifies the actual values for these parameters during this run. How all of this works is explained in Variables. Also please take a look at the detailed explanation for the Procedure and Procedure call nodes for a better understanding of how these complement each other. A test suite library with a set of commonly useful Procedures is provided with QF‑Test under the name qfs.qft. An entire chapter of the Tutorial is devoted to this library and \"Referencing nodes in another test suite\" explains how to include it in your test suites.","hash":"figure_8.4","h4":"Figure 8.4: Packages and Procedures"},"283":{"id":283,"content":"Local Procedures and Packages If you work with several test suite libraries you might face a situation, where you define reusable test steps or sequences, which you only want to use within a dedicated test suite. If you want to create such local Procedures, you can put a '_' as first sign of the procedure's name. This marks a Procedure as test suite local. A call of a local Procedure can only be inserted within the test suite, where it is defined. You can use the same concept for local Packages.","hash":"usec_localprocedures","h2":"Local Procedures and Packages"},"284":{"id":284,"content":"Relative Procedures If you call Procedures from other Procedures, it could be convenient not to specify the full procedure name all the time. So called 'relative' procedure calls can only be added to a Package, which has the Border for relative calls (see Border for relative calls) attribute specified. The structure of that call follows the concept below:","hash":"usec_relativeprocedures","h2":"Relative Procedures"},"285":{"id":285,"content":"Level Call Procedures of the same level .Name of Procedure Procedures one level higher ..Name of Procedure Procedures one level deeper .Name of Package.Name of Procedure Table 8.1: Relative procedure calls As you can see each dot stands for one level. So calling a Procedure two levels higher requires three dots (Current level also requires a dot.)","hash":"table_8.1","h2":"Relative Procedures"},"286":{"id":286,"content":"Inserting Procedure call nodes As you should organize your tests in separate test steps, which are ideally the same like QF‑Test's procedures, QF‑Test offers several ways to insert those Procedure call nodes: Via the menu »Insert«-»Procedures«-»ProcedureCall« Via right mouse click and selecting »Insert node«-»Procedures«-»ProcedureCall« Copy a Procedure node and insert it at the location of the Procedure call using the normal Copy/Paste actions Via Drag&Drop operation, i.e. dragging the Procedure node to its target node Via the keyboard shortcut Ctrl⁠+⁠A By converting a Sequence or a Test step into a procedure, as described in \"Transforming a Sequence into a Procedure\". Shortcut Ctrl⁠+⁠Shift⁠+⁠P This approach is also valid for inserting Dependency reference nodes, except the keyboard shortcut.","hash":"usec_procedures_InsertProcCalls","h2":"Inserting Procedure call nodes"},"287":{"id":287,"content":"Parameterizing nodes You can create parameters for a Procedure, Dependency or Test case automatically via the menu »Operations«-»Parameterize node«. The parameter details dialog allows you to define for which actions you want to create parameters, e.g. only text-inputs or check nodes.","hash":"usec_procedures_Param","h2":"Parameterizing nodes"},"288":{"id":288,"content":"Transforming a Sequence into a Procedure This transformation is very useful for developing procedures immediately after recording! Under Extras you can convert a recorded Sequence node into a Procedure and move that to the Procedures node. If you transform a Sequence under Test cases QF‑Test automatically creates a Procedure node and inserts a Procedure call to the previous location of the transformed node.","hash":"usec_procedure_transform","h2":"Transforming a Sequence into a Procedure"},"289":{"id":289,"content":"Dependency nodes Video: Dependencies","hash":"usec_dependencies","h1":"Dependency nodes"},"290":{"id":290,"content":"Concept Dependencies are a powerful and optimized concept for handling pre- and post-conditions. They are indispensable when running tests in the QF‑Test Daemon mode mode. They basically work the following way: Set up a list of all dependencies required for the test case. Compare the list of dependencies needed for the current test case with the list of dependencies of the test case executed last. Execute all Cleanup nodes of the dependencies no longer part of the current dependencies list plus the ones where the values of Characteristic variables changed, including the Cleanup nodes of the Dependencies based on them. Execute all Setup nodes of the current dependencies list. Test cases as well as other dependencies can make use of Dependency nodes placed in the Procedures section via Dependency reference nodes. Therefore, Setup and Cleanup nodes placed in a Dependency node can be used by various test cases - in contrast to those placed directly in Test case or Test set nodes. In order to understand the concept of Dependency nodes it might be helpful to have a look at how a manual tester would proceed: He would do the setup for the first test case and then run it. In case of errors he may want to run special error cleanup routines. After that he would first check the requirements of the second test case. Only then would he do any cleanup. And he would only clean up as much as is necessary. Next he would check that the SUT still meets all preconditions required by the next test case and if not execute the necessary steps. In case the previous test case failed badly he might need to clean up the SUT completely before being able to set up the initial condition for the second test case. This is exactly what you can implement using QF‑Test Dependencies. Dependencies give an answer to the disadvantages of the classical Setup and Cleanup nodes where Setup nodes can only be nested by nesting test sets and where Cleanup nodes will be executed in any case, both of which is not very efficient. Moreover, Dependency nodes provide structure elements for handling errors and exceptions. Quite a number of the provided sample test suites make use of Dependencies, e.g.: The test suite in the directory doc/tutorial named dependencies.qft. You will find a detailed description in the \"Advanced features of QF‑Test\" chapter of the tutorial. The test suite in demo/carconfigSwing named carconfigSwing_en.qft, showing a realistic example. The SWT demo test suite named swt_addressbook.qft, with an example for SWT users The test suite in demo/eclipse named eclipse.qft, containing nested Dependencies. The data driver demo datadriver.qft in doc/tutorial also uses Dependencies. Single-stepping through these suites in the debugger, looking at the variable bindings and examining the run logs should help you to familiarize yourself with this feature. Please take care to store modified test suites in a project-related folder.","hash":"sec_concept","h2":"Concept"},"291":{"id":291,"content":"Usage of Dependencies You can define Dependencies in two places: You can implement Dependency nodes at the beginning of Test suite, Test set or Test case nodes. Additionally to their own Dependency a Test case or Test set may inherit the Dependency of its parent node. Dependencies used by a number of Test cases or used as a basis for other Dependencies may be implemented just like a Procedure node and be placed in the Procedures section, e.g. in a Package node named \"Dependencies\". The fully qualified name has the same structure as that of a Procedure. Just like Procedures Dependencies can be referred to by other nodes, in this case via Dependency reference nodes. One Dependency should deal with one precondition. Then you can reduce the test overhead generated by cleanup activities. In case a Dependency itself relies on preconditions these should be implemented in separate Dependency nodes. Dependencies can either be inherited from a parent node or referred to explicitly via Dependency reference nodes. The implementation of the actual pre- and post-conditions is done in the Setup and Cleanup nodes of the Dependency. In case a Test set or Test case node has a Dependency node as well as Setup and Cleanup nodes the Dependency will be executed first. Setup and Cleanup nodes have no influence on the dependency stack.","hash":"sec_usage_of_dependencies","h2":"Usage of Dependencies"},"292":{"id":292,"content":"Dependency execution and Dependency stack The execution of a Dependency has three phases: Generate a list of required Dependencies and check with list of previously executed Dependency nodes Execute Cleanup nodes if required Execute Setup nodes of all required Dependency nodes The examples used in this chapter all refer to tests with the following preconditions and cleanup activities: Sample Dependency A: Setup: start application if necessary Cleanup: stop application Dependency B: Setup: log in user if necessary Cleanup: log off user Dependency C: Setup: load application module 1 if necessary Cleanup: close application module 1 Dependency D: Setup: load application module 2 if necessary Cleanup: close application module 2 Dependency E: Setup: open dialog in module 2 if necessary Cleanup: close dialog Dependency C depends on B, B in turn on A. Dependency E depends on D, D on B therefore also on A. Before executing a Test case node QF‑Test checks whether it has a Dependency node of its own and/or inherits one from its parent nodes. In that case QF‑Test checks whether the Dependency node itself relies on other dependencies. Based on this analysis QF‑Test generates a list of the dependencies required. This is done in step 1 of the example below. Next, QF‑Test checks if previous tests have already executed dependencies. If so, QF‑Test checks if it has to execute any Cleanup nodes. After that QF‑Test goes through all the setup nodes, starting with the most basic ones. The name of each Dependency executed is noted down in a list called dependency stack. See step 2 of below example. Example: Test case 1 Test of application module 1. First test case to be executed. step Analyze the dependencies: the dependencies A-B-C have to be executed. step Compare the dependencies to be executed with the dependency stack: In this example the dependency stack is still empty as the test case is the first one to be executed. step Execute the Setup nodes, starting with A (start application), then B (login user (user name: Standard)), and last C (load application module 1). The dependency stack now reads A-B-C. step Execute the Test case. In the run log you can see exactly what QF‑Test did:","hash":"usec_dependency_stack","h2":"Dependency execution and Dependency stack"},"293":{"id":293,"content":"Figure 8.5: Dependency stack A-B-C After executing the test case the application remains in the condition the last test case left it in. Only after analyzing the dependencies of the next test case Cleanup nodes might be run and the respective Dependency be deleted from the dependency stack. When Cleanup nodes need to be run they are executed in reverse order to the Setup nodes. After maybe clearing up dependencies no longer needed the Setup nodes of all required Dependencies are executed. Just like a manual tester will check that all requirements for the next test case are fulfilled QF‑Test will do the same. A manual tester may not be conscious of checking the basic requirements. However, if he notices that the last test case left the application in a very bad state like a deadlock, he will probably kill the process if nothing else helped and start it again. To this end QF‑Test explicitly runs all Setup nodes. These should be implemented in a way that they first check if the application is already in the required state and just in case not run the whole Setup node.","hash":"fig_dependency_abc","h4":"Figure 8.5: Dependency stack A-B-C"},"294":{"id":294,"content":"Figure 8.6: Good practice Setup node Setups nodes should first check if the required condition already exists before actually executing the node. Cleanup nodes should first check if the requested cleanup action (e.g. closing a dialog) has already been performed. Also they should be programmed in such a way that they are in grade of clearing up error states of the application (e.g. error messages) so that a failed test case will not affect the following ones. Example: test case 2 Test a dialog in application module 2 step: Analyze the dependencies: the dependencies A-B-D-E have to be executed. step: Compare the list of dependencies to be executed with the dependency stack: Dependency C is not required for test case 2. Therefore Cleanup node of Dependency C is executed (close application module 1). step: Execute the Setup nodes, starting with A (check the application is already started and skip the rest of the setup), then B (check the user is already logged in, and skip the rest of the setup), then D (check if application module 2 is loaded and as it is not execute the complete Cleanup node), then E (same as D). step: Execute the Test case. You can see in the run log that the cleanup was done:","hash":"fig_dependency_setup","h4":"Figure 8.6: Good practice Setup node"},"295":{"id":295,"content":"Figure 8.7: Dependency stack A-B-D-E","hash":"fig_dependency_2","h4":"Figure 8.7: Dependency stack A-B-D-E"},"296":{"id":296,"content":"Characteristic variables Values of certain variables may determine whether a dependency has to be cleared up and the setup re-executed, like the user name for dependency B 'Login'. These variables are called Characteristic variables. The values of the Characteristic variables are always taken into account when comparing dependency stacks. Two Dependencies on the stack are only considered identical if the values of all Characteristic variables from the previous and the current run are equivalent. Consequently it is also possible for a Dependency to directly or indirectly refer to the same base Dependency with different values for its Characteristic variables. In that case the base Dependency will appear multiple times in the linearized dependency stack. Furthermore, QF‑Test stores the values of the Characteristic variables during execution of the Setup of a Dependency. When the Dependency is rolled back, i.e. its Cleanup node is executed, QF‑Test will ensure that these variables are bound to the same value as during execution of the Setup. This ensures that a completely unrelated Test case with conflicting variable definitions can be executed without interfering with the execution of the Cleanup nodes during Dependency rollback. Consider for example the commonly used \"client\" variable for the name of an SUT client. If a set of tests for one SUT has been run and the next test will need a different SUT with a different name, the \"client\" variable will be changed. However, the Cleanup node for the previous SUT must still refer to the old value of \"client\", otherwise it wouldn't be able to terminate the SUT client. This is taken care of automatically as long as \"client\" was added to the list of Characteristic variables. Example: Test case 3: Test of the same dialog for the user Administrator. Step: Analyze the dependencies: same list of dependencies A-B-D-E as in Test case 2. However, the Characteristic variables of Dependency B has a different value, i.e. 'Administrator'. Step: Compare the dependency list with the dependency stack: The required Dependency B differs from the Dependency B saved on the dependency stack because of the values of the Characteristic variables 'username', which is 'Standard' on the dependency stack. This means that the dependency stack will be rolled back including Dependency B, starting with the Cleanup for Dependency E (close dialog), then Cleanup for Dependency D (stop module 2), then Cleanup for Dependency B (log off user - the variable 'username' then has the value 'Standard' saved via the Characteristic variables on the dependency stack). Step: Execute the Setup nodes, starting with A (check the application is already started and skip the rest of the setup), then B (log in user 'Administrator'), then D (load module 2), then E (open dialog). Step: Execute the Test case. In the run log you can see the values of the Characteristic variables behind the respective Dependency:","hash":"usec_dependency_special_variables","h2":"Characteristic variables"},"297":{"id":297,"content":"Figure 8.8: Dependency with Characteristic variables Other examples for Characteristic variables are JDK versions when the SUT needs to be tested for various JDK versions or the browser name with web applications. In our example these would be specified as Characteristic variables for Dependency A.","hash":"fig_dependency_3","h4":"Figure 8.8: Dependency with Characteristic variables"},"298":{"id":298,"content":"Forced cleanup In some use cases it may be necessary to execute the Cleanup node of a Dependency after each Test case. Then you should set the attribute Forced cleanup. If Forced cleanup is activated for a Dependency node on the list of dependencies the Cleanup node of this and maybe of subsequent Dependencies will be executed. Example: In this example the test logic requires module 2 to be stopped after test execution. The attribute Forced cleanup is activated for Dependency D. In our example the Cleanup nodes of Dependencies E (close dialog) and D (stop modul) would be executed after each Test case.","hash":"sec_forced_cleanup","h2":"Forced cleanup"},"299":{"id":299,"content":"Rolling back Dependencies QF‑Test rolls back Dependencies depending on the needs of the Test cases. If you want to clear the list of dependencies explicitly there are two ways to do it: The menu item »Run«-»Roll back dependencies« rolls back the list of dependencies 'cleanly' executing all the Cleanup nodes in reverse order to the setup activities. The menu item »Run«-»Reset dependencies« just deletes the list of dependencies without executing any nodes. When a Test case does not use Dependencies the list of dependencies remains untouched, i.e. no Cleanup nodes are executed.","hash":"sec_rolling_back_dependencies","h2":"Rolling back Dependencies"},"300":{"id":300,"content":"Error escalation Another thing that is just grand about Dependencies is the convenient way that errors can be escalated without any additional effort. Let's again consider the example from the previous section after the first dependency stack has been initialized to A-B-C (Application started, user logged in, module one loaded) and the Setups have been run. Now what happens if the SUT has a really bad fault, like going into a deadlock and not reacting to user input any longer? When a Cleanup node fails during rollback of the dependencies stack, QF‑Test will roll back an additional Dependency and another one if that fails again and so on until the stack has been cleared. Similarly, if one of the Setups fails, an additional Dependency is rolled back and the execution of the Setups started from scratch. Example: In the example Test case 1 above the SUT would for example get deadlocked. In Test case 1 an exception would be thrown, Test case 1 would be stopped and execution passed on to Test case 2. Step: Analyze the dependencies: the list of dependencies A-B-D-E has to be executed. (Application started, user logged in, module 2 loaded, dialog opened) Step: Comparing the dependency list with the dependency stack set up by Test case 1 A-B-C (application started, user logged in, module 1 loaded) results in the execution of the Cleanup node of Dependency C (stop module 1). Of course, the exception is thrown again. Now QF‑Test runs the Cleanup node for the next Dependency B (log off user). This will fail again so that now the basic Dependency A will be rolled back, which successfully stops the application. Step: Execute the Setup nodes, starting with A (start the application), then B (log in user), then D (load module 2), then E (open dialog). Step: Test case 2 will be executed despite the deadlock in Test case 1.","hash":"usec_error_escalation","h2":"Error escalation"},"301":{"id":301,"content":"Figure 8.9: Exception in forced cleanup sequence of C causes B to clean up For this to work it is very important to write Cleanup sequences in a way that ensures that either the desired state is reached or that an exception is thrown and that there is a more basic dependency with a more encompassing Cleanup. For example, if the Cleanup node for the SUT Dependency just tries to cleanly shut down the SUT through its File->Exit menu without exception handling and further safeguards, an exception in that sequence will prevent the SUT from being terminated and possibly interfere with all subsequent tests. Instead, the shutdown should be wrapped in a Try/Catch with a Finally node that checks that the SUT is really dead and if not, kills the process as a last resort.","hash":"fig_dependency_exception","h4":"Figure 8.9: Exception in forced cleanup sequence of C causes B to clean up"},"302":{"id":302,"content":"Figure 8.10: Typical Cleanup node With good error handling in place, Test cases will rarely interfere with each other even in case of really bad errors. This helps avoid losing a whole night's worth of test runs just because of a single error.","hash":"fig_dependency_cleanup","h4":"Figure 8.10: Typical Cleanup node"},"303":{"id":303,"content":"Error handling Besides supporting automatic escalation of errors a Dependency can also act as an error or exception handler for the tests that depend on it. Catch nodes, which can be placed at the end of a Dependency, are used to catch and handle exceptions thrown during a test. Exceptions thus caught will still be reported as exceptions in the run log and the report, but they will not interfere with subsequent tests or even abort the whole test run. An Error handler node is another special node that may be added to a Dependency after the Cleanup and before the Catch nodes. It will be executed whenever the result of a Test case is \"error\". In case of an exception, the Error handler node is not executed automatically because that might only cause more problems and even interfere with the exception handling, depending on the kind of exception. To do similar things for errors and exception, implement the actual handler as a Procedure and call it from the Error handler and the Catch node. Error handlers are useful for capturing and saving miscellaneous states that are not automatically provided by QF‑Test. For example, you may want to create copies of temporary files created during execution of your SUT that may hold information pertaining to the error. Only the topmost Error handler that is found on the dependency stack is executed, i.e. if in a dependency stack of [A,B,C,D] both A and C have Error handlers, only C's Error handler is run. Otherwise it would be difficult to modify the error handling of the more basic Dependency A in the more specialized Dependency C. To reuse A's error handling code in C, implement it as a Procedure.","hash":"usec_dependency_error_handling","h2":"Error handling"},"304":{"id":304,"content":"Name spaces for Dependencies You might be interested in reading this section in case you want to run several SUTs at the same time where you do not want the Dependency node for a test on one of the SUTs to trigger cleanup actions for another SUT. Otherwise feel free to skip it. A typical use case would be the test of whole process chains over several applications. Consider the following situation: Sales representatives enter data for offers via a web application into a database at headquarters. There, the offers will be completed, printed and posted. A copy of each printed offer will be saved in a document management system (DMS).","hash":"usec_dependency_namespaces","h2":"Name spaces for Dependencies"},"305":{"id":305,"content":"Figure 8.11: Example Test set for name spaces In above example two sales representatives (UserA and UserB) enter offers and two different persons (UserC and UserD) process the offers at headquarters. Then the offers will be checked in the document management system. Since you do not want the dependencies of the test cases to interfere with one another you need to add a suitable name in the Dependency namespace attribute of each Dependency reference node. After running the test set you can see in the run log that a dependencies stack was set up in the name space 'data entry' for the first test case:","hash":"fig_dependency_namespaces_testcase","h4":"Figure 8.11: Example Test set for name spaces"},"306":{"id":306,"content":"Figure 8.12: Dependency handling for test case 'Data entry by User A' A dependencies stack is set up in the name space 'database' for the second test case. The dependencies stack in the name space 'data entry' remains unheeded. Looking at the applications, this means the database is started whereas the application for data entry is left as it is.","hash":"fig_dependency_namespaces_log1","h4":"Figure 8.12: Dependency handling for test case 'Data entry by User A'"},"307":{"id":307,"content":"Figure 8.13: Dependency handling for test case 'Offer processing by User C' A dependencies stack is set up in the name space 'DMS' for the third test case. The dependencies stacks in the name spaces 'data entry' and 'database' remain unheeded. Looking at the applications, this means the document management system is started whereas the other two applications are left as they are.","hash":"fig_dependency_namespaces_log2","h4":"Figure 8.13: Dependency handling for test case 'Offer processing by User C'"},"308":{"id":308,"content":"Figure 8.14: Dependency handling for test case 'Check offer 1 in DMS' In test case number four the required dependencies are checked against the ones on the dependencies stack in the name space 'data entry' of the first test case. The dependencies stacks in the other two name spaces remain unheeded. Looking at the applications, this means User A is logged off, User B is logged into the data entry application and the other two applications are left as they are.","hash":"fig_dependency_namespaces_log3","h4":"Figure 8.14: Dependency handling for test case 'Check offer 1 in DMS'"},"309":{"id":309,"content":"Figure 8.15: Dependency handling for test case 'Data entry by User B' In test case number five the required dependencies are checked against the ones on the dependencies stack in the name space 'database' of the second test case. The dependencies stacks in the other two name spaces remain unheeded. Looking at the applications, this means User C is logged off, User D is logged into the database application and again the other two applications are left as they are.","hash":"fig_dependency_namespaces_log4","h4":"Figure 8.15: Dependency handling for test case 'Data entry by User B'"},"310":{"id":310,"content":"Figure 8.16: Dependency handling for test case 'Offer processing by User D' In the last test case the required dependencies are checked against the ones on the dependencies stack in the name space 'DMS' of the third test case. The dependencies stacks in the other two name spaces remain unheeded. Looking at the applications, this means no clean up action has to be done on the DMS. The other two applications are left as they are, anyway.","hash":"fig_dependency_namespaces_log5","h4":"Figure 8.16: Dependency handling for test case 'Offer processing by User D'"},"311":{"id":311,"content":"Figure 8.17: Dependency handling for test case 'Check offer 2 in DMS'","hash":"fig_dependency_namespaces_log6","h4":"Figure 8.17: Dependency handling for test case 'Check offer 2 in DMS'"},"312":{"id":312,"content":"Documenting test suites Like with any programming-related task it is important for successful test-automation to properly document your efforts. Otherwise there is a good chance (some might say a certainty) that you will lose the overview over what you have done so far and start re-implementing things or miss out tests that should have been automated. Proper documentation will be invaluable when working through a run log, trying to understand the cause of a failed test. It will also greatly improve the readability of test reports. An easy option for readable and documented tests is to group the recorded nodes into Sequence und Test step nodes. For inline documentation you can use the Comment node. When you want to set up a documentation available outside QF‑Test you can do so based on the Comment attributes of Test set, Test case, Package and Procedure nodes, and create a set of comprehensive HTML documents that will make all required information readily available. The various kinds of documents and the methods to create them are explained in detail in \"Reports and test documentation\".","hash":"usec_documentation","h1":"Documenting test suites"},"313":{"id":313,"content":"Mobile Manual","hash":"","h0":"Projects | QF‑Test Manual"},"314":{"id":314,"content":"Mobile Manual","hash":"home-link","h0":"Projects | QF‑Test Manual"},"315":{"id":315,"content":"Projects Projects provide a better overview, simplify navigation between test suites and expand the scope for search and replace operations. Also, QF‑Test automatically manages dependencies resulting from includes or absolute references between test suites belonging to the same project (see \"Referencing nodes in another test suite\"). Many other features have already been implemented or are under development. Technically a QF‑Test project is a set of test suites located in one or more directories with a common root. There is a 1:1 relation between the project and its directory and the name of the directory automatically becomes the name of the project. To create a new project, use the menu item »File«-»New Project...«. Then select the directory. QF‑Test will create a file named qftest.qpj in that directory to designate it as a project. This file can also be used to define options and project-specific library paths as described in \"The file qftest.qpj\".","hash":"usec_projects","h0":"Projects"},"316":{"id":316,"content":"Subprojects A subproject is a subdirectory of a project which is itself a project. Test suites within a subproject also belong to all parent projects. The project of a test suite is the innermost subproject to which the suite belongs. Automatic dependency resolution always includes the entire outermost project of a test suite, including all subprojects.","hash":"usec_projects_subproject","h1":"Subprojects"},"317":{"id":317,"content":"Figure 9.1: The Project View","hash":"figure_9.1","h4":"Figure 9.1: The Project View"},"318":{"id":318,"content":"Project View The project view with one or more projects can be toggled on or off via the menu item »View«-»Show Projects«. The project tree displays the directory hierarchy of a project with its test suites, starting from the project root, possibly limited by the filter above the tree, which applies to test suite names. Double-clicking a test suite opens it, as does pressing the Return key. You can select several files or directories to be opened in one go, including all test suites located under the selected directories. The hierarchy is refreshed automatically at intervals defined in the option Project refresh interval (s). You can refresh a directory including its complete hierarchy at any time by selecting it and pressing F5. For a more thorough rescan that does not rely on modification times but may take significantly longer for large projects, press Shift⁠+⁠F5 instead. To switch keyboard focus between the test suite and the project view, press F6. To quickly navigate from the current test suite to its node in the project tree, press Shift⁠+⁠F6. If necessary, the project view and project tree will be opened automatically for this action.","hash":"usec_projects_view","h1":"Project View"},"319":{"id":319,"content":"The file qftest.qpj The qftest.qpj file designates the root directory of a project. All test suites under this directory automatically belong to the project, except those excluded either by project-specific entries in \"Section [exclude]\" or via the global option Project files and directories to exclude. For more information about project options, see \"Project settings\". Normally, this file is empty. However, you can add entries in different sections, each beginning with a line like [SectionName]. Blank lines or lines beginning with \"#\" are ignored. The contents of the qftest.qpj file must be encoded in UTF-8.","hash":"usec_projects_file","h1":"The file qftest.qpj"},"320":{"id":320,"content":"Section [config] This section contains settings for the project as Name=Value entries. Possible settings include: readgitignore Determines whether files or directories defined in a .gitignore file should be excluded (for the format specification, please refer to the documentation for Git version control). Possible values are \"true\", \"false\", or a file name to be read instead of the .gitignore file in the project directory. The default value is \"false\". Using a .gitignore file is recommended when combining a QF‑Test project with a large project containing many files not relevant for QF‑Test.","hash":"usec_projects_gitignore","h1":"Section [config]"},"321":{"id":321,"content":"Section [librarypath] In this section, you can specify library paths which apply only to this project. Each line contains a path, either relative to the project's root directory or absolute. For variable specifications, you can use ${env:...} or ${system:...}. The respective values must be set at test execution, for example, ${env:myLibpath} requires the environment variable myLibpath to be set, ${system:myLibpath} uses the Java system property myLibpath. See also the example in \"Example\". The library paths are searched sequentially if relative file names cannot be resolved relative to the calling suite. If nested projects exist, the library paths for the innermost project are searched first, followed by those of each outer project. If still not resolved, the files specified in the global library paths are searched (see Referencing nodes in another test suite).","hash":"usec_projects_librarypath","h1":"Section [librarypath]"},"322":{"id":322,"content":"Section [exclude] Here you can explicitly specify files and directories to exclude from the project. Each line contains a path, either relative to the project's root directory or absolute.","hash":"usec_projects_exclude","h1":"Section [exclude]"},"323":{"id":323,"content":"Section [include] Here you can explicitly re-include individual files or subdirectories located within a directory excluded via the [exclude] section. Each line contains a path, either relative to the project's root directory or absolute.","hash":"usec_projects_include","h1":"Section [include]"},"324":{"id":324,"content":"Example [config] gitignore = ../.gitignore # include .gitignore file from parent directory [librarypath] ../myLibFolderOutsideTheProject # path relative to the project's root directory C:/testing/myLibraries # absolute path ${env:myLibpath} # the environment variable 'myLibpath' contains the value ${system:myLibpath} # the system property 'myLibpath' contains the value [exclude] scratch # exclude directory [include] scratch/wichtig.qft # exception: include this file Example 9.1: Examples for a Project Configuration Always use the '/' character as the directory separator – even on Windows. QF‑Test will automatically use the correct separator at runtime for each system. This ensures your test suites remain portable across different systems.","hash":"usec_projects_sample","h1":"Example"},"325":{"id":325,"content":"Mobile Manual","hash":"","h0":"The standard library | QF‑Test Manual"},"326":{"id":326,"content":"Mobile Manual","hash":"home-link","h0":"The standard library | QF‑Test Manual"},"327":{"id":327,"content":"The standard library The standard library qfs.qft, a test suite that is part of the QF‑Test distribution, contains many useful procedures for a diverse set of tasks.","hash":"usec_stdlib","h0":"The standard library"},"328":{"id":328,"content":"Figure 10.1: Standard library qfs.qft Among others there are procedures for accessing and checking components (AWT, Swing, JavaFX, SWT, Web) in a generic manner, file system and database access, logging messages or screenshots to the run log and report and for performing cleanup. A complete description of all packages and procedures including parameters and return values is provided in the library's HTML documentation, also accessible from the QF‑Test »Help« menu. The latest version is also available online. qfs.qft is included by default in every newly created test suite. As its directory is on the library path, specifying just qfs.qft in the Include files of the Test suite node is sufficient. All procedures referring to an SUT use the generic variable $(client) as an implicit parameter. You must make sure that this variable is set correctly either globally or locally or specified as an explicit parameter in the procedure call.","hash":"fig_qfsqft","h4":"Figure 10.1: Standard library qfs.qft"},"329":{"id":329,"content":"Mobile Manual","hash":"","h0":"Scripting | QF‑Test Manual"},"330":{"id":330,"content":"Mobile Manual","hash":"home-link","h0":"Scripting | QF‑Test Manual"},"331":{"id":331,"content":"Scripting The video 'Scripting in QF‑Test (Basics)' explains the basic concepts about scripting. If you want to know more about scripting have a look at the video 'Scripting in QF‑Test (Advanced) explains the basic concepts about scripting. One of QF‑Test's benefits is that complex tests can be created without writing a single line of code. However, there are limits to what can be achieved with a GUI alone. When testing a program which writes to a database, for example, one might want to verify that the actual values written to the database are correct; or one might want to read values from a database or a file and use these to drive a test. All this and more is possible with the help of powerful scripting languages like Jython, Groovy or JavaScript. While Jython is supported since the beginning of QF‑Test, Groovy has found its way into QF‑Test a bit later (QF‑Test version 3). This language might be more convenient than Jython for those who are familiar with Java. Version 4.2 enabled JavaScript which might be more suitable for web developers. It's mainly a matter of individual preference whether to utilize Jython, Groovy or JavaScript scripting inside QF‑Test. In this chapter the basics of the scripting features available in all supported languages are explained. Most of the examples can be applied exactly or with few changes in other script languages. Methods calls which vary in syntax are exemplified in the affected languages. Particularities of the script languages are described in the sections Fundamentals of the Jython integration, Scripting with Groovy and Scripting with JavaScript. The scripting language to use for a given Server script or SUT script node is determined by its Script language attribute, so you can mix all three languages within a test suite. The default language to use for newly created script nodes can be set via the options Default script language for script nodes and Default script language for conditions.","hash":"usec_scripting","h0":"Scripting"},"332":{"id":332,"content":"General The approach to scripting in QF‑Test is inverse from that of other GUI test tools. Instead of driving the whole test from a script, QF‑Test embeds scripts into the test suite. This is achieved with the two nodes Server script and SUT script. Both nodes have a Script attribute for the actual code.","hash":"sec_generalscripting","h1":"General"},"333":{"id":333,"content":"Figure 11.1: Detail view of a Server script with help window for rc methods The internal script editor has some useful features to ease the typing of code. Reserved keywords, built-in functions, standard types, literals and comments are highlighted. Indentation is handled automatically inside of code blocks. With TAB and Shift⁠+⁠TAB respectively several selected lines can be indented manually. However, the probably most useful feature - at least for the QF‑Test newbie - might be the input assistance for many built-in methods. Type, for example, rc. and maybe some initial letters of a method name. Then press Ctrl⁠+⁠Space to open a pop-up window displaying the appropriate methods and descriptions of QF‑Test's run context (cf. \"Advanced scripting (Jython, Groovy and JavaScript)\"). Select one of the methods and confirm with Return to insert it into the script code. To get a list of all objects equipped with help, just press Ctrl⁠+⁠Space with the mouse cursor positioned after white space. Server scripts are useful for tasks like calculating the values of variables or reading and parsing data from a file and using it to drive a test. SUT scripts on the other hand give full access to the components of the SUT and to every Java API that the SUT exposes. An SUT script might be used to retrieve or check values in the SUT to which QF‑Test doesn't have access. The SUT script node has a Client attribute which requires the name of the SUT client to run in. Server scripts are run in script interpreters for the different script languages embedded in QF‑Test itself, while SUT scripts are run in a script interpreter embedded in the SUT. These interpreters are independent of each other and do not share any state. However, QF‑Test uses the RMI connection between itself and the SUT for seamless integration of SUT scripts into the execution of a test. Through the menu items »Extras«-»Jython console« or »Extras«-»Groovy console« etc. you can open a window with an interactive command prompt for the language interpreters embedded in QF‑Test. You can use the console to experiment with the scripts, get a feeling for the language, but also to try out some sophisticated stuff like setting up database connections. The keystrokes Ctrl⁠+⁠Up and Ctrl⁠+⁠Down let you cycle through previous input and you can also edit any other line or mark a region in the console and simply press Return to send it to the interpreter. In that case QF‑Test will filter the '>>>' and '...' prompts from previous interpreter output. Similar consoles are available for each SUT client. The respective menu items are located below the »Clients« menu. When working in a SUT script terminal, there's one thing you need to be aware of: The commands issued to the interpreter are not executed on the event dispatch thread, contrary to commands executed via SUT script nodes. This may not mean anything to you and most of the time it doesn't cause any problems, but it may deadlock your application if you access any Swing or SWT components or invoke their methods. To avoid that, QF‑Test provides the global methods runAWT, runSWT, runFX, runWeb, runWin, runAndroid and runIOS which execute arbitrary code on the event dispatch thread. For example, to get the number of visible nodes in a JTree component named tree, use runAWT(\"tree.getRowCount()\") (or runAWT { tree.getRowCount() } in Groovy) to be on the safe side.","hash":"figure_11.1","h4":"Figure 11.1: Detail view of a Server script with help window for rc methods"},"334":{"id":334,"content":"Script expressions On occasion it can be useful to directly run small calculations or text manipulations directly in a node attribute. In QF‑Test, this is possible everywhere where QF‑Test variable expansion is available. To achieve this, there is a special syntax with which single-line script expressions can be evaluated: $[Jython expression] evaluates the given expression in the Jython interpreter. Alternatively you can use ${jython:Jython expression}. All expressions are allowed that are allowed for the Jython eval method. to process a Groovy expression, use ${groovy:Groovy expression}, and to process a JavaScript expression, use ${javascript:JavaScript expression}. The script expressions are evaluated according to the same rules as the script nodes, see Fundamentals of the Jython integration, Scripting with Groovy or Scripting with JavaScript. Access to QF‑Test variables in ${Script language:expression} or $[...] expressions follows the same rules as in other scripts for the respective language. An exception for Jython: the default QF‑Test syntax $(...) and ${...:...} can only be used for numeric and boolean values. You should access strings via rc.getStr instead (see \"Variables\"). Example: In a Loop node, the expression $[$(lastRowIndex) + 1] in Number of iterations can be used if the variable lastRowIndex was previously set by the node Fetch index with index &-1 for the last row (like #List:&-1). Script expressions can also return encapsulated objects. Example: The variable myList contains the value $[ [\"Ape\", \"Beaver\", \"Chincilla\"] ]. You can now use $[len($(myList))] in Number of iterations in a Loop node. In the condition attributes of If, Test case and Test set this special syntax is not required. There you can enter script expressions directly.","hash":"sec_script_expressions","h1":"Script expressions"},"335":{"id":335,"content":"The run context rc When executing Server scripts and SUT scripts, QF‑Test provides a special environment in which a variable named rc is bound. This variable represents the run context which encapsulates the current state of the execution of the test. It provides an interface (fully documented in \"The rc module: Run context API\") for accessing QF‑Test variables, for calling QF‑Test procedures and can be used to add messages to the run log. To SUT scripts it also provides access to the actual Java components of the SUT's GUI. For those cases where no run context is available, i.e. Resolvers, TestRunListeners, code executing in a background thread etc. QF‑Test also provides a module called qf with useful generic methods for logging and other things. Please see \"The qf module\" for details.","hash":"sec_runcontext","h1":"The run context rc"},"336":{"id":336,"content":"Logging messages One thing the run context can be used for is to add arbitrary messages to the run log that QF‑Test generates for each test run. These messages may also be flagged as warnings or errors. rc.logMessage(\"This is a plain message\") rc.logWarning(\"This is a warning\") rc.logError(\"This is an error\") Example 11.1: Logging messages from scripts When working with compact run logs (see the option Create compact run log), nodes which most likely will not be needed for error analysis may be deleted from the run log to preserve memory. This does not apply to error messages (rc.logError). They are kept, along with about 100 nodes preceding the error. Warnings (rc.logWarning) are also kept, however, without preceding nodes. Normal messages (rc.logMessage) may be subject to deletion. If you really need to make sure that a message will definitely be kept in the run log you can enforce this by specifying the optional second parameter dontcompactify, e.g. rc.logMessage(\"This message will not be removed\", dontcompactify=true) # or simply rc.logMessage(\"This message will not be removed\", 1) Example 11.2: Logging messages that will not get removed in compact run logs","hash":"sec_logging_messages","h2":"Logging messages"},"337":{"id":337,"content":"Performing checks Most of the time logging messages is tied to evaluating some condition. In that case, it is often desirable to get a result in the HTML or XML report equivalent to that of a Check node. The methods rc.check and rc.checkEqual will do just that: var = 0 rc.check(var == 0, \"Value of var is 0\") rc.checkEqual('${system:user.language}', 'en', \"English locale required\", rc.EXCEPTION) Example 11.3: Performing checks The optional last argument changes the error level in case of failure. Possible values are rc.EXCEPTION, rc.ERROR, rc.OK or rc.WARNING.","hash":"sec_performing_checks","h2":"Performing checks"},"338":{"id":338,"content":"Variables QF‑Test has different kinds of variables. On the one hand there are variables belonging to the QF‑Test environment and on the other variables of the script languages, see \"Variables\". Variables of the script languages are separated into server-side and SUT-side variables of each interpreter. The following graphic visualizes the different visibility of the variable types:","hash":"usec_scriptvars","h2":"Variables"},"339":{"id":339,"content":"Figure 11.2: Overview of the types of variables in QF‑Test To share the different kinds of variables between QF‑Test and the script interpreters, QF‑Test provides the rc object which has several methods for this purpose. The methods are explained in the next section.","hash":"figure_11.2","h4":"Figure 11.2: Overview of the types of variables in QF‑Test"},"340":{"id":340,"content":"Accessing variables Using QF‑Test variables in scripts is not difficult. You can access string values through the run context method getStr, boolean values through getBool, integer values through getInt, other numeric values through getNum and data object values through getObj (see \"The rc module: Run context API\" for the complete API documentation). # access a simple variable text = rc.getStr(\"someText\") # access a property or resource version = rc.getStr(\"qftest\", \"version\") Example 11.4: Using rc.getStr to access string variables","hash":"sub_accessing_variables","h2":"Accessing variables"},"341":{"id":341,"content":"Setting variables To make the results of a script available during further test execution, values can be stored in global or local variables. The effect is identical to that of a Set variable node. The corresponding methods in the run context are rc.setGlobal and rc.setLocal. # Test if the file /tmp/somefile exists from java.io import File rc.setGlobal(\"fileExists\", File(\"/tmp/somefile\").exists()) Example 11.5: Using rc.setGlobal After executing the above example $(fileExists) will expand to true if the file /tmp/somefile exists and to false if it doesn't. To clear a variable, set it to None, to clear all global variables use rc.clearGlobals() from a Server script.","hash":"sec_setting_variables","h2":"Setting variables"},"342":{"id":342,"content":"Global variables Sometimes it is helpful to have a variable available in several scripting nodes. If the value of the variable is not a simple string or integer, it is sometimes not sufficient to use rc.setGlobal to store it in a global QF‑Test variable, because the value must be serialized when written or accessed from an SUT scripts - otherwise only the stringification of the object is stored in the variable. In such a case, the variable can be declared global in Jython to be usable within different scripts or expressions of the same scripting language, as shown in the following example. global globalVar globalVar = 10000 Example 11.6: Global Jython variable The globalVar is now accessible within all further scripting nodes of the same type (Server scripts or SUT scripts of the same client). For changing the value of globalVar within another script, the global declaration is necessary again. Otherwise, a new local variable is created instead of accessing the existing global. Use the del statement to remove a global Jython variable: global globalVar del globalVar Example 11.7: Delete a global Jython variable In Groovy and JavaScript the global variables declaration is even easier than in Jython. All variables that are not declared locally are assumed to be global. myGlobal = 'global' Example 11.8: Defining a global variable in Groovy or JavaScript assert myGlobal == 'global' def globals = binding.variables assert globals['myGlobal'] == 'global' globals.remove('myGlobal') assert globals.find { it == 'myGlobal' } == null Example 11.9: Usage and deletion of a global Groovy variable","hash":"usec_global_variables","h2":"Global variables"},"343":{"id":343,"content":"Exchanging variables between processes Sometimes one would like to use variable values that have been defined in one process in a different process. For example, an SUT script might have been used to create a list of items displayed in a table. Later we want to iterate over that list in a Server script. One way is to store the list in a QF‑Test variable with rc.setGlobal or rc.setLocal and then retrieve the list content later with rc.getObj. This works fine as long as the stored content is serializable, the object can be recreated in the other process and no exception is defined (see Object classes to exclude from serialization). If that is not the case, rc.getObj will automatically return the stringification of the stored value - similar to rc.getStr. Alternatively, the run context provides a symmetrical set of methods to access or set global script variables in a different process. For SUT scripts these methods are named toServer and fromServer. The corresponding Server script methods are toSUT and fromSUT. For this to work, the script nodes must use the same scripting language. The following example illustrates how an SUT script can set a global variable in the QF‑Test Jython interpreter: cellValues = [] table = rc.getStr(\"idOfTable\") for i in range(table.getRowCount()): cellValues.append(table.getValueAt(i, 0)) rc.toServer(tableCells=cellValues) Example 11.10: Setting a server variable from an SUT script After the above script is run, the global variable named \"tableCells\" in the QF‑Test Jython interpreter will hold the array of cell values. The cell values in the above example are not necessarily strings. They could be numbers, date values, anything. Unfortunately Jython's pickle mechanism isn't smart enough to transport instances of Java classes (not even realizable ones), so the whole exchange mechanism is limited to primitive types like strings and numbers, along with Jython objects and structures like arrays and dictionaries.","hash":"usec_exchanging_vars","h2":"Exchanging variables between processes"},"344":{"id":344,"content":"Accessing the SUT's GUI components For SUT scripts the run context provides an additional method that is extremely useful. Calling rc.getComponent(\"componentId\") will retrieve the information of the Component node in the test suite with the QF‑Test ID \"componentId\" and pass that to QF‑Test's component recognition mechanism. The whole process is basically the same as when simulating an event, including the possible exceptions if the component cannot be found. If the component is located, it will be passed to Jython, not as some abstract data but as the actual Java object. All methods exposed by the Java API for the component's class can now be invoked to retrieve information or achieve effects which are not possible through the GUI alone. To get a list of a component's method see \"Inspecting components\". # get the custom password field field = rc.getComponent(\"tfPassword\") # read its encrypted value passwd = field.getCryptedText() rc.setGlobal(\"passwd\", passwd) # get the table component table = rc.getComponent(\"tabAddresses\") # get the number of rows rows = table.getRowCount() rc.setGlobal(\"tableRows\", rows) Example 11.11: Accessing components with rc.getComponent You can also access sub-items this way. If the componentId parameter references an item, the result of the getComponent call is a pair, the component and the item's index. The index can be used to retrieve the actual value. The following example shows how to get the value of a table cell. Note the convenient way Jython supports sequence unpacking during assignment. # first get the table and index table, (row,column) = rc.getComponent(\"tableAddresses@Name@Greg\") # then get the value of the table cell cell = table.getValueAt(row, column) Example 11.12: Accessing sub-items with rc.getComponent","hash":"usec_accessing_components","h2":"Accessing the SUT's GUI components"},"345":{"id":345,"content":"Calling Procedures The run context can also be used to call back into QF‑Test and execute a Procedure node. rc.callProcedure(\"text.clearField\", {\"component\": \"nameField\", \"message\" : \"nameField cleared\"}) Example 11.13: Simple procedure call in Jython In the example above the Procedure named \"clearField\" in the Package named \"text\" will be called. The parameter named \"component\" is set to the value \"nameField\" and the parameter named \"message\" is set to the value \"nameField cleared\". The same example with Groovy syntax: rc.callProcedure(\"text.clearField\", [\"component\" : \"nameField\", \"message\" : \"nameField cleared\"]) Example 11.14: Simple procedure call in Groovy And in JavaScript: rc.callProcedure(\"text.clearField\", {\"component\" : \"nameField\", \"message\" : \"nameField cleared\"}) Example 11.15: Simple procedure call in JavaScript The value returned by the Procedure through a Return node is returned as the result of the rc.callProcedure call. Great care must be taken when using rc.callProcedure in SUT script nodes. Only short-running Procedures should be called that won't trigger overly complex actions in the SUT. Otherwise, a DeadlockTimeoutException might be caused. For data-driven tests where for some reason the data must be determined in the SUT, use rc.toServer to transfer the values to QF‑Test interpreter, then drive the test from a Server script node where these restrictions do not apply.","hash":"sec_calling_procedures","h2":"Calling Procedures"},"346":{"id":346,"content":"Setting options Many of the options described in \"Options\" can also be set at runtime via rc.setOption. Constants for option names are predefined in the class Options. It is automatically available for all script languages. A real-life example where this might be useful is if you want to replay an event on a disabled component, so you need to temporarily disable QF‑Test's check for the enabled/disabled state. For setting and immediately resetting an option there is the variant pushOption / popOption which leaves a potentially preceding setOption call intact: rc.pushOption(Options.OPT_PLAY_THROW_DISABLED_EXCEPTION, false) Example 11.16: Example for pushOption After replaying this special event, the previous option setting can be restored as shown in the following example: rc.popOption(Options.OPT_PLAY_THROW_DISABLED_EXCEPTION) Example 11.17: Example for popOption To be on the safe side and ensure, that the value is always restored, the two script nodes should be placed into a Try / Finally combination. Otherwise, for example a ComponentNotFoundException during event replay would prevent restoring the option. Be sure to set QF‑Test options in a Server script node and SUT options in an SUT script node, otherwise the setting will have no effect. Some options - most notably for SmartIDs - have effect on QF‑Test and SUT side. Those must be set in a Server script node. QF‑Test automatically takes care of the SUT side as well. The option documentation in \"Options\" includes information about the effected side - server and/or SUT.","hash":"usec_scripting_options","h2":"Setting options"},"347":{"id":347,"content":"Override components You might face a situation where you want to work with a component which you have to determine at script level before working with it, either for performance reasons when using the same component multiple times or for special cases where default component recognition is too difficult or inefficient. For such cases you can use the method rc.overrideElement to associate the component found with a QF‑Test ID or SmartID after which you can work use the assigned ID QF‑Test event, check or similar nodes. The following example could alternatively be resolved using SmartIDs but still illustrates the case well. For more complex cases overrideElement remains a relevant alternative. Let's imagine that we have a panel and we want to work with the first textfield, but because of changing textfields we cannot rely on the standard way of the recognition. Now we can implement a script, which looks for the first textfield and assigns that textfield to the PriorityAwtSwingComponent from the standard library qfs.qft. Once we have executed that script we can work with any QF‑Test nodes using the PriorityAwtSwingComponent, which actually performs all actions on the found textfield.","hash":"usec_scripting_override","h2":"Override components"},"348":{"id":348,"content":"panel = rc.getComponent(\"myPanel\") for component in panel.getComponents(): if qf.isInstance(component, \"javax.swing.JTextField\"): rc.overrideElement(\"PriorityAwtSwingComponent\", component) break Example 11.18: Using rc.overrideElement This concept is very useful if you know an algorithm to determine the target component of your test steps. You can find (old-style, see below) priority components for all engines in the standard library qfs.qft. You can also find an illustrative example in the provided demo test suite carconfigSwing_advanced_en.qft, located in the directory demo/carconfigSwing in your QF‑Test installation. Before the introduction of SmartIDs QF‑Test ID of an existing Component node had to be used as the id parameter. When using SmartIDs these are no longer necessary. You are free to assgin a pseudo SmartID as long as it starts with #. This functionality is based on simple string comparison. Potentially defined scopes are not taken into account! Also new in QF‑Test 7.0 is the ability to query overridden elements via rc.getOverrideElement. Following is an example based on SmartID that overrides a component only if necessary.","hash":"ex_overrideElement","h2":"Override components"},"349":{"id":349,"content":"if not rc.getOverrideElement(\"#FirstTextField\"): panel = rc.getComponent(\"myPanel\") for component in panel.getComponents(): if qf.isInstance(component, \"javax.swing.JTextField\"): rc.overrideElement(\"#FirstTextField\", component) break Example 11.19: Conditional rc.overrideElement with SmartID","hash":"ex_overrideElement_SmartID","h2":"Override components"},"350":{"id":350,"content":"Fundamentals of the Jython integration Jython is based on Python 2, not Python 3, so whenever just \"Python\" is mentioned in relation to Jython throughout this manual it refers to Python 2. Python is an object oriented scripting language written in C by Guido van Rossum. A wealth of information including an excellent Python tutorial is available at http://www.python.org. Python is a standard language that has been around for years with extensive freely accessible documentation. Therefore, this manual only explains how Jython is integrated into QF‑Test, not the language itself. Python is a very natural language. Its greatest strength is the readability of Python scripts, so you should have no problems following the examples. Jython (formerly called JPython) is a Java implementation of version 2 of the language Python. It has the same syntax as Python and almost the same set of features. The object systems of Java and Jython are very similar and Jython can be integrated seamlessly into applications like QF‑Test. This makes it an invaluable tool for Java scripting. Jython has its own web page at http://www.jython.org. There is also an extensive tutorial available which may help you get started with this scripting language. QF‑Test uses Jython version 2.7 which supports a large majority of the standard Python 2 library. The Jython script language is not only used in Server script and SUT script nodes, but also in $[...] expressions and (by default) to evaluate conditions like in the attribute Condition of If nodes.","hash":"usec_jythonbasics","h1":"Fundamentals of the Jython integration"},"351":{"id":351,"content":"Jython Variables In Jython scripts, QF‑Test variable references like $(var) or ${group:name} are expanded before the evaluation of the script. This can lead to unwanted effects, especially if the values of these variables contain line breaks or backslashes (\\). Instead, you should use the methods rc.getStr() and rc.getObj() etc. (see \"Accessing variables\") or rc.vars and rc.groups (see \"Referencing variables in scripts and script expressions\"), which are safely evaluated during script execution.","hash":"usec_jython_vars","h2":"Jython Variables"},"352":{"id":352,"content":"Jython Modules Modules for Jython in QF‑Test are just like standard Python modules. You can import the modules into QF‑Test scripts and call their methods, which simplifies the development of complex scripts and increases maintainability since modules are available across test suites. Modules intended to be shared between test suites should be placed in the directory jython under QF‑Test's root directory. Modules written specifically for one test suite can also be placed in the test suite's directory. The version-specific directory qftest-10.0.2-mobile/jython/Lib is reserved for bundled modules. Jython modules must have the file extension .py. The following Jython module defines a procedure sorting an array of numbers. def insertionSort(alist): for index in range(1, len(alist)): currentvalue = alist[index] position = index while position > 0 and alist[position-1] > currentvalue: alist[position] = alist[position-1] position = position-1 alist[position] = currentvalue Example 11.20: The Jython module pysort.py The procedure defined in above module is beeing called in the following Jython script: import pysort alist = [54,26,93,17,77,31,44,55,20] pysort.insertionSort(alist) print(alist) Example 11.21: Jython script using a module","hash":"sec_jython_modules","h2":"Jython Modules"},"353":{"id":353,"content":"Post-mortem debugging of Jython scripts Python comes with a simple line-oriented debugger called pdb. Among its useful features is the ability for post-mortem debugging, i.e. analyzing why a script failed with an exception. In Python, you can simply import the pdb package and run pdb.pm() after an exception. This will put you in a debugger environment where you can examine the variable bindings in effect at the time of failure and also navigate up to the call stack to examine the variables there. It is somewhat similar to analyzing a core dump of a C application. Though Jython comes with pdb, the debugger doesn't work very well inside QF‑Test for various reasons. But at least post-mortem debugging of Jython scripts is supported from the Jython consoles (see \"Fundamentals of the Jython integration\"). After a Server script node fails, open QF‑Test's Jython console, for a failed SUT script node open the respective SUT Jython console, then just execute debug(). This should have a similar effect as pdb.pm() described above. For further information about the Python debugger please refer to the pdb documentation. You can find a step-by-step tutorial on debugging Jython scripts in QF‑Test with external tools in our blog post How to debug Jython Scripts in QF‑Test .","hash":"usec_jythondebug","h2":"Post-mortem debugging of Jython scripts"},"354":{"id":354,"content":"Boolean type Jython now has a real boolean type with values True and False whereas in older versions integer values 0 and 1 served as boolean values. This can cause problems if boolean results from calls like file.exists() are assigned to a QF‑Test variable, e.g. \"fileExists\" and later checked in a Condition attribute in the form $(fileExists) == 1. Such conditions should generally be written as just $(fileExists) or rc.getBool(\"fileExists\") which work well with all Jython versions.","hash":"sec_boolean_type","h2":"Boolean type"},"355":{"id":355,"content":"Jython strings and character encodings Summary and advice Characters in Jython literal strings like \"abc\" used to be limited to 8 bit, causing problems when trying to work with international characters. QF‑Test version 5.3 introduces a solution for international characters in Jython scripts and Condition attributes based on the option Literal Jython strings are unicode (16-bit as in Java). If you start using QF‑Test with version 5.3. or higher, that option is turned on by default. A small percentage of existing scripts will need to be updated when switching to unicode literals, so if QF‑Test encounters an existing older system configuration the option remains off until explicitly turned on. Turning the option on is strongly recommended. The \"Trouble shooting\" section below explains what to do in case you encounter problems. If Jython unicode literals are activated, the option Default character encoding for Jython should be set to \"utf-8\" for maximum flexibility. The main thing to avoid, regardless of the option setting, is expansion of QF‑Test variables in literal Jython strings like \"$(somevar)\". It can cause syntax errors or have unexpected results if the expanded variable contains newlines or backslash characters. Use rc.getStr(\"somevar\") instead. Background and history of Jython in QF‑Test In Java all strings are sequences of 16-bit characters, whereas Jython has two kinds of Strings: 8-bit \"byte strings\" (type <str>) and 16-bit \"unicode strings\" (type <unicode>). The majority of strings used in QF‑Test Jython scripts are either string constants like \"abc\", called literal strings, or Java string values converted to Jython, e.g. the result of rc.getStr(\"varname\"). Conversion from a Java string always results in a 16-bit unicode Jython string. For literal strings the result depends on the setting of the option Literal Jython strings are unicode (16-bit as in Java). When unicode and byte strings are compared or concatenated, Jython needs to convert one into the other. Conversion from unicode to byte strings is called encoding, the other way decoding. There are many different ways to encode 16-bit strings to 8-bit sequences and the rules to do so are called encodings. Common examples include \"utf-8\" or \"latin-1\". The option Default character encoding for Jython specifies the default encoding to use. For backwards compatibility the default used to be \"latin-1\" before QF‑Test 5.3 and is now \"utf-8\", which is preferable because it is the most flexible and supports all international character sets. Jython in QF‑Test is based on Python version 2. In early Python versions strings were made of 8-bit characters. Later, unicode strings with 16-bit characters were added. In Python 2 literal strings like \"abc\" are 8-bit byte strings, prepending 'u', i.e. u\"abc\" turns them into unicode strings. In Python 3 literal strings are unicode and one needs to prepend 'b', i.e. b\"abc\" to get 8-bit strings. In Jython 2.2, Java strings were converted to 8-bit Python strings based on the default encoding of the Java VM, typically ISO-8859-1 (also known as latin-1) in western countries. Since Jython 2.5, every Java string gets interpreted as a unicode Jython string. With 8-bit literal string this results in a lot of implicit conversion between 8-bit and unicode strings, for example when concatenating a Java string - now unicode - and a literal string like rc.getStr(\"path\") + \"/file\". Before QF‑Test version 5.3 the Jython script nodes had further problems with characters outside the 8-bit range, because of the way scripts were passed from QF‑Test to the Jython compiler. In the process of fixing these issues it was decided that the best way to reduce problems with Jython literal strings was to adapt a feature already available in Python 2, namely from future import unicode_literals and make it possible to treat Jython literal strings in QF‑Test as unicode. This results in literal strings being the same in all three scripting languages of QF‑Test and fully compatible with Java strings, so the interaction of Jython scripts with everything else in QF‑Test gets far more natural. The new option Literal Jython strings are unicode (16-bit as in Java) determines whether or not literal Strings in QF‑Test Jython scripts are treated as unicode. For backwards compatibility reasons the default remains 8-bit if QF‑Test encounters an exsiting system configuration, otherwise unicode literals are now the default. The recommended Jython option settings are on for Literal Jython strings are unicode (16-bit as in Java) and \"utf-8\" for Default character encoding for Jython.","hash":"usec_jythonstrings","h2":"Jython strings and character encodings"},"356":{"id":356,"content":"Trouble shooting Jython encoding issues As explained in the previous sections, Jython has two string types, <type 'str'> for 8-bit \"byte\" strings and <type 'unicode'> for 16-bit \"unicode\" strings. Literal strings can be prepended with 'b' (b\"abc\") to get byte strings or with 'u' (u\"abc\") for unicode strings. Plain literal strings (\"abc\") are unicode if the option Literal Jython strings are unicode (16-bit as in Java) is turned on and byte strings otherwise. Java strings resulting from Java function calls like rc.getStr(\"somevar\") are unicode strings. The following advice should help minimizing Jython string encoding issues: Turn the option Literal Jython strings are unicode (16-bit as in Java) on and set the option Default character encoding for Jython to \"utf-8\". Literal strings containing $() expansion like \"$(varname)\" have always been problematic and should be replaced with rc.getStr(\"varname\"). Strings containing Windows filenames need special treatment because of the backslash '\\' character. In 8-bit strings backslashes are retained unless they have special meaning like '\\t' for tab or '\\n' for newline. In 16-bit strings there are several more special escape sequences that are likely to cause syntax errors or unexpected results. Issues are avoided by using rc.getStr(\"filename\") (see above) and prepending 'r' (for \"raw string\") to literal strings, e.g. qftestDir = r\"C:\\Program Files\\QFS\\QF‑Test\". Generally use qf.println instead of print ... because the latter gets passed through an 8-bit stream with the default Java encoding (and in case of an SUT script node also of the operating system) and thus may lose international characters on the way. Converting an object to a string in Jython was traditionally done via str(some_object). As str is the byte string type this always creates a byte string and triggers encoding. Unless you specifically need a byte string it is much better to use unicode(some_object). The types Jython module provides the constant types.StringType and types.UnicodeType as well as the list types.StringTypes cotaining both. The latter is very useful when checking if an object is any type of string, regardless of 8-bit or 16-bit. Instead of if type(some_object) == types.StringType this should be written as if type(some_object) in types.StringTypes In the very few cases where you really need a literal byte string, prepend a 'b', e.g. array.array(b'i', [1, 2, 3]) And of course our support is always there to help.","hash":"usec_jythonstrings_troubleshooting","h2":"Jython strings and character encodings"},"357":{"id":357,"content":"Getting the name of a Java class This simple operation is surprisingly difficult in Jython. Given a Java object you would expect to simply write obj.getClass().getName(). For some objects this works fine, for others it fails with a cryptic message. This can be very frustrating. Things go wrong whenever there is another getName method defined by the class, which is the case for AWT Component, so getting the class name this way fails for all AWT/Swing component classes. In Jython 2.2.1 the accepted workaround was to use the Python idiom obj.__class__.__name__. This no longer works in Jython 2.5 because it no longer returns the fully qualified class name, only the last part. Instead of java.lang.String you now get just String. The only solution that reliably works for version 2.5 is: from java.lang import Class Class.getName(obj.getClass()) This also works for 2.2, but it is not nice, so we initiated a new convenience module with utility methods called qf that gets imported automatically. As a result you can now simply write qf.getClassName(obj).","hash":"sec_getting_the_name_of_a_java_class","h2":"Getting the name of a Java class"},"358":{"id":358,"content":"A complex example We are going to close this section with a complex example, combining features from Jython and QF‑Test to execute a data-driven test. For the example we assume that a simple table with the three columns \"Name\", \"Age\" and \"Address\" should be filled with values read from a file. The file is assumed to be in \"comma-separated-values\" format with \"|\" as the separator character, one line per table-row, e.g.: John Smith|45|Some street, some town Julia Black|35|Another street, same town The example verifies the SUT's functionality in creating new table rows. It calls a QF‑Test procedure that takes the three parameters, \"name\", \"age\", and \"address\", creates a new table-row and fills it with these values. Then the Jython script is used to read and parse the data from the file, iterate over the data-sets and call back to QF‑Test for each table-row to be created. The name of the file to read is passed in a QF‑Test variable named \"filename\". After filling the table, the script compares the state of the actual table component with the data read from the file to make sure everything is OK.","hash":"sec_a_complex_example","h2":"A complex example"},"359":{"id":359,"content":"import string data = [] # read the data from the file fd = open(rc.getStr(\"filename\"), \"r\") line = fd.readline() while line: # remove whitespace line = string.strip(line) # split the line into separate fields # and add them to the data array if len(line) > 0: data.append(string.split(line, \"|\")) line = fd.readline() # now iterate over the rows for row in data: # call a qftest procedure to create # one new table row rc.callProcedure(\"table.createRow\", {\"name\": row[0], \"age\": row[1], \"address\": row[2]}) # verify that the table-rows have been filled correctly table = rc.getComponent(\"tabAddresses\") # check the number of rows rc.check(table.getRowCount() == len(data), \"Row count\") if table.getRowCount() == len(data): # check each row for i in range(len(data)): rc.check(table.getValueAt(i, 0)) == data[i][0], \"Name in row \" + str(i)) rc.check(table.getValueAt(i, 1)) == data[i][1], \"Age in row \" + str(i)) rc.check(table.getValueAt(i, 2)) == data[i][2], \"Address in row \" + str(i)) Example 11.22: Executing a data-driven test Of course, the example above serves only as an illustration. It is too complex to be edited comfortably in QF‑Test and too much is hard-coded, so it is not easily reusable. For real use, the code to read and parse the file should be parameterized and moved to a module, as should the code that verifies the table. This is done in the following Jython script with the methods loadTable to read the data from the file and verifyTable to verify the results. It is saved in a module named csvtable.py. An example module is provided in qftest-10.0.2-mobile/doc/tutorial/csvtable.py. Following is a simplified version: import string def loadTable(file, separator=\"|\"): data = [] fd = open(file, \"r\") line = fd.readline() while line: line = string.strip(line) if len(line) > 0: data.append(string.split(line,separator)) line = fd.readline() return data def verifyTable(rc, table, data): ret = 1 # check the number of rows if table.getRowCount() != len(data): if rc: rc.logError(\"Row count mismatch\") return 0 # check each row for i in range(len(data)): row = data[i] # check the number of columns if table.getModel().getColumnCount() != len(row): if rc: rc.logError(\"Column count mismatch \" + \"in row \" + str(i)) ret = 0 else: # check each cell for j in range(len(row)): val = table.getModel().getValueAt(i, j) if str(val) != row[j]: if rc: rc.logError(\"Mismatch in row \" + str(i) + \" column \" + str(j)) ret = 0 return ret Example 11.23: Writing a module The code above should look familiar. It is an improved version of parts of \"Executing a data-driven test\". With that module in place, the code that has to be written in QF‑Test is reduced to: import csvtable # load the data data = csvtable.loadTable(rc.getStr(\"filename\")) # now iterate over the rows for row in data: # call a qftest procedure to create # one new table row rc.callProcedure(\"table.createRow\", {\"name\": row[0], \"age\": row[1], \"address\": row[2]}) # verify that the table-rows have been filled correctly table = rc.getComponent(\"tabAddresses\") csvtable.verifyTable(rc, table, data) Example 11.24: Calling methods in a module","hash":"ex_data_driven","h2":"A complex example"},"360":{"id":360,"content":"Scripting with Groovy Groovy is another established scripting language for the Java Platform. It was invented by James Strachan and Bob McWhirter in 2003. All you need for doing Groovy is a Java Runtime Environment (JRE) and the groovy-all.jar file. This library contains a compiler to create Java class files and provides the runtime when using that classes in the Java Virtual Machine (JVM). You may think of Groovy as being Java with an additional .jar file. In contrast to Java, Groovy is a dynamic language, meaning that the behavior of an object is determined at runtime. Groovy also allows to load classes from sources without creating class files. Finally, it is easy to embed Groovy scripts into Java applications like QF‑Test. The Groovy syntax is similar to Java, maybe more expressive and easier to read. When coming from Java you can embrace the Groovy style step by step. Of course we cannot explain all aspects of the Groovy language here. For in-depth information, please take a look at the Groovy home page at http://groovy-lang.org/ or read the excellent book \"Groovy in Action\" by Dierk Koenig and others. Perhaps the following tips may help a Java programmer getting started with Groovy. The semicolon is optional as long as a line contains only one statement. Parentheses are sometimes optional, e. g. println 'hello qfs' means the same as println('hello qfs'). Use for (i in 0..<len) { ... } instead of for (int i = 0; i < len; i++) { ... }. The following imports are made by default: java.lang.*, java.util.*, java.io.*, java.net.*, groovy.lang.*, groovy.util.*, java.math.BigInteger, java.math.BigDecimal. Everything is an object, even integers like '1' or booleans like 'true'. Instead of using getter and setter methods like obj.getXxx(), you can simply write obj.xxx to access a property. The operator == checks for equality, not identity, so you can write if (somevar == \"somestring\") instead of if (somevar.equals(\"somestring\")). The method is() checks for identity. Variables have a dynamic type when being defined with the def keyword. Using def x = 1 allows for example to assign a String value to the variable x later in the script. Arrays are defined differently from Java, e. g. int[] a = [1, 2, 3] or def a = [1, 2, 3] as int[]. With def a = [1, 2, 3] you define a List in Groovy. Groovy extends the Java library by defining a set of extra methods for many classes. Thus, you can for example apply an isInteger() method to any String object in a Groovy script. That's what is called GDK (according to the JDK in Java). To get a list of those methods for an arbitrary object obj, you can simply invoke obj.class.metaClass.metaMethods.name or use the following example: import groovy.inspect.Inspector def s = 'abc' def inspector = new Inspector(s) def mm = inspector.getMetaMethods().toList().sort() { it[Inspector.MEMBER_NAME_IDX] } for (m in mm) { println(m[Inspector.MEMBER_TYPE_IDX] + ' ' + m[Inspector.MEMBER_NAME_IDX] + '(' + m[Inspector.MEMBER_PARAMS_IDX] + ')') } Example 11.25: GDK methods for a String object Inner classes are not supported, in most cases you can use Closures instead. A Closure is an object which represents a piece of code. It can take parameters and return a value. Like a block, a Closure is defined with curly braces { ... }. Blocks only exist in context with a class, an interface, static or object initializers, method bodies, if, else, synchronized, for, while, switch, try, catch, and finally. Every other occurrence of {...} is a Closure. As an example let's take a look at the eachFileMatch GDK method of the File class. It takes two parameters, a filter (e. g. a Pattern) and a Closure. That Closure takes itself a parameter, a File object for the current file. def dir = rc.getStr('qftest', 'suite.dir') def pattern = ~/.*\\.qft/ def files = [] new File(dir).eachFileMatch(pattern) { file -> files.add(file.name) } files.each { // A single Closure argument can also be referred with \"it\" rc.logMessage(it) } Example 11.26: Closures Working with Lists and Maps is simpler than in Java. def myList = [1, 2, 3] assert myList.size() == 3 assert myList[0] == 1 myList.add(4) def myMap = [a:1, b:2, c:3] assert myMap['a'] == 1 myMap.each { this.println it.value } Example 11.27: Working with lists and maps","hash":"usec_groovy","h1":"Scripting with Groovy"},"361":{"id":361,"content":"Groovy packages Just like Java classes, Groovy source files (.groovy) can be organized in packages. Those intended to be shared between test suites should be placed in the directory groovy under QF‑Test's root directory. Others that are written specifically for one test suite can also be placed in the directory of the test suite. The version-specific directory qftest-10.0.2-mobile/groovy is reserved for Groovy files provided by Quality First Software GmbH. package my class MyModule { public static int add(int a, int b) { return a + b } } Example 11.28: MyModule.groovy The file MyModule.groovy could be saved in a subdirectory my below the suite directory. Then you can use the add method from MyModule as follows: import my.MyModule as MyLib assert MyLib.add(2, 3) == 5 Example 11.29: Using MyModule This code also shows another groovy feature: Type aliasing. By using import and as in combination you can reference a class by a name of your choice.","hash":"sec_groovy_packages","h2":"Groovy packages"},"362":{"id":362,"content":"Scripting with JavaScript JavaScript has become the most widely used programming language in the web area and is one of the most popular script languages. QF‑Test supports scripting with ECMAScript, which provides a common standard for the variety of different implementations of JavaScript. QF‑Test must run with at least Java 8 to use JavaScript. It is possible to write code for the ECMAScript 6 standard. QF‑Test automatically transpiles the code to the EcmaScript 5 standard before the execution. Special features of JavaScript as compared to other programming languages: There are two different null values: undefined and null. A variable is undefined when it has no value. null is an intended null value that has to be assigned. The == operator checks for equality instead of identity. So you can use if (somevar == \"somestring\") to check for equality. To check for identity use the === operator. Variables declared with the let keyword are dynamically typed. E.g. let x = 1 makes it possible to assign String to x. Constants can be declared with const.","hash":"usec_javascript","h1":"Scripting with JavaScript"},"363":{"id":363,"content":"JavaScript imports The following example shows how functionality can be transfered in a module. The module must be placed in the javascript directory inside the QF‑Test root directory. The module can look like this: var fibonacci = function(n) { return n < 1 ? 0 : n <= 2 ? 1 : fibonacci(n - 1) + fibonacci(n - 2); } function sumDigits(number) { var str = number.toString(); var sum = 0; for (var i = 0; i < str.length; i++) { sum += parseInt(str.charAt(i), 10); } return sum; } // Module exports (Node.js style) exports.fibonacci = fibonacci; exports.sumDigits = sumDigits; Example 11.30: The moremath.js module The moremath.js module defines the two function: fibonacci and sumDigits. Each function has to be exported to . This can be achieved via Node.js like function exports. The following code can now be used inside the script node to take advantage of the moremath.js modules functions: moremath = require('moremath'); console.log(moremath.fibonacci(13)); console.log(moremath.sumDigits(123)); Example 11.31: Usage of the moremath.js module There are multiple ways to import modules. Modules provided by QF‑Test can be imported using the import function. import {Autowin} from 'autowin'; Autowin.doClickHard(0, 0, true); Example 11.32: Using the autowin module Java classes can also be imported using the import function. import {File} from 'java.io'; Example 11.33: Importing Java classes It is also possible to use the \"require\" function for importing npm modules, which are explained in the following section.","hash":"sec_javascript_imports","h2":"JavaScript imports"},"364":{"id":364,"content":"NPM modules npm is a package manager for JavaScript with over 350.000 packages. The available packages are listed here https://www.npmjs.com/. The packages can be used in QF‑Test scripts. They need to be installed in the javascript folder of the QF‑Test root directory. npm install underscore This line installs the npm underscore package from the os command line. There are a few npm modules that are incompatible with the ECMAScript standard as they were written for Node.js. _ = require('underscore'); func = function(num){ return num % 2 == 0; } let evens = _.filter([1, 2, 3, 4, 5, 6], func); console.log(evens); Example 11.34: Usage of the 'underscore' package","hash":"sec_npm_modules","h2":"NPM modules"},"365":{"id":365,"content":"Print statements Besides console.log() there is another method implemented in QF‑Test to show output on the terminal. Note that this print is not defined in ECMAScript and was added for convenience in QF‑Test. print([1,2,3,4]); Example 11.35: Printing an array","hash":"sec_print_statements","h2":"Print statements"},"366":{"id":366,"content":"Execution JavaScript scripts are not executed inside the browser but in the Nashorn engine. This allows the execution of EcmaScript directly in the JVM.","hash":"sec_execution","h2":"Execution"},"367":{"id":367,"content":"Mobile Manual","hash":"","h0":"Command line arguments and exit codes | QF‑Test Manual"},"368":{"id":368,"content":"Mobile Manual","hash":"home-link","h0":"Command line arguments and exit codes | QF‑Test Manual"},"369":{"id":369,"content":"Command line arguments and exit codes","hash":"sec_execution","h0":"Command line arguments and exit codes"},"370":{"id":370,"content":"Call syntax The call syntax for interactive and batch mode varies widely since some command line arguments are specific to interactive mode or batch mode or even sub-modes of batch mode. Note that all of the arguments have sensible default values which you only need to override for special cases. In most cases you'll only need to execute either qftest [<suite> | <run log>]* to run QF‑Test in interactive mode, or qftest -batch [-runlog [<file>]] [-report <directory>] <suite> to execute a test in batch mode. For maximum flexibility the names of all QF‑Test arguments are case-insensitive and embedded '-', '_', '.' and ':' characters are ignored, so -report.html is equivalent to --reportHtml or -report-html. The latter is the officially documented form because it avoids conflicts with Windows PowerShell. The program qftest.exe is a Windows GUI application. When started from a command shell, it will not wait for QF‑Test to terminate but return immediately. Thus, when executing a test in batch mode, you cannot see whether QF‑Test has finished or not (you may put the command into a .bat file to deal with this behaviour). Furthermore you won't see any output from QF‑Test in the console window when using qftest.exe. For both reasons you may prefer to utilize the qftestc.exe Console application when launching QF‑Test from a command shell: It waits for QF‑Test to terminate and print output from Server scripts will be displayed in the console window. Apart from that, everything said about qftest.exe in this chapter holds true for qftestc.exe too. In case the macOS App is used those parameters can be defined directly in QF‑Test via »Edit«-»Options« under General->Startup (please also see the macOS specific note under Starting QF‑Test). Interactive mode The full call syntax for interactive mode is: qftest [-dbg] [-java <executable> (deprecated)] [-noconsole] [-J<java-argument>]* [-allow-shutdown [<shutdown ID>]] [-daemon] [-daemonhost <host>] [-daemonport <port>] [-daemonrmiport <port>] [-dontkillprocesses] [-engine <engine>] [-groovydir <directory>] [-help] [-ipv6] [-javascriptdir <directory>] [-jythondir <directory>] [-jythonport <number>] [-keybindings <value>] [-keystore <keystore file>] [-keypass <keystore password>] [-libpath <path>] [-license <file>] [-license-waitfor <seconds>] [-logdir <directory>] [-noplugins] [-noupdatecheck] [-option <name>=<value>] [-options <file>] [-plugindir <directory>] [-port <number>] [-reuse] [-run] [-runlogdir <directory>] [-runtime] [-serverhost <host>] [-shell <executable>] [-shellarg <argument>] [-suitesfile <file>] [-systemcfg <file>] [-systemdir <directory>] [-tempdir <directory>] [-test <n>|<ID>]* [-usercfg <file>] [-userdir <directory>] [-variable <name>=<value>]* [-version] [<suite> | <run log>]* There are several sub-modes for running QF‑Test in batch mode. The default is to execute one or more test suites. Alternatively QF‑Test can be invoked to create test documentation from test suites or reports from run logs. QF‑Test can also be run in daemon mode where it sits in the background waiting for calls from the outside telling it what to do (see \"Daemon mode\" for further information about the daemon mode). Finally, showing help or version information can also be seen as separate sub-modes. Test execution To execute one or more test suites and create a run log and/or report as a result, use: qftest -batch [-run] [-dbg] [-java <executable> (deprecated)] [-noconsole] [-J<java-argument>]* [-allow-shutdown [<shutdown ID>]] [-clearglobals] [-compact] [-engine <engine>] [-exitcode-ignore-exception] [-exitcode-ignore-error] [-exitcode-ignore-warning] [-groovydir <directory>] [-ipv6] [-javascriptdir <directory>] [-jythondir <directory>] [-jythonport <number>] [-keystore <keystore file>] [-keypass <keystore password>] [-libpath <path>] [-license <file>] [-license-waitfor <seconds>] [-logdir <directory>] [-nolog] [-nomessagewindow] [-noplugins] [-option <name>=<value>] [-options <file>] [-plugindir <directory>] [-port <number>] [-report <directory>] [-report-checks] [-report-customdir <directory>] [-report-doctags] [-report-errors] [-report-exceptions] [-report-html <directory>] [-report-ignorenotimplemented] [-report-ignoreskipped] [-report-junit <directory>] [-report-name <name>] [-report-nodeicons] [-report-passhtml] [-report-piechart] [-report-include-suitename] [-report-scale-thumbnails <percent>] [-report-teststeps] [-report-thumbnails] [-report-warnings] [-report-xml <directory>] [-runid <ID>] [-runlogdir <directory>] [-runlog [<file>]] [-runtime] [-serverhost <host>] [-shell <executable>] [-shellarg <argument>] [-sourcedir <directory>] [-suitesfile <file>] [-splitlog] [-systemcfg <file>] [-systemdir <directory>] [-test <n>|<ID>]* [-threads <number>] [-userdir <directory>] [-variable <name>=<value>]* [-verbose [<level>]] <suite>+ Test execution via QF‑Test daemon The following parameters can be specified when executing a test case by calling a daemon: qftest -batch -calldaemon [-cleanup] [-clearglobals] [-dbg] [-java <executable> (deprecated)] [-noconsole] [-J<java-argument>]* [-daemonhost <host>] [-daemonport <port>] [-exitcode-ignore-exception] [-exitcode-ignore-error] [-exitcode-ignore-warning] [-ipv6] [-keystore <keystore file>] [-keypass <keystore password>] [-nomessagewindow] [-ping] [-option <name>=<value>] [-options <file>] [-runid <ID>] [-runlogdir <directory>] [-runlog [<file>]] [-startclean] [-startsut] [-stopclean] [-stoprun] [-systemdir <directory>] [-suitedir <dir>] [-systemdir <directory>] [-terminate] [-timeout <milliseconds>] [-userdir <directory>] [-variable <name>=<value>]* [-verbose [<level>]] <suite#test case> Change the XML format of existing test suites qftest -batch -convertxml [-convertxml-indent <number>] [-convertxml-linelength <number>] [-convertxml-utf8 <true|false>] (<suite> | <directory>)+ Create test documentation Package or test case documentation can be create for one or more test suites or whole directories. This is described further in \"Reports and test documentation\". The command line syntax is: qftest -batch -gendoc [-dbg] [-java <executable> (deprecated)] [-noconsole] [-J<java-argument>]* [-license <file>] [-license-waitfor <seconds>] [-nomessagewindow] [-option <name>=<value>] [-options <file>] [-pkgdoc <directory>] [-pkgdoc-dependencies] [-pkgdoc-doctags] [-pkgdoc-html <directory>] [-pkgdoc-includelocal] [-pkgdoc-nodeicons] [-pkgdoc-passhtml] [-pkgdoc-sortpackages] [-pkgdoc-sortprocedures] [-pkgdoc-xml <directory>] [-sourcedir <directory>] [-systemdir <directory>] [-testdoc <directory>] [-testdoc-doctags] [-testdoc-followcalls] [-testdoc-html <directory>] [-testdoc-nodeicons] [-testdoc-passhtml] [-testdoc-sorttestcases] [-testdoc-sorttestsets] [-testdoc-teststeps] [-testdoc-xml <directory>] (<suite> | <directory>)+ Create a report from run logs To create a report from one or more run logs or whole directories use: qftest -batch -genreport [-dbg] [-java <executable> (deprecated)] [-noconsole] [-J<java-argument>]* [-license <file>] [-license-waitfor <seconds>] [-nomessagewindow] [-option <name>=<value>] [-options <file>] [-report <directory>] [-report-checks] [-report-customdir <directory>] [-report-doctags] [-report-errors] [-report-exceptions] [-report-html <directory>] [-report-ignorenotimplemented] [-report-ignoreskipped] [-report-junit <directory>] [-report-name <name>] [-report-nodeicons] [-report-passhtml] [-report-piechart] [-report-include-suitename] [-report-scale-thumbnails <percent>] [-report-teststeps] [-report-thumbnails] [-report-warnings] [-report-xml <directory>] [-runlogdir <directory>] (<run log> | <directory>)+ Daemon mode To run QF‑Test in daemon mode as described \"Daemon mode\" use: qftest -batch -daemon [-dbg] [-java <executable> (deprecated)] [-noconsole] [-J<java-argument>]* [-daemonhost <host>] [-daemonport <port>] [-daemonrmiport <port>] [-engine <engine>] [-groovydir <directory>] [-ipv6] [-javascriptdir <directory>] [-jythondir <directory>] [-jythonport <number>] [-keystore <keystore file>] [-keypass <keystore password>] [-libpath <path>] [-license <file>] [-license-waitfor <seconds>] [-logdir <directory>] [-nolog] [-nomessagewindow] [-noplugins] [-option <name>=<value>] [-options <file>] [-plugindir <directory>] [-port <number>] [-runtime] [-serverhost <host>] [-shell <executable>] [-shellarg <argument>] [-splitlog] [-systemcfg <file>] [-systemdir <directory>] [-userdir <directory>] [-variable <name>=<value>]* Import one test suite into another qftest -batch -import [-import-from <test suite>] [-import-into <test suite>] [-import-components] [-import-procedures] [-import-tests] Analyze references of a test suite qftest -batch -analyze [-analyze-target <directory>] [-suitedir <dir>] [-analyze-references] [-analyze-duplicates] [-analyze-invalidchar] [-analyze-emptynodes] [-analyze-components] [-analyze-procedures] [-analyze-dependencies] [-analyze-tests] [-analyze-packages] [-remove-unused-callables] [-remove-unused-components] [-analyze-transitive] [-analyze-followincludes] (<suite> | <directory>)+ Merging run logs qftest -batch -mergelogs [-mergelogs-mode [<mode>]] [-mergelogs-usefqn] [-mergelogs-resultlog [<file>]] [-mergelogs-masterlog [<file>]] (<run log> | <directory>)+ Get version information qftest -batch -version Cleanly terminate one specific QF‑Test instance running on the local system (see -allow-shutdown [<shutdown ID>]) qftest -batch -shutdown <ID> 4711 Pause the current test run on the local system qftest -batch -interrupt-running-instances [-timeout <milliseconds>] Compress images in an existing test suite qftest -batch -compress <suite>+ Get help qftest -batch -help","hash":"sec_callsyntax","h1":"Call syntax"},"371":{"id":371,"content":"Command line arguments Command line arguments for QF‑Test fall in three categories. They can be mixed freely.","hash":"sec_commandline","h1":"Command line arguments"},"372":{"id":372,"content":"Arguments for the starter script These arguments are evaluated directly by the qftest shell script or executable and override settings determined during installation. On Linux these settings are stored in the file launcher.cfg in QF‑Test's system directory, on Windows the file is called launcherwin.cfg.","hash":"sec_arguments_for_the_starter_script","h2":"Arguments for the starter script"},"373":{"id":373,"content":"-batch Run QF‑Test in batch mode. This causes QF‑Test to load and execute a test suite directly and finish with an exit code that represents the result of the test run.","hash":"arg_batch","hp":"Arguments for the starter script","h4":"-batch"},"374":{"id":374,"content":"-dbg Turn on debugging output for the starter script. The same effect is achieved by setting the environment variable QFTEST_DEBUG to a non-empty value. On Windows this causes QF‑Test to open a console window to display the output that would otherwise be invisible unless the argument -noconsole is also given. This also turns on debugging output for the qfclient and java helper programs when using the old connection mechanism (see \"Running an application from QF‑Test\").","hash":"arg_dbg","hp":"Arguments for the starter script","h4":"-dbg"},"375":{"id":375,"content":"-java <executable> (deprecated) The Java executable used to run QF‑Test. The default is java on Linux and javaw.exe on Windows, unless a different value was set during installation. This argument will be removed in a future version of QF‑Test.","hash":"arg_java","hp":"Arguments for the starter script","h4":"-java <executable> (deprecated)"},"376":{"id":376,"content":"-noconsole (Windows only) On Windows this argument suppresses the console window that would otherwise be opened in case -dbg is specified.","hash":"arg_noconsole","hp":"Arguments for the starter script","h4":"-noconsole (Windows only)"},"377":{"id":377,"content":"Arguments for the Java VM You can pass arguments to the Java VM through the starter script by prepending them with -J, e.g. -J-Duser.language=en to set a system property. To set the classpath, prepend -J only to the -cp or -classpath argument, not to the actual value, e.g. -J-classpath myclasses.jar. When setting the classpath this way, QF‑Test's own jar archives need not to be taken into account.","hash":"sec_arguments_for_the_java_vm","h2":"Arguments for the Java VM"},"378":{"id":378,"content":"Arguments for QF‑Test The rest of the arguments are handled by QF‑Test itself when it is executed by the Java virtual machine. These arguments can also be placed in a file using the syntax <name>=<value> for arguments with parameters or <name>=true or <name>=false to turn a simple argument on or off. By default this file is called qftest.options, located in the bin directory of QF‑Test and used only for internal logging purposes. If you change anything in this file, you can move it to QF‑Test's system directory so your changes will still apply after upgrading. Alternatively you can use the -options <file> argument to specify a different file. Arguments given on the command line override arguments from an option file except for those which can be given multiple times. In the latter case the arguments are merged.","hash":"sec_arguments_for_qf_test","h2":"Arguments for QF‑Test"},"379":{"id":379,"content":"-allowkilling Deprecated, use -allow-shutdown without shutdown ID instead.","hash":"arg_allowkilling","hp":"Arguments for QF‑Test","h4":"-allowkilling"},"380":{"id":380,"content":"-allow-shutdown [<shutdown ID>] Explicitly specifies that this QF‑Test instance can be cleanly terminated via a batch call with the -shutdown <ID> argument. An optional string argument can be provided as shutdown ID which allows selective process termination without knowing the process ID. The shutdown ID must contain at least one non-numeric character to be distinguishable from the numerical process ID. If -allow-shutdown [<shutdown ID>] has not been specified on the command line, a running QF‑Test process can only be terminated cleanly by means of the process ID. The argument -allow-shutdown false prohibits all clean termination of the QF‑Test instance, even if -shutdown <ID> is used with the correct process ID.","hash":"arg_allowshutdown","hp":"Arguments for QF‑Test","h4":"-allow-shutdown [<shutdown ID>]"},"381":{"id":381,"content":"-analyze (batch mode only) Run the static validation of test suites. Analyzing results are stored to a given file.","hash":"arg_analyze","hp":"Arguments for QF‑Test","h4":"-analyze (batch mode only)"},"382":{"id":382,"content":"-analyze-target <directory> (batch mode only) The target folder, where the result file should be created.","hash":"arg_analyzeTarget","hp":"Arguments for QF‑Test","h4":"-analyze-target <directory> (batch mode only)"},"383":{"id":383,"content":"-analyze-references (batch mode only) Switch for analyzing references the given test suite.","hash":"arg_analyzeReferences","hp":"Arguments for QF‑Test","h4":"-analyze-references (batch mode only)"},"384":{"id":384,"content":"-analyze-duplicates (batch mode only) Switch for analyzing duplicates of the given test suite.","hash":"arg_analyzeDuplicates","hp":"Arguments for QF‑Test","h4":"-analyze-duplicates (batch mode only)"},"385":{"id":385,"content":"-analyze-invalidchar (batch mode only) Checks the given test suite for invalid characters in node names.","hash":"arg_analyzeInvalidChar","hp":"Arguments for QF‑Test","h4":"-analyze-invalidchar (batch mode only)"},"386":{"id":386,"content":"-analyze-emptynodes (batch mode only) Checks the given test suite for empty nodes.","hash":"arg_analyzeEmptyNodes","hp":"Arguments for QF‑Test","h4":"-analyze-emptynodes (batch mode only)"},"387":{"id":387,"content":"-analyze-components (batch mode only) Switch for analyzing components of the given test suite.","hash":"arg_analyzeComponents","hp":"Arguments for QF‑Test","h4":"-analyze-components (batch mode only)"},"388":{"id":388,"content":"-analyze-dependencies (batch mode only) Switch for analyzing dependency references of the given test suite.","hash":"arg_analyzeDependencies","hp":"Arguments for QF‑Test","h4":"-analyze-dependencies (batch mode only)"},"389":{"id":389,"content":"-analyze-procedures (batch mode only) Switch for analyzing procedure calls of the given test suite.","hash":"arg_analyzeProcedures","hp":"Arguments for QF‑Test","h4":"-analyze-procedures (batch mode only)"},"390":{"id":390,"content":"-analyze-tests (batch mode only) Switch for analyzing test calls of the given test suite.","hash":"arg_analyzeTests","hp":"Arguments for QF‑Test","h4":"-analyze-tests (batch mode only)"},"391":{"id":391,"content":"-analyze-packages (batch mode only) Switch for analyzing packages of the given test suite.","hash":"arg_analyzePackages","hp":"Arguments for QF‑Test","h4":"-analyze-packages (batch mode only)"},"392":{"id":392,"content":"-remove-unused-callables (batch mode only) Switch to remove unused callable nodes.","hash":"arg_AnalyzeUnusedCallables","hp":"Arguments for QF‑Test","h4":"-remove-unused-callables (batch mode only)"},"393":{"id":393,"content":"-remove-unused-components (batch mode only) Switch to remove unused components.","hash":"arg_AnalyzeUnusedComponents","hp":"Arguments for QF‑Test","h4":"-remove-unused-components (batch mode only)"},"394":{"id":394,"content":"-analyze-transitive (batch mode only) Switch for analyzing references and calls transitively, i.e. follow the calls and analyze its content also.","hash":"arg_analyzeTransitive","hp":"Arguments for QF‑Test","h4":"-analyze-transitive (batch mode only)"},"395":{"id":395,"content":"-analyze-followincludes (batch mode only) Switch for analyzing all included test suites of the given test suite.","hash":"arg_analyzeFollowIncludes","hp":"Arguments for QF‑Test","h4":"-analyze-followincludes (batch mode only)"},"396":{"id":396,"content":"-calldaemon (batch mode only) Connect to a running QF‑Test daemon to execute a test case.","hash":"arg_calldaemon","hp":"Arguments for QF‑Test","h4":"-calldaemon (batch mode only)"},"397":{"id":397,"content":"-cleanup (calldaemon mode only) With this argument all TestRunDaemons belonging to a daemon are cleaned up and all clients killed before running the test.","hash":"arg_cleanup","hp":"Arguments for QF‑Test","h4":"-cleanup (calldaemon mode only)"},"398":{"id":398,"content":"-clearglobals (batch mode and calldaemon mode only) If more than one test suite is specified for batch execution, clear global variables and resources before the execution of each test suite. Can also be used in calldaemon mode to clear globals before assigning variables from the command line and starting the test and, if used in combination with -stopclean, to clear globals after the test.","hash":"arg_clearglobals","hp":"Arguments for QF‑Test","h4":"-clearglobals (batch mode and calldaemon mode only)"},"399":{"id":399,"content":"-compact (batch mode only) Create a compact run log which retains only those branches and nodes that contain warnings, errors, exceptions or other information that is relevant to the report. This is equivalent to activating the option Create compact run log in interactive mode. Ignored if log file creation is suppressed with -nolog.","hash":"arg_compact","hp":"Arguments for QF‑Test","h4":"-compact (batch mode only)"},"400":{"id":400,"content":"-compress (batch mode only) Loss-free compresses the images in an existing test suite.","hash":"arg_compress","hp":"Arguments for QF‑Test","h4":"-compress (batch mode only)"},"401":{"id":401,"content":"-convertxml (batch mode only) Run in batch mode to automatically convert the XML file format of test suites according to the following arguments or options.","hash":"arg_convertxml","hp":"Arguments for QF‑Test","h4":"-convertxml (batch mode only)"},"402":{"id":402,"content":"-convertxml-indent <number> (convertxml mode only) Number of blank characters to use per level of indentation. If not specified the value of the option Number of blanks for indentation when saving test suites is used.","hash":"arg_convertxmlIndent","hp":"Arguments for QF‑Test","h4":"-convertxml-indent <number> (convertxml mode only)"},"403":{"id":403,"content":"-convertxml-linelength <number> (convertxml mode only) Maximum length of lines containing XML attributes. If not specified the value of the option Line length for saving test suites is used.","hash":"arg_convertxmlLineLength","hp":"Arguments for QF‑Test","h4":"-convertxml-linelength <number> (convertxml mode only)"},"404":{"id":404,"content":"-convertxml-utf8 <true|false> (convertxml mode only) Whether to save the converted suites with UTF-8 (value true) or ISO-8859-1 encoding (value false). If not specified the value of the option Use UTF-8 encoding for saving test suites is used.","hash":"arg_convertxmlUtf8","hp":"Arguments for QF‑Test","h4":"-convertxml-utf8 <true|false> (convertxml mode only)"},"405":{"id":405,"content":"-daemon Run QF‑Test in daemon mode. Further information is provided in \"Daemon mode\".","hash":"arg_daemon","hp":"Arguments for QF‑Test","h4":"-daemon"},"406":{"id":406,"content":"-daemonhost <host> (daemon or calldaemon mode only) In calldaemon mode, specify the host where to locate the QF‑Test daemon. The default is localhost. When starting a daemon, either in interactive or in batch mode, this parameter defines the hostname or IP address that daemon objects use at RMI level. The default in this case is chosen by Java, typically the IP address of the primary local network interface.","hash":"arg_daemonhost","hp":"Arguments for QF‑Test","h4":"-daemonhost <host> (daemon or calldaemon mode only)"},"407":{"id":407,"content":"-daemonport <port> Specify the registry port for the QF‑Test daemon to listen on and to connect to respectively. The default is 3543 or the port defined with -port <number>.","hash":"arg_daemonport","hp":"Arguments for QF‑Test","h4":"-daemonport <port>"},"408":{"id":408,"content":"-daemonrmiport <port> Specify the port that the QF‑Test daemon should use for RMI communication. Useful only when running the daemon behind a firewall. When running unprotected without SSL (see \"Daemon security considerations\") this can be identical to the daemon port specified with -daemonport <port>. If using SSL, two different ports are required.","hash":"arg_daemonrmiport","hp":"Arguments for QF‑Test","h4":"-daemonrmiport <port>"},"409":{"id":409,"content":"-dontkillprocesses (batch mode only) When finishing batch execution, don't explicitly kill processes started by QF‑Test as part of the tests. However, whether or not a sub-process of QF‑Test survives QF‑Test's exit is system-dependent.","hash":"arg_dontkillprocesses","hp":"Arguments for QF‑Test","h4":"-dontkillprocesses (batch mode only)"},"410":{"id":410,"content":"-engine <engine> Specify which engine license(s) to use. This option is only useful in case the QF‑Test license contains a mix of GUI engine(s) with different numbers of engine licenses. In that case it may be necessary to specify the engine license(s) to use in order to prevent license conflicts with colleagues using the same license. Possible values are \"all\" to use all supported licenses, \"ask\" to bring up a dialog for engine selection or any combination of \"awt\" for AWT/Swing, \"fx\" for JavaFX, \"swt\" for SWT or \"web\" for Web, e.g. \"awt,web\". This is explained in more detail in \"License\".","hash":"arg_engine","hp":"Arguments for QF‑Test","h4":"-engine <engine>"},"411":{"id":411,"content":"-exitcode-ignore-exception (batch and calldaemon mode) For exit code calculation exceptions, errors and warnings are ignored. This means if exceptions, errors or warnings occurred during a test run the exit code will be 0. This option is helpful when integrating QF‑Test with build tools that rate a build as failed dependent on the the exit code.","hash":"arg_exitcodeignoreexception","hp":"Arguments for QF‑Test","h4":"-exitcode-ignore-exception (batch and calldaemon mode)"},"412":{"id":412,"content":"-exitcode-ignore-error (batch and calldaemon mode) For exit code calculation errors and warnings are ignored. This means if just errors and warnings occurred during a test run the exit code will be 0. This option is helpful when integrating QF‑Test with build tools that rate a build as failed dependent on the the exit code.","hash":"arg_exitcodeignoreerror","hp":"Arguments for QF‑Test","h4":"-exitcode-ignore-error (batch and calldaemon mode)"},"413":{"id":413,"content":"-exitcode-ignore-warning (batch and calldaemon mode) For exit code calculation warnings are ignored. This means if just warnings occurred during a test run the exit code will be 0. This option is helpful when integrating QF‑Test with build tools that rate a build as failed dependent on the the exit code.","hash":"arg_exitcodeignorewarning","hp":"Arguments for QF‑Test","h4":"-exitcode-ignore-warning (batch and calldaemon mode)"},"414":{"id":414,"content":"-gendoc (batch mode only) Tell QF‑Test that this batch run serves to create test documentation from test suites.","hash":"arg_gendoc","hp":"Arguments for QF‑Test","h4":"-gendoc (batch mode only)"},"415":{"id":415,"content":"-genreport (batch mode only) Tell QF‑Test that this batch run serves to create a report from run logs.","hash":"arg_genreport","hp":"Arguments for QF‑Test","h4":"-genreport (batch mode only)"},"416":{"id":416,"content":"-groovydir <directory> This argument overrides the default location of the directory for additional Groovy modules. The default directory called groovy is located under QF‑Test's system directory.","hash":"arg_groovydir","hp":"Arguments for QF‑Test","h4":"-groovydir <directory>"},"417":{"id":417,"content":"-help Show help about available command line arguments.","hash":"arg_help","hp":"Arguments for QF‑Test","h4":"-help"},"418":{"id":418,"content":"-import (batch mode only) Import a given test suite into another one. This mode can be used to merge two test suites.","hash":"arg_import","hp":"Arguments for QF‑Test","h4":"-import (batch mode only)"},"419":{"id":419,"content":"-import-from <test suite> (batch mode only) The source test suite, which should be imported into another one.","hash":"arg_importFrom","hp":"Arguments for QF‑Test","h4":"-import-from <test suite> (batch mode only)"},"420":{"id":420,"content":"-import-into <test suite> (batch mode only) The target tests-suite for importing.","hash":"arg_importInto","hp":"Arguments for QF‑Test","h4":"-import-into <test suite> (batch mode only)"},"421":{"id":421,"content":"-import-components (batch mode only) Switch for merging components of two given test suites.","hash":"arg_importComponents","hp":"Arguments for QF‑Test","h4":"-import-components (batch mode only)"},"422":{"id":422,"content":"-import-procedures (batch mode only) Switch for merging packages and procedures of two given test suites.","hash":"arg_importProcedures","hp":"Arguments for QF‑Test","h4":"-import-procedures (batch mode only)"},"423":{"id":423,"content":"-import-tests (batch mode only) Switch for merging test cases and test sets of two given test suites.","hash":"arg_importTests","hp":"Arguments for QF‑Test","h4":"-import-tests (batch mode only)"},"424":{"id":424,"content":"-interrupt-running-instances (batch mode only) Interrupt a test run on the current system and brings up a dialog which allows to pause or to interrupt the current test run.","hash":"arg_interruptrunninginstances","hp":"Arguments for QF‑Test","h4":"-interrupt-running-instances (batch mode only)"},"425":{"id":425,"content":"-ipv6 QF‑Test uses only IPv4 communication, so by default IPv6 support is disabled at Java level which can reduce startup time significantly. In case you need to enable IPv6 support in QF‑Test, for example for use within a plugin, you can use this argument.","hash":"arg_ipv6","hp":"Arguments for QF‑Test","h4":"-ipv6"},"426":{"id":426,"content":"-javascriptdir <directory> This argument overrides the default location of the directory for additional JavaScript modules. The default directory called javascript is located under QF‑Test's system directory.","hash":"arg_javascriptdir","hp":"Arguments for QF‑Test","h4":"-javascriptdir <directory>"},"427":{"id":427,"content":"-jythondir <directory> This argument overrides the default location of the directory for additional Jython modules. The default directory called jython is located under QF‑Test's system directory.","hash":"arg_jythondir","hp":"Arguments for QF‑Test","h4":"-jythondir <directory>"},"428":{"id":428,"content":"-jythonport <number> Tell the embedded Jython interpreter to listen for TCP connections at the specified port. You can then use telnet to connect to that port and get an interactive Jython command line.","hash":"arg_jythonport","hp":"Arguments for QF‑Test","h4":"-jythonport <number>"},"429":{"id":429,"content":"-keybindings <value> (interactive mode only) Currently used only for macOS to switch between the new default Mac bindings (value system) or the old, Windows oriented QF‑Test bindings (value classic).","hash":"arg_keybindings","hp":"Arguments for QF‑Test","h4":"-keybindings <value> (interactive mode only)"},"430":{"id":430,"content":"-keystore <keystore file> An alternative keystore file to use for securing daemon communication with SSL. See \"Daemon security considerations\" for details. To disable SSL by specifying no keystore, use this argument in the form -keystore=.","hash":"arg_keystore","hp":"Arguments for QF‑Test","h4":"-keystore <keystore file>"},"431":{"id":431,"content":"-keypass <keystore password> The password for the keystore file used for securing daemon communication with SSL. See \"Daemon security considerations\" for details.","hash":"arg_keypass","hp":"Arguments for QF‑Test","h4":"-keypass <keystore password>"},"432":{"id":432,"content":"-kill-kunning-instances Deprecated, use -shutdown all instead.","hash":"arg_killrunninginstances","hp":"Arguments for QF‑Test","h4":"-kill-kunning-instances"},"433":{"id":433,"content":"-libpath <path> Override the library path option (Directories holding test suite libraries). The directories of the library path should be separated by the standard path separator character for the system, i.e. ';' for Windows and ':' for Linux. QF‑Test's include directory will automatically be appended to the path.","hash":"arg_libpath","hp":"Arguments for QF‑Test","h4":"-libpath <path>"},"434":{"id":434,"content":"-license <file> Set the location of the license file (see \"The license file\").","hash":"arg_license","hp":"Arguments for QF‑Test","h4":"-license <file>"},"435":{"id":435,"content":"-license-waitfor <seconds>; Specify an interval in seconds to wait during QF‑Test startup in case a license is not immediately available. This timeout is also in effect when renewing a lease from the QF‑Test license server and the server is temporarily unavailable.","hash":"arg_license.waitfor","hp":"Arguments for QF‑Test","h4":"-license-waitfor <seconds>;"},"436":{"id":436,"content":"-logdir <directory> This argument overrides the default location of the directory into which QF‑Test saves its internal log files. The default log directory is called log and located under QF‑Test's system directory.","hash":"arg_logdir","hp":"Arguments for QF‑Test","h4":"-logdir <directory>"},"437":{"id":437,"content":"-mergelogs (batch mode only) Tell QF‑Test that this batch run serves to merge several run logs. You can find a detailed description at \"Merging run logs\".","hash":"arg_MergeRunlog","hp":"Arguments for QF‑Test","h4":"-mergelogs (batch mode only)"},"438":{"id":438,"content":"-mergelogs-masterlog [<file>] (batch mode only) The path to the run log which will act as master run log for log mering, if the run log should be patched with newer results. Use this switch, if you want to replace individual test cases in that run log with results from a rerun.","hash":"arg_MergeRunlogMasterLog","hp":"Arguments for QF‑Test","h4":"-mergelogs-masterlog [<file>] (batch mode only)"},"439":{"id":439,"content":"-mergelogs-mode [<mode>] (batch mode only) Specifies the mode how run logs should be merged based in the main run log, specified with the -mergelogs-masterlog [<file>] switch. You can specify the modes \"replace\", \"merge\" and \"append\". \"replace\" takes the new results and overwrites the existing test cases from the main run log. \"merge\" adds the new test cases to main run log and \"append\" simply adds the new run log to the main run log.","hash":"arg_MergeRunlogMode","hp":"Arguments for QF‑Test","h4":"-mergelogs-mode [<mode>] (batch mode only)"},"440":{"id":440,"content":"-mergelogs-resultlog [<file>] (batch mode only) The path to the run log which will contain the merged results of the master run log and the new run logs with updates. So, this will be the new and clean run log file.","hash":"arg_MergeRunlogResultLog","hp":"Arguments for QF‑Test","h4":"-mergelogs-resultlog [<file>] (batch mode only)"},"441":{"id":441,"content":"-mergelogs-usefqn (batch mode only) Use that switch, if the full qualified name of test cases should be used in case of merging run logs. Otherwise only the name of test cases will be used without test set names.","hash":"arg_MergeRunlogUseFqn","hp":"Arguments for QF‑Test","h4":"-mergelogs-usefqn (batch mode only)"},"442":{"id":442,"content":"-nolog (batch mode only) Suppress the automatic creation of a run log. If any of -runlog [<file>], -report <directory>, -report-html <directory>, -report-xml <directory> or -report-junit <directory> is given, this argument is ignored. This option is retained for backwards compatibility only. To keep memory use manageable, split run logs should be used instead (see -splitlog).","hash":"arg_nolog","hp":"Arguments for QF‑Test","h4":"-nolog (batch mode only)"},"443":{"id":443,"content":"-nomessagewindow (batch mode only) In case of a fatal error in batch mode QF‑Test prints an error message to the console and for improved visibility also brings up an error dialog for about 30 seconds. That dialog can be suppressed with the help of this argument. Batch commands that don't require an actual display, i.e. all batch commands that do not execute tests, will run in AWT headless mode if this argument is specified.","hash":"arg_nomessagewindow","hp":"Arguments for QF‑Test","h4":"-nomessagewindow (batch mode only)"},"444":{"id":444,"content":"-noplugins Prevent from loading plugins in QF‑Test as well as in clients. This may help to debug problems caused by plugins.","hash":"arg_noplugins","hp":"Arguments for QF‑Test","h4":"-noplugins"},"445":{"id":445,"content":"-noupdatecheck Using this argument disables the automatic update check. This overrides the update options (see \"Updates\").","hash":"arg_noupdatecheck","hp":"Arguments for QF‑Test","h4":"-noupdatecheck"},"446":{"id":446,"content":"-option <name>=<value> Specifies options. -option <name>=<value> sets a value of the option with a name <name> to <value>. This argument can be given more than once to set several options.","hash":"arg_option","hp":"Arguments for QF‑Test","h4":"-option <name>=<value>"},"447":{"id":447,"content":"-options <file> Override the location of the file used to specify additional command line arguments. This argument can be given more than once to use several sources of command line arguments.","hash":"arg_options","hp":"Arguments for QF‑Test","h4":"-options <file>"},"448":{"id":448,"content":"-ping (calldaemon mode only) Use this option, if you want to check whether a daemon is up and running.","hash":"arg_ping","hp":"Arguments for QF‑Test","h4":"-ping (calldaemon mode only)"},"449":{"id":449,"content":"-pkgdoc <directory> (batch mode only) With this argument QF‑Test creates both HTML and XML pkgdoc documentation. If no directory is given, it is created from the basename of the suite.","hash":"arg_pkgdoc","hp":"Arguments for QF‑Test","h4":"-pkgdoc <directory> (batch mode only)"},"450":{"id":450,"content":"-pkgdoc-dependencies (batch mode only) Whether to list dependencies when creating the pkgdoc documentation. Default is true, use -pkgdoc-dependencies=false to disable.","hash":"arg_pkgdoc.dependencies","hp":"Arguments for QF‑Test","h4":"-pkgdoc-dependencies (batch mode only)"},"451":{"id":451,"content":"-pkgdoc-doctags (batch mode only) Whether to use the QFS doctag extensions when creating the pkgdoc documentation. Default is true, use -pkgdoc-doctags=false to disable.","hash":"arg_pkgdoc.doctags","hp":"Arguments for QF‑Test","h4":"-pkgdoc-doctags (batch mode only)"},"452":{"id":452,"content":"-pkgdoc-html <directory> (batch mode only) With this argument QF‑Test creates HTML pkgdoc documentation. If no directory is given, it is created from the basename of the suite.","hash":"arg_pkgdoc.html","hp":"Arguments for QF‑Test","h4":"-pkgdoc-html <directory> (batch mode only)"},"453":{"id":453,"content":"-pkgdoc-includelocal (batch mode only) Whether to include local packages and procedures (those whose names begin with an '_'). Default is false.","hash":"arg_pkgdoc.includelocal","hp":"Arguments for QF‑Test","h4":"-pkgdoc-includelocal (batch mode only)"},"454":{"id":454,"content":"-pkgdoc-nodeicons (batch mode only) Whether to show icons for nodes in the pkgdoc documentation. Default is true, use -pkgdoc-nodeicons=false to disable.","hash":"arg_pkgdoc.nodeicons","hp":"Arguments for QF‑Test","h4":"-pkgdoc-nodeicons (batch mode only)"},"455":{"id":455,"content":"-pkgdoc-passhtml (batch mode only) Whether to pass HTML tags in comments through to the HTML pkgdoc. Default is true, use -pkgdoc-passhtml=false to disable.","hash":"arg_pkgdoc.passhtml","hp":"Arguments for QF‑Test","h4":"-pkgdoc-passhtml (batch mode only)"},"456":{"id":456,"content":"-pkgdoc-sortpackages (batch mode only) Whether to sort packages alphabetically. Default is true, use -pkgdoc-sortpackages=false to disable.","hash":"arg_pkgdoc.sortpackages","hp":"Arguments for QF‑Test","h4":"-pkgdoc-sortpackages (batch mode only)"},"457":{"id":457,"content":"-pkgdoc-sortprocedures (batch mode only) Whether to sort procedures alphabetically. Default is true, use -pkgdoc-sortprocedures=false to disable.","hash":"arg_pkgdoc.sortprocedures","hp":"Arguments for QF‑Test","h4":"-pkgdoc-sortprocedures (batch mode only)"},"458":{"id":458,"content":"-pkgdoc-splitparagraph (batch mode only) Specifies whether comments are splitted into paragraphs by using empty lines. Default is true, with -pkgdoc-splitparagraph=false it is possible to disable this option.","hash":"arg_pkgdoc.splitparagraph","hp":"Arguments for QF‑Test","h4":"-pkgdoc-splitparagraph (batch mode only)"},"459":{"id":459,"content":"-pkgdoc-stylesheet <file> (batch mode only) Optional XSLT Stylesheet for the second step of the transformation.","hash":"arg_pkgdoc.stylesheet","hp":"Arguments for QF‑Test","h4":"-pkgdoc-stylesheet <file> (batch mode only)"},"460":{"id":460,"content":"-pkgdoc-xml <directory> (batch mode only) With this argument QF‑Test creates XML pkgdoc documentation. If no directory is given, it is created from the basename of the suite.","hash":"arg_pkgdoc.xml","hp":"Arguments for QF‑Test","h4":"-pkgdoc-xml <directory> (batch mode only)"},"461":{"id":461,"content":"-plugindir <directory> This argument overrides the default location of the directory for plugins, jar files that should be made accessible to scripts. The default directory called plugin is located under QF‑Test's system directory. See \"The plugin directory\" for more information about plugins.","hash":"arg_plugindir","hp":"Arguments for QF‑Test","h4":"-plugindir <directory>"},"462":{"id":462,"content":"-port <number> The TCP port on which QF‑Test communicates with the SUT. By default QF‑Test uses an arbitrary dynamic port where it creates its own RMI registry. A specific port should only be requested if it must be hard-coded when starting the SUT.","hash":"arg_port","hp":"Arguments for QF‑Test","h4":"-port <number>"},"463":{"id":463,"content":"-report <directory> (batch mode only) Create a combined XML/HTML report. The directory name may contain placeholders as explained in \"Placeholders in the filename parameter for run log and report\".","hash":"arg_report","hp":"Arguments for QF‑Test","h4":"-report <directory> (batch mode only)"},"464":{"id":464,"content":"-report-checks (batch mode only) Whether to list checks in the report. Default is false. Please note: the argument refers only to checks with default result handling, i.e. just logging to the run log, not setting a variable or throwing an exception. For more information please see \"Report contents\".","hash":"arg_report.checks","hp":"Arguments for QF‑Test","h4":"-report-checks (batch mode only)"},"465":{"id":465,"content":"-report-customdir <directory> (batch mode only) Directory containing css stylesheets and icons for custom reports.","hash":"arg_report.customdir","hp":"Arguments for QF‑Test","h4":"-report-customdir <directory> (batch mode only)"},"466":{"id":466,"content":"-report-doctags (batch mode only) Whether to use the QFS doctag extensions when creating the report. Default is true, use -report-doctags=false to disable.","hash":"arg_report.doctags","hp":"Arguments for QF‑Test","h4":"-report-doctags (batch mode only)"},"467":{"id":467,"content":"-report-errors (batch mode only) Whether to list errors in the report. Default is true, use -report-errors=false to disable.","hash":"arg_report.errors","hp":"Arguments for QF‑Test","h4":"-report-errors (batch mode only)"},"468":{"id":468,"content":"-report-exceptions (batch mode only) Whether to list exceptions in the report. Default is true, use -report-exceptions=false to disable.","hash":"arg_report.exceptions","hp":"Arguments for QF‑Test","h4":"-report-exceptions (batch mode only)"},"469":{"id":469,"content":"-report-html <directory> (batch mode only) Create an HTML report. The directory name may contain placeholders as explained in \"Placeholders in the filename parameter for run log and report\".","hash":"arg_report.html","hp":"Arguments for QF‑Test","h4":"-report-html <directory> (batch mode only)"},"470":{"id":470,"content":"-report-ignorenotimplemented (batch mode only) Whether to ignore nodes that are not implemented in the report in which case the legend and respective columns for not implemented tests are also not shown. Default is false.","hash":"arg_report.ignorenotimplemented","hp":"Arguments for QF‑Test","h4":"-report-ignorenotimplemented (batch mode only)"},"471":{"id":471,"content":"-report-ignoreskipped (batch mode only) Whether to ignore skipped nodes in the report in which case the legend and respective columns for skipped tests are also not shown. Default is false.","hash":"arg_report.ignoreskipped","hp":"Arguments for QF‑Test","h4":"-report-ignoreskipped (batch mode only)"},"472":{"id":472,"content":"-report-junit <directory> (batch mode only) Create a report in JUnit XML format as understood by many Continuous Integration Tools. The directory name may contain placeholders as explained in \"Placeholders in the filename parameter for run log and report\".","hash":"arg_report.junit","hp":"Arguments for QF‑Test","h4":"-report-junit <directory> (batch mode only)"},"473":{"id":473,"content":"-report-name <name> (batch mode only) Specify the name for the report, meaning its identifier, not a file name. Default is the runid. The name may contain placeholders as explained in \"Placeholders in the filename parameter for run log and report\".","hash":"arg_report.name","hp":"Arguments for QF‑Test","h4":"-report-name <name> (batch mode only)"},"474":{"id":474,"content":"-report-nodeicons (batch mode only) Whether to show icons for nodes in the report. Default is true, use -report-nodeicons=false to disable.","hash":"arg_report.nodeicons","hp":"Arguments for QF‑Test","h4":"-report-nodeicons (batch mode only)"},"475":{"id":475,"content":"-report-passhtml (batch mode only) Whether to pass HTML tags in comments through to the HTML report. Default is true, -report-passhtml=false to disable.","hash":"arg_report.passhtml","hp":"Arguments for QF‑Test","h4":"-report-passhtml (batch mode only)"},"476":{"id":476,"content":"-report-piechart (batch mode only) Whether to create a pie chart in the top part of the HTML report. Default is true, -report-piechart=false to disable.","hash":"arg_report.piechart","hp":"Arguments for QF‑Test","h4":"-report-piechart (batch mode only)"},"477":{"id":477,"content":"-report-include-suitename (batch mode only) Whether to use the value of the Name attribute of the Test suite step as label of a testsuite in the HTML report. Default is true, -report-include-suitename=false to use the file name instead.","hash":"arg_report.includesuitename","hp":"Arguments for QF‑Test","h4":"-report-include-suitename (batch mode only)"},"478":{"id":478,"content":"-report-scale-thumbnails <percent> (batch mode only) How to scale thumbnail images for screenshots in the error listings of the report. A plain integer value is interpreted as percent of the original image size. Since QF‑Test version 9.0 the preferred alternative is a string of the form <width>x<height> that causes images to be scaled proportionally so that neither the given width nor height are exceeded. Default is 140x70.","hash":"arg_report.scale-thumbnails","hp":"Arguments for QF‑Test","h4":"-report-scale-thumbnails <percent> (batch mode only)"},"479":{"id":479,"content":"-report-teststeps (batch mode only) Whether to list test steps in the report. Default is true, use -report-teststeps=false to disable.","hash":"arg_report.teststeps","hp":"Arguments for QF‑Test","h4":"-report-teststeps (batch mode only)"},"480":{"id":480,"content":"-report-thumbnails (batch mode only) Whether to display thumbnail images for screenshots in the error listings of the report. Default is false.","hash":"arg_report.thumbnails","hp":"Arguments for QF‑Test","h4":"-report-thumbnails (batch mode only)"},"481":{"id":481,"content":"-report-warnings (batch mode only) Whether to show warning information in the report. Default is true.","hash":"arg_report.warnings","hp":"Arguments for QF‑Test","h4":"-report-warnings (batch mode only)"},"482":{"id":482,"content":"-report-xml <directory> (batch mode only) Create an XML report. The directory name may contain placeholders as explained in \"Placeholders in the filename parameter for run log and report\".","hash":"arg_report.xml","hp":"Arguments for QF‑Test","h4":"-report-xml <directory> (batch mode only)"},"483":{"id":483,"content":"-reuse (interactive mode only) This argument is used mainly when launching QF‑Test from a desktop icon or the Windows explorer through a file association. It tells the newly started QF‑Test instance to search for an already running version of QF‑Test and ask that to open the given file(s). If another instance can be reused in that way, the newly started program will terminate immediately and new windows for the file(s) will be opened by the old instance.","hash":"arg_reuse","hp":"Arguments for QF‑Test","h4":"-reuse (interactive mode only)"},"484":{"id":484,"content":"-run (interactive and batch mode) If this parameter is set for the interactive mode, it will directly start the specified test suites or tests after launching QF‑Test. Using it in batch mode explicitly tells QF‑Test that this batch run is for actual test execution as opposed to generating documentation or a report. As this is the default operation for batch mode this argument can be omitted.","hash":"arg_run","hp":"Arguments for QF‑Test","h4":"-run (interactive and batch mode)"},"485":{"id":485,"content":"-runid <ID> (batch and calldaemon mode) Specify an ID for the test run. The ID may contain placeholders as explained in \"Placeholders in the filename parameter for run log and report\" and will itself serve as a replacement for the placeholder %i/+i.","hash":"arg_runid","hp":"Arguments for QF‑Test","h4":"-runid <ID> (batch and calldaemon mode)"},"486":{"id":486,"content":"-runlog [<file>] (batch and calldaemon mode) Save the run log in the given file. The optional filename may contain placeholders as explained in \"Placeholders in the filename parameter for run log and report\". If no filename is given, it is composed of the basename of the suite and a timestamp. If missing, the extension .qrz is added automatically and the run log is saved compressed. Otherwise the extension .qrl or .qrz determines compression. Even without this argument a run log is created unless suppressed with -nolog or when a report is generated. The default value is %p%b.qrz. In calldaemon mode, a run log will be stored only if a (local) filename is specified.","hash":"arg_runlog","hp":"Arguments for QF‑Test","h4":"-runlog [<file>] (batch and calldaemon mode)"},"487":{"id":487,"content":"-runlogdir <directory> In interactive mode this argument overrides the option Directory for run logs at a special layer for command line arguments. If specified, interactively changing the option has no effect whereas changing it at script level is still possible. In batch mode this directory serves as the target base directory for saving run logs unless the filename of the run logs specified with -runlog [<file>] is an absolute path. If this argument is given and a report is generated, the files in the report will be laid out according to the structure of the run logs relative to this directory. The directory name may contain placeholders as explained in \"Placeholders in the filename parameter for run log and report\".","hash":"arg_runlogdir","hp":"Arguments for QF‑Test","h4":"-runlogdir <directory>"},"488":{"id":488,"content":"-runtime Use a runtime license only. In batch mode, QF‑Test will normally use a runtime license (or multiple runtime licenses if -threads <number> is given). If not enough free runtime licenses are available, full development licenses will be used instead unless -runtime is given in which case no development license is used and QF‑Test will fail with an error message. In interactive mode, if -runtime is given, QF‑Test will use a runtime license instead of a full development license. In that mode, any test suite can be loaded and tests can be run interactively as usual, including debugging support. Saving of test suites will be disabled, however, though test suites can be modified for temporary experiments.","hash":"arg_runtime","hp":"Arguments for QF‑Test","h4":"-runtime"},"489":{"id":489,"content":"-shell <executable> The shell to use when executing a Execute shell command node. Default for Linux is /bin/sh, for Windows COMMAND.COM or cmd.exe.","hash":"arg_shell","hp":"Arguments for QF‑Test","h4":"-shell <executable>"},"490":{"id":490,"content":"-shellarg <argument> The argument that causes the shell specified with -shell <executable> to execute the following argument and then exit. For Linux shells this is typically -c, COMMAND.COM and cmd.exe expect /c. If you have Linux tools installed on Windows and specify sh or bash as the shell to use, don't forget to change -shellarg <argument> to -c.","hash":"arg_shellarg","hp":"Arguments for QF‑Test","h4":"-shellarg <argument>"},"491":{"id":491,"content":"-shutdown <ID> (batch mode only) Cleanly terminates the QF‑Test instance with the given process ID (only digits) or shutdown ID on the local system, if allowed (see -allow-shutdown [<shutdown ID>]). In batch mode this means that a running test is stopped, connected clients are terminated, the run log is saved, and the QF‑Test instance terminates with the exit code -12. If QF‑Test is running interactively, all open testsuites are closed without saving modifications. In special cases this might be useful, especially if auto-save is configured in a meaningful way (see Auto-save interval (s)). The special shutdown ID all terminates all running QF‑Test processes that were started with the -allow-shutdown [<shutdown ID>] argument to explicitly allow that.","hash":"arg_shutdown","hp":"Arguments for QF‑Test","h4":"-shutdown <ID> (batch mode only)"},"492":{"id":492,"content":"-serverhost <host> Set the host name or IP address for communication between QF‑Test and the SUT. You may need to do this when running QF‑Test and the SUT on different machines or if you experience troubles with reverse name lookup. The default is to use the loopback interface. To use the primary network interface of the local host, specify -serverhost= with an empty value.","hash":"arg_serverhost","hp":"Arguments for QF‑Test","h4":"-serverhost <host>"},"493":{"id":493,"content":"-sourcedir <directory> (batch mode only) If this argument is given and a report is generated, the files in the report will be laid out according to the structure of the test suites relative to this directory unless -runlogdir <directory> is also specified. In any case, the directory of a test suite listed in the report will only be listed if this argument is specified and the test suite is located below this directory.","hash":"arg_sourcedir","hp":"Arguments for QF‑Test","h4":"-sourcedir <directory> (batch mode only)"},"494":{"id":494,"content":"-splitlog (batch mode only) In batch mode split run logs (see \"Split run logs\") are enabled by default and can be turned off via -splitlog=false. If -splitlog is explicitly specified without parameter, the default extension for run logs is changed from .qrz to .qzp so as to create split run logs in ZIP format. The same can be achieved by specifying the name of the run log explicitly with the desired extension.","hash":"arg_splitlog","hp":"Arguments for QF‑Test","h4":"-splitlog (batch mode only)"},"495":{"id":495,"content":"-startclean (calldaemon mode only) With this argument all contexts of the shared TestRunDaemon are cleaned up and released before running the test.","hash":"arg_startclean","hp":"Arguments for QF‑Test","h4":"-startclean (calldaemon mode only)"},"496":{"id":496,"content":"-startsut (only for internal use) This argument is used to start a client application on a remote host. You should not work with this argument directly. The standard library qfs.qft contains a procedure qfs.daemon.startRemoteSUT which can be use for this purpose.","hash":"arg_startsut","hp":"Arguments for QF‑Test","h4":"-startsut (only for internal use)"},"497":{"id":497,"content":"-stopclean (calldaemon mode only) With this argument all contexts of the shared TestRunDaemon are cleaned up and released after running the test.","hash":"arg_stopclean","hp":"Arguments for QF‑Test","h4":"-stopclean (calldaemon mode only)"},"498":{"id":498,"content":"-stoprun (calldaemon mode only) Stop a running test executed by the Daemon on the given host and port. This argument can be combined with -cleanup or -stopclean.","hash":"arg_stoprun","hp":"Arguments for QF‑Test","h4":"-stoprun (calldaemon mode only)"},"499":{"id":499,"content":"-suitedir <dir> (calldaemon mode only) Specify the (remote) directory where the QF‑Test Daemon looks for test suites. Use an absolute path when specifying the test to execute, if this argument is not given.","hash":"arg_suitedir","hp":"Arguments for QF‑Test","h4":"-suitedir <dir> (calldaemon mode only)"},"500":{"id":500,"content":"-suitesfile <file> (interactive and batch mode) Specify a text file containing test suites or test cases to be executed. You should specify one test suite per line. Individual test cases can be added as for the the -test <n>|<ID> argument. You can find some samples in the table below.","hash":"arg_suitesfile","hp":"Arguments for QF‑Test","h4":"-suitesfile <file> (interactive and batch mode)"},"501":{"id":501,"content":"Specify a text file containing test suites or test cases to be executed. You should specify one test suite per line. Individual test cases can be added as for the the -test <n>|<ID> argument. You can find some samples in the table below. Entries in file Description path/suite1.qft path/suite2.qft Both test suites will be executed. path/suite1.qft path/suite2.qft#id-tc1 Test suite suite1.qft will be executed completely and test case 'id-tc1' of suite2.qft will be executed. path/suite1.qft -test tc1 -test tc2 Test cases tc1 and tc2 of suite1.qft will be executed. Table 36.1: Samples -suitesfile <file>","hash":"table_36.1","hp":"Arguments for QF‑Test","h4":"-suitesfile <file> (interactive and batch mode)"},"502":{"id":502,"content":"-systemcfg <file> Set the location of the system configuration file (see \"The configuration files\").","hash":"arg_systemcfg","hp":"Arguments for QF‑Test","h4":"-systemcfg <file>"},"503":{"id":503,"content":"-systemdir <directory> Override the location of the directory holding the system configuration files (see \"The configuration files\") including optional plugins and scripting modules. If any of -systemcfg <file>, -plugindir <directory>, -jythondir <directory>, -groovydir <directory> or -javascriptdir <directory> are also specified they have precedence.","hash":"arg_systemdir","hp":"Arguments for QF‑Test","h4":"-systemdir <directory>"},"504":{"id":504,"content":"-tempdir <directory> (interactive mode only) Can be used to specify a temporary directory which is needed on Windows only for the context sensitive help system. By default the values of the environment variables TEMP and TMP are tried.","hash":"arg_tempdir","hp":"Arguments for QF‑Test","h4":"-tempdir <directory> (interactive mode only)"},"505":{"id":505,"content":"-terminate (calldaemon mode only) Use this option, if you want to terminate a running QF‑Test daemon.","hash":"arg_terminate","hp":"Arguments for QF‑Test","h4":"-terminate (calldaemon mode only)"},"506":{"id":506,"content":"-test <n>|<ID> (interactive and batch mode) Without this argument all the top-level tests of the suite are executed one after the other. Using -test <n>|<ID>, you can select specific tests. An arbitrary node located anywhere in a test suite can be accessed by its QF‑Test ID. Test case or Test set nodes can be referenced also by their qualified name. Top-level tests can also be selected by their index, the index for the first test being 0. You can use this argument multiple times, even for the same test.","hash":"arg_test","hp":"Arguments for QF‑Test","h4":"-test <n>|<ID> (interactive and batch mode)"},"507":{"id":507,"content":"-testdoc <directory> (batch mode only) With this argument QF‑Test creates both HTML and XML testdoc documentation. If no directory is given, it is created from the basename of the suite.","hash":"arg_testdoc","hp":"Arguments for QF‑Test","h4":"-testdoc <directory> (batch mode only)"},"508":{"id":508,"content":"-testdoc-doctags (batch mode only) Whether to use the QFS doctag extensions when creating the testdoc documentation. Default is true, use -testdoc-doctags=false to disable.","hash":"arg_testdoc.doctags","hp":"Arguments for QF‑Test","h4":"-testdoc-doctags (batch mode only)"},"509":{"id":509,"content":"-testdoc-followcalls (batch mode only) By default QF‑Test ignores Test call nodes during testdoc creation. With this argument the target Test case, Test set or whole test suite are processed as if they were part of the original test suite. Thus it is possible to create a subset testdoc documentation by creating a dedicated test suite with Test calls to the required parts.","hash":"arg_testdoc.followcalls","hp":"Arguments for QF‑Test","h4":"-testdoc-followcalls (batch mode only)"},"510":{"id":510,"content":"-testdoc-html <directory> (batch mode only) With this argument QF‑Test creates HTML testdoc documentation. If no directory is given, it is created from the basename of the suite.","hash":"arg_testdoc.html","hp":"Arguments for QF‑Test","h4":"-testdoc-html <directory> (batch mode only)"},"511":{"id":511,"content":"-testdoc-nodeicons (batch mode only) Whether to show icons for nodes in the testdoc documentation. Default is true, use -testdoc-nodeicons=false to disable.","hash":"arg_testdoc.nodeicons","hp":"Arguments for QF‑Test","h4":"-testdoc-nodeicons (batch mode only)"},"512":{"id":512,"content":"-testdoc-passhtml (batch mode only) Whether to pass HTML tags in comments through to the HTML testdoc. Default is true, use -testdoc-passhtml=false to disable.","hash":"arg_testdoc.passhtml","hp":"Arguments for QF‑Test","h4":"-testdoc-passhtml (batch mode only)"},"513":{"id":513,"content":"-testdoc-sorttestcases (batch mode only) Whether to sort test cases alphabetically. Default is true, use -testdoc-sorttestcases=false to disable.","hash":"arg_testdoc.sorttestcases","hp":"Arguments for QF‑Test","h4":"-testdoc-sorttestcases (batch mode only)"},"514":{"id":514,"content":"-testdoc-sorttestsets (batch mode only) Whether to sort test sets alphabetically. Default is true, use -testdoc-sorttestsets=false to disable.","hash":"arg_testdoc.sorttestsets","hp":"Arguments for QF‑Test","h4":"-testdoc-sorttestsets (batch mode only)"},"515":{"id":515,"content":"-testdoc-splitparagraph (batch mode only) Specifies whether comments are splitted into paragraphs by using empty lines. Default is true, with -testdoc-splitparagraph=false it is possible to disable this option.","hash":"arg_testdoc.splitparagraph","hp":"Arguments for QF‑Test","h4":"-testdoc-splitparagraph (batch mode only)"},"516":{"id":516,"content":"-testdoc-stylesheet <file> (batch mode only) Optional XSLT Stylesheet for the second step of the transformation.","hash":"arg_testdoc.stylesheet","hp":"Arguments for QF‑Test","h4":"-testdoc-stylesheet <file> (batch mode only)"},"517":{"id":517,"content":"-testdoc-teststeps (batch mode only) Whether to list test steps in the testdoc documentation. Default is true, use -testdoc-teststeps=false to disable.","hash":"arg_testdoc.teststeps","hp":"Arguments for QF‑Test","h4":"-testdoc-teststeps (batch mode only)"},"518":{"id":518,"content":"-testdoc-xml <directory> (batch mode only) With this argument QF‑Test creates XML testdoc documentation. If no directory is given, it is created from the basename of the suite.","hash":"arg_testdoc.xml","hp":"Arguments for QF‑Test","h4":"-testdoc-xml <directory> (batch mode only)"},"519":{"id":519,"content":"-threads <number> (batch mode only) Run the same test suite in a number of parallel threads. Typically used for the purpose of load testing. One license is required per thread, so normally -runtime should be specified as well. See \"Performing GUI-based load tests\" for more information about load tests.","hash":"arg_threads","hp":"Arguments for QF‑Test","h4":"-threads <number> (batch mode only)"},"520":{"id":520,"content":"-timeout <milliseconds> (batch or calldaemon mode only) Give a timeout value in milliseconds for the test run when executing a test in batch mode or through the QF‑Test daemon. Default is infinite.","hash":"arg_timeout","hp":"Arguments for QF‑Test","h4":"-timeout <milliseconds> (batch or calldaemon mode only)"},"521":{"id":521,"content":"-usercfg <file> (interactive mode only) Set the location of the user configuration file (see \"The configuration files\").","hash":"arg_usercfg","hp":"Arguments for QF‑Test","h4":"-usercfg <file> (interactive mode only)"},"522":{"id":522,"content":"-userdir <directory> Override the location of the directory holding the user configuration files (see \"The configuration files\"). If -usercfg <file> or -runlogdir <directory> are also specified they have precedence.","hash":"arg_userdir","hp":"Arguments for QF‑Test","h4":"-userdir <directory>"},"523":{"id":523,"content":"-variable <name>=<value> To override a system or suite variable definition (see \"Variables\") use this argument to set the variable named <name> to the value <value>. Using this argument multiple times you can define more than one variable.","hash":"arg_variable","hp":"Arguments for QF‑Test","h4":"-variable <name>=<value>"},"524":{"id":524,"content":"-verbose [<level>] Print progress and status information during a test run to the console. This is in particular useful when driving a test via -calldaemon, because the actual test usually runs on a different host where you may not be able to observe it. Note that on Windows you need to use qftestc.exe (instead of qftest.exe) to see the output. Specifying a level of verbosity is optional, possible values are all (print all nodes) and tests (default, only Test set and Test case nodes are printed out). Each level can be combined with errors (print error and exception messages) like tests,errors.","hash":"arg_verbose","hp":"Arguments for QF‑Test","h4":"-verbose [<level>]"},"525":{"id":525,"content":"-version Print version information and exit.","hash":"arg_version","hp":"Arguments for QF‑Test","h4":"-version"},"526":{"id":526,"content":"Placeholders in the filename parameter for run log and report The filename given in any of the command line arguments -runid <ID>, -runlog [<file>], -runlogdir <directory>, -report <directory>, -report-html <directory>, -report-name <name>, -report-xml <directory> or -report-junit <directory>, may contain placeholders of the form %X or +X (the latter must be used on Windows where '%' is a special character) where X may be any of the characters listed in the table below. QF‑Test will fill in the respective value when creating the run log or report. All time values refer to the time the test was started. When executing multiple test suites, be sure to include the base name of the suite in the filename by specifying %b. Otherwise only a single run log or report may be written that represents only the test run of the last test suite.","hash":"sec_placeholders","h2":"Placeholders in the filename parameter for run log and report"},"527":{"id":527,"content":"Character Replacement % Literal '%' character. + Literal '+' character. i The current runid as specified with -runid <ID>. p The directory of the test suite relative to -sourcedir <directory>. Expands to the absolute directory in case -sourcedir <directory> is unspecified and is empty if -sourcedir <directory> is specified but the test suite is not located below it. P The absolute directory of the test suite. May only be given at the beginning. b The basename of the test suite, exclusive directory and .qft extension. r The return value (or \"exit code\") of the test run (-runlog only). w The number of warnings in the test run (-runlog only). e The number of errors in the test run (-runlog only). x The number of exceptions in the test run (-runlog only). y The current year (2 digits). Y The current year (4 digits). M The current month (2 digits). d The current day (2 digits). h The current hour (2 digits). m The current minute (2 digits). s The current second (2 digits). Table 36.2: Placeholders in filename parameters So if, for example, you want to save the run log in a subdirectory of your test suite directory called logs and want to include a timestamp and the exit code, use -runlog %p/logs/%b-%y%M%d-%h%m%s-%r.qrl It is possible to use %b, %p and %P for collective parameters like runid or report. This makes sense only when processing a single test suite. When processing multiple test suites, the name of the first test suite is used.","hash":"table_36.2","h2":"Placeholders in the filename parameter for run log and report"},"528":{"id":528,"content":"Exit codes for QF‑Test When run in interactive mode, the exit code of QF‑Test is not very useful. It is either negative if QF‑Test fails to start or 0. In batch mode however the exit code expresses the result of the test run. Negative values represent fatal errors that prevent the test from being executed, while positive values stand for errors during the test run. Note that many systems only support exit codes between 0 and 255, so every exit code may have to be calculated modulo 256, i.e. -1=255, -2=254 and so on. The following exit codes are currently defined:","hash":"sec_exitcodes","h1":"Exit codes for QF‑Test"},"529":{"id":529,"content":"Value Meaning 0 Everything OK 1 Warnings occurred during the test run 2 Errors occurred during the test run 3 Exceptions occurred during the test run -1 Unexpected Exception -2 Bad command line arguments -3 Missing or invalid license -4 Errors while setting up the RMI connection -5 Errors while loading the test suite -6 The test suite doesn't contain any tests -12 The process was terminated from outside via the -shutdown <ID> batch command Table 36.3: Exit codes for QF‑Test Besides, there are special exit codes when running QF‑Test with the -calldaemon argument:","hash":"table_36.3","h1":"Exit codes for QF‑Test"},"530":{"id":530,"content":"Value Meaning -7 Daemon could not be found -8 Failed to get or create a TestRunDaemon -9 Failed to get or create a run context -10 The test could not be started -11 The test has not ended within the given timeout Table 36.4: calldaemon exit codes for QF‑Test","hash":"table_36.4","h1":"Exit codes for QF‑Test"},"531":{"id":531,"content":"Mobile Manual","hash":"","h0":"Unit Tests | QF‑Test Manual"},"532":{"id":532,"content":"Mobile Manual","hash":"home-link","h0":"Unit Tests | QF‑Test Manual"},"533":{"id":533,"content":"Unit Tests With Unit Tests, i.e. component tests, you can check the functional units. They explicitly test the functionality of single components. For this reason they are much less complex compared to integration and system tests. The Unit test node executes Unit Tests via the JUnit framework as part of a QF‑Test test run. The results are available in the run log as well as in the report. In \"JUnit 5 Jupiter\" you find information on how to include QF‑Test test suites into existing JUnit tests. The tests can be started from two possible sources: Java classes containing the JUnit test cases or Unit Tests scripted directly in QF‑Test. The parameters of the node vary with the use case. The JUnit 5 framework is used to execute the tests. This enables executing JUnit 5 Tests using the JUnit Jupiter engine as well as executing JUnit 4 and JUnit 3 tests using the JUnit Vintage engine. With JUnit 5 you can use features like parameterized tests, nested tests and test with a different display name.","hash":"usec_unittests","h0":"Unit Tests"},"534":{"id":534,"content":"Java Classes as the Source for the Unit Test It is possible to execute Unit Tests from Jar or Class files. It is also possible to execute Unit Tests that are available from the SUT's runtime. QF‑Test executes the tests of the test classes specified in the respective attribute of the Unit test node. In the report they will be displayed as test steps within a test case. The following example demonstrates the usage of a Unit test node with Java test classes.","hash":"sec_java_classes_as_the_source_for_the_unit_test","h1":"Java Classes as the Source for the Unit Test"},"535":{"id":535,"content":"Figure 12.1: Unit Test node with Java classes package de.qfs.test; import org.junit.Assert; import org.junit.Test; public class StringTest { @Test public void testubstring() { String s = new String(\"Long text\"); s = s.substring(5, 9; assert(\"text\".equals(s)); } @Test public void testReplace() { String s = new String(\"example\"); s = s.replace('e', 'i'); Assert.assertEquals(\"ixampli\", s); } } Example 12.1: Java Unit test The class de.qfs.test.StringTest must exist in the unittests.jar specified in the Classpath attribute. The path is determined relative to the path of the directory of the current suite. In this example the jar file is in the same directory as the suite. JUnit test classes are Java classes where the methods have the @Test annotation. The Unit test node executes all classes specified in the Test classes table. Thus a Unit test node can execute several test classes.","hash":"figure_12.1","h4":"Figure 12.1: Unit Test node with Java classes"},"536":{"id":536,"content":"Basics of the Test Scripts The second option to execute Unit Tests is to script the Unit Test directly in the Unit test node. You can use any of the Script languages QF‑Test offers. The most appropriate one is Groovy because it supports the Java annotations. The JUnit framework is used to execute the scripts.","hash":"usec_unittestscriptbasics","h1":"Basics of the Test Scripts"},"537":{"id":537,"content":"Groovy Unit Tests @BeforeClass static void onbefore(){ println(\"Set Up\") } @Test(expected=IndexOutOfBoundsException.class) void indexOutOfBoundsAccess() { def numbers = [1,2,3,4] numbers.get(4) } @Test void noFailure() { assert true } Example 12.2: Unit Test Script with Groovy In Groovy the required JUnit 4 classes are automatically imported at run-time. Just like in Java all tests with the @Test annotation will be executed. You can ignore expected exceptions using the expected parameter of the @Test annotation. The methods with the @BeforeClass annotation will be executed before the test methods will be run.","hash":"sec_groovy_unit_tests","h2":"Groovy Unit Tests"},"538":{"id":538,"content":"Jython Unit Tests def setUp(self): print \"Set Up\" def testMathCeil(self): import math self.assertEqual(2, math.ceil(1.01)) self.assertEqual(1, math.ceil(0.5)) self.assertEqual(0, math.ceil(-0.5)) self.assertEqual(-1, math.ceil(-1.1)) def testMultiplication(self): self.assertAlmostEqual(0.3, 0.1 * 3) Example 12.3: Unit Test script with Jython Because Jython does not support Java annotations, the tests run as JUnit 3 tests. All methods beginning with the keyword test are considered to be a test and executed as QF‑Test checks. The methods must have the self parameter because they are automatically enclosed in a class. The setUp method is executed at the beginning of each test.","hash":"usec_unittestscriptjython","h2":"Jython Unit Tests"},"539":{"id":539,"content":"JavaScript Unit test setUp(){ print(\"Set up\"); } tearDown() { print(\"Tear Down\"); } testUpperCase(){ let s = \"text\"; assertEquals(\"TEXT\", s.toUpperCase()); } testOk() { assertTrue(true); } Example 12.4: Unit Test Script with JavaScript Also JavaScript does not support Java annotations, the tests are executed as JUnit-3 Tests (cf. \"Jython Unit Tests\"). Just like in Jython all functions beginning with the keyword tests are executed as QF‑Test checks.","hash":"sec_javascript_unit_test","h2":"JavaScript Unit test"},"540":{"id":540,"content":"Injections It is possible to use the Unit Test node for the so called Live Tests. In this case the Unit Tests are executed in the running SUT. Using 'Injections' the Unit Tests inject QF‑Test objects like WebDriver, components and variables into the Unit Tests or scripts directly.","hash":"sec_injections","h1":"Injections"},"541":{"id":541,"content":"Component-Injections import static org.junit.Assert.*; import javax.swing.JComponent; import org.junit.Test; public class ComponentTest { /** The component to test in this unit test */ static JComponent component; /** Expected value */ static String accessibleName; @Test public void accessibleNameIsCorrect() { /** component and accessible name are injected at run-time */ final String currentName = component.getAccessibleContext().getAccessibleName(); assertEquals(accessibleName,currentName); } } Example 12.5: Java Unit test","hash":"sec_component_injections","h2":"Component-Injections"},"542":{"id":542,"content":"Figure 12.2: Example Unit Test node with Injections The example shows the injection of two QF‑Test objects: component and variable. The parameter \"Field\" corresponds to the name of the field static JComponent component; in the Java class. The java field must be static.","hash":"figure_12.2","h4":"Figure 12.2: Example Unit Test node with Injections"},"543":{"id":543,"content":"WebDriver-Injections import static org.junit.Assert.*; import org.junit.Test; import org.openqa.selenium.WebDriver; public class WebdriverTest { /** The driver of the window currently opened by QF‑Test. */ static WebDriver driver; @Test public void urlIsCorrectedLoaded() { // driver is injected at run-time final String currentUrl = driver.getCurrentUrl(); assertEquals(\"http://www.example.com\", currentUrl); } } Example 12.6: Java Unit Test with WebDriver Injections","hash":"usec_unitinjecttcomponents","h2":"WebDriver-Injections"},"544":{"id":544,"content":"Figure 12.3: Example Unit Test node with Injections This example shows how to inject a WebDriver object into a Java class. When no value for the WebDriver driver is specified QF‑Test determines the value via the given client.","hash":"figure_12.3","h4":"Figure 12.3: Example Unit Test node with Injections"},"545":{"id":545,"content":"Unit Tests in Report The greatest benefit from using the Unit test node is that the results are displayed nicely formatted in the HTML report. All Unit Test classes executed via this node are considered QF‑Test test cases. Unit test nodes should not be run separately. In order to see them correctly displayed in the HTML report, run them as part of a Test case. Each test method is handled like a QF‑Test check, e.g. a failed check does not abort the tests execution.","hash":"usec_unitreport","h1":"Unit Tests in Report"},"546":{"id":546,"content":"Figure 12.4: Unit Test Report","hash":"figure_12.4","h4":"Figure 12.4: Unit Test Report"},"547":{"id":547,"content":"Mobile Manual","hash":"","h0":"Android application testing | QF‑Test Manual"},"548":{"id":548,"content":"Mobile Manual","hash":"home-link","h0":"Android application testing | QF‑Test Manual"},"549":{"id":549,"content":"Android application testing This chapter covers test automation of Android native applications. There is a short introductory video about Android testing available on our QF‑Test YouTube Channel. In June 2022, a special webinar took place about Android Testing with QF‑Test. After a bit of theory the detailed way of working with emulator and real device is demonstrated. Here you can find the special webinar video recording available on our QF‑Test YouTube Channel. In case you want to test mobile Web applications, we recommend to check out the options of the mobile emulation mode of the chrome desktop browser as describe in \"Emulation of mobile browsers\". Even though is possible to use a web browser on an Android device (given that it supports the accessibility interface), the mobile emulation mode offers better automation features and less overhead for mobile web testing.","hash":"usec_androidtesting","h1":"Android application testing"},"550":{"id":550,"content":"Mobile Manual","hash":"","h0":"Preconditions and known restrictions | QF‑Test Manual"},"551":{"id":551,"content":"Mobile Manual","hash":"home-link","h0":"Preconditions and known restrictions | QF‑Test Manual"},"552":{"id":552,"content":"Preconditions and known restrictions","hash":"sec_android_restrict_precond","h0":"Preconditions and known restrictions"},"553":{"id":553,"content":"Preconditions In order to perform Android tests with QF‑Test, the following preconditions need to be fulfilled for the machine QF‑Test is running on: In case an Android emulator shall be used, a sufficiently powerfull machine is required (not an old scrap mill :-). It might be even necessary to enable hardware acceleration (typical via the bios) if the emulator works too slow. Further details can be found at https://developer.android.com/studio/run/emulator-acceleration. Android SDK Command-Line tools need to be available on your machine, even better an installation of Android Studio as described in \"Installing Android Studio, emulator and virtual devices (AVD)\". Either a real Android mobile device needs to be connected via cable and USB debugging need to be enabled for this device (see \"Connecting to a real Android device\"), Or an Android emulator needs to be installed, running an adequate Android Virtual Device (AVD) (see \"Android Studio virtual device configuration\"). The Android API Level of the real or virtual Android device needs to be greater or equal 24, which means Android Version 7 Nougat or later (see Andriod version history at Wikipedia).","hash":"sec_android_precond","h1":"Preconditions"},"554":{"id":554,"content":"Known restrictions There are some restrictions within this version listed below: Only one Android client can be connected and controlled in parallel so far. It is planned to enhance this to multiple clients as it is supported with the other UI technologies.","hash":"sec_android_restrict","h1":"Known restrictions"},"555":{"id":555,"content":"Mobile Manual","hash":"","h0":"Emulator or real device | QF‑Test Manual"},"556":{"id":556,"content":"Mobile Manual","hash":"home-link","h0":"Emulator or real device | QF‑Test Manual"},"557":{"id":557,"content":"Emulator or real device At the beginning of Android testing, you need to decide how to start: with a virtual or real device. A real Android device can be used for testing with QF‑Test. It needs to have the USB debugging developer option activated and requires a connection via cable to the machinge QF‑Tests runs on. By help of respective setup sequence, QF‑Test connects to the real device and is able to control it. Now actions and tests can be recored and executed. An Android virtual device (AVD) is the emulation of a real device. It runs by using an emulator software on a computer that replicates the hardware and behavior of the real device. An Android emulator is therefore a software to execute and test Android apps on a computer. The emulator is able to load different Android virtual devices with specific Android versions or products of a certain vendor. When using an emulator, it is typically started by QF‑Test at the beginning of the test, then QF‑Test loads and connect to the defined virutal Android device. Finally the app to be tested is opened. Actions and tests can now be recorded and executed. An advantage of the emulator is, that there is no dependency of external devices and testing of different virtual devices is possible. Though, it needs a bit more of initial setup and may cause more load on your maschine. A real device allows a quicker start, is less flexible and needs USB debugging enabled.","hash":"sec_android_emulator_or_device","h0":"Emulator or real device"},"558":{"id":558,"content":"Mobile Manual","hash":"","h0":"Installing Android Studio, emulator and virtual devices (AVD) | QF‑Test Manual"},"559":{"id":559,"content":"Mobile Manual","hash":"home-link","h0":"Installing Android Studio, emulator and virtual devices (AVD) | QF‑Test Manual"},"560":{"id":560,"content":"Installing Android Studio, emulator and virtual devices (AVD) The easiest way to install the Android SDK Command-Line tools and emulator and configure a virtual device is via the Android Studio. There is also the option to just install the Android SDK or even just the SDK command line tools but there are some pitfalls, which is why we decided to focus on Android Studio. If you have not already installed Android Studio, the following steps are necessary:","hash":"sec_android_studio","h0":"Installing Android Studio, emulator and virtual devices (AVD)"},"561":{"id":561,"content":"Android Studio installation Download Android Studio from https://developer.android.com/studio. The installation will need about 3 GB on your hard disk. Just install it in the standard way with default settings and allow it to get started afterwards. In the setup wizard you can go with the proposed settings. During installation you will be asked for a change in command line settings which you may want to accept. Installation is finished.","hash":"android_studio_install","h1":"Android Studio installation"},"562":{"id":562,"content":"Android Studio virtual device configuration As we just want to use the Android Studio to configure our virtual device, we choose »Virtual Device Manager« from the menu (sometimes indicated by the vertical dots top right). Otherwise, you can find the Device Manager in the Tools menu.","hash":"android_studio_avd_conf","h1":"Android Studio virtual device configuration"},"563":{"id":563,"content":"As we just want to use the Android Studio to configure our virtual device, we choose »Virtual Device Manager« from the menu (sometimes indicated by the vertical dots top right). Otherwise, you can find the Device Manager in the Tools menu. Figure 13.1: Android studio start screen Here we can select »Create device...«.","hash":"fig_android_studio_start","h1":"Android Studio virtual device configuration"},"564":{"id":564,"content":"Here we can select »Create device...«. Figure 13.2: Android studio virtual device creation screen Select an appropriate virtual device. It is recommended to go for smaller screen sizes to both spare memory and allow the virtual device to fully fit on your screen.","hash":"fig_android_studio_avd","h1":"Android Studio virtual device configuration"},"565":{"id":565,"content":"Select an appropriate virtual device. It is recommended to go for smaller screen sizes to both spare memory and allow the virtual device to fully fit on your screen. Figure 13.3: Android studio screen to chose a device definition Now select the System Image representing the Android version. Press the respective \"Download\" link to start the component installer. Then you can also proceed with \"Next\".","hash":"fig_android_studio_avd_hw","h1":"Android Studio virtual device configuration"},"566":{"id":566,"content":"Now select the System Image representing the Android version. Press the respective \"Download\" link to start the component installer. Then you can also proceed with \"Next\". Figure 13.4: Android studio screen to download and select the system image Finally press \"Finish\" on the last configuration dialog.","hash":"fig_android_studio_system_image","h1":"Android Studio virtual device configuration"},"567":{"id":567,"content":"Finally press \"Finish\" on the last configuration dialog. Figure 13.5: Android studio screen to finish the AVD configuration procedure Now you have a first configured virtual device ready for QF‑Test to use.","hash":"fig_android_studio_avd_finish","h1":"Android Studio virtual device configuration"},"568":{"id":568,"content":"Now you have a first configured virtual device ready for QF‑Test to use. Figure 13.6: Android studio screen showing available AVDs","hash":"fig_android_studio_avd_available","h1":"Android Studio virtual device configuration"},"569":{"id":569,"content":"Mobile Manual","hash":"","h0":"Connecting to a real Android device | QF‑Test Manual"},"570":{"id":570,"content":"Mobile Manual","hash":"home-link","h0":"Connecting to a real Android device | QF‑Test Manual"},"571":{"id":571,"content":"Connecting to a real Android device To use a real Android device for testing it needs to have USB debugging enabled and connected to the machine via USB cable. Also an Android SDK is required on your machine. Even though it may be sufficient to just install a dedicated package for the Android SDK Command-Line tools we strongly recommend install the full Android Studio as described in \"Installing Android Studio, emulator and virtual devices (AVD)\" Enable USB debugging Please activate USB debugging for your real device. Typically following steps are necessary: Navigate to \"Setings\" -> \"About 'Device'\". Click seven times at Build-Number, then \"Settings\" -> \"Developer options\" will get visible There activate the option \"USB debugging\" The reference documentation how to activate USB debugging can be found at https://developer.android.com/studio/debug/dev-options. Connect to PC via USB cable After connecting the Android device to the PC, you may be asked on the device whether to allow USB debugging from this PC and whether to allow this permanently. You need to confirm this.","hash":"sec_android_real_device","h0":"Connecting to a real Android device"},"572":{"id":572,"content":"Mobile Manual","hash":"","h0":"Create a QF‑Test setup sequence for Android testing | QF‑Test Manual"},"573":{"id":573,"content":"Mobile Manual","hash":"home-link","h0":"Create a QF‑Test setup sequence for Android testing | QF‑Test Manual"},"574":{"id":574,"content":"Create a QF‑Test setup sequence for Android testing As always when creating a setup sequence, open the Quickstart Wizard via the »Extras« menu or the toolbar button. Select \"An Android application\".","hash":"sec_android_test_setup","h0":"Create a QF‑Test setup sequence for Android testing"},"575":{"id":575,"content":"Select \"An Android application\". Figure 13.7: Quickstart wizard screen to select the application type","hash":"fig_android_quickstart_type","h0":"Create a QF‑Test setup sequence for Android testing"},"576":{"id":576,"content":"Usage of an Android emulator Select first option \"Launch emulator and connect to an Android virtual device\".","hash":"sec_android_test_setup_emulator","h1":"Usage of an Android emulator"},"577":{"id":577,"content":"Select first option \"Launch emulator and connect to an Android virtual device\". Figure 13.8: Quickstart wizard screen to select the emulate as test device Select the virtual device from the drop-down list. Press \"Refresh\" in case no AVD is visible. If it is still not visible also try to restart QF‑Test in order to make the virtual device visible. Then press \"Next\".","hash":"fig_android_quickstart_emulator","h1":"Usage of an Android emulator"},"578":{"id":578,"content":"Select the virtual device from the drop-down list. Press \"Refresh\" in case no AVD is visible. If it is still not visible also try to restart QF‑Test in order to make the virtual device visible. Then press \"Next\". Figure 13.9: Quickstart wizard screen to select the AVD As the next step you may want to specify the Android .apk file you want to test. If you want to test an App already installed, leave it empty.","hash":"fig_android_quickstart_avd","h1":"Usage of an Android emulator"},"579":{"id":579,"content":"As the next step you may want to specify the Android .apk file you want to test. If you want to test an App already installed, leave it empty. Figure 13.10: Quickstart wizard screen to select an APK In the next step you can specify a client name and press \"Next\" or \"Finish\" to finalize the Wizard.","hash":"fig_android_quickstart_apk","h1":"Usage of an Android emulator"},"580":{"id":580,"content":"In the next step you can specify a client name and press \"Next\" or \"Finish\" to finalize the Wizard. Figure 13.11: Quickstart wizard screen to specify the client name As a result, a Setup sequence will be created in the \"Extras\" node of your test suite. It should be pretty much self explanatory and also contains the hint, that in this early access phase the qfsandroid.qft suite is needed for this setup sequence to run successfully. A resepective include has been added automatically.","hash":"fig_android_quickstart_client","h1":"Usage of an Android emulator"},"581":{"id":581,"content":"As a result, a Setup sequence will be created in the \"Extras\" node of your test suite. It should be pretty much self explanatory and also contains the hint, that in this early access phase the qfsandroid.qft suite is needed for this setup sequence to run successfully. A resepective include has been added automatically. Figure 13.12: Android setup sequence created by the quickstart wizard When executing the Setup sequence, the emulator window is supposed to appear and in case you have provided an .apk file to be started, the same should be visible there. Also the Record button is supposed to become active in order to indicate an established connection.","hash":"fig_android_quickstart_setup_sequence","h1":"Usage of an Android emulator"},"582":{"id":582,"content":"When executing the Setup sequence, the emulator window is supposed to appear and in case you have provided an .apk file to be started, the same should be visible there. Also the Record button is supposed to become active in order to indicate an established connection. Figure 13.13: Android emulator window","hash":"fig_android_emulator","h1":"Usage of an Android emulator"},"583":{"id":583,"content":"Usage of a real Android device Select \"Connect to a real Android device or running Android virtual device\".","hash":"sec_android_test_setup_real_device","h1":"Usage of a real Android device"},"584":{"id":584,"content":"Select \"Connect to a real Android device or running Android virtual device\". Figure 13.14: Quickstart wizard screen to select the application type From the Combo box select the shown entry, which is the id of your connected device. Press \"Refresh\" in case no device is visible. If it is still not visible also try to restart QF‑Test in order to make the device visible. Then press \"Next\".","hash":"fig_android_quickstart_real_type","h1":"Usage of a real Android device"},"585":{"id":585,"content":"From the Combo box select the shown entry, which is the id of your connected device. Press \"Refresh\" in case no device is visible. If it is still not visible also try to restart QF‑Test in order to make the device visible. Then press \"Next\". Figure 13.15: Quickstart wizard screen to select the real device As the next step you may want to specify an Android .apk file you want to test. If you want to test an App already installed, leave it empty.","hash":"fig_android_quickstart_real_device","h1":"Usage of a real Android device"},"586":{"id":586,"content":"As the next step you may want to specify an Android .apk file you want to test. If you want to test an App already installed, leave it empty. Figure 13.16: Quickstart wizard screen to select a .apk file In the next step you can specify a client name and press \"Next\" or \"Finish\" to finalize the Wizard.","hash":"fig_android_quickstart_real_apk","h1":"Usage of a real Android device"},"587":{"id":587,"content":"In the next step you can specify a client name and press \"Next\" or \"Finish\" to finalize the Wizard. Figure 13.17: Quickstart wizard screen to specify the client name As a result, a Setup sequence will be created in the \"Extras\" node of your test suite. It should be pretty much self explanatory and also contains the hint, that in this early access phase the qfsandroid.qft suite is needed for this setup sequence to run successfully. A resepective include has been added automatically.","hash":"fig_android_quickstart_real_client","h1":"Usage of a real Android device"},"588":{"id":588,"content":"As a result, a Setup sequence will be created in the \"Extras\" node of your test suite. It should be pretty much self explanatory and also contains the hint, that in this early access phase the qfsandroid.qft suite is needed for this setup sequence to run successfully. A resepective include has been added automatically. Figure 13.18: Android setup sequence created by the quickstart wizard When executing this Setup sequence the Record button is supposed to become active in order to indicate an established connection. Also in case you have provided an .apk file to be started, the same should get visible on you real device.","hash":"fig_android_quickstart_real_setup_sequence","h1":"Usage of a real Android device"},"589":{"id":589,"content":"Mobile Manual","hash":"","h0":"Record actions and checks for Android | QF‑Test Manual"},"590":{"id":590,"content":"Mobile Manual","hash":"home-link","h0":"Record actions and checks for Android | QF‑Test Manual"},"591":{"id":591,"content":"Record actions and checks for Android Please press on the Record Button to see what is going to happen for Android testing in QF‑Test. A special recording windows will open showing the content of either the emulator or the real device. This special window is necessary, as it is currently not possible to directly capture events from the emulator or real device. So you need to capture actions and checks via this special window. It offers buttons for resizing the content area. Please also note that the content area just shows an image of the device screen. It needs to be updated manually by using the refresh button. There is also an auto refresh toggle button to perform this automatically.","hash":"sec_android_recording","h0":"Record actions and checks for Android"},"592":{"id":592,"content":"It offers buttons for resizing the content area. Please also note that the content area just shows an image of the device screen. It needs to be updated manually by using the refresh button. There is also an auto refresh toggle button to perform this automatically. Figure 13.19: QF‑Test Android recording window Now you can try and record and also replay actions or checks. It may feel a bit clumsy in the beginning, but you will get used to the recording window soon. Despite these Android recording specifics, QF‑Test should work and behave as with any other GUI Technology, except for the known restrictions described in \"Known restrictions\". Goodies: The recording window also has some goodies to mention. In the bottom line left it shows the mouse coordinates, which may become handy if you need to work with absolute mouse clicks. On the right, it indicates the type of the last highlighted component. There is a toolbar button on the recording window to open a UI inspector window, see UI Inspector, displaying all visible components including the size and coordinates. This is more to help tracking down issues with component recording and recognision issues, but may become handy here and there.","hash":"fig_android_recording_window","h0":"Record actions and checks for Android"},"593":{"id":593,"content":"Mobile Manual","hash":"","h0":"Android utility procedures | QF‑Test Manual"},"594":{"id":594,"content":"Mobile Manual","hash":"home-link","h0":"Android utility procedures | QF‑Test Manual"},"595":{"id":595,"content":"Android utility procedures There are a number of Android utility procedures available in the standard library and are located in respecitive \"android\" package. Some are similar to those avaialbe for other UI technologies but some are very specific for mobile testing e.g. for performing guestures or swipe actions, scrolling and setting of a certain component status.","hash":"sec_android_stdlib","h0":"Android utility procedures"},"596":{"id":596,"content":"Figure 13.20: Android utility procedures","hash":"fig_android_stdlib","h4":"Figure 13.20: Android utility procedures"},"597":{"id":597,"content":"Mobile Manual","hash":"","h0":"iOS application testing | QF‑Test Manual"},"598":{"id":598,"content":"Mobile Manual","hash":"home-link","h0":"iOS application testing | QF‑Test Manual"},"599":{"id":599,"content":"iOS application testing This chapter covers test automation of iOS native applications. There is a short introductory video about iOS testing available on our QF‑Test YouTube channel. In September 2024, a special webinar took place about iOS testing with QF‑Test. After a bit of theory the detailed way of working with the simulator and real device is demonstrated. Here you can find the special webinar video recording available on our QF‑Test YouTube channel. In case you want to test mobile Web applications, we recommend to check out the options of the mobile emulation mode of the chrome desktop browser as describe in \"Emulation of mobile browsers\". Even though it is possible to control an accessibility aware web browser on an iOS device for testing (e.g. Safari), the mobile emulation mode offers better automation features and less overhead for mobile web testing.","hash":"usec_iostesting","h1":"iOS application testing"},"600":{"id":600,"content":"Mobile Manual","hash":"","h0":"Preconditions and known restrictions | QF‑Test Manual"},"601":{"id":601,"content":"Mobile Manual","hash":"home-link","h0":"Preconditions and known restrictions | QF‑Test Manual"},"602":{"id":602,"content":"Preconditions and known restrictions","hash":"sec_ios_restrict_precond","h0":"Preconditions and known restrictions"},"603":{"id":603,"content":"Preconditions In order to perform iOS tests with QF‑Test, the following preconditions need to be fulfilled for the machine QF‑Test is running on: iOS applications can only be tested on a macOS system. You have to install and execute QF‑Test on this system (interactively, in batch mode or via daemon calls). To execute tests on the iOS simulator or iOS device, you have to install the complete development environment Xcode in version 13 or higher from the App Store. To avoid installation problems, it is recommended to disable the auto update mechanism for applications in the App Store or system settings, and update Xcode manually while no test is running. In Xcode, you have to enable the iOS development platform and install the corresponding iOS simulators/runtimes. To install, open \"Settings\" or \"Preferences\" and select the tab \"Platforms\" or \"Components\". You have to repeat this step after each Xcode update. Select the correct development path /Applications/Xcode.app/Contents/Developer via Terminal: sudo xcode-select -s /Applications/Xcode.app/Contents/Developer. To control the iOS device or iOS simulator, the iOS Development Bridge is required. For installation, please refer to https://fbidb.io/docs/installation. In the menu \"Extras\" of the QF‑Test main window you can find the command \"Check/Setup iOS test environment ...\". This command helps to verify your current system and gives advices on how to install the required tools. When a tool is started the first time it can happen that its initialization takes more than 30 seconds. In this case, due to timeout, a wrong version number of the tool is reported. To work around, simply restart the check/setup procedure.","hash":"sec_ios_precond","h1":"Preconditions"},"604":{"id":604,"content":"Known restrictions Events directly entered on a connected device or in the Simulator app cannot be recorded. Similar to Android tests, interactions have to be performed in the dedicated recording window, see Record actions and checks for iOS. Starting from iOS version 13, when using SecureField components (for entering passwords or other sensitive information), the software keyboard will no longer be displayed in the recording window, and the text component will appear empty although it contains input. The software keyboard is not essential for recording, because input to the text component can always be recorded via keyboard events to the recording window. However, the component information for the software keyboard remains available and can be used for playback of Mouse events to its keys. For this purpose, you can use component recording (see Recording components) on the whole window to record the keyboard component or work directly with SmartID. A suitable SmartID suggestion can be obtained using the UI Inspector.","hash":"sec_ios_restrict","h1":"Known restrictions"},"605":{"id":605,"content":"Mobile Manual","hash":"","h0":"Installing Xcode, Simulators and IDB | QF‑Test Manual"},"606":{"id":606,"content":"Mobile Manual","hash":"home-link","h0":"Installing Xcode, Simulators and IDB | QF‑Test Manual"},"607":{"id":607,"content":"Installing Xcode, Simulators and IDB For iOS testing, QF‑Test requires an installation of the full Xcode development application, as well as the iOS Development Bridge (idb). In the menu \"Extras\" of the QF‑Test main window you can find the command \"Check/Setup iOS test environment ...\". This command helps to verify your current system and gives advice on how to install the required tools. When a tool is started the first time it can happen that its initialization takes more than 30 seconds. In this case, due to timeout, a wrong version number of the tool is reported. To work around, simply restart the check/setup procedure.","hash":"sec_ios_install","h0":"Installing Xcode, Simulators and IDB"},"608":{"id":608,"content":"Xcode Installation Install Xcode in version 13 or higher from the App Store.","hash":"ios_xcode_install","h1":"Xcode Installation"},"609":{"id":609,"content":"Install Xcode in version 13 or higher from the App Store. Figure 14.1: Xcode in the macOS App Store If Xcode is updated while a test is running, the installation can be damaged. Therefore, it is recommended to disable the auto update mechanism for applications in the App Store or system settings, and update Xcode manually while no test is running.","hash":"fig_ios_xcode_appstore","h1":"Xcode Installation"},"610":{"id":610,"content":"Figure 14.2: Recommended App Store settings Select the correct development path /Applications/Xcode.app/Contents/Developer via Terminal: sudo xcode-select -s /Applications/Xcode.app/Contents/Developer Example 14.1: Xcode development path selection in Terminal After installation, open Xcode and trigger the installation of additional required software as requested. This must include at least one iOS Platform. If you dismiss the dialog upon first start, you can retrigger the installation from the dialog »XCode«-»Settings…« in the »Platforms« panel. Using the right-click menu, it is also possible to remove installed frameworks.","hash":"fig_ios_appstore_settings","h4":"Figure 14.2: Recommended App Store settings"},"611":{"id":611,"content":"Figure 14.3: Platform management in Xcode Using the menu item »XCode«-»Open Developer Tool«-»Simulator«, start the iOS Simulator once and make sure that proper Simulator definitions have been created. Here, it is also possible to define additional devices.","hash":"fig_ios_xcode_settings","h4":"Figure 14.3: Platform management in Xcode"},"612":{"id":612,"content":"Figure 14.4: The iOS Simulator menu","hash":"fig_ios_simulator_menu","h4":"Figure 14.4: The iOS Simulator menu"},"613":{"id":613,"content":"iOS Development Bridge (idb) Installation To interact with the iOS device, QF‑Test uses the idb tool. It consists of the idb companion which communicates directly with the (simulated) device, and the Python based idb client. Both parts need to be available on the system in order to execute iOS tests. More information about the idb tool can be found in the idb documentation. The installation of the idb companion can be performed using the command line Homebrew tool (see https://brew.sh). To install the idb companion, run on the command line: brew tap facebook/fb brew install idb-companion Example 14.2: idb companion installation on the command line The idb client requires a Python 3.6 or greater to be installed on the system. This can also be done using Homebrew on the command line. Afterward, the idb client is installed using the pip tool of Python: brew install python3 pip3 install --upgrade pip pip3 install fb-idb Example 14.3: idb client installation on the command line","hash":"ios_idb_install","h1":"iOS Development Bridge (idb) Installation"},"614":{"id":614,"content":"Mobile Manual","hash":"","h0":"Testing on a real iOS device | QF‑Test Manual"},"615":{"id":615,"content":"Mobile Manual","hash":"home-link","h0":"Testing on a real iOS device | QF‑Test Manual"},"616":{"id":616,"content":"Testing on a real iOS device App testing on the iOS Simulator is quick and easy, but sometimes it is required to run a test using a real device connected to the machine running the iOS test. To run iOS tests on a real device, several requirements need to be fulfilled: The system has to be prepared as described in \"Installing Xcode, Simulators and IDB\", including a complete installation of Xcode. The Developer Mode must be enabled on the device in »Xcode«-»Settings«-»Privacy & Security«. The device has to be connected to the machine, and the machine has to be marked as \"trusted\" on the device. The device must be unlocked during testing. A developer account must be added in »Xcode«-»Settings…«-»Accounts« using its Apple ID. The team ID corresponding to the selected developer account must be provided using the option Code Signing Team ID / Organizational Unit. Sometimes, the first test start fails due to missing profile trust on the device. To trust the developer profile, open the Settings app and on the device navigate to »General«-»VPN & Device Management« or »Profiles« and confirm the trust there.","hash":"sec_ios_real_device","h0":"Testing on a real iOS device"},"617":{"id":617,"content":"The system has to be prepared as described in \"Installing Xcode, Simulators and IDB\", including a complete installation of Xcode. The Developer Mode must be enabled on the device in »Xcode«-»Settings«-»Privacy & Security«. The device has to be connected to the machine, and the machine has to be marked as \"trusted\" on the device. The device must be unlocked during testing. A developer account must be added in »Xcode«-»Settings…«-»Accounts« using its Apple ID. The team ID corresponding to the selected developer account must be provided using the option Code Signing Team ID / Organizational Unit. Sometimes, the first test start fails due to missing profile trust on the device. To trust the developer profile, open the Settings app and on the device navigate to »General«-»VPN & Device Management« or »Profiles« and confirm the trust there. Figure 14.5: Navigate to the iOS profile trust section Applications, which are installed on the device during the test must be available in a version build for \"Any iOS device\" (which is another build target than \"Any iOS Simulator\"), and properly signed. As well, a provisioning profile must be installed on the device allowing the application to be run (see Apple documentation).","hash":"fig_ios_trust_profile","h0":"Testing on a real iOS device"},"618":{"id":618,"content":"Mobile Manual","hash":"","h0":"Create a QF‑Test Setup sequence for iOS testing | QF‑Test Manual"},"619":{"id":619,"content":"Mobile Manual","hash":"home-link","h0":"Create a QF‑Test Setup sequence for iOS testing | QF‑Test Manual"},"620":{"id":620,"content":"Create a QF‑Test Setup sequence for iOS testing Open the Quickstart Wizard via the »Extras« menu or the toolbar button. Select \"An iOS application\".","hash":"sec_ios_test_setup","h0":"Create a QF‑Test Setup sequence for iOS testing"},"621":{"id":621,"content":"Select \"An iOS application\". Figure 14.6: Quickstart wizard screen to select the application type Select the real or simulated device from the drop-down list. Press \"Refresh\" in case no devices are visible. If it is still not visible, open Xcode and select »Window«-»Devices and Simulators« to make sure everything is properly set up. You can also provide only the first part of the device name to make your test more flexible. To proceed to the next step, press \"Next\".","hash":"fig_ios_quickstart_type","h0":"Create a QF‑Test Setup sequence for iOS testing"},"622":{"id":622,"content":"Select the real or simulated device from the drop-down list. Press \"Refresh\" in case no devices are visible. If it is still not visible, open Xcode and select »Window«-»Devices and Simulators« to make sure everything is properly set up. You can also provide only the first part of the device name to make your test more flexible. To proceed to the next step, press \"Next\". Figure 14.7: Quickstart wizard screen to select the test device As the next step you may want to specify the iOS .app bundle or .ipa file you want to test. You can also directly reference a .zip file, containing the app bundle. If you want to test an app already installed, leave it empty.","hash":"fig_ios_quickstart_device","h0":"Create a QF‑Test Setup sequence for iOS testing"},"623":{"id":623,"content":"As the next step you may want to specify the iOS .app bundle or .ipa file you want to test. You can also directly reference a .zip file, containing the app bundle. If you want to test an app already installed, leave it empty. Figure 14.8: Quickstart wizard screen to select an app file In the next step you can specify a client name and press \"Next\" or \"Finish\" to finalize the Wizard.","hash":"fig_ios_quickstart_app","h0":"Create a QF‑Test Setup sequence for iOS testing"},"624":{"id":624,"content":"In the next step you can specify a client name and press \"Next\" or \"Finish\" to finalize the Wizard. Figure 14.9: Quickstart wizard screen to specify the client name As a result, a Setup sequence will be created in the \"Extras\" node of the test suite. The Setup sequence includes a call to the qfs.ios.setup.checkEnvironment procedure from the standard library, to verify that the executing system is properly set up.","hash":"fig_ios_quickstart_client","h0":"Create a QF‑Test Setup sequence for iOS testing"},"625":{"id":625,"content":"As a result, a Setup sequence will be created in the \"Extras\" node of the test suite. The Setup sequence includes a call to the qfs.ios.setup.checkEnvironment procedure from the standard library, to verify that the executing system is properly set up. Figure 14.10: iOS setup sequence created by the quickstart wizard","hash":"fig_ios_quickstart_setup_sequence","h0":"Create a QF‑Test Setup sequence for iOS testing"},"626":{"id":626,"content":"Mobile Manual","hash":"","h0":"Record actions and checks for iOS | QF‑Test Manual"},"627":{"id":627,"content":"Mobile Manual","hash":"home-link","h0":"Record actions and checks for iOS | QF‑Test Manual"},"628":{"id":628,"content":"Record actions and checks for iOS To start recording, press the record button in QF‑Test. A special recording window will open showing the content of either the Simulator or the real device. This special window is necessary, as it is currently not possible to directly capture events from the Simulator or real device. The display content from the (simulated) device is continuously mirrored in the recording window, which also offers buttons for resizing the content area.","hash":"sec_ios_recording","h0":"Record actions and checks for iOS"},"629":{"id":629,"content":"The display content from the (simulated) device is continuously mirrored in the recording window, which also offers buttons for resizing the content area. Figure 14.11: QF‑Test iOS recording window Now you can record and also replay actions or checks. There is an toolbar button on the recording window to open a UI inspector window, see UI Inspector, displaying all visible components including the size and coordinates.","hash":"fig_ios_recording_window","h0":"Record actions and checks for iOS"},"630":{"id":630,"content":"Mobile Manual","hash":"","h0":"iOS utility procedures | QF‑Test Manual"},"631":{"id":631,"content":"Mobile Manual","hash":"home-link","h0":"iOS utility procedures | QF‑Test Manual"},"632":{"id":632,"content":"iOS utility procedures There are a number of iOS utility procedures available in the standard library, located in respective ios package. Some are similar to those available for other UI technologies but some are very specific to mobile testing for example for performing gestures or swipe actions, scrolling and setting of a certain component status.","hash":"sec_ios_stdlib","h0":"iOS utility procedures"},"633":{"id":633,"content":"Figure 14.12: iOS utility procedures","hash":"fig_ios_stdlib","h4":"Figure 14.12: iOS utility procedures"},"634":{"id":634,"content":"Mobile Manual","hash":"","h0":"Data-driven testing | QF‑Test Manual"},"635":{"id":635,"content":"Mobile Manual","hash":"home-link","h0":"Data-driven testing | QF‑Test Manual"},"636":{"id":636,"content":"Data-driven testing Data-driven testing is a very important aspect of test automation. In short, the goal is to run a given test or set of tests multiple times with different sets of input data and expected results. QF‑Test has various means to store data or load external data for use in data-driven tests. The most convenient is based on a Data driver node which sets up an environment for iterating over the sets of data combined with one or more Data binder nodes to bind the variables for test execution. Note that there is no Data binder node as such. The name serves as a generic term for the specific nodes like a Data table or a CSV data file. This is best explained through some examples. A demo test suite with simple and advanced examples named datadriver.qft is provided in the directory doc/tutorial below QF‑Test's root directory. Please take care to store modified test suites in a project-related folder.","hash":"usec_datadriver","h0":"Data-driven testing"},"637":{"id":637,"content":"Data driver examples","hash":"sec_data_driver_examples","h1":"Data driver examples"},"638":{"id":638,"content":"Figure 15.1: A simple data-driven test The image above shows a Test set with a Data driver node that contains a single Data binder in the form of a Data table node. The contents of the Data table are as follows:","hash":"figure_15.1","h4":"Figure 15.1: A simple data-driven test"},"639":{"id":639,"content":"Figure 15.2: Data table example When the Test set is executed, it will iterate over the rows of the Data table shown above. For each of the three iterations the values of the respective row in the table are bound to the variable named in the matching column header. Thus, during the first iteration the variable named \"Model\" is bound to \"Rolo\", \"Variant\" to \"None\" and \"Price\" to \"19000\". During the second iteration, \"Model\" is set to \"I5\" and to \"Minigolf\" during the third and last iteration. For each iteration, all Test case child nodes of the Test set are run. The following image shows a run log for the above Test set.","hash":"figure_15.2","h4":"Figure 15.2: Data table example"},"640":{"id":640,"content":"Figure 15.3: Run log of a data-driven test The next example shows that data-driven testing is not limited to a single loop:","hash":"figure_15.3","h4":"Figure 15.3: Run log of a data-driven test"},"641":{"id":641,"content":"Figure 15.4: Data-driven test with nested loops The Data driver now contains a second Data table node with the following contents:","hash":"figure_15.4","h4":"Figure 15.4: Data-driven test with nested loops"},"642":{"id":642,"content":"Figure 15.5: Second data table example The Test set will now go through a total of six iterations because for each of the three iterations of the outer loop \"cars\", both iterations of the inner loop \"accessories\" will be run as shown in the following run log.","hash":"figure_15.5","h4":"Figure 15.5: Second data table example"},"643":{"id":643,"content":"Figure 15.6: Run log of a data-driven test with nested loops The extremely useful dynamic names of the loop nodes in the run logs are obtained by setting the attribute Name for loop pass in the run log to the value \"car Model: $(Model)\"in the first and to \"car Model: $(Model), accessory Name: $(Accessory)\" in the second example. As you can see, that name is expanded individually for each iteration, so you can make use of the variables bound for that iteration.","hash":"figure_15.6","h4":"Figure 15.6: Run log of a data-driven test with nested loops"},"644":{"id":644,"content":"General use of Data drivers As seen in the example above the Data driver node must be placed in a Test set node, between the optional Dependency and Setup nodes. When the Test set is executed it will check for Data driver and run it. The contents of the Data driver node are not limited to Data binders. Like a normal Sequence the Data driver node can hold any executable node to be able to perform any setup that may be required to retrieve the data. Thus it is also possible to share Data binders by putting them inside a Procedure and calling the Procedure from inside the Data driver. Conceptually, a Data binder represents a loop where a different set of variables is bound for each iteration. A Data binder must be registered with a name in the Data driver context of a Test set. This ensures that the loop can be interrupted by a Break node with the same name. Once the Test set has run the Data driver node, it will iterate over the registered data loops and perform the tests. In case of nested loops the Data binder that was registered first represents the outermost loop. Its variables are bound first and have lesser precedence than the variables from the inner loop(s).","hash":"sec_general_use_of_data_drivers","h1":"General use of Data drivers"},"645":{"id":645,"content":"Examples for Data drivers We provide a couple of examples for reading CSV or Excel files in the test suite doc/tutorial/datadriver.qft.","hash":"sec_examples_for_data_drivers","h1":"Examples for Data drivers"},"646":{"id":646,"content":"Advanced use Besides the Data table node there are various other means for binding data in a data driver. The Excel data file, CSV data file, Database and Data loop nodes are all explained in detail in \"Data driver\". It is also possible to bind data by calling the Procedures qfs.databinder.bindList or qfs.databinder.bindSets in the standard library qfs.qft. These take as parameters strings with lists or sets of values to split and iterate over. Please see tutorial chapter \"The Standard Library\" for information about the standard library. And finally, data can be bound directly from Jython (and analogous from Groovy and JavaScript) with the help of the databinder module, which offers the following methods:","hash":"user_datadriver_advanced","h1":"Advanced use"},"647":{"id":647,"content":"void bindDict(Object rc, String loopname, Map dict, String counter=None, String intervals=None) Create and register a databinder that binds data from a dictionary. The keys of the dictionary are the names of the variables and the values are sequences of values to be bound. Parameters rcThe current run context. loopname The name under which to bind the data, equivalent to the Name attribute of a Data binder node. dictThe dictionary to bind. counter An optional variable name for the iteration counter. intervals Optional ranges of indices, separated by comma, e.g. \"0,2-3\".","hash":"api_void_binddict_object_rc_string_loopname_map_dict_string_counter_none_string_intervals_none_in_user_datadriver_advanced","h1":"Advanced use"},"648":{"id":648,"content":"void bindList(Object rc, String loopname, String varname, Object values, String separator=None, String counter=None, String intervals=None) Create and register a databinder that binds a list of values to a variable. Parameters rcThe current run context. loopname The name under which to bind the data, equivalent to the Name attribute of a Data binder node. varnameThe name of the variable to bind to. values The values to bind. Either a sequence type or a string to split. separator Optional separator character to split the values at in case they're a string. Default is whitespace. counter An optional variable name for the iteration counter. intervals Optional ranges of indices, separated by comma, e.g. \"0,2-3\".","hash":"api_void_bindlist_object_rc_string_loopname_string_varname_object_values_string_separator_none_string_counter_none_string_intervals_none_in_user_datadriver_advanced","h1":"Advanced use"},"649":{"id":649,"content":"void bindSets(Object rc, String loopname, Object varnames, Object values, String separator=None, String counter=None, String intervals=None) Create and register a databinder that binds a list of value-set to a set of variables. Parameters rcThe current run context. loopname The name under which to bind the data, equivalent to the Name attribute of a Data binder node. varnames The names of the variables to bind to. Either a sequence type or a string to split. values The value-sets to bind. Either a sequence of sequences - each inner sequence being one set of data to bind - or a string to split. separator Optional separator character to split the varnames and the values of a value-set at in case they're a string. Default is whitespace. Value-sets are separated by line-breaks. counter An optional variable name for the iteration counter. intervals Optional ranges of indices, separated by comma, e.g. \"0,2-3\". Some examples: import databinder # Three iterations with the values \"spam\", \"bacon\" and \"eggs\" # bound to the variable named \"ingredient\" databinder.bindList(rc, \"meal\", \"ingredient\", [\"spam\", \"bacon\", \"eggs\"]) # Same with string values databinder.bindList(rc, \"meal\", \"ingredient\", \"spam bacon eggs\") # Same with string values and special separator databinder.bindList(rc, \"meal\", \"ingredient\", \"spam|bacon|eggs\", \"|\") # Two iterations, the first with item=\"apple\" and number=\"5\", # the second with item=\"orange\" and number=\"3\" databinder.bindSets(rc, \"fruit\", [\"item\", \"number\"], [[\"apple\",5], [\"orange\",3]]) # Same with string values, note the linebreak databinder.bindSets(rc, \"fruit\", \"item number\", \"\"\"apple 5 orange 3\"\"\") # Same as before with the data stored in a dict databinder.bindDict(rc, \"fruit\", {\"item\": [\"apple\", \"orange\"], \"number\": [5,3]}) Example 15.1: Examples for use of the databinder module","hash":"api_void_bindsets_object_rc_string_loopname_object_varnames_object_values_string_separator_none_string_counter_none_string_intervals_none_in_user_datadriver_advanced","h1":"Advanced use"},"650":{"id":650,"content":"Mobile Manual","hash":"","h0":"Reports and test documentation | QF‑Test Manual"},"651":{"id":651,"content":"Mobile Manual","hash":"home-link","h0":"Reports and test documentation | QF‑Test Manual"},"652":{"id":652,"content":"Reports and test documentation Besides test suites and run logs QF‑Test can create a number of additional documents. Most important of these is the report, which summarizes the overall results of a test run along with an overview over the test suites executed and their individual results. The report is easy to read and understand without further knowledge about QF‑Test and thus complements the run log which is geared towards error analysis and requires some QF‑Test experience to fully understand. Following is an example of a report summary:","hash":"usec_report","h0":"Reports and test documentation"},"653":{"id":653,"content":"Figure 16.1: Example report The other documents are more static in nature, describing the content of test suites instead of test run results. The testdoc document gives an overview over the structure of Test set and Test case nodes in a given set of test suites. It is intended for the test architect or QA project manager and documents the current state of test development. The pkgdoc documentation is similar, but focuses on Package, Procedure and Dependency nodes instead. The result is a library reference comparable to Java's JavaDoc. The target audience for pgkdoc are test implementers requiring information about already existing procedures and their parameters.","hash":"figure_16.1","h4":"Figure 16.1: Example report"},"654":{"id":654,"content":"Reports Before we can start explaining how to create reports, some basic terms and concepts need to be defined.","hash":"usec_reports","h1":"Reports"},"655":{"id":655,"content":"Report concepts A report represents the results of one or more test runs. A test run comprises the execution of either a single test suite or multiple test suites, typically executed together in one batch-run. A test run is identified by a runid. It is possible to execute a test run in several steps by assigning the same runid to the resulting run logs. A report is identified by a report name. For a report that covers a single test run, the report name is usually the same as the runid. For reports summarizing the results of several test runs a distinct report name can be specified. Reports can be created in multiple variants: XML, HTML and JUnit. Most users will probably use the HTML variant which can be viewed in a browser, printed and archived. The XML variant can serve as the basis for collecting the results of a test run for further processing, for example to collect test results in a database or to create customized HTML reports. We suggest that you always create both HTML and XML reports unless you have a good reason to do otherwise. JUnit reports base on the JUnit XML format as created by Apache Ant by use of its JUnitReport task. This format is not as pretty and detailed as the first two report variants QF‑Test offers but it is directly understood by many continuous integration tools and may prove useful for a quick integration with those. A report consists of one summary document, plus one document per run log. These files are collected together with complementary files like icons, stylesheets and screenshot images in a directory. At the file level, this directory represents the report. The layout of the files inside the report directory depends on some command line options explained below. Basically there are two ways to lay out the files: Based on the file structure of the original test suites or based on the file structure of the run logs.","hash":"sec_report_concepts","h2":"Report concepts"},"656":{"id":656,"content":"Report contents In advance to the overall test result, a report as shown above starts with a summary containing informational system data and a legend describing the meaning of counter icons used in the report (see Running tests). The difference between \"Time spent in tests\" and \"Elapsed time\" are explicit delays introduced in nodes via the 'Delay before/after' attribute or user interrupts. The contents of a report are based on the original structure of the executed test suites. The main structure is created from Test set and Test case nodes. The Comment attributes of the root node as well as the Test set and Test case nodes share the doctags with testdoc documents as explained in \"Testdoc documentation for Test sets and Test cases\". In addition to those doctags the '@title' doctag can be specified in the comment of the root node to set a title for the report document created for the respective test suite. If -report-teststeps is specified in batch mode (true by default) or the respective option is active in the interactive dialog, Test cases can be further broken down into steps with the help of Test step nodes. In addition to explicitly wrapping steps into a Test step, any node can be turned into a test step by specifying the doctag '@teststep' in its Comment, followed by an optional name for the step. For Test step nodes the '@author', '@version' and '@since' doctags are also applicable. The names, comments and tag values of the various nodes can contain variables that will be expanded at execution time so that the expanded value is shown in the report. This is especially useful for test steps within a procedure. If listing of test steps is active, Setup, Cleanup and Dependency nodes are also listed and checks, screenshots and messages, including warnings, errors and exceptions are properly integrated into the nested steps. If the test suites are set up properly the resulting report can serve as a very readable summary of what was going on during the execution of a test. Whether warnings and checks are listed is determined by the command line arguments -report-warnings and -report-checks or the respective interactive options. Warnings from component recognition are never listed because they are too technical and could easily flood the report. For checks one must distinguish between checks that represent an actual verification step and those that are used solely for control flow, for example to check whether a checkbox is already selected and click it only in case it is not. By default QF‑Test lists those Check nodes in the report that have the default result settings, i.e. the Error level of message is 'Error', no exception is thrown and no result variable bound. All others are treated as helpers for control flow and not listed in the report. For cases where this default treatment is not appropriate, you can force a Check into the report via the doctag '@report' in its Comment attribute or prevent its listing via '@noreport'. Of course failed checks are treated as warnings, errors or exceptions (depending on their Error level of message) and cannot be excluded from the report if messages at the respective level are shown. Additional messages, checks and screenshots can be added to the report by scripts via the methods rc.logMessage, rc.logImage and rc.check and its variants, which have an optional report parameter. For details, please see the run context API documentation in \"The rc module: Run context API\".","hash":"usec_reports_content","h2":"Report contents"},"657":{"id":657,"content":"Creating reports There are three ways to create reports: Interactively from a run log through the menu item »File«-»Create report...«. In batch mode as the result of a test run. In batch mode by transforming already existing run logs. The interactive variant is easy to use. Just select the target directory for the report and whether you want the XML and/or the HTML variant. For report creation in batch mode there are a number of command line options which are listed and explained in \"Command line arguments\". Let's look at the variant of creating reports as the result of a test run first: The command line syntax for plain test execution in batch mode is qftest -batch <test suite> [<test suite>...] To create a combined XML and HTML report, use -report <directory>. To create only one version or to separate the XML, HTML variants, use -report-xml <directory> and/or -report-html <directory>. For JUnit reports -report-junit <directory> works respectively. The runid of a test run is specified with -runid <ID>, the name of the report with -report-name <name>. If the report name is unspecified it will default to the runid. To lay out the files in the report directory according to the file structure of the test suites, use -sourcedir <directory>. To use the file structure of the run log as the basis, use -runlogdir <directory>. The following is a typical example of a command line for a batch run making use of the placeholders explained in \"Placeholders in the filename parameter for run log and report\": qftest -batch -runid +M+d -runlog logs/+i -report report_+i -sourcedir . suite1.qft subdir/suite2.qft Example 16.1: Creating a report as the result of a test run Creating a report as a separate step by transforming a set of run logs is similar in many respects. The run logs to transform have to be specified instead of the test suites to execute and the -runid <ID> and -sourcedir <directory> command line options have no effect. The following is an example for how to create a weekly summary report based on the assumption that you have collected all run logs below the directory named logdir, possibly in subdirectorys thereof: qftest -batch -genreport -report report_+M+d -report.name week_of_+y+M+d logdir Example 16.2: Creating a weekly summary report","hash":"sec_creating_reports","h2":"Creating reports"},"658":{"id":658,"content":"Customizing reports The XML and HTML reports are created from the run log via XSLT. By changing the XSLT stylesheets used it is possible to change the content and structure of the resulting documents. You can find more on this possibility in our blog article \"Creating custom HTML/XML/Junit reports\" at https://www.qftest.com/en/blog/article/2019/02/28/creating-custom-htmlxmljunit-reports.html As an alternative it is possible to customize the display of the HTML report using established web techniques via JavaScript. A file named user.js is copied to the report directory and included in all pages of the HTML report. To change the report layout you can replace this file with your own version after creating the report. See the comments in the default user.js file for examples.","hash":"usec_customizingreports","h2":"Customizing reports"},"659":{"id":659,"content":"Testdoc documentation for Test sets and Test cases The type of test documents called testdoc provide overview and detailed information over the Test set and Test case nodes of one or more test suites. When Test cases contain Test steps those steps will be included in the testdoc. By default QF‑Test ignores Test call nodes during testdoc creation. By setting the option -testdoc-followcalls=true the real targets Test case, Test set or the whole test suite are processed as if they were part of the original test suite. This documentation is a valuable tool for QA project managers to keep track of the current state of test development. Similar to reports, testdoc documents are laid out as directories with one summary file and one detailed file per test suite. A testdoc document for a single suite can be created interactively from a test suite by selecting »Create testdoc documentation...« from the »File« menu. This is very useful during test development to quickly check whether all tests are properly documented. For actual use as a reference it is preferable to create complete sets of documents spanning multiple test suites for a whole project. This can be done by running QF‑Test in batch mode with the -gendoc command line argument. In its simplest form, a call to create testdoc documentation for a whole directory tree would look as follows: qftest -batch -gendoc -testdoc test_documentation directory/with/test suites Example 16.3: Creating testdoc documentation Please see \"Command line arguments and exit codes\" for detailed information about the available command line arguments. To get optimal results you can use HTML markup in the Comment attributes of Test set and Test case nodes and also make use of doctags. A doctag is a keyword beginning with '@', sometimes followed by a name and always by a description. This is a proven concept in JavaDoc, the standard documentation format for Java programs (see http://www.oracle.com/technetwork/java/javase/documentation/index-137868.html#tag). All doctags must appear after the main description. Description after the doctags will be ignored, as well doctags inside the descripiton are not allowed. The following doctags are supported for Test set and Test case nodes: @deprecated If a Test set or Test case is no longer to be used, this description should explain when and why the node was deprecated and especially which replacement should be used. @condition Non-formal explanation of the condition under which the node is executed or skipped. @param Description for a parameter. Following are the name of the parameter and its description. @charvar Description for a characteristic variable. Following are the name of the variable and its description. @author Author of the Test set or Test case. @version Version of the Test case or Test case. @since The version since which this Test set or Test case has been available. In addition to the doctags described above, the doctag '@title' in the comment of the root node can be used to specify a title for the testdoc document created for the respective test suite.","hash":"usec_testdoc","h1":"Testdoc documentation for Test sets and Test cases"},"660":{"id":660,"content":"Pkgdoc documentation for Packages, Procedures and Dependencies The concepts of and methods for creation of pkgdoc documents are nearly identical to testdoc, so this section is brief. Instead of Test set and Test case nodes, pkgdoc documents cover Package, Procedure and Dependency nodes. They are intended for the test developer to keep track of the procedures available for use in implementing tests. Please refer to the standard library qfs.qft as a good example how a pkgdoc may look like. A pkgdoc document can also either be created interactively using »File«-»Create HMTL/XML pkgdoc...« or in batch mode. Again, please see \"Command line arguments and exit codes\" for detailed information about the available command line arguments. As the following example shows, testdoc and pkgdoc can even be created together in a single batch run: qftest -batch -gendoc -testdoc tests -pkgdoc procedures directory/with/test suites Example 16.4: Creating testdoc and pkgdoc documentation in a single run Of course pkgdoc also supports HTML markup and doctags. The following doctags are supported for Package, Procedure and Dependency nodes: @deprecated If a Procedure, Dependency or Package is no longer to be used, this description should explain when and why the node was deprecated and especially which replacement should be used. @param (Procedure and Dependency only) A parameter of a Procedure or Dependency. Following are the name of the parameter and its description. @charvar (Dependency only) Description for a characteristic variable of a Dependency. Following are the name of the variable and its description. @return (Procedure only) The return value of the procedure. @result (Procedure and Dependency only) Can be used to document side-effects of the Procedure or Dependency like setting a global variable. @throws (Procedure only) Expected exception. Following are the name of the exception and a description of its cause. @catches (Dependency only) An exception being caught by the Dependency. Following are the name of the exception and a description of the handler. @author Author of the Package, Procedure or Dependency. @version Version of the Package, Procedure or Dependency. @since The version since which this Package, Procedure or Dependency is available. In addition to the doctags described above, the doctag '@title' in the comment of the root node can be used to specify a title for the pkgdoc document created for the respective test suite.","hash":"usec_pkgdoc","h1":"Pkgdoc documentation for Packages, Procedures and Dependencies"},"661":{"id":661,"content":"Mobile Manual","hash":"","h0":"Test execution | QF‑Test Manual"},"662":{"id":662,"content":"Mobile Manual","hash":"home-link","h0":"Test execution | QF‑Test Manual"},"663":{"id":663,"content":"Test execution When talking about test execution, there are two aspects to be considered. On one hand you need to run tests while they are developed to check them for proper operation. This situation has already been described in \"Running tests\". Basically all you have to do to run a test interactively is invoking »Run«-»Start« from the main menu. On the other hand you want to run your tests periodically to ensure the stability of the system under test, for example in nightly regression tests. Instead of launching QF‑Test, loading the test suite and running it from the graphical user interface, it is much more convenient here to execute tests from the command line in batch mode. This kind of running tests is explained in the first section of this chapter (Test execution in batch mode). Sometimes, for instance when you want to run the test on a remote computer, a second variant comes into play: the daemon mode. This type of test execution, which uses a running QF‑Test instance to execute tests, is the topic of the second section (Executing tests in daemon mode). For integration of QF‑Test with build tools like ant, maven or Jenkins, please refer to \"Integration with Development Tools\".","hash":"usec_testexecution","h1":"Test execution"},"664":{"id":664,"content":"Mobile Manual","hash":"","h0":"Test execution in batch mode | QF‑Test Manual"},"665":{"id":665,"content":"Mobile Manual","hash":"home-link","h0":"Test execution in batch mode | QF‑Test Manual"},"666":{"id":666,"content":"Test execution in batch mode There are a lot of command line arguments when running QF‑Test in batch mode; an overview can be found in \"Command line arguments and exit codes\". Here we will present examples showing the most important of them. The examples are written for the Windows operating system, but you may easily adapt them for the Linux platform. What is different is the path specification and also the syntax for placeholders (\"Placeholders in the filename parameter for run log and report\"): On Linux you can use +X as well as %X. On Windows there's a separate console application qftestc.exe. In contrast to its GUI variant qftest.exe, it waits until the execution of QF‑Test has terminated and also displays print output from a Server script. You can use qftestc.exe in place of qftest.exe wherever you'll find it convenient.","hash":"usec_execbatch","h0":"Test execution in batch mode"},"667":{"id":667,"content":"Command line usage Let's start with the most simple QF‑Test command to execute a test: qftest -batch -run c:\\mysuites\\suiteA.qft Example 17.1: Test execution from the command line The argument -batch makes QF‑Test start without a graphical user interface. The second argument, -run, is the specifier for test execution. Finally, at the end of the command line, you find the test suite to be executed. The argument -run is optional, i. e. the test execution is defined as default for the batch mode. When running the above command, all top-level Test case and Test set nodes of suiteA.qft will be executed one after another. After the test run you will find a run log file in the current directory; it has the same name as the test suite (except from the extension, which can be .qrl, .qrz or .qzp). The run log file shows the result of the test run. By specifying -nolog you can suppress the creation of a run log. Probably this only makes sense, if you have extended your test by your own log output (written to a file). Otherwise you'd have to check the result code of QF‑Test, whereas 0 means that everything is alright. A positive value in contrast indicates that warnings, errors or exceptions occurred during the test run (see \"Exit codes for QF‑Test\"). That's why in most situations you'll probably prefer to create a run log and save it at a fixed place in the file system. This can be achieved with the parameter -runlog: qftest -batch -compact -runlog c:\\mylogs\\+b c:\\mysuites\\suiteA.qft Example 17.2: Test execution with run log creation A run log file suiteA.qrz will now be created in the specified directory c:\\mylogs. The placeholder +b is responsible for its name being identical with that of the test suite. The additional switch -compact prevents the run log from growing too large: Only the nodes needed for a report and those immediately before an error or an exception are kept in the run log. Especially in case of very long test runs this may help to reduce the amount of required memory. The newer method of using split run logs is even more powerful. For more information about that see \"The run log\". Whether the file is indeed created as compressed run log (to be distinguished from the above \"compact\") with extension .qrz, depends on the system settings. To force the creation of a particular format you can set the file extension explicitly. With -runlog c:\\mylogs\\+b.qrl, for example, an uncompressed XML file will be produced. Sometimes you may want to execute not the whole test suite but only parts of it. By using the parameter -test you can run a specific node of the test suite: qftest -batch -runlog c:\\mylogs\\+b -test \"My test case\" c:\\mysuites\\suiteA.qft Example 17.3: Executing a specified node The parameter -test expects the QF‑Test ID attribute of the node to follow or the qualified name of a Test case or Test set. If you want to execute several nodes, you can define -test <ID> multiple times. Apart from the node's QF‑Test ID, -test accepts also the numerical index of a top-level node. For example, -test 0 will run the first child of the Test suite node. The run log provides a rather technical view of the test run; it is helpful mainly when analyzing errors (cf. \"The run log\"). The report in contrast contains a summary of the executed test cases and errors (cf. \"Reports and test documentation\") in XML or HTML format. It is created from the run log either in a separate step after running the test or automatically with the test run: qftest -batch -runlog c:\\mylogs\\+b -report c:\\mylogs\\rep_+b_+y+M+d+h+m c:\\mysuites\\suiteA.qft Example 17.4: Creating a report In this example the XML and HTML files are saved in a directory which name consists of the test suite and a timestamp like c:\\mylogs\\rep_suiteA_0806042152. When replacing the argument -report with -report.xml or -report.html respectively, only an XML or HTML report will be created. Test cases often uses variables to control the execution of the test. For example, you may have defined the variable myvar in the Test suite node of the suite. You can overwrite its default value when running the test suite from the command line: qftest -batch -variable myvar=\"Value from command line\" -runlog c:\\mylogs\\+b c:\\mysuites\\suiteA.qft Example 17.5: Test execution with variables If needed, you can specify -variable <name>=<wert> multiple times to set values for different variables.","hash":"sec_command_line_usage","h1":"Command line usage"},"668":{"id":668,"content":"Windows batch script Running tests from the command line is fundamental for integrating QF‑Test in test management systems (see Interaction with Test Management Tools). Otherwise, living without such a tool, you may find it convenient to embed the command for the test execution into a script. A simple Windows batch script (qfbatch.bat) looks like this: @echo off setlocal if \"%1\" == \"\" ( echo Usage: qfbatch Testsuite goto end ) else ( set suite=%~f1 ) set logdir=c:\\mylogs pushd c:\\programs\\qftest\\qftest-10.0.2-mobile\\bin @echo on .\\qftest -batch -compact -runlog %logdir%\\+b %suite% @echo off if %errorlevel% equ 0 ( echo Test terminated successfully goto end ) if %errorlevel% equ 1 ( echo Test terminated with warnings goto end ) if %errorlevel% equ 2 ( echo Test terminated with errors goto end ) if %errorlevel% equ 3 ( echo Test terminated with exceptions goto end ) if %errorlevel% leq -1 ( echo Error %errorlevel% goto end ) :end popd Example 17.6: Batch script qfbatch.bat to execute a test suite Now you can simply run that script with only the file name of the test suite as parameter. Everything else is done automatically: The test suite will be executed, the run log file stored in logdir and finally the script will print out the state of the test run (depending on the QF‑Test result code).","hash":"sec_windows_batch_script","h1":"Windows batch script"},"669":{"id":669,"content":"Groovy Since version QF‑Test 3 the language Groovy is part of the release (cf. \"Scripting\"). It is meant mainly for scripting inside QF‑Test (Server and SUT scripts), but it can, like Jython, also be used outside of QF‑Test. Groovy is probably well suited to create a little test execution management system by yourself. By the way, Groovy simplifies working with Ant, too: Instead of dealing with bulky XML files, which makes it hard to define conditions, you can work with the Groovy AntBuilder. However, that's out of scope here, the following example doesn't rely on Ant but only on the basic Groovy features: def suite = '' if (args.size() == 0) { println 'Usage: groovy QfExec Testsuite' return } else { suite = args[0] } def qftestdir = 'c:\\\\programs\\\\qfs\\\\qftest\\\\qftest-10.0.2-mobile' def qftest = qftestdir + '\\\\bin\\\\qftest.exe' def command = [qftest, \"-batch\", \"-compact\", \"-runlog\", \"c:\\\\mylogs\\\\+b\", suite] def printStream = { stream -> while (true) { try { stream.eachLine { println it } } catch (IOException) { break } } } println \"Running command: $command\" def proc = command.execute() new Thread().start() { printStream(proc.in) } new Thread().start() { printStream(proc.err) } proc.waitFor() switch (proc.exitValue()) { case '0': println 'Test terminated successfully'; break case '1': println 'Test terminated with warnings'; break case '2': println 'Test terminated with errors'; break case '3': println 'Test terminated with exceptions'; break default: println \"Error ${proc.exitValue()}\" } Example 17.7: Groovy script QfExec.groovy to execute a test suite If you have Groovy installed on your computer independently of QF‑Test, you can run the example test suite simply via groovy QfExec c:\\mysuites\\suiteA.qft. Otherwise you can use the Groovy jar file from the QF‑Test installation, preferably again with help of a batch script: @echo off setlocal if \"%1\" == \"\" ( echo Usage: qfexec Testsuite goto end ) set qftestdir=c:\\programs\\qftest\\qftest-10.0.2-mobile set scriptfile=QfExec.groovy java -cp %qftestdir%/lib/groovy-all.jar groovy.ui.GroovyMain %scriptfile% %* :end Example 17.8: Batch script qfexec.bat to run a Groovy script (here: QfExec.groovy) Now execute the test suite with qfexec c:\\mysuites\\suiteA.qft.","hash":"sec_groovy","h1":"Groovy"},"670":{"id":670,"content":"Mobile Manual","hash":"","h0":"Executing tests in daemon mode | QF‑Test Manual"},"671":{"id":671,"content":"Mobile Manual","hash":"home-link","h0":"Executing tests in daemon mode | QF‑Test Manual"},"672":{"id":672,"content":"Executing tests in daemon mode In daemon mode QF‑Test listens to RMI connections and provides an interface for remote test execution. This is useful for simplifying test execution in a distributed load-testing scenario (\"Performing GUI-based load tests\"), but also for integration with existing test management or test execution tools (\"Interaction with Test Management Tools\"). GUI tests require an active user session. Chapter Hints on setting up test systems contains useful tips and tricks to set-up the daemon process. In FAQ 14 you can find technical details.","hash":"usec_execdaemon","h0":"Executing tests in daemon mode"},"673":{"id":673,"content":"Launching the daemon !!! Warning !!! Anybody with access to the QF‑Test daemon can start any program on the machine running the daemon with the rights of the user account that the daemon is running under, so access should be granted only to trusted users. If you are not running the daemon in a secure environment where every user is trusted or if you are creating your own library to connect to the QF‑Test daemon, you definitely should read \"Daemon security considerations\" about how to secure daemon communication with SSL. To work with a daemon, you must first launch it on any computer in your network (of course, this host can also be localhost): qftest -batch -daemon -daemonport 12345 Example 17.9: Launching a QF‑Test daemon Important compatibility note: Starting with QF‑Test version 3.5, SSL is used for daemon communication by default. To interact with a QF‑Test version older than 3.5 you must start the daemon with an empty -keystore <keystore file> argument in the form: qftest -batch -keystore= -daemon -daemonport 12345 Example 17.10: Launching a QF‑Test daemon without SSL If you omit the argument -daemonport, the daemon will listen on QF‑Test's standard port 3543. You may check whether the daemon is running by means of the netstat utility: netstat -a -p tcp -n | findstr \"12345\" netstat -a --tcp --numeric-ports | grep 12345 If you want to launch a daemon on a remote host, you may use for instance ssh or VNC. Your network administrator knows whether and how this works. To follow the examples below, a local daemon will be sufficient.","hash":"sec_launching_the_daemon","h1":"Launching the daemon"},"674":{"id":674,"content":"Controlling a daemon from QF‑Test's command line The easiest way to get in touch with a daemon is running QF‑Test from the command line in the calldaemon mode. The following example checks if a daemon is listening at the specified host and port: qftestc -batch -calldaemon -daemonhost localhost -daemonport 12345 -ping Example 17.11: Pinging a QF‑Test daemon In contrast to the netstat command from above -ping also works between different computers (if you check the daemon on your local computer, you can omit the argument -daemonhost). What you actually want from a daemon is executing your test case(s) and getting back a run log file. It sounds and indeed looks quite similar to what you have seen before when running a test in batch mode: qftest -batch -calldaemon -daemonhost somehost -daemonport 12345 -runlog c:\\mylogs\\+b -suitedir c:\\mysuites suiteA.qft#\"My test case\" Example 17.12: Running a test case with the QF‑Test daemon In contrast to the batch mode, a Test case or a Test set node is always referenced here by its qualified name, for instance \"My Test set.My Test case\" (just to remember: -test <ID> may be used in batch mode). To execute the complete suite suiteA.qft, you can simply omit the test case or write suiteA.qft#.. If the daemon is running on a remote host, you have to specify it explicitly via -daemonhost (default is -daemonhost localhost). Note that the parameter -suitedir refers to the remote host (where the daemon is running) while -runlog defines a local file. In case you cannot easily observe the test running on a remote host, you may find it convenient to add the argument -verbose to get status output in the console (on Windows, use qftestc to see the output). A running daemon, no matter whether local or remote, can be terminated with the calldaemon command -terminate: qftest -batch -calldaemon -daemonport 12345 -daemonhost localhost -terminate Example 17.13: Terminating a QF‑Test daemon A complete list of the calldaemon parameters can be found in the chapter Command line arguments and exit codes.","hash":"usec_calldaemon","h1":"Controlling a daemon from QF‑Test's command line"},"675":{"id":675,"content":"Controlling a daemon with the daemon API Using the QF‑Test command line to control a daemon was quite easy. On the other hand, to get all capabilities of a daemon, you have to deal with the daemon API. In this section we will concentrate on some basic examples, the whole interface is described in \"Daemon mode\". To get started with the daemon API, insert a Server script node with the following code: from de.qfs.apps.qftest.daemon import DaemonRunContext from de.qfs.apps.qftest.daemon import DaemonLocator host = \"localhost\" port = 12345 # Leading r means raw string to allow normal backslashes in the path string. testcase = r\"c:\\mysuites\\suiteA.qft#My test case\" timeout = 60 * 1000 def calldaemon(host, port, testcase, timeout=0): daemon = DaemonLocator.instance().locateDaemon(host, port) trd = daemon.createTestRunDaemon() context = trd.createContext() context.runTest(testcase) if not context.waitForRunState(DaemonRunContext.STATE_FINISHED, timeout): # Run did not finish, terminate it context.stopRun() if not context.waitForRunState(DaemonRunContext.STATE_FINISHED, 5000): # Context is deadlocked raise UserException(\"No reply from daemon RunContext.\") rc.logError(\"Daemon call did not terminate and had to be stopped.\") result = context.getResult() log = context.getRunLog() rc.addDaemonLog(log) context.release() return result result = calldaemon(host, port, testcase, timeout) rc.logMessage(\"Result from daemon: %d\" %result) Example 17.14: Daemon API in a Server script The script shows the basic mechanisms to control a daemon: First find a running daemon with locateDaemon. Provide an environment for test runs by calling createTestRunDaemon. To run a test, you need a context object (createContext). The creation of that object requires a QF‑Test run-time license. Now the context enables you to start a test run (runTest) and to query about its current state. waitForRunState waits during the defined timeout (in milliseconds) until the specified state has occurred. In the example above, we wait for the test to terminate within one minute. Finally, when the test run has terminated, the context can query the test result with the method getResult (cf. Exit codes for QF‑Test). Moreover, you can use the context to get the run log of the daemon test run. It can be included in the local run log by means of the rc method addDaemonLog. To keep it small and simple, the example script does not contain any error handling. However, particularly when working with a daemon, you should check every method call. Driving a daemon from a Server script has the disadvantage of consuming an additional QF‑Test license to run the script node interactively or in batch mode. However, this doesn't apply nor for the above-mentioned calldaemon mode neither for the case when controlling a daemon outside QF‑Test (see below). The usage of the daemon API is not restricted to Server scripts. Outside QF‑Test a daemon can be contacted by means of a Java program or, more easily, a Groovy script. The following Groovy script works with several running daemons and may serve as a starting point for load tests. Suppose we have started some daemons in our network, each on a separate machine. We want to execute a test case simultaneously by all of the daemons and we want to save a run log for every single test run (daemon1.qrl, ..., daemonN.qrl). The test suite containing the test case to be executed may be available for all daemon instances via the network drive z:). import de.qfs.apps.qftest.daemon.DaemonLocator import de.qfs.apps.qftest.daemon.DaemonRunContext def testcase = \"z:\\\\mysuites\\\\suiteA.qft#My test case\" def logfile = \"c:\\\\mylogs\\\\daemon\" def timeout = 120 * 1000 def keystore = \"z:\\\\mysuites\\\\mydaemon.keystore\" def password = \"verySecret\" def locator = DaemonLocator.instance() locator.setKeystore(keystore) locator.setKeystorePassword(password) def daemons = locator.locateDaemons(10000) def contexts = [] // Start tests for (daemon in daemons) { def trd = daemon.createTestRunDaemon() trd.setGlobal('machines', daemons.size().toString()) def context = trd.createContext() contexts << context context.runTest(testcase) } // Wait for tests to terminate for (i in 0..<contexts.size()) { def context = contexts[i] context.waitForRunState(DaemonRunContext.STATE_FINISHED, timeout) byte[] runlog = context.getRunLog() def fos = new FileOutputStream(\"$logfile${i + 1}.qrl\") fos.write(runlog) fos.close() context.release() } Example 17.15: Groovy daemon script CallDaemon.groovy To run that Groovy script, you need the QF‑Test libraries qftest.jar, qfshared.jar, and qflib.jar as well as the Groovy library, which is also part of the QF‑Test installation. The following batch script shows how it works: @echo off setlocal set qftestdir=c:\\programs\\qftest\\qftest-10.0.2-mobile set qflibdir=%qftestdir%\\qflib set classpath=%qftestdir%\\lib\\groovy-all.jar set classpath=%classpath%;%qflibdir%\\qftest.jar;%qflibdir%\\qfshared.jar;%qflibdir%\\qflib.jar java -cp %classpath% groovy.ui.GroovyMain CallDaemon Example 17.16: Batch script calldaemon.bat to run Calldaemon.groovy When accessed from externally, the DaemonLocator can only determine the default keystore to encrypt the daemon communication automatically, if the qftest.jar file is loaded from the QF‑Test directory (as shown in the batch script). Alternatively (as seen in the groovy script), the keystore can be specified explicetly by calling setKeystore and setKeystorePassword, or indirectly with the system properties javax.net.ssl.keyStore and javax.net.ssl.keyStorePassword. To make the daemon example a load test (cf. \"Performing GUI-based load tests\"), you have to synchronize the test runs inside \"My test case\" (e.g. after starting the SUT). This can be done by means of the rc method syncThreads: def machines = rc.getNum('machines') rc.syncThreads('startup', 60000, -1, machines) Example 17.17: Groovy Server script node to synchronize the test runs The variable machines denotes the number of hosts with a daemon running on them. Best define it in the Test suite node of the test suite with a default value of 1. When running the Groovy script, it will be overwritten with the correct value.","hash":"sec_controlling_a_daemon_with_the_daemon_api","h1":"Controlling a daemon with the daemon API"},"676":{"id":676,"content":"Mobile Manual","hash":"","h0":"Re-execution of nodes (Rerun) | QF‑Test Manual"},"677":{"id":677,"content":"Mobile Manual","hash":"home-link","h0":"Re-execution of nodes (Rerun) | QF‑Test Manual"},"678":{"id":678,"content":"Re-execution of nodes (Rerun)","hash":"usec_rerun","h0":"Re-execution of nodes (Rerun)"},"679":{"id":679,"content":"Triggering rerun from a run log When a test run has finished, the run log or report is a good entry point for evaluating the results. In case of errors you may face various challenges. You might want to re-execute the failed test cases to investigate the reason for the error or because you want to perform an official re-test of this failing situation after removing the error condition. If the re-test results are to be shown in the test-report, you may want to replace the previous results or append them to the existing ones. Or you might just want to repeat the test case with the previous variable settings and keep the new run logs and reports separately. To that end QF‑Test offers the capability to trigger re-execution from the run log. You can trigger a rerun via selecting the run log node or any test set node and choose »Rerun test cases« from the »Edit« menu or from the context menu. Alternatively you can select the nodes to rerun it the error list and use the context menu entry »Rerun test cases of selected nodes«. The dialog then shown lets you select the test cases for the rerun and choose how to handle run logs via the selection box Mode for merging run logs with the following options:","hash":"usec_rerun_from_log","h1":"Triggering rerun from a run log"},"680":{"id":680,"content":"Choice Meaning Replace test cases Replace the test cases from the original run log with the results from the rerun, i.e. the previous results will get lost. The previous run log will be saved in a backup copy. Merge run logs The new test results will be merged into the existing structure. Append run log The new test results will be appended to the end of the run log. The test set structure will be ignored. Keep run logs separated The new test results will be written to a new run log, the original one remains unchanged. Table 17.1: Choices for handling the run log of a rerun","hash":"table_17.1","h1":"Triggering rerun from a run log"},"681":{"id":681,"content":"Figure 17.1: Dialog to rerun test cases For each test case the variable values are taken from the run log of the original test run. Since only the String value of the variables is stored in the run log, all values are of type \"String\" during rerun from long. During re-execution the variable ${qftest:isInRerunFromLog} is set to true, making it possible to distinguish between a normal test run and a rerun. Merging of run logs makes use of names of test cases and test sets. Therefore, those names should be unique. In case of data-driven testing you should take care to keep those names unique via the attributes Name for separate run log or Characteristic variables.","hash":"figure_17.1","h4":"Figure 17.1: Dialog to rerun test cases"},"682":{"id":682,"content":"Rerunning failing nodes immediately During your test automation project you can sometimes face situations where some test steps don't provide reliable results, failing sometimes but not always. Most of the time such cases depend on timing and can be stabilized using Wait for component to appear nodes, or checks for conditions, delays, scripts or other control structures. As an alternative or additional approach QF‑Test offers the capability to repeat such steps whenever they fail. This automated rerunning in case of error can be applied to every executable node using a certain doctag in the comment attribute. This doctag can look like this: @rerun attempts=3;errorlevel>=ERROR;newerrorlevel=WARNING; handler=handlers.errorhandler Example 17.18: Example for a rerun definition In the example above a failed node will be repeated up to three times until an attempt succeeds. Failed attempts will be downgraded to \"warning\" in the run log. In case all attempts fail, the last attempt will be reported as an error or exception. After every failed attempt QF‑Test will execute the procedure handlers.errorhandler. If you are interested in the number of the current rerun attempt, you can use the variable reruncounter from the qftest variable group, see \"Special groups\". The @rerun doctag offers the following parameters: attempts The maximum number of attempts. errorlevel (optional) Defines the error states to be handled. Possible values are EXCEPTION, ERROR or WARNING with = for an exact match or > or >= for a range. Specifying errorlevel=ERROR means to rerun that node only in case of an error whereas errorlevel>=ERROR triggers the rerun in case of errors or exceptions. If this parameter isn't specified the value errorlevel>=ERROR will be taken as default. newerrorlevel (optional) Specifies the error-level in the run log for the initial run and possible additional failed runs. You can again choose between EXCEPTION, ERROR or WARNING with the additional options NOLOG and KEEP. The level NOLOG stands for removing the failing results from the run log entirely. NOLOG should be used with extreme care. Using the level KEEP doesn't override the original error level and reports it unchanged. If this parameter isn't specified the value WARNING will be taken as default. handler (optional) The name of the procedure which should be called in case a caught error state occurs. This procedure will be called after each failed attempt. reusevariables (optional, default=true) Specifies whether to reuse the variable values from the beginning of the first run. When set to false the current variable values will be used. logmessages (optional, default=true) If that parameter is set to true a message will be written into the run log, when an attempt begins and when the execution of that sequence terminates. In addition, every node gets an annotation in the run log with the current attempt. logmessagesintoreport (optional, default=true) If this parameter and the parameter logmessages are set to true, all messages will be written to the report as well. keepfirst (optional, default=false) If this value is set to true the first failing attempt will be logged with its original error level. In case of further failing attempts those errors will be logged with the newerrorlevel level. exceptiontype (optional) In case you want to catch only one specific exception you can specify the exception type here, e.g. CheckFailedException or just ClientNotConnected for a ClientNotConnectedException. This parameter should only be used if you set Exception as value for the parameter errorlevel. Please see the Catch node for details about exceptions. exceptionmessage (optional) In case you want to catch only one specific exception with one text, you can specify the text here. This parameter should only be used if you set Exception as error level. Please see the Catch node for details about exceptions. exceptionregex (optional) If true, the value of exceptionmessage is a regular expression. This parameter should only be used if you set Exception as error level and an exception message. Please see the Catch node for details about exceptions. exceptionlocalized (optional) If true, the value of exceptionmessage should be the localized exception message, e.g. mostly the full text. This parameter should only be used if you set Exception as error level and an exception message. Please see the Catch node for details about exceptions.","hash":"usec_rerun_node","h1":"Rerunning failing nodes immediately"},"683":{"id":683,"content":"Mobile Manual","hash":"","h0":"Distributed test development | QF‑Test Manual"},"684":{"id":684,"content":"Mobile Manual","hash":"home-link","h0":"Distributed test development | QF‑Test Manual"},"685":{"id":685,"content":"Distributed test development The previous chapters all focused on creating and organizing sets of reliable tests in a single test suite. However, when testing a large application, a single suite may not be enough. There are at least two scenarios where splitting tests into multiple test suites becomes essential: Multiple developers are creating and editing tests. To avoid redundancy and duplication of code, separately developed tests should use common Procedures and Components where possible, but only one person can edit a test suite at a time. Tests are simply getting too large. Run logs for extensive test runs may cause the system to run out of memory and organizing a large number of tests in a single suite is difficult. Things may become unwieldy. It may also be desirable to be able to run some of the tests as part of the whole test as well as standalone. QF‑Test provides a set of advanced features that make it possible to split and arrange tests across a set of test suites. Multiple developers can work on separate parts of a test, then coordinate their efforts, merge the Components of their suites and create libraries of shared Procedures. This chapter first explains the various mechanisms for distributed test development and how they interact. The final section then summarizes these in concise step-by-step instructions on how to approach large testing efforts with QF‑Test.","hash":"usec_distributeddevelopment","h0":"Distributed test development"},"686":{"id":686,"content":"Referencing nodes in another test suite It is possible to reference Procedures and Components in a test suite other than the current one. These references can be explicit or implicit through included files: Explicit references use a syntax similar to the one used in URLs to specify an item inside a web page. The referenced suite must be prepended to the Procedure name attribute of a Procedure call of the QF‑Test component ID attribute of a Component dependent node, separated by a '#' character. The usual packagepath.procedure becomes suite#packagepath.procedure. Implicit references make use of the Include files attribute of the Test suite node. Whenever a node is not found in the current suite, QF‑Test will search for a matching Procedure or Component within all the suite's directly or indirectly included files (a file is considered indirectly included by a suite if it is found as an included file within one of the suite's own included files; for example, if suite A includes B, and suite B includes C, then C is indirectly included by A). A test suite that references a node in another test suite becomes dependent on that suite. If the Name of a Procedure or the QF‑Test ID of a Component in the referenced suite changes, the suite with the reference must get updated, otherwise the link is broken and the suite will no longer work correctly. In such cases QF‑Test will automatically update references if it knows about them. The best way to ensure that is to have both test suites in a common project because QF‑Test automatically tracks all includes and all explicit references within a project. Alternatively you can list the calling suite in the Dependencies (reverse includes) attribute of Test suite root node of the referenced suite. While implicit references are more convenient in most cases, they can make tests harder to understand because it is not immediately obvious where the Procedure or Component referenced by some node is actually located. One possibility to find out is to select \"Locate procedure\" (Ctrl⁠+⁠P) or \"Locate component\" (Ctrl⁠+⁠W) from the context menu. Additionally, QF‑Test provides the menu items »Operations«-»Make references explicit« and »Operations«-»Make references implicit« which let you toggle quickly between the two modes without changing the actually referenced nodes. In both cases, the referenced suite can either be given a relative or absolute filename. Relative filenames will be resolved relatively to the directory of current suite, or - if that fails - relatively to the directories on the library path (see option Directories holding test suite libraries). Always use the forward '/' as the directory separator, even under Windows. QF‑Test will map it to the correct character for the system it runs on. This keeps your test suites independent from the operating system. Your Package and Procedure names as well as Component QF‑Test IDs should not contain any '\\' or '#' characters. If they do, you need to include an escape character in the Procedure call or the QF‑Test component ID attribute. See \"Quoting and escaping special characters\" for details about escaping and quoting special characters. When choosing the Procedure for a Procedure call or the Component for some event in the dialog, QF‑Test offers a selection of all currently opened test suites. If a Procedure or Component from another test suite is selected, QF‑Test automatically creates the correct reference, taking included suites into account. When the test is run at a later time, the referenced test suite is loaded automatically if necessary. During execution QF‑Test keeps a stack of currently executing suites. Whenever a Procedure is called in another suite, the called suite is pushed on to the top of this stack and removed when execution returns to the calling suite. Whenever during the execution of a Procedure a Window or Component is referenced by its QF‑Test ID, QF‑Test searches through this stack of suites from the top to the bottom, i.e. first in the test suite of the called Procedure and then in the calling suite, always checking any included files along the way. This process is quite complicated and you should take care to keep your include hierarchies simple. In case you encounter problems anyway, a detailed explanation is given in \"Include file resolution\".","hash":"usec_suitereference","h1":"Referencing nodes in another test suite"},"687":{"id":687,"content":"Managing Components As we have emphasized in \"Components\", the Components are the essential part of a test suite. If the SUT changes between releases, these will likely be affected most. If changes are so massive that QF‑Test cannot adapt automatically, the Components will have to be updated manually. This is why you should try to avoid redundancy in the Component hierarchy of your tests more than in any other part. Therefore, when splitting your tests across multiple test suites you should try to keep the Components together in one central test suite and include this suite from the other suites. For very large applications you may want to split the Component hierarchy into parts, each related to a separate part of the SUT's GUI. Maintaining this central Component library is not trivial. The problems that will arise can be resolved with QF‑Test as follows: When multiple test developers are recording new Components simultaneously, they cannot be integrated immediately into the central suite, because only one user can edit the central suite at a time. Instead, Components must be integrated later by importing them into the central suite when the new tests have stabilized. This is explained in the following section. When the SUT changes, Components in the central suite may need to be updated. If this involves changing any Component QF‑Test IDs, this will break any references to these Components from other suites. To avoid that, QF‑Test must update those references and it will do so, provided that the suites that depend on the central suite are currently loaded, belong to the same project or are listed in the Dependencies (reverse includes) attribute of the Test suite node of the central suite.","hash":"usec_manageComponents","h1":"Managing Components"},"688":{"id":688,"content":"Merging test suites test suites can be merged by importing one test suite into another with the »File«-»Import...« menu item. You can select the areas of the test suite, which should be imported. You have to take care about a correct Include/Reverse-Include of your test suites to ensure, that all calls and component references are still valid. See \"Organizing test suites\" for details.","hash":"usec_merging","h1":"Merging test suites"},"689":{"id":689,"content":"Importing Components During import, all Windows and Components of the imported test suite are integrated into the component hierarchy of the importing suite. Components that already exist are not copied. A QF‑Test ID conflict (identical components with different QF‑Test IDs or differing components with identical QF‑Test IDs) is resolved automatically by changing the QF‑Test ID of the imported component. Afterwards, all Windows and Components are removed from the imported suite. All nodes in the imported suite that referred to these Components are updated accordingly. Ideally, the imported suite should include the importing suite so no explicit suite references will have to be created.","hash":"sec_importing_components","h2":"Importing Components"},"690":{"id":690,"content":"Importing Procedures and Testcases As you can import Components QF‑Test also allows to import Procedures, Packages, Dependencies and Test cases as well as Test sets by choosing 'Procedures' or 'Tests' in the import dialog. You should take care about keeping all calls consistent, e.g. in most cases it does not make sense to import Procedures without their required Components. In case you only want to import one dedicated Procedure or Test case you can use the button 'Detailimport' on the importdialog. Here you can choose any node you want to import separately.","hash":"sec_importing_procedures_and_testcases","h2":"Importing Procedures and Testcases"},"691":{"id":691,"content":"Strategies for distributed development There is no single best way of test development or organization, but one approach that works well is the following: Start with a central test suite that has the functionality needed to start and stop the SUT and a basic set of Tests and Procedures. This will become your master suite which will contain all Components. Make sure that your developers have understood the importance of assigning names with setName() and that unique names are assigned consistently where needed. Where setName() is not an option, try to implement ComponentNameResolvers to achieve this (see \"The NameResolver Interface\"). You should be able to record and replay sequences without much ado and without \"polluting\" the Component hierarchy after trivial changes in the user interface. Move as much functionality as possible into Procedures, especially commonly-used stuff and the setup and cleanup routines for the SUT. To create new tests, start with an empty test suite. Include the master test suite by editing the Include files attribute of the Test suite node of the new suite. Create the Setup and Cleanup nodes to start and stop the SUT by calling the respective Procedures in the master suite. Create your tests as required. When recording sequences, the Components of the master-suite will be used if possible. New Components are added to the new suite, so the master suite will not be modified at this stage. Where possible, call Procedures in the master suite for common operations. When your new set of tests is complete and you are satisfied that they work well, import any required nodes of your new test suite into the master suite. You have to ensure that all new Component nodes that you recorded are imported into the master suite's Component hierarchy in any case. The master suite's existing Components will not be affected by this, so other suites that depend on the master suite will not need to be modified. After importing Components you can import all or only the required Procedures into the master suite. You now have various options of how to arrange the actual sequences of events and checks that form your tests. In any case it is a good idea to move everything to Procedures and Packages structured after your test-plan. Then the top-level Test set or Test case nodes of the master suite and your new suite will only contain the required hierarchy of Test set, Test case, Test step and Sequence nodes filled with Procedure calls to the actual test cases. Such an arrangement has several advantages: All your tests are structured cleanly. You can easily create different sets of tests with varying complexity and run-time. You have the option to keep the test cases in separate test suites and have the master suite call them. These \"test case-libraries\" must include the master-suite, so they need not contain any Components themselves. You can organize your tests so that the master-suite will run the whole set of tests, while each separate suite can also be run standalone. The tests can be maintained by several developers as long as modifications to the master suite are coordinated. If you decide to keep your new tests in the newly created test suite instead of moving them to the master suite, modify the master suite to tell QF‑Test that there is a new test suite that depends on it. To do so, either ensure that both test suites belong to the same project or add the new test suite to the Dependencies attribute of the master suite's Test suite node. If you need to modify or extend the new test suite later, proceed as before. You can record new sequences as needed. When you are done, merge any newly created Components back into the master suite. If your SUT changes in a way that requires updates or adaptions to the master-suite's Component hierarchy, you must coordinate your test developers. Before you start updating the Components, make sure that all suites that directly or indirectly include the master suite belong to the same project as the master suite or are listed in the Dependencies attribute of the master suite's Test suite node. If modifying the Components of the master suite involves any QF‑Test component ID changes, QF‑Test will update the depending test suites accordingly, so they should not be edited simultaneously by others. The file format for QF‑Test test suites is XML and thus plain text. As a result, test suites can be managed very well by version control systems like CVS. Changes to some QF‑Test component ID attributes of the depending suites can typically be merged with other changes without conflicts, alleviating the need for coordination. Of course, the above scheme can be extended to have several master suites for testing different parts or aspects of an application. It may be a good idea to ensure that the component hierarchies in these suites don't overlap too much though. This will save you the effort of maintaining all these hierarchies in case the user interface of the SUT changes significantly.","hash":"usec_distributedstepbystep","h1":"Strategies for distributed development"},"692":{"id":692,"content":"Static validation of test suites Working in a project over time will cause modifications, refactoring or deletion of steps in your test suite structure, e.g. you may consider renaming Procedures or simply removing them once they are not required anymore.","hash":"usec_diststaticvalidation","h1":"Static validation of test suites"},"693":{"id":693,"content":"Avoiding invalid references In such cases it is quite important that you adapt all references of the according Procedure in order to guarantee that the remaining tests keep running. For this purpose QF‑Test automatically updates all references during the process of renaming or moving elements on demand. If you want to ensure that your created test structure doesn't contain any call of non-existing Procedures anymore, you can also use the \"Analyze references\" command of QF‑Test in order to perform a static validation of your test suite. This command will open a dialog showing all references and whether they are still okay or something is missing. You can trigger the analysis via a right mouse-click and selecting »Additional node operations«-»Analyze references...« or selecting the according entry from the main menu under »Operations«. This method is also available in batch mode.","hash":"sec_avoiding_invalid_references","h2":"Avoiding invalid references"},"694":{"id":694,"content":"Figure 18.1: Result of analyzing references QF‑Test also provides features to search through your test suites for duplicate nodes, empty Packages or Procedures or to analyze for nodes having invalid characters in their names. This kind of static validation is available for Procedures, Dependencies, Test cases, Test sets and Components and their references.","hash":"figure_18.1","h4":"Figure 18.1: Result of analyzing references"},"695":{"id":695,"content":"Unused procedures During test development it could happen that procedures, which were used in the first version of your tests will not be used in newer versions due to re-factoring of tests. If those procedures won't get deleted immediately they will stay in the test suite and the test suite will grow and grow. Sometimes you could get the feeling that you have too many procedures or that you have lost the overview of your procedures. In order to check for such unused procedures or dependencies in your test suite you can open the context menu via a right mouse click at Test suite or Procedures and select »Additional node operations«-»Find unused callables...«. This operation creates a report showing any procedures or dependencies which had been created but haven't been used yet. Now you could decide what you want to do with those. Sometimes you might simply remove all of those unused nodes immediately via »Additional node operations«-»Remove unused callables«.","hash":"usec_find_unused_procedures","h2":"Unused procedures"},"696":{"id":696,"content":"Mobile Manual","hash":"","h0":"Automated Creation of Basic Procedures | QF‑Test Manual"},"697":{"id":697,"content":"Mobile Manual","hash":"home-link","h0":"Automated Creation of Basic Procedures | QF‑Test Manual"},"698":{"id":698,"content":"Automated Creation of Basic Procedures","hash":"usec_procbuilder","h0":"Automated Creation of Basic Procedures"},"699":{"id":699,"content":"Introduction At the beginning of a typical QF‑Test project the tester records the first tests and starts them. After a couple of such recordings and first success stories he notices that only recording or performing copy/paste bares some hidden pitfalls in maintaining the tests. Just think about a possible workflow change in a main panel, then the tester might have to adapt all test cases. That's why we recommend to make use of the modularization concept using procedures and variables as early as possible in a project. For more information about the modularization concept, please see \"Procedures and Packages\". In projects containing a lot of dialogs and graphical components it might be sufficient to split those procedures into component-specific ones, e.g \"press button ok\" and separate workflow procedures, e.g. \"create a vehicle\" combining the component-specific steps together. This approach enables the tester to create new test cases very fast. However, he has to put a lot of efforts into creating those basic procedures first. QF‑Test comes with a Procedure Builder, which will create those basic procedures for you. Using the Procedure Builder will drastically decrease the efforts of recording and creating procedures for graphical components. So the tester can solely concentrate on his main focus, i.e. designing the workflow of the test itself and the according test data.","hash":"usec_pbIntro","h1":"Introduction"},"700":{"id":700,"content":"How to use the Procedure Builder For creating the basic procedure automatically, you have to perform following steps: Start the SUT from QF‑Test. Navigate to the window or frame you want to create procedures for in the SUT. Press the 'Record Procedures' button, select the according menu item in QF‑Test or use the Hotkey for procedure recording. Perform a right mouse-click on the respective component in the SUT. Select the according recording-mode. Stop procedure recording by releasing the 'Record Procedures' button, by deselecting the according menu item in QF‑Test or using the Hotkey for procedure recording. Now you should be able to find a newly created package in the Procedures node of the test suite where you stopped the recording, containing the created procedures for the components. By default this is called procbuilder. If the package procbuilder already exists, a package procbuilder1 will be created and so on. When you open the package you will see a set of packages for functions like check, get, select, wait and so on. These contain the procedures created for the components you selected when running the procedure builder, apart from the check package, where another level with packages for the various check modes is inserted. This is the default structure, which you can adapt to your needs by modifying the definition file for the procedure builder as described in the following section.","hash":"usec_pbHowToUse","h1":"How to use the Procedure Builder"},"701":{"id":701,"content":"Figure 19.1: Recorded procedures","hash":"figure_19.1","h4":"Figure 19.1: Recorded procedures"},"702":{"id":702,"content":"Configuration of the Procedure Builder The act of building procedures is controlled by a template suite, which is located at qftest-10.0.2-mobile/include/procbuilderdef.qft. This file should be copied to any project-specific location, if you want to adapt it to your project. You can define its location in the options at Configuration file for recorded procedures . The template suite contains procedures for the most common GUI elements and actions. If you require other test steps, you can add the according procedure to this test suite. The file itself is a test suite with a dedicated structure. You can find a detailed explanation of this structure in the subsection \"The Procedure Builder definition file\". The definition file allows the tester to define procedures for components of dedicated classes or to define procedures for working with all components of one certain window. You can find some demo configurations at qftest-10.0.2-mobile/demo/procbuilder.","hash":"usec_pbHowPbAdapt","h1":"Configuration of the Procedure Builder"},"703":{"id":703,"content":"The Procedure Builder definition file The automated creation of basic procedures delivers different procedures depending on the components. A text-field requires a setter procedure for setting its text, a button requires a press procedure for pressing it or a window could require a setter which calls the setter procedures of all text-fields or combo-boxes on that window to call just one procedure for using the window etc..","hash":"usec_pbSkeletons","h2":"The Procedure Builder definition file"},"704":{"id":704,"content":"Figure 19.2: The Procedure Builder definition file The topmost package in the Procedures node is the name of the target package for the newly created packages. By default this is called procbuilder. This package will be inserted below the Procedures, when you have finished recording procedures. If the package procbuilder already exists, a package procbuilder1 will be created and so on. The next level is the class level. Here you can define a package per class. The package name represents the full class name, but with '_' as separators instead of '.'. That's because '.' is not allowed in package names. The Procedure Builder creates the procedures also for descendants of specified classes. In case the names of your classes contain a '_', you have to mark this via '\\_'. The following levels can be chosen freely because those levels are intended to structure the procedures. At the last level you have to define the steps of the procedure itself. Of course there are a lot of variable data in that definition, e.g. like <COMPID>. Using those you can specify variables for the procedure names, like the QF‑Test ID of the current component or the component-name. You can also record the current value of the text-field or the current selected status of a checkbox. It's even possible to keep the package structure variable. For an overview of all possible variables, please see \"The Procedure Builder definition file\".","hash":"figure_19.2","h4":"Figure 19.2: The Procedure Builder definition file"},"705":{"id":705,"content":"Mobile Manual","hash":"","h0":"Interaction with Test Management Tools | QF‑Test Manual"},"706":{"id":706,"content":"Mobile Manual","hash":"home-link","h0":"Interaction with Test Management Tools | QF‑Test Manual"},"707":{"id":707,"content":"Interaction with Test Management Tools QF‑Test contains some pragmatic test management approaches, like creating a test case overview or documenting test cases within QF‑Test. In bigger projects it might be necessary to make use of an own dedicated test management system to track the development status of test cases or to link test cases and their results to defects, use cases or features. Besides support for planning of test cases and tracking their results a test management system could also contain a test execution engine, which supervises the occupation of test systems during different test runs. As QF‑Test doesn't come with all of those features though continuously improving in that area, it is very easy to integrate QF‑Test with such a test management or test execution system using the QF‑Test Batch mode or the QF‑Test Daemon mode. For more information about the Batch mode or the Daemon mode, please see \"Test execution\". The following chapters describe some exemplary solutions which we provide for established test management systems. If you cannot find your test management system in that list, please contact our support team to get hints about a possible integration approach.","hash":"usec_testmanagement","h1":"Interaction with Test Management Tools"},"708":{"id":708,"content":"Mobile Manual","hash":"","h0":"HP ALM - Quality Center | QF‑Test Manual"},"709":{"id":709,"content":"Mobile Manual","hash":"home-link","h0":"HP ALM - Quality Center | QF‑Test Manual"},"710":{"id":710,"content":"HP ALM - Quality Center","hash":"usec_qc","h0":"HP ALM - Quality Center"},"711":{"id":711,"content":"Introduction The current integration of QF‑Test and HP ALM - Quality Center utilizes the built-in VAPI-XP-TEST type of Quality Center.","hash":"usec_qcIntro","h1":"Introduction"},"712":{"id":712,"content":"Figure 20.1: Integration with ALM - QualityCenter The VAPI-XP-TEST type is intended to be an automated test case for any test-tool. QF‑Test comes with a template file for the VAPI-XP-TEST script, which is qcVapiXPTemplate.txt, see qftest-10.0.2-mobile/ext/qualitycenter. This script can be used as template for all QF‑Test tests in Quality Center. Please see \"Step-by-step integration guide\" for a detailed step-by-step description. The QF‑Test VAPI-XP-TEST template script employs an external worker VBScript script, called qcTemplate.vbs. This script is also part of the QF‑Test distribution (see qftest-10.0.2-mobile/ext/qualitycenter) and has to be adapted to your specific needs. So we encourage you to copy that file to a project specific location and adapt it according to your needs. The worker script launches QF‑Test in batch mode on each test system locally, i.e. it has to be accessible for each test system. As the test suite files and the configuration files have to be available on the test system too, we recommend to put all those files on a shared network drive or into the version management system. After the execution of the test the run log of QF‑Test will be appended to the test instance as well as the status of the test will be set to the result. You can also change the worker script to make use of a daemon call (for details about the daemon mode, please see \"Daemon mode\"). In this case QF‑Test will establish the network connection to the test system and launch the test by itself. In case of the normal batch call Quality Center establishes the connection to the test system and triggers the local QF‑Test installation to perform the test. If you make use of the daemon call, the worker script has to be located on the Quality Center system, but the test suite still needs to be accessible on each test system. If you do not make use of VBScript in your project, feel free to port the QF‑Test demo scripts to JScript or any other supported language. The following figure shows the VAPI-XP-TEST test case in Quality Center:","hash":"figure_20.1","h4":"Figure 20.1: Integration with ALM - QualityCenter"},"713":{"id":713,"content":"Figure 20.2: QF‑Test VAPI-XP-TEST test case in HP ALM - QualityCenter","hash":"figure_20.2","h4":"Figure 20.2: QF‑Test VAPI-XP-TEST test case in HP ALM - QualityCenter"},"714":{"id":714,"content":"Step-by-step integration guide General steps to be performed on the the test system: Copy the template worker script from qftest-10.0.2-mobile/ext/qualitycenter/qcTemplate.vbs to your project location and rename it to a proper name. We recommend to use the same path on all test systems. Perhaps you should use a shared network drive. Within the worker script you can define certain default option, e.g. whether the batch or daemon mode should be used as default and what should be the name for the default run log file. This also can be done at a later stage, which might be recommendable when initially starting with the integration process to keep things simple. Steps in Quality Center to create a test case: Start Quality Center and log in to your project. You might want to create a new test set e.g. called \"DemoTestSet\" in the \"Test plan\" area.","hash":"usec_qcStep","h1":"Step-by-step integration guide"},"715":{"id":715,"content":"You might want to create a new test set e.g. called \"DemoTestSet\" in the \"Test plan\" area. Figure 20.3: In Test plan create new Test set In this test set create a new test with type VAPI-XP-TEST.","hash":"figure_20.3","h1":"Step-by-step integration guide"},"716":{"id":716,"content":"In this test set create a new test with type VAPI-XP-TEST. Figure 20.4: Create new test of type VAPI-XP-TEST On the HP VAPI-XP Wizard window just press finish without any modifications. (That means you have VBScript as script language and COM/DCOM Server Test as test type).","hash":"figure_20.4","h1":"Step-by-step integration guide"},"717":{"id":717,"content":"On the HP VAPI-XP Wizard window just press finish without any modifications. (That means you have VBScript as script language and COM/DCOM Server Test as test type). Figure 20.5: HP VAPI-XP Wizard You will then get a new test as shown below.","hash":"figure_20.5","h1":"Step-by-step integration guide"},"718":{"id":718,"content":"You will then get a new test as shown below. Figure 20.6: Test details Change to the 'Test script' tab of the test and copy the content of the template file qftest-10.0.2-mobile/ext/qualitycenter/qcVapiXPTemplate.txt into the Script Viewer's text area.","hash":"figure_20.6","h1":"Step-by-step integration guide"},"719":{"id":719,"content":"Change to the 'Test script' tab of the test and copy the content of the template file qftest-10.0.2-mobile/ext/qualitycenter/qcVapiXPTemplate.txt into the Script Viewer's text area. Figure 20.7: Copy template content to script text area Within the script please do following adaptations: Change the pathToModule variable to the location you have copied the worker script qcTemplate.vbs to. Change the testSuiteFile variable to your desired test suite file. If you want to execute one specific test, you can also change the testCase variable to the desired test case name. Please read the comments in the script carefully, because you can also use test case specific settings optionally. Steps to be performed to run the sample test case Change to the \"Test lab\" section in Quality Center. You might want to create a new sample test set.","hash":"figure_20.7","h1":"Step-by-step integration guide"},"720":{"id":720,"content":"You might want to create a new sample test set. Figure 20.8: New test set in Test lab section Add the test case to the new test sets' execution grid by choosing it from the test plan structure.","hash":"figure_20.8","h1":"Step-by-step integration guide"},"721":{"id":721,"content":"Add the test case to the new test sets' execution grid by choosing it from the test plan structure. Figure 20.9: Add test to execution grid Now you can launch the test case. Ensure the \"Run all tests locally\" checkbox is activated unless you really have a remote system with a QF‑Test environment already set up.","hash":"figure_20.9","h1":"Step-by-step integration guide"},"722":{"id":722,"content":"Now you can launch the test case. Ensure the \"Run all tests locally\" checkbox is activated unless you really have a remote system with a QF‑Test environment already set up. Figure 20.10: Run the test Now Quality Center should start the test run - possibly on your machine, then you should see the SUT coming up after some time, actions being performed and closed at the end. When the run has finished, the result is noted down with the test: Passed or Failed.","hash":"figure_20.10","h1":"Step-by-step integration guide"},"723":{"id":723,"content":"Now Quality Center should start the test run - possibly on your machine, then you should see the SUT coming up after some time, actions being performed and closed at the end. When the run has finished, the result is noted down with the test: Passed or Failed. Figure 20.11: Test result After the test has terminated, in addition to the result the run log of the test will be uploaded as attachment to the test instance. To view the run log, please double-click to the test in the execution grid, then change to \"Runs\" and again double-click at the paper-clip attachments symbol for the respective test run.","hash":"figure_20.11","h1":"Step-by-step integration guide"},"724":{"id":724,"content":"To view the run log, please double-click to the test in the execution grid, then change to \"Runs\" and again double-click at the paper-clip attachments symbol for the respective test run. Figure 20.12: Uploaded run log","hash":"figure_20.12","h1":"Step-by-step integration guide"},"725":{"id":725,"content":"Troubleshooting First of all we need to state that we are not QualityCenter experts. Therefore there might be better and advance options for troubleshooting. Hence we want to at least provide some hints we used so far. Unfortunately the process output during the test execution in QualityCenter is only visible for a fraction of time, not allowing a direct analysis. Therefore we need to find a work around. The text editor of the VAPI-XP-TEST node in the \"Test plan\" area allows to directly execute the script. Then in the output area below the output gets visible permanently showing possibly something helpful.","hash":"usec_qcHelp","h1":"Troubleshooting"},"726":{"id":726,"content":"Figure 20.13: Script debug run But the direct execution from the script node needs to be handled with care. Of course it is not considered as a real test run, so no run log can be uploaded which results in a respective Run-time error \"Object required\" in the output. Don't get confused by that! For more debugging, additional statements like TDOutput.Print \"Some text\" can be added to both the test script and the worker script. By this you can see how far the script runs until a possible error occurs. The text script editor has a \"Syntax check\" button which is helpful for validation after every change.","hash":"figure_20.13","h4":"Figure 20.13: Script debug run"},"727":{"id":727,"content":"Mobile Manual","hash":"","h0":"Imbus TestBench | QF‑Test Manual"},"728":{"id":728,"content":"Mobile Manual","hash":"home-link","h0":"Imbus TestBench | QF‑Test Manual"},"729":{"id":729,"content":"Imbus TestBench","hash":"usec_testbench","h0":"Imbus TestBench"},"730":{"id":730,"content":"Introduction The current integration of QF‑Test and the TestBench consists of two parts: Creating a QF‑Test template file using the TestBench interactions. Importing QF‑Test results into TestBench. You can find all required libraries and test suites in the folder qftest-10.0.2-mobile/ext/testbench/Version_1.1_TestBench_2.3. Please take care to copy all test suites to a project-related folder first and modify them there. The following section provides a short overview about the integration concept.","hash":"usec_itbIntro","h1":"Introduction"},"731":{"id":731,"content":"Creating QF‑Test template from interactions After planning your tests and designing the interactions in the TestBench, you can create a template QF‑Test file using the QF‑Test export plug-in for interactions. Imbus will provide all required information, how to install this plugin. After exporting the interactions you will find all interactions as procedures and their structure as packages in the QF‑Test file. Now you can start recording the respective steps in QF‑Test and fill the empty procedures. The completed file has to be saved in your project-specific test suite folder, because this file should be used as input file for the test execution later. We recommend to use a project-specific location, perhaps a shared network drive or the version management system.","hash":"usec_itbExport","h1":"Creating QF‑Test template from interactions"},"732":{"id":732,"content":"Importing test execution results For running tests you need specific test cases and procedures, which can be found in the provided test suites in the folder qftest-10.0.2-mobile/ext/testbench/Version_1.1_TestBench_2.3/suite. Please take care to copy all test suites to a project-related folder first and modify them there. You can also find a demo implementation for the CarConfigurator in the folder qftest-10.0.2-mobile/ext/testbench/Version_1.1_TestBench_2.3/suite/demo. You have to take care that you need to include the test suite TestBench_Automation.qft to your test suite. If you have created procedures via the iTEP exporting as described in chapter \"Creating QF‑Test template from interactions\" you will need to include that test suite as well. The next step is to adapt the configuration for the output files. This can be achieved by modifying the files testaut.properties and user.properties. Now you are ready to call the test case Standalone test executor from TestBench_Automation.qft. When the test run has been completed, you can import all those results using the iTEP or iTORX import plug-in into the TestBench. The single QF‑Test run logs will then be attached to the test-instances.","hash":"usec_itbExec","h1":"Importing test execution results"},"733":{"id":733,"content":"Mobile Manual","hash":"","h0":"QMetry | QF‑Test Manual"},"734":{"id":734,"content":"Mobile Manual","hash":"home-link","h0":"QMetry | QF‑Test Manual"},"735":{"id":735,"content":"QMetry","hash":"usec_qmetry","h0":"QMetry"},"736":{"id":736,"content":"Introduction The current integration between QF‑Test and QMetry relies on planning the tests and its steps within QMetry and forwarding the actual test execution to QF‑Test. Once the the test run terminates the QF‑Test run log and its HTML report will be automatically uploaded to QMetry to the respective result area as well as the state of the test case in QMetry will be set to the according result. You need to prepare your test system in order to run QF‑Test tests. Please perform the following steps: In the 'Admin' area of the QMetry Testmanagement view install a test execution agent at the 'Agent' view. Download the required agent and configuration files to install the QMetry execution agent on your test system. Install the respective QF‑Test QMetry Launcher at your test-agent. Install and set-up a platform at the 'Platform' view, which is also located in the 'Admin' area of QMetry. Configure QMetryAgent.properties correctly to use the required environment variables of QMetry's QF‑Test wrapper. Configure QMetryConfig.properties correctly to show to the right QF‑Test executable. Configure additional parameters for the QF‑Test call in QMetryConfig.properties, see next section for details. Launch the QMetry agent. Please do not launch the agent as Windows-Service to avoid running GUI-Tests within the service-session. If you launch the agent as service you should run the QF‑Test tests via the QF‑Test daemon, which shouldn't run in a service session then. After setting up the agent and launcher, you need to plan the test execution. QMetry supports several ways of integrating QF‑Test test cases. You can find all supported integrations in QMetry's integration guide document. Please perform following steps for a simple integration: In the Testmanagement view change to 'Test Cases' and plan the test cases there. At the individual test case you have to set the value 'Test Script Name' to the path of the required QF‑Test test suite holding the actual implementation of the test case. The name of the test case must be exactly the same as the specified value for the QF‑Test ID attribute in QF‑Test. Add the test case to an executable test suite in the 'Test Suites' view. Now you are ready to run the test cases: Open the 'Test Suites' view and select the required test suite for execution. Select the 'Execute TestSuite' tab. Run or schedule a test run via assigning an agent to the 'Automation' column. The next time when the local QMetry agent is polling the QMetry server it will get the necessary information to run the test case. Once the test run terminates you will find the run log of QF‑Test and its HTML report attached to the 'Execution History' of the executed test suite. The state of the test case will also be updated accordingly. The following figure shows the 'Execution History' tab in 'Test Suites' holding the run log:","hash":"usec_qmetryIntro","h1":"Introduction"},"737":{"id":737,"content":"The following figure shows the 'Execution History' tab in 'Test Suites' holding the run log: Figure 20.14: QF‑Test run log in QMetry You will find a more detailed description of how to setup QMetry in the manual of QMetry and in QMetry's integration guide document.","hash":"figure_20.14","h1":"Introduction"},"738":{"id":738,"content":"Sample Configuration It's recommended to set following values in the configuration file QMetryConfig.properties: Set the value of generic.adapter.success.code to 0,1. Set qftest.additional.arguments to -test ${QMTestCaseName} in case of local test execution. In case of using QF‑Test's daemon set qftest.additional.arguments to -test ${QMTestCaseName} -calldaemon -daemonhost <testsystem> -daemonport <daemonport> . As already mentioned in the previous section, you need to use the same name for the test case within QMetry and for the value of the QF‑Test ID attribute within QF‑Test. Further ways for integrating QMetry and QF‑Test can be found in the integration guide document provided by QMetry.","hash":"usec_qmetryDemoSettings","h1":"Sample Configuration"},"739":{"id":739,"content":"Mobile Manual","hash":"","h0":"Klaros | QF‑Test Manual"},"740":{"id":740,"content":"Mobile Manual","hash":"home-link","h0":"Klaros | QF‑Test Manual"},"741":{"id":741,"content":"Klaros","hash":"usec_klaros","h0":"Klaros"},"742":{"id":742,"content":"Introduction Klaros is a test management tool developed and supported by verit Informationssysteme GmbH, Kaiserslautern, Germany. Klaros is available in two kinds of editions, a free community edition and an enterprise edition with an extended set of functionality, individual configuration options and full customer support. The current integration of QF‑Test with Klaros comprises: Import of QF‑Test results into Klaros.","hash":"usec_klarosIntro","h1":"Introduction"},"743":{"id":743,"content":"Importing QF‑Test results into Klaros After creating the XML report file as described in \"Reports and test documentation\", you can upload the results to Klaros. An example for a QF‑Test import URL may look like this, where the result file is contained in the HTTP request body. http://localhost:18080/klaros-web/seam/resource/rest/importer?config=P00001&env=ENV00001&sut=SUT00001&type=qftest&time=05.02.2013_12:00&username=me&password=secret Example 20.1: Importing test results into Klaros The curl command line tool can be used on Linux or Windows/Cygwin to trigger an import in a single command line. curl -v -H \"Content-Type: text/xml\" -T \"my_qftest_report.xml\" \\ \"http://localhost:18080/klaros-web/seam/resource/rest/importer?config=P00001&env=ENV00001&sut=SUT00001&type=qftest&time=05.02.2013_12:00&user=me&password=secret\" Example 20.2: Using curl command to import test results into Klaros Further information can be found within the Klaros online manual at https://www.klaros-testmanagement.com/files/doc/html/User-Manual.Import-Export.html.","hash":"usec_klarosImport","h1":"Importing QF‑Test results into Klaros"},"744":{"id":744,"content":"Mobile Manual","hash":"","h0":"TestLink | QF‑Test Manual"},"745":{"id":745,"content":"Mobile Manual","hash":"home-link","h0":"TestLink | QF‑Test Manual"},"746":{"id":746,"content":"TestLink","hash":"usec_testlink","h0":"TestLink"},"747":{"id":747,"content":"Introduction The current integration of QF‑Test with the open-source tool TestLink consists of two parts: Generating template test suites for QF‑Test from the planned test cases of TestLink. Importing QF‑Test results into TestLink. If you use TestLink 1.9.4 or newer you can use the TestLink API for interacting with TestLink. The TestLink API requires a valid development key. Therefore open TestLink and go to 'My Settings'. In the settings you can generate a development key by pressing 'Generate key' under the 'API interface' section. For TestLink 1.9.3 or older versions the integration mechanism accesses the database of TestLink directly. This approach requires a JDBC database driver to use the provided scripts. You can download those drivers from the web page of their providers. Exporting the planned test cases including its test steps from TestLink to QF‑Test supports the test-creator to implement the test cases exactly as planned. Importing the test results into TestLink provides a better overview over all executed manual and automated tests-cases in one tool. Test results can also be uploaded to TestLink without exporting them before. Therefore you have to take care, that the ID of the test case from TestLink is part of the test case's name in QF‑Test. The name has to be called like this: <TestLink-ID>: Name of the test case.","hash":"usec_testlinkIntro","h1":"Introduction"},"748":{"id":748,"content":"Generating template test suites for QF‑Test from test cases QF‑Test offers the capability to generate template test suites following the same structure as the planned tests in TestLink to guarantee a synchronized structure of automated tests and test planning. In the QF‑Test file you can find one Test case node per test case and one Test set node per suite from TestLink. If you have specified the fields \"Steps\" and \"Expected Results\" of a test case, the generating-script will also create an empty Test step for each test step in the according test case. The expected result will be shown in the Comment attribute of the Test step node. Now the template test suite has to be filled by the test automation engineer with the according steps by adding QF‑Test steps to the generated Test step nodes. In case you use TestLink 1.9.4 or newer you need to perform following steps: Take care that test automation is enabled in TestLink. Therefore set the respective enable_test_automation key to ENABLED in the configuration file config.inc.php. Copy the folder qftest-10.0.2-mobile/ext/testlink/api to a project-specific location. Open the launcher script you want to use with a text editor. The launcher scripts are exportTests.bat for Windows and exportTests.sh for Linux. Adapt the paths of the variables JAVA, QFTDIR and TESTLINKINTEGRATOR. Open the file TestLinkUserSpecifics.py with a text editor. Adjust the variables serverurl and devkey. If you want to export custom fields from TestLink, also adjust the variable custom_fields. Run the adapted export script, like shown below. exportTests.bat --testproject projectname --targetsuite /path/to/testsuite.qft Example 20.3: Sample call of exporting test cases from 1.9.4 If you use TestLink 1.9.3 or older, please perform those steps: Copy the folder qftest-10.0.2-mobile/ext/testlink/export to a project-specific location. Open the launcher script you want to use with a text editor. The launcher scripts are exportTestLinkToQFT.bat for Windows and exportTestLinkToQFT.sh for Linux. Adapt the paths of the variables JAVA, QFTDIR and TESTLINKINTEGRATOR. Open the file TestLinkDBIntegrator.py with a text editor. Adjust the variables dbdriver, conncetionstr, dbuser and dbpass according to your database connection. If you want to export custom fields from TestLink, also adjust the variable custom_fields. Run the adapted export script, like shown below. exportTestLinkToQFT.bat --testproject projectname --targetsuite /path/to/testsuite.qft Example 20.4: Sample call of exporting test cases till 1.9.3","hash":"usec_testlinkExport","h1":"Generating template test suites for QF‑Test from test cases"},"749":{"id":749,"content":"Execution of test cases Executing the QF‑Test tests can be performed as usual. But you should create a XML-report at the end of the test run, because the import mechanism is using this report. Therefore you have to use the '-report.xml' parameter during test execution. If you create the reports via the GUI, you have to check the checkbox 'Create XML report'. In case you did not export test cases from TestLink the ID of the test case from TestLink has to be part of the test case's name in QF‑Test. The name has to be called like this: <TestLink-ID>: Name of the test case. qftest -batch -report.xml reportFolder testsuite.qft Example 20.5: Sample execution to create a XML report","hash":"usec_testlinkExec","h1":"Execution of test cases"},"750":{"id":750,"content":"Importing QF‑Test results into TestLink After creating the XML report file, you can upload the results to TestLink. Per default the import mechanism creates a new build for every test run. The build number of TestLink will be created by the run-ID of the QF‑Test report. You can change the run-ID, by setting the parameter '-runid' when launching the tests with QF‑Test. But you can also set the '-build' parameter during import to specify a custom build name. In case you use TestLink 1.9.4 or newer you need to perform following steps: Take care that test automation is enabled in TestLink. Therefore set the respective enable_test_automation key to ENABLED in the configuration file config.inc.php. Copy the folder qftest-10.0.2-mobile/ext/testlink/api to a project-specific location. (If you have copied them already for exporting you can use the same files.) Open the launcher script you want to use with a text editor. The launcher scripts are importResults.bat for Windows and importResults.sh for Linux. Adapt the paths of the variables JAVA, QFTDIR and TESTLINKINTEGRATOR. Open the file TestLinkUserSpecifics.py with a text editor. Adjust the variables serverurl and devkey. (If you have adapted them already for exporting you can use the same values.) Run the adapted import script, like shown below. importResults.bat --testproject projectname --resultfile qftestReport.xml --testplan testplanname --platform system1 Example 20.6: Importing test results into TestLink from 1.9.4 If you want to overwrite the build name you can use the '-build' parameter.> importResults.bat --testproject projectname --resultfile qftestReport.xml --testplan testplanname --platform system1 --build myBuild Example 20.7: Importing test results into TestLink from 1.9.4 with custom build If you use TestLink 1.9.3 or an older version, please perform following steps: Copy the folder qftest-10.0.2-mobile/ext/testlink/import to a project-specific location. Open the launcher script you want to use with a text editor. The launcher scripts are importToTestLink.bat for Windows and importToTestLink.sh for Linux. Adapt the paths of the variables JAVA, QFTDIR and TESTLINKINTEGRATOR. Open the file ReportParser.py with a text editor. Adjust the variables dbdriver, conncetionstr, dbuser and dbpass according to your database connection. If you want to export custom fields from TestLink, also adjust the variable custom_fields. Run the adapted import script, like shown below. importToTestLink.bat --testproject projectname --resultfile qftestReport.xml --testplan testplanname --tester tester Example 20.8: Importing test results into TestLink till 1.9.3","hash":"usec_testlinkImport","h1":"Importing QF‑Test results into TestLink"},"751":{"id":751,"content":"Mobile Manual","hash":"","h0":"Integration with Development Tools | QF‑Test Manual"},"752":{"id":752,"content":"Mobile Manual","hash":"home-link","h0":"Integration with Development Tools | QF‑Test Manual"},"753":{"id":753,"content":"Integration with Development Tools Automating GUI testing is just one part of the development cycle. Requirements like automating the compilation or build process, running tests, creating documentation or providing a deliverable package led on to a variety of different development tools like IDEs (e.g. Eclipse) or build tools (e.g. make, ant, maven) or so called continuous integration systems (like Jenkins, Cruise Control, Continuum). In general, by use of QF‑Test's command line interface as documented in \"Test execution\" and \"Command line arguments and exit codes\" a straight forward integration with those tools should be possible. GUI tests require an active user session. Chapter Hints on setting up test systems contains useful tips and tricks to set-up your test systems. In FAQ 14 you can find technical details. The following sections contain examples for integrations with a some of the tools mentioned above.","hash":"usec_buildtools","h1":"Integration with Development Tools"},"754":{"id":754,"content":"Mobile Manual","hash":"","h0":"Eclipse | QF‑Test Manual"},"755":{"id":755,"content":"Mobile Manual","hash":"home-link","h0":"Eclipse | QF‑Test Manual"},"756":{"id":756,"content":"Eclipse Eclipse (http://eclipse.org) is an Open Source software developer tool for java applications. QF‑Test offers an Eclipse plugin enabling you to start an application directly from Eclipse and run tests on it - anything from whole test sets, single test cases or even just a mouse click. Video instructions: 'The QF‑Test Eclipse Plugin'","hash":"usec_eclipseplugin","h0":"Eclipse"},"757":{"id":757,"content":"Installation For the installation please copy the Eclipse plugin file de.qfs.qftest_10.0.2-mobile.jar from the subdirectory qftest-10.0.2-mobile/misc/ of the QF‑Test installation directory to the subdirectory 'dropins' of the Eclipse installation directory. Then (re-)start Eclipse and the plugin will be available.","hash":"user_eclipseplugin_installation","h1":"Installation"},"758":{"id":758,"content":"Configuration of the test nodes Open the Eclipse menu »Run«-»Run Configurations«. Enter the QF‑Test nodes to be started in the tab 'Main' and if necessary enter parameters in the tabs 'Settings' and 'Initial Settings'. (The tabs 'Environment' and 'Common' are standard Eclipse tabs that are not needed for the configuration of the QF‑Test Plugin.) Then save the configuration by pressing 'Apply'. To start a test run press 'Run'.","hash":"user_eclipseplugin_configuration","h1":"Configuration of the test nodes"},"759":{"id":759,"content":"Tab 'Main'","hash":"user_eclipseplugin_configuration_main","h1":"Tab 'Main'"},"760":{"id":760,"content":"Figure 21.1: Eclipse plugin configuration - tab 'Main' Enter the fully qualified path to the QF‑Test executable 'qftest.exe' in the field QF‑Test executable, e.g. C:\\Program Files (x86)\\qfs\\qftest\\qftest-4.1.0\\bin\\qftest.exe. 'Run configuration to be used as SUT' is an optional entry. You may enter an existing Eclipse 'Run Configuration' for starting the application to be tested. At the start of the application the QF‑Test plugin sets up the connection to QF‑Test so you can replay or record tests on the application. Use this option when you specify QF‑Test nodes in the 'Startup nodes' section which do not start the application themselves. Please be aware that the run configuration to be used as SUT will be started and then right away the listed 'startup nodes' will be executed. So, to make sure the SUT is started when executing the 'startup nodes' the first action of the first 'startup nodes' should be to wait for the SUT. This can be done either by inserting a Wait for client to connect node at the beginning of the first 'startup node' or by adding a first 'startup node' just calling a Wait for client to connect node in QF‑Test. Enter all QF‑Test nodes to be executed in the table 'Startup nodes'. You need to specify the QF‑Test ID of the node as well as its test suite. Please be aware that the QF‑Test ID is a separate attribute of the node and not its name. The QF‑Test ID attribute is empty by default and has to be set before use.","hash":"fig_eclipseplugin_config_main","h4":"Figure 21.1: Eclipse plugin configuration - tab 'Main'"},"761":{"id":761,"content":"Tab 'Settings'","hash":"user_eclipseplugin_configuration_settings","h1":"Tab 'Settings'"},"762":{"id":762,"content":"Figure 21.2: Eclipse plugin configuration - Tab 'Settings' Variables specified in this tab will be read each time before executing the run configuration. 'Path to run log folder' specifies the directory where to save the run logs of the test runs of the run configuration. It is optional. When empty the run logs are saved as configured in QF‑Test itself. If required enter variables to be passed to QF‑Test on command line level in the table 'Variables'. This will overwrite default values of the variable.","hash":"fig_eclipseplugin_config_settings","h4":"Figure 21.2: Eclipse plugin configuration - Tab 'Settings'"},"763":{"id":763,"content":"Tab 'Initial Settings'","hash":"user_eclipseplugin_configuration_initalsettings","h1":"Tab 'Initial Settings'"},"764":{"id":764,"content":"Figure 21.3: Eclipse plugin configuration - Tab 'Initial Settings' The values set in this tab are optional and only read in once before the start of QF‑Test When changing them you need to restart QF‑Test before they take effect. Path to license file: Path of the license file to be used. Path to qftest system config file: Path of the qftest.cfg file to be used. Path to qftest user config file: Path of the user configuration file to be used.","hash":"fig_eclipseplugin_config_initialsettings","h4":"Figure 21.3: Eclipse plugin configuration - Tab 'Initial Settings'"},"765":{"id":765,"content":"Mobile Manual","hash":"","h0":"Ant | QF‑Test Manual"},"766":{"id":766,"content":"Mobile Manual","hash":"home-link","h0":"Ant | QF‑Test Manual"},"767":{"id":767,"content":"Ant People who are using Apache Ant (http://ant.apache.org) as build system may easily integrate QF‑Test in their build file: <project name=\"QF‑Test\" default=\"runtest\"> <property name=\"qftest\" location=\"c:\\Program Files\\qfs\\qftest\\qftest-10.0.2-mobile\\bin\\qftest.exe\" /> <property name=\"logdir\" value=\"c:\\mylogs\" /> <target name=\"runtest\" description=\"Run a test in batchmode\"> <echo message=\"Running ${suite} ...\" /> <exec executable=\"${qftest}\" failonerror=\"false\" resultproperty=\"returncode\"> <arg value=\"-batch\" /> <arg value=\"-compact\" /> <arg value=\"-runlog\" /> <arg value=\"${logdir}\\+b\" /> <arg value=\"${suite}\" /> </exec> <condition property=\"result\" value=\"Test terminated successfully.\"> <equals arg1=\"${returncode}\" arg2=\"0\" /> </condition> <condition property=\"result\" value=\"Test terminated with warnings.\"> <equals arg1=\"${returncode}\" arg2=\"1\" /> </condition> <condition property=\"result\" value=\"Test terminated with errors.\"> <equals arg1=\"${returncode}\" arg2=\"2\" /> </condition> <condition property=\"result\" value=\"Test terminated with exceptions.\"> <equals arg1=\"${returncode}\" arg2=\"3\" /> </condition> <echo message=\"${result}\" /> </target> </project> Example 21.1: Ant build file build.xml to execute a test suite The above example assumes the test suite to be defined as property when running ant: ant -Dsuite=\"...\\qftest-10.0.2-mobile\\demo\\carconfigSwing\\carconfigSwing_en.qft\".","hash":"usec_ant","h0":"Ant"},"768":{"id":768,"content":"Mobile Manual","hash":"","h0":"Maven | QF‑Test Manual"},"769":{"id":769,"content":"Mobile Manual","hash":"home-link","h0":"Maven | QF‑Test Manual"},"770":{"id":770,"content":"Maven People who are using Apache Maven (http://maven.apache.org) as build system may easily integrate QF‑Test in their build. This can be achieved by using the antrun plugin of Maven. A demo pom.xml file, where QF‑Tests tests are executed in the test phase could look like this: <project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\"> <modelVersion>4.0.0</modelVersion> <artifactId>testant</artifactId> <packaging>jar</packaging> <name>testant</name> <groupId>de.qfs</groupId> <version>1</version> <properties> <qf.exe>\"C:\\Program Files\\qfs\\qftest\\qftest-10.0.2-mobile\\bin\\qftest.exe\"</qf.exe> <qf.reportfolder>qftest</qf.reportfolder> <qf.log>logFile.qrz</qf.log> <qf.suite>\"c:\\path\\to\\testsuite.qft\"</qf.suite> </properties> <build> <plugins> <plugin> <groupId>org.apache.maven.plugins</groupId> <artifactId>maven-antrun-plugin</artifactId> <executions> <execution> <phase>test</phase> <configuration> <tasks> <exec executable=\"${qf.exe}\"> <arg value=\"-batch\"/> <arg value=\"-report\"/> <arg value=\"${qf.reportfolder}\"/> <arg value=\"-runlog\"/> <arg value=\"${qf.log}\"/> <arg value=\"${qf.suite}\"/> </exec> </tasks> </configuration> <goals> <goal>run</goal> </goals> </execution> </executions> </plugin> </plugins> </build> </project> Example 21.2: Maven build file pom.xml to execute a test suite In your project it might become required to run the tests during another build phase, than the configured test phase in the example. In this case you have to configure the plugin accordingly, like described in the Maven documentation.","hash":"usec_maven","h0":"Maven"},"771":{"id":771,"content":"Mobile Manual","hash":"","h0":"Jenkins | QF‑Test Manual"},"772":{"id":772,"content":"Mobile Manual","hash":"home-link","h0":"Jenkins | QF‑Test Manual"},"773":{"id":773,"content":"Jenkins The video 'QF‑Test Jenkins Plugin' shows installation and configuration of the plugin. Jenkins (jenkins-ci.org) is a continuous integration build tool. It is used to control and monitor the build process within a software project. One important step in this build process is automated testing. There are number of benefits to be gained when integrating QF‑Test with Jenkins: In case Jenkins is already used for the continuous integration process, integration of automated GUI tests can be easily achieved. Easy-to-use administration of scheduled test runs and notification of results via email or RSS. Jenkins' web-based UI provides good overview and control of test results. By use of the HTML Publisher Plugin it is possible to embed QF‑Test's HTML reports directly into the Jenkins GUI. Results generated during the test run such as run logs and reports can be archived automatically. Therefore maintaining an own directory structure is not needed anymore.","hash":"usec_jenkins","h0":"Jenkins"},"774":{"id":774,"content":"Install and start Jenkins For GUI tests, Jenkins must not be configured to run as a service but within a real user session. On Windows the .msi installer unfortunately directly installs Jenkins as service without any further inquiry. Please beware of it therefore and ensure Jenkins is started as real user process as described below. To install Jenkins download the war Archive (which can be found here) and start it via java -jar jenkins.war. As soon as Jenkins is started its web interface can be accessed via http://localhost:8080. It should look like the following:","hash":"usec_jenkinsInstall","h1":"Install and start Jenkins"},"775":{"id":775,"content":"Figure 21.4: Jenkins after start-up.","hash":"figure_21.4","h4":"Figure 21.4: Jenkins after start-up."},"776":{"id":776,"content":"Requirements for GUI tests GUI testing requires an unlocked, active desktop. That is the only way to ensure that the SUT behaves the same as if a normal user interacts with it. Chapter Hints on setting up test systems contains useful tips and tricks to set up the Jenkins process. Jenkins allows execution of tasks on remote machines. This is of course also relevant for GUI testing. Due to its nature GUI tests are typically not intended to run on the central build server. In addition, tests might need to be executed for different environments, operating systems and SUT versions. On a remote machine, a Jenkins agent needs to be launched in order to connect to the Jenkins server and wait for jobs to be processed. As described in the Jenkins documentation, there are several options to launch this agent, but for the GUI tests to properly work the only possible launch method is to use Java Web Start. For GUI tests it is vital to have an active, unlocked user session. Therefore it is not possible to start the agent via a windows service but a real (test) user must be logged in (e.g. via auto login) using Windows Autostart to launch the Jenkins agent. Furthermore screen locking needs to be disabled. Please see also FAQ 14 for more technical background details.","hash":"jenkinsGuiTests","h1":"Requirements for GUI tests"},"777":{"id":777,"content":"Install QF‑Test Plugin The QF‑Test Plugin enables QF‑Test to interact with Jenkins. To install the plugin open the Jenkins dashboard and navigate via \"Manage Jenkins\" to \"Manage Plugins\". Select the QF‑Test Plugin from the \"Available\" tab. When installing the QF‑Test Plugin the JUNIT and HTML-Publisher Plugin will also be downloaded automatically, in case they were not already installed. Finally restart Jenkins to complete the installation. Now the QF‑Test Plugin will show up under the Installed tab, as shown in Figure 20.2. Jenkins will automatically use the latest installed version of QF‑Test. In case you want to use a different version, you can provide its path under the QF‑Test section in the Jenkins configuration (Manage Jenkins -> Configure System).","hash":"usec_jenkinsInstallPlugin","h1":"Install QF‑Test Plugin"},"778":{"id":778,"content":"Figure 21.5: Install QF‑Test Plugin. As soon as the QF‑Test Plugin has been installed successfully, test execution with QF‑Test can be included in the build jobs. A detailed explanation about the configuration of jobs can be found in the QF‑Test Plugin documentation at https://www.qftest.com/en/jenkins.","hash":"figure_21.5","h4":"Figure 21.5: Install QF‑Test Plugin."},"779":{"id":779,"content":"Mobile Manual","hash":"","h0":"JUnit 5 Jupiter | QF‑Test Manual"},"780":{"id":780,"content":"Mobile Manual","hash":"home-link","h0":"JUnit 5 Jupiter | QF‑Test Manual"},"781":{"id":781,"content":"JUnit 5 Jupiter In \"Unit Tests\" we described how to integrate JUnit tests into a QF‑Test test suite, which creates a common run log combining the results from the unit tests with those from the other QF‑Test test cases. With the help of the Java annotation @QFTest.Test it is possible to go the opposite way and include QF‑Test test suites into a Junit 5 test case, integrating the results from the QF‑Test test run into the JUnit test results. This simplifies the inclusion of QF‑Test test runs into Maven or Gradle builds, as well as software development environments like Eclipse or IntelliJ IDEA. To do so, extend the test class, which should include the execution of one or several QF‑Test test suites, with a method annotated with de.qfs.apps.qftest.junit5.QFTest.Test. The method must return an object of the type de.qfs.apps.qftest.junit5.QFTest, which is created using the static method QFTest.runSuite or QFTest.runSuites. If required, this object can be further configured e.g. to include QF‑Test options or variables. The provided methods are documented in the file doc/javadoc/qftest-junit5.zip inside the QF‑Test installation. import de.qfs.apps.qftest.junit5.QFTest; import java.io.File; public class QFTestDemoTest { @QFTest.Test QFTest demoTest() throws Exception { // Get location of demo testsuite final File qftestVerdir = QFTest.getVersionDir(); final File demo = new File(qftestVerdir, \"demo/carconfigSwing/carconfigSwing_en.qft\"); return QFTest.runSuite(demo) .withVariable(\"buggyMode\",\"True\") .withArgument(\"-verbose\") .withReportOpen(); } } Example 21.3: Example of a JUnit 5 test case including a QF‑Test test suite. To execute the test it is required to include the following libraries from the QF‑Test installation into the classpath: lib/truezip.jar qflib/qflib.jar qflib/qfshared.jar qflib/qftest.jar If the project is based on Gradle build, you can apply the de.qfs.qftest gradle plugin to automatically resolve those dependencies. For more information, refer to the plugin homepage. plugins { id 'java' id 'de.qfs.qftest' version '1.1.0' } repositories { mavenCentral() } test { useJUnitPlatform() } Example 21.4: Excerpt from a gradle.build file, which calls QF‑Test during the JUnit test run.","hash":"usec_junit5","h0":"JUnit 5 Jupiter"},"782":{"id":782,"content":"Mobile Manual","hash":"","h0":"TeamCity CI | QF‑Test Manual"},"783":{"id":783,"content":"Mobile Manual","hash":"home-link","h0":"TeamCity CI | QF‑Test Manual"},"784":{"id":784,"content":"TeamCity CI QF‑Test can easily be integrated with TeamCity CI, so that tests are automatically executed by TeamCity CI and test results, run logs and HTML reports can be inspected right through the TeamCity UI. You can find step-by-step instructions for how to set this us in our blog post Integrating QF‑Test with TeamCity in three easy steps .","hash":"usec_teamcityci","h0":"TeamCity CI"},"785":{"id":785,"content":"Mobile Manual","hash":"","h0":"Integration with Robot Framework | QF‑Test Manual"},"786":{"id":786,"content":"Mobile Manual","hash":"home-link","h0":"Integration with Robot Framework | QF‑Test Manual"},"787":{"id":787,"content":"Integration with Robot Framework","hash":"usec_robotframework","h0":"Integration with Robot Framework"},"788":{"id":788,"content":"Introduction Robot Framework is a very popular framework for test automation and robotic process automation (RPA). Based on Python, it comes with a plethora of ready-to-use keyword libraries for many scenarios. Most of the time the decision will be to use either QF‑Test or Robot Framework, but there are situations where an integration makes perfect sense: If you have an existing infrastructure based on Robot Framework or testers with in-depth Robot Framework knowledge combined with the need for QF‑Test's unique abilities in UI automation.","hash":"usec_rf_intro","h1":"Introduction"},"789":{"id":789,"content":"Prerequisites and installation You need a current version of Python 3 installed. If not already available, Robot Framework can be installed via pip install robotframework. Robot Framework version 4 or higher is required. The integration requires a bridge between Python and Java. JPype serves that role very well. It needs to be installed via pip install JPype1. QF‑Test comes with a Robot Framework library called qftest that Robot Framework needs to know about. It is located in the directory .../qftest-10.0.2-mobile/ext/robotframework. You can either add that directory to your PYTHONPATH environment variable or create a file called qftest_robot.pth in the site-packages of your Python 3 installation - i.e .../python3/Lib/site-packages/qftest_robot.pth - with just one line, the full path to that directory.","hash":"usec_rf_installation","h1":"Prerequisites and installation"},"790":{"id":790,"content":"Getting started Robot Framework talks to QF‑Test via its daemon mode, so you need to start QF‑Test with daemon mode enabled as described in \"Daemon mode\". For test development it is best to use interactive daemon mode in which you can activate the QF‑Test debugger and step through your keywords at QF‑Test level in addition to using the debugger of whichever IDE you run your Robot Framework scripts from. So please start QF‑Test from the command line with qftest -daemon -daemonport 5454 -keystore= The port 5454 is just an example, choose whatever you like, but make sure you use the same in your robot file as described below. As explained in the documentation for the -keystore <keystore file> command line argument, -keystore= tells the daemon to use unsecured communication, which speeds up communication setup and should be OK for internal use on your local machine. The third argument to the qftest library shown below should be \"false\" if the QF‑Test daemon is started with -keystore= and \"true\" otherwise. Before creating your own Robot Framework tests with QF‑Test you should try to run the demo robot script provided with QF‑Test to ensure that your setup is complete. It is provided in the directory .../qftest-10.0.2-mobile/demo/robotframework. Please change to that location and run robot carconfigSwing_en.robot The script should launch the Swing Carconfig demo application and perform a few clicks and checks. If you run it several times you'll see another great advantage of this integration: Becaus the application is started via the QF‑Test daemon its lifetime is no longer dependent on that of the Python process running the Robot Framework script. Subsequent scripts can make use of the already running application and rely on QF‑Test dependencies (\"Dependencies\") to ensure a well-defined state. SmartIDs (see \"SmartID\") are ideal for specifying target components in Robot Framework keyword calls. Unfortunately the leading '#' of SmartIDs introduces a comment in Robot Framework so that it would always need to be escaped which significantly reduces readability. There is an option in QF‑Test that makes it possible to treat every Comment reference automatically as a SmartID if no Component node exist with that ID. Because the option is only for use with Robot Framework it can only be set at script level as shown in the procedure \"use smartids without marker\" in the robot.qft demo test suite: rc.setOption(Options.OPT_SMARTID_WITHOUT_MARKER, true)","hash":"usec_rf_start","h1":"Getting started"},"791":{"id":791,"content":"Using the library As you can see in the file resource.txt in the Robot Framework demo directory, the qftest library should be initialized as follows: Library qftest localhost 5454 false ${SUITE} The arguments are optional with the first three defining the host and port of the QF‑Test daemon to contact and whether to use a keystore or not. The fourth one defaults to robot.qft and specifies the primary test suite from which to determine the keywords that Robot Framework can use.","hash":"usec_rf_library","h1":"Using the library"},"792":{"id":792,"content":"Creating your own keywords The keywords for Robot Framework are determined by parsing the primary test suite specified as argument in the Library definition of the robot script as well as all test suites included directly or indirectly from that suite. The @keyword doctag is used to designate a Procedure or an entire Package hierarchy as keywords. Details are explained in \"Doctags for Robot Framework\".","hash":"usec_rf_keywords","h1":"Creating your own keywords"},"793":{"id":793,"content":"Mobile Manual","hash":"","h0":"Keyword-driven testing with QF‑Test | QF‑Test Manual"},"794":{"id":794,"content":"Mobile Manual","hash":"home-link","h0":"Keyword-driven testing with QF‑Test | QF‑Test Manual"},"795":{"id":795,"content":"Keyword-driven testing with QF‑Test","hash":"usec_keyworddriven","h1":"Keyword-driven testing with QF‑Test"},"796":{"id":796,"content":"Mobile Manual","hash":"","h0":"Introduction | QF‑Test Manual"},"797":{"id":797,"content":"Mobile Manual","hash":"home-link","h0":"Introduction | QF‑Test Manual"},"798":{"id":798,"content":"Introduction The concept of keyword-driven testing allows business analysts and testers to describe test cases without any deep QF‑Test knowledge. Those test cases can either be described in a meta-language or directly in a testmanagement system. QF‑Test will then read and execute those test cases. The implementation of the underlying test steps inside QF‑Test needs to be done by engineers having QF‑Test knowledge. Business testers and QF‑Test engineers are free in defining the way how to describe test steps. They can define a wide range of keywords like simple action-related keywords (e.g. click a button) or more complex business-related keywords (e.g. create an object inside the SUT). Combining test steps into a test case could be achieved by a strict table-oriented approach like clickButton=OK or formulating the test steps in continuous text like \"Close the dialog via click on ok\". The following examples illustrate the most popular variants of defining test cases in a keyword-driven manner. The demo test case will create a vehicle in the CarConfigurator demo application of QF‑Test. Option 1: Business-related test steps (see \"Business-related Procedures\"). You find a sample at qftest-10.0.2-mobile/demo/keywords/simple_business.","hash":"used_keywords_intro","h0":"Introduction"},"799":{"id":799,"content":"Test step Launch SUT, if necessary Open vehicles dialog via Options -> Vehicles Enter data (name and price) Press new in order to create the vehicle Press OK in order to close the dialog Check creation of vehicle in table Table 23.1: Test case using business-related keywords Option 2: Atomic test steps (see \"Atomic component-oriented procedures\"). You find a sample at qftest-10.0.2-mobile/demo/keywords/simple_atomic.","hash":"table_23.1","h0":"Introduction"},"800":{"id":800,"content":"Test step Launch SUT, if necessary Select menu 'Options' Select menu 'Vehicles...' Fill text-field 'Name' Fill text-field 'Price' Press button 'New' in order to create the vehicle Press button 'OK' in order to close the dialog Check table, whether new created vehicle appears Table 23.2: Test case using atomic keywords Option 3: Behavior-Driven Testing (BDT) from a technical perspective (see \"Behavior-Driven Testing (BDT) from technical perspective\"). You find a sample at qftest-10.0.2-mobile/demo/keywords/behaviordriven.","hash":"table_23.2","h0":"Introduction"},"801":{"id":801,"content":"Test step Given SUT is running Given vehicles dialog is opened When vehicle name is set to <name> And vehicle price is set to <price> And button new clicked And button ok clicked Then row with <name> and <formatted-price> appears in table And column model has value <name> And column price has value <formatted-price> Table 23.3: Test case with Behavior-Driven Testing from a technical perspective Option 4: Behavior-Driven Testing (BDT) with business keywords (see \"Behavior-Driven Testing (BDT) from business perspective\"). You find a sample at qftest-10.0.2-mobile/demo/keywords/behaviordriven_business.","hash":"table_23.3","h0":"Introduction"},"802":{"id":802,"content":"Test step Given application is ready to enter vehicle data When vehicle created with <model> and <price> Then <model> with <formatted price> appears in table Table 23.4: Test case with Behavior-Driven Testing from a business perspective In the subsequent sections you will find a more detailed description of those variants of keyword-driven testing with QF‑Test. The concept of Behavior-driven testing (BDT) is described in \"Behavior-driven testing (BDT)\". From a perspective of QF‑Test BDT is just a special variation of keyword-driven testing. All samples use the CarConfigurator of QF‑Test which is also provided by the installation. You can find all samples in the folder qftest-10.0.2-mobile/demo/keywords/. In order to show the test planning aspects we provide Excel files containing the required test steps. Of course you can also go ahead and use your testmanagement tool to plan test steps. We are using Excel files as Excel is a very common piece of software and reading Excel file is quite simple in QF‑Test. The section keywords with dynamic components (see \"Keyword-driven testing using dynamic or generic components\") describes how to use QF‑Test just as test-executor without really recording steps within QF‑Test. You need to interact with QF‑Test only in rare cases when applying this scenario. Please take care to copy all test suites to a project-related folder first and modify them there.","hash":"table_23.4","h0":"Introduction"},"803":{"id":803,"content":"Mobile Manual","hash":"","h0":"Simple Keyword-driven testing with QF‑Test | QF‑Test Manual"},"804":{"id":804,"content":"Mobile Manual","hash":"home-link","h0":"Simple Keyword-driven testing with QF‑Test | QF‑Test Manual"},"805":{"id":805,"content":"Simple Keyword-driven testing with QF‑Test The simplest way of using keywords is to use existing procedures. Procedures can be designed as business-related procedures or as atomic component-oriented procedures. Business-related procedures perform real workflow in the application, e.g. creating a new vehicle. Atomic component-oriented procedures perform very basic steps like click the ok-button.","hash":"usec_keywords_simple","h1":"Simple Keyword-driven testing with QF‑Test"},"806":{"id":806,"content":"Mobile Manual","hash":"","h0":"Business-related Procedures | QF‑Test Manual"},"807":{"id":807,"content":"Mobile Manual","hash":"home-link","h0":"Business-related Procedures | QF‑Test Manual"},"808":{"id":808,"content":"Business-related Procedures As stated in the previous section business-related procedures represent a real business workflow in your application. You can find a sample at qftest-10.0.2-mobile/demo/keywords/simple_business/ SimpleKeywords.qft. The respective test-plan can be found at qftest-10.0.2-mobile/demo/keywords/simple_business/ simple_keywords.xlsx. Please take care to copy the demo folder to a project-related folder first and modify them there. The sample shows the \"Create vehicle\" test case of the QF‑Test CarConfigurator. It consists of following test steps: Launch SUT, if necessary Open vehicles dialog via Options -> Vehicles Enter data (name and price) Press new in order to create the vehicle Press OK in order to close the dialog Check creation of vehicle in table Let's take a look at the Excel file now:","hash":"usec_keywords_simple_business","h0":"Business-related Procedures"},"809":{"id":809,"content":"Figure 23.1: Excel file business-related keywords As QF‑Test can read excel files row by row, we have decided to go for that excel structure. Reading that file follows the data-driven concept (see \"Data driver\"). It's also possible to use another structure of the excel file, but then we lose the advantage of using the QF‑Test functionality directly without any scripts or if-conditions. In the first row we find the values teststep, value1 and value2. That row will be interpreted as variable names by QF‑Test. Every subsequent row will then contain respective values for those variables. This mechanism allows QF‑Test to walk through that Excel file in order to execute the planned test steps. Now let's take a look at the test suite SimpleKeywords.qft. The test suite looks like this:","hash":"fig_simplebusiness_excel","h4":"Figure 23.1: Excel file business-related keywords"},"810":{"id":810,"content":"Figure 23.2: Test suite business-related keywords","hash":"fig_simplebusiness","h4":"Figure 23.2: Test suite business-related keywords"},"811":{"id":811,"content":"Node Purpose Test set \"Scenario\" Represents the container node for the test execution. This node could be omitted theoretically. Dependency reference dependencies.sutStarted The concept of dependencies allows QF‑Test to manage the starting and stopping process of your application in an intelligent way. Dependencies can contain a strategy in case of any unexpected behavior during test run. See \"Dependencies\" for details. Test case \"Create vehicle\" This node represents the implemented test case. Teststep \"Walk through test steps\" This node is required to read the excel file with a data driver node. Data driver \"steps from excel\" A data driver reads the content of the Excel file row by row. Excel file \"steps from excel\" Points to the Excel file. Test step \"Generic test step\" This node will be filled with the current test step name from Excel during execution. This approach will create a readable report. Call procedure \"business.$(teststep)\" Here the respective procedure defined in Excel is called. The variable teststep will be filled with the planned data of Excel because of the data driver mechanism. Table 23.5: Structure of SimpleKeywords.qft All required procedures are implemented in the package business. In order to allow a simple variable definition any steps in Excel use the variables value1 and value2. Every procedure maps those generic names to the specific parameters of the procedure itself.","hash":"table_23.5","h4":"Figure 23.2: Test suite business-related keywords"},"812":{"id":812,"content":"Figure 23.3: Procedure fillDialog This concept requires that any used keyword has to be implemented in QF‑Test already before using it. If your steps require more than two parameters you need to extend the excel file with more columns. In addition you need one test case node in QF‑Test per test case in Excel. You can make this more flexible, see \"Scenario files\".","hash":"fig_simplebusiness_enter","h4":"Figure 23.3: Procedure fillDialog"},"813":{"id":813,"content":"Mobile Manual","hash":"","h0":"Atomic component-oriented procedures | QF‑Test Manual"},"814":{"id":814,"content":"Mobile Manual","hash":"home-link","h0":"Atomic component-oriented procedures | QF‑Test Manual"},"815":{"id":815,"content":"Atomic component-oriented procedures Besides the already known business-related procedures representing workflows you can describe every action individually. Applying this concept results in a very detailed description. You can find the sample test suite at qftest-10.0.2-mobile/demo/keywords/simple_atomic/ SimpleAtomicKeywords.qft. The respective test-plan can be found at qftest-10.0.2-mobile/demo/keywords/simple_atomic/ simple_atomic_keywords.xlsx. Please take care to copy the demo folder to a project-related folder first and modify them there. Let's take a look at the \"Create vehicle\" test case of the CarConfigurator again. The test case now consists of the following steps: Launch SUT, if necessary Select menu 'Options' Select menu 'Vehicles...' Fill text-field 'Name' Fill text-field 'Price' Press button 'New' in order to create the vehicle Press button 'OK' in order to close the dialog Check table, whether new created vehicle appears Similar to the business-related keywords you need to specify an Excel file containing the planned test steps and you need to create the procedures in QF‑Test as well. You can find the implemented procedures in the package atomic of the test suite qftest-10.0.2-mobile/demo/keywords/SimpleAtomicKeywords.qft. In case you choose this approach you can also think about using the automated procedure generation (see \"Automated Creation of Basic Procedures\"). The next section describes how to use dynamic procedures. This means that we will still write atomic component-oriented procedures in our test-plan, but there will be no need to create a procedure for each and every step or component. Instead of individual procedures we will create procedures like clickButton or setText. Those procedures will then be re-used every time.","hash":"usec_keywords_simple_atomic","h0":"Atomic component-oriented procedures"},"816":{"id":816,"content":"Mobile Manual","hash":"","h0":"Keyword-driven testing using dynamic or generic components | QF‑Test Manual"},"817":{"id":817,"content":"Mobile Manual","hash":"home-link","h0":"Keyword-driven testing using dynamic or generic components | QF‑Test Manual"},"818":{"id":818,"content":"Keyword-driven testing using dynamic or generic components The previous section shows how we can apply keyword-driven testing to call various procedures depending on the test-plan. But the graphical components and their recognition still stays in QF‑Test and the respective procedures. This approach requires that every procedure needs to be recorded or created before actually running the tests. However, it's also possible to specify the actual component information directly in the test-plan. This plan should then be interpreted by QF‑Test. You can find a sample test suite at qftest-10.0.2-mobile/demo/keywords/generic/Keywords_With_Generics.qft. The respective test-plan can be found at qftest-10.0.2-mobile/demo/keywords/generic/keywords-generic.xlsx. Please take care to copy the demo folder to a project-related folder first and modify them there. This approach depends on the concept of generic component recognition in QF‑Test. Generic component recognition allows the user to apply variables to the recorded component information or to move components out of hierarchical component structure. Please see \"Generic components\" for details. Let's go back to our sample test case. The test case \"Create vehicle\" looks like this. Launch SUT, if necessary Select menu 'Options' Select menu 'Vehicles...' Fill text-field 'Name' Fill text-field 'Price' Press button 'New' in order to create the vehicle Press button 'OK' in order to close the dialog Check table, whether new created vehicle appears As you can see the test case follows the same description like in the previous section about atomic keywords. The Excel file looks like this:","hash":"usec_keywords_components","h0":"Keyword-driven testing using dynamic or generic components"},"819":{"id":819,"content":"Figure 23.4: Excel file of generic components The used Excel file contains values like selectMenu or dialog.clickButton for the teststep column. Additionally a new column target was introduced. That new variable will be explained later. Like in the previous samples you can find a demo implementation at qftest-10.0.2-mobile/demo/keywords/generic/Keywords_With_Generics.qft. You can find the respective procedures in the package generic. Please take care to copy the demo folder to a project-related folder first and modify them there.","hash":"fig_keywords_excel_generics","h4":"Figure 23.4: Excel file of generic components"},"820":{"id":820,"content":"Figure 23.5: Test suite for generic components Let's investigate the procedure selectMenu first. This procedure consists of a mouse-click at the component GenericMenuItem. If we analyze that component in the test suite, we see that the attribute class is set to MenuItem. We also see that the attributes Name and Feature are empty, but there is one entry for the Extra features table. This entry has the name qfs:label with the state Must match and the value $(target). The next attributes Structure is empty again and the values for Geometry are set to '-'. You can details about the '-' at \"Generic components\". This way of defining a component means that the recognition of that component relies on the variable target. The variable itself is used in the extra feature qfs:label. That extra feature qfs:label represents the best describing text of a component, e.g. the text on a button or a label close to a text-field. The excel file got the column target which contains the exact label of the respective target components. This method has been applied to all other components as well. Another noteworthy aspect is the package dialog under the package generic. This has been introduced because QF‑Test also takes the window or dialog objects into account in order to recognize the graphical components correctly. QF‑Test also distinguishes between windows and dialogs. Standard windows which allow the user to work within a second window of the application as well and so-called modal windows preventing the user to work in a second window of your application. In most cases it's simpler to separate those two kinds of windows in several packages. If you want, it might be possible to unify them in one window, but that's not shown in the current samples. By the way, you don't need to separate between those window types if you test web applications as there every component is part of a web-page. In this section we have seen how to make the component recognition more flexible using variables. Additionally we have created one procedure per action and type of target component. This concept allows us to define all test cases within Excel. The required procedures including the generic components have to be created at the beginning of the project. Of course you can also mix this approach with some recorded procedures. Those recorded procedures can then be used like business-related procedures described in \"Business-related Procedures\")","hash":"fig_keywords_generics","h4":"Figure 23.5: Test suite for generic components"},"821":{"id":821,"content":"Mobile Manual","hash":"","h0":"Behavior-driven testing (BDT) | QF‑Test Manual"},"822":{"id":822,"content":"Mobile Manual","hash":"home-link","h0":"Behavior-driven testing (BDT) | QF‑Test Manual"},"823":{"id":823,"content":"Behavior-driven testing (BDT) Besides the traditional concept of keyword-driven testing a second concept called Behavior-driven testing (BDT) is widely being used. Tools for behaviour driven testing like Cucumber/Gherkin can easily be integrated into QF‑Test (please contact Quality First Software GmbH for a description about how to set up and configure BDT with QF‑Test). Using this approach allows testers to describe test cases more or less in continuous text and sentences. But the tester needs to follow a predefined vocabulary at the beginning of the sentence. Test cases described like this can be more readable for persons without any knowledge of the test cases. Test cases can be described from a technical perspective (see \"Behavior-Driven Testing (BDT) from technical perspective\") or from a business perspective (see \"Behavior-Driven Testing (BDT) from business perspective\") like in keyword driven testing. You find samples for both variants in the following sections.","hash":"usec_keywords_bdt","h1":"Behavior-driven testing (BDT)"},"824":{"id":824,"content":"Mobile Manual","hash":"","h0":"Behavior-Driven Testing (BDT) from technical perspective | QF‑Test Manual"},"825":{"id":825,"content":"Mobile Manual","hash":"home-link","h0":"Behavior-Driven Testing (BDT) from technical perspective | QF‑Test Manual"},"826":{"id":826,"content":"Behavior-Driven Testing (BDT) from technical perspective Describing a test case from a technical perspective using Behavior-Driven Testing (BDT) uses more or less elementary actions for designing a test case. You can find a sample test suite at qftest-10.0.2-mobile/demo/keywords/behaviordriven/ BehaviorDrivenTesting.qft. The respective test-plan can be found at qftest-10.0.2-mobile/demo/keywords/behaviordriven/ createvehicle.xlsx. Please take care to copy the demo folder to a project-related folder first and modify them there. The \"Create vehicle\" test case looks like this if it's described in the BDT manner from a technical view: Given SUT is running Given vehicles dialog is opened When vehicle name is set to <name> And vehicle price is set to <price> And button new clicked And button ok clicked Then row with <name> and <formatted-price> appears in table And column model has value <name> And column price has value <formatted-price> BDT requires to use the terms Given, When, And and Then at the beginning of any sentence. You will find more information about this approach in the testing literature. QF‑Test requires matching procedures for above test steps, so we need to build respective procedures again. It's an established method to divide the BDT-keywords in separate packages. The provided test suite therefore contains the packages Given, When_And and Then.","hash":"user_keywords_tech_bdt","h0":"Behavior-Driven Testing (BDT) from technical perspective"},"827":{"id":827,"content":"Figure 23.6: Test suite Behavior-driven testing technical The provided sample test suite contains all procedures in the respective packages, e.g. a procedure vehicles dialog opened inside the package Given. In order to prevent annoying typos a Server-script read test steps and fix typos formats any steps to lower case and tries to replace multiple blanks by one. This script is called directly before the procedure call of $(teststep). In order to run the test case on multiple test data the sample was extended. Of course you can apply the concept of generic component recognition as described in the previous section (see \"Keyword-driven testing using dynamic or generic components\"). To that end you would need to specify a very exact description or implement a script filtering the target components from the test step itself.","hash":"fig_keywords_bdt","h4":"Figure 23.6: Test suite Behavior-driven testing technical"},"828":{"id":828,"content":"Mobile Manual","hash":"","h0":"Behavior-Driven Testing (BDT) from business perspective | QF‑Test Manual"},"829":{"id":829,"content":"Mobile Manual","hash":"home-link","h0":"Behavior-Driven Testing (BDT) from business perspective | QF‑Test Manual"},"830":{"id":830,"content":"Behavior-Driven Testing (BDT) from business perspective Describing test cases from business perspective using Behavior-Driven Testing (BDT) requires actions from a user's point of view. So those actions contain several interactions likes mouse-clicks or text-inputs. You can find a sample test suite at qftest-10.0.2-mobile/demo/keywords/behaviordriven_business/ BehaviorDrivenTesting-Business.qft. The respective test-plan can be found at qftest-10.0.2-mobile/demo/keywords/behaviordriven_business/ createvehicle-business.xlsx. Please take care to copy the demo folder to a project-related folder first and modify them there. The \"Create vehicle\" test case looks like this if it's described in the BDT manner from a business perspective: Given application is ready to enter vehicle data When vehicle created with <model> and <price> Then <model> with <formatted price> appears in table This approach uses the keywords Given, When, And and Then at the beginning of any sentence like the technical one. The provided test suite therefore contains the packages Given, When_And and Then.","hash":"user_keywords_business_bdt","h0":"Behavior-Driven Testing (BDT) from business perspective"},"831":{"id":831,"content":"Figure 23.7: Test suite Behavior-driven testing from business perspective In order to prevent annoying typos a Server-script read test steps and fix typos formats any steps to lower case and tries to replace multiple blanks by one. This script is called directly before the procedure call of $(teststep). In order to run the test case on multiple test data the sample was extended.","hash":"fig_keywords_bdt_business","h4":"Figure 23.7: Test suite Behavior-driven testing from business perspective"},"832":{"id":832,"content":"Mobile Manual","hash":"","h0":"Scenario files | QF‑Test Manual"},"833":{"id":833,"content":"Mobile Manual","hash":"home-link","h0":"Scenario files | QF‑Test Manual"},"834":{"id":834,"content":"Scenario files Apart from defining single test cases you can also specify the entire test scenario in Excel files or even within your test management tool. In our sample we will go on using Excel to keep things simple. Of course it's also possible to use your testmanagement tool there. For reasons of simplification we have used Excel files again. You can find a sample test suite at qftest-10.0.2-mobile/demo/keywords/generic_with_scenario/ Keywords_With_Generics.qft. The scenario itself can be found in qftest-10.0.2-mobile/demo/keywords/generic_with_scenario/ scenario.xlsx. All used test cases are described in a separate excel file, see qftest-10.0.2-mobile/demo/keywords/generic_with_scenario/ keywords-generic-testcases.xlsx. Please take care to copy the demo folder to a project-related folder first and modify them there. The provided scenario consists of two test cases using the concept of generic procedures and components (see \"Keyword-driven testing using dynamic or generic components\"). You can use any other approach, if you want. Let's take a look at the scenario Excel file.","hash":"usec_keywords_scenarios","h0":"Scenario files"},"835":{"id":835,"content":"Figure 23.8: Excel file as scenario file The worksheet \"Scenario\" contains a column \"testcase\". This value will be used as variable later. Each subsequent row represents a test case name. Those test cases correspond with the worksheets in keywords-generic-testcases.xlsx. The worksheets \"tc_createvehicle\" and \"tc_createvehicle_cheap\" contain the respective test case description. How does the test suite look like?","hash":"fig_keywords_excel_scenario","h4":"Figure 23.8: Excel file as scenario file"},"836":{"id":836,"content":"Figure 23.9: Test suite scenario file","hash":"fig_keywords_scenario","h4":"Figure 23.9: Test suite scenario file"},"837":{"id":837,"content":"Node Purpose Test set \"Generic samples with scenario\" Represents the container node for the test execution. This node could be omitted theoretically. Dependency reference dependencies.sutStarted The concept of dependencies allows QF‑Test to manage the starting and stopping process of your application in an intelligent way. Dependencies can contain a strategy in case of any unexpected behavior during test run. See \"Dependencies\" for details. Data driver \"scenario\" Here we read the required test cases to execute. Excel file \"test cases\" Points to the scenario excel file. Test case \"Generic test case\" This node represents the implemented test case. Teststep \"Walk through test steps\" This node is required to read the test steps from the excel file with a data driver node. Data driver \"steps from excel\" A data driver reads the content of the Excel file describing the test case row by row. Excel file \"steps from excel\" Points to the Excel file describing the test case. Test step \"Generic test step\" This node will be filled with the current test step name from Excel during execution. This approach will create a readable report. Call procedure \"generic.$(teststep)\" Here the respective procedure defined in Excel is called. The variable teststep will be filled with the test data of Excel because of the data driver mechanism. Table 23.6: Structure of Keywords_With_Generics.qft","hash":"table_23.6","h4":"Figure 23.9: Test suite scenario file"},"838":{"id":838,"content":"Mobile Manual","hash":"","h0":"Custom test case description | QF‑Test Manual"},"839":{"id":839,"content":"Mobile Manual","hash":"home-link","h0":"Custom test case description | QF‑Test Manual"},"840":{"id":840,"content":"Custom test case description The previous sections show all samples using Excel files. As already mentioned it's also possible to use different file-types, e.g. XML or CSV files. But you can also think about evaluate the result of a web-service. Therefore, you will need to implement Server-scripts reading the required information like test step name, component names or variables for QF‑Test. Setting variables can be achieved by the methods rc.setLocal bzw. rc.setGlobal. Once those variables have been set it will become necessary to call test case or procedures. Therefore, you can use the methods rc.callTest or rc.callProcedure. You can find a full API description at \"Scripting\". You can also find a few samples in the provided test suite of the manual tester (qftest-10.0.2-mobile/demo/manualtester) or in the integration of the imbus TestBench (qftest-10.0.2-mobile/ext/testbench).","hash":"usec_keywords_custom","h0":"Custom test case description"},"841":{"id":841,"content":"Mobile Manual","hash":"","h0":"Adapting to your software | QF‑Test Manual"},"842":{"id":842,"content":"Mobile Manual","hash":"home-link","h0":"Adapting to your software | QF‑Test Manual"},"843":{"id":843,"content":"Adapting to your software All examples make use of the CarConfigurator of QF‑Test. You can use those samples as templates to adapt the existing concept to your strategy of keyword-driven testing. The provided samples can only act as templates because of the huge variety of ways of creating applications and the many different testing strategies. They will never serve as out-of-the-box solution without any need of adapting them. In order to find a matching solution to your project you can also get in touch with our support team. Nevertheless you can find a full sample for the CarConfigurator at qftest-10.0.2-mobile/demo/keywords/ full_sample_for_carconfig. The sample uses the concept of scenario files as described in \"Scenario files\".","hash":"usec_keywords_adapt","h0":"Adapting to your software"},"844":{"id":844,"content":"Technology Necessary Adjustments JavaFX Replace the value awt with fx in the attribute GUI engine on all window components. Perhaps you need to extend the recorded window components with additional variables. You need to adapt the procedure startStop.startSUT in order to start your application. Simply copy the created steps from the quickstart wizard. You might possibly have to create some resolver scripts to tune component recognition. Java/Swing Perhaps you need to extend the recorded window components with additional variables. You need to adapt the procedure startStop.startSUT in order to start your application. Simply copy the created steps from the quickstart wizard. You might possibly have to create some resolver scripts to tune component recognition. Java/SWT Replace the value awt with swt in the attribute GUI engine on all window components. Perhaps you need to extend the recorded window components with additional variables. You need to adapt the procedure startStop.startSUT in order to start your application. Simply copy the created steps from the quickstart wizard. You might possibly have to create some resolver scripts to tune component recognition. Web Replace the window component with a Web page node. As dialogs are already part of the web page you don't need to keep them separated and can create a component within the web page.. You need to adapt the procedure startStop.startSUT in order to start your application. Simply copy the created steps from the quickstart wizard. You might possibly have to tune component recognition using the CustomWebResolver concept. Table 23.7: Necessary adaptions to your SUT","hash":"table_23.7","h0":"Adapting to your software"},"845":{"id":845,"content":"Mobile Manual","hash":"","h0":"Usage of QF‑Test in Docker Environments | QF‑Test Manual"},"846":{"id":846,"content":"Mobile Manual","hash":"home-link","h0":"Usage of QF‑Test in Docker Environments | QF‑Test Manual"},"847":{"id":847,"content":"Usage of QF‑Test in Docker Environments","hash":"usec_docker","h0":"Usage of QF‑Test in Docker Environments"},"848":{"id":848,"content":"What is Docker? Docker is a free virtualization software that makes it very easy to install and run arbitrary applications on physical computers or in the cloud. Docker was originally developed for the Linux operating system. Docker is now also available for other platforms, including Microsoft Windows and macOS. The virtualization software also runs on cloud services such as Amazon Web Services (AWS) and Microsoft Azure. Unlike virtual machines, Docker containers are much more resource-efficient, as they do not require the installation of a guest operating system.","hash":"usec_docker_intro","h1":"What is Docker?"},"849":{"id":849,"content":"QF‑Test Docker Images Since QF‑Test version 6.0.3 official Docker images have been available, which allow to virtualize QF‑Test relatively easy. To enable different application scenarios, there are currently 4 different Docker images per QF‑Test version on Docker Hub. The exact details and application possibilities for those individual images are also described there. There is an image with and without preinstalled web browser especially for web tests as well as a variant with or without additional VNC server, which allows the visual control of the test execution as well as possibly necessary debugging of tests. The provided images only serve as a basis for your own application scenarios and can be extended accordingly by using them as a base image in a Dockerfile. In February 2023, a special webinar took place about using Docker with QF‑Test. After a bit of theory the detailed steps of using the QF‑Test images from Docker Hub. Here you can find the special webinar video recording available on our QF‑Test YouTube Channel.","hash":"usec_docker_images","h1":"QF‑Test Docker Images"},"850":{"id":850,"content":"Mobile Manual","hash":"","h0":"Performing GUI-based load tests | QF‑Test Manual"},"851":{"id":851,"content":"Mobile Manual","hash":"home-link","h0":"Performing GUI-based load tests | QF‑Test Manual"},"852":{"id":852,"content":"Performing GUI-based load tests Video: Load testing","hash":"usec_loadtest","h0":"Performing GUI-based load tests"},"853":{"id":853,"content":"Background and comparison with other techniques In addition to functional and system tests, QF‑Test can also be used to perform load tests, stress tests or performance tests. The idea is to test the performance of some server applications by running a number of GUI clients concurrently. Performance is measured by running multiple GUI clients in parallel. QF‑Test enables you to measure the actual end-to-end response times (the time span from user action until the result shows up). For the following paragraphs we will use the term load testing. There are many different ways for setting up and performing load tests, most of which are not using real GUI clients. Instead they directly make use of the protocol between the client and server, e.g. by sending HTTP request or performing RMI or other kinds of remote procedure calls. There are a number of pros and cons for protocol-based or GUI-based load testing: Use of resources: Protocol-based testing uses very little resources at the client side, so it can easily scale up to the breaking point of the server without requiring too much hardware. GUI-based tests incur the full memory and performance overhead for each client, which can be quite significant, especially in case of Swing- or JavaFX-based rich clients. In addition, every client creates a GUI and, therefore, a real active user session is required. Efforts creating tests: Rich clients typically represent a complex user interface, which correlates with a certain complexity of the client/server API. Creating protocol-based tests that cover most of that API can be quite an effort. On the other hand, GUI-based tests that have already been implemented for functional testing may be available for reuse. If not, it is still much easier to automate complete use cases with QF‑Test than at protocol level. Measuring response times: With GUI-based testing, actual end-to-end response times (the time span from user action until the result shows up) are measured, while protocol-based tests measure only the times for the server call. Either can be useful, depending on the situation. In some cases it can be quite reasonable to combine both approaches. You can think about running GUI tests on a few systems in order to measure those end-to-end times and in parallel you can trigger protocol-based tests in order to create some load. In summary, GUI-based load tests can be very useful and efficient - especially if functional tests can be reused - provided that either the number of clients that need to be simulated is not too high, or that sufficient hardware is available for the client side. At the end of this section here is a overview diagram showing all involved systems.","hash":"sec_background_and_comparison_with_other_techniques","h1":"Background and comparison with other techniques"},"854":{"id":854,"content":"Figure 25.1: Load testing scenario","hash":"fig_loadtestingstructure","h4":"Figure 25.1: Load testing scenario"},"855":{"id":855,"content":"Load testing with QF‑Test As load testing is a sophisticated subject QF‑Test provides a demo tests-suite which can be used as initial point for your project. You can find that demo solution at qftest-10.0.2-mobile/demo/loadtesting/. This folder contains the following files:","hash":"sec_load_testing_with_qf_test","h1":"Load testing with QF‑Test"},"856":{"id":856,"content":"File Purpose Systems.xlsx You can configure which test systems are involved in the test run. Furthermore you can configure global variables for the test run there. carconfig_Loadtesting.qft This test suite contains the GUI tests which will get executed on the test systems. daemonController_twoPhases.qft This test suite represents the controlling test suite for the entire test run. Using this test suite allows you to launch and co-ordinate the test run on multiple systems. checkForRunningDaemons.qft This test suite contains test cases to check for running daemon processes on individual test systems. Table 25.1: Content of load testing directory The test suites and files mentioned above can be applied to a load testing project which makes use of multiple test systems. Please take care to copy the demo folder to a project-related folder first and modify them there. The subsequent figure shows an illustration:","hash":"table_25.1","h1":"Load testing with QF‑Test"},"857":{"id":857,"content":"Figure 25.2: Overview load testing project The provided sample test suite for controlling the test run looks like this:","hash":"fig_loadtestingoverview","h4":"Figure 25.2: Overview load testing project"},"858":{"id":858,"content":"Figure 25.3: Sample test suite daemonController_twoPhases.qft In order to execute load tests with QF‑Test you should take care of the following: Provision of test systems Conception of the test run Preparing test systems prior to the test run Test execution Evaluating results You can find brief explanations as well as some hints for each item in the following sections. For tips on how to do parallel website testing with QF‑Test read our blog post Running Website Tests in Parallel with QF‑Test .","hash":"fig_loadtestingdaemoncontroller","h4":"Figure 25.3: Sample test suite daemonController_twoPhases.qft"},"859":{"id":859,"content":"Provision of test systems You perform load tests with QF‑Test via the GUI. GUI tests require an active user session and shouldn't get executed in parallel at the same desktop. That's why we recommend to set-up a virtual or physical system for every client involved. It's indeed possible to run multiple GUI tests in parallel on the same desktop, but this can end up in very subtle problems, e.g. issues with the current focus. That's why running multiple GUI tests on the same desktop is not recommended and should only be taken into consideration in exception. QF‑Test needs to be installed on every system. In addition, the required test suites, the configuration file of QF‑Test and necessary test data files need to be deployed to the test systems as well. You can either copy those files to every system locally or you establish a common network share. Furthermore, every test system requires at least a runtime license in order to run the tests. QFS offers to lease such runtime licenses even for a certain period of time.","hash":"usec_loadtestingsysprep","h2":"Provision of test systems"},"860":{"id":860,"content":"Conception of the test run The simplest case is to run the same test on all involved test systems. However, many load testing projects require different sets of GUI tests to be executed. You can think about running tests for various roles of users or user groups. A possible group can represent standard users another some kind of administrator users. Besides designing the test run for multiple roles load tests are often split into several phases. A phase represents a certain thematic priority. As an example you can divide your project into four phases. The first phase stands for the \"Launch\" phase. There, the SUT is getting launched on all involved test systems and some initial actions as the log-in can take place. During the second phase 50 clients perform their specific test-scenario. The third phase is performed using 100 clients and the final fourth phase downgrades to 50 clients again. This kind of scaling is also called ramp-up phase (incrementally increasing load) and ramp-down phase (incrementally decreasing load). Such a conception using several phases increasing the load allows you to test the load capacity of your application in several steps. Like this you will get the information that your application was ok in phase one and problems occurred in the second phase, rather than just a statement about all or nothing. Using several phases makes sense if multiple roles are the actual focus of your tests. In some cases launching the application on all involved test system can break the environment. So you can think about splitting your project at least into a \"launch\" phase and \"test\" phase. You should create one test suite per role to keep track of your test cases. Implementation in the sample test suite: You can find a sample project with two phases in the provided controller test suite daemonController_twoPhases.qft The first phase (Launch Phase Phase) launches the application. The second phase (Test Phase) represents the actual test phase. You can configure the required test suite in the corresponding Run...Phase test nodes of each phase. The provided sample focuses on several roles instead of phases. In case you would like to create a third phase, simply copy the test node Test Phase and rename it accordingly.","hash":"usec_loadtestingconcept","h2":"Conception of the test run"},"861":{"id":861,"content":"Preparing test systems prior to the test run You need to launch the QF‑Test daemon before you can start your test run. This QF‑Test daemon requires a vacant network port. In order to work effectively we recommend to use the same port on all systems, e.g. 5555. You can launch the daemon like this: qftest -batch -daemon -daemonport 5555 Example 25.1: Launching QF‑Test daemon Please note, that the daemon needs to be started in an active user session. You can accomplish this using tools like the task planer. You can find further details about the daemon at \"Executing tests in daemon mode\". Chapter Hints on setting up test systems contains useful tips and tricks to set-up the daemon process. In FAQ 14 you can find technical details. If you want to check whether the daemons are up and running you can either run individual ping commands of the daemon or you run the provided test suite checkForRunningDaemons.qft. qftest -batch -calldaemon -ping -daemonhost localhost -daemonport 5555 Example 25.2: Ping of QF‑Test daemon at localhost On Windows you should use the command qftestc.exe instead of qftest.exe for every command.","hash":"usec_loadtestingsysping","h2":"Preparing test systems prior to the test run"},"862":{"id":862,"content":"Test execution During test execution you will need some scripts that will contact the various QF‑Test daemons in order to co-ordinate the test run. Such scripts can use QF‑Test's daemon API (see \"Daemon API\") or its command line (see \"Command line arguments and exit codes\"). Implementation in the sample test suite: The provided test suite daemonController_twoPhases.qft allows you to run such a load testing scenario and collect the run logs of the test runs afterwards. In the provided Excel file Systems.xlsx you can configure which test systems should be involved. That files also contains some variables to organize your tests in roles as described in \"Conception of the test run\". Once all test systems have been correctly configured you can start the test run via running the entire test suite. Besides the pure execution of such a load testing project you can also meet further requirements. The provided test suites shows samples for the following aspects: Synchronizing the test run on several test systems, see \"Synchronization\". Measure end-to-end times, see \"Measuring end-to-end response times\".","hash":"usec_loadtestingTestExec","h2":"Test execution"},"863":{"id":863,"content":"Evaluating results Evaluating results can become quite challenging just because of that huge amount of data. You can analyze the QF‑Test run logs as well as the QF‑Test reports. Perhaps you receive some measurements at server side or you find a couple of logs which you can analyze by specific tools. During test execution you can also create custom log-files with QF‑Test as described in \"Measuring end-to-end response times\" for details.","hash":"sec_evaluating_results","h2":"Evaluating results"},"864":{"id":864,"content":"Hints on test execution","hash":"usec_loadtestingexectipps","h1":"Hints on test execution"},"865":{"id":865,"content":"Synchronization To get consistent results, it may sometimes be necessary to coordinate the tests in the parallel threads, either to make sure that all clients access the server simultaneously, or to prevent just that. Furthermore, a role (see previous section) might require all test systems to be in a certain state before running a specific action. Test runs can be synchronized with the help of a Server script node. That script should contain the following: rc.syncThreads(\"identifier\", timeout, remote=3) identifier is a name for the synchronization point, timeout is the maximum time in milliseconds to wait for all threads to reach the given synchronization point and remote specifies how many systems should wait for that synchronization point. If the timeout is exceeded without the expected number of threads reaching the synchronization point, a TestException is thrown. To log an error instead of raising an exception, set the optional parameter throw to 0 (default value 1) or you pack that Server script step into a Try step. rc.syncThreads(\"case1\", 120000, remote=3, throw=0) You can find a sample implementation in carconfig_Loadtesting.qft.","hash":"usec_loadtestingsync","h2":"Synchronization"},"866":{"id":866,"content":"Figure 25.4: Call of rc.syncThreads in demo test suite","hash":"fig_loadtestingsyncsample","h4":"Figure 25.4: Call of rc.syncThreads in demo test suite"},"867":{"id":867,"content":"Measuring end-to-end response times It's a very common requirement for GUI tests to measure end-to-end response times. QF‑Test logs those times into its run log. Instead of having to parse that run log in order to retrieve those values you can implement a so-called TestRunListener to write a dedicated log file, which just contains the required measurements. In order to measure the interesting parts, you will need to mark your test steps or sequence using a dedicated keyword. The provided sample implementation uses the keyword @transaction for that purpose. If you want to use another keyword, you have to change the code of the provided TestRunListener. In the provided sample test suite all measurements will be logged into a simple CSV file. That CSV file can be used later for the actual evaluation by another tool. Furthermore, writing that CSV file doesn't brake the test run. If you want to create Excel files or fill databases in order to evaluate the results you should do that after the test run due to performance reasons. You can find details about the TestRunListener at \"Test run listeners\". The sample implementation can be found in carconfig_Loadtesting.qft. The created CSV file looks like this: open vehicles;118;20150921145057;OK close vehicles;84;20150921145057;OK Example 25.3: CSV file for time measurements In that CSV file the first value represents the name of the measurement, the second value stands for the duration of the action in milliseconds, the third shows the time when the step was performed, the fourth value shows whether the step was successful.","hash":"usec_loadtestingmeasurement","h2":"Measuring end-to-end response times"},"868":{"id":868,"content":"Troubleshooting Due to the complexity of load testing projects you may face issues in several areas. Why are wrong test cases executed? Adapt the variable testsuite in the respective test case. You can also address a test case directly via testsuite#testset.testcase. The QF‑Test daemon cannot be started. Is the network port vacant? You can check this using the netstat command. Here is a sample for the port 5555. netstat -a -p tcp -n | findstr \"5555\" netstat -a --tcp --numeric-ports | grep 5555 The test systems cannot be reached although the QF‑Test daemon is running. Check whether the QF‑Test daemon can be reached on the test-sytem, see \"Provision of test systems\". If the QF‑Test daemon is running, please perform following steps: Can you reach the QF‑Test daemon on the local systems using the ping command, see \"Preparing test systems prior to the test run\"? Ensure that the daemon or its Java process is not blocked by your system firewall. Perhaps there are issues resolving the host name of your test system. Then try to launch the daemon with the additional parameter -serverhost localhost or -serverhost IP address or -serverhost <host name>. In case you use the IP address, please also access that system using the IP-address, otherwise use the host name.","hash":"usec_loadtestingtroubleshooting","h1":"Troubleshooting"},"869":{"id":869,"content":"Mobile Manual","hash":"","h0":"Executing Manual Tests in QF‑Test | QF‑Test Manual"},"870":{"id":870,"content":"Mobile Manual","hash":"home-link","h0":"Executing Manual Tests in QF‑Test | QF‑Test Manual"},"871":{"id":871,"content":"Executing Manual Tests in QF‑Test","hash":"usec_manualtester","h0":"Executing Manual Tests in QF‑Test"},"872":{"id":872,"content":"Introduction QF‑Test is primarily a tool for the creation and execution of automated tests. However, it is rarely possible - or economical - to automate 100% of the required tests for a project. In most projects some manual tests need to be performed as well. One of the biggest challenges in testing a project is consolidating the different results and reports of automated and manual testing to get an overview about the execution status of all tests. To facilitate reporting the results of manual test execution along with those of automated testing, QF‑Test now offers the capability of tracking manual tests from within itself. The steps to be performed during a manual test have to be defined in an Excel file which is read by a test suite called ManualTestRunner.qft. This test suite is provided along with a sample specification file in the directory demo/manualtester below the QF‑Test installation directory. The test designer has to specify each step in that Excel file including the expected result. After stepping through the manual tests QF‑Test provides the usual results - a run log, HTML and XML reports. Additionally, a newly created Excel file with the results of the respective test run is created. For a detailed description please see \"Step-by-step Guide\". The dialog used for the test execution is called ManualStepDialog and looks like this:","hash":"usec_mtIntro","h1":"Introduction"},"873":{"id":873,"content":"Figure 26.1: Example for a ManualStepDialog The title of the dialog shows the name of the test case. The detailed step description and the expected result are shown in the first two text-boxes. After performing the test the tester has to specify whether the test succeeded or not. In case the test failed the tester also has to enter the received result which is intended to show the differences between the actual and the expected result. This dialog can also be used for your own purposes, see \"The ManualStepDialog API\".","hash":"figure_26.1","h4":"Figure 26.1: Example for a ManualStepDialog"},"874":{"id":874,"content":"Step-by-step Guide Please perform the following steps on your system to launch a manual test from QF‑Test. Copy the definition Excel file from qftest-10.0.2-mobile/demo/manualtester/SampleTestDescription.xlsx to your project location and rename it to a suitable name. We recommend to use the same path on all test systems. Perhaps you can make use of a shared network drive. Also copy the execution test suite from qftest-10.0.2-mobile/demo/manualtester/ManualTestRunner.qft to your project location. You may want to rename it as well. Open the Excel file and define the test steps. After saving the changes to the Excel file, open the execution test suite and adapt the global variable testFile variable to target your specific Excel file. Turn off the QF‑Test debugger. It would only interfere with the steps of the manual tester. Start the test suite via selecting the test suite node and pressing \"Start test run\". QF‑Test will now read the data from the Excel file and open a dialog containing the first test step. Enter the result of the test step and proceed with executing each test step. At the end of the test execution QF‑Test will write a new Excel file containing the test description and the according results. You can also store the run log of that execution or create an HTML report. Please read the comments in the test suite and Excel file carefully, because you can adapt this concept according to your needs. It is even possible to start only specific tests.","hash":"usec_mtStepByStep","h1":"Step-by-step Guide"},"875":{"id":875,"content":"Structure of the Excel file The Excel file has a specific structure which allows you to describe the manual test steps quite flexibly. The meaning of the columns is explained in the following table:","hash":"usec_mtExcelFile","h1":"Structure of the Excel file"},"876":{"id":876,"content":"Column Description TestCase A unique identifier for each test case. If the step belongs to the same test case as the previous step, just leave this column empty. Type of Test Optional definition of the kind or function of the test or step, e.g. a functional test or a usability test, startup, etc. Comment An individual comment for the test case. This comment will be shown in the run log of QF‑Test. Short Description A short description about the content of the test. Step Description The detailed description of the manual step. Expected Result The description of the expected result of that test step. Table 26.1: Description of the Excel file for the definition of manual tests The Excel file with the results of the manual test execution will contain two additional columns as follows:","hash":"table_26.1","h1":"Structure of the Excel file"},"877":{"id":877,"content":"Column Description Received Result The result the tester received during test execution. If a test step fails, the tester must specify a received result. State The state of the test, i.e. PASSED, FAILED, CANCELED or SKIPPED. Table 26.2: Description of the Excel file with the results of manual tests","hash":"table_26.2","h1":"Structure of the Excel file"},"878":{"id":878,"content":"The ManualTestRunner test suite The ManualTestRunner.qft test suite contains some global variables at suite-level which provide fine-grained control over test run. These are explained in the following table. All variables not listed here are used internally by the test suite and should not be changed.","hash":"usec_mtMTestRunner","h1":"The ManualTestRunner test suite"},"879":{"id":879,"content":"Global Variable Description testFile The path to the test step definition Excel file. testSheet The worksheet of the Excel file containing the test steps. resultSheet The name of the worksheet for the results. tests A list of tests to be intended to execute. If this variable is empty, all tests will be executed. If you want to execute only test 5 and 6, you can specify 5,6 or 5-6. It is even possible to specify things like: 1,3-5,7 to execute the tests 1, 3, 4, 5 and 7. defaultState The default selection of the state. You can set it either to PASSED or FAILED. All other states will be converted to FAILED. testCaseColumn The heading of the column containing the test case number. commentColumn The heading of the column containing the comment. shortDescColumn The heading of the column containing the short step description. stepDescColumn The heading of the column containing the full step description. expResultColumn The heading of the column containing the expected result. recResultColumn The heading of the column containing the received result. stateColumn The heading of the column containing the state of the test. Table 26.3: Description of the global variables in the ManualTestRunner test suite","hash":"table_26.3","h1":"The ManualTestRunner test suite"},"880":{"id":880,"content":"Results An executed test step can be set to one of the following states:","hash":"usec_mtStates","h1":"Results"},"881":{"id":881,"content":"Result Description PASSED The test step was successful. FAILED The test step failed. CANCELED The test step was canceled. SKIPPED The test step was skipped. Table 26.4: States of manual test execution","hash":"table_26.4","h1":"Results"},"882":{"id":882,"content":"Mobile Manual","hash":"","h0":"Best Practices | QF‑Test Manual"},"883":{"id":883,"content":"Mobile Manual","hash":"home-link","h0":"Best Practices | QF‑Test Manual"},"884":{"id":884,"content":"Best Practices","hash":"sec_BestP","h1":"Best Practices"},"885":{"id":885,"content":"Mobile Manual","hash":"","h0":"Introduction | QF‑Test Manual"},"886":{"id":886,"content":"Mobile Manual","hash":"home-link","h0":"Introduction | QF‑Test Manual"},"887":{"id":887,"content":"Introduction This part of the manual describes best practices based on lessons learned from several customer projects and user feedback. The concepts described should assist you in finding the best strategy for using QF‑Test in your projects. QF‑Test is a very generic tool. The hints and experiences described here are just suggestions from our point of view, which we hope will support you in working efficiently and successfully with QF‑Test in your project. But they are just one way of doing things and you will have to find your own solution that works best for your specific project.","hash":"sec_bpIntro","h0":"Introduction"},"888":{"id":888,"content":"Mobile Manual","hash":"","h0":"How to start a testing project | QF‑Test Manual"},"889":{"id":889,"content":"Mobile Manual","hash":"home-link","h0":"How to start a testing project | QF‑Test Manual"},"890":{"id":890,"content":"How to start a testing project This chapter talks about the most important aspects that should be considered before you start to use QF‑Test widely in your testing project. It mostly raises questions and gives general answers with references to more detailed information. The aim of this chapter is to provide hints about issues which you should take care of in order to make your GUI tests reliable, stable, repeatable and especially maintainable.","hash":"sec_bpHowToStart","h0":"How to start a testing project"},"891":{"id":891,"content":"Infrastructure and testing environment Before you start creating and running automated tests you should think about some general matters pertaining to the environment where the tests have to run. In order to make tests reliable and repeatable you have to take into account that you must be able to bring your SUT into a well-defined state, which includes the state of its backend, e.g. a server and/or a database. If you do not think about such aspects it might become very difficult and sometimes quite tricky to rerun a test or simply to analyze test results and maintenance of tests can become a nightmare. Please consider the following topics: What is the initial state of your SUT? Which user is the actual user running the tests in your SUT? Most projects work with dedicated test users for running tests. Another approach could be to have one test user per test engineer. Which language setting of your SUT is the primary one? Is it really required to reach a full coverage of all supported languages or is it sufficient to run the bulk of the tests in one primary language and create only a few tests to specifically test localization? In most cases repeating tests in several languages just covers the same functionality, so you gain no real new information after running them. However, unless you take precautions, the language setting will influence the component recognition of QF‑Test, please see \"How to achieve robust component recognition\" for details. What is the initial state of your database? Can you work with an extra test database or do you have to use a production database? Test databases contain test data with designed and planned content whereas production databases contain real-life data. Is the latter predictable and reliable? What about the danger that tests can mess with and possibly destroy production data? If at all possible you should avoid running automated tests in a production environment. Can you clean up or reset the environment after one test run for rerunning the test? Is it possible to undo changes in the database or is it required to use new test data for the next regression phase? How can you read or write test data? Do you want to use standard SQL scripts or can you reuse libraries from development? Some projects even reinstall the whole database before every test run because they cannot reuse any test data or clean the database correctly. Do you want to integrate QF‑Test with other tools, e.g. build tools or test management tools? How to integrate QF‑Test with a test management tool? If you can reuse already planned test steps you can avoid redundant work in planning tests and creating them. For the standard integration for such tools, please see \"Interaction with Test Management Tools\". Should test's be launched by a build-tool? If you have created tests you can run them unattended and trigger the run by a build-system like Ant or CruiseControl. Please see \"Test execution\" for details about test execution. Should test results be uploaded to a reporting system or into a test management system or is it more sufficient to put the HTML reports and run logs on a centralized HTTP-server? Who will work with QF‑Test? Do only one or two engineers work with QF‑Test or do all developers and business testers participate in test development? You can find some hints about working in a team with different roles in \"Roles and responsibilities\". What are the skills of the engineers? It is recommended to have at least one dedicated person with a good QF‑Test knowledge in the team, who is also capable of implementing scripts and understanding software development principles. Of course there will be more issues to take care about which are specific for your project. Try to figure them out.","hash":"sec_bpInfrastructure","h1":"Infrastructure and testing environment"},"892":{"id":892,"content":"Location of files You should also think about following aspects of saving or installing files: Where to install QF‑Test to? QF‑Test can be installed locally on every system but this forces you to update every system manually whenever you need to upgrade to a new version. You can also install QF‑Test on a shared network drive, if your network is reliable, see \"Network installation\" for details. Where to store the configuration file qftest.cfg? Among other things that file contains information about how QF‑Test should recognize components or what should go into the run log. These options have to be the same for every QF‑Test user, otherwise you cannot share tests in your team. To ensure that you can either use a shared network installation for QF‑Test or specify the config file via command line parameters when launching QF‑Test. Make sure the shared config file is write-protected unless you explicitly want to change it. For details, see \"The configuration files\". Where to store the license file license? You should put the license file to a central place in order to update the license only once when you receive an update for it. Again, you can either have a shared network installation for QF‑Test or can use command line parameters to specify the location of that file when launching QF‑Test. For details, see \"The license file\". Where to store the test suites? The best place to store test suites is a version management system where you can track the changes and access any version of the files. If this is not possible you should store them on a shared network drive. Where to store the test data files? Test data files are associated with test suites so you should store them closely to the suites, i.e. either in the same version management system or on a shared network drive. Where to store the HTML reports and run logs? You should put those files in a centralized place where any engineer can take a look at them to evaluate the test results. Most people tend to use an HTTP server or a shared network drive for that.","hash":"sec_bpLoc","h1":"Location of files"},"893":{"id":893,"content":"Network installation If you plan to install QF‑Test on a shared network drive you have to take care about some specific things. The main source of conflict is the system settings file qftest.cfg. It is actually a good (and necessary) thing to have all users use the same system settings, especially for the recognition options. Sharing the system settings file facilitates this. However, this file should be made read-only so that one user will not inadvertently change the system settings for everyone. If the file is read-only, QF‑Test will not save the system settings upon exit. Any change to these settings will have to be made by explicitly making that file writable, then exiting QF‑Test and then making it read-only again. Alternatively each user could specify a different system settings file via -systemcfg <file> but that's not advisable. The running QF‑Test instances will also share the log directory (internal logging, not a problem) and the Jython package cache which can occasionally cause problems so that QF‑Test cannot initialize its Jython interpreter. This doesn't happen often and can be fixed by clearing (not removing) the Jython cachedir. For Windows, each user should also execute the setup.exe for the primary QF‑Test version, located in the installed qftest-x.y.z directory, to get proper registry settings and documentation links on his machine. In the rare case when a QF‑Test patch overwrites existing jar files of QF‑Test, running instances based on those jars may crash on Windows.","hash":"sec_bpNetworkInstallation","h2":"Network installation"},"894":{"id":894,"content":"Component Recognition The most important aspect of a GUI testing tool is a stable and reliable recognition of the graphical components. In that area QF‑Test is very flexible and can be configured in several ways. In most cases the default configuration for the component recognition works well, but sometimes you may have to change it. If you change the component recognition options after creating lots of test cases, those test cases may break. Therefore you should try to find the most appropriate settings for your project as early as possible. It is worth spending time in that area before starting to implement a huge amount of tests because in the worst case you might have to re-record or at least update all or most of the existing test cases after a critical change of the recognition options. Best start by recording some demo test cases and figure out how QF‑Test recognizes your SUT's components. The recognition mechanism is described in \"Components\" and \"Sub-items: Addressing relative to a parent component\". If you rerun those demo test cases - ideally on different versions of your SUT - and run into recognition problems, you have to ask yourself following questions about those tests: Are there enough synchronization points, like Wait for component to appear or Check nodes with timeouts to execute test steps only if the SUT is ready for them? Sample 1: After opening a window you can only work in that window, if it is really there -> Use a Wait for component to appear node. Sample 2: After pressing on a search button, you can only continue with the test when the search is really over -> Use a Check node with a timeout. Another important aspect besides synchronization points is the correct approach of recognizing components. You have to ask yourself the following questions to determine, which recognition approach might be the most appropriate one: Do the developers use unique and stable names for their components? Please take a closer look at \"Windows, Components and Items\". Perhaps it is sufficient to use a regular expression for the Feature attribute of the component of the main window under the Windows and components node. Please see \"Using regular expressions for working with dynamic window titles\" for details. If development did not set useful or even dynamic names it may be required to implement a NameResolver. Please take a closer look at \"How to achieve robust component recognition\". Do any of the QF‑Test recognition options need to be changed? These are described in \"How to achieve robust component recognition\". Is it possible to use generic components? See \"Generic components\" for details. In some cases it is sufficient to change the default configuration. Let us assume the developers have set unique and stable names for the target components, i.e. buttons, textfields, checkboxes etc. In such cases it may be sufficient to just change the 'Name override mode' setting of QF‑Test to 'Name overrides everything'. This setting tells QF‑Test to ignore any changes in the component hierarchy and just work with the target components and the window directly. You have to change this option in two places: Once at 'Record' -> 'Components' -> 'Name override mode' and at 'Replay' -> 'Recognition' -> 'Name override mode'. See \"How to achieve robust component recognition\" for more details.","hash":"sec_bpComponentRec","h1":"Component Recognition"},"895":{"id":895,"content":"Mobile Manual","hash":"","h0":"Organizing test suites | QF‑Test Manual"},"896":{"id":896,"content":"Mobile Manual","hash":"home-link","h0":"Organizing test suites | QF‑Test Manual"},"897":{"id":897,"content":"Organizing test suites One of the most challenging tasks in a project is keeping the test suites maintainable over a long period of time. Especially if some window or workflow changes significantly the maintenance effort should be kept to a minimum. It is also worth thinking about how to minimize the creation efforts of tests that contain a lot of similar or even the same steps. A typical use case is launching the SUT or the login process or a very important and basic workflow like navigating to a certain part of the SUT. Another aspect to think about is how to efficiently organize test suites if different people work in your testing project. In any case you should create your test suites within a QF‑Test project as described in \"Projects\". This feature provides a better overview over your test suites and directories. The following sections show some best practices how to keep your tests maintainable, extensible and well-organized.","hash":"sec_bpOrganize","h0":"Organizing test suites"},"898":{"id":898,"content":"Organizing tests In chapter \"Test set and Test case nodes\" we describe the concepts of Test set and Test case nodes. A Test case node stands for one dedicated test case and its test data. A typical Test case could be derived from a use case, a requirement or a defect description in your environment, e.g 'Calculate the price for vehicle xyz at 10% discount' for the CarConfigurator application. Test set nodes are collections of Test sets and Test cases which can be used for organizing test cases, e.g. 'Tests for calculating prices'. Test step nodes represent the individual test steps of a Test case like 'Open window' or 'Check calculation'. If you have an external description of the Test case or any other associated information which might be important for it, it is recommended to add an HTML link to it in the Comment attribute of the Test case. You will see that link in the report later. It is even possible to create a separate test documentation using the menu action »File«-»Create testdoc documentation«. More details about documentation can be found in \"Reports and test documentation\". The report and test documentation also contain the Test step nodes which are used in a Test case. If a Test case consists of lots of Procedure calls or Sequences, you should organize the single test steps in Test step nodes. Those Test step nodes have the advantage that you can really see every significant step in the QF‑Test window and also in the report later. If you want to put several nodes into a Test step you can pack the respective nodes into a Test step via selecting them, perform a right-mouse click and selecting »Pack nodes«-»TestStep«.","hash":"sec_bpOrganizingTests","h1":"Organizing tests"},"899":{"id":899,"content":"Modularization One of the most important concepts for effective test automation is modularization. Modularization here means placing reusable sequences in a dedicated location and calling these whenever possible. This concept enables you to create a sequence only once and reuse it as often as you require it in your tests without re-recording the same steps all the time. Changes in the SUT that require an update of the tests that rely on such a sequence, e.g. a change to some basic workflow, can then be handled by updating just the procedure in a single location instead of many identical sequences spread all over the test suites. The modularization concept in QF‑Test is implemented via Procedure nodes. Procedures are well described in \"Procedures and Packages\". If you have lots of test cases, it is best to have almost every test step as a Procedure and create those procedures up front, if possible. With those procedures in place you can fill your test cases very fast by just adding the respective Procedure call nodes. In larger projects it is useful to have Procedures at different level, e.g. component specific procedures like 'Click OK' and workflow oriented procedures like 'Create a vehicle'.","hash":"sec_bpModul","h1":"Modularization"},"900":{"id":900,"content":"Parameterization The concept of modularization enables you to maintain test steps at a single location in your test suites. But how to use different test data for different tests? If you have a Procedure that can be called with different test data, e.g. a typical 'Login' process with name and password or the 'Select accessory' procedure of the CarConfigurator, you can use variables within the QF‑Test nodes. Those variables should be used at places where test data is usually being accessed. In most cases variables will be used for Text input nodes or for selections of items in a list or a table or tree nodes. If a procedure requires variables you should define the required variables in its list of Variable definitions. This is to ensure that you get a list of all required parameters whenever you add a respective Procedure call node for that Procedure to your tests. Some customers even set dummy default values for parameters so they can recognize immediately when a parameter has not been initialized by the calling test. The next step is to move those variables from the Procedure call either into the Variable definitions section of the Test case node or to put the test data into a Data driver node with a Data table or using an external data source. The usage of variables and parameters is well described in \"Procedures and Packages\". Parameters can also be created automatically, please see \"Parameterizing nodes\". You can find more details about the data driver concept for loading test data from a data source in \"Data-driven testing\".","hash":"sec_bpParam","h1":"Parameterization"},"901":{"id":901,"content":"Working in multiple test suites Up to now you have read about using the modularization and parameterization concept to avoid unnecessary and redundant work in the creation process of your tests. You should have recognized that those concepts will reduce the maintenance efforts of your test suites by changing or updating only one single sequence instead of several ones. But we still do not know how to organize our work for different test engineers or for a very large project with a lot of GUI elements. The answer for an effective working organization comes again from the software development area and it is to use several 'libraries' for different areas and different responsibilities. Importing other test suites into a test suite enables you to follow that encapsulation approach. A typical organization of test suites in your project could look like this:","hash":"sec_bpWork","h1":"Working in multiple test suites"},"902":{"id":902,"content":"Figure 29.1: Structure of multiple test suites Level 0 is the level that contains test steps (i.e. Procedures) which are required for nearly all test cases in your projects. Such test steps could be 'Launch SUT' or 'Perform the login'. Level 1 contains test steps for a specific part of the SUT. For the CarConfigurator you can think about a test suite 'Vehicles' containing Procedures like 'Create a vehicle', 'Remove a vehicle' and another test suite 'Accessories', which contains Procedures like 'Create an accessory' or 'Remove an accessory'. Level 2 is the test case level. It contains Test cases and Test sets for the respective area of your software, e.g. 'Tests for vehicle creation' or 'Tests for accessory creation'. Of course you could also have a test suite like 'Integration tests' which refers to test steps from different test suites at level 1 and level 0. Level 3 is the so called scenario level. Those test suites usually just contain Test calls to level 2 and stand for different scenarios within your test project, e.g. 'Nightly test scenario', 'Defect verification scenario' or 'Quick-test build verification'. The structure described in this document is of course just one possible solution for handling test suites in a project and is not a strict rule you have to follow. You could also think about splitting level 1 into a GUI-element level and a workflow level or merge level 2 and level 3 to one level. Which structure you finally implement also depends on the experience and knowledge of the test-engineers working in your project. The including area of level 1 test suites looks like this:","hash":"fig_advBpLibs","h4":"Figure 29.1: Structure of multiple test suites"},"903":{"id":903,"content":"Figure 29.2: Including test suites of level 1 You can find a detailed description of how to include test suites in \"Referencing nodes in another test suite\" and \"Include file resolution\". In \"Extending test suites\" you can find a step-by-step description how to extend an already existing test suite and in \"Component storage\" you can find strategies of handling components in such a scenario.","hash":"fig_advBpIncludes","h4":"Figure 29.2: Including test suites of level 1"},"904":{"id":904,"content":"Roles and responsibilities If you take a closer look at the organization shown in the previous section \"Working in multiple test suites\" you may recognize that it is also possible to organize your test suites based on different knowledge levels of test engineers.","hash":"sec_bpRoles","h1":"Roles and responsibilities"},"905":{"id":905,"content":"Figure 29.3: Structure of different test suites with roles Level 0 and level 1 require a good knowledge in working with QF‑Test but not a deep knowledge of the SUT. On the other hand level 2 and level 3 require a very good knowledge of the SUT and the planned test cases but those engineers usually do not require a very deep knowledge of QF‑Test as long as they just use procedures from level 0 and level 1. Test engineers working in level 0 and level 1 should be capable of implementing scripts or control structures like the Try/Catch concept which enables them to create strong and powerful test libraries. At least the engineers working on level 0, but also recommended for engineers working on level 1, should have a good knowledge about component recognition in QF‑Test. Please see \"Components\", \"Sub-items: Addressing relative to a parent component\" and \"How to achieve robust component recognition\". Even if you are working alone on a project it is strongly recommended to split the tests and procedures into different levels because maintenance will become easier than with everything kept in one huge test suite.","hash":"fig_advBpLibsRoles","h4":"Figure 29.3: Structure of different test suites with roles"},"906":{"id":906,"content":"Managing components at different levels If you follow the approach suggested in the previous section (\"Working in multiple test suites\") you have to define where the components belong. There are two possibilities: Put all components into level 0. Split the components like the procedures into several levels. Storing all components in level 0 is the most simple solution but this could cause you to update level 0 very often, just because one single component in your project changes. You have to assign responsible persons to keep that structure cleanly. In big projects you may consider storing the common components like the login dialog or the main frame menus, that are important for everyone, in level 0. Components specific to a certain area, e.g. a dedicated vehicle dialog, appear only in the test suite that holds the procedures operating on those components. The workflow for moving components between test suites is described in \"Component storage\" and the workflow for extending existing test suites is described in \"Extending test suites\".","hash":"sec_bpTSHandlingComponents","h1":"Managing components at different levels"},"907":{"id":907,"content":"Reverse includes You don't need to care about Dependencies of test suites belonging to a QF‑Test project as described in \"Projects\", because QF‑Test automatically resolves dependent suites. So, if you use the concept of projects, you can skip this chapter. If you work in different test suites in your project you might sometimes want to rename a Procedure or a Test case. If you do that you may encounter some troubles in updating the references to that Procedure or Test case in other test suites. If you want to keep the other files also being updated after renaming such an element you have to maintain the Dependencies attribute of the root node of the library test suite. If you follow the approach described in section \"Working in multiple test suites\", you should ensure that level 0 contains a reverse include to level 1, level 1 should contain one to level 2 and level 2 should contain another one to level 3. A sample from the provided demo test suites is shown in \"Including test suites of level 1\".","hash":"sec_bpRevInclude","h1":"Reverse includes"},"908":{"id":908,"content":"Mobile Manual","hash":"","h0":"Efficient working techniques | QF‑Test Manual"},"909":{"id":909,"content":"Mobile Manual","hash":"home-link","h0":"Efficient working techniques | QF‑Test Manual"},"910":{"id":910,"content":"Efficient working techniques This chapter will help you in optimizing your working techniques and avoid unnecessary steps when working with QF‑Test.","hash":"sec_bpEffectiveWork","h0":"Efficient working techniques"},"911":{"id":911,"content":"Using QF‑Test projects The previous chapter describes the creation of several test suites. As you can image the amount of test suites will increase over time. You can get a better overview over them using a QF‑Test project. QF‑Test projects show all involved test suites in a very nice way. Furthermore projects automatically take care of propagating modifications to referring test suites. You can find more information about projects at \"Projects\".","hash":"sec_bpUseProjects","h1":"Using QF‑Test projects"},"912":{"id":912,"content":"Creating test suites from scratch In the previous chapter we described the concept of creating maintainable test suites by utilizing procedures and variables within QF‑Test. Normally people start recording very long sequences and splitting those into smaller parts or even procedures later. It is very hard to split up long sequences as you have really to walk through the whole one to find proper boundaries. Another disadvantage is that you cannot see parts which have already been implemented in existing test cases or procedures. Instead of that described workflow we recommend to plan the tests and their test steps including procedures first. Then you can start recording procedure by procedure. We came to the conclusion that anticipatory recording and creation is very helpful especially for working in bigger teams. A typical workflow for creating those procedures looks like this: Plan the required procedures first. Also plan the required package structure first. Record every procedure as a separate sequence. Rename the recorded sequence like the procedure should be called. Transform the recorded sequence into a Procedure, using the »Transform node into...« action from the context-menu of QF‑Test. Move the Procedure to the correct location. Replace test data with variables, either manually or by using the parameterizer (see \"Parameterizing nodes\") Add the variables to the Variable definitions of the Procedure node, possibly specifying default values. Describe the procedure in its Comment attribute, see \"Documenting test suites\". An alternative approach of creating procedures is the automated creation provided by QF‑Test. This concept is described in \"Automated Creation of Basic Procedures\".","hash":"sec_bpRecording","h1":"Creating test suites from scratch"},"913":{"id":913,"content":"The standard library qfs.qft QF‑Test provides the standard library qfs.qft which is included per default in every test suite. This suite contains many useful procedures for accessing components, the file system or a database. Please take a look at that library before you begin implementing something that has already been solved by us.","hash":"sec_bpStandardLibrary","h1":"The standard library qfs.qft"},"914":{"id":914,"content":"Component storage QF‑Test records new components in the test suite where you press the 'Stop recording' button. Therefore it could happen that you record components in the wrong test suite. If you want to move those components into another test suite you must always use »File«-»Import« from the target suite. Take care to ensure that both suites belong to the same project or to specify correct 'Include files'/'Dependencies relations in those test suites. This workflow is described in detail in \"Managing Components\". For cleaning your component structure in a test suite you can first import the test suite into itself. Then you can select the Windows and components step, open the context menu via a right mouse-click and click at »Mark unused components...«. You will get a list of all components which are not used in the project. If you are sure that those components can be removed, then select the »Remove unused components« in the context menu of the Windows and components step. As soon as a Component's comment contains any text it is considered used, even if it has no references.","hash":"sec_bpWorkWithComponents","h1":"Component storage"},"915":{"id":915,"content":"Extending test suites Several workflows can be followed to extend existing test suites: Simply record and extend the target test suite directly. Work with a scratch suite as described in \"Distributed test development\". If you extend testsuites directly via clicking at 'Stop recording' in that suite, then you have to care about the recorded components. In case you have changed the recorded component hierarchy under Windows and components the newly recorded components will be recorded in the normal hierarchy again and you have to move the new components to the optimized hierarchy. Another aspect is that it could become very difficult for moving single components into another test suite under the right location there. If you work in a scratch suite you can create the new test steps temporarily in a completely new test suite and import the recorded components and the created procedures and test cases into the target suites together. A detailed workflow for extending a test suite from level 1 (from \"Working in multiple test suites\") could look as follows: Create a new test suite. Add the test suite to be extended to the Include files area of the new one. Save the new test suite. Ensure that both test suites belong to the same project or add the new test suite to the Dependencies area of the test suite to extend. Record the new test steps in the scratch suite. Also create Procedures, if required. Then import the components, procedures and tests into the target test suite as described in \"Component storage\" and \"Merging test suites\". A more detailed description of working in multiple test suite can be found in \"Distributed test development\".","hash":"sec_bpExtendingSuites","h1":"Extending test suites"},"916":{"id":916,"content":"Working in the script editor The script editor of QF‑Test contains some fancy features to avoid too much typing actions. If you want to call methods of the run context rc, you can simply type rc. and press Ctrl⁠+⁠Space, then you will get a list of all available methods. The autocompletion is also working for several variable names, which are:","hash":"sec_bpScripting","h1":"Working in the script editor"},"917":{"id":917,"content":"Variables Methods doc Methods of a DocumentNode. frame Methods of a FrameNode. iw Methods of the ImageWrapper. node Methods of a DOMNode. Options The keys and values of QF‑Test options to set. qf Methods of the qf module. rc Methods of the Run context. resolvers Methods of the Resolvers module. Just press Ctrl⁠+⁠Space without typing anything A list of all variables with autocompletion. Table 30.1: List of variables with autocompletion.","hash":"table_30.1","h1":"Working in the script editor"},"918":{"id":918,"content":"Mobile Manual","hash":"","h0":"Hints on setting up test systems | QF‑Test Manual"},"919":{"id":919,"content":"Mobile Manual","hash":"home-link","h0":"Hints on setting up test systems | QF‑Test Manual"},"920":{"id":920,"content":"Hints on setting up test systems This chapter provides some hints how to set up your test systems and processes in order to get a stable test execution.","hash":"sec_bpTestsyssetup","h0":"Hints on setting up test systems"},"921":{"id":921,"content":"Using the task scheduler In order to execute tests or similar processes on a regular basis it is very common to set up a Windows service. Unfortunately those services have the disadvantage that they don't run in an active Windows user session. Because of this such processes should never be started as services, because running GUI tests without an active user session brings up very subtle problems during test execution. You can find further technical details at FAQ 14. We recommend to define a scheduled task via the task scheduler instead of using services. This can be directly applied via the graphical UI of the task scheduler. The following instruction should work on Windows computers. Depending on the version, there might be slight differences: Start the Windows Task scheduler via 'System Control Panel' -> 'Administrative Tools' -> 'Task Scheduler'. Click \"Create Task\" on the right. At the \"General\" tab define a \"Name\", e.g. QF‑Test. Now click at the \"Change User or Group\" button and select the user for the session which should be used to run QF‑Test. Do not use the System- or Service session but a real user session. Press OK to close the dialog. Now select \"Run only when user is logged in\". Do not select \"Run with highest privileges\". Choose the correct Windows version for your task. Now select the \"Triggers\" tab. Click \"New..\" and define the desired time/trigger at \"Begin the task\". Click \"OK\" to close. Now select the \"Actions\" tab, click at \"New.\" and specify \"Start a program\" as \"Action\" and \"Browse\" to the .cmd or .bat file you've just created. Press \"OK\" to close this dialog. You can now have a look at the \"Conditions\" and \"Settings\" tab if you need anything else from your side. If you have finished the setup press \"OK\" and the task has been created. It is very important that the user which is configured to run that process is logged in correctly. This user can be logged in manually or automatically (see \"Automated logon on Windows systems\"). It is recommended to use a virtual system for running GUI tests. On such virtual systems the user needs to be logged in only on the guest system and the host can be locked.","hash":"sec_bpTaskScheduler","h1":"Using the task scheduler"},"922":{"id":922,"content":"Remote access to Windows systems Accessing remote Windows systems via RDP is subject to some restrictions and requires a dedicated configuration of your systems. That's because the implemented RDP server of Windows desktop versions allows only one active user. Thus the (virtual) monitor will be locked as soon as you access the system via RDP. After closing the RDP session the monitor of the test system remains locked. Usually you cannot use a graphical user interface at a locked screen, thus you cannot test it, too. On Windows 10 or Windows Server 2016 systems you can make use of RDP if you modify the Registry. Therefore navigate to HKEY_CURRENT_USER\\Software\\Microsoft\\Terminal Server Client or HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Terminal Server Client and add a new value RemoteDesktop_SuppressWhenMinimized as DWORD having the value 2. Once that setting has been set you are allowed to minimize RDP connections, but you have to keep the connection alive. The tests will still fail if you disconnect or close the session. Instead of this approach you should use the capabilities your virtual server provides. For VMware server the vSphere client would be the first choice. With VirtualBox you can connect to VirtualBox with RDP (not with the Windows client). Of course this kind of RDP connection has not the impacts on the test system as explained above.","hash":"sec_bpRemoteAccess","h1":"Remote access to Windows systems"},"923":{"id":923,"content":"Automated logon on Windows systems A simple possibility to get an active user session is to logon a test user automatically after start-up of your system. This chapter describes how to configure your system for that purpose. An automatic logon at Windows is always a security risk. Therefore you have to ensure that the corresponding test systems are not accessible from outside the test environment. Although this guidance is generally valid it will be used commonly together with virtual systems which will be accessed remotely. What to keep in mind for this remote access will be explained at \"Remote access to Windows systems\". The following method is running with Windows 7, Windows 8, Windows 8.1 and Windows 10. There might be a few differences depending on the exact operation system: Start the command line interface with administrator privileges. Enter control userpasswords2. Now the dialog 'User Accounts' appears. Remove the check at the checkbox 'Users must enter user name and password'. In the next appearing dialog ('Automatic Logon') enter the user password twice. Click the 'Ok' button to finish the configuration. Of course also other methods exist to get the same result. Thus you could modify the corresponding registry entry directly. Or you could download the 'Autologon' tool from Microsoft from https://technet.microsoft.com/en-us/sysinternals/bb963905. But all those different methods lead to the same result, which is the modified registry entry. We recommend to use the method explained above as in this way no download is needed and a type mismatch in the registry entry is avoided. By the way, an automated logon will never run for domain users. In fact this would be quite awkward in conjunction with test system. This may be an information which may calm your administrators down.","hash":"sec_bpAutoLogonWin","h1":"Automated logon on Windows systems"},"924":{"id":924,"content":"Test execution on Linux On Linux systems you can set up virtual displays using tools like VNC server. A very useful window manager for those displays could be xfce.","hash":"sec_bpLinux","h1":"Test execution on Linux"},"925":{"id":925,"content":"Mobile Manual","hash":"","h0":"Test execution | QF‑Test Manual"},"926":{"id":926,"content":"Mobile Manual","hash":"home-link","h0":"Test execution | QF‑Test Manual"},"927":{"id":927,"content":"Test execution This chapter gives some hints about how to implement your tests to get stable and reliable test execution.","hash":"sec_bpTestExec","h0":"Test execution"},"928":{"id":928,"content":"Dependencies The 'Dependencies' concept of QF‑Test provides functionality to guarantee that all prerequisites for a test case are fulfilled before running it. It is also capable of reacting to unexpected behavior, e.g. closing an error dialog, which pops up and blocks your tests. The concept is described in \"Dependencies\" and a use case can be found in the tutorial in the chapter 'Dependencies'. You should at least implement a Dependency which is responsible for launching the SUT, containing a Setup for launching, a Cleanup for a normal exit and a Catch to react on any unexpected behavior. If you implement a Cleanup, try to close the SUT normally first and only if the SUT does not terminate correctly, kill it via Stop client. For SWING and SWT applications please use the procedures qfs.cleanup.swing.closeAllModalDialogs and qfs.cleanup.swt.closeAllModalDialogsAndShells from the standard library qfs.qft for closing unexpected error dialogs.","hash":"sec_bpDependencies","h1":"Dependencies"},"929":{"id":929,"content":"Timeout vs. delay Instead of using the 'Delay before' and 'Delay after' attributes you should try to use QF‑Test's synchronization nodes to optimize test execution time. The first kind of synchronization nodes are the 'waiter' nodes like Wait for component to appear, Wait for client to connect, Wait for document to load and Wait for process to terminate. You can specify the Timeout attribute to wait for a component, process or document. The Wait for component to appear node even provides the functionality to wait for the absence of a component. The second kind are the 'check' nodes which allow you to specify the Timeout attribute as well. Those nodes can be used to continue the test when a GUI element of your SUT has reached a defined state.","hash":"sec_bpTimeoutDelay","h1":"Timeout vs. delay"},"930":{"id":930,"content":"What to do if the run log contains an error If the test report contains an error message or exceptions, the following steps should be performed to find the source of that failure very fast: Analyze the run log, especially the screenshots and any other messages. If you cannot find the cause immediately, jump to the failing location in your test suite by typing Ctrl⁠+⁠T in the run log. Set a breakpoint before or at the failing step. Ensure that the debugger of QF‑Test is enabled. Run the failing test. When QF‑Test reaches the breakpoint and stops, open the debugger window and check the active variable bindings to wee whether they contain any wrong values. Perhaps at that time you can also see the error immediately in your SUT. If you cannot see any source of that error, run the failing step. If you still encounter errors you might have to re-debug some steps executed before the failing step. Use the 'Continue execution from here' menu entry to jump to previous steps instead of rerunning the whole test again. Since QF‑Test version 3.1 it is possible to mark nodes via the context menu item »Set mark« or setting bookmarks for specific nodes via the menu item »Add bookmark«. These features enable you to find important nodes very fast again. If you encounter problems with component recognition, please see \"Troubleshooting component recognition problems\" and \"How to achieve robust component recognition\".","hash":"sec_bpWhatonErrors","h1":"What to do if the run log contains an error"},"931":{"id":931,"content":"Mobile Manual","hash":"","h0":"Reference manual | QF‑Test Manual"},"932":{"id":932,"content":"Mobile Manual","hash":"home-link","h0":"Reference manual | QF‑Test Manual"},"933":{"id":933,"content":"Reference manual","hash":"sec_reference","h1":"Reference manual"},"934":{"id":934,"content":"Mobile Manual","hash":"","h0":"Options | QF‑Test Manual"},"935":{"id":935,"content":"Mobile Manual","hash":"home-link","h0":"Options | QF‑Test Manual"},"936":{"id":936,"content":"Options Since QF‑Test is a tool that is intended for a wide range of applications, the \"one size fits all\" approach doesn't quite work. That's why QF‑Test has a great number of options that control its functionality. There are two kinds of options for QF‑Test: user options and system options. User options adjust the behavior of QF‑Test's own GUI while system options influence how tests are recorded and replayed. Each user has its own set of user options whereas system options are saved in a common system file. See \"The configuration files\" for details about configuration files. Many options can have their value changed at run time from a script via rc.setOption as described in \"The rc module: Run context API\". Depending on whether the option takes effect in QF‑Test itself or in the SUT, the documentation for those options shows a \"Server script name\" or \"SUT script name\" matching the constant from the Options class. Obviously the option has to be set in a matching Server script or SUT script node. Where the option's value can be selected from a drop-down list, the documentation also lists the constants that can be specified as the option's value. Though the number of options may look daunting, don't let yourself be deterred by it. All options have reasonable default values, so QF‑Test works well out of the box for most cases. However, if you find you need to change something or simply want to explore the range of QF‑Test's abilities, this chapter is for you. The options can be set in the dialog available through the menu item »Edit«-»Options...«. The settings are saved in two configuration files, one for personal settings and one for system-wide settings (see \"The configuration files\").","hash":"sec_options","h0":"Options"},"937":{"id":937,"content":"Figure 33.1: Options tree To get at an option, first select the appropriate node of the tree. The options for that topic are then displayed in the right part of the view. When switching from one group to the other, the current values are verified but not adopted yet. This happens only after confirmation with the OK button.","hash":"figure_33.1","h4":"Figure 33.1: Options tree"},"938":{"id":938,"content":"Mobile Manual","hash":"","h0":"General options | QF‑Test Manual"},"939":{"id":939,"content":"Mobile Manual","hash":"home-link","h0":"General options | QF‑Test Manual"},"940":{"id":940,"content":"General options This is the node for general QF‑Test settings.","hash":"sec_opt_general","h0":"General options"},"941":{"id":941,"content":"Figure 33.2: General options","hash":"figure_33.2","h4":"Figure 33.2: General options"},"942":{"id":942,"content":"Ask before closing (User) When a test suite or a test run log has been modified, QF‑Test asks whether it should be saved before it closes its main window. That query can be suppressed by turning off this option. Be warned that auto saving is not implemented yet, so you may lose data if you forget to save before closing.","hash":"opt_asksave","hp":"General options","h4":"Ask before closing (User)"},"943":{"id":943,"content":"Ask before overwriting (User) When you try to save a test suite or a run log or generate a report, pgkdoc or testdoc or save the image of a Check image over an existing file or directory, QF‑Test asks for confirmation unless you turn off the option for the respective type of file.","hash":"opt_askoverwrite","hp":"General options","h4":"Ask before overwriting (User)"},"944":{"id":944,"content":"Restore last session on startup (User) If this option is set and QF‑Test is opened in the workbench view, the previous session is restored by loading previously opened test suites and selecting the previously selected node in each suite. If one or more test suites are specified on the command line, this are loaded in addition to the previous session and receive the initial focus on startup.","hash":"opt_restoresession","hp":"General options","h4":"Restore last session on startup (User)"},"945":{"id":945,"content":"Number of recent files in menu (User) The »File« menu offers quick access to recently used test suites or run logs. This option determines the maximum number of recent file entries in the menu.","hash":"opt_numrecentfiles","hp":"General options","h4":"Number of recent files in menu (User)"},"946":{"id":946,"content":"Default script language for script nodes (User) This option can be set to either \"Jython\", \"Groovy\" or \"JavaScript\" and determines the default setting for the Script language attribute of newly created Server script or SUT script nodes.","hash":"opt_defaultscriptlanguage","hp":"General options","h4":"Default script language for script nodes (User)"},"947":{"id":947,"content":"Default script language for conditions (User) This option can be set to either \"Jython\", \"Groovy\" or \"JavaScript\" and determines the default setting for the Script language attribute of newly created If, Elseif, While, Test set or Test step nodes.","hash":"opt_defaultconditionlanguage","hp":"General options","h4":"Default script language for conditions (User)"},"948":{"id":948,"content":"Literal Jython strings are unicode (16-bit as in Java) (System) Server (automatically forwarded to SUT) script name: OPT_JYTHON_UNICODE_LITERALS This option defines how to treat literal strings (explicitly specified string constants like \"abc\") in Jython scripts in Server script and SUT script nodes, Condition attributes in If and other nodes as well as the interactive Jython consoles for QF‑Test and the SUT. If set, it defines that literal Jython strings should be treated as 16-bit unicode strings, just like in Java itself. Otherwise literal strings are 8-bit Python 2 strings that don't integrate well with Java and thus QF‑Test. Please see \"Jython strings and character encodings\" for detailed information and examples. If QF‑Test encounters an existing older system configuration, the default value in QF‑Test is off, meaning 8-bit literal strings. For new installations the option is turned on.","hash":"opt_jythonunicodeliterals","hp":"General options","h4":"Literal Jython strings are unicode (16-bit as in Java) (System)"},"949":{"id":949,"content":"Default character encoding for Jython (System) Server (automatically forwarded to SUT) script name: OPT_JYTHON_DEFAULT_ENCODING This option defines the default encoding for converting between Jython 16-bit unicode strings and 8-bit byte strings. It applies to explicit conversions like str(...) and to implicit conversions. If the previous option Literal Jython strings are unicode (16-bit as in Java) is unset, implicit conversions include all occurrences of literal Jython strings (explicitly specified string constants like \"abc\"). Please see \"Jython strings and character encodings\" for detailed information and examples. Starting with QF‑Test 5.3 the default value is \"utf-8\" (it used to be \"latin-1\"). Existing system configurations are not be affected by that change.","hash":"opt_defaultjythonencoding","hp":"General options","h4":"Default character encoding for Jython (System)"},"950":{"id":950,"content":"Use native file chooser on Windows or macOS systems (User) Server script name: OPT_USE_NATIVE_FILECHOOSER On Windows or macOS systems the native file chooser is more advanced and more convenient to use than the Swing file chooser so QF‑Test uses the native one by default. In case you prefer the Swing file chooser you can get it back by deactivating this option.","hash":"opt_usenativefilechooser","hp":"General options","h4":"Use native file chooser on Windows or macOS systems (User)"},"951":{"id":951,"content":"Show complete file path and QF‑Test version in the title bar (User) If set, QF‑Test shows the full path of the current test suite and the QF‑Test version in the title bar of the main window.","hash":"opt_showsuitefullpath","hp":"General options","h4":"Show complete file path and QF‑Test version in the title bar (User)"},"952":{"id":952,"content":"Project settings There are several options that influence the way QF‑Test manages and displays projects.","hash":"sec_opt_projects","h1":"Project settings"},"953":{"id":953,"content":"Figure 33.3: Projects","hash":"figure_33.3","h4":"Figure 33.3: Projects"},"954":{"id":954,"content":"Project refresh interval (s) (User) The interval at which a project automatically gets completely refreshed. You can refresh a directory at any time by selecting it and pressing F5. To refresh the complete hierarchy below the selected directory, press Shift⁠+⁠F5 instead.","hash":"opt_projectrefreshinterval","hp":"Project settings","h4":"Project refresh interval (s) (User)"},"955":{"id":955,"content":"Number of test suites to open in one go without warning (User) From the project tree you can open all test suites contained in one directory hierarchy in one go. If you accidentally select too many test suites, QF‑Test will first issue a warning with the number of test suites, allowing you to cancel that action. This option determines the threshold for that warning.","hash":"opt_projectmaxsuitestoopen","hp":"Project settings","h4":"Number of test suites to open in one go without warning (User)"},"956":{"id":956,"content":"Project files and directories to exclude (System) In many cases a directory hierarchy holds files and directories that don't really belong to a project, most notably subdirectories created by version control systems like git, subversion or cvs. In this option you can specify patterns for files and directories to generally exclude from projects. The patterns used here are not regular expressions but a simpler form often used by development tools: An '*' stands for any number of characters up to the next file separator - for compatibility reasons only forward '/' is used - while '**' means 0 or more characters of any kind, including '/'. Every pattern is relative to the root directory of the project. Some examples: **/.svn All directories named .svn at any depth. **/.* All directories starting with a '.' at any depth. deprecated A directory named deprecated directly below the project root.","hash":"opt_projectexcludes","hp":"Project settings","h4":"Project files and directories to exclude (System)"},"957":{"id":957,"content":"Saving test suites The following options specify the format for saving test suites as XML files. The format for saving run logs is determined by the option Save run log in current XML format with UTF-8 encoding. Regardless of the chosen XML format, test suites and run logs can also be opened with QF‑Test versions older than 7.0 (although node types introduced later are obviously not recognized). Saving with an old QF‑Test version always causes the old XML format to be used.","hash":"sec_opt_testsuites","h1":"Saving test suites"},"958":{"id":958,"content":"Figure 33.4: Saving test suites","hash":"figure_33.4","h4":"Figure 33.4: Saving test suites"},"959":{"id":959,"content":"Overwrite XML format of existing test suites (System) Changing the XML file format can lead to a lot of purely syntactical changes the next time a test suite gets saved. These changes will show up in version control and possibly hide the real semantic changes. To avoid this, the XML format defined in these options only applies to new files by default. QF‑Test will not change the format of already existing test suites unless this option is activated. Changing the XML format should be a project-wide decision and ideally performed in one go with all files checked into version control as a single commit with no other changes. Conversion can easily be done using QF‑Test in batch mode with the -convertxml command line argument as described in \"Call syntax\".","hash":"opt_xmlsuiteoverwrite","hp":"Saving test suites","h4":"Overwrite XML format of existing test suites (System)"},"960":{"id":960,"content":"Use UTF-8 encoding for saving test suites (System) If this option is active (the default), test suites are saved using UTF-8 encoding. Otherwise the encoding is ISO-8859-1. QF‑Test versions older than 7.0 always use ISO-8859-1 encoding.","hash":"opt_xmlsuiteutf8","hp":"Saving test suites","h4":"Use UTF-8 encoding for saving test suites (System)"},"961":{"id":961,"content":"Number of blanks for indentation when saving test suites (System) XML files that use indentation are easier for humans to read. However, test suites are mostly processed by QF‑Test and the only time a typical QF‑Test user need to work at that level is when resolving merge conflicts. The latter are reduced by using an indentation level of 0, the new default, because otherwise all lines in the XML will change for nodes that are wrapped into or moved out of a parent node. QF‑Test versions older than 7.0 always use 2 characters for indentation.","hash":"opt_xmlsuiteindent","hp":"Saving test suites","h4":"Number of blanks for indentation when saving test suites (System)"},"962":{"id":962,"content":"Line length for saving test suites (System) The only lines in test suite XML files that can safely be wrapped are those containing attributes of XML nodes. Wrapping actual text, e.g. from scripts or comment attributes would change its meaning so this option does not impose a hard limit for line length. Unfortunately there is no ideal default value for this option. The current default of 160 is a compromise between the following two extremes: A negative or extremely large value results in practically unlimited line length, enough to always keep all attributes of an XML node on a single line. This is both compact and good for merging because attribute changes are kept on a single line that also includes the - typically unique - ID of the node. The value 0 introduces a special format that causes each attribute and even the closing > character to be written on its own line. As a result, line-based version control tools like git blame can show the most recent change of each individual attribute whereas for a long line only the most recently changed attribute is shown. Also, it is easier to interpret the changes in diffs between two versions of an XML file. The downside of this mode is that the context of a change - typically 3 lines - might not include the ID attribute which increases the chance of an incorrect merge. QF‑Test versions older than 7.0 always use a line length of 78 characters.","hash":"opt_xmlsuitelinelength","hp":"Saving test suites","h4":"Line length for saving test suites (System)"},"963":{"id":963,"content":"Display The following options specify the display of the test suite tree and its nodes.","hash":"sec_opt_treeview","h1":"Display"},"964":{"id":964,"content":"Figure 33.5: Display","hash":"figure_33.5","h4":"Figure 33.5: Display"},"965":{"id":965,"content":"UI theme (User) This option determines which QF‑Test UI theme to use. There is a shortcut for changing this option via the menu »View«-»UI theme«.","hash":"opt_uithemename","hp":"Display","h4":"UI theme (User)"},"966":{"id":966,"content":"UI mode - light or dark (User) This option determines whether the current QF‑Test UI theme is displayed in light or in dark mode. The default setting is to follow the setting of the underlying operating system. There is a shortcut for changing this option via the menu »View«-»UI theme«.","hash":"opt_uitheme","hp":"Display","h4":"UI mode - light or dark (User)"},"967":{"id":967,"content":"Paint lines in trees (User) The option controls whether to display vertical lines between tree nodes of the same indentation.","hash":"opt_treepaintlines","hp":"Display","h4":"Paint lines in trees (User)"},"968":{"id":968,"content":"Syntax highlighting for tree nodes (User) This option controls activation of syntax highlighting for tree nodes within test suites and run logs. If active, specific text parts of nodes (e.g. node name, parameters, client) are outlined in different colors and styles. This significantly improves readability.","hash":"opt_treenodesyntaxhigh","hp":"Display","h4":"Syntax highlighting for tree nodes (User)"},"969":{"id":969,"content":"Show step types for named tree nodes (User) If this option is deactivated, labels like \"Test case\" are hidden in tree nodes of test suites and run logs provided the respective node has a name and its icon is unique.","hash":"opt_treeshowprefix","hp":"Display","h4":"Show step types for named tree nodes (User)"},"970":{"id":970,"content":"Show script language for script nodes (User) When you activate the option the script language of a Server script or SUT script node will be displayed in the test suite tree.","hash":"opt_treeshowscriptlanguage","hp":"Display","h4":"Show script language for script nodes (User)"},"971":{"id":971,"content":"Show result variables (User) When you activate the option the name of the result variable will be shown in the tree nodes of the test suite and the run log.","hash":"opt_treeshowresultvariable","hp":"Display","h4":"Show result variables (User)"},"972":{"id":972,"content":"Show result values (User) When you activate the option the value of the result variable will be shown in the node of the run log tree. The option Maximum length for values in trees determines the maximum length of the value displayed.","hash":"opt_treeshowresultvalues","hp":"Display","h4":"Show result values (User)"},"973":{"id":973,"content":"Show client name in tree (User) Use the option to display the name of the client the node relates to in the test suite tree, either \"Always\" or \"Never\" or only when the value of the Client attribute is not the default value $(client).","hash":"opt_treeshowclient","hp":"Display","h4":"Show client name in tree (User)"},"974":{"id":974,"content":"Show class or type of components (User) This options determines what to show for a Component node in the tree: Its primary class, its specific type or both. A typical example would be just 'Panel', just 'TitledPanel' or the combination of 'Panel:TitledPanel'.","hash":"opt_treeshowclassortype","hp":"Display","h4":"Show class or type of components (User)"},"975":{"id":975,"content":"Maximum length for values in trees (User) The option is only relevant when Show result values has been activated. It determines the maximum length of the result value displayed in a test suite tree node.","hash":"opt_treemaxvaluelength","hp":"Display","h4":"Maximum length for values in trees (User)"},"976":{"id":976,"content":"Maximum length for component IDs in trees (User) The option determines the maximum lenght of the QF‑Test component ID displayed in the tree node.","hash":"opt_treemaxcomponentidlength","hp":"Display","h4":"Maximum length for component IDs in trees (User)"},"977":{"id":977,"content":"Font size (pt) (User) This option specifies the font size (as point value) used for display of UI elements within QF‑Test. A change in this value becomes operative after restarting QF‑Test.","hash":"opt_minfontsize","hp":"Display","h4":"Font size (pt) (User)"},"978":{"id":978,"content":"Show symbols for tab and line break characters (User) If this option is set, QF‑Test shows symbols for tabulator and linebreaks in tables and relevant textareas.","hash":"opt_editshowwhitespaces","hp":"Display","h4":"Show symbols for tab and line break characters (User)"},"979":{"id":979,"content":"Editing These options are used to configure various settings regarding editing in the tree or detail view.","hash":"sec_opt_editing","h1":"Editing"},"980":{"id":980,"content":"Figure 33.6: Editing","hash":"figure_33.6","h4":"Figure 33.6: Editing"},"981":{"id":981,"content":"Warn when modifying a test suite that cannot be saved (User) If saving test suites is prohibited, for example when working without a license, QF‑Test will warn you that you will not be able to save your changes when a test suite is modified for the first time. Deactivating this option suppresses that warning.","hash":"opt_warnonmodify","hp":"Editing","h4":"Warn when modifying a test suite that cannot be saved (User)"},"982":{"id":982,"content":"Ask before discarding detail modifications (User) When you have started making changes to an existing or newly inserted node and then abort by pressing Escape or clicking the \"Cancel\" button, QF‑Test asks for confirmation before discard your modifications. This dialog can be suppressed by disabling this option. In this case, please be aware that - especially in case of scripts - a lot of work may get lost in case of a mistake.","hash":"opt_askdiscard","hp":"Editing","h4":"Ask before discarding detail modifications (User)"},"983":{"id":983,"content":"Ask before implicitly accepting detail modifications (User) As described in \"Basic editing\", this option defines how strictly QF‑Test will enforce the validity of attributes during editing. If you modify attributes and move the focus away from the current node without committing the changes first, QF‑Test can either accept the modified values automatically or ask for confirmation by popping up a modal dialog that shows the modified attributes and enforces a decision before moving on. The following settings are available: Always Don’t accept values implicitly; always ask for confirmation. Only if values are suspect or invalid Try to accept values implicitly as long as they are valid and not suspect. Currently \"being suspect\" is defined as having leading or trailing whitespace, which can lead to subtle issues that are very difficult to track down. Never Accept all values, even invalid ones. This option doesn’t change the effect of explicitly discarding your modifications by clicking the Cancel button or pressing Escape.","hash":"opt_askaccept","hp":"Editing","h4":"Ask before implicitly accepting detail modifications (User)"},"984":{"id":984,"content":"Show \"OK\" and \"Cancel\" buttons (User) Use of the OK and Cancel buttons is optional, and they can be removed from the UI via this option. The keyboard shortcuts Return or Ctrl⁠+⁠Return can be used to commit changes, and Escape can be used to discard them.","hash":"opt_showokcancel","hp":"Editing","h4":"Show \"OK\" and \"Cancel\" buttons (User)"},"985":{"id":985,"content":"Highlight invalid attributes while typing (User) Invalid attribute values are highlighted with a reddish background color. This option determines whether the highlighting is continuously updated on every keystroke or only when focus leaves the field.","hash":"opt_highlightwhileediting","hp":"Editing","h4":"Highlight invalid attributes while typing (User)"},"986":{"id":986,"content":"Number of undo levels per suite (User) This option lets you set the number of edits that can be undone in a test suite or run log.","hash":"opt_undolimit","hp":"Editing","h4":"Number of undo levels per suite (User)"},"987":{"id":987,"content":"Intelligent scrolling in trees (User) The default methods for interacting with Swing trees are not ideal. Moving the selection around causes a log of unnecessary horizontal scrolling and Swing has the tendency to scroll trees to a position where little context is visible around the selected node. Because tree navigation is essential for QF‑Test, some of these methods are implemented differently to provide a more natural interface and to make sure that there is always enough context visible around the selected node. However, your mileage may vary, so if you don't like the alternative methods you can switch back to the default Swing way of things by deactivating this option.","hash":"opt_intelligentscroll","hp":"Editing","h4":"Intelligent scrolling in trees (User)"},"988":{"id":988,"content":"Check references before deletion (User) If this option is set, QF‑Test searches for references of nodes before nodes will be deleted. If references can be found, they will be shown in a dialog.","hash":"opt_checkreferences","hp":"Editing","h4":"Check references before deletion (User)"},"989":{"id":989,"content":"Ask after changing QF‑Test component IDs or use default (User) If this option is set, QF‑Test asks whether the user wants to update the QF‑Test component IDs of any referring node after the QF‑Test ID of a component has been changed. If this option isn't set QF‑Test updates all references in case of unique QF‑Test component IDs.","hash":"opt_askforcomponentidupdate","hp":"Editing","h4":"Ask after changing QF‑Test component IDs or use default (User)"},"990":{"id":990,"content":"Ask after changing callable names or use default (User) If this option is set, QF‑Test asks whether the user wants to update the callable names (i.e. procedures, packages, tests and dependencies) of any referring node after the name of a callable node has been changed. If this option isn't set QF‑Test updates all references in case of unique names.","hash":"opt_askforcallableidupdate","hp":"Editing","h4":"Ask after changing callable names or use default (User)"},"991":{"id":991,"content":"Check if configuration files are writable (User) If this option is set, QF‑Test checks whether the configuration files have writing permissions once opening the 'Options' dialog. If one configuration file has no writing privileges, QF‑Test will show a message.","hash":"opt_askifoptionshavenopermissions","hp":"Editing","h4":"Check if configuration files are writable (User)"},"992":{"id":992,"content":"Automatically open created nodes (User) Automatically open nodes that just have been created.","hash":"opt_autoopennodesoncreation","hp":"Editing","h4":"Automatically open created nodes (User)"},"993":{"id":993,"content":"Activate workbench view (User) If this option is set, all test suites are displayed in one window - the workbench. Working without workbench with each test suite in its own window was deprecated in QF‑Test version 8.0.","hash":"opt_workbenchview","hp":"Editing","h4":"Activate workbench view (User)"},"994":{"id":994,"content":"Bookmarks Here you can edit your bookmarks, a list of files and nodes that can be accessed quickly via the menu »File«-»Bookmarks«. Instead of a file you can also specify a directory. When the respective bookmark is selected, the file selection dialog is opened directly for this directory. The QF‑Test ID for the node is ignored in this case.","hash":"sec_opt_bookmarks","h1":"Bookmarks"},"995":{"id":995,"content":"Figure 33.7: Bookmarks Though you can also create new bookmarks manually, it is preferable to use the menu item »File«-»Bookmarks«-»Add current file«to add a bookmark for a whole test suite or run log or to select »Add to bookmarks« in the context menu of a node in a test suite to add a bookmark for this specific node.","hash":"figure_33.7","h4":"Figure 33.7: Bookmarks"},"996":{"id":996,"content":"External tools The following options determine which external programs are called by QF‑Test.","hash":"sec_opt_external","h1":"External tools"},"997":{"id":997,"content":"Figure 33.8: External tools options","hash":"figure_33.8","h4":"Figure 33.8: External tools options"},"998":{"id":998,"content":"External editor command (User) Scripts can be edited in an external editor by pressing Alt⁠+⁠Return or by clicking the button above the text area. The contents of the text area are then saved to a temporary file and the external editor is run to edit that file. It is recommended to define a name for the script before opening it in the external editor (see also Warn when running external editor without file name). Otherwise a random number is chosen as file name, which makes it difficult to distinguish several scripts opened in the external editor. Changes made to an external file are picked up automatically by QF‑Test. Depending on your settings, you may get a warning message when this happens (see Warn when test suite is changed by an external editor). In case you are tempted to edit your script code parallel in the internal QF‑Test editor: These changes are also saved in the temporary file. Editors like jEdit on their part are smart enough to detect the change and reload the file automatically. This option determines the external editor command to use. There are two variants, the plain name of an executable file or a complex command including options. The latter is distinguished by the string $(file) which is the placeholder for the name of the temporary file. Additionally, $(line) may be used to pass the current line number to the editor as well. The $(file)/$(line) syntax is used simply to avoid yet another different convention for variable attributes. No standard QF‑Test $(...) variable expansion is taking place. Plain commands need never be quoted. Examples are: emacsclient notepad C:\\Program Files\\Crimson Editor\\cedt.exe Complex commands on the other hand may need to use quotes, especially on windows. QF‑Test takes care of quoting the $(file) argument itself: \"C:\\Program Files\\eclipse-3.6\\eclipse.exe\" --launcher.openFile $(file) javaw.exe -jar C:\\Programs\\jEdit4.2\\jedit.jar -reuseview $(file) \"C:\\Program Files\\Crimson Editor\\cedt.exe\" $(file) xterm -e vi +$(line) $(file) If this option is left empty, the value of the environment variable EDITOR is used, if it is defined when QF‑Test is started.","hash":"opt_externaleditor","hp":"External tools","h4":"External editor command (User)"},"999":{"id":999,"content":"Directory passed temporary files to external editor (User) This option can be used to change the directory in which QF‑Test saves temporary files for opening in an external editor (see External editor command). If empty, the user configuration directory is used.","hash":"opt_externaleditorfolder","hp":"External tools","h4":"Directory passed temporary files to external editor (User)"},"1000":{"id":1000,"content":"Warn when test suite is changed by an external editor (User) Display a warning message when changes to a script made by an external editor are picked up by QF‑Test (see also External editor command).","hash":"opt_warnonexternaledit","hp":"External tools","h4":"Warn when test suite is changed by an external editor (User)"},"1001":{"id":1001,"content":"Warn when running external editor without file name (User) Display a warning message when a script without name is opened in an external editor (see also External editor command).","hash":"opt_warnonexternaleditnofilename","hp":"External tools","h4":"Warn when running external editor without file name (User)"},"1002":{"id":1002,"content":"External imaging program (User) The Image of a Check image node can be edited in an external imaging program. The image is saved to a temporary PNG file and the external imaging program is run to edit that file. When finished editing, the file must be saved and the program exited. QF‑Test will read the image back from the temporary file. This option determines the program to use for the operation. There are two variants, the plain name of an executable file or a complex command including options. The latter is distinguished by the string $(file) which is the placeholder for the name of the temporary file. The $(file)/$(line) syntax is used simply to avoid yet another different convention for variable attributes. No standard QF‑Test $(...) variable expansion is taking place. Plain commands need never be quoted. Examples are: gimp mspaint C:\\Windows\\System32\\mspaint.exe Complex commands on the other hand may need to use quotes, especially on windows. QF‑Test takes care of quoting the $(file) argument itself: gimp --no-splash $(file) \"C:\\Windows\\System32\\mspaint.exe\" $(file)","hash":"opt_externalimager","hp":"External tools","h4":"External imaging program (User)"},"1003":{"id":1003,"content":"HTML browser (User) This option allows you to set the HTML browser used to open HTML pages (e.g. report files or the context sensitive help). You can specify a complex command using '$url' as placeholder for the URL to show, e.g. netscape -remote openURL($url) or just a simple command like firefox in which case the URL is passed as the last argument. If the option is empty the system browser is used.","hash":"opt_browser","hp":"External tools","h4":"HTML browser (User)"},"1004":{"id":1004,"content":"Backup files Unless told to do otherwise, QF‑Test creates backups of existing files when saving test suites or run logs. These backup files are useful only in protecting against failures when saving a file. They are by no means a replacement for proper system backups. The following options determine if, when and how backup files are created.","hash":"sec_opt_backup","h1":"Backup files"},"1005":{"id":1005,"content":"Figure 33.9: Backup file options","hash":"figure_33.9","h4":"Figure 33.9: Backup file options"},"1006":{"id":1006,"content":"Create backup files for test suites (User) Backup files for test suites are created only if this option is activated. Please be careful and don't turn it off without a good reason, such as using a version control system for test suites which obviates the need to create backups. Just think about the amount of work that goes into creating a useful test suite and imagine the frustration if it gets destroyed accidentally.","hash":"opt_backupsuite","hp":"Backup files","h4":"Create backup files for test suites (User)"},"1007":{"id":1007,"content":"Create backup files for test run logs (User) Usually a run log is far less valuable than a test suite, so there is a separate option that determines whether backups are created for run logs.","hash":"opt_backuplog","hp":"Backup files","h4":"Create backup files for test run logs (User)"},"1008":{"id":1008,"content":"Backup frequency (User) There are two possibilities for the frequency with which backup files are created. With the first option, \"One backup per session\", QF‑Test creates a backup file only the first time a file is saved. If you continue editing the suite or run log and save it again, the backup file is left unchanged. Only when you edit a different file or restart QF‑Test, a new backup is created. This setting is useful is you keep only one backup per test suite. If, on the other hand, you keep multiple backups per suite, \"Backup on every save\" may be the preferred choice.","hash":"opt_backupsingle","hp":"Backup files","h4":"Backup frequency (User)"},"1009":{"id":1009,"content":"Name of the backup file (User) Like many other things, the conventions for the names of backup files differ between Linux and Windows. While the common extension for a backup file under Windows is .bak, there are many variants under Linux. One of the most common is appending a tilde character '~'.","hash":"opt_backupname","hp":"Backup files","h4":"Name of the backup file (User)"},"1010":{"id":1010,"content":"Number of backup files to keep (User) You can keep more than one backup file for each test suite or run log. If you do so, backup files are named after the scheme .bak1, .bak2... for the .bak naming style and ~1~, ~2~... for the other. The most recent backup is always numbered 1. When a new backup is created, the old number 1 is renamed to 2, 2 renamed to 3 and so on. When the maximum is reached, the oldest files are deleted.","hash":"opt_backupnum","hp":"Backup files","h4":"Number of backup files to keep (User)"},"1011":{"id":1011,"content":"Auto-save interval (s) (User) Interval after which a modified test suite is saved automatically. Setting this value to 0 will disable auto-saving. Otherwise values less than about 20 seconds are not useful. Run logs are never saved automatically. Auto-save files are created in the same directory as the test suite or - in the case of new suites that have never been saved - in the user configuration directory.","hash":"opt_autosaveinterval","hp":"Backup files","h4":"Auto-save interval (s) (User)"},"1012":{"id":1012,"content":"Library","hash":"sec_opt_libpath","h1":"Library"},"1013":{"id":1013,"content":"Figure 33.10: Library options","hash":"figure_33.10","h4":"Figure 33.10: Library options"},"1014":{"id":1014,"content":"Directories holding test suite libraries (System) This is a list of directories that are searched for test suites whenever a suite reference is given as a relative path that cannot be resolved relative to the current suite. This includes direct suite references in the Procedure name attribute of a Procedure call or a Component QF‑Test ID reference as well as suites included through the Include files attribute of the Test suite node. See also Referencing nodes in another test suite. The library paths in this option apply globally to all test suites. Alternatively, you can specify the directory relative to a project. To do this, enter the path in the qftest.qpj file of the respective project. For more information, see \"The file qftest.qpj\". The directory names can reference environment variables or system properties via the syntax ${env:...} or ${system:...}. You can change the directory at run time by setting the respective environment variable or system property via script to the new value. Use rc.setProperty, which is described in \"The rc module: Run context API\". Though the syntax above is a standard in QF‑Test for group variables or properties, this is a special case where only the env or system groups can be used. The include directory belonging to the current version of QF‑Test is automatically and invisibly placed at the end of the library path. This ensures that the common library qfs.qft can always be included without knowing its actual location and that its version is matching the version of QF‑Test at all times. If the command line argument -libpath <path> is given it will override the settings of this option. In interactive mode, the value of the command line argument is displayed here, but it will not be saved with the system configuration unless it is modified.","hash":"opt_libpath","hp":"Library","h4":"Directories holding test suite libraries (System)"},"1015":{"id":1015,"content":"Test suites included in a new test suite (System) The option defines which test suites will be written to the list Include files when creating a new test suite. If you only specify the name of the test suite without the file path the test suite has to be located either directly in the folder or the including test suite or in one of the Directories holding test suite libraries. When the list is left empty, the standard library qfs.qft will be included in a new test suite by default.","hash":"opt_includedfilesdefault","hp":"Library","h4":"Test suites included in a new test suite (System)"},"1016":{"id":1016,"content":"License","hash":"sec_opt_license","h1":"License"},"1017":{"id":1017,"content":"Figure 33.11: License options Normally QF‑Test license bundles contain a homogeneous mix of GUI engines. For example, a bundle of QF‑Test/swing licenses only supports the AWT/Swing engine, QF‑Test/suite licenses support both AWT/Swing and SWT for all included licenses. For these kinds of simple licenses these license settings can be ignored. A small problem arises in case of mixed engine licenses where some GUI engine is included only for a part of the licenses. An example for this is a license bundle that was formerly purchased for qftestJUI, upgraded to QF‑Test/suite with QF‑Test 2.0 and then extended with further QF‑Test/swing licenses, say two licenses for QF‑Test/suite and another two for QF‑Test/swing. Such a license allows running four concurrent instances of QF‑Test, but only two of these can make use of the SWT engine. If more than two instances are started with SWT support there will be a license conflict. When QF‑Test detects such a mixed license bundle for the first time it asks the user which engine licenses to use. The choice made then can be changed here at any time. Besides, QF‑Test can be started with the command line argument -engine <engine> to override the supported GUI engines for this execution.","hash":"figure_33.11","h4":"Figure 33.11: License options"},"1018":{"id":1018,"content":"Updates To get the latest features and bug-fixes QF‑Test can check for updates automatically. The following options determine whether to check and when to notify for available updates. Using the command line argument \"-noupdatecheck\" you can disable the automatic update check.","hash":"sec_opt_update","h1":"Updates"},"1019":{"id":1019,"content":"Figure 33.12: Update options","hash":"figure_33.12","h4":"Figure 33.12: Update options"},"1020":{"id":1020,"content":"Automatically check for updates (User) QF‑Test automatically checks for updates upon startup. Deactivating this option disables this feature.","hash":"opt_checkforupdate","hp":"Updates","h4":"Automatically check for updates (User)"},"1021":{"id":1021,"content":"Ask for Update (User) If a new version is available QF‑Test shows a notification with links to the release notes and the download page. This option limits those notifications to specific kinds of versions. Minor updates contain mostly bug-fixes and small improvements. Medium upgrades are released to provide new features. Major upgrades include significant new features and may change the behavior of QF‑Test.","hash":"opt_askforupdate","hp":"Updates","h4":"Ask for Update (User)"},"1022":{"id":1022,"content":"Mobile Manual","hash":"","h0":"Recording options | QF‑Test Manual"},"1023":{"id":1023,"content":"Mobile Manual","hash":"home-link","h0":"Recording options | QF‑Test Manual"},"1024":{"id":1024,"content":"Recording options The following options determine which kinds of events are recorded and which filters are applied, how components are recorded and arranged, and how sub-items are handled.","hash":"sec_opt_record","h0":"Recording options"},"1025":{"id":1025,"content":"Figure 33.13: Recording options","hash":"figure_33.13","h4":"Figure 33.13: Recording options"},"1026":{"id":1026,"content":"Show initial quickstart help on record button (User) Controls the display of an initial question mark on the record button in order to directly lead new users to the quickstart wizard.","hash":"opt_recordshowhelpbutton","hp":"Recording options","h4":"Show initial quickstart help on record button (User)"},"1027":{"id":1027,"content":"Hotkey for recording (User) SUT script name: OPT_RECORD_HOTKEY Event recording can be directly started/stopped by pressing a key in the SUT. The key to be used for this function is set through this option. To set an option, click into the field and press the desired key combination. The default key is F11.","hash":"opt_hotkeyrecord","hp":"Recording options","h4":"Hotkey for recording (User)"},"1028":{"id":1028,"content":"Keep variables in recorded client names (System) This option is very useful if the client name assigned to your SUT contains variables (e.g. $(client)), which generally makes sense when creating procedures. If this option is set, the client attribute of all recorded nodes is set to the unexpanded Client value of the Start SUT client node through which the SUT was started.","hash":"opt_usetrueclientname","hp":"Recording options","h4":"Keep variables in recorded client names (System)"},"1029":{"id":1029,"content":"Insert recording at current selection (User) Depending on what you are currently working on, it may or may not make sense to add newly recorded sequences directly at the current insertion mark. If you deactivate this option, new recordings are placed in a new Sequence under Extras.","hash":"opt_insertatselection","hp":"Recording options","h4":"Insert recording at current selection (User)"},"1030":{"id":1030,"content":"Hotkey for checks (User) SUT script name: OPT_RECORD_CHECK_HOTKEY To simplify recording a sequence of events with interspersed checks, you can switch between plain recording and recording checks by pressing a key in the SUT. The key that triggers this switch is set through this option. To set an option, click into the field and press the desired key combination. The default key is F12.","hash":"opt_hotkeycheck","hp":"Recording options","h4":"Hotkey for checks (User)"},"1031":{"id":1031,"content":"Highlight components when checking (User) SUT script name: OPT_RECORD_CHECK_HIGHLIGHT When QF‑Test is recording checks, it can give visual feedback on the component the mouse is currently over by inverting its foreground and background colors. Rarely this may have unwanted visual side effects, so you can turn that feature off with this option.","hash":"opt_highlightduringcheck","hp":"Recording options","h4":"Highlight components when checking (User)"},"1032":{"id":1032,"content":"Show message if no events were recorded (User) Server script name: OPT_SHOW_EMPTY_RECORDING_MESSAGE When starting to record and stopping without interacting with the SUT in between, a message is shown indicating that no events were recorded. By deactivating this option that message can be suppressed.","hash":"opt_showemptyrecordingmessage","hp":"Recording options","h4":"Show message if no events were recorded (User)"},"1033":{"id":1033,"content":"Events to record These options specify which kinds of events are recorded and which aren't. You should not tinker with these unless you know what you are doing.","hash":"sec_opt_recordevents","h1":"Events to record"},"1034":{"id":1034,"content":"Figure 33.14: Options for events to record","hash":"figure_33.14","h4":"Figure 33.14: Options for events to record"},"1035":{"id":1035,"content":"Abstract 'Mouse click' events (System) Activating this option causes a sequence of MOUSE_MOVED, MOUSE_PRESSED, MOUSE_RELEASED and MOUSE_CLICKED events to be recorded as a single 'Mouse click' pseudo event (see \"Mouse event\").","hash":"opt_recordmousemprc","hp":"Events to record","h4":"Abstract 'Mouse click' events (System)"},"1036":{"id":1036,"content":"Simplified 'Mouse click' recording (System) When recording 'Mouse click' events, this option should also be activated. Except for Drag&Drop and special case MOUSE_MOVED events, recording is then based primarily on MOUSE_PRESSED events, turned into 'Mouse clicks'. This gives best results in most cases, even when QF‑Test receives too few or too many events from the SUT. If this option is turned off, the algorithm from QF‑Test 4.0 and older is used. This is worth a try in case a recorded sequence cannot be replayed directly.","hash":"opt_recordmousemprcsimple","hp":"Events to record","h4":"Simplified 'Mouse click' recording (System)"},"1037":{"id":1037,"content":"Abstract 'Keystroke' events (System) This option lets you record a sequence of KEY_PRESSED, KEY_TYPED and KEY_RELEASED events (or just KEY_PRESSED and KEY_RELEASED for function keys) as a single 'Keystroke' pseudo event (see \"Key event\").","hash":"opt_recordkeyptr","hp":"Events to record","h4":"Abstract 'Keystroke' events (System)"},"1038":{"id":1038,"content":"Record MouseEvents without coordinates where possible (System) SUT script name: OPT_RECORD_REPOSITION_MOUSE_EVENTS For many types of components and sub-items it doesn't matter where exactly a MouseEvent occurs. However, if large values are recorded for the X or Y coordinate of a Mouse event, there's the danger that the event might miss its target upon replay if the component has shrunk a little due to font changes or because the window has been resized. This is also a possible source for problems when converting a recorded sequence to a Procedure with variable target components. If this option is activated, QF‑Test ignores the coordinates of recorded MouseEvents if it thinks that the coordinates don't matter for the target component, e.g. for all kinds of buttons, for menu items, table cells, list items and tree nodes. For the latter QF‑Test distinguishes between clicks on the node itself and on the expand/collapse toggle. When MouseEvents without coordinates are played back, QF‑Test targets the center of the respective component or item except that the X coordinate for items is limited to 5 because item bounds cannot always be calculated correctly.","hash":"opt_repositionmouseevents","hp":"Events to record","h4":"Record MouseEvents without coordinates where possible (System)"},"1039":{"id":1039,"content":"Convert opening of a window into Wait for component to appear (System) When replaying a sequence during which a new window is opened, it may be useful to allow for a longer than usual delay until the window is opened. By activating this option, a recorded WINDOW_OPENED event will be turned into a Wait for component to appear node automatically.","hash":"opt_convertwindowopenwait","hp":"Events to record","h4":"Convert opening of a window into Wait for component to appear (System)"},"1040":{"id":1040,"content":"Events to pack In order to keep the amount of raw event data generated during normal use of a Java GUI manageable, QF‑Test employs a set of recording filters and packers. These do their best to keep everything needed for successful replay and throw away the rest. To get an impression of the actual data behind a recorded sequence, try recording a short sequence with all of these turned off, and with 'Mouse click' and 'Keystroke' pseudo events disabled.","hash":"sec_opt_packevents","h1":"Events to pack"},"1041":{"id":1041,"content":"Figure 33.15: Options for events to pack","hash":"figure_33.15","h4":"Figure 33.15: Options for events to pack"},"1042":{"id":1042,"content":"MOUSE_MOVED events (System) SUT script name: OPT_RECORD_PACK_MOUSE_MOVED MOUSE_MOVED events are especially frequent. Every mouse cursor motion generates a handful of these. Under most circumstances, only the last of a consecutive series of MOUSE_MOVED events is actually useful, so all events except the last one are dropped, if this option is activated. An example where this is not advisable is recording some freehand drawing in a graphics application. One might think that MOUSE_MOVED events are completely useless, since MOUSE_PRESSED or MOUSE_RELEASED events have their own set of coordinates, but this is not the case. Some Java components require a MOUSE_MOVED event before a MOUSE_PRESSED event is recognized.","hash":"opt_packmousemoved","hp":"Events to pack","h4":"MOUSE_MOVED events (System)"},"1043":{"id":1043,"content":"MOUSE_DRAGGED events (System) SUT script name: OPT_RECORD_PACK_MOUSE_DRAGGED MOUSE_DRAGGED events are like MOUSE_MOVED events, but with one mouse button held down. Similarly, only the last of a series of MOUSE_DRAGGED events is recorded unless you turn off this option, except for special cases (see next option).","hash":"opt_packmousedragged","hp":"Events to pack","h4":"MOUSE_DRAGGED events (System)"},"1044":{"id":1044,"content":"Mouse drag hover delay (System) SUT script name: OPT_RECORD_MOUSE_DRAGGED_HOVER There are situations where not only the final target of a mouse drag is of interest, but intermediate points as well. The most common is invoking a menu item in a sub-menu. As of QF‑Test 1.05.2, the following no longer applies because MOUSE_MOVED or MOUSE_DRAGGED events that are required for opening sub-menus are not \"optimized away\" anymore. However, there may be other situations where intermediate stops are useful when recording drags.","hash":"opt_draghover","hp":"Events to pack","h4":"Mouse drag hover delay (System)"},"1045":{"id":1045,"content":"SUT script name: OPT_RECORD_MOUSE_DRAGGED_HOVER There are situations where not only the final target of a mouse drag is of interest, but intermediate points as well. The most common is invoking a menu item in a sub-menu. As of QF‑Test 1.05.2, the following no longer applies because MOUSE_MOVED or MOUSE_DRAGGED events that are required for opening sub-menus are not \"optimized away\" anymore. However, there may be other situations where intermediate stops are useful when recording drags. Figure 33.16: Dragging to a sub-menu As illustrated above, creating a new Test call node for a suite could be done by clicking on the »Insert« menu button, dragging the mouse to the »Test and Sequence nodes« item for the sub-menu, so the sub-menu pops up, then dragging on to the »Testcall« menu item and releasing the mouse button. Normally such a sequence would be reduced to a press, a drag to the final »Testcall« item and a release. It would fail to replay, since the sub-menu would never be popped up. To work correctly, an additional drag to the »Test and Sequence nodes« item must be recorded. For that reason QF‑Test recognizes a MOUSE_DRAGGED event as important if you hover over an intermediate component for a while during the drag. The delay (in milliseconds) needed to recognize such an event is set through this option. To record the above example correctly with this option set to 1000, you'd have to click on the »Insert« menu button, drag to the »Test and Sequence nodes« item and keep the mouse pointer stationary for one second, then move on to the »TestCall« sub-menu item and release the mouse button.","hash":"figure_33.16","hp":"Events to pack","h4":"Mouse drag hover delay (System)"},"1046":{"id":1046,"content":"Maximum drag distance for 'Mouse click' event (System) It sometimes happens unintentionally that the mouse cursor is moved between pressing the mouse button and releasing it. This movement may be registered as a MOUSE_DRAGGED event, depending on the JDK version and the distance of the move. QF‑Test is able to compensate for small movements and still convert the click into an abstract 'Mouse click' event. This option defines the maximum distance between pressing and releasing the mouse button that QF‑Test will ignore. Every MOUSE_DRAGGED event above that distance will be left unchanged.","hash":"opt_maxdragmprc","hp":"Events to pack","h4":"Maximum drag distance for 'Mouse click' event (System)"},"1047":{"id":1047,"content":"Collect key events into a Text input node (System) Another example where a lot of events are generated is entering a short string of text into a text field. Each character typed leads to at least one KEY_PRESSED, one KEY_TYPED and one KEY_RELEASED event. For additional fun, the KEY_RELEASED events may arrive out of order or not at all, depending on operating system and JDK version. If this option is activated, sequences of KeyEvents on a text component (to be exact: a component whose class is derived from java.awt.TextField or javax.swing.text.JTextField) are converted into a Text input node. Only true character input is packed, function or control keys or key combinations with Control or Alt are left unchanged. When the packed sequence is replayed, only KEY_TYPED events are generated. KEY_PRESSED and KEY_RELEASED events cannot be generated, since the required key code is system dependent and cannot be determined from the character alone. This is not a problem however, since text components usually handle only KEY_TYPED events and some special keys.","hash":"opt_packtextinput","hp":"Events to pack","h4":"Collect key events into a Text input node (System)"},"1048":{"id":1048,"content":"Automatically set 'Clear...' attribute of recorded Text input nodes (System) This option determines the value of the Clear target component first attribute of a recorded Text input node. If the option is not set, the attribute will not be set either. Otherwise, the Clear target component first attribute is set if and only if the text field or text area was empty before the input started.","hash":"opt_textinputclear","hp":"Events to pack","h4":"Automatically set 'Clear...' attribute of recorded Text input nodes (System)"},"1049":{"id":1049,"content":"Always set 'Replay single events' attribute of recorded Text input nodes (System) This option determines the value of the Replay single events attribute of a recorded Text input node. If the option is set, the attribute will be set and vice versa. The conservative way is to keep the option set, but for a typical application that does not add its own KeyListeners to text fields it should be safe to turn it off so as to speed up replay of Text input nodes.","hash":"opt_textinputsingle","hp":"Events to pack","h4":"Always set 'Replay single events' attribute of recorded Text input nodes (System)"},"1050":{"id":1050,"content":"Components General information regarding the settings for recording of class names: QF‑Test can record classes of component in various ways, therefore it organizes component classes in various categories. Those categories are called as the specific class, the technology-specific system class, the generic class and the dedicated type of the generic class. Each category is recorded at Extra features. The option Record generic class names for components is checked by default. Using this option allows you to record generic classes in order to share and re-use your tests when testing a different technology with just minor changes to the existing tests.","hash":"sec_opt_recordcomponents","h1":"Components"},"1051":{"id":1051,"content":"Figure 33.17: Options for recording components","hash":"figure_33.17","h4":"Figure 33.17: Options for recording components"},"1052":{"id":1052,"content":"Hotkey for components (User) SUT script name: OPT_RECORD_COMPONENT_HOTKEY This option defines the key for a very useful functionality: recording components directly from the SUT. Pressing this key in the SUT will switch it to \"component recording\" mode, regardless of whether event recording is currently activated or not. To change the option please click the field showing the current key or key combination (it is an interactive field) and press the desired key or key combination. To leave the interactive field press the tab key or do a mouse click to a different field. The default key is Shift⁠+⁠F11 for Window/Linux and ⇧⁠+⁠F11 for Mac. In this mode, clicking on a component with the mouse will cause the component to be recorded and added to the test suite if it was unknown before. If more than one test suite is currently opened, the menu item »Record«-»Receive components« determines the suite that will receive the components. The QF‑Test ID of the Component is put on the clipboard so it can be pasted into any text field with Control⁠+⁠V. This latter feature is very handy when creating an event or a check from scratch.","hash":"opt_hotkeycomponent","hp":"Components","h4":"Hotkey for components (User)"},"1053":{"id":1053,"content":"SUT script name: OPT_RECORD_COMPONENT_HOTKEY This option defines the key for a very useful functionality: recording components directly from the SUT. Pressing this key in the SUT will switch it to \"component recording\" mode, regardless of whether event recording is currently activated or not. To change the option please click the field showing the current key or key combination (it is an interactive field) and press the desired key or key combination. To leave the interactive field press the tab key or do a mouse click to a different field. The default key is Shift⁠+⁠F11 for Window/Linux and ⇧⁠+⁠F11 for Mac. In this mode, clicking on a component with the mouse will cause the component to be recorded and added to the test suite if it was unknown before. If more than one test suite is currently opened, the menu item »Record«-»Receive components« determines the suite that will receive the components. The QF‑Test ID of the Component is put on the clipboard so it can be pasted into any text field with Control⁠+⁠V. This latter feature is very handy when creating an event or a check from scratch. Figure 33.18: Popup menu for recording components You can also record a whole component hierarchy at once by clicking with the right mouse button instead. This will bring up a popup menu with the following four options: Component only This is similar to clicking with the left mouse button. Only the selected component is recorded. Component and children The selected component and all components contained therein are recorded. Whole window Records every component in the whole window. Suggest names This is a special feature to improve the collaboration between testers and developers in deciding which components should have names set with setName(). All components in the whole window are recorded and put into a test suite of their own. Each unnamed component for which a name will improve testability is marked with a name of the form \"SUGGESTED NAME (n): suggestion\". The running count in braces is just used to avoid duplicates. The suggested name is built from the component's class and other available information. It should be taken with a grain of salt. Show methods This is another special feature that brings up a component inspector window showing the attributes and methods of the selected component's class. See \"Inspecting components\" for further information. Normally \"component recording\" mode is turned off by either pressing the hotkey again or by selecting a component. If you want to record multiple single components, use the key combination for Hotkey for multiple component recording. That way selecting a component will not turn off the mode, only pressing the hotkey again will.","hash":"figure_33.18","hp":"Components","h4":"Hotkey for components (User)"},"1054":{"id":1054,"content":"Hotkey for multiple component recording (User) SUT script name: OPT_RECORD_COMPONENT_CONTINUE_HOTKEY This option defines the key combination that allows you to switch to component recording mode. To change the option please click the field showing the current key or key combination (it is an interactive field) and press the desired key or key combination. To leave the interactive field press the tab key or do a mouse click to a different field. The default key is CTRL⁠+⁠F11 for Window/Linux and ⌃⁠+⁠F11 for Mac. The key difference with Hotkey for components is that this mode remains active, enabling you to record multiple components consecutively. To exit the mode, simply press the hotkey again.","hash":"opt_hotkeycomponentcontinue","hp":"Components","h4":"Hotkey for multiple component recording (User)"},"1055":{"id":1055,"content":"Record generic class names for components (System) SUT script name: OPT_RECORD_COMPONENT_GENERIC_CLASS Where possible QF‑Test assigns generic class names to components like \"Button\", \"Table\" or \"Tree\" in addition to the actual Java, DOM or framework-specific class names like \"javax.swing.JButton\", \"javafx.scene.control.Button\", \"INPUT\" or \"X-BUTTON\". These generic class names are more descriptive and robust, improve compatibility between different UIs and enable creation of generic utility procedures. Generic class names can be used for component recognition or registering resolvers. If this option is active, generic class names are recorded where available.","hash":"opt_recordgenericclass","hp":"Components","h4":"Record generic class names for components (System)"},"1056":{"id":1056,"content":"Record system class only (System) SUT script name: OPT_RECORD_COMPONENT_SYSTEM_CLASS_ONLY If this option is set, QF‑Test does not record any custom classes for Components. Instead it moves up the class hierarchy until it encounters a system class and records that. Set this option if the class names of your custom GUI classes tend to differ between releases. You must activate this option if you intend to obfuscate the jar files of your application or if you are using a custom class loader to load your application's GUI classes.","hash":"opt_dontrecordcustom","hp":"Components","h4":"Record system class only (System)"},"1057":{"id":1057,"content":"Match any class when recording components (System) SUT script name: OPT_RECORD_TOLERANT_CLASS_MATCH For compatibility with older QF‑Test versions that did not have generic classes, QF‑Test now matches against several classes of a component when recording, the concrete class, the generic class and the system class. This is very useful if you want to retain as many of your old components as possible. If you would rather get new components based on generic classes in new recordings you should deactivate this option. Components recorded for the first time will always be recorded with the class determined by the preceding two options Record generic class names for components and Record system class only.","hash":"opt_tolerantclassmatch","hp":"Components","h4":"Match any class when recording components (System)"},"1058":{"id":1058,"content":"Validate component recognition during recording (System) SUT script name: OPT_VALIDATE_RECORDED_COMPONENTS In case non-unique names are assigned to components QF‑Test can still distinguish between these components with the help of the Extra feature qfs:matchindex that specifies the index of the component with the given name. If this option is set, QF‑Test will check the name of the component during recording and try to assign qfs:matchindex correctly. You should only deactivate this option if you are sure that component names are \"reasonably unique\" and the component validation significantly impacts performance during recording.","hash":"opt_validaterecordedcomponents","hp":"Components","h4":"Validate component recognition during recording (System)"},"1059":{"id":1059,"content":"Name override mode (record) (System) Server (automatically forwarded to SUT) script name: OPT_RECORD_COMPONENT_NAME_OVERRIDE Possible Values: VAL_NAME_OVERRIDE_EVERYTHING, VAL_NAME_OVERRIDE_HIERARCHY, VAL_NAME_OVERRIDE_PLAIN There are two versions of this option which are closely related. This one is effective during recording, the other one during replay. Obviously, both options should always have the same value. There's one exception though: When migrating from one setting to another, QF‑Test's components have to be updated. During that process, keep the replay option at the old setting and change this option to the new one. Be sure to update the replay setting after updating the components. This option determines the weight given to the names of components for recording. Possible choices are: Hierarchical resolution This choice should be used if component names are not unique on a per-window basis, but naming is still used consistently so that two components with identical names have at least parent components or ancestors with distinct names. That way, component recognition is still tolerant to a lot of change, but if a named component is moved to a different named parent in the SUT, the test suite will have to be updated to reflect the change. Plain attribute If there are components with identical names in the SUT within the same parent component you must use this setting. The name will still play an important role in component recognition, but not much more than the Feature attribute.","hash":"opt_nameoverriderec","hp":"Components","h4":"Name override mode (record) (System)"},"1060":{"id":1060,"content":"Component hierarchy (System) Server script name: OPT_RECORD_COMPONENT_HIERARCHY Possible Values: VAL_RECORD_HIERARCHY_INTELLIGENT, VAL_RECORD_HIERARCHY_FULL, VAL_RECORD_HIERARCHY_FLAT QF‑Test supports three different kinds of views for the components of the SUT. For more information about their effect on component recognition, see \"Weighting of recognition features for recorded components\". The flat view collects all components of a window as direct child nodes of the respective Window node. The advantage of this view is that structural changes of the component hierarchy have little effect on component recognition. This is also its greatest disadvantage: since structural information is not available, this view gives reasonable recognition quality only if setName() is used ubiquitously. Another drawback is the lack of clearness. The complement to the flat view is the full hierarchy. It includes every single component of the SUT's GUI, emulating all parent/child relationships. This view can be a useful tool for developers or testers that want to gain insights into the SUT's structure, but is not very applicable for testing, since structural changes affect it too much. As long as you don't change the GUI however, it will give you excellent recognition without the help of setName(). A compromise between flat and full hierarchy is available through the choice \"Intelligent\". For this view only the \"interesting\" components of the SUT are recorded. \"Interesting\" in this case means that either the user can interact with the component, or it is located at some important point in the hierarchy, like the children of a split pane or a tabbed pane. In some later version of QF‑Test this decision may be made configurable as well.","hash":"opt_nesting","hp":"Components","h4":"Component hierarchy (System)"},"1061":{"id":1061,"content":"Prepend QF‑Test ID of window parent to component QF‑Test ID (System) Server script name: OPT_RECORD_COMPONENT_PREPEND_WINDOW_ID If selected, QF‑Test prepends the QF‑Test ID of the Window parent of a Component to its QF‑Test ID during recording. This is useful to disambiguate QF‑Test IDs of components with identical names in different windows.","hash":"opt_addwindowid","hp":"Components","h4":"Prepend QF‑Test ID of window parent to component QF‑Test ID (System)"},"1062":{"id":1062,"content":"Prepend parent QF‑Test ID to component QF‑Test ID (System) Server script name: OPT_RECORD_COMPONENT_PREPEND_PARENT_ID Possible Values: VAL_RECORD_COMPONENT_PREPEND_PARENT_ALWAYS, VAL_RECORD_COMPONENT_PREPEND_PARENT_NAMED, VAL_RECORD_COMPONENT_PREPEND_PARENT_FEATURE, VAL_RECORD_COMPONENT_PREPEND_PARENT_NEVER When a Component is recorded for the first time, QF‑Test assigns an automatically generated QF‑Test ID. The QF‑Test ID of a direct or indirect parent node may be prepended to this QF‑Test ID. This is useful to distinguish between similar components that don't have a name of their own. Example: Imagine two JScrollPanes, one named \"TreeScrollPane\" and the other named \"DetailScrollPane\". Without this functionality, their vertical scrollbars would get the QF‑Test IDs \"scrollbarVertical\" and \"scrollbarVertical2\". With this function turned on, the IDs would be \"TreeScrollPane.scrollbarVertical\" and \"DetailScrollPane\".scrollbarVertical\". That way it is immediately obvious which component is the target of an event. There are four possible settings: \"Never\" turns this option off. \"Nearest named ancestor\" is a useful setting, if your developers have assigned names to all major components with the Java method setName. A component that doesn't have a name of its own, gets the QF‑Test ID of its nearest named ancestor node prepended. If setName is used sparingly or not at all, it is better to set this option to \"Nearest ancestor with name or feature\". That way either the name or a distinctive feature of an ancestor node will be applicable. \"Always\" is only useful if the option Component hierarchy is set to \"Flat\". With this setting, every component gets the QF‑Test ID of its parent node prepended, which can lead to unusably long QF‑Test IDs when components are nested deeply.","hash":"opt_addparentid","hp":"Components","h4":"Prepend parent QF‑Test ID to component QF‑Test ID (System)"},"1063":{"id":1063,"content":"Recording sub-items Events on complex components like tables or trees can be recorded relative to a sub-item of the component.","hash":"sec_opt_relativeevents","h1":"Recording sub-items"},"1064":{"id":1064,"content":"Figure 33.19: Options for recording sub-items","hash":"figure_33.19","h4":"Figure 33.19: Options for recording sub-items"},"1065":{"id":1065,"content":"Record sub-items as event targets (System) SUT script name: OPT_RECORD_SUBITEM This option activates recording sub-items. When turned off, events on complex components are no different from events on simple components.","hash":"opt_subitemmouseevents","hp":"Recording sub-items","h4":"Record sub-items as event targets (System)"},"1066":{"id":1066,"content":"Multi-level sub-items (System) Server (automatically forwarded to SUT) script name: OPT_RECORD_SUBITEM_MULTILEVEL Via this option you can completely disable multi-level sub-items (even for replay). However, you should only turn this feature off in case you are running into problems caused by test suites that contain unquoted special characters like '@' or '%' in textual sub-item indexes. Even then it is preferable to update the test suites with properly quoted items, possibly using the special variable syntax ${quoteitem:...} (see \"Special groups\").","hash":"opt_multilevelsubitems","hp":"Recording sub-items","h4":"Multi-level sub-items (System)"},"1067":{"id":1067,"content":"Sub-item format (System) SUT script name: OPT_RECORD_SUBITEM_FORMAT Possible Values: VAL_RECORD_SUBITEM_FORMAT_INTELLIGENT, VAL_RECORD_SUBITEM_FORMAT_TEXT, VAL_RECORD_SUBITEM_FORMAT_NUMBER When recording an event for a sub-item, the Item's index can be defined As string or As number. The third choice, \"Intelligent\", causes QF‑Test to record the index in the format most appropriate for the item. If the name of the item is unique within the complex component, a string index is recorded, a numeric index otherwise.","hash":"opt_subitemformat","hp":"Recording sub-items","h4":"Sub-item format (System)"},"1068":{"id":1068,"content":"Sub-item type (System) Server script name: OPT_RECORD_SUBITEM_TYPE Possible Values: VAL_RECORD_SUBITEM_TYPE_INTELLIGENT, VAL_RECORD_SUBITEM_TYPE_NODE, VAL_RECORD_SUBITEM_TYPE_SYNTAX With this option you control whether a Item node is created for a sub-element during event recording or the element is referenced directly in the attribute QF‑Test component ID of the Mouse event node. (see \"Sub-items: Addressing relative to a parent component\"). Choosing \"Intelligent\" will only cause a node to be created if the Index is given as text and the sub-element is not editable in the SUT.","hash":"opt_subitemtype","hp":"Recording sub-items","h4":"Sub-item type (System)"},"1069":{"id":1069,"content":"Represent tree node as path (System) SUT script name: OPT_RECORD_SUBITEM_TREE_PATH It is not uncommon that trees have identically named nodes under different parent nodes, e.g. a file system with the directories /tmp and /usr/tmp. By using a path format in the Items for tree nodes QF‑Test can make full use of the hierarchical structure to distinguish between these nodes. The slash character '/' is used as separator. If this option is deactivated, trees will be treated as flat lists.","hash":"opt_subitempath","hp":"Recording sub-items","h4":"Represent tree node as path (System)"},"1070":{"id":1070,"content":"Recording Window The following options can be used to customize the look and functionality of the recording window.","hash":"sec_opt_android_recordingwindow","h1":"Recording Window"},"1071":{"id":1071,"content":"Figure 33.20: Options for the recording window","hash":"figure_33.20","h4":"Figure 33.20: Options for the recording window"},"1072":{"id":1072,"content":"Automatic scaling (System) Server script name: OPT_RECORDING_DISPLAY_AUTO_SCALING If this option is set, the preview image in the recording window will be automatically scaled according to the window size.","hash":"opt_android_recordingwindowautoscalingstate","hp":"Recording Window","h4":"Automatic scaling (System)"},"1073":{"id":1073,"content":"Show screen borders (System) Server script name: OPT_SHOW_BORDER Draws a Border around the edge of the virtual screen inside the recording window to make the edge clearly visible.","hash":"opt_android_recordingwindowshowborder","hp":"Recording Window","h4":"Show screen borders (System)"},"1074":{"id":1074,"content":"Show vertical toolbar (System) Server script name: OPT_VERTICAL_TOOLBAR_STATE Inserts an additional toolbar at the edge of the recording window containing actions for controlling possible hardware buttons of the device. In recording mode, these are also recorded as events.","hash":"opt_android_recordingwindowverticaltoolbar","hp":"Recording Window","h4":"Show vertical toolbar (System)"},"1075":{"id":1075,"content":"Highlighting after click (System) Server script name: OPT_CLICK_HIGHLIGHT When the option is set clicks to recording window will highlight the respective component, showing a colored border around it for a short time. This can be useful to check whether a click was interpreted correctly.","hash":"opt_android_recordingwindowclickhighlight","hp":"Recording Window","h4":"Highlighting after click (System)"},"1076":{"id":1076,"content":"Highlight duration (ms) (System) Server script name: OPT_HIGHLIGHT_DURATION With this you control how long a border around a selected component should be displayed.","hash":"opt_android_recordingwindowhighlightduration","hp":"Recording Window","h4":"Highlight duration (ms) (System)"},"1077":{"id":1077,"content":"Automatic refresh interval (ms) (System) Server script name: OPT_RECORDING_AUTO_REFRESH_INTERVALL This controls how often QF‑Test will try to refresh the contents of the recording window. Please be aware that the maximum refresh speed depends on the device or emulator/simulator used. A interval value lower than the maximum refresh speed will not have any effect. Too low values may negatively impact system performance.","hash":"opt_android_recordingwindowrefreshintervall","hp":"Recording Window","h4":"Automatic refresh interval (ms) (System)"},"1078":{"id":1078,"content":"Number of refreshes after one click (System) Server script name: OPT_REFRESH_STEPS The option defines the number of times the recording window will be updated after a click. The option is only relevant when automatic updating has been disabled. Depending on the configurable animation speed of Android it can happen that the preview window may be updated whilst an animation is executed. In that case the option can be useful.","hash":"opt_android_recordingwindowrefreshsteps","hp":"Recording Window","h4":"Number of refreshes after one click (System)"},"1079":{"id":1079,"content":"Waiting time between refreshes after a click (ms) (System) Server script name: OPT_INTERVAL_TIME_AFTER_CLICK The option defines the time between two refreshes. The option is only relevant when automatic refreshing has been disabled. Please be aware the maximum refresh speed depends on the device or emulator/simulator used. A interval value lower than the maximum refresh speed will not have any effect.","hash":"opt_android_recordingwindowintervalafterclick","hp":"Recording Window","h4":"Waiting time between refreshes after a click (ms) (System)"},"1080":{"id":1080,"content":"Swipe recording (User) The option defines how swipes are recorded. In addition to the coordinate-based approach,a simple directional swipe mode (up, down, left, right) and an intelligent mode are available.","hash":"opt_recordingwindowswiperecording","hp":"Recording Window","h4":"Swipe recording (User)"},"1081":{"id":1081,"content":"Swipe on the top level component (System) Server script name: OPT_SWIPE_ON_TOPLEVEL_COMPONENT When the option is activated swipes will always be recorded on the top level component. Due to differing screen sizes and resolutions of devices some components may not be located in the visible area. Then, swipes where the lower level component is not relevant may become unreliable. Especially for navigation swipes, the option can improve the recording.","hash":"opt_android_recordingwindowswipeontoplevel","hp":"Recording Window","h4":"Swipe on the top level component (System)"},"1082":{"id":1082,"content":"Record swipe time (System) Server script name: OPT_MOBILE_RECORD_SWIPE_TIME When the option is activated the duration of swipe gestures will be recorded. To avoid or achieve a fling effect, you can also record the swipe duration. The fling effect refers to the automatic, rapid continuation of scrolling after a quick swipe gesture.","hash":"opt_android_recordingwindowrecordswipetime","hp":"Recording Window","h4":"Record swipe time (System)"},"1083":{"id":1083,"content":"Recording procedures The following options determine the configuration of the Procedure Builder which is described in detail in Automated Creation of Basic Procedures.","hash":"sec_opt_prcobuilder","h1":"Recording procedures"},"1084":{"id":1084,"content":"Figure 33.21: Procedure Builder options","hash":"figure_33.21","h4":"Figure 33.21: Procedure Builder options"},"1085":{"id":1085,"content":"Hotkey for procedure recording (User) SUT script name: OPT_RECORD_PROCEDURE_HOTKEY This option defines a key for turning on automatic procedure recording directly in the SUT. To change the option please click the field showing the current key or key combination (it is an interactive field) and press the desired key or key combination. To leave the interactive field press the tab key or do a mouse click to a different field. The default key is Shift⁠+⁠F12 for Window/Linux and ⇧⁠+⁠F12 for Mac.","hash":"opt_hotkeyprocedure","hp":"Recording procedures","h4":"Hotkey for procedure recording (User)"},"1086":{"id":1086,"content":"Hotkey for multiple procedure recording (User) SUT script name: OPT_RECORD_PROCEDURE_CONTINUE_HOTKEY This option defines a key for turning on automatic procedure recording directly in the SUT. To change the option please click the field showing the current key or key combination (it is an interactive field) and press the desired key or key combination. To leave the interactive field press the tab key or do a mouse click to a different field. The default key is Ctrl⁠+⁠F12 for Window/Linux and ⌃⁠+⁠F12 for Mac. The difference with Hotkey for procedure recording is that procedure recording mode remains active, enabling you to record multiple procedures consecutively. To exit the mode, simply press the hotkey again.","hash":"opt_hotkeyprocedurecontinue","hp":"Recording procedures","h4":"Hotkey for multiple procedure recording (User)"},"1087":{"id":1087,"content":"Configuration file for recorded procedures (System) Here you can specify your own template file for the Procedure Builder. If a relative path is given, QF‑Test looks for the definition file in the directory that QF‑Test was started from and in the default include directory.","hash":"opt_pbconffile","hp":"Recording procedures","h4":"Configuration file for recorded procedures (System)"},"1088":{"id":1088,"content":"Mobile Manual","hash":"","h0":"Replay options | QF‑Test Manual"},"1089":{"id":1089,"content":"Mobile Manual","hash":"home-link","h0":"Replay options | QF‑Test Manual"},"1090":{"id":1090,"content":"Replay options The following settings change the way test suites are executed.","hash":"sec_opt_play","h0":"Replay options"},"1091":{"id":1091,"content":"Figure 33.22: Replay options","hash":"figure_33.22","h4":"Figure 33.22: Replay options"},"1092":{"id":1092,"content":"Hotkey for pausing test run (\"Don't Panic\" key) (User) Server (automatically forwarded to SUT) script name: OPT_PLAY_DONT_PANIC_HOTKEY When running a test at full speed it can be rather difficult to get the focus to QF‑Test's window and interrupt the test so you can do something different without having all these windows flashing around the screen. This is all the more true when the options Actually move mouse cursor or Raise SUT windows automatically are activated or when running in batch mode. This option lets you define a key combination (the default being Alt⁠+⁠F12) that will instantly pause all running tests if it is pressed in any SUT or QF‑Test window (unless multiple QF‑Test instances are run simultaneously, of course). Pressing the same key combination again will resume all tests, unless you manually resume or stop any of them. In that case its effect is automatically reset to suspend tests. To set a hotkey, click into the field and press the desired key combination.","hash":"opt_panickey","hp":"Replay options","h4":"Hotkey for pausing test run (\"Don't Panic\" key) (User)"},"1093":{"id":1093,"content":"Call stack size (System) Server script name: OPT_PLAY_CALLSTACK_SIZE The call stack size is a limit for the nesting depth of Sequences or Procedure calls during replay. This limit is needed to detect and handle endless recursion. When the nesting depth exceeds the call stack size, a StackOverflowException is thrown. The default value of 200 should be sufficient but can be increased for very complex tests.","hash":"opt_callstacksize","hp":"Replay options","h4":"Call stack size (System)"},"1094":{"id":1094,"content":"Log warning for nested test cases (System) Server script name: OPT_PLAY_WARN_NESTED_TEST_CASE Execution of Test case nodes should not be nested because such Test cases cannot be listed properly in the report. If this option is active, a warning is logged in case a Test case is executed within another Test case.","hash":"opt_warnnestedtestcase","hp":"Replay options","h4":"Log warning for nested test cases (System)"},"1095":{"id":1095,"content":"Mark nodes during replay (User) If set, tree nodes that are currently executed are marked with an arrow.","hash":"opt_markrunningsteps","hp":"Replay options","h4":"Mark nodes during replay (User)"},"1096":{"id":1096,"content":"Show replay messages in status line (User) Determines whether the name of the currently executing node is shown in the status line.","hash":"opt_printrunningsteps","hp":"Replay options","h4":"Show replay messages in status line (User)"},"1097":{"id":1097,"content":"Raise test suite window after replay (User) This option is mainly used together with the option Raise SUT windows automatically. It causes the window of a test suite to be raised after a test run. See also option Force window to the top when raising.","hash":"opt_raiseafter","hp":"Replay options","h4":"Raise test suite window after replay (User)"},"1098":{"id":1098,"content":"Minimize test suite window during replay (User) If this option is set, QF‑Test will minimize the window of a test suite while its tests are being executed. The window will pop back up automatically when the test is stopped or suspended. This feature is especially useful on Windows 2000/XP systems where programs are prohibited from bringing their windows to the top so QF‑Test cannot raise the windows of the SUT.","hash":"opt_minimize","hp":"Replay options","h4":"Minimize test suite window during replay (User)"},"1099":{"id":1099,"content":"Show message dialog after (User) After replay is finished, the status line shows the number of errors and warnings that occurred. If an uncaught exception was thrown, an error dialog is displayed. Additionally, a message dialog can be displayed in case of warnings or errors or every time a run is finished. This option sets the minimum error level that triggers such a message dialog.","hash":"opt_showmessageafter","hp":"Replay options","h4":"Show message dialog after (User)"},"1100":{"id":1100,"content":"Always locate the source of an error (User) When an exception is thrown during replay, the node that caused the exception will be made visible and selected. If you don't like this, you can turn this feature off and locate the node via the »Run«-»Find last error source...« menu item instead.","hash":"opt_selectonerror","hp":"Replay options","h4":"Always locate the source of an error (User)"},"1101":{"id":1101,"content":"Salt for crypting passwords (System) QF‑Test can store variable data encrypted and decrypt it using the special variable group decrypt (see \"Special groups\"). In addition, QF‑Test can store encrypted passwords in the Text attribute of a Text input node for a password field or the Detail attribute of a Selection used for a login dialog in a web SUT. When such passwords are en- or decrypted, QF‑Test combines the key with the salt specified in this option. Without this salt, anybody with sufficient knowledge is able to decrypt your passwords to get the plain-text version. Don't let this option give you a false sense of security. Anybody that gains access to this salt and anybody that can execute your tests can also gain access to the plain-text version of the password. However, encrypting passwords is still useful to prevent obvious plain-text passwords getting stored in test suites and run logs, and encrypted passwords are reasonably safe from someone who only gets hold of a test suite or run log without access to this salt. To retrieve an encrypted variable within a script without decrypting it, use the run context method rc.getWrapped(), see The rc module: Run context API.","hash":"opt_passwordsalt","hp":"Replay options","h4":"Salt for crypting passwords (System)"},"1102":{"id":1102,"content":"How to handle disabled components (System) Server script name: OPT_PLAY_ERROR_STATE_DISABLED_COMPONENT Possible Values: VAL_PLAY_DISABLED_COMPONENT_WARNING, VAL_PLAY_DISABLED_COMPONENT_ERROR, VAL_PLAY_DISABLED_COMPONENT_EXCEPTION In case you replay an event on a component, which is disabled you can configure QF‑Test's behavior for that case. You can Log a warning message Log an error message Throw a DisabledComponentStepException","hash":"opt_errorstatedisabledcomponent","hp":"Replay options","h4":"How to handle disabled components (System)"},"1103":{"id":1103,"content":"How to handle exceeded execution timeout (System) Server script name: OPT_PLAY_ERROR_STATE_EXECUTION_TIMEOUT Possible Values: VAL_PLAY_EXECUTION_TIMEOUT_WARNING, VAL_PLAY_EXECUTION_TIMEOUT_ERROR, VAL_PLAY_EXECUTION_TIMEOUT_EXCEPTION, VAL_PLAY_EXECUTION_TIMEOUT_WARNING_IMMEDIATE, VAL_PLAY_EXECUTION_TIMEOUT_ERROR_IMMEDIATE, VAL_PLAY_EXECUTION_TIMEOUT_EXCEPTION_IMMEDIATE In case of an exceeding execution timeout, you can configure QF‑Test's behavior for that case. You can Log a warning message and run through possible cleanup nodes. Log an error message and run through possible cleanup nodes. Throw an ExecutionTimeoutExpiredException and run through possible cleanup nodes. Log a warning message and stop the node immediately. Log an error message and stop the node immediately. Throw an ExecutionTimeoutExpiredException and stop the node immediately. The definition of running cleanup nodes includes that Cleanup and Catch nodes get executed. Stopping the node immediately stands for not executing possible Cleanup and Catch nodes at the end.","hash":"opt_errorstateexecutiontimeout","hp":"Replay options","h4":"How to handle exceeded execution timeout (System)"},"1104":{"id":1104,"content":"Client options Various settings for process and SUT clients can be adjusted with the following options:","hash":"sec_opt_clients","h1":"Client options"},"1105":{"id":1105,"content":"Figure 33.23: Client options","hash":"figure_33.23","h4":"Figure 33.23: Client options"},"1106":{"id":1106,"content":"Ignore empty argument lines when starting a client (System) Server script name: OPT_PLAY_CLIENT_START_IGNORE_EMPTY_ARGUMENT If the option is set (default), empty program parameters or class arguments lines will be ignored in 'starter' nodes like Start Java SUT client, Start SUT client, Start process, Start web engine, Start windows application or Launch Android emulator. This is very useful for using variables in parameters because an empty variable is then equivalent to removing the parameter from the list. If the option is turned off, an empty argument line (i.e. '') will be passed to the starting program instead.","hash":"opt_clientstartignoreemptyargument","hp":"Client options","h4":"Ignore empty argument lines when starting a client (System)"},"1107":{"id":1107,"content":"Ask whether to stop clients before exiting (User) If there are still active clients upon exit of QF‑Test, these are terminated after asking for confirmation. If this option is turned off, the clients are terminated unconditionally.","hash":"opt_askstopclients","hp":"Client options","h4":"Ask whether to stop clients before exiting (User)"},"1108":{"id":1108,"content":"When terminating a process, kill its whole process tree (System) Server script name: OPT_PLAY_KILL_PROCESS_TREE The process of an SUT or a helper program started during a test can be terminated via a Stop client node or manually via the »Client« menu. In case of an SUT, QF‑Test first tries to communicate with it and initiate a clean System.exit call. Non-Java programs have to be killed. If the program has started further child processes these may or may not get terminated by a normal shutdown or kill, depending on circumstances. It is normally undesirably to keep such processes around as they might interfere with other tests or lock files that need to be removed or overwritten. Unless this option is disabled, QF‑Test will try to determine the whole process hierarchy for any program it started and make sure that the main process and all child processes get killed explicitly.","hash":"opt_killprocesstree","hp":"Client options","h4":"When terminating a process, kill its whole process tree (System)"},"1109":{"id":1109,"content":"Number of terminated clients in menu (User) Server script name: OPT_PLAY_MAX_CLIENTS This option limits the number of menu items for terminated clients that are kept in the »Clients« menu.","hash":"opt_numclients","hp":"Client options","h4":"Number of terminated clients in menu (User)"},"1110":{"id":1110,"content":"Maximum size of client terminal (kB) (User) Server (automatically forwarded to SUT) script name: OPT_PLAY_TERMINAL_SIZE The maximum amount of text (in kilobyte) that the individual client terminal will hold. If the limit is exceeded, old text will be removed when new text arrives. A value of 0 means no limit. This option also determines the amount of output available for the special variables ${qftest:client.output.<name>}, ${qftest:client.stdout.<name>} and ${qftest:client.stderr.<name>}.","hash":"opt_clientoutputsize","hp":"Client options","h4":"Maximum size of client terminal (kB) (User)"},"1111":{"id":1111,"content":"Highlight selected component in the SUT (User) Server script name: OPT_PLAY_HIGHLIGHT_COMPONENTS If this option is set, QF‑Test will highlight the associated component in the SUT whenever a Component node or a node that references a Component is selected.","hash":"opt_flashcomponent","hp":"Client options","h4":"Highlight selected component in the SUT (User)"},"1112":{"id":1112,"content":"How to handle exceptions in the SUT (System) SUT script name: OPT_PLAY_SUT_EXCEPTION_LEVEL Possible Values: VAL_PLAY_EXCEPTION_LEVEL_WARNING, VAL_PLAY_EXCEPTION_LEVEL_ERROR, VAL_PLAY_EXCEPTION_LEVEL_EXCEPTION Exceptions that are thrown during event handling in the SUT are typically a sure sign for a bug in the SUT. This option determines what to do if such an exception is caught. You can Log a warning message Log an error message Throw an UnexpectedClientException","hash":"opt_clientexceptionlevel","hp":"Client options","h4":"How to handle exceptions in the SUT (System)"},"1113":{"id":1113,"content":"Reuse IDs for SUT clients in nested sub-processes (System) Server script name: OPT_PLAY_REUSE_SUT_IDS This is a complex option which you should hopefully never care about. When an SUT client launches another process that itself connects to QF‑Test, the new SUT client is identified by the name of the original SUT client with a ':' and a numeric ID appended. The first ID will always be 2, with increasing numbers for additional sub-processes. When a sub-process terminates and another sub-process connects, QF‑Test can either reuse the ID of the terminated process or continue incrementing to create a new ID. In most cases it is preferable to reuse the sub-process ID. The most common case is a single sub-process that is started, terminated, then started again. By activating this option you can always address the single sub-process with the same client name. In a more complex situation, multiple sub-processes may be launched and terminated more or less at random, depending on progression of the test run. In such a case, always incrementing the ID for a new process is more deterministic. In either case the ID counter will be reset when the original SUT client is started anew.","hash":"opt_reusesubclientids","hp":"Client options","h4":"Reuse IDs for SUT clients in nested sub-processes (System)"},"1114":{"id":1114,"content":"Automatically perform garbage collection in the SUT (System) SUT script name: OPT_PLAY_SUT_GARBAGE_COLLECTION By default QF‑Test performs a full garbage collection in the SUT once every few hundred SUT script executions. This is necessary due to a limitation in Java's default garbage collection mechanism that allows an OutOfMemoryError to happen for the so called PermGen space, even though the required memory could easily be reclaimed by a garbage collection. When you are trying to analyze the memory performance of your application, these explicit garbage collections might influence the results. For that case you can disable QF‑Test's garbage collection via this option.","hash":"opt_garbagecollectsut","hp":"Client options","h4":"Automatically perform garbage collection in the SUT (System)"},"1115":{"id":1115,"content":"Terminal options Various settings for the shared terminal can be adjusted with the following options:","hash":"sec_opt_terminal","h1":"Terminal options"},"1116":{"id":1116,"content":"Figure 33.24: Terminal options","hash":"figure_33.24","h4":"Figure 33.24: Terminal options"},"1117":{"id":1117,"content":"Maximum size of shared terminal (kB) (User) Server script name: OPT_PLAY_SHARED_TERMINAL_SIZE The maximum amount of text (in kilobyte) that the shared terminal will hold. If the limit is exceeded, old text will be removed when new text arrives. A value of 0 means no limit.","hash":"opt_terminalsize","hp":"Terminal options","h4":"Maximum size of shared terminal (kB) (User)"},"1118":{"id":1118,"content":"Regular expression to suppress display of certain text (User) By defining a regular expression for this option, certain text in the terminal output can be suppressed. Default value is empty. See also Regular expressions.","hash":"opt_terminalregexpsuppress","hp":"Terminal options","h4":"Regular expression to suppress display of certain text (User)"},"1119":{"id":1119,"content":"Use rich text terminal (User) If activated the rich text terminal allowing monospaced font type and coloring of given regular expressions. Deactivate this option if you want to switch back to the simple terminal as it were before QF‑Test version 4. QF‑Test needs to be restarted in order to make a change in this option become visible.","hash":"opt_terminalrichtext","hp":"Terminal options","h4":"Use rich text terminal (User)"},"1120":{"id":1120,"content":"Use monospaced font (User) If activated the rich text terminal will use a monospaced font. This option only has an effect if the Use rich text terminal is active.","hash":"opt_terminalmonospaced","hp":"Terminal options","h4":"Use monospaced font (User)"},"1121":{"id":1121,"content":"Regular expression coloring (User) If activated the shared terminal output is processed for given regular expressions to be highlighted in different colors. This option only has an effect if Use rich text terminal and Regular expression coloring are active.","hash":"opt_terminalregexpcoloring","hp":"Terminal options","h4":"Regular expression coloring (User)"},"1122":{"id":1122,"content":"Regular expression for red highlighting (User) This option allows to define a regular expression for output to be shown in red color. This option only has an effect if Use rich text terminal and Regular expression coloring are active. Default value is: (?md).+Exception\\b.*\\n(?%gt;\\n?^(?%gt;\\sat|Caused by:)\\s.+\\n)+|.*(?i)exception(?%gt;s)?\\b.* With this also typical Java stack traces will be highlighted. See also Regular expressions.","hash":"opt_terminalregexpcolor0","hp":"Terminal options","h4":"Regular expression for red highlighting (User)"},"1123":{"id":1123,"content":"Regular expression for orange highlighting (User) This option allows to define a regular expression for output to be shown in orange color. The default regular expression matches error log output and lines containing respective text. This option only has an effect if Use rich text terminal and Regular expression coloring are active. Default value is: (?md)^[1-2] \\(\\d\\d:\\d\\d:\\d\\d\\.\\d\\d\\d\\) .*|.*(?i)(?%gt;error(?%gt;s)?|fehler)\\b.* With this also error log messages will be highlighted. See also Regular expressions.","hash":"opt_terminalregexpcolor1","hp":"Terminal options","h4":"Regular expression for orange highlighting (User)"},"1124":{"id":1124,"content":"Regular expression for yellow highlighting (User) This option allows to define a regular expression for output to be shown in yellow color. The default regular expression matches with typical stack traces and exceptions. This option only has an effect if Use rich text terminal and Regular expression coloring are active. Default value is: (?md)^[3-4] \\(\\d\\d:\\d\\d:\\d\\d\\.\\d\\d\\d\\) .*|.*(?i)(?%gt;warning(?%gt;s)?|warnung(?%gt;en)?)\\b.* With this also warning log messages will be highlighted. See also Regular expressions.","hash":"opt_terminalregexpcolor2","hp":"Terminal options","h4":"Regular expression for yellow highlighting (User)"},"1125":{"id":1125,"content":"Regular expression for blue highlighting (User) This option allows to define a regular expression for output to be shown in blue color. The default regular expression matches with typical stack traces and exceptions. This option only has an effect if Use rich text terminal and Regular expression coloring are active.","hash":"opt_terminalregexpcolor3","hp":"Terminal options","h4":"Regular expression for blue highlighting (User)"},"1126":{"id":1126,"content":"Regular expression for green highlighting (User) This option allows to define a regular expression for output to be shown in green color. The default regular expression matches with typical stack traces and exceptions. This option only has an effect if Use rich text terminal and Regular expression coloring are active.","hash":"opt_terminalregexpcolor4","hp":"Terminal options","h4":"Regular expression for green highlighting (User)"},"1127":{"id":1127,"content":"Event handling These options influence some details of how events are simulated in the SUT during replay.","hash":"sec_opt_replayevents","h1":"Event handling"},"1128":{"id":1128,"content":"Figure 33.25: Event handling options","hash":"figure_33.25","h4":"Figure 33.25: Event handling options"},"1129":{"id":1129,"content":"Raise SUT windows automatically (System) SUT script name: OPT_PLAY_RAISE_SUT_WINDOWS If this option is set, windows of the SUT for which a MouseEvent or KeyEvent is replayed will be raised automatically when they get activated. This eases switching between QF‑Test and the SUT to visually verify that a sequence is replaying correctly. See also options Raise test suite window after replay and Force window to the top when raising.","hash":"opt_automaticraise","hp":"Event handling","h4":"Raise SUT windows automatically (System)"},"1130":{"id":1130,"content":"Force window to the top when raising (System) SUT script name: OPT_PLAY_RAISE_SUT_WINDOWS_FORCED This option only has an effect on Windows systems. Windows only allows an application to bring one of its own windows to the front if that application currently has the focus. This can make it difficult for QF‑Test to raise SUT windows and to automatically switch between the SUT and QF‑Test. If this option is activated, QF‑Test temporarily sets the \"always on top\" attribute to force windows to the top. See also options Raise test suite window after replay and Raise SUT windows automatically.","hash":"opt_forcedraise","hp":"Event handling","h4":"Force window to the top when raising (System)"},"1131":{"id":1131,"content":"Check for modal dialogs (System) SUT script name: OPT_PLAY_CHECK_MODAL A modal dialog is a window that blocks all input to other windows until it is closed. It is often used to display an error message or request user input. Because the events simulated by QF‑Test are artificial, they are not blocked by a modal dialog and can reach any window. This is normally not desirable, since the existence of a modal dialog may signal an unexpected error. Activating this option causes QF‑Test to check for modal dialogs itself before replaying MouseEvents or KeyEvents. If such an event is targeted to a window that is blocked by a modal dialog, a ModalDialogException is thrown.","hash":"opt_checkmodaldialog","hp":"Event handling","h4":"Check for modal dialogs (System)"},"1132":{"id":1132,"content":"Actually move mouse cursor (System) SUT script name: OPT_PLAY_MOVE_MOUSE_CURSOR If this option is set, the mouse cursor is actually moved across the screen as MouseEvents are simulated. This feature requires a working AWT robot. While this option is mainly intended to give visual feedback, it can have a positive impact on test reliability because it reduces side-effects through events from the underlying system that might interfere with the automated test. However, for tests where precise mouse movement is essential, for example a drawing tool, this option should be turned off.","hash":"opt_hardmousemoves","hp":"Event handling","h4":"Actually move mouse cursor (System)"},"1133":{"id":1133,"content":"Hold back system events during replay (ms) (System) SUT script name: OPT_PLAY_DELAY_HARD_EVENTS Only applies to Swing and SWT testing. During event replay QF‑Test blocks or delays some events that are not initiated by QF‑Test but come directly from the system, for example when the user is moving the mouse cursor. This is done to prevent them from interfering with the SUT in an unlucky moment. Popup windows, which are used for menus and combo boxes among other things, are especially sensitive to such events which can cause them to pop down accidentally. Therefore, these filters improve testing stability. This option sets the maximum time that such events may be delayed. In the unlikely case that the filters have unwanted side effects with your application, you can turn them off by setting the value to 0.","hash":"opt_blockhardevents","hp":"Event handling","h4":"Hold back system events during replay (ms) (System)"},"1134":{"id":1134,"content":"Scroll automatically to display sub-items (System) SUT script name: OPT_PLAY_SCROLL_ITEM If this option is set, accessing a sub-item of a complex component inside a scroll pane will automatically cause the sub-item to be scrolled into view. In that case you can remove most recorded events on scroll bars or scroll buttons, which are not required for correct replay.","hash":"opt_autoscroll","hp":"Event handling","h4":"Scroll automatically to display sub-items (System)"},"1135":{"id":1135,"content":"Expand tree nodes as needed (System) SUT script name: OPT_PLAY_EXPAND_TREE When accessing nodes of a tree component as hierarchic sub-items it is possible to select a node that is not visible because one of its ancestral nodes is not expanded. If this option is set, all ancestors of the node will be expanded as needed. Otherwise this situation leads to a ComponentNotFoundException.","hash":"opt_treeexpand","hp":"Event handling","h4":"Expand tree nodes as needed (System)"},"1136":{"id":1136,"content":"Throw DisabledComponentException (System) SUT script name: OPT_PLAY_THROW_DISABLED_EXCEPTION If QF‑Test replays events on a component that is not enabled, these events are ignored silently. In most cases this indicates an error which is signaled by throwing a DisabledComponentException. Old test suites may not be prepared to deal with this exception. These test suites should be fixed, but as a quick workaround DisabledComponentExceptions can be suppressed by deactivating this option.","hash":"opt_throwdisabled","hp":"Event handling","h4":"Throw DisabledComponentException (System)"},"1137":{"id":1137,"content":"Default algorithm for image checks (System) Server script name: OPT_PLAY_IMAGE_CHECK_DEFAULT_ALGORITHM Via the Algorithm for image comparison attribute of a Check image step it is possible to specify which algorithm should be used by QF‑Test for image comparison. Similarly rc.checkImageAdvanced also knows an algorithm argument. If this attribute or in case of rc.checkImageAdvanced this argument is left empty, the algorithm specified in this Option will be used for image comparison.","hash":"opt_imagecheckdefaultalgo","hp":"Event handling","h4":"Default algorithm for image checks (System)"},"1138":{"id":1138,"content":"Component recognition How component recognition works - and the impact of these options on it - is explained in \"Weighting of recognition features for recorded components\". The pre-defined values should give good results. If you experience problems with component recognition, you can try to improve it by adjusting the probabilities.","hash":"sec_opt_recognition","h1":"Component recognition"},"1139":{"id":1139,"content":"Figure 33.26: Component recognition options The name of a component plays a special role. The following option affects the impact of names:","hash":"figure_33.26","h4":"Figure 33.26: Component recognition options"},"1140":{"id":1140,"content":"Name override mode (replay) (System) SUT script name: OPT_PLAY_RECOGNITION_NAME_OVERRIDE Possible Values: VAL_NAME_OVERRIDE_EVERYTHING, VAL_NAME_OVERRIDE_HIERARCHY, VAL_NAME_OVERRIDE_PLAIN There are two versions of this option which are closely related. This one is effective during replay, the other one during recording. Obviously, both options should always have the same value. There's one exception though: When migrating from one setting to another, QF‑Test's components have to be updated. During that process, keep this option at the old setting and change the record option to the new one. Be sure to update the replay setting after updating the components. This option determines the weight given to the names of components for component recognition. Possible choices are: Hierarchical resolution This choice should be used if component names are not unique on a per-window basis, but naming is still used consistently so that two components with identical names have at least parent components or ancestors with distinct names. That way, component recognition is still tolerant to a lot of change, but if a named component is moved to a different named parent in the SUT, the test suite will have to be updated to reflect the change. Plain attribute If there are components with identical names in the SUT within the same parent component you must use this setting. The name will still play an important role in component recognition, but not much more than the Feature attribute. The algorithm for component recognition is very tolerant and biased towards finding a match. If the best match is not perfect QF‑Test logs information about the encountered differences, either as a warning or a plain message, depending on the following options:","hash":"opt_nameoverride","hp":"Component recognition","h4":"Name override mode (replay) (System)"},"1141":{"id":1141,"content":"Log missing name (System) SUT script name: OPT_PLAY_WARN_MISSING_NAME If this option is set, a message will be logged whenever a component is targeted that does not have a name, but QF‑Test \"thinks\" it should have one. A plausible name is suggested where possible.","hash":"opt_warnformissingname","hp":"Component recognition","h4":"Log missing name (System)"},"1142":{"id":1142,"content":"Log ambiguous name (System) SUT script name: OPT_PLAY_WARN_AMBIGUOUS_NAME If the option Name override mode (replay) is set to \"Override everything\" or \"Hierarchical resolution\", a message is logged whenever QF‑Test encounters more than one potential target components with the same name. That message can be suppressed with the help of this option.","hash":"opt_warnforduplicatename","hp":"Component recognition","h4":"Log ambiguous name (System)"},"1143":{"id":1143,"content":"Log feature mismatch (System) SUT script name: OPT_PLAY_WARN_FEATURE_MISMATCH A component is considered to have a \"feature mismatch\" if it is determined by QF‑Test as the target best suited for an event or check even though at one or more levels of the hierarchy the recorded Feature attribute did not match the current state of the component. If this option is activated, feature mismatches are logged, notifying you that it may be a good idea to update the affected components.","hash":"opt_warnforfeaturemismatch","hp":"Component recognition","h4":"Log feature mismatch (System)"},"1144":{"id":1144,"content":"Log extra feature mismatch (System) SUT script name: OPT_PLAY_WARN_EXTRA_FEATURE_MISMATCH An \"extra feature mismatch\" is similar to a feature mismatch as explained above, except that it applies to extra features with status \"should match\". If this option is activated, extra feature mismatches are logged, notifying you that it may be a good idea to update the affected components.","hash":"opt_warnforextrafeaturemismatch","hp":"Component recognition","h4":"Log extra feature mismatch (System)"},"1145":{"id":1145,"content":"Log structure mismatch (System) SUT script name: OPT_PLAY_WARN_STRUCTURE_MISMATCH A \"structure mismatch\" is similar to a feature mismatch as explained above, except that instead of the feature it is the structure information represented by the attributes Class index and Class count where the mismatch occurred. If this option is activated, structure mismatches are logged, notifying you that it may be a good idea to update the affected components.","hash":"opt_warnforstructuremismatch","hp":"Component recognition","h4":"Log structure mismatch (System)"},"1146":{"id":1146,"content":"Log intermediate named ancestor (System) SUT script name: OPT_PLAY_WARN_NAMED_ANCESTOR An \"intermediate named ancestor\" is a direct or indirect parent component of the target component in the SUT which is not part of the component hierarchy in QF‑Test even though it has a name. If the option Name override mode (replay) is set to \"Hierarchical resolution\", this is considered as a mismatch, comparable to a feature or structure mismatch. If this option is activated, interferences through intermediate named ancestors are logged, notifying you that it may be a good idea to update the affected components.","hash":"opt_warnforintermediatenamedancestor","hp":"Component recognition","h4":"Log intermediate named ancestor (System)"},"1147":{"id":1147,"content":"Log warning instead of message (System) SUT script name: OPT_PLAY_COMPONENT_WARNINGS If this option is activated, deviations from the expected values during component recognition are logged as warnings instead of plain messages. It can be useful to temporarily activate this option to increase the visibility of such deviations, either to update the respective component information or to seek out false positive matches. For normal testing this creates too much noise and tends to obscure more interesting warnings. For an explanation of the remaining options for component recognition please refer to \"Weighting of recognition features for recorded components\". The respective SUT script names for these options are: OPT_PLAY_RECOGNITION_BONUS_NAME OPT_PLAY_RECOGNITION_PENALTY_NAME OPT_PLAY_RECOGNITION_BONUS_FEATURE OPT_PLAY_RECOGNITION_PENALTY_FEATURE OPT_PLAY_RECOGNITION_BONUS_EXTRAFEATURE OPT_PLAY_RECOGNITION_PENALTY_EXTRAFEATURE OPT_PLAY_RECOGNITION_BONUS_STRUCTURE OPT_PLAY_RECOGNITION_PENALTY_STRUCTURE OPT_PLAY_RECOGNITION_PENALTY_MODAL OPT_PLAY_RECOGNITION_MINIMUM_PROBABILITY","hash":"opt_componentwarnings","hp":"Component recognition","h4":"Log warning instead of message (System)"},"1148":{"id":1148,"content":"Delays Here values can be set for various delays.","hash":"sec_opt_delays","h1":"Delays"},"1149":{"id":1149,"content":"Figure 33.27: Delay options","hash":"figure_33.27","h4":"Figure 33.27: Delay options"},"1150":{"id":1150,"content":"Default delays (ms) (System) Server script name: OPT_PLAY_DELAY_BEFORE, OPT_PLAY_DELAY_AFTER These two options set the delay in milliseconds before and after the execution of a node. If a node defines its own Delay before/after, its value overrides this default. These options are useful to slow a test down so you'll be able to follow it.","hash":"opt_defaultdelay","hp":"Delays","h4":"Default delays (ms) (System)"},"1151":{"id":1151,"content":"Drag&Drop and interpolation of mouse movement Simulating Drag&Drop is non-trivial. It is made possible only by generating \"hard\" mouse events that actually move the mouse cursor. On Windows systems, some mouse drivers can interfere with these \"hard\" events. See \"Drag&Drop\" for further details about Drag&Drop. To make Drag&Drop as reliable as possible, movement of the mouse cursor is highly configurable. Since the requirements for Drag&Drop and hard mouse events differ from those for general mouse moves which only provide visual feedback, two sets of options are provided. The settings for demo mouse moves are ignored unless the respective option Actually move mouse cursor is activated. Typically movements for Drag&Drop and hard events should be slower and involve more interpolation steps than those for demo moves, which could slow down a test considerably. All of the following values influence the overall speed of mouse moves. A little experimentation may be required to get the desired effect.","hash":"sec_opt_robot","h1":"Drag&Drop and interpolation of mouse movement"},"1152":{"id":1152,"content":"Delay (ms) (System) SUT script name: OPT_PLAY_DND_DELAY, OPT_PLAY_MOVEMOUSE_DELAY After each single movement of the mouse cursor QF‑Test will wait for the specified number of milliseconds. This value should be between 2 and 20 if interpolation is enabled and between 20 and 200 if interpolation is turned off. With interpolation, 10 is a good value for Drag&Drop and 5 for demo mouse moves.","hash":"opt_robotdelay","hp":"Drag&Drop and interpolation of mouse movement","h4":"Delay (ms) (System)"},"1153":{"id":1153,"content":"Interpolation step size (System) SUT script name: OPT_PLAY_DND_STEP, OPT_PLAY_MOVEMOUSE_STEP The size of the steps for interpolation of mouse movement. Set this to 0 to turn interpolation off. Good values are between 1 and 3 for Drag&Drop and between 2 and 10 for demo mouse moves.","hash":"opt_robotstep","hp":"Drag&Drop and interpolation of mouse movement","h4":"Interpolation step size (System)"},"1154":{"id":1154,"content":"Acceleration (System) SUT script name: OPT_PLAY_DND_ACCELERATION, OPT_PLAY_MOVEMOUSE_ACCELERATION To avoid needless slowdown of tests, long distance mouse movement can be accelerated. A value of 0 turns off acceleration. Useful values range from 1 for very little acceleration to 10 or more for high acceleration. Good values are between 3 and 5 for Drag&Drop and between 6 and 20 for demo mouse moves.","hash":"opt_robotacceleration","hp":"Drag&Drop and interpolation of mouse movement","h4":"Acceleration (System)"},"1155":{"id":1155,"content":"Acceleration threshold (System) SUT script name: OPT_PLAY_DND_THRESHOLD, OPT_PLAY_MOVEMOUSE_THRESHOLD To ensure that small movements as well as the start end end of each movement remain precise, acceleration is turned off for movements that require less than this threshold's number of steps. Good values are between 4 and 8 for Drag&Drop and between 0 and 6 for demo mouse moves.","hash":"opt_robotthreshold","hp":"Drag&Drop and interpolation of mouse movement","h4":"Acceleration threshold (System)"},"1156":{"id":1156,"content":"Timeouts These timeouts are essential for reliable replay of tests under varying conditions. They define how long QF‑Test waits for a component to be in the proper state for an event before throwing an exception. Don't make these values too small, so a little hiccup due to high load won't interrupt a test needlessly. QF‑Test continues as soon as the conditions for replaying an event are met, so higher values for the timeouts won't slow down execution (except for focus, see below). On the other hand, don't set any values higher than a few seconds or you'll have to wait too long until you finally get an error message when a component is truly not found.","hash":"sec_opt_autodelay","h1":"Timeouts"},"1157":{"id":1157,"content":"Figure 33.28: Timeout options","hash":"figure_33.28","h4":"Figure 33.28: Timeout options"},"1158":{"id":1158,"content":"Deadlock detection (s) (System) Server script name: OPT_PLAY_TIMEOUT_DEADLOCK If the SUT does not react for the given time, a DeadlockTimeoutException is thrown. Setting this value to 0 will suppress deadlock detection.","hash":"opt_deadlocktimeout","hp":"Timeouts","h4":"Deadlock detection (s) (System)"},"1159":{"id":1159,"content":"Wait for GUI engine (ms) (System) SUT script name: OPT_PLAY_TIMEOUT_ENGINE This option is useful only for multi-engine SUTs, like Eclipse with embedded AWT/Swing components. A Wait for client to connect node finishes as soon as the first GUI engine connects to QF‑Test, unless its GUI engine attribute specifies to wait for a specific engine. To prevent a subsequent Wait for component to appear node for a component of the wrong engine from failing immediately, QF‑Test first waits for the time specified with this option to give the second GUI engine a chance to connect also.","hash":"opt_waitforengine","hp":"Timeouts","h4":"Wait for GUI engine (ms) (System)"},"1160":{"id":1160,"content":"Wait for non-existent component (ms) (System) SUT script name: OPT_PLAY_TIMEOUT_COMPONENT The maximum time in milliseconds that QF‑Test waits for the target component of an event to become visible. When the connection between QF‑Test and the SUT is established, this option is temporarily set to at least 30000 ms so as to allow the SUT time for its initialization.","hash":"opt_waitforcomponent","hp":"Timeouts","h4":"Wait for non-existent component (ms) (System)"},"1161":{"id":1161,"content":"Wait for non-existent item (ms) (System) SUT script name: OPT_PLAY_TIMEOUT_ITEM If an event is targeted on a sub-item of a complex component, QF‑Test first waits for the component to become visible. Then it gives the SUT the chance to make the intended sub-item available before this timeout is exceeded.","hash":"opt_waitforsubitem","hp":"Timeouts","h4":"Wait for non-existent item (ms) (System)"},"1162":{"id":1162,"content":"Default timeout for checks (ms) (System) Server script name: OPT_PLAY_CHECK_TIMEOUT This option defines a default timeout for Check nodes that have no Timeout attribute set and that represent an actual check in the report instead of being used for test control flow, i.e. checks that don't throw an exception and don't set a result variable or that have a @report doctag. If your tests include a lot of Check nodes without explicitly defined Timeout that are expected to fail - which is unlikely for the actual checks described above - you may be able speed up test execution by setting this value to 0. However, it would be preferable to set the Timeout attribute of the respective nodes to 0 instead and leave this option unchanged because it increases general stability of check execution.","hash":"opt_defaultchecktimeout","hp":"Timeouts","h4":"Default timeout for checks (ms) (System)"},"1163":{"id":1163,"content":"Wait for modal dialog (ms) (System) SUT script name: OPT_PLAY_TIMEOUT_MODAL If an event is targeted at a window that is blocked by a modal dialog, a ModalDialogException will be thrown. However, modal dialogs are often temporary, informing the user about some ongoing processing. If this option is set to a non-zero value, QF‑Test will wait for the given time before it throws the exception. If the modal dialog disappears before the time limit is exceeded, the test will continue immediately. This greatly simplifies handling of temporary modal dialogs. If the option Convert opening of a window into Wait for component to appear is activated, recording a sequence of events during which a temporary dialog is displayed may result in a Wait for component to appear node for that dialog. If the dialog is displayed for a short time only, it is best to remove such nodes to avoid timing issues. If the SUT employs temporary modal dialogs often it may be best to disable the option Convert opening of a window into Wait for component to appear .","hash":"opt_waitformodal","hp":"Timeouts","h4":"Wait for modal dialog (ms) (System)"},"1164":{"id":1164,"content":"Wait for button/menu enable (ms) (System) SUT script name: OPT_PLAY_TIMEOUT_ENABLED A MouseEvent on a button or menu item is simply ignored, if the component is not enabled. This could lead to unwanted side effects during a test, so QF‑Test waits until the component is enabled or the specified timeout is exceeded. If the component does not become activated within the given time, a DisabledComponentException is thrown unless the option Throw DisabledComponentException is deactivated.","hash":"opt_waitforactivation","hp":"Timeouts","h4":"Wait for button/menu enable (ms) (System)"},"1165":{"id":1165,"content":"Wait for focus (ms) (System) SUT script name: OPT_PLAY_TIMEOUT_FOCUS If set, this timeout causes QF‑Test to wait for a component to get the keyboard focus before it simulates any KeyEvents on it. This option actually can slow down a test noticeably if a component fails to get the focus, so don't set it higher than about 100. A good value is 20.","hash":"opt_waitforfocus","hp":"Timeouts","h4":"Wait for focus (ms) (System)"},"1166":{"id":1166,"content":"Poll interval for component wait (ms) (System) SUT script name: OPT_PLAY_POLL_COMPONENT When waiting for a component in the SUT to appear, QF‑Test can't always rely on Java's event mechanism. Instead it has to repeatedly scan the SUT for the component. This option determines the interval between searches.","hash":"opt_componentpollinterval","hp":"Timeouts","h4":"Poll interval for component wait (ms) (System)"},"1167":{"id":1167,"content":"Sub-item poll interval (ms) (System) SUT script name: OPT_PLAY_POLL_ITEM When waiting for a non-existent sub-item in the SUT, QF‑Test can't rely on the event mechanism. Instead it has to repeatedly search the complex component for the sub-item. This option determines the interval between searches.","hash":"opt_subitempollinterval","hp":"Timeouts","h4":"Sub-item poll interval (ms) (System)"},"1168":{"id":1168,"content":"Retry check interval (ms) (System) SUT script name: OPT_PLAY_POLL_CHECK If a Check fails for which a Timeout is defined, QF‑Test repeatedly queries the component's state until either it matches the given values or the time is up. The interval to wait between queries is set with this option.","hash":"opt_checkpollinterval","hp":"Timeouts","h4":"Retry check interval (ms) (System)"},"1169":{"id":1169,"content":"Backward compatibility These options can re-set QF‑Test to older behavior. Those settings have changed that much that QF‑Test cannot keep backward compatibility over all versions.","hash":"sec_opt_replaybw","h1":"Backward compatibility"},"1170":{"id":1170,"content":"Figure 33.29: Options for replay backward compatibility","hash":"figure_33.29","h4":"Figure 33.29: Options for replay backward compatibility"},"1171":{"id":1171,"content":"Don't evaluate variable boolean attributes (before 4.2) (System) Server script name: OPT_PLAY_DONT_EVALUATE_BOOLEAN_OPTIONS Expressions in values of attributes with variable boolean values will be evaluated by Jython since 4.2.0. Such attributes are attributes like the Replay as \"hard\" event attribute of Mouse event node or the Modal attribute of Window nodes.","hash":"opt_evaluatevariablebooleanoptions","hp":"Backward compatibility","h4":"Don't evaluate variable boolean attributes (before 4.2) (System)"},"1172":{"id":1172,"content":"Mobile Manual","hash":"","h0":"SmartID und qfs:label | QF‑Test Manual"},"1173":{"id":1173,"content":"Mobile Manual","hash":"home-link","h0":"SmartID und qfs:label | QF‑Test Manual"},"1174":{"id":1174,"content":"SmartID und qfs:label The following settings define details for capture and replay of SmartIDs and qfs:label* variants. Please see \"SmartID\" and \"qfs:label* variants\" for details.","hash":"sec_opt_smartid","h0":"SmartID und qfs:label"},"1175":{"id":1175,"content":"Figure 33.30: SmartID und qfs:label-Optionen","hash":"figure_33.30","h4":"Figure 33.30: SmartID und qfs:label-Optionen"},"1176":{"id":1176,"content":"SmartID recording (System) Server (automatically forwarded to SUT) script name: OPT_RECORD_SMARTID If this option is active, SmartIDs will be recorded instead of components where possible.","hash":"opt_recordsmartid","hp":"SmartID und qfs:label","h4":"SmartID recording (System)"},"1177":{"id":1177,"content":"Always record class for SmartID (System) Server (automatically forwarded to SUT) script name: OPT_RECORD_SMARTID_CLASS Prepending the class of the target component is optional for SmartIDs. This option determines whether classes are always prepended when recording SmartIDs or only if required for uniqueness. The option is active by default because - in addition to improved readability and clarity - having the class in a SmartID improves replay performance significantly.","hash":"opt_recordsmartidclass","hp":"SmartID und qfs:label","h4":"Always record class for SmartID (System)"},"1178":{"id":1178,"content":"Always record qualifier for SmartID (System) Server (automatically forwarded to SUT) script name: OPT_RECORD_SMARTID_QUALIFIER This option determines whether the qualifier for a SmartID gets recorded or not. In the following cases the qualifier will always be rercorded, regardless of the setting: If the SmartID is a qfs:label* variant and the option Recording of qfs:label* variants is set to either \"Record all variants\" or \"Record specific only\". If the SmartID is based on an extra feature not belonging to the qfs:label* variants and the option Priority for recording SmartIDs with qualifier has been set to record the extra feature. If the option Priority for recording SmartIDs with qualifier deviates from its default value and the recorded SmartID is not based on the name.","hash":"opt_recordsmartidqualifier","hp":"SmartID und qfs:label","h4":"Always record qualifier for SmartID (System)"},"1179":{"id":1179,"content":"Priority for recording SmartIDs with qualifier (System) Server (automatically forwarded to SUT) script name: OPT_RECORD_SMARTID_PRIORITIES This comma-separated list of qualifiers determines the order in which criteria for component recognition are applied when recording SmartIDs. The default value of \"name,qlabel,feature\" tells QF‑Test to first look for a name and use it for the SmartID, if available. Next is the test for a qfs:label*-variant and last for a feature. See SmartID for a list of available qualifiers and their meanings. For replay of a SmartID with no explicit qualifier the order is the same as the default value. Thus the search starts by looking for a named component only, then for qfs:label* and feature, which are taken as equivalent and implicitly combined.","hash":"opt_smartidpriorities","hp":"SmartID und qfs:label","h4":"Priority for recording SmartIDs with qualifier (System)"},"1180":{"id":1180,"content":"Maximum length for recorded SmartID value (System) Server (automatically forwarded to SUT) script name: OPT_SMARTID_MAX_VALUE_LENGTH In rare cases, the feature or associated label of a component can be very long. This is not a problem as such and often goes unnoticed if stored in a Component node, but it can be rather unwieldy in a SmartID. For ease of use, values longer than the value given in this option are automatically converted into a regular expression of the given length.","hash":"opt_smartidmaxvaluelength","hp":"SmartID und qfs:label","h4":"Maximum length for recorded SmartID value (System)"},"1181":{"id":1181,"content":"Use SmartID instead of QPath for components inside items (System) Server (automatically forwarded to SUT) script name: OPT_RECORD_SMARTID_INSTEAD_OF_QPATH A component inside an item, e.g. a CheckBox inside a table cell, has to be represented as a pseudo item with special syntax. Starting with QF‑Test version 7, SmartID has replaced the outdated QPath for this task. If this option is deactivated, QPath will be used except when general SmartID recording is active.","hash":"opt_smartidinsteadofqpath","hp":"SmartID und qfs:label","h4":"Use SmartID instead of QPath for components inside items (System)"},"1182":{"id":1182,"content":"Recording of qfs:label* variants (System) SUT script name: OPT_RECORD_QFSLABEL_MODE Possible Values: VAL_RECORD_QFSLABEL_MODE_ALL, VAL_RECORD_QFSLABEL_MODE_SPECIFIC, VAL_RECORD_QFSLABEL_MODE_BEST, VAL_RECORD_QFSLABEL_MODE_LEGACY This option determines which qfs:label* variants are getting recorded as Extra features: The value \"Record all variants\" causes all qfs:label* variants found to be stored in the Extra features. The best label found gets the state \"Should match\", all others the state \"Ignore\". For a SmartID the specific qualifier is recorded (see table qfs:label* variants). With the value \"Record specific only\", only the best rated qfs:label* variant is stored in the Extra features or used as the qualifier in a SmartID. The value \"Record qfs:labelBest only\" tells QF‑Test to only record the best rated qfs:label* variant and store it in the Extra features with the name qfs:labelBest, see Best label. When recording the best label as SmartID with \"Record qfs:labelBest only\", depending on the setting of the option Always record qualifier for SmartID, either no qualifier will be recorded or the specific qualifier of the label. If set to \"Legacy qfs:label mode\", the associated label is determined via the old algorithm from before QF‑Test 7.0. It is stored as qfs:label in the Extra features. For a SmartID the qualifier qlabel is used, but not recorded by default ().","hash":"opt_recordqfslabelmode","hp":"SmartID und qfs:label","h4":"Recording of qfs:label* variants (System)"},"1183":{"id":1183,"content":"Mobile Manual","hash":"","h0":"Android | QF‑Test Manual"},"1184":{"id":1184,"content":"Mobile Manual","hash":"home-link","h0":"Android | QF‑Test Manual"},"1185":{"id":1185,"content":"Android The following options influence the testing of Android applications.","hash":"sec_opt_android","h0":"Android"},"1186":{"id":1186,"content":"Figure 33.31: Options for Android","hash":"figure_33.31","h4":"Figure 33.31: Options for Android"},"1187":{"id":1187,"content":"Android SDK (System) Server script name: OPT_ANDROID_SDK_PATH Enter the installation path of the Android SDK here. This directory is usually named sdk and contains a subdirectory tools or cmdline-tools. This setting is only necessary if QF‑Test can not determine the path automatically.","hash":"opt_androidsdkpath","hp":"Android","h4":"Android SDK (System)"},"1188":{"id":1188,"content":"Log extra android information to run log (System) Server script name: OPT_ANDROID_DEBUG If this option is activated further information is logged in the log.","hash":"opt_androiddebug","hp":"Android","h4":"Log extra android information to run log (System)"},"1189":{"id":1189,"content":"Forward emulator output to QF‑Test terminal (System) Server script name: OPT_ANDROID_FORWARD_EMULATOR_OUTPUT If this option is activated and an emulator was launched via the Launch Android emulator node, then the stdout/stderr output of the launched emulator will be passed on to the QF‑Test terminal.","hash":"opt_androidforwardemulatoroutput","hp":"Android","h4":"Forward emulator output to QF‑Test terminal (System)"},"1190":{"id":1190,"content":"Mobile Manual","hash":"","h0":"iOS | QF‑Test Manual"},"1191":{"id":1191,"content":"Mobile Manual","hash":"home-link","h0":"iOS | QF‑Test Manual"},"1192":{"id":1192,"content":"iOS These options are available to control the testing of iOS applications:","hash":"sec_opt_ios","h0":"iOS"},"1193":{"id":1193,"content":"Figure 33.32: Options for iOS Tests","hash":"figure_33.32","h4":"Figure 33.32: Options for iOS Tests"},"1194":{"id":1194,"content":"Show iOS Device Agent Output (User) SUT script name: OPT_IOS_PRINT_AGENT_OUTPUT Possible Values: VAL_IOS_PRINT_AGENT_OUTPUT_NONE, VAL_IOS_PRINT_AGENT_OUTPUT_INSTRUMENT, VAL_IOS_PRINT_AGENT_OUTPUT_EXEC, VAL_IOS_PRINT_AGENT_OUTPUT_ALL During the start and the execution of iOS tests, a Xcode build is executed to build and run the required device agent. During normal execution, the detailed output of the process is hidden from the terminal. While tracking down errors, it might be helpful to display the process output in the terminal. This can be enabled for the device instrumentation, the execution or both phases of the test.","hash":"opt_iosprintagentoutput","hp":"iOS","h4":"Show iOS Device Agent Output (User)"},"1195":{"id":1195,"content":"Hide simulator when recording window is shown (User) SUT script name: OPT_IOS_AUTO_HIDE_SIMULATOR Possible Values: VAL_IOS_AUTO_HIDE_SIMULATOR_ALWAYS, VAL_IOS_AUTO_HIDE_SIMULATOR_NEVER, VAL_IOS_AUTO_HIDE_SIMULATOR_ONOPEN As with Android testing, the interaction for inspection and test recording has to be performed on a dedicated window, see Record actions and checks for iOS. When using the Simulator to execute the application under test, it can be confusing when the user interface is visible twice - in the Simulator window and in the recording window. To avoid confusion, QF‑Test can automatically hide the Simulator window when the recording window is opened. When you explicitly switch to the Simulator, its window will be reactivated. However, if you choose \"Always\", additionally to hiding the Simulator, switching to the simulator will bring up the recording window - as long as it is open.","hash":"opt_iosautohidesimulator","hp":"iOS","h4":"Hide simulator when recording window is shown (User)"},"1196":{"id":1196,"content":"Close simulator after test (User) SUT script name: OPT_IOS_AUTO_CLOSE_SIMULATOR Possible Values: VAL_IOS_AUTO_CLOSE_SIMULATOR_YES, VAL_IOS_AUTO_CLOSE_SIMULATOR_NO, VAL_IOS_AUTO_CLOSE_SIMULATOR_AUTO To control the iOS device or the Simulator, QF‑Test uses a controller client. If required, the iOS Simulator is started by QF‑Test along with the controller. By default, the Simulator is also closed when the controller client is stopped. During test development, it might be helpful to keep the Simulator running, even when the QF‑Test controller client was stopped. It is possible to define here that the Simulator should not be closed together with the controller, or only if it was opened by the controller client itself.","hash":"opt_iosautoclosesimulator","hp":"iOS","h4":"Close simulator after test (User)"},"1197":{"id":1197,"content":"Restart Simulator if connection is lost (System) SUT script name: OPT_IOS_RESTART_SIMULATOR When the connection to the iOS device gets interrupted during a test run, QF‑Test automatically restarts the device agent to reestablish the connection. If the iOS target device is simulated, QF‑Test by default assumes that the Simulator was closed intentionally to stop the test run. With this option, it is possible to enable the connection recovery also for Simulator connections, including a restart of the Simulator app.","hash":"opt_iosrestartsimulator","hp":"iOS","h4":"Restart Simulator if connection is lost (System)"},"1198":{"id":1198,"content":"Code Signing Team ID / Organizational Unit (System) SUT script name: OPT_XCODE_DEVELOPMENT_TEAM QF‑Test can execute tests on apps running directly on an iOS device. Due to platform restrictions, the device agent, which is temporarily installed on the device to perform the required interactions, has to be automatically signed using a valid iPhone Developer Certificate. To identify the certificate, the Team ID (also known as \"Certificate Organizational Unit\") has to be provided. The Team ID is a unique 10-character string generated by Apple assigned to your team. You can find your Team ID listed under the \"Organizational Unit\" field in your iPhone Developer certificate in your keychain. You can also find your Team ID using your developer account. Sign in to https://developer.apple.com/account, and scroll to the Membership details. Your Team ID appears in the Membership Information section under the team name. To generate a development certificate, open the Settings dialog of Xcode, select the \"Accounts\" tab and add your developer account there using your Apple ID.","hash":"opt_iosxcodeorgid","hp":"iOS","h4":"Code Signing Team ID / Organizational Unit (System)"},"1199":{"id":1199,"content":"Code Signing Identity (System) SUT script name: OPT_XCODE_CODE_SIGN_IDENTITY Normally, this value can be left empty, since Xcode automatically deduces the Signing ID from the certificate specified by the Team ID, but sometimes, a dedicated Signing ID has to be provided (usually Apple Developer or iPhone Developer).","hash":"opt_iosxcodesigningid","hp":"iOS","h4":"Code Signing Identity (System)"},"1200":{"id":1200,"content":"Allow automatic provisioning profile creation (System) SUT script name: OPT_XCODE_ALLOW_PROVISIONING_UPDATES If enabled, a provision profile to execute the agent on the connected device can be created automatically by Xcode during device instrumentation.","hash":"opt_iosxcodeallowprovisioningupdates","hp":"iOS","h4":"Allow automatic provisioning profile creation (System)"},"1201":{"id":1201,"content":"Allow automatic device registration (System) SUT script name: OPT_XCODE_ALLOW_PROVISIONING_DEVICE_REGISTRATION If enabled, a new device can be registered automatically by Xcode during device instrumentation.","hash":"opt_iosxcodeallowprovisioningdeviceregistration","hp":"iOS","h4":"Allow automatic device registration (System)"},"1202":{"id":1202,"content":"Custom iOS Device Agent Bundle ID (System) SUT script name: OPT_IOS_AGENT_BUNDLE_ID Xcode may fail to create a provisioning profile for the agent - especially when using a free developer account. Here it is possible to manually change the bundle id for the agent to something Xcode will accept.","hash":"opt_iosagentbundleid","hp":"iOS","h4":"Custom iOS Device Agent Bundle ID (System)"},"1203":{"id":1203,"content":"Mobile Manual","hash":"","h0":"UI Inspector options | QF‑Test Manual"},"1204":{"id":1204,"content":"Mobile Manual","hash":"home-link","h0":"UI Inspector options | QF‑Test Manual"},"1205":{"id":1205,"content":"UI Inspector options The following options relate to UI inspector settings.","hash":"sec_opt_inspector","h0":"UI Inspector options"},"1206":{"id":1206,"content":"Figure 33.33: UI Inspector options","hash":"figure_33.33","h4":"Figure 33.33: UI Inspector options"},"1207":{"id":1207,"content":"Hotkey for opening the UI inspector (System) SUT script name: OPT_INSPECTOR_HOTKEY The option defines the key or key combination for opening the UI inspector directly from the SUT. with activated selection mode. To change the option please click the field showing the current key or key combination (it is an interactive field) and press the desired key or key combination. To leave the interactive field press the tab key or do a mouse click to a different field. The default key is Ctrl⁠+⁠Shift⁠+⁠F11 for Window/Linux and ⇧⁠+⁠⌃⁠+⁠F11 for Mac. Detailed information on the inspector can be found in \"UI Inspector\".","hash":"opt_inspectorhotkey","hp":"UI Inspector options","h4":"Hotkey for opening the UI inspector (System)"},"1208":{"id":1208,"content":"Hotkey for activating component selection in the UI inspector (System) SUT script name: OPT_INSPECTOR_MODE_HOTKEY The option defines the key or key combination for activating component selection mode in the inspector directly from the SUT. (The UI inspector will be opened as well when not open.) To change the option please click the field showing the current key or key combination (it is an interactive field) and press the desired key or key combination. To leave the interactive field press the tab key or do a mouse click to a different field. The default key is Ctrl⁠+⁠Shift⁠+⁠F12 for Window/Linux and ⇧⁠+⁠⌃⁠+⁠F12 for Mac. Detailed information on the inspector can be found in \"UI Inspector\".","hash":"opt_inspectormodehotkey","hp":"UI Inspector options","h4":"Hotkey for activating component selection in the UI inspector (System)"},"1209":{"id":1209,"content":"Mobile Manual","hash":"","h0":"Artificial Intelligence | QF‑Test Manual"},"1210":{"id":1210,"content":"Mobile Manual","hash":"home-link","h0":"Artificial Intelligence | QF‑Test Manual"},"1211":{"id":1211,"content":"Artificial Intelligence The following options serve to integrate LLMs (\"Large Language Models\") with QF‑Test.","hash":"sec_opt_llmintegration","h0":"Artificial Intelligence"},"1212":{"id":1212,"content":"Figure 33.34: AI options","hash":"figure_33.34","h4":"Figure 33.34: AI options"},"1213":{"id":1213,"content":"LLM Configurations (System) Server script name: OPT_LLM_PROVIDERS In this table you can make third-party LLMs usable in QF‑Test, for example to use them with the Check text with AI or ai.ask() (see The ai module). Each line represents a specific language model. The following table columns are available: Type The name of the API provider or type. If the API type you need is not yet available, please get in touch with our support team. Name The name of this configuration. Used to reference it in other places. URL The URL at which the LLM can be accessed. Please get this information from the documentation of the LLM provider. Usually ends with /v1 or similar. API key The API key serves to authenticate with the respective LLM provider. Get it from your LLM provider. Model name Many providers offer multiple LLM models like \"gpt-4o\" or \"gemini-2.0-flash\". You can learn about the actually available model names from your LLM provider.","hash":"opt_LLMProviders","hp":"Artificial Intelligence","h4":"LLM Configurations (System)"},"1214":{"id":1214,"content":"Prompt templates (System) Server script name: OPT_LLM_PROMPT_TEMPLATES In this table you can configure templates for LLM requests, to use with Check text with AI, for example. Each line represents a specific template. The following table columns are available: Name The name of this template with which it can be referenced elsewhere. Template The text content of the template which would be sent to an LLM. The following placeholders are available: {{context}}: Additional application-specific information, see Check context. {{goodCompletions}}: A list of example results which should be interpreted as positive. {{badCompletions}}: A list of example results which should be interpreted as negative. {{completion}}: The actual result, e.g. from a Check text with AI. {{positiveResponse}}: The string configured in \"Positive response\", to teach the model how to reply. {{negativeResponse}}: The string configured in \"Negative response\", to teach the model how to reply. Positive response The response text that should be considered positive, e.g. \"yes\". Case-insensitive. Negative response The response text that should be considered negative, e.g. \"no\". Case-insensitive.","hash":"opt_LLMPromptTemplates","hp":"Artificial Intelligence","h4":"Prompt templates (System)"},"1215":{"id":1215,"content":"Default timeout for LLM requests (ms) (System) Server script name: OPT_LLM_REQUEST_TIMEOUT The default timeout for LLM requests in milliseconds. If a request, like in the context of a Check text with AI, takes longer than the configured duration, an exception is thrown.","hash":"opt_LLMRequestTimeout","hp":"Artificial Intelligence","h4":"Default timeout for LLM requests (ms) (System)"},"1216":{"id":1216,"content":"Disable SSL verification for LLM requests (System) Server script name: OPT_LLM_REQUEST_DISABLE_SSL_VERIFICATION In case SSL issues occur during communication with an LLM, you can use this option to disable SSL verification for all network communication with external LLM models.","hash":"opt_LLMRequestDisableSSLVerification","hp":"Artificial Intelligence","h4":"Disable SSL verification for LLM requests (System)"},"1217":{"id":1217,"content":"Mobile Manual","hash":"","h0":"Debugger options | QF‑Test Manual"},"1218":{"id":1218,"content":"Mobile Manual","hash":"home-link","h0":"Debugger options | QF‑Test Manual"},"1219":{"id":1219,"content":"Debugger options These options modify the behavior of the debugger.","hash":"sec_opt_debugger","h0":"Debugger options"},"1220":{"id":1220,"content":"Figure 33.35: Debugger options","hash":"figure_33.35","h4":"Figure 33.35: Debugger options"},"1221":{"id":1221,"content":"Enable debugger (User) By default the debugger is disabled unless this option, which can also be modified through the menu item »Debugger«-»Enable debugger«, is activated. If a test is interrupted by a breakpoint or be pressing the \"Pause\" button, the debugger is activated automatically. Similarly, starting a test run with \"Step in\" or \"Step over\" will activate the debugger for the duration of that test run.","hash":"opt_enabledebugger","hp":"Debugger options","h4":"Enable debugger (User)"},"1222":{"id":1222,"content":"Always open debugger window (User) When test execution is halted and the debugger entered QF‑Test can optionally open a separate window for the debugger. This option determines whether debugging should happen in a separate window or the normal test suite window.","hash":"opt_alwaysshowdebugger","hp":"Debugger options","h4":"Always open debugger window (User)"},"1223":{"id":1223,"content":"Show variable bindings automatically (User) When test execution is halted and the debugger entered QF‑Test can display the current variable bindings in the workbench window. If this option is active the variables are shown automatically each time a test run first enters the debugger. Alternatively the variables can be viewed in the debugger window or shown in the workbench window via the menu »Debugger«-»Show variables«.","hash":"opt_alwaysshowbindings","hp":"Debugger options","h4":"Show variable bindings automatically (User)"},"1224":{"id":1224,"content":"Automatic breaks (User) These options describe the situations in which execution of a test will be suspended and the debugger entered: Break on uncaught exception The debugger will break if an exception is thrown that will not be handled by a Catch node. Break on error The debugger will break if an error occurs. Break on warning The debugger will break if a warning occurs.","hash":"opt_automaticbreaks","hp":"Debugger options","h4":"Automatic breaks (User)"},"1225":{"id":1225,"content":"Mobile Manual","hash":"","h0":"Run log options | QF‑Test Manual"},"1226":{"id":1226,"content":"Mobile Manual","hash":"home-link","h0":"Run log options | QF‑Test Manual"},"1227":{"id":1227,"content":"Run log options These options let you control which information is collected in a run log, if and when a run log is shown and how to locate errors.","hash":"sec_opt_log","h0":"Run log options"},"1228":{"id":1228,"content":"General run log options","hash":"sec_opt_showrunlog","h1":"General run log options"},"1229":{"id":1229,"content":"Figure 33.36: General run log options","hash":"figure_33.36","h4":"Figure 33.36: General run log options"},"1230":{"id":1230,"content":"When to show run logs (User) A run log is created for every execution of a test. A number of recent run logs are available from the »Run« menu, the most recent run log can also be opened by pressing Control⁠+⁠L. Additionally the run log can be shown during execution or after an error as follows: At start This choice causes QF‑Test to open the run log when it begins executing a test sequence. The nodes of the log will be added as execution proceeds. After finish With this choice the run log is shown after replay is finished. On exception The run log is shown only if an uncaught exception is thrown. Don't show The run log is not displayed automatically. You have to open it via the »Run« menu or by pressing Control⁠+⁠L.","hash":"opt_whentoshowlog","hp":"General run log options","h4":"When to show run logs (User)"},"1231":{"id":1231,"content":"Show relative duration indicators (User) Server script name: OPT_LOG_DURATION_INDICATORS To analyze the run-time behaviour of a test it is helpful to see at a glance which branches are taking up the most time. To that end, display of duration indicators can be activated via this option, which is also directly accessible via the »View« menu of a run log. The length of the bars shown represents the percentage of the time taken for execution of the respective node relative to the time taken by its parent node.","hash":"opt_logdurationindicators","hp":"General run log options","h4":"Show relative duration indicators (User)"},"1232":{"id":1232,"content":"Duration indicator kind (User) Server script name: OPT_LOG_DURATION_INDICATORS_KIND Possible Values: VAL_LOG_DURATION_INDICATORS_KIND_DURATION, VAL_LOG_DURATION_INDICATORS_KIND_REALTIME, VAL_LOG_DURATION_INDICATORS_KIND_BOTH This option determines whether duration indicators show duration, real time spent or both. The difference between the values of \"Duration\" and \"Real time spent\" are explicit delays introduced in nodes via the 'Delay before/after' attribute or user interrupts.","hash":"opt_logdurationindicatorskind","hp":"General run log options","h4":"Duration indicator kind (User)"},"1233":{"id":1233,"content":"Number of run logs in menu (User) A limit for the number of menu items for recent run logs kept in the »Run« menu.","hash":"opt_numberoflogstokeep","hp":"General run log options","h4":"Number of run logs in menu (User)"},"1234":{"id":1234,"content":"Automatically save run logs (User) To prevent excessive memory use through run logs and also to make the most recent run logs persistent between QF‑Test sessions, the recent run logs kept in the »Run« menu are saved automatically to the user configuration directory or the directory defined in the option Directory for run logs. The filename for the run log is based on a timestamp. QF‑Test uses file locks to prevent collisions and accidental removal in case of parallel sessions and automatically keeps the user configuration directory clean by removing unreferenced logs, so there should be no reason to disable this feature. Still, you can do so by disabling this option.","hash":"opt_autosaverecentlogs","hp":"General run log options","h4":"Automatically save run logs (User)"},"1235":{"id":1235,"content":"Directory for run logs (User) By default, run logs created during interactive use of QF‑Test are stored in the user configuration directory. This option can be used to specify a different target directory. This option is interpreted by QF‑Test whenever a test is started. At that point, test suite and global variable bindings are already in place and in contrast to other options it is possible to use QF‑Test variable syntax here. This includes special variables like ${env:HOME} to look up an environment variable or even ${qftest:suite.dir} to save the run log next to the test suite. If the directory is dynamic, like in the latter case, QF‑Test may not be able to clean up old run logs regularly. Errors in variable expansion are silently ignored and the user configuration directory is used instead.","hash":"opt_recentlogdirectory","hp":"General run log options","h4":"Directory for run logs (User)"},"1236":{"id":1236,"content":"Show expanded variable values in tree nodes (User) The nodes in the tree view of a run log can either be displayed with variables expanded to the value they had at run-time or with the original variables. Both views have their use, so you can toggle between them via this option or more quickly via the menu item »View«-»Show nodes expanded«.","hash":"opt_lognodesexpanded","hp":"General run log options","h4":"Show expanded variable values in tree nodes (User)"},"1237":{"id":1237,"content":"Show return values of procedures (User) If this option is active, return values of Procedures are displayed in the tree after the respective Procedure call node. In a run log you can also toggle this option's value via the menu item »View«-»Show procedure return values«.","hash":"opt_logshowreturnvalue","hp":"General run log options","h4":"Show return values of procedures (User)"},"1238":{"id":1238,"content":"Skip suppressed errors (User) Like the previous one, this option controls the search for errors in a run log. If activated, warnings, errors or exceptions that have not propagated to the top, are not found. Thus exceptions caught by a Try/Catch clause or messages suppressed through the Maximum error level attribute are skipped. This option is also accessible through the »Edit«-»Skip suppressed errors« menu item.","hash":"opt_finderrorskip","hp":"General run log options","h4":"Skip suppressed errors (User)"},"1239":{"id":1239,"content":"Cleanup tree when jumping to next or previous error (User) When repeatedly jumping to errors in a run log the tree can easily get cluttered with many expanded nodes. If this option is activated, QF‑Test will automatically clean up the tree each time you navigate to an error so that only the parents of the error node are expanded. When viewing split run logs, partial run logs containing an error will remain in memory as long as their nodes are expanded. Keeping this option activated will ensure that partial run logs will be released as soon as possible, keeping memory use manageable even viewing the errors of a very large run logs.","hash":"opt_finderrorcleanup","hp":"General run log options","h4":"Cleanup tree when jumping to next or previous error (User)"},"1240":{"id":1240,"content":"Save compressed run logs (*.qrz) (System) Server script name: OPT_LOG_SAVE_COMPRESSED Run logs can either be saved as plain or as compressed XML files. For large run logs without screenshots the compression factor can be as high as 10, so it's advisable to use compressed logs where possible. The only reason not to use compression is if you want to transform the XML run log afterwards. But even then compressed run logs are an option because the compression method used is standard gzip format, so converting to and from compressed run logs can easily be done using gzip. When saving a log-file interactively you can always switch between compressed or non-compressed format by choosing the appropriate filter or by giving the file the extension .qrz or .qrl. In batch mode, the default run log format is compressed. To create an uncompressed run log, simply specify the extension .qrl in the parameter for the -runlog [<file>] command line argument.","hash":"opt_prefercompressed","hp":"General run log options","h4":"Save compressed run logs (*.qrz) (System)"},"1241":{"id":1241,"content":"Save run log in current XML format with UTF-8 encoding (System) Server script name: OPT_XML_LOG_NEW Starting with QF‑Test version 7.0, run logs are saved in the current XML format with UTF-8 encoding, no indentation and arbitrarily long lines. If you need to fall back to the old format (ISO-8859-1 encoding, 2 characters indentation, line length 78) for use in external tools you can do so by deactivating this option.","hash":"opt_xmllognew","hp":"General run log options","h4":"Save run log in current XML format with UTF-8 encoding (System)"},"1242":{"id":1242,"content":"Options for splitting run logs","hash":"sec_opt_log_splitting","h1":"Options for splitting run logs"},"1243":{"id":1243,"content":"Figure 33.37: Options for splitting run logs","hash":"figure_33.37","h4":"Figure 33.37: Options for splitting run logs"},"1244":{"id":1244,"content":"Create split run logs (User) Server script name: OPT_LOG_SAVE_SPLIT A run log can be split into several parts by setting the Name for separate run log attribute of a Data driver or any of the various test nodes. By turning this option off you can temporarily disable support for split run logs in order to get a normal, single run log without having to modify any Name for separate run log attributes. See \"Split run logs\" for further information about split run logs.","hash":"opt_supportsplitlog","hp":"Options for splitting run logs","h4":"Create split run logs (User)"},"1245":{"id":1245,"content":"Save split run logs as ZIP files (*.qzp) (User) Server script name: OPT_LOG_SAVE_SPLIT_ZIP Split run logs can either be saved as a single ZIP file with the extension .qzp, containing the main run log and all partial logs together, or as a normal .qrl or .qrz run log that is accompanied by a directory with the same base name and the suffix _logs, e.g. the file runlog.qrz plus the directory runlog_logs. This option determines the format in which split run logs are created in interactive mode. It has no effect if the option Automatically save run logs is turned off. See \"Split run logs\" for further information about split run logs.","hash":"opt_preferzipped","hp":"Options for splitting run logs","h4":"Save split run logs as ZIP files (*.qzp) (User)"},"1246":{"id":1246,"content":"Minimum size for automatic splitting (kB) (System) Server script name: OPT_LOG_AUTO_SPLIT_SIZE This option exclusively applies to Test case and Test set nodes. At other places run logs are split only when Name for separate run log has explicitly been set. Split run logs are the only reliable way to prevent running out of memory during very long running tests or when the run log grows quickly due to screenshots or output from the SUT. They are also more efficient when transforming run logs into reports. However, explicit setting of Name for separate run log attributes requires an understanding of the issues involved and either making decisions about where best to split a run log or tedious typing when trying to split into small pieces. As a compromise, QF‑Test makes a very rough calculation about the size of a run log during executing, taking screenshots and program output into account. When execution of a Test case or Test set has finished and the approximate size of the run log pertaining to that node is larger than the threshold specified in this option, the run log is split off and saved automatically. A value of 0 prevents automatic splitting. See \"Split run logs\" for further information about split run logs.","hash":"opt_autosplitlogthreshold","hp":"Options for splitting run logs","h4":"Minimum size for automatic splitting (kB) (System)"},"1247":{"id":1247,"content":"Name for automatically split 'Test case' run log (System) Server script name: OPT_LOG_AUTO_SPLIT_TESTCASE_NAME This option specifies the name to use for an external log when it is split off automatically after execution of a Test case has finished as described in the previous option. Variables can be used as well as the '%...' placeholders documented for the attribute Name for separate run log. The special variable ${qftest:testcase.splitlogname} is a good base. It expands to a path name created from the name of the Test case with possible parent Test set nodes as directories. See \"Split run logs\" for further information about split run logs.","hash":"opt_testcasesplitlogname","hp":"Options for splitting run logs","h4":"Name for automatically split 'Test case' run log (System)"},"1248":{"id":1248,"content":"Name for automatically split 'Test set' run log (System) Server script name: OPT_LOG_AUTO_SPLIT_TESTSET_NAME This option specifies the name to use for an external log when it is split off automatically after execution of a Test set has finished as described in the option Minimum size for automatic splitting (kB). Variables can be used as well as the '%...' placeholders documented for the attribute Name for separate run log. The special variable ${qftest:testset.splitlogname} is a good base. It expands to a path name created from the name of the Test set with possible parent Test set nodes as directories. See \"Split run logs\" for further information about split run logs.","hash":"opt_testsetsplitlogname","hp":"Options for splitting run logs","h4":"Name for automatically split 'Test set' run log (System)"},"1249":{"id":1249,"content":"Options determining run log content","hash":"sec_opt_log_content","h1":"Options determining run log content"},"1250":{"id":1250,"content":"Figure 33.38: Options determining run log content","hash":"figure_33.38","h4":"Figure 33.38: Options determining run log content"},"1251":{"id":1251,"content":"Log variable expansion (System) Server script name: OPT_LOG_CONTENT_VARIABLE_EXPANSION If this option is activated, every variable expansion is logged.","hash":"opt_logexpansion","hp":"Options determining run log content","h4":"Log variable expansion (System)"},"1252":{"id":1252,"content":"Maximum length of logged variable values (System) Server script name: OPT_LOG_CONTENT_VARIABLE_MAX_VALUE_LENGTH This option determines, how many characters of a variable value will be written into the run log when a variable is set or read. Longer values will be trimmed to the given value. If the option value is negative, no trimming is performed, with '0' no variable values will be logged.","hash":"opt_logvarmaxvaluelength","hp":"Options determining run log content","h4":"Maximum length of logged variable values (System)"},"1253":{"id":1253,"content":"Log parent nodes of components (System) Server script name: OPT_LOG_CONTENT_PARENT_COMPONENTS Setting this option will cause all direct and indirect parent nodes to be logged in addition to the target component node for every event, check, etc.","hash":"opt_logparent","hp":"Options determining run log content","h4":"Log parent nodes of components (System)"},"1254":{"id":1254,"content":"Log level for the SUT (System) Server script name: OPT_LOG_CONTENT_SUT_LEVEL Possible Values: VAL_LOG_SUT_LEVEL_MESSAGE, VAL_LOG_SUT_LEVEL_WARNING, VAL_LOG_SUT_LEVEL_ERROR The level for automatically generated messages in the SUT during replay, e.g. details for component recognition. Only messages with the respective level, i.e. plain messages, warnings or errors will be logged. This option has no effect on messages created explicitly via the Message node, rc.logMessage or qf.logMessage.","hash":"opt_loglevel","hp":"Options determining run log content","h4":"Log level for the SUT (System)"},"1255":{"id":1255,"content":"Number of events to log for error diagnosis (System) SUT script name: OPT_LOG_CONTENT_DIAGNOSIS During replay of a test QF‑Test logs various events and other things going on behind the scenes. This information is quickly discarded except when an error happens. In that case the most recent events are written to a special run log node. The information may also be useful to developers but is mostly required for error diagnosis when requesting support from Quality First Software GmbH. This option determines the number of recent internal events to keep. Setting it to 0 disables the feature altogether. You should not set this value to less than about 400 without a good reason. Because the information is logged only for errors, the cost for gathering it is minimal.","hash":"opt_logdiagnostics","hp":"Options determining run log content","h4":"Number of events to log for error diagnosis (System)"},"1256":{"id":1256,"content":"Create compact run log (System) Server script name: OPT_LOG_CONTENT_COMPACT Activating this option causes QF‑Test to discard every node from a run log that is neither relevant for error diagnosis, nor for the XML/HTML report. After an error or exception, as well as at the end of a test run, the 100 most recent nodes are not discarded, so the most relevant information should remain available. Even large tests should not cause memory issues, provided the option Create split run logs is turned on and used as described in Split run logs. But if you do run out of memory, activating this option can be useful. This option is used only when QF‑Test is run in interactive mode. It is ignored in batch mode (see \"Starting QF‑Test\") to avoid accidental loss of information. To create a compact run log in batch mode, use the -compact command line argument.","hash":"opt_compactlog","hp":"Options determining run log content","h4":"Create compact run log (System)"},"1257":{"id":1257,"content":"Don't create run log (System) Server script name: OPT_LOG_CONTENT_SUPPRESS For very-long-running tests or demos that are run in an endless loop, memory consumption of the run log is an issue, but split run logs are an ideal solution. Before split run logs were available, turning run logs off completely via this option was sometimes the only way to get long-running tests to work. Now this option is only retained for backwards compatibility. In batch mode this option is ignored. To suppress the run log, use the argument -nolog.","hash":"opt_suppresslog","hp":"Options determining run log content","h4":"Don't create run log (System)"},"1258":{"id":1258,"content":"Log SUT output individually (System) SUT script name: OPT_LOG_CONTENT_SPLIT_IO If set, any text that an SUT client prints to its stdout or stderr stream is also logged in the run log. For each interaction with the SUT QF‑Test collects text printed before the event and after the event during synchronization. This makes it possible to associate output like an exception stacktrace that is triggered by an event with the event itself, something that is impossible if all output is kept in a single piece.","hash":"opt_logsplitio","hp":"Options determining run log content","h4":"Log SUT output individually (System)"},"1259":{"id":1259,"content":"Compactify individually logged SUT output (System) Server script name: OPT_LOG_CONTENT_COMPACTIFY_SPLIT_IO Output from an SUT client tends to accumulate and can consume a lot of memory. If this option is activated, individually logged SUT output for events that are no longer of interest can be removed along with the events in compact run logs. Please see the option Create compact run log for further information about compact run logs.","hash":"opt_compactifysplitio","hp":"Options determining run log content","h4":"Compactify individually logged SUT output (System)"},"1260":{"id":1260,"content":"Log comments to run log (System) Server script name: OPT_LOG_COMMENTS_TO_RUNLOG If this option is activated, Component steps are added to the run log.","hash":"opt_logcommentstorunlog","hp":"Options determining run log content","h4":"Log comments to run log (System)"},"1261":{"id":1261,"content":"Wrap lines in exception messages (System) Server script name: OPT_LOG_WRAP_EXCEPTION_MESSAGE If activated, display of exceptions messages in the run log or an error dialog are displayed using word-wrap to break long lines.","hash":"opt_logwrapexceptionmessage","hp":"Options determining run log content","h4":"Wrap lines in exception messages (System)"},"1262":{"id":1262,"content":"Run log options for screenshots","hash":"sec_opt_log_screenshots","h1":"Run log options for screenshots"},"1263":{"id":1263,"content":"Figure 33.39: Run log options for screenshots","hash":"figure_33.39","h4":"Figure 33.39: Run log options for screenshots"},"1264":{"id":1264,"content":"Compress images in run logs and test suites (System) Server script name: OPT_LOG_CONTENT_COMPRESS_SCREENSHOTS If this option is activated, QF‑Test will store new images in test suites and run logs losslessly compressed. This option can reduce the memory consumption of run logs and test suites on disk and in memory significantly. On the other hand, compression and decompression requires some CPU time, so the option can be deactivated for very time-critical test executions.","hash":"opt_screenshotscompress","hp":"Run log options for screenshots","h4":"Compress images in run logs and test suites (System)"},"1265":{"id":1265,"content":"Maximum number of errors with screenshots per run log (System) Server script name: OPT_LOG_CONTENT_SCREENSHOT_MAX The maximum number of screenshots that QF‑Test takes and stores in the run log during a test run on situations of exception or errors. Setting this value to 0 disables taking screenshots entirely, a negative value means unlimited screenshots.","hash":"opt_maximumscreenshots","hp":"Run log options for screenshots","h4":"Maximum number of errors with screenshots per run log (System)"},"1266":{"id":1266,"content":"Count screenshots individually for each split log (System) Server script name: OPT_LOG_CONTENT_SCREENSHOT_PER_SPLIT_LOG If this option is set, each partial log of a split run log may contain the maximum number of screenshots defined above without affecting the count for the main run log. Otherwise, the limit applies for the sum of all parts belonging to the same main run log. See \"Split run logs\" for further information about split run logs.","hash":"opt_maximumscreenshotsperlog","hp":"Run log options for screenshots","h4":"Count screenshots individually for each split log (System)"},"1267":{"id":1267,"content":"Create screenshots of the whole screen upon error (System) Server script name: OPT_LOG_CONTENT_SCREENSHOT_FULLSCREEN Activating this option causes QF‑Test to take an image of the whole screen and save it in the run log when a screenshot is triggered by an exception or error.","hash":"opt_wholescreenshots","hp":"Run log options for screenshots","h4":"Create screenshots of the whole screen upon error (System)"},"1268":{"id":1268,"content":"Limit screenshots to relevant screens (System) Server script name: OPT_LOG_CONTENT_SCREENSHOT_RELEVANT_ONLY If multiple monitors are connected when taking screenshots it may not be desirable to take screenshots of all screens, especially on personal workstations where this might expose private or confidential information. If this option is active (the default), QF‑Test will try to determine the screens on which SUT or QF‑Test windows are showing and exclude the rest.","hash":"opt_relevantscreenshotsonly","hp":"Run log options for screenshots","h4":"Limit screenshots to relevant screens (System)"},"1269":{"id":1269,"content":"Create screenshots of the client's windows upon error in client (System) Server script name: OPT_LOG_CONTENT_SCREENSHOT_WINDOW Activating this option causes QF‑Test to record images of all windows and dialogs of the SUT and store them in the run log when screenshots are triggered due to exceptions or errors coming from that SUT. In many cases this will work even for windows that are covered by other windows or in cases where a full screenshot is not possible, for example when a screen is locked.","hash":"opt_partialscreenshots","hp":"Run log options for screenshots","h4":"Create screenshots of the client's windows upon error in client (System)"},"1270":{"id":1270,"content":"Create screenshots of all client windows upon error (System) Server script name: OPT_LOG_CONTENT_SCREENSHOT_ALL_WINDOWS If this option is active QF‑Test will log images of all windows of all connected SUTs for any exception or error, regardless of where the exception or error is coming from. This option also affects which screens are considered relevant, depending on where SUT windows are showing.","hash":"opt_allclientscreenshots","hp":"Run log options for screenshots","h4":"Create screenshots of all client windows upon error (System)"},"1271":{"id":1271,"content":"Create screenshots for warnings (System) Server script name: OPT_LOG_CONTENT_WARNING_SCREENSHOTS If this option is active, screenshots will also be saved when warnings are logged in the run log. Otherwise this is done for errors and exceptions only.","hash":"opt_warningscreenshots","hp":"Run log options for screenshots","h4":"Create screenshots for warnings (System)"},"1272":{"id":1272,"content":"Log successful advanced image checks (System) Server script name: OPT_LOG_CONTENT_SCREENSHOT_ADVANCED_ALWAYS If this option is activated, QF‑Test will store the expected and actual images as well as the transformed images for successful advanced image checks in the run log. Otherwise these details are kept for failed image checks only. Activating this option can raise the size of the run log drastically so be sure to use it in combination with compact run logs and/or split run logs.","hash":"opt_screenshotsadvancedok","hp":"Run log options for screenshots","h4":"Log successful advanced image checks (System)"},"1273":{"id":1273,"content":"Log the used image into the report when a image check is performed with an image variable. (System) Server script name: OPT_LOG_CONTENT_IMAGE_VARIABLE If this option is enabled, the used image is logged into the run log when a image check is performed with an image variable.","hash":"opt_logimagevariable","hp":"Run log options for screenshots","h4":"Log the used image into the report when a image check is performed with an image variable. (System)"},"1274":{"id":1274,"content":"Options for mapping between directories with test suites","hash":"sec_options_for_mapping_between_directories_with_test_suites","h1":"Options for mapping between directories with test suites"},"1275":{"id":1275,"content":"Figure 33.40: Options for mapping between directories with test suites","hash":"figure_33.40","h4":"Figure 33.40: Options for mapping between directories with test suites"},"1276":{"id":1276,"content":"Directory map for test suites (System) When analyzing a run log it is often necessary to quickly switch between the run log and the respective test suite. However, when running automated tests on different systems like Windows and Linux, the directories from which test suites are loaded during the test vary and there is no automatic way to map between different directory layouts. With this option you can assist QF‑Test in locating test suites. The 'From' column is a glob pattern that must match from the beginning of the path of the test suite stored in the run log to the end of some directory in that path. The 'To' column is the respective replacement for the matching part and can also contain a glob pattern. When searching for the test suite, QF‑Test processes this list top to bottom, performing the replacement for every match found and the first match leading to an actual test suite is used. A glob patterns is a simpler form of a regular expression often used by development tools: An '*' stands for any number of characters up to the next file separator while '**' means 0 or more characters of any kind, including '/'. Some examples: **/test suites All directories named test suites at any depth. T:/test/sut_* All directories starting with sut_ in the T:/test directory.","hash":"opt_suitedirectorymap","hp":"Options for mapping between directories with test suites","h4":"Directory map for test suites (System)"},"1277":{"id":1277,"content":"Mobile Manual","hash":"","h0":"Variables | QF‑Test Manual"},"1278":{"id":1278,"content":"Mobile Manual","hash":"home-link","h0":"Variables | QF‑Test Manual"},"1279":{"id":1279,"content":"Variables The following options pertain to variable binding.","hash":"sec_opt_vars","h0":"Variables"},"1280":{"id":1280,"content":"Figure 33.41: Variable options","hash":"figure_33.41","h4":"Figure 33.41: Variable options"},"1281":{"id":1281,"content":"When binding variables, expand values immediately (System) Server script name: OPT_VARIABLE_IMMEDIATE_BINDING When a set of variable bindings is pushed onto a variable stack, any additional variable references in the values of these variables can either be expanded immediately, or the values can be left unchanged to be expanded lazily as needed. This is explained in detail in \"Immediate and lazy binding\". For immediate expansion turn this option on, for lazy expansion turn it off.","hash":"opt_immediatebinding","hp":"Variables","h4":"When binding variables, expand values immediately (System)"},"1282":{"id":1282,"content":"Fall back to lazy binding if immediate binding fails (System) Server script name: OPT_VARIABLE_LAZY_FALLBACK Old tests that rely on lazy variable binding may fail with the new default of immediate binding. If this option is activated, variables that cannot be bound immediately due to references to not-yet-defined variables are bound lazily instead and a warning is issued. To get rid of the warning simply change the value of the respective variable to use explicit lazy binding with '$_'. Please see \"Immediate and lazy binding\" for further information.","hash":"opt_immediatebindingfallback","hp":"Variables","h4":"Fall back to lazy binding if immediate binding fails (System)"},"1283":{"id":1283,"content":"Enable 'Local variable' attribute by default (System) Many nodes have a 'Local variable' attribute that determines whether a result variable should get stored locally or as a global variable. If this option is activated, newly created nodes of that kind will have the 'Local variable' attribute set. Get more information about local and global variables in Variable levels.","hash":"opt_preferlocalvariables","hp":"Variables","h4":"Enable 'Local variable' attribute by default (System)"},"1284":{"id":1284,"content":"Warn, if directly expanded variables in script expressions contain escape characters (System) Server script name: OPT_WARN_FOR_ESCAPE_CHARS_IN_EXPANSIONS_FOR_SCRIPTS It is possible to use variable expansions of the form $(name) or ${group:name} for Script expressions. In some cases the variable value contains unintentionally certain escape characters: If, for example, the variable path has the value C:\\Users\\test\\new (instead of C:\\\\Users\\\\test\\\\new) and is used in a script like \"$(path)\"==\"\", the sequences \\U, \\t, and \\n will be interpreted as escape characters, which can lead to surprising errors. If this option is active, QF‑Test will log a warning in such cases. To avoid such problems, use rc.getStr in scripts (see \"Accessing variables\" for details).","hash":"opt_warnforescapecharsinexpansionsforscripts","hp":"Variables","h4":"Warn, if directly expanded variables in script expressions contain escape characters (System)"},"1285":{"id":1285,"content":"Object classes to exclude from serialization (System) Server script name: OPT_VARIABLE_NO_SERIALIZED_CLASSES Objects stored in QF‑Test variables are automatically serialized when exchanged between processes (see Exchanging variables between processes). For some objects this can lead to problems, most notably objects of the AWT \"Component\" class. With the help of this option, serialization of object variable can be prevented as follows: A variable containing an object of a class (or subclass) listed in this option only provides the original object when retrieved in the originating process. In other processes, the variable only provides the String representation of the content. Furthermore, various kinds of variables can be defined here. These are explained in \"Variables\".","hash":"opt_variablenoserializedclasses","hp":"Variables","h4":"Object classes to exclude from serialization (System)"},"1286":{"id":1286,"content":"Mobile Manual","hash":"","h0":"Runtime only | QF‑Test Manual"},"1287":{"id":1287,"content":"Mobile Manual","hash":"home-link","h0":"Runtime only | QF‑Test Manual"},"1288":{"id":1288,"content":"Runtime only Some options of a more technical nature are not available via the user interface, especially if they are useful only in very specific cases and will do more harm than good in general. As mentioned in the introduction to this chapter, options can be set in Server script or SUT script nodes via rc.setOption(Options.<OPTION_NAME>, <value>) (see \"The rc module: Run context API\" for details). Which kind of step to use is indicated by the text \"Server script name\" or \"SUT script name\" in the documentation of the respective option.","hash":"sec_opt_runtime","h0":"Runtime only"},"1289":{"id":1289,"content":"Connect via QF‑Test agent (System) Server script name: OPT_PLAY_CONNECT_VIA_AGENT QF‑Test version 4 introduced a new mechanism for connecting to an SUT, based on Java agents. It is far more powerful and flexible than the older mechanisms and even a hard requirement for most current SUTs. Thus it should not be turned off without a very good reason. Without the agent an SUT based on Java 9 or newer will not even start. Besides, the agent is a prerequisite for access to JavaFX, embedded browsers and the full functionality of live unit testing.","hash":"opt_connectviaagent","hp":"Runtime only","h4":"Connect via QF‑Test agent (System)"},"1290":{"id":1290,"content":"Instrument AWT EventQueue (System) Server script name: OPT_PLAY_INSTRUMENT_EVENT_QUEUE","hash":"opt_instrumenteventqueue","hp":"Runtime only","h4":"Instrument AWT EventQueue (System)"},"1291":{"id":1291,"content":"Mobile Manual","hash":"","h0":"Elements of a test suite | QF‑Test Manual"},"1292":{"id":1292,"content":"Mobile Manual","hash":"home-link","h0":"Elements of a test suite | QF‑Test Manual"},"1293":{"id":1293,"content":"Elements of a test suite","hash":"sec_suite","h1":"Elements of a test suite"},"1294":{"id":1294,"content":"Mobile Manual","hash":"","h0":"The test suite and its structure | QF‑Test Manual"},"1295":{"id":1295,"content":"Mobile Manual","hash":"home-link","h0":"The test suite and its structure | QF‑Test Manual"},"1296":{"id":1296,"content":"The test suite and its structure There are more than 60 different kinds of nodes for a test suite which are all listed in this chapter. Each node type has a unique set of features. The attributes of a node are displayed and edited in the detail view of the editor. The restrictions that apply to each attribute are listed as well as whether it supports variable expansion (see \"Variables\"). Additional features of a node include the behavior of the node during execution of a test and the kinds of parent and child nodes allowed.","hash":"sec_rootnode","h0":"The test suite and its structure"},"1297":{"id":1297,"content":"Test suite The root node of the tree represents the test suite itself. Its basic structure is fixed. The root node contains an arbitrary number of Test sets or Test cases, followed by the Procedures the Extras and the Windows and components. When executed, the top-level Test sets are executed one by one. Contained in: None Children: An arbitrary number of Test set or Test case nodes, followed by the Procedures, Extras and Windows and components nodes. Execution: The top-level Test set nodes are executed one by one. Attributes:","hash":"step_RootStep","h1":"Test suite"},"1298":{"id":1298,"content":"Figure 34.1: Test suite attributes","hash":"figure_34.1","h4":"Figure 34.1: Test suite attributes"},"1299":{"id":1299,"content":"Name A kind of short description for the test suite. The name is displayed in the tree view, so it should be concise and tell something about the function of the test suite. Variable: No Restrictions: None","hash":"att_RootStep_name","hp":"Test suite","h4":"Name"},"1300":{"id":1300,"content":"Include files This is a list of test suites that are included by the suite. If a Component or Procedure reference cannot be resolved in the current suite, the included suites are searched for it. When recording new components, QF‑Test will search the included suites for a matching Component node before creating a new one. Relative pathnames are treated relative to the directory of the suite, or to a directory on the library path (see option Directories holding test suite libraries). When you change anything in this attribute QF‑Test will offer to update all affected nodes to compensate for the change. For example, if you add or remove a suite from the includes, QF‑Test will make all references to that suite's Procedures or Components implicit or absolute so that the actual referenced nodes remain unchanged. In such a case, choose \"Yes\". If, on the other hand, you renamed a suite or moved it to some other directory and are simply updating the includes to reflect that, chose \"No\" so all former implicit references into the old suite will now point to the new one. Variable: File names for included test suites can reference environment variables or system properties via the syntax ${env:...} or ${system:...}. You can change the included test suite at run time by setting the respective environment variable or system property via script to the new value. Use rc.setProperty, which is described in \"The rc module: Run context API\". Though the syntax above is a standard in QF‑Test for group variables or properties, this is a special case where only the env or system groups can be used. Restrictions: None","hash":"att_RootStep_includes","hp":"Test suite","h4":"Include files"},"1301":{"id":1301,"content":"Dependencies (reverse includes) This list of test suites is the reverse of the Include files attribute. It has no impact on test execution. Instead it serves a hint to tell QF‑Test which test suites depend on Components in this suite, either because they (directly or indirectly) include this suite or because they explicitly reference Components in it. This information is used when QF‑Test IDs of Components are manipulated (for example after updating components, see (\"Update Components\")) and the QF‑Test component ID attributes of nodes depending on these components have to be updated. QF‑Test always checks all currently loaded suites for dependencies. Additionally, it will automatically load and check all suites listed here. Relative pathnames are treated relative to the directory of the suite, or to a directory on the library path (see option Directories holding test suite libraries). Like the Include files, the Dependencies are also resolved indirectly. For example if suite A has the dependency B which has the dependency C, both suites B and C will be loaded and checked for references automatically when components in suite A are manipulated. Variable: Environment variables or system properties can be used in the same way as for the Include files attribute, i.e. using ${env:...} or ${system:...}. Restrictions: None","hash":"att_RootStep_dependencies","hp":"Test suite","h4":"Dependencies (reverse includes)"},"1302":{"id":1302,"content":"Variable definitions These variables definitions are identical to the suite variable bindings accessible in the Variables pane of the global options. A detailed explanation of variable definition and lookup is given in \"Variables\". See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_RootStep_variable","hp":"Test suite","h4":"Variable definitions"},"1303":{"id":1303,"content":"Execution timeout Time limit for the node's execution in milliseconds. If that limit expires the execution of that node will get interrupted. Variable: Yes Restrictions: >= 0","hash":"att_RootStep_exectimeout","hp":"Test suite","h4":"Execution timeout"},"1304":{"id":1304,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_RootStep_comment","hp":"Test suite","h4":"Comment"},"1305":{"id":1305,"content":"Mobile Manual","hash":"","h0":"Test and Sequence nodes | QF‑Test Manual"},"1306":{"id":1306,"content":"Mobile Manual","hash":"home-link","h0":"Test and Sequence nodes | QF‑Test Manual"},"1307":{"id":1307,"content":"Test and Sequence nodes Tests and sequences are the main structural elements of a test suite. Test case nodes represent logical test cases and are implemented as specialized sequences. A sequence is a container that executes its child nodes one by one. It can define variables (see \"Variables\") that remain bound during the execution of the children. Other kinds of sequences differ either in the way their child nodes are executed, or in the restrictions they impose on their child or parent nodes.","hash":"sec_sequences","h0":"Test and Sequence nodes"},"1308":{"id":1308,"content":"Test case A Test case node represents one or more logical test cases. In a sense it is the most important of all QF‑Test nodes and everything else only serves to lend structure to Test cases or to implement their logic. Functionally it is a highly specialized Sequence with a number of important extensions and special attributes. A Test case should focus on the actual test it supposed to perform. Setup and cleanup tasks required to ensure that the Test case executes in the required environment and does not interfere with subsequent tests should be implemented in the form of Dependencies as described in \"Dependency nodes\". Alternatively - or in addition to Dependencies - a Test case can have Setup and Cleanup nodes to be executed before and after the Test case. Because a Test case can be called from a Test call node it is also somewhat similar to a Procedure in that its Name attribute is mandatory and that it has a list of Parameter default values that can be overridden in the calling node. Test cases also play a central role in run logs and test reports. During a test run a Test case node can be executed several times in different contexts and with different parameters. Logically these executions may represent the same or different test cases. By defining a set of Characteristic variables you can specify which variable values are used to differentiate between executions, thus characterizing the run-time environment of the test. The values of these variables at the time of entry to the Test case are stored in the run log. To emphasize the fact that each execution of a Test case node may represent a separate logical test case there is an alternative name attribute called Name for run log and report. Its value may contain references to the Characteristic variables of the test. In the run log or report the test will then be listed with this name, including the expanded run-time variable values. Finally, there are situations in which a test cannot or should not be executed for specific variable settings. If the Condition attribute of the Test case is defined, the Test case will only be executed if that expression expands to a true value. If the Test case is not executed due to the Condition it will be listed as skipped in the report. Contained in: Test suite, Test set. Children: Optional Dependency or Dependency reference as the first element. A Setup may be the next and a Cleanup the last node with an arbitrary number of normal child nodes in between. A Test case that does not contain normal child nodes will be listed as not implemented in the report. Execution: First the Variable definitions of the Test case are bound on the primary and its Parameter default values on the fallback variable stack (see \"Variables\"). With these in place the Condition is evaluated and the node will be skipped if a non-empty Condition evaluates to false. Next the dependency of the Test case - possibly inherited from its parent node - is determined and resolved as described in \"Dependency nodes\". Then the optional Setup is executed once, followed by the normal child nodes and a single execution of the optional Cleanup. An exception raised during the course of the Test case will be caught and passed to the Dependency for handling in a Catch node. Even if the exception is not handled by a Dependency it is not propagated beyond the Test case to prevent aborting the whole test run. The error state is duly noted in run log and report however. Attributes:","hash":"step_TestCase","h1":"Test case"},"1309":{"id":1309,"content":"Figure 34.2: Test case attributes","hash":"figure_34.2","h4":"Figure 34.2: Test case attributes"},"1310":{"id":1310,"content":"Name A Test case is identified by its name and the names of its Test set ancestors, so you should assign a name with a meaning that is easy to recognize and remember. Variable: No Restrictions: Must not be empty or contain the characters '.' or '#'.","hash":"att_TestCase_name","hp":"Test case","h4":"Name"},"1311":{"id":1311,"content":"Name for run log and report A separate name to be used for run log and report. This is useful to differentiate between multiple executions with potentially different values for the Characteristic variables. Variable: Yes Restrictions: None","hash":"att_TestCase_reportname","hp":"Test case","h4":"Name for run log and report"},"1312":{"id":1312,"content":"Characteristic variables These variables are part of the characteristics of a Test set or Test case. Two executions of a Test case are considered to represent the same logical test case if the run-time values of all Characteristic variables are identical. The run-time values of the Characteristic variables are stored in the run log. Variable: No Restrictions: None","hash":"att_TestCase_discriminator","hp":"Test case","h4":"Characteristic variables"},"1313":{"id":1313,"content":"Name for separate run log If this attribute is set it marks the node as a breaking point for split run logs and defines the filename for the partial log. When the node finishes, the respective log entry is removed from the main run log and saved as a separate, partial run log. This operation is completely transparent, the main run log retains references to the partial logs and is fully controllable. Please see \"Split run logs\" for further information about split run logs. This attribute has no effect if the option Create split run logs is disabled or split run logs are explicitly turned off for batch mode via the -splitlog command line argument. There is no need to keep the filename unique. If necessary, QF‑Test appends a number to the filename to avoid collisions. The filename may contain directories and, similar to specifying the name of a run log in batch mode on the command line, the following placeholders can be used after a '%' or a '+' character:","hash":"att_TestCase_externalizename","hp":"Test case","h4":"Name for separate run log"},"1314":{"id":1314,"content":"If this attribute is set it marks the node as a breaking point for split run logs and defines the filename for the partial log. When the node finishes, the respective log entry is removed from the main run log and saved as a separate, partial run log. This operation is completely transparent, the main run log retains references to the partial logs and is fully controllable. Please see \"Split run logs\" for further information about split run logs. This attribute has no effect if the option Create split run logs is disabled or split run logs are explicitly turned off for batch mode via the -splitlog command line argument. There is no need to keep the filename unique. If necessary, QF‑Test appends a number to the filename to avoid collisions. The filename may contain directories and, similar to specifying the name of a run log in batch mode on the command line, the following placeholders can be used after a '%' or a '+' character: Character Replacement % Literal '%' character. + Literal '+' character. i The current runid as specified with -runid <ID>. r The error level of the partial log. w The number of warnings in the partial log. e The number of errors in the partial log. x The number of exceptions in the partial log. t The thread index to which the partial log belongs (for tests run with parallel threads). y The current year (2 digits). Y The current year (4 digits). M The current month (2 digits). d The current day (2 digits). h The current hour (2 digits). m The current minute (2 digits). s The current second (2 digits). Table 34.1: Placeholders for the Name for separate run log attribute Variable: Yes Restrictions: None, characters that are illegal for a filename will be replaced with '_'.","hash":"table_34.1","hp":"Test case","h4":"Name for separate run log"},"1315":{"id":1315,"content":"Inherit dependency from parent node This option allows inheriting the Dependency from the parent node as a replacement for or in addition to specifying a Dependency for the node itself. Variable: No Restrictions: None","hash":"att_TestCase_inherit","hp":"Test case","h4":"Inherit dependency from parent node"},"1316":{"id":1316,"content":"Condition If the condition is non-empty it will be evaluated and if the result is false the execution of the current node is aborted. In this case the node will be reported as skipped. Like the Condition of an If node, the Condition is evaluated by the Jython interpreter, so the same rules apply. Variable: Yes Restrictions: Valid syntax","hash":"att_TestCase_condition","hp":"Test case","h4":"Condition"},"1317":{"id":1317,"content":"Script language This attribute determines the interpreter in which to run the script, or in other words, the scripting language to use. Possible values are \"Jython\", \"Groovy\" and \"JavaScript\". Variable: No Restrictions: None","hash":"att_TestCase_interpreter","hp":"Test case","h4":"Script language"},"1318":{"id":1318,"content":"Expected to fail if... This attribute allows specifying a condition under which the Test case is expected to fail. This is helpful to distinguish new problems from already known ones. Of course the latter should be fixed, but if and when that happens may be outside the tester's sphere of influence. Most of the time it is sufficient to simply set this attribute to 'true' to mark the Test case as an expected failure. But if the Test case is executed multiple times, e.g. within a Data driver or on multiple systems and fails only in specific cases, the condition should be written so that it evaluates to true for exactly those cases, e.g. ${qftest:windows} for a test that fails on Windows but runs fine on other systems. If this attribute evaluates to true and the Test case fails with an error, it will be listed separately in the run log, report and on the status line. It still means that there is an error in the application, so the overall percentage of successful tests is not changed. It is treated as an error if this attribute evaluates to true and the Test case does not fail because this means that either the test is not able to reproduce the problem reliably or that the problem has been fixed and the Test case must be updated accordingly. Variable: Yes Restrictions: Valid syntax","hash":"att_TestCase_expectedfail","hp":"Test case","h4":"Expected to fail if..."},"1319":{"id":1319,"content":"Variable definitions These variables are bound on the direct bindings stack (see \"Variables\"). They remain valid during the execution of the Test case's child nodes and cannot be overridden by a Test call node. See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_TestCase_variable","hp":"Test case","h4":"Variable definitions"},"1320":{"id":1320,"content":"Parameter default values Here you can define default or fallback values for the Test case's parameters (see \"Variables\"). Defining these values also serves as documentation and is a valuable time-saver when using the dialog to select the Test case for the Test name attribute of a Test call. See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_TestCase_fallback","hp":"Test case","h4":"Parameter default values"},"1321":{"id":1321,"content":"Maximum error level When a warning, error or exception occurs during a test run, the state of the corresponding node of the run log is set accordingly. This state is normally propagated to the parent node in a way that ensures that the error state of a run log node represents the worst of its child nodes' states. Using this attribute, the maximum error state that the run log node for a sequence will propagate, can be limited. This value has no effect on the way exceptions are handled. It only affects the error states of the run log nodes and by that the exit code of QF‑Test when run in batch mode (see. \"Starting QF‑Test\"). It also has no effect on the creation of compact run logs (see command line argument -compact). The node for a sequence in which a warning, error or exception occurs is never removed from a compact log, even if the error is not propagated due to the setting of this attribute. Variable: No Restrictions: None","hash":"att_TestCase_maxerror","hp":"Test case","h4":"Maximum error level"},"1322":{"id":1322,"content":"Execution timeout Time limit for the node's execution in milliseconds. If that limit expires the execution of that node will get interrupted. Variable: Yes Restrictions: >= 0","hash":"att_TestCase_exectimeout","hp":"Test case","h4":"Execution timeout"},"1323":{"id":1323,"content":"Border for relative calls This flag determines whether relative procedure calls, test calls or dependency references are allowed within that certain node. Relative calls passing that border are not allowed. If that attribute is not specified in the hierarchy, no relative calls are allowed. Variable: No Restrictions: None","hash":"att_TestCase_border","hp":"Test case","h4":"Border for relative calls"},"1324":{"id":1324,"content":"QF‑Test ID When using the command line argument -test <n>|<ID> for execution in batch mode you can specify the QF‑Test ID of the node as an alternative to its qualified name. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_TestCase_id","hp":"Test case","h4":"QF‑Test ID"},"1325":{"id":1325,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_TestCase_delay","hp":"Test case","h4":"Delay before/after"},"1326":{"id":1326,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_TestCase_comment","hp":"Test case","h4":"Comment"},"1327":{"id":1327,"content":"Test set The main purpose of a Test set is to give structure to the Test cases of a test suite. Test sets can be nested. The Name of a Test set is part of the Test case's fully qualified name to which a Test call node refers. Test sets are also callable themselves and thus have a set of Parameter default values that can be overridden in the Test call. One way of structuring Test cases is to collect those with similar setup and cleanup requirements in the same Test set which can provide a Dependency or Dependency reference node to be inherited by the Test case or nested Test set child nodes. If the Inherit dependency from parent node attribute of the Test set is set, the Dependency nodes of the Test set's parent(s) are also inherited. See \"Dependency nodes\" for information about QF‑Test's dependency mechanism. Alternative or additional setup and cleanup is available in the form of Setup and Cleanup nodes which will be executed before and after each of the Test set and Test case child nodes. Another important feature of a Test set is data-driven testing. This can be achieved by adding a Data driver node with one or more Data binders as described in \"Data-driven testing\". Like a Test case, a Test set plays an important role for reports. As it can also be executed several times with different parameter settings, it has a set of Characteristic variables and an alternative Name for run log and report that work just like for a Test case. The same is true for the Condition which can be used to skip an entire Test set depending on current variable values. Contained in: Test suite, Test set. Children: Optional Dependency or Dependency reference as the first child, followed by an optional Data driver. A Setup may come next and a Cleanup at the end with an arbitrary number of Test set, Test case and Test call nodes in between. Execution: First the Parameter default values of the Test set are bound on the fallback variable stack (see \"Variables\"). With these in place the Condition is evaluated and the node will be skipped if a non-empty Condition evaluates to false. The Dependency or Dependency reference node will not be resolved at this time unless its Always execute, even in test suite and test set nodes attribute is set. If there is a Data driver node, it is executed to create a data driving context, bind one or more Data binders and then repeatedly execute the other child nodes as described in \"Data-driven testing\". For each loop iteration - or once in case no Data driver is present - the Test set executes each of its Test set or Test case child nodes. If an optional Setup or Cleanup node are present, they are executed before and after each of these child nodes respectively. Attributes:","hash":"step_TestSet","h1":"Test set"},"1328":{"id":1328,"content":"Figure 34.3: Test set attributes","hash":"figure_34.3","h4":"Figure 34.3: Test set attributes"},"1329":{"id":1329,"content":"Name The name of a Test set is part of its own identification and of that of the Test case and Test set nodes it contains, so you should assign a name with a meaning that is easy to recognize and remember. Variable: No Restrictions: Must not be empty or contain the characters '.' or '#'.","hash":"att_TestSet_name","hp":"Test set","h4":"Name"},"1330":{"id":1330,"content":"Name for run log and report A separate name to be used for run log and report. This is useful to differentiate between multiple executions with potentially different values for the Characteristic variables. Variable: Yes Restrictions: None","hash":"att_TestSet_reportname","hp":"Test set","h4":"Name for run log and report"},"1331":{"id":1331,"content":"Characteristic variables These variables are part of the characteristics of a Test set or Test case. Two executions of a Test case are considered to represent the same logical test case if the run-time values of all Characteristic variables are identical. The run-time values of the Characteristic variables are stored in the run log. Variable: No Restrictions: None","hash":"att_TestSet_discriminator","hp":"Test set","h4":"Characteristic variables"},"1332":{"id":1332,"content":"Name for separate run log If this attribute is set it marks the node as a breaking point for split run logs and defines the filename for the partial log. When the node finishes, the respective log entry is removed from the main run log and saved as a separate, partial run log. This operation is completely transparent, the main run log retains references to the partial logs and is fully controllable. Please see \"Split run logs\" for further information about split run logs. This attribute has no effect if the option Create split run logs is disabled or split run logs are explicitly turned off for batch mode via the -splitlog command line argument. There is no need to keep the filename unique. If necessary, QF‑Test appends a number to the filename to avoid collisions. The filename may contain directories and, similar to specifying the name of a run log in batch mode on the command line, the following placeholders can be used after a '%' or a '+' character:","hash":"att_TestSet_externalizename","hp":"Test set","h4":"Name for separate run log"},"1333":{"id":1333,"content":"If this attribute is set it marks the node as a breaking point for split run logs and defines the filename for the partial log. When the node finishes, the respective log entry is removed from the main run log and saved as a separate, partial run log. This operation is completely transparent, the main run log retains references to the partial logs and is fully controllable. Please see \"Split run logs\" for further information about split run logs. This attribute has no effect if the option Create split run logs is disabled or split run logs are explicitly turned off for batch mode via the -splitlog command line argument. There is no need to keep the filename unique. If necessary, QF‑Test appends a number to the filename to avoid collisions. The filename may contain directories and, similar to specifying the name of a run log in batch mode on the command line, the following placeholders can be used after a '%' or a '+' character: Character Replacement % Literal '%' character. + Literal '+' character. i The current runid as specified with -runid <ID>. r The error level of the partial log. w The number of warnings in the partial log. e The number of errors in the partial log. x The number of exceptions in the partial log. t The thread index to which the partial log belongs (for tests run with parallel threads). y The current year (2 digits). Y The current year (4 digits). M The current month (2 digits). d The current day (2 digits). h The current hour (2 digits). m The current minute (2 digits). s The current second (2 digits). Table 34.2: Placeholders for the Name for separate run log attribute Variable: Yes Restrictions: None, characters that are illegal for a filename will be replaced with '_'.","hash":"table_34.2","hp":"Test set","h4":"Name for separate run log"},"1334":{"id":1334,"content":"Inherit dependency from parent node This option allows inheriting the Dependency from the parent node as a replacement for or in addition to specifying a Dependency for the node itself. Variable: No Restrictions: None","hash":"att_TestSet_inherit","hp":"Test set","h4":"Inherit dependency from parent node"},"1335":{"id":1335,"content":"Condition If the condition is non-empty it will be evaluated and if the result is false the execution of the current node is aborted. In this case the node will be reported as skipped. Like the Condition of an If node, the Condition is evaluated by the Jython interpreter, so the same rules apply. Variable: Yes Restrictions: Valid syntax","hash":"att_TestSet_condition","hp":"Test set","h4":"Condition"},"1336":{"id":1336,"content":"Script language This attribute determines the interpreter in which to run the script, or in other words, the scripting language to use. Possible values are \"Jython\", \"Groovy\" and \"JavaScript\". Variable: No Restrictions: None","hash":"att_TestSet_interpreter","hp":"Test set","h4":"Script language"},"1337":{"id":1337,"content":"Parameter default values Here you can define default or fallback values for the Test set's parameters (see \"Variables\"). Defining these values also serves as documentation and is a valuable time-saver when using the dialog to select the Test set for the Test name attribute of a Test call. See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_TestSet_fallback","hp":"Test set","h4":"Parameter default values"},"1338":{"id":1338,"content":"Maximum error level When a warning, error or exception occurs during a test run, the state of the corresponding node of the run log is set accordingly. This state is normally propagated to the parent node in a way that ensures that the error state of a run log node represents the worst of its child nodes' states. Using this attribute, the maximum error state that the run log node for a sequence will propagate, can be limited. This value has no effect on the way exceptions are handled. It only affects the error states of the run log nodes and by that the exit code of QF‑Test when run in batch mode (see. \"Starting QF‑Test\"). It also has no effect on the creation of compact run logs (see command line argument -compact). The node for a sequence in which a warning, error or exception occurs is never removed from a compact log, even if the error is not propagated due to the setting of this attribute. Variable: No Restrictions: None","hash":"att_TestSet_maxerror","hp":"Test set","h4":"Maximum error level"},"1339":{"id":1339,"content":"Execution timeout Time limit for the node's execution in milliseconds. If that limit expires the execution of that node will get interrupted. Variable: Yes Restrictions: >= 0","hash":"att_TestSet_exectimeout","hp":"Test set","h4":"Execution timeout"},"1340":{"id":1340,"content":"Border for relative calls This flag determines whether relative procedure calls, test calls or dependency references are allowed within that certain node. Relative calls passing that border are not allowed. If that attribute is not specified in the hierarchy, no relative calls are allowed. Variable: No Restrictions: None","hash":"att_TestSet_border","hp":"Test set","h4":"Border for relative calls"},"1341":{"id":1341,"content":"QF‑Test ID When using the command line argument -test <n>|<ID> for execution in batch mode you can specify the QF‑Test ID of the node as an alternative to its qualified name. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_TestSet_id","hp":"Test set","h4":"QF‑Test ID"},"1342":{"id":1342,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_TestSet_delay","hp":"Test set","h4":"Delay before/after"},"1343":{"id":1343,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_TestSet_comment","hp":"Test set","h4":"Comment"},"1344":{"id":1344,"content":"Test call With this node a call to some other executable test node can be made. Possible targets are Test suite, Test set and Test case nodes in the same or a different test suite. Execution will continue in the called node and when finished return to the Test call and thus to its parent node. The name of a Test case or Test set to call is determined by its Name and the Names of its Test set ancestors. These are concatenated with a dot ('.') as separator, starting with the outermost Test set and ending in the Test case's name. Thus to call a Test case named nodeTest in a Test set named Tree that is itself a child of a Test set named Main, the Test name attribute would be set to 'Main.Tree.nodeTest'. A node in a different test suite is addressed by prepending the filename of the test suite followed by a '#' to the Test name. A Test suite node is addressed by a single '.', so calling a whole test suite is done with a Test name attribute of the form 'suitename.qft#.'. It is generally easiest to pick the target node interactively from a dialog by clicking on the button above the Test name attribute. See also \"Referencing nodes in another test suite\" for further information about cross-suite calls. Contained in: All kinds of sequences. Children: None Execution: The Variable definitions of the Test call are bound, the target node is determined and execution is passed to it. After the Test call returns, the Test call's variables are unbound again. Attributes:","hash":"step_TestCall","h1":"Test call"},"1345":{"id":1345,"content":"Figure 34.4: Test call Attributes","hash":"figure_34.4","h4":"Figure 34.4: Test call Attributes"},"1346":{"id":1346,"content":"Name In case of a Test case or Test set it is the full name, created from the Name of its Test set parents and its own Name, joined by a dot. A Test suite node is addressed by a single '.' character. The \"Select test\" button above the attribute brings up a dialog in which you can select the target node interactively. You can also get to this dialog by pressing Shift⁠+⁠Return or Alt⁠+⁠Return when the focus is in the text field. By selecting the \"Copy parameters\" checkbox you can adopt the Test case's or Test set's Parameter default values as parameters for the Test call node to save typing. Variable: Yes Restrictions: Must not be empty.","hash":"att_TestCall_calledtest","hp":"Test call","h4":"Name"},"1347":{"id":1347,"content":"Name for separate run log If this attribute is set it marks the node as a breaking point for split run logs and defines the filename for the partial log. When the node finishes, the respective log entry is removed from the main run log and saved as a separate, partial run log. This operation is completely transparent, the main run log retains references to the partial logs and is fully controllable. Please see \"Split run logs\" for further information about split run logs. This attribute has no effect if the option Create split run logs is disabled or split run logs are explicitly turned off for batch mode via the -splitlog command line argument. There is no need to keep the filename unique. If necessary, QF‑Test appends a number to the filename to avoid collisions. The filename may contain directories and, similar to specifying the name of a run log in batch mode on the command line, the following placeholders can be used after a '%' or a '+' character:","hash":"att_TestCall_externalizename","hp":"Test call","h4":"Name for separate run log"},"1348":{"id":1348,"content":"If this attribute is set it marks the node as a breaking point for split run logs and defines the filename for the partial log. When the node finishes, the respective log entry is removed from the main run log and saved as a separate, partial run log. This operation is completely transparent, the main run log retains references to the partial logs and is fully controllable. Please see \"Split run logs\" for further information about split run logs. This attribute has no effect if the option Create split run logs is disabled or split run logs are explicitly turned off for batch mode via the -splitlog command line argument. There is no need to keep the filename unique. If necessary, QF‑Test appends a number to the filename to avoid collisions. The filename may contain directories and, similar to specifying the name of a run log in batch mode on the command line, the following placeholders can be used after a '%' or a '+' character: Character Replacement % Literal '%' character. + Literal '+' character. i The current runid as specified with -runid <ID>. r The error level of the partial log. w The number of warnings in the partial log. e The number of errors in the partial log. x The number of exceptions in the partial log. t The thread index to which the partial log belongs (for tests run with parallel threads). y The current year (2 digits). Y The current year (4 digits). M The current month (2 digits). d The current day (2 digits). h The current hour (2 digits). m The current minute (2 digits). s The current second (2 digits). Table 34.3: Placeholders for the Name for separate run log attribute Variable: Yes Restrictions: None, characters that are illegal for a filename will be replaced with '_'.","hash":"table_34.3","hp":"Test call","h4":"Name for separate run log"},"1349":{"id":1349,"content":"Variable definitions This is where you define the parameter values for the target node. These variables are bound on the primary variable stack (see \"Variables\") so they override any Parameter default values. See \"Tables\" about how to work with the table. In case you want to re-set the order of the parameters like they are sorted in the called test case or test set, you can select »Re-set parameter order«. Variable: Variable names no, values yes Restrictions: None","hash":"att_TestCall_variable","hp":"Test call","h4":"Variable definitions"},"1350":{"id":1350,"content":"Act like a procedure call If the Test call node is executed inside a Test case, this attribute determines how exceptions are handled in the called node(s). If it is activated a single exception terminates the whole call irrespective of Test set and Test case nesting, just like it would for a regular Procedure call node. If this attribute is unset the special roles of Test set and Test case nodes with their local exception handling is maintained. Variable: Yes Restrictions: None","hash":"att_TestCall_actasproccall","hp":"Test call","h4":"Act like a procedure call"},"1351":{"id":1351,"content":"Execution timeout Time limit for the node's execution in milliseconds. If that limit expires the execution of that node will get interrupted. Variable: Yes Restrictions: >= 0","hash":"att_TestCall_exectimeout","hp":"Test call","h4":"Execution timeout"},"1352":{"id":1352,"content":"QF‑Test ID At the moment the QF‑Test ID attribute has no meaning for this type of node. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_TestCall_id","hp":"Test call","h4":"QF‑Test ID"},"1353":{"id":1353,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_TestCall_delay","hp":"Test call","h4":"Delay before/after"},"1354":{"id":1354,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_TestCall_comment","hp":"Test call","h4":"Comment"},"1355":{"id":1355,"content":"Sequence This is the most general kind of sequence. Its children are executed one by one and their number or type is not limited in any way. Contained in: All kinds of sequences. Children: Any Execution: The Variable definitions of the Sequence are bound and its child nodes executed one by one. After the execution of the last child is complete, the variables are unbound again. Attributes:","hash":"step_BasicSequence","h1":"Sequence"},"1356":{"id":1356,"content":"Figure 34.5: Sequence attributes","hash":"figure_34.5","h4":"Figure 34.5: Sequence attributes"},"1357":{"id":1357,"content":"Name The name of a sequence is a kind of short description. It is displayed in the tree view, so it should be concise and say something about the function of the sequence. Variable: No Restrictions: None","hash":"att_BasicSequence_name","hp":"Sequence","h4":"Name"},"1358":{"id":1358,"content":"Variable definitions This is where you define the values of the variables that remain bound during the execution of the sequence's child nodes (see \"Variables\"). See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_BasicSequence_variable","hp":"Sequence","h4":"Variable definitions"},"1359":{"id":1359,"content":"Maximum error level When a warning, error or exception occurs during a test run, the state of the corresponding node of the run log is set accordingly. This state is normally propagated to the parent node in a way that ensures that the error state of a run log node represents the worst of its child nodes' states. Using this attribute, the maximum error state that the run log node for a sequence will propagate, can be limited. This value has no effect on the way exceptions are handled. It only affects the error states of the run log nodes and by that the exit code of QF‑Test when run in batch mode (see. \"Starting QF‑Test\"). It also has no effect on the creation of compact run logs (see command line argument -compact). The node for a sequence in which a warning, error or exception occurs is never removed from a compact log, even if the error is not propagated due to the setting of this attribute. Variable: No Restrictions: None","hash":"att_BasicSequence_maxerror","hp":"Sequence","h4":"Maximum error level"},"1360":{"id":1360,"content":"QF‑Test ID At the moment the QF‑Test ID attribute has no meaning for this type of node. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_BasicSequence_id","hp":"Sequence","h4":"QF‑Test ID"},"1361":{"id":1361,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_BasicSequence_delay","hp":"Sequence","h4":"Delay before/after"},"1362":{"id":1362,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_BasicSequence_comment","hp":"Sequence","h4":"Comment"},"1363":{"id":1363,"content":"Test step A Test step is a special Sequence that serves to divide a Test case into steps that can be documented individually and will show up in the report or testdoc documentation. In contrast to Test cases, which should not be nested, Test steps can be nested to any depth. Another important feature of a Test step is data-driven testing. This can be achieved by adding a Data driver node with one or more Data binders as described in \"Data-driven testing\". Contained in: All kinds of sequences. Children: Any Execution: First the Variable definitions of the Test step are bound. With these in place the Condition is evaluated and the node will be skipped if a non-empty Condition evaluates to false. Then its child nodes executed one by one - possibly several times in case a Data driver is in place. After the execution of the last child of the last iteration is complete, the variables are unbound again. Attributes:","hash":"step_TestStep","h1":"Test step"},"1364":{"id":1364,"content":"Figure 34.6: Test step attributes","hash":"figure_34.6","h4":"Figure 34.6: Test step attributes"},"1365":{"id":1365,"content":"Name The name of a sequence is a kind of short description. It is displayed in the tree view, so it should be concise and say something about the function of the sequence. Variable: No Restrictions: None","hash":"att_TestStep_name","hp":"Test step","h4":"Name"},"1366":{"id":1366,"content":"Name for run log and report A separate name to be used for run log and report. This is useful to differentiate between multiple executions of the surrounding Test case with potentially different values for its Characteristic variables. Variable: Yes Restrictions: None","hash":"att_TestStep_reportname","hp":"Test step","h4":"Name for run log and report"},"1367":{"id":1367,"content":"Condition If the condition is non-empty it will be evaluated and if the result is false the execution of the current node is aborted. In this case the node will be reported as skipped. Like the Condition of an If node, the Condition is evaluated by the Jython interpreter, so the same rules apply. Variable: Yes Restrictions: Valid syntax","hash":"att_TestStep_condition","hp":"Test step","h4":"Condition"},"1368":{"id":1368,"content":"Script language This attribute determines the interpreter in which to run the script, or in other words, the scripting language to use. Possible values are \"Jython\", \"Groovy\" and \"JavaScript\". Variable: No Restrictions: None","hash":"att_TestStep_interpreter","hp":"Test step","h4":"Script language"},"1369":{"id":1369,"content":"Name for separate run log If this attribute is set it marks the node as a breaking point for split run logs and defines the filename for the partial log. When the node finishes, the respective log entry is removed from the main run log and saved as a separate, partial run log. This operation is completely transparent, the main run log retains references to the partial logs and is fully controllable. Please see \"Split run logs\" for further information about split run logs. This attribute has no effect if the option Create split run logs is disabled or split run logs are explicitly turned off for batch mode via the -splitlog command line argument. There is no need to keep the filename unique. If necessary, QF‑Test appends a number to the filename to avoid collisions. The filename may contain directories and, similar to specifying the name of a run log in batch mode on the command line, the following placeholders can be used after a '%' or a '+' character:","hash":"att_TestStep_externalizename","hp":"Test step","h4":"Name for separate run log"},"1370":{"id":1370,"content":"If this attribute is set it marks the node as a breaking point for split run logs and defines the filename for the partial log. When the node finishes, the respective log entry is removed from the main run log and saved as a separate, partial run log. This operation is completely transparent, the main run log retains references to the partial logs and is fully controllable. Please see \"Split run logs\" for further information about split run logs. This attribute has no effect if the option Create split run logs is disabled or split run logs are explicitly turned off for batch mode via the -splitlog command line argument. There is no need to keep the filename unique. If necessary, QF‑Test appends a number to the filename to avoid collisions. The filename may contain directories and, similar to specifying the name of a run log in batch mode on the command line, the following placeholders can be used after a '%' or a '+' character: Character Replacement % Literal '%' character. + Literal '+' character. i The current runid as specified with -runid <ID>. r The error level of the partial log. w The number of warnings in the partial log. e The number of errors in the partial log. x The number of exceptions in the partial log. t The thread index to which the partial log belongs (for tests run with parallel threads). y The current year (2 digits). Y The current year (4 digits). M The current month (2 digits). d The current day (2 digits). h The current hour (2 digits). m The current minute (2 digits). s The current second (2 digits). Table 34.4: Placeholders for the Name for separate run log attribute Variable: Yes Restrictions: None, characters that are illegal for a filename will be replaced with '_'.","hash":"table_34.4","hp":"Test step","h4":"Name for separate run log"},"1371":{"id":1371,"content":"Variable definitions This is where you define the values of the variables that remain bound during the execution of the sequence's child nodes (see \"Variables\"). See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_TestStep_variable","hp":"Test step","h4":"Variable definitions"},"1372":{"id":1372,"content":"Maximum error level When a warning, error or exception occurs during a test run, the state of the corresponding node of the run log is set accordingly. This state is normally propagated to the parent node in a way that ensures that the error state of a run log node represents the worst of its child nodes' states. Using this attribute, the maximum error state that the run log node for a sequence will propagate, can be limited. This value has no effect on the way exceptions are handled. It only affects the error states of the run log nodes and by that the exit code of QF‑Test when run in batch mode (see. \"Starting QF‑Test\"). It also has no effect on the creation of compact run logs (see command line argument -compact). The node for a sequence in which a warning, error or exception occurs is never removed from a compact log, even if the error is not propagated due to the setting of this attribute. Variable: No Restrictions: None","hash":"att_TestStep_maxerror","hp":"Test step","h4":"Maximum error level"},"1373":{"id":1373,"content":"Execution timeout Time limit for the node's execution in milliseconds. If that limit expires the execution of that node will get interrupted. Variable: Yes Restrictions: >= 0","hash":"att_TestStep_exectimeout","hp":"Test step","h4":"Execution timeout"},"1374":{"id":1374,"content":"QF‑Test ID At the moment the QF‑Test ID attribute has no meaning for this type of node. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_TestStep_id","hp":"Test step","h4":"QF‑Test ID"},"1375":{"id":1375,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_TestStep_delay","hp":"Test step","h4":"Delay before/after"},"1376":{"id":1376,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_TestStep_comment","hp":"Test step","h4":"Comment"},"1377":{"id":1377,"content":"Sequence with time limit This node extends the basic Sequence node with time-constraint checking. Child nodes are executed as usual, but upon completion of the sequence the elapsed time is compared to the time-limit. Exceeding the time limit will result in a warning, error or exception, depending on the value of the attribute Error level if time limit exceeded. Explicit delays like Delay before/after or user interrupts are deducted from the duration before the constraints are checked, unless Check realtime is activated. For report generation, time-constraints are treated like checks. If the Comment attribute starts with an '!' character, the result will be logged in the report. The function of this node is to check time constraints in the user-acceptance range, i.e. between a few hundred milliseconds and a few seconds. Real-time constraints of a few milliseconds or less are beyond its limits. Contained in: All kinds of sequences. Children: Any Execution: The Variable definitions of the Sequence with time limit are bound and its child nodes executed one by one. After the execution of the last child is complete, the variables are unbound again. The elapsed time is compared to the given time limit. Attributes:","hash":"step_TimeConstrainedSequence","h1":"Sequence with time limit"},"1378":{"id":1378,"content":"Figure 34.7: Sequence with time limit attributes","hash":"figure_34.7","h4":"Figure 34.7: Sequence with time limit attributes"},"1379":{"id":1379,"content":"Name The name of a sequence is a kind of short description. It is displayed in the tree view, so it should be concise and say something about the function of the sequence. Variable: No Restrictions: None","hash":"att_TimeConstrainedSequence_name","hp":"Sequence with time limit","h4":"Name"},"1380":{"id":1380,"content":"Time limit for execution The time (in milliseconds) allowed for the execution of the sequence. Variable: Yes Restrictions: Must not be negative.","hash":"att_TimeConstrainedSequence_timelimit","hp":"Sequence with time limit","h4":"Time limit for execution"},"1381":{"id":1381,"content":"Check realtime Normally explicit delays like Delay before/after or user interrupts are deducted from the duration, before the time constraints are checked. To prevent this deduction and therefore check the real-time, this attribute can be activated. Variable: No Restrictions: None","hash":"att_TimeConstrainedSequence_checkrealtime","hp":"Sequence with time limit","h4":"Check realtime"},"1382":{"id":1382,"content":"Error level if time limit exceeded This attribute determines what happens in case the time limit is exceeded. If set to \"exception\", a CheckFailedException will be thrown. Otherwise a message with the respective error-level will be logged in the run log. Variable: No Restrictions: None","hash":"att_TimeConstrainedSequence_timeerror","hp":"Sequence with time limit","h4":"Error level if time limit exceeded"},"1383":{"id":1383,"content":"Variable definitions This is where you define the values of the variables that remain bound during the execution of the sequence's child nodes (see \"Variables\"). See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_TimeConstrainedSequence_variable","hp":"Sequence with time limit","h4":"Variable definitions"},"1384":{"id":1384,"content":"Maximum error level When a warning, error or exception occurs during a test run, the state of the corresponding node of the run log is set accordingly. This state is normally propagated to the parent node in a way that ensures that the error state of a run log node represents the worst of its child nodes' states. Using this attribute, the maximum error state that the run log node for a sequence will propagate, can be limited. This value has no effect on the way exceptions are handled. It only affects the error states of the run log nodes and by that the exit code of QF‑Test when run in batch mode (see. \"Starting QF‑Test\"). It also has no effect on the creation of compact run logs (see command line argument -compact). The node for a sequence in which a warning, error or exception occurs is never removed from a compact log, even if the error is not propagated due to the setting of this attribute. Variable: No Restrictions: None","hash":"att_TimeConstrainedSequence_maxerror","hp":"Sequence with time limit","h4":"Maximum error level"},"1385":{"id":1385,"content":"Execution timeout Time limit for the node's execution in milliseconds. If that limit expires the execution of that node will get interrupted. Variable: Yes Restrictions: >= 0","hash":"att_TimeConstrainedSequence_exectimeout","hp":"Sequence with time limit","h4":"Execution timeout"},"1386":{"id":1386,"content":"QF‑Test ID At the moment the QF‑Test ID attribute has no meaning for this type of node. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_TimeConstrainedSequence_id","hp":"Sequence with time limit","h4":"QF‑Test ID"},"1387":{"id":1387,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_TimeConstrainedSequence_delay","hp":"Sequence with time limit","h4":"Delay before/after"},"1388":{"id":1388,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_TimeConstrainedSequence_comment","hp":"Sequence with time limit","h4":"Comment"},"1389":{"id":1389,"content":"Extras This node is a kind of clipboard or playground where the usual restrictions on the parent of a node don't apply. You can add any kind of node here to assemble and try out some test sequences. Contained in: Root node Children: Any Execution: Cannot be executed Attributes:","hash":"step_ExtraSequence","h1":"Extras"},"1390":{"id":1390,"content":"Figure 34.8: Extras attributes","hash":"figure_34.8","h4":"Figure 34.8: Extras attributes"},"1391":{"id":1391,"content":"QF‑Test ID At the moment the QF‑Test ID attribute has no meaning for this type of node. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_ExtraSequence_id","hp":"Extras","h4":"QF‑Test ID"},"1392":{"id":1392,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_ExtraSequence_comment","hp":"Extras","h4":"Comment"},"1393":{"id":1393,"content":"Mobile Manual","hash":"","h0":"Dependencies | QF‑Test Manual"},"1394":{"id":1394,"content":"Mobile Manual","hash":"home-link","h0":"Dependencies | QF‑Test Manual"},"1395":{"id":1395,"content":"Dependencies Dependencies are a very powerful feature for handling setup and cleanup requirements for test cases automatically. The goal is to isolate test cases so that each one can be run independently without interfering with others. This is a very important requirement for things like testing arbitrary sub-sets of test cases, for example to re-test only failed tests, or during test-development where it must be possible to quickly run and debug any given test case.","hash":"sec_dependencies","h0":"Dependencies"},"1396":{"id":1396,"content":"Dependency Dependency nodes are used to implement advanced, automatic handling of setup and cleanup requirements for Test sets and Test cases. A detailed description of the Dependency mechanism is given in \"Dependency nodes\". This section focuses on formal requirements for the Dependency node and its attributes. As Dependencies are complex, they should be reused as much as possible. This can be done by grouping Test cases with identical dependencies in a Test set and have them inherit the Dependency of the Test set. However, this mechanism alone is not flexible enough, so a Dependency can also be implemented just like a Procedure and placed among the Procedures of a test suite to be referenced from a Dependency reference node. For this to work, the Name attribute is mandatory and it also has a list of Parameter default values that can be overridden in the referencing node. The Characteristic variables of a Dependency are part of its identity and play an important role in the dependency resolution mechanism. Contained in: Test suite, Test set, Test case, Procedures, Package. Children: Zero or more Dependency references on which the Dependency is based, optional Setup and Cleanup nodes and an optional Error handler followed by zero or more Catch nodes. Execution: Normally Dependencies are executed only indirectly in the setup phase of a Test set or Test case. If a Dependency node is executed interactively, the dependency stack is resolved as described in \"Dependency nodes\". Attributes:","hash":"step_Dependency","h1":"Dependency"},"1397":{"id":1397,"content":"Figure 34.9: Dependency attributes","hash":"figure_34.9","h4":"Figure 34.9: Dependency attributes"},"1398":{"id":1398,"content":"Name A Dependency is identified by its name, so you should assign a name with a meaning that is easy to recognize and remember. Variable: No Restrictions: Must not be empty or contain the characters '.' or '#'.","hash":"att_Dependency_name","hp":"Dependency","h4":"Name"},"1399":{"id":1399,"content":"Name for run log and report A separate name to be used for run log and report. This is useful to differentiate between multiple executions with potentially different values for the Characteristic variables. Variable: Yes Restrictions: None","hash":"att_Dependency_reportname","hp":"Dependency","h4":"Name for run log and report"},"1400":{"id":1400,"content":"Characteristic variables These variables are part of a Dependency's identity. During Dependency resolution as described in \"Dependency nodes\" two Dependencies are considered equal only if they are one and the same node and the run-time values of all their Characteristic variables are identical. Additionally, the values of the Characteristic variables are stored during the setup phase of the Dependency. Later, when the Dependency is rolled back, these settings will be temporarily restored for the cleanup phase. Characteristic variables have the same value at a Cleanup node as during the execution of the corresponding Setup node - regardless of the value of the variables in the current test case. Variable: No Restrictions: None","hash":"att_Dependency_discriminator","hp":"Dependency","h4":"Characteristic variables"},"1401":{"id":1401,"content":"Always execute, even in test suite and test set nodes Normally a Dependency is only executed if it belongs to a Test case node. Dependencies in Test suite or Test set nodes are simply inherited by the Test case descendants of these nodes. However, in some cases it is useful to resolve a Dependency early, for example when the Dependency provides parameters for a test run that are required to evaluate a Condition of a subsequent Test case. This can be achieved by activating this option. Variable: No Restrictions: None","hash":"att_Dependency_forcedexec","hp":"Dependency","h4":"Always execute, even in test suite and test set nodes"},"1402":{"id":1402,"content":"Forced cleanup Normally Dependencies are only rolled back and their cleanup code executed as required by the dependency resolution mechanism described in \"Dependency nodes\". In some cases it makes sense to force partial cleanup of the dependency stack immediately after a Test case finishes. This is what the Forced cleanup attribute is for. If this option is activated, the dependency stack will be rolled back at least up to and including this Dependency . Variable: No Restrictions: None","hash":"att_Dependency_forcedcleanup","hp":"Dependency","h4":"Forced cleanup"},"1403":{"id":1403,"content":"Parameter default values Here you can define default or fallback values for the Dependency's parameters (see \"Variables\"). Defining these values also serves as documentation and is a valuable time-saver when using the dialog to select the Dependency for the Referenced dependency attribute of a Dependency reference. See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_Dependency_fallback","hp":"Dependency","h4":"Parameter default values"},"1404":{"id":1404,"content":"QF‑Test ID At the moment the QF‑Test ID attribute has no meaning for this type of node. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_Dependency_id","hp":"Dependency","h4":"QF‑Test ID"},"1405":{"id":1405,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_Dependency_delay","hp":"Dependency","h4":"Delay before/after"},"1406":{"id":1406,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_Dependency_comment","hp":"Dependency","h4":"Comment"},"1407":{"id":1407,"content":"Dependency reference A Dependency reference is simply a stand-in for a Dependency defined in some other place, typically a Package. The name of the referenced Dependency is determined by its Name and the Names of its Package parents. These are concatenated with a dot ('.') as separator, starting with the outermost Package and ending in the Dependency's name. Thus to reference a Dependency named demoStarted in a Package named Demo that is itself a child of a Package named Main, set the Referenced dependency attribute to 'Main.Demo.demoStarted'. See \"Referencing nodes in another test suite\" about how to reference a Dependency in a different test suite. Contained in: Test suite, Test set, Test case and Dependency Children: None Execution: Normally Dependency references are executed only indirectly in the setup phase of a Test set or Test case. If a Dependency reference node is executed interactively, the referenced Dependency is determined and the dependency stack resolved accordingly as described in \"Dependency nodes\". Attributes:","hash":"step_DependencyReference","h1":"Dependency reference"},"1408":{"id":1408,"content":"Figure 34.10: Dependency reference attributes","hash":"figure_34.10","h4":"Figure 34.10: Dependency reference attributes"},"1409":{"id":1409,"content":"Referenced dependency The full name of the Dependency, created from the Names of its Package parents and its own Name, joined by a dot. The \"Select dependency\" button above the attribute brings up a dialog in which you can select the Dependency interactively. By selecting the \"Copy parameters\" checkbox you can adopt the Dependency's Parameter default values as parameters for the Dependency reference node to save typing. Variable: Yes Restrictions: Must not be empty.","hash":"att_DependencyReference_reference","hp":"Dependency reference","h4":"Referenced dependency"},"1410":{"id":1410,"content":"Dependency namespace Normally there is only a single stack of dependencies, but in some cases, e.g. when mixing tests for independent SUT clients, it can be useful to have independent sets of dependencies for different parts of the test, so that resolving the dependencies for one part doesn't necessarily tear down everything required for a different part. By setting the Dependency namespace attribute of a Dependency reference node you can tell QF‑Test to resolve the target dependency in that namespace. The default dependency stack will be completely ignored in that case. If there is a dependency stack remaining from a previous dependency resolution in the same namespace it will be used for comparison instead, otherwise a new stack will be created. For an example please refer to Name spaces for Dependencies. Variable: Yes Restrictions: None","hash":"att_DependencyReference_namespace","hp":"Dependency reference","h4":"Dependency namespace"},"1411":{"id":1411,"content":"Always execute, even in test suite and test set nodes Normally a Dependency is only executed if it belongs to a Test case node. Dependencies in Test suite or Test set nodes are simply inherited by the Test case descendants of these nodes. However, in some cases it is useful to resolve a Dependency early, for example when the Dependency provides parameters for a test run that are required to evaluate a Condition of a subsequent Test case. This can be achieved by activating this option. Variable: No Restrictions: None","hash":"att_DependencyReference_forcedexec","hp":"Dependency reference","h4":"Always execute, even in test suite and test set nodes"},"1412":{"id":1412,"content":"Variable definitions These variables override the Parameter default values of the Dependency referenced by this Dependency reference. See \"Tables\" about how to work with the table. In case you want to re-set the order of the parameters like they are sorted in the called dependency, you can select »Re-set parameter order«. Variable: Variable names no, values yes Restrictions: None","hash":"att_DependencyReference_variable","hp":"Dependency reference","h4":"Variable definitions"},"1413":{"id":1413,"content":"QF‑Test ID At the moment the QF‑Test ID attribute has no meaning for this type of node. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_DependencyReference_id","hp":"Dependency reference","h4":"QF‑Test ID"},"1414":{"id":1414,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_DependencyReference_delay","hp":"Dependency reference","h4":"Delay before/after"},"1415":{"id":1415,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_DependencyReference_comment","hp":"Dependency reference","h4":"Comment"},"1416":{"id":1416,"content":"Setup This node is just like a Sequence except for its special place in a Dependency, Test set or Test case node. Contained in: Dependency, Test set or Test case Children: Any Execution: The Variable definitions of the Setup are bound and its child nodes executed one by one. After the execution of the last child is complete, the variables are unbound again. Attributes:","hash":"step_SetupSequence","h1":"Setup"},"1417":{"id":1417,"content":"Figure 34.11: Setup attributes","hash":"figure_34.11","h4":"Figure 34.11: Setup attributes"},"1418":{"id":1418,"content":"Name The name of a sequence is a kind of short description. It is displayed in the tree view, so it should be concise and say something about the function of the sequence. Variable: No Restrictions: None","hash":"att_SetupSequence_name","hp":"Setup","h4":"Name"},"1419":{"id":1419,"content":"Variable definitions This is where you define the values of the variables that remain bound during the execution of the sequence's child nodes (see \"Variables\"). See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_SetupSequence_variable","hp":"Setup","h4":"Variable definitions"},"1420":{"id":1420,"content":"Maximum error level When a warning, error or exception occurs during a test run, the state of the corresponding node of the run log is set accordingly. This state is normally propagated to the parent node in a way that ensures that the error state of a run log node represents the worst of its child nodes' states. Using this attribute, the maximum error state that the run log node for a sequence will propagate, can be limited. This value has no effect on the way exceptions are handled. It only affects the error states of the run log nodes and by that the exit code of QF‑Test when run in batch mode (see. \"Starting QF‑Test\"). It also has no effect on the creation of compact run logs (see command line argument -compact). The node for a sequence in which a warning, error or exception occurs is never removed from a compact log, even if the error is not propagated due to the setting of this attribute. Variable: No Restrictions: None","hash":"att_SetupSequence_maxerror","hp":"Setup","h4":"Maximum error level"},"1421":{"id":1421,"content":"QF‑Test ID At the moment the QF‑Test ID attribute has no meaning for this type of node. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_SetupSequence_id","hp":"Setup","h4":"QF‑Test ID"},"1422":{"id":1422,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_SetupSequence_delay","hp":"Setup","h4":"Delay before/after"},"1423":{"id":1423,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_SetupSequence_comment","hp":"Setup","h4":"Comment"},"1424":{"id":1424,"content":"Cleanup This node is just like a Sequence except for its special place in a Dependency, Test set or Test case node. Contained in: Dependency, Test set or Test case Children: Any Execution: The Variable definitions of the Cleanup are bound and its child nodes executed one by one. After the execution of the last child is complete, the variables are unbound again. Attributes:","hash":"step_CleanupSequence","h1":"Cleanup"},"1425":{"id":1425,"content":"Figure 34.12: Cleanup attributes","hash":"figure_34.12","h4":"Figure 34.12: Cleanup attributes"},"1426":{"id":1426,"content":"Name The name of a sequence is a kind of short description. It is displayed in the tree view, so it should be concise and say something about the function of the sequence. Variable: No Restrictions: None","hash":"att_CleanupSequence_name","hp":"Cleanup","h4":"Name"},"1427":{"id":1427,"content":"Variable definitions This is where you define the values of the variables that remain bound during the execution of the sequence's child nodes (see \"Variables\"). See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_CleanupSequence_variable","hp":"Cleanup","h4":"Variable definitions"},"1428":{"id":1428,"content":"Maximum error level When a warning, error or exception occurs during a test run, the state of the corresponding node of the run log is set accordingly. This state is normally propagated to the parent node in a way that ensures that the error state of a run log node represents the worst of its child nodes' states. Using this attribute, the maximum error state that the run log node for a sequence will propagate, can be limited. This value has no effect on the way exceptions are handled. It only affects the error states of the run log nodes and by that the exit code of QF‑Test when run in batch mode (see. \"Starting QF‑Test\"). It also has no effect on the creation of compact run logs (see command line argument -compact). The node for a sequence in which a warning, error or exception occurs is never removed from a compact log, even if the error is not propagated due to the setting of this attribute. Variable: No Restrictions: None","hash":"att_CleanupSequence_maxerror","hp":"Cleanup","h4":"Maximum error level"},"1429":{"id":1429,"content":"QF‑Test ID At the moment the QF‑Test ID attribute has no meaning for this type of node. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_CleanupSequence_id","hp":"Cleanup","h4":"QF‑Test ID"},"1430":{"id":1430,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_CleanupSequence_delay","hp":"Cleanup","h4":"Delay before/after"},"1431":{"id":1431,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_CleanupSequence_comment","hp":"Cleanup","h4":"Comment"},"1432":{"id":1432,"content":"Error handler This node is just like a Sequence except for its special place in a Dependency (see \"Dependency nodes\"). Contained in: Dependency Children: Any Execution: The Variable definitions of the Error handler are bound and its child nodes executed one by one. After the execution of the last child is complete, the variables are unbound again. Attributes:","hash":"step_ErrorHandler","h1":"Error handler"},"1433":{"id":1433,"content":"Figure 34.13: Error handler attributes","hash":"figure_34.13","h4":"Figure 34.13: Error handler attributes"},"1434":{"id":1434,"content":"Name The name of a sequence is a kind of short description. It is displayed in the tree view, so it should be concise and say something about the function of the sequence. Variable: No Restrictions: None","hash":"att_ErrorHandler_name","hp":"Error handler","h4":"Name"},"1435":{"id":1435,"content":"Variable definitions This is where you define the values of the variables that remain bound during the execution of the sequence's child nodes (see \"Variables\"). See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_ErrorHandler_variable","hp":"Error handler","h4":"Variable definitions"},"1436":{"id":1436,"content":"Maximum error level When a warning, error or exception occurs during a test run, the state of the corresponding node of the run log is set accordingly. This state is normally propagated to the parent node in a way that ensures that the error state of a run log node represents the worst of its child nodes' states. Using this attribute, the maximum error state that the run log node for a sequence will propagate, can be limited. This value has no effect on the way exceptions are handled. It only affects the error states of the run log nodes and by that the exit code of QF‑Test when run in batch mode (see. \"Starting QF‑Test\"). It also has no effect on the creation of compact run logs (see command line argument -compact). The node for a sequence in which a warning, error or exception occurs is never removed from a compact log, even if the error is not propagated due to the setting of this attribute. Variable: No Restrictions: None","hash":"att_ErrorHandler_maxerror","hp":"Error handler","h4":"Maximum error level"},"1437":{"id":1437,"content":"QF‑Test ID At the moment the QF‑Test ID attribute has no meaning for this type of node. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_ErrorHandler_id","hp":"Error handler","h4":"QF‑Test ID"},"1438":{"id":1438,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_ErrorHandler_delay","hp":"Error handler","h4":"Delay before/after"},"1439":{"id":1439,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_ErrorHandler_comment","hp":"Error handler","h4":"Comment"},"1440":{"id":1440,"content":"Mobile Manual","hash":"","h0":"Data driver | QF‑Test Manual"},"1441":{"id":1441,"content":"Mobile Manual","hash":"home-link","h0":"Data driver | QF‑Test Manual"},"1442":{"id":1442,"content":"Data driver The term Data-driven Testing refers to a common method in automated testing where test cases are executed several times with different sets of data defined. With QF‑Test's highly flexible variables there is no limit on how this data can be used but the most common case is for event input values and expected check values. QF‑Test's data-driving mechanism consists of the Data driver node used to provide a data-driving context and several kinds of Data binders. Currently available are the Data table node that stores data internally within QF‑Test the CSV data file node that reads data from a CSV file, the Database node that reads data from a database and the Excel data file that reads data from an Excel file. An extension API for plugging in arbitrary external data is also available. Further information about how the various parts of the data driver mechanism are working together is provided in \"Data-driven testing\".","hash":"sec_datadriver","h0":"Data driver"},"1443":{"id":1443,"content":"Data driver Except for its special place in a Test set or Test step, a Data driver is just like a normal Sequence. It provides a context for one or more Data binders to register themselves during the execution of the Data driver. The Test set then iterates over the sets of data provided by the registered Data binders and executes its child nodes as described in \"Data-driven testing\". For this purpose a Data driver node needs to be placed in a Test set node, between the optional Dependency and Setup nodes. Data driver nodes can also be placed in a Test step as first steps. Contained in: Test set, Test step. Children: Any Execution: When a Test set or Test step is executed it checks for a Data driver and runs it. The contents of the Data driver node are not limited to Data binders, but can hold any executable node so that they can perform any setup that may be required to retrieve the data. Thus it is also possible to share Data binders by placing them inside a Procedure and calling the Procedure from inside the Data driver. Any Data binders registered within this Data driver's context will then be queried for data by the Test set or Test step. Attributes:","hash":"step_DataDriver","h1":"Data driver"},"1444":{"id":1444,"content":"Figure 34.14: Data driver attributes","hash":"figure_34.14","h4":"Figure 34.14: Data driver attributes"},"1445":{"id":1445,"content":"Name The name of a Data driver is a kind of short description. It is displayed in the tree view, so it should be concise and say something about the kind of data provided. Variable: No Restrictions: None","hash":"att_DataDriver_name","hp":"Data driver","h4":"Name"},"1446":{"id":1446,"content":"Name for loop pass in the run log A separate name for each iteration to be used in the run log. It can make use of the variables bound as a result of the data-driving which makes it easier to locate a specific step of the iteration. Variable: Yes Restrictions: None","hash":"att_DataDriver_loopreportname","hp":"Data driver","h4":"Name for loop pass in the run log"},"1447":{"id":1447,"content":"Name for separate run log If this attribute is set it marks the node as a breaking point for split run logs and defines the filename for the partial log. Every time an iteration of the Data driver finishes, the respective log entry is removed from the main run log and saved as a separate, partial run log. This operation is completely transparent, the main run log retains references to the partial logs and is fully controllable. Please see \"Split run logs\" for further information about split run logs. This attribute has no effect if the option Create split run logs is disabled or split run logs are explicitly turned off for batch mode via the -splitlog command line argument. There is no need to keep the filename unique. If necessary, QF‑Test appends a number to the filename to avoid collisions. The filename may contain directories and, similar to specifying the name of a run log in batch mode on the command line, the following placeholders can be used after a '%' or a '+' character:","hash":"att_DataDriver_externalizename","hp":"Data driver","h4":"Name for separate run log"},"1448":{"id":1448,"content":"If this attribute is set it marks the node as a breaking point for split run logs and defines the filename for the partial log. Every time an iteration of the Data driver finishes, the respective log entry is removed from the main run log and saved as a separate, partial run log. This operation is completely transparent, the main run log retains references to the partial logs and is fully controllable. Please see \"Split run logs\" for further information about split run logs. This attribute has no effect if the option Create split run logs is disabled or split run logs are explicitly turned off for batch mode via the -splitlog command line argument. There is no need to keep the filename unique. If necessary, QF‑Test appends a number to the filename to avoid collisions. The filename may contain directories and, similar to specifying the name of a run log in batch mode on the command line, the following placeholders can be used after a '%' or a '+' character: Character Replacement % Literal '%' character. + Literal '+' character. i The current runid as specified with -runid <ID>. r The error level of the partial log. w The number of warnings in the partial log. e The number of errors in the partial log. x The number of exceptions in the partial log. t The thread index to which the partial log belongs (for tests run with parallel threads). y The current year (2 digits). Y The current year (4 digits). M The current month (2 digits). d The current day (2 digits). h The current hour (2 digits). m The current minute (2 digits). s The current second (2 digits). Table 34.5: Placeholders for the Name for separate run log attribute Variable: Yes Restrictions: None, characters that are illegal for a filename will be replaced with '_'.","hash":"table_34.5","hp":"Data driver","h4":"Name for separate run log"},"1449":{"id":1449,"content":"Variable definitions This is where you define the values of the variables that remain bound during the execution of the sequence's child nodes (see \"Variables\"). See \"Tables\" about how to work with the table. Variable: Variable names no, values yes Restrictions: None","hash":"att_DataDriver_variable","hp":"Data driver","h4":"Variable definitions"},"1450":{"id":1450,"content":"QF‑Test ID At the moment the QF‑Test ID attribute has no meaning for this type of node. Variable: No Restrictions: Must not contain any of the characters '\\', '#', '$', '@', '&', or '%' or start with an underscore ('_').","hash":"att_DataDriver_id","hp":"Data driver","h4":"QF‑Test ID"},"1451":{"id":1451,"content":"Delay before/after These attributes cause a delay before or after the execution of the node. If a value is empty, the Default delay from the global options is used. Variable: Yes Restrictions: Valid number >= 0","hash":"att_DataDriver_delay","hp":"Data driver","h4":"Delay before/after"},"1452":{"id":1452,"content":"Comment Here you can enter a comment that explains the purpose of this node. This is the preferred way of documenting the test suite. For detailed documentation, especially for Test set, Test case or Procedure nodes, this text area might not be the right place. There are many excellent editors that are much better suited to this task. The option External editor command lets you define an external editor in which comments can be edited conveniently by pressing Alt⁠+⁠Return or by clicking the button. You can trigger special behaviors of some nodes using doctags, please see Doctags. If you enter text in the comment field of a Component node, the node will be considered as 'used' when you want to mark or delete unused components. Variable: Yes Restrictions: None","hash":"att_DataDriver_comment","hp":"Data driver","h4":"Comment"},"1453":{"id":1453,"content":"Data table A Data table provides a convenient interface for storing test data in tabular form directly inside QF‑Test. For details about the data-driving mechanism please see \"Data-driven testing\". Contained in: Any Children: None Execution: The Data table expands variable values in the table according to the option When binding variables, expand values immediately. Each row is expanded individually left to right, meaning that - within the same row - a cell may refer to a variable bound in a column further to the left. Then the Data table registers itself with the Data driver context. A property group called like the node will be created additionally. That group contains the variables size and totalsize. size shows the number of data rows with taking care about iteration intervals. The variable totalsize shows the total number of data rows without taking care about iteration intervals. When all Data binders have been registered the Test set will query the Data table in order to iterate over the available sets of data. If no such context is available the respective property group will be extended with all variables. Attributes:","hash":"step_TableDataBinder","h1":"Data table"},"1454":{"id":1454,"content":"Figure 34.15: Data table attributes","hash":"figure_34.15","h4":"Figure 34.15: Data table attributes"},"1455":{"id":1455,"content":"Name The Name of a Data binder is mandatory. It is used to distinguish Data binders in the same Data driver context. A Break node executed during data-driven testing can be used to break out of a specific loop by referring to the Data binder's Name. Variable: Yes Restrictions: None","hash":"att_TableDataBinder_name","hp":"Data table","h4":"Name"},"1456":{"id":1456,"content":"Iteration counter The name of the variable that the iteration counter will be bound to. Variable: Yes Restrictions: None","hash":"att_TableDataBinder_var","hp":"Data table","h4":"Iteration counter"},"1457":{"id":1457,"content":"Iteration ranges An optional set of indexes or ranges to use from the bound data. This is especially useful during test development in order to run sample tests with just a single index or a subset of the given data. Ranges are separated by ','. Each range is either a single index or an inclusive range of the form 'from-to' or 'from:to' where 'to' is optional.