import {AbstractTestRunListener} from 'de.qfs.apps.qftest.extensions.qftest'

const binding = this

const Tracer = Java.extend(AbstractTestRunListener,{
    runStarted(event) {
        print("Run started")
    },
    runStopped(event) {
        print("Run stopped")
    },
    nodeEntered(event) {
        const name = event.getNode().getName()
        const nodeType = event.getNode().getType()
        if (nodeType == "TestCase") {
            if (name) {
                const parts = name.split(":")
                binding.rc.setGlobal("tcid", parts[0])
            }
        }
    },
    nodeExited(event) {},
    problemOccurred(event) {
        if (event.getState() > 1) {
            binding.error = "KO"
        }
    }
})

try {
    rc.removeTestRunListener(tcidlistener)
} catch(e) {}

tcidlistener = new Tracer()
rc.addTestRunListener(tcidlistener)

