import de.qfs.apps.qftest.extensions.ResolverRegistry
import de.qfs.apps.qftest.extensions.checks.*
import de.qfs.apps.qftest.shared.data.check.*
import de.qfs.lib.util.Pair

// Modifications required at (!)

class CustomChecker implements Checker {

    /**
     * Description of the checkType
     */
    def getCheckType() {
        return new DefaultCheckType(
            "CurrencyText_checked",  // (!) An internal name of the new checker
            CheckDataType.STRING,    // (!) Type: STRING, STRING_LIST, SELECTABLE_STRING_LIST, BOOLEAN, GEOMETRY, IMAGE
            "Text without Currency"  // (!) The Label in the popup menu
        )
    }

    /**
     * Supported checkTypes
     */
    DefaultCheckType[] getSupportedCheckTypes(def com, def item) {
        return [getCheckType()] as DefaultCheckType[];
    }

    /**
     * Get the current check data in the target element or sub-item.
     *
     * @return  The check data or null if the check is not supported.
     */
    CheckData getCheckData(def com, def item, CheckType checkType) {
        if (checkType.getIdentifier() != getCheckType().getIdentifier()) return null // Not our job...

        // (!) Implement the check data logic
        def rawValue = com.getText()
        def checkData = rawValue.replaceAll(~/[^0-9.,]/, "")

        return new StringCheckData(checkType.getIdentifier(), checkData) // (!) or StringItemsCheckData, SelectableItemsCheckData, BooleanCheckData, GeometryCheckData, ImageCheckData
    }

    /**
     * Get the current check data in the target element or sub-item and the item that the check
     * data corresponds to. For example, when recording a column check after right-clicking on a
     * table cell, the input subItem will be the cell while the return item should be the column.
     *
     * @return  A pair of the check data and target item or null if the check is not supported.
     **/
    Pair getCheckDataAndItem(def com, def item, CheckType checkType) {
        def data = getCheckData(com, item, checkType)
        if (! data) return null
        return new Pair(data, item) // (!) Probably adapt item
    }

    def b // callers binding

    // Unregister previous instance of this check/element combination
    def unregister(element) {
        if (! b.hasVariable("customCheckers")) return

        def checkIdentifier = getCheckType().getIdentifier()

        def thisCustomCheckers = b.customCheckers[checkIdentifier]
        if (! thisCustomCheckers) return
        def customChecker = thisCustomCheckers[element]
        if (! customChecker) return

        b.customCheckers[checkIdentifier].remove(element)
        CheckerRegistry.instance().unregisterChecker(element, customChecker)

        return this
    }

    def register(element) {
        unregister(element)

        def checkIdentifier = getCheckType().getIdentifier()

        // init container for unregistration
        if (! b.hasVariable("customCheckers")) {
            b.customCheckers = [:]
        }
        if (! b.customCheckers[checkIdentifier]) {
            b.customCheckers[checkIdentifier] = [:]
        }

        b.customCheckers[checkIdentifier][element] = this
        CheckerRegistry.instance().registerChecker(element, this)
        return this
    }
}

new CustomChecker(b:binding).register("TextField") // (!) Adapt to component type for which to register the check