import {ResolverRegistry} from 'de.qfs.apps.qftest.extensions'
import {Checker, DefaultCheckType, CheckDataType, CheckerRegistry} from 'de.qfs.apps.qftest.extensions.checks'
import {StringCheckData} from 'de.qfs.apps.qftest.shared.data.check'
import {Pair} from 'de.qfs.lib.util'
const DefaultCheckTypeArray = Java.type("de.qfs.apps.qftest.extensions.checks.DefaultCheckType[]")

// Modifications required at (!)

class CustomChecker {
    getCheckType() {
        return new DefaultCheckType(
            "CurrencyText_checked",  // (!) An internal name of the new checker
            CheckDataType.STRING,    // (!) Type: STRING, STRING_LIST, SELECTABLE_STRING_LIST, BOOLEAN, GEOMETRY, IMAGE
            "Text without Currency"  // (!) The Label in the popup menu
        )
    }

    constructor(binding) {
        this.binding = binding // remember outer bindungs for "globals" access

        const object = this; // store reference for access from "this.checker"

        // Extend the Java checker interface:
        this.checker = new (Java.extend(Checker, {
            /**
             * Supported checkTypes
             */
            getSupportedCheckTypes: function(com, item) {
                return Java.to([object.getCheckType()],DefaultCheckTypeArray)
            },

            /**
             * Get the current check data in the target element or sub-item.
             *
             * @return  The check data or null if the check is not supported.
             */
             getCheckData: function(com, item, checkType) {
                 if (checkType.getIdentifier() != object.getCheckType().getIdentifier()) return null // Not our job...

                 // (!) Implement the check data logic
                 const rawValue = com.getText()
                 const checkData = rawValue.replace(/[^0-9.,]/g, "")

                 return new StringCheckData(checkType.getIdentifier(), checkData) // (!) or StringItemsCheckData, SelectableItemsCheckData, BooleanCheckData, GeometryCheckData, ImageCheckData
             },

             /**
              * Get the current check data in the target element or sub-item and the item that the check
              * data corresponds to. For example, when recording a column check after right-clicking on a
              * table cell, the input subItem will be the cell while the return item should be the column.
              *
              * @return  A pair of the check data and target item or null if the check is not supported.
              **/
             getCheckDataAndItem: function(com, item, checkType) {
                 const data = this.getCheckData(com, item, checkType)
                 if (! data) return null
                 return new Pair(data, item) // (!) Probably adapt item
             }

        }));
    }

    // Unregister previous instance of this check/element combination
    unregister(element) {
        if (! this.binding.customCheckers) return

        const checkIdentifier = this.getCheckType().getIdentifier()

        const thisCustomCheckers = this.binding.customCheckers[checkIdentifier]
        if (! thisCustomCheckers) return
        const customChecker = thisCustomCheckers[element]
        if (! customChecker) return

        delete this.binding.customCheckers[checkIdentifier][element]
        CheckerRegistry.instance().unregisterChecker(element, customChecker)

        return this
    }

    register(element) {
        this.unregister(element)

        const checkIdentifier = this.getCheckType().getIdentifier()

        // init container for unregistration
        if (! this.binding.customCheckers) {
            this.binding.customCheckers = {}
        }
        if (! this.binding.customCheckers[checkIdentifier]) {
            this.binding.customCheckers[checkIdentifier] = {}
        }

        this.binding.customCheckers[checkIdentifier][element] = this.checker
        CheckerRegistry.instance().registerChecker(element, this.checker)
        return this
    }
}

(new CustomChecker(this)).register("TextField") // (!) Adapt to component type for which to register the check
