import de.qfs.ImageWrapper

def iw = new ImageWrapper(rc)

def suiteDir = rc.lookup("qftest", "suite.dir")

//Create Screenshots
def screenshot = iw.grabScreenshot()
def discount = iw.grabImage(rc.getComponent("CalculatedPrice"))

//Write images to protocol or 
rc.logImage(screenshot)
iw.savePng(suiteDir + "/image.png", screenshot)
rc.logImage(discount)
iw.savePng(suiteDir + "/discount.png", discount)

//Compare images
def pngImg = iw.loadPng(suiteDir + "/discount.png")
rc.checkImage(pngImg, discount, "Discount from file")
rc.checkImageAdvanced(pngImg, discount, "Discount from file", "algorithm=similarity")