from imagewrapper import ImageWrapper

iw = ImageWrapper(rc)

suiteDir = rc.lookup("qftest", "suite.dir")

#Create Screenshots
screenshot = iw.grabScreenshot()
discount = iw.grabImage(rc.getComponent("CalculatedPrice"))

#Write images to protocol or 
rc.logImage(screenshot)
iw.savePng(suiteDir + "/image.png", screenshot)
rc.logImage(discount)
iw.savePng(suiteDir + "/discount.png", discount)

#Compare images
pngImg = iw.loadPng(suiteDir + "/discount.png")
rc.checkImage(pngImg, discount, "Discount from file")
rc.checkImageAdvanced(pngImg, discount, "Discount from file", "algorithm=similarity")