sidx_dump={"version":"0.9.5","fields":["content","h-1","h0","h1","h2","h3","hash"],"ref":"id","documentStore":{"docs":{"0":{"id":0,"content":"Mobile Tutorial","hash":"","h0":"Preface | QF‑Test Tutorial"},"1":{"id":1,"content":"Mobile Tutorial","hash":"home-link","h0":"Preface | QF‑Test Tutorial"},"2":{"id":2,"content":"Preface","hash":"sec_Introduction","h0":"Preface"},"3":{"id":3,"content":"QF‑Test QF‑Test is a professional tool for automated testing of Java, Web and native Windows applications with a graphical user interface (UI). QF‑Test tests the system as a whole through the UI. It can also be used for integration tests checking the overall workflow and the interaction of single systems. The main use cases for QF‑Test are automated regression tests. You can use it as well for load testing and input of mass data via the graphical user interface. QF‑Test is designed for the use of testers and developers alike. It has an intuitive UI. Tests can easily be build with the recording function. On the other hand tests can be set up and structured like any other software. If you need to test some functionality for which QF‑Test provides no standard test elements you can almost always implement it via a script. During test execution QF‑Test writes a run log intended for post-mortem error analysis. Additionally you can create configurable HTML reports (also XML or JUnit format) presenting the test results in an overview and with graphics. QF‑Test can be run platform independently on Windows, Linux and macOS. It supports the Java technologies Swing, JavaFX and SWT and the most common web browsers, some even headless. From QF‑Test version 5 on you can also test native Windows applications. For a detailed list of the supported platforms, Java and browser technologies please refer to the System requirements section of the user manual. The video 'Overview' gives a general overview of QF‑Test. You will find a more technical overview in the video 'Technical insights'.","hash":"sec_qf_test","h1":"QF‑Test"},"4":{"id":4,"content":"Tutorial This tutorial is meant as a hands-on introduction to QF‑Test. In the base part we will show the main functions of QF‑Test and guide you through the necessary steps to set up your own test suite. You will learn how to analyze your test results, step through your test by use of the debugger and generate an overview report. Further topics are the concept of modularization by help of procedures and component recognition, which is of central meaning in UI Testing. With \"Advanced features of QF‑Test\" some more advanced QF‑Test features come on stage, like data-driven testing, ensuring of test case prerequisites and automatic generation of basic procedures. Those apply for Java, web and native Windows testing. The way you write tests for Java, Web or native Windows applications is the same for all three technologies. Only with Web applications you might have to have a look at component recognition before you start with the tests, and with native Windows applications you need to be a bit more patient when recording or replaying the tests. Now you might wonder why we provided three different base parts. This is because the demo applications we use look slightly different for each technology. You also get different setup sequences and different components. So, in order as not to confuse you with a demo not matching the exact description of the tutorial we decided to provide three base parts, \"Java UI testing with QF‑Test\" for Java, \"Web UI testing with QF‑Test\" for Web and \"Native Windows UI testing with QF‑Test\" for native Windows applications. This tutorial is also available as HTML online version at www.qftest.com/doc/tutorial/en/tutorial.html. As an alternative to private study, QFS offers training courses for QF‑Test. Details can be found at www.qftest.com/en/support/training-consulting/training.html. The following notations are used throughout the tutorial: »Menu«-»Submenu« represents a menu or menu item. Modifier⁠+⁠Key stands for a keystroke, where the modifier is one (or a combination) of Shift/⇧, Control/⌃, Alt/⌥, or ⌘. Monospaced font is used for names of directories and files, user input and program output.","hash":"sec_tutorial","h1":"Tutorial"},"5":{"id":5,"content":"Feedback This tutorial has been rewritten from scratch for QF‑Test 4.2. We hope you'll like it and look forward to your feedback - be it positive or negative. Please send all comments, bug reports, wishes etc. to support@qftest.com.","hash":"sec_feedback","h1":"Feedback"},"6":{"id":6,"content":"Mobile Tutorial","hash":"","h0":"Mobile Apps testing with QF‑Test | QF‑Test Tutorial"},"7":{"id":7,"content":"Mobile Tutorial","hash":"home-link","h0":"Mobile Apps testing with QF‑Test | QF‑Test Tutorial"},"8":{"id":8,"content":"Mobile Apps testing with QF‑Test This part of the tutorial explains the basic features and workflows of QF‑Test for testing mobile applications. The contents presented in this tutorial refer to an Android application. The fundamentals, however, are identical for iOS. A test environment as described in the manual is required. Details about the required test environment can be found in the manual chapters Android and iOS applications. Please make sure to read them! In \"Advanced features of QF‑Test\" more advanced QF‑Test features are explained, applicable for all supported UI technologies.","hash":"sec_mobile","h1":"Mobile Apps testing with QF‑Test"},"9":{"id":9,"content":"Mobile Tutorial","hash":"","h0":"Working with a Sample Test suite (Mobile) | QF‑Test Tutorial"},"10":{"id":10,"content":"Mobile Tutorial","hash":"home-link","h0":"Working with a Sample Test suite (Mobile) | QF‑Test Tutorial"},"11":{"id":11,"content":"Working with a Sample Test suite (Mobile) In this first chapter, we will have a look at the structure of a simple test suite, explain its major elements, execute it and evaluate the result.","hash":"sec_androiddemo","h1":"Working with a Sample Test suite (Mobile)"},"12":{"id":12,"content":"Mobile Tutorial","hash":"","h0":"Loading the Test suite | QF‑Test Tutorial"},"13":{"id":13,"content":"Mobile Tutorial","hash":"home-link","h0":"Loading the Test suite | QF‑Test Tutorial"},"14":{"id":14,"content":"Loading the Test suite On first startup of QF‑Test and/or the System Under Test (SUT) via QF‑Test you might get a security warning from the firewall asking whether to block the Java network communication. As QF‑Test communicates with the SUT by means of the Java network protocols, this must not be blocked by the local firewall in order to allow automated testing. After starting up QF‑Test, you can immediately bring up our first example test suite: Press the toolbar button to bring up the file open dialog. Navigate to the subdirectory qftest-10.0.2-mobile/doc/tutorial of your QF‑Test installation. There select the file FirstAndroidTests.qft and open it. If you want to use the tutorial for iOS, please select FirstIOSTests.qft. QF‑Test will then load the indicated test suite which should look as follows:","hash":"tut_loadsuiteandroid","h0":"Loading the Test suite"},"15":{"id":15,"content":"Figure 1.1: The first test suite The left part of the main window contains the test suite, organized in a tree structure. The right side shows the details of the currently selected tree node. At bottom right you'll see the terminal displaying messages sent by QF‑Test and the application you are testing. In the tree structure of the main window you can navigate and select individual nodes of the test suite. Double click the node Test set: Simple Tests to expand it and reveal its child nodes. The test set contains two test case nodes enclosed by a Setup/Cleanup pair, which mainly starts and stops the test application.","hash":"fig_firstTestSuiteAndroid","h4":"Figure 1.1: The first test suite"},"16":{"id":16,"content":"Figure 1.2: The contents of the \"Test set: Simple Tests\" node In the following sections we'll describe the purpose and function of the individual nodes.","hash":"fig_firstTestSetAndroid","h4":"Figure 1.2: The contents of the \"Test set: Simple Tests\" node"},"17":{"id":17,"content":"Mobile Tutorial","hash":"","h0":"Starting and Connecting the Device | QF‑Test Tutorial"},"18":{"id":18,"content":"Mobile Tutorial","hash":"home-link","h0":"Starting and Connecting the Device | QF‑Test Tutorial"},"19":{"id":19,"content":"Starting and Connecting the Device The Android application can either be tested on a real Android device or an emulator, an iOS application of a real iOS device or a simulator. Subsequently, the term \"device\" refers to any of the options. Our first step is to examine the Setup node more closely: Expand the Setup: Start device and connect node, as shown below.","hash":"tut_startsutandroid","h0":"Starting and Connecting the Device"},"20":{"id":20,"content":"Figure 1.3: The Setup node You will see two child nodes: Set variable – set the variable client to the connection name for the SUT, which will be needed for every action replayed to the application. Start device and connect – starts the corresponding Emulator (Android) or Simulator (iOS), or connects to a real device if a connection is not yet established, and opens the CarConfigurator app.","hash":"fig_firstSetupAndroid","h4":"Figure 1.3: The Setup node"},"21":{"id":21,"content":"Figure 1.4: The sequence to start the mobile device In Start device and connect, the first entry is a Wait for client node to check whether the client is already running. Only if not, it will be started. Starting the device is done in two steps: First, the Connect to Android device node tries to connect to to a real Android device or a running emulator. In case it fails QF‑Test jumps to the Catch node where the Start Android emulator node starts the emulator if the given device is an emulator. Note: For iOS, the node Connect to iOS device is used to connect to a real device as well as to a simulator. Wait for mobile device – finalizes the connection to the Android device and for both technologies waits for the connection to be up and running. These two steps are created automatically when using the Quickstart Wizard, which is explained in the next tutorial chapter (\"Starting the Application\"). Let's start the application: If you want to use a real device or a specific emulator, start it manually first. For performance reasons we recommend starting the emulator manually, so it is not linked to the QF‑Test client process and does not need to be restarted every time. Alternatively, you can set the emulator name via the Test suite node variable definition deviceName. You can see the devices available via the menu »Extras«»Known Android devices…«. If the variable deviceName is not set, QF‑Test first looks for an Android device already running. If none is running, an available one will be started. Select the node Setup: Start device and connect, keeping it expanded. Click the Start test run toolbar button. This executes the currently selected node. During execution QF‑Test marks the active step by use of an arrow pointer ->. After the setup sequence is completed, the demo app \"CarConfigurator\" should appear on the Android device.","hash":"fig_firstStartAndroid","h4":"Figure 1.4: The sequence to start the mobile device"},"22":{"id":22,"content":"Figure 1.5: The CarConfigurator Android demo","hash":"fig_androidDemoApp","h4":"Figure 1.5: The CarConfigurator Android demo"},"23":{"id":23,"content":"Mobile Tutorial","hash":"","h0":"First test case | QF‑Test Tutorial"},"24":{"id":24,"content":"Mobile Tutorial","hash":"home-link","h0":"First test case | QF‑Test Tutorial"},"25":{"id":25,"content":"First test case Next we will have a look at the first test case. It consists of four test steps:","hash":"tut_firsttestandroid","h0":"First test case"},"26":{"id":26,"content":"Figure 1.6: The \"First\" Test case node Reset – performs a reset via the »File« menu and selects the Vehicles tab. Select Model Rolo – selects the first vehicle model \"Rolo\" from the list. Select Special Model Jazz – switches to the Specials tab and selects \"Jazz\". Check Final Price – checks that the calculated value of the \"Final Price\" field equals a given value. Test steps are used to group nodes and to document what is being done. This proves very useful when it comes to error analysis or test adaptations later on. Expand the four test step nodes.","hash":"fig_firstTestCaseAndroid","h4":"Figure 1.6: The \"First\" Test case node"},"27":{"id":27,"content":"Figure 1.7: Details of the first test case You can see Mouse clicks and Checks, which have been grouped in test step nodes for better readability of the test case. The action nodes display the action type (Mouse click, Check, ...) and the component targeted, i.e. where the action goes to. When writing a test you can use the QF‑Test recording function to create them. Recording will be explained in the next Creating your own test suite (Mobile). Let's execute the first test case: Select the node Test case: First. Click the replay button . The test steps will then be replayed. The test result is indicated during and after the test run in the status bar at the bottom right of the QF‑Test main window and should read 'Finished: No errors'. Next to it, there are counters for the numbers and results of the test cases executed. In our case, it was just one, error-free, which means a success rate of 100%.","hash":"fig_firstTestCaseDetailsAndroid","h4":"Figure 1.7: Details of the first test case"},"28":{"id":28,"content":"Figure 1.8: The result view in the status bar Each counter icon has a descriptive tool tip. A list of all counters can be found in the chapter Capture and replay of the manual.","hash":"fig_resultOneTestCaseNoErrorAndroid","h4":"Figure 1.8: The result view in the status bar"},"29":{"id":29,"content":"Mobile Tutorial","hash":"","h0":"Second Test case - with Error | QF‑Test Tutorial"},"30":{"id":30,"content":"Mobile Tutorial","hash":"home-link","h0":"Second Test case - with Error | QF‑Test Tutorial"},"31":{"id":31,"content":"Second Test case - with Error The second test case will show us what will happen when an error occurs during test execution. Expand the node Test case: Second (with Error).","hash":"tut_secondtestandroid","h0":"Second Test case - with Error"},"32":{"id":32,"content":"Figure 1.9: The \"Second\" Test case node Except for the third test step it is identical to the first test case. So what does the unknown step do? Test step: Grant 5% discount – presses the 5% discount button.","hash":"fig_secondTestCaseAndroid","h4":"Figure 1.9: The \"Second\" Test case node"},"33":{"id":33,"content":"Figure 1.10: Details of the second test case Let's execute the second test case: Select the node Test case: Second (with Error). Click the replay button . This time a dialog shows up telling us that an error occurred.","hash":"fig_secondTestCaseDetailsAndroid","h4":"Figure 1.10: Details of the second test case"},"34":{"id":34,"content":"Figure 1.11: Error in the second test case What happened? To find out we'll open the QF‑Test run log for error analysis. An alternative approach for error analysis would be to execute the test case again using the debugger. This will be explained in chapter Using the Debugger (Mobile).","hash":"fig_textTestErrorAndroid","h4":"Figure 1.11: Error in the second test case"},"35":{"id":35,"content":"Mobile Tutorial","hash":"","h0":"The Run log for Error Diagnosis | QF‑Test Tutorial"},"36":{"id":36,"content":"Mobile Tutorial","hash":"home-link","h0":"The Run log for Error Diagnosis | QF‑Test Tutorial"},"37":{"id":37,"content":"The Run log for Error Diagnosis QF‑Test logs detailed information for every test execution. Please open the latest run log by one of the following options: either by pressing the Show run log button of the error dialog or in case you have already closed the dialog by pressing toolbar button or by pressing Ctrl⁠+⁠L. The most recent run logs are also listed at the bottom of the Run menu of the main window. The run log comes up in a separate window displaying the logged actions of the test case you've just executed:","hash":"tut_firstRunlogAndroid","h0":"The Run log for Error Diagnosis"},"38":{"id":38,"content":"Figure 1.12: Run log of the second test case The run log reflects the tree structure of the test suite view you are already familiar with. When you click on one of the nodes on the left side, the properties of the event including time stamp and duration will be displayed on the right. In the tree on the left you will notice nodes surrounded by a red border. These indicate that a problem occurred in a child node. If you keep expanding the red nodes, you'll eventually come to the actual error node. Please use an easier way to find the error source by pressing the Find next error toolbar button or the [Ctrl-N] key shortcut. All nodes with red highlighting have been expanded and the actual error node has been selected:","hash":"fig_firstErrorRunlogAndroid","h4":"Figure 1.12: Run log of the second test case"},"39":{"id":39,"content":"Figure 1.13: Error diagnosis for the second test case The error message on the right says that the expected value of the final price field differs from the actual one. Of course this error is there by intention as the second test case is supposed to show us how to analyze an error. Another helper for error analysis is the Screenshot node of the SUT taken at the time when the error occurred. Its details view contains a full screenshot of the screen at the time of the error, which is often useful for determining the cause of the error. The following image shows such a screenshot node:","hash":"fig_firstErrorRunlogDetailsAndroid","h4":"Figure 1.13: Error diagnosis for the second test case"},"40":{"id":40,"content":"Figure 1.14: Screenshot node showing the error situation In addition to screenshots of all monitors, QF‑Test also saves images of the client windows at the time of the error. This allows you to analyze their contents even if they are covered by other dialogs or windows. The information gathered in a long test run accumulates and can eat up enormous amounts of memory. This is the reason why QF‑Test is configured by default to create a compact run log, keeping only the relevant information for report generation and error diagnosis. This functionality can be configured via the option \"Create compact run log\" within »Edit«-»Options«-»Run logs«-»Content«. The root node of the run log tells you whether it is a compact or detailed run log. You can also configure the number of screenshots to be saved.","hash":"fig_firstErrorRunlogScreenshotAndroid","h4":"Figure 1.14: Screenshot node showing the error situation"},"41":{"id":41,"content":"Mobile Tutorial","hash":"","h0":"Getting Help | QF‑Test Tutorial"},"42":{"id":42,"content":"Mobile Tutorial","hash":"home-link","h0":"Getting Help | QF‑Test Tutorial"},"43":{"id":43,"content":"Getting Help We take a short break in this section to give you a few tips that might prove helpful as you continue with the tutorial. There are different places where you can look for help or information: The most comprehensive search can be achieved via »Help«-»Online search...«. This navigates you to the search functionality on our homepage and allows querying throughout all available documentation (manual, tutorial, standard library, blog and our videos). Search results can be filtered as needed. In case you work offline and want to search for a certain topic, the offline versions of the manual or tutorial available via the »Help« menu can be used. QF‑Test also offers a context sensitive help for tree node types and their details. To use it, simply press the right mouse button on an arbitrary tree node or attribute in the details pane. From the context menu select »What's this?«. This will directly bring you to the reference explanation of this item in the manual. Beside getting help from the documentation you also have the option to contact our support team. During your evaluation phase or after that as customer with a valid maintenance contract you may issue your questions directly to our support experts using the QF‑Test help menu entry »Contact the support team« or via our website.","hash":"tut_firsthelpandroid","h0":"Getting Help"},"44":{"id":44,"content":"Mobile Tutorial","hash":"","h0":"Stopping the Application | QF‑Test Tutorial"},"45":{"id":45,"content":"Mobile Tutorial","hash":"home-link","h0":"Stopping the Application | QF‑Test Tutorial"},"46":{"id":46,"content":"Stopping the Application We haven't inspected the cleanup sequence yet, so let's have a look at it now: Expand the Cleanup: Stop demo node.","hash":"tut_firstcleanupandroid","h0":"Stopping the Application"},"47":{"id":47,"content":"Figure 1.15: The Cleanup sequence The Cleanup sequence stops the client process in a hard way and waits until it fully terminates. This is a very simple approach and shall suffice for the moment. If the emulator/simulator was started by QF‑Test, it will also be stopped when the client process is terminated.","hash":"fig_firstCleanupAndroid","h4":"Figure 1.15: The Cleanup sequence"},"48":{"id":48,"content":"Mobile Tutorial","hash":"","h0":"A full Test Run | QF‑Test Tutorial"},"49":{"id":49,"content":"Mobile Tutorial","hash":"home-link","h0":"A full Test Run | QF‑Test Tutorial"},"50":{"id":50,"content":"A full Test Run After we have worked through the test set step by step, let's execute everything in one go. Select the Test set \"Simple Tests\". Execute it with the replay button . The test run ends with the well-known error. Now please open the run log via to see how QF‑Test executed the test.","hash":"tut_firstFullRunAndroid","h0":"A full Test Run"},"51":{"id":51,"content":"Figure 1.16: The run log of the complete test set You can see that the Setup and Cleanup nodes are executed before and after each test case. This is a special behavior of Setup/Cleanup nodes within a test set and helps achieving a proper starting state for each test case. Stopping the SUT after each test case is not the smartest way to ensure a clean state. More elegant ways to establish a defined test starting situation and to perform cleanup will be explained in the advanced features chapter of this tutorial (\"Dependencies: Automatically ensuring correct prerequisites for each Test case\").","hash":"fig_androidRunlogFull","h4":"Figure 1.16: The run log of the complete test set"},"52":{"id":52,"content":"Mobile Tutorial","hash":"","h0":"Report Generation | QF‑Test Tutorial"},"53":{"id":53,"content":"Mobile Tutorial","hash":"home-link","h0":"Report Generation | QF‑Test Tutorial"},"54":{"id":54,"content":"Report Generation In the world of quality assurance documenting test results is important. To this end, QF‑Test offers an automated report-generation feature. Since you've just done a test run, we're at a good point to show you this feature. Please open the run log and select »File«-»Create report...«.","hash":"tut_firstreportandroid","h0":"Report Generation"},"55":{"id":55,"content":"Figure 1.17: Report Generation properties In the first field, you can specify the file name of the report. Following this, you can decide what type of report you want. QF‑Test offers three kinds of reports, HTML, XML and JUnit format. An XML report is useful if you want to process the data further, e.g., if you have written your own XSLT stylesheets to shape the report. JUnit reports prove useful when you need to import results into build or test management tools. Let's generate an HTML report from the results of the last test run. Just leave the report options unchanged. Start generation by pressing the OK button. The report will then be generated and presented to you in a browser window:","hash":"fig_AndroidReportDialog","h4":"Figure 1.17: Report Generation properties"},"56":{"id":56,"content":"Figure 1.18: An HTML Report The report begins with a summary containing informational data from your system on the top left side, a legend describing the meaning of icons used in the report on the top right side, an overview pie chart in the middle and the overall test result below. In our case, one error-free test case and the second with the well-known error, leading to a success rate of 50%. Following the summary there are three overview sections: Test suites that have been executed within the test run. Test suites in which errors occurred. Errors including their exact position and detailed message. The report generator is very useful for creating an overview document for presentation and archiving purposes.","hash":"fig_androidReportHtml","h4":"Figure 1.18: An HTML Report"},"57":{"id":57,"content":"Mobile Tutorial","hash":"","h0":"Creating your own test suite (Mobile) | QF‑Test Tutorial"},"58":{"id":58,"content":"Mobile Tutorial","hash":"home-link","h0":"Creating your own test suite (Mobile) | QF‑Test Tutorial"},"59":{"id":59,"content":"Creating your own test suite (Mobile) In this chapter of the mobile tutorial we will create sequences to start and stop the SUT, record actions and checks, and build a simple test case from them.","hash":"sec_mobiletestsuite","h1":"Creating your own test suite (Mobile)"},"60":{"id":60,"content":"Mobile Tutorial","hash":"","h0":"Starting the Application | QF‑Test Tutorial"},"61":{"id":61,"content":"Mobile Tutorial","hash":"home-link","h0":"Starting the Application | QF‑Test Tutorial"},"62":{"id":62,"content":"Starting the Application To begin, the application under test should be started from within QF‑Test. The Quickstart Wizard helps generate a suitable start sequence. Please open a new, empty test suite via »File«-»New test suite...«. Open the Quickstart Wizard via the menu »Extras«-»Quickstart Wizard...« .","hash":"tut_quickStartMobile","h0":"Starting the Application"},"63":{"id":63,"content":"Figure 2.1: Selecting the SUT type In the first step choose whether it is an Android application or an iOS application. Select Android application or iOS application. Press Next. If you select iOS application, follow the specific steps to select the device and the app to test. You can find the Carconfig app (CarConfig-iOS-Simulator.zip) under ../qftest-10.0.2-mobile/demo/ios/ in your QF‑Test installation. If you select an Android application, an additional page lets you decide whether an emulator should be started or whether a real device or a running emulator should be used. Choose between Start emulator or Connect to running emulator/real device. Then select the desired device name from the list of available devices.","hash":"fig_WizardTypeAndroid","h4":"Figure 2.1: Selecting the SUT type"},"64":{"id":64,"content":"Then select the desired device name from the list of available devices. Figure 2.2: Select device and app for Android When selecting the Android APK note that it is not shipped with QF‑Test by default. If you ran the carconfigAndroid demo, the app should have been downloaded to ${qftest:dir.user}/android, so you can directly enter ${qftest:dir.user}/android/CarConfigurator.apk. Alternatively you can download the APK from https://www.qftest.com/fileadmin/Webdata/pub/android/CarConfigurator.apk","hash":"fig_WizardChooseDeviceAndroid","h4":"Figure 2.1: Selecting the SUT type"},"65":{"id":65,"content":"Figure 2.3: Select device and app for Android Please press Finish to complete the wizard. The generated start sequence appears under the Extras section of the test suite and contains all steps necessary to start the app on the selected device.","hash":"fig_WizardAndroidDemo","h4":"Figure 2.3: Select device and app for Android"},"66":{"id":66,"content":"Figure 2.4: Generated start sequence Let's try it out: Make sure the node Setup: Start CarConfigurator is selected. Press or simply hit the Enter key. The selected app should now be installed and started on the device or emulator. Save the test suite ( or »File«-»Save« or Ctrl⁠+⁠S). Enter a name, e.g. FirstAndroidTests.qft.","hash":"fig_WizardFinalAndroid","h4":"Figure 2.4: Generated start sequence"},"67":{"id":67,"content":"Mobile Tutorial","hash":"","h0":"Recording Actions | QF‑Test Tutorial"},"68":{"id":68,"content":"Mobile Tutorial","hash":"home-link","h0":"Recording Actions | QF‑Test Tutorial"},"69":{"id":69,"content":"Recording Actions For mobile applications a special recording window is available mirroring the screen of the real device or emulator. This window is necessary because actions cannot be recorded directly on the device or emulator. All interactions are carried out via this recording window and recorded accordingly.","hash":"tut_recActionsMobile","h0":"Recording Actions"},"70":{"id":70,"content":"Figure 2.5: The recording window for Android applications Press the Record button in the recording window. Wait until the recording window opens. In the recording window, click the username text field and type \"tester\". Then click the password text field and type \"tester\". Stop recording via . The recorded sequence appears under the Extras section.","hash":"fig_MobileAppWinRec","h4":"Figure 2.5: The recording window for Android applications"},"71":{"id":71,"content":"The recorded sequence appears under the Extras section. Figure 2.6: By default, the sequence name contains the date and time of creation. This can be adjusted in the details on the right. Rename the sequence, e.g. to Perform login. We can insert the recorded actions at the end of our setup sequence. To keep complexity low for now, insert them inside a Try node. This ensures that no error is raised if we are already logged in.","hash":"fig_FirstRecordedLoginSequenceAndroid","h4":"Figure 2.5: The recording window for Android applications"},"72":{"id":72,"content":"We can insert the recorded actions at the end of our setup sequence. To keep complexity low for now, insert them inside a Try node. This ensures that no error is raised if we are already logged in. Figure 2.7: Next we want to record a series of actions: Press the Record button. With the mouse, select the model Rolo in the table. Switch to the Specials tab. Select the special model Jazz. Confirm your selection with OK. Finally click the first tab Vehicles again. Stop recording by switching back to the QF‑Test window and pressing the button there. Again, you will find the recorded sequence under the Extras section, as shown in the following image.","hash":"fig_FirstRecordedLoginSequenceRenamedAndroid","h4":"Figure 2.5: The recording window for Android applications"},"73":{"id":73,"content":"Figure 2.8: The tree after recording the sequence Change the sequence name to \"Select model Rolo Jazz\". Open the sequence to see its contained nodes. These should be the expected mouse clicks. You should even be able to identify the targeted components.","hash":"fig_FirstRecordedSequenceAndroid","h4":"Figure 2.8: The tree after recording the sequence"},"74":{"id":74,"content":"Figure 2.9: The renamed sequence We now want to replay the recorded sequence. Select the sequence Select model Rolo Jazz. Press Play. You should see exactly the same actions you recorded before. You should be able to replay the recorded flow repeatedly without errors. In the status line at the bottom right of the test suite window you should see \"Finished: No errors\".","hash":"fig_FirstRecordedSequenceRenamedAndroid","h4":"Figure 2.9: The renamed sequence"},"75":{"id":75,"content":"Mobile Tutorial","hash":"","h0":"Recording Checks | QF‑Test Tutorial"},"76":{"id":76,"content":"Mobile Tutorial","hash":"home-link","h0":"Recording Checks | QF‑Test Tutorial"},"77":{"id":77,"content":"Recording Checks Checks are also carried out in the recording window. In this way you can verify, for example, the text of an element or its visibility. In the recording window press the Record Check button. In the recording window select the text field for the total costs. Open the context menu (usually via right-click) and choose Text. Stop recording with . Rename the sequence, e.g. to Check price. Open the node to see the check.","hash":"tut_recChecksMobile","h0":"Recording Checks"},"78":{"id":78,"content":"Mobile Tutorial","hash":"","h0":"Setting up a test suite | QF‑Test Tutorial"},"79":{"id":79,"content":"Mobile Tutorial","hash":"home-link","h0":"Setting up a test suite | QF‑Test Tutorial"},"80":{"id":80,"content":"Setting up a test suite The base structure beneath the root node of a test suite is defined by the following nodes: An arbitrary number of Test set and Test case nodes to specify and structure functional tests. Procedures – reusable sequences organized into procedures. Extras – our playground for recordings, etc. Windows and components – the heart of the test suite. It contains all recorded windows and components of the SUT along with their properties. Functional test cases are represented by Test case nodes and grouped or structured via Test set nodes. Setup and Cleanup nodes can contain actions to ensure a well-defined state before and after a test case. We start by renaming the Test set node from \"unnamed\" to \"Demo Tests\". If a dialog appears about updating references, simply answer it with \"Yes\". Next, move the Setup node generated by the Quickstart Wizard into the Test set node, at the first position before the contained test case. You can move nodes via drag and drop, the context menu (right-click Cut/Paste) or the keyboard shortcuts Ctrl⁠+⁠X and Ctrl⁠+⁠V.","hash":"tut_buildtestandroid","h0":"Setting up a test suite"},"81":{"id":81,"content":"Figure 2.10: Beginning the structuring Next we want to turn the two previously recorded sequences into a test case. Rename the Test case node from \"unnamed\" to \"First\". Open the Test case node by clicking the \">\" symbol. Move the two sequences from the Extras section into the test case. If you do not open the Test case node, QF‑Test will try to insert the sequence nodes after the Test case node at the same level. However, this is not permitted for sequence nodes. QF‑Test always records sequences. These serve the same purpose as test steps. Test steps, however, are listed in the report. You can convert between them, which we will demonstrate for information in the following steps. Open the context menu for the first of the two sequence nodes with the right mouse button. Choose »Convert node to...«-»Test step«. Do the same for the second sequence node.","hash":"fig_beginbuildatest_mobile","h4":"Figure 2.10: Beginning the structuring"},"82":{"id":82,"content":"Figure 2.11: The tree after restructuring On Android and iOS the shutdown of the emulator/simulator cannot be recorded. Instead, use a Stop program node.","hash":"fig_buildatest_mobile","h4":"Figure 2.11: The tree after restructuring"},"83":{"id":83,"content":"On Android and iOS the shutdown of the emulator/simulator cannot be recorded. Instead, use a Stop program node. Figure 2.12: Simple cleanup sequence for Mobile With that we have completed the most important steps to structure our test suite.","hash":"fig_FirstCleanupAndroid","h4":"Figure 2.11: The tree after restructuring"},"84":{"id":84,"content":"Mobile Tutorial","hash":"","h0":"Create a procedure (Mobile) | QF‑Test Tutorial"},"85":{"id":85,"content":"Mobile Tutorial","hash":"home-link","h0":"Create a procedure (Mobile) | QF‑Test Tutorial"},"86":{"id":86,"content":"Create a procedure (Mobile) In the two previous chapters you learned how to start an application via QF‑Test so that mouse and keyboard input can be recorded, how to record checks and how to consolidate the result into a test case. This approach is sufficient as long as the tests are simple and not too many. However, as the number of tests grows, it becomes important to employ so-called \"procedures\". Procedures are a means to make sequences reusable and thus avoid duplication. This is essential to achieve simple and efficient maintainability of tests over time. Procedures can be grouped into packages . Procedures and packages are the basis for the modularization of tests.","hash":"sec_FirstProzedurMobile","h1":"Create a procedure (Mobile)"},"87":{"id":87,"content":"Mobile Tutorial","hash":"","h0":"Identify reusable parts | QF‑Test Tutorial"},"88":{"id":88,"content":"Mobile Tutorial","hash":"home-link","h0":"Identify reusable parts | QF‑Test Tutorial"},"89":{"id":89,"content":"Identify reusable parts In this section we will further develop the test suite FirstAndroidTests.qft, which you already know from chapter 19. Copy FirstAndroidTests.qft from the subdirectory qftest-10.0.2-mobile/doc/tutorial of the QF‑Test installation into a working directory and open FirstAndroidTests.qft. If you want to save the changes we will make to the demo test suite, then save it to a working directory as described at the end of \"Starting the Application\". Please take a look at the \"Reset\" test step in both test cases. The two test steps are identical.","hash":"tut_procreusemobile","h0":"Identify reusable parts"},"90":{"id":90,"content":"Figure 3.1: Two identical test steps According to the considerations above it makes sense to convert the test step into a procedure.","hash":"IdenticalTeststepsAndroid","h4":"Figure 3.1: Two identical test steps"},"91":{"id":91,"content":"Mobile Tutorial","hash":"","h0":"Manual creation of procedures | QF‑Test Tutorial"},"92":{"id":92,"content":"Mobile Tutorial","hash":"home-link","h0":"Manual creation of procedures | QF‑Test Tutorial"},"93":{"id":93,"content":"Manual creation of procedures There are several ways to create procedures and insert procedure calls. We start with the manual approach where an (empty) Procedure node is inserted, and then the corresponding actions are moved into it. Then we will create the corresponding procedure call. It is good to know these basic steps. However, there is a second, more elegant way to create procedures, which we will show afterwards. So let's insert a procedure by hand: We begin by creating the Procedure node and giving it a suitable name. Open the Procedure node and make sure it is selected (highlighted in blue). Choose »Insert«-»Procedure node«-»Procedure«. Enter \"reset\" as the name. The other fields do not need to be filled in. Press OK to complete creation of the procedure. Open the newly created \"reset\" procedure.","hash":"tut_procmanualmobile","h0":"Manual creation of procedures"},"94":{"id":94,"content":"Figure 3.2: Create procedure node In the second step we fill the procedure with the corresponding reusable actions. Select the three \"Mouse click\" nodes in the test step. To select more than one node, click the first node, then press the Shift key and click the last of the nodes to be selected while keeping the Shift key pressed. Move them down into the procedure, e.g. with the mouse (drag and drop) or via cut/paste in the »Edit« menu or via the context menu.","hash":"ProcedureNodeInFirstTestcaseAndroid","h4":"Figure 3.2: Create procedure node"},"95":{"id":95,"content":"Figure 3.3: Fill procedure with content In the third step we insert a procedure call in place of the three moved mouse clicks. Select the \"Reset\" test step, which should be open. Choose the menu »Insert«-»Procedure node«-»Procedure call« or use the keyboard shortcut Ctrl⁠+⁠A.","hash":"procedureContentInFirstTestcaseAndroid","h4":"Figure 3.3: Fill procedure with content"},"96":{"id":96,"content":"Figure 3.4: Insert procedure call Press the procedure selection button in the dialog to the left of the label \"Name of the procedure\". Select \"reset\" from the procedure list. No further input is necessary. Press OK in both dialogs to complete creation of the procedure call.","hash":"AddProcedureCallAndroid","h4":"Figure 3.4: Insert procedure call"},"97":{"id":97,"content":"Figure 3.5: Select procedure To really gain value from the procedure, we now need to replace the content of the test step in the second test case with a call to the \"reset\" procedure as well. You can do this as described above or perform the following alternative steps to create the procedure call: Open the 'Reset' test step of the second test case. Delete the three mouse click nodes from it. Select the \"reset\" procedure node. Drag the \"reset\" procedure node with the mouse into the test step node. Copy/paste can also be used. This does not move the Procedure node but creates a corresponding procedure call. The test suite should then look as follows:","hash":"SelectProcedureAndroid","h4":"Figure 3.5: Select procedure"},"98":{"id":98,"content":"Figure 3.6: Test suite with procedure If you now run the test cases, they should work as before. In the log you can now also see the procedure calls and their execution.","hash":"fig_testsuite_with_Procedure_android","h4":"Figure 3.6: Test suite with procedure"},"99":{"id":99,"content":"Mobile Tutorial","hash":"","h0":"Convert node to procedure | QF‑Test Tutorial"},"100":{"id":100,"content":"Mobile Tutorial","hash":"home-link","h0":"Convert node to procedure | QF‑Test Tutorial"},"101":{"id":101,"content":"Convert node to procedure As mentioned at the beginning of the last section, QF‑Test offers an alternative to create procedures much faster. Mark the Test step or Sequence node that contains the reusable steps that should be transformed into a procedure. Choose the menu »Operations«-»Convert node to«-»Procedure« or use the keyboard shortcut Ctrl⁠+⁠Shift⁠+⁠P. As you can see, the Test step or the Sequence node has disappeared. In its place there is a Procedure call node. In addition, a procedure with the name of the former test step or sequence has been created in the Procedures section. It contains exactly the same child nodes as the test step or sequence did before. When recording a sequence in QF‑Test it has proven useful to give the sequence a name immediately and then convert it into a procedure, even if you only suspect that the recorded steps might be repeated somewhere.","hash":"tut_proctransformmobile","h0":"Convert node to procedure"},"102":{"id":102,"content":"Mobile Tutorial","hash":"","h0":"Components (Mobile) | QF‑Test Tutorial"},"103":{"id":103,"content":"Mobile Tutorial","hash":"home-link","h0":"Components (Mobile) | QF‑Test Tutorial"},"104":{"id":104,"content":"Components (Mobile) QF‑Test stores the information needed to find components displayed in the GUI of the SUT in the Windows and components area. During recording QF‑Test analyzes the information obtained about GUI elements and stores those with which the user interacted in the details of Component nodes. Detailed information about components can be found in the manual chapter Components. In this chapter we will show how to address subitems of components like tables and lists.","hash":"sec_ComplexComponentsMobile","h1":"Components (Mobile)"},"105":{"id":105,"content":"Mobile Tutorial","hash":"","h0":"Addressing subitems of tables and lists | QF‑Test Tutorial"},"106":{"id":106,"content":"Mobile Tutorial","hash":"home-link","h0":"Addressing subitems of tables and lists | QF‑Test Tutorial"},"107":{"id":107,"content":"Addressing subitems of tables and lists Subitems of tables and lists are addressed via indices. The two most important index types are the numerical index and the text index. To demonstrate this, we will now record a mouse click on a list item and take a closer look at the recorded QF‑Test component ID. Start the CarConfig demo if it is not already running. Execute the Setup node in the test suite to do so. Activate recording mode via “Start recording” . Click a list item, e.g. the first model. Stop recording via “Stop recording” . You will find the recorded mouse click in the Extras section.","hash":"sec_addressing_complex_components_mobile","h0":"Addressing subitems of tables and lists"},"108":{"id":108,"content":"Figure 4.1: Addressing a list item The recorded QF‑Test component ID is action_bar_root.list@Rolo. It consists of the following parts: action_bar_root.list is the QF‑Test ID of the list component itself. @ separates the index from the QF‑Test component ID, defining the type of the index as a text index. Rolo is the text index for the list item with the text “Rolo”. Alternatively you can use & to specify a numerical index. Thus, &0 would specify the first list item. Numerical indices always start at 0. Tables are addressed analogously to lists, but they have an additional index to address the column. VehicleTable@Modell&0 addresses in table VehicleTable the column via the text index Modell and the row via the numerical index 0. This is just an example and cannot be tried out in the Android demo because there is no table in the app.","hash":"fig_ComponentsListIndexMobile","h4":"Figure 4.1: Addressing a list item"},"109":{"id":109,"content":"Mobile Tutorial","hash":"","h0":"SmartIDs – direct component addressing | QF‑Test Tutorial"},"110":{"id":110,"content":"Mobile Tutorial","hash":"home-link","h0":"SmartIDs – direct component addressing | QF‑Test Tutorial"},"111":{"id":111,"content":"SmartIDs – direct component addressing Since QF‑Test 7.0, SmartIDs officially offer the possibility to reference components without recording a Component node. For certain applications this can greatly simplify the management and maintenance of component information. SmartIDs can also have a positive impact on the editability and readability of tests. Last but not least, this enables creating tests even without the recording function, for example when a component or the entire application does not yet exist and you want to implement the test already (“Test first” approach). As recognition criteria, the component class, its name or label, and the index are available. The values are the same as for the recorded Component node. Component hierarchies can also be represented. A SmartID is used instead of the QF‑Test component ID. Its marker is the hash # as the first character. This is followed by the name or label of the component, for example: Details and examples can be found in the manual chapter SmartID.","hash":"sec_components_smartid_android","h0":"SmartIDs – direct component addressing"},"112":{"id":112,"content":"Mobile Tutorial","hash":"","h0":"Using the Debugger (Mobile) | QF‑Test Tutorial"},"113":{"id":113,"content":"Mobile Tutorial","hash":"home-link","h0":"Using the Debugger (Mobile) | QF‑Test Tutorial"},"114":{"id":114,"content":"Using the Debugger (Mobile) This chapter is also available as a video at 'Using the Debugger'. In this chapter you will learn how to use the intuitive debugger integrated into QF‑Test. Those of you already familiar with other IDEs like Eclipse will notice similarities in the functionality and usefulness of the debugger. We will cover the following debugger features: Setting a Breakpoint via Ctrl⁠+⁠F8 (on macOS: ⇧⁠+⁠⌘⁠+⁠B). Pausing test execution via the Pause button or the keyboard shortcut to interrupt test execution (\"Don’t Panic\" key) Alt⁠+⁠F12. Stepping through Execution via \"Step in\" , \"Step over\" and \"Step out\" . Skipping nodes via \"Skip over\" and \"Skip out\" . Activating debugger mode on error or exception. Resolving problems from the run log. Jump directly to the current error in the run log via Ctrl⁠+⁠J. (Jump to run log in chapter \"Resolving problems from the run log\"). Instead of using the buttons you can also trigger commands via the menu bar or keyboard shortcuts. Shortcuts are listed in the QF‑Test menus where applicable. A complete overview of keyboard shortcuts used by QF‑Test can be found in the appendix Keyboard shortcuts of the manual. There you will also find a small helper for the function key layout of QF‑Test to attach to your keyboard. There are additional debugger features such as \"Locate current node\" (Locate current node in \"Advanced Debugging Using the \"Variable bindings\" Table\"), \"Continue execution from here\" via the popup menu of the respective node (\"Continue execution from here\"), \"Rethrow exception\" , the table of variable definitions (\"Advanced Debugging Using the \"Variable bindings\" Table\"), which we will discuss in later chapters.","hash":"sec_DebuggerAndroid","h1":"Using the Debugger (Mobile)"},"115":{"id":115,"content":"Mobile Tutorial","hash":"","h0":"Setting a Breakpoint | QF‑Test Tutorial"},"116":{"id":116,"content":"Mobile Tutorial","hash":"home-link","h0":"Setting a Breakpoint | QF‑Test Tutorial"},"117":{"id":117,"content":"Setting a Breakpoint First we want to activate the debugger. This can be done in several ways, for example by setting a breakpoint before starting the test run. The purpose of a breakpoint is to interrupt the test run at a position you want to examine more closely. As soon as QF‑Test hits the breakpoint, test execution is paused and the debugger mode is activated. The Pause button is now pressed. Select a node and press Ctrl⁠+⁠F8 (on macOS: ⇧⁠+⁠⌘⁠+⁠B). The breakpoint is indicated by the icon .","hash":"tut_breakpointsmobile","h0":"Setting a Breakpoint"},"118":{"id":118,"content":"Figure 5.1: Setting a breakpoint Select the Test suite node and start the test run via the key Enter.","hash":"fig_DebugSetBreakpointAndroid","h4":"Figure 5.1: Setting a breakpoint"},"119":{"id":119,"content":"Figure 5.2: Starting the test run Remove the breakpoint by pressing Ctrl⁠+⁠F8 (on macOS: ⇧⁠+⁠⌘⁠+⁠B) again.","hash":"fig_DebugStartTestRunAndroid","h4":"Figure 5.2: Starting the test run"},"120":{"id":120,"content":"Figure 5.3: Removing a breakpoint You can set or remove a breakpoint not only via the shortcut Ctrl⁠+⁠F8, but also via the menu »Debugger«-»Breakpoint on/off« or alternatively by right-clicking the node and selecting »Breakpoint on/off« in the popup menu. For the other debugger functions we will mainly refer to the respective buttons, but the other options are available as well. Again you will see the small arrow, this time indicating which node will be executed next. This node is called the current node. When the debugger mode is activated, QF‑Test navigates to the current node if it is not already visible and selects it, i.e. the row is highlighted in blue. The command »Debugger«-»Remove all breakpoints« is also useful if you want to remove all breakpoints in all open test suites. There is no limit to the number of breakpoints you can set in your test suite. Breakpoints are not saved when the test suite is closed.","hash":"fig_DebugRemoveBreakpointAndroid","h4":"Figure 5.3: Removing a breakpoint"},"121":{"id":121,"content":"Mobile Tutorial","hash":"","h0":"Stepping through Execution | QF‑Test Tutorial"},"122":{"id":122,"content":"Mobile Tutorial","hash":"home-link","h0":"Stepping through Execution | QF‑Test Tutorial"},"123":{"id":123,"content":"Stepping through Execution Now we want to execute the test cases step by step. Please experiment a bit with \"Step in\" , \"Step over\" and \"Step out\" . As you will have noticed, \"Step in\" opens a node with children and makes the first child node the active node. This is, as always, indicated by the arrow marker on the node. If you continue from the point where execution of the test suite was paused in the last section, i.e. from the node \"Test case: First\", the test case would now be opened:","hash":"tut_debug_steps_mobile","h0":"Stepping through Execution"},"124":{"id":124,"content":"Figure 5.4: Step in In the case of a leaf node, i.e. a node that has no children, the effect is the same as the following function. With the button \"Step over\" a node including all its child nodes is executed. The next node to be executed at the same level then becomes the active one and gets the arrow.","hash":"fig_StepInExampleAndroid","h4":"Figure 5.4: Step in"},"125":{"id":125,"content":"Figure 5.5: Step over \"Step out\" executes the remaining sibling nodes and stops at the next node to be executed on the parent hierarchy level.","hash":"fig_StepOverExampleAndroid","h4":"Figure 5.5: Step over"},"126":{"id":126,"content":"Figure 5.6: Step out In the example this is the Cleanup node. As already explained in the first chapter A full Test Run, Setup and Cleanup nodes have the special property of being executed before and after each test case to establish a defined starting state for every test case. This behavior only occurs if you started the complete test suite or the test set and are in debugger mode. If no test execution was active and you had only selected the test case, the \"Step over\" function causes the test case to be executed and then the next test case to be selected. Execute the Cleanup and Setup nodes by using to execute the entire nodes and then to open the second test case. This is preparation for the next chapter about skipping nodes. Please note during interactive test creation with menus and comboboxes that these often collapse when the application loses focus, which is the case when switching to debugger mode. In such cases it is advisable to execute the node that opens a menu or combobox together with the node that performs the selection, i.e. do not switch to debugger mode in between. For example, you can achieve this by setting a breakpoint after the node that performs the selection and, when reaching the node that opens the menu or combobox, resume test execution by releasing the Pause button .","hash":"fig_StepOutExampleAndroid","h4":"Figure 5.6: Step out"},"127":{"id":127,"content":"Mobile Tutorial","hash":"","h0":"Skipping nodes | QF‑Test Tutorial"},"128":{"id":128,"content":"Mobile Tutorial","hash":"home-link","h0":"Skipping nodes | QF‑Test Tutorial"},"129":{"id":129,"content":"Skipping nodes The \"Skip\" functions extend the capabilities of QF‑Test’s debugger in a way that goes beyond the functionality of standard programming environments. As the name suggests, the \"Skip\" operations allow skipping one or more nodes during the test run, i.e. jumping ahead without executing them. This can be useful for various reasons, e.g. to quickly reach a certain position in your test flow or to skip a node currently causing an error. At the end of the last section we made the first test step in the second test case the active node. This is the starting point for our next action:","hash":"tut_skip_steps_mobile","h0":"Skipping nodes"},"130":{"id":130,"content":"Figure 5.7: Execution paused at the first node of the second test case Now press the \"Skip over\" button . QF‑Test simply skips the active node without executing it or its child nodes. It then pauses at the next node to be executed on the same level.","hash":"fig_DebugSkipOverInitialStateAndroid","h4":"Figure 5.7: Execution paused at the first node of the second test case"},"131":{"id":131,"content":"Figure 5.8: \"Skip over\" And finally the \"Skip out\" button . You immediately see that QF‑Test skips out of the current node without executing further child nodes.","hash":"fig_DebugSkipOverAndroid","h4":"Figure 5.8: \"Skip over\""},"132":{"id":132,"content":"Figure 5.9: \"Skip out\" One remark about \"Skip over\" and \"Skip out\": Use these with care! Skipping out of a sequence before it has finished can leave your SUT in a state that other sequences or tests in the suite cannot build upon.","hash":"fig_DebugSkipOutAndroid","h4":"Figure 5.9: \"Skip out\""},"133":{"id":133,"content":"Mobile Tutorial","hash":"","h0":"Activating debugger mode on error or exception | QF‑Test Tutorial"},"134":{"id":134,"content":"Mobile Tutorial","hash":"home-link","h0":"Activating debugger mode on error or exception | QF‑Test Tutorial"},"135":{"id":135,"content":"Activating debugger mode on error or exception When debugging a test it is often helpful if test execution stops and switches to debugger mode exactly when an error, an exception or sometimes even just a warning occurs. Using this technique we will debug the second test case in this section and the next. Please open the Debugger menu and change the default settings as follows: Click the menu item »Debugger«-»Debugger enabled« to enable it. Click the submenu item »Debugger«-»Options«-»Break on error« to enable this function as well. If you now open the Debugger menu and the Options submenu again, it should look like this:","hash":"tut_debug_start_mobile","h0":"Activating debugger mode on error or exception"},"136":{"id":136,"content":"Figure 5.10: Debugger options: stop test on error We have to change the debugger options because otherwise the test would just run through, analogous to the previous examples from chapters one and two. Select the Test suite node and then start the test via \"Start test run\" . QF‑Test stops at the erroneous node and switches to debugger mode:","hash":"fig_debugger_stops_at_error_mobile","h4":"Figure 5.10: Debugger options: stop test on error"},"137":{"id":137,"content":"Figure 5.11: QF‑Test pauses on error The node that caused the error is marked by a red square. In addition, an error dialog appears that provides details about the cause of the error. From there we switch to the run log which, as so often, is the key to fixing the problem.","hash":"fig_debugger_stopped_by_error_mobile","h4":"Figure 5.11: QF‑Test pauses on error"},"138":{"id":138,"content":"Figure 5.12: Error message Click the Jump to run log button in the error message.","hash":"debug_error_dialog_mobile","h4":"Figure 5.12: Error message"},"139":{"id":139,"content":"Mobile Tutorial","hash":"","h0":"Resolving problems from the run log | QF‑Test Tutorial"},"140":{"id":140,"content":"Mobile Tutorial","hash":"home-link","h0":"Resolving problems from the run log | QF‑Test Tutorial"},"141":{"id":141,"content":"Resolving problems from the run log Via the Jump to run log button (see error message in figure \"Error message\") the run log opens directly at the corresponding node. In addition to the actual error message, various other information about the test environment at the time of the error has been logged. Besides screenshots taken at the time of the error, the run log under the node that caused the error contains a list of bound variables (stacktrace). We will return to the usefulness of the stacktrace later (The \"Variable Bindings\" Table). In the present case the wrong value is expected in the Check text node of the test suite. To fix the error this must be replaced by the value actually shown. For a Check with a fixed value, which is the case here, the easiest way is to right-click the error node with the red border \"Failed: Check text: default …\" and select »Update Check node with received data« in the context menu.","hash":"tut_ResolveRunTimeErrorsAndroid","h0":"Resolving problems from the run log"},"142":{"id":142,"content":"Figure 5.13: Update Check node with received data QF‑Test navigates to the affected Check text node in the test suite and updates the value of the attribute Text based on the data read from the SUT.","hash":"fig_DebugUpdateCheckNodeAndroid","h4":"Figure 5.13: Update Check node with received data"},"143":{"id":143,"content":"Figure 5.14: Corrected Check node The node now contains the correct value, but it is still marked with a red border because it has not been executed again yet. We will do that now. Continue the test by pressing the Pause button to release the pause. QF‑Test executes the rest of the test suite. In our case these are the Check text and the Cleanup nodes. Subsequently QF‑Test informs you that an error occurred. However, we already fixed this during the test run.","hash":"fig_DebugCorrectedCheckNodeAndroid","h4":"Figure 5.14: Corrected Check node"},"144":{"id":144,"content":"Jump to run log: If you want to open the run log exactly at the position where test execution is currently paused, simply click the menu item »Debugger«-»Jump to Run log« or press the shortcut Ctrl⁠+⁠J from debugger mode. If you just want to open the run log without jumping to the current position, use Ctrl⁠+⁠L, which also works after the test run has finished.","hash":"tut_JumpToRunLogAndroid tut_JumpToRunLogAndroid","h4":"Figure 5.14: Corrected Check node"},"145":{"id":145,"content":"Mobile Tutorial","hash":"","h0":"Pausing test execution | QF‑Test Tutorial"},"146":{"id":146,"content":"Mobile Tutorial","hash":"home-link","h0":"Pausing test execution | QF‑Test Tutorial"},"147":{"id":147,"content":"Pausing test execution If a test is currently running and you want to switch to debugger mode, you can either quickly set a breakpoint on a node that has not yet been executed, or simply press the \"Pause\" button to activate debugger mode immediately. To continue execution, release the Pause button , regardless of how debugger mode was activated. We want to continue using the existing test cases throughout this tutorial. However, the error in the second test case has now been fixed. Therefore it makes sense to remove \"(with error)\" from the name of the second test case, as well as \"(causes error)\" from the name of the test step. There are situations where the SUT constantly grabs the focus. In such cases it can be difficult to keep the QF‑Test window in the foreground long enough to press the Pause button. In this case you can use the \"Don’t Panic\" key Alt⁠+⁠F12. It immediately interrupts all running tests. To continue the test you can press this key combination again.","hash":"tut_pause_execution_mobile","h0":"Pausing test execution"},"148":{"id":148,"content":"Mobile Tutorial","hash":"","h0":"Variables and Procedure Parameters (Mobile) | QF‑Test Tutorial"},"149":{"id":149,"content":"Mobile Tutorial","hash":"home-link","h0":"Variables and Procedure Parameters (Mobile) | QF‑Test Tutorial"},"150":{"id":150,"content":"Variables and Procedure Parameters (Mobile) In this chapter you will learn how to use a procedure to execute the same steps with different data. You will also see how to use variables. Error analysis with respect to variables is covered as well. This chapter is also available as a video at 'Variables and Procedure Parameters'. In the video, a Java application is used for the explanations. For Android applications there are no differences regarding the use of variables.","hash":"sec_variablestackmobile","h1":"Variables and Procedure Parameters (Mobile)"},"151":{"id":151,"content":"Mobile Tutorial","hash":"","h0":"Procedure with a Variable | QF‑Test Tutorial"},"152":{"id":152,"content":"Mobile Tutorial","hash":"home-link","h0":"Procedure with a Variable | QF‑Test Tutorial"},"153":{"id":153,"content":"Procedure with a Variable Take a look at the last test step \"Check final price\" in our two test cases.","hash":"sec_ProcedureWithVariableAndroid","h0":"Procedure with a Variable"},"154":{"id":154,"content":"Figure 6.1: Two almost identical test steps The same step is executed, but with different data. Even if it is just a single step, it makes sense to turn it into a procedure. We might later decide to convert the hard-coded values 13.349,00 € and 12.734,00 € to another format so that the check on the \"Final price\" field works for other currencies as well. Implementing such logic twice would definitely not be sensible. Select the Check text node in the first test case. Choose the menu »Operations«-»Wrap node into«-»Sequence« or use the keyboard shortcut Ctrl⁠+⁠Shift⁠+⁠S to wrap it into a sequence. Name the sequence 'checkFinalPrice'. This name follows the Java convention of concatenating words. On the other hand, QF‑Test also allows spaces in procedure names, so you do not have to follow the Java convention. Press Ctrl⁠+⁠Shift⁠+⁠P to quickly convert the sequence node into a procedure (as known from the previous chapter). As you can see, the sequence is replaced by a procedure call to \"checkFinalPrice\". Double-click the procedure call to jump to the procedure in the Procedures node. Open the newly created procedure node to see its contents.","hash":"fig_params1Android","h4":"Figure 6.1: Two almost identical test steps"},"155":{"id":155,"content":"Figure 6.2: Procedure with hard-coded value As expected, the Check text node is inside the procedure. However, it is only valid for a single price, namely 13.349,00 €. Since we also want to use the same procedure for the second test case, we need to replace the price with a variable. The value of this variable should then be passed when calling the procedure. In the next example we will add a parameter with a default value in the procedure node. Default values are often used when the corresponding parameter would receive that value in most procedure calls. Then you don't need to specify the default value every time and can rely on the value defined in the procedure node. Although this does not apply to the price parameter, we can use it here to show how a default value works and how it can be overridden with another value when needed. First, let’s add a variable with a default value: Select the procedure 'checkFinalPrice'. Press the \"Insert row\" button above the \"Default values for parameters\" table. Enter price as the name of the parameter. Enter 13.349,00 € as the value. Press OK.","hash":"fig_procedure_hardcoded_mobile","h4":"Figure 6.2: Procedure with hard-coded value"},"156":{"id":156,"content":"Figure 6.3: Details of a procedure node In the next step, we replace the value of the Text attribute of the Check text node with a reference to the variable.","hash":"fig_parameter_default_values_table_mobile","h4":"Figure 6.3: Details of a procedure node"},"157":{"id":157,"content":"Variable syntax: When working with variables it is important to understand that in some places you tell QF‑Test what the name of a variable is and in others you tell QF‑Test to access the value of a variable. In the example above, QF‑Test is informed of the variable name in the name column of the default values table. In that case you only needed to enter price. In the Text attribute of the Check text node, the value of the variable should be used. In QF‑Test this is done by putting the variable name in $(), here $(preis). If you do not wrap the variable name in $(), QF‑Test would compare the price with the literal string price. Select the Check text node in the procedure \"checkFinalPrice\". Enter $(preis) in the Text attribute of the Check text node details. Press 'OK' in the node details.","hash":"tut_VariableSyntaxMobile","h4":"Figure 6.3: Details of a procedure node"},"158":{"id":158,"content":"Figure 6.4: 'Check text' node Execute the first test case. The test case should run without errors.","hash":"fig_ProcedureAddVariableAndroid","h4":"Figure 6.4: 'Check text' node"},"159":{"id":159,"content":"Mobile Tutorial","hash":"","h0":"The \"Variable Bindings\" Table | QF‑Test Tutorial"},"160":{"id":160,"content":"Mobile Tutorial","hash":"home-link","h0":"The \"Variable Bindings\" Table | QF‑Test Tutorial"},"161":{"id":161,"content":"The \"Variable Bindings\" Table In the next step we add a procedure call in the second test case. Replace the Check text node of the second test case with a procedure call to \"checkFinalPrice\". You can simply copy the procedure call from the first test case or insert it as described above.","hash":"tut_variable_stack_mobile","h0":"The \"Variable Bindings\" Table"},"162":{"id":162,"content":"Figure 6.5: Procedure call to \"checkFinalPrice\" in the second procedure If the procedure call already shows the price with its default value, this is because the procedure call was generated using the procedure itself, either by copying the procedure, via drag-and-drop using the procedure node, or by direct insertion of the procedure as explained further above. For the current topic we focus on the default value. Therefore, please delete any existing price parameter if you are following the tutorial step by step. To do so, click the red X above the \"Variable bindings\" table. Make sure the debugger is configured to break on errors (see Debugger options: stop test on error). Select the node \"Test case: Second\". Execute it either via the button or by pressing the Enter key. An error message indicates that a different price than the one displayed was expected. What went wrong? Let’s investigate the error. Usually we would look into the run log, but there is another important source of information. Click OK to close the error message. In debugging mode you can see a list of nodes with variables bound by them at the bottom right of the QF‑Test window. You may need to enlarge the \"Variable bindings\" table to see all entries.","hash":"fig_AddProcedureCallToSecondTestcaseAndroid","h4":"Figure 6.5: Procedure call to \"checkFinalPrice\" in the second procedure"},"163":{"id":163,"content":"Figure 6.6: Variable definitions The \"Variable bindings\" table is very helpful during debugging because it shows the current values of variables. It supports working with procedures and helps understand how QF‑Test determines the correct variable value. QF‑Test processes the \"Variable bindings\" table from top to bottom. You see that in the first lines no variables are bound. At the \"Global variables\" level one variable is bound, and on the secondary stack for \"Procedure: checkFinalPrice\" another one. The global variable is used for the connection to the SUT application and was set before application startup (cf. Starting and Connecting the Device). The other variable is of more interest right now — but it has the wrong value. This value on the secondary stack is the default value, which is used when no variable with the same name is assigned a value elsewhere. To fix this, we need to pass the correct value to the procedure in the procedure call. Again, there are several ways to do this. One way would be to add a new row in the \"Variable bindings\" table in the details of the procedure call, similar to how we did it in the procedure node in the previous section. If there are already multiple procedure calls, the following is simpler: Stop the running test execution via . Right-click the Procedure node and choose »More node operations«-»Adjust parameters of references« in the popup menu.","hash":"fig_VariableBindingsTable1Android","h4":"Figure 6.6: Variable definitions"},"164":{"id":164,"content":"Right-click the Procedure node and choose »More node operations«-»Adjust parameters of references« in the popup menu. Figure 6.7: Popup menu for \"Adjust parameters of references\" In the following dialog, ensure the checkbox »Add missing parameters at caller« is set, and confirm with OK. In the procedure call, QF‑Test creates a row in the \"Variable bindings\" table for each default value. In our case, a row has been added for the parameter named price with the value 13.349,00 €. Even so, it will still not work in the second test case, even though the value is passed directly, because it is still the default value which is not correct here. Please do not change the value yet, so we can use the resulting error to demonstrate another debugging method. Close the \"Adjusted nodes\" dialog that QF‑Test shows to inform you about completed nodes.","hash":"fig_CompleteParameters_mobile","h4":"Figure 6.6: Variable definitions"},"165":{"id":165,"content":"Mobile Tutorial","hash":"","h0":"Advanced Debugging Using the \"Variable bindings\" Table | QF‑Test Tutorial"},"166":{"id":166,"content":"Mobile Tutorial","hash":"home-link","h0":"Advanced Debugging Using the \"Variable bindings\" Table | QF‑Test Tutorial"},"167":{"id":167,"content":"Advanced Debugging Using the \"Variable bindings\" Table Next, we want to examine the\"Variable bindings\" table and find out how to use it for debugging. Therefore, please keep the incorrect value that was inserted in the procedure call in the previous section. We will interrupt the execution of the test case at the procedure call and then step into the procedure. While doing so, we will watch what happens in the \"Variable bindings\" table. Afterwards we will jump directly from the \"Variable bindings\" table to the faulty procedure call and correct the parameter value there. Set a breakpoint at \"Procedure call: checkFinalPrice\" in the second test case. Execute the second test case. When QF‑Test stops at the breakpoint, perform two step-ins into the procedure using and watch the \"Variable bindings\" table.","hash":"tut_variable_stack_debugging_mobile","h0":"Advanced Debugging Using the \"Variable bindings\" Table"},"168":{"id":168,"content":"Figure 6.8: Variable Definitions table shows the wrong value When you step into the procedure, the first step creates a row for \"Procedure call: checkFinalPrice\" at the top of the table, and the second step creates the row \"Procedure: checkFinalPrice\". Now the variable price appears at two different levels in the \"Variable bindings\" table: in the row for \"Procedure call: checkFinalPrice\" and in the row \"Procedure: checkFinalPrice\" on the secondary stack, neither of which has the correct value. In QF‑Test you can interactively change the values of variables in the \"Variable bindings\" table while in debugging mode. You can even add new variables or delete existing ones. You can work with them as long as they are on the variable stack, in our case as long as the procedure is being executed. Changing the current variable value in the \"Variable bindings\" table does not adjust the parameter value entered in the procedure call node. The value must be changed explicitly in the procedure call. The fastest way to get to the procedure call is to double-click the procedure call row (the second row) in the Variable Definitions table. This method is especially helpful when you are debugging large test suites and the node you want to jump to is not visible in the test suite window. Instead of a double-click you can also right-click the row and choose the menu item »Jump to node in test suite«. Double-click the second row with the procedure call in the \"Variable bindings\" table. Set the parameter to the correct value, i.e. 12.734,00 €. Conversely, the current value in the \"Variable bindings\" table is not changed by this. To achieve that, we need to execute the procedure call again. However, the test execution has already moved past this point. Here we want to demonstrate another useful function of the debugger that lets you instruct QF‑Test to change the next node to be executed. Select the corresponding node and choose the menu »Continue execution from here« or use the keyboard shortcut Ctrl⁠+⁠,. So, to try out the newly set value: Right-click the node \"Procedure call: checkFinalPrice\" in the second procedure. Select \"Continue execution from here\" in the popup menu.","hash":"fig_VariableStack3Android","h4":"Figure 6.8: Variable Definitions table shows the wrong value"},"169":{"id":169,"content":"Figure 6.9: Continue execution from here The two top rows in the \"Variable bindings\" table have disappeared. The reason is that you have left the procedure (albeit \"backwards\") and the procedure call with the variables bound to it has been taken off the call stack. Release the pause button . No error should appear now. Because the \"Variable bindings\" table is extremely helpful when hunting for incorrect variable values, a copy of it is also stored under the \"Stacktrace\" node in the run log, showing the variable values exactly at the time of the error.","hash":"fig_ProcedureContinueExecFromHereAndroid","h4":"Figure 6.9: Continue execution from here"},"170":{"id":170,"content":"Locate current node: Sometimes you drift quite far from the current node while debugging and then want to return to it. The easiest way is to press \"Locate current node\" in the toolbar or choose the menu »Debugger«-»Locate current node«.","hash":"locate_current_node_mobile locate_current_node_mobile","h4":"Figure 6.9: Continue execution from here"},"171":{"id":171,"content":"Mobile Tutorial","hash":"","h0":"Setting Variables | QF‑Test Tutorial"},"172":{"id":172,"content":"Mobile Tutorial","hash":"home-link","h0":"Setting Variables | QF‑Test Tutorial"},"173":{"id":173,"content":"Setting Variables In addition to the methods described above, variables can also be set as follows: Via a Set variable node, as a Procedure node's Return value, as the result of a QF‑Test node like Fetch text, Fetch geometry, Fetch index and Check, in the 'Variable bindings' table of Test suite, Test case, Test step, Sequence and other nodes like If or Loop, via command line parameters. Information about where a variable is best defined can be found in the next section. A Set variable node can be inserted via the menu »Insert«-»Misc nodes«-»Set variable«. In the node details you can specify whether it should be a local variable (tick the Local variable check box) or a global variable. The following figure shows the details of a Set variable node that you can find as the first node in the Setup node. A variable named client is defined. You can tell that it is a global variable because the Local variable check box is not set.","hash":"tut_setting_variables_mobile","h0":"Setting Variables"},"174":{"id":174,"content":"Figure 6.10: Details of the Set variable node If a variable should be set with the return value of a procedure, specify the variable name in the \"Variable for return value\" attribute of the procedure call. In the procedure itself you must insert a Return node as the last node to be executed to return the relevant value. The procedure in the following figure reads the discount value from the SUT and returns it to the calling test case. There, the receiving variable is named Rabatt and is declared as a local variable. This example is not included in the exercise test suite.","hash":"figtailsSetVariableAndroid","h4":"Figure 6.10: Details of the Set variable node"},"175":{"id":175,"content":"Figure 6.11: Procedure with return value The Fetch text node in the figure above is one of the QF‑Test nodes that directly set the value of a variable. The variable name is entered in the accordingly named attribute. Again, you can choose whether it should be a local or a global variable. There are a number of nodes that have a Variable definitions table. There, you can set local variables. If the respective node is inside a procedure, the variable is bound as a local variable to the procedure, otherwise as a local variable to the test case. Variables that are bound to the test suite node via this table can be referenced by all nodes in the test suite. All nodes to which variables can be bound are displayed in the \"Variable bindings\" panel at the bottom right in debugger mode, when they are currently being executed. Variables can also be specified via the command line. Use the command line parameter -variable, e.g. qftest -batch -variable \"browser\"=\"ie\" test.qft. For further information see the manual, chapter 'Command line arguments'.","hash":"fig_DetailsCallProcedureAndroid","h4":"Figure 6.11: Procedure with return value"},"176":{"id":176,"content":"Mobile Tutorial","hash":"","h0":"Levels for Variable Definitions | QF‑Test Tutorial"},"177":{"id":177,"content":"Mobile Tutorial","hash":"home-link","h0":"Levels for Variable Definitions | QF‑Test Tutorial"},"178":{"id":178,"content":"Levels for Variable Definitions This section answers the question of at which level a variable should be defined. If you are currently not interested, you can skip directly to the next chapter. Variables can be bound at different levels: In the test suite node, in test cases and procedures as default or local variables, as parameters in a procedure call, as global variables, and as command line parameters. The level at which a variable is best defined depends on the purpose of the variable: Procedure parameters Pass a value as a parameter to a procedure if the same procedure is to be executed more than once with different values. Procedure parameters are specified in the Variable definitions table of a Procedure call node. Local variables in a procedure Local variables are defined within the procedure and are valid only there. When the procedure finishes, they are deleted. Use a local variable if it is not needed outside the procedure. They are the tool of choice for intermediate results. Local variables in a test case In a test case, local variables can either be created during the execution of the test case or via the corresponding table in the details of the Test case node. If you use the same value multiple times within a test case, it makes sense to assign it to a variable once and then use the variable. This improves maintainability. Local variables should also be used for intermediate results. Global variables When global variables have been created, they exist until they are explicitly deleted or until QF‑Test is closed. They even survive stops and re-execution of tests. Use them for values that are needed in multiple test cases. An example is the variable client which is created in the Setup node when starting the application. To get rid of them, choose the menu »Playback«-»Clear global variables«. They are also cleared when QF‑Test terminates. Command line parameters Variables set via the command line are useful in batch mode when you want to perform multiple batch runs with different values. Command line parameters apply for the entire duration of the batch run. A typical example is variable-driven execution across different browsers. Variables can be specified via the command line parameter -variable (cf. chapter 'Command line arguments' in the manual). Test suite variables Test suite variables can be used by all test cases. Their purpose corresponds to that of global variables, except that in batch mode they can be overridden by variables on the command line. Default values (secondary stack) You can define default values for the variables of procedures, test cases and test case sets. These apply if no variable with the same name has been defined at a higher level.","hash":"tut_variable_levels_mobile","h0":"Levels for Variable Definitions"},"179":{"id":179,"content":"Mobile Tutorial","hash":"","h0":"The Standard Library (Mobile) | QF‑Test Tutorial"},"180":{"id":180,"content":"Mobile Tutorial","hash":"home-link","h0":"The Standard Library (Mobile) | QF‑Test Tutorial"},"181":{"id":181,"content":"The Standard Library (Mobile) This chapter is also available as a video at 'The Standard Library'. QF‑Test provides a certain number of node types that can be used for creating tests. If you need functionality that goes beyond that, you can implement it via script nodes. To make your work easier, many frequently required functions have already been implemented as procedures and are shipped with QF‑Test in a standard procedure library. So if you have a task that cannot be solved using the provided nodes, you should first explore the standard library to see whether you find a suitable or similar solution there. If you find a similar solution, simply copy the existing standard procedure and adapt it to your needs. For information about working with scripts, please see the manual, chapter 12 \"Scripting\". The library is contained in the file qfs.qft and is part of the QF‑Test distribution. Since it is further developed with every QF‑Test version, it is not advisable to modify the shipped standard library. Instead, copy a procedure to your own test suite and adjust it there if needed. In order to use the qfs.qft library, it must be included in the \"Test suite\" root node of your suite under \"Included files\". For new test suites this is done automatically. Select the 'Test suite' root node of your test suite. In the details of the 'Test suite' root node, check that qfs.qft is listed in the \"Included files\" attribute. Add qfs.qft to this list if it is not included yet. No path specification is necessary because the include directory of QF‑Test is automatically part of the library path (see also the reference section of the manual). In the following we describe a selection of the most commonly needed standard procedures. A complete HTML documentation of the standard library can be found via the menu item »Help«-»Standard library qfs.qft...«.","hash":"sec_StandardLibraryMobile","h1":"The Standard Library (Mobile)"},"182":{"id":182,"content":"Mobile Tutorial","hash":"","h0":"Exploring the Standard Library | QF‑Test Tutorial"},"183":{"id":183,"content":"Mobile Tutorial","hash":"home-link","h0":"Exploring the Standard Library | QF‑Test Tutorial"},"184":{"id":184,"content":"Exploring the Standard Library In addition to inserting procedure calls from the standard library, it is helpful to take a look at how functions are implemented and organized. Open the library itself, i.e. the suite qfs.qft, which is located in the directory qftest-10.0.2-mobile/include of your QF‑Test installation.","hash":"sec_StandardLibraryOverviewMobile","h0":"Exploring the Standard Library"},"185":{"id":185,"content":"Figure 7.1: The Standard Library You will see a main package qfs that encloses the specific packages. The qfs package helps to easily identify procedures as belonging to the standard library. In almost all procedures of our library you will notice the use of the variable $(client). This is a standard mechanism to keep test suites independent of a specific SUT. For using the standard library it is required that a valid value for $(client) is set before any of its procedures can be used.","hash":"fig_SuiteQfsQftMobile","h4":"Figure 7.1: The Standard Library"},"186":{"id":186,"content":"Mobile Tutorial","hash":"","h0":"Selected Packages and Procedures | QF‑Test Tutorial"},"187":{"id":187,"content":"Mobile Tutorial","hash":"home-link","h0":"Selected Packages and Procedures | QF‑Test Tutorial"},"188":{"id":188,"content":"Selected Packages and Procedures We now take a closer look at a few selected packages and procedures of the standard library.","hash":"sec_StandardLibraryPackagesMobile","h0":"Selected Packages and Procedures"},"189":{"id":189,"content":"The Android Package The package qfs.run-android contains procedures to execute various ADB commands or to interact with the device. Below is a selection of the available procedures within the package: appControl-resetCurrentApp Resets all data and permissions of the currently focused app and restarts it. dataTransfer-pull Transfers a file or folder from the Android device to the local system. dataTransfer-push Transfers a file or folder from the local system to the Android device. runAdbCommand Executes any ADB command. device-appSwitch Activates the app switch button on the device. device-back Activates the back button on the device. device-home Activates the home button on the device. device-closeKeyboard Closes a potentially open on-screen keyboard. device-setRotation Changes the device's screen orientation.","hash":"sec_the_android_package","h1":"The Android Package"},"190":{"id":190,"content":"The Utils Package The qfs.utils package contains useful procedures for frequently occurring requirements of test development. Here are some procedures of the package: getDate Returns a string that contains a date. By default, the current date is returned. (Other dates are configurable.) getTime Returns a string that contains a time. By default, the current time is returned. (Other times are configurable.) logMemory Writes the current memory usage to the log. printVariable Prints the content of a specified variable to the console. printMessage Prints the content of a specified message to the console. writeMessageIntoFile Writes a specified string into a specified file.","hash":"sec_the_utils_package","h1":"The Utils Package"},"191":{"id":191,"content":"The Check Package The qfs.check package contains procedures that perform checks. The most important procedures are: checkEnabledStatus Checks whether a component is enabled or disabled. In case of an error, the procedure writes a corresponding error to the log. checkSelectedStatus Checks whether a component is selected or not selected. In case of an error, the procedure writes a corresponding error to the log. checkText Checks the text of a component. In case of an error, the procedure writes a corresponding error to the log.","hash":"sec_the_check_package","h1":"The Check Package"},"192":{"id":192,"content":"The Databinder Package The qfs.databinder package contains procedures for execution within a Data driver node to bind data for data-driven testing. The most important procedures are: bindList Binds a list of values to a variable. The values are separated by whitespace or by the delimiter passed as a parameter. bindSets Binds sets of values to a set of variables. The sets of values are separated by line breaks, the values within a set by whitespace or by the delimiter passed as a parameter.","hash":"sec_the_databinder_package","h1":"The Databinder Package"},"193":{"id":193,"content":"Mobile Tutorial","hash":"","h0":"Control structures (Mobile) | QF‑Test Tutorial"},"194":{"id":194,"content":"Mobile Tutorial","hash":"home-link","h0":"Control structures (Mobile) | QF‑Test Tutorial"},"195":{"id":195,"content":"Control structures (Mobile) The two most important control structures of QF‑Test are loops and the conditional execution of nodes. Loops can be implemented by two different kinds of nodes: While and Loop nodes. If, Elseif and Else nodes are available to implement conditional execution. This chapter is also available as a video tutorial at \"Control Structures\".","hash":"sec_controlstructuresmobile","h1":"Control structures (Mobile)"},"196":{"id":196,"content":"Mobile Tutorial","hash":"","h0":"If - else | QF‑Test Tutorial"},"197":{"id":197,"content":"Mobile Tutorial","hash":"home-link","h0":"If - else | QF‑Test Tutorial"},"198":{"id":198,"content":"If - else You already came across If nodes in the Setup sequence in the chapter Starting and Connecting the Device. Let's have a closer look at the details of the node.","hash":"sec_ifmobile","h0":"If - else"},"199":{"id":199,"content":"Figure 8.1: Setup Sequence with if-else structures By means of an If node you can control whether certain nodes will be executed or not. In our case, this concerns logging in to the Carconfig app. First, we need to determine whether we are already logged in. This is done via the Wait for component to appear node, which writes either true or false to the notLoggedIn variable.","hash":"fig_ControlsSetupSequenceMobile","h4":"Figure 8.1: Setup Sequence with if-else structures"},"200":{"id":200,"content":"Figure 8.2: Wait for component to appear writes the result into the variable \"notLoggedIn\" The If node has a Condition attribute where you'll find an expression evaluating the result variable notLoggedIn. As we want to refer to its value we need to use the syntax $() (see also note on variable syntax in chapter \"Procedure with a Variable\").","hash":"fig_ControlsWaitForComponentMobile","h4":"Figure 8.2: Wait for component to appear writes the result into the variable \"notLoggedIn\""},"201":{"id":201,"content":"Figure 8.3: If node evaluates the variable Depending on whether you are already logged in, QF‑Test will either execute the nodes contained in the If node or not. In the variable definition table, you can check the value of the notLoggedIn variable. When the first Test case's is executed, the value is true, and thus the condition $(notLoggedIn) is true, which means the login nodes are executed. During the second Test case's, the value is false, and therefore the condition is false. The nodes in the If node are skipped. In an Elseif node, an additional condition is specified, which is evaluated if the condition in the If node is not met. The child nodes of the Else node are only executed if neither the condition of the If node nor that of the Elseif node applies.","hash":"fig_ControlsIfMobile","h4":"Figure 8.3: If node evaluates the variable"},"202":{"id":202,"content":"Mobile Tutorial","hash":"","h0":"Loops | QF‑Test Tutorial"},"203":{"id":203,"content":"Mobile Tutorial","hash":"home-link","h0":"Loops | QF‑Test Tutorial"},"204":{"id":204,"content":"Loops QF‑Test provides two different kinds of nodes loops: Loop nodes execute their child nodes for a certain number of times. However, you can leave the loop any time using a Break node. While nodes execute their child nodes until a certain condition becomes false. Again, you can leave it any time using a Break node. Loop nodes will always stop after the given number of times. In the case of While nodes, however, you need to make sure that the condition will become false at some point. Otherwise you would have an infinite loop. In interactive mode you can always stop execution by hitting the pause button . In batch mode you would have to kill the QF‑Test process. (You start QF‑Test in batch mode using the command line parameter -batch. Then QF‑Test does not start its UI and just executes the given test suite.) In the following exercise, we will implement a test case that checks whether a specific entry is displayed in the CarConfig demo's list. The actions of the test case will be: Determine the number of list entries. Loop over all entries and check whether each entry matches. Break the loop when a match was found. If the entry was not found, write an error to the log. Please start with recording a check on the entry of interest: Activate the check recording mode by clicking the toolbar button Right-click on a vehicle name in the CarConfig demo and select the »Text« option from the context menu. Stop the recording by pressing . Change the name of the recorded sequence to e.g. 'Check text' Turn the recorded sequence into a test case by right-clicking it and selecting the submenu item »Transform node into«-»Test case« from the popup menu. In general, QF‑Test lets you add nodes very efficiently by packing one node into another one: Open the test case node and pack the recorded Check node into a loop by right-clicking it and selecting the submenu item »Pack nodes«-»Loop« from the popup menu. QF‑Test evaluates dynamically which nodes may be packed into one another and only presents the appropriate ones. So, in case you do not find the 'Loop' submenu item make sure you have right-clicked the correct node. The same holds true for the 'Transform node into' and 'Insert node' methods. In the next series of actions we want to set the value for the Number of iterations attribute of the Loop node. In order to do so we need to find out how many entries the list has. There is no simple node that you could use. However, in the last chapter we learned that the standard library provides a lot of extended functionality. So let's insert the procedure getItemCount from the package qfs.android.list in the standard library. Select the Test case node and press Ctrl⁠+⁠A Press the 'Select procedure' button left to 'Procedure name'. Click the tab 'qfs.qft' in the 'Select procedure' dialog. Navigate to 'getItemCount' in the package 'qfs.android.list' Click 'OK' to select it. Click 'OK' in the 'Procedure call' dialog. Adding a procedure via Ctrl⁠+⁠A was described in Manual creation of procedures. If you would like to check with the screenshots please have a look there. Enter the variable name itemCount in the Variable for return value attribute. Change the default value for the id in the variable definitions table to the QF‑Test component ID of the list, i.e. action_bar_root.list. Click the OK button. Select the Loop node. Enter a reference to the variable $(itemCount) in the Number of iterations attribute of the Loop node. Enter the name of an iteration counter, e.g. i in the respective attribute of the Loop node. Click the OK button. In the next series of actions we will change the recorded item index to the iteration counter and add a variable for the result to the details of the Check node. Then we will add an If node after the Check node evaluating the result, with a Break node within to quit the loop when the row was found. Open the Loop node. Select the Check node. Change the recorded item index of the QF‑Test component ID to the iteration counter $(i). The QF‑Test component ID should now read action_bar_root.list&$(i)@#Label Enter the variable name checkSucceeded in the 'Variable for result' attribute and click the OK button. Right-click the Check node and the submenu item »Insert node «-»Control structures«-»Break« from the popup menu. Click 'OK' in the 'Break' dialog. Pack the Break node into an If node by pressing Ctrl⁠+⁠Shift⁠+⁠I (Of course you can also pack it via the menu). Type $(checkSucceeded) in the 'Condition' attribute of the 'If' node and click the OK button. The variable checkSucceeded will be set to either true or false by the Check node so that the reference to the variable $(checkSucceeded) is all we need to enter in the 'Condition' attribute of the If node. In the next series of actions let's add an Else node as the last node in the Loop node. It will only be entered if all repetitions of the loop were executed, which in our case means that the entry was not found and the check never became true. Collapse the If node if it is open. This is important because otherwise the Else node would belong to the If node and not to the Loop node. Right-click the If node and select the submenu item »Insert node «-»Control structures«-»Else«. Click 'OK' in the 'Else' dialog. Open the Else node. From the standard library insert the procedure logError contained in the package qfs.run-log as described above. Type Entry not found in the value field of message in the Variable definitions table. Change the value of withScreenshots in the Variable definitions table from false to true. Click 'OK' in the 'Break' dialog. When you run tests in batch mode screenshots are a great help for analyzing errors. On the other hand a great number of screenshots lead to a big log-file. This is why the default value for withScreenshots is false. Last, let's complete the test case with Setup and Cleanup nodes and move it into the top part of the test suite. Copy the Setup and Cleanup nodes of 'Test set: Simple Tests' into the new test case as the first and last node. Move the test case from the Extras section into the top section of the test suite after the 'Test set: Simple Tests' node. This is what the new test case would look like:","hash":"sec_loopsmobile","h0":"Loops"},"205":{"id":205,"content":"Figure 8.4: The new test case Execute the new test case. It should run without error. Then modify a value in the details of the Check items node, e.g. change the name of the car to Wrong value.","hash":"fig_ControlsTestcaseMobile","h4":"Figure 8.4: The new test case"},"206":{"id":206,"content":"Figure 8.5: Details of the Check items node Execute the new test case again. This time the Else node should be entered and you should get an error message.","hash":"fig_ControlsCheckDetailsMobile","h4":"Figure 8.5: Details of the Check items node"},"207":{"id":207,"content":"Mobile Tutorial","hash":"","h0":"Now it is time to start your own application (Mobile) | QF‑Test Tutorial"},"208":{"id":208,"content":"Mobile Tutorial","hash":"home-link","h0":"Now it is time to start your own application (Mobile) | QF‑Test Tutorial"},"209":{"id":209,"content":"Now it is time to start your own application (Mobile) After having spent a lot of time with all those example programs, you are now ready to start on your own application (if you really haven't already done so). This chapter is also available as a video tutorial at \"It's time to start your own Application\". The Quickstart Wizard available via the menu »Extras«-»Quickstart Wizard...« helps you to achieve this. Simply follow the wizard steps to generate the setup sequence. Please refer also to chapter 3 \"Quickstart\" in the user manual. Then go ahead with what you have learned in this tutorial - record small sequences of events and checks, turn them into procedures which go into your test library, then set up the test cases using procedure calls. Finally, we reached the end of the basic tutorial part.","hash":"sec_ownappmobile","h0":"Now it is time to start your own application (Mobile)"},"210":{"id":210,"content":"Mobile Tutorial","hash":"","h0":"Advanced features of QF‑Test | QF‑Test Tutorial"},"211":{"id":211,"content":"Mobile Tutorial","hash":"home-link","h0":"Advanced features of QF‑Test | QF‑Test Tutorial"},"212":{"id":212,"content":"Advanced features of QF‑Test This part of the tutorial covers advanced QF‑Test features. The following chapters use the Java variant of the CarConfigurator, that you already know from the basic tutorial part. It is a Java/Swing application, but the concepts of the topics is the same for each technology. We also provide dedicated test suite files for each chapter, so that you get the chance to take a look at the single topics separately. These files are located in qftest-10.0.2-mobile/doc/tutorial/advanced-demos/en.","hash":"sec_advanced","h1":"Advanced features of QF‑Test"},"213":{"id":213,"content":"Mobile Tutorial","hash":"","h0":"Data-driven Testing: Running one Test case with different test\n    data | QF‑Test Tutorial"},"214":{"id":214,"content":"Mobile Tutorial","hash":"home-link","h0":"Data-driven Testing: Running one Test case with different test\n    data | QF‑Test Tutorial"},"215":{"id":215,"content":"Data-driven Testing: Running one Test case with different test data This chapter explains how data-driven testing can be achieved using QF‑Test. You can find the implementation of the following examples in the demo test suite qftest-10.0.2-mobile/doc/tutorial/advanced-demos/en/datadrivenTesting.qft. The second provided test suite qftest-10.0.2-mobile/doc/tutorial/datadriver.qft contains further samples like reading an Excel file or creating an iteration over test cases. Please take care to copy all test suites to a project-related folder first and modify them there.","hash":"sec_DataDriven","h0":"Data-driven Testing: Running one Test case with different test data"},"216":{"id":216,"content":"Situation The users of the CarConfigurator can grant several discount levels to their customers. Thus the test designers have figured out three discount levels which have to be tested. Those discount levels are 0%, 10% and 15%. As the workflow of granting discounts is the same for each discount level, we can use the same test case for testing them. The only difference between the test cases is the input of the actual discount level and the price to check. A major advantage of using the same test case is that this avoids side effects caused by several implementations of a Test case, which could have different bugs. Additionally we can reduce the implementation effort. The logical test case, i.e. the steps of the test, for granting a discount will look like this: Start the SUT. Select a vehicle. Specify the discount. Check whether the discount has been used for price calculation. Stop the SUT. The following paragraphs demonstrate how to implement such a scenario.","hash":"sec_dataDriven","h1":"Situation"},"217":{"id":217,"content":"Traditional way of implementing data-driven testing The QF‑Test definition of a Test case node says that a Test case is a workflow together with a specific set of test data. If you have two sets of test data, you have to use two different Test case nodes. Those nodes can be organized within a Test set node. So the conventional way to solve the issue is to implement one Test case per discount level, like depicted below:","hash":"sec_dataDrivenTrad","h1":"Traditional way of implementing data-driven testing"},"218":{"id":218,"content":"Figure 10.1: Traditional way of data-driven testing Those three nodes are grouped within a Test set node. The Test set node also contains the Setup and the Cleanup sequences, which will launch the SUT before each Test case and will stop the SUT after it. This is to ensure that each test case has the same pre-conditions. If you do not want to re-start the SUT between the single test runs, you could add a new Test set to the Test set 'Discount levels' and move the three Test case nodes into that Test set like this:","hash":"fig_dataDrivenTrad1","h4":"Figure 10.1: Traditional way of data-driven testing"},"219":{"id":219,"content":"Figure 10.2: Traditional way with a nested Test set The chapter Dependencies: Automatically ensuring correct prerequisites for each Test case will show up a more elegant and more efficient way of organizing pre-requisites of test cases. As you can imagine this approach could be very exhausting with regards to maintaining test data, especially if we have to add or remove discount levels. Another disadvantage is that we keep the test data within QF‑Test. The next section Data driver concept demonstrates how to organize the test suite to implement the Test case only once and to keep the test data separated from the test case.","hash":"fig_dataDrivenTrad2","h4":"Figure 10.2: Traditional way with a nested Test set"},"220":{"id":220,"content":"Data driver concept If we want to run one test case using different test data sets, we have to define the test data in a data source first. The data source has to be part of a Data driver node. QF‑Test offers built-in data source nodes for database tables, CSV files, Excel files and QF‑Test data tables. A QF‑Test data table will store the data in the test suite itself. This is what we will use for the following example. You can use any other type of data sources, e.g. XML files, too, by implementing your own script for reading the data. Insert a Test set to the test suite first. You can choose whatever name you want. A Data driver node can be inserted into a Test set via right mouse click and then selecting »Insert node«-»Data drivers«-»Data driver«. You have just to specify a name for this node. The actual data source will then be inserted as child node to that Data driver node. For our example we insert a 'Data table' via a right mouse click at the opened Data driver node and select »Insert node«-»Data drivers«-»Data table«. A Data driver node with the following details will be inserted:","hash":"sec_dataDriver20","h1":"Data driver concept"},"221":{"id":221,"content":"Figure 10.3: Data table dialog First we have to specify a name for this data source. We should also define a name for the 'Iteration counter' variable. The iteration counter contains the index of the currently executed test data in the test run The next step is to define the test data. Therefore click on the 'Insert column' button, which is the first button of the 'Data bindings' section. Then you have to define a name for the column, let us set it to 'discount'. After pressing 'OK' you will see that the column has been inserted in the 'Data bindings' area. This column heading will stand for the variable name in the tests later. Now you can use the 'Insert row' button to insert a new row. Each row will stand for one test data set, i.e. you have to insert three rows by now, where the first row contains '0', the second '10' and the third '15'. The table should look like this:","hash":"fig_dataDriver20Dt1","h4":"Figure 10.3: Data table dialog"},"222":{"id":222,"content":"Figure 10.4: The filled data table The next part is the implementation of the test case. Therefore we just insert one Test case node to the Test set. If you want to insert a Test case to a Test set which already contains a Data driver node, you have to select the closed Data driver node to insert it. The Test case will contain the procedure calls for the required test steps. The Setup and Cleanup nodes of the previous example can also be copied to the Test set. The whole Test set will look like this now:","hash":"fig_dataDriver20Dt2","h4":"Figure 10.4: The filled data table"},"223":{"id":223,"content":"Figure 10.5: Test set with Data driver The following step is to make use of the variable 'discount' which has been defined at the 'Data table' node before. We will add that variable as parameter to the 'setDiscount' procedure call. Once we have done this, we have following result:","hash":"fig_dataDriver20TestSet","h4":"Figure 10.5: Test set with Data driver"},"224":{"id":224,"content":"Figure 10.6: Using the $(discount) parameter Now we are ready to launch the Test set. After running the tests we should get at least two errors. Those errors come from the different values of the 'Final price' text-field, but our test always verifies the same value. In our case we should also put the expected values for the 'Final price' fields to our test data via adding a second column to the 'Data table' node.","hash":"fig_dataDriver20ParamTree","h4":"Figure 10.6: Using the $(discount) parameter"},"225":{"id":225,"content":"Figure 10.7: Full data table Another drawback is, that we see the same test case name in the HTML overview report and in the run logs for each test run. To avoid this we can edit the 'Name for reports and run logs' attribute of the Test case node. In that attribute we have to make use of at least one of the test case specific data, i.e. in our case 'discount'. So let us set that attribute to 'Discount $(discount)'.","hash":"fig_dataDriver20Full","h4":"Figure 10.7: Full data table"},"226":{"id":226,"content":"Figure 10.8: Name for run log and report attribute If we rerun the tests now, we should get no error anymore and the run log as well as the HTML report contain three different test case names. Here you can see the created run log file:","hash":"fig_dataDriver20NRR","h4":"Figure 10.8: Name for run log and report attribute"},"227":{"id":227,"content":"Figure 10.9: Run log with different names per Test case If you want to run one Test case only without the whole Test set and its Data driver, it is recommended to set default values for the variables as global ones at Test suite. If the name of the variable in the Data driver is the same like the name of the procedure, you can also skip the variable definition of the Procedure call. This can be done because the variable of the Data driver will be put at QF‑Test's variable stack and so any step within the Test case can access that variable. You can see this behavior in the demo test suite qftest-10.0.2-mobile/doc/tutorial/advanced-demos/en/datadrivenTesting.qft in the Test set \"data-driven tests with optimized procedure calls\". In the demo test suite qftest-10.0.2-mobile/doc/tutorial/advanced-demos/en/datadrivenTesting.qft you can also find an additional Test set using a CSV file as data source.","hash":"fig_dataDriver20HTML","h4":"Figure 10.9: Run log with different names per Test case"},"228":{"id":228,"content":"Summary The Data driver concept of QF‑Test allows the user to create logical test cases and to keep the test data separated from the test flow itself. It is even possible to use nested Data driver nodes in a Test case. This can be achieved by creating a Test step in a Test case. This Test step can contain the nested Data driver. You can find a more detailed explanation about data-driven testing within QF‑Test in the manual in the chapter Data-driven testing. The second provided test suite qftest-10.0.2-mobile/doc/tutorial/datadriver.qft contains further samples like reading an Excel file or creating an iteration over test cases.","hash":"dataDrivenSummary","h1":"Summary"},"229":{"id":229,"content":"Mobile Tutorial","hash":"","h0":"Dependencies: Automatically ensuring correct prerequisites for\n    each Test case | QF‑Test Tutorial"},"230":{"id":230,"content":"Mobile Tutorial","hash":"home-link","h0":"Dependencies: Automatically ensuring correct prerequisites for\n    each Test case | QF‑Test Tutorial"},"231":{"id":231,"content":"Dependencies: Automatically ensuring correct prerequisites for each Test case Video: Dependencies This chapter explains the dependency concept of QF‑Test. That concept is important for creating robust test cases and for defining recovery activities, if a single test case crashes during the test run. It has been introduced to guarantee that any test case's prerequisites are fulfilled before running it. You can find the following examples in the file qftest-10.0.2-mobile/doc/tutorial/ advanced-demos/en/dependencies.qft. There is also a second test suite qftest-10.0.2-mobile/doc/tutorial/ advanced-demos/en/dependencies_work.qft to perform your own implementations. Please take care to copy all test suites to a project-related folder first and modify them there.","hash":"sec_AdvDeps","h0":"Dependencies: Automatically ensuring correct prerequisites for each Test case"},"232":{"id":232,"content":"General Please copy the test suite qftest-10.0.2-mobile/doc/tutorial/ advanced-demos/en/dependencies_work.qft to a project-related folder first and open it there. Take a look at the first Test set 'Discount Tests'. It contains three different Test case nodes and the respective Setup and Cleanup to launch and stop the SUT before each Test case. That is a typical test suite you might have created yourself.","hash":"sec_depsGeneral","h1":"General"},"233":{"id":233,"content":"Figure 11.1: First Test set of dependencies_work.qft Let us assume you just want to launch one specific Test case, because that one failed or it verifies a specific defect. If you want to do so, you have either to run the whole Test set, because you have to ensure that the prerequisites are fulfilled, or you run the Setup manually and run the according Test case then. As this is a situation which is very common but not easily solvable with the concepts we know already, QF‑Test introduces the Dependencies concept. It is responsible for managing prerequisites of Test cases and allows you to run one Test case directly. In that case QF‑Test will take care of the prerequisites of the Test case, e.g. launching the SUT, selecting a vehicle and so on. A Dependency can contain a Setup, a Cleanup, an Error handler and a Catch node. The Setup of a Dependency will be executed before each Test case. This is because the correct pre-conditions of a Test case are a very important aspect of a robust test run. You could imagine a situation where one Test case closes the SUT because of a mistake. Then the next test case has to launch the SUT again. Exactly for this situation, the Dependency concept provides a very stable and fancy solution. The second aspect of Dependencies is that they optimize the execution of tests. With the current means we have to start the SUT before each Test case and stop the SUT after each. That is no problem for a small application like the CarConfigurator, but for huge applications, like Eclipse/RCP application or any ERP system, this might become insufficient. That is why Dependencies call the Cleanup steps only if required. Another advantage of the Dependencies concept are global Error handler and Catch for recovery management. This feature becomes quite important, if you run lots of test cases in a series and one is failing and preventing the other test cases from continuing execution because of modal error dialogs, e.g. 'OutOfMemoryException'. In a nutshell Dependencies are a place to define the prerequisites of a Test case. very helpful to make test cases more independent from other ones. a better approach of implementing Setup and Cleanup steps. allows you to implement recovery steps in case of errors or exceptions. optimizing test execution. re-usable as they can be defined in the Procedures area. The following sections demonstrate how to use Dependencies.","hash":"fig_depWorkTestSuite","h4":"Figure 11.1: First Test set of dependencies_work.qft"},"234":{"id":234,"content":"Ensuring prerequisites Please copy the test suite qftest-10.0.2-mobile/doc/tutorial/ advanced-demos/en/dependencies_work.qft to a project-related folder first and open it there if you haven't done that so far. This file contains a Test set 'Discount Tests' with three Test cases and the conventional implementation using the Setup and Cleanup. We will change this Test set to make use of a Dependency now.","hash":"sec_firstDep","h1":"Ensuring prerequisites"},"235":{"id":235,"content":"Figure 11.2: First Test set of dependencies_work.qft First we have to insert a Dependency node. This can be achieved by a right click at the Test set and then selecting »Insert node«-»Dependencies«-»Dependency«. Specify a name for that Dependency, e.g. \"SUT started\". The next step is to move the Setup and Cleanup nodes into that Dependency. Therefore open the Dependency node and move the mentioned nodes into it. You can do this via drag and drop or via right mouse click »Cut« and »Paste« or Ctrl⁠+⁠X and Ctrl⁠+⁠V. The test suite should now look like this:","hash":"fig_depFirstDepWorkTestSuite","h4":"Figure 11.2: First Test set of dependencies_work.qft"},"236":{"id":236,"content":"Figure 11.3: Sample test suite with the first Dependency Let us test the Dependency now: Please stop all running clients before that, then select one Test case, e.g. 'Discount 10', and run it. You should see that the Test case 'Discount 10' has been executed and the SUT has not been stopped at the end of the test run. Please open the run log to make a deeper analysis of what happened.","hash":"fig_firstDependencySample","h4":"Figure 11.3: Sample test suite with the first Dependency"},"237":{"id":237,"content":"Figure 11.4: The run log of the execution If you open the Test case in the run log, you can see a 'Resolve dependency' node. Open it and there you find two nodes. The last one shows that the Setup has been executed. The other one will be explained in following chapters. So far we have determined that the Setup node will be automatically executed before a Test case, if the Dependency is defined at the Test set level, but the Cleanup has not been executed so far. If you start another Test case now, e.g. 'Discount 15', the already started SUT is used. The Setup node of a Dependency will be executed before each Test case in any case. That is to ensure that the prerequisites are fulfilled for each single Test case. The Cleanup node of a Dependency will only be executed on demand, i.e. if the steps of the Setup of that Dependency are not required anymore. In our case the Cleanup steps did not get executed, because both test cases have the same Dependency. The test execution passed because the Procedure startStop.startApplication already checks whether it's necessary to launch the application or not.","hash":"fig_firstDepSampleRunLog","h4":"Figure 11.4: The run log of the execution"},"238":{"id":238,"content":"Figure 11.5: Procedure startStop.startApplication The next step is to launch the complete Test set by clicking it and pressing 'Run test'. All three tests should pass and the SUT should not be stopped in between. We have achieved an optimized test execution. The Cleanup will not run because all three test cases refer to the same Dependency. We save a lot of time in executing the test cases and we are closer to testing a real life behavior as users usually do not restart the SUT all the time. The next goal is to make that Dependency available for other Test sets in our project. For this you need to move the Dependency node into the Procedures area. Then click at the Test set and insert a Dependency reference node via »Insert node«-»Dependencies«-»Dependency reference«. The dialog looks similar to the Procedure call dialog and you can select the Dependency on the same way. The test suite should now look like this:","hash":"fig_firstDepSampleStart","h4":"Figure 11.5: Procedure startStop.startApplication"},"239":{"id":239,"content":"Figure 11.6: The test suite with a Dependency reference We recommend to add all Dependencies to a separate Package called 'dependencies'. If you run the Test set the first time after moving the Dependency, QF‑Test stops the SUT before the first Test case and re-starts the SUT, because the Dependency from the Test set is different from the Dependency defined in the Procedures node. But this will be explained more detailed in following chapters. Please take a closer look at the second Test set 'Discount Tests with SUT stop' of the demo test suite. The second Test case 'Dicount 10' stops the SUT. But the third Test case also relies on a running SUT. As we know the Dependencies concept already, we should see that the SUT will be started for the third Test case again. That is exactly the advantage of the Dependencies concept.","hash":"fig_firstDepSampleDepRef","h4":"Figure 11.6: The test suite with a Dependency reference"},"240":{"id":240,"content":"Figure 11.7: Ensuring prerequisites for Test case 'Discount 15'","hash":"fig_firstDepEnsuringPreReqs","h4":"Figure 11.7: Ensuring prerequisites for Test case 'Discount 15'"},"241":{"id":241,"content":"Combining dependencies Managing prerequisites can be a more complex matter than just verifying whether the SUT is up and running. In many projects several groups of test cases with different prerequisites like others exist. Let us assume you want to test a big ERP system with more views, like a 'vendor' view and an 'article' view. Then all tests for the 'vendor' view will rely on an opened 'vendor' view and all tests for the 'article' view rely on an opened 'article' view. The opening of the specific view again relies on a logged-in user and the login depends on a started SUT. So you can see something like a tree of prerequisites. QF‑Test allows the user to build such a structure of Dependency nodes via adding Dependency reference nodes to a Dependency. We will build up a small example with just two dependencies for the CarConfigurator now. In the CarConfigurator you can open a 'vehicles' dialog via the menu 'Options' -> 'Vehicles'. We want to create certain tests for that dialog now. Later we want to create some tests on the 'accessory' dialog which can also be opened via the menu via 'Options' -> 'Accessories'. First let us define the tests which we want to create. Test Case 1: Create vehicle 'test1' with price '100'. Start SUT if necessary. Open vehicles dialog via the menu. Specify 'test1' as name and '100' for the price. Press 'New'. Close vehicles dialog via pressing 'Ok'. Open vehicles dialog via the menu. Select the newly created vehicle 'test1'. Close the vehicles dialog via pressing 'Cancel'. Stop SUT if necessary. Test Case 2: Create vehicle 'test2' with price '99999'. Start SUT if necessary. Open vehicles dialog via the menu. Specify 'test2' as name and '99999' for the price. Press 'New'. Close vehicles dialog via pressing 'Ok'. Open vehicles dialog via the menu. Select the newly created vehicle 'test2'. Close the vehicles dialog via pressing 'Cancel'. Stop SUT if necessary. Test Case 3: Create accessory 'testaccessory' with price '12'. Start SUT if necessary. Open accessories dialog via the menu. Specify 'testaccessory' as name and '12' for the price. Press 'New'. Press 'Ok'. Open accessories dialog via the menu. Select the newly created accessory 'testaccessory'. Close the accessories dialog via pressing 'Cancel'. Stop SUT if necessary. Let us take a closer look at the test steps of the tests above. We see that each test case requires a running application, so we should implement the 'Start SUT' step as prerequisite. This has to be done in the Setup of a Dependency. The 'Stop SUT' step is an optional step which can be part of the Cleanup of the Dependency. This 'SUT started' Dependency has been implemented by us in the previous examples already, so we could re-use it. The next issue is that test case 1 and test case 2 require an opened vehicle dialog. Because we plan more tests in that area, we can create a new Dependency 'vehicles dialog opened', which will contain the opening of the dialog as Setup and the closing of the dialog via 'Cancel' as Cleanup. We are able to open this dialog only if the SUT is up and running already, so this Dependency is dependent on the 'SUT started' Dependency. The implementation of that 'open vehicle dialog' Dependency looks like this:","hash":"sec_depCombine","h1":"Combining dependencies"},"242":{"id":242,"content":"Figure 11.8: 'vehicles dialog opened' Dependency In the Setup we have to check whether the dialog is already opened, because a previous test case could have forgotten to close the dialog. The 'Timeout' attribute of the Wait for component to appear node is set to '0' because the dialog is expected to be here. If the dialog is already opened, it is fine and we can continue, otherwise we have to open the dialog. We have to create a Dependency 'accessories dialog opened' as well. This Dependency is similar to the 'vehicles dialog opened' Dependency, but it deals with the accessory dialog instead of the vehicles dialog. After creating those dependencies we have to record the according test steps and create the test cases. The test steps have already been implemented by us and you can find them in the according Package structure in the test suite qftest-10.0.2-mobile/doc/tutorial/ advanced-demos/en/dependencies.qft. The test cases should be organized in one Test set called 'Combined Dependencies Tests'. This Test set should contain two more Test sets. The first one is 'Tests for vehicles' and the second one is 'Tests for accessories'. The Test set 'Tests for vehicles' has to contain the implementation of test case 1 and test case 2 and a Dependency reference to the 'vehicles dialog opened' Dependency. The second Test set 'Tests for accessories' has to contain test case 3 and a Dependency reference to the Dependency 'accessories dialog opened'.","hash":"fig_depVehicleDialog","h4":"Figure 11.8: 'vehicles dialog opened' Dependency"},"243":{"id":243,"content":"Figure 11.9: Implementation of specified test cases If you run that Test set now, you will see that QF‑Test stops the SUT first, because that comes from a dependency of the previous examples. Then QF‑Test starts the SUT, performs the steps of test case 1 and then the steps of test case 2. Then it will perform the steps of test case 3. If you take a closer look at the beginning of test case 3 in the run log, you will see that the Cleanup of the 'vehicles dialog opened' Dependency has been executed. That happened because the 'vehicles dialog opened' Dependency was not required anymore. The following test case test case 3 required the 'accessories dialog opened' Dependency. However, both Dependencies require the 'SUT started' Dependency, that is why that Cleanup of the 'SUT started' Dependency has not been executed.","hash":"fig_depVehiclesAccessoriesTest","h4":"Figure 11.9: Implementation of specified test cases"},"244":{"id":244,"content":"Figure 11.10: Run log of nested Dependencies The ability to combine dependencies or to call the Cleanup of dependencies on demand can enable you to put a lot of preparing and cleaning steps into a Dependency. Another use case for the CarConfigurator could be to create a 'Vehicle created' Dependency, which creates a vehicle, which is required for the test and removes it afterwards. That would be an approach to ensure that the test data has been established correctly.","hash":"fig_depRunLogDepCombine","h4":"Figure 11.10: Run log of nested Dependencies"},"245":{"id":245,"content":"Error and exception handling","hash":"sec_depErrorAndCatch","h1":"Error and exception handling"},"246":{"id":246,"content":"Error handling Please copy the test suite qftest-10.0.2-mobile/doc/tutorial/ advanced-demos/en/dependencies_work.qft to a project-related folder first and open it there if you haven't done that so far. You can find a Test set 'Tests with error'. The second Test case of that Test set fails.","hash":"sec_depErrorHandler","h2":"Error handling"},"247":{"id":247,"content":"Figure 11.11: Test-suite of Error handler Let us assume that we want to trigger a specific behavior after a test case, but only if it failed. In our case we could stop the SUT to guarantee that the following test case can rely on a clean environment again. We know that the Setup node is executed before each Test case and the Cleanup node will only run on demand. So how could we run specific steps only in case of an error? The solution is the so called Error handler node for a Dependency. You have to click at the closed Cleanup node of that Dependency and insert the Error handler node via right mouse click and selecting »Insert node«-»Dependencies«-»Error handler«. In the Error handler you can define the steps for stopping the SUT again. The Dependency SUT started should look like this now:","hash":"fig_depErrorTestSuite","h4":"Figure 11.11: Test-suite of Error handler"},"248":{"id":248,"content":"Figure 11.12: Dependency with Error handler Please run the whole Test set 'Tests with error' and switch into the run log after the test run has finished. In the run log you can see that the Error handler was executed after the second Test case only.","hash":"fig_depErrorHandlerSample","h4":"Figure 11.12: Dependency with Error handler"},"249":{"id":249,"content":"Figure 11.13: Run log for Dependency with Error handler","hash":"fig_depErrorHandlerSample2","h4":"Figure 11.13: Run log for Dependency with Error handler"},"250":{"id":250,"content":"Exception handling In the previous section we have learned that Error handler nodes contain steps which are executed if the Test case fails. Besides errors also exceptions can occur during a test run. An exception is an unexpected behavior during the test run, e.g. an error dialog appears suddenly or a component could not be found anymore. How should we handle such exceptions? You can find an example Test set 'Tests with exception' in the test suite dependencies_work.qft. Of course you could surround the test steps in each Test case by try-catch and implement a dedicated exception handling in each single Test case, like implemented in the demo Test set. But this approach could lead to a lot of redundancy and makes the Test cases a little bit more unreadable.","hash":"sec_depCatch","h2":"Exception handling"},"251":{"id":251,"content":"Figure 11.14: Try-catch nodes in each Test case Our goal is to reduce the redundancy and to move the exception handling - which is always the same - to one global location. This location will be our Dependency. The first step is adding the Catch node to the Dependency via clicking at the closed Error handler node and selecting »Insert node«-»Control structures«-»Catch« in the menu. Then we can copy the procedure-calls for stopping the SUT into that Catch. Now the try-catch nodes in the single test cases become unnecessary. Please move the procedure-calls out of the Try and remove the empty try-catch structure. Your test suite should look like this now:","hash":"fig_depCatchTryEachTest","h4":"Figure 11.14: Try-catch nodes in each Test case"},"252":{"id":252,"content":"Figure 11.15: Test-suite with Catch Now you can start the Test set 'Test with exception'. The second Test case throws an IndexNotFoundException, because the selected vehicle does not exist. It is intended to handle that exception in the Catch of the Dependency. If the debugger is activated, QF‑Test interrupts the test run at the place where the exception arises. In this case you might have to re-throw the exception via the 'Rethrow exception' button. An alternative is to deactivate the debugger via »Debugger«-»Enable debugger«. After the test run you can open the run log and verify what happened.","hash":"fig_depCatchTestSuite","h4":"Figure 11.15: Test-suite with Catch"},"253":{"id":253,"content":"Figure 11.16: Run log of a Dependency with Catch In a normal project you should at least try to catch a 'TestException' and the Catch should contain a procedure call of either qfs.swing.cleanup.closeAllModalDialogs, qfs.fx.cleanup.closeAllModalDialogs or qfs.swt.cleanup.closeAllModalDialogsAndModalShells. Those procedures close all modal dialogs, e.g. dialog windows, which are blocking the execution.","hash":"fig_depRunLogCatchDep","h4":"Figure 11.16: Run log of a Dependency with Catch"},"254":{"id":254,"content":"Summary You have seen that you can implement a very strong recovery system for your test cases using the Error handler and, even more important, the Catch of Dependencies. In most projects the global Catch node becomes very important, especially if ComponentNotFoundExceptions and ModalDialogExceptions appear.","hash":"sec_depErrorCatchSum","h2":"Summary"},"255":{"id":255,"content":"More about dependencies In the previous sections we have learned that we can combine several dependencies and that the Cleanup of a Dependency is only executed, if the stack of combined dependencies changes. We could also instruct a Dependency to call its Cleanup every time after a Test case. This can be achieved by checking the attribute 'Forced cleanup' of the Dependency. There are even more interesting features about dependencies, e.g. you can use a variable instructing QF‑Test to run the Cleanup. This variable is called 'Characteristic variable'. You will find more details about that feature in the manual at chapter Dependencies. This approach could be used to create one 'user login' Dependency which will only run through its Cleanup, i.e. perform the logout, if another user is required by the next Test case. A detailed description of dependencies can be found in the manual at chapter Dependencies.","hash":"sec_depMoreDep","h1":"More about dependencies"},"256":{"id":256,"content":"Mobile Tutorial","hash":"","h0":"Automated creation of basic procedures | QF‑Test Tutorial"},"257":{"id":257,"content":"Mobile Tutorial","hash":"home-link","h0":"Automated creation of basic procedures | QF‑Test Tutorial"},"258":{"id":258,"content":"Automated creation of basic procedures This chapter describes how procedures for each UI component can be created automatically by QF‑Test. The advantage of this approach is that you do not need to record each step of your tests manually. Furthermore you will also get a standardized structure of Packages and Procedures for testing all dialogs of your SUT. You can find the following examples in the file qftest-10.0.2-mobile/doc/tutorial/advanced-demos/en/automated_procedures.qft . There is also a second test suite qftest-10.0.2-mobile/doc/tutorial/advanced-demos/en/automated_procedures_work.qft to perform your own implementations. Please take care to copy all test suites to a project-related folder first and modify them there.","hash":"sec_AdvProcbuilder","h0":"Automated creation of basic procedures"},"259":{"id":259,"content":"General If we want to create tests for all features of the CarConfigurator, we have to record steps on each element that will be touched by a test. The CarConfigurator is a small application with five dialogs and perhaps approximately thirty graphical elements. So creating all important test cases for this application can be achieved within one or two days. But imagine a big project like an ERP system with about fifty dialogs and hundreds of elements. Creating test cases for such a huge system will definitely take longer and also the maintenance of recorded tests could become quite difficult. As first organizational step we recommend to record each test step as a Procedure and call it from the Test cases requiring it. If you organize your tests in different test suites, you could split those test suites into two levels. The first level contains only UI component related procedures and the second level contains only test cases calling procedures of level one. The approach of implementing each test step as procedure brings us to a situation where we could split the work into two parts: Creating and maintaining the procedures representing the test steps Creating and maintaining the test cases QF‑Test brings a feature which creates that basic procedures for each UI component automatically. The usage of this feature should drastically minimize the time for creating test suites and test cases and supports you in making easier maintainable test suites. You can find a demo suite containing some test cases created by this qftest-10.0.2-mobile/doc/tutorial/advanced-demos/en/automated_procedures.qft .","hash":"sec_apbGeneral","h1":"General"},"260":{"id":260,"content":"Figure 12.1: Screenshot of test suite The following sections demonstrate how to create those procedures and organize your test cases.","hash":"fig_advPbTestSuite","h4":"Figure 12.1: Screenshot of test suite"},"261":{"id":261,"content":"Automated creation of procedures Please copy the demo test suite qftest-10.0.2-mobile/doc/tutorial/advanced-demos/en/automated_procedures_work.qft to a project-related folder and open it there. This test suite contains a Test set referring to a 'Start SUT' Dependency.","hash":"sec_abpCreation","h1":"Automated creation of procedures"},"262":{"id":262,"content":"Figure 12.2: The test suite automated_procedures_work.qft First we have to launch the SUT via selecting the Dependency reference and pressing 'Start test run'. Once the SUT is up and running we are ready to record the test steps. Normally we would press the 'Start recording' button, then record the according test steps and then press 'Stop recording'. After that we would re-organize the recorded steps, i.e. generating procedures and parametrizing them. Exactly those steps can be performed automatically now. Let us generate the basic procedures for the main window first. Before we can start, please modify the settings of QF‑Test. Open the QF‑Test options via »Edit«-»Options«. Then switch to 'Record' -> 'Procedures'. Please change the value for the 'Configuration file for recorded procedures' to the full path of the demo configuration test suite at qftest-10.0.2-mobile/demo/procbuilder/carconfig-procbuilderdef.qft. Then close the 'Options' via pressing 'OK'. You will see more details about that file in the following chapters. After altering the settings proceed with following steps: Press the 'Record procedures' button. Perform a right mouse-click in the SUT. Select 'Whole window'. Press the 'Record procedures' button again. Now QF‑Test creates the basic procedures of the main window. You should see a new Package called procbuilder under Procedures of your test suite. This package contains several packages and procedures for actions on the whole dialog and its single UI components. The current configuration created a Package JCarConfigurator under the procbuilder Package. This Package is indicated to be the container for all actions performed on the main window.","hash":"fig_autoProcSuite","h4":"Figure 12.2: The test suite automated_procedures_work.qft"},"263":{"id":263,"content":"Figure 12.3: The recorded procedures Please note that the involved components have also been recorded in Windows and components. The next step is to check which procedures are useful for us and which are obsolete. Let us take a closer look at the created Packages:","hash":"fig_autoProcFirstRecord","h4":"Figure 12.3: The recorded procedures"},"264":{"id":264,"content":"Package Content JCarConfigurator This package contains all procedures for actions on components of the CarConfigurator window. It has been created because the configuration file uses the component hierarchy for creating the package structure. Table 12.1: The Package JCarConfigurator contains several packages which are:","hash":"table_12.1","h4":"Figure 12.3: The recorded procedures"},"265":{"id":265,"content":"Package Content MenuBar This package contains procedures for clicking at the items of the menu. VehicleTablePanel This package contains all procedures for actions on components on the 'VehicleTable' panel of the SUT. In our case there are only procedures for the 'VehicleTable' object, because that is the only component on that panel. check This package contains procedures for checking components. check-window This package contains procedures which can be called to check the components of one frame using one call. Those procedures are container procedures. get This package contains procedures for getting the current values of components, e.g. reading the text of a text-field. select This package contains procedures for selecting items of elements - in our case only one procedure to select a tab in the TabbedPane. set This package contains procedures for setting several components of the current window - in our case several setters for the text fields of the frame. set-window This package contains procedures setting several component of certain frames or dialogs - in our case one procedure calling all procedure for the package 'set' of the JCarConfigurator frame. Those container procedures are typical workflow procedures. wait This package contains all procedure waiting for several components. Table 12.2: In our case all procedures might be useful. So we can move the whole 'JCarConfigurator' Package from the procbuilder Package directly under the Procedures node. Press 'Yes' on the occurring 'Update Reference' dialog. Now the procedures can be used by test cases or other procedures. Finally our test suite should look like this:","hash":"table_12.2","h4":"Figure 12.3: The recorded procedures"},"266":{"id":266,"content":"Figure 12.4: The test suite containing the procedures Repeat that recording now for the 'Specials' and the 'Accessories' panel and just move the respective procedures or packages for the important components to the 'JCarConfigurator' package. In our case these are only the packages 'SpecialsPanel' and 'AccessoryTablePanel'. The full test suite should then look like this:","hash":"fig_autoProcTestSuite1","h4":"Figure 12.4: The test suite containing the procedures"},"267":{"id":267,"content":"Figure 12.5: The procedures for all panels We are ready for creating test cases using the automatically recorded test steps. You could of course also repeat that recording for all other dialogs, e.g. the 'Vehicles' dialog which can be reached via the menu 'Options' -> 'Vehicles' as well as for the 'Accessories' and 'Specials' dialogs. You do not need to record the whole window all the time. You could also select 'Component only' to record one dedicated component or 'Component with children' to record procedures for a certain panel.","hash":"fig_autoProcTestSuite2","h4":"Figure 12.5: The procedures for all panels"},"268":{"id":268,"content":"Configuration of the automated creation","hash":"sec_apbConf","h1":"Configuration of the automated creation"},"269":{"id":269,"content":"Introduction In the previous example we used the file qftest-10.0.2-mobile/demo/procbuilder/carconfig-procbuilderdef.qft as configuration file for the automated creation. In this section we want to take a closer look at the configuration capabilities of QF‑Test. So please open that file.","hash":"sec_apbConfIntro","h2":"Introduction"},"270":{"id":270,"content":"Figure 12.6: The current configuration The package procbuilder is the root-package for all created packages. If you want to use another name for the automatically created procedures, feel free to rename the package. If you open that package, you can see the 'class' level. This level describes the classes of the UI components which should be taken into account for creating the packages. The next levels contains information about the created package structure and procedures. You can find a detailed description of those capabilities in the manual in chapter The Procbuilder definition file.","hash":"fig_apbConfiguration","h4":"Figure 12.6: The current configuration"},"271":{"id":271,"content":"First example In our first example we want to create a new settings file which we will build up step by step. Please perform following actions at the beginning: Open a new test suite file and save it. Specify a name like 'mySettings.qft' or something similar. Create a new Package with the name 'myProcedures'. The new test suite should look like this:","hash":"sec_apbFirstExample","h2":"First example"},"272":{"id":272,"content":"Figure 12.7: The own configuration file Now we are ready to configure procedure templates for specific classes. Let us create procedures for the text-fields on the main panel of the CarConfigurator first. It might be interesting for our project to check the content of those text-fields, so we need to create procedures for checking the text of each text-field. To create those procedures we have to insert a new package to the package 'myProcedures'. Please call that package 'javax_swing_JTextField'. 'javax.swing.JTextField' is the class of those text-fields, but we have to use '_' in the package's name, because '.' is not allowed in that attribute. This package will instruct QF‑Test to create the procedures in it, if it meets a component of the class 'javax.swing.JTextField' only. That is an important aspect, because we should realize that procedure templates can be created per classes of components. Consecutively we want to create a template for a procedure checking the text of a component. The template procedure has to be part of another package. The name of this package should indicate its purpose, e.g. 'checkers'. After creating the 'checkers' package you can add a procedure 'checkText' to it. The procedure should contain a 'Check Text' node which is meant to check the text of components. Please insert such a 'Check text' node via right mouse click at the expanded procedure and »Insert node«-»Check nodes«-»Check Text«. Specify $(client) as client, 'dummy' as QF‑Test component ID and $(text) as text. Of course, after confirming these entries, we will get a warning that a component named 'dummy' does not exist. In this case we are allowed to ignore this warning. The test suite will then look like this:","hash":"fig_apbOwnConf1","h4":"Figure 12.7: The own configuration file"},"273":{"id":273,"content":"Figure 12.8: The checkText procedure The procedure contains an empty default value for the parameter 'text'.","hash":"fig_apbOwnConfProc","h4":"Figure 12.8: The checkText procedure"},"274":{"id":274,"content":"Figure 12.9: The checkText procedure with parameters Now we have nearly completed our first procedure template, but we have to think about one more issue. Each component has its specific and unique QF‑Test ID, so it would be great to use that QF‑Test ID attribute immediately during creation, otherwise we have to do that manually afterwards. We also want the procedure to have a component-related name instead of 'checkText' only. The place holder <COMPID> points out to QF‑Test to replace it with the QF‑Test ID of the current component. So we have to change the procedure name to checkText_<COMPID> and we have to insert the <COMPID> place holder directly in the QF‑Test component ID attribute of the 'Check text' node. Finally the template procedure should look like this:","hash":"fig_apbOwnConfParams","h4":"Figure 12.9: The checkText procedure with parameters"},"275":{"id":275,"content":"Figure 12.10: Using the <COMPID> place holder We are ready to begin now. First we have to order QF‑Test to use that file. That is achieved via the options of QF‑Test. Open the options dialog via »Edit«-»Options« and change to 'Record' -> 'Procedures.' Specify the path of your 'mySettings.qft' for the 'Configuration file for recorded procedures' and press 'OK'. Then start the CarConfigurator again. Once it is up and running, please proceed with following steps: Press the 'Record procedures' button. Perform a right mouse-click in the SUT. Select 'Whole window'. Press the 'Record procedures' button again. Congratulations, you have instructed QF‑Test to record test steps for you.","hash":"fig_apbOwnConfPlaceholderCompId","h4":"Figure 12.10: Using the <COMPID> place holder"},"276":{"id":276,"content":"Figure 12.11: Your first automatically created procedures","hash":"fig_apbOwnConfFirstCreation","h4":"Figure 12.11: Your first automatically created procedures"},"277":{"id":277,"content":"Using the current text for checking The 'checkText' procedures have a parameter 'text' for the text to check. Up to now we have to specify that value each time we call that Procedure of the according text-field. Let us assume we have a scenario where we intend to check the default values of the CarConfigurator after its startup. In this case we would have to add the single procedure calls of all four 'checkText' procedures and specify the according values. However, QF‑Test offers a place holder to set the current value of a text-field automatically to the created procedures. Therefore we have to change the default-value of the 'text' parameter to <CURRENTVALUE> in our configuration test suite. After that you have to ensure that the myProcedures package doesn't exist under the Procedures node anymore, then re-create the packages like in the previous example. Otherwise QF‑Test will create a package myProcedures1 to ensure that each creation process has its own unique target package. The configuration file looks like this:","hash":"sec_apbCurrentText","h2":"Using the current text for checking"},"278":{"id":278,"content":"Figure 12.12: The configuration for the current text The newly created procedures displays like below:","hash":"fig_apbExampleCurrentText","h4":"Figure 12.12: The configuration for the current text"},"279":{"id":279,"content":"Figure 12.13: The created procedures with the current text","hash":"fig_apbExampleCurrentText2","h4":"Figure 12.13: The created procedures with the current text"},"280":{"id":280,"content":"Creating container procedures In the previous example we have created the 'checkText' procedure for checking single text-fields. Now you should be able to create a 'set' procedure for setting the text of a text-field or a 'press' procedure for pressing a button. Those procedures are created similarly. Keep in mind that all those procedures work with one single component. In some test scenarios it might be interesting to call one procedure for checking all components of a specific dialog or specific panel or to fill all visible text-fields. Because such procedures deal with components which act as containers, we call those procedures 'container'-procedures. In our case we could consider one procedure calling all single 'checkText' procedures of the CarConfigurator. But how to create such a procedure like that? First of all add a new 'class'-package to your 'mySettings.qft' file with the name 'javax_swing_JFrame'. The main window of the JCarConfigurator is an instance of javax.swing.JFrame, that is why we have to use that specific package name. The 'class'-package has to contain a 'type'-package which we call 'checkers-window' now. The 'type'-package has to contain a procedure checkTextOfElements_<COMPID>, intended to perform the actual checks. We use the <COMPID> placeholder again for the procedure name to determine which dialog is affected by the created procedures. The next step is to specify the procedure content. Let us see how we can configure this. We have four text-fields which can be checked by using the same procedure checkText_<COMPID>. QF‑Test allows to call all four procedures with just one configured Procedure call node. Therefore insert a Procedure call for the procedure javax_swing_JTextField.checkers.checkText_<CCOMPID>. The configuration file should look like below:","hash":"sec_abpContainer","h2":"Creating container procedures"},"281":{"id":281,"content":"Figure 12.14: The template for container procedures The last step is to make QF‑Test to create a 'container' procedure and not a normal 'component' procedure. This can be achieved by setting @FORCHILDREN in the comment attribute of the checkTextOfElements_<COMPID> procedure.","hash":"fig_apbContainerExample","h4":"Figure 12.14: The template for container procedures"},"282":{"id":282,"content":"Figure 12.15: Usage of @FORCHILDREN tag Now you can record the procedures like in the previous examples. Do not forget to remove the 'myProcedures' from Procedures before. You should then get something like this under Procedures:","hash":"fig_apbForChildrenTag","h4":"Figure 12.15: Usage of @FORCHILDREN tag"},"283":{"id":283,"content":"Figure 12.16: The created container procedures QF‑Test replaces the 'class' part of the procedure-calls by the top package of the configuration. In our case this is 'myProcedures'.","hash":"fig_apbCreatedContainer","h4":"Figure 12.16: The created container procedures"},"284":{"id":284,"content":"Using the current value of child components We could meet a similar situation like in the example Using the current text for checking, where we want to record the current values of each text-field during creation. In the example Using the current text for checking we used <CURRENTVALUE>. Now we have to specify the current text as parameter at the procedure-call in the 'container'-procedure 'checkTextElements'. Therefore we add the parameter 'text' to the procedure-call in your 'mySettings.qft' file and the value should be <CCURRENTVALUE>.","hash":"sec_apbCurrentChildValue","h2":"Using the current value of child components"},"285":{"id":285,"content":"Figure 12.17: Configuration of <CCURRENTVALUE> If you create the procedures again, you will see the current values at the procedure-calls. Please do not forget to remove the 'myProcedures' package from Procedures.","hash":"fig_apbContainerCurrentText","h4":"Figure 12.17: Configuration of <CCURRENTVALUE>"},"286":{"id":286,"content":"Figure 12.18: Test-suite using <CCURRENTVALUE> If you take a closer look at the created procedure 'checkTextElements_', you will see that each procedure-call gets the parameter text. Perhaps it might be convenient for test development to set the according 'text' parameters as default values for the 'container'-procedure. To achieve this you have to add one more parameter to the procedure call in the settings file. The name of the parameter has to be <CCOMPID> and the value will be <CCURRENTVALUE>. Then you have to change the value of the text parameter of that procedure-call to $(<CCOMPID>). The configuration should look like this now:","hash":"fig_apbContainerCurrentTextTestSuite","h4":"Figure 12.18: Test-suite using <CCURRENTVALUE>"},"287":{"id":287,"content":"Figure 12.19: Parameters for container procedures If you create the procedures again, you will see that the 'checkTextElements' procedure has four more parameters with the current value of the elements as default values. Additionally each single procedure call uses a variable - named after the component-id - as 'text' parameter.","hash":"fig_apbContainerParams","h4":"Figure 12.19: Parameters for container procedures"},"288":{"id":288,"content":"Figure 12.20: Parameters for container procedures in test suite","hash":"fig_apbContainerParamsTestSuite","h4":"Figure 12.20: Parameters for container procedures in test suite"},"289":{"id":289,"content":"More configuration capabilities As you have seen in the previous sections there is a lot of configuration capability for the automated creation of basic procedures. But there are even more options available. Please take a look at the manual chapter The Procbuilder definition file.","hash":"sec_apbMore","h2":"More configuration capabilities"}},"docInfo":{"0":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"1":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"2":{"content":1,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"3":{"content":171,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"4":{"content":219,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"5":{"content":26,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"6":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"7":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"8":{"content":62,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"9":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"10":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"11":{"content":19,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"12":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"13":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"14":{"content":84,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"15":{"content":72,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"16":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"17":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"18":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"19":{"content":39,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"20":{"content":42,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"21":{"content":203,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"22":{"content":5,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"23":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"24":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"25":{"content":12,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"26":{"content":69,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"27":{"content":99,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"28":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"29":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"30":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"31":{"content":20,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"32":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"33":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"34":{"content":35,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"35":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"36":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"37":{"content":62,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"38":{"content":83,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"39":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"40":{"content":85,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"41":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"42":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"43":{"content":136,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"44":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"45":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"46":{"content":14,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"47":{"content":31,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"48":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"49":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"50":{"content":39,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"51":{"content":67,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"52":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"53":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"54":{"content":35,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"55":{"content":78,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"56":{"content":83,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"57":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"58":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"59":{"content":22,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"60":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"61":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"62":{"content":36,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"63":{"content":83,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"64":{"content":37,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"65":{"content":29,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"66":{"content":41,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"67":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"68":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"69":{"content":32,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"70":{"content":42,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"71":{"content":46,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"72":{"content":73,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"73":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"74":{"content":40,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"75":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"76":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"77":{"content":53,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"78":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"79":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"80":{"content":122,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"81":{"content":96,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"82":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"83":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"84":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"85":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"86":{"content":61,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"87":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"88":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"89":{"content":57,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"90":{"content":15,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"91":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"92":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"93":{"content":78,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"94":{"content":57,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"95":{"content":34,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"96":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"97":{"content":71,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"98":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"99":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"100":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"101":{"content":93,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"102":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"103":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"104":{"content":48,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"105":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"106":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"107":{"content":68,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"108":{"content":86,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"109":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"110":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"111":{"content":96,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"112":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"113":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"114":{"content":184,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"115":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"116":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"117":{"content":51,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"118":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"119":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"120":{"content":94,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"121":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"122":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"123":{"content":57,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"124":{"content":35,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"125":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"126":{"content":139,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"127":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"128":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"129":{"content":70,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"130":{"content":30,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"131":{"content":20,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"132":{"content":29,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"133":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"134":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"135":{"content":67,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"136":{"content":38,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"137":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"138":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"139":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"140":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"141":{"content":104,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"142":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"143":{"content":46,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"144":{"content":45,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"145":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"146":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"147":{"content":105,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"148":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"149":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"150":{"content":43,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"151":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"152":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"153":{"content":14,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"154":{"content":116,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"155":{"content":110,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"156":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"157":{"content":87,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"158":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"159":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"160":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"161":{"content":35,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"162":{"content":132,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"163":{"content":145,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"164":{"content":95,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"165":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"166":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"167":{"content":84,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"168":{"content":238,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"169":{"content":57,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"170":{"content":29,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"171":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"172":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"173":{"content":106,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"174":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"175":{"content":110,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"176":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"177":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"178":{"content":288,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"179":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"180":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"181":{"content":189,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"182":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"183":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"184":{"content":31,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"185":{"content":50,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"186":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"187":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"188":{"content":13,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"189":{"content":89,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"190":{"content":62,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"191":{"content":52,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"192":{"content":51,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"193":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"194":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"195":{"content":35,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"196":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"197":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"198":{"content":19,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"199":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"200":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"201":{"content":80,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"202":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"203":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"204":{"content":693,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"205":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"206":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"207":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"208":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"209":{"content":86,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"210":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"211":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"212":{"content":51,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"213":{"content":2,"h-1":0,"h0":12,"h1":0,"h2":0,"h3":0,"hash":0},"214":{"content":2,"h-1":0,"h0":12,"h1":0,"h2":0,"h3":0,"hash":2},"215":{"content":61,"h-1":0,"h0":10,"h1":0,"h2":0,"h3":0,"hash":1},"216":{"content":99,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"217":{"content":50,"h-1":0,"h0":0,"h1":6,"h2":0,"h3":0,"hash":1},"218":{"content":62,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"219":{"content":71,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"220":{"content":138,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"221":{"content":100,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"222":{"content":58,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"223":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"224":{"content":48,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"225":{"content":52,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"226":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"227":{"content":96,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"228":{"content":77,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"229":{"content":2,"h-1":0,"h0":11,"h1":0,"h2":0,"h3":0,"hash":0},"230":{"content":2,"h-1":0,"h0":11,"h1":0,"h2":0,"h3":0,"hash":2},"231":{"content":78,"h-1":0,"h0":9,"h1":0,"h2":0,"h3":0,"hash":1},"232":{"content":43,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"233":{"content":245,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"234":{"content":41,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"235":{"content":58,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"236":{"content":46,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"237":{"content":118,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"238":{"content":97,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"239":{"content":92,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"240":{"content":9,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"241":{"content":370,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"242":{"content":150,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"243":{"content":87,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"244":{"content":44,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"245":{"content":3,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"246":{"content":31,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"247":{"content":86,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"248":{"content":29,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"249":{"content":8,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"250":{"content":86,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"251":{"content":74,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"252":{"content":58,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"253":{"content":31,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"254":{"content":31,"h-1":0,"h0":0,"h1":0,"h2":1,"h3":0,"hash":1},"255":{"content":82,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"256":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"257":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"258":{"content":64,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"259":{"content":168,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"260":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"261":{"content":25,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"262":{"content":172,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"263":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"264":{"content":30,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"265":{"content":175,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"266":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"267":{"content":55,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"268":{"content":3,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"269":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":1,"h3":0,"hash":1},"270":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"271":{"content":40,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"272":{"content":165,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"273":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"274":{"content":72,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"275":{"content":73,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"276":{"content":6,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"277":{"content":100,"h-1":0,"h0":0,"h1":0,"h2":5,"h3":0,"hash":1},"278":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"279":{"content":6,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"280":{"content":179,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1},"281":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"282":{"content":21,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"283":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"284":{"content":55,"h-1":0,"h0":0,"h1":0,"h2":5,"h3":0,"hash":1},"285":{"content":20,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"286":{"content":60,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"287":{"content":34,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"288":{"content":9,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"289":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1}},"length":290,"save":true},"index":{"content":{"root":{"0":{"docs":{"108":{"tf":1.7320508075688772},"216":{"tf":1},"221":{"tf":1},"242":{"tf":1}},"df":4},"1":{"0":{"0":{"docs":{"27":{"tf":1},"241":{"tf":1.4142135623730951}},"df":2},"docs":{"216":{"tf":1},"221":{"tf":1},"236":{"tf":1.4142135623730951},"239":{"tf":1}},"df":4,".":{"0":{"docs":{},"df":0,".":{"2":{"docs":{"14":{"tf":1},"63":{"tf":1},"89":{"tf":1},"184":{"tf":1},"212":{"tf":1},"215":{"tf":1.4142135623730951},"227":{"tf":1.4142135623730951},"228":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":1},"234":{"tf":1},"242":{"tf":1},"246":{"tf":1},"258":{"tf":1.4142135623730951},"259":{"tf":1},"261":{"tf":1},"262":{"tf":1},"269":{"tf":1}},"df":18},"docs":{},"df":0}},"1":{"docs":{"218":{"tf":1}},"df":1},"2":{"docs":{"219":{"tf":1}},"df":1},"3":{"docs":{"221":{"tf":1}},"df":1},"4":{"docs":{"222":{"tf":1}},"df":1},"5":{"docs":{"223":{"tf":1}},"df":1},"6":{"docs":{"224":{"tf":1}},"df":1},"7":{"docs":{"225":{"tf":1}},"df":1},"8":{"docs":{"226":{"tf":1}},"df":1},"9":{"docs":{"227":{"tf":1}},"df":1},"docs":{},"df":0}},"1":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"244":{"tf":1}},"df":1},"1":{"docs":{"247":{"tf":1}},"df":1},"2":{"docs":{"248":{"tf":1}},"df":1},"3":{"docs":{"249":{"tf":1}},"df":1},"4":{"docs":{"251":{"tf":1}},"df":1},"5":{"docs":{"252":{"tf":1}},"df":1},"6":{"docs":{"253":{"tf":1}},"df":1},"docs":{"233":{"tf":1}},"df":1},"2":{"docs":{"235":{"tf":1}},"df":1},"3":{"docs":{"236":{"tf":1}},"df":1},"4":{"docs":{"237":{"tf":1}},"df":1},"5":{"docs":{"238":{"tf":1}},"df":1},"6":{"docs":{"239":{"tf":1}},"df":1},"7":{"docs":{"240":{"tf":1}},"df":1},"8":{"docs":{"242":{"tf":1}},"df":1},"9":{"docs":{"243":{"tf":1}},"df":1},"docs":{},"df":0}},"2":{"docs":{"181":{"tf":1},"241":{"tf":1.4142135623730951}},"df":2,".":{"1":{"0":{"docs":{"275":{"tf":1}},"df":1},"1":{"docs":{"276":{"tf":1}},"df":1},"2":{"docs":{"278":{"tf":1}},"df":1},"3":{"docs":{"279":{"tf":1}},"df":1},"4":{"docs":{"281":{"tf":1}},"df":1},"5":{"docs":{"282":{"tf":1}},"df":1},"6":{"docs":{"283":{"tf":1}},"df":1},"7":{"docs":{"285":{"tf":1}},"df":1},"8":{"docs":{"286":{"tf":1}},"df":1},"9":{"docs":{"287":{"tf":1}},"df":1},"docs":{"260":{"tf":1},"264":{"tf":1}},"df":2},"2":{"0":{"docs":{"288":{"tf":1}},"df":1},"docs":{"262":{"tf":1},"265":{"tf":1}},"df":2},"3":{"docs":{"263":{"tf":1}},"df":1},"4":{"docs":{"266":{"tf":1}},"df":1},"5":{"docs":{"267":{"tf":1}},"df":1},"6":{"docs":{"270":{"tf":1}},"df":1},"7":{"3":{"4":{"docs":{},"df":0,",":{"0":{"0":{"docs":{"154":{"tf":1},"168":{"tf":1}},"df":2},"docs":{},"df":0},"docs":{},"df":0}},"docs":{},"df":0},"docs":{"272":{"tf":1}},"df":1},"8":{"docs":{"273":{"tf":1}},"df":1},"9":{"docs":{"274":{"tf":1}},"df":1},"docs":{},"df":0}},"3":{"docs":{},"df":0,".":{"3":{"4":{"9":{"docs":{},"df":0,",":{"0":{"0":{"docs":{"154":{"tf":1},"155":{"tf":1.4142135623730951},"164":{"tf":1}},"df":3},"docs":{},"df":0},"docs":{},"df":0}},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0}},"5":{"docs":{"216":{"tf":1},"221":{"tf":1},"237":{"tf":1},"240":{"tf":1}},"df":4},"9":{"docs":{"89":{"tf":1}},"df":1},"docs":{"241":{"tf":1.4142135623730951},"242":{"tf":1},"243":{"tf":1}},"df":3,".":{"1":{"0":{"docs":{"33":{"tf":1}},"df":1},"1":{"docs":{"34":{"tf":1}},"df":1},"2":{"docs":{"38":{"tf":1}},"df":1},"3":{"docs":{"39":{"tf":1}},"df":1},"4":{"docs":{"40":{"tf":1}},"df":1},"5":{"docs":{"47":{"tf":1}},"df":1},"6":{"docs":{"51":{"tf":1}},"df":1},"7":{"docs":{"55":{"tf":1}},"df":1},"8":{"docs":{"56":{"tf":1}},"df":1},"docs":{"15":{"tf":1}},"df":1},"2":{"docs":{"16":{"tf":1}},"df":1},"3":{"docs":{"20":{"tf":1}},"df":1},"4":{"docs":{"21":{"tf":1}},"df":1},"5":{"docs":{"22":{"tf":1}},"df":1},"6":{"docs":{"26":{"tf":1}},"df":1},"7":{"docs":{"27":{"tf":1}},"df":1},"8":{"docs":{"28":{"tf":1}},"df":1},"9":{"docs":{"32":{"tf":1}},"df":1},"docs":{},"df":0}},"2":{"docs":{"241":{"tf":1.4142135623730951},"242":{"tf":1},"243":{"tf":1}},"df":3,".":{"1":{"0":{"docs":{"81":{"tf":1}},"df":1},"1":{"docs":{"82":{"tf":1}},"df":1},"2":{"docs":{"83":{"tf":1}},"df":1},"docs":{"63":{"tf":1}},"df":1},"2":{"docs":{"64":{"tf":1}},"df":1},"3":{"docs":{"65":{"tf":1}},"df":1},"4":{"docs":{"66":{"tf":1}},"df":1},"5":{"docs":{"70":{"tf":1}},"df":1},"6":{"docs":{"71":{"tf":1}},"df":1},"7":{"docs":{"72":{"tf":1}},"df":1},"8":{"docs":{"73":{"tf":1}},"df":1},"9":{"docs":{"74":{"tf":1}},"df":1},"docs":{},"df":0}},"3":{"docs":{"209":{"tf":1},"241":{"tf":1},"242":{"tf":1},"243":{"tf":1.7320508075688772}},"df":4,".":{"1":{"docs":{"90":{"tf":1}},"df":1},"2":{"docs":{"94":{"tf":1}},"df":1},"3":{"docs":{"95":{"tf":1}},"df":1},"4":{"docs":{"96":{"tf":1}},"df":1},"5":{"docs":{"97":{"tf":1}},"df":1},"6":{"docs":{"98":{"tf":1}},"df":1},"docs":{},"df":0}},"4":{"docs":{},"df":0,".":{"1":{"docs":{"108":{"tf":1}},"df":1},"2":{"docs":{"5":{"tf":1}},"df":1},"docs":{},"df":0}},"5":{"0":{"docs":{"56":{"tf":1}},"df":1},"docs":{"3":{"tf":1},"32":{"tf":1.4142135623730951}},"df":2,".":{"1":{"0":{"docs":{"136":{"tf":1}},"df":1},"1":{"docs":{"137":{"tf":1}},"df":1},"2":{"docs":{"138":{"tf":1}},"df":1},"3":{"docs":{"142":{"tf":1}},"df":1},"4":{"docs":{"143":{"tf":1}},"df":1},"docs":{"118":{"tf":1}},"df":1},"2":{"docs":{"119":{"tf":1}},"df":1},"3":{"docs":{"120":{"tf":1}},"df":1},"4":{"docs":{"124":{"tf":1}},"df":1},"5":{"docs":{"125":{"tf":1}},"df":1},"6":{"docs":{"126":{"tf":1}},"df":1},"7":{"docs":{"130":{"tf":1}},"df":1},"8":{"docs":{"131":{"tf":1}},"df":1},"9":{"docs":{"132":{"tf":1}},"df":1},"docs":{},"df":0}},"6":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"174":{"tf":1}},"df":1},"1":{"docs":{"175":{"tf":1}},"df":1},"docs":{"154":{"tf":1}},"df":1},"2":{"docs":{"155":{"tf":1}},"df":1},"3":{"docs":{"156":{"tf":1}},"df":1},"4":{"docs":{"158":{"tf":1}},"df":1},"5":{"docs":{"162":{"tf":1}},"df":1},"6":{"docs":{"163":{"tf":1}},"df":1},"7":{"docs":{"164":{"tf":1}},"df":1},"8":{"docs":{"168":{"tf":1}},"df":1},"9":{"docs":{"169":{"tf":1}},"df":1},"docs":{},"df":0}},"7":{"docs":{},"df":0,".":{"0":{"docs":{"111":{"tf":1}},"df":1},"1":{"docs":{"185":{"tf":1}},"df":1},"docs":{},"df":0}},"8":{"docs":{},"df":0,".":{"1":{"docs":{"199":{"tf":1}},"df":1},"2":{"docs":{"200":{"tf":1}},"df":1},"3":{"docs":{"201":{"tf":1}},"df":1},"4":{"docs":{"205":{"tf":1}},"df":1},"5":{"docs":{"206":{"tf":1}},"df":1},"docs":{},"df":0}},"9":{"9":{"9":{"9":{"9":{"docs":{"241":{"tf":1.4142135623730951}},"df":1},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"0":{"tf":1},"1":{"tf":1},"6":{"tf":1},"7":{"tf":1},"8":{"tf":1.4142135623730951},"9":{"tf":1},"10":{"tf":1},"11":{"tf":1},"12":{"tf":1},"13":{"tf":1},"17":{"tf":1},"18":{"tf":1},"21":{"tf":1.4142135623730951},"23":{"tf":1},"24":{"tf":1},"27":{"tf":1},"29":{"tf":1},"30":{"tf":1},"34":{"tf":1},"35":{"tf":1},"36":{"tf":1},"41":{"tf":1},"42":{"tf":1},"44":{"tf":1},"45":{"tf":1},"48":{"tf":1},"49":{"tf":1},"52":{"tf":1},"53":{"tf":1},"57":{"tf":1},"58":{"tf":1},"59":{"tf":1.4142135623730951},"60":{"tf":1},"61":{"tf":1},"67":{"tf":1},"68":{"tf":1},"69":{"tf":1},"75":{"tf":1},"76":{"tf":1},"78":{"tf":1},"79":{"tf":1},"83":{"tf":1},"84":{"tf":1},"85":{"tf":1},"86":{"tf":1},"87":{"tf":1},"88":{"tf":1},"91":{"tf":1},"92":{"tf":1},"99":{"tf":1},"100":{"tf":1},"102":{"tf":1},"103":{"tf":1},"104":{"tf":1},"105":{"tf":1},"106":{"tf":1},"109":{"tf":1},"110":{"tf":1},"112":{"tf":1},"113":{"tf":1},"114":{"tf":1},"115":{"tf":1},"116":{"tf":1},"121":{"tf":1},"122":{"tf":1},"127":{"tf":1},"128":{"tf":1},"133":{"tf":1},"134":{"tf":1},"139":{"tf":1},"140":{"tf":1},"145":{"tf":1},"146":{"tf":1},"148":{"tf":1},"149":{"tf":1},"150":{"tf":1},"151":{"tf":1},"152":{"tf":1},"159":{"tf":1},"160":{"tf":1},"165":{"tf":1},"166":{"tf":1},"171":{"tf":1},"172":{"tf":1},"176":{"tf":1},"177":{"tf":1},"179":{"tf":1},"180":{"tf":1},"181":{"tf":1},"182":{"tf":1},"183":{"tf":1},"186":{"tf":1},"187":{"tf":1},"193":{"tf":1},"194":{"tf":1},"195":{"tf":1},"196":{"tf":1},"197":{"tf":1},"202":{"tf":1},"203":{"tf":1},"207":{"tf":1},"208":{"tf":1},"209":{"tf":1},"210":{"tf":1},"211":{"tf":1},"213":{"tf":1},"214":{"tf":1},"229":{"tf":1},"230":{"tf":1},"256":{"tf":1},"257":{"tf":1}},"df":111,"e":{"docs":{},"df":0,"/":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"14":{"tf":1},"89":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":1},"234":{"tf":1},"242":{"tf":1},"246":{"tf":1}},"df":7,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"/":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{"212":{"tf":1},"215":{"tf":1},"227":{"tf":1.4142135623730951},"258":{"tf":1.4142135623730951},"259":{"tf":1},"261":{"tf":1}},"df":6}}}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"215":{"tf":1},"228":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"/":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{"63":{"tf":1}},"df":1}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"262":{"tf":1},"269":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"d":{"docs":{"184":{"tf":1}},"df":1}}}}}}}}}}},"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"3":{"tf":1}},"df":1}}},"e":{"docs":{"3":{"tf":1},"4":{"tf":1.4142135623730951},"8":{"tf":1},"19":{"tf":1},"51":{"tf":1},"93":{"tf":1},"94":{"tf":1},"117":{"tf":1},"129":{"tf":1},"163":{"tf":1.4142135623730951},"164":{"tf":1},"178":{"tf":1},"219":{"tf":1.4142135623730951},"228":{"tf":1},"233":{"tf":1},"239":{"tf":1},"241":{"tf":1.7320508075688772},"242":{"tf":1},"250":{"tf":1},"254":{"tf":1},"255":{"tf":1.7320508075688772},"262":{"tf":1},"274":{"tf":1},"286":{"tf":1},"287":{"tf":1},"289":{"tf":1.4142135623730951}},"df":26}},"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"86":{"tf":1}},"df":2}}}},"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1},"181":{"tf":1},"205":{"tf":1},"215":{"tf":1},"231":{"tf":1},"258":{"tf":1},"262":{"tf":1}},"df":7,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"⁠":{"docs":{},"df":0,"+":{"docs":{},"df":0,"⁠":{"docs":{},"df":0,"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"y":{"docs":{"4":{"tf":1}},"df":1}}}}}}}}}}},"e":{"docs":{"107":{"tf":1},"114":{"tf":1},"117":{"tf":1},"120":{"tf":1},"126":{"tf":1.7320508075688772},"135":{"tf":1.4142135623730951},"136":{"tf":1},"144":{"tf":1},"147":{"tf":1.7320508075688772},"162":{"tf":1},"168":{"tf":1},"175":{"tf":1},"178":{"tf":1.4142135623730951},"204":{"tf":2.23606797749979}},"df":14,"l":{"docs":{"26":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951},"73":{"tf":1},"74":{"tf":1},"107":{"tf":1},"108":{"tf":1}},"df":6}},"a":{"docs":{},"df":0,"l":{"docs":{"233":{"tf":1},"253":{"tf":1}},"df":2,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"254":{"tf":1}},"df":1}}}}}}}}}}}}}}},"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"4":{"tf":1}},"df":1}}}}},"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"40":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"s":{"docs":{"27":{"tf":1.4142135623730951},"43":{"tf":1},"72":{"tf":1},"73":{"tf":1},"81":{"tf":1},"86":{"tf":1},"94":{"tf":1.4142135623730951},"95":{"tf":1},"97":{"tf":1.4142135623730951},"107":{"tf":1.4142135623730951},"220":{"tf":1.4142135623730951},"235":{"tf":1},"247":{"tf":1},"262":{"tf":1},"272":{"tf":1},"275":{"tf":1}},"df":16}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"47":{"tf":1}},"df":1}}}},"v":{"docs":{},"df":0,"e":{"docs":{"80":{"tf":1.4142135623730951},"81":{"tf":1},"93":{"tf":1},"94":{"tf":1},"95":{"tf":1},"97":{"tf":1},"168":{"tf":1},"204":{"tf":1.4142135623730951},"218":{"tf":1},"235":{"tf":1.4142135623730951},"238":{"tf":1},"239":{"tf":1},"251":{"tf":1.4142135623730951},"265":{"tf":1},"266":{"tf":1}},"df":15}}},"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1},"4":{"tf":1},"15":{"tf":1.4142135623730951},"27":{"tf":1},"37":{"tf":1},"185":{"tf":1},"262":{"tf":1.7320508075688772},"272":{"tf":1},"280":{"tf":1}},"df":9,"l":{"docs":{},"df":0,"i":{"docs":{"15":{"tf":1},"120":{"tf":1}},"df":2}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"43":{"tf":1},"111":{"tf":1},"259":{"tf":1}},"df":3}},"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"86":{"tf":1},"178":{"tf":1},"219":{"tf":1},"259":{"tf":1.7320508075688772}},"df":4}}}}}},"s":{"docs":{},"df":0,"s":{"docs":{"3":{"tf":1}},"df":1}},"c":{"docs":{},"df":0,"o":{"docs":{"3":{"tf":1},"114":{"tf":1},"117":{"tf":1},"119":{"tf":1}},"df":4}},"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"8":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"28":{"tf":1},"43":{"tf":1.7320508075688772},"93":{"tf":1.4142135623730951},"104":{"tf":1},"111":{"tf":1},"114":{"tf":1},"175":{"tf":1},"178":{"tf":1},"181":{"tf":1.4142135623730951},"204":{"tf":1},"209":{"tf":1},"228":{"tf":1},"233":{"tf":1},"255":{"tf":1.4142135623730951},"258":{"tf":1},"270":{"tf":1},"274":{"tf":1},"289":{"tf":1}},"df":21}}},"a":{"docs":{},"df":0,"g":{"docs":{"55":{"tf":1},"111":{"tf":1},"233":{"tf":1.4142135623730951},"241":{"tf":1}},"df":4}},"i":{"docs":{"86":{"tf":1},"181":{"tf":1},"204":{"tf":1},"241":{"tf":1}},"df":4}},"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"4":{"tf":1},"204":{"tf":1.4142135623730951}},"df":2}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"241":{"tf":1}},"df":1}}}},"k":{"docs":{},"df":0,"e":{"docs":{"8":{"tf":1},"66":{"tf":1},"86":{"tf":1},"89":{"tf":1},"90":{"tf":1},"93":{"tf":1},"123":{"tf":1},"147":{"tf":1},"154":{"tf":1},"162":{"tf":1},"178":{"tf":1},"181":{"tf":1},"204":{"tf":1.4142135623730951},"223":{"tf":1},"225":{"tf":1},"233":{"tf":1},"234":{"tf":1},"236":{"tf":1},"238":{"tf":1},"250":{"tf":1},"259":{"tf":1},"281":{"tf":1}},"df":22}},"j":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"11":{"tf":1},"216":{"tf":1}},"df":2}}},"r":{"docs":{},"df":0,"k":{"docs":{"21":{"tf":1},"101":{"tf":1},"137":{"tf":1},"143":{"tf":1}},"df":4,"e":{"docs":{},"df":0,"r":{"docs":{"111":{"tf":1},"123":{"tf":1}},"df":2}}}},"d":{"docs":{},"df":0,"e":{"docs":{"129":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1},"14":{"tf":1},"27":{"tf":1},"56":{"tf":1},"86":{"tf":1},"199":{"tf":1},"201":{"tf":1},"204":{"tf":1},"233":{"tf":1}},"df":9,"t":{"docs":{"4":{"tf":1},"272":{"tf":1}},"df":2}}},"n":{"docs":{},"df":0,"u":{"docs":{"4":{"tf":1.7320508075688772},"21":{"tf":1},"26":{"tf":1},"37":{"tf":1},"43":{"tf":1.7320508075688772},"62":{"tf":1},"77":{"tf":1},"80":{"tf":1},"81":{"tf":1},"94":{"tf":1.4142135623730951},"95":{"tf":1},"101":{"tf":1},"114":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"126":{"tf":1.7320508075688772},"135":{"tf":1.7320508075688772},"141":{"tf":1},"144":{"tf":1},"154":{"tf":1},"163":{"tf":1},"164":{"tf":1.4142135623730951},"168":{"tf":1.7320508075688772},"170":{"tf":1},"173":{"tf":1},"178":{"tf":1},"181":{"tf":1},"204":{"tf":2.23606797749979},"209":{"tf":1},"241":{"tf":2.8284271247461903},"251":{"tf":1},"265":{"tf":1},"267":{"tf":1}},"df":32,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"265":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"101":{"tf":1},"235":{"tf":1}},"df":2}}}}},"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"15":{"tf":1},"39":{"tf":1},"56":{"tf":1},"138":{"tf":1.4142135623730951},"141":{"tf":1.7320508075688772},"162":{"tf":1.4142135623730951},"190":{"tf":1},"204":{"tf":1},"206":{"tf":1}},"df":9}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"40":{"tf":1},"190":{"tf":1}},"df":2}}}},"t":{"docs":{"201":{"tf":1}},"df":1,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{"164":{"tf":1},"168":{"tf":1},"173":{"tf":1},"204":{"tf":1}},"df":4}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{"185":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"t":{"docs":{"272":{"tf":1},"284":{"tf":1}},"df":2}}},"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"l":{"docs":{"56":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"69":{"tf":1}},"df":1}}}},"s":{"docs":{},"df":0,"s":{"docs":{"164":{"tf":1}},"df":1},"c":{"docs":{"173":{"tf":1}},"df":1},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"k":{"docs":{"233":{"tf":1}},"df":1}}}},"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{"259":{"tf":1}},"df":1}},"d":{"docs":{"280":{"tf":1}},"df":1}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"101":{"tf":1}},"df":1}},"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"163":{"tf":1},"178":{"tf":1.7320508075688772}},"df":2}}}}}},"y":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"271":{"tf":1},"275":{"tf":1},"280":{"tf":1},"284":{"tf":1}},"df":4}}}}}}}}}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"271":{"tf":1},"272":{"tf":1},"277":{"tf":1},"282":{"tf":1},"283":{"tf":1},"285":{"tf":1}},"df":6,"e":{"docs":{},"df":0,"s":{"1":{"docs":{"277":{"tf":1}},"df":1},"docs":{},"df":0}}}}}}}}}}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"0":{"tf":1},"1":{"tf":1},"4":{"tf":2.23606797749979},"5":{"tf":1},"6":{"tf":1},"7":{"tf":1},"8":{"tf":1.4142135623730951},"9":{"tf":1},"10":{"tf":1},"12":{"tf":1},"13":{"tf":1},"14":{"tf":1},"17":{"tf":1},"18":{"tf":1},"21":{"tf":1},"23":{"tf":1},"24":{"tf":1},"29":{"tf":1},"30":{"tf":1},"35":{"tf":1},"36":{"tf":1},"41":{"tf":1},"42":{"tf":1},"43":{"tf":1.7320508075688772},"44":{"tf":1},"45":{"tf":1},"48":{"tf":1},"49":{"tf":1},"51":{"tf":1},"52":{"tf":1},"53":{"tf":1},"57":{"tf":1},"58":{"tf":1},"59":{"tf":1},"60":{"tf":1},"61":{"tf":1},"67":{"tf":1},"68":{"tf":1},"75":{"tf":1},"76":{"tf":1},"78":{"tf":1},"79":{"tf":1},"84":{"tf":1},"85":{"tf":1},"87":{"tf":1},"88":{"tf":1},"91":{"tf":1},"92":{"tf":1},"99":{"tf":1},"100":{"tf":1},"102":{"tf":1},"103":{"tf":1},"105":{"tf":1},"106":{"tf":1},"109":{"tf":1},"110":{"tf":1},"112":{"tf":1},"113":{"tf":1},"115":{"tf":1},"116":{"tf":1},"121":{"tf":1},"122":{"tf":1},"127":{"tf":1},"128":{"tf":1},"133":{"tf":1},"134":{"tf":1},"139":{"tf":1},"140":{"tf":1},"145":{"tf":1},"146":{"tf":1},"147":{"tf":1},"148":{"tf":1},"149":{"tf":1},"151":{"tf":1},"152":{"tf":1},"159":{"tf":1},"160":{"tf":1},"162":{"tf":1},"165":{"tf":1},"166":{"tf":1},"171":{"tf":1},"172":{"tf":1},"176":{"tf":1},"177":{"tf":1},"179":{"tf":1},"180":{"tf":1},"182":{"tf":1},"183":{"tf":1},"186":{"tf":1},"187":{"tf":1},"193":{"tf":1},"194":{"tf":1},"195":{"tf":1},"196":{"tf":1},"197":{"tf":1},"202":{"tf":1},"203":{"tf":1},"207":{"tf":1},"208":{"tf":1},"209":{"tf":1.7320508075688772},"210":{"tf":1},"211":{"tf":1},"212":{"tf":1.4142135623730951},"213":{"tf":1},"214":{"tf":1},"229":{"tf":1},"230":{"tf":1},"256":{"tf":1},"257":{"tf":1}},"df":109}}}},"r":{"docs":{},"df":0,"n":{"docs":{"81":{"tf":1},"154":{"tf":1},"204":{"tf":1},"209":{"tf":1}},"df":4}}},"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"28":{"tf":1},"55":{"tf":1},"178":{"tf":1}},"df":4,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"14":{"tf":1},"21":{"tf":1},"37":{"tf":1},"38":{"tf":1},"170":{"tf":1},"204":{"tf":1}},"df":6}}}}},"p":{"docs":{"56":{"tf":1.4142135623730951},"163":{"tf":1},"168":{"tf":1},"169":{"tf":1},"204":{"tf":1.4142135623730951},"283":{"tf":1}},"df":6,"i":{"docs":{},"df":0,"c":{"docs":{"4":{"tf":1},"43":{"tf":1},"162":{"tf":1},"212":{"tf":1.4142135623730951}},"df":4}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"77":{"tf":1}},"df":1}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{"126":{"tf":1},"217":{"tf":1}},"df":2}}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"259":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"1":{"docs":{"241":{"tf":1.7320508075688772}},"df":1},"2":{"docs":{"241":{"tf":1.7320508075688772}},"df":1},"docs":{"3":{"tf":3.4641016151377544},"4":{"tf":3.605551275463989},"8":{"tf":2},"11":{"tf":1.4142135623730951},"14":{"tf":2.23606797749979},"15":{"tf":3},"16":{"tf":1.4142135623730951},"19":{"tf":1},"21":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":2},"27":{"tf":3.3166247903554},"31":{"tf":2},"32":{"tf":2},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"40":{"tf":1},"50":{"tf":2.449489742783178},"51":{"tf":2.6457513110645907},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"59":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772},"63":{"tf":1},"65":{"tf":1},"66":{"tf":1},"74":{"tf":1},"80":{"tf":3.7416573867739413},"81":{"tf":3},"83":{"tf":1},"86":{"tf":2.23606797749979},"89":{"tf":2.23606797749979},"90":{"tf":1.4142135623730951},"94":{"tf":1},"95":{"tf":1},"97":{"tf":2.449489742783178},"98":{"tf":1.4142135623730951},"101":{"tf":2},"107":{"tf":1},"111":{"tf":2},"114":{"tf":1.4142135623730951},"117":{"tf":1.7320508075688772},"118":{"tf":1.4142135623730951},"119":{"tf":1},"120":{"tf":1.7320508075688772},"123":{"tf":2},"126":{"tf":3.4641016151377544},"129":{"tf":2},"130":{"tf":1},"132":{"tf":1},"135":{"tf":1.7320508075688772},"136":{"tf":2.23606797749979},"141":{"tf":1.4142135623730951},"142":{"tf":1},"143":{"tf":1.7320508075688772},"144":{"tf":1.4142135623730951},"147":{"tf":2.8284271247461903},"153":{"tf":1.4142135623730951},"154":{"tf":1.4142135623730951},"155":{"tf":1},"158":{"tf":1.4142135623730951},"161":{"tf":1.7320508075688772},"162":{"tf":1.4142135623730951},"163":{"tf":1},"164":{"tf":1},"167":{"tf":1.7320508075688772},"168":{"tf":2},"173":{"tf":1.7320508075688772},"174":{"tf":1.4142135623730951},"175":{"tf":1.7320508075688772},"178":{"tf":3.7416573867739413},"181":{"tf":2.6457513110645907},"185":{"tf":1},"190":{"tf":1},"192":{"tf":1},"201":{"tf":1.4142135623730951},"204":{"tf":4.242640687119285},"205":{"tf":1.4142135623730951},"206":{"tf":1},"209":{"tf":1.4142135623730951},"212":{"tf":1},"215":{"tf":2.8284271247461903},"216":{"tf":3},"217":{"tf":2.8284271247461903},"218":{"tf":3.1622776601683795},"219":{"tf":3},"220":{"tf":2.6457513110645907},"221":{"tf":2.23606797749979},"222":{"tf":3},"223":{"tf":1},"224":{"tf":2},"225":{"tf":2},"226":{"tf":1.4142135623730951},"227":{"tf":3.1622776601683795},"228":{"tf":3.3166247903554},"231":{"tf":2.6457513110645907},"232":{"tf":2.449489742783178},"233":{"tf":4.358898943540674},"234":{"tf":2.23606797749979},"235":{"tf":1.7320508075688772},"236":{"tf":2.23606797749979},"237":{"tf":2.8284271247461903},"238":{"tf":3.1622776601683795},"239":{"tf":3.1622776601683795},"240":{"tf":1},"241":{"tf":4},"242":{"tf":4.358898943540674},"243":{"tf":2.8284271247461903},"244":{"tf":1.4142135623730951},"246":{"tf":2.23606797749979},"247":{"tf":2},"248":{"tf":2},"250":{"tf":3.3166247903554},"251":{"tf":1.7320508075688772},"252":{"tf":2.449489742783178},"254":{"tf":1},"255":{"tf":1.4142135623730951},"258":{"tf":2},"259":{"tf":4.242640687119285},"260":{"tf":1.4142135623730951},"261":{"tf":1.7320508075688772},"262":{"tf":2.449489742783178},"265":{"tf":1.4142135623730951},"266":{"tf":1.4142135623730951},"267":{"tf":1.4142135623730951},"271":{"tf":1.4142135623730951},"272":{"tf":1},"275":{"tf":1},"277":{"tf":1},"280":{"tf":1},"286":{"tf":1.4142135623730951},"288":{"tf":1}},"df":136,"e":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"70":{"tf":1.4142135623730951}},"df":2},"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"253":{"tf":1}},"df":1}}}}}},".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"175":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"241":{"tf":1.7320508075688772}},"df":1}}}}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"8":{"tf":1},"21":{"tf":1},"212":{"tf":1}},"df":5}}}},"i":{"docs":{},"df":0,"c":{"docs":{"3":{"tf":1.4142135623730951}},"df":1},"q":{"docs":{},"df":0,"u":{"docs":{"135":{"tf":1}},"df":1}}}}}},"r":{"docs":{},"df":0,"m":{"docs":{"19":{"tf":1}},"df":1,"i":{"docs":{},"df":0,"n":{"docs":{"15":{"tf":1},"47":{"tf":1.4142135623730951},"178":{"tf":1}},"df":3}}}},"l":{"docs":{},"df":0,"l":{"docs":{"33":{"tf":1},"40":{"tf":1},"157":{"tf":1.4142135623730951},"173":{"tf":1}},"df":4}},"a":{"docs":{},"df":0,"m":{"docs":{"43":{"tf":1.4142135623730951}},"df":1}},"x":{"docs":{},"df":0,"t":{"docs":{"70":{"tf":1.4142135623730951},"77":{"tf":1.7320508075688772},"107":{"tf":1},"108":{"tf":2},"141":{"tf":1.4142135623730951},"142":{"tf":1.4142135623730951},"143":{"tf":1},"154":{"tf":1},"155":{"tf":1},"156":{"tf":1.4142135623730951},"157":{"tf":2.23606797749979},"158":{"tf":1},"161":{"tf":1},"173":{"tf":1},"175":{"tf":1},"191":{"tf":1},"204":{"tf":1.4142135623730951},"224":{"tf":1},"265":{"tf":1.7320508075688772},"272":{"tf":3.4641016151377544},"273":{"tf":1},"274":{"tf":1},"277":{"tf":2.449489742783178},"278":{"tf":1},"279":{"tf":1},"280":{"tf":2.23606797749979},"284":{"tf":2.23606797749979},"286":{"tf":1.7320508075688772},"287":{"tf":1}},"df":29}},"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"272":{"tf":2},"274":{"tf":1.4142135623730951},"281":{"tf":1}},"df":3}}}}}},"h":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{"3":{"tf":1},"4":{"tf":1.4142135623730951},"50":{"tf":1},"114":{"tf":1},"123":{"tf":1},"136":{"tf":1},"255":{"tf":1}},"df":7,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"43":{"tf":1},"147":{"tf":1}},"df":3}}}}}},"w":{"docs":{"252":{"tf":1.4142135623730951}},"df":1}},"e":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1.7320508075688772},"55":{"tf":1},"56":{"tf":1},"94":{"tf":1},"95":{"tf":1},"97":{"tf":1},"216":{"tf":1},"218":{"tf":1.4142135623730951},"221":{"tf":1},"226":{"tf":1},"232":{"tf":1},"234":{"tf":1},"238":{"tf":1.4142135623730951}},"df":13}}},"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1},"104":{"tf":1},"114":{"tf":1},"209":{"tf":1},"216":{"tf":1},"217":{"tf":1},"218":{"tf":1},"224":{"tf":1},"242":{"tf":1},"253":{"tf":1},"259":{"tf":1},"260":{"tf":1},"262":{"tf":1},"265":{"tf":1.4142135623730951},"270":{"tf":1},"272":{"tf":1.7320508075688772},"280":{"tf":1.7320508075688772}},"df":17}},"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{"164":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"32":{"tf":1},"95":{"tf":1},"221":{"tf":1},"239":{"tf":1.4142135623730951}},"df":4},"t":{"docs":{},"df":0,"i":{"docs":{"259":{"tf":1}},"df":1}}},"n":{"docs":{},"df":0,"k":{"docs":{"274":{"tf":1}},"df":1}}},"u":{"docs":{"86":{"tf":1},"108":{"tf":1},"201":{"tf":1},"216":{"tf":1}},"df":4},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"147":{"tf":1},"162":{"tf":1},"167":{"tf":1},"201":{"tf":1},"221":{"tf":1},"222":{"tf":1},"235":{"tf":1},"277":{"tf":1},"280":{"tf":1},"284":{"tf":1}},"df":10}}}}},"\"":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"167":{"tf":1}},"df":1}}}}}}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"101":{"tf":1},"204":{"tf":1.4142135623730951}},"df":2}}},"e":{"docs":{},"df":0,"r":{"docs":{"189":{"tf":1.4142135623730951}},"df":1}}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"217":{"tf":1},"218":{"tf":1},"219":{"tf":1}},"df":3}}}},"e":{"docs":{},"df":0,"e":{"docs":{"15":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"73":{"tf":1},"82":{"tf":1},"241":{"tf":1}},"df":6}},"i":{"docs":{"21":{"tf":1},"66":{"tf":1},"71":{"tf":1},"72":{"tf":1},"81":{"tf":1},"108":{"tf":1},"168":{"tf":1},"250":{"tf":1},"251":{"tf":2},"253":{"tf":1}},"df":10,"g":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"114":{"tf":1},"247":{"tf":1}},"df":2}}}}},"u":{"docs":{},"df":0,"e":{"docs":{"199":{"tf":1},"201":{"tf":1.4142135623730951},"204":{"tf":2}},"df":3}}},"w":{"docs":{},"df":0,"o":{"docs":{"15":{"tf":1},"20":{"tf":1},"21":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772},"86":{"tf":1},"89":{"tf":1},"90":{"tf":1},"107":{"tf":1},"136":{"tf":1},"153":{"tf":1},"154":{"tf":1},"167":{"tf":1},"168":{"tf":1},"169":{"tf":1},"195":{"tf":1.4142135623730951},"204":{"tf":1},"217":{"tf":1.4142135623730951},"224":{"tf":1},"237":{"tf":1},"241":{"tf":1},"242":{"tf":1},"259":{"tf":1.7320508075688772}},"df":22},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{"154":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"21":{"tf":1},"33":{"tf":1},"38":{"tf":1},"39":{"tf":1.4142135623730951},"40":{"tf":1},"71":{"tf":1},"86":{"tf":1},"120":{"tf":1},"141":{"tf":1.4142135623730951},"155":{"tf":1},"169":{"tf":1},"178":{"tf":1},"190":{"tf":1.7320508075688772},"204":{"tf":2},"206":{"tf":1},"209":{"tf":1.7320508075688772},"238":{"tf":1.4142135623730951},"239":{"tf":1},"255":{"tf":1},"259":{"tf":1},"267":{"tf":1},"277":{"tf":1}},"df":22,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"242":{"tf":1}},"df":1}}}}},"p":{"docs":{"28":{"tf":1},"43":{"tf":1}},"df":2},"c":{"docs":{},"df":0,"k":{"docs":{"173":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"b":{"docs":{"26":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"204":{"tf":1},"265":{"tf":1}},"df":4,"l":{"docs":{"72":{"tf":1},"104":{"tf":1},"107":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"114":{"tf":1.7320508075688772},"141":{"tf":1},"155":{"tf":1},"157":{"tf":1},"161":{"tf":1},"162":{"tf":1.4142135623730951},"163":{"tf":1.7320508075688772},"164":{"tf":1},"167":{"tf":2.23606797749979},"168":{"tf":2.8284271247461903},"169":{"tf":1.4142135623730951},"173":{"tf":1},"175":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"201":{"tf":1},"204":{"tf":1.7320508075688772},"220":{"tf":2.23606797749979},"221":{"tf":1.4142135623730951},"222":{"tf":1},"223":{"tf":1},"224":{"tf":1},"225":{"tf":1},"264":{"tf":1},"265":{"tf":1}},"df":28},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{"265":{"tf":1}},"df":1}}}}}}},"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"27":{"tf":1},"73":{"tf":1},"277":{"tf":1}},"df":3}}}},"k":{"docs":{},"df":0,"e":{"docs":{"43":{"tf":1},"89":{"tf":1},"107":{"tf":1},"153":{"tf":1},"184":{"tf":1},"188":{"tf":1},"212":{"tf":1},"215":{"tf":1},"231":{"tf":1},"232":{"tf":1},"233":{"tf":1},"239":{"tf":1},"241":{"tf":1},"243":{"tf":1},"258":{"tf":1},"259":{"tf":1},"263":{"tf":1},"269":{"tf":1},"286":{"tf":1},"289":{"tf":1}},"df":20,"n":{"docs":{"39":{"tf":1},"141":{"tf":1},"169":{"tf":1},"270":{"tf":1}},"df":4}}},"s":{"docs":{},"df":0,"k":{"docs":{"181":{"tf":1}},"df":1}},"g":{"docs":{"282":{"tf":1}},"df":1}},"y":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{"27":{"tf":1},"43":{"tf":1},"55":{"tf":1},"63":{"tf":1},"70":{"tf":1.4142135623730951},"107":{"tf":1},"108":{"tf":1},"181":{"tf":1},"204":{"tf":1.4142135623730951},"220":{"tf":1},"280":{"tf":1.4142135623730951}},"df":11},"i":{"docs":{},"df":0,"c":{"docs":{"178":{"tf":1},"232":{"tf":1},"265":{"tf":1}},"df":3}}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{"218":{"tf":1},"219":{"tf":1},"233":{"tf":1}},"df":3,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"2":{"tf":1}},"df":1}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"8":{"tf":1},"55":{"tf":1},"56":{"tf":1},"141":{"tf":1},"204":{"tf":1}},"df":6}}},"s":{"docs":{"14":{"tf":1},"32":{"tf":1},"37":{"tf":1.7320508075688772},"38":{"tf":1},"43":{"tf":1},"55":{"tf":1},"63":{"tf":1},"65":{"tf":1},"66":{"tf":1},"70":{"tf":1},"72":{"tf":1.4142135623730951},"74":{"tf":1},"77":{"tf":1},"93":{"tf":1},"94":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"119":{"tf":1},"130":{"tf":1},"143":{"tf":1},"144":{"tf":1},"147":{"tf":1.7320508075688772},"154":{"tf":1},"155":{"tf":1.4142135623730951},"157":{"tf":1},"162":{"tf":1},"170":{"tf":1},"204":{"tf":2},"221":{"tf":1},"238":{"tf":1},"241":{"tf":3},"262":{"tf":2.449489742783178},"265":{"tf":1},"275":{"tf":1.7320508075688772},"280":{"tf":1.4142135623730951}},"df":35}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"51":{"tf":1},"219":{"tf":1},"231":{"tf":1.4142135623730951},"233":{"tf":2},"234":{"tf":1},"237":{"tf":1},"240":{"tf":1},"241":{"tf":2}},"df":9}}}}}}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{"86":{"tf":1},"136":{"tf":1},"154":{"tf":1},"163":{"tf":1},"167":{"tf":1},"222":{"tf":1},"241":{"tf":1},"242":{"tf":1},"243":{"tf":1},"250":{"tf":1},"255":{"tf":1},"269":{"tf":1},"277":{"tf":1},"280":{"tf":1},"282":{"tf":1},"289":{"tf":1}},"df":16,"s":{"docs":{"81":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"233":{"tf":1}},"df":1}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"126":{"tf":1},"244":{"tf":1}},"df":2}}},"i":{"docs":{"157":{"tf":1.4142135623730951}},"df":1}},"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1}},"df":1}}}}}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"4":{"tf":1.4142135623730951},"137":{"tf":1},"181":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951},"212":{"tf":1},"215":{"tf":1},"228":{"tf":1},"233":{"tf":1}},"df":9}},"e":{"docs":{"26":{"tf":1},"43":{"tf":1},"55":{"tf":1}},"df":3,"n":{"docs":{"101":{"tf":1}},"df":1}}},"c":{"docs":{},"df":0,"e":{"docs":{"262":{"tf":1},"275":{"tf":1}},"df":2,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"86":{"tf":2.23606797749979},"90":{"tf":1},"93":{"tf":3.605551275463989},"94":{"tf":1.7320508075688772},"95":{"tf":2},"96":{"tf":2.23606797749979},"97":{"tf":2.8284271247461903},"98":{"tf":1.4142135623730951},"101":{"tf":2.8284271247461903},"150":{"tf":1.7320508075688772},"153":{"tf":1},"154":{"tf":2.8284271247461903},"155":{"tf":2.8284271247461903},"156":{"tf":1},"157":{"tf":1},"161":{"tf":1.7320508075688772},"162":{"tf":2.8284271247461903},"163":{"tf":2.8284271247461903},"164":{"tf":1.4142135623730951},"167":{"tf":2.449489742783178},"168":{"tf":3.7416573867739413},"169":{"tf":1.4142135623730951},"173":{"tf":1},"174":{"tf":2},"175":{"tf":1.7320508075688772},"178":{"tf":3.4641016151377544},"181":{"tf":2.23606797749979},"184":{"tf":1},"185":{"tf":1.7320508075688772},"188":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"190":{"tf":1.4142135623730951},"191":{"tf":2.23606797749979},"192":{"tf":1.4142135623730951},"200":{"tf":1},"204":{"tf":2.8284271247461903},"209":{"tf":1.4142135623730951},"222":{"tf":1},"223":{"tf":1},"227":{"tf":1.7320508075688772},"233":{"tf":1},"237":{"tf":1},"238":{"tf":1.7320508075688772},"239":{"tf":1},"251":{"tf":1.4142135623730951},"253":{"tf":1.4142135623730951},"258":{"tf":1.7320508075688772},"259":{"tf":2.449489742783178},"260":{"tf":1},"261":{"tf":1},"262":{"tf":3},"263":{"tf":1.4142135623730951},"264":{"tf":1},"265":{"tf":4.58257569495584},"266":{"tf":1.4142135623730951},"267":{"tf":1.4142135623730951},"270":{"tf":1.4142135623730951},"272":{"tf":3.3166247903554},"273":{"tf":1.4142135623730951},"274":{"tf":2.23606797749979},"275":{"tf":2},"276":{"tf":1},"277":{"tf":2.449489742783178},"278":{"tf":1},"279":{"tf":1},"280":{"tf":4.69041575982343},"281":{"tf":2},"282":{"tf":1.7320508075688772},"283":{"tf":1.4142135623730951},"284":{"tf":1.7320508075688772},"285":{"tf":1.7320508075688772},"286":{"tf":2.23606797749979},"287":{"tf":2},"288":{"tf":1},"289":{"tf":1}},"df":77}}},"s":{"docs":{},"df":0,"s":{"docs":{"21":{"tf":1},"47":{"tf":1.4142135623730951},"55":{"tf":1},"163":{"tf":1},"204":{"tf":1},"277":{"tf":1}},"df":6}}},"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"262":{"tf":1.4142135623730951},"265":{"tf":1},"270":{"tf":1.4142135623730951},"289":{"tf":1}},"df":4,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"262":{"tf":1},"269":{"tf":1}},"df":2}}}}}}}}}}}}}}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"4":{"tf":1},"82":{"tf":1},"83":{"tf":1},"129":{"tf":1},"209":{"tf":1}},"df":5}}}},"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"14":{"tf":1}},"df":1}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"51":{"tf":1}},"df":1,"t":{"docs":{},"df":0,"i":{"docs":{"38":{"tf":1},"55":{"tf":1},"80":{"tf":1},"126":{"tf":1}},"df":4}}}}},"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"38":{"tf":1},"114":{"tf":1.4142135623730951},"137":{"tf":1},"141":{"tf":1},"233":{"tf":1}},"df":5}}}},"j":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"215":{"tf":1},"231":{"tf":1},"232":{"tf":1},"234":{"tf":1},"238":{"tf":1},"241":{"tf":1},"246":{"tf":1},"253":{"tf":1},"254":{"tf":1},"258":{"tf":1},"259":{"tf":1},"261":{"tf":1},"272":{"tf":1}},"df":13}}}}},"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1}},"df":1}}},"c":{"docs":{},"df":0,"e":{"docs":{"26":{"tf":1.4142135623730951},"39":{"tf":1},"77":{"tf":1},"153":{"tf":1},"154":{"tf":1},"155":{"tf":2},"157":{"tf":1.7320508075688772},"162":{"tf":1.7320508075688772},"164":{"tf":1},"168":{"tf":1},"216":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951},"241":{"tf":2.449489742783178}},"df":13}},"n":{"docs":{},"df":0,"t":{"docs":{"190":{"tf":1.4142135623730951}},"df":1,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"190":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"190":{"tf":1}},"df":1}}}}}}}}}},"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1}},"df":1},"i":{"docs":{},"df":0,"t":{"docs":{"5":{"tf":1},"56":{"tf":1},"80":{"tf":1},"111":{"tf":1},"117":{"tf":1},"129":{"tf":1},"144":{"tf":1.4142135623730951}},"df":7}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"111":{"tf":1},"228":{"tf":1}},"df":2}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"54":{"tf":1},"123":{"tf":1},"129":{"tf":1},"168":{"tf":1},"204":{"tf":1},"274":{"tf":1}},"df":6,"e":{"docs":{},"df":0,"r":{"docs":{"21":{"tf":1}},"df":1}}}}},"p":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"114":{"tf":1},"120":{"tf":1},"163":{"tf":1},"164":{"tf":1.4142135623730951},"168":{"tf":1},"204":{"tf":1.7320508075688772}},"df":6}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"189":{"tf":1}},"df":1}}}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"3":{"tf":1.4142135623730951}},"df":1}}}}},"c":{"docs":{},"df":0,"e":{"docs":{"43":{"tf":1},"95":{"tf":1},"101":{"tf":1},"157":{"tf":1},"233":{"tf":1},"252":{"tf":1},"274":{"tf":1.4142135623730951},"275":{"tf":1},"277":{"tf":1}},"df":9,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"280":{"tf":1}},"df":1}}}}}},"y":{"docs":{"74":{"tf":1}},"df":1,"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"80":{"tf":1}},"df":1}}}}}},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"178":{"tf":1}},"df":1}}}}},"n":{"docs":{"241":{"tf":1}},"df":1}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{"3":{"tf":1},"5":{"tf":1},"8":{"tf":1},"14":{"tf":1},"37":{"tf":1},"38":{"tf":1},"50":{"tf":1},"54":{"tf":1},"62":{"tf":1},"65":{"tf":1},"89":{"tf":1},"123":{"tf":1},"126":{"tf":1},"135":{"tf":1},"162":{"tf":1},"164":{"tf":1},"167":{"tf":1},"181":{"tf":1},"204":{"tf":1.4142135623730951},"209":{"tf":1},"215":{"tf":1},"231":{"tf":1},"232":{"tf":1},"234":{"tf":1},"236":{"tf":1.4142135623730951},"239":{"tf":1},"246":{"tf":1},"248":{"tf":1},"251":{"tf":1},"258":{"tf":1},"261":{"tf":1},"262":{"tf":1.4142135623730951},"263":{"tf":1},"269":{"tf":1},"271":{"tf":1},"272":{"tf":1.4142135623730951},"275":{"tf":1},"285":{"tf":1},"289":{"tf":1}},"df":39}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1.7320508075688772},"8":{"tf":1},"15":{"tf":1},"89":{"tf":1},"108":{"tf":1},"181":{"tf":1.4142135623730951},"204":{"tf":1},"209":{"tf":1},"212":{"tf":1.4142135623730951},"220":{"tf":1},"222":{"tf":1},"241":{"tf":1},"259":{"tf":1},"272":{"tf":1},"283":{"tf":1}},"df":15},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"150":{"tf":1.4142135623730951},"155":{"tf":2.23606797749979},"162":{"tf":1},"163":{"tf":1},"164":{"tf":2},"167":{"tf":1},"168":{"tf":1.4142135623730951},"173":{"tf":1},"175":{"tf":1},"178":{"tf":2.8284271247461903},"192":{"tf":1.4142135623730951},"204":{"tf":1},"223":{"tf":1},"224":{"tf":1},"273":{"tf":1},"274":{"tf":1},"277":{"tf":1.4142135623730951},"284":{"tf":1.4142135623730951},"286":{"tf":2.23606797749979},"287":{"tf":1.7320508075688772},"288":{"tf":1}},"df":21,"r":{"docs":{"262":{"tf":1}},"df":1}}}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"h":{"docs":{"216":{"tf":1}},"df":1}}}}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1}},"df":1}}}},"h":{"docs":{"181":{"tf":1.4142135623730951},"262":{"tf":1},"275":{"tf":1}},"df":3}},"i":{"docs":{},"df":0,"r":{"docs":{"15":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"e":{"docs":{"43":{"tf":1}},"df":1,"l":{"docs":{"175":{"tf":1},"265":{"tf":1.4142135623730951},"266":{"tf":1},"267":{"tf":1.4142135623730951},"272":{"tf":1},"280":{"tf":1}},"df":6}},"i":{"docs":{},"df":0,"c":{"docs":{"114":{"tf":1},"147":{"tf":1}},"df":2}}},"g":{"docs":{},"df":0,"e":{"docs":{"63":{"tf":1}},"df":1}},"s":{"docs":{},"df":0,"s":{"docs":{"155":{"tf":1},"163":{"tf":1},"164":{"tf":1},"178":{"tf":1},"192":{"tf":1.4142135623730951},"237":{"tf":1},"238":{"tf":1}},"df":7,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"70":{"tf":1}},"df":1}}}}},"t":{"docs":{"168":{"tf":1},"235":{"tf":1}},"df":2}},"c":{"docs":{},"df":0,"k":{"docs":{"204":{"tf":2.449489742783178}},"df":1,"a":{"docs":{},"df":0,"g":{"docs":{"86":{"tf":1.4142135623730951},"185":{"tf":1.7320508075688772},"188":{"tf":1.4142135623730951},"189":{"tf":1.7320508075688772},"190":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"204":{"tf":1.7320508075688772},"239":{"tf":1},"242":{"tf":1},"258":{"tf":1},"262":{"tf":2.449489742783178},"263":{"tf":1},"264":{"tf":2.23606797749979},"265":{"tf":3.605551275463989},"266":{"tf":1.7320508075688772},"270":{"tf":2.6457513110645907},"271":{"tf":1},"272":{"tf":2.6457513110645907},"277":{"tf":2},"280":{"tf":2.23606797749979},"283":{"tf":1},"285":{"tf":1}},"df":23,"e":{"docs":{},"df":0,"'":{"docs":{"272":{"tf":1}},"df":1}}}}}},"u":{"docs":{},"df":0,"s":{"docs":{"114":{"tf":1.4142135623730951},"117":{"tf":1.4142135623730951},"123":{"tf":1},"126":{"tf":1},"130":{"tf":1.4142135623730951},"137":{"tf":1},"143":{"tf":1.4142135623730951},"144":{"tf":1},"147":{"tf":2},"169":{"tf":1},"204":{"tf":1}},"df":11}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{"16":{"tf":1},"56":{"tf":1},"81":{"tf":1},"117":{"tf":1},"178":{"tf":1.4142135623730951},"272":{"tf":1}},"df":6}}}},"t":{"docs":{"157":{"tf":1},"224":{"tf":1},"227":{"tf":1},"244":{"tf":1}},"df":4},"l":{"docs":{},"df":0,"l":{"docs":{"189":{"tf":1}},"df":1}},"s":{"docs":{},"df":0,"h":{"docs":{"189":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"r":{"docs":{"217":{"tf":1},"227":{"tf":1},"272":{"tf":1}},"df":3,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"21":{"tf":1},"26":{"tf":1},"51":{"tf":1},"71":{"tf":1},"97":{"tf":1},"126":{"tf":1.4142135623730951},"167":{"tf":1},"178":{"tf":1},"191":{"tf":1},"231":{"tf":1},"243":{"tf":1.4142135623730951},"255":{"tf":1},"258":{"tf":1},"262":{"tf":1.7320508075688772},"271":{"tf":1},"275":{"tf":1},"280":{"tf":1}},"df":17}}}},"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"81":{"tf":1}},"df":1},"s":{"docs":{},"df":0,"s":{"docs":{"189":{"tf":1}},"df":1}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{"259":{"tf":1},"286":{"tf":1}},"df":2}}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"43":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"e":{"docs":{"56":{"tf":1}},"df":1}}},"q":{"docs":{},"df":0,"f":{"docs":{"4":{"tf":1},"185":{"tf":1.4142135623730951}},"df":2,"‑":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":3.1622776601683795},"4":{"tf":2.8284271247461903},"5":{"tf":1},"8":{"tf":2},"14":{"tf":2.449489742783178},"15":{"tf":1},"21":{"tf":2},"27":{"tf":1.4142135623730951},"34":{"tf":1},"37":{"tf":1},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"47":{"tf":1},"50":{"tf":1},"54":{"tf":1},"55":{"tf":1},"62":{"tf":1},"63":{"tf":1},"64":{"tf":1},"72":{"tf":1},"81":{"tf":1.4142135623730951},"86":{"tf":1},"89":{"tf":1},"101":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"107":{"tf":1},"108":{"tf":1.7320508075688772},"111":{"tf":1.4142135623730951},"114":{"tf":2},"117":{"tf":1},"120":{"tf":1},"130":{"tf":1},"131":{"tf":1},"136":{"tf":1},"137":{"tf":1},"142":{"tf":1},"143":{"tf":1.4142135623730951},"147":{"tf":1},"154":{"tf":1},"157":{"tf":2.23606797749979},"162":{"tf":1},"163":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"167":{"tf":1},"168":{"tf":1.4142135623730951},"173":{"tf":1},"175":{"tf":1},"178":{"tf":1.4142135623730951},"181":{"tf":2.23606797749979},"184":{"tf":1},"195":{"tf":1},"201":{"tf":1},"204":{"tf":3},"212":{"tf":1.4142135623730951},"215":{"tf":1},"217":{"tf":1},"219":{"tf":1},"220":{"tf":1.7320508075688772},"228":{"tf":1.4142135623730951},"231":{"tf":1},"233":{"tf":1.4142135623730951},"239":{"tf":1},"241":{"tf":1},"243":{"tf":1.4142135623730951},"252":{"tf":1},"255":{"tf":1},"258":{"tf":1},"259":{"tf":1},"262":{"tf":1.7320508075688772},"269":{"tf":1},"272":{"tf":1.4142135623730951},"274":{"tf":2.23606797749979},"275":{"tf":1.7320508075688772},"277":{"tf":1.4142135623730951},"280":{"tf":1},"281":{"tf":1},"283":{"tf":1}},"df":77,"’":{"docs":{"129":{"tf":1}},"df":1},"'":{"docs":{"227":{"tf":1}},"df":1}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1},"63":{"tf":1},"89":{"tf":1},"175":{"tf":1},"184":{"tf":1},"212":{"tf":1},"215":{"tf":1.4142135623730951},"227":{"tf":1.4142135623730951},"228":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":1},"234":{"tf":1},"242":{"tf":1},"246":{"tf":1},"258":{"tf":1.4142135623730951},"259":{"tf":1},"261":{"tf":1},"262":{"tf":1},"269":{"tf":1}},"df":19,":":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"}":{"docs":{},"df":0,"/":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"64":{"tf":1}},"df":1,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"k":{"docs":{"64":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"181":{"tf":2.23606797749979},"184":{"tf":1},"204":{"tf":1}},"df":3}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{"189":{"tf":1},"204":{"tf":1}},"df":2}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"190":{"tf":1}},"df":1}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"191":{"tf":1}},"df":1}}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"192":{"tf":1}},"df":1}}}}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,".":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"204":{"tf":1.4142135623730951}},"df":1}}}}}}}}}}}},"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"253":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"253":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"x":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"253":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"62":{"tf":1.7320508075688772},"80":{"tf":1},"209":{"tf":1.7320508075688772}},"df":4}}}}},"l":{"docs":{},"df":0,"i":{"docs":{"129":{"tf":1},"147":{"tf":1},"154":{"tf":1}},"df":3}}}},"t":{"docs":{"170":{"tf":1},"204":{"tf":1},"233":{"tf":1},"259":{"tf":1}},"df":4}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"43":{"tf":1}},"df":1}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"43":{"tf":1},"178":{"tf":1}},"df":2}}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"54":{"tf":1}},"df":1}}}}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":2.8284271247461903},"4":{"tf":3.1622776601683795},"5":{"tf":1},"8":{"tf":1.7320508075688772},"14":{"tf":1},"20":{"tf":1.4142135623730951},"21":{"tf":2.6457513110645907},"27":{"tf":1.4142135623730951},"32":{"tf":1},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"39":{"tf":1.7320508075688772},"40":{"tf":1},"43":{"tf":1.7320508075688772},"47":{"tf":1},"51":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"64":{"tf":1},"65":{"tf":1},"69":{"tf":1},"70":{"tf":1},"71":{"tf":1},"72":{"tf":1},"77":{"tf":1.4142135623730951},"80":{"tf":1},"81":{"tf":2},"83":{"tf":1},"86":{"tf":1},"108":{"tf":1},"111":{"tf":2},"114":{"tf":1},"117":{"tf":1},"120":{"tf":1},"126":{"tf":1.7320508075688772},"129":{"tf":1.4142135623730951},"141":{"tf":1},"150":{"tf":1.4142135623730951},"154":{"tf":1},"155":{"tf":1.7320508075688772},"162":{"tf":1},"163":{"tf":1.4142135623730951},"164":{"tf":1.7320508075688772},"167":{"tf":1},"168":{"tf":1.4142135623730951},"169":{"tf":1},"174":{"tf":1},"175":{"tf":1},"178":{"tf":2.449489742783178},"181":{"tf":1.7320508075688772},"185":{"tf":1.4142135623730951},"190":{"tf":1},"192":{"tf":1.4142135623730951},"199":{"tf":1},"200":{"tf":1},"204":{"tf":3},"212":{"tf":1.4142135623730951},"216":{"tf":2},"219":{"tf":1},"220":{"tf":2.23606797749979},"221":{"tf":2.23606797749979},"222":{"tf":1},"224":{"tf":1},"225":{"tf":1.4142135623730951},"226":{"tf":1},"227":{"tf":1},"231":{"tf":1.7320508075688772},"233":{"tf":2.23606797749979},"235":{"tf":1},"237":{"tf":1},"238":{"tf":1.4142135623730951},"239":{"tf":1},"240":{"tf":1},"241":{"tf":2.6457513110645907},"242":{"tf":2.23606797749979},"244":{"tf":1.4142135623730951},"247":{"tf":1.4142135623730951},"249":{"tf":1},"251":{"tf":1},"254":{"tf":1},"258":{"tf":1.4142135623730951},"259":{"tf":2.23606797749979},"262":{"tf":2.23606797749979},"263":{"tf":1},"264":{"tf":1.4142135623730951},"265":{"tf":3.1622776601683795},"266":{"tf":1.4142135623730951},"267":{"tf":2.23606797749979},"269":{"tf":1},"270":{"tf":1.7320508075688772},"272":{"tf":2.23606797749979},"273":{"tf":1},"275":{"tf":1.7320508075688772},"277":{"tf":1.4142135623730951},"278":{"tf":1},"280":{"tf":2.449489742783178},"281":{"tf":1},"284":{"tf":1.4142135623730951},"286":{"tf":1.4142135623730951},"287":{"tf":1},"288":{"tf":1},"289":{"tf":1}},"df":101,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"55":{"tf":1},"154":{"tf":1}},"df":3}},"e":{"docs":{},"df":0,"r":{"docs":{"101":{"tf":1}},"df":1}}},"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"5":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"147":{"tf":1}},"df":1}}}}}}},"g":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"242":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"t":{"docs":{"282":{"tf":1},"285":{"tf":1}},"df":2}}},"c":{"docs":{"255":{"tf":1}},"df":1,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"281":{"tf":1},"282":{"tf":1}},"df":2}}}}}}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"4":{"tf":1},"8":{"tf":1},"28":{"tf":1},"104":{"tf":1},"111":{"tf":1},"114":{"tf":1},"173":{"tf":1},"181":{"tf":1},"204":{"tf":2.23606797749979},"250":{"tf":1},"255":{"tf":1}},"df":11}},"r":{"docs":{"25":{"tf":1},"26":{"tf":1},"277":{"tf":1},"280":{"tf":1.4142135623730951},"287":{"tf":1}},"df":5}},"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"4":{"tf":1},"14":{"tf":1},"16":{"tf":1},"37":{"tf":1},"39":{"tf":1},"55":{"tf":1},"56":{"tf":1},"63":{"tf":1},"72":{"tf":1},"80":{"tf":1},"81":{"tf":1},"97":{"tf":1.4142135623730951},"108":{"tf":1},"111":{"tf":1},"114":{"tf":1},"124":{"tf":1},"135":{"tf":1},"154":{"tf":1.4142135623730951},"162":{"tf":1},"163":{"tf":1},"164":{"tf":1},"173":{"tf":1.4142135623730951},"174":{"tf":1},"181":{"tf":1},"204":{"tf":1},"209":{"tf":1},"212":{"tf":1},"215":{"tf":1},"216":{"tf":1},"220":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"231":{"tf":1},"233":{"tf":1},"237":{"tf":1},"239":{"tf":1},"243":{"tf":1},"247":{"tf":1},"258":{"tf":1},"260":{"tf":1},"262":{"tf":1.4142135623730951},"271":{"tf":1},"275":{"tf":1}},"df":42}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"189":{"tf":1.4142135623730951},"215":{"tf":1},"231":{"tf":1},"232":{"tf":1},"234":{"tf":1},"246":{"tf":1},"258":{"tf":1},"261":{"tf":1}},"df":8}}}},"n":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1}},"df":1}},"c":{"docs":{},"df":0,"u":{"docs":{"126":{"tf":1},"147":{"tf":1},"162":{"tf":1}},"df":3,"s":{"docs":{"189":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":1},"16":{"tf":1},"27":{"tf":1},"40":{"tf":1},"43":{"tf":1},"80":{"tf":1.4142135623730951},"111":{"tf":1},"114":{"tf":1.4142135623730951},"120":{"tf":1},"124":{"tf":1},"126":{"tf":1},"129":{"tf":1.4142135623730951},"135":{"tf":1},"168":{"tf":1},"181":{"tf":1.4142135623730951},"184":{"tf":1},"204":{"tf":1}},"df":18}}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"8":{"tf":1}},"df":1}}}}}}},"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"55":{"tf":1},"89":{"tf":1},"96":{"tf":1},"131":{"tf":1},"162":{"tf":1},"175":{"tf":1},"181":{"tf":1},"215":{"tf":1},"228":{"tf":1}},"df":10,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"258":{"tf":1}},"df":1}}}}}}}},"l":{"docs":{},"df":0,"l":{"docs":{"39":{"tf":1},"50":{"tf":1},"126":{"tf":1},"225":{"tf":1},"262":{"tf":1},"266":{"tf":1}},"df":6,"i":{"docs":{"47":{"tf":1}},"df":1}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"231":{"tf":1},"233":{"tf":1},"237":{"tf":1}},"df":3}}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"3":{"tf":1},"5":{"tf":1},"14":{"tf":1},"26":{"tf":1},"39":{"tf":1},"43":{"tf":1.4142135623730951},"55":{"tf":1},"56":{"tf":1},"59":{"tf":1},"62":{"tf":1},"63":{"tf":1},"64":{"tf":1.4142135623730951},"80":{"tf":1},"81":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"96":{"tf":1},"97":{"tf":1.4142135623730951},"108":{"tf":1},"114":{"tf":2},"123":{"tf":1.4142135623730951},"136":{"tf":1},"137":{"tf":1},"141":{"tf":1},"142":{"tf":1},"144":{"tf":1},"147":{"tf":1.4142135623730951},"154":{"tf":1},"161":{"tf":1},"163":{"tf":1},"167":{"tf":1},"168":{"tf":1.4142135623730951},"169":{"tf":1},"170":{"tf":1},"174":{"tf":1},"184":{"tf":1},"189":{"tf":1.4142135623730951},"204":{"tf":2.8284271247461903},"212":{"tf":1},"219":{"tf":1},"224":{"tf":1},"228":{"tf":1},"233":{"tf":1.4142135623730951},"239":{"tf":1.4142135623730951},"243":{"tf":1},"259":{"tf":1},"265":{"tf":1},"282":{"tf":1},"285":{"tf":1}},"df":48}},"e":{"docs":{},"df":0,"e":{"docs":{"27":{"tf":1},"56":{"tf":1},"270":{"tf":1}},"df":3},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"181":{"tf":1},"190":{"tf":1}},"df":2}}}}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"265":{"tf":2}},"df":1}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"34":{"tf":1},"38":{"tf":1.4142135623730951},"63":{"tf":1},"72":{"tf":1},"104":{"tf":1},"107":{"tf":1},"114":{"tf":1},"167":{"tf":1},"173":{"tf":1},"181":{"tf":1.4142135623730951},"200":{"tf":1},"204":{"tf":1.4142135623730951},"215":{"tf":1},"227":{"tf":1},"228":{"tf":1},"231":{"tf":1},"237":{"tf":1},"242":{"tf":1},"246":{"tf":1},"250":{"tf":1},"255":{"tf":1},"258":{"tf":1},"259":{"tf":1},"270":{"tf":1}},"df":25},"a":{"docs":{},"df":0,"l":{"docs":{"21":{"tf":1},"26":{"tf":1.4142135623730951},"39":{"tf":1},"72":{"tf":1},"131":{"tf":1},"153":{"tf":1},"154":{"tf":1},"209":{"tf":1},"224":{"tf":1.4142135623730951},"265":{"tf":1},"274":{"tf":1}},"df":11}},"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{"27":{"tf":1},"65":{"tf":1},"74":{"tf":1},"132":{"tf":1},"144":{"tf":1},"178":{"tf":1},"248":{"tf":1}},"df":7}}},"e":{"docs":{"242":{"tf":1}},"df":1}},"l":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1},"14":{"tf":1.4142135623730951},"26":{"tf":1},"54":{"tf":1},"55":{"tf":1},"62":{"tf":1},"66":{"tf":1},"181":{"tf":1.7320508075688772},"189":{"tf":1.4142135623730951},"190":{"tf":1},"204":{"tf":1},"212":{"tf":1.4142135623730951},"215":{"tf":1},"220":{"tf":1.7320508075688772},"226":{"tf":1},"227":{"tf":1},"228":{"tf":1},"231":{"tf":1},"234":{"tf":1},"258":{"tf":1},"262":{"tf":1.4142135623730951},"264":{"tf":1},"269":{"tf":1.7320508075688772},"270":{"tf":1},"271":{"tf":1.4142135623730951},"272":{"tf":1},"275":{"tf":1.4142135623730951},"277":{"tf":1},"280":{"tf":1.4142135623730951},"284":{"tf":1},"286":{"tf":1},"289":{"tf":1}},"df":32},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"43":{"tf":1}},"df":1}}},"l":{"docs":{"93":{"tf":1},"94":{"tf":1},"95":{"tf":1},"222":{"tf":1},"280":{"tf":1}},"df":5}},"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"11":{"tf":1},"14":{"tf":1.4142135623730951},"15":{"tf":1},"19":{"tf":1},"21":{"tf":2},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"32":{"tf":1},"55":{"tf":1},"63":{"tf":1},"72":{"tf":1},"80":{"tf":1},"81":{"tf":1.4142135623730951},"94":{"tf":1},"107":{"tf":1},"108":{"tf":1},"111":{"tf":1.4142135623730951},"117":{"tf":1},"123":{"tf":1.4142135623730951},"126":{"tf":1},"129":{"tf":1},"130":{"tf":1},"154":{"tf":1},"155":{"tf":1},"158":{"tf":1},"161":{"tf":1},"163":{"tf":1},"168":{"tf":1},"173":{"tf":1},"181":{"tf":1},"199":{"tf":1},"201":{"tf":1},"204":{"tf":1},"215":{"tf":1},"220":{"tf":1.4142135623730951},"221":{"tf":1.7320508075688772},"231":{"tf":1},"232":{"tf":1.4142135623730951},"233":{"tf":1},"234":{"tf":1},"235":{"tf":1.4142135623730951},"236":{"tf":1},"239":{"tf":1.4142135623730951},"241":{"tf":1},"242":{"tf":1},"243":{"tf":1},"246":{"tf":1},"251":{"tf":1},"258":{"tf":1},"259":{"tf":1.4142135623730951},"262":{"tf":1.4142135623730951},"271":{"tf":1.4142135623730951},"272":{"tf":1},"274":{"tf":1},"275":{"tf":1},"276":{"tf":1},"280":{"tf":1}},"df":58,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1},"66":{"tf":1},"89":{"tf":1.7320508075688772}},"df":3}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1}},"df":1}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"14":{"tf":1.4142135623730951}},"df":1}}}}},"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"15":{"tf":1},"16":{"tf":1},"20":{"tf":1},"21":{"tf":1},"22":{"tf":1},"26":{"tf":1},"27":{"tf":1},"28":{"tf":1},"32":{"tf":1},"33":{"tf":1},"34":{"tf":1},"38":{"tf":1},"39":{"tf":1},"40":{"tf":1},"47":{"tf":1},"51":{"tf":1},"55":{"tf":1},"56":{"tf":1},"63":{"tf":1},"64":{"tf":1},"65":{"tf":1},"66":{"tf":1},"70":{"tf":1},"71":{"tf":1},"72":{"tf":1},"73":{"tf":1},"74":{"tf":1},"81":{"tf":1},"82":{"tf":1},"83":{"tf":1},"90":{"tf":1},"94":{"tf":1},"95":{"tf":1},"96":{"tf":1},"97":{"tf":1},"98":{"tf":1},"108":{"tf":1},"118":{"tf":1},"119":{"tf":1},"120":{"tf":1},"124":{"tf":1},"125":{"tf":1},"126":{"tf":1},"130":{"tf":1},"131":{"tf":1},"132":{"tf":1},"136":{"tf":1},"137":{"tf":1},"138":{"tf":1},"141":{"tf":1},"142":{"tf":1},"143":{"tf":1},"154":{"tf":1},"155":{"tf":1},"156":{"tf":1},"158":{"tf":1},"162":{"tf":1},"163":{"tf":1},"164":{"tf":1},"168":{"tf":1},"169":{"tf":1},"173":{"tf":1},"174":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"185":{"tf":1},"199":{"tf":1},"200":{"tf":1},"201":{"tf":1},"205":{"tf":1},"206":{"tf":1},"216":{"tf":1},"218":{"tf":1},"219":{"tf":1},"221":{"tf":1},"222":{"tf":1},"223":{"tf":1},"224":{"tf":1},"225":{"tf":1},"226":{"tf":1},"227":{"tf":1},"233":{"tf":1},"235":{"tf":1},"236":{"tf":1},"237":{"tf":1},"238":{"tf":1},"239":{"tf":1},"240":{"tf":1},"242":{"tf":1},"243":{"tf":1},"244":{"tf":1},"247":{"tf":1},"248":{"tf":1},"249":{"tf":1},"251":{"tf":1},"252":{"tf":1},"253":{"tf":1},"260":{"tf":1},"262":{"tf":1},"263":{"tf":1},"266":{"tf":1},"267":{"tf":1},"270":{"tf":1},"272":{"tf":1},"273":{"tf":1},"274":{"tf":1},"275":{"tf":1},"276":{"tf":1},"278":{"tf":1},"279":{"tf":1},"281":{"tf":1},"282":{"tf":1},"283":{"tf":1},"285":{"tf":1},"286":{"tf":1},"287":{"tf":1},"288":{"tf":1}},"df":116}}},"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"26":{"tf":1},"39":{"tf":1},"55":{"tf":1},"70":{"tf":1.4142135623730951},"77":{"tf":1},"93":{"tf":1},"154":{"tf":1},"204":{"tf":1},"224":{"tf":1.4142135623730951},"265":{"tf":1.4142135623730951},"272":{"tf":2},"277":{"tf":1.4142135623730951},"280":{"tf":2},"284":{"tf":1}},"df":14}}},"x":{"docs":{"137":{"tf":1},"141":{"tf":1.4142135623730951},"143":{"tf":1},"147":{"tf":1},"163":{"tf":1}},"df":5},"v":{"docs":{},"df":0,"e":{"docs":{"259":{"tf":1}},"df":1}},"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"259":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"51":{"tf":1},"54":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"212":{"tf":1.4142135623730951},"233":{"tf":1},"255":{"tf":1.4142135623730951},"259":{"tf":1.7320508075688772}},"df":9}}}},"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"5":{"tf":1.4142135623730951}},"df":1}}}}},"l":{"docs":{"270":{"tf":1}},"df":1}},"w":{"docs":{"43":{"tf":1},"188":{"tf":1}},"df":2},"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"173":{"tf":1.7320508075688772},"175":{"tf":1}},"df":2}}}},"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"21":{"tf":1},"141":{"tf":1},"233":{"tf":1.4142135623730951},"246":{"tf":1},"247":{"tf":1},"250":{"tf":1}},"df":6}},"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"38":{"tf":1},"114":{"tf":1}},"df":2}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"101":{"tf":1}},"df":1},"s":{"docs":{},"df":0,"t":{"docs":{"168":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"167":{"tf":1}},"df":1}}}},"r":{"docs":{"170":{"tf":1},"234":{"tf":1},"237":{"tf":1.4142135623730951},"246":{"tf":1}},"df":4},"l":{"docs":{},"df":0,"s":{"docs":{"199":{"tf":1},"201":{"tf":1.4142135623730951},"204":{"tf":2.23606797749979}},"df":3}},"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{"233":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"74":{"tf":1},"129":{"tf":1},"228":{"tf":1}},"df":3}}}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"3":{"tf":1.4142135623730951},"14":{"tf":1},"54":{"tf":1},"258":{"tf":1},"261":{"tf":1},"268":{"tf":1},"269":{"tf":1},"289":{"tf":1}},"df":8,"a":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"21":{"tf":1},"51":{"tf":1},"181":{"tf":1.4142135623730951},"219":{"tf":1},"231":{"tf":1},"237":{"tf":1},"258":{"tf":1},"259":{"tf":1},"262":{"tf":1},"267":{"tf":1},"270":{"tf":1},"276":{"tf":1},"277":{"tf":1}},"df":14,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"_":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"262":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}},"p":{"docs":{},"df":0,"p":{"docs":{"8":{"tf":1},"20":{"tf":1},"21":{"tf":1},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1},"108":{"tf":1},"189":{"tf":1.4142135623730951},"199":{"tf":1}},"df":10,"l":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1},"155":{"tf":1},"178":{"tf":1.4142135623730951},"201":{"tf":1}},"df":4,"c":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979},"8":{"tf":2},"15":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1},"21":{"tf":1.4142135623730951},"46":{"tf":1},"62":{"tf":1.4142135623730951},"63":{"tf":2.449489742783178},"69":{"tf":1},"70":{"tf":1},"86":{"tf":1},"89":{"tf":1},"111":{"tf":1.4142135623730951},"114":{"tf":1},"126":{"tf":1},"150":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"178":{"tf":1},"209":{"tf":1.7320508075688772},"212":{"tf":1},"233":{"tf":1.7320508075688772},"237":{"tf":1},"241":{"tf":1},"259":{"tf":1.4142135623730951}},"df":26}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"21":{"tf":1},"65":{"tf":1},"70":{"tf":1},"71":{"tf":1},"80":{"tf":1},"137":{"tf":1},"168":{"tf":1},"169":{"tf":1},"199":{"tf":1},"200":{"tf":1},"242":{"tf":1},"250":{"tf":1},"254":{"tf":1}},"df":13}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"x":{"docs":{"114":{"tf":1}},"df":1}}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"34":{"tf":1},"47":{"tf":1},"86":{"tf":1},"93":{"tf":1},"111":{"tf":1},"219":{"tf":1},"233":{"tf":1},"244":{"tf":1},"250":{"tf":1},"255":{"tf":1},"258":{"tf":1},"259":{"tf":1}},"df":12}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"204":{"tf":1}},"df":1}}},"x":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{"259":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"189":{"tf":1}},"df":1}}}}}}},"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"189":{"tf":1}},"df":1}}}}}}},"k":{"docs":{"64":{"tf":1.4142135623730951}},"df":1}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"k":{"docs":{"3":{"tf":1}},"df":1}},"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"y":{"docs":{"3":{"tf":1},"81":{"tf":1},"108":{"tf":1},"123":{"tf":1},"204":{"tf":1.4142135623730951},"224":{"tf":1},"251":{"tf":1}},"df":7}}},"l":{"docs":{"4":{"tf":1},"5":{"tf":1},"8":{"tf":1},"28":{"tf":1},"38":{"tf":1},"40":{"tf":1},"43":{"tf":1},"65":{"tf":1},"69":{"tf":1},"80":{"tf":1},"120":{"tf":1.7320508075688772},"124":{"tf":1},"147":{"tf":1},"162":{"tf":1},"175":{"tf":1.4142135623730951},"178":{"tf":1},"185":{"tf":1},"189":{"tf":1},"204":{"tf":1.7320508075688772},"209":{"tf":1},"215":{"tf":1},"231":{"tf":1},"236":{"tf":1},"238":{"tf":1.7320508075688772},"239":{"tf":1},"241":{"tf":1.4142135623730951},"253":{"tf":1},"258":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"262":{"tf":1},"264":{"tf":1},"265":{"tf":2},"267":{"tf":1.7320508075688772},"270":{"tf":1},"277":{"tf":1},"280":{"tf":2.449489742783178}},"df":36,"o":{"docs":{},"df":0,"w":{"docs":{"14":{"tf":1},"40":{"tf":1},"43":{"tf":1},"129":{"tf":1},"154":{"tf":1},"228":{"tf":1},"233":{"tf":1.4142135623730951},"241":{"tf":1},"272":{"tf":1.4142135623730951},"280":{"tf":1}},"df":10}}},"t":{"docs":{"4":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"r":{"docs":{"262":{"tf":1}},"df":1,"n":{"docs":{"4":{"tf":1},"21":{"tf":1},"34":{"tf":1},"64":{"tf":1},"97":{"tf":1},"101":{"tf":1},"108":{"tf":1},"120":{"tf":1},"252":{"tf":1}},"df":9}}},"⁠":{"docs":{},"df":0,"+":{"docs":{},"df":0,"⁠":{"docs":{},"df":0,"f":{"1":{"2":{"docs":{"114":{"tf":1},"147":{"tf":1}},"df":2},"docs":{},"df":0},"docs":{},"df":0}}}},"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{"155":{"tf":1}},"df":1}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{"21":{"tf":1.4142135623730951},"37":{"tf":1},"38":{"tf":1},"71":{"tf":1},"72":{"tf":1},"89":{"tf":1},"107":{"tf":1},"111":{"tf":1},"114":{"tf":1},"120":{"tf":1},"126":{"tf":1},"143":{"tf":1},"162":{"tf":1},"163":{"tf":1},"168":{"tf":1},"181":{"tf":1},"198":{"tf":1},"199":{"tf":1},"201":{"tf":1},"209":{"tf":1},"212":{"tf":1},"222":{"tf":1},"233":{"tf":1},"237":{"tf":1.4142135623730951},"239":{"tf":1},"241":{"tf":1.4142135623730951},"242":{"tf":1.7320508075688772}},"df":27}}}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"80":{"tf":1}},"df":1}}},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"169":{"tf":1}},"df":1}}}}},"n":{"docs":{},"df":0,"i":{"docs":{"3":{"tf":1},"19":{"tf":1},"162":{"tf":1},"185":{"tf":1},"189":{"tf":1},"204":{"tf":1.4142135623730951},"220":{"tf":1},"227":{"tf":1},"231":{"tf":1},"233":{"tf":1},"237":{"tf":1}},"df":11},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"y":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{"3":{"tf":1},"26":{"tf":1},"34":{"tf":1.4142135623730951},"39":{"tf":1},"150":{"tf":1},"236":{"tf":1}},"df":6}},"z":{"docs":{"4":{"tf":1},"39":{"tf":1},"40":{"tf":1},"104":{"tf":1},"204":{"tf":1}},"df":5}},"o":{"docs":{},"df":0,"g":{"docs":{"108":{"tf":1},"136":{"tf":1}},"df":2}}}},"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"8":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1},"21":{"tf":2.6457513110645907},"22":{"tf":1},"63":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951},"65":{"tf":1},"70":{"tf":1},"82":{"tf":1},"83":{"tf":1},"108":{"tf":1},"150":{"tf":1},"189":{"tf":2}},"df":14}}}},"/":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"14":{"tf":1}},"df":1}}}},"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{"39":{"tf":1},"154":{"tf":1},"155":{"tf":1},"162":{"tf":1},"163":{"tf":1},"164":{"tf":1},"168":{"tf":1},"204":{"tf":1.4142135623730951},"219":{"tf":1},"225":{"tf":1},"233":{"tf":1},"237":{"tf":1},"244":{"tf":1},"255":{"tf":1},"270":{"tf":1},"272":{"tf":1}},"df":16}}},"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"80":{"tf":1},"178":{"tf":1}},"df":2}}}},"y":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"226":{"tf":1},"237":{"tf":1},"243":{"tf":1},"250":{"tf":1},"277":{"tf":1}},"df":5}}}}},"d":{"docs":{"164":{"tf":1},"204":{"tf":1},"224":{"tf":1},"241":{"tf":1},"251":{"tf":1}},"df":5,"d":{"docs":{"155":{"tf":1.4142135623730951},"161":{"tf":1},"163":{"tf":1},"164":{"tf":1},"168":{"tf":1},"181":{"tf":1},"204":{"tf":2},"218":{"tf":1},"219":{"tf":1},"223":{"tf":1},"239":{"tf":1},"272":{"tf":1},"277":{"tf":1},"280":{"tf":1},"284":{"tf":1},"286":{"tf":1}},"df":16,"i":{"docs":{},"df":0,"t":{"docs":{"40":{"tf":1},"63":{"tf":1},"101":{"tf":1},"108":{"tf":1},"114":{"tf":1},"137":{"tf":1},"141":{"tf":1},"173":{"tf":1},"184":{"tf":1},"201":{"tf":1},"227":{"tf":1}},"df":11,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1},"216":{"tf":1},"287":{"tf":1}},"df":3}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"104":{"tf":1},"107":{"tf":1.4142135623730951},"108":{"tf":2},"111":{"tf":1}},"df":4}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"51":{"tf":1},"114":{"tf":1.4142135623730951},"167":{"tf":1},"212":{"tf":1.4142135623730951},"231":{"tf":1.4142135623730951},"232":{"tf":1},"234":{"tf":1},"242":{"tf":1},"246":{"tf":1}},"df":11},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"216":{"tf":1},"233":{"tf":1},"239":{"tf":1},"258":{"tf":1}},"df":4}}}}},"i":{"docs":{},"df":0,"s":{"docs":{"126":{"tf":1},"181":{"tf":1}},"df":2}}},"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"26":{"tf":1},"181":{"tf":1}},"df":2}}},"j":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"71":{"tf":1},"163":{"tf":1},"164":{"tf":1.7320508075688772},"168":{"tf":1},"181":{"tf":1}},"df":5}}}},"b":{"docs":{"189":{"tf":1.4142135623730951}},"df":1}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1},"21":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"63":{"tf":1},"64":{"tf":1},"69":{"tf":1},"111":{"tf":1},"114":{"tf":1},"120":{"tf":1},"150":{"tf":1},"181":{"tf":1},"189":{"tf":1},"195":{"tf":1.4142135623730951},"209":{"tf":1.4142135623730951},"238":{"tf":1},"289":{"tf":1}},"df":16}}},"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"86":{"tf":1},"216":{"tf":1},"225":{"tf":1}},"df":3}}}},"s":{"docs":{},"df":0,"k":{"docs":{"14":{"tf":1}},"df":1},"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"54":{"tf":1}},"df":1},"m":{"docs":{"233":{"tf":1},"241":{"tf":1},"247":{"tf":1},"277":{"tf":1}},"df":4}},"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"n":{"docs":{"163":{"tf":1},"178":{"tf":1}},"df":2}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"233":{"tf":1.4142135623730951},"272":{"tf":1}},"df":2}}}}},"c":{"docs":{},"df":0,"t":{"docs":{"280":{"tf":1}},"df":1,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"20":{"tf":1},"27":{"tf":1.7320508075688772},"37":{"tf":1},"59":{"tf":1},"69":{"tf":1.4142135623730951},"71":{"tf":1},"72":{"tf":1.4142135623730951},"74":{"tf":1},"80":{"tf":1},"93":{"tf":1},"94":{"tf":1},"129":{"tf":1},"204":{"tf":2},"262":{"tf":1.4142135623730951},"264":{"tf":1},"265":{"tf":1},"271":{"tf":1}},"df":17,"_":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"108":{"tf":1},"204":{"tf":1}},"df":2,"@":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{"108":{"tf":1}},"df":1}}}}},"&":{"docs":{},"df":0,"$":{"docs":{},"df":0,"(":{"docs":{},"df":0,"i":{"docs":{},"df":0,")":{"docs":{},"df":0,"@":{"docs":{},"df":0,"#":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"204":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}},"v":{"docs":{"21":{"tf":1},"107":{"tf":1},"114":{"tf":1},"117":{"tf":1.4142135623730951},"120":{"tf":1},"123":{"tf":1},"124":{"tf":1},"126":{"tf":1},"129":{"tf":1},"130":{"tf":1},"135":{"tf":1},"147":{"tf":1.4142135623730951},"189":{"tf":1.7320508075688772},"204":{"tf":1},"231":{"tf":1},"252":{"tf":1}},"df":16}},"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"38":{"tf":1.4142135623730951},"39":{"tf":1},"141":{"tf":1.4142135623730951},"216":{"tf":1},"220":{"tf":1},"280":{"tf":1}},"df":6}}}},"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"40":{"tf":1}},"df":1}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"90":{"tf":1},"233":{"tf":1},"242":{"tf":1.4142135623730951},"262":{"tf":1},"277":{"tf":1.4142135623730951},"286":{"tf":1}},"df":6,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"69":{"tf":1},"175":{"tf":1}},"df":2}}}}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"270":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"157":{"tf":1},"227":{"tf":1}},"df":2,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"241":{"tf":2.6457513110645907},"242":{"tf":2.23606797749979},"243":{"tf":1},"266":{"tf":1},"267":{"tf":1}},"df":5},"y":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"266":{"tf":1}},"df":1}}}}}}}}}}}}}}}}},"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"v":{"docs":{"43":{"tf":1},"51":{"tf":1},"86":{"tf":1},"126":{"tf":1},"168":{"tf":1},"209":{"tf":1},"215":{"tf":1},"228":{"tf":1},"235":{"tf":1},"238":{"tf":1},"255":{"tf":1},"259":{"tf":1},"275":{"tf":1},"281":{"tf":1},"286":{"tf":1}},"df":15}}}}},"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"21":{"tf":1},"120":{"tf":1},"123":{"tf":1},"124":{"tf":1}},"df":4}}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"43":{"tf":1},"80":{"tf":1}},"df":2}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"56":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"a":{"docs":{"104":{"tf":1},"221":{"tf":1},"233":{"tf":1},"238":{"tf":1},"241":{"tf":1}},"df":5}},"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"175":{"tf":1},"178":{"tf":1}},"df":2}}}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{"241":{"tf":1.7320508075688772}},"df":1}}}},"i":{"docs":{},"df":0,"s":{"docs":{"252":{"tf":1}},"df":1}}},"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"34":{"tf":1},"72":{"tf":1.4142135623730951},"119":{"tf":1},"120":{"tf":1},"135":{"tf":1},"143":{"tf":1},"147":{"tf":1},"163":{"tf":1},"168":{"tf":1},"175":{"tf":1},"204":{"tf":1},"206":{"tf":1},"233":{"tf":1},"239":{"tf":1},"241":{"tf":1},"247":{"tf":1.4142135623730951},"262":{"tf":1},"275":{"tf":1.4142135623730951},"280":{"tf":1},"285":{"tf":1},"287":{"tf":1}},"df":21}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"40":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"142":{"tf":1},"156":{"tf":1},"157":{"tf":1.4142135623730951},"174":{"tf":1},"175":{"tf":1},"181":{"tf":1},"200":{"tf":1},"204":{"tf":2.6457513110645907},"225":{"tf":1.7320508075688772},"226":{"tf":1},"242":{"tf":1},"255":{"tf":1},"272":{"tf":1},"274":{"tf":1.4142135623730951},"281":{"tf":1}},"df":16}}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"114":{"tf":1}},"df":1}}}}},"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"v":{"docs":{"90":{"tf":1},"97":{"tf":1},"155":{"tf":1},"157":{"tf":1},"161":{"tf":1},"162":{"tf":1.4142135623730951},"173":{"tf":1},"175":{"tf":1},"204":{"tf":1},"241":{"tf":1}},"df":10}},"i":{"docs":{},"df":0,"l":{"docs":{"244":{"tf":1}},"df":1}}},"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"93":{"tf":1},"167":{"tf":1},"244":{"tf":1},"274":{"tf":1}},"df":4}}}}}}},"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"142":{"tf":1},"280":{"tf":1}},"df":2}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"129":{"tf":1},"209":{"tf":1}},"df":2}}}}},"j":{"docs":{},"df":0,"a":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":2},"14":{"tf":1.4142135623730951},"150":{"tf":1},"154":{"tf":1.4142135623730951},"212":{"tf":1}},"df":6,"f":{"docs":{},"df":0,"x":{"docs":{"3":{"tf":1}},"df":1}},"/":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{"212":{"tf":1}},"df":1}}},"x":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"_":{"docs":{},"df":0,"j":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"272":{"tf":1}},"df":1,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"_":{"docs":{},"df":0,"<":{"docs":{},"df":0,"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"280":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"280":{"tf":1}},"df":1}}}}}}}}}}}},".":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,".":{"docs":{},"df":0,"j":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"272":{"tf":1.4142135623730951}},"df":1}}}}}}}}},"f":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"280":{"tf":1}},"df":1}}}}}}}}}}}}}}},"z":{"docs":{},"df":0,"z":{"docs":{"26":{"tf":1.4142135623730951},"72":{"tf":1},"73":{"tf":1},"74":{"tf":1}},"df":4}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"55":{"tf":1.4142135623730951}},"df":2}}},"m":{"docs":{},"df":0,"p":{"docs":{"21":{"tf":1},"114":{"tf":1.4142135623730951},"129":{"tf":1},"138":{"tf":1},"141":{"tf":1},"144":{"tf":1.7320508075688772},"154":{"tf":1},"167":{"tf":1},"168":{"tf":1.4142135623730951}},"df":9}}},"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"262":{"tf":1},"264":{"tf":1.4142135623730951},"265":{"tf":1.4142135623730951},"266":{"tf":1},"280":{"tf":1}},"df":5}}}}}}}}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979}},"df":2,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"21":{"tf":1},"50":{"tf":1},"56":{"tf":1},"80":{"tf":1},"97":{"tf":1},"120":{"tf":1},"135":{"tf":1},"147":{"tf":1},"150":{"tf":1},"154":{"tf":1},"226":{"tf":1},"242":{"tf":1},"267":{"tf":1}},"df":14}},"'":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"16":{"tf":1},"34":{"tf":1}},"df":2}},"r":{"docs":{"54":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"t":{"docs":{"162":{"tf":1}},"df":1}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":2.23606797749979},"15":{"tf":1.4142135623730951},"27":{"tf":1},"37":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"55":{"tf":1},"69":{"tf":1.7320508075688772},"70":{"tf":2},"72":{"tf":1},"74":{"tf":1},"77":{"tf":1.7320508075688772},"80":{"tf":1.4142135623730951},"104":{"tf":1},"147":{"tf":1},"162":{"tf":1},"168":{"tf":1},"253":{"tf":1},"262":{"tf":2},"263":{"tf":1},"264":{"tf":1},"265":{"tf":1.7320508075688772},"267":{"tf":1},"275":{"tf":1},"280":{"tf":1.4142135623730951}},"df":25}}}},"s":{"docs":{},"df":0,"h":{"docs":{"5":{"tf":1}},"df":1}},"z":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"21":{"tf":1},"62":{"tf":1.7320508075688772},"65":{"tf":1},"80":{"tf":1},"209":{"tf":1.7320508075688772}},"df":5}}}},"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"40":{"tf":1},"51":{"tf":1},"56":{"tf":1},"62":{"tf":1},"178":{"tf":1.4142135623730951},"189":{"tf":1},"192":{"tf":1.4142135623730951},"204":{"tf":1},"217":{"tf":1},"218":{"tf":1},"219":{"tf":1},"227":{"tf":1},"228":{"tf":1},"259":{"tf":1}},"df":14}},"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"74":{"tf":1},"111":{"tf":1.4142135623730951},"129":{"tf":1},"130":{"tf":1},"131":{"tf":1},"144":{"tf":1},"158":{"tf":1},"205":{"tf":1},"227":{"tf":1}},"df":9}}},"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"204":{"tf":1.4142135623730951}},"df":1}}}}}}}}}}}}},"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{"3":{"tf":1},"222":{"tf":1},"227":{"tf":1},"233":{"tf":1},"248":{"tf":1},"262":{"tf":1.4142135623730951},"265":{"tf":1},"267":{"tf":1},"275":{"tf":1}},"df":9}}},"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"14":{"tf":1},"21":{"tf":1},"40":{"tf":1},"63":{"tf":1.7320508075688772},"173":{"tf":1},"175":{"tf":1},"181":{"tf":1},"191":{"tf":1.4142135623730951},"199":{"tf":1.4142135623730951},"201":{"tf":1},"204":{"tf":1.4142135623730951},"216":{"tf":1},"237":{"tf":1},"241":{"tf":1},"242":{"tf":1}},"df":15}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"'":{"docs":{"43":{"tf":1}},"df":1},"e":{"docs":{},"df":0,"v":{"docs":{"220":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{"94":{"tf":1},"167":{"tf":1},"168":{"tf":1},"170":{"tf":1},"195":{"tf":1},"204":{"tf":1.4142135623730951}},"df":6}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"192":{"tf":1.4142135623730951}},"df":1}}}}}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{"11":{"tf":1},"43":{"tf":1},"50":{"tf":1},"89":{"tf":1.4142135623730951},"98":{"tf":1},"144":{"tf":1},"154":{"tf":1},"155":{"tf":1},"157":{"tf":1},"163":{"tf":1},"164":{"tf":1},"168":{"tf":1},"181":{"tf":1.4142135623730951},"259":{"tf":1},"280":{"tf":1}},"df":15,"f":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"3":{"tf":1},"8":{"tf":1},"216":{"tf":1},"217":{"tf":1},"265":{"tf":1}},"df":5}}}}},"l":{"docs":{},"df":0,"d":{"docs":{"54":{"tf":1}},"df":1}},"d":{"docs":{"154":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1}},"df":1}}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{"3":{"tf":1},"4":{"tf":1},"27":{"tf":1},"190":{"tf":1.4142135623730951},"191":{"tf":1.7320508075688772},"199":{"tf":1},"200":{"tf":1},"204":{"tf":1}},"df":8,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"190":{"tf":1}},"df":1}}}}}}}}}}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"55":{"tf":1}},"df":1}}}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"141":{"tf":1},"162":{"tf":1},"163":{"tf":1},"168":{"tf":1},"205":{"tf":1}},"df":5}}},"a":{"docs":{},"df":0,"p":{"docs":{"154":{"tf":1.4142135623730951},"157":{"tf":1}},"df":2}}},"a":{"docs":{},"df":0,"y":{"docs":{"4":{"tf":1},"38":{"tf":1},"47":{"tf":1},"51":{"tf":1.4142135623730951},"77":{"tf":1},"93":{"tf":1.4142135623730951},"117":{"tf":1},"129":{"tf":1},"141":{"tf":1},"163":{"tf":1.4142135623730951},"168":{"tf":1},"170":{"tf":1},"217":{"tf":1.4142135623730951},"218":{"tf":1},"219":{"tf":1.4142135623730951},"238":{"tf":1}},"df":16},"r":{"docs":{},"df":0,"n":{"docs":{"14":{"tf":1},"135":{"tf":1},"272":{"tf":1.4142135623730951}},"df":3}},"n":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1},"21":{"tf":1},"43":{"tf":1},"55":{"tf":1.4142135623730951},"72":{"tf":1},"74":{"tf":1},"81":{"tf":1},"89":{"tf":1},"111":{"tf":1},"117":{"tf":1.4142135623730951},"120":{"tf":1},"123":{"tf":1},"144":{"tf":1.4142135623730951},"147":{"tf":1.4142135623730951},"155":{"tf":1},"167":{"tf":1},"168":{"tf":1.4142135623730951},"170":{"tf":1},"178":{"tf":1},"200":{"tf":1},"204":{"tf":1},"218":{"tf":1},"220":{"tf":1.4142135623730951},"222":{"tf":1},"227":{"tf":1},"233":{"tf":1.4142135623730951},"241":{"tf":2},"247":{"tf":1},"259":{"tf":1},"269":{"tf":1},"270":{"tf":1},"271":{"tf":1},"272":{"tf":1},"274":{"tf":1},"284":{"tf":1}},"df":35}},"i":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1.7320508075688772},"47":{"tf":1},"70":{"tf":1},"199":{"tf":1},"200":{"tf":1},"242":{"tf":1},"265":{"tf":1.4142135623730951}},"df":7}},"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"167":{"tf":1.4142135623730951}},"df":1}}}},"w":{"docs":{},"df":0,"w":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"/":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"/":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,".":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"/":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"n":{"docs":{"38":{"tf":1}},"df":1,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979}},"df":2}}},"m":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1},"20":{"tf":1},"21":{"tf":1},"55":{"tf":1},"63":{"tf":1},"64":{"tf":1},"66":{"tf":1},"71":{"tf":1},"73":{"tf":1},"93":{"tf":1.4142135623730951},"96":{"tf":1},"101":{"tf":1.4142135623730951},"111":{"tf":1.4142135623730951},"129":{"tf":1},"147":{"tf":1.4142135623730951},"154":{"tf":1.7320508075688772},"155":{"tf":1.4142135623730951},"157":{"tf":2.23606797749979},"163":{"tf":1},"164":{"tf":1},"173":{"tf":1},"174":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"178":{"tf":1},"204":{"tf":2.449489742783178},"205":{"tf":1},"220":{"tf":1.4142135623730951},"221":{"tf":2},"225":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"227":{"tf":1.7320508075688772},"235":{"tf":1},"241":{"tf":1.7320508075688772},"270":{"tf":1},"271":{"tf":1.4142135623730951},"272":{"tf":1.7320508075688772},"274":{"tf":1.4142135623730951},"280":{"tf":1.7320508075688772},"286":{"tf":1},"287":{"tf":1}},"df":40}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"14":{"tf":1},"15":{"tf":1},"43":{"tf":1},"120":{"tf":1},"142":{"tf":1},"204":{"tf":1}},"df":6}}}},"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"4":{"tf":1},"20":{"tf":1},"21":{"tf":1},"43":{"tf":1},"55":{"tf":1},"93":{"tf":1},"97":{"tf":1},"104":{"tf":1},"155":{"tf":1.7320508075688772},"157":{"tf":1},"162":{"tf":1},"163":{"tf":1},"168":{"tf":1},"178":{"tf":1.4142135623730951},"181":{"tf":2},"199":{"tf":1},"200":{"tf":1},"204":{"tf":1.7320508075688772},"238":{"tf":1},"258":{"tf":1},"267":{"tf":1},"272":{"tf":1}},"df":23}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1},"65":{"tf":1},"69":{"tf":1},"96":{"tf":1},"181":{"tf":1},"237":{"tf":1},"241":{"tf":2.449489742783178}},"df":7}}}}}}},"g":{"docs":{"5":{"tf":1}},"df":1},"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{"14":{"tf":1.4142135623730951}},"df":1}}}}},"x":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"25":{"tf":1},"27":{"tf":1.4142135623730951},"38":{"tf":1},"63":{"tf":1},"72":{"tf":1},"80":{"tf":1},"81":{"tf":1},"120":{"tf":1},"124":{"tf":1},"125":{"tf":1},"126":{"tf":1.4142135623730951},"129":{"tf":1},"130":{"tf":1},"135":{"tf":1},"155":{"tf":1},"156":{"tf":1},"161":{"tf":1},"167":{"tf":1},"168":{"tf":1},"173":{"tf":1},"178":{"tf":1},"204":{"tf":1.7320508075688772},"219":{"tf":1},"221":{"tf":1},"222":{"tf":1},"233":{"tf":1},"235":{"tf":1},"238":{"tf":1.4142135623730951},"241":{"tf":1},"255":{"tf":1},"263":{"tf":1},"270":{"tf":1},"280":{"tf":1}},"df":34}},"w":{"docs":{"62":{"tf":1.4142135623730951},"163":{"tf":1},"168":{"tf":1},"181":{"tf":1},"204":{"tf":1.4142135623730951},"205":{"tf":1.4142135623730951},"206":{"tf":1},"218":{"tf":1},"221":{"tf":1},"241":{"tf":2},"262":{"tf":1},"271":{"tf":2},"272":{"tf":1},"280":{"tf":1}},"df":14,"l":{"docs":{},"df":0,"i":{"docs":{"93":{"tf":1},"154":{"tf":1},"168":{"tf":1},"241":{"tf":1.7320508075688772},"278":{"tf":1}},"df":5}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"204":{"tf":1}},"df":1}}},"s":{"docs":{},"df":0,"t":{"docs":{"219":{"tf":1},"228":{"tf":1.4142135623730951},"244":{"tf":1}},"df":3}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"274":{"tf":1}},"df":1}}}}},"o":{"docs":{},"df":0,"w":{"docs":{"4":{"tf":1},"46":{"tf":1},"50":{"tf":1},"66":{"tf":1},"71":{"tf":1},"72":{"tf":1},"74":{"tf":1},"97":{"tf":1},"98":{"tf":1.4142135623730951},"107":{"tf":1},"117":{"tf":1},"123":{"tf":1.4142135623730951},"130":{"tf":1},"135":{"tf":1},"143":{"tf":1.4142135623730951},"147":{"tf":1},"163":{"tf":1},"168":{"tf":1},"169":{"tf":1},"188":{"tf":1},"204":{"tf":1},"209":{"tf":1.4142135623730951},"221":{"tf":1.4142135623730951},"222":{"tf":1},"224":{"tf":1},"226":{"tf":1},"234":{"tf":1},"235":{"tf":1},"236":{"tf":1},"237":{"tf":1},"238":{"tf":1},"241":{"tf":1.4142135623730951},"243":{"tf":1},"247":{"tf":1},"251":{"tf":1.4142135623730951},"252":{"tf":1},"262":{"tf":1.4142135623730951},"265":{"tf":1},"266":{"tf":1},"272":{"tf":1},"274":{"tf":1},"275":{"tf":1},"277":{"tf":1},"280":{"tf":1.4142135623730951},"282":{"tf":1},"284":{"tf":1},"286":{"tf":1}},"df":47},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1}},"df":1}},"e":{"docs":{"21":{"tf":1},"64":{"tf":1},"126":{"tf":1},"200":{"tf":1},"263":{"tf":1}},"df":5},"i":{"docs":{},"df":0,"c":{"docs":{"38":{"tf":1},"114":{"tf":1},"123":{"tf":1},"185":{"tf":1}},"df":4}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"199":{"tf":1},"200":{"tf":1.4142135623730951},"201":{"tf":1.4142135623730951}},"df":3}}}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{"15":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":2.8284271247461903},"26":{"tf":1.7320508075688772},"27":{"tf":1.7320508075688772},"31":{"tf":1},"32":{"tf":1},"33":{"tf":1},"38":{"tf":2.6457513110645907},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1},"51":{"tf":1.4142135623730951},"66":{"tf":1},"71":{"tf":1},"72":{"tf":1},"73":{"tf":1},"77":{"tf":1},"80":{"tf":3.1622776601683795},"81":{"tf":3},"82":{"tf":1},"83":{"tf":1},"93":{"tf":2},"94":{"tf":2.23606797749979},"95":{"tf":1},"97":{"tf":2.23606797749979},"101":{"tf":2.449489742783178},"104":{"tf":1},"107":{"tf":1},"111":{"tf":1.4142135623730951},"114":{"tf":2},"117":{"tf":1},"118":{"tf":1},"120":{"tf":2.23606797749979},"123":{"tf":2.23606797749979},"124":{"tf":2.23606797749979},"125":{"tf":1.4142135623730951},"126":{"tf":3},"129":{"tf":2},"130":{"tf":2},"131":{"tf":1.4142135623730951},"136":{"tf":1.4142135623730951},"137":{"tf":1},"141":{"tf":2.23606797749979},"142":{"tf":1.4142135623730951},"143":{"tf":1.7320508075688772},"147":{"tf":1},"154":{"tf":2.23606797749979},"155":{"tf":1.7320508075688772},"156":{"tf":1.4142135623730951},"157":{"tf":2},"158":{"tf":1},"161":{"tf":1},"162":{"tf":1.7320508075688772},"163":{"tf":1.7320508075688772},"164":{"tf":2},"168":{"tf":2.449489742783178},"169":{"tf":1},"170":{"tf":2},"173":{"tf":3},"174":{"tf":1.7320508075688772},"175":{"tf":2.6457513110645907},"178":{"tf":2},"181":{"tf":2.449489742783178},"192":{"tf":1},"195":{"tf":2},"198":{"tf":1.4142135623730951},"199":{"tf":1.7320508075688772},"200":{"tf":1},"201":{"tf":3.4641016151377544},"204":{"tf":7.211102550927978},"205":{"tf":1},"206":{"tf":1.4142135623730951},"217":{"tf":2},"218":{"tf":2},"220":{"tf":3.1622776601683795},"222":{"tf":2},"223":{"tf":1},"224":{"tf":1},"225":{"tf":1},"228":{"tf":1},"232":{"tf":1},"233":{"tf":1},"235":{"tf":2.23606797749979},"237":{"tf":2.23606797749979},"238":{"tf":1.7320508075688772},"239":{"tf":1},"241":{"tf":1.4142135623730951},"242":{"tf":1},"247":{"tf":2.449489742783178},"250":{"tf":1},"251":{"tf":2.23606797749979},"254":{"tf":1},"265":{"tf":1},"272":{"tf":2},"274":{"tf":1},"277":{"tf":1},"280":{"tf":1}},"df":101,"'":{"docs":{"173":{"tf":1}},"df":1}}},"n":{"docs":{},"df":0,"e":{"docs":{"21":{"tf":1}},"df":1}},"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"253":{"tf":1},"262":{"tf":1},"281":{"tf":1}},"df":3}}}}},"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"27":{"tf":1},"40":{"tf":1},"80":{"tf":1},"86":{"tf":1},"120":{"tf":1},"175":{"tf":1},"181":{"tf":1},"204":{"tf":2.449489742783178}},"df":8}}},"e":{"docs":{},"df":0,"r":{"docs":{"107":{"tf":1},"108":{"tf":1.7320508075688772}},"df":2}}},"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"233":{"tf":1}},"df":1}}}}}}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"3":{"tf":1.7320508075688772},"259":{"tf":1}},"df":2}}}},"n":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1},"216":{"tf":1.7320508075688772}},"df":2}},"b":{"docs":{"147":{"tf":1}},"df":1}},"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"26":{"tf":1},"27":{"tf":1},"80":{"tf":1},"86":{"tf":1},"218":{"tf":1},"241":{"tf":1}},"df":6}},"w":{"docs":{"86":{"tf":1}},"df":1}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"204":{"tf":1.4142135623730951},"274":{"tf":1}},"df":2,"l":{"docs":{},"df":0,"i":{"docs":{"111":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{"3":{"tf":1},"43":{"tf":1},"93":{"tf":1},"101":{"tf":1}},"df":4,"n":{"docs":{"21":{"tf":1},"26":{"tf":1},"204":{"tf":1.4142135623730951}},"df":3}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"4":{"tf":1.4142135623730951},"40":{"tf":1},"54":{"tf":1.4142135623730951},"55":{"tf":2},"56":{"tf":1},"62":{"tf":1},"65":{"tf":1},"66":{"tf":1},"80":{"tf":1},"162":{"tf":1},"204":{"tf":1},"209":{"tf":1},"232":{"tf":1},"259":{"tf":1},"262":{"tf":1.4142135623730951}},"df":16}}},"t":{"docs":{"4":{"tf":1},"14":{"tf":1},"43":{"tf":1.4142135623730951},"124":{"tf":1},"168":{"tf":1},"178":{"tf":1},"206":{"tf":1},"212":{"tf":1},"224":{"tf":1},"226":{"tf":1},"237":{"tf":1},"258":{"tf":1},"265":{"tf":1.4142135623730951},"272":{"tf":1},"282":{"tf":1},"286":{"tf":1}},"df":16,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"190":{"tf":1}},"df":1}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{"190":{"tf":1}},"df":1}}},"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"204":{"tf":1.4142135623730951}},"df":1}}}}}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"173":{"tf":1}},"df":1}}}}}}},"u":{"docs":{},"df":0,"i":{"docs":{"104":{"tf":1.4142135623730951}},"df":1,"d":{"docs":{"4":{"tf":1}},"df":1}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{"231":{"tf":1},"247":{"tf":1}},"df":2}}}}}}},"o":{"docs":{"50":{"tf":1},"209":{"tf":1.4142135623730951}},"df":2,"e":{"docs":{"27":{"tf":1},"129":{"tf":1},"181":{"tf":1}},"df":3},"o":{"docs":{},"df":0,"d":{"docs":{"54":{"tf":1},"93":{"tf":1}},"df":2}},"a":{"docs":{},"df":0,"l":{"docs":{"238":{"tf":1},"251":{"tf":1}},"df":2}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"40":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"n":{"docs":{"97":{"tf":1}},"df":1}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"163":{"tf":1.4142135623730951},"173":{"tf":1.4142135623730951},"175":{"tf":1},"178":{"tf":2.23606797749979},"227":{"tf":1},"233":{"tf":1},"251":{"tf":1},"254":{"tf":1}},"df":8}}}}}},"u":{"docs":{},"df":0,"s":{"docs":{"3":{"tf":2},"4":{"tf":2},"14":{"tf":1},"21":{"tf":2},"26":{"tf":1.4142135623730951},"27":{"tf":1},"34":{"tf":1.4142135623730951},"38":{"tf":1},"39":{"tf":1},"43":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"63":{"tf":1},"82":{"tf":1},"83":{"tf":1},"95":{"tf":1},"97":{"tf":1},"101":{"tf":1.4142135623730951},"108":{"tf":1},"111":{"tf":1},"114":{"tf":2.8284271247461903},"120":{"tf":1},"126":{"tf":1},"129":{"tf":1},"132":{"tf":1},"135":{"tf":1},"141":{"tf":1},"144":{"tf":1},"147":{"tf":1.4142135623730951},"150":{"tf":2},"154":{"tf":1},"155":{"tf":1.7320508075688772},"157":{"tf":1},"162":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"164":{"tf":1},"167":{"tf":1.7320508075688772},"168":{"tf":1.4142135623730951},"175":{"tf":1},"178":{"tf":2.6457513110645907},"181":{"tf":1.7320508075688772},"185":{"tf":1.7320508075688772},"190":{"tf":1},"200":{"tf":1},"204":{"tf":2},"209":{"tf":1},"212":{"tf":1},"215":{"tf":1},"216":{"tf":1.7320508075688772},"217":{"tf":1},"220":{"tf":1.7320508075688772},"221":{"tf":1},"223":{"tf":1},"224":{"tf":1},"225":{"tf":1},"227":{"tf":1},"228":{"tf":1},"233":{"tf":1},"234":{"tf":1.4142135623730951},"237":{"tf":1},"241":{"tf":1},"244":{"tf":1},"254":{"tf":1},"255":{"tf":1.4142135623730951},"263":{"tf":1},"264":{"tf":1},"265":{"tf":1.7320508075688772},"267":{"tf":1},"269":{"tf":1},"270":{"tf":1},"272":{"tf":1},"274":{"tf":1},"275":{"tf":1.4142135623730951},"277":{"tf":1},"280":{"tf":1.7320508075688772},"284":{"tf":2},"286":{"tf":1},"287":{"tf":1}},"df":78,"e":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":1},"104":{"tf":1},"209":{"tf":1},"216":{"tf":1},"228":{"tf":1},"238":{"tf":1},"241":{"tf":1.4142135623730951},"255":{"tf":1.4142135623730951}},"df":9,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"70":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"77":{"tf":1},"162":{"tf":1},"238":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"g":{"docs":{"190":{"tf":1},"259":{"tf":1},"282":{"tf":1}},"df":3},"b":{"docs":{},"df":0,"l":{"docs":{"233":{"tf":1}},"df":1}}}},"i":{"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":2},"8":{"tf":1},"204":{"tf":1},"258":{"tf":1},"259":{"tf":1.4142135623730951},"262":{"tf":1},"270":{"tf":1}},"df":8},"p":{"docs":{"3":{"tf":1},"4":{"tf":1},"14":{"tf":1.7320508075688772},"21":{"tf":1},"33":{"tf":1},"37":{"tf":1},"40":{"tf":1},"80":{"tf":1},"209":{"tf":1},"219":{"tf":1},"241":{"tf":1.7320508075688772},"262":{"tf":1},"271":{"tf":1},"275":{"tf":1},"277":{"tf":1}},"df":15,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"80":{"tf":1},"141":{"tf":1},"142":{"tf":1.4142135623730951},"265":{"tf":1}},"df":4}}},"o":{"docs":{},"df":0,"n":{"docs":{"132":{"tf":1}},"df":1}}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"14":{"tf":1},"62":{"tf":1},"63":{"tf":1},"65":{"tf":1},"70":{"tf":1},"71":{"tf":1},"72":{"tf":1},"141":{"tf":1},"169":{"tf":1},"181":{"tf":1},"262":{"tf":1.4142135623730951},"265":{"tf":1},"277":{"tf":1},"282":{"tf":1}},"df":14,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"157":{"tf":1},"163":{"tf":1}},"df":2}}}}}}}},"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{"32":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"47":{"tf":1},"70":{"tf":1},"178":{"tf":1.4142135623730951},"204":{"tf":1}},"df":4}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"55":{"tf":1}},"df":1}}}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"80":{"tf":1},"81":{"tf":1}},"df":2}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"251":{"tf":1}},"df":1}}}}}}}}},"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"250":{"tf":1}},"df":1}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"250":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{"274":{"tf":1},"277":{"tf":1}},"df":2}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"190":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"8":{"tf":2},"11":{"tf":1},"14":{"tf":1},"15":{"tf":1.4142135623730951},"16":{"tf":1},"21":{"tf":2},"27":{"tf":2},"28":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"43":{"tf":2},"47":{"tf":1},"50":{"tf":1},"51":{"tf":1},"54":{"tf":1},"55":{"tf":1.4142135623730951},"56":{"tf":2},"59":{"tf":1},"63":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"74":{"tf":1},"77":{"tf":2},"81":{"tf":1.4142135623730951},"86":{"tf":1},"89":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"94":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":1},"98":{"tf":1},"101":{"tf":2},"104":{"tf":2.23606797749979},"107":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"111":{"tf":1},"114":{"tf":3},"117":{"tf":1},"120":{"tf":2},"123":{"tf":1.7320508075688772},"124":{"tf":1.4142135623730951},"126":{"tf":2.23606797749979},"129":{"tf":1.7320508075688772},"132":{"tf":1.4142135623730951},"135":{"tf":1},"137":{"tf":1},"138":{"tf":1},"141":{"tf":2.23606797749979},"142":{"tf":1},"143":{"tf":1},"147":{"tf":2},"150":{"tf":1.4142135623730951},"153":{"tf":1},"154":{"tf":1.7320508075688772},"155":{"tf":2},"156":{"tf":1},"157":{"tf":3.4641016151377544},"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"163":{"tf":2.6457513110645907},"164":{"tf":2.449489742783178},"167":{"tf":2.23606797749979},"168":{"tf":4.123105625617661},"169":{"tf":1.4142135623730951},"170":{"tf":1},"173":{"tf":2.23606797749979},"174":{"tf":2},"175":{"tf":2.23606797749979},"178":{"tf":3.605551275463989},"181":{"tf":2.6457513110645907},"184":{"tf":1.4142135623730951},"185":{"tf":1},"191":{"tf":1.7320508075688772},"198":{"tf":1.4142135623730951},"199":{"tf":1.7320508075688772},"200":{"tf":1},"201":{"tf":2.449489742783178},"204":{"tf":6},"205":{"tf":1},"209":{"tf":1.4142135623730951},"212":{"tf":1},"215":{"tf":1},"220":{"tf":1.7320508075688772},"221":{"tf":1.7320508075688772},"224":{"tf":1},"225":{"tf":2},"227":{"tf":2},"228":{"tf":2},"231":{"tf":1},"233":{"tf":2.23606797749979},"237":{"tf":2},"238":{"tf":1.7320508075688772},"239":{"tf":1.4142135623730951},"241":{"tf":2.449489742783178},"242":{"tf":2},"243":{"tf":1},"247":{"tf":1.7320508075688772},"248":{"tf":1},"250":{"tf":2.23606797749979},"251":{"tf":1.7320508075688772},"252":{"tf":1.4142135623730951},"253":{"tf":1},"254":{"tf":1},"255":{"tf":1.7320508075688772},"258":{"tf":1},"259":{"tf":1.4142135623730951},"262":{"tf":1.4142135623730951},"263":{"tf":1},"265":{"tf":2.449489742783178},"266":{"tf":1},"269":{"tf":1.4142135623730951},"270":{"tf":1.4142135623730951},"271":{"tf":1},"272":{"tf":2},"274":{"tf":1},"275":{"tf":1},"277":{"tf":1.7320508075688772},"280":{"tf":2},"281":{"tf":1},"282":{"tf":1},"283":{"tf":1},"284":{"tf":2},"286":{"tf":1},"288":{"tf":1},"289":{"tf":1}},"df":131,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"3":{"tf":1.4142135623730951}},"df":1}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"69":{"tf":1},"104":{"tf":1},"126":{"tf":1},"168":{"tf":1},"189":{"tf":1},"204":{"tf":1}},"df":7}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"114":{"tf":1},"117":{"tf":1},"147":{"tf":1},"167":{"tf":1},"252":{"tf":1}},"df":5}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"163":{"tf":1},"178":{"tf":1},"204":{"tf":1},"255":{"tf":1},"272":{"tf":1},"280":{"tf":1}},"df":6}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{"178":{"tf":1.4142135623730951}},"df":1}}}}},"g":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"114":{"tf":1}},"df":2}},"n":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"252":{"tf":1},"277":{"tf":1},"280":{"tf":1}},"df":4},"t":{"docs":{"39":{"tf":1}},"df":1}}},"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"114":{"tf":1}},"df":2}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{"231":{"tf":1},"233":{"tf":1}},"df":2,"t":{"docs":{"4":{"tf":1},"269":{"tf":1}},"df":2}}}}}}},"p":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"4":{"tf":1},"86":{"tf":1},"96":{"tf":1},"216":{"tf":1}},"df":5}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"185":{"tf":1},"233":{"tf":1}},"df":3}}}},"x":{"docs":{"107":{"tf":1.7320508075688772},"108":{"tf":2.8284271247461903},"111":{"tf":1},"173":{"tf":1},"204":{"tf":1.4142135623730951},"221":{"tf":1}},"df":6,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"252":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"c":{"docs":{"14":{"tf":1},"27":{"tf":1},"38":{"tf":1},"107":{"tf":1},"108":{"tf":1},"117":{"tf":1},"120":{"tf":1},"123":{"tf":1},"162":{"tf":1},"262":{"tf":1},"272":{"tf":1}},"df":11},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{"15":{"tf":1},"16":{"tf":1}},"df":2}}}}}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1}},"df":1}}},"d":{"docs":{"71":{"tf":1},"72":{"tf":1},"155":{"tf":1},"175":{"tf":1}},"df":4}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"14":{"tf":1},"63":{"tf":1},"66":{"tf":1},"89":{"tf":1},"184":{"tf":1}},"df":5},"n":{"docs":{},"df":0,"c":{"docs":{"280":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"82":{"tf":1},"83":{"tf":1},"111":{"tf":1},"114":{"tf":1},"168":{"tf":1},"181":{"tf":1},"242":{"tf":1},"274":{"tf":1}},"df":8}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"168":{"tf":1},"255":{"tf":1.4142135623730951},"272":{"tf":1},"275":{"tf":1}},"df":4}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"46":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"71":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"81":{"tf":1},"93":{"tf":2},"95":{"tf":1.4142135623730951},"96":{"tf":1},"155":{"tf":1},"161":{"tf":1},"162":{"tf":1},"167":{"tf":1},"173":{"tf":1.4142135623730951},"174":{"tf":1},"184":{"tf":1},"204":{"tf":2.23606797749979},"220":{"tf":2.6457513110645907},"221":{"tf":2.23606797749979},"222":{"tf":1.7320508075688772},"235":{"tf":1.4142135623730951},"238":{"tf":1.4142135623730951},"247":{"tf":1.4142135623730951},"251":{"tf":1},"272":{"tf":1.7320508075688772},"274":{"tf":1},"280":{"tf":1}},"df":24}}},"u":{"docs":{},"df":0,"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{"233":{"tf":1}},"df":1}}}}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"37":{"tf":1},"40":{"tf":1.4142135623730951},"43":{"tf":1},"56":{"tf":1},"81":{"tf":1},"104":{"tf":1.7320508075688772},"111":{"tf":1},"141":{"tf":1},"143":{"tf":1},"157":{"tf":1},"162":{"tf":1},"164":{"tf":1},"173":{"tf":1},"175":{"tf":1},"181":{"tf":1},"270":{"tf":1}},"df":16}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"204":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"d":{"docs":{"38":{"tf":1},"56":{"tf":1},"124":{"tf":1},"174":{"tf":1},"181":{"tf":2.23606797749979}},"df":5}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"167":{"tf":1},"169":{"tf":1}},"df":2}}}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"162":{"tf":1}},"df":1}}}}},"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"v":{"docs":{"263":{"tf":1}},"df":1}}}}},"f":{"docs":{"3":{"tf":1},"14":{"tf":1},"20":{"tf":1},"21":{"tf":2.23606797749979},"38":{"tf":1},"40":{"tf":1},"47":{"tf":1},"55":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1},"71":{"tf":1},"72":{"tf":1},"80":{"tf":1},"81":{"tf":1},"89":{"tf":1},"98":{"tf":1},"101":{"tf":1},"107":{"tf":1},"120":{"tf":1.4142135623730951},"123":{"tf":1},"126":{"tf":1.4142135623730951},"135":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"147":{"tf":1},"154":{"tf":1},"157":{"tf":1},"162":{"tf":1.4142135623730951},"163":{"tf":1},"173":{"tf":1},"174":{"tf":1},"175":{"tf":1},"178":{"tf":2.23606797749979},"181":{"tf":2.23606797749979},"195":{"tf":1},"198":{"tf":1.4142135623730951},"199":{"tf":1.4142135623730951},"200":{"tf":1},"201":{"tf":2.6457513110645907},"204":{"tf":3.3166247903554},"209":{"tf":1},"217":{"tf":1},"218":{"tf":1},"219":{"tf":1},"220":{"tf":1},"222":{"tf":1},"226":{"tf":1},"227":{"tf":1.4142135623730951},"231":{"tf":1},"233":{"tf":1.7320508075688772},"234":{"tf":1},"237":{"tf":2},"239":{"tf":1},"241":{"tf":2.6457513110645907},"242":{"tf":1},"243":{"tf":1.4142135623730951},"246":{"tf":1},"247":{"tf":1},"250":{"tf":1},"252":{"tf":1},"254":{"tf":1},"255":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"270":{"tf":1.4142135623730951},"272":{"tf":1},"285":{"tf":1},"286":{"tf":1},"287":{"tf":1}},"df":67},"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"111":{"tf":1},"154":{"tf":1},"181":{"tf":1.4142135623730951},"184":{"tf":1},"195":{"tf":1.4142135623730951},"204":{"tf":1},"215":{"tf":1},"216":{"tf":1.7320508075688772},"217":{"tf":1.4142135623730951},"219":{"tf":1},"220":{"tf":1},"222":{"tf":1},"231":{"tf":1},"233":{"tf":1.4142135623730951},"234":{"tf":1},"241":{"tf":1.7320508075688772},"242":{"tf":1.4142135623730951},"243":{"tf":1},"250":{"tf":1.4142135623730951},"254":{"tf":1},"258":{"tf":1},"259":{"tf":1}},"df":23}}}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"54":{"tf":1},"55":{"tf":1},"83":{"tf":1},"86":{"tf":1},"107":{"tf":1},"157":{"tf":1},"162":{"tf":1},"191":{"tf":1},"192":{"tf":1},"195":{"tf":1},"204":{"tf":1},"231":{"tf":1},"233":{"tf":1.4142135623730951},"254":{"tf":1.4142135623730951},"259":{"tf":1},"266":{"tf":1},"272":{"tf":1}},"df":17}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"111":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"v":{"docs":{"178":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{"14":{"tf":1},"101":{"tf":1},"131":{"tf":1},"147":{"tf":1.4142135623730951},"274":{"tf":1}},"df":5}}}},"a":{"docs":{},"df":0,"g":{"docs":{"39":{"tf":1},"40":{"tf":1},"72":{"tf":1}},"df":3,"i":{"docs":{},"df":0,"n":{"docs":{"219":{"tf":1},"233":{"tf":1},"259":{"tf":1}},"df":3}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"4":{"tf":1},"43":{"tf":1},"107":{"tf":1.4142135623730951},"108":{"tf":1.7320508075688772},"135":{"tf":1.4142135623730951},"144":{"tf":1},"168":{"tf":1},"181":{"tf":1},"204":{"tf":2.6457513110645907},"205":{"tf":1},"206":{"tf":1},"265":{"tf":1.4142135623730951}},"df":12,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"204":{"tf":1.4142135623730951}},"df":1}}}}}},"r":{"docs":{"204":{"tf":2.23606797749979},"215":{"tf":1},"221":{"tf":1.4142135623730951},"228":{"tf":1}},"df":4}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"f":{"docs":{"108":{"tf":1},"162":{"tf":1},"174":{"tf":1},"184":{"tf":1},"220":{"tf":1},"228":{"tf":1}},"df":6}}}},"'":{"docs":{"209":{"tf":1},"237":{"tf":1}},"df":2}},"d":{"docs":{"107":{"tf":1},"108":{"tf":1.7320508075688772},"111":{"tf":1},"114":{"tf":1},"204":{"tf":2},"272":{"tf":1},"274":{"tf":2},"287":{"tf":1}},"df":8,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"8":{"tf":1},"32":{"tf":1},"89":{"tf":1},"90":{"tf":1},"154":{"tf":1}},"df":5,"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{"73":{"tf":1},"89":{"tf":1},"185":{"tf":1}},"df":3}}}}}}},"o":{"docs":{"8":{"tf":1.4142135623730951},"14":{"tf":1},"19":{"tf":1.4142135623730951},"20":{"tf":1},"21":{"tf":1.4142135623730951},"63":{"tf":2},"82":{"tf":1},"83":{"tf":1}},"df":8},".":{"docs":{"27":{"tf":1},"120":{"tf":1},"123":{"tf":1},"124":{"tf":1},"126":{"tf":1},"129":{"tf":1},"168":{"tf":1},"184":{"tf":1},"204":{"tf":1},"216":{"tf":1},"221":{"tf":1},"225":{"tf":1},"237":{"tf":1},"255":{"tf":1},"262":{"tf":1}},"df":15},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"28":{"tf":1},"56":{"tf":1},"117":{"tf":1}},"df":3}}},"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{"43":{"tf":1},"217":{"tf":1},"241":{"tf":1},"274":{"tf":1}},"df":4}}},"g":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"272":{"tf":1}},"df":1}}}}},"s":{"docs":{},"df":0,"y":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"3":{"tf":1.7320508075688772},"14":{"tf":1},"56":{"tf":1},"189":{"tf":1.4142135623730951},"233":{"tf":1},"241":{"tf":1},"254":{"tf":1},"259":{"tf":1.4142135623730951}},"df":8}}}},"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"81":{"tf":1}},"df":1}}}},"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"x":{"docs":{"157":{"tf":1},"200":{"tf":1.4142135623730951}},"df":2}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"154":{"tf":1},"155":{"tf":1},"212":{"tf":1},"218":{"tf":1},"231":{"tf":1},"237":{"tf":1},"250":{"tf":1},"251":{"tf":1},"262":{"tf":1},"277":{"tf":1},"280":{"tf":1.7320508075688772},"287":{"tf":1}},"df":13}},"c":{"docs":{"54":{"tf":1},"111":{"tf":1},"155":{"tf":1},"181":{"tf":1}},"df":4}},"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"11":{"tf":1},"15":{"tf":1},"16":{"tf":1},"47":{"tf":1},"50":{"tf":1},"59":{"tf":1},"83":{"tf":1},"86":{"tf":1.4142135623730951},"204":{"tf":1.7320508075688772}},"df":9,"i":{"docs":{"43":{"tf":1},"66":{"tf":1},"80":{"tf":1},"130":{"tf":1},"144":{"tf":1},"147":{"tf":1},"161":{"tf":1},"181":{"tf":1},"209":{"tf":1}},"df":9,"f":{"docs":{},"df":0,"i":{"docs":{"111":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"r":{"docs":{"163":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"l":{"docs":{"19":{"tf":1},"20":{"tf":1},"21":{"tf":1}},"df":3,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"z":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{"63":{"tf":1}},"df":1}}}}}}}}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"114":{"tf":1},"163":{"tf":1},"181":{"tf":1.4142135623730951},"238":{"tf":1},"242":{"tf":1},"271":{"tf":1},"284":{"tf":1}},"df":7,"l":{"docs":{},"df":0,"i":{"docs":{"280":{"tf":1}},"df":1}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{"15":{"tf":1},"38":{"tf":1},"56":{"tf":1.4142135623730951},"216":{"tf":1}},"df":4}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"40":{"tf":1},"51":{"tf":1},"147":{"tf":1},"216":{"tf":1},"233":{"tf":1.7320508075688772},"259":{"tf":1},"284":{"tf":1}},"df":7}}}},"b":{"docs":{},"df":0,"l":{"docs":{"125":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"4":{"tf":1},"15":{"tf":1.4142135623730951},"16":{"tf":1},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"80":{"tf":2.23606797749979},"114":{"tf":1},"117":{"tf":1.4142135623730951},"118":{"tf":1},"120":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"135":{"tf":1},"147":{"tf":1},"163":{"tf":1},"164":{"tf":1},"167":{"tf":1},"168":{"tf":1.4142135623730951},"173":{"tf":2.6457513110645907},"174":{"tf":1.4142135623730951},"175":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"185":{"tf":1},"192":{"tf":2},"204":{"tf":2},"209":{"tf":1},"217":{"tf":1.7320508075688772},"218":{"tf":2.23606797749979},"219":{"tf":1},"220":{"tf":1.7320508075688772},"221":{"tf":1.4142135623730951},"222":{"tf":2},"223":{"tf":1},"224":{"tf":1},"225":{"tf":1},"227":{"tf":2},"232":{"tf":1},"233":{"tf":1.4142135623730951},"234":{"tf":1.4142135623730951},"235":{"tf":1.4142135623730951},"237":{"tf":1},"238":{"tf":1.7320508075688772},"239":{"tf":1.7320508075688772},"242":{"tf":2.449489742783178},"243":{"tf":1},"246":{"tf":1.4142135623730951},"248":{"tf":1},"250":{"tf":1.4142135623730951},"252":{"tf":1},"261":{"tf":1},"262":{"tf":1.4142135623730951},"265":{"tf":2.23606797749979},"271":{"tf":1},"277":{"tf":1},"280":{"tf":1.4142135623730951},"281":{"tf":1},"286":{"tf":1.4142135623730951}},"df":59,"u":{"docs":{},"df":0,"p":{"docs":{"4":{"tf":1},"19":{"tf":1.4142135623730951},"20":{"tf":1},"21":{"tf":1.4142135623730951},"51":{"tf":1},"66":{"tf":1},"71":{"tf":1},"72":{"tf":1},"80":{"tf":1.4142135623730951},"107":{"tf":1},"126":{"tf":1.4142135623730951},"173":{"tf":1},"178":{"tf":1},"198":{"tf":1},"199":{"tf":1},"204":{"tf":1.4142135623730951},"209":{"tf":1},"218":{"tf":1},"222":{"tf":1},"232":{"tf":1},"233":{"tf":2},"234":{"tf":1},"235":{"tf":1},"237":{"tf":2},"241":{"tf":1.4142135623730951},"242":{"tf":1},"247":{"tf":1}},"df":27,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"15":{"tf":1},"51":{"tf":1}},"df":2}}}}}}}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"189":{"tf":1}},"df":1}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"223":{"tf":1}},"df":1}}}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"265":{"tf":1}},"df":1}}}},"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1},"16":{"tf":1},"43":{"tf":1},"56":{"tf":1},"65":{"tf":1},"70":{"tf":1},"71":{"tf":1},"72":{"tf":1},"81":{"tf":1},"89":{"tf":1},"101":{"tf":1.4142135623730951},"107":{"tf":1},"123":{"tf":1},"129":{"tf":1},"135":{"tf":1},"163":{"tf":1},"167":{"tf":1},"173":{"tf":1},"178":{"tf":1},"181":{"tf":1},"204":{"tf":1.4142135623730951},"219":{"tf":1},"221":{"tf":1},"233":{"tf":1},"250":{"tf":1},"255":{"tf":1},"260":{"tf":1},"269":{"tf":1},"289":{"tf":1}},"df":29}}}},"u":{"docs":{},"df":0,"r":{"docs":{"14":{"tf":1}},"df":1}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"31":{"tf":1.7320508075688772},"32":{"tf":1},"33":{"tf":1.7320508075688772},"34":{"tf":1},"38":{"tf":1},"39":{"tf":1.4142135623730951},"56":{"tf":1},"81":{"tf":1},"93":{"tf":1},"94":{"tf":1},"97":{"tf":1.4142135623730951},"126":{"tf":1},"129":{"tf":1},"130":{"tf":1},"135":{"tf":1},"147":{"tf":1.4142135623730951},"155":{"tf":1},"161":{"tf":1.4142135623730951},"162":{"tf":1.4142135623730951},"164":{"tf":1},"167":{"tf":1.4142135623730951},"168":{"tf":2},"201":{"tf":1},"215":{"tf":1},"221":{"tf":1},"224":{"tf":1},"228":{"tf":1},"231":{"tf":1},"233":{"tf":1},"239":{"tf":1.4142135623730951},"242":{"tf":1.4142135623730951},"246":{"tf":1},"248":{"tf":1},"252":{"tf":1},"258":{"tf":1},"259":{"tf":1}},"df":36,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"163":{"tf":1.4142135623730951},"168":{"tf":1},"178":{"tf":1}},"df":3}}}}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{"4":{"tf":1},"21":{"tf":1.4142135623730951},"46":{"tf":1},"47":{"tf":1.4142135623730951},"59":{"tf":1},"62":{"tf":1},"65":{"tf":1},"66":{"tf":1},"70":{"tf":1},"71":{"tf":2},"72":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"74":{"tf":1.7320508075688772},"77":{"tf":1},"80":{"tf":1},"81":{"tf":2.6457513110645907},"83":{"tf":1},"86":{"tf":1},"101":{"tf":2.449489742783178},"132":{"tf":1.4142135623730951},"154":{"tf":2.23606797749979},"173":{"tf":1},"198":{"tf":1},"199":{"tf":1},"204":{"tf":1.4142135623730951},"209":{"tf":1.4142135623730951},"218":{"tf":1}},"df":27}}}}},"n":{"docs":{},"df":0,"d":{"docs":{"5":{"tf":1}},"df":1},"t":{"docs":{"15":{"tf":1}},"df":1},"s":{"docs":{"90":{"tf":1},"147":{"tf":1},"154":{"tf":1},"178":{"tf":1}},"df":4,"i":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1}},"df":1},"b":{"docs":{},"df":0,"l":{"docs":{"154":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"26":{"tf":2.23606797749979},"27":{"tf":1},"33":{"tf":1},"38":{"tf":1},"43":{"tf":1},"50":{"tf":1},"54":{"tf":1},"63":{"tf":2.449489742783178},"64":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"73":{"tf":1},"74":{"tf":1.4142135623730951},"77":{"tf":1},"93":{"tf":1},"94":{"tf":1.7320508075688772},"95":{"tf":1},"96":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"117":{"tf":1},"118":{"tf":1},"120":{"tf":1.4142135623730951},"126":{"tf":2},"136":{"tf":1},"141":{"tf":1},"154":{"tf":1},"155":{"tf":1},"157":{"tf":1},"162":{"tf":1},"168":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"188":{"tf":1.4142135623730951},"189":{"tf":1},"191":{"tf":1.4142135623730951},"204":{"tf":3.1622776601683795},"216":{"tf":1},"220":{"tf":1.4142135623730951},"222":{"tf":1},"233":{"tf":1},"235":{"tf":1},"236":{"tf":1},"238":{"tf":1},"241":{"tf":1.7320508075688772},"247":{"tf":1},"251":{"tf":1},"252":{"tf":1},"262":{"tf":1.4142135623730951},"265":{"tf":1.7320508075688772},"267":{"tf":1},"275":{"tf":1}},"df":54}}}},"e":{"docs":{"15":{"tf":1},"20":{"tf":1},"21":{"tf":1},"27":{"tf":1},"50":{"tf":1},"51":{"tf":1},"73":{"tf":1},"74":{"tf":1.4142135623730951},"77":{"tf":1},"98":{"tf":1},"101":{"tf":1},"120":{"tf":1},"131":{"tf":1},"141":{"tf":1},"150":{"tf":1},"154":{"tf":1.4142135623730951},"162":{"tf":1.7320508075688772},"163":{"tf":1},"175":{"tf":1},"181":{"tf":1.7320508075688772},"185":{"tf":1},"200":{"tf":1},"221":{"tf":1},"225":{"tf":1},"226":{"tf":1},"227":{"tf":1},"236":{"tf":1},"237":{"tf":1},"239":{"tf":1},"241":{"tf":1.4142135623730951},"243":{"tf":1.4142135623730951},"248":{"tf":1},"262":{"tf":1.4142135623730951},"270":{"tf":1},"280":{"tf":1},"285":{"tf":1},"286":{"tf":1},"287":{"tf":1}},"df":38,"n":{"docs":{"254":{"tf":1},"289":{"tf":1}},"df":2}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"37":{"tf":1},"108":{"tf":1},"192":{"tf":1.4142135623730951},"212":{"tf":1},"219":{"tf":1},"228":{"tf":1},"239":{"tf":1}},"df":7}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"43":{"tf":2.23606797749979}},"df":1}}}},"r":{"docs":{},"df":0,"i":{"docs":{"72":{"tf":1},"204":{"tf":1.7320508075688772},"233":{"tf":1}},"df":3},"v":{"docs":{"81":{"tf":1}},"df":1}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"93":{"tf":1},"117":{"tf":1},"163":{"tf":1},"216":{"tf":1.4142135623730951},"241":{"tf":1},"255":{"tf":1},"262":{"tf":1},"264":{"tf":1},"265":{"tf":2}},"df":9}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"11":{"tf":1},"15":{"tf":1.4142135623730951},"38":{"tf":1},"80":{"tf":1.7320508075688772},"81":{"tf":1},"83":{"tf":1},"195":{"tf":1.7320508075688772},"199":{"tf":1},"204":{"tf":1.4142135623730951},"241":{"tf":1},"242":{"tf":1},"251":{"tf":1.4142135623730951},"258":{"tf":1},"264":{"tf":1},"270":{"tf":1}},"df":16}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"157":{"tf":1},"190":{"tf":1.7320508075688772}},"df":2}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"254":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"4":{"tf":1},"221":{"tf":1.4142135623730951}},"df":2,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"43":{"tf":1},"129":{"tf":1},"181":{"tf":3},"184":{"tf":1.4142135623730951},"185":{"tf":2},"188":{"tf":1},"204":{"tf":1.7320508075688772},"258":{"tf":1}},"df":9}}}}},"g":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1}},"df":1}},"r":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"14":{"tf":1},"15":{"tf":1},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":3.605551275463989},"47":{"tf":1},"51":{"tf":1.4142135623730951},"55":{"tf":1},"59":{"tf":1},"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"80":{"tf":1},"86":{"tf":1},"89":{"tf":1},"93":{"tf":1},"107":{"tf":1.4142135623730951},"108":{"tf":1},"117":{"tf":1},"118":{"tf":1},"119":{"tf":1},"126":{"tf":1.4142135623730951},"129":{"tf":1},"136":{"tf":1.4142135623730951},"163":{"tf":1},"178":{"tf":1},"198":{"tf":1},"204":{"tf":1.7320508075688772},"209":{"tf":1.7320508075688772},"216":{"tf":1},"218":{"tf":1},"233":{"tf":1},"235":{"tf":1},"237":{"tf":1.4142135623730951},"239":{"tf":1.4142135623730951},"241":{"tf":2.6457513110645907},"243":{"tf":1.7320508075688772},"247":{"tf":1},"252":{"tf":1},"261":{"tf":1},"262":{"tf":1.7320508075688772},"275":{"tf":1}},"df":44,"u":{"docs":{},"df":0,"p":{"docs":{"14":{"tf":1},"163":{"tf":1},"277":{"tf":1}},"df":3}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,".":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"237":{"tf":1},"238":{"tf":1}},"df":2}}}}}}}}}}}}}}}},"t":{"docs":{},"df":0,"u":{"docs":{"27":{"tf":1},"28":{"tf":1},"74":{"tf":1}},"df":3},"e":{"docs":{"51":{"tf":1.4142135623730951},"80":{"tf":1},"126":{"tf":1},"132":{"tf":1}},"df":4}},"m":{"docs":{},"df":0,"p":{"docs":{"38":{"tf":1}},"df":1}},"c":{"docs":{},"df":0,"k":{"docs":{"163":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"169":{"tf":1},"178":{"tf":1},"227":{"tf":1},"255":{"tf":1}},"df":6,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"141":{"tf":1.4142135623730951},"169":{"tf":1}},"df":2}}}}}},"b":{"docs":{},"df":0,"l":{"docs":{"233":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"p":{"docs":{"4":{"tf":1.4142135623730951},"19":{"tf":1},"21":{"tf":1.7320508075688772},"25":{"tf":1},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"65":{"tf":1},"81":{"tf":2},"83":{"tf":1},"89":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"93":{"tf":1},"94":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"97":{"tf":2},"101":{"tf":2.449489742783178},"114":{"tf":2},"123":{"tf":2.6457513110645907},"124":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"129":{"tf":1},"147":{"tf":1},"150":{"tf":1},"153":{"tf":1},"154":{"tf":1.7320508075688772},"156":{"tf":1},"161":{"tf":1},"162":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"168":{"tf":1.7320508075688772},"173":{"tf":1},"209":{"tf":1},"216":{"tf":1},"221":{"tf":1},"222":{"tf":1},"223":{"tf":1},"227":{"tf":1},"228":{"tf":1.4142135623730951},"233":{"tf":1.7320508075688772},"235":{"tf":1},"237":{"tf":1.4142135623730951},"238":{"tf":1},"241":{"tf":2},"242":{"tf":1.4142135623730951},"243":{"tf":1.7320508075688772},"244":{"tf":1},"247":{"tf":1.4142135623730951},"250":{"tf":1.4142135623730951},"251":{"tf":1},"258":{"tf":1},"259":{"tf":2.23606797749979},"262":{"tf":2.23606797749979},"263":{"tf":1},"267":{"tf":1},"271":{"tf":1.4142135623730951},"275":{"tf":1.4142135623730951},"280":{"tf":1},"281":{"tf":1}},"df":62}},"u":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1}},"df":1}}},"o":{"docs":{},"df":0,"p":{"docs":{"15":{"tf":1},"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"51":{"tf":1},"59":{"tf":1},"70":{"tf":1},"72":{"tf":1},"77":{"tf":1},"82":{"tf":1},"83":{"tf":1},"107":{"tf":1.4142135623730951},"125":{"tf":1},"135":{"tf":1},"136":{"tf":1.4142135623730951},"162":{"tf":1},"163":{"tf":1},"167":{"tf":1},"178":{"tf":1},"204":{"tf":1.7320508075688772},"216":{"tf":1},"218":{"tf":1},"232":{"tf":1},"233":{"tf":1},"236":{"tf":1.4142135623730951},"238":{"tf":1},"239":{"tf":1.7320508075688772},"241":{"tf":2},"243":{"tf":1},"247":{"tf":1.4142135623730951},"251":{"tf":1},"262":{"tf":1}},"df":31},"r":{"docs":{},"df":0,"e":{"docs":{"104":{"tf":1.4142135623730951},"169":{"tf":1},"220":{"tf":1}},"df":3}}},"y":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"55":{"tf":1}},"df":1}}}}}}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"143":{"tf":1},"164":{"tf":1.4142135623730951}},"df":2}}}},"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{"38":{"tf":1},"162":{"tf":1},"220":{"tf":2.23606797749979},"221":{"tf":1},"227":{"tf":1}},"df":5}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"101":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{"135":{"tf":1},"170":{"tf":1}},"df":2}},"h":{"docs":{"241":{"tf":1},"271":{"tf":1},"282":{"tf":1}},"df":3}}}},"o":{"docs":{},"df":0,"n":{"docs":{"117":{"tf":1}},"df":1}},"l":{"docs":{},"df":0,"v":{"docs":{"181":{"tf":1},"217":{"tf":1}},"df":2,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"233":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"t":{"docs":{"181":{"tf":1.4142135623730951},"233":{"tf":1},"247":{"tf":1}},"df":3}}}},"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"181":{"tf":1.7320508075688772},"220":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"5":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"39":{"tf":1},"69":{"tf":1},"189":{"tf":1.4142135623730951}},"df":3,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"39":{"tf":1.7320508075688772},"40":{"tf":1.7320508075688772},"141":{"tf":1},"204":{"tf":1.7320508075688772},"260":{"tf":1}},"df":5}}}}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{"216":{"tf":1},"277":{"tf":1},"280":{"tf":1}},"df":3}}}}}}},"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1.4142135623730951},"8":{"tf":1},"43":{"tf":1.7320508075688772},"163":{"tf":1},"259":{"tf":1}},"df":5,"@":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"5":{"tf":1}},"df":1}}}}}}}}}}}}},"s":{"docs":{"39":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"11":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"21":{"tf":1},"27":{"tf":1},"38":{"tf":1},"56":{"tf":1.4142135623730951},"59":{"tf":1},"62":{"tf":1.4142135623730951},"65":{"tf":1},"66":{"tf":1},"74":{"tf":1},"80":{"tf":1.7320508075688772},"83":{"tf":1},"89":{"tf":1.4142135623730951},"97":{"tf":1},"98":{"tf":1},"107":{"tf":1},"118":{"tf":1},"120":{"tf":1.7320508075688772},"123":{"tf":1},"126":{"tf":1},"132":{"tf":1},"136":{"tf":1},"141":{"tf":1},"142":{"tf":1},"143":{"tf":1},"168":{"tf":1.7320508075688772},"173":{"tf":1},"174":{"tf":1},"175":{"tf":1.4142135623730951},"178":{"tf":1.7320508075688772},"181":{"tf":2.6457513110645907},"184":{"tf":1},"185":{"tf":1},"204":{"tf":1.7320508075688772},"212":{"tf":1},"215":{"tf":1.7320508075688772},"219":{"tf":1},"220":{"tf":1.4142135623730951},"227":{"tf":1.7320508075688772},"228":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"234":{"tf":1},"235":{"tf":1},"236":{"tf":1},"238":{"tf":1},"239":{"tf":1.4142135623730951},"242":{"tf":1},"246":{"tf":1},"247":{"tf":1},"250":{"tf":1},"251":{"tf":1},"252":{"tf":1},"258":{"tf":1.4142135623730951},"259":{"tf":2.23606797749979},"260":{"tf":1},"261":{"tf":1.4142135623730951},"262":{"tf":1.7320508075688772},"265":{"tf":1},"266":{"tf":1.4142135623730951},"271":{"tf":1.4142135623730951},"272":{"tf":1},"277":{"tf":1},"286":{"tf":1},"288":{"tf":1}},"df":68,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"62":{"tf":1},"93":{"tf":1},"181":{"tf":1}},"df":3}}}}},"b":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"4":{"tf":1},"135":{"tf":1.4142135623730951},"204":{"tf":2.23606797749979}},"df":3}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"14":{"tf":1},"89":{"tf":1}},"df":2}}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{"19":{"tf":1},"143":{"tf":1}},"df":2}}}},"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"104":{"tf":1},"107":{"tf":1.4142135623730951}},"df":2}}}}},"r":{"docs":{},"df":0,"e":{"docs":{"8":{"tf":1},"66":{"tf":1},"93":{"tf":1},"162":{"tf":1},"204":{"tf":1.4142135623730951}},"df":5},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"38":{"tf":1},"250":{"tf":1}},"df":2}}}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"178":{"tf":1}},"df":1}}}},"t":{"docs":{"14":{"tf":1.4142135623730951},"20":{"tf":1},"39":{"tf":1},"51":{"tf":1},"59":{"tf":1},"63":{"tf":1},"80":{"tf":1},"104":{"tf":1},"132":{"tf":1},"142":{"tf":1},"147":{"tf":1},"163":{"tf":1},"174":{"tf":1},"185":{"tf":1},"216":{"tf":1.4142135623730951},"218":{"tf":1.7320508075688772},"232":{"tf":1},"233":{"tf":2.23606797749979},"235":{"tf":1},"236":{"tf":1},"237":{"tf":1},"238":{"tf":1.4142135623730951},"239":{"tf":2.449489742783178},"241":{"tf":3.605551275463989},"243":{"tf":2},"247":{"tf":1.7320508075688772},"251":{"tf":1},"258":{"tf":1},"261":{"tf":1},"262":{"tf":1.7320508075688772},"265":{"tf":1},"275":{"tf":1}},"df":32},"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"27":{"tf":1},"56":{"tf":1}},"df":2}}}},"h":{"docs":{"39":{"tf":1},"114":{"tf":1},"126":{"tf":1},"147":{"tf":1},"154":{"tf":1},"216":{"tf":1},"241":{"tf":1},"250":{"tf":1},"259":{"tf":1},"272":{"tf":1},"280":{"tf":1.4142135623730951}},"df":11}},"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"47":{"tf":1}},"df":1,"i":{"docs":{"86":{"tf":1}},"df":1}}}}},"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"56":{"tf":1.4142135623730951},"228":{"tf":1},"254":{"tf":1}},"df":3}}}}},"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"101":{"tf":1}},"df":1}}}}},"g":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"129":{"tf":1}},"df":1}}}}},"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"250":{"tf":1}},"df":1}}}}}}},"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"3":{"tf":1}},"df":1}},"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"26":{"tf":1},"72":{"tf":1.4142135623730951},"126":{"tf":1.4142135623730951},"135":{"tf":1},"136":{"tf":1},"137":{"tf":1},"147":{"tf":1},"189":{"tf":1},"248":{"tf":1},"262":{"tf":1}},"df":10}}}},"t":{"docs":{"3":{"tf":1}},"df":1}},"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"4":{"tf":1},"15":{"tf":1},"31":{"tf":1},"33":{"tf":1},"37":{"tf":1},"39":{"tf":1.4142135623730951},"40":{"tf":1},"54":{"tf":1},"93":{"tf":1},"104":{"tf":1},"155":{"tf":1},"162":{"tf":1},"163":{"tf":1},"164":{"tf":1},"168":{"tf":1},"169":{"tf":1},"173":{"tf":1},"219":{"tf":1},"237":{"tf":1}},"df":19,"n":{"docs":{"19":{"tf":1},"72":{"tf":1},"141":{"tf":1}},"df":3}},"r":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1}},"df":1,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"38":{"tf":1},"80":{"tf":1},"95":{"tf":1},"101":{"tf":1},"114":{"tf":2.23606797749979},"120":{"tf":1},"144":{"tf":1},"154":{"tf":1},"168":{"tf":1}},"df":9}}}}}},"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"94":{"tf":1.4142135623730951}},"df":2}},"p":{"docs":{"64":{"tf":1},"181":{"tf":1.4142135623730951}},"df":2}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"47":{"tf":1}},"df":1}},"p":{"docs":{},"df":0,"e":{"docs":{"55":{"tf":1}},"df":1}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{"82":{"tf":1},"83":{"tf":1}},"df":2}}}}}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1},"74":{"tf":1},"81":{"tf":1.7320508075688772},"101":{"tf":1},"111":{"tf":1},"124":{"tf":1.4142135623730951},"130":{"tf":1},"150":{"tf":1},"154":{"tf":1},"155":{"tf":1},"163":{"tf":1},"178":{"tf":1.7320508075688772},"204":{"tf":1},"212":{"tf":1},"216":{"tf":1.7320508075688772},"218":{"tf":1},"224":{"tf":1},"225":{"tf":1},"227":{"tf":1},"237":{"tf":1},"238":{"tf":1.4142135623730951},"251":{"tf":1},"280":{"tf":1}},"df":23},"p":{"docs":{},"df":0,"l":{"docs":{"11":{"tf":1},"215":{"tf":1},"228":{"tf":1},"236":{"tf":1}},"df":4}}},"v":{"docs":{},"df":0,"e":{"docs":{"40":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951},"120":{"tf":1},"238":{"tf":1},"271":{"tf":1}},"df":6}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1}},"df":1}}}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{},"df":0,"f":{"docs":{"21":{"tf":1},"63":{"tf":1},"181":{"tf":1},"185":{"tf":1.4142135623730951},"204":{"tf":1},"217":{"tf":1},"225":{"tf":1},"233":{"tf":1.4142135623730951},"241":{"tf":1},"247":{"tf":1.4142135623730951},"272":{"tf":1},"274":{"tf":1},"280":{"tf":1.7320508075688772}},"df":13,"i":{"docs":{"55":{"tf":1},"80":{"tf":1},"108":{"tf":1.4142135623730951},"155":{"tf":1},"173":{"tf":1},"174":{"tf":1},"175":{"tf":1},"178":{"tf":1.4142135623730951},"190":{"tf":2},"201":{"tf":1},"216":{"tf":1},"220":{"tf":1},"221":{"tf":1},"235":{"tf":1},"241":{"tf":1.7320508075688772},"243":{"tf":1},"271":{"tf":1},"272":{"tf":1},"275":{"tf":1},"277":{"tf":1.4142135623730951},"280":{"tf":1},"284":{"tf":1}},"df":22}},"a":{"docs":{},"df":0,"l":{"docs":{"26":{"tf":1.4142135623730951},"51":{"tf":1},"69":{"tf":1},"72":{"tf":1.4142135623730951},"126":{"tf":1},"266":{"tf":1},"267":{"tf":1}},"df":7,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"266":{"tf":1}},"df":1}}}}}}}}}},"n":{"docs":{},"df":0,"t":{"docs":{"209":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{"154":{"tf":1}},"df":1}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"259":{"tf":1.4142135623730951}},"df":1}}}},"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"51":{"tf":1}},"df":1}}},"i":{"docs":{},"df":0,"d":{"docs":{"111":{"tf":2.23606797749979}},"df":1}}}},"l":{"docs":{},"df":0,"l":{"docs":{"114":{"tf":1},"120":{"tf":1},"209":{"tf":1},"233":{"tf":1},"241":{"tf":1},"259":{"tf":1}},"df":6}}}},"k":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{"114":{"tf":1.7320508075688772},"126":{"tf":1},"129":{"tf":2.23606797749979},"130":{"tf":1.4142135623730951},"131":{"tf":1.7320508075688772},"132":{"tf":2},"178":{"tf":1},"201":{"tf":1},"227":{"tf":1}},"df":9}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"137":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"3":{"tf":1},"21":{"tf":1},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"59":{"tf":1},"77":{"tf":2.23606797749979},"86":{"tf":1},"141":{"tf":2},"142":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"153":{"tf":1},"154":{"tf":1.4142135623730951},"155":{"tf":1},"156":{"tf":1},"157":{"tf":1.7320508075688772},"158":{"tf":1},"161":{"tf":1},"173":{"tf":1.7320508075688772},"181":{"tf":1},"191":{"tf":2.23606797749979},"201":{"tf":1},"204":{"tf":3.605551275463989},"205":{"tf":1},"206":{"tf":1},"209":{"tf":1},"216":{"tf":1.4142135623730951},"237":{"tf":1},"242":{"tf":1},"255":{"tf":1},"263":{"tf":1},"265":{"tf":2},"272":{"tf":2.8284271247461903},"274":{"tf":1},"277":{"tf":1.7320508075688772},"280":{"tf":2},"284":{"tf":1.4142135623730951}},"df":36,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"154":{"tf":1.4142135623730951},"155":{"tf":1},"157":{"tf":1},"161":{"tf":1},"162":{"tf":1},"163":{"tf":1},"167":{"tf":1},"168":{"tf":2.23606797749979}},"df":8}}}}}}}}},"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"164":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{"191":{"tf":1}},"df":1}}}}}}}}}}},"r":{"docs":{"272":{"tf":1.4142135623730951},"280":{"tf":1}},"df":2}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{"191":{"tf":1}},"df":1}}}}}}}}}}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{"204":{"tf":2}},"df":1}}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{"191":{"tf":1},"272":{"tf":1},"273":{"tf":1},"274":{"tf":1.4142135623730951},"277":{"tf":1.4142135623730951},"280":{"tf":1.4142135623730951}},"df":6,"_":{"docs":{},"df":0,"<":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"274":{"tf":1},"280":{"tf":1}},"df":2}}}}}}}},"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"<":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"280":{"tf":1},"281":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"l":{"docs":{"284":{"tf":1},"287":{"tf":1}},"df":2,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{"286":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"8":{"tf":1},"11":{"tf":1},"21":{"tf":1},"28":{"tf":1},"34":{"tf":1},"51":{"tf":1},"59":{"tf":1},"86":{"tf":1},"89":{"tf":1},"104":{"tf":1.4142135623730951},"111":{"tf":1},"114":{"tf":2},"126":{"tf":1.4142135623730951},"136":{"tf":1},"150":{"tf":1.4142135623730951},"154":{"tf":1},"175":{"tf":1},"178":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"195":{"tf":1},"198":{"tf":1},"200":{"tf":1},"204":{"tf":1},"209":{"tf":1.4142135623730951},"212":{"tf":1.4142135623730951},"215":{"tf":1},"219":{"tf":1},"228":{"tf":1},"231":{"tf":1},"237":{"tf":1},"239":{"tf":1},"255":{"tf":1.4142135623730951},"258":{"tf":1},"262":{"tf":1},"270":{"tf":1},"289":{"tf":1}},"df":36}}}},"r":{"docs":{},"df":0,"t":{"docs":{"56":{"tf":1}},"df":1},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"111":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"255":{"tf":1}},"df":1}}}}}}}}},"n":{"docs":{},"df":0,"g":{"docs":{"73":{"tf":1},"89":{"tf":1},"135":{"tf":1},"136":{"tf":1},"164":{"tf":1},"168":{"tf":2.23606797749979},"189":{"tf":1},"204":{"tf":2.23606797749979},"205":{"tf":1},"234":{"tf":1},"255":{"tf":1},"262":{"tf":1},"274":{"tf":1},"275":{"tf":1},"277":{"tf":1},"286":{"tf":1}},"df":16},"c":{"docs":{"212":{"tf":1}},"df":1}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"15":{"tf":1},"20":{"tf":1},"38":{"tf":1},"101":{"tf":1},"123":{"tf":1},"124":{"tf":1},"130":{"tf":1},"131":{"tf":1},"201":{"tf":1},"204":{"tf":1.4142135623730951},"220":{"tf":1},"284":{"tf":1}},"df":12,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"123":{"tf":1},"124":{"tf":1},"267":{"tf":1}},"df":3}}}}}},"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{"63":{"tf":1.4142135623730951},"77":{"tf":1},"81":{"tf":1},"93":{"tf":1},"95":{"tf":1},"101":{"tf":1},"154":{"tf":1},"163":{"tf":1},"164":{"tf":1},"168":{"tf":1.4142135623730951},"170":{"tf":1},"175":{"tf":1},"178":{"tf":1},"220":{"tf":1}},"df":14}},"i":{"docs":{},"df":0,"c":{"docs":{"178":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"3":{"tf":1},"4":{"tf":1},"15":{"tf":1},"21":{"tf":1},"25":{"tf":1.4142135623730951},"26":{"tf":1},"27":{"tf":2.449489742783178},"31":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1},"39":{"tf":1.4142135623730951},"43":{"tf":1},"51":{"tf":2},"56":{"tf":1.4142135623730951},"59":{"tf":1},"80":{"tf":2.23606797749979},"81":{"tf":2.449489742783178},"86":{"tf":1},"89":{"tf":1},"97":{"tf":1.4142135623730951},"98":{"tf":1},"123":{"tf":1.7320508075688772},"124":{"tf":1},"126":{"tf":2.8284271247461903},"129":{"tf":1},"130":{"tf":1},"135":{"tf":1},"141":{"tf":1.4142135623730951},"143":{"tf":1},"147":{"tf":2.23606797749979},"153":{"tf":1},"154":{"tf":1},"155":{"tf":1},"157":{"tf":1},"158":{"tf":1.4142135623730951},"161":{"tf":1.7320508075688772},"162":{"tf":1},"164":{"tf":1.4142135623730951},"167":{"tf":1.7320508075688772},"168":{"tf":1},"173":{"tf":1},"174":{"tf":1},"175":{"tf":1},"178":{"tf":3.1622776601683795},"191":{"tf":1.7320508075688772},"199":{"tf":1},"204":{"tf":3.605551275463989},"205":{"tf":1.4142135623730951},"206":{"tf":1},"209":{"tf":1},"215":{"tf":1.4142135623730951},"216":{"tf":2.23606797749979},"217":{"tf":2},"218":{"tf":1.7320508075688772},"219":{"tf":2},"220":{"tf":1},"222":{"tf":2},"224":{"tf":1},"225":{"tf":2},"226":{"tf":1},"227":{"tf":1.7320508075688772},"228":{"tf":2},"231":{"tf":1.7320508075688772},"232":{"tf":1.4142135623730951},"233":{"tf":4},"234":{"tf":1},"236":{"tf":1.4142135623730951},"237":{"tf":2.8284271247461903},"238":{"tf":1.4142135623730951},"239":{"tf":2},"240":{"tf":1},"241":{"tf":2.6457513110645907},"242":{"tf":2.449489742783178},"243":{"tf":2.6457513110645907},"244":{"tf":1},"246":{"tf":1},"247":{"tf":2.23606797749979},"248":{"tf":1},"250":{"tf":2},"251":{"tf":1.4142135623730951},"252":{"tf":1.4142135623730951},"254":{"tf":1},"255":{"tf":1.4142135623730951},"259":{"tf":2.6457513110645907},"260":{"tf":1},"265":{"tf":2.449489742783178},"266":{"tf":1},"267":{"tf":1},"272":{"tf":1},"277":{"tf":1},"280":{"tf":1},"283":{"tf":1}},"df":95,"'":{"docs":{"201":{"tf":1.4142135623730951},"231":{"tf":1}},"df":2}}},"r":{"docs":{"205":{"tf":1}},"df":1,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"63":{"tf":1.4142135623730951},"107":{"tf":1},"199":{"tf":1},"204":{"tf":1.4142135623730951}},"df":4,"u":{"docs":{},"df":0,"r":{"docs":{"20":{"tf":1},"21":{"tf":1},"22":{"tf":1},"66":{"tf":1},"212":{"tf":1},"216":{"tf":1},"233":{"tf":1},"241":{"tf":1.4142135623730951},"244":{"tf":1},"259":{"tf":1.4142135623730951},"264":{"tf":1},"272":{"tf":1},"275":{"tf":1},"277":{"tf":1},"280":{"tf":1}},"df":15}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"64":{"tf":1}},"df":1}}}}}}}}}}}}},"r":{"docs":{},"df":0,"i":{"docs":{"69":{"tf":1},"77":{"tf":1}},"df":2}},"e":{"docs":{"132":{"tf":1},"215":{"tf":1},"231":{"tf":1},"233":{"tf":1},"258":{"tf":1}},"df":5}},"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"21":{"tf":1},"233":{"tf":1.4142135623730951},"250":{"tf":1},"251":{"tf":2.449489742783178},"252":{"tf":1.4142135623730951},"253":{"tf":1.7320508075688772},"254":{"tf":1.4142135623730951}},"df":7}}},"l":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"26":{"tf":1},"216":{"tf":1}},"df":2}}},"l":{"docs":{"86":{"tf":1},"93":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772},"98":{"tf":1},"101":{"tf":1},"120":{"tf":1},"154":{"tf":1.4142135623730951},"155":{"tf":1.4142135623730951},"161":{"tf":1.7320508075688772},"162":{"tf":1.7320508075688772},"163":{"tf":1.7320508075688772},"164":{"tf":1},"167":{"tf":2},"168":{"tf":3},"169":{"tf":1.4142135623730951},"174":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"184":{"tf":1},"204":{"tf":1},"209":{"tf":1},"222":{"tf":1},"223":{"tf":1},"227":{"tf":1.4142135623730951},"233":{"tf":1},"238":{"tf":1},"239":{"tf":1},"242":{"tf":1},"244":{"tf":1},"247":{"tf":1},"251":{"tf":1.4142135623730951},"253":{"tf":1},"255":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"262":{"tf":1},"265":{"tf":1.7320508075688772},"272":{"tf":1},"277":{"tf":1.4142135623730951},"280":{"tf":2.6457513110645907},"283":{"tf":1},"284":{"tf":1.4142135623730951},"285":{"tf":1},"286":{"tf":1.7320508075688772},"287":{"tf":1}},"df":45,"e":{"docs":{},"df":0,"r":{"docs":{"164":{"tf":1}},"df":1}}}},"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"28":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"129":{"tf":1},"269":{"tf":1},"270":{"tf":1},"289":{"tf":1.4142135623730951}},"df":4}}}},"u":{"docs":{},"df":0,"s":{"docs":{"39":{"tf":1},"126":{"tf":1},"129":{"tf":1},"137":{"tf":1.4142135623730951},"141":{"tf":1},"147":{"tf":1},"216":{"tf":1}},"df":7}},"m":{"docs":{},"df":0,"e":{"docs":{"198":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"241":{"tf":2}},"df":1}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"21":{"tf":1},"27":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"54":{"tf":1},"56":{"tf":1},"59":{"tf":1.4142135623730951},"86":{"tf":1},"93":{"tf":2.23606797749979},"94":{"tf":1},"97":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"111":{"tf":1},"154":{"tf":1},"164":{"tf":1},"168":{"tf":1.4142135623730951},"178":{"tf":1.7320508075688772},"181":{"tf":1},"215":{"tf":1},"226":{"tf":1},"228":{"tf":1.7320508075688772},"231":{"tf":1},"232":{"tf":1},"241":{"tf":3.1622776601683795},"242":{"tf":1.7320508075688772},"244":{"tf":1.7320508075688772},"255":{"tf":1},"258":{"tf":1},"259":{"tf":2.8284271247461903},"260":{"tf":1},"262":{"tf":1.4142135623730951},"263":{"tf":1},"264":{"tf":1.4142135623730951},"267":{"tf":1},"270":{"tf":2},"271":{"tf":1.4142135623730951},"272":{"tf":2.6457513110645907},"276":{"tf":1},"277":{"tf":1.7320508075688772},"278":{"tf":1},"279":{"tf":1},"280":{"tf":2.449489742783178},"281":{"tf":1},"283":{"tf":1},"285":{"tf":1},"286":{"tf":1},"287":{"tf":1}},"df":47,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"71":{"tf":1},"93":{"tf":1.4142135623730951},"96":{"tf":1},"126":{"tf":1},"204":{"tf":1},"258":{"tf":1},"261":{"tf":1},"268":{"tf":1},"269":{"tf":1},"274":{"tf":1},"277":{"tf":1},"284":{"tf":1},"289":{"tf":1}},"df":13}}}}}},"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{"111":{"tf":1}},"df":1}}}}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{"231":{"tf":1}},"df":1}}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"40":{"tf":1.7320508075688772},"162":{"tf":1},"190":{"tf":1.4142135623730951},"262":{"tf":1.7320508075688772},"264":{"tf":1},"268":{"tf":1},"269":{"tf":1.4142135623730951},"270":{"tf":1},"272":{"tf":1.4142135623730951},"275":{"tf":1},"277":{"tf":1.4142135623730951},"278":{"tf":1},"280":{"tf":1.7320508075688772},"283":{"tf":1},"285":{"tf":1},"286":{"tf":1},"289":{"tf":1.4142135623730951}},"df":18}}},"r":{"docs":{},"df":0,"m":{"docs":{"72":{"tf":1},"164":{"tf":1},"272":{"tf":1}},"df":3}}},"u":{"docs":{},"df":0,"s":{"docs":{"4":{"tf":1}},"df":1}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"212":{"tf":1},"219":{"tf":1},"220":{"tf":1},"228":{"tf":1},"231":{"tf":1.4142135623730951},"233":{"tf":2},"239":{"tf":1.4142135623730951}},"df":8}},"r":{"docs":{},"df":0,"n":{"docs":{"199":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"154":{"tf":1}},"df":1}}}}},"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,".":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"25":{"tf":1},"108":{"tf":1}},"df":2}},"d":{"docs":{"280":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"r":{"docs":{"90":{"tf":1}},"df":1}}}},"o":{"docs":{},"df":0,"l":{"docs":{"190":{"tf":1.4142135623730951}},"df":1,"i":{"docs":{},"df":0,"d":{"docs":{"86":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"147":{"tf":1}},"df":1}}}}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"272":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1},"195":{"tf":1.7320508075688772},"199":{"tf":1},"204":{"tf":1.4142135623730951},"251":{"tf":1}},"df":5}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"8":{"tf":1},"16":{"tf":1},"40":{"tf":1.4142135623730951},"95":{"tf":1},"97":{"tf":1},"154":{"tf":1},"190":{"tf":1.4142135623730951},"264":{"tf":1},"265":{"tf":1},"272":{"tf":1},"280":{"tf":1}},"df":11}},"x":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1.4142135623730951},"77":{"tf":1},"80":{"tf":1},"81":{"tf":1},"94":{"tf":1},"141":{"tf":1},"204":{"tf":1}},"df":7}}},"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"15":{"tf":1.4142135623730951},"39":{"tf":1},"56":{"tf":1},"65":{"tf":1},"71":{"tf":1},"73":{"tf":1},"80":{"tf":1.7320508075688772},"101":{"tf":1.4142135623730951},"141":{"tf":1},"143":{"tf":1},"181":{"tf":1},"189":{"tf":1},"190":{"tf":1.7320508075688772},"191":{"tf":1},"192":{"tf":1},"201":{"tf":1},"204":{"tf":1},"215":{"tf":1},"218":{"tf":1},"221":{"tf":1.4142135623730951},"222":{"tf":1.4142135623730951},"226":{"tf":1},"228":{"tf":1.4142135623730951},"232":{"tf":1},"233":{"tf":1},"234":{"tf":1},"241":{"tf":1},"242":{"tf":1.7320508075688772},"250":{"tf":1},"253":{"tf":1},"259":{"tf":1.7320508075688772},"261":{"tf":1},"262":{"tf":1.4142135623730951},"264":{"tf":1.4142135623730951},"265":{"tf":3.3166247903554},"266":{"tf":1},"270":{"tf":1},"272":{"tf":1},"273":{"tf":1},"280":{"tf":2.23606797749979},"281":{"tf":1.4142135623730951},"283":{"tf":1},"284":{"tf":1},"286":{"tf":1},"287":{"tf":1},"288":{"tf":1}},"df":46}},"c":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1.4142135623730951}},"df":1}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"43":{"tf":1},"114":{"tf":1.4142135623730951},"123":{"tf":1},"143":{"tf":1},"147":{"tf":1.7320508075688772},"168":{"tf":1.4142135623730951},"169":{"tf":1},"233":{"tf":1},"242":{"tf":1}},"df":9}}}},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":2},"21":{"tf":2.8284271247461903},"63":{"tf":1},"163":{"tf":1.4142135623730951},"198":{"tf":1}},"df":6}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"81":{"tf":1.4142135623730951},"90":{"tf":1},"101":{"tf":1.7320508075688772},"154":{"tf":1.4142135623730951}},"df":4},"s":{"docs":{"168":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"t":{"docs":{"154":{"tf":1.4142135623730951},"217":{"tf":1},"234":{"tf":1}},"df":3},"i":{"docs":{"286":{"tf":1}},"df":1}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"195":{"tf":1.4142135623730951},"200":{"tf":1},"201":{"tf":2.23606797749979},"204":{"tf":2},"218":{"tf":1},"233":{"tf":1}},"df":6}}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"275":{"tf":1}},"df":1}}}}}}},"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1},"233":{"tf":1}},"df":2,"l":{"docs":{},"df":0,"i":{"docs":{"181":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"5":{"tf":1},"281":{"tf":1}},"df":2}}},"u":{"docs":{},"df":0,"n":{"docs":{"14":{"tf":1.4142135623730951}},"df":1}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"114":{"tf":1},"120":{"tf":1},"173":{"tf":1},"175":{"tf":1.7320508075688772},"178":{"tf":2.6457513110645907},"189":{"tf":1.4142135623730951},"204":{"tf":1}},"df":7}}}},"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1.7320508075688772},"27":{"tf":1},"73":{"tf":1},"80":{"tf":1.4142135623730951},"104":{"tf":2.6457513110645907},"107":{"tf":1},"108":{"tf":1.7320508075688772},"111":{"tf":3.1622776601683795},"191":{"tf":1.7320508075688772},"199":{"tf":1},"200":{"tf":1},"204":{"tf":1.7320508075688772},"242":{"tf":1},"250":{"tf":1},"258":{"tf":1},"259":{"tf":1.4142135623730951},"262":{"tf":1},"263":{"tf":1.4142135623730951},"264":{"tf":1.4142135623730951},"265":{"tf":2.8284271247461903},"266":{"tf":1},"267":{"tf":1.7320508075688772},"270":{"tf":1},"272":{"tf":2.449489742783178},"274":{"tf":2},"280":{"tf":1.7320508075688772},"281":{"tf":1},"284":{"tf":1},"287":{"tf":1}},"df":29,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"254":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"51":{"tf":1},"65":{"tf":1},"83":{"tf":1},"93":{"tf":1},"96":{"tf":1},"114":{"tf":1},"126":{"tf":1},"164":{"tf":1},"181":{"tf":1},"204":{"tf":1},"238":{"tf":1},"274":{"tf":1}},"df":13},"x":{"docs":{"71":{"tf":1},"72":{"tf":1},"241":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"40":{"tf":1.7320508075688772}},"df":1}},"r":{"docs":{"157":{"tf":1}},"df":1}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"43":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"d":{"docs":{"274":{"tf":1.4142135623730951},"275":{"tf":1},"280":{"tf":1}},"df":3}}},"e":{"docs":{"4":{"tf":1},"26":{"tf":1},"37":{"tf":1},"38":{"tf":1},"224":{"tf":1},"243":{"tf":1}},"df":6},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1},"147":{"tf":1},"241":{"tf":1},"242":{"tf":1},"244":{"tf":1},"255":{"tf":1.4142135623730951}},"df":6}},"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"126":{"tf":1.7320508075688772}},"df":1}}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{"4":{"tf":1},"39":{"tf":1},"204":{"tf":1},"250":{"tf":1},"267":{"tf":1},"272":{"tf":1}},"df":6}},"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"27":{"tf":1},"28":{"tf":1.4142135623730951},"204":{"tf":1.7320508075688772},"221":{"tf":1.4142135623730951}},"df":4}}}}},"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"20":{"tf":1},"93":{"tf":1.4142135623730951},"94":{"tf":1},"97":{"tf":1},"141":{"tf":1},"155":{"tf":1},"168":{"tf":1},"178":{"tf":1.4142135623730951},"191":{"tf":1.7320508075688772}},"df":9}}}}},"c":{"docs":{},"df":0,"t":{"docs":{"51":{"tf":1},"143":{"tf":1.4142135623730951},"163":{"tf":1.4142135623730951},"164":{"tf":1},"167":{"tf":1},"168":{"tf":1.4142135623730951},"204":{"tf":1},"219":{"tf":1},"231":{"tf":1},"233":{"tf":1}},"df":10,"l":{"docs":{},"df":0,"i":{"docs":{"244":{"tf":1}},"df":1}}}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"40":{"tf":1},"114":{"tf":1},"150":{"tf":1},"212":{"tf":1}},"df":4}}},"s":{"docs":{},"df":0,"t":{"docs":{"77":{"tf":1}},"df":1}},"p":{"docs":{},"df":0,"i":{"docs":{"89":{"tf":1},"161":{"tf":1},"162":{"tf":1},"169":{"tf":1},"181":{"tf":1.4142135623730951},"204":{"tf":1},"215":{"tf":1},"222":{"tf":1},"231":{"tf":1},"232":{"tf":1},"234":{"tf":1},"246":{"tf":1},"251":{"tf":1},"258":{"tf":1},"261":{"tf":1}},"df":15},"y":{"docs":{},"df":0,"/":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"97":{"tf":1}},"df":1}}}}}}},"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"n":{"docs":{"108":{"tf":1.4142135623730951},"157":{"tf":1},"221":{"tf":2},"224":{"tf":1}},"df":4}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{"126":{"tf":1},"204":{"tf":1}},"df":2}}}}},"d":{"docs":{},"df":0,"e":{"docs":{"154":{"tf":1},"155":{"tf":1}},"df":2}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1}},"df":1}}}}},"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"43":{"tf":1},"111":{"tf":1},"129":{"tf":1},"181":{"tf":1},"199":{"tf":1},"204":{"tf":1.4142135623730951},"241":{"tf":1},"265":{"tf":1},"267":{"tf":1}},"df":9}}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1},"21":{"tf":1},"114":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"129":{"tf":1},"131":{"tf":1},"144":{"tf":1.4142135623730951},"147":{"tf":1},"162":{"tf":1},"163":{"tf":1},"168":{"tf":1.4142135623730951},"170":{"tf":2},"175":{"tf":1},"178":{"tf":1},"189":{"tf":1},"190":{"tf":1.7320508075688772},"221":{"tf":1},"233":{"tf":1},"262":{"tf":1},"265":{"tf":1.4142135623730951},"270":{"tf":1},"274":{"tf":1},"277":{"tf":1.4142135623730951},"278":{"tf":1},"279":{"tf":1},"284":{"tf":2.23606797749979},"285":{"tf":1},"287":{"tf":1}},"df":28,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"277":{"tf":1},"284":{"tf":1}},"df":2}}}}},"c":{"docs":{"154":{"tf":1}},"df":1}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"43":{"tf":1},"216":{"tf":1}},"df":2}}}},"t":{"docs":{"235":{"tf":1}},"df":1,"/":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"80":{"tf":1},"94":{"tf":1}},"df":2}}}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"15":{"tf":1},"21":{"tf":1},"27":{"tf":1.7320508075688772},"33":{"tf":1},"38":{"tf":1},"70":{"tf":1.4142135623730951},"72":{"tf":1},"73":{"tf":1},"77":{"tf":1},"80":{"tf":1},"81":{"tf":1},"94":{"tf":1.7320508075688772},"95":{"tf":1},"97":{"tf":1},"107":{"tf":1.7320508075688772},"120":{"tf":1},"135":{"tf":1.4142135623730951},"138":{"tf":1},"141":{"tf":1},"144":{"tf":1},"154":{"tf":1},"162":{"tf":1.4142135623730951},"163":{"tf":1},"164":{"tf":1},"168":{"tf":2.23606797749979},"204":{"tf":4.123105625617661},"220":{"tf":1.4142135623730951},"221":{"tf":1},"235":{"tf":1.4142135623730951},"238":{"tf":1.4142135623730951},"247":{"tf":1.4142135623730951},"251":{"tf":1},"262":{"tf":1},"265":{"tf":1},"272":{"tf":1},"275":{"tf":1}},"df":36}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"20":{"tf":1},"21":{"tf":1.7320508075688772},"40":{"tf":1},"47":{"tf":1.4142135623730951},"173":{"tf":1},"178":{"tf":1},"185":{"tf":1.4142135623730951},"236":{"tf":1},"272":{"tf":1.4142135623730951}},"df":9}}}},"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"19":{"tf":1},"37":{"tf":1},"117":{"tf":1},"120":{"tf":1},"162":{"tf":1},"164":{"tf":1},"178":{"tf":1},"189":{"tf":1},"222":{"tf":1},"233":{"tf":1},"241":{"tf":2.449489742783178},"242":{"tf":1},"247":{"tf":1},"251":{"tf":1},"253":{"tf":1},"262":{"tf":1}},"df":16,"r":{"docs":{"107":{"tf":1},"188":{"tf":1},"198":{"tf":1},"238":{"tf":1},"239":{"tf":1},"241":{"tf":1},"243":{"tf":1},"263":{"tf":1},"269":{"tf":1},"286":{"tf":1}},"df":10},"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"y":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"189":{"tf":1}},"df":1}}}}}}}}}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{"51":{"tf":1},"244":{"tf":1},"247":{"tf":1}},"df":3,"u":{"docs":{},"df":0,"p":{"docs":{"46":{"tf":1.4142135623730951},"47":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"80":{"tf":1},"83":{"tf":1},"126":{"tf":1.7320508075688772},"143":{"tf":1},"204":{"tf":1.4142135623730951},"218":{"tf":1},"222":{"tf":1},"232":{"tf":1},"233":{"tf":1.7320508075688772},"234":{"tf":1},"235":{"tf":1},"237":{"tf":1.7320508075688772},"238":{"tf":1},"241":{"tf":1.4142135623730951},"243":{"tf":1.4142135623730951},"244":{"tf":1},"247":{"tf":1.4142135623730951},"255":{"tf":2.23606797749979}},"df":21}}},"r":{"docs":{"178":{"tf":1.4142135623730951}},"df":1}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"111":{"tf":1},"270":{"tf":1.4142135623730951},"272":{"tf":2},"280":{"tf":1.4142135623730951},"283":{"tf":1}},"df":5}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"l":{"docs":{"38":{"tf":1},"168":{"tf":1}},"df":2,"⁠":{"docs":{},"df":0,"+":{"docs":{},"df":0,"⁠":{"docs":{"66":{"tf":1}},"df":1,"l":{"docs":{"37":{"tf":1},"144":{"tf":1}},"df":2},"x":{"docs":{"80":{"tf":1},"235":{"tf":1}},"df":2},"v":{"docs":{"80":{"tf":1},"235":{"tf":1}},"df":2},"a":{"docs":{"95":{"tf":1},"204":{"tf":1.4142135623730951}},"df":2},"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"⁠":{"docs":{},"df":0,"+":{"docs":{},"df":0,"⁠":{"docs":{"154":{"tf":1}},"df":1,"p":{"docs":{"101":{"tf":1},"154":{"tf":1}},"df":2},"i":{"docs":{"204":{"tf":1}},"df":1}}}}}}}}},"f":{"8":{"docs":{"114":{"tf":1},"117":{"tf":1},"119":{"tf":1},"120":{"tf":1}},"df":4},"docs":{},"df":0},"j":{"docs":{"114":{"tf":1},"144":{"tf":1}},"df":2}}}}}}},"f":{"docs":{"163":{"tf":1},"178":{"tf":1}},"df":2},"s":{"docs":{},"df":0,"v":{"docs":{"220":{"tf":1},"227":{"tf":1}},"df":2}},"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"284":{"tf":1},"285":{"tf":1},"286":{"tf":1.4142135623730951}},"df":3}}}}}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"286":{"tf":1.4142135623730951}},"df":1}}}}}}},"o":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"86":{"tf":1},"114":{"tf":1.4142135623730951},"123":{"tf":1},"124":{"tf":1},"125":{"tf":1},"126":{"tf":1},"130":{"tf":1},"131":{"tf":1},"132":{"tf":1},"204":{"tf":1},"215":{"tf":1},"228":{"tf":1}},"df":12,"a":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"56":{"tf":1}},"df":2}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{"3":{"tf":2},"4":{"tf":1},"56":{"tf":1.7320508075688772},"114":{"tf":1},"225":{"tf":1}},"df":5}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"155":{"tf":1},"178":{"tf":1}},"df":2}}}}}}}}},"r":{"docs":{"3":{"tf":1},"4":{"tf":2.23606797749979},"5":{"tf":1},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"26":{"tf":1},"37":{"tf":1.4142135623730951},"38":{"tf":1},"40":{"tf":1.4142135623730951},"43":{"tf":2.23606797749979},"55":{"tf":1},"63":{"tf":2.23606797749979},"66":{"tf":2},"69":{"tf":1.4142135623730951},"77":{"tf":1},"80":{"tf":1.4142135623730951},"94":{"tf":1.4142135623730951},"95":{"tf":1},"97":{"tf":1},"101":{"tf":2.23606797749979},"111":{"tf":1.7320508075688772},"114":{"tf":1.7320508075688772},"120":{"tf":1.4142135623730951},"126":{"tf":1.7320508075688772},"129":{"tf":1.4142135623730951},"130":{"tf":1},"132":{"tf":1},"135":{"tf":1.4142135623730951},"144":{"tf":1},"147":{"tf":1},"154":{"tf":1},"161":{"tf":1},"162":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"170":{"tf":1},"173":{"tf":1.4142135623730951},"175":{"tf":1},"178":{"tf":1.7320508075688772},"181":{"tf":1},"189":{"tf":1.7320508075688772},"191":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"199":{"tf":1.4142135623730951},"201":{"tf":1},"204":{"tf":1},"215":{"tf":1},"219":{"tf":1},"228":{"tf":1},"233":{"tf":2},"235":{"tf":1.4142135623730951},"237":{"tf":1},"244":{"tf":1},"250":{"tf":1},"253":{"tf":1},"259":{"tf":1},"265":{"tf":1.4142135623730951},"266":{"tf":1},"267":{"tf":1},"271":{"tf":1},"280":{"tf":1.7320508075688772}},"df":61,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"14":{"tf":1},"181":{"tf":1},"204":{"tf":1},"275":{"tf":1}},"df":5}}},"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{"15":{"tf":1},"80":{"tf":1},"184":{"tf":1},"217":{"tf":1},"219":{"tf":1.4142135623730951},"242":{"tf":1},"259":{"tf":1},"260":{"tf":1},"262":{"tf":1}},"df":9,"i":{"docs":{},"df":0,"z":{"docs":{"259":{"tf":1}},"df":1}}}}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"189":{"tf":1}},"df":1}}}}},"w":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1},"27":{"tf":1},"55":{"tf":1},"59":{"tf":1},"181":{"tf":1},"209":{"tf":1.7320508075688772},"220":{"tf":1},"231":{"tf":1},"258":{"tf":1},"272":{"tf":1},"277":{"tf":1}},"df":11}},"n":{"docs":{"4":{"tf":1},"21":{"tf":1},"27":{"tf":1},"37":{"tf":1},"38":{"tf":1},"39":{"tf":1},"50":{"tf":1},"56":{"tf":1},"94":{"tf":1},"124":{"tf":1},"129":{"tf":1},"132":{"tf":1},"136":{"tf":1},"162":{"tf":1},"163":{"tf":1.7320508075688772},"168":{"tf":1},"175":{"tf":1},"204":{"tf":2},"215":{"tf":1},"217":{"tf":1},"220":{"tf":1},"221":{"tf":1},"222":{"tf":1},"225":{"tf":1},"227":{"tf":1.4142135623730951},"233":{"tf":2.449489742783178},"236":{"tf":1},"237":{"tf":1.4142135623730951},"242":{"tf":1.7320508075688772},"251":{"tf":1},"255":{"tf":1},"259":{"tf":1.4142135623730951},"265":{"tf":2},"267":{"tf":1},"274":{"tf":1},"280":{"tf":2},"286":{"tf":1}},"df":37,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1},"43":{"tf":1}},"df":2}}},"/":{"docs":{},"df":0,"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"f":{"docs":{"120":{"tf":1.4142135623730951}},"df":1}}}},"c":{"docs":{"178":{"tf":1.4142135623730951},"219":{"tf":1},"223":{"tf":1},"262":{"tf":1},"275":{"tf":1}},"df":5}},"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"43":{"tf":1},"54":{"tf":1},"55":{"tf":1},"101":{"tf":1},"111":{"tf":1},"220":{"tf":1},"277":{"tf":1}},"df":8}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"43":{"tf":1.4142135623730951}},"df":1}}},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{"111":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"t":{"docs":{"34":{"tf":1},"66":{"tf":1},"69":{"tf":1},"77":{"tf":1},"108":{"tf":1},"114":{"tf":1.4142135623730951},"123":{"tf":1},"125":{"tf":1},"126":{"tf":1},"131":{"tf":1.4142135623730951},"132":{"tf":1.7320508075688772},"167":{"tf":1},"168":{"tf":1},"204":{"tf":1},"216":{"tf":1},"251":{"tf":1},"274":{"tf":1}},"df":17,"p":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1}},"df":1}}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"178":{"tf":1}},"df":1}}},"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"y":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"233":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"14":{"tf":1.4142135623730951},"20":{"tf":1},"34":{"tf":1},"37":{"tf":1},"50":{"tf":1},"54":{"tf":1},"62":{"tf":1.4142135623730951},"70":{"tf":1},"73":{"tf":1},"77":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772},"89":{"tf":1},"93":{"tf":1.4142135623730951},"95":{"tf":1},"97":{"tf":1},"120":{"tf":1},"123":{"tf":1.4142135623730951},"126":{"tf":1.7320508075688772},"135":{"tf":1.4142135623730951},"141":{"tf":1},"144":{"tf":1.4142135623730951},"154":{"tf":1},"184":{"tf":1},"189":{"tf":1},"204":{"tf":2},"220":{"tf":1},"232":{"tf":1},"234":{"tf":1},"235":{"tf":1},"236":{"tf":1},"237":{"tf":1.4142135623730951},"241":{"tf":4},"242":{"tf":2.8284271247461903},"243":{"tf":1.7320508075688772},"246":{"tf":1},"252":{"tf":1},"261":{"tf":1},"262":{"tf":1},"269":{"tf":1},"270":{"tf":1},"271":{"tf":1},"275":{"tf":1}},"df":42},"r":{"docs":{"101":{"tf":1},"129":{"tf":1},"154":{"tf":1},"163":{"tf":1},"164":{"tf":1}},"df":5}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"19":{"tf":1},"37":{"tf":1},"40":{"tf":1.4142135623730951},"43":{"tf":1},"55":{"tf":1},"120":{"tf":1},"135":{"tf":1.4142135623730951},"136":{"tf":1.4142135623730951},"162":{"tf":1},"204":{"tf":1},"241":{"tf":1.7320508075688772},"262":{"tf":1.7320508075688772},"267":{"tf":1},"275":{"tf":1.7320508075688772},"289":{"tf":1}},"df":15}},"m":{"docs":{"227":{"tf":1},"233":{"tf":1.4142135623730951},"238":{"tf":1}},"df":3}}}},"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"31":{"tf":1},"33":{"tf":1},"38":{"tf":1},"39":{"tf":1},"56":{"tf":1},"126":{"tf":1},"135":{"tf":1},"143":{"tf":1},"190":{"tf":1},"250":{"tf":1},"265":{"tf":1}},"df":11}}}},"k":{"docs":{"55":{"tf":1},"72":{"tf":1},"93":{"tf":1},"96":{"tf":1},"155":{"tf":1},"157":{"tf":1},"162":{"tf":1},"164":{"tf":1},"204":{"tf":3},"221":{"tf":1},"241":{"tf":1.7320508075688772},"262":{"tf":1},"275":{"tf":1}},"df":13},"b":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"104":{"tf":1}},"df":1}}}},"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"263":{"tf":1}},"df":1}}}}},"j":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"265":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"157":{"tf":1},"241":{"tf":1}},"df":2,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"136":{"tf":1},"175":{"tf":1},"204":{"tf":1.4142135623730951},"242":{"tf":1},"274":{"tf":1},"277":{"tf":1}},"df":6}}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{"178":{"tf":1},"218":{"tf":1},"233":{"tf":1},"239":{"tf":1},"241":{"tf":1},"252":{"tf":1},"262":{"tf":1},"277":{"tf":1}},"df":8,"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"3":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"150":{"tf":1},"219":{"tf":1}},"df":2,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"147":{"tf":1}},"df":1}}}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"4":{"tf":1},"27":{"tf":1.4142135623730951},"59":{"tf":1},"69":{"tf":2.23606797749979},"70":{"tf":2.6457513110645907},"71":{"tf":1.4142135623730951},"72":{"tf":2.23606797749979},"73":{"tf":1},"74":{"tf":1.7320508075688772},"77":{"tf":2.449489742783178},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1},"83":{"tf":1},"86":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"104":{"tf":1},"107":{"tf":2.6457513110645907},"108":{"tf":1},"111":{"tf":1.7320508075688772},"204":{"tf":2.8284271247461903},"209":{"tf":1},"242":{"tf":1},"258":{"tf":1},"259":{"tf":1.7320508075688772},"262":{"tf":3},"263":{"tf":1.4142135623730951},"266":{"tf":1},"267":{"tf":2.23606797749979},"275":{"tf":2.23606797749979},"282":{"tf":1},"284":{"tf":1}},"df":33}},"g":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1.4142135623730951},"111":{"tf":1}},"df":2}}}},"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"21":{"tf":1},"227":{"tf":1},"239":{"tf":1},"259":{"tf":1}},"df":4}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"231":{"tf":1},"233":{"tf":1.4142135623730951},"254":{"tf":1}},"df":3}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"37":{"tf":1}},"df":1}},"i":{"docs":{},"df":0,"v":{"docs":{"141":{"tf":1},"142":{"tf":1},"155":{"tf":1},"174":{"tf":1}},"df":4}}}},"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"4":{"tf":1},"5":{"tf":1},"40":{"tf":1},"54":{"tf":1.7320508075688772},"55":{"tf":3.1622776601683795},"56":{"tf":2},"81":{"tf":1},"225":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951}},"df":10}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"y":{"docs":{"4":{"tf":1},"20":{"tf":1},"27":{"tf":1.4142135623730951},"28":{"tf":1},"33":{"tf":1},"50":{"tf":1},"74":{"tf":1.4142135623730951}},"df":7},"c":{"docs":{"97":{"tf":1},"141":{"tf":1},"154":{"tf":1},"155":{"tf":1},"156":{"tf":1},"161":{"tf":1},"274":{"tf":1},"283":{"tf":1}},"df":8}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{"4":{"tf":1},"80":{"tf":1},"111":{"tf":1},"259":{"tf":1}},"df":4}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"101":{"tf":1},"266":{"tf":1},"267":{"tf":1}},"df":3,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"74":{"tf":1}},"df":1}}}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"204":{"tf":1}},"df":1}}}}},"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"4":{"tf":1},"11":{"tf":1},"27":{"tf":1.4142135623730951},"28":{"tf":1},"43":{"tf":1},"54":{"tf":1},"55":{"tf":1.4142135623730951},"56":{"tf":1},"86":{"tf":1},"164":{"tf":1},"173":{"tf":1},"178":{"tf":1.4142135623730951},"200":{"tf":1.4142135623730951},"204":{"tf":1.7320508075688772},"223":{"tf":1}},"df":16}},"m":{"docs":{"126":{"tf":1}},"df":1}},"t":{"docs":{"143":{"tf":1}},"df":1,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"189":{"tf":1},"238":{"tf":1}},"df":3}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"82":{"tf":1}},"df":1}}}}}}},"e":{"docs":{},"df":0,"t":{"docs":{"26":{"tf":1.4142135623730951},"89":{"tf":1},"93":{"tf":1.4142135623730951},"95":{"tf":1},"96":{"tf":1},"97":{"tf":2},"189":{"tf":1}},"df":7,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{"189":{"tf":1}},"df":1}}}}}}}}}}}},"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"v":{"docs":{"114":{"tf":1.4142135623730951},"141":{"tf":1},"237":{"tf":1}},"df":3}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"114":{"tf":1},"120":{"tf":1},"150":{"tf":1},"175":{"tf":1},"204":{"tf":1},"232":{"tf":1},"266":{"tf":1}},"df":7}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"233":{"tf":1}},"df":1}}}}},"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"8":{"tf":1},"19":{"tf":1},"43":{"tf":1},"80":{"tf":1},"111":{"tf":1},"120":{"tf":1},"156":{"tf":1},"163":{"tf":1},"164":{"tf":1.4142135623730951},"181":{"tf":1},"200":{"tf":1},"204":{"tf":1.4142135623730951},"209":{"tf":1},"238":{"tf":1.7320508075688772},"239":{"tf":1},"241":{"tf":1},"242":{"tf":1.4142135623730951},"261":{"tf":1},"262":{"tf":1},"265":{"tf":1}},"df":21,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{"175":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"38":{"tf":1}},"df":1}}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"8":{"tf":1.4142135623730951},"181":{"tf":1},"185":{"tf":1},"190":{"tf":1},"222":{"tf":1},"233":{"tf":1},"237":{"tf":1},"241":{"tf":1.4142135623730951},"243":{"tf":1.7320508075688772},"244":{"tf":1},"255":{"tf":1},"259":{"tf":1}},"df":13},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"219":{"tf":1}},"df":1}}}}}},"w":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"5":{"tf":1}},"df":1}}}}}}},"a":{"docs":{},"df":0,"d":{"docs":{"8":{"tf":1},"27":{"tf":1},"142":{"tf":1},"174":{"tf":1},"204":{"tf":1},"215":{"tf":1},"220":{"tf":1},"228":{"tf":1},"265":{"tf":1}},"df":9,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"27":{"tf":1},"111":{"tf":1}},"df":2}}},"i":{"docs":{"209":{"tf":1},"224":{"tf":1},"262":{"tf":1},"267":{"tf":1},"272":{"tf":1},"275":{"tf":1}},"df":6}},"l":{"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1},"21":{"tf":1.7320508075688772},"63":{"tf":1},"69":{"tf":1},"238":{"tf":1}},"df":6,"l":{"docs":{},"df":0,"i":{"docs":{"97":{"tf":1},"209":{"tf":1}},"df":2}},"i":{"docs":{},"df":0,"z":{"docs":{"272":{"tf":1}},"df":1}}},"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"21":{"tf":1},"40":{"tf":1},"129":{"tf":1},"169":{"tf":1}},"df":4}}},"c":{"docs":{},"df":0,"h":{"docs":{"126":{"tf":1},"129":{"tf":1},"209":{"tf":1},"267":{"tf":1}},"df":4}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"15":{"tf":1}},"df":1}}}},"d":{"docs":{"38":{"tf":1.7320508075688772},"137":{"tf":1},"141":{"tf":1},"143":{"tf":1},"162":{"tf":1}},"df":5,"u":{"docs":{},"df":0,"c":{"docs":{"216":{"tf":1},"251":{"tf":1}},"df":2},"n":{"docs":{},"df":0,"d":{"docs":{"250":{"tf":1},"251":{"tf":1}},"df":2}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"v":{"docs":{"40":{"tf":1},"174":{"tf":1}},"df":2},"a":{"docs":{},"df":0,"s":{"docs":{"126":{"tf":1},"143":{"tf":1},"147":{"tf":1},"169":{"tf":1}},"df":4}}},"i":{"docs":{"155":{"tf":1},"239":{"tf":1},"241":{"tf":1.7320508075688772},"247":{"tf":1}},"df":4},"a":{"docs":{},"df":0,"t":{"docs":{"215":{"tf":1},"231":{"tf":1},"232":{"tf":1},"234":{"tf":1},"246":{"tf":1},"258":{"tf":1},"259":{"tf":1},"261":{"tf":1},"274":{"tf":1}},"df":9}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"71":{"tf":1},"74":{"tf":1},"77":{"tf":1},"80":{"tf":1},"81":{"tf":1},"270":{"tf":1}},"df":6}}},"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"80":{"tf":1},"86":{"tf":1},"89":{"tf":1},"94":{"tf":1},"101":{"tf":1}},"df":5}}}}},"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"114":{"tf":1},"252":{"tf":1}},"df":2}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{"141":{"tf":1},"170":{"tf":1},"173":{"tf":1},"174":{"tf":2.23606797749979},"175":{"tf":1},"190":{"tf":2},"204":{"tf":1}},"df":7}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"v":{"docs":{"119":{"tf":1},"120":{"tf":2},"147":{"tf":1},"219":{"tf":1},"244":{"tf":1},"251":{"tf":1},"282":{"tf":1},"285":{"tf":1}},"df":8}},"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"125":{"tf":1}},"df":1}},"r":{"docs":{},"df":0,"k":{"docs":{"132":{"tf":1}},"df":1}}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{"226":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1.4142135623730951},"21":{"tf":2.449489742783178},"27":{"tf":1},"34":{"tf":1},"37":{"tf":2.449489742783178},"38":{"tf":1.4142135623730951},"40":{"tf":2.449489742783178},"50":{"tf":1.7320508075688772},"51":{"tf":1},"54":{"tf":1.4142135623730951},"55":{"tf":1},"56":{"tf":1},"63":{"tf":1.4142135623730951},"98":{"tf":1},"107":{"tf":1},"114":{"tf":2},"117":{"tf":1.4142135623730951},"118":{"tf":1},"119":{"tf":1},"126":{"tf":1},"129":{"tf":1},"136":{"tf":1.4142135623730951},"137":{"tf":1},"138":{"tf":1},"141":{"tf":2},"143":{"tf":1},"144":{"tf":2.23606797749979},"147":{"tf":1.4142135623730951},"158":{"tf":1},"162":{"tf":1},"163":{"tf":1},"169":{"tf":1},"178":{"tf":1.4142135623730951},"204":{"tf":1},"205":{"tf":1},"215":{"tf":1},"218":{"tf":1},"220":{"tf":1},"221":{"tf":1},"224":{"tf":1},"225":{"tf":1.7320508075688772},"226":{"tf":1.7320508075688772},"227":{"tf":1.4142135623730951},"231":{"tf":1.4142135623730951},"233":{"tf":2.449489742783178},"236":{"tf":2},"237":{"tf":1.4142135623730951},"238":{"tf":1.4142135623730951},"239":{"tf":1.4142135623730951},"241":{"tf":1.7320508075688772},"243":{"tf":1.4142135623730951},"244":{"tf":1},"247":{"tf":1.4142135623730951},"248":{"tf":2},"249":{"tf":1},"250":{"tf":1.4142135623730951},"252":{"tf":1.7320508075688772},"253":{"tf":1},"255":{"tf":1.4142135623730951},"262":{"tf":1.4142135623730951},"275":{"tf":1}},"df":61,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"b":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"189":{"tf":1}},"df":1}}}}}}}}}}}},"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1.4142135623730951},"27":{"tf":1},"38":{"tf":1},"39":{"tf":1},"43":{"tf":1},"56":{"tf":1},"71":{"tf":1},"74":{"tf":1},"77":{"tf":1},"80":{"tf":1},"81":{"tf":1},"120":{"tf":1},"141":{"tf":1},"162":{"tf":1},"163":{"tf":1.4142135623730951},"164":{"tf":1},"168":{"tf":1.4142135623730951},"175":{"tf":1},"204":{"tf":2.449489742783178},"220":{"tf":1.4142135623730951},"235":{"tf":1.4142135623730951},"247":{"tf":1},"262":{"tf":1},"272":{"tf":1},"275":{"tf":1}},"df":25}}},"d":{"docs":{"178":{"tf":1}},"df":1}},"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{"26":{"tf":1.4142135623730951},"72":{"tf":1},"73":{"tf":1},"74":{"tf":1},"108":{"tf":1.4142135623730951}},"df":5}},"o":{"docs":{},"df":0,"t":{"docs":{"40":{"tf":1},"80":{"tf":1},"181":{"tf":1.7320508075688772},"270":{"tf":1}},"df":4}},"w":{"docs":{"108":{"tf":1},"120":{"tf":1},"155":{"tf":1},"163":{"tf":1},"164":{"tf":1.4142135623730951},"168":{"tf":2.8284271247461903},"169":{"tf":1},"204":{"tf":1},"221":{"tf":2.23606797749979}},"df":9},"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"231":{"tf":1},"233":{"tf":1}},"df":2}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{"27":{"tf":1},"56":{"tf":1}},"df":2}},"n":{"docs":{"64":{"tf":1}},"df":1},"i":{"docs":{},"df":0,"s":{"docs":{"71":{"tf":1},"72":{"tf":1}},"df":2}},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{"174":{"tf":1}},"df":1}}}}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"14":{"tf":1.4142135623730951}},"df":2}},"g":{"docs":{"3":{"tf":1},"34":{"tf":1},"37":{"tf":2.6457513110645907},"38":{"tf":1.4142135623730951},"40":{"tf":2.23606797749979},"50":{"tf":1},"51":{"tf":1},"54":{"tf":1},"71":{"tf":1},"72":{"tf":1},"98":{"tf":1},"114":{"tf":2},"137":{"tf":1},"138":{"tf":1},"141":{"tf":2.23606797749979},"144":{"tf":2},"162":{"tf":1},"169":{"tf":1},"190":{"tf":1},"191":{"tf":1.7320508075688772},"199":{"tf":1.4142135623730951},"201":{"tf":1},"204":{"tf":1.7320508075688772},"225":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"227":{"tf":1},"236":{"tf":1},"237":{"tf":1.4142135623730951},"241":{"tf":1},"243":{"tf":1},"244":{"tf":1},"248":{"tf":1.4142135623730951},"249":{"tf":1},"252":{"tf":1},"253":{"tf":1}},"df":35,"i":{"docs":{},"df":0,"n":{"docs":{"71":{"tf":1},"201":{"tf":1},"241":{"tf":1},"255":{"tf":1}},"df":4},"c":{"docs":{"154":{"tf":1},"216":{"tf":1},"228":{"tf":1}},"df":3}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"190":{"tf":1}},"df":1}}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"204":{"tf":1}},"df":1}}}}},"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"255":{"tf":1}},"df":1}}}},"o":{"docs":{},"df":0,"k":{"docs":{"4":{"tf":1.4142135623730951},"5":{"tf":1},"11":{"tf":1},"14":{"tf":1},"21":{"tf":1},"25":{"tf":1},"43":{"tf":1},"46":{"tf":1},"89":{"tf":1},"97":{"tf":1},"107":{"tf":1},"135":{"tf":1},"153":{"tf":1},"162":{"tf":1},"184":{"tf":1},"188":{"tf":1},"198":{"tf":1},"204":{"tf":1.4142135623730951},"212":{"tf":1},"216":{"tf":1},"221":{"tf":1},"222":{"tf":1},"232":{"tf":1},"235":{"tf":1},"238":{"tf":1.4142135623730951},"239":{"tf":1},"241":{"tf":1.4142135623730951},"243":{"tf":1},"247":{"tf":1},"251":{"tf":1},"263":{"tf":1},"265":{"tf":1},"266":{"tf":1},"269":{"tf":1},"271":{"tf":1},"272":{"tf":1},"274":{"tf":1},"277":{"tf":1},"280":{"tf":1},"286":{"tf":1.4142135623730951},"289":{"tf":1}},"df":41},"p":{"docs":{"173":{"tf":1},"195":{"tf":1.7320508075688772},"204":{"tf":4.47213595499958}},"df":3}},"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"14":{"tf":1},"173":{"tf":1.7320508075688772},"174":{"tf":1},"175":{"tf":2},"178":{"tf":2.6457513110645907},"189":{"tf":1.4142135623730951}},"df":6},"t":{"docs":{"114":{"tf":1.4142135623730951},"170":{"tf":1.7320508075688772},"184":{"tf":1},"212":{"tf":1},"251":{"tf":1.4142135623730951}},"df":5}}},"n":{"docs":{},"df":0,"g":{"docs":{"40":{"tf":1},"86":{"tf":1},"147":{"tf":1},"168":{"tf":1.4142135623730951}},"df":4,"e":{"docs":{},"df":0,"r":{"docs":{"259":{"tf":1}},"df":1}}}},"w":{"docs":{"71":{"tf":1},"72":{"tf":1}},"df":2},"s":{"docs":{},"df":0,"e":{"docs":{"126":{"tf":1}},"df":1}},"t":{"docs":{"204":{"tf":1},"209":{"tf":1},"233":{"tf":1},"238":{"tf":1},"244":{"tf":1},"250":{"tf":1},"289":{"tf":1}},"df":7}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"x":{"docs":{"3":{"tf":1}},"df":1}},"k":{"docs":{"21":{"tf":1}},"df":1},"e":{"docs":{"74":{"tf":1},"163":{"tf":1},"173":{"tf":1},"175":{"tf":1.7320508075688772},"178":{"tf":2.6457513110645907},"192":{"tf":1},"204":{"tf":1}},"df":7}},"s":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"26":{"tf":1},"28":{"tf":1},"37":{"tf":1},"63":{"tf":1},"64":{"tf":1},"81":{"tf":1},"96":{"tf":1},"104":{"tf":1},"107":{"tf":2},"108":{"tf":2.23606797749979},"114":{"tf":1},"141":{"tf":1},"162":{"tf":1},"181":{"tf":1.4142135623730951},"192":{"tf":1},"204":{"tf":2}},"df":17}},"b":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"43":{"tf":1},"181":{"tf":3.1622776601683795},"184":{"tf":1.7320508075688772},"185":{"tf":2},"188":{"tf":1},"204":{"tf":1.7320508075688772},"209":{"tf":1}},"df":7}}}}},"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"120":{"tf":1}},"df":1}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"157":{"tf":1}},"df":1}},"t":{"docs":{},"df":0,"l":{"docs":{"250":{"tf":1}},"df":1}}},"f":{"docs":{},"df":0,"e":{"docs":{"238":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1},"86":{"tf":1},"114":{"tf":1},"150":{"tf":1},"204":{"tf":1},"209":{"tf":1},"250":{"tf":1},"255":{"tf":1}},"df":8}},"v":{"docs":{"55":{"tf":1},"132":{"tf":1},"204":{"tf":1.4142135623730951}},"df":3},"d":{"docs":{"56":{"tf":1},"204":{"tf":1},"250":{"tf":1}},"df":3},"f":{"docs":{"124":{"tf":1}},"df":1}},"f":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1},"38":{"tf":1.4142135623730951},"56":{"tf":1},"96":{"tf":1},"169":{"tf":1},"204":{"tf":1}},"df":6}},"t":{"docs":{"63":{"tf":1},"168":{"tf":1},"204":{"tf":1},"221":{"tf":1},"225":{"tf":1},"233":{"tf":1},"236":{"tf":1},"241":{"tf":1.7320508075688772},"247":{"tf":1},"262":{"tf":1},"263":{"tf":1},"272":{"tf":1},"277":{"tf":1},"280":{"tf":1}},"df":14,"'":{"docs":{"21":{"tf":1},"27":{"tf":1},"33":{"tf":1},"46":{"tf":1},"50":{"tf":1},"55":{"tf":1},"66":{"tf":1},"93":{"tf":1},"198":{"tf":1},"204":{"tf":1.7320508075688772}},"df":10},"’":{"docs":{"155":{"tf":1},"162":{"tf":1}},"df":2}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"56":{"tf":1}},"df":1}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"81":{"tf":1},"124":{"tf":1},"125":{"tf":1},"130":{"tf":1},"163":{"tf":1},"168":{"tf":1},"178":{"tf":2.23606797749979},"216":{"tf":2.23606797749979},"217":{"tf":1},"218":{"tf":1},"219":{"tf":1},"237":{"tf":1},"259":{"tf":2},"270":{"tf":1.7320508075688772}},"df":14}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"26":{"tf":1},"114":{"tf":1},"141":{"tf":1},"154":{"tf":1},"221":{"tf":1},"241":{"tf":1}},"df":6},"s":{"docs":{},"df":0,"t":{"docs":{"37":{"tf":1}},"df":1}}}},"s":{"docs":{},"df":0,"t":{"docs":{"55":{"tf":1},"94":{"tf":1},"101":{"tf":1},"111":{"tf":1},"123":{"tf":1},"129":{"tf":1},"153":{"tf":1},"174":{"tf":1},"204":{"tf":2},"237":{"tf":1},"281":{"tf":1}},"df":11}},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"96":{"tf":1},"111":{"tf":1.4142135623730951}},"df":2}}},"y":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"114":{"tf":1}},"df":1}}}},"r":{"docs":{},"df":0,"g":{"docs":{"168":{"tf":1}},"df":1}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"218":{"tf":1},"224":{"tf":1},"232":{"tf":1},"233":{"tf":1.7320508075688772},"237":{"tf":1},"238":{"tf":1},"262":{"tf":1}},"df":7}}}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{"3":{"tf":1},"4":{"tf":1},"55":{"tf":1},"56":{"tf":1},"141":{"tf":1},"142":{"tf":1.4142135623730951},"150":{"tf":1},"154":{"tf":1},"189":{"tf":1},"192":{"tf":1.7320508075688772},"215":{"tf":1.7320508075688772},"217":{"tf":1.7320508075688772},"218":{"tf":1},"219":{"tf":2},"220":{"tf":4.69041575982343},"221":{"tf":2.6457513110645907},"222":{"tf":1.7320508075688772},"223":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951},"225":{"tf":1.4142135623730951},"227":{"tf":2.23606797749979},"228":{"tf":2.449489742783178},"244":{"tf":1}},"df":23,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"f":{"docs":{"189":{"tf":1.4142135623730951}},"df":1}}}}}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"192":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"s":{"docs":{"220":{"tf":1}},"df":1}}}},"e":{"docs":{"71":{"tf":1},"190":{"tf":1.7320508075688772}},"df":2}},"y":{"docs":{"259":{"tf":1}},"df":1}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1},"216":{"tf":1}},"df":2}},"r":{"docs":{"63":{"tf":1},"64":{"tf":1}},"df":2}},"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"28":{"tf":1},"255":{"tf":1},"270":{"tf":1}},"df":4}},"b":{"docs":{"8":{"tf":1},"16":{"tf":1},"56":{"tf":1},"89":{"tf":1},"97":{"tf":1},"161":{"tf":1},"173":{"tf":1},"181":{"tf":1},"204":{"tf":1.4142135623730951},"258":{"tf":1},"270":{"tf":1}},"df":11}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{"3":{"tf":1},"89":{"tf":1},"181":{"tf":1},"190":{"tf":1},"286":{"tf":1}},"df":5}}}},"i":{"docs":{},"df":0,"c":{"docs":{"19":{"tf":2.23606797749979},"20":{"tf":1.4142135623730951},"21":{"tf":4},"63":{"tf":2.23606797749979},"64":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"66":{"tf":1},"69":{"tf":1.4142135623730951},"163":{"tf":1},"189":{"tf":3.3166247903554},"198":{"tf":1}},"df":11,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"21":{"tf":1.4142135623730951}},"df":1}}},"'":{"docs":{"189":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"4":{"tf":1},"8":{"tf":1},"15":{"tf":1},"27":{"tf":1},"33":{"tf":1},"37":{"tf":1},"39":{"tf":1},"40":{"tf":1},"43":{"tf":1.4142135623730951},"56":{"tf":1},"71":{"tf":1},"104":{"tf":1.4142135623730951},"111":{"tf":1},"137":{"tf":1},"156":{"tf":1},"157":{"tf":1.4142135623730951},"163":{"tf":1},"173":{"tf":1.4142135623730951},"174":{"tf":1},"178":{"tf":1},"181":{"tf":1},"198":{"tf":1},"204":{"tf":1},"205":{"tf":1},"206":{"tf":1},"220":{"tf":1},"228":{"tf":1},"239":{"tf":1},"255":{"tf":1.4142135623730951},"262":{"tf":1},"270":{"tf":1}},"df":32}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"39":{"tf":1},"163":{"tf":1},"199":{"tf":1},"204":{"tf":1},"237":{"tf":1},"280":{"tf":1}},"df":6}}}}}},"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{"114":{"tf":1.4142135623730951},"135":{"tf":1.4142135623730951},"162":{"tf":1},"163":{"tf":1},"164":{"tf":1},"167":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"170":{"tf":1}},"df":8,"g":{"docs":{"4":{"tf":1},"34":{"tf":1.4142135623730951},"114":{"tf":2.6457513110645907},"117":{"tf":1.4142135623730951},"120":{"tf":2},"126":{"tf":1.7320508075688772},"129":{"tf":1},"135":{"tf":2.6457513110645907},"136":{"tf":1.7320508075688772},"144":{"tf":1.4142135623730951},"147":{"tf":1.7320508075688772},"162":{"tf":1.4142135623730951},"168":{"tf":1},"170":{"tf":1},"175":{"tf":1},"252":{"tf":2}},"df":16}}}},"m":{"docs":{},"df":0,"o":{"docs":{"4":{"tf":1.4142135623730951},"21":{"tf":1},"22":{"tf":1},"46":{"tf":1},"64":{"tf":1},"80":{"tf":1},"89":{"tf":1},"107":{"tf":1},"108":{"tf":1},"204":{"tf":1},"215":{"tf":1},"227":{"tf":1.4142135623730951},"239":{"tf":1},"250":{"tf":1},"259":{"tf":1},"261":{"tf":1},"262":{"tf":1}},"df":17,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{"81":{"tf":1},"107":{"tf":1},"164":{"tf":1},"168":{"tf":1},"216":{"tf":1},"219":{"tf":1},"233":{"tf":1},"260":{"tf":1}},"df":8}}}},"'":{"docs":{"204":{"tf":1}},"df":1},"s":{"docs":{},"df":0,"/":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"212":{"tf":1}},"df":1,"/":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"215":{"tf":1},"227":{"tf":1.4142135623730951}},"df":2}}}}}}}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"231":{"tf":1},"242":{"tf":1}},"df":2}}}},"_":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"231":{"tf":1},"232":{"tf":1},"234":{"tf":1},"246":{"tf":1}},"df":4}}}}}}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"_":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"258":{"tf":1},"259":{"tf":1}},"df":2}}}},"_":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"258":{"tf":1},"261":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"237":{"tf":1},"244":{"tf":1},"247":{"tf":1}},"df":3}}}},"c":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"4":{"tf":1},"55":{"tf":1},"63":{"tf":1},"154":{"tf":1}},"df":4}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"174":{"tf":1}},"df":1}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"51":{"tf":1},"80":{"tf":1.4142135623730951},"108":{"tf":1},"126":{"tf":1},"155":{"tf":1},"173":{"tf":1.4142135623730951},"178":{"tf":2.23606797749979},"220":{"tf":1},"221":{"tf":1.7320508075688772},"223":{"tf":1},"231":{"tf":1},"233":{"tf":1.4142135623730951},"237":{"tf":1},"239":{"tf":1},"241":{"tf":1},"247":{"tf":1}},"df":16,"i":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"114":{"tf":1},"154":{"tf":1},"163":{"tf":1},"168":{"tf":1.4142135623730951},"175":{"tf":1},"178":{"tf":1.4142135623730951},"201":{"tf":1},"204":{"tf":1.7320508075688772},"217":{"tf":1},"227":{"tf":1},"259":{"tf":1},"270":{"tf":1},"289":{"tf":1}},"df":14}}}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"40":{"tf":1},"64":{"tf":1},"71":{"tf":1},"135":{"tf":1},"141":{"tf":1},"155":{"tf":2.449489742783178},"157":{"tf":1},"162":{"tf":1.4142135623730951},"163":{"tf":1},"164":{"tf":1.4142135623730951},"178":{"tf":1.7320508075688772},"190":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951},"227":{"tf":1},"273":{"tf":1},"277":{"tf":1.4142135623730951},"286":{"tf":1},"287":{"tf":1}},"df":18}}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"233":{"tf":1}},"df":1}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"51":{"tf":1},"178":{"tf":1},"201":{"tf":1},"219":{"tf":1},"231":{"tf":1.7320508075688772},"233":{"tf":3},"234":{"tf":1},"235":{"tf":2.449489742783178},"236":{"tf":1.4142135623730951},"237":{"tf":2.449489742783178},"238":{"tf":2.6457513110645907},"239":{"tf":2.8284271247461903},"241":{"tf":3.7416573867739413},"242":{"tf":3.1622776601683795},"243":{"tf":2.6457513110645907},"244":{"tf":2.23606797749979},"247":{"tf":2},"248":{"tf":1},"249":{"tf":1},"251":{"tf":1.4142135623730951},"252":{"tf":1},"253":{"tf":1},"254":{"tf":1},"255":{"tf":3.3166247903554},"261":{"tf":1},"262":{"tf":1}},"df":26,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"233":{"tf":1},"235":{"tf":1},"250":{"tf":1}},"df":3}}}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"217":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"97":{"tf":1},"162":{"tf":1},"168":{"tf":1},"178":{"tf":1.4142135623730951}},"df":4}},"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"192":{"tf":1.4142135623730951}},"df":1}}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"212":{"tf":1},"250":{"tf":1},"267":{"tf":1}},"df":3}}},"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"236":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"l":{"docs":{"242":{"tf":1},"280":{"tf":1}},"df":2},"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"252":{"tf":1}},"df":1}}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{"3":{"tf":1},"21":{"tf":1},"27":{"tf":1},"31":{"tf":1},"43":{"tf":1},"104":{"tf":1},"126":{"tf":1},"129":{"tf":1},"143":{"tf":1},"163":{"tf":1},"178":{"tf":1},"201":{"tf":1},"231":{"tf":1},"250":{"tf":1.4142135623730951},"274":{"tf":1},"284":{"tf":1}},"df":16},"a":{"docs":{},"df":0,"t":{"docs":{"38":{"tf":1},"178":{"tf":1}},"df":2}}},"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"86":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{"272":{"tf":1.4142135623730951}},"df":1}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1},"178":{"tf":1},"192":{"tf":1},"215":{"tf":1.4142135623730951},"217":{"tf":1},"218":{"tf":1},"227":{"tf":1},"228":{"tf":1.4142135623730951}},"df":8},"r":{"docs":{"192":{"tf":1},"219":{"tf":1},"220":{"tf":3},"222":{"tf":1.4142135623730951},"223":{"tf":1},"227":{"tf":1.7320508075688772},"228":{"tf":1.7320508075688772}},"df":7}}},"f":{"docs":{},"df":0,"t":{"docs":{"170":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"g":{"docs":{"80":{"tf":1},"94":{"tf":1},"97":{"tf":1},"162":{"tf":1},"235":{"tf":1}},"df":5},"w":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"225":{"tf":1}},"df":1}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"259":{"tf":1}},"df":1}}}}},"o":{"docs":{},"df":0,"p":{"docs":{"80":{"tf":1},"94":{"tf":1},"162":{"tf":1},"235":{"tf":1}},"df":4}}},"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":2},"39":{"tf":1},"43":{"tf":1},"150":{"tf":1.4142135623730951},"154":{"tf":1},"162":{"tf":1},"168":{"tf":1},"178":{"tf":2},"195":{"tf":1},"204":{"tf":1},"215":{"tf":1},"216":{"tf":1.4142135623730951},"217":{"tf":1},"220":{"tf":1},"224":{"tf":1},"226":{"tf":1},"227":{"tf":1},"232":{"tf":1},"239":{"tf":1},"241":{"tf":1},"259":{"tf":1}},"df":21}},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"147":{"tf":1},"259":{"tf":1}},"df":2}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"111":{"tf":1},"162":{"tf":1}},"df":2,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1},"89":{"tf":1.4142135623730951},"181":{"tf":1},"184":{"tf":1}},"df":4}}},"l":{"docs":{},"df":0,"i":{"docs":{"43":{"tf":1.4142135623730951},"64":{"tf":1},"69":{"tf":1},"114":{"tf":1},"141":{"tf":1},"164":{"tf":1},"167":{"tf":1},"175":{"tf":1},"178":{"tf":1},"233":{"tf":1},"265":{"tf":1},"274":{"tf":1}},"df":12}}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"14":{"tf":1},"33":{"tf":1},"37":{"tf":1.4142135623730951},"40":{"tf":1},"80":{"tf":1},"96":{"tf":1.4142135623730951},"137":{"tf":1},"164":{"tf":1.4142135623730951},"204":{"tf":2.23606797749979},"221":{"tf":1},"233":{"tf":1},"238":{"tf":1.4142135623730951},"241":{"tf":4.47213595499958},"242":{"tf":3.4641016151377544},"243":{"tf":1.7320508075688772},"250":{"tf":1},"253":{"tf":1.4142135623730951},"258":{"tf":1},"259":{"tf":1.4142135623730951},"262":{"tf":1},"265":{"tf":1.4142135623730951},"267":{"tf":1.7320508075688772},"275":{"tf":1},"280":{"tf":1.4142135623730951}},"df":24}}},"g":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{"37":{"tf":1},"39":{"tf":1},"40":{"tf":1}},"df":3}}}}}},"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"y":{"docs":{"15":{"tf":1},"27":{"tf":1},"37":{"tf":1},"38":{"tf":1},"104":{"tf":1},"162":{"tf":1},"175":{"tf":1},"204":{"tf":1},"278":{"tf":1}},"df":9}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1.4142135623730951},"174":{"tf":1},"216":{"tf":3},"217":{"tf":1},"218":{"tf":1},"219":{"tf":1},"221":{"tf":1},"223":{"tf":1},"224":{"tf":1},"225":{"tf":1.7320508075688772},"232":{"tf":1},"234":{"tf":1},"236":{"tf":1.4142135623730951},"237":{"tf":1},"239":{"tf":1},"240":{"tf":1}},"df":16}}}},"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"114":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"101":{"tf":1},"169":{"tf":1}},"df":2}}}}},"b":{"docs":{},"df":0,"l":{"docs":{"191":{"tf":1}},"df":1}},"d":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"219":{"tf":1}},"df":1}}}}}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"181":{"tf":1}},"df":1}}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"239":{"tf":1}},"df":1}}}}}},"o":{"docs":{"167":{"tf":1}},"df":1,"u":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"15":{"tf":1},"154":{"tf":1},"168":{"tf":1.7320508075688772}},"df":3}}},"n":{"docs":{},"df":0,"e":{"docs":{"21":{"tf":1},"26":{"tf":1},"54":{"tf":1},"117":{"tf":1},"157":{"tf":1},"181":{"tf":1},"199":{"tf":1},"209":{"tf":1},"223":{"tf":1},"227":{"tf":1},"234":{"tf":1},"241":{"tf":1},"246":{"tf":1}},"df":13},"’":{"docs":{},"df":0,"t":{"docs":{"114":{"tf":1},"147":{"tf":1}},"df":2}},"'":{"docs":{},"df":0,"t":{"docs":{"155":{"tf":1}},"df":1}}},"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"26":{"tf":1},"43":{"tf":1.4142135623730951},"54":{"tf":1},"56":{"tf":1},"181":{"tf":1}},"df":5}}}}}},"w":{"docs":{},"df":0,"n":{"docs":{"94":{"tf":1}},"df":1,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"64":{"tf":1.4142135623730951}},"df":1}}}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"n":{"docs":{},"df":0,"'":{"docs":{},"df":0,"t":{"docs":{"277":{"tf":1}},"df":1}}}}}},"y":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"204":{"tf":1}},"df":1}}}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{"3":{"tf":1.4142135623730951},"14":{"tf":1},"21":{"tf":1.4142135623730951},"26":{"tf":1},"40":{"tf":1},"43":{"tf":1.7320508075688772},"50":{"tf":1},"62":{"tf":1.4142135623730951},"69":{"tf":1},"70":{"tf":1},"77":{"tf":1},"80":{"tf":1.4142135623730951},"86":{"tf":1},"94":{"tf":1.4142135623730951},"107":{"tf":1.7320508075688772},"108":{"tf":1.4142135623730951},"114":{"tf":2.6457513110645907},"118":{"tf":1},"120":{"tf":1.4142135623730951},"136":{"tf":1},"141":{"tf":1},"162":{"tf":1.4142135623730951},"163":{"tf":1},"173":{"tf":1.7320508075688772},"175":{"tf":1.4142135623730951},"178":{"tf":1.7320508075688772},"181":{"tf":1.4142135623730951},"199":{"tf":1},"204":{"tf":1.4142135623730951},"209":{"tf":1},"220":{"tf":1.4142135623730951},"224":{"tf":1},"235":{"tf":1.4142135623730951},"238":{"tf":1},"241":{"tf":4},"247":{"tf":1},"251":{"tf":1},"252":{"tf":1.4142135623730951},"262":{"tf":1.7320508075688772},"267":{"tf":1},"272":{"tf":1},"275":{"tf":1.4142135623730951}},"df":42},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"o":{"docs":{"3":{"tf":1.4142135623730951},"43":{"tf":1},"114":{"tf":1},"150":{"tf":1.4142135623730951},"181":{"tf":1},"195":{"tf":1},"209":{"tf":1},"231":{"tf":1}},"df":8}}},"e":{"docs":{},"df":0,"w":{"docs":{"28":{"tf":1},"38":{"tf":1},"39":{"tf":1},"241":{"tf":2.8284271247461903}},"df":4}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"77":{"tf":1},"120":{"tf":1},"168":{"tf":1},"280":{"tf":1}},"df":4}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1},"4":{"tf":1},"43":{"tf":1},"181":{"tf":1}},"df":4}}}},"i":{"docs":{"26":{"tf":1},"47":{"tf":1},"56":{"tf":1},"163":{"tf":1},"204":{"tf":1},"219":{"tf":1},"233":{"tf":2},"254":{"tf":1.4142135623730951}},"df":8,"f":{"docs":{},"df":0,"i":{"docs":{"77":{"tf":1},"224":{"tf":1},"233":{"tf":1},"241":{"tf":1},"252":{"tf":1}},"df":5}}}},"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{"26":{"tf":1.4142135623730951},"72":{"tf":1},"204":{"tf":1},"216":{"tf":1},"233":{"tf":1},"241":{"tf":4.123105625617661},"242":{"tf":2.449489742783178},"243":{"tf":1.4142135623730951},"244":{"tf":1.4142135623730951},"252":{"tf":1},"267":{"tf":1.4142135623730951}},"df":11,"e":{"docs":{},"df":0,"t":{"docs":{"108":{"tf":1},"265":{"tf":1.4142135623730951}},"df":2,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"@":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"&":{"0":{"docs":{"108":{"tf":1}},"df":1},"docs":{},"df":0}}}}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"265":{"tf":1}},"df":1}}}}}}}}}}}}}}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"241":{"tf":1.7320508075688772}},"df":1}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"114":{"tf":1.7320508075688772},"141":{"tf":1.4142135623730951},"150":{"tf":2.23606797749979},"153":{"tf":1},"155":{"tf":1.7320508075688772},"156":{"tf":1},"157":{"tf":2.8284271247461903},"161":{"tf":1},"162":{"tf":1.7320508075688772},"163":{"tf":3.4641016151377544},"164":{"tf":1},"167":{"tf":2},"168":{"tf":3.4641016151377544},"169":{"tf":2.23606797749979},"173":{"tf":3.7416573867739413},"174":{"tf":2.449489742783178},"175":{"tf":3.7416573867739413},"178":{"tf":5.477225575051661},"185":{"tf":1},"190":{"tf":1},"192":{"tf":1.4142135623730951},"199":{"tf":1},"200":{"tf":2},"201":{"tf":1.7320508075688772},"204":{"tf":3.3166247903554},"221":{"tf":1.4142135623730951},"223":{"tf":1.4142135623730951},"227":{"tf":2.449489742783178},"255":{"tf":1.7320508075688772},"287":{"tf":1}},"df":32}},"n":{"docs":{},"df":0,"t":{"docs":{"212":{"tf":1}},"df":1}}},"o":{"docs":{},"df":0,"u":{"docs":{"129":{"tf":1},"141":{"tf":1},"189":{"tf":1}},"df":3}}}},"l":{"docs":{},"df":0,"u":{"docs":{"26":{"tf":1.4142135623730951},"39":{"tf":1},"97":{"tf":1},"111":{"tf":1},"141":{"tf":1.7320508075688772},"142":{"tf":1},"143":{"tf":1},"154":{"tf":1},"155":{"tf":3.4641016151377544},"156":{"tf":1},"157":{"tf":1.7320508075688772},"162":{"tf":1.4142135623730951},"163":{"tf":2.6457513110645907},"164":{"tf":2.23606797749979},"167":{"tf":1.4142135623730951},"168":{"tf":3},"169":{"tf":1.4142135623730951},"173":{"tf":1},"174":{"tf":2},"175":{"tf":1.4142135623730951},"178":{"tf":2.6457513110645907},"185":{"tf":1},"192":{"tf":2.23606797749979},"200":{"tf":1},"201":{"tf":1.7320508075688772},"204":{"tf":2.449489742783178},"205":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"227":{"tf":1},"262":{"tf":1},"265":{"tf":1},"273":{"tf":1},"277":{"tf":2.23606797749979},"284":{"tf":1.7320508075688772},"285":{"tf":1},"286":{"tf":1.7320508075688772},"287":{"tf":1.4142135623730951}},"df":37},"i":{"docs":{},"df":0,"d":{"docs":{"43":{"tf":1},"155":{"tf":1},"178":{"tf":1},"185":{"tf":1}},"df":4}}}}},"h":{"docs":{},"df":0,"a":{"docs":{"3":{"tf":1},"5":{"tf":1},"28":{"tf":1},"38":{"tf":1},"101":{"tf":1.7320508075688772},"124":{"tf":1},"132":{"tf":1},"141":{"tf":1},"143":{"tf":1},"144":{"tf":1},"147":{"tf":1.4142135623730951},"163":{"tf":1},"164":{"tf":1},"168":{"tf":1.4142135623730951},"169":{"tf":1},"178":{"tf":1},"200":{"tf":1},"204":{"tf":1},"216":{"tf":1},"218":{"tf":1},"220":{"tf":1},"221":{"tf":1},"223":{"tf":1},"231":{"tf":1},"233":{"tf":1},"236":{"tf":1.4142135623730951},"237":{"tf":1.4142135623730951},"241":{"tf":1.4142135623730951},"242":{"tf":1.4142135623730951},"243":{"tf":1.4142135623730951},"244":{"tf":1},"248":{"tf":1},"264":{"tf":1},"272":{"tf":1},"274":{"tf":1},"277":{"tf":1},"280":{"tf":1.4142135623730951},"286":{"tf":1},"287":{"tf":1}},"df":39,"n":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"4":{"tf":1},"93":{"tf":1},"154":{"tf":1},"204":{"tf":1}},"df":5,"l":{"docs":{"245":{"tf":1},"246":{"tf":1},"250":{"tf":1.7320508075688772},"251":{"tf":1},"252":{"tf":1}},"df":5,"e":{"docs":{},"df":0,"r":{"docs":{"233":{"tf":1.4142135623730951},"247":{"tf":2.23606797749979},"248":{"tf":1.4142135623730951},"249":{"tf":1},"250":{"tf":1},"251":{"tf":1},"254":{"tf":1}},"df":7}}}}},"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"31":{"tf":1},"34":{"tf":1},"167":{"tf":1},"236":{"tf":1},"243":{"tf":1},"252":{"tf":1}},"df":6}}}},"v":{"docs":{},"df":0,"e":{"docs":{"209":{"tf":1}},"df":1,"n":{"docs":{},"df":0,"'":{"docs":{},"df":0,"t":{"docs":{"46":{"tf":1},"209":{"tf":1},"234":{"tf":1},"246":{"tf":1}},"df":4}}}}},"r":{"docs":{},"df":0,"d":{"docs":{"47":{"tf":1},"154":{"tf":1},"155":{"tf":1}},"df":3}},"s":{"docs":{},"df":0,"h":{"docs":{"111":{"tf":1}},"df":1}}},"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"4":{"tf":1},"55":{"tf":1.4142135623730951},"56":{"tf":1},"181":{"tf":1},"225":{"tf":1},"226":{"tf":1}},"df":7}},"t":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{},"df":0,":":{"docs":{},"df":0,"/":{"docs":{},"df":0,"/":{"docs":{},"df":0,"w":{"docs":{},"df":0,"w":{"docs":{},"df":0,"w":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"/":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"/":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"/":{"docs":{},"df":0,"p":{"docs":{},"df":0,"u":{"docs":{},"df":0,"b":{"docs":{},"df":0,"/":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"k":{"docs":{"64":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"221":{"tf":1}},"df":1,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"3":{"tf":1}},"df":1}}}}},"r":{"docs":{},"df":0,"t":{"docs":{"80":{"tf":1}},"df":1}}},"l":{"docs":{},"df":0,"p":{"docs":{"4":{"tf":1},"43":{"tf":2.8284271247461903},"51":{"tf":1},"62":{"tf":1},"135":{"tf":1},"163":{"tf":1.4142135623730951},"168":{"tf":1},"169":{"tf":1},"181":{"tf":1},"184":{"tf":1},"185":{"tf":1},"204":{"tf":1},"209":{"tf":1},"233":{"tf":1}},"df":14,"e":{"docs":{},"df":0,"r":{"docs":{"39":{"tf":1},"114":{"tf":1}},"df":2}}}},"r":{"docs":{},"df":0,"e":{"docs":{"114":{"tf":1.4142135623730951},"141":{"tf":1},"155":{"tf":1},"157":{"tf":1},"164":{"tf":1},"168":{"tf":1.7320508075688772},"169":{"tf":1},"190":{"tf":1},"226":{"tf":1},"242":{"tf":1}},"df":10}}},"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{"5":{"tf":1}},"df":1}},"m":{"docs":{},"df":0,"e":{"docs":{"189":{"tf":1.4142135623730951}},"df":1,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"43":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"d":{"docs":{"204":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"r":{"docs":{"274":{"tf":1.4142135623730951},"275":{"tf":1},"277":{"tf":1}},"df":3}}}}},"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"38":{"tf":1},"93":{"tf":1},"120":{"tf":1}},"df":3}}}}},"e":{"docs":{},"df":0,"r":{"docs":{"178":{"tf":1}},"df":1}}}},"t":{"docs":{"66":{"tf":1},"117":{"tf":1},"204":{"tf":1}},"df":3},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{"111":{"tf":1},"125":{"tf":1},"264":{"tf":1}},"df":3}}}}}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"169":{"tf":1}},"df":1},"d":{"docs":{},"df":0,"r":{"docs":{"259":{"tf":1}},"df":1}}},"g":{"docs":{},"df":0,"e":{"docs":{"233":{"tf":1},"259":{"tf":1}},"df":2}}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"3":{"tf":1},"185":{"tf":1},"233":{"tf":1}},"df":3}},"e":{"docs":{},"df":0,"r":{"docs":{"38":{"tf":1},"181":{"tf":1},"259":{"tf":1}},"df":3},"s":{"docs":{},"df":0,"t":{"docs":{"141":{"tf":1},"170":{"tf":1}},"df":2}}}}},"c":{"docs":{},"df":0,"h":{"docs":{"4":{"tf":1},"28":{"tf":1},"51":{"tf":2},"126":{"tf":1},"164":{"tf":1},"204":{"tf":1},"212":{"tf":1.4142135623730951},"216":{"tf":1},"218":{"tf":1.4142135623730951},"219":{"tf":1},"221":{"tf":1},"225":{"tf":1},"231":{"tf":1},"232":{"tf":1},"233":{"tf":1.7320508075688772},"237":{"tf":1.4142135623730951},"241":{"tf":1},"247":{"tf":1},"250":{"tf":1.4142135623730951},"251":{"tf":1},"258":{"tf":1.4142135623730951},"259":{"tf":2},"272":{"tf":1},"274":{"tf":1},"277":{"tf":1.4142135623730951},"284":{"tf":1},"286":{"tf":1},"287":{"tf":1}},"df":28}},"t":{"docs":{"40":{"tf":1}},"df":1}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"11":{"tf":1},"77":{"tf":1},"104":{"tf":1},"259":{"tf":1.7320508075688772},"265":{"tf":1},"287":{"tf":1}},"df":7}}}},"g":{"docs":{"51":{"tf":1},"93":{"tf":1},"219":{"tf":1}},"df":3}},"s":{"docs":{"195":{"tf":1},"198":{"tf":1},"199":{"tf":1},"201":{"tf":1},"204":{"tf":2.23606797749979},"206":{"tf":1}},"df":6,"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"163":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"f":{"docs":{"195":{"tf":1},"201":{"tf":1.4142135623730951}},"df":2}}}}},"x":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"11":{"tf":1},"21":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"31":{"tf":1},"33":{"tf":1},"34":{"tf":1},"37":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1},"56":{"tf":1},"98":{"tf":1},"107":{"tf":1},"114":{"tf":2.23606797749979},"117":{"tf":1},"120":{"tf":1},"123":{"tf":1.7320508075688772},"124":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"126":{"tf":2.6457513110645907},"129":{"tf":1},"130":{"tf":1.7320508075688772},"131":{"tf":1},"135":{"tf":1},"143":{"tf":1.4142135623730951},"144":{"tf":1},"147":{"tf":1.7320508075688772},"150":{"tf":1},"154":{"tf":1},"158":{"tf":1},"162":{"tf":1},"163":{"tf":1},"167":{"tf":1.4142135623730951},"168":{"tf":2.449489742783178},"169":{"tf":1},"174":{"tf":1},"175":{"tf":1},"178":{"tf":2},"189":{"tf":1.4142135623730951},"192":{"tf":1},"195":{"tf":1.4142135623730951},"199":{"tf":1},"201":{"tf":2},"204":{"tf":2.23606797749979},"205":{"tf":1},"206":{"tf":1},"221":{"tf":1},"233":{"tf":2},"236":{"tf":1},"237":{"tf":2.8284271247461903},"238":{"tf":1.4142135623730951},"243":{"tf":1.4142135623730951},"247":{"tf":1},"248":{"tf":1},"250":{"tf":1},"253":{"tf":1},"255":{"tf":1}},"df":57}}},"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"174":{"tf":1},"204":{"tf":1}},"df":2}}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"56":{"tf":1}},"df":2,"l":{"docs":{},"df":0,"i":{"docs":{"74":{"tf":1},"101":{"tf":1},"135":{"tf":1},"144":{"tf":1},"169":{"tf":1},"233":{"tf":1},"239":{"tf":1},"262":{"tf":1}},"df":8}}}},"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"14":{"tf":1},"77":{"tf":1},"108":{"tf":1},"111":{"tf":1.7320508075688772},"117":{"tf":1},"126":{"tf":1.4142135623730951},"136":{"tf":1},"155":{"tf":1},"157":{"tf":1},"174":{"tf":1},"178":{"tf":1.4142135623730951},"209":{"tf":1},"215":{"tf":1},"220":{"tf":1.4142135623730951},"222":{"tf":1},"231":{"tf":1},"241":{"tf":1.4142135623730951},"243":{"tf":1},"250":{"tf":1},"258":{"tf":1},"269":{"tf":1},"271":{"tf":1.4142135623730951},"277":{"tf":1},"280":{"tf":1},"282":{"tf":1},"284":{"tf":1.4142135623730951}},"df":26}},"i":{"docs":{},"df":0,"n":{"docs":{"19":{"tf":1},"117":{"tf":1},"167":{"tf":1}},"df":3}}}},"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"8":{"tf":1.4142135623730951},"11":{"tf":1},"21":{"tf":1},"27":{"tf":1},"34":{"tf":1},"51":{"tf":1},"126":{"tf":1},"162":{"tf":1},"215":{"tf":1},"231":{"tf":1},"237":{"tf":1},"239":{"tf":1}},"df":12}},"n":{"docs":{"43":{"tf":1},"150":{"tf":1},"228":{"tf":1}},"df":3}},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"168":{"tf":1},"178":{"tf":1}},"df":2}}}}}},"o":{"docs":{},"df":0,"r":{"docs":{"181":{"tf":1},"184":{"tf":1}},"df":2}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"15":{"tf":1},"19":{"tf":1},"21":{"tf":1},"26":{"tf":1},"31":{"tf":1},"38":{"tf":1.4142135623730951},"46":{"tf":1},"272":{"tf":1}},"df":8}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"39":{"tf":1},"73":{"tf":1},"141":{"tf":1},"155":{"tf":1},"162":{"tf":1},"224":{"tf":1},"242":{"tf":1}},"df":7}},"r":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1}},"df":1},"i":{"docs":{"123":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"200":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{"62":{"tf":1},"65":{"tf":1},"70":{"tf":1},"71":{"tf":1},"72":{"tf":1},"80":{"tf":1},"81":{"tf":1},"107":{"tf":1},"204":{"tf":1},"209":{"tf":1}},"df":10,"s":{"docs":{},"df":0,"«":{"docs":{},"df":0,"»":{"docs":{},"df":0,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{"21":{"tf":1}},"df":1}}}}}}}}},"e":{"docs":{},"df":0,"m":{"docs":{"169":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"129":{"tf":1},"204":{"tf":1}},"df":2}}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1},"114":{"tf":1.4142135623730951},"135":{"tf":1.4142135623730951},"178":{"tf":1},"233":{"tf":1},"245":{"tf":1},"250":{"tf":2.449489742783178},"251":{"tf":1},"252":{"tf":2.23606797749979}},"df":9}},"l":{"docs":{"215":{"tf":1},"220":{"tf":1},"228":{"tf":1}},"df":3}}},"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"111":{"tf":1},"147":{"tf":1},"162":{"tf":1},"168":{"tf":1},"178":{"tf":1},"181":{"tf":1},"241":{"tf":1},"252":{"tf":1},"272":{"tf":1},"277":{"tf":1}},"df":10}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"219":{"tf":1}},"df":1}}}}}},"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"26":{"tf":1},"27":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"37":{"tf":1.4142135623730951},"38":{"tf":2},"39":{"tf":2.8284271247461903},"40":{"tf":1.7320508075688772},"50":{"tf":1},"56":{"tf":2},"71":{"tf":1},"72":{"tf":1},"74":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"129":{"tf":1},"135":{"tf":1.7320508075688772},"136":{"tf":1},"137":{"tf":2},"138":{"tf":1.4142135623730951},"141":{"tf":2.8284271247461903},"143":{"tf":1},"147":{"tf":1.7320508075688772},"150":{"tf":1},"158":{"tf":1},"162":{"tf":2.23606797749979},"164":{"tf":1},"169":{"tf":1.4142135623730951},"191":{"tf":2.449489742783178},"204":{"tf":1.4142135623730951},"205":{"tf":1},"206":{"tf":1},"224":{"tf":1.4142135623730951},"226":{"tf":1},"233":{"tf":2},"245":{"tf":1},"246":{"tf":1.4142135623730951},"247":{"tf":2.449489742783178},"248":{"tf":1.7320508075688772},"249":{"tf":1},"250":{"tf":1.7320508075688772},"251":{"tf":1},"254":{"tf":1}},"df":44},"n":{"docs":{"136":{"tf":1}},"df":1}}},"p":{"docs":{"233":{"tf":1},"241":{"tf":1},"259":{"tf":1}},"df":3}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1},"40":{"tf":1},"73":{"tf":1},"101":{"tf":1},"111":{"tf":1},"135":{"tf":1},"154":{"tf":1},"164":{"tf":1.4142135623730951},"168":{"tf":1},"178":{"tf":1},"228":{"tf":1},"254":{"tf":1},"255":{"tf":1},"289":{"tf":1}},"df":14,"t":{"docs":{"38":{"tf":1},"209":{"tf":1}},"df":2,"u":{"docs":{"38":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"y":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{"50":{"tf":1}},"df":1}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"11":{"tf":1},"43":{"tf":1},"200":{"tf":1},"201":{"tf":1.4142135623730951},"204":{"tf":1.4142135623730951}},"df":5}}}},"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"51":{"tf":1.4142135623730951},"71":{"tf":1},"72":{"tf":1},"80":{"tf":1},"164":{"tf":1},"218":{"tf":1},"219":{"tf":1},"231":{"tf":1},"233":{"tf":1},"234":{"tf":1},"237":{"tf":1},"240":{"tf":1},"244":{"tf":1},"277":{"tf":1.4142135623730951}},"df":15}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"8":{"tf":1.4142135623730951},"129":{"tf":1},"141":{"tf":1},"247":{"tf":1}},"df":4}}}}},"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{"15":{"tf":1},"185":{"tf":1}},"df":2}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"21":{"tf":1},"43":{"tf":1},"162":{"tf":1},"204":{"tf":3},"272":{"tf":1}},"df":5}},"e":{"docs":{},"df":0,"r":{"docs":{"64":{"tf":1},"66":{"tf":1.4142135623730951},"93":{"tf":1},"118":{"tf":1},"155":{"tf":1.4142135623730951},"157":{"tf":1.4142135623730951},"162":{"tf":1},"168":{"tf":1},"175":{"tf":1},"204":{"tf":2.449489742783178},"206":{"tf":1}},"df":11}},"i":{"docs":{},"df":0,"r":{"docs":{"111":{"tf":1},"126":{"tf":1},"178":{"tf":1}},"df":3}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"40":{"tf":1}},"df":1}},"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{"147":{"tf":1}},"df":1}}}},"d":{"docs":{"50":{"tf":1},"54":{"tf":1},"71":{"tf":1},"72":{"tf":1},"89":{"tf":1},"129":{"tf":1},"209":{"tf":1},"236":{"tf":1}},"df":8},"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"111":{"tf":1},"135":{"tf":1.7320508075688772},"191":{"tf":1},"244":{"tf":1},"252":{"tf":1}},"df":5}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{"162":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"c":{"docs":{"5":{"tf":1},"80":{"tf":1}},"df":2}},"m":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"19":{"tf":1},"20":{"tf":1},"21":{"tf":2.6457513110645907},"63":{"tf":1.7320508075688772},"66":{"tf":1},"69":{"tf":1.4142135623730951}},"df":6,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"/":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"47":{"tf":1},"82":{"tf":1},"83":{"tf":1}},"df":3}}}}},"r":{"docs":{"63":{"tf":1}},"df":1}}}}}}}},"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"62":{"tf":1},"93":{"tf":1},"251":{"tf":1},"273":{"tf":1}},"df":4}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"y":{"docs":{"86":{"tf":1}},"df":1}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{"20":{"tf":1},"51":{"tf":1},"126":{"tf":1},"244":{"tf":1}},"df":4}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"86":{"tf":1}},"df":1}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{"168":{"tf":1},"219":{"tf":1},"254":{"tf":1}},"df":3}}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"26":{"tf":1}},"df":1}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"40":{"tf":1},"94":{"tf":1},"111":{"tf":1},"225":{"tf":1},"262":{"tf":1},"275":{"tf":1}},"df":6}}},".":{"docs":{},"df":0,"g":{"docs":{"55":{"tf":1},"66":{"tf":1},"71":{"tf":1},"77":{"tf":1},"94":{"tf":1},"107":{"tf":1},"129":{"tf":1},"175":{"tf":1},"204":{"tf":1.4142135623730951},"205":{"tf":1},"220":{"tf":1},"233":{"tf":1.4142135623730951},"235":{"tf":1},"236":{"tf":1},"237":{"tf":1},"250":{"tf":1},"253":{"tf":1},"255":{"tf":1},"265":{"tf":1},"267":{"tf":1},"272":{"tf":1}},"df":21}},"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{"86":{"tf":1},"204":{"tf":1},"219":{"tf":1}},"df":3}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"124":{"tf":1},"216":{"tf":1}},"df":2}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"216":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{"114":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"/":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"p":{"docs":{"233":{"tf":1}},"df":1}}}}}}}}}}},"b":{"docs":{"114":{"tf":1},"117":{"tf":1},"119":{"tf":1}},"df":3,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"55":{"tf":1},"59":{"tf":1},"132":{"tf":1},"241":{"tf":1.4142135623730951},"271":{"tf":1}},"df":6},"t":{"docs":{"220":{"tf":1}},"df":1}}},"g":{"docs":{"5":{"tf":1},"216":{"tf":1}},"df":2},"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"14":{"tf":1},"21":{"tf":1},"27":{"tf":1},"32":{"tf":1},"33":{"tf":1},"37":{"tf":1.4142135623730951},"38":{"tf":1},"43":{"tf":1},"50":{"tf":1},"55":{"tf":1},"70":{"tf":1},"72":{"tf":1.4142135623730951},"77":{"tf":1},"81":{"tf":1},"96":{"tf":1},"114":{"tf":1.4142135623730951},"117":{"tf":1},"120":{"tf":1},"124":{"tf":1},"126":{"tf":1},"130":{"tf":1},"131":{"tf":1},"138":{"tf":1},"141":{"tf":1},"143":{"tf":1},"147":{"tf":1.7320508075688772},"155":{"tf":1},"162":{"tf":1},"169":{"tf":1},"189":{"tf":1.7320508075688772},"204":{"tf":2.6457513110645907},"221":{"tf":1.7320508075688772},"252":{"tf":1},"262":{"tf":1.7320508075688772},"275":{"tf":1.4142135623730951},"280":{"tf":1}},"df":36}}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1.4142135623730951},"55":{"tf":1},"178":{"tf":1}},"df":3,"\"":{"docs":{},"df":0,"=":{"docs":{},"df":0,"\"":{"docs":{},"df":0,"i":{"docs":{"175":{"tf":1}},"df":1}}}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"14":{"tf":1.4142135623730951},"43":{"tf":1},"259":{"tf":1.4142135623730951}},"df":3}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"k":{"docs":{"43":{"tf":1},"135":{"tf":1},"162":{"tf":1},"192":{"tf":1},"204":{"tf":2.8284271247461903}},"df":5,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"114":{"tf":1},"117":{"tf":2.23606797749979},"118":{"tf":1},"119":{"tf":1},"120":{"tf":2.8284271247461903},"126":{"tf":1},"147":{"tf":1},"167":{"tf":1.4142135623730951}},"df":8}}}}}}}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1.7320508075688772},"80":{"tf":1},"142":{"tf":1}},"df":3},"i":{"docs":{"86":{"tf":1}},"df":1,"c":{"docs":{"4":{"tf":1},"8":{"tf":1},"93":{"tf":1},"209":{"tf":1},"212":{"tf":1},"258":{"tf":1},"259":{"tf":1},"262":{"tf":1.4142135623730951},"289":{"tf":1}},"df":9}}},"r":{"docs":{"27":{"tf":1},"28":{"tf":1},"114":{"tf":1}},"df":3},"c":{"docs":{},"df":0,"k":{"docs":{"72":{"tf":1},"189":{"tf":1.4142135623730951}},"df":2,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"169":{"tf":1}},"df":1}}}}}},"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"175":{"tf":1},"178":{"tf":2},"204":{"tf":2}},"df":3}}}},"e":{"docs":{"26":{"tf":1},"126":{"tf":1},"168":{"tf":1},"175":{"tf":1}},"df":4,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"51":{"tf":1},"74":{"tf":1},"80":{"tf":1.4142135623730951},"98":{"tf":1},"101":{"tf":1},"117":{"tf":1},"126":{"tf":1},"132":{"tf":1},"163":{"tf":1},"185":{"tf":1},"218":{"tf":1},"223":{"tf":1},"231":{"tf":1},"232":{"tf":1},"233":{"tf":1.4142135623730951},"236":{"tf":1},"237":{"tf":1.4142135623730951},"239":{"tf":1},"247":{"tf":1},"262":{"tf":1},"282":{"tf":1}},"df":22}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"19":{"tf":1},"56":{"tf":1},"189":{"tf":1},"217":{"tf":1},"278":{"tf":1},"280":{"tf":1}},"df":6},"n":{"docs":{},"df":0,"g":{"docs":{"185":{"tf":1},"204":{"tf":1}},"df":2}}}},"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"27":{"tf":1},"233":{"tf":1}},"df":2}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"63":{"tf":1},"81":{"tf":1},"126":{"tf":1},"216":{"tf":1},"218":{"tf":1},"238":{"tf":1}},"df":6}}}}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"43":{"tf":1},"141":{"tf":1},"250":{"tf":1}},"df":3}},"t":{"docs":{"173":{"tf":1},"178":{"tf":1}},"df":2}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"51":{"tf":1},"126":{"tf":1},"227":{"tf":1},"238":{"tf":1},"247":{"tf":1},"250":{"tf":1}},"df":6}}}}}},"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"56":{"tf":1},"62":{"tf":1},"81":{"tf":1},"93":{"tf":1},"101":{"tf":1},"243":{"tf":1},"271":{"tf":1},"275":{"tf":1}},"df":8}}},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{"80":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"86":{"tf":1},"124":{"tf":1},"204":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951},"251":{"tf":1},"254":{"tf":1},"259":{"tf":1}},"df":7}},"a":{"docs":{},"df":0,"m":{"docs":{"204":{"tf":1}},"df":1}}},"y":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"129":{"tf":1},"181":{"tf":1}},"df":2}}}}},"i":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"123":{"tf":1},"250":{"tf":1}},"df":3},"n":{"docs":{},"df":0,"d":{"docs":{"114":{"tf":1.4142135623730951},"141":{"tf":1},"161":{"tf":1},"162":{"tf":1.4142135623730951},"163":{"tf":1.7320508075688772},"164":{"tf":1},"167":{"tf":2.23606797749979},"168":{"tf":2.23606797749979},"169":{"tf":1.4142135623730951},"173":{"tf":1},"175":{"tf":1},"192":{"tf":1.7320508075688772},"221":{"tf":1.4142135623730951}},"df":13,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"192":{"tf":1}},"df":1}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"192":{"tf":1}},"df":1}}}}},"g":{"docs":{"204":{"tf":1},"241":{"tf":1},"259":{"tf":1}},"df":3}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"14":{"tf":1.4142135623730951},"253":{"tf":1}},"df":2}},"g":{"docs":{"43":{"tf":1}},"df":1}},"u":{"docs":{},"df":0,"e":{"docs":{"93":{"tf":1},"120":{"tf":1}},"df":2}}},"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"15":{"tf":1},"27":{"tf":1},"37":{"tf":1},"74":{"tf":1},"162":{"tf":1},"163":{"tf":1},"175":{"tf":1}},"df":7}}},"h":{"docs":{"21":{"tf":1},"89":{"tf":1},"96":{"tf":1},"237":{"tf":1},"243":{"tf":1}},"df":5}},"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"38":{"tf":1},"141":{"tf":1},"143":{"tf":1}},"df":3}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"141":{"tf":1},"162":{"tf":1},"163":{"tf":1.4142135623730951},"169":{"tf":1},"175":{"tf":1.7320508075688772},"178":{"tf":1}},"df":6}}},"x":{"docs":{"173":{"tf":1.4142135623730951}},"df":1}}},"x":{"docs":{"162":{"tf":1}},"df":1,"m":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"55":{"tf":1.4142135623730951},"220":{"tf":1}},"df":3}},"s":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"55":{"tf":1}},"df":1}}}},"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"y":{"docs":{"38":{"tf":1},"66":{"tf":1},"94":{"tf":1.4142135623730951},"114":{"tf":1.4142135623730951},"118":{"tf":1},"137":{"tf":1},"147":{"tf":1.4142135623730951},"162":{"tf":1}},"df":8,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"k":{"docs":{"4":{"tf":1}},"df":1}}}}},"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"80":{"tf":1},"86":{"tf":1},"95":{"tf":1},"101":{"tf":1},"114":{"tf":2.23606797749979},"154":{"tf":1},"168":{"tf":1},"189":{"tf":1}},"df":8}}}}}},"e":{"docs":{},"df":0,"p":{"docs":{"21":{"tf":1},"38":{"tf":1},"40":{"tf":1},"71":{"tf":1},"72":{"tf":1},"94":{"tf":1},"147":{"tf":1},"167":{"tf":1},"185":{"tf":1},"219":{"tf":1.4142135623730951},"228":{"tf":1},"280":{"tf":1}},"df":12}}},"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"89":{"tf":1},"93":{"tf":1},"212":{"tf":1},"233":{"tf":1},"239":{"tf":1},"247":{"tf":1}},"df":6,"n":{"docs":{"50":{"tf":1},"56":{"tf":1},"154":{"tf":1}},"df":3}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"55":{"tf":1},"195":{"tf":1},"204":{"tf":1}},"df":3}},"l":{"docs":{},"df":0,"l":{"docs":{"204":{"tf":1}},"df":1}}}},"y":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"'":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"5":{"tf":1},"15":{"tf":1},"38":{"tf":1},"200":{"tf":1}},"df":4}},"v":{"docs":{"37":{"tf":1},"54":{"tf":1}},"df":2}},"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"f":{"docs":{"232":{"tf":1}},"df":1}}}}}}},"e":{"docs":{"80":{"tf":1},"265":{"tf":1}},"df":2}},"_":{"docs":{"272":{"tf":1}},"df":1}}},"h-1":{"root":{"docs":{},"df":0}},"h0":{"root":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"0":{"tf":1},"1":{"tf":1},"2":{"tf":1}},"df":3}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"229":{"tf":1},"230":{"tf":1},"231":{"tf":1}},"df":3}}}}}}}}},"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"84":{"tf":1},"85":{"tf":1},"91":{"tf":1},"92":{"tf":1},"93":{"tf":1},"99":{"tf":1},"100":{"tf":1},"101":{"tf":1},"148":{"tf":1},"149":{"tf":1},"151":{"tf":1},"152":{"tf":1},"153":{"tf":1},"186":{"tf":1},"187":{"tf":1},"188":{"tf":1},"256":{"tf":1},"257":{"tf":1},"258":{"tf":1}},"df":19}}}}},"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"139":{"tf":1},"140":{"tf":1},"141":{"tf":1}},"df":3}}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"87":{"tf":1},"88":{"tf":1},"89":{"tf":1}},"df":3},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"148":{"tf":1},"149":{"tf":1}},"df":2}}}}},"u":{"docs":{},"df":0,"s":{"docs":{"145":{"tf":1},"146":{"tf":1},"147":{"tf":1}},"df":3}},"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"186":{"tf":1},"187":{"tf":1},"188":{"tf":1}},"df":3}}}}}},"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"‑":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"0":{"tf":1},"1":{"tf":1},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"9":{"tf":1},"10":{"tf":1},"12":{"tf":1},"13":{"tf":1},"17":{"tf":1},"18":{"tf":1},"23":{"tf":1},"24":{"tf":1},"29":{"tf":1},"30":{"tf":1},"35":{"tf":1},"36":{"tf":1},"41":{"tf":1},"42":{"tf":1},"44":{"tf":1},"45":{"tf":1},"48":{"tf":1},"49":{"tf":1},"52":{"tf":1},"53":{"tf":1},"57":{"tf":1},"58":{"tf":1},"60":{"tf":1},"61":{"tf":1},"67":{"tf":1},"68":{"tf":1},"75":{"tf":1},"76":{"tf":1},"78":{"tf":1},"79":{"tf":1},"84":{"tf":1},"85":{"tf":1},"87":{"tf":1},"88":{"tf":1},"91":{"tf":1},"92":{"tf":1},"99":{"tf":1},"100":{"tf":1},"102":{"tf":1},"103":{"tf":1},"105":{"tf":1},"106":{"tf":1},"109":{"tf":1},"110":{"tf":1},"112":{"tf":1},"113":{"tf":1},"115":{"tf":1},"116":{"tf":1},"121":{"tf":1},"122":{"tf":1},"127":{"tf":1},"128":{"tf":1},"133":{"tf":1},"134":{"tf":1},"139":{"tf":1},"140":{"tf":1},"145":{"tf":1},"146":{"tf":1},"148":{"tf":1},"149":{"tf":1},"151":{"tf":1},"152":{"tf":1},"159":{"tf":1},"160":{"tf":1},"165":{"tf":1},"166":{"tf":1},"171":{"tf":1},"172":{"tf":1},"176":{"tf":1},"177":{"tf":1},"179":{"tf":1},"180":{"tf":1},"182":{"tf":1},"183":{"tf":1},"186":{"tf":1},"187":{"tf":1},"193":{"tf":1},"194":{"tf":1},"196":{"tf":1},"197":{"tf":1},"202":{"tf":1},"203":{"tf":1},"207":{"tf":1},"208":{"tf":1},"210":{"tf":1.4142135623730951},"211":{"tf":1.4142135623730951},"213":{"tf":1},"214":{"tf":1},"229":{"tf":1},"230":{"tf":1},"256":{"tf":1},"257":{"tf":1}},"df":96}}}}}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"0":{"tf":1},"1":{"tf":1},"6":{"tf":1},"7":{"tf":1},"9":{"tf":1},"10":{"tf":1},"12":{"tf":1},"13":{"tf":1},"17":{"tf":1},"18":{"tf":1},"23":{"tf":1},"24":{"tf":1},"29":{"tf":1},"30":{"tf":1},"35":{"tf":1},"36":{"tf":1},"41":{"tf":1},"42":{"tf":1},"44":{"tf":1},"45":{"tf":1},"48":{"tf":1},"49":{"tf":1},"52":{"tf":1},"53":{"tf":1},"57":{"tf":1},"58":{"tf":1},"60":{"tf":1},"61":{"tf":1},"67":{"tf":1},"68":{"tf":1},"75":{"tf":1},"76":{"tf":1},"78":{"tf":1},"79":{"tf":1},"84":{"tf":1},"85":{"tf":1},"87":{"tf":1},"88":{"tf":1},"91":{"tf":1},"92":{"tf":1},"99":{"tf":1},"100":{"tf":1},"102":{"tf":1},"103":{"tf":1},"105":{"tf":1},"106":{"tf":1},"109":{"tf":1},"110":{"tf":1},"112":{"tf":1},"113":{"tf":1},"115":{"tf":1},"116":{"tf":1},"121":{"tf":1},"122":{"tf":1},"127":{"tf":1},"128":{"tf":1},"133":{"tf":1},"134":{"tf":1},"139":{"tf":1},"140":{"tf":1},"145":{"tf":1},"146":{"tf":1},"148":{"tf":1},"149":{"tf":1},"151":{"tf":1},"152":{"tf":1},"159":{"tf":1},"160":{"tf":1},"165":{"tf":1},"166":{"tf":1},"171":{"tf":1},"172":{"tf":1},"176":{"tf":1},"177":{"tf":1},"179":{"tf":1},"180":{"tf":1},"182":{"tf":1},"183":{"tf":1},"186":{"tf":1},"187":{"tf":1},"193":{"tf":1},"194":{"tf":1},"196":{"tf":1},"197":{"tf":1},"202":{"tf":1},"203":{"tf":1},"207":{"tf":1},"208":{"tf":1},"210":{"tf":1},"211":{"tf":1},"213":{"tf":1},"214":{"tf":1},"229":{"tf":1},"230":{"tf":1},"256":{"tf":1},"257":{"tf":1}},"df":96}}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"6":{"tf":1},"7":{"tf":1},"9":{"tf":1},"10":{"tf":1},"12":{"tf":1},"13":{"tf":1},"14":{"tf":1},"23":{"tf":1},"24":{"tf":1},"25":{"tf":1},"29":{"tf":1},"30":{"tf":1},"31":{"tf":1},"48":{"tf":1},"49":{"tf":1},"50":{"tf":1},"57":{"tf":1},"58":{"tf":1},"78":{"tf":1},"79":{"tf":1},"80":{"tf":1},"145":{"tf":1},"146":{"tf":1},"147":{"tf":1},"213":{"tf":1.7320508075688772},"214":{"tf":1.7320508075688772},"215":{"tf":1.7320508075688772},"229":{"tf":1},"230":{"tf":1},"231":{"tf":1}},"df":30}}},"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"105":{"tf":1},"106":{"tf":1},"107":{"tf":1},"159":{"tf":1},"160":{"tf":1},"161":{"tf":1},"165":{"tf":1},"166":{"tf":1},"167":{"tf":1}},"df":9}}},"h":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{"121":{"tf":1},"122":{"tf":1},"123":{"tf":1}},"df":3}}}}}},"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"207":{"tf":1},"208":{"tf":1},"209":{"tf":1}},"df":3}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"6":{"tf":1},"7":{"tf":1},"9":{"tf":1},"10":{"tf":1},"57":{"tf":1},"58":{"tf":1},"84":{"tf":1},"85":{"tf":1},"102":{"tf":1},"103":{"tf":1},"112":{"tf":1},"113":{"tf":1},"148":{"tf":1},"149":{"tf":1},"179":{"tf":1},"180":{"tf":1},"193":{"tf":1},"194":{"tf":1},"207":{"tf":1},"208":{"tf":1},"209":{"tf":1}},"df":21}}},"d":{"docs":{},"df":0,"e":{"docs":{"133":{"tf":1},"134":{"tf":1},"135":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"91":{"tf":1},"92":{"tf":1},"93":{"tf":1}},"df":3}}}}}},"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{"6":{"tf":1},"7":{"tf":1}},"df":2,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"44":{"tf":1},"45":{"tf":1},"46":{"tf":1},"60":{"tf":1},"61":{"tf":1},"62":{"tf":1},"207":{"tf":1},"208":{"tf":1},"209":{"tf":1}},"df":9}}}}},"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"67":{"tf":1},"68":{"tf":1},"69":{"tf":1}},"df":3}},"v":{"docs":{"133":{"tf":1},"134":{"tf":1},"135":{"tf":1}},"df":3}}}},"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"105":{"tf":1},"106":{"tf":1},"107":{"tf":1},"109":{"tf":1},"110":{"tf":1},"111":{"tf":1}},"df":6}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{"165":{"tf":1},"166":{"tf":1},"167":{"tf":1},"210":{"tf":1},"211":{"tf":1}},"df":5}}}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"256":{"tf":1},"257":{"tf":1},"258":{"tf":1}},"df":3,"a":{"docs":{},"df":0,"t":{"docs":{"229":{"tf":1},"230":{"tf":1},"231":{"tf":1}},"df":3}}}}}}},"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{"9":{"tf":1},"10":{"tf":1}},"df":2}}}},"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"9":{"tf":1},"10":{"tf":1}},"df":2}}}},"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"9":{"tf":1},"10":{"tf":1},"12":{"tf":1},"13":{"tf":1},"14":{"tf":1},"57":{"tf":1},"58":{"tf":1},"78":{"tf":1},"79":{"tf":1},"80":{"tf":1}},"df":10}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"105":{"tf":1},"106":{"tf":1},"107":{"tf":1}},"df":3}}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"17":{"tf":1},"18":{"tf":1},"19":{"tf":1},"60":{"tf":1},"61":{"tf":1},"62":{"tf":1},"207":{"tf":1},"208":{"tf":1},"209":{"tf":1}},"df":9}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"179":{"tf":1},"180":{"tf":1},"182":{"tf":1},"183":{"tf":1},"184":{"tf":1}},"df":5}}}}}},"o":{"docs":{},"df":0,"p":{"docs":{"44":{"tf":1},"45":{"tf":1},"46":{"tf":1}},"df":3}},"e":{"docs":{},"df":0,"p":{"docs":{"121":{"tf":1},"122":{"tf":1},"123":{"tf":1}},"df":3}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"193":{"tf":1},"194":{"tf":1}},"df":2}}}}}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"29":{"tf":1},"30":{"tf":1},"31":{"tf":1}},"df":3}}}},"t":{"docs":{"78":{"tf":1},"79":{"tf":1},"80":{"tf":1},"115":{"tf":1},"116":{"tf":1},"117":{"tf":1},"171":{"tf":1},"172":{"tf":1},"173":{"tf":1}},"df":9},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"186":{"tf":1},"187":{"tf":1},"188":{"tf":1}},"df":3}}}}},"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"109":{"tf":1},"110":{"tf":1},"111":{"tf":1}},"df":3}}}}}},"k":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{"127":{"tf":1},"128":{"tf":1},"129":{"tf":1}},"df":3}}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"12":{"tf":1},"13":{"tf":1},"14":{"tf":1}},"df":3}},"g":{"docs":{"35":{"tf":1},"36":{"tf":1},"37":{"tf":1},"139":{"tf":1},"140":{"tf":1},"141":{"tf":1}},"df":6},"o":{"docs":{},"df":0,"p":{"docs":{"202":{"tf":1},"203":{"tf":1},"204":{"tf":1}},"df":3}}},"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"105":{"tf":1},"106":{"tf":1},"107":{"tf":1}},"df":3}},"b":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"179":{"tf":1},"180":{"tf":1},"182":{"tf":1},"183":{"tf":1},"184":{"tf":1}},"df":5}}}}}},"e":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"176":{"tf":1},"177":{"tf":1},"178":{"tf":1}},"df":3}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"17":{"tf":1},"18":{"tf":1},"19":{"tf":1}},"df":3}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"99":{"tf":1},"100":{"tf":1},"101":{"tf":1}},"df":3}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"193":{"tf":1},"194":{"tf":1}},"df":2}}}}},"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"102":{"tf":1},"103":{"tf":1},"109":{"tf":1},"110":{"tf":1},"111":{"tf":1}},"df":5}}}},"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"229":{"tf":1},"230":{"tf":1},"231":{"tf":1}},"df":3}}}}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"23":{"tf":1},"24":{"tf":1},"25":{"tf":1},"29":{"tf":1},"30":{"tf":1},"31":{"tf":1},"213":{"tf":1},"214":{"tf":1},"215":{"tf":1},"229":{"tf":1},"230":{"tf":1},"231":{"tf":1}},"df":12}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"57":{"tf":1},"58":{"tf":1},"84":{"tf":1},"85":{"tf":1}},"df":4,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"91":{"tf":1},"92":{"tf":1},"93":{"tf":1},"256":{"tf":1},"257":{"tf":1},"258":{"tf":1}},"df":6}}}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"75":{"tf":1},"76":{"tf":1},"77":{"tf":1}},"df":3}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"17":{"tf":1},"18":{"tf":1},"19":{"tf":1}},"df":3}}},"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{"165":{"tf":1},"166":{"tf":1},"167":{"tf":1}},"df":3,"g":{"docs":{"112":{"tf":1},"113":{"tf":1},"133":{"tf":1},"134":{"tf":1},"135":{"tf":1}},"df":5}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"176":{"tf":1},"177":{"tf":1},"178":{"tf":1}},"df":3}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"229":{"tf":1},"230":{"tf":1},"231":{"tf":1}},"df":3}}}}},"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{"35":{"tf":1},"36":{"tf":1},"37":{"tf":1}},"df":3}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"109":{"tf":1},"110":{"tf":1},"111":{"tf":1}},"df":3}}}},"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"213":{"tf":1},"214":{"tf":1},"215":{"tf":1}},"df":3}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{"213":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"215":{"tf":1.4142135623730951}},"df":3}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"213":{"tf":1},"214":{"tf":1},"215":{"tf":1}},"df":3}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"23":{"tf":1},"24":{"tf":1},"25":{"tf":1}},"df":3}}}},"o":{"docs":{},"df":0,"r":{"docs":{"35":{"tf":1},"36":{"tf":1},"37":{"tf":1},"176":{"tf":1},"177":{"tf":1},"178":{"tf":1},"229":{"tf":1},"230":{"tf":1},"231":{"tf":1}},"df":9}},"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"48":{"tf":1},"49":{"tf":1},"50":{"tf":1}},"df":3}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"139":{"tf":1},"140":{"tf":1},"141":{"tf":1}},"df":3}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"210":{"tf":1},"211":{"tf":1}},"df":2}}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"29":{"tf":1},"30":{"tf":1},"31":{"tf":1},"35":{"tf":1},"36":{"tf":1},"37":{"tf":1},"133":{"tf":1},"134":{"tf":1},"135":{"tf":1}},"df":9}}}},"x":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"121":{"tf":1},"122":{"tf":1},"123":{"tf":1},"145":{"tf":1},"146":{"tf":1},"147":{"tf":1}},"df":6}}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"133":{"tf":1},"134":{"tf":1},"135":{"tf":1}},"df":3}}}},"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"182":{"tf":1},"183":{"tf":1},"184":{"tf":1}},"df":3}}}}},"l":{"docs":{},"df":0,"s":{"docs":{"196":{"tf":1},"197":{"tf":1},"198":{"tf":1}},"df":3}},"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"229":{"tf":1},"230":{"tf":1},"231":{"tf":1}},"df":3}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"229":{"tf":1},"230":{"tf":1},"231":{"tf":1}},"df":3}}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{"35":{"tf":1},"36":{"tf":1},"37":{"tf":1},"48":{"tf":1},"49":{"tf":1},"50":{"tf":1},"139":{"tf":1},"140":{"tf":1},"141":{"tf":1},"213":{"tf":1},"214":{"tf":1},"215":{"tf":1}},"df":12}},"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"52":{"tf":1},"53":{"tf":1},"54":{"tf":1}},"df":3}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"67":{"tf":1},"68":{"tf":1},"69":{"tf":1},"75":{"tf":1},"76":{"tf":1},"77":{"tf":1}},"df":6}}}},"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"87":{"tf":1},"88":{"tf":1},"89":{"tf":1}},"df":3}}}}},"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"v":{"docs":{"139":{"tf":1},"140":{"tf":1},"141":{"tf":1}},"df":3}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"41":{"tf":1},"42":{"tf":1},"43":{"tf":1}},"df":3},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"52":{"tf":1},"53":{"tf":1},"54":{"tf":1}},"df":3}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"p":{"docs":{"41":{"tf":1},"42":{"tf":1},"43":{"tf":1}},"df":3}}}},"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{"57":{"tf":1},"58":{"tf":1},"207":{"tf":1},"208":{"tf":1},"209":{"tf":1}},"df":5}},"r":{"docs":{"133":{"tf":1},"134":{"tf":1},"135":{"tf":1}},"df":3},"n":{"docs":{"213":{"tf":1},"214":{"tf":1},"215":{"tf":1}},"df":3}},"u":{"docs":{},"df":0,"p":{"docs":{"78":{"tf":1},"79":{"tf":1},"80":{"tf":1}},"df":3},"s":{"docs":{"112":{"tf":1},"113":{"tf":1},"165":{"tf":1},"166":{"tf":1},"167":{"tf":1}},"df":5}},"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{"87":{"tf":1},"88":{"tf":1},"89":{"tf":1}},"df":3}}}}}}},"f":{"docs":{"196":{"tf":1},"197":{"tf":1},"198":{"tf":1}},"df":3}},"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{"99":{"tf":1},"100":{"tf":1},"101":{"tf":1},"127":{"tf":1},"128":{"tf":1},"129":{"tf":1}},"df":6}},"w":{"docs":{"207":{"tf":1},"208":{"tf":1},"209":{"tf":1}},"df":3}}},"b":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"k":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"115":{"tf":1},"116":{"tf":1},"117":{"tf":1}},"df":3}}}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"159":{"tf":1},"160":{"tf":1},"161":{"tf":1},"165":{"tf":1},"166":{"tf":1},"167":{"tf":1}},"df":6}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"256":{"tf":1},"257":{"tf":1},"258":{"tf":1}},"df":3}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"148":{"tf":1},"149":{"tf":1},"151":{"tf":1},"152":{"tf":1},"153":{"tf":1},"159":{"tf":1},"160":{"tf":1},"161":{"tf":1},"165":{"tf":1},"166":{"tf":1},"167":{"tf":1},"171":{"tf":1},"172":{"tf":1},"173":{"tf":1},"176":{"tf":1},"177":{"tf":1},"178":{"tf":1}},"df":17}}}}}}}}},"h1":{"root":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"‑":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"8":{"tf":1},"212":{"tf":1}},"df":3}}}}}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"8":{"tf":1},"11":{"tf":1},"59":{"tf":1},"217":{"tf":1}},"df":4}}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"217":{"tf":1}},"df":1}}}}}},"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"5":{"tf":1}},"df":1}}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"212":{"tf":1}},"df":1}}}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"8":{"tf":1},"11":{"tf":1},"59":{"tf":1},"86":{"tf":1},"104":{"tf":1},"114":{"tf":1},"150":{"tf":1},"181":{"tf":1},"195":{"tf":1}},"df":9}}},"r":{"docs":{},"df":0,"e":{"docs":{"255":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{"8":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"189":{"tf":1}},"df":1}}}}}},"d":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{"212":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"261":{"tf":1},"268":{"tf":1}},"df":2}}}}},"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{"11":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"y":{"docs":{"217":{"tf":1}},"df":1}}},"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"11":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"11":{"tf":1},"59":{"tf":1}},"df":2}},"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"228":{"tf":1}},"df":1}}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"181":{"tf":1}},"df":1}}}}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"195":{"tf":1}},"df":1}}}}}}},"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"216":{"tf":1}},"df":1}}}}}},"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"59":{"tf":1},"86":{"tf":1}},"df":2,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"261":{"tf":1},"268":{"tf":1}},"df":2}}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"104":{"tf":1}},"df":1}}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"241":{"tf":1}},"df":1}}}},"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"195":{"tf":1}},"df":1}}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"220":{"tf":1}},"df":1}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"268":{"tf":1}},"df":1}}}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"191":{"tf":1}},"df":1}}}}},"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{"59":{"tf":1}},"df":1}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"86":{"tf":1},"150":{"tf":1},"261":{"tf":1}},"df":3}}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"234":{"tf":1}},"df":1}}}}}}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"150":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"189":{"tf":1},"190":{"tf":1},"191":{"tf":1},"192":{"tf":1}},"df":4}}}}}},"u":{"docs":{},"df":0,"s":{"docs":{"114":{"tf":1}},"df":1},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"190":{"tf":1}},"df":1}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"g":{"docs":{"114":{"tf":1}},"df":1}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"241":{"tf":1},"255":{"tf":1}},"df":2}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{"217":{"tf":1},"220":{"tf":1}},"df":2,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"192":{"tf":1}},"df":1}}}}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"217":{"tf":1}},"df":1},"r":{"docs":{"220":{"tf":1}},"df":1}}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"150":{"tf":1}},"df":1}}}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"181":{"tf":1}},"df":1}}}}}}},"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"217":{"tf":1}},"df":1}}}}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"232":{"tf":1},"259":{"tf":1}},"df":2}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"234":{"tf":1}},"df":1}}}},"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"245":{"tf":1}},"df":1}}}},"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"245":{"tf":1}},"df":1}}}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"l":{"docs":{"245":{"tf":1}},"df":1}}}}}}},"h2":{"root":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"246":{"tf":1}},"df":1}}}},"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"250":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"271":{"tf":1}},"df":1}}}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"l":{"docs":{"246":{"tf":1},"250":{"tf":1}},"df":2}}}}},"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"254":{"tf":1}},"df":1}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"269":{"tf":1}},"df":1}}}}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"271":{"tf":1}},"df":1}}}},"o":{"docs":{},"df":0,"r":{"docs":{"277":{"tf":1}},"df":1}}},"u":{"docs":{},"df":0,"s":{"docs":{"277":{"tf":1},"284":{"tf":1}},"df":2}},"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"277":{"tf":1},"284":{"tf":1}},"df":2}}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"277":{"tf":1}},"df":1}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"284":{"tf":1}},"df":1}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"280":{"tf":1}},"df":1}}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"280":{"tf":1}},"df":1}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"289":{"tf":1}},"df":1}}}}}},"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"284":{"tf":1}},"df":1}}}}},"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"289":{"tf":1}},"df":1}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{"277":{"tf":1}},"df":1}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"280":{"tf":1}},"df":1}}}}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"284":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{"289":{"tf":1}},"df":1}}}}}},"h3":{"root":{"docs":{},"df":0}},"hash":{"root":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"1":{"tf":1},"7":{"tf":1},"10":{"tf":1},"13":{"tf":1},"18":{"tf":1},"24":{"tf":1},"30":{"tf":1},"36":{"tf":1},"42":{"tf":1},"45":{"tf":1},"49":{"tf":1},"53":{"tf":1},"58":{"tf":1},"61":{"tf":1},"68":{"tf":1},"76":{"tf":1},"79":{"tf":1},"85":{"tf":1},"88":{"tf":1},"92":{"tf":1},"100":{"tf":1},"103":{"tf":1},"106":{"tf":1},"110":{"tf":1},"113":{"tf":1},"116":{"tf":1},"122":{"tf":1},"128":{"tf":1},"134":{"tf":1},"140":{"tf":1},"146":{"tf":1},"149":{"tf":1},"152":{"tf":1},"160":{"tf":1},"166":{"tf":1},"172":{"tf":1},"177":{"tf":1},"180":{"tf":1},"183":{"tf":1},"187":{"tf":1},"194":{"tf":1},"197":{"tf":1},"203":{"tf":1},"208":{"tf":1},"211":{"tf":1},"214":{"tf":1},"230":{"tf":1},"257":{"tf":1}},"df":48}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{"1":{"tf":1},"7":{"tf":1},"10":{"tf":1},"13":{"tf":1},"18":{"tf":1},"24":{"tf":1},"30":{"tf":1},"36":{"tf":1},"42":{"tf":1},"45":{"tf":1},"49":{"tf":1},"53":{"tf":1},"58":{"tf":1},"61":{"tf":1},"68":{"tf":1},"76":{"tf":1},"79":{"tf":1},"85":{"tf":1},"88":{"tf":1},"92":{"tf":1},"100":{"tf":1},"103":{"tf":1},"106":{"tf":1},"110":{"tf":1},"113":{"tf":1},"116":{"tf":1},"122":{"tf":1},"128":{"tf":1},"134":{"tf":1},"140":{"tf":1},"146":{"tf":1},"149":{"tf":1},"152":{"tf":1},"160":{"tf":1},"166":{"tf":1},"172":{"tf":1},"177":{"tf":1},"180":{"tf":1},"183":{"tf":1},"187":{"tf":1},"194":{"tf":1},"197":{"tf":1},"203":{"tf":1},"208":{"tf":1},"211":{"tf":1},"214":{"tf":1},"230":{"tf":1},"257":{"tf":1}},"df":48}}},"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"_":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"170":{"tf":1.4142135623730951}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"_":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1}},"df":1}}}}}}}},"f":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"198":{"tf":1}},"df":1}}}}}}},"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"_":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1}},"df":1}}}}}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1}},"df":1}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"_":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"189":{"tf":1}},"df":1}}}}}}}}}}}}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"190":{"tf":1}},"df":1}}}}}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"_":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"191":{"tf":1}},"df":1}}}}}}}}}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"192":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"5":{"tf":1}},"df":1}}}}}}},"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"86":{"tf":1}},"df":1}}}}}}}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{"234":{"tf":1}},"df":1}}}}}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"8":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"59":{"tf":1}},"df":1}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{"11":{"tf":1}},"df":1}}}}}}}}}},"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"_":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"_":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"107":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{"212":{"tf":1}},"df":1}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{"231":{"tf":1}},"df":1}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"258":{"tf":1}},"df":1}}}}}}}}}}},"p":{"docs":{},"df":0,"b":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"259":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{"268":{"tf":1}},"df":1,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{"269":{"tf":1}},"df":1}}}}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{"277":{"tf":1}},"df":1}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"284":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"271":{"tf":1}},"df":1}}}}}}}}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"289":{"tf":1}},"df":1}}}}},"b":{"docs":{},"df":0,"p":{"docs":{},"df":0,"c":{"docs":{},"df":0,"r":{"docs":{"261":{"tf":1}},"df":1},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"280":{"tf":1}},"df":1}}}}}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"104":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"_":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"111":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}},"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"195":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"114":{"tf":1}},"df":1}}}}}}}}}}}}},"p":{"docs":{},"df":0,"s":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"232":{"tf":1}},"df":1}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"241":{"tf":1}},"df":1}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"250":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"245":{"tf":1}},"df":1}}}}}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"l":{"docs":{"246":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{"254":{"tf":1}},"df":1}}}}}}}}}}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{"255":{"tf":1}},"df":1}}}}}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"215":{"tf":1},"216":{"tf":1}},"df":2,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"217":{"tf":1}},"df":1}}}}},"r":{"2":{"0":{"docs":{"220":{"tf":1}},"df":1},"docs":{},"df":0},"docs":{},"df":0}}}}}}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"150":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"153":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"y":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"181":{"tf":1}},"df":1}}}}},"o":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"184":{"tf":1}},"df":1}}}}}}}}}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"188":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"204":{"tf":1}},"df":1}}}}}}}}}},"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"209":{"tf":1}},"df":1}}}}}}}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"97":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"_":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"14":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"19":{"tf":1}},"df":1}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"31":{"tf":1}},"df":1}}}}}}}}}}}}}}},"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"_":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"173":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}},"k":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"129":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"25":{"tf":1}},"df":1}}}}}}}}}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"37":{"tf":1}},"df":1}}}}}}}}}}}},"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"54":{"tf":1}},"df":1}}}}}}}}}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"43":{"tf":1}},"df":1}}}}}}}}}}},"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"46":{"tf":1}},"df":1}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"50":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"62":{"tf":1}},"df":1}}}}}}}}}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"69":{"tf":1}},"df":1}}}}}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"s":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"77":{"tf":1}},"df":1}}}}}}}}}}}},"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"141":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}},"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"80":{"tf":1}},"df":1}}}}}}}}}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"k":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"117":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"89":{"tf":1}},"df":1}}}}}}}}}},"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"93":{"tf":1}},"df":1}}}}}}}}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"101":{"tf":1}},"df":1}}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"147":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"123":{"tf":1}},"df":1}}}}}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"135":{"tf":1}},"df":1}}}}}}}}}}}}}}}}},"j":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"144":{"tf":1.4142135623730951}},"df":1}}}}}}}}}}}}}}}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"y":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"x":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"157":{"tf":1}},"df":1}}}}}}}}}}},"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"161":{"tf":1}},"df":1}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"167":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"178":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"1":{"2":{"docs":{},"df":0,".":{"1":{"docs":{"264":{"tf":1}},"df":1},"2":{"docs":{"265":{"tf":1}},"df":1},"docs":{},"df":0}},"docs":{},"df":0},"docs":{},"df":0}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"_":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"15":{"tf":1}},"df":1}}}}}}}}}}},"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"16":{"tf":1}},"df":1}}}}}}}}}},"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"26":{"tf":1}},"df":1}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"27":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"20":{"tf":1}},"df":1}}}}}}}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"21":{"tf":1}},"df":1}}}}}}}}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"38":{"tf":1}},"df":1}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"39":{"tf":1}},"df":1}}}}}}}}}}}}}},"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"40":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}},"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"47":{"tf":1},"83":{"tf":1}},"df":2}}}}}}}}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"71":{"tf":1}},"df":1}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"72":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"73":{"tf":1}},"df":1}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"74":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"y":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"236":{"tf":1}},"df":1}}}}}}}}}},"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{"240":{"tf":1}},"df":1}}}}}}}}}}}}}},"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"237":{"tf":1}},"df":1}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"238":{"tf":1}},"df":1}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{"239":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{"22":{"tf":1}},"df":1}}}}}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"51":{"tf":1}},"df":1}}}}}}}},"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"55":{"tf":1}},"df":1}}}}}},"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"l":{"docs":{"56":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"162":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"v":{"docs":{},"df":0,"p":{"docs":{},"df":0,"b":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"260":{"tf":1}},"df":1}}}}}}}}}}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"262":{"tf":1}},"df":1}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"263":{"tf":1}},"df":1}}}}}}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"1":{"docs":{"266":{"tf":1}},"df":1},"2":{"docs":{"267":{"tf":1}},"df":1},"docs":{},"df":0}}}}}}}}}}}}}}}},"p":{"docs":{},"df":0,"b":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"270":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"281":{"tf":1}},"df":1}}}}}},"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{"285":{"tf":1}},"df":1,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"286":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"287":{"tf":1}},"df":1,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"288":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"283":{"tf":1}},"df":1}}}}}}}}}}}}}},"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"1":{"docs":{"272":{"tf":1}},"df":1},"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{"273":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"274":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"275":{"tf":1}},"df":1}}}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"r":{"docs":{"276":{"tf":1}},"df":1}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"2":{"docs":{"279":{"tf":1}},"df":1},"docs":{"278":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"282":{"tf":1}},"df":1}}}}}}}}}}}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"28":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"32":{"tf":1}},"df":1}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"33":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"124":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"o":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"125":{"tf":1}},"df":1}}}}}}}}}}}}}}}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"126":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}},"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"s":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"185":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"34":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"_":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"98":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"z":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"t":{"docs":{},"df":0,"y":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"63":{"tf":1}},"df":1}}}}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"64":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{"65":{"tf":1}},"df":1}}}}}}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"66":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{"70":{"tf":1}},"df":1}}}}}}}}}}}}}}},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"81":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}},"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"82":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"108":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"164":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}},"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"199":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}},"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"200":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"201":{"tf":1}},"df":1}}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"205":{"tf":1}},"df":1}}}}}}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"206":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"b":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"k":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"118":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"119":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}},"k":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"130":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"131":{"tf":1}},"df":1}}}}}}}}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"132":{"tf":1}},"df":1}}}}}}}}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"k":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"120":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"_":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"136":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"_":{"docs":{},"df":0,"b":{"docs":{},"df":0,"y":{"docs":{},"df":0,"_":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"137":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}},"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"142":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"143":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"175":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}},"p":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"233":{"tf":1}},"df":1}}}}}}}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"235":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"242":{"tf":1}},"df":1}}}}}},"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"243":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"244":{"tf":1}},"df":1}}}}}}}}},"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{"253":{"tf":1}},"df":1}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"247":{"tf":1}},"df":1}}}}}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"248":{"tf":1}},"df":1,"e":{"2":{"docs":{"249":{"tf":1}},"df":1},"docs":{},"df":0}}}}}}}}}}}}}}}}}},"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"y":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"251":{"tf":1}},"df":1}}}}}}}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"252":{"tf":1}},"df":1}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"1":{"docs":{"218":{"tf":1}},"df":1},"2":{"docs":{"219":{"tf":1}},"df":1},"docs":{},"df":0}}}}},"r":{"2":{"0":{"docs":{},"df":0,"d":{"docs":{},"df":0,"t":{"1":{"docs":{"221":{"tf":1}},"df":1},"2":{"docs":{"222":{"tf":1}},"df":1},"docs":{},"df":0}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"223":{"tf":1}},"df":1}}}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{"224":{"tf":1}},"df":1}}}}}}}},"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"225":{"tf":1}},"df":1}}},"n":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{"226":{"tf":1}},"df":1}}},"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"l":{"docs":{"227":{"tf":1}},"df":1}}}}},"docs":{},"df":0},"docs":{},"df":0}}}}}}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"s":{"1":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"154":{"tf":1}},"df":1}}}}}}}},"docs":{},"df":0},"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"_":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"156":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"155":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"158":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"f":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"169":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"1":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"163":{"tf":1}},"df":1}}}}}}}},"docs":{},"df":0}}}}}}}}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"3":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"168":{"tf":1}},"df":1}}}}}}}},"docs":{},"df":0}}}}}}}}}}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"174":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"90":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"94":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"95":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"96":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"_":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"_":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"138":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"228":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}},"pipeline":["trimmer","stopWordFilter","stemmer"]};sidx_href=["intro.html","intro.html#home-link","intro.html#sec_Introduction","intro.html#sec_qf_test","intro.html#sec_tutorial","intro.html#sec_feedback","mobile.html","mobile.html#home-link","mobile.html#sec_mobile","androiddemo.html","androiddemo.html#home-link","androiddemo.html#sec_androiddemo","loadsuiteandroid.html","loadsuiteandroid.html#home-link","loadsuiteandroid.html#tut_loadsuiteandroid","loadsuiteandroid.html#fig_firstTestSuiteAndroid","loadsuiteandroid.html#fig_firstTestSetAndroid","startsutandroid.html","startsutandroid.html#home-link","startsutandroid.html#tut_startsutandroid","startsutandroid.html#fig_firstSetupAndroid","startsutandroid.html#fig_firstStartAndroid","startsutandroid.html#fig_androidDemoApp","firsttestandroid.html","firsttestandroid.html#home-link","firsttestandroid.html#tut_firsttestandroid","firsttestandroid.html#fig_firstTestCaseAndroid","firsttestandroid.html#fig_firstTestCaseDetailsAndroid","firsttestandroid.html#fig_resultOneTestCaseNoErrorAndroid","secondtestandroid.html","secondtestandroid.html#home-link","secondtestandroid.html#tut_secondtestandroid","secondtestandroid.html#fig_secondTestCaseAndroid","secondtestandroid.html#fig_secondTestCaseDetailsAndroid","secondtestandroid.html#fig_textTestErrorAndroid","firstrunlogandroid.html","firstrunlogandroid.html#home-link","firstrunlogandroid.html#tut_firstRunlogAndroid","firstrunlogandroid.html#fig_firstErrorRunlogAndroid","firstrunlogandroid.html#fig_firstErrorRunlogDetailsAndroid","firstrunlogandroid.html#fig_firstErrorRunlogScreenshotAndroid","firsthelpandroid.html","firsthelpandroid.html#home-link","firsthelpandroid.html#tut_firsthelpandroid","firstcleanupandroid.html","firstcleanupandroid.html#home-link","firstcleanupandroid.html#tut_firstcleanupandroid","firstcleanupandroid.html#fig_firstCleanupAndroid","firstfullrunandroid.html","firstfullrunandroid.html#home-link","firstfullrunandroid.html#tut_firstFullRunAndroid","firstfullrunandroid.html#fig_androidRunlogFull","firstreportandroid.html","firstreportandroid.html#home-link","firstreportandroid.html#tut_firstreportandroid","firstreportandroid.html#fig_AndroidReportDialog","firstreportandroid.html#fig_androidReportHtml","testsuite_mobile.html","testsuite_mobile.html#home-link","testsuite_mobile.html#sec_mobiletestsuite","quickstartmobile.html","quickstartmobile.html#home-link","quickstartmobile.html#tut_quickStartMobile","quickstartmobile.html#fig_WizardTypeAndroid","quickstartmobile.html#fig_WizardChooseDeviceAndroid","quickstartmobile.html#fig_WizardAndroidDemo","quickstartmobile.html#fig_WizardFinalAndroid","recactionsmobile.html","recactionsmobile.html#home-link","recactionsmobile.html#tut_recActionsMobile","recactionsmobile.html#fig_MobileAppWinRec","recactionsmobile.html#fig_FirstRecordedLoginSequenceAndroid","recactionsmobile.html#fig_FirstRecordedLoginSequenceRenamedAndroid","recactionsmobile.html#fig_FirstRecordedSequenceAndroid","recactionsmobile.html#fig_FirstRecordedSequenceRenamedAndroid","recchecksmobile.html","recchecksmobile.html#home-link","recchecksmobile.html#tut_recChecksMobile","buildtestandroid.html","buildtestandroid.html#home-link","buildtestandroid.html#tut_buildtestandroid","buildtestandroid.html#fig_beginbuildatest_mobile","buildtestandroid.html#fig_buildatest_mobile","buildtestandroid.html#fig_FirstCleanupAndroid","firstprocmobile.html","firstprocmobile.html#home-link","firstprocmobile.html#sec_FirstProzedurMobile","procreusemobile.html","procreusemobile.html#home-link","procreusemobile.html#tut_procreusemobile","procreusemobile.html#IdenticalTeststepsAndroid","procmanualmobile.html","procmanualmobile.html#home-link","procmanualmobile.html#tut_procmanualmobile","procmanualmobile.html#ProcedureNodeInFirstTestcaseAndroid","procmanualmobile.html#procedureContentInFirstTestcaseAndroid","procmanualmobile.html#AddProcedureCallAndroid","procmanualmobile.html#SelectProcedureAndroid","procmanualmobile.html#fig_testsuite_with_Procedure_android","proctransformmobile.html","proctransformmobile.html#home-link","proctransformmobile.html#tut_proctransformmobile","componentsmobile.html","componentsmobile.html#home-link","componentsmobile.html#sec_ComplexComponentsMobile","complex_components_mobile.html","complex_components_mobile.html#home-link","complex_components_mobile.html#sec_addressing_complex_components_mobile","complex_components_mobile.html#fig_ComponentsListIndexMobile","components_smartid_android.html","components_smartid_android.html#home-link","components_smartid_android.html#sec_components_smartid_android","debuggermobile.html","debuggermobile.html#home-link","debuggermobile.html#sec_DebuggerAndroid","breakpointsmobile.html","breakpointsmobile.html#home-link","breakpointsmobile.html#tut_breakpointsmobile","breakpointsmobile.html#fig_DebugSetBreakpointAndroid","breakpointsmobile.html#fig_DebugStartTestRunAndroid","breakpointsmobile.html#fig_DebugRemoveBreakpointAndroid","debugstepsmobile.html","debugstepsmobile.html#home-link","debugstepsmobile.html#tut_debug_steps_mobile","debugstepsmobile.html#fig_StepInExampleAndroid","debugstepsmobile.html#fig_StepOverExampleAndroid","debugstepsmobile.html#fig_StepOutExampleAndroid","skipstepsmobile.html","skipstepsmobile.html#home-link","skipstepsmobile.html#tut_skip_steps_mobile","skipstepsmobile.html#fig_DebugSkipOverInitialStateAndroid","skipstepsmobile.html#fig_DebugSkipOverAndroid","skipstepsmobile.html#fig_DebugSkipOutAndroid","debugonerrormobile.html","debugonerrormobile.html#home-link","debugonerrormobile.html#tut_debug_start_mobile","debugonerrormobile.html#fig_debugger_stops_at_error_mobile","debugonerrormobile.html#fig_debugger_stopped_by_error_mobile","debugonerrormobile.html#debug_error_dialog_mobile","correcterrorfromrunlogmobile.html","correcterrorfromrunlogmobile.html#home-link","correcterrorfromrunlogmobile.html#tut_ResolveRunTimeErrorsAndroid","correcterrorfromrunlogmobile.html#fig_DebugUpdateCheckNodeAndroid","correcterrorfromrunlogmobile.html#fig_DebugCorrectedCheckNodeAndroid","correcterrorfromrunlogmobile.html#tut_JumpToRunLogAndroid","pausemobile.html","pausemobile.html#home-link","pausemobile.html#tut_pause_execution_mobile","variablestackmobile.html","variablestackmobile.html#home-link","variablestackmobile.html#sec_variablestackmobile","secondprocmobile.html","secondprocmobile.html#home-link","secondprocmobile.html#sec_ProcedureWithVariableAndroid","secondprocmobile.html#fig_params1Android","secondprocmobile.html#fig_procedure_hardcoded_mobile","secondprocmobile.html#fig_parameter_default_values_table_mobile","secondprocmobile.html#tut_VariableSyntaxMobile","secondprocmobile.html#fig_ProcedureAddVariableAndroid","variablebindingstablemobile.html","variablebindingstablemobile.html#home-link","variablebindingstablemobile.html#tut_variable_stack_mobile","variablebindingstablemobile.html#fig_AddProcedureCallToSecondTestcaseAndroid","variablebindingstablemobile.html#fig_VariableBindingsTable1Android","variablebindingstablemobile.html#fig_CompleteParameters_mobile","variablestackdebuggingmobile.html","variablestackdebuggingmobile.html#home-link","variablestackdebuggingmobile.html#tut_variable_stack_debugging_mobile","variablestackdebuggingmobile.html#fig_VariableStack3Android","variablestackdebuggingmobile.html#fig_ProcedureContinueExecFromHereAndroid","variablestackdebuggingmobile.html#locate_current_node_mobile","settingvariablesmobile.html","settingvariablesmobile.html#home-link","settingvariablesmobile.html#tut_setting_variables_mobile","settingvariablesmobile.html#figtailsSetVariableAndroid","settingvariablesmobile.html#fig_DetailsCallProcedureAndroid","variablelevelsmobile.html","variablelevelsmobile.html#home-link","variablelevelsmobile.html#tut_variable_levels_mobile","stdlibmobile.html","stdlibmobile.html#home-link","stdlibmobile.html#sec_StandardLibraryMobile","stdliboverviewmobile.html","stdliboverviewmobile.html#home-link","stdliboverviewmobile.html#sec_StandardLibraryOverviewMobile","stdliboverviewmobile.html#fig_SuiteQfsQftMobile","stdlibpackagesmobile.html","stdlibpackagesmobile.html#home-link","stdlibpackagesmobile.html#sec_StandardLibraryPackagesMobile","stdlibpackagesmobile.html#sec_the_android_package","stdlibpackagesmobile.html#sec_the_utils_package","stdlibpackagesmobile.html#sec_the_check_package","stdlibpackagesmobile.html#sec_the_databinder_package","controlsmobile.html","controlsmobile.html#home-link","controlsmobile.html#sec_controlstructuresmobile","ifelsemobile.html","ifelsemobile.html#home-link","ifelsemobile.html#sec_ifmobile","ifelsemobile.html#fig_ControlsSetupSequenceMobile","ifelsemobile.html#fig_ControlsWaitForComponentMobile","ifelsemobile.html#fig_ControlsIfMobile","loopsmobile.html","loopsmobile.html#home-link","loopsmobile.html#sec_loopsmobile","loopsmobile.html#fig_ControlsTestcaseMobile","loopsmobile.html#fig_ControlsCheckDetailsMobile","ownapp.html","ownapp.html#home-link","ownapp.html#sec_ownappmobile","advanced.html","advanced.html#home-link","advanced.html#sec_advanced","datadriven.html","datadriven.html#home-link","datadriven.html#sec_DataDriven","datadriven.html#sec_dataDriven","datadriven.html#sec_dataDrivenTrad","datadriven.html#fig_dataDrivenTrad1","datadriven.html#fig_dataDrivenTrad2","datadriven.html#sec_dataDriver20","datadriven.html#fig_dataDriver20Dt1","datadriven.html#fig_dataDriver20Dt2","datadriven.html#fig_dataDriver20TestSet","datadriven.html#fig_dataDriver20ParamTree","datadriven.html#fig_dataDriver20Full","datadriven.html#fig_dataDriver20NRR","datadriven.html#fig_dataDriver20HTML","datadriven.html#dataDrivenSummary","dependencies.html","dependencies.html#home-link","dependencies.html#sec_AdvDeps","dependencies.html#sec_depsGeneral","dependencies.html#fig_depWorkTestSuite","dependencies.html#sec_firstDep","dependencies.html#fig_depFirstDepWorkTestSuite","dependencies.html#fig_firstDependencySample","dependencies.html#fig_firstDepSampleRunLog","dependencies.html#fig_firstDepSampleStart","dependencies.html#fig_firstDepSampleDepRef","dependencies.html#fig_firstDepEnsuringPreReqs","dependencies.html#sec_depCombine","dependencies.html#fig_depVehicleDialog","dependencies.html#fig_depVehiclesAccessoriesTest","dependencies.html#fig_depRunLogDepCombine","dependencies.html#sec_depErrorAndCatch","dependencies.html#sec_depErrorHandler","dependencies.html#fig_depErrorTestSuite","dependencies.html#fig_depErrorHandlerSample","dependencies.html#fig_depErrorHandlerSample2","dependencies.html#sec_depCatch","dependencies.html#fig_depCatchTryEachTest","dependencies.html#fig_depCatchTestSuite","dependencies.html#fig_depRunLogCatchDep","dependencies.html#sec_depErrorCatchSum","dependencies.html#sec_depMoreDep","tut_procbuilder.html","tut_procbuilder.html#home-link","tut_procbuilder.html#sec_AdvProcbuilder","tut_procbuilder.html#sec_apbGeneral","tut_procbuilder.html#fig_advPbTestSuite","tut_procbuilder.html#sec_abpCreation","tut_procbuilder.html#fig_autoProcSuite","tut_procbuilder.html#fig_autoProcFirstRecord","tut_procbuilder.html#table_12.1","tut_procbuilder.html#table_12.2","tut_procbuilder.html#fig_autoProcTestSuite1","tut_procbuilder.html#fig_autoProcTestSuite2","tut_procbuilder.html#sec_apbConf","tut_procbuilder.html#sec_apbConfIntro","tut_procbuilder.html#fig_apbConfiguration","tut_procbuilder.html#sec_apbFirstExample","tut_procbuilder.html#fig_apbOwnConf1","tut_procbuilder.html#fig_apbOwnConfProc","tut_procbuilder.html#fig_apbOwnConfParams","tut_procbuilder.html#fig_apbOwnConfPlaceholderCompId","tut_procbuilder.html#fig_apbOwnConfFirstCreation","tut_procbuilder.html#sec_apbCurrentText","tut_procbuilder.html#fig_apbExampleCurrentText","tut_procbuilder.html#fig_apbExampleCurrentText2","tut_procbuilder.html#sec_abpContainer","tut_procbuilder.html#fig_apbContainerExample","tut_procbuilder.html#fig_apbForChildrenTag","tut_procbuilder.html#fig_apbCreatedContainer","tut_procbuilder.html#sec_apbCurrentChildValue","tut_procbuilder.html#fig_apbContainerCurrentText","tut_procbuilder.html#fig_apbContainerCurrentTextTestSuite","tut_procbuilder.html#fig_apbContainerParams","tut_procbuilder.html#fig_apbContainerParamsTestSuite","tut_procbuilder.html#sec_apbMore"];sidx_stops=["","a","able","about","across","after","almost","also","am","among","an","and","are","as","at","be","because","been","but","by","can","cannot","could","dear","did","do","does","either","ever","every","got","had","have","he","her","hers","him","his","how","however","i","into","is","it","its","just","least","like","likely","may","me","might","most","must","my","neither","no","nor","not","of","off","often","on","only","other","our","rather","said","say","says","she","should","so","some","than","that","the","their","them","then","there","these","they","this","tis","to","too","twas","us","wants","was","we","were","what","when","where","which","who","whom","why","will","with","would","yet","you","your"];if(window.sidx_load_callback){sidx_load_callback(sidx_dump,sidx_href,sidx_stops)}