package de.qfs
class JSONModule{
    //  redirected constants
    //  redirected methods
    /**
     * The JSON.parse() static method parses a JSON string, constructing the Object value or object described by the string.
     * If called from Javascript, the original Javascript version of JSON.parse is used.
     * 
     * @param text      The String or InputStream to parse as JSON.
     * @param reviver   If a function, this prescribes how each value originally produced by parsing is transformed before being returned.
     * Non-callable values are ignored.
     * 
     * @implNote
     * If a reviver is specified, the value computed by parsing is transformed before being returned. Specifically, the computed value and all its properties
     * (in a depth-first fashion, beginning with the most nested properties and proceeding to the original value itself) are individually run through the reviver.
     * The reviver is called with two arguments: key and value, representing the property name as a string (even for Lists) and the property value.
     * If the reviver function throws a NoSuchElementException, the property is deleted from the object (or replaced by null in a list),
     * if it throws an UnsupportedOperationException, the value is unchanged.
     * Otherwise, the property is redefined to be the return value.
     * If the reviver only transforms some values and not others, be certain to return all untransformed values as-is or throw an UnsupportedOperationException.
     * Otherwise, they will be deleted from the resulting object.
     * Similar to the replacer parameter of JSON.stringify(), for Lists and Maps, reviver will be last called on the root value with an empty string as the key and the root object as the value.
     * For other valid JSON values, reviver works similarly and is called once with an empty string as the key and the value itself as the value.
     * If you return another value from reviver, that value will completely replace the originally parsed value. This even applies to the root value.
     * 
     * @return The Map, List, String, Number, Boolean, or null value corresponding to the given JSON text.
     */
    public  static Object parse(Object text, Object reviver=null){
        return de.qfs.apps.qftest.shared.script.modules.JSONModule.parse(text, reviver)
    }
    /**
     * The JSON.parse() static method parses a JSON string, constructing the Object value or object described by the string.
     * If called from Javascript, the original Javascript version of JSON.parse is used.
     * 
     * @param text      The String or InputStream to parse as JSON.
     * @param reviver   If a function, this prescribes how each value originally produced by parsing is transformed before being returned.
     * Non-callable values are ignored.
     * 
     * @implNote
     * If a reviver is specified, the value computed by parsing is transformed before being returned. Specifically, the computed value and all its properties
     * (in a depth-first fashion, beginning with the most nested properties and proceeding to the original value itself) are individually run through the reviver.
     * The reviver is called with two arguments: key and value, representing the property name as a string (even for Lists) and the property value.
     * If the reviver function throws a NoSuchElementException, the property is deleted from the object (or replaced by null in a list),
     * if it throws an UnsupportedOperationException, the value is unchanged.
     * Otherwise, the property is redefined to be the return value.
     * If the reviver only transforms some values and not others, be certain to return all untransformed values as-is or throw an UnsupportedOperationException.
     * Otherwise, they will be deleted from the resulting object.
     * Similar to the replacer parameter of JSON.stringify(), for Lists and Maps, reviver will be last called on the root value with an empty string as the key and the root object as the value.
     * For other valid JSON values, reviver works similarly and is called once with an empty string as the key and the value itself as the value.
     * If you return another value from reviver, that value will completely replace the originally parsed value. This even applies to the root value.
     * 
     * @return The Map, List, String, Number, Boolean, or null value corresponding to the given JSON text.
     */
    public  static Object parse(Map mappedParams, Object text){
        if(mappedParams == null){
            return de.qfs.apps.qftest.shared.script.modules.JSONModule.parse(mappedParams, text)
        }
        def reviver = null
        if(mappedParams.containsKey("reviver")){
            reviver = mappedParams.reviver
        }
        return de.qfs.apps.qftest.shared.script.modules.JSONModule.parse(text, reviver)
    }
    public  static Object stringify(Object value){
        return de.qfs.apps.qftest.shared.script.modules.JSONModule.stringify(value)
    }
    public  static Object stringify(Object value, Object replacer){
        return de.qfs.apps.qftest.shared.script.modules.JSONModule.stringify(value, replacer)
    }
    public  static Object stringify(Object value, Object replacer, Long space){
        return de.qfs.apps.qftest.shared.script.modules.JSONModule.stringify(value, replacer, space)
    }
    public  static Object stringify(Object value, Object replacer, String space){
        return de.qfs.apps.qftest.shared.script.modules.JSONModule.stringify(value, replacer, space)
    }
}
