from de.qfs.apps.qftest.shared.script.modules import Autowin as _WrappedAutowin
#  redirected constants
VK_RETURN = _WrappedAutowin.VK_RETURN
VK_ENTER = _WrappedAutowin.VK_ENTER
VK_BACKSPACE = _WrappedAutowin.VK_BACKSPACE
VK_TAB = _WrappedAutowin.VK_TAB
VK_SHIFT = _WrappedAutowin.VK_SHIFT
VK_CONTROL = _WrappedAutowin.VK_CONTROL
VK_CTRL = _WrappedAutowin.VK_CTRL
VK_MENU = _WrappedAutowin.VK_MENU
VK_ALT = _WrappedAutowin.VK_ALT
VK_ESCAPE = _WrappedAutowin.VK_ESCAPE
VK_ESC = _WrappedAutowin.VK_ESC
VK_SPACE = _WrappedAutowin.VK_SPACE
VK_PRIOR = _WrappedAutowin.VK_PRIOR
VK_PGUP = _WrappedAutowin.VK_PGUP
VK_NEXT = _WrappedAutowin.VK_NEXT
VK_PGDOWN = _WrappedAutowin.VK_PGDOWN
VK_END = _WrappedAutowin.VK_END
VK_HOME = _WrappedAutowin.VK_HOME
VK_LEFT = _WrappedAutowin.VK_LEFT
VK_UP = _WrappedAutowin.VK_UP
VK_RIGHT = _WrappedAutowin.VK_RIGHT
VK_DOWN = _WrappedAutowin.VK_DOWN
VK_INSERT = _WrappedAutowin.VK_INSERT
VK_DELETE = _WrappedAutowin.VK_DELETE
VK_WINDOWS = _WrappedAutowin.VK_WINDOWS
VK_F1 = _WrappedAutowin.VK_F1
VK_F2 = _WrappedAutowin.VK_F2
VK_F3 = _WrappedAutowin.VK_F3
VK_F4 = _WrappedAutowin.VK_F4
VK_F5 = _WrappedAutowin.VK_F5
VK_F6 = _WrappedAutowin.VK_F6
VK_F7 = _WrappedAutowin.VK_F7
VK_F8 = _WrappedAutowin.VK_F8
VK_F9 = _WrappedAutowin.VK_F9
VK_F10 = _WrappedAutowin.VK_F10
VK_F11 = _WrappedAutowin.VK_F11
VK_F12 = _WrappedAutowin.VK_F12
VK_F13 = _WrappedAutowin.VK_F13
VK_F14 = _WrappedAutowin.VK_F14
VK_F15 = _WrappedAutowin.VK_F15
VK_F16 = _WrappedAutowin.VK_F16
VK_F17 = _WrappedAutowin.VK_F17
VK_F18 = _WrappedAutowin.VK_F18
VK_F19 = _WrappedAutowin.VK_F19
VK_F20 = _WrappedAutowin.VK_F20
VK_F21 = _WrappedAutowin.VK_F21
VK_F22 = _WrappedAutowin.VK_F22
VK_F23 = _WrappedAutowin.VK_F23
VK_F24 = _WrappedAutowin.VK_F24
VK_0 = _WrappedAutowin.VK_0
VK_1 = _WrappedAutowin.VK_1
VK_2 = _WrappedAutowin.VK_2
VK_3 = _WrappedAutowin.VK_3
VK_4 = _WrappedAutowin.VK_4
VK_5 = _WrappedAutowin.VK_5
VK_6 = _WrappedAutowin.VK_6
VK_7 = _WrappedAutowin.VK_7
VK_8 = _WrappedAutowin.VK_8
VK_9 = _WrappedAutowin.VK_9
VK_A = _WrappedAutowin.VK_A
VK_B = _WrappedAutowin.VK_B
VK_C = _WrappedAutowin.VK_C
VK_D = _WrappedAutowin.VK_D
VK_E = _WrappedAutowin.VK_E
VK_F = _WrappedAutowin.VK_F
VK_G = _WrappedAutowin.VK_G
VK_H = _WrappedAutowin.VK_H
VK_I = _WrappedAutowin.VK_I
VK_J = _WrappedAutowin.VK_J
VK_K = _WrappedAutowin.VK_K
VK_L = _WrappedAutowin.VK_L
VK_M = _WrappedAutowin.VK_M
VK_N = _WrappedAutowin.VK_N
VK_O = _WrappedAutowin.VK_O
VK_P = _WrappedAutowin.VK_P
VK_Q = _WrappedAutowin.VK_Q
VK_R = _WrappedAutowin.VK_R
VK_S = _WrappedAutowin.VK_S
VK_T = _WrappedAutowin.VK_T
VK_U = _WrappedAutowin.VK_U
VK_V = _WrappedAutowin.VK_V
VK_W = _WrappedAutowin.VK_W
VK_X = _WrappedAutowin.VK_X
VK_Y = _WrappedAutowin.VK_Y
VK_Z = _WrappedAutowin.VK_Z
VK_NUMPAD0 = _WrappedAutowin.VK_NUMPAD0
VK_NUMPAD1 = _WrappedAutowin.VK_NUMPAD1
VK_NUMPAD2 = _WrappedAutowin.VK_NUMPAD2
VK_NUMPAD3 = _WrappedAutowin.VK_NUMPAD3
VK_NUMPAD4 = _WrappedAutowin.VK_NUMPAD4
VK_NUMPAD5 = _WrappedAutowin.VK_NUMPAD5
VK_NUMPAD6 = _WrappedAutowin.VK_NUMPAD6
VK_NUMPAD7 = _WrappedAutowin.VK_NUMPAD7
VK_NUMPAD8 = _WrappedAutowin.VK_NUMPAD8
VK_NUMPAD9 = _WrappedAutowin.VK_NUMPAD9
KEYEVENTF_EXTENDEDKEY = _WrappedAutowin.KEYEVENTF_EXTENDEDKEY
KEYEVENTF_KEYUP = _WrappedAutowin.KEYEVENTF_KEYUP
MOUSEEVENTF_MOVE = _WrappedAutowin.MOUSEEVENTF_MOVE
MOUSEEVENTF_LEFTDOWN = _WrappedAutowin.MOUSEEVENTF_LEFTDOWN
MOUSEEVENTF_LEFTUP = _WrappedAutowin.MOUSEEVENTF_LEFTUP
MOUSEEVENTF_RIGHTDOWN = _WrappedAutowin.MOUSEEVENTF_RIGHTDOWN
MOUSEEVENTF_RIGHTUP = _WrappedAutowin.MOUSEEVENTF_RIGHTUP
MOUSEEVENTF_MIDDLEDOWN = _WrappedAutowin.MOUSEEVENTF_MIDDLEDOWN
MOUSEEVENTF_MIDDLEUP = _WrappedAutowin.MOUSEEVENTF_MIDDLEUP
MOUSEEVENTF_WHEEL = _WrappedAutowin.MOUSEEVENTF_WHEEL
MOUSEEVENTF_ABSOLUTE = _WrappedAutowin.MOUSEEVENTF_ABSOLUTE
WHEEL_DELTA = _WrappedAutowin.WHEEL_DELTA
SM_CXSCREEN = _WrappedAutowin.SM_CXSCREEN
SM_CYSCREEN = _WrappedAutowin.SM_CYSCREEN
SC_CLOSE = _WrappedAutowin.SC_CLOSE
SC_MINIMIZE = _WrappedAutowin.SC_MINIMIZE
SC_MAXIMIZE = _WrappedAutowin.SC_MAXIMIZE
SC_RESTORE = _WrappedAutowin.SC_RESTORE
WM_COMMAND = _WrappedAutowin.WM_COMMAND
#  redirected methods
__wrappedInstance = _WrappedAutowin.instance()
def getAllWindows():
    """
    Get all top-level windows on the screen.

    @return A list with the top-level windows.
    """
    return __wrappedInstance.getAllWindows()

def getWindowText(win):
    """
    Get the text of a window (does work not only for titles).

    @param win
    The window handle.
    @return The text of the window.
    """
    return __wrappedInstance.getWindowText(win)

def setWindowText(win, text):
    """
    Set the text of a window.

    @param win
    The window handle.
    @param text
    The text to set.
    @return True, if the text is set.
    """
    return __wrappedInstance.setWindowText(win, text)

def getWindowClassName(win):
    """
    Get the classname of a window.

    @param win
    The window handle.
    @return The classname of the window.
    """
    return __wrappedInstance.getWindowClassName(win)

def setWindowPosition(win, x, y):
    """
    Set the position of a window.

    @param win
    The window handle.
    @param x
    The x co-ordinate.
    @param y
    The y co-ordinate.
    """
    __wrappedInstance.setWindowPosition(win, x, y)

def setWindowSize(win, width, height):
    """
    Set the size of a window.

    @param win
    The window handle.
    @param width
    The width.
    @param height
    The height.
    """
    __wrappedInstance.setWindowSize(win, width, height)

def findWindow(name, regexp=False):
    """
    Find a window on the desktop indentified by its title.

    @param name
    The window title
    @param regexp
    True if the given title is a regular expression.
    @return A handle for the window or null if not found.
    @throws Exception
    """
    if regexp:
        regexp = True

    else:
        regexp = False

    return __wrappedInstance.findWindow(name, regexp)

def waitForWindow(timeout, name, regexp=False):
    """
    Wait for a window on the desktop identified by its title.

    @param timeout
    The maximum time to wait (in ms).
    @param name
    The window title
    @param regexp
    True if the given title is a regular expression.
    @return A handle for the window or null if the timeout is exceeded.
    @throws Exception
    """
    if regexp:
        regexp = True

    else:
        regexp = False

    return __wrappedInstance.waitForWindow(timeout, name, regexp)

def findDialog(parent, titleRe=None):
    """
    Find a dialog on the desktop with the given parent.

    @param parent
    The parent window.
    @param titleRe
    An optional regexp for the window title.
    @return A handle for the dialog or null if the timeout is exceeded.
    @throws Exception
    """
    return __wrappedInstance.findDialog(parent, titleRe)

def waitForDialog(timeout, parent, titleRe=None):
    """
    Wait for a dialog on the desktop with the given parent.

    @param timeout
    The maximum time to wait (in ms).

    @param parent
    The parent window.

    @param titleRe
    An optional regexp for the window title.

    @return A handle for the dialog or null if the timeout is exceeded.
    @throws Exception
    """
    return __wrappedInstance.waitForDialog(timeout, parent, titleRe)

def findChildWindow(parent, name, regexp=False):
    """
    Find a child window of a given window, indentified by some text.

    @param parent
    A handle for the parent window.
    @param name
    The identifying text.
    @param regexp
    True if the given text is a regular expression.
    @return A handle for the child window or null if not found.
    @throws Exception
    """
    if regexp:
        regexp = True

    else:
        regexp = False

    return __wrappedInstance.findChildWindow(parent, name, regexp)

def findChildWindows(parent, name=None, regexp=False, clazz=None):
    """
    Find child windows of a given window, identified by text and class name.

    @param parent
    A handle for the parent window.
    @param name
    The identifying text.
    @param regexp
    True if the given text is a regular expression.
    @param clazz
    The name of the child window's class.
    @return A list of child window handles.
    """
    if regexp:
        regexp = True

    else:
        regexp = False

    return __wrappedInstance.findChildWindows(parent, name, regexp, clazz)

def waitForChildWindow(timeout, parent, name, regexp=False):
    """
    Wait for a child window of a given window, indentified by some text.

    @param timeout
    The maximum time to wait (in ms).
    @param parent
    A handle for the parent window.
    @param name
    The identifying text.
    @param regexp
    True if the given text is a regular expression.
    @return A handle for the child window or null if not found.
    @throws Exception
    """
    if regexp:
        regexp = True

    else:
        regexp = False

    return __wrappedInstance.waitForChildWindow(timeout, parent, name, regexp)

def findChildWindowByClassName(parent, classname, regexp=False):
    """
    Find a child window of a given window, indentified by the window's class name

    @param parent
    A handle for the parent window.
    @param classname
    The identifying classname.
    @param regexp
    True if the given classname is a regular expression.
    @return A handle for the child window or null if not found.
    @throws Exception
    """
    if regexp:
        regexp = True

    else:
        regexp = False

    return __wrappedInstance.findChildWindowByClassName(parent, classname, regexp)

def mouse_event(flags, dx, dy, dwData=0):
    """ Synthesize a mouse event at the given coordinates."""
    __wrappedInstance.mouse_event(flags, dx, dy, dwData)

def keybd_event(code, flags):
    """
    Synthesize a key event.

    @param code
    The virtual key code.
    @param flags
    KEYEVENTF flags.
    """
    __wrappedInstance.keybd_event(code, flags)

def doClickHard(x, y, right=False):
    """ Synthesize a mouse click at the given screen position."""
    if right:
        right = True

    else:
        right = False

    __wrappedInstance.doClickHard(x, y, right)

def doClick(win, x, y):
    """
    Simulate a mouse click on a window.

    @param win
    A handle for the window.
    @param x
    Target X coordinate.
    @param y
    Target Y coordinate.
    """
    __wrappedInstance.doClick(win, x, y)

def closeWindow(win, async=False):
    """
    Close a window by sending it the WM_CLOSE message.

    @param win
    A handle for the window.
    """
    if async:
        async = True

    else:
        async = False

    __wrappedInstance.closeWindow(win, async)

def maximizeWindow(win):
    """
    Maximize a window.

    @param win
    A handle for the window.
    """
    __wrappedInstance.maximizeWindow(win)

def minimizeWindow(win):
    """
    Minimize a window.

    @param win
    A handle for the window.
    """
    __wrappedInstance.minimizeWindow(win)

def restoreWindow(win):
    """
    Restore a window.

    @param win
    A handle for the window.
    """
    __wrappedInstance.restoreWindow(win)

def setForeground(win):
    """
    Puts a window to the foreground

    @param win
    A handle for the window.
    """
    __wrappedInstance.setForeground(win)

def typeKey(win, keycode):
    """
    Simulate a key press on a window.

    @param win
    A handle for the window.
    @param keycode
    The keycode for the key.
    """
    __wrappedInstance.typeKey(win, keycode)

def sendText(textToInput):
    """
    Sends appropriate key events to input text to the control currently in focus

    @param textToInput the text to input

    @since 5.1.1
    """
    __wrappedInstance.sendText(textToInput)

