from de.qfs.apps.qftest.shared.script.modules.helper import AttrWrappableMap

class DictAttrWrapper(dict):
    """ 
        Wrapper which allows to access elements in a dictionary
        recursively using attribute syntax
    """

    def __init__(self, delegate):
        self.__delegate__ = delegate
        pass
    
    # Forward dictionary access:
        
    def __getitem__(self, *args, **kwargs):
        item = self.__delegate__.__getitem__(*args, **kwargs)
        if isinstance(item, AttrWrappableMap):
            return DictAttrWrapper(item)
        return item

    def __setitem__(self, *args, **kwargs):
        return self.__delegate__.__setitem__(*args, **kwargs)
        
    def __delitem__(self, *args, **kwargs):
        return self.__delegate__.__delitem__(*args, **kwargs)
        
    def __cmp__(self, *args, **kwargs):
        return self.__delegate__.__cmp__(*args, **kwargs)
        
    def __contains__(self, *args, **kwargs):
        return self.__delegate__.__contains__(*args, **kwargs)
        
    def __doc__(self, *args, **kwargs):
        return self.__delegate__.__doc__(*args, **kwargs)
        
    def __iter__(self, *args, **kwargs):
        return self.__delegate__.__iter__(*args, **kwargs)
        
    def __ge__(self, *args, **kwargs):
        return self.__delegate__.__ge__(*args, **kwargs)
        
    def __gt__(self, *args, **kwargs):
        return self.__delegate__.__gt__(*args, **kwargs)
        
    def __le__(self, *args, **kwargs):
        return self.__delegate__.__le__(*args, **kwargs)
        
    def __lt__(self, *args, **kwargs):
        return self.__delegate__.__lt__(*args, **kwargs)
         
    def __ne__(self, *args, **kwargs):
        return self.__delegate__.__ne__(*args, **kwargs)
    
    def __reduce__(self, *args, **kwargs):
        return self.__delegate__.__reduce__(*args, **kwargs)
    
    def __reduce_ex__(self, *args, **kwargs):
        return self.__delegate__.__reduce_ex__(*args, **kwargs)
    
    def __repr__(self, *args, **kwargs):
        return self.__delegate__.__repr__(*args, **kwargs)
    
    def __str__(self, *args, **kwargs):
        return self.__delegate__.__str__(*args, **kwargs)
    
    def clear(self, *args, **kwargs):
        return self.__delegate__.clear(*args, **kwargs)
    
    def copy(self, *args, **kwargs):
        return self.__delegate__.copy(*args, **kwargs)
    
    def fromkeys(self, *args, **kwargs):
        return self.__delegate__.fromkeys(*args, **kwargs)
    
    def get(self, *args, **kwargs):
        return self.__delegate__.get(*args, **kwargs)
    
    def has_key(self, *args, **kwargs):
        return self.__delegate__.has_key(*args, **kwargs)
    
    def items(self, *args, **kwargs):
        return self.__delegate__.items(*args, **kwargs)
    
    def iteritems(self, *args, **kwargs):
        return self.__delegate__.iteritems(*args, **kwargs)
    
    def iterkeys(self, *args, **kwargs):
        return self.__delegate__.iterkeys(*args, **kwargs)
    
    def itervalues(self, *args, **kwargs):
        return self.__delegate__.itervalues(*args, **kwargs)
    
    def keys(self, *args, **kwargs):
        return self.__delegate__.keys(*args, **kwargs)
    
    def pop(self, *args, **kwargs):
        return self.__delegate__.pop(*args, **kwargs)
    
    def popitem(self, *args, **kwargs):
        return self.__delegate__.popitem(*args, **kwargs)
    
    def setdefault(self, *args, **kwargs):
        return self.__delegate__.setdefault(*args, **kwargs)
    
    def setifabsent(self, *args, **kwargs):
        return self.__delegate__.setifabsent(*args, **kwargs)
    
    def update(self, *args, **kwargs):
        return self.__delegate__.update(*args, **kwargs)
    
    def values(self, *args, **kwargs):
        return self.__delegate__.values(*args, **kwargs)
    
    def viewitems(self, *args, **kwargs):
        return self.__delegate__.viewitems(*args, **kwargs)
    
    def viewkeys(self, *args, **kwargs):
        return self.__delegate__.viewkeys(*args, **kwargs)
    
    def viewvalues(self, *args, **kwargs):
        return self.__delegate__.viewvalues(*args, **kwargs)
         
    # Add attribute access:
    def __getattr__(self, key):
        if key[:2] == "__" and key[-2:] == "__":
            return super(dict, self).__getattr__(key)
        return self.__getattribute__(key)
            
    def __getattribute__(self, key):
        if key[:2] == "__" and key[-2:] == "__":
            return super(dict, self).__getattribute__(key)
            
        try:
            return self.__getitem__(key)
        except KeyError:
            raise AttributeError("Dictionary has no item '%s'" % key)

    def __setattr__(self, key, value):
        if key[:2] == "__" and key[-2:] == "__":
            return super(dict, self).__setattr__(key, value)
        return self.__setitem__(key, value)

    def __delattr__(self, key):
        if key[:2] == "__" and key[-2:] == "__":
            return super(dict, self).__delattr__(key)
        return self.__delitem__(key)