#!/bin/sh

#----------------------------------------------------------------------
# Locate this shell skript
#----------------------------------------------------------------------
binary=$0
if [ -n "$QFTEST_DEBUG" ]; then
    echo binary: $binary
fi

# Shouldn't be necessary
while [ -L "$binary" ]; do
    link=`ls -ld "$binary"`
    link=`expr "$link" : '.*-> \(.*\)$'`
    if [ -n "$QFTEST_DEBUG" ]; then
        echo following link: $link
    fi
    case $link in
    /*)
    binary=$link
    ;;
    *)
    binary=`dirname "$binary"`/$link
    ;;
    esac
done

basedir=`dirname "$binary"`
basedir=`cd "$basedir"; pwd`
topdir=`dirname "$basedir"`
bindir=$basedir/bin

#----------------------------------------------------------------------
# Possibly create directories
#----------------------------------------------------------------------
if [ ! -e "$topdir/log" ]; then
    echo "Creating directory $topdir/log"
    mkdir "$topdir/log"
    chmod 777 "$topdir/log"
fi

if [ ! -e "$topdir/jython" ]; then
    echo "Creating directory $topdir/jython"
    mkdir "$topdir/jython"
    chmod 777 "$topdir/jython"
else
    rm -f "$topdir/jython/*\$py.class"
fi

if [ ! -e "$topdir/groovy" ]; then
    echo "Creating directory $topdir/groovy"
    mkdir "$topdir/groovy"
    chmod 777 "$topdir/groovy"
fi

if [ ! -e "$topdir/javascript" ]; then
    echo "Creating directory $topdir/javascript"
    mkdir "$topdir/javascript"
    chmod 777 "$topdir/javascript"
fi

if [ ! -e "$topdir/plugin" ]; then
    echo "Creating directory $topdir/plugin"
    mkdir "$topdir/plugin"
    chmod 777 "$topdir/plugin"
fi

if [ ! -e "$topdir/plugin/qftest" ]; then
    echo "Creating directory $topdir/plugin/qftest"
    mkdir "$topdir/plugin/qftest"
    chmod 777 "$topdir/plugin/qftest"
fi

if [ ! -e "$topdir/plugin/sut" ]; then
    echo "Creating directory $topdir/plugin/sut"
    mkdir "$topdir/plugin/sut"
    chmod 777 "$topdir/plugin/sut"
fi

#----------------------------------------------------------------------
# Migration: copy qftest.cfg and qftest.options
#----------------------------------------------------------------------
if [ ! -e "$topdir/qftest.options" -a -e "$topdir/qftestJUI.options" ]; then
    echo Copying global command line arguments to $topdir/qftest.options
    cp "$topdir/qftestJUI.options" "$topdir/qftest.options"
fi

#----------------------------------------------------------------------
# Create links in /usr/local/bin or /usr/bin
#----------------------------------------------------------------------
target=/usr/local/bin
if [ ! -d "$target" ]; then
    target=/usr/bin
fi

while [ 1 = 1 ]; do
    echo
    echo "Do you want to create a symbolic link to qftest"
    echo -n "in $target [Y/n]? "
    read answer rest
    case $answer in
    '' | y* | Y*)
        echo "Creating symbolic link $target/qftest"
        rm -f "$target/qftest"
        ln -s "$bindir/qftest" "$target/qftest"
        break
        ;;
    n* | N*)
        echo "Symbolic link not created"
        break
        ;;
    esac
done

#----------------------------------------------------------------------
# Check java installation/configuration
#----------------------------------------------------------------------
usemyjre=
java=
lang=
javacfg=
javamem=
memcfg=
# load old configuration
if [ -f "$topdir/launcher.cfg" ]; then
    . "$topdir/launcher.cfg"
    if [ -n "$java" ]; then
        javacfg=1
    fi
    if [ -n "$javamem" ]; then
        memcfg=1
    fi
fi

usejava="$java"

# Look for own JRE
myjre=
uname -a | grep -q Linux
if [ $? ]; then
    uname -a | grep -q x86_64
    if [ $? ]; then
    if [ -d "$basedir/jre/linux64" ]; then
        myjre="$basedir/jre/linux64"
    elif [ -d "$basedir/jre/linux32" ]; then
        myjre="$basedir/jre/linux32"
    fi
    elif [ -d "$basedir/jre/linux32" ]; then
    myjre="$basedir/jre/linux32"
    fi
fi

if [ -z "$usejava" ]; then
    # Locate java executable on the path
    path=$PATH
    exe=java
    while [ -n "$path" ]; do
    dir=`expr "$path" : '\([^:]*\)'`
    path=`expr "$path" : '[^:]*:\(.*\)'`
    if [ -d "$dir" ]; then
        dir=`cd "$dir"; pwd`
    fi
    done
    if [ -n "$java" ]; then
        usejava="$java"
    fi
fi


#----------------------------------------------------------------------
# Ask for java binary
#----------------------------------------------------------------------
askjava=1
if [ "$usemyjre" != "no" -a -n "$myjre" ]; then
    while [ 1 = 1 ]; do
    echo
    echo "QF-Test's own JRE is located at:"
    echo $myjre
    echo -n "Should QF-Test use this JRE [Y/n]? "
    read answer rest
    case $answer in
        '' | y* | Y*)
        askjava=0
        break
        ;;
        n* | N*)
        usemyjre=no
        myjre=
        break
        ;;
    esac
    done
fi
if [ "$askjava" = 1 ]; then
    if [ -n "$usejava" ]; then
    while [ 1 = 1 ]; do
        echo
        echo QF-Test will be run using the following java executable:
        echo $usejava
        echo -n "Is this correct [Y/n]? "
        read answer rest
        case $answer in
        '' | y* | Y*)
            break
            ;;
        n* | N*)
            usejava=
            break
            ;;
        esac
    done
    else
    echo Cannot determine location of java executable
    fi

    if [ -z "$usejava" ]; then
        if [ -n "$myjre" ]; then
            # We get here if usemyjre was set to no in launcher.cfg, the
            # configured JRE is not usable but a local JRE exists
            while [ 1 = 1 ]; do
            echo
            echo "QF-Test's own JRE is located at:"
            echo $myjre
            echo -n "Should QF-Test use this JRE [Y/n]? "
            read answer rest
            case $answer in
                '' | y* | Y*)
                usemyjre=yes
                usejava="$myjre"
                break
                ;;
                n* | N*)
                usemyjre=no
                myjre=
                break
                ;;
            esac
            done
        fi
        if [ -z "$usejava" ]; then
            echo
            echo Please enter the location of the java executable
            read java
            if [ -n "$java" ]; then
            javacfg=1
            fi
        fi
    fi
fi
#----------------------------------------------------------------------
# Ask for the Java memory
#----------------------------------------------------------------------
memdefault=512
if [ -z "$javamem" ]; then
    current=
    javamem=$memdefault
else
    current=", current: $javamem"
fi

echo
echo "How much Memory should QF-Test be allowed to use in MB (standard: $memdefault$current)? "
read answer rest
case $answer in
    '')
    ;;
    *)
    javamem=`expr "$answer" : '\([0-9]*\).*$'`
    if [ -z "$javamem" ]; then
        javamem=$memdefault
    fi
    ;;
esac
echo "Using $javamem MB"


#----------------------------------------------------------------------
# Ask for the language for qftest
#----------------------------------------------------------------------
case "$lang" in
    '')
    ask="System"
    ;;
    de)
    ask="German"
    ;;
    en)
    ask="English"
    ;;
    *)
    ask=$lang
    ;;
esac

echo
echo "Which language setting should QF-Test use ($ask)"
echo -n "[(S)ystem/(E)nglish/(G)erman]? "
read answer rest
case $answer in
    '')
    ;;
    s | S | system | System | SYSTEM)
    lang=
    ;;
    e | E | english | English | ENGLISH)
    lang=en
    ;;
    g | G | german | German | GERMAN)
    lang=de
    ;;
    *)
    lang=$answer
    ;;
esac


# finally write the configuration file
echo Saving configuration to "$topdir/launcher.cfg"
rm -f "$topdir/launcher.cfg"
echo "# QF-Test startup configuration file" >> "$topdir/launcher.cfg"
if [ "$usemyjre" = no ]; then
    echo "usemyjre=no" >>  "$topdir/launcher.cfg"
elif [ -n "$myjre" ]; then
    echo "usemyjre=yes" >>  "$topdir/launcher.cfg"
fi
if [ -n "$javacfg" ]; then
    if [ "$usemyjre" != no ]; then
    echo "# The following java definition is used only if QF-Test's own JRE is removed" >> "$topdir/launcher.cfg"
    fi
    if [ -n "$java" ]; then
    echo "java=\"$java\"" >> "$topdir/launcher.cfg"
    fi
fi
if [ -n "$lang" ]; then
    echo "lang=$lang" >> "$topdir/launcher.cfg"
fi
if [ -n "$javamem" -a "$javamem" != "$memdefault" ]; then
    echo "javamem=$javamem" >> "$topdir/launcher.cfg"
fi


