// {{{ copyright

/********************************************************************
 *
 * Copyright (C) 2004 Gregor Schmid, Quality First Software
 * All rights reserved
 *
 *******************************************************************/

// }}}

package de.qfs.apps.qftest.demo.fx.carconfig.structures;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCParams;

/**
 * Sample JUnit Tests for CarConfigurator - JavaFX.
 *
 * @author QFS, mm
 */
public class UtilityTests
{

    public static String buggyMode = null;

    @Test
    public void isStandardUser()
    {
        CCModel model = CCModel.getInstance();
        CCControllerFX c = new CCControllerFX(model);
        model.setM_params(CCParams.builder().build());

        model.getM_params().setUser("tester");
        assertTrue(c.isStandardUser());
    }

    @Test
    public void isNoStandardUser()
    {
        CCModel model = CCModel.getInstance();
        CCControllerFX c = new CCControllerFX(model);
        model.setM_params(CCParams.builder().build());
        
        model.getM_params().setUser("myuser");
        assertFalse(c.isStandardUser());
    }

    @Test
    public void calculatePriceOk()
    {   CCModel model = CCModel.getInstance();
        CCControllerFX c = new CCControllerFX(model);
        model.setM_params(CCParams.builder().build());
        
        model.getM_params().setBuggy(buggyMode == null ? false : Boolean.parseBoolean(buggyMode));
        double result_price = c.calculatePriceOk(29000, 500, 100, 0, 0, 0);
        double expected_price = 29600.0;
        assertEquals(expected_price, result_price, 0);

    }

}
