/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.cde.CDE;
import org.eclipse.swt.internal.cde.DtActionArg;
import org.eclipse.swt.internal.gnome.GNOME;
import org.eclipse.swt.internal.gnome.GnomeVFSMimeApplication;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class Program {
    String name = "";
    String command;
    String iconPath;
    Display display;
    boolean gnomeExpectUri;
    static long modTime;
    static Map<String, List<String>> mimeTable;
    static long cdeShell;
    static final String[] CDE_ICON_EXT;
    static final String[] CDE_MASK_EXT;
    static final String DESKTOP_DATA = "Program_DESKTOP";
    static final String ICON_THEME_DATA = "Program_GNOME_ICON_THEME";
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";
    static final int DESKTOP_UNKNOWN = 0;
    static final int DESKTOP_GNOME = 1;
    static final int DESKTOP_GIO = 2;
    static final int DESKTOP_CDE = 3;
    static final int PREFERRED_ICON_SIZE = 16;

    Program() {
    }

    static int getDesktop(final Display display) {
        byte[] byArray;
        long l;
        if (display == null) {
            return 0;
        }
        Integer n = (Integer)display.getData(DESKTOP_DATA);
        if (n != null) {
            return n;
        }
        int n2 = 0;
        if (!OS.isX11()) {
            n2 = 2;
            display.setData(DESKTOP_DATA, n2);
            return n2;
        }
        long l2 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
        long l3 = OS.XDefaultRootWindow(l2);
        int[] nArray = new int[1];
        long l4 = OS.XListProperties(l2, l3, nArray);
        long[] lArray = new long[nArray[0]];
        if (l4 != 0L) {
            OS.memmove(lArray, l4, (long)(lArray.length * OS.PTR_SIZEOF));
            OS.XFree(l4);
        }
        if (n2 == 0 && (l = OS.XInternAtom(l2, byArray = Converter.wcsToMbcs(null, "_NET_SUPPORTING_WM_CHECK", true), true)) != 0L) {
            long l5;
            byte[] byArray2;
            int n3 = OS.RTLD_LAZY;
            if (OS.IsAIX) {
                byArray2 = Converter.wcsToMbcs(null, "libgio-2.0.a(libgio-2.0.so.0)", true);
                n3 |= 0x40000;
            } else {
                byArray2 = OS.IsHPUX ? Converter.wcsToMbcs(null, "libgio-2.0.so", true) : Converter.wcsToMbcs(null, "libgio-2.0.so.0", true);
            }
            long l6 = OS.dlopen(byArray2, n3);
            if (l6 != 0L) {
                byArray2 = Converter.wcsToMbcs(null, "g_app_info_launch_default_for_uri", true);
                l5 = OS.dlsym(l6, byArray2);
                if (l5 != 0L) {
                    n2 = 2;
                }
                OS.dlclose(l6);
            }
            if (n2 == 0 && Program.gnome_init()) {
                n2 = 1;
                l5 = GNOME.gnome_icon_theme_new();
                display.setData(ICON_THEME_DATA, new LONG(l5));
                display.addListener(12, new Listener(){

                    @Override
                    public void handleEvent(Event event) {
                        LONG lONG = (LONG)display.getData(Program.ICON_THEME_DATA);
                        if (lONG == null) {
                            return;
                        }
                        display.setData(Program.ICON_THEME_DATA, null);
                        if (lONG.value != 0L) {
                            OS.g_object_unref(lONG.value);
                        }
                    }
                });
            }
        }
        if (n2 == 0) {
            byArray = Converter.wcsToMbcs(null, "_DT_SM_PREFERENCES", true);
            l = OS.XInternAtom(l2, byArray, true);
            for (int i = 0; n2 == 0 && i < lArray.length; ++i) {
                if (lArray[i] == 0L || lArray[i] != l || !Program.cde_init(display)) continue;
                n2 = 3;
            }
        }
        display.setData(DESKTOP_DATA, n2);
        return n2;
    }

    boolean cde_execute(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, this.command, true);
        byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
        long l = OS.g_malloc(byArray2.length);
        OS.memmove(l, byArray2, (long)byArray2.length);
        DtActionArg dtActionArg = new DtActionArg();
        dtActionArg.argClass = 1;
        dtActionArg.name = l;
        long l2 = CDE.DtActionInvoke(cdeShell, byArray, dtActionArg, 1, null, null, null, 1, 0L, 0L);
        OS.g_free(l);
        return l2 != 0L;
    }

    static String cde_getAction(String string) {
        String string2 = null;
        String string3 = Program.cde_getAttribute(string, "ACTIONS");
        if (string3 != null) {
            int n = string3.indexOf("Open");
            string2 = n != -1 ? string3.substring(n, n + 4) : ((n = string3.indexOf(",")) != -1 ? string3.substring(0, n) : string3);
        }
        return string2;
    }

    static String cde_getAttribute(String string, String string2) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = Converter.wcsToMbcs(null, string, true);
        long l = CDE.DtDtsDataTypeToAttributeValue(byArray3, byArray2 = Converter.wcsToMbcs(null, string2, true), byArray = null);
        if (l == 0L) {
            return null;
        }
        int n = OS.strlen(l);
        byte[] byArray4 = new byte[n];
        OS.memmove(byArray4, l, (long)n);
        CDE.DtDtsFreeAttributeValue(l);
        return new String(Converter.mbcsToWcs(null, byArray4));
    }

    static Map<String, List<String>> cde_getDataTypeInfo() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        long l = CDE.DtDtsDataTypeNames();
        if (l != 0L) {
            int n = 0;
            long[] lArray = new long[1];
            OS.memmove(lArray, l + (long)(n++ * 4), 4L);
            while (lArray[0] != 0L) {
                int n2 = OS.strlen(lArray[0]);
                byte[] byArray = new byte[n2];
                OS.memmove(byArray, lArray[0], (long)n2);
                String string = new String(Converter.mbcsToWcs(null, byArray));
                String string2 = Program.cde_getExtension(string);
                if (!CDE.DtDtsDataTypeIsAction(byArray) && string2 != null && Program.cde_getAction(string) != null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string2);
                    hashMap.put(string, arrayList);
                }
                OS.memmove(lArray, l + (long)(n++ * 4), 4L);
            }
            CDE.DtDtsFreeDataTypeNames(l);
        }
        return hashMap;
    }

    static String cde_getExtension(String string) {
        String string2 = Program.cde_getAttribute(string, "NAME_TEMPLATE");
        if (string2 == null || string2.indexOf("%s.") == -1) {
            return null;
        }
        int n = string2.indexOf(".");
        return string2.substring(n);
    }

    ImageData cde_getImageData() {
        return null;
    }

    static String cde_getMimeType(String string) {
        String string2 = null;
        Map<String, List<String>> map = Program.cde_getDataTypeInfo();
        if (map == null) {
            return null;
        }
        Iterator<String> iterator = map.keySet().iterator();
        block0: while (string2 == null && iterator.hasNext()) {
            String string3 = iterator.next();
            List<String> list = map.get(string3);
            for (int i = 0; i < list.size(); ++i) {
                if (!string.equals(list.get(i))) continue;
                string2 = string3;
                continue block0;
            }
        }
        return string2;
    }

    static Program cde_getProgram(Display display, String string) {
        String string2 = Program.cde_getAction(string);
        if (string2 == null) {
            return null;
        }
        Program program = new Program();
        program.display = display;
        program.name = string;
        program.command = string2;
        program.iconPath = Program.cde_getAttribute(program.name, "ICON");
        return program;
    }

    static boolean cde_init(Display display) {
        try {
            Library.loadLibrary((String)"swt-cde");
        }
        catch (Throwable throwable) {
            return false;
        }
        CDE.XtToolkitInitialize();
        long l = CDE.XtCreateApplicationContext();
        long l2 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
        byte[] byArray = Converter.wcsToMbcs(null, "CDE", true);
        byte[] byArray2 = Converter.wcsToMbcs(null, "CDE", true);
        long[] lArray = new long[]{0L};
        CDE.XtDisplayInitialize(l, l2, byArray, byArray2, 0L, 0, lArray, 0);
        long l3 = CDE.topLevelShellWidgetClass();
        cdeShell = CDE.XtAppCreateShell(byArray, byArray2, l3, l2, null, 0);
        CDE.XtSetMappedWhenManaged(cdeShell, false);
        CDE.XtResizeWidget(cdeShell, 10, 10, 0);
        CDE.XtRealizeWidget(cdeShell);
        boolean bl = CDE.DtAppInitialize(l, l2, cdeShell, byArray, byArray);
        if (bl) {
            CDE.DtDbLoad();
        }
        return bl;
    }

    static boolean cde_isExecutable(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        return OS.access(byArray, 1) == 0;
    }

    static String[] parseCommand(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < string.length()) {
            int n2;
            while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            if (n >= string.length()) continue;
            if (string.charAt(n) == '\"' || string.charAt(n) == '\'') {
                for (n2 = n + 1; n2 < string.length() && string.charAt(n2) != string.charAt(n); ++n2) {
                }
                if (n2 >= string.length()) {
                    arrayList.add(string.substring(n, n2));
                } else {
                    arrayList.add(string.substring(n + 1, n2));
                }
                n = n2 + 1;
                continue;
            }
            for (n2 = n; n2 < string.length() && !Character.isWhitespace(string.charAt(n2)); ++n2) {
            }
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    boolean gnome_execute(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, this.name, true);
        long l = GNOME.gnome_vfs_mime_get_default_application(byArray);
        byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
        long l2 = GNOME.gnome_vfs_make_uri_from_input_with_dirs(byArray2, 2);
        long l3 = OS.g_list_append(0L, l2);
        int n = GNOME.gnome_vfs_mime_application_launch(l, l3);
        GNOME.gnome_vfs_mime_application_free(l);
        OS.g_free(l2);
        OS.g_list_free(l3);
        return n == 0;
    }

    static boolean gnome_launch(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = GNOME.gnome_vfs_make_uri_from_input_with_dirs(byArray, 2);
        int n = GNOME.gnome_vfs_url_show(l);
        OS.g_free(l);
        return n == 0;
    }

    ImageData gnome_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        try {
            return new ImageData(this.iconPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String gnome_getMimeType(String string) {
        int n;
        String string2 = null;
        String string3 = "swt" + string;
        byte[] byArray = Converter.wcsToMbcs(null, string3, true);
        long l = GNOME.gnome_vfs_mime_type_from_name(byArray);
        if (l != 0L && (n = OS.strlen(l)) > 0) {
            byte[] byArray2 = new byte[n];
            OS.memmove(byArray2, l, (long)n);
            string2 = new String(Converter.mbcsToWcs(null, byArray2));
        }
        return string2;
    }

    static Program gnome_getProgram(Display display, String string) {
        Program program = null;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = GNOME.gnome_vfs_mime_get_default_application(byArray);
        if (l != 0L) {
            byte[] byArray2;
            int n;
            program = new Program();
            program.display = display;
            program.name = string;
            GnomeVFSMimeApplication gnomeVFSMimeApplication = new GnomeVFSMimeApplication();
            GNOME.memmove(gnomeVFSMimeApplication, l, GnomeVFSMimeApplication.sizeof);
            if (gnomeVFSMimeApplication.command != 0L && (n = OS.strlen(gnomeVFSMimeApplication.command)) > 0) {
                byArray2 = new byte[n];
                OS.memmove(byArray2, gnomeVFSMimeApplication.command, (long)n);
                program.command = new String(Converter.mbcsToWcs(null, byArray2));
            }
            program.gnomeExpectUri = gnomeVFSMimeApplication.expects_uris == 0;
            n = OS.strlen(gnomeVFSMimeApplication.id);
            byArray2 = new byte[n + 1];
            OS.memmove(byArray2, gnomeVFSMimeApplication.id, (long)n);
            LONG lONG = (LONG)display.getData(ICON_THEME_DATA);
            long l2 = GNOME.gnome_icon_lookup(lONG.value, 0L, null, byArray2, 0L, byArray, 0, null);
            long l3 = 0L;
            if (l2 != 0L) {
                l3 = GNOME.gnome_icon_theme_lookup_icon(lONG.value, l2, 16, null, null);
            }
            if (l3 != 0L) {
                n = OS.strlen(l3);
                if (n > 0) {
                    byArray2 = new byte[n];
                    OS.memmove(byArray2, l3, (long)n);
                    program.iconPath = new String(Converter.mbcsToWcs(null, byArray2));
                }
                OS.g_free(l3);
            }
            if (l2 != 0L) {
                OS.g_free(l2);
            }
            GNOME.gnome_vfs_mime_application_free(l);
        }
        return program != null && program.command != null ? program : null;
    }

    static boolean gnome_init() {
        try {
            return GNOME.gnome_vfs_init();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean gnome_isExecutable(String string) {
        boolean bl;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (!GNOME.gnome_vfs_is_executable_command_string(byArray)) {
            return false;
        }
        long l = GNOME.gnome_vfs_make_uri_from_input(byArray);
        long l2 = GNOME.gnome_vfs_get_mime_type(l);
        OS.g_free(l);
        byte[] byArray2 = Converter.wcsToMbcs(null, "application/x-executable", true);
        boolean bl2 = bl = GNOME.gnome_vfs_mime_type_get_equivalence(l2, byArray2) != 0L;
        if (!bl) {
            byte[] byArray3 = Converter.wcsToMbcs(null, "application/x-shellscript", true);
            bl = GNOME.gnome_vfs_mime_type_get_equivalence(l2, byArray3) == 1L;
        }
        return bl;
    }

    public static Program findProgram(String string) {
        return Program.findProgram(Display.getCurrent(), string);
    }

    static Program findProgram(Display display, String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '.') {
            string = "." + string;
        }
        int n = Program.getDesktop(display);
        String string2 = null;
        switch (n) {
            case 2: {
                string2 = Program.gio_getMimeType(string);
                break;
            }
            case 1: {
                string2 = Program.gnome_getMimeType(string);
                break;
            }
            case 3: {
                string2 = Program.cde_getMimeType(string);
            }
        }
        if (string2 == null) {
            return null;
        }
        Program program = null;
        switch (n) {
            case 2: {
                program = Program.gio_getProgram(display, string2);
                break;
            }
            case 1: {
                program = Program.gnome_getProgram(display, string2);
                break;
            }
            case 3: {
                program = Program.cde_getProgram(display, string2);
            }
        }
        return program;
    }

    public static String[] getExtensions() {
        return Program.getExtensions(Display.getCurrent());
    }

    static String[] getExtensions(Display display) {
        int n = Program.getDesktop(display);
        Map<String, List<String>> map = null;
        switch (n) {
            case 2: {
                return Program.gio_getExtensions();
            }
            case 1: {
                break;
            }
            case 3: {
                map = Program.cde_getDataTypeInfo();
            }
        }
        if (map == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : map.keySet()) {
            List<String> list = map.get(string);
            for (int i = 0; i < list.size(); ++i) {
                if (arrayList.contains(list.get(i))) continue;
                arrayList.add(list.get(i));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    static Program[] getPrograms(Display display) {
        int n = Program.getDesktop(display);
        Map<String, List<String>> map = null;
        switch (n) {
            case 2: {
                return Program.gio_getPrograms(display);
            }
            case 1: {
                break;
            }
            case 3: {
                map = Program.cde_getDataTypeInfo();
            }
        }
        if (map == null) {
            return new Program[0];
        }
        ArrayList<Program> arrayList = new ArrayList<Program>();
        for (String string : map.keySet()) {
            Program program = null;
            switch (n) {
                case 3: {
                    program = Program.cde_getProgram(display, string);
                }
            }
            if (program == null) continue;
            arrayList.add(program);
        }
        return arrayList.toArray(new Program[arrayList.size()]);
    }

    ImageData gio_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        ImageData imageData = null;
        long l = OS.gtk_icon_theme_get_default();
        byte[] byArray = Converter.wcsToMbcs(null, this.iconPath, true);
        long l2 = OS.g_icon_new_for_string(byArray, null);
        if (l2 != 0L) {
            long l3 = OS.gtk_icon_theme_lookup_by_gicon(l, l2, 16, 0);
            if (l3 != 0L) {
                long l4 = OS.gtk_icon_info_load_icon(l3, null);
                if (l4 != 0L) {
                    int n = OS.gdk_pixbuf_get_rowstride(l4);
                    long l5 = OS.gdk_pixbuf_get_pixels(l4);
                    int n2 = OS.gdk_pixbuf_get_height(l4);
                    int n3 = OS.gdk_pixbuf_get_width(l4);
                    boolean bl = OS.gdk_pixbuf_get_has_alpha(l4);
                    byte[] byArray2 = new byte[n * n2];
                    OS.memmove(byArray2, l5, (long)byArray2.length);
                    OS.g_object_unref(l4);
                    if (bl) {
                        PaletteData paletteData = new PaletteData(-16777216, 0xFF0000, 65280);
                        imageData = new ImageData(n3, n2, 32, paletteData, 4, byArray2);
                        imageData.bytesPerLine = n;
                        int n4 = 3;
                        int n5 = 0;
                        byte[] byArray3 = new byte[n3 * n2];
                        for (int i = 0; i < n2; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                byArray3[n5++] = byArray2[n4];
                                byArray2[n4] = 0;
                                n4 += 4;
                            }
                        }
                        imageData.alphaData = byArray3;
                    } else {
                        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
                        imageData = new ImageData(n3, n2, 24, paletteData, 4, byArray2);
                        imageData.bytesPerLine = n;
                    }
                }
                OS.gtk_icon_info_free(l3);
            }
            OS.g_object_unref(l2);
        }
        return imageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, List<String>> gio_getMimeInfo() {
        long l = 0L;
        long l2 = 0L;
        byte[] byArray = Converter.wcsToMbcs(null, "/usr/share/mime/globs", true);
        l = OS.g_file_new_for_path(byArray);
        long l3 = OS.g_file_read(l, 0L, 0L);
        try {
            if (l3 != 0L) {
                long[] lArray = new long[2];
                byArray = Converter.wcsToMbcs(null, "*", true);
                l2 = OS.g_file_query_info(l, byArray, 0L, 0L, 0L);
                OS.g_file_info_get_modification_time(l2, lArray);
                if (modTime != 0L && lArray[0] == modTime) {
                    Map<String, List<String>> map = mimeTable;
                    return map;
                }
                mimeTable = new HashMap<String, List<String>>();
                modTime = lArray[0];
                long l4 = OS.g_data_input_stream_new(l3);
                long[] lArray2 = new long[1];
                if (l4 != 0L) {
                    long l5 = OS.g_data_input_stream_read_line(l4, lArray2, 0L, 0L);
                    while (l5 != 0L) {
                        byte[] byArray2 = new byte[(int)lArray2[0]];
                        OS.memmove(byArray2, l5, (long)((int)lArray2[0]));
                        String string = new String(Converter.mbcsToWcs(null, byArray2));
                        int n = string.indexOf(58);
                        if (n > 0) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            String string2 = string.substring(0, n);
                            String string3 = string.substring(n + 1);
                            int n2 = string3.indexOf(".");
                            if (n2 > 0) {
                                String string4 = string3.substring(n2);
                                if (mimeTable.containsKey(string4)) {
                                    List<String> list = mimeTable.get(string4);
                                    arrayList.addAll(list);
                                }
                                arrayList.add(string2);
                                mimeTable.put(string4, arrayList);
                            }
                        }
                        OS.g_free(l5);
                        l5 = OS.g_data_input_stream_read_line(l4, lArray2, 0L, 0L);
                    }
                }
                if (l4 != 0L) {
                    OS.g_object_unref(l4);
                }
                Map<String, List<String>> map = mimeTable;
                return map;
            }
            Map<String, List<String>> map = null;
            return map;
        }
        finally {
            if (l2 != 0L) {
                OS.g_object_unref(l2);
            }
            if (l3 != 0L) {
                OS.g_object_unref(l3);
            }
            if (l != 0L) {
                OS.g_object_unref(l);
            }
        }
    }

    static String gio_getMimeType(String string) {
        String string2 = null;
        Map<String, List<String>> map = Program.gio_getMimeInfo();
        if (map != null && map.containsKey(string)) {
            List<String> list = map.get(string);
            string2 = list.get(0);
        }
        return string2;
    }

    static Program gio_getProgram(Display display, String string) {
        Program program = null;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = OS.g_app_info_get_default_for_type(byArray, false);
        if (l != 0L) {
            program = Program.gio_getProgram(display, l);
        }
        return program;
    }

    static Program gio_getProgram(Display display, long l) {
        long l2;
        byte[] byArray;
        int n;
        Program program = new Program();
        program.display = display;
        long l3 = OS.g_app_info_get_name(l);
        if (l3 != 0L && (n = OS.strlen(l3)) > 0) {
            byArray = new byte[n];
            OS.memmove(byArray, l3, (long)n);
            program.name = new String(Converter.mbcsToWcs(null, byArray));
        }
        if ((l2 = OS.g_app_info_get_executable(l)) != 0L && (n = OS.strlen(l2)) > 0) {
            byArray = new byte[n];
            OS.memmove(byArray, l2, (long)n);
            program.command = new String(Converter.mbcsToWcs(null, byArray));
        }
        program.gnomeExpectUri = OS.g_app_info_supports_uris(l);
        long l4 = OS.g_app_info_get_icon(l);
        if (l4 != 0L) {
            long l5 = OS.g_icon_to_string(l4);
            if (l5 != 0L) {
                n = OS.strlen(l5);
                if (n > 0) {
                    byArray = new byte[n];
                    OS.memmove(byArray, l5, (long)n);
                    program.iconPath = new String(Converter.mbcsToWcs(null, byArray));
                }
                OS.g_free(l5);
            }
            OS.g_object_unref(l4);
        }
        return program.command != null ? program : null;
    }

    static Program[] gio_getPrograms(Display display) {
        long l;
        long l2 = l = OS.g_app_info_get_all();
        ArrayList<Program> arrayList = new ArrayList<Program>();
        while (l2 != 0L) {
            Program program;
            long l3 = OS.g_list_data(l2);
            if (l3 != 0L && (program = Program.gio_getProgram(display, l3)) != null) {
                arrayList.add(program);
            }
            l2 = OS.g_list_next(l2);
        }
        if (l != 0L) {
            OS.g_list_free(l);
        }
        Program[] programArray = new Program[arrayList.size()];
        for (int i = 0; i < programArray.length; ++i) {
            programArray[i] = (Program)arrayList.get(i);
        }
        return programArray;
    }

    static boolean gio_isExecutable(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.g_file_test(byArray, 4)) {
            return false;
        }
        if (!OS.g_file_test(byArray, 8)) {
            return false;
        }
        long l = OS.g_file_new_for_path(byArray);
        boolean bl = false;
        if (l != 0L) {
            byte[] byArray2 = Converter.wcsToMbcs(null, "*", true);
            long l2 = OS.g_file_query_info(l, byArray2, 0L, 0L, 0L);
            if (l2 != 0L) {
                byte[] byArray3;
                long l3 = OS.g_file_info_get_content_type(l2);
                if (l3 != 0L && !(bl = OS.g_content_type_is_a(l3, byArray3 = Converter.wcsToMbcs(null, "application/x-executable", true)))) {
                    byte[] byArray4 = Converter.wcsToMbcs(null, "application/x-shellscript", true);
                    bl = OS.g_content_type_equals(l3, byArray4);
                }
                OS.g_object_unref(l2);
            }
            OS.g_object_unref(l);
        }
        return bl;
    }

    static boolean gio_launch(String string) {
        boolean bl = false;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = OS.g_file_new_for_commandline_arg(byArray);
        if (l != 0L) {
            long l2 = OS.g_file_get_uri(l);
            if (l2 != 0L) {
                bl = OS.g_app_info_launch_default_for_uri(l2, 0L, 0L);
                OS.g_free(l2);
            }
            OS.g_object_unref(l);
        }
        return bl;
    }

    boolean gio_execute(String string) {
        byte[] byArray;
        boolean bl = false;
        byte[] byArray2 = Converter.wcsToMbcs(null, this.command, true);
        long l = OS.g_app_info_create_from_commandline(byArray2, byArray = Converter.wcsToMbcs(null, this.name, true), this.gnomeExpectUri ? 2L : 0L, 0L);
        if (l != 0L) {
            byte[] byArray3 = Converter.wcsToMbcs(null, string, true);
            long l2 = 0L;
            if (string.length() > 0) {
                l2 = OS.g_app_info_supports_uris(l) ? OS.g_file_new_for_uri(byArray3) : OS.g_file_new_for_path(byArray3);
            }
            long l3 = 0L;
            if (l2 != 0L) {
                l3 = OS.g_list_append(0L, l2);
            }
            bl = OS.g_app_info_launch(l, l3, 0L, 0L);
            if (l3 != 0L) {
                OS.g_list_free(l3);
                OS.g_object_unref(l2);
            }
            OS.g_object_unref(l);
        }
        return bl;
    }

    static String[] gio_getExtensions() {
        Map<String, List<String>> map = Program.gio_getMimeInfo();
        if (map == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static boolean isExecutable(Display display, String string) {
        switch (Program.getDesktop(display)) {
            case 2: {
                return Program.gio_isExecutable(string);
            }
            case 1: {
                return Program.gnome_isExecutable(string);
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    public static boolean launch(String string) {
        return Program.launch(Display.getCurrent(), string, null);
    }

    public static boolean launch(String string, String string2) {
        return Program.launch(Display.getCurrent(), string, string2);
    }

    static boolean launch(Display display, String string, String string2) {
        String string3;
        Program program;
        if (string == null) {
            SWT.error(4);
        }
        if (string2 != null && Program.isExecutable(display, string)) {
            try {
                Compatibility.exec(new String[]{string}, null, string2);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        switch (Program.getDesktop(display)) {
            case 2: {
                if (Program.gio_launch(string)) {
                    return true;
                }
            }
            case 1: {
                if (!Program.gnome_launch(string)) break;
                return true;
            }
        }
        int n = string.lastIndexOf(46);
        if (n != -1 && (program = Program.findProgram(display, string3 = string.substring(n))) != null && program.execute(string)) {
            return true;
        }
        string3 = string.toLowerCase();
        if (string3.startsWith(PREFIX_HTTP) || string3.startsWith(PREFIX_HTTPS)) {
            program = Program.findProgram(display, ".html");
            if (program == null) {
                program = Program.findProgram(display, ".htm");
            }
            if (program != null && program.execute(string)) {
                return true;
            }
        }
        try {
            Compatibility.exec(new String[]{string}, null, string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Program)) {
            return false;
        }
        Program program = (Program)object;
        return this.display == program.display && this.name.equals(program.name) && this.command.equals(program.command);
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = Program.getDesktop(this.display);
        switch (n) {
            case 2: {
                return this.gio_execute(string);
            }
            case 1: {
                return this.gnome_execute(string);
            }
            case 3: {
                return this.cde_execute(string);
            }
        }
        return false;
    }

    public ImageData getImageData() {
        switch (Program.getDesktop(this.display)) {
            case 2: {
                return this.gio_getImageData();
            }
            case 1: {
                return this.gnome_getImageData();
            }
            case 3: {
                return this.cde_getImageData();
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.display.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }

    static {
        CDE_ICON_EXT = new String[]{".m.pm", ".l.pm", ".s.pm", ".t.pm"};
        CDE_MASK_EXT = new String[]{".m_m.bm", ".l_m.bm", ".s_m.bm", ".t_m.bm"};
    }
}

