/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    long groupHandle;
    long labelHandle;
    long imageHandle;
    long boxHandle;
    int accelerator;
    int userId;
    String toolTipText;

    public MenuItem(Menu menu, int n) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.createWidget(menu.getItemCount());
    }

    public MenuItem(Menu menu, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        int n3 = menu.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.createWidget(n2);
    }

    void addAccelerator(long l) {
        this.updateAccelerator(l, true);
    }

    void addAccelerators(long l) {
        this.addAccelerator(l);
        if (this.menu != null) {
            this.menu.addAccelerators(l);
        }
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return MenuItem.checkBits(n, 8, 32, 16, 2, 64, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int n) {
        boolean bl;
        long l;
        this.state |= 8;
        byte[] byArray = new byte[1];
        int n2 = 122;
        switch (this.style & n2) {
            case 2: {
                this.handle = OS.gtk_separator_menu_item_new();
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            case 16: {
                if (OS.GTK_VERSION <= OS.VERSION(3, 10, 8)) {
                    byArray = new byte[]{32, 0};
                }
                this.groupHandle = OS.gtk_radio_menu_item_new(0L);
                if (this.groupHandle == 0L) {
                    this.error(2);
                }
                OS.g_object_ref(this.groupHandle);
                OS.g_object_ref_sink(this.groupHandle);
                l = OS.gtk_radio_menu_item_get_group(this.groupHandle);
                if (OS.GTK3) {
                    this.handle = OS.gtk_radio_menu_item_new(l);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = OS.gtk_accel_label_new(byArray);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if (!OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = OS.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                    break;
                }
                this.handle = OS.gtk_radio_menu_item_new_with_label(l, byArray);
                break;
            }
            case 32: {
                if (OS.GTK3) {
                    this.handle = OS.gtk_check_menu_item_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = OS.gtk_accel_label_new(byArray);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if (!OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = OS.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                    break;
                }
                this.handle = OS.gtk_check_menu_item_new_with_label(byArray);
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            case 64: {
                if (OS.GTK3) {
                    this.handle = OS.gtk_menu_item_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = OS.gtk_accel_label_new(byArray);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if ((this.parent.style & n2) == 2 || !OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = OS.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                    break;
                }
            }
            default: {
                if (OS.GTK3) {
                    this.handle = OS.gtk_menu_item_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = OS.gtk_accel_label_new(byArray);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if (!OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = OS.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                    break;
                }
                this.handle = OS.gtk_image_menu_item_new_with_label(byArray);
            }
        }
        if (this.imageHandle != 0L) {
            if (OS.SWT_PADDED_MENU_ITEMS) {
                OS.gtk_image_set_pixel_size(this.imageHandle, 16);
            }
            OS.gtk_container_add(this.boxHandle, this.imageHandle);
            OS.gtk_widget_show(this.imageHandle);
        }
        if (this.labelHandle != 0L) {
            if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                OS.gtk_label_set_xalign(this.labelHandle, 0.0f);
                OS.gtk_widget_set_halign(this.labelHandle, 0);
            } else {
                OS.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.0f);
            }
            OS.gtk_box_pack_end(this.boxHandle, this.labelHandle, true, true, 0);
            OS.gtk_widget_show(this.labelHandle);
        }
        if (this.boxHandle != 0L) {
            OS.gtk_container_add(this.handle, this.boxHandle);
            OS.gtk_widget_show(this.boxHandle);
        }
        if ((this.style & 2) == 0) {
            if (this.boxHandle == 0L) {
                this.labelHandle = OS.gtk_bin_get_child(this.handle);
            }
            OS.gtk_accel_label_set_accel_widget(this.labelHandle, 0L);
        }
        if (!(bl = OS.gtk_widget_get_sensitive(l = this.parent.handle))) {
            OS.gtk_widget_set_sensitive(l, true);
        }
        OS.gtk_menu_shell_insert(l, this.handle, n);
        if (!bl) {
            OS.gtk_widget_set_sensitive(l, false);
        }
        OS.gtk_widget_show(this.handle);
    }

    void fixMenus(Decorations decorations) {
        if (this.menu != null) {
            this.menu.fixMenus(decorations);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    long getAccelGroup() {
        Menu menu = this.parent;
        while (menu != null && menu.cascade != null) {
            menu = menu.cascade.parent;
        }
        if (menu == null) {
            return 0L;
        }
        Decorations decorations = menu.parent;
        if (decorations == null) {
            return 0L;
        }
        return decorations.menuBar == menu ? decorations.accelGroup : 0L;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!this.gtk_widget_get_mapped(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, gtkAllocation);
        int n = gtkAllocation.x;
        int n2 = gtkAllocation.y;
        int n3 = gtkAllocation.width;
        int n4 = gtkAllocation.height;
        return new Rectangle(n, n2, n3, n4);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.gtk_widget_get_sensitive(this.handle);
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    @Override
    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.gtk_check_menu_item_get_active(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    long gtk_activate(long l) {
        if ((this.style & 0x40) != 0 && this.menu != null) {
            return 0L;
        }
        if (!this.isEnabled()) {
            return 0L;
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13);
        return 0L;
    }

    @Override
    long gtk_select(long l) {
        this.parent.selectedItem = this;
        this.sendEvent(30);
        return 0L;
    }

    @Override
    long gtk_show_help(long l, long l2) {
        boolean bl = this.hooks(28);
        if (bl) {
            this.postEvent(28);
        } else {
            bl = this.parent.sendHelpEvent(l2);
        }
        if (bl) {
            OS.gtk_menu_shell_deactivate(this.parent.handle);
            return 1L;
        }
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
        OS.g_signal_connect_closure(this.handle, OS.select, this.display.getClosure(44), false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            if (this.menu.selectedItem == this) {
                this.menu.selectedItem = null;
            }
            this.menu.dispose();
        }
        this.menu = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerator(l);
        }
        if (this.groupHandle != 0L) {
            OS.g_object_unref(this.groupHandle);
        }
        this.groupHandle = 0L;
        this.accelerator = 0;
        this.parent = null;
    }

    void removeAccelerator(long l) {
        this.updateAccelerator(l, false);
    }

    void removeAccelerators(long l) {
        this.removeAccelerator(l);
        if (this.menu != null) {
            this.menu.removeAccelerators(l);
        }
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void reskinChildren(int n) {
        if (this.menu != null) {
            this.menu.reskin(n);
        }
        super.reskinChildren(n);
    }

    void selectRadio() {
        MenuItem[] menuItemArray = this.parent.getItems();
        for (int i = 0; i < menuItemArray.length && menuItemArray[i] != this; ++i) {
        }
        for (int i = i - 1; i >= 0 && menuItemArray[i].setRadioSelection(false); --i) {
        }
        for (int i = i + 1; i < menuItemArray.length && menuItemArray[i].setRadioSelection(false); ++i) {
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n) {
        this.checkWidget();
        if (this.accelerator == n) {
            return;
        }
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerator(l);
        }
        this.accelerator = n;
        if (l != 0L) {
            this.addAccelerator(l);
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (OS.gtk_widget_get_sensitive(this.handle) == bl) {
            return;
        }
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerator(l);
        }
        OS.gtk_widget_set_sensitive(this.handle, bl);
        if (l != 0L) {
            this.addAccelerator(l);
        }
    }

    public void setID(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        this.userId = n;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
            long l = imageList.getPixbuf(n);
            if (OS.GTK3) {
                if (!OS.GTK_IS_MENU_ITEM(this.handle)) {
                    return;
                }
                if (OS.SWT_PADDED_MENU_ITEMS && this.imageHandle != 0L) {
                    OS.gtk_image_set_from_pixbuf(this.imageHandle, l);
                } else {
                    if (this.imageHandle == 0L && this.boxHandle != 0L) {
                        this.imageHandle = OS.gtk_image_new_from_pixbuf(l);
                        OS.gtk_container_add(this.boxHandle, this.imageHandle);
                        OS.gtk_box_reorder_child(this.boxHandle, this.imageHandle, 0);
                    } else {
                        OS.gtk_image_set_from_pixbuf(this.imageHandle, l);
                    }
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                }
            } else {
                if (!OS.GTK_IS_IMAGE_MENU_ITEM(this.handle)) {
                    return;
                }
                this.imageHandle = OS.gtk_image_new_from_pixbuf(l);
                OS.gtk_image_menu_item_set_image(this.handle, this.imageHandle);
            }
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            OS.gtk_widget_show(this.imageHandle);
        } else if (OS.GTK3) {
            if (this.imageHandle != 0L && this.boxHandle != 0L) {
                if (OS.SWT_PADDED_MENU_ITEMS) {
                    OS.gtk_container_remove(this.boxHandle, this.imageHandle);
                    this.imageHandle = OS.gtk_image_new();
                    if (this.imageHandle == 0L) {
                        this.error(2);
                    }
                    OS.gtk_image_set_pixel_size(this.imageHandle, 16);
                    OS.gtk_container_add(this.boxHandle, this.imageHandle);
                    OS.gtk_widget_show(this.imageHandle);
                } else {
                    OS.gtk_container_remove(this.boxHandle, this.imageHandle);
                    this.imageHandle = 0L;
                }
            }
        } else {
            if (!OS.GTK_IS_IMAGE_MENU_ITEM(this.handle)) {
                return;
            }
            OS.gtk_image_menu_item_set_image(this.handle, 0L);
        }
    }

    public void setMenu(Menu menu) {
        Menu menu2;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((menu2 = this.menu) == menu) {
            return;
        }
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerators(l);
        }
        if (menu2 != null) {
            menu2.cascade = null;
            OS.g_object_ref(menu2.handle);
            OS.gtk_menu_item_set_submenu(this.handle, 0L);
        }
        if ((this.menu = menu) != null) {
            menu.cascade = this;
            OS.gtk_menu_item_set_submenu(this.handle, menu.handle);
        }
        if (l != 0L) {
            this.addAccelerators(l);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.parent.style & 0x4000000) != 0 || !bl) {
            int n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            OS.gtk_widget_set_direction(this.handle, n);
            OS.gtk_container_forall(this.handle, this.display.setDirectionProc, n);
            if (this.menu != null) {
                this.menu._setOrientation(this.parent.style & 0x6000000);
            }
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
        OS.gtk_check_menu_item_set_active(this.handle, bl);
        if ((this.style & 0x10) != 0) {
            OS.gtk_check_menu_item_set_active(this.groupHandle, !bl);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        String string2 = "";
        int n = string.indexOf(9);
        if (n != -1) {
            boolean bl = (this.parent.style & 0x4000000) != 0;
            string2 = (bl ? "" : "  ") + string.substring(n + 1, string.length()) + (bl ? "  " : "");
            string = string.substring(0, n);
        }
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        if (this.boxHandle == 0L && !OS.GTK3) {
            this.labelHandle = OS.gtk_bin_get_child(this.handle);
        }
        if (this.labelHandle != 0L && OS.GTK_IS_LABEL(this.labelHandle)) {
            OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
            if (OS.GTK_IS_ACCEL_LABEL(this.labelHandle)) {
                if (OS.GTK3) {
                    if (OS.GTK_VERSION >= OS.VERSION(3, 6, 0)) {
                        MaskKeysym maskKeysym = this.getMaskKeysym();
                        if (maskKeysym != null) {
                            OS.gtk_accel_label_set_accel_widget(this.labelHandle, this.handle);
                            OS.gtk_accel_label_set_accel(this.labelHandle, maskKeysym.keysym, maskKeysym.mask);
                        }
                    } else {
                        this.setAccelLabel(this.labelHandle, string2);
                    }
                } else {
                    this.setAccelLabel(this.labelHandle, string2);
                }
                OS.g_signal_emit_by_name(this.handle, OS.accel_closures_changed);
            }
        }
    }

    private void setAccelLabel(long l, String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l2 = OS.g_malloc(byArray.length);
        OS.memmove(l2, byArray, (long)byArray.length);
        long l3 = OS.GTK_ACCEL_LABEL_GET_ACCEL_STRING(l);
        OS.GTK_ACCEL_LABEL_SET_ACCEL_STRING(l, l2);
        if (l3 != 0L) {
            OS.g_free(l3);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string != null && (string.trim().length() == 0 || string.equals(this.toolTipText))) {
            return;
        }
        this.toolTipText = string;
        this.parent.getShell().setToolTipText(this.handle, this.toolTipText);
    }

    void updateAccelerator(long l, boolean bl) {
        int n;
        int n2;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return;
        }
        int n3 = 0;
        if ((this.accelerator & 0x10000) != 0) {
            n3 |= 8;
        }
        if ((this.accelerator & 0x20000) != 0) {
            n3 |= 1;
        }
        if ((this.accelerator & 0x40000) != 0) {
            n3 |= 4;
        }
        if ((n2 = Display.untranslateKey(n = this.accelerator & 0x100FFFF)) != 0) {
            n = n2;
        } else {
            switch (n) {
                case 13: {
                    n = 65293;
                    break;
                }
                default: {
                    n = Display.wcsToMbcs((char)n);
                }
            }
        }
        if (n != 0) {
            if (bl) {
                OS.gtk_widget_add_accelerator(this.handle, OS.activate, l, n, n3, 1);
            } else {
                OS.gtk_widget_remove_accelerator(this.handle, l, n, n3);
            }
        }
    }

    private MaskKeysym getMaskKeysym() {
        if (this.text == null) {
            return null;
        }
        MaskKeysym maskKeysym = new MaskKeysym();
        int n = this.text.indexOf(9);
        if (n == -1) {
            return null;
        }
        int n2 = n + 1;
        int n3 = this.text.indexOf(43, n2);
        while (n3 != -1) {
            String string = this.text.substring(n2, n3);
            if (string.equals("Ctrl")) {
                maskKeysym.mask |= 4;
            }
            if (string.equals("Shift")) {
                maskKeysym.mask |= 1;
            }
            if (string.equals("Alt")) {
                maskKeysym.mask |= 8;
            }
            n2 = n3 + 1;
            n3 = this.text.indexOf(43, n2);
        }
        if ("Enter".equals(this.text.substring(n2))) {
            maskKeysym.keysym = 65076;
        }
        block0 : switch (this.text.length() - n2) {
            case 1: {
                maskKeysym.keysym = this.text.charAt(n2);
                maskKeysym.keysym = Display.wcsToMbcs((char)maskKeysym.keysym);
                break;
            }
            case 2: {
                if (this.text.charAt(n2) != 'F') break;
                switch (this.text.charAt(n2 + 1)) {
                    case '1': {
                        maskKeysym.keysym = 65470;
                        break;
                    }
                    case '2': {
                        maskKeysym.keysym = 65471;
                        break;
                    }
                    case '3': {
                        maskKeysym.keysym = 65472;
                        break;
                    }
                    case '4': {
                        maskKeysym.keysym = 65473;
                        break;
                    }
                    case '5': {
                        maskKeysym.keysym = 65474;
                        break;
                    }
                    case '6': {
                        maskKeysym.keysym = 65475;
                        break;
                    }
                    case '7': {
                        maskKeysym.keysym = 65476;
                        break;
                    }
                    case '8': {
                        maskKeysym.keysym = 65477;
                        break;
                    }
                    case '9': {
                        maskKeysym.keysym = 65478;
                    }
                }
                break;
            }
            case 3: {
                if (this.text.charAt(n2) != 'F' || this.text.charAt(n2 + 1) != '1') break;
                switch (this.text.charAt(n2 + 2)) {
                    case '0': {
                        maskKeysym.keysym = 65479;
                        break block0;
                    }
                    case '1': {
                        maskKeysym.keysym = 65480;
                        break block0;
                    }
                    case '2': {
                        maskKeysym.keysym = 65481;
                        break block0;
                    }
                    case '3': {
                        maskKeysym.keysym = 65482;
                        break block0;
                    }
                    case '4': {
                        maskKeysym.keysym = 65483;
                        break block0;
                    }
                    case '5': {
                        maskKeysym.keysym = 65484;
                    }
                }
            }
        }
        return maskKeysym;
    }

    boolean updateAcceleratorText(boolean bl) {
        if (this.accelerator != 0) {
            return false;
        }
        MaskKeysym maskKeysym = null;
        if (bl) {
            maskKeysym = this.getMaskKeysym();
        }
        if (maskKeysym == null) {
            return true;
        }
        if (maskKeysym.keysym != 0) {
            long l = this.getAccelGroup();
            if (bl) {
                OS.gtk_widget_add_accelerator(this.handle, OS.activate, l, maskKeysym.keysym, maskKeysym.mask, 1);
            } else {
                OS.gtk_widget_remove_accelerator(this.handle, l, maskKeysym.keysym, maskKeysym.mask);
            }
        }
        return maskKeysym.keysym != 0;
    }

    private class MaskKeysym {
        int mask = 0;
        int keysym = 0;

        private MaskKeysym() {
        }
    }
}

