/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.cde.CDE;
import org.eclipse.swt.internal.cde.DtActionArg;
import org.eclipse.swt.internal.gnome.GNOME;
import org.eclipse.swt.internal.gnome.GnomeVFSMimeApplication;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class Program {
    String name;
    String command;
    String iconPath;
    Display display;
    boolean gnomeExpectUri;
    static long modTime;
    static Hashtable mimeTable;
    static long cdeShell;
    static final String[] CDE_ICON_EXT;
    static final String[] CDE_MASK_EXT;
    static final String DESKTOP_DATA = "Program_DESKTOP";
    static final String ICON_THEME_DATA = "Program_GNOME_ICON_THEME";
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";
    static final int DESKTOP_UNKNOWN = 0;
    static final int DESKTOP_GNOME = 1;
    static final int DESKTOP_GNOME_24 = 2;
    static final int DESKTOP_GIO = 3;
    static final int DESKTOP_CDE = 4;
    static final int PREFERRED_ICON_SIZE = 16;

    Program() {
    }

    static int getDesktop(final Display display) {
        byte[] byArray;
        long l;
        if (display == null) {
            return 0;
        }
        Integer n = (Integer)display.getData(DESKTOP_DATA);
        if (n != null) {
            return n;
        }
        int n2 = 0;
        long l2 = OS.GDK_DISPLAY();
        long l3 = OS.XDefaultRootWindow(l2);
        int[] nArray = new int[1];
        long l4 = OS.XListProperties(l2, l3, nArray);
        long[] lArray = new long[nArray[0]];
        if (l4 != 0L) {
            OS.memmove(lArray, l4, (long)(lArray.length * OS.PTR_SIZEOF));
            OS.XFree(l4);
        }
        if (n2 == 0 && (l = OS.XInternAtom(l2, byArray = Converter.wcsToMbcs(null, "_NET_SUPPORTING_WM_CHECK", true), true)) != 0L) {
            long l5;
            byte[] byArray2;
            int n3 = OS.RTLD_LAZY;
            if (OS.IsAIX) {
                byArray2 = Converter.wcsToMbcs(null, "libgio-2.0.a(libgio-2.0.so.0)", true);
                n3 |= 0x40000;
            } else {
                byArray2 = OS.IsHPUX ? Converter.wcsToMbcs(null, "libgio-2.0.so", true) : Converter.wcsToMbcs(null, "libgio-2.0.so.0", true);
            }
            long l6 = OS.dlopen(byArray2, n3);
            if (l6 != 0L) {
                byArray2 = Converter.wcsToMbcs(null, "g_app_info_launch_default_for_uri", true);
                l5 = OS.dlsym(l6, byArray2);
                if (l5 != 0L) {
                    n2 = 3;
                }
                OS.dlclose(l6);
            }
            if (n2 == 0 && OS.GTK_VERSION >= OS.VERSION(2, 2, 0) && Program.gnome_init()) {
                n2 = 1;
                l5 = GNOME.gnome_icon_theme_new();
                display.setData(ICON_THEME_DATA, new LONG(l5));
                display.addListener(12, new Listener(){

                    public void handleEvent(Event event) {
                        LONG lONG = (LONG)display.getData(Program.ICON_THEME_DATA);
                        if (lONG == null) {
                            return;
                        }
                        display.setData(Program.ICON_THEME_DATA, null);
                        if (lONG.value != 0L) {
                            OS.g_object_unref(lONG.value);
                        }
                    }
                });
                byArray2 = Converter.wcsToMbcs(null, "libgnomevfs-2.so.0", true);
                long l7 = OS.dlopen(byArray2, OS.RTLD_LAZY);
                if (l7 != 0L) {
                    byArray2 = Converter.wcsToMbcs(null, "gnome_vfs_url_show", true);
                    long l8 = OS.dlsym(l7, byArray2);
                    if (l8 != 0L) {
                        n2 = 2;
                    }
                    OS.dlclose(l7);
                }
            }
        }
        if (n2 == 0) {
            byArray = Converter.wcsToMbcs(null, "_DT_SM_PREFERENCES", true);
            l = OS.XInternAtom(l2, byArray, true);
            for (int i = 0; n2 == 0 && i < lArray.length; ++i) {
                if (lArray[i] == 0L || lArray[i] != l || !Program.cde_init(display)) continue;
                n2 = 4;
            }
        }
        display.setData(DESKTOP_DATA, new Integer(n2));
        return n2;
    }

    boolean cde_execute(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, this.command, true);
        byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
        long l = OS.g_malloc(byArray2.length);
        OS.memmove(l, byArray2, (long)byArray2.length);
        DtActionArg dtActionArg = new DtActionArg();
        dtActionArg.argClass = 1;
        dtActionArg.name = l;
        long l2 = CDE.DtActionInvoke(cdeShell, byArray, dtActionArg, 1, null, null, null, 1, 0L, 0L);
        OS.g_free(l);
        return l2 != 0L;
    }

    static String cde_getAction(String string) {
        String string2 = null;
        String string3 = Program.cde_getAttribute(string, "ACTIONS");
        if (string3 != null) {
            int n = string3.indexOf("Open");
            string2 = n != -1 ? string3.substring(n, n + 4) : ((n = string3.indexOf(",")) != -1 ? string3.substring(0, n) : string3);
        }
        return string2;
    }

    static String cde_getAttribute(String string, String string2) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = Converter.wcsToMbcs(null, string, true);
        long l = CDE.DtDtsDataTypeToAttributeValue(byArray3, byArray2 = Converter.wcsToMbcs(null, string2, true), byArray = null);
        if (l == 0L) {
            return null;
        }
        int n = OS.strlen(l);
        byte[] byArray4 = new byte[n];
        OS.memmove(byArray4, l, (long)n);
        CDE.DtDtsFreeAttributeValue(l);
        return new String(Converter.mbcsToWcs(null, byArray4));
    }

    static Hashtable cde_getDataTypeInfo() {
        Hashtable hashtable = new Hashtable();
        long l = CDE.DtDtsDataTypeNames();
        if (l != 0L) {
            int n = 0;
            long[] lArray = new long[1];
            OS.memmove(lArray, l + (long)(n++ * 4), 4L);
            while (lArray[0] != 0L) {
                int n2 = OS.strlen(lArray[0]);
                byte[] byArray = new byte[n2];
                OS.memmove(byArray, lArray[0], (long)n2);
                String string = new String(Converter.mbcsToWcs(null, byArray));
                String string2 = Program.cde_getExtension(string);
                if (!CDE.DtDtsDataTypeIsAction(byArray) && string2 != null && Program.cde_getAction(string) != null) {
                    Vector<String> vector = new Vector<String>();
                    vector.addElement(string2);
                    hashtable.put(string, vector);
                }
                OS.memmove(lArray, l + (long)(n++ * 4), 4L);
            }
            CDE.DtDtsFreeDataTypeNames(l);
        }
        return hashtable;
    }

    static String cde_getExtension(String string) {
        String string2 = Program.cde_getAttribute(string, "NAME_TEMPLATE");
        if (string2 == null || string2.indexOf("%s.") == -1) {
            return null;
        }
        int n = string2.indexOf(".");
        return string2.substring(n);
    }

    ImageData cde_getImageData() {
        return null;
    }

    static String cde_getMimeType(String string) {
        String string2 = null;
        Hashtable hashtable = Program.cde_getDataTypeInfo();
        if (hashtable == null) {
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        block0: while (string2 == null && enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string3);
            for (int i = 0; i < vector.size(); ++i) {
                if (!string.equals(vector.elementAt(i))) continue;
                string2 = string3;
                continue block0;
            }
        }
        return string2;
    }

    static Program cde_getProgram(Display display, String string) {
        Program program = new Program();
        program.display = display;
        program.name = string;
        program.command = Program.cde_getAction(string);
        program.iconPath = Program.cde_getAttribute(program.name, "ICON");
        return program;
    }

    static boolean cde_init(Display display) {
        try {
            Library.loadLibrary("swt-cde");
        }
        catch (Throwable throwable) {
            return false;
        }
        CDE.XtToolkitInitialize();
        long l = CDE.XtCreateApplicationContext();
        long l2 = OS.GDK_DISPLAY();
        byte[] byArray = Converter.wcsToMbcs(null, "CDE", true);
        byte[] byArray2 = Converter.wcsToMbcs(null, "CDE", true);
        long[] lArray = new long[]{0L};
        CDE.XtDisplayInitialize(l, l2, byArray, byArray2, 0L, 0, lArray, 0);
        long l3 = CDE.topLevelShellWidgetClass();
        cdeShell = CDE.XtAppCreateShell(byArray, byArray2, l3, l2, null, 0);
        CDE.XtSetMappedWhenManaged(cdeShell, false);
        CDE.XtResizeWidget(cdeShell, 10, 10, 0);
        CDE.XtRealizeWidget(cdeShell);
        boolean bl = CDE.DtAppInitialize(l, l2, cdeShell, byArray, byArray);
        if (bl) {
            CDE.DtDbLoad();
        }
        return bl;
    }

    static boolean cde_isExecutable(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        return OS.access(byArray, 1) == 0;
    }

    static String[] parseCommand(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < string.length()) {
            int n2;
            while (n < string.length() && Compatibility.isWhitespace(string.charAt(n))) {
                ++n;
            }
            if (n >= string.length()) continue;
            if (string.charAt(n) == '\"' || string.charAt(n) == '\'') {
                for (n2 = n + 1; n2 < string.length() && string.charAt(n2) != string.charAt(n); ++n2) {
                }
                if (n2 >= string.length()) {
                    vector.addElement(string.substring(n, n2));
                } else {
                    vector.addElement(string.substring(n + 1, n2));
                }
                n = n2 + 1;
                continue;
            }
            for (n2 = n; n2 < string.length() && !Compatibility.isWhitespace(string.charAt(n2)); ++n2) {
            }
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    boolean gnome_24_execute(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, this.name, true);
        long l = GNOME.gnome_vfs_mime_get_default_application(byArray);
        byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
        long l2 = GNOME.gnome_vfs_make_uri_from_input_with_dirs(byArray2, 2);
        long l3 = GNOME.g_list_append(0L, l2);
        int n = GNOME.gnome_vfs_mime_application_launch(l, l3);
        GNOME.gnome_vfs_mime_application_free(l);
        GNOME.g_free(l2);
        GNOME.g_list_free(l3);
        return n == 0;
    }

    static boolean gnome_24_launch(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = GNOME.gnome_vfs_make_uri_from_input_with_dirs(byArray, 2);
        int n = GNOME.gnome_vfs_url_show(l);
        GNOME.g_free(l);
        return n == 0;
    }

    boolean gnome_execute(String string) {
        int n;
        Object object;
        int n2;
        String[] stringArray;
        long l;
        if (this.gnomeExpectUri && (l = GNOME.gnome_vfs_make_uri_from_input((byte[])(stringArray = (String[])Converter.wcsToMbcs(null, string, true)))) != 0L) {
            n2 = OS.strlen(l);
            if (n2 > 0) {
                object = new byte[n2];
                OS.memmove((byte[])object, l, (long)n2);
                string = new String(Converter.mbcsToWcs(null, (byte[])object));
            }
            GNOME.g_free(l);
        }
        stringArray = Program.parseCommand(this.command);
        int n3 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            n2 = stringArray[n].indexOf("%f");
            if (n2 == -1) continue;
            object = stringArray[n];
            n3 = n;
            stringArray[n] = ((String)object).substring(0, n2) + string + ((String)object).substring(n2 + 2);
        }
        if (string.length() > 0 && n3 < 0) {
            String[] stringArray2 = new String[stringArray.length + 1];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n] = stringArray[n];
            }
            stringArray2[stringArray.length] = string;
            stringArray = stringArray2;
        }
        try {
            Compatibility.exec(stringArray);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    ImageData gnome_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        try {
            return new ImageData(this.iconPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Hashtable gnome_getMimeInfo() {
        long l;
        Hashtable hashtable = new Hashtable();
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long l2 = l = GNOME.gnome_vfs_get_registered_mime_types();
        while (l2 != 0L) {
            OS.memmove(lArray, l2, (long)OS.PTR_SIZEOF);
            long l3 = lArray[0];
            int n = OS.strlen(l3);
            byte[] byArray = new byte[n];
            OS.memmove(byArray, l3, (long)n);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            long l4 = GNOME.gnome_vfs_mime_get_extensions_list(l3);
            if (l4 != 0L) {
                Vector<String> vector = new Vector<String>();
                long l5 = l4;
                while (l5 != 0L) {
                    OS.memmove(lArray2, l5, (long)OS.PTR_SIZEOF);
                    long l6 = lArray2[0];
                    int n2 = OS.strlen(l6);
                    byte[] byArray2 = new byte[n2];
                    OS.memmove(byArray2, l6, (long)n2);
                    String string2 = new String(Converter.mbcsToWcs(null, byArray2));
                    string2 = '.' + string2;
                    vector.addElement(string2);
                    l5 = GNOME.g_list_next(l5);
                }
                GNOME.gnome_vfs_mime_extensions_list_free(l4);
                if (vector.size() > 0) {
                    hashtable.put(string, vector);
                }
            }
            l2 = GNOME.g_list_next(l2);
        }
        if (l != 0L) {
            GNOME.gnome_vfs_mime_registered_mime_type_list_free(l);
        }
        return hashtable;
    }

    static String gnome_getMimeType(String string) {
        int n;
        String string2 = null;
        String string3 = "swt" + string;
        byte[] byArray = Converter.wcsToMbcs(null, string3, true);
        long l = GNOME.gnome_vfs_mime_type_from_name(byArray);
        if (l != 0L && (n = OS.strlen(l)) > 0) {
            byte[] byArray2 = new byte[n];
            OS.memmove(byArray2, l, (long)n);
            string2 = new String(Converter.mbcsToWcs(null, byArray2));
        }
        return string2;
    }

    static Program gnome_getProgram(Display display, String string) {
        Program program = null;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = GNOME.gnome_vfs_mime_get_default_application(byArray);
        if (l != 0L) {
            program = new Program();
            program.display = display;
            program.name = string;
            GnomeVFSMimeApplication gnomeVFSMimeApplication = new GnomeVFSMimeApplication();
            GNOME.memmove(gnomeVFSMimeApplication, l, GnomeVFSMimeApplication.sizeof);
            int n = OS.strlen(gnomeVFSMimeApplication.command);
            byte[] byArray2 = new byte[n];
            OS.memmove(byArray2, gnomeVFSMimeApplication.command, (long)n);
            program.command = new String(Converter.mbcsToWcs(null, byArray2));
            program.gnomeExpectUri = gnomeVFSMimeApplication.expects_uris == 0;
            n = OS.strlen(gnomeVFSMimeApplication.id);
            byArray2 = new byte[n + 1];
            OS.memmove(byArray2, gnomeVFSMimeApplication.id, (long)n);
            LONG lONG = (LONG)display.getData(ICON_THEME_DATA);
            long l2 = GNOME.gnome_icon_lookup(lONG.value, 0L, null, byArray2, 0L, byArray, 0, null);
            long l3 = 0L;
            if (l2 != 0L) {
                l3 = GNOME.gnome_icon_theme_lookup_icon(lONG.value, l2, 16, null, null);
            }
            if (l3 != 0L) {
                n = OS.strlen(l3);
                if (n > 0) {
                    byArray2 = new byte[n];
                    OS.memmove(byArray2, l3, (long)n);
                    program.iconPath = new String(Converter.mbcsToWcs(null, byArray2));
                }
                GNOME.g_free(l3);
            }
            if (l2 != 0L) {
                GNOME.g_free(l2);
            }
            GNOME.gnome_vfs_mime_application_free(l);
        }
        return program;
    }

    static boolean gnome_init() {
        try {
            return GNOME.gnome_vfs_init();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean gnome_isExecutable(String string) {
        boolean bl;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (!GNOME.gnome_vfs_is_executable_command_string(byArray)) {
            return false;
        }
        long l = GNOME.gnome_vfs_make_uri_from_input(byArray);
        long l2 = GNOME.gnome_vfs_get_mime_type(l);
        GNOME.g_free(l);
        byte[] byArray2 = Converter.wcsToMbcs(null, "application/x-executable", true);
        boolean bl2 = bl = GNOME.gnome_vfs_mime_type_get_equivalence(l2, byArray2) != 0L;
        if (!bl) {
            byte[] byArray3 = Converter.wcsToMbcs(null, "application/x-shellscript", true);
            bl = GNOME.gnome_vfs_mime_type_get_equivalence(l2, byArray3) == 1L;
        }
        return bl;
    }

    public static Program findProgram(String string) {
        return Program.findProgram(Display.getCurrent(), string);
    }

    static Program findProgram(Display display, String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '.') {
            string = "." + string;
        }
        int n = Program.getDesktop(display);
        String string2 = null;
        switch (n) {
            case 3: {
                string2 = Program.gio_getMimeType(string);
                break;
            }
            case 1: 
            case 2: {
                string2 = Program.gnome_getMimeType(string);
                break;
            }
            case 4: {
                string2 = Program.cde_getMimeType(string);
            }
        }
        if (string2 == null) {
            return null;
        }
        Program program = null;
        switch (n) {
            case 3: {
                program = Program.gio_getProgram(display, string2);
                break;
            }
            case 1: 
            case 2: {
                program = Program.gnome_getProgram(display, string2);
                break;
            }
            case 4: {
                program = Program.cde_getProgram(display, string2);
            }
        }
        return program;
    }

    public static String[] getExtensions() {
        return Program.getExtensions(Display.getCurrent());
    }

    static String[] getExtensions(Display display) {
        String[] stringArray;
        int n = Program.getDesktop(display);
        Hashtable hashtable = null;
        switch (n) {
            case 3: {
                return Program.gio_getExtensions();
            }
            case 2: {
                break;
            }
            case 1: {
                hashtable = Program.gnome_getMimeInfo();
                break;
            }
            case 4: {
                hashtable = Program.cde_getDataTypeInfo();
            }
        }
        if (hashtable == null) {
            return new String[0];
        }
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            Vector vector2 = (Vector)hashtable.get(stringArray);
            for (int i = 0; i < vector2.size(); ++i) {
                if (vector.contains(vector2.elementAt(i))) continue;
                vector.addElement(vector2.elementAt(i));
            }
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    static Program[] getPrograms(Display display) {
        Program[] programArray;
        int n = Program.getDesktop(display);
        Hashtable hashtable = null;
        switch (n) {
            case 3: {
                return Program.gio_getPrograms(display);
            }
            case 2: {
                break;
            }
            case 1: {
                hashtable = Program.gnome_getMimeInfo();
                break;
            }
            case 4: {
                hashtable = Program.cde_getDataTypeInfo();
            }
        }
        if (hashtable == null) {
            return new Program[0];
        }
        Vector<Program> vector = new Vector<Program>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            programArray = (Program[])enumeration.nextElement();
            Program program = null;
            switch (n) {
                case 1: {
                    program = Program.gnome_getProgram(display, (String)programArray);
                    break;
                }
                case 4: {
                    program = Program.cde_getProgram(display, (String)programArray);
                }
            }
            if (program == null) continue;
            vector.addElement(program);
        }
        programArray = new Program[vector.size()];
        for (int i = 0; i < programArray.length; ++i) {
            programArray[i] = (Program)vector.elementAt(i);
        }
        return programArray;
    }

    ImageData gio_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        ImageData imageData = null;
        long l = OS.gtk_icon_theme_get_default();
        byte[] byArray = Converter.wcsToMbcs(null, this.iconPath, true);
        long l2 = OS.g_icon_new_for_string(byArray, null);
        if (l2 != 0L) {
            long l3 = OS.gtk_icon_theme_lookup_by_gicon(l, l2, 16, 0);
            if (l3 != 0L) {
                long l4 = OS.gtk_icon_info_load_icon(l3, null);
                if (l4 != 0L) {
                    int n = OS.gdk_pixbuf_get_rowstride(l4);
                    long l5 = OS.gdk_pixbuf_get_pixels(l4);
                    int n2 = OS.gdk_pixbuf_get_height(l4);
                    int n3 = OS.gdk_pixbuf_get_width(l4);
                    boolean bl = OS.gdk_pixbuf_get_has_alpha(l4);
                    byte[] byArray2 = new byte[n * n2];
                    OS.memmove(byArray2, l5, (long)byArray2.length);
                    OS.g_object_unref(l4);
                    if (bl) {
                        PaletteData paletteData = new PaletteData(-16777216, 0xFF0000, 65280);
                        imageData = new ImageData(n3, n2, 32, paletteData, 4, byArray2);
                        imageData.bytesPerLine = n;
                        int n4 = 3;
                        int n5 = 0;
                        byte[] byArray3 = new byte[n3 * n2];
                        for (int i = 0; i < n2; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                byArray3[n5++] = byArray2[n4];
                                byArray2[n4] = 0;
                                n4 += 4;
                            }
                        }
                        imageData.alphaData = byArray3;
                    } else {
                        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
                        imageData = new ImageData(n3, n2, 24, paletteData, 4, byArray2);
                        imageData.bytesPerLine = n;
                    }
                }
                OS.gtk_icon_info_free(l3);
            }
            OS.g_object_unref(l2);
        }
        return imageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Hashtable gio_getMimeInfo() {
        Hashtable hashtable;
        long l;
        long l2;
        block22: {
            long l3;
            block18: {
                Hashtable hashtable2;
                block21: {
                    long[] lArray;
                    block19: {
                        Hashtable hashtable3;
                        block20: {
                            l2 = 0L;
                            l3 = 0L;
                            byte[] byArray = Converter.wcsToMbcs(null, "/usr/share/mime/globs", true);
                            l2 = OS.g_file_new_for_path(byArray);
                            l = OS.g_file_read(l2, 0L, 0L);
                            if (l == 0L) break block18;
                            lArray = new long[2];
                            byArray = Converter.wcsToMbcs(null, "*", true);
                            l3 = OS.g_file_query_info(l2, byArray, 0L, 0L, 0L);
                            OS.g_file_info_get_modification_time(l3, lArray);
                            if (modTime == 0L || lArray[0] != modTime) break block19;
                            hashtable3 = mimeTable;
                            Object var23_8 = null;
                            if (l3 == 0L) break block20;
                            OS.g_object_unref(l3);
                        }
                        if (l != 0L) {
                            OS.g_object_unref(l);
                        }
                        if (l2 != 0L) {
                            OS.g_object_unref(l2);
                        }
                        return hashtable3;
                    }
                    try {
                        mimeTable = new Hashtable();
                        modTime = lArray[0];
                        long l4 = OS.g_data_input_stream_new(l);
                        int[] nArray = new int[1];
                        if (l4 != 0L) {
                            long l5 = OS.g_data_input_stream_read_line(l4, nArray, 0L, 0L);
                            while (l5 != 0L) {
                                byte[] byArray = new byte[nArray[0]];
                                OS.memmove(byArray, l5, (long)nArray[0]);
                                String string = new String(Converter.mbcsToWcs(null, byArray));
                                int n = string.indexOf(58);
                                if (n > 0) {
                                    Vector<String> vector = new Vector<String>();
                                    String string2 = string.substring(0, n);
                                    String string3 = string.substring(n + 1);
                                    int n2 = string3.indexOf(".");
                                    if (n2 > 0) {
                                        String string4 = string3.substring(n2);
                                        vector.add(string2);
                                        if (mimeTable.containsKey(string4)) {
                                            Vector vector2 = (Vector)mimeTable.get(string4);
                                            vector.addAll(vector2);
                                        }
                                        mimeTable.put(string4, vector);
                                    }
                                }
                                OS.g_free(l5);
                                l5 = OS.g_data_input_stream_read_line(l4, nArray, 0L, 0L);
                            }
                        }
                        if (l4 != 0L) {
                            OS.g_object_unref(l4);
                        }
                        hashtable2 = mimeTable;
                        Object var23_9 = null;
                        if (l3 == 0L) break block21;
                    }
                    catch (Throwable throwable) {
                        block23: {
                            Object var23_11 = null;
                            if (l3 != 0L) {
                                OS.g_object_unref(l3);
                            }
                            if (l != 0L) {
                                OS.g_object_unref(l);
                            }
                            if (l2 == 0L) break block23;
                            OS.g_object_unref(l2);
                        }
                        throw throwable;
                    }
                    OS.g_object_unref(l3);
                }
                if (l != 0L) {
                    OS.g_object_unref(l);
                }
                if (l2 != 0L) {
                    OS.g_object_unref(l2);
                }
                return hashtable2;
            }
            hashtable = null;
            Object var23_10 = null;
            if (l3 == 0L) break block22;
            OS.g_object_unref(l3);
        }
        if (l != 0L) {
            OS.g_object_unref(l);
        }
        if (l2 != 0L) {
            OS.g_object_unref(l2);
        }
        return hashtable;
    }

    static String gio_getMimeType(String string) {
        String string2 = null;
        Hashtable hashtable = Program.gio_getMimeInfo();
        if (hashtable != null && hashtable.containsKey(string)) {
            Vector vector = (Vector)hashtable.get(string);
            string2 = (String)vector.get(0);
        }
        return string2;
    }

    static Program gio_getProgram(Display display, String string) {
        Program program = null;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = OS.g_app_info_get_default_for_type(byArray, false);
        if (l != 0L) {
            program = Program.gio_getProgram(display, l);
        }
        return program;
    }

    static Program gio_getProgram(Display display, long l) {
        long l2;
        byte[] byArray;
        int n;
        Program program = new Program();
        program.display = display;
        long l3 = OS.g_app_info_get_name(l);
        if (l3 != 0L && (n = OS.strlen(l3)) > 0) {
            byArray = new byte[n];
            OS.memmove(byArray, l3, (long)n);
            program.name = new String(Converter.mbcsToWcs(null, byArray));
        }
        if ((l2 = OS.g_app_info_get_executable(l)) != 0L && (n = OS.strlen(l2)) > 0) {
            byArray = new byte[n];
            OS.memmove(byArray, l2, (long)n);
            program.command = new String(Converter.mbcsToWcs(null, byArray));
        }
        program.gnomeExpectUri = OS.g_app_info_supports_uris(l);
        long l4 = OS.g_app_info_get_icon(l);
        if (l4 != 0L) {
            long l5 = OS.g_icon_to_string(l4);
            if (l5 != 0L) {
                n = OS.strlen(l5);
                if (n > 0) {
                    byArray = new byte[n];
                    OS.memmove(byArray, l5, (long)n);
                    program.iconPath = new String(Converter.mbcsToWcs(null, byArray));
                }
                OS.g_free(l5);
            }
            OS.g_object_unref(l4);
        }
        return program;
    }

    static Program[] gio_getPrograms(Display display) {
        long l;
        long l2 = l = OS.g_app_info_get_all();
        Vector<Program> vector = new Vector<Program>();
        while (l2 != 0L) {
            Program program;
            long l3 = OS.g_list_data(l2);
            if (l3 != 0L && (program = Program.gio_getProgram(display, l3)) != null) {
                vector.addElement(program);
            }
            l2 = OS.g_list_next(l2);
        }
        if (l != 0L) {
            OS.g_list_free(l);
        }
        Program[] programArray = new Program[vector.size()];
        for (int i = 0; i < programArray.length; ++i) {
            programArray[i] = (Program)vector.elementAt(i);
        }
        return programArray;
    }

    static boolean gio_isExecutable(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.g_file_test(byArray, 4)) {
            return false;
        }
        if (!OS.g_file_test(byArray, 8)) {
            return false;
        }
        long l = OS.g_file_new_for_path(byArray);
        boolean bl = false;
        if (l != 0L) {
            byte[] byArray2 = Converter.wcsToMbcs(null, "*", true);
            long l2 = OS.g_file_query_info(l, byArray2, 0L, 0L, 0L);
            if (l2 != 0L) {
                byte[] byArray3;
                long l3 = OS.g_file_info_get_content_type(l2);
                if (l3 != 0L && !(bl = OS.g_content_type_is_a(l3, byArray3 = Converter.wcsToMbcs(null, "application/x-executable", true)))) {
                    byte[] byArray4 = Converter.wcsToMbcs(null, "application/x-shellscript", true);
                    bl = OS.g_content_type_equals(l3, byArray4);
                }
                OS.g_object_unref(l2);
            }
            OS.g_object_unref(l);
        }
        return bl;
    }

    static boolean gio_launch(String string) {
        boolean bl = false;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l = OS.g_file_new_for_path(byArray);
        if (l != 0L) {
            long l2 = OS.g_file_get_uri(l);
            if (l2 != 0L) {
                bl = OS.g_app_info_launch_default_for_uri(l2, 0L, 0L);
                OS.g_free(l2);
            }
            OS.g_object_unref(l);
        }
        return bl;
    }

    boolean gio_execute(String string) {
        byte[] byArray;
        boolean bl = false;
        byte[] byArray2 = Converter.wcsToMbcs(null, this.command, true);
        long l = OS.g_app_info_create_from_commandline(byArray2, byArray = Converter.wcsToMbcs(null, this.name, true), this.gnomeExpectUri ? 2L : 0L, 0L);
        if (l != 0L) {
            byte[] byArray3 = Converter.wcsToMbcs(null, string, true);
            long l2 = 0L;
            if (string.length() > 0) {
                l2 = OS.g_app_info_supports_uris(l) ? OS.g_file_new_for_uri(byArray3) : OS.g_file_new_for_path(byArray3);
            }
            long l3 = 0L;
            if (l2 != 0L) {
                l3 = OS.g_list_append(0L, l2);
            }
            bl = OS.g_app_info_launch(l, l3, 0L, 0L);
            if (l3 != 0L) {
                OS.g_list_free(l3);
                OS.g_object_unref(l2);
            }
            OS.g_object_unref(l);
        }
        return bl;
    }

    static String[] gio_getExtensions() {
        String[] stringArray;
        Hashtable hashtable = Program.gio_getMimeInfo();
        if (hashtable == null) {
            return new String[0];
        }
        Vector<String[]> vector = new Vector<String[]>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    static boolean isExecutable(Display display, String string) {
        switch (Program.getDesktop(display)) {
            case 3: {
                return Program.gio_isExecutable(string);
            }
            case 1: 
            case 2: {
                return Program.gnome_isExecutable(string);
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    public static boolean launch(String string) {
        return Program.launch(Display.getCurrent(), string, null);
    }

    public static boolean launch(String string, String string2) {
        return Program.launch(Display.getCurrent(), string, string2);
    }

    static boolean launch(Display display, String string, String string2) {
        String string3;
        Program program;
        if (string == null) {
            SWT.error(4);
        }
        if (string2 != null && Program.isExecutable(display, string)) {
            try {
                Compatibility.exec(new String[]{string}, null, string2);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        switch (Program.getDesktop(display)) {
            case 3: {
                if (Program.gio_launch(string)) {
                    return true;
                }
            }
            case 2: {
                if (!Program.gnome_24_launch(string)) break;
                return true;
            }
        }
        int n = string.lastIndexOf(46);
        if (n != -1 && (program = Program.findProgram(display, string3 = string.substring(n))) != null && program.execute(string)) {
            return true;
        }
        string3 = string.toLowerCase();
        if (string3.startsWith(PREFIX_HTTP) || string3.startsWith(PREFIX_HTTPS)) {
            program = Program.findProgram(display, ".html");
            if (program == null) {
                program = Program.findProgram(display, ".htm");
            }
            if (program != null && program.execute(string)) {
                return true;
            }
        }
        try {
            Compatibility.exec(new String[]{string}, null, string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Program)) {
            return false;
        }
        Program program = (Program)object;
        return this.display == program.display && this.name.equals(program.name) && this.command.equals(program.command);
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = Program.getDesktop(this.display);
        switch (n) {
            case 3: {
                return this.gio_execute(string);
            }
            case 2: {
                return this.gnome_24_execute(string);
            }
            case 1: {
                return this.gnome_execute(string);
            }
            case 4: {
                return this.cde_execute(string);
            }
        }
        return false;
    }

    public ImageData getImageData() {
        switch (Program.getDesktop(this.display)) {
            case 3: {
                return this.gio_getImageData();
            }
            case 1: 
            case 2: {
                return this.gnome_getImageData();
            }
            case 4: {
                return this.cde_getImageData();
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.display.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }

    static {
        CDE_ICON_EXT = new String[]{".m.pm", ".l.pm", ".s.pm", ".t.pm"};
        CDE_MASK_EXT = new String[]{".m_m.bm", ".l_m.bm", ".s_m.bm", ".t_m.bm"};
    }
}

