/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import java.util.Arrays;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Text
extends Scrollable {
    long bufferHandle;
    long imContext;
    int tabs = 8;
    int lastEventTime = 0;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    boolean doubleClick;
    String message = "";
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    int[] segments;
    static final int ITER_SIZEOF = GTK.GtkTextIter_sizeof();
    static final int SPACE_FOR_CURSOR = 1;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";
    GdkRGBA background;
    long indexMark = 0L;
    double cachedAdjustment;
    double currentAdjustment;
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.Text");

    public Text(Composite composite, int n) {
        super(composite, Text.checkStyle(n));
        if ((n & 0x80) != 0) {
            this.style |= 0x300;
            if ((n & 0x200) == 0) {
                this.style &= 0xFFFFFDFF;
                GTK.gtk_entry_set_icon_from_icon_name((long)this.handle, (int)0, null);
            } else {
                GTK.gtk_entry_set_icon_activatable((long)this.handle, (int)0, (boolean)true);
                GTK.gtk_entry_set_icon_sensitive((long)this.handle, (int)0, (boolean)true);
            }
            if ((n & 0x100) == 0) {
                this.style &= 0xFFFFFEFF;
            }
        }
    }

    static int checkStyle(int n) {
        if ((n & 0x80) != 0) {
            n |= 0x804;
            n &= 0xFFBFFFFF;
        }
        if ((n & 4) != 0 && (n & 2) != 0) {
            n &= 0xFFFFFFFD;
        }
        if (((n = Text.checkBits((int)n, (int)16384, (int)0x1000000, (int)131072, (int)0, (int)0, (int)0)) & 4) != 0) {
            n &= 0xFFFFFCBF;
        }
        if ((n & 0x40) != 0) {
            n |= 2;
            n &= 0xFFFFFEFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFBFFFFF;
        }
        if ((n & 6) != 0) {
            return n;
        }
        if ((n & 0x300) != 0) {
            return n | 2;
        }
        return n | 4;
    }

    void createHandle(int n) {
        this.state |= 0x28;
        if ((this.style & 8) != 0 && this.applyThemeBackground() == 1) {
            this.state |= 0x10000;
        }
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.gtk_widget_set_has_surface_or_window(this.fixedHandle, true);
        if ((this.style & 4) != 0) {
            this.handle = (this.style & 0x80) != 0 ? GTK.gtk_search_entry_new() : GTK.gtk_entry_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            GTK.gtk_container_add((long)this.fixedHandle, (long)this.handle);
            GTK.gtk_editable_set_editable((long)this.handle, ((this.style & 8) == 0 ? 1 : 0) != 0);
            if (GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
                if ((this.style & 0x800) == 0) {
                    GTK.gtk_entry_set_has_frame((long)this.handle, (boolean)false);
                    long l = GTK.gtk_widget_get_style_context((long)this.handle);
                    String string = this.display.gtk_rgba_to_css_string(this.display.COLOR_LIST_BACKGROUND_RGBA);
                    this.gtk_css_provider_load_from_css(l, "entry {border: solid; background: " + string + ";}");
                    GTK.gtk_style_context_invalidate((long)l);
                }
            } else {
                GTK.gtk_entry_set_has_frame((long)this.handle, ((this.style & 0x800) != 0 ? 1 : 0) != 0);
            }
            GTK.gtk_entry_set_visibility((long)this.handle, ((this.style & 0x400000) == 0 ? 1 : 0) != 0);
            float f = 0.0f;
            if ((this.style & 0x1000000) != 0) {
                f = 0.5f;
            }
            if ((this.style & 0x20000) != 0) {
                f = 1.0f;
            }
            if (f > 0.0f) {
                GTK.gtk_entry_set_alignment((long)this.handle, (float)f);
            }
        } else {
            this.scrolledHandle = GTK.gtk_scrolled_window_new((long)0L, (long)0L);
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
            this.handle = GTK.gtk_text_view_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.bufferHandle = GTK.gtk_text_view_get_buffer((long)this.handle);
            if (this.bufferHandle == 0L) {
                this.error(2);
            }
            GTK.gtk_container_add((long)this.fixedHandle, (long)this.scrolledHandle);
            GTK.gtk_container_add((long)this.scrolledHandle, (long)this.handle);
            GTK.gtk_text_view_set_editable((long)this.handle, ((this.style & 8) == 0 ? 1 : 0) != 0);
            if ((this.style & 0x40) != 0) {
                GTK.gtk_text_view_set_wrap_mode((long)this.handle, (int)3);
            }
            int n2 = (this.style & 0x100) != 0 ? 0 : 2;
            int n3 = (this.style & 0x200) != 0 ? 0 : 2;
            GTK.gtk_scrolled_window_set_policy((long)this.scrolledHandle, (int)n2, (int)n3);
            if ((this.style & 0x800) != 0) {
                GTK.gtk_scrolled_window_set_shadow_type((long)this.scrolledHandle, (int)3);
            }
            int n4 = 0;
            if ((this.style & 0x1000000) != 0) {
                n4 = 2;
            }
            if ((this.style & 0x20000) != 0) {
                n4 = 1;
            }
            GTK.gtk_text_view_set_justification((long)this.handle, (int)n4);
        }
        this.imContext = OS.imContextLast();
        if ((this.style & 4) != 0) {
            GTK.gtk_entry_set_width_chars((long)this.handle, (int)6);
        }
        this.setFontDescription(this.defaultFont().handle);
    }

    int applyThemeBackground() {
        return this.backgroundAlpha == 0 || (this.style & 0xB00) == 0 ? 1 : 0;
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.doubleClick = true;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)modifyListener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, (Listener)new TypedListener((SWTEventListener)segmentListener));
        this.clearSegments(true);
        this.applySegments();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)selectionListener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)verifyListener);
        this.addListener(25, (Listener)typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)false);
        this.clearSegments(true);
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_insert_text((long)this.handle, (byte[])byArray, (int)byArray.length, (int[])new int[]{-1});
            GTK.gtk_editable_set_position((long)this.handle, (int)-1);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_end_iter((long)this.bufferHandle, (byte[])byArray2);
            GTK.gtk_text_buffer_insert((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray, (int)byArray.length);
            GTK.gtk_text_buffer_place_cursor((long)this.bufferHandle, (byte[])byArray2);
            long l = GTK.gtk_text_buffer_get_insert((long)this.bufferHandle);
            GTK.gtk_text_view_scroll_to_mark((long)this.handle, (long)l, (double)0.0, (boolean)true, (double)0.0, (double)0.0);
        }
        this.applySegments();
    }

    void applySegments() {
        int n;
        String string;
        if (this.isDisposed() || !this.hooks(49) && !this.filters(49)) {
            return;
        }
        Event event = new Event();
        event.text = string = this.getText();
        event.segments = this.segments;
        this.sendEvent(49, event);
        this.segments = event.segments;
        if (this.segments == null) {
            return;
        }
        int n2 = this.segments.length;
        if (n2 == 0) {
            return;
        }
        int n3 = n = string == null ? 0 : string.length();
        for (int i = 1; i < n2; ++i) {
            if (event.segments[i] >= event.segments[i - 1] && event.segments[i] <= n) continue;
            this.error(5);
        }
        char[] cArray = event.segmentsChars;
        char[] cArray2 = new char[]{this.getOrientation() == 0x4000000 ? (char)'\u200f' : '\u200e'};
        if ((this.style & 4) != 0) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            int n4 = GTK.gtk_entry_get_max_length((long)this.handle);
            if (n4 != 0) {
                GTK.gtk_entry_set_max_length((long)this.handle, (int)this.translateOffset(n4));
            }
            int[] nArray = new int[1];
            for (int i = 0; i < n2; ++i) {
                nArray[0] = this.segments[i] + i;
                if (cArray != null && cArray.length > i) {
                    cArray2[0] = cArray[i];
                }
                byte[] byArray = Converter.wcsToMbcs((char[])cArray2, (boolean)false);
                long l = GTK.gtk_entry_get_text((long)this.handle);
                nArray[0] = (int)OS.g_utf16_offset_to_utf8_offset(l, nArray[0]);
                GTK.gtk_editable_insert_text((long)this.handle, (byte[])byArray, (int)byArray.length, (int[])nArray);
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
        } else {
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byte[] byArray3 = new byte[ITER_SIZEOF];
            for (int i = 0; i < n2; ++i) {
                GTK.gtk_text_buffer_get_bounds((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray3);
                long l = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray3, (boolean)true);
                GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray, (int)((int)OS.g_utf16_offset_to_utf8_offset(l, this.segments[i] + i)));
                OS.g_free(l);
                if (cArray != null && cArray.length > i) {
                    cArray2[0] = cArray[i];
                }
                byte[] byArray4 = Converter.wcsToMbcs((char[])cArray2, (boolean)false);
                GTK.gtk_text_buffer_insert((long)this.bufferHandle, (byte[])byArray, (byte[])byArray4, (int)byArray4.length);
            }
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
        }
    }

    void clearSegments(boolean bl) {
        if (this.segments == null) {
            return;
        }
        int n = this.segments.length;
        if (n == 0) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n2;
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            if (bl) {
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                long l = GTK.gtk_entry_get_text((long)this.handle);
                for (int i = 0; i < n; ++i) {
                    int n3 = (int)OS.g_utf16_offset_to_utf8_offset(l, this.segments[i]);
                    int n4 = (int)OS.g_utf16_offset_to_utf8_offset(l, this.segments[i] + 1);
                    GTK.gtk_editable_delete_text((long)this.handle, (int)n3, (int)n4);
                }
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
            }
            if ((n2 = GTK.gtk_entry_get_max_length((long)this.handle)) != 0) {
                GTK.gtk_entry_set_max_length((long)this.handle, (int)this.untranslateOffset(n2));
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        } else if (bl) {
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byte[] byArray3 = new byte[ITER_SIZEOF];
            byte[] byArray4 = new byte[ITER_SIZEOF];
            for (int i = 0; i < n; ++i) {
                GTK.gtk_text_buffer_get_bounds((long)this.bufferHandle, (byte[])byArray3, (byte[])byArray4);
                long l = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray3, (byte[])byArray4, (boolean)true);
                GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray, (int)((int)OS.g_utf16_offset_to_utf8_offset(l, this.segments[i])));
                GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray2, (int)((int)OS.g_utf16_offset_to_utf8_offset(l, this.segments[i] + 1)));
                GTK.gtk_text_buffer_delete((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2);
                OS.g_free(l);
            }
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
        }
        this.segments = null;
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = GTK.gtk_editable_get_position((long)this.handle);
            GTK.gtk_editable_select_region((long)this.handle, (int)n, (int)n);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            long l = GTK.gtk_text_buffer_get_insert((long)this.bufferHandle);
            GTK.gtk_text_buffer_get_iter_at_mark((long)this.bufferHandle, (byte[])byArray, (long)l);
            GTK.gtk_text_buffer_select_range((long)this.bufferHandle, (byte[])byArray, (byte[])byArray);
        }
    }

    Point computeSizeInPixels(int n, int n2, boolean bl) {
        long l;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if ((this.style & 4) != 0) {
            GTK.gtk_widget_realize((long)this.handle);
            long l2 = GTK.gtk_entry_get_layout((long)this.handle);
            OS.pango_layout_get_pixel_size(l2, nArray, nArray2);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2);
            long l3 = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2, (boolean)true);
            long l4 = GTK.gtk_widget_create_pango_layout((long)this.handle, (long)l3);
            OS.g_free(l3);
            OS.pango_layout_set_width(l4, n * 1024);
            OS.pango_layout_get_pixel_size(l4, nArray, nArray2);
            OS.g_object_unref(l4);
        }
        int n3 = nArray[0];
        int n4 = nArray2[0];
        if ((this.style & 4) != 0 && this.message.length() > 0) {
            byte[] byArray = Converter.wcsToMbcs((String)this.message, (boolean)true);
            l = GTK.gtk_widget_create_pango_layout((long)this.handle, (byte[])byArray);
            Arrays.fill(byArray, (byte)0);
            OS.pango_layout_get_pixel_size(l, nArray, nArray2);
            OS.g_object_unref(l);
            n3 = Math.max(n3, nArray[0]);
        }
        if ((this.style & 0x80) != 0) {
            GtkBorder gtkBorder = new GtkBorder();
            l = GTK.gtk_widget_get_style_context((long)this.handle);
            int n5 = GTK.GTK_VERSION < OS.VERSION(3, 18, 0) ? 0 : GTK.gtk_widget_get_state_flags((long)this.handle);
            this.gtk_style_context_get_padding(l, n5, gtkBorder);
            n3 += gtkBorder.left + gtkBorder.right;
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        n3 = n == -1 ? n3 : n;
        n4 = n2 == -1 ? n4 : n2;
        Rectangle rectangle = this.computeTrimInPixels(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    Rectangle computeTrimInPixels(int n, int n2, int n3, int n4) {
        Object object;
        this.checkWidget();
        Rectangle rectangle = super.computeTrimInPixels(n, n2, n3, n4);
        int n5 = 0;
        int n6 = 0;
        if ((this.style & 4) != 0) {
            Point point;
            object = new GtkBorder();
            long l = GTK.gtk_widget_get_style_context((long)this.handle);
            int n7 = GTK.GTK_VERSION < OS.VERSION(3, 18, 0) ? 0 : GTK.gtk_widget_get_state_flags((long)this.handle);
            this.gtk_style_context_get_padding(l, n7, (GtkBorder)object);
            rectangle.x -= object.left;
            rectangle.y -= object.top;
            rectangle.width += object.left + object.right;
            if (object.bottom == 0 && object.top == 0) {
                point = this.computeNativeSize(this.handle, rectangle.width, -1, true);
                rectangle.height = point.y;
            } else {
                rectangle.height += object.top + object.bottom;
            }
            if ((this.style & 0x800) != 0) {
                int n8 = GTK.GTK_VERSION < OS.VERSION(3, 18, 0) ? 0 : GTK.gtk_widget_get_state_flags((long)this.handle);
                this.gtk_style_context_get_border(l, n8, (GtkBorder)object);
                rectangle.x -= object.left;
                rectangle.y -= object.top;
                rectangle.width += object.left + object.right;
                rectangle.height += object.top + object.bottom;
            }
            point = new GdkRectangle();
            GTK.gtk_entry_get_icon_area((long)this.handle, (int)0, (GdkRectangle)point);
            rectangle.x -= point.width;
            rectangle.width += point.width;
            GTK.gtk_entry_get_icon_area((long)this.handle, (int)1, (GdkRectangle)point);
            rectangle.width += point.width;
        } else {
            int n9 = this.gtk_container_get_border_width_or_margin(this.handle);
            n5 += n9;
            n6 += n9;
        }
        object = new int[1];
        if (!GTK.GTK4) {
            GTK.gtk_widget_style_get((long)this.handle, (byte[])OS.interior_focus, (int[])object, (long)0L);
        }
        if (object[0] == false) {
            if (!GTK.GTK4) {
                GTK.gtk_widget_style_get((long)this.handle, (byte[])OS.focus_line_width, (int[])object, (long)0L);
            }
            n5 += object[0];
            n6 += object[0];
        }
        rectangle.x -= n5;
        rectangle.y -= n6;
        rectangle.width += 2 * n5;
        rectangle.height += 2 * n6;
        ++rectangle.width;
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_copy_clipboard((long)this.handle);
        } else {
            long l = GTK.gtk_clipboard_get((long)0L);
            this.clearSegments(true);
            GTK.gtk_text_buffer_copy_clipboard((long)this.bufferHandle, (long)l);
            this.applySegments();
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_cut_clipboard((long)this.handle);
        } else {
            long l = GTK.gtk_clipboard_get((long)0L);
            this.clearSegments(true);
            GTK.gtk_text_buffer_cut_clipboard((long)this.bufferHandle, (long)l, (boolean)GTK.gtk_text_view_get_editable((long)this.handle));
            this.applySegments();
        }
    }

    char[] deprocessText(char[] cArray, int n, int n2) {
        int n3;
        if (cArray == null) {
            return new char[0];
        }
        if (n < 0) {
            n = 0;
        }
        int n4 = cArray.length;
        if (n2 == -1) {
            n2 = n + n4;
        }
        if (this.segments != null && n2 > this.segments[0] && (n3 = this.segments.length) > 0 && n <= this.segments[n3 - 1]) {
            int n5 = 0;
            while (n - n5 > this.segments[n5]) {
                ++n5;
            }
            int n6 = n5;
            for (int i = n; i < n2; ++i) {
                if (n6 < n3 && i - n6 == this.segments[n6]) {
                    ++n6;
                    continue;
                }
                cArray[i - n6 + n5 - n] = cArray[i - n];
            }
            n4 = n2 - n - n6 + n5;
        }
        if (n != 0 || n2 != n + n4) {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, 0, cArray2, 0, n4);
            return cArray2;
        }
        return cArray;
    }

    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    void deregister() {
        long l;
        super.deregister();
        if (this.bufferHandle != 0L) {
            this.display.removeWidget(this.bufferHandle);
        }
        if ((l = this.imContext()) != 0L) {
            this.display.removeWidget(l);
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3;
        boolean bl4 = bl3 = GTK.GTK_VERSION < OS.VERSION(3, 14, 0) ? this.insideBlockSelection(n, n2) : false;
        if (bl && bl3 && super.dragDetect(n, n2, bl, bl2, blArray)) {
            if (blArray != null) {
                blArray[0] = true;
            }
            return true;
        }
        return false;
    }

    long eventWindow() {
        return this.paintWindow();
    }

    boolean filterKey(int n, long l) {
        int n2 = GDK.gdk_event_get_time((long)l);
        if (n2 != this.lastEventTime) {
            if (Text.logger.level >= 9) {
                logger.log(9, "filterKey(int,int)", "times differ");
            }
            this.lastEventTime = n2;
            long l2 = this.imContext();
            if (Text.logger.level >= 9) {
                logger.build("filterKey(int,int)").add("imContext: ").add(l2).log(9);
            }
            if (l2 != 0L) {
                boolean bl = GTK.gtk_im_context_filter_keypress((long)l2, (long)l);
                if (Text.logger.level >= 9) {
                    logger.build("filterKey(int,int)").add("ret: ").add(bl).log(9);
                }
                if (!bl && this.display.charOverrideHead > this.display.charOverrideTail) {
                    long l3 = this.display.charOverride[this.display.charOverrideTail++];
                    if (Text.logger.level >= 9) {
                        logger.build("filterKey(int,int)").add("char override: ").addHex(l3).log(9);
                    }
                    char c = (char)(l3 >> 32 & 0xFFFFL);
                    byte[] byArray = Converter.wcsToMbcs((char[])new char[]{c}, (boolean)true);
                    long l4 = OS.g_malloc(byArray.length);
                    OS.memmove((long)l4, (byte[])byArray, (long)byArray.length);
                    this.gtk_commit(l2, l4);
                    OS.g_free(l4);
                    bl = true;
                }
                return bl;
            }
        }
        this.gdkEventKey = l;
        return false;
    }

    void fixIM() {
        long l;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (l = this.imContext()) != 0L) {
            GTK.gtk_im_context_filter_keypress((long)l, (long)this.gdkEventKey);
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    int getBorderWidthInPixels() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return super.getBorderWidthInPixels();
        }
        if ((this.style & 0x800) != 0) {
            return this.getThickness((long)this.handle).x;
        }
        return 0;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        long l = GTK.gtk_text_buffer_get_insert((long)this.bufferHandle);
        GTK.gtk_text_buffer_get_iter_at_mark((long)this.bufferHandle, (byte[])byArray, (long)l);
        return GTK.gtk_text_iter_get_line((byte[])byArray);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = GTK.gtk_editable_get_position((long)this.handle);
            n = GTK.gtk_entry_text_index_to_layout_index((long)this.handle, (int)n);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GTK.gtk_entry_get_layout_offsets((long)this.handle, (int[])nArray, (int[])nArray2);
            long l = GTK.gtk_entry_get_layout((long)this.handle);
            PangoRectangle pangoRectangle = new PangoRectangle();
            OS.pango_layout_index_to_pos(l, n, pangoRectangle);
            int n2 = nArray[0] + OS.PANGO_PIXELS(pangoRectangle.x) - this.getBorderWidthInPixels();
            int n3 = nArray2[0] + OS.PANGO_PIXELS(pangoRectangle.y);
            return new Point(n2, n3);
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        long l = GTK.gtk_text_buffer_get_insert((long)this.bufferHandle);
        GTK.gtk_text_buffer_get_iter_at_mark((long)this.bufferHandle, (byte[])byArray, (long)l);
        GdkRectangle gdkRectangle = new GdkRectangle();
        GTK.gtk_text_view_get_iter_location((long)this.handle, (byte[])byArray, (GdkRectangle)gdkRectangle);
        int[] nArray = new int[1];
        int[] nArray3 = new int[1];
        GTK.gtk_text_view_buffer_to_window_coords((long)this.handle, (int)2, (int)gdkRectangle.x, (int)gdkRectangle.y, (int[])nArray, (int[])nArray3);
        return new Point(nArray[0], nArray3[0]);
    }

    public int getCaretPosition() {
        int n;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            long l = GTK.gtk_entry_get_text((long)this.handle);
            n = (int)OS.g_utf8_offset_to_utf16_offset(l, GTK.gtk_editable_get_position((long)this.handle));
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            long l = GTK.gtk_text_buffer_get_insert((long)this.bufferHandle);
            GTK.gtk_text_buffer_get_iter_at_mark((long)this.bufferHandle, (byte[])byArray, (long)l);
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray2, (int)0);
            long l2 = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray, (boolean)true);
            n = (int)OS.g_utf8_offset_to_utf16_offset(l2, GTK.gtk_text_iter_get_offset((byte[])byArray));
            OS.g_free(l2);
        }
        return this.untranslateOffset(n);
    }

    public int getCharCount() {
        int n;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            long l = GTK.gtk_entry_get_text((long)this.handle);
            n = (int)OS.g_utf16_strlen(l, -1L);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2);
            long l = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2, (boolean)true);
            n = (int)OS.g_utf16_strlen(l, -1L);
            OS.g_free(l);
        }
        return this.untranslateOffset(n);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        if ((this.style & 4) != 0 && !GTK.gtk_entry_get_visibility((long)this.handle)) {
            return GTK.gtk_entry_get_invisible_char((long)this.handle);
        }
        return '\u0000';
    }

    public boolean getEditable() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return GTK.gtk_editable_get_editable((long)this.handle);
        }
        return GTK.gtk_text_view_get_editable((long)this.handle);
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        return GTK.gtk_text_buffer_get_line_count((long)this.bufferHandle);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public int getOrientation() {
        return super.getOrientation();
    }

    int getPosition(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = -1;
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            long l = GTK.gtk_entry_get_layout((long)this.handle);
            OS.pango_layout_xy_to_index(l, point.x * 1024, point.y * 1024, nArray, nArray2);
            long l2 = OS.pango_layout_get_text(l);
            n = (int)OS.g_utf16_pointer_to_offset(l2, l2 + (long)nArray[0]) + nArray2[0];
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            GTK.gtk_text_view_get_iter_at_location((long)this.handle, (byte[])byArray, (int)point.x, (int)point.y);
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray2, (int)0);
            long l = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray, (boolean)true);
            n = (int)OS.g_utf8_offset_to_utf16_offset(l, GTK.gtk_text_iter_get_offset((byte[])byArray));
            OS.g_free(l);
        }
        return this.untranslateOffset(n);
    }

    public Point getSelection() {
        Point point;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GTK.gtk_editable_get_selection_bounds((long)this.handle, (int[])nArray, (int[])nArray2);
            long l = GTK.gtk_entry_get_text((long)this.handle);
            nArray[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray[0]);
            nArray2[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray2[0]);
            point = new Point(nArray[0], nArray2[0]);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_selection_bounds((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2);
            byte[] byArray3 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray3, (int)0);
            long l = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray3, (byte[])byArray2, (boolean)true);
            int n = (int)OS.g_utf8_offset_to_utf16_offset(l, GTK.gtk_text_iter_get_offset((byte[])byArray));
            int n2 = (int)OS.g_utf8_offset_to_utf16_offset(l, GTK.gtk_text_iter_get_offset((byte[])byArray2));
            OS.g_free(l);
            point = new Point(n, n2);
        }
        point.x = this.untranslateOffset(point.x);
        point.y = this.untranslateOffset(point.y);
        return point;
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point point = this.getSelection();
        return Math.abs(point.y - point.x);
    }

    public String getSelectionText() {
        this.checkWidget();
        Point point = this.getSelection();
        return this.getText().substring(point.x, point.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int n) {
        byte[] byArray = Converter.wcsToMbcs((String)" ", (boolean)true);
        long l = GTK.gtk_widget_create_pango_layout((long)this.handle, (byte[])byArray);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(l, nArray, nArray2);
        OS.g_object_unref(l);
        return nArray[0] * n;
    }

    public String getText() {
        return new String(this.getTextChars());
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        if (n > n2 || 0 > n2) {
            return "";
        }
        String string = this.getText();
        int n3 = string.length();
        if (n > (n2 = Math.min(n2, n3 - 1))) {
            return "";
        }
        n = Math.max(0, n);
        return string.substring(n, n2 + 1);
    }

    public char[] getTextChars() {
        byte[] byArray;
        long l;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            l = GTK.gtk_entry_get_text((long)this.handle);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byArray = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray);
            l = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray, (boolean)true);
        }
        if (l == 0L) {
            return new char[0];
        }
        int n = C.strlen((long)l);
        byArray = new byte[n];
        C.memmove((byte[])byArray, (long)l, (long)n);
        if ((this.style & 2) != 0) {
            OS.g_free(l);
        }
        char[] cArray = Converter.mbcsToWcs((byte[])byArray);
        Arrays.fill(byArray, (byte)0);
        if (this.segments != null) {
            cArray = this.deprocessText(cArray, 0, -1);
        }
        return cArray;
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return LIMIT;
        }
        int n = GTK.gtk_entry_get_max_length((long)this.handle);
        return n == 0 ? 65535 : this.untranslateOffset(n);
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        long l = GTK.gtk_scrollable_get_vadjustment((long)this.handle);
        this.currentAdjustment = GTK.gtk_adjustment_get_value((long)l);
        if (this.cachedAdjustment == this.currentAdjustment && this.indexMark != 0L) {
            GTK.gtk_text_buffer_get_iter_at_mark((long)this.bufferHandle, (byte[])byArray, (long)this.indexMark);
            return GTK.gtk_text_iter_get_line((byte[])byArray);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        GTK.gtk_text_view_get_visible_rect((long)this.handle, (GdkRectangle)gdkRectangle);
        GTK.gtk_text_view_get_line_at_y((long)this.handle, (byte[])byArray, (int)gdkRectangle.y, null);
        return GTK.gtk_text_iter_get_line((byte[])byArray);
    }

    public int getTopPixel() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTopPixelInPixels());
    }

    int getTopPixelInPixels() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        GdkRectangle gdkRectangle = new GdkRectangle();
        GTK.gtk_text_view_get_visible_rect((long)this.handle, (GdkRectangle)gdkRectangle);
        int[] nArray = new int[1];
        GTK.gtk_text_view_get_line_at_y((long)this.handle, (byte[])byArray, (int)gdkRectangle.y, (int[])nArray);
        return nArray[0];
    }

    long gtk_activate(long l) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        int n = GDK.gdk_event_get_event_type((long)l2);
        if (!this.doubleClick) {
            switch (n) {
                case 5: 
                case 6: {
                    return 1L;
                }
            }
        }
        return l3;
    }

    long gtk_changed(long l) {
        boolean bl = false;
        long l2 = GTK.gtk_get_current_event();
        if (l2 != 0L) {
            int n = GDK.gdk_event_get_event_type((long)l2);
            n = Text.fixGdkEventTypeValues((int)n);
            switch (n) {
                case 8: {
                    bl = true;
                }
            }
            this.gdk_event_free(l2);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        if ((this.style & 0x80) != 0 && (this.style & 0x100) == 0) {
            GTK.gtk_entry_set_icon_from_icon_name((long)this.handle, (int)1, null);
        }
        return 0L;
    }

    long gtk_commit(long l, long l2) {
        if (Text.logger.level >= 7) {
            Logger.Builder builder = logger.build("gtk_commit(int,int)");
            (Text.logger.level < 8 ? builder : builder.add("imContext: ").add(l).add(", text: ").add(l2)).log(7);
        }
        if (l2 == 0L) {
            return 0L;
        }
        if ((this.style & 4) != 0 && !GTK.gtk_editable_get_editable((long)this.handle)) {
            return 0L;
        }
        int n = C.strlen((long)l2);
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        C.memmove((byte[])byArray, (long)l2, (long)n);
        char[] cArray = Converter.mbcsToWcs((byte[])byArray);
        Arrays.fill(byArray, (byte)0);
        char[] cArray2 = this.sendIMKeyEvent(1, 0L, cArray);
        if (cArray2 == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 9L);
        int n2 = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
        int n3 = 17;
        OS.g_signal_handlers_unblock_matched(l, n3, n2, 0, 0L, 0L, this.handle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(l, OS.commit, l2);
        } else {
            byArray = Converter.wcsToMbcs((char[])cArray2, (boolean)true);
            OS.g_signal_emit_by_name(l, OS.commit, byArray);
            Arrays.fill(byArray, (byte)0);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(l, n3, n2, 0, 0L, 0L, this.handle);
        if ((this.style & 4) != 0 && this.fixStart != -1 && this.fixEnd != -1) {
            GTK.gtk_editable_set_position((long)this.handle, (int)this.fixStart);
            GTK.gtk_editable_select_region((long)this.handle, (int)this.fixStart, (int)this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    long gtk_delete_range(long l, long l2, long l3) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        byte[] byArray2 = new byte[ITER_SIZEOF];
        C.memmove((byte[])byArray, (long)l2, (long)byArray.length);
        C.memmove((byte[])byArray2, (long)l3, (long)byArray2.length);
        int n = GTK.gtk_text_iter_get_offset((byte[])byArray);
        int n2 = GTK.gtk_text_iter_get_offset((byte[])byArray2);
        byte[] byArray3 = new byte[ITER_SIZEOF];
        GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray3, (int)0);
        long l4 = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray3, (byte[])byArray2, (boolean)true);
        n = (int)OS.g_utf8_offset_to_utf16_offset(l4, n);
        n2 = (int)OS.g_utf8_offset_to_utf16_offset(l4, n2);
        OS.g_free(l4);
        String string = this.verifyText("", n, n2);
        if (string == null) {
            GTK.gtk_text_buffer_get_selection_bounds((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2);
            n = GTK.gtk_text_iter_get_offset((byte[])byArray);
            n2 = GTK.gtk_text_iter_get_offset((byte[])byArray2);
            if (n != n2) {
                this.fixStart = n;
                this.fixEnd = n2;
            }
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
        } else if (string.length() > 0) {
            byte[] byArray4 = Converter.wcsToMbcs((String)string, (boolean)false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            GTK.gtk_text_buffer_delete((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_insert((long)this.bufferHandle, (byte[])byArray, (byte[])byArray4, (int)byArray4.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
            Arrays.fill(byArray4, (byte)0);
        }
        return 0L;
    }

    long gtk_delete_text(long l, long l2, long l3) {
        int n;
        int n2;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        long l4 = GTK.gtk_entry_get_text((long)this.handle);
        if (l3 == -1L) {
            l3 = OS.g_utf8_strlen(l4, -1L);
        }
        if ((string = this.verifyText("", n2 = (int)OS.g_utf8_offset_to_utf16_offset(l4, l2), n = (int)OS.g_utf8_offset_to_utf16_offset(l4, l3))) == null) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GTK.gtk_editable_get_selection_bounds((long)this.handle, (int[])nArray, (int[])nArray2);
            if (nArray[0] != nArray2[0]) {
                this.fixStart = nArray[0];
                this.fixEnd = nArray2[0];
            }
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{(int)l3};
            byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            GTK.gtk_editable_insert_text((long)this.handle, (byte[])byArray, (int)byArray.length, (int[])nArray);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_editable_set_position((long)this.handle, (int)nArray[0]);
            Arrays.fill(byArray, (byte)0);
        }
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            int n = GDK.gdk_event_get_event_type((long)l2);
            n = Text.fixGdkEventTypeValues((int)n);
            switch (n) {
                case 12: {
                    boolean[] blArray = new boolean[1];
                    if (GTK.GTK4) {
                        GDK.gdk_event_get_focus_in((long)l2, (boolean[])blArray);
                    } else {
                        GdkEventFocus gdkEventFocus = new GdkEventFocus();
                        OS.memmove(gdkEventFocus, l2, (long)GdkEventFocus.sizeof);
                        boolean bl = blArray[0] = gdkEventFocus.in != 0;
                    }
                    if (!blArray[0]) break;
                    long l3 = GTK.gtk_settings_get_default();
                    OS.g_object_set(l3, GTK.gtk_entry_select_on_focus, true, 0L);
                }
            }
        }
        return super.gtk_event_after(l, l2);
    }

    long gtk_draw(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        long l3 = super.gtk_draw(l, l2);
        return l3;
    }

    boolean mustBeVisibleOnInitBounds() {
        return true;
    }

    long gtk_focus_out_event(long l, long l2) {
        this.fixIM();
        return super.gtk_focus_out_event(l, l2);
    }

    long gtk_grab_focus(long l) {
        long l2 = super.gtk_grab_focus(l);
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            long l3 = GTK.gtk_settings_get_default();
            OS.g_object_set(l3, GTK.gtk_entry_select_on_focus, false, 0L);
        }
        return l2;
    }

    long gtk_icon_release(long l, long l2, long l3) {
        Event event = new Event();
        event.detail = l2 == 0L ? 512 : 256;
        this.sendSelectionEvent(14, event, false);
        return 0L;
    }

    long gtk_insert_text(long l, long l2, long l3, long l4) {
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l3];
        C.memmove((byte[])byArray, (long)l2, (long)byArray.length);
        String string2 = new String(Converter.mbcsToWcs((byte[])byArray));
        int[] nArray = new int[1];
        C.memmove((int[])nArray, (long)l4, (long)4L);
        long l5 = GTK.gtk_entry_get_text((long)this.handle);
        if (nArray[0] == -1) {
            nArray[0] = (int)OS.g_utf8_strlen(l5, -1L);
        }
        int n = nArray[0];
        int n2 = nArray[0];
        if (this.fixStart != -1 && this.fixEnd != -1) {
            n = nArray[0] = this.fixStart;
            n2 = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        if ((string = this.verifyText(string2, n = (int)OS.g_utf8_offset_to_utf16_offset(l5, n), n2 = (int)OS.g_utf8_offset_to_utf16_offset(l5, n2))) != string2 && this.handle != 0L) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            GTK.gtk_editable_get_selection_bounds((long)this.handle, (int[])nArray2, (int[])nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                    GTK.gtk_editable_delete_selection((long)this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] byArray2 = Converter.wcsToMbcs((String)string, (boolean)false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                GTK.gtk_editable_insert_text((long)this.handle, (byte[])byArray2, (int)byArray2.length, (int[])nArray);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            C.memmove((long)l4, (int[])nArray, (long)4L);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0L;
    }

    long gtk_key_press_event(long l, long l2) {
        long l3;
        if (Text.logger.level >= 7) {
            Logger.Builder builder = logger.build("gtk_key_press_event(int,int)");
            (Text.logger.level < 8 ? builder : builder.add("this: ").add((Object)this).add(", widget: ").add(l).add(", event: ").add(l2)).log(7);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.hooks(49) || this.filters(49)) {
            int n;
            int[] nArray = new int[1];
            GDK.gdk_event_get_state((long)l2, (int[])nArray);
            if (GTK.GTK4) {
                long[] lArray = new long[1];
                GDK.gdk_event_get_string((long)l2, (long[])lArray);
                n = (int)OS.g_utf16_strlen(lArray[0], -1L);
            } else {
                GdkEventKey gdkEventKey = new GdkEventKey();
                OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
                n = gdkEventKey.length;
            }
            if (n > 0 && (nArray[0] & 0xC) == 0) {
                bl = true;
                if (this.segments != null) {
                    this.clearSegments(true);
                    bl2 = true;
                }
            }
        }
        if ((l3 = super.gtk_key_press_event(l, l2)) != 0L) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1L) {
            l3 = 1L;
        }
        this.gdkEventKey = 0L;
        if (bl && (l3 != 0L || bl2)) {
            this.applySegments();
        }
        return l3;
    }

    long gtk_populate_popup(long l, long l2) {
        if ((this.style & 0x4000000) != 0) {
            GTK.gtk_widget_set_direction((long)l2, (int)2);
            GTK.gtk_container_forall((long)l2, (long)this.display.setDirectionProc, (long)2L);
        }
        return 0L;
    }

    long gtk_text_buffer_insert_text(long l, long l2, long l3, long l4) {
        int n;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        C.memmove((byte[])byArray, (long)l2, (long)byArray.length);
        int n2 = n = GTK.gtk_text_iter_get_offset((byte[])byArray);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            n = this.fixStart;
            n2 = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        byte[] byArray2 = new byte[ITER_SIZEOF];
        GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray2, (int)0);
        long l5 = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray, (boolean)true);
        n = (int)OS.g_utf8_offset_to_utf16_offset(l5, n);
        n2 = (int)OS.g_utf8_offset_to_utf16_offset(l5, n2);
        OS.g_free(l5);
        byte[] byArray3 = new byte[(int)l4];
        C.memmove((byte[])byArray3, (long)l3, (long)byArray3.length);
        String string = new String(Converter.mbcsToWcs((byte[])byArray3));
        String string2 = this.verifyText(string, n, n2);
        if (string2 == null) {
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        } else if (string2 != string) {
            byte[] byArray4 = Converter.wcsToMbcs((String)string2, (boolean)false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_insert((long)this.bufferHandle, (long)l2, (byte[])byArray4, (int)byArray4.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        }
        return 0L;
    }

    void hookEvents() {
        long l;
        super.hookEvents();
        if ((this.style & 4) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
            OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.getClosure(26), false);
            OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.getClosure(13), false);
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
            OS.g_signal_connect_closure(this.handle, OS.grab_focus, this.display.getClosure(23), false);
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
            if ((this.style & 0x80) != 0) {
                OS.g_signal_connect_closure(this.handle, OS.icon_release, this.display.getClosure(67), false);
            }
        } else {
            OS.g_signal_connect_closure(this.bufferHandle, OS.changed, this.display.getClosure(6), false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.insert_text, this.display.getClosure(52), false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.delete_range, this.display.getClosure(12), false);
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
        }
        if ((l = this.imContext()) != 0L) {
            OS.g_signal_connect_closure(l, OS.commit, this.display.getClosure(9), false);
            int n = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
            int n2 = 17;
            OS.g_signal_handlers_block_matched(l, n2, n, 0, 0L, 0L, this.handle);
        }
        OS.g_signal_connect_closure(this.handle, OS.backspace, this.display.getClosure(70), false);
        OS.g_signal_connect_closure(this.handle, OS.backspace, this.display.getClosure(71), true);
        OS.g_signal_connect_closure(this.handle, OS.copy_clipboard, this.display.getClosure(72), false);
        OS.g_signal_connect_closure(this.handle, OS.copy_clipboard, this.display.getClosure(73), true);
        OS.g_signal_connect_closure(this.handle, OS.cut_clipboard, this.display.getClosure(74), false);
        OS.g_signal_connect_closure(this.handle, OS.cut_clipboard, this.display.getClosure(75), true);
        OS.g_signal_connect_closure(this.handle, OS.paste_clipboard, this.display.getClosure(76), false);
        OS.g_signal_connect_closure(this.handle, OS.paste_clipboard, this.display.getClosure(77), true);
        OS.g_signal_connect_closure(this.handle, OS.delete_from_cursor, this.display.getClosure(78), false);
        OS.g_signal_connect_closure(this.handle, OS.delete_from_cursor, this.display.getClosure(79), true);
        OS.g_signal_connect_closure(this.handle, OS.move_cursor, this.display.getClosure(80), false);
        OS.g_signal_connect_closure(this.handle, OS.move_cursor, this.display.getClosure(81), true);
        OS.g_signal_connect_closure(this.handle, OS.direction_changed, this.display.getClosure(82), true);
    }

    long imContext() {
        if (this.imContext != 0L) {
            return this.imContext;
        }
        return 0L;
    }

    private boolean insideBlockSelection(int n, int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 4) != 0) {
            objectArray2 = new int[1];
            objectArray = new int[1];
            GTK.gtk_editable_get_selection_bounds((long)this.handle, (int[])objectArray2, (int[])objectArray);
            n3 = objectArray2[0];
            n4 = objectArray[0];
        } else {
            objectArray2 = new byte[ITER_SIZEOF];
            objectArray = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_selection_bounds((long)this.bufferHandle, (byte[])objectArray2, (byte[])objectArray);
            n3 = GTK.gtk_text_iter_get_offset((byte[])objectArray2);
            n4 = GTK.gtk_text_iter_get_offset((byte[])objectArray);
        }
        if (n3 != n4) {
            if (n4 < n3) {
                int n5 = n4;
                n4 = n3;
                n3 = n5;
            }
            int n6 = -1;
            if ((this.style & 4) != 0) {
                objectArray = new int[1];
                int[] nArray = new int[1];
                long l = GTK.gtk_entry_get_layout((long)this.handle);
                OS.pango_layout_xy_to_index(l, n * 1024, n2 * 1024, objectArray, nArray);
                long l2 = OS.pango_layout_get_text(l);
                n6 = (int)OS.g_utf8_pointer_to_offset(l2, l2 + (long)objectArray[0]) + nArray[0];
            } else {
                objectArray = new byte[ITER_SIZEOF];
                GTK.gtk_text_view_get_iter_at_location((long)this.handle, (byte[])objectArray, (int)n, (int)n2);
                n6 = GTK.gtk_text_iter_get_offset((byte[])objectArray);
            }
            if (n3 <= n6 && n6 < n4) {
                return true;
            }
        }
        return false;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.clearSegments(true);
        byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)false);
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GTK.gtk_editable_get_selection_bounds((long)this.handle, (int[])nArray, (int[])nArray2);
            GTK.gtk_editable_delete_selection((long)this.handle);
            GTK.gtk_editable_insert_text((long)this.handle, (byte[])byArray, (int)byArray.length, (int[])nArray);
            GTK.gtk_editable_set_position((long)this.handle, (int)nArray[0]);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byte[] byArray3 = new byte[ITER_SIZEOF];
            if (GTK.gtk_text_buffer_get_selection_bounds((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray3)) {
                GTK.gtk_text_buffer_delete((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray3);
            }
            GTK.gtk_text_buffer_insert((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray, (int)byArray.length);
            GTK.gtk_text_buffer_place_cursor((long)this.bufferHandle, (byte[])byArray2);
            this.scrollIfNotVisible(byArray2, null, true);
        }
        this.applySegments();
    }

    private void scrollIfNotVisible(byte[] byArray, byte[] byArray2, boolean bl) {
        GdkRectangle gdkRectangle = new GdkRectangle();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        byte[] byArray3 = new byte[ITER_SIZEOF];
        GTK.gtk_text_view_get_visible_rect((long)this.handle, (GdkRectangle)gdkRectangle);
        int n = this.getLineHeight();
        int n2 = gdkRectangle.height / n;
        GTK.gtk_text_view_get_line_yrange((long)this.handle, (byte[])byArray, (int[])nArray, null);
        if (this.indexMark != 0L) {
            GTK.gtk_text_buffer_get_iter_at_mark((long)this.bufferHandle, (byte[])byArray3, (long)this.indexMark);
            GTK.gtk_text_view_get_line_yrange((long)this.handle, (byte[])byArray3, (int[])nArray2, null);
            int n3 = (nArray[0] - nArray2[0]) / n;
            if (n3 >= n2) {
                if (bl) {
                    long l = GTK.gtk_text_buffer_get_insert((long)this.bufferHandle);
                    GTK.gtk_text_view_scroll_to_mark((long)this.handle, (long)l, (double)0.0, (boolean)true, (double)0.0, (double)0.0);
                } else if (byArray2 != null) {
                    GTK.gtk_text_view_scroll_to_iter((long)this.handle, (byte[])byArray2, (double)0.0, (boolean)true, (double)0.0, (double)0.0);
                }
            }
        } else {
            nArray2[0] = 0;
            int n4 = (nArray[0] - nArray2[0]) / n;
            if (n4 >= n2) {
                if (byArray2 != null && !bl) {
                    GTK.gtk_text_view_scroll_to_iter((long)this.handle, (byte[])byArray2, (double)0.0, (boolean)true, (double)0.0, (double)0.0);
                } else if (bl) {
                    long l = GTK.gtk_text_buffer_get_insert((long)this.bufferHandle);
                    GTK.gtk_text_view_scroll_to_mark((long)this.handle, (long)l, (double)0.0, (boolean)true, (double)0.0, (double)0.0);
                }
            }
        }
    }

    long paintWindow() {
        if ((this.style & 4) != 0) {
            long l = super.paintWindow();
            long l2 = GDK.gdk_window_get_children((long)l);
            if (l2 != 0L) {
                do {
                    l = OS.g_list_data(l2);
                } while ((l2 = OS.g_list_next(l2)) != 0L);
            }
            OS.g_list_free(l2);
            return l;
        }
        GTK.gtk_widget_realize((long)this.handle);
        return GTK.gtk_text_view_get_window((long)this.handle, (int)2);
    }

    long paintSurface() {
        if ((this.style & 4) != 0) {
            long l = super.paintSurface();
            long l2 = GDK.gdk_surface_get_children((long)l);
            if (l2 != 0L) {
                do {
                    l = OS.g_list_data(l2);
                } while ((l2 = OS.g_list_next(l2)) != 0L);
            }
            OS.g_list_free(l2);
            return l;
        }
        return 0L;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_paste_clipboard((long)this.handle);
        } else {
            long l = GTK.gtk_clipboard_get((long)0L);
            this.clearSegments(true);
            GTK.gtk_text_buffer_paste_clipboard((long)this.bufferHandle, (long)l, null, (boolean)GTK.gtk_text_view_get_editable((long)this.handle));
            this.applySegments();
        }
    }

    void register() {
        long l;
        super.register();
        if (this.bufferHandle != 0L) {
            this.display.addWidget(this.bufferHandle, (Widget)((Object)this));
        }
        if ((l = this.imContext()) != 0L) {
            this.display.addWidget(l, (Widget)((Object)this));
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
        this.message = null;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, (SWTEventListener)modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, (SWTEventListener)segmentListener);
        this.clearSegments(true);
        this.applySegments();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, (SWTEventListener)selectionListener);
        this.eventTable.unhook(14, (SWTEventListener)selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, (SWTEventListener)verifyListener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_select_region((long)this.handle, (int)0, (int)-1);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray, (int)0);
            GTK.gtk_text_buffer_get_end_iter((long)this.bufferHandle, (byte[])byArray2);
            GTK.gtk_text_buffer_select_range((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2);
        }
    }

    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        String string;
        String string2;
        String string3;
        String string4;
        this.background = gdkRGBA == null ? this.defaultBackground() : gdkRGBA;
        GdkRGBA gdkRGBA2 = this.display.getSystemColor((int)26).handle;
        GdkRGBA gdkRGBA3 = this.display.getSystemColor((int)27).handle;
        String string5 = string4 = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? " selection" : ":selected";
        if ((this.style & 4) != 0) {
            string3 = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? "entry" : "GtkEntry";
            string2 = " {background: " + this.display.gtk_rgba_to_css_string(this.background) + ";}\n" + string3 + ":selected {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA2) + ";}\n" + string3 + string4 + " {color: " + this.display.gtk_rgba_to_css_string(gdkRGBA3) + ";}";
        } else {
            string3 = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? "textview text" : "GtkTextView";
            string2 = " {background-color: " + this.display.gtk_rgba_to_css_string(this.background) + ";}\n" + string3 + ":selected {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA2) + ";}\n" + string3 + string4 + " {color: " + this.display.gtk_rgba_to_css_string(gdkRGBA3) + ";}";
        }
        this.cssBackground = string = string3 + string2;
        String string6 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(l, string6);
    }

    void setCursor(long l) {
        long l2 = 0L;
        if (l == 0L) {
            if (GTK.GTK4) {
                byte[] byArray = Converter.wcsToMbcs((String)"text", (boolean)true);
                l2 = GDK.gdk_cursor_new_from_name((byte[])byArray, (long)0L);
            } else {
                l2 = GDK.gdk_cursor_new_for_display((long)GDK.gdk_display_get_default(), (long)152L);
            }
        }
        super.setCursor(l != 0L ? l : l2);
        if (l == 0L) {
            OS.g_object_unref(l2);
        }
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClick = bl;
    }

    public void setEchoChar(char c) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            GTK.gtk_entry_set_visibility((long)this.handle, (c == '\u0000' ? 1 : 0) != 0);
            GTK.gtk_entry_set_invisible_char((long)this.handle, (char)c);
        }
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!bl) {
            this.style |= 8;
        }
        if ((this.style & 4) != 0) {
            GTK.gtk_editable_set_editable((long)this.handle, (boolean)bl);
        } else {
            GTK.gtk_text_view_set_editable((long)this.handle, (boolean)bl);
        }
    }

    void setFontDescription(long l) {
        super.setFontDescription(l);
        this.setTabStops(this.tabs);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 4) != 0) {
            byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)true);
            GTK.gtk_entry_set_placeholder_text((long)this.handle, (byte[])byArray);
            return;
        }
        this.redraw(false);
    }

    public void setOrientation(int n) {
        this.checkWidget();
    }

    public void setSelection(int n) {
        this.checkWidget();
        n = this.translateOffset(n);
        if ((this.style & 4) != 0) {
            long l = GTK.gtk_entry_get_text((long)this.handle);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            GTK.gtk_editable_set_position((long)this.handle, (int)n);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2);
            long l = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2, (boolean)true);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            OS.g_free(l);
            GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray, (int)n);
            GTK.gtk_text_buffer_place_cursor((long)this.bufferHandle, (byte[])byArray);
            this.scrollIfNotVisible(byArray, byArray, false);
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        if ((this.style & 4) != 0) {
            long l = GTK.gtk_entry_get_text((long)this.handle);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            n2 = (int)OS.g_utf16_offset_to_utf8_offset(l, n2);
            GTK.gtk_editable_set_position((long)this.handle, (int)n);
            GTK.gtk_editable_select_region((long)this.handle, (int)n, (int)n2);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            GTK.gtk_text_buffer_get_bounds((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2);
            long l = GTK.gtk_text_buffer_get_text((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2, (boolean)true);
            n = (int)OS.g_utf16_offset_to_utf8_offset(l, n);
            n2 = (int)OS.g_utf16_offset_to_utf8_offset(l, n2);
            OS.g_free(l);
            GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray, (int)n);
            GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray2, (int)n2);
            this.scrollIfNotVisible(byArray, byArray, false);
            GTK.gtk_text_buffer_select_range((long)this.bufferHandle, (byte[])byArray, (byte[])byArray2);
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setTabs(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.tabs = n;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int n) {
        int n2 = this.getTabWidth(n);
        long l = OS.pango_tab_array_new(1, false);
        OS.pango_tab_array_set_tab(l, 0, 0L, n2);
        if ((this.style & 4) != 0) {
            GTK.gtk_entry_set_tabs((long)this.handle, (long)l);
        } else {
            GTK.gtk_text_view_set_tabs((long)this.handle, (long)l);
        }
        OS.pango_tab_array_free(l);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount())) == null) {
            return;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        this.setText(cArray);
    }

    public void setTextChars(char[] cArray) {
        this.checkWidget();
        if (cArray == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            String string = this.verifyText(new String(cArray), 0, this.getCharCount());
            if (string == null) {
                return;
            }
            cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
        }
        this.setText(cArray);
    }

    void setText(char[] cArray) {
        this.clearSegments(false);
        if ((this.style & 4) != 0) {
            byte[] byArray = Converter.wcsToMbcs((char[])cArray, (boolean)true);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            GTK.gtk_entry_set_text((long)this.handle, (byte[])byArray);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            Arrays.fill(byArray, (byte)0);
        } else {
            byte[] byArray = Converter.wcsToMbcs((char[])cArray, (boolean)false);
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_set_text((long)this.bufferHandle, (byte[])byArray, (int)byArray.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 12L);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0L, 0L, 52L);
            GTK.gtk_text_buffer_get_iter_at_offset((long)this.bufferHandle, (byte[])byArray2, (int)0);
            GTK.gtk_text_buffer_place_cursor((long)this.bufferHandle, (byte[])byArray2);
            long l = GTK.gtk_text_buffer_get_insert((long)this.bufferHandle);
            GTK.gtk_text_view_scroll_to_mark((long)this.handle, (long)l, (double)0.0, (boolean)true, (double)0.0, (double)0.0);
            Arrays.fill(byArray, (byte)0);
        }
        this.sendEvent(24);
        if ((this.style & 0x80) != 0 && (this.style & 0x100) == 0) {
            GTK.gtk_entry_set_icon_from_icon_name((long)this.handle, (int)1, null);
        }
        this.applySegments();
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if ((this.style & 4) != 0) {
            GTK.gtk_entry_set_max_length((long)this.handle, (int)(this.segments != null ? Math.min(LIMIT, this.translateOffset(n)) : n));
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        GTK.gtk_text_buffer_get_iter_at_line((long)this.bufferHandle, (byte[])byArray, (int)n);
        byte[] byArray2 = Converter.wcsToMbcs((String)"index_mark", (boolean)true);
        this.indexMark = GTK.gtk_text_buffer_create_mark((long)this.bufferHandle, (byte[])byArray2, (byte[])byArray, (boolean)true);
        GTK.gtk_text_view_scroll_to_mark((long)this.handle, (long)this.indexMark, (double)0.0, (boolean)true, (double)0.0, (double)0.0);
        long l = GTK.gtk_scrollable_get_vadjustment((long)this.handle);
        this.cachedAdjustment = GTK.gtk_adjustment_get_value((long)l);
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        long l = GTK.gtk_text_buffer_get_selection_bound((long)this.bufferHandle);
        GTK.gtk_text_view_scroll_to_mark((long)this.handle, (long)l, (double)0.0, (boolean)true, (double)0.0, (double)0.0);
        l = GTK.gtk_text_buffer_get_insert((long)this.bufferHandle);
        GTK.gtk_text_view_scroll_to_mark((long)this.handle, (long)l, (double)0.0, (boolean)true, (double)0.0, (double)0.0);
    }

    int translateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        for (int i = 0; i < n2 && n - i >= this.segments[i]; ++i) {
            ++n;
        }
        return n;
    }

    boolean translateTraversal(long l) {
        int[] nArray = new int[1];
        GDK.gdk_event_get_keyval((long)l, (int[])nArray);
        switch (nArray[0]) {
            case 65293: 
            case 65421: {
                long l2 = this.imContext();
                if (l2 == 0L) break;
                long[] lArray = new long[1];
                GTK.gtk_im_context_get_preedit_string((long)l2, (long[])lArray, null, null);
                if (lArray[0] == 0L) break;
                int n = C.strlen((long)lArray[0]);
                OS.g_free(lArray[0]);
                if (n == 0) break;
                return false;
            }
        }
        return super.translateTraversal(l);
    }

    int traversalCode(int n, long l) {
        int n2 = super.traversalCode(n, l);
        if ((this.style & 8) != 0) {
            return n2;
        }
        if ((this.style & 2) != 0) {
            n2 &= 0xFFFFFFFB;
            if (n == 65289 && l != 0L) {
                boolean bl;
                int[] nArray = new int[1];
                GDK.gdk_event_get_state((long)l, (int[])nArray);
                boolean bl2 = bl = (nArray[0] & 1) == 0;
                if (bl && (nArray[0] & 4) == 0) {
                    n2 &= 0xFFFFFFE7;
                }
            }
        }
        return n2;
    }

    int untranslateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        for (int i = 0; i < n2 && n > this.segments[i]; --n, ++i) {
        }
        return n;
    }

    String verifyText(String string, int n, int n2) {
        if (string != null && string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        long l = GTK.gtk_get_current_event();
        if (l != 0L) {
            int n3 = GDK.gdk_event_get_event_type((long)l);
            n3 = Text.fixGdkEventTypeValues((int)n3);
            switch (n3) {
                case 8: {
                    this.setKeyState(event, l);
                }
            }
            this.gdk_event_free(l);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }

    long windowProc(long l, long l2) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)l2) {
                case 70: 
                case 72: 
                case 74: 
                case 76: {
                    this.clearSegments(true);
                    break;
                }
                case 71: 
                case 73: 
                case 75: 
                case 77: {
                    this.applySegments();
                }
            }
        }
        return super.windowProc(l, l2);
    }

    long windowProc(long l, long l2, long l3) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)l3) {
                case 82: {
                    this.clearSegments(true);
                    this.applySegments();
                }
            }
        }
        return super.windowProc(l, l2, l3);
    }

    long windowProc(long l, long l2, long l3, long l4) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)l4) {
                case 78: {
                    this.clearSegments(true);
                    break;
                }
                case 79: {
                    this.applySegments();
                }
            }
        }
        return super.windowProc(l, l2, l3, l4);
    }

    long windowProc(long l, long l2, long l3, long l4, long l5) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch ((int)l5) {
                case 80: {
                    if (l2 != 1L) break;
                    this.clearSegments(true);
                    break;
                }
                case 81: {
                    if (l2 != 1L) break;
                    this.applySegments();
                }
            }
        }
        return super.windowProc(l, l2, l3, l4, l5);
    }
}

