/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.instrument;

import de.qfs.apps.qftest.instrument.WeakIdentityHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class InstanceTracer {
    public static Object instrumentation;
    private static Map<String, Set<Object>> instances;
    private static Map<String, HashMap<ConstructorListener, Boolean>> listeners;
    private static ConstructorListener globalListener;
    private static Map<String, HashMap<MethodListener, Boolean>> classMethodListeners;
    private static Map<Object, HashMap<MethodListener, Boolean>> instanceMethodListeners;
    private static MethodListener globalMethodListener;
    private static Class loggerClass;
    private static Object logger;
    private static Set threadsBusyWithLogging;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void instanceCreated(Object object, Object[] objectArray) {
        Object object2;
        Iterator iterator;
        if (logger != null) {
            try {
                int n = (Integer)loggerClass.getField("level").get(logger);
                if (n >= 8) {
                    iterator = new StringBuilder();
                    if (objectArray == null) {
                        ((StringBuilder)((Object)iterator)).append("null");
                    } else {
                        ((StringBuilder)((Object)iterator)).append("[");
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (i > 0) {
                                ((StringBuilder)((Object)iterator)).append(",");
                            }
                            ((StringBuilder)((Object)iterator)).append(InstanceTracer.safeToString(objectArray[i]));
                        }
                        ((StringBuilder)((Object)iterator)).append("]");
                    }
                    InstanceTracer.dump(7, "instanceCreated(Object)", "instance: " + InstanceTracer.safeToString(object) + ", param: " + ((StringBuilder)((Object)iterator)).toString());
                } else if (n >= 7) {
                    InstanceTracer.dump(7, "instanceCreated(Object)", "instance: " + InstanceTracer.safeToString(object));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        Object object3 = instances;
        synchronized (object3) {
            iterator = object.getClass();
            while (true) {
                if ((object2 = instances.get(((Class)((Object)iterator)).getName())) == null) {
                    object2 = Collections.newSetFromMap(new WeakIdentityHashMap());
                    instances.put(((Class)((Object)iterator)).getName(), (Set<Object>)object2);
                }
                if (InstanceTracer.mayLog(9)) {
                    InstanceTracer.log(9, "instanceCreated(Object)", "map for " + ((Class)((Object)iterator)).getSimpleName() + ": " + InstanceTracer.safeToString(object2));
                }
                if (object2.contains(object)) {
                    if (!InstanceTracer.mayLog(9)) return;
                    InstanceTracer.log(9, "instanceCreated(Object)", "already known");
                    return;
                }
                object2.add((Object)object);
                if (iterator == Object.class) break;
                iterator = ((Class)((Object)iterator)).getSuperclass();
            }
        }
        object3 = new HashSet();
        if (globalListener != null) {
            object3.add(globalListener);
        }
        iterator = listeners;
        synchronized (iterator) {
            object2 = listeners.get(null);
            if (InstanceTracer.mayLog(9)) {
                InstanceTracer.log(9, "instanceCreated(Object)", "listeners for null: " + object2);
            }
            if (object2 != null) {
                object3.addAll(object2.keySet());
            }
            for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                object2 = listeners.get(clazz.getName());
                if (InstanceTracer.mayLog(9)) {
                    InstanceTracer.log(9, "instanceCreated(Object)", "listeners for " + clazz + ": " + object2);
                }
                if (object2 != null) {
                    object3.addAll(object2.keySet());
                }
                if (clazz == Object.class) break;
            }
        }
        if (InstanceTracer.mayLog(9)) {
            InstanceTracer.log(9, "instanceCreated(Object)", "listeners: " + object3);
        }
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (ConstructorListener)iterator.next();
            if (InstanceTracer.mayLog(9)) {
                InstanceTracer.log(9, "instanceCreated(Object)", "calling: " + object2);
            }
            try {
                object2.instanceCreated(object, objectArray);
            }
            catch (Throwable throwable) {
                if (InstanceTracer.mayLog(9)) {
                    InstanceTracer.log(9, "instanceCreated(Object)", throwable, "");
                }
                if (!(throwable instanceof PassthroughException)) continue;
                throw ((PassthroughException)throwable).getCause();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object methodCalled(String string, Object object, Object[] objectArray) {
        if (loggerClass != null && !threadsBusyWithLogging.contains(Thread.currentThread())) {
            try {
                threadsBusyWithLogging.add(Thread.currentThread());
                InstanceTracer.logCall(string, object, objectArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                threadsBusyWithLogging.remove(Thread.currentThread());
            }
        }
        HashSet<MethodListener> hashSet = new HashSet<MethodListener>();
        if (globalMethodListener != null) {
            hashSet.add(globalMethodListener);
        }
        Object object3 = classMethodListeners;
        synchronized (object3) {
            Map object22 = classMethodListeners.get(string);
            if (InstanceTracer.mayLog(9)) {
                InstanceTracer.log(9, "methodCalled(String,Object,Object[])", "class methodListeners for " + string + ": " + object22);
            }
            if (object22 != null) {
                hashSet.addAll(object22.keySet());
            }
        }
        object3 = instanceMethodListeners;
        synchronized (object3) {
            Map map = instanceMethodListeners.get(object);
            if (InstanceTracer.mayLog(9)) {
                InstanceTracer.log(9, "methodCalled(String,Object,Object[])", "instance methodListeners for " + InstanceTracer.safeToString(object) + ": " + map);
            }
            if (map != null) {
                hashSet.addAll(map.keySet());
            }
        }
        if (InstanceTracer.mayLog(9)) {
            InstanceTracer.log(9, "methodCalled(String,Object,Object[])", "methodListeners: " + hashSet);
        }
        for (MethodListener methodListener : hashSet) {
            if (InstanceTracer.mayLog(9)) {
                InstanceTracer.log(9, "methodCalled(String,Object,Object[])", "calling: " + methodListener);
            }
            try {
                Object object2 = methodListener.methodCalled(string, object, objectArray);
                if (object2 == Boolean.TRUE) continue;
                if (InstanceTracer.mayLog(9)) {
                    InstanceTracer.log(9, "methodCalled(String,Object,Object[])", "call suppressed, returning " + object2 + " for " + string);
                }
                return object2;
            }
            catch (Throwable throwable) {
                if (InstanceTracer.mayLog(9)) {
                    InstanceTracer.log(9, "methodCalled(String,Object,Object[])", throwable, "");
                }
                if (!(throwable instanceof PassthroughException)) continue;
                throw ((PassthroughException)throwable).getCause();
            }
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void methodReturned(String string, Object object) {
        if (!threadsBusyWithLogging.contains(Thread.currentThread())) {
            try {
                threadsBusyWithLogging.add(Thread.currentThread());
                if (InstanceTracer.mayLog(7)) {
                    InstanceTracer.dump(7, "methodReturned(String,Object)", "descriptor: " + string + ", instance: " + InstanceTracer.safeToString(object));
                }
            }
            finally {
                threadsBusyWithLogging.remove(Thread.currentThread());
            }
        }
        HashSet<MethodListener> hashSet = new HashSet<MethodListener>();
        if (globalMethodListener != null) {
            hashSet.add(globalMethodListener);
        }
        Object object2 = classMethodListeners;
        synchronized (object2) {
            Map map = classMethodListeners.get(string);
            if (InstanceTracer.mayLog(9)) {
                InstanceTracer.log(9, "methodReturned(String,Object)", "class methodListeners for " + string + ": " + map);
            }
            if (map != null) {
                hashSet.addAll(map.keySet());
            }
        }
        object2 = instanceMethodListeners;
        synchronized (object2) {
            Map map = instanceMethodListeners.get(object);
            if (InstanceTracer.mayLog(9)) {
                InstanceTracer.log(9, "methodReturned(String,Object)", "instance methodListeners for " + InstanceTracer.safeToString(object) + ": " + map);
            }
            if (map != null) {
                hashSet.addAll(map.keySet());
            }
        }
        if (InstanceTracer.mayLog(9)) {
            InstanceTracer.log(9, "methodReturned(String,Object)", "methodListeners: " + hashSet);
        }
        for (MethodListener methodListener : hashSet) {
            if (InstanceTracer.mayLog(9)) {
                InstanceTracer.log(9, "methodReturned(String,Object)", "calling: " + methodListener);
            }
            try {
                methodListener.methodReturned(string, object);
            }
            catch (Throwable throwable) {
                if (InstanceTracer.mayLog(9)) {
                    InstanceTracer.log(9, "methodReturned(String,Object)", throwable, "");
                }
                if (!(throwable instanceof PassthroughException)) continue;
                throw ((PassthroughException)throwable).getCause();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object methodReturned(String string, Object object, Object object2) {
        if (!threadsBusyWithLogging.contains(Thread.currentThread())) {
            try {
                threadsBusyWithLogging.add(Thread.currentThread());
                if (InstanceTracer.mayLog(7)) {
                    InstanceTracer.dump(7, "methodReturned(String,Object,Object)", "descriptor: " + string + ", instance: " + InstanceTracer.safeToString(object) + ", value: " + InstanceTracer.safeToString(object2));
                }
            }
            finally {
                threadsBusyWithLogging.remove(Thread.currentThread());
            }
        }
        HashSet<MethodListener> hashSet = new HashSet<MethodListener>();
        if (globalMethodListener != null) {
            hashSet.add(globalMethodListener);
        }
        Object object4 = classMethodListeners;
        synchronized (object4) {
            Map object32 = classMethodListeners.get(string);
            if (InstanceTracer.mayLog(9)) {
                InstanceTracer.log(9, "methodReturned(String,Object,Object)", "class methodListeners for " + string + ": " + object32);
            }
            if (object32 != null) {
                hashSet.addAll(object32.keySet());
            }
        }
        object4 = instanceMethodListeners;
        synchronized (object4) {
            Map map = instanceMethodListeners.get(object);
            if (InstanceTracer.mayLog(9)) {
                InstanceTracer.log(9, "methodReturned(String,Object,Object)", "instance methodListeners for " + InstanceTracer.safeToString(object) + ": " + map);
            }
            if (map != null) {
                hashSet.addAll(map.keySet());
            }
        }
        if (InstanceTracer.mayLog(9)) {
            InstanceTracer.log(9, "methodReturned(String,Object,Object)", "methodListeners: " + hashSet);
        }
        for (MethodListener methodListener : hashSet) {
            if (InstanceTracer.mayLog(9)) {
                InstanceTracer.log(9, "methodReturned(String,Object,Object)", "calling: " + methodListener);
            }
            try {
                object2 = methodListener.methodReturned(string, object, object2);
            }
            catch (Throwable throwable) {
                if (InstanceTracer.mayLog(9)) {
                    InstanceTracer.log(9, "methodReturned(String,Object,Object)", throwable, "");
                }
                if (!(throwable instanceof PassthroughException)) continue;
                throw ((PassthroughException)throwable).getCause();
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConstructorListener(String string, ConstructorListener constructorListener) {
        if (InstanceTracer.mayLog(7)) {
            InstanceTracer.log(7, "addConstructorListener(String,ConstructorListener)", "clazz: " + string + ", listener: " + constructorListener);
        }
        if (string == null) {
            globalListener = constructorListener;
        } else {
            Map<String, HashMap<ConstructorListener, Boolean>> map = listeners;
            synchronized (map) {
                HashMap<ConstructorListener, Boolean> hashMap = listeners.get(string);
                if (hashMap == null) {
                    hashMap = new HashMap();
                    listeners.put(string, hashMap);
                }
                hashMap.put(constructorListener, Boolean.TRUE);
            }
        }
    }

    public static void removeConstructorListener(String string, ConstructorListener constructorListener) {
        if (InstanceTracer.mayLog(7)) {
            InstanceTracer.log(7, "removeConstructorListener(String,ConstructorListener)", "clazz: " + string + ", listener: " + constructorListener);
        }
        if (string == null) {
            if (globalListener == constructorListener) {
                globalListener = null;
            }
        } else {
            HashMap<ConstructorListener, Boolean> hashMap = listeners.get(string);
            if (hashMap != null) {
                hashMap.remove(constructorListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMethodListener(String string, MethodListener methodListener) {
        if (InstanceTracer.mayLog(7)) {
            InstanceTracer.log(7, "addMethodListener(String,MethodListener)", "clazz: " + string + ", listener: " + methodListener);
        }
        if (string == null) {
            globalMethodListener = methodListener;
        } else {
            string = string.replace('.', '/');
            Map<String, HashMap<MethodListener, Boolean>> map = classMethodListeners;
            synchronized (map) {
                HashMap<MethodListener, Boolean> hashMap = classMethodListeners.get(string);
                if (hashMap == null) {
                    hashMap = new HashMap();
                    classMethodListeners.put(string, hashMap);
                }
                hashMap.put(methodListener, Boolean.TRUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMethodListener(String string, MethodListener methodListener) {
        if (InstanceTracer.mayLog(7)) {
            InstanceTracer.log(7, "removeMethodListener(String,MethodListener)", "clazz: " + string + ", listener: " + methodListener);
        }
        if (string == null) {
            if (globalMethodListener == methodListener) {
                globalMethodListener = null;
            }
        } else {
            string = string.replace('.', '/');
            Map<String, HashMap<MethodListener, Boolean>> map = classMethodListeners;
            synchronized (map) {
                HashMap<MethodListener, Boolean> hashMap = classMethodListeners.get(string);
                if (hashMap != null) {
                    hashMap.remove(methodListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMethodListener(Object object, MethodListener methodListener) {
        if (InstanceTracer.mayLog(7)) {
            InstanceTracer.log(7, "addMethodListener(Object,MethodListener)", "instance: " + object + ", listener: " + methodListener);
        }
        Map<Object, HashMap<MethodListener, Boolean>> map = instanceMethodListeners;
        synchronized (map) {
            HashMap<MethodListener, Boolean> hashMap = instanceMethodListeners.get(object);
            if (hashMap == null) {
                hashMap = new HashMap();
                instanceMethodListeners.put(object, hashMap);
            }
            hashMap.put(methodListener, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMethodListener(Object object, MethodListener methodListener) {
        if (InstanceTracer.mayLog(7)) {
            InstanceTracer.log(7, "removeMethodListener(Object,MethodListener)", "instance: " + object + ", listener: " + methodListener);
        }
        Map<Object, HashMap<MethodListener, Boolean>> map = instanceMethodListeners;
        synchronized (map) {
            HashMap<MethodListener, Boolean> hashMap = instanceMethodListeners.get(object);
            if (hashMap != null) {
                hashMap.remove(methodListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getInstances(String string) {
        if (InstanceTracer.mayLog(7)) {
            InstanceTracer.log(7, "getInstances(String)", "clazz: " + string);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map<String, Set<Object>> map = instances;
        synchronized (map) {
            Set<Object> set = instances.get(string);
            if (set != null) {
                arrayList.addAll(set);
            }
        }
        if (InstanceTracer.mayLog(9)) {
            InstanceTracer.log(9, "getInstances(String)", "ret: " + InstanceTracer.safeToString(arrayList));
        }
        return arrayList;
    }

    private static String safeToString(Object object) {
        try {
            return object == null ? "null" : object.toString();
        }
        catch (Throwable throwable) {
            return "EXCEPTED";
        }
    }

    private static boolean mayLog(int n) {
        if (logger != null) {
            try {
                int n2 = (Integer)loggerClass.getField("level").get(logger);
                return n2 >= n;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    private static void log(int n, String string, String string2, boolean bl) {
        if (logger != null) {
            try {
                loggerClass.getMethod(bl ? "dumpStack" : "log", Integer.TYPE, String.class, String.class).invoke(logger, n, string, string2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static void log(int n, String string, Throwable throwable, String string2) {
        if (logger != null) {
            try {
                loggerClass.getMethod("log", Integer.TYPE, String.class, Throwable.class, String.class).invoke(logger, n, string, throwable, string2);
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
        }
    }

    private static void log(int n, String string, String string2) {
        InstanceTracer.log(n, string, string2, false);
    }

    private static void dump(int n, String string, String string2) {
        InstanceTracer.log(n, string, string2, true);
    }

    private static void logCall(String string, Object object, Object[] objectArray) {
        try {
            int n;
            String[] stringArray = string.split("-");
            String string2 = stringArray[0].replace('/', '.').replace('$', '.');
            Object t = loggerClass.getConstructor(String.class).newInstance(string2);
            if (t != null && (n = ((Integer)loggerClass.getField("level").get(t)).intValue()) >= 7) {
                StringBuilder stringBuilder = new StringBuilder(stringArray[1]);
                stringBuilder.append("(");
                stringBuilder.append(")");
                String string3 = stringBuilder.toString();
                if (n >= 8) {
                    stringBuilder = new StringBuilder("instance: ");
                    stringBuilder.append(InstanceTracer.safeToString(object));
                    if (objectArray != null) {
                        stringBuilder.append(", parameters: [");
                        boolean bl = true;
                        for (Object object2 : objectArray) {
                            if (!bl) {
                                stringBuilder.append(", ");
                            }
                            bl = false;
                            stringBuilder.append(InstanceTracer.safeToString(object2));
                        }
                        stringBuilder.append("]");
                    }
                    loggerClass.getMethod("dumpStack", Integer.TYPE, String.class, String.class).invoke(t, 7, string3, stringBuilder.toString());
                } else {
                    loggerClass.getMethod("log", Integer.TYPE, String.class, String.class).invoke(t, 7, string3, "");
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        instances = new HashMap<String, Set<Object>>();
        listeners = new HashMap<String, HashMap<ConstructorListener, Boolean>>();
        classMethodListeners = new HashMap<String, HashMap<MethodListener, Boolean>>();
        instanceMethodListeners = new WeakHashMap<Object, HashMap<MethodListener, Boolean>>();
        threadsBusyWithLogging = Collections.synchronizedSet(new HashSet());
        try {
            loggerClass = Class.forName("de.qfs.lib.log.Logger");
            logger = loggerClass.getConstructor(String.class).newInstance("de.qfs.apps.qftest.instrument.InstanceTracer");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static final class PassthroughException
    extends RuntimeException {
        public PassthroughException(Throwable throwable) {
            super(throwable);
        }
    }

    public static interface MethodListener {
        public Object methodCalled(String var1, Object var2, Object[] var3);

        public void methodReturned(String var1, Object var2);

        public Object methodReturned(String var1, Object var2, Object var3);
    }

    public static interface ConstructorListener {
        public void instanceCreated(Object var1, Object[] var2);
    }
}

