/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.qagent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DebugOut {
    private final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    private String ID;
    private File logFile;
    private boolean logChecked;
    private Object delegate;
    private int failureCount;

    public DebugOut(String string, File file) {
        this.ID = string;
        this.logFile = file;
    }

    public final void setDelegate(Object object) {
        this.delegate = object;
    }

    public void debug(String string) {
        this.debug(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(final String string, final String string2) {
        if (this.failureCount >= 10) {
            return;
        }
        if (this.delegate != null) {
            try {
                this.delegate.getClass().getMethod("debug", String.class, String.class).invoke(this.delegate, string, string2);
            }
            catch (Throwable throwable) {
                if (this.failureCount == 0) {
                    System.err.println("Failed accessing delegate " + this.delegate + ": " + throwable.getMessage());
                }
                ++this.failureCount;
            }
            return;
        }
        if (this.logFile == null) {
            return;
        }
        try {
            try {
                PrintWriter printWriter = this.openLog();
                try {
                    printWriter.println("" + this.ID + " " + this.df.format(new Date()) + ": " + (string == null ? "" : string + " - ") + string2);
                    printWriter.flush();
                }
                finally {
                    try {
                        printWriter.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (SecurityException securityException) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            PrintWriter printWriter = DebugOut.this.openLog();
                            try {
                                printWriter.println("" + DebugOut.this.ID + " " + DebugOut.this.df.format(new Date()) + ": " + (string == null ? "" : string + " - ") + "Missing Privileges:");
                                securityException.printStackTrace(printWriter);
                                printWriter.println("" + DebugOut.this.ID + " " + DebugOut.this.df.format(new Date()) + ": " + (string == null ? "" : string + " - ") + string2);
                                printWriter.flush();
                            }
                            finally {
                                try {
                                    printWriter.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        catch (Exception exception) {
                            if (DebugOut.this.failureCount == 0) {
                                System.err.println("Error opening log " + DebugOut.this.logFile.getPath() + ": " + exception.getMessage());
                            }
                            DebugOut.this.failureCount++;
                        }
                        return null;
                    }
                });
            }
        }
        catch (Exception exception) {
            if (this.failureCount == 0) {
                System.err.println("Error opening log " + this.logFile.getPath() + ": " + exception.getMessage());
            }
            ++this.failureCount;
        }
    }

    public void debug(Throwable throwable) {
        this.debug(null, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(final String string, final Throwable throwable) {
        if (this.failureCount >= 10) {
            return;
        }
        if (this.delegate != null) {
            try {
                this.delegate.getClass().getMethod("debug", String.class, Throwable.class).invoke(this.delegate, string, throwable);
            }
            catch (Throwable throwable2) {
                if (this.failureCount == 0) {
                    System.err.println("Failed accessing delegate " + this.delegate + ": " + throwable2.getMessage());
                }
                ++this.failureCount;
            }
            return;
        }
        if (this.logFile == null) {
            return;
        }
        try {
            try {
                PrintWriter printWriter = this.openLog();
                try {
                    printWriter.println("" + this.ID + " " + this.df.format(new Date()) + ": " + (string == null ? "" : string + " - "));
                    throwable.printStackTrace(printWriter);
                    printWriter.flush();
                }
                finally {
                    try {
                        printWriter.close();
                    }
                    catch (Throwable throwable3) {}
                }
            }
            catch (SecurityException securityException) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            PrintWriter printWriter = DebugOut.this.openLog();
                            try {
                                printWriter.println("" + DebugOut.this.ID + " " + DebugOut.this.df.format(new Date()) + ": " + (string == null ? "" : string + " - ") + "Missing Privileges:");
                                securityException.printStackTrace(printWriter);
                                printWriter.println("" + DebugOut.this.ID + " " + DebugOut.this.df.format(new Date()) + ": " + (string == null ? "" : string + " - "));
                                throwable.printStackTrace(printWriter);
                                printWriter.flush();
                            }
                            finally {
                                try {
                                    printWriter.close();
                                }
                                catch (Throwable throwable2) {}
                            }
                        }
                        catch (Exception exception) {
                            if (DebugOut.this.failureCount == 0) {
                                System.err.println("Error opening log " + DebugOut.this.logFile.getPath() + ": " + exception.getMessage());
                            }
                            DebugOut.this.failureCount++;
                        }
                        return null;
                    }
                });
            }
        }
        catch (Exception exception) {
            if (this.failureCount == 0) {
                System.err.println("Error opening log " + this.logFile.getPath() + ": " + exception.getMessage());
            }
            ++this.failureCount;
        }
    }

    private PrintWriter openLog() throws IOException {
        boolean bl = true;
        if (!this.logChecked) {
            if (System.currentTimeMillis() - this.logFile.lastModified() > 0x6DDD00L) {
                bl = false;
            }
            this.logChecked = true;
        }
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), bl), StandardCharsets.UTF_8));
    }
}

