/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.qagent;

import de.qfs.apps.qftest.instrument.InstanceMap;
import de.qfs.apps.qftest.instrument.InstanceTracer;
import de.qfs.apps.qftest.instrument.ModuleHelper;
import de.qfs.apps.qftest.qagent.DebugOut;
import de.qfs.apps.qftest.qagent.PreLoader;
import de.qfs.apps.qftest.qagent.QAgent;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class InstanceWaiter
implements InstanceTracer.ConstructorListener {
    private DebugOut dbgOut;
    private PreLoader loader;
    private Set<String> watchedClasses = new HashSet<String>(Arrays.asList("de.qfs.apps.qfwin.QFWin", "de.qfs.apps.qfios.QFIOS", "javafx.scene.web.WebView", "com.teamdev.jxbrowser.chromium.javafx.BrowserView", "com.teamdev.jxbrowser.chromium.swing.BrowserView", "com.teamdev.jxbrowser.view.javafx.BrowserView", "com.teamdev.jxbrowser.view.swing.BrowserView", "com.teamdev.jxbrowser.view.swt.BrowserView", "org.eclipse.swt.browser.Browser"));

    public InstanceWaiter(DebugOut debugOut, PreLoader preLoader) {
        this.dbgOut = debugOut;
        this.loader = preLoader;
        String string = System.getenv("QFTEST_AGENT_IGNORE_INSTANCE_CLASSES");
        if (string != null) {
            for (String string2 : string.split(",")) {
                if (!this.watchedClasses.remove(string2)) continue;
                debugOut.debug("Ignoring class " + string2);
            }
        }
    }

    @Override
    public void instanceCreated(final Object object, Object[] objectArray) {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                block30: {
                    try {
                        String[] stringArray;
                        String string;
                        boolean bl;
                        Object object2;
                        Class clazz;
                        if (InstanceWaiter.isInstance(object, "java.awt.Toolkit")) {
                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "AWT toolkit created: " + object);
                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "current Thread:" + Thread.currentThread());
                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "current ThreadGroup:" + Thread.currentThread().getThreadGroup());
                            clazz = object.getClass();
                            try {
                                Class.forName("java.lang.Module");
                                ModuleHelper.openModule(clazz, InstanceWaiter.class);
                                ModuleHelper.openModule(Toolkit.class, InstanceWaiter.class);
                                InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "opened modules");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            while (true) {
                                try {
                                    object2 = clazz.getDeclaredField("atNames");
                                    bl = ((AccessibleObject)object2).isAccessible();
                                    try {
                                        if (!bl) {
                                            ((Field)object2).setAccessible(true);
                                        }
                                        if ((string = (String)((Field)object2).get(null)) != null) {
                                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "Accessibility toolkits: " + string);
                                            stringArray = string.split(",");
                                            int n = -1;
                                            for (int i = 0; i < stringArray.length; ++i) {
                                                if (!"de.qfs.apps.qftest.start.Connector".equals(stringArray[i])) continue;
                                                n = i;
                                                break;
                                            }
                                            if (n >= 0) {
                                                if (stringArray.length == 1) {
                                                    InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "Removing accessibility toolkits");
                                                    ((Field)object2).set(null, null);
                                                } else {
                                                    StringBuilder stringBuilder = new StringBuilder();
                                                    boolean bl2 = true;
                                                    for (int i = 0; i < stringArray.length; ++i) {
                                                        if (i == n) continue;
                                                        if (!bl2) {
                                                            stringBuilder.append(",");
                                                        }
                                                        stringBuilder.append(stringArray[i]);
                                                        bl2 = false;
                                                    }
                                                    String string2 = stringBuilder.toString();
                                                    InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "Setting accessibility toolkits: " + string2);
                                                    ((Field)object2).set(null, string2);
                                                }
                                            }
                                        }
                                    }
                                    finally {
                                        if (!bl) {
                                            ((Field)object2).setAccessible(false);
                                        }
                                    }
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                    if (clazz == Object.class) break;
                                    clazz = clazz.getSuperclass();
                                    continue;
                                }
                                break;
                            }
                        }
                        clazz = QAgent.Environment.getEnv("QFTEST_INSTRUMENT_EVENT_QUEUE");
                        object2 = QAgent.Environment.getEnv("QFTEST_INJECT_EVENT_QUEUE");
                        bl = !"false".equalsIgnoreCase((String)((Object)clazz)) && ("true".equalsIgnoreCase((String)((Object)clazz)) || "true".equalsIgnoreCase((String)object2));
                        string = object.getClass().getName();
                        if (InstanceWaiter.isInstance(object, "com.sun.javafx.tk.Toolkit") || bl && InstanceWaiter.isInstance(object, "java.awt.EventDispatchThread") || !bl && InstanceWaiter.isInstance(object, "java.awt.EventQueue") && !string.startsWith("de.qfs.apps.qftest.client") || InstanceWaiter.this.watchedClasses.contains(string)) {
                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "instance: " + object);
                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "thread: " + Thread.currentThread());
                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "Creating Connector");
                            stringArray = (String[])InstanceMap.getMap().get("de.qfs.apps.qftest.start.Connector");
                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "Cached Connector class: " + stringArray);
                            if (stringArray == null) {
                                stringArray = InstanceWaiter.this.loader.loadClass("de.qfs.apps.qftest.start.Connector");
                                InstanceMap.getMap().put("de.qfs.apps.qftest.start.Connector", stringArray);
                                InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "Created Connector class: " + stringArray);
                            }
                            stringArray.getConstructor(Object.class, ClassLoader.class).newInstance(object, InstanceWaiter.this.loader);
                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "Connector created");
                        }
                        if (!InstanceWaiter.isInstance(object, "com.teamdev.jxbrowser.engine.EngineOptions$Builder") || "false".equalsIgnoreCase(System.getProperty("qftest.web.jx.bridged"))) break block30;
                        InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "JxBrowser Engine Options Builder created: " + object);
                        try {
                            object.getClass().getMethod("disableWebSecurity", new Class[0]).invoke(object, new Object[0]);
                        }
                        catch (Exception exception) {
                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "Could not disable JX WebSecurity");
                        }
                        try {
                            object.getClass().getMethod("disableSandbox", new Class[0]).invoke(object, new Object[0]);
                        }
                        catch (Exception exception) {
                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "Could not disable JX sandbox");
                        }
                        for (String string3 : new String[]{"--allow-running-insecure-content", "--ignore-certificate-errors", "--disable-client-side-phishing-detection", "--disable-site-isolation-trials"}) {
                            InstanceWaiter.this.addJxEngineOptionsSwitch(object, string3);
                        }
                        if ("cdp".equalsIgnoreCase(System.getProperty("qftest.web.jx.bridged"))) {
                            int n = InstanceWaiter.this.getFreeTcpPort();
                            InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "Setting JX remote debugging port to: " + n);
                            try {
                                object.getClass().getMethod("remoteDebuggingPort", Integer.TYPE).invoke(object, n);
                            }
                            catch (Exception exception) {
                                InstanceWaiter.this.dbgOut.debug("InstanceWaiter", "Could not set remote debugging port: " + exception.getMessage());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        InstanceWaiter.this.dbgOut.debug("InstanceWaiter", throwable);
                    }
                }
                return null;
            }
        });
    }

    private int getFreeTcpPort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
    }

    private void addJxEngineOptionsSwitch(Object object, String string) {
        try {
            object.getClass().getMethod("addSwitch", String.class).invoke(object, string);
        }
        catch (Exception exception) {
            this.dbgOut.debug("InstanceWaiter", "Could not add JX switch " + string);
        }
    }

    static boolean isInstance(Object object, String string) {
        return InstanceWaiter.isInstance(object.getClass(), string);
    }

    static boolean isInstance(Class clazz, String string) {
        while (clazz != null) {
            Class<?>[] classArray;
            if (clazz.getName().equals(string)) {
                return true;
            }
            for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                if (!clazz2.getName().equals(string)) continue;
                return true;
            }
            if (clazz == Object.class) break;
            clazz = clazz.getSuperclass();
        }
        return false;
    }
}

