/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.qagent;

import de.qfs.apps.qftest.instrument.ModuleHelper;
import de.qfs.apps.qftest.qagent.DebugOut;
import de.qfs.apps.qftest.qagent.InstanceWaiter;
import de.qfs.apps.qftest.qagent.PreLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class QAgent {
    private static final String QFCONNECT_PROPERTIES_FILENAME = "qfconnect.properties";
    private static String VERSION = "Version|60000|";
    private static boolean isMain = false;
    private static boolean DEBUG = false;
    private static String rootdir;
    private static String basedir;
    private static String plugindir;
    private static String devcp;
    private static String logdir;
    private static String logfile;
    private static Object dbgDelegate;
    private static String engine;
    private static PreLoader preLoader;
    private static int ID;
    private static DebugOut dbgOut;
    private static Properties sysProps;
    private static final Object classLock;
    private static ClassFileTransformer cft;
    private static boolean initialized;
    private Properties properties;
    private Class caller;
    protected static boolean hasModules;
    protected boolean isWebStart;
    protected boolean isAsync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void premain(final String string, final Instrumentation instrumentation) {
        Object object = classLock;
        synchronized (object) {
            if (initialized) {
                QAgent.debug("Already initialized");
                if (DEBUG) {
                    try {
                        throw new RuntimeException("Dummy exception to get a stacktrace");
                    }
                    catch (RuntimeException runtimeException) {
                        QAgent.debug(runtimeException);
                    }
                }
                return;
            }
            isMain = "main".equals(string);
            QAgent.debug("isMain: " + isMain);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    QAgent.setupAgent(string, instrumentation, true);
                    QAgent.debug("premain done");
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void agentmain(final String string, final Instrumentation instrumentation) {
        DEBUG = true;
        System.err.println("this: " + QAgent.class);
        System.err.println("initialized: " + initialized);
        System.err.println("DEBUG: " + DEBUG);
        System.err.println("agentArgs: " + string);
        Object object = classLock;
        synchronized (object) {
            if (initialized) {
                QAgent.debug("Already initialized");
                System.err.println("already initialized " + initialized);
                if (DEBUG) {
                    try {
                        throw new RuntimeException("Dummy exception to get a stacktrace");
                    }
                    catch (RuntimeException runtimeException) {
                        QAgent.debug(runtimeException);
                    }
                }
                return;
            }
            initialized = true;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.getProperties().setProperty("qftest.agent.attach", "true");
                    QAgent.setupAgent(string, instrumentation, false);
                    QAgent.debug("agentmain done");
                    if (cft != null) {
                        try {
                            cft.getClass().getMethod("retransform", Instrumentation.class).invoke((Object)cft, instrumentation);
                            QAgent.debug("retransformation done");
                        }
                        catch (Throwable throwable) {
                            QAgent.debug(throwable);
                        }
                        boolean bl = false;
                        boolean bl2 = false;
                        for (Class clazz : instrumentation.getAllLoadedClasses()) {
                            Object object;
                            Object object2;
                            if (!bl && clazz != null && InstanceWaiter.isInstance(clazz, "java.awt.Toolkit")) {
                                QAgent.debug("Got AWT Toolkit class: " + clazz);
                                try {
                                    object2 = clazz.getMethod("getDefaultToolkit", new Class[0]).invoke(null, new Object[0]);
                                    QAgent.debug("toolkit: " + object2);
                                    object = clazz.getMethod("getSystemEventQueue", new Class[0]).invoke(object2, new Object[0]);
                                    QAgent.debug("eventQueue: " + object);
                                    Class<?> clazz2 = preLoader.loadClass("de.qfs.apps.qftest.start.Connector");
                                    QAgent.debug("Created Connector class: " + clazz2);
                                    clazz2.getConstructor(Object.class, ClassLoader.class).newInstance(object, preLoader);
                                    QAgent.debug("Connector created");
                                    bl = true;
                                }
                                catch (Throwable throwable) {
                                    QAgent.debug(throwable);
                                }
                            }
                            if (!bl2 && clazz != null && InstanceWaiter.isInstance(clazz, "com.sun.javafx.tk.Toolkit")) {
                                QAgent.debug("Got JavaFX Toolkit class: " + clazz);
                                if (hasModules) {
                                    ModuleHelper.openModule(clazz, this);
                                }
                                try {
                                    object2 = clazz.getMethod("getToolkit", new Class[0]).invoke(null, new Object[0]);
                                    QAgent.debug("toolkit: " + object2);
                                    object = preLoader.loadClass("de.qfs.apps.qftest.start.Connector");
                                    QAgent.debug("Created Connector class: " + object);
                                    ((Class)object).getConstructor(Object.class, ClassLoader.class).newInstance(object2, preLoader);
                                    QAgent.debug("Connector created");
                                    bl2 = true;
                                }
                                catch (Throwable throwable) {
                                    QAgent.debug(throwable);
                                }
                            }
                            if (bl && bl2) break;
                        }
                    }
                    return null;
                }
            });
            System.err.println("initialized now: " + initialized);
        }
    }

    private static void addTransformer(String string, Instrumentation instrumentation, boolean bl) {
        QAgent.debug("Adding instance trace transformer");
        try {
            cft = (ClassFileTransformer)preLoader.loadClass("de.qfs.apps.qftest.transform.InstanceTraceTransformer").getConstructor(String.class, Boolean.TYPE).newInstance(string, bl);
            QAgent.debug("cft: " + cft);
            instrumentation.addTransformer(cft, true);
            initialized = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            QAgent.debug(throwable);
        }
        if (!isMain) {
            QAgent.debug("setup InstanceTracer");
            try {
                Class<?> clazz = Class.forName("de.qfs.apps.qftest.instrument.InstanceTracer");
                Class<?> clazz2 = Class.forName("de.qfs.apps.qftest.instrument.InstanceTracer$ConstructorListener");
                QAgent.debug("itlClass: " + clazz2);
                try {
                    clazz.getField("instrumentation").set(null, instrumentation);
                }
                catch (Throwable throwable) {
                    QAgent.debug(throwable);
                }
                Object obj = preLoader.loadClass("de.qfs.apps.qftest.qagent.InstanceWaiter").getConstructor(dbgDelegate.getClass(), PreLoader.class).newInstance(dbgDelegate, preLoader);
                clazz.getMethod("addConstructorListener", String.class, clazz2).invoke(null, null, obj);
            }
            catch (Throwable throwable) {
                QAgent.debug(throwable);
            }
        }
        QAgent.debug("addTransformer done");
    }

    private static void setupAgent(String string, Instrumentation instrumentation, boolean bl) {
        boolean bl2 = false;
        try {
            Environment.init(string);
            if (hasModules) {
                ModuleHelper.setInstrumentation(instrumentation);
            }
            String string2 = null;
            if (!isMain) {
                string2 = QAgent.initHome();
                QAgent.debug("home: " + string2);
                if (string2 == null && !isMain) {
                    return;
                }
                String string3 = System.getProperty("sun.java.command");
                QAgent.debug("Start command: " + string3);
                if (string3 != null) {
                    String string4 = Environment.getEnv("QFTEST_AGENT_IGNORE_COMMAND");
                    if (string4 == null) {
                        string4 = "com.sun.deploy.panel.JreLocator,de.qfs.apps.qftest.shared.Util";
                    }
                    QAgent.debug("Commands to ignore: " + string4);
                    for (String string5 : string4.split(",")) {
                        if ((string5 = string5.trim()).startsWith("RE=")) {
                            if (!string3.matches(string5.substring(3))) continue;
                            QAgent.debug("Ignoring command: " + string3);
                            initialized = true;
                            return;
                        }
                        if (!string5.equals(string3)) continue;
                        QAgent.debug("Ignoring command: " + string3);
                        initialized = true;
                        return;
                    }
                    if (bl && hasModules && string == null && string3.startsWith("de.qfs.apps.qftest.start.")) {
                        bl2 = true;
                    }
                }
                if (string2 != null) {
                    QAgent.setupPaths(string2);
                }
            }
            try {
                ((Map)Class.forName("de.qfs.apps.qftest.instrument.InstanceMap").getMethod("getMap", new Class[0]).invoke(null, new Object[0])).put("de.qfs.apps.qftest.qagent.QAgent.instrumentation", instrumentation);
            }
            catch (Throwable throwable) {
                QAgent.debug(throwable);
            }
            QAgent.setupPreLoader();
        }
        catch (Throwable throwable) {
            QAgent.debug(throwable);
            throwable.printStackTrace();
            return;
        }
        QAgent.debug("Installing transformer for " + instrumentation);
        System.getProperties().setProperty("qftest.agent.attached", "true");
        QAgent.addTransformer(bl2 ? "slave" : string, instrumentation, !bl);
        if ("true".equalsIgnoreCase(Environment.getEnv("QFTEST_SSL_HACK"))) {
            QAgent.sslhack();
        }
    }

    private static String initHome() {
        File file;
        String string = Environment.from7Bit(Environment.getEnv("QFTEST_HOME"));
        if (string == null) {
            return null;
        }
        String string2 = Environment.from7Bit(Environment.getEnv("QFTEST_LOGDIR"));
        if (string2 != null && (file = new File(string2)).isDirectory()) {
            logfile = new File(file, "qfconnect.log").getAbsolutePath();
        }
        if (string != null && logfile == null && (file = new File(string, "log")).isDirectory()) {
            logfile = new File(file, "qfconnect.log").getAbsolutePath();
        }
        if (logfile != null) {
            dbgOut = new DebugOut("" + ID, new File(logfile));
            DEBUG = true;
            QAgent.debug("--------------------------------------------------------------------");
            QAgent.debug("Started: " + new Date());
            QAgent.debug("Agent version: " + VERSION.substring(8, VERSION.length() - 1));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupPaths(String string) {
        Serializable serializable;
        if (rootdir != null) {
            return;
        }
        sysProps = System.getProperties();
        QAgent.debug("System properties: " + sysProps);
        String string2 = Environment.getEnv("QFTEST_VERSION");
        String string3 = Environment.from7Bit(Environment.getEnv("QFTEST_VERSIONDIR"));
        plugindir = Environment.from7Bit(Environment.getEnv("QFTEST_PLUGINDIR"));
        devcp = Environment.from7Bit(Environment.getEnv("QFTEST_DEV_CLASSPATH"));
        if ("".equals(devcp)) {
            devcp = null;
        }
        logdir = Environment.from7Bit(Environment.getEnv("QFTEST_LOGDIR"));
        String string4 = Environment.from7Bit(Environment.getEnv("QFTEST_USERDIR"));
        String string5 = Environment.from7Bit(Environment.getEnv("QFTEST_SYSTEMDIR"));
        QAgent.debug("QFTEST_HOME: " + string);
        QAgent.debug("QFTEST_VERSION: " + string2);
        QAgent.debug("QFTEST_VERSIONDIR: " + string3);
        QAgent.debug("QFTEST_DEV_CLASSPATH: " + devcp);
        QAgent.debug("QFTEST_PLUGINDIR: " + plugindir);
        QAgent.debug("QFTEST_LOGDIR: " + logdir);
        QAgent.debug("QFTEST_USERDIR: " + string4);
        QAgent.debug("QFTEST_SYSTEMDIR: " + string5);
        if (string4 != null) {
            sysProps.put("qftest.userconfigdir", string4);
        }
        if (string5 != null) {
            sysProps.put("qftest.systemconfigdir", string5);
        }
        File file = new File(string);
        sysProps.put("qftest.home", string);
        File file2 = null;
        if (string3 != null) {
            file2 = new File(string3);
            sysProps.put("qftest.versiondir", string3);
        } else if (string2 != null) {
            file2 = new File(file, "qftest-" + string2);
            if (!file2.isDirectory()) {
                QAgent.debug("baseDir is not a directory: " + file2.getPath());
                file2 = null;
            } else {
                sysProps.put("qftest.versiondir", file2.getPath());
            }
        }
        if (file2 == null) {
            QAgent.debug("No baseDir, giving up");
            return;
        }
        basedir = file2.getAbsolutePath();
        if (plugindir != null) {
            sysProps.put("qftest.plugindir", plugindir);
        }
        rootdir = file.getAbsolutePath();
        if (logdir == null && string5 != null && ((File)(serializable = new File(string5, "log"))).isDirectory()) {
            logdir = ((File)serializable).getAbsolutePath();
        }
        if (logdir == null && string4 != null && ((File)(serializable = new File(string4, "log"))).isDirectory()) {
            logdir = ((File)serializable).getAbsolutePath();
        }
        if (logdir == null && file != null) {
            logdir = new File(file, "log").getAbsolutePath();
        }
        serializable = new Properties();
        File file3 = null;
        if (string4 != null) {
            file3 = new File(string4, QFCONNECT_PROPERTIES_FILENAME);
        }
        if (file3 == null || !file3.exists()) {
            file3 = string5 != null ? new File(string5, QFCONNECT_PROPERTIES_FILENAME) : new File(file, QFCONNECT_PROPERTIES_FILENAME);
        }
        QAgent.debug("Properties file:" + file3.getPath());
        try {
            FileInputStream fileInputStream = new FileInputStream(file3);
            try {
                ((Properties)serializable).load(fileInputStream);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            QAgent.debug("No qfconnect.properties file");
        }
        QAgent.debug("Connector properties:" + ((Properties)serializable).toString());
        for (Object bl2 : ((Properties)serializable).keySet()) {
            if (!((String)bl2).startsWith("qflib.") || sysProps.containsKey((String)bl2)) continue;
            String string6 = QAgent.expand(((Properties)serializable).getProperty((String)bl2));
            QAgent.debug("Setting property: " + bl2 + "=" + string6);
            sysProps.put(bl2, string6);
        }
        if (System.getProperty("os.name").toUpperCase().indexOf("MAC OS X") >= 0) {
            boolean bl = "true".equals(System.getProperty("qfs.laf.useScreenMenuBar"));
            boolean bl2 = "false".equals(((Properties)serializable).getProperty("qfs.apple.noScreenMenuBar"));
            if (bl) {
                System.getProperties().put("apple.laf.useScreenMenuBar", "true");
            } else if (!bl2) {
                System.getProperties().put("apple.laf.useScreenMenuBar", "false");
            }
        }
    }

    private static void setupBootstrapPath(Instrumentation instrumentation) {
        try {
            String string;
            if (QAgent.class.getProtectionDomain().getCodeSource() != null) {
                string = QAgent.class.getProtectionDomain().getCodeSource().getLocation().getFile();
                QAgent.debug("my loc: " + string);
            } else {
                string = new File(new File(basedir, "misc"), "qfconnect.jar").getPath();
                QAgent.debug("fallback loc: " + string);
            }
            File file = new File(new File(string).getParent(), "qfinst.jar");
            QAgent.debug("path: " + file + ", exists: " + file.exists());
            if (!file.exists()) {
                file = new File(new File(basedir, "misc"), "qfinst.jar");
                QAgent.debug("fallback path: " + file + ", exists: " + file.exists());
            }
            JarFile jarFile = new JarFile(file);
        }
        catch (Throwable throwable) {
            QAgent.debug(throwable);
        }
    }

    private static void setupPreLoader() throws Exception {
        Object object;
        Object object2;
        URL uRL;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (QAgent.class.getProtectionDomain().getCodeSource() != null) {
            uRL = QAgent.class.getProtectionDomain().getCodeSource().getLocation();
            QAgent.debug("setupPreLoader - my URL: " + uRL);
        } else {
            uRL = new File(new File(basedir, "misc"), "qfconnect.jar").toURI().toURL();
            QAgent.debug("setupPreLoader - fallback url: " + uRL);
        }
        arrayList.add(uRL);
        QAgent.debug("engine: " + engine);
        boolean bl = "web".equals(engine) || "win".equals(engine);
        boolean bl2 = false;
        if (devcp != null) {
            object2 = new StringTokenizer(devcp, ";" + File.pathSeparator);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                if (!bl && ((String)object).indexOf("qflib") > 0) {
                    arrayList.add(QAgent.makeURL(new File((String)object)));
                    bl = true;
                }
                if (((String)object).indexOf("asm.jar") <= 0) continue;
                arrayList.add(QAgent.makeURL(new File((String)object)));
                bl2 = true;
            }
            if (!bl) {
                object2 = new File(basedir, "qflib");
                QAgent.addURL(arrayList, new File((File)object2, "qflib.jar"));
            }
            if (!bl2) {
                object2 = new File(basedir, "lib");
                QAgent.addURL(arrayList, new File((File)object2, "asm.jar"));
            }
        }
        if (!bl && basedir != null) {
            object2 = new File(basedir, "qflib/qflib.jar");
            QAgent.debug("qflib: " + object2);
            if (((File)object2).exists()) {
                arrayList.add(QAgent.makeURL((File)object2));
                bl = true;
            }
        }
        if (!bl2 && basedir != null) {
            object2 = new File(basedir, "lib/asm.jar");
            QAgent.debug("asm: " + object2);
            if (((File)object2).exists()) {
                arrayList.add(QAgent.makeURL((File)object2));
                bl2 = true;
            }
        }
        try {
            QAgent.debug("preloader urls: " + arrayList);
            object2 = arrayList.toArray(new URL[0]);
            QAgent.debug("Creating pre loader");
            preLoader = new PreLoader(dbgOut, (URL[])object2, ClassLoader.getSystemClassLoader());
            QAgent.debug("preLoader: " + preLoader);
        }
        catch (Throwable throwable) {
            QAgent.debug(throwable);
        }
        try {
            dbgDelegate = preLoader.loadClass("de.qfs.apps.qftest.qagent.DebugOut").getConstructor(String.class, File.class).newInstance("" + ID, logfile == null ? null : new File(logfile));
            QAgent.debug("delegate: " + dbgDelegate);
            if (logfile != null && dbgOut != null) {
                dbgOut.setDelegate(dbgDelegate);
            }
        }
        catch (Throwable throwable) {
            QAgent.debug(throwable);
        }
        try {
            ((Map)Class.forName("de.qfs.apps.qftest.instrument.InstanceMap").getMethod("getMap", new Class[0]).invoke(null, new Object[0])).put("de.qfs.apps.qftest.qagent.QAgent.preLoader", preLoader);
        }
        catch (Throwable throwable) {
            QAgent.debug(throwable);
        }
        if (Boolean.valueOf(System.getProperty("qflib.loginstrumentation", "false")).booleanValue()) {
            try {
                object2 = preLoader.loadClass("de.qfs.lib.util.LogSetup");
                ((Class)object2).getMethod("globalSetupInitialLogging", String.class).invoke(null, "qfclient");
                object = preLoader.loadClass("de.qfs.lib.log.Log");
                ((Class)object).getMethod("setOutputLevel", Integer.TYPE).invoke(null, 2);
                QAgent.debug("logging initialized");
            }
            catch (Throwable throwable) {
                QAgent.debug(throwable);
            }
        }
    }

    private static void debug(String string) {
        if (!DEBUG) {
            return;
        }
        if (dbgOut != null) {
            dbgOut.debug("Agent", string);
        } else {
            System.err.println(string);
        }
    }

    private static void debug(Throwable throwable) {
        if (!DEBUG) {
            return;
        }
        if (dbgOut != null) {
            dbgOut.debug("Agent", throwable);
        } else {
            throwable.printStackTrace();
        }
    }

    private static String expand(String string) {
        int n = string.indexOf("{");
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n >= 0) {
            stringBuffer.append(string.substring(n2, n));
            if (string.substring(n).startsWith("{rootdir}")) {
                stringBuffer.append(rootdir);
                n2 = n + 9;
            } else if (string.substring(n).startsWith("{basedir}")) {
                stringBuffer.append(basedir);
                n2 = n + 9;
            } else if (string.substring(n).startsWith("{logdir}")) {
                stringBuffer.append(logdir);
                n2 = n + 8;
            } else if (string.substring(n).startsWith("{id}")) {
                stringBuffer.append(ID);
                n2 = n + 4;
            } else {
                stringBuffer.append("{");
                n2 = n + 1;
            }
            n = string.indexOf("{", n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private static void addURL(ArrayList<URL> arrayList, File file) throws Exception {
        if (!file.exists()) {
            QAgent.debug("No such file: " + file);
            return;
        }
        arrayList.add(QAgent.makeURL(file));
    }

    private static URL makeURL(File file) throws Exception {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string = file.getAbsolutePath();
        }
        string = string.replace(File.separatorChar, '/');
        StringBuffer stringBuffer = new StringBuffer();
        if (System.getProperty("java.version").compareTo("1.4") >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (" ".equals(string2)) {
                    stringBuffer.append("%20");
                    continue;
                }
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        if (file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file://" + (string.startsWith("/") ? "" : "/") + string);
    }

    private static void sslhack() {
        QAgent.debug("SSL hack activated");
        try {
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            SSLContext.getInstance("SSL").init(null, trustManagerArray, null);
        }
        catch (Throwable throwable) {
            QAgent.debug("SSL hack failed");
            QAgent.debug(throwable);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DEBUG = "true".equalsIgnoreCase(System.getenv("QFTEST_DEBUG_AGENT"));
                return null;
            }
        });
        ID = (int)(Math.random() * 10000.0);
        classLock = new Object();
        try {
            Class.forName("java.lang.Module");
            hasModules = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class Environment {
        private static final boolean OS_IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
        private static final Map<String, String> environment = new HashMap<String, String>();

        public static void init(String string) {
            String string2 = string == null ? System.getProperty("qftest.envfile") : string;
            File file = null;
            if (string2 != null) {
                System.getProperties().setProperty("qftest.envfile", string2);
                string2 = string2.replace("{home}", System.getProperty("user.home"));
                file = new File(string2);
            }
            if (file == null) {
                Object object = System.getenv(OS_IS_WINDOWS ? "TEMP" : "TMP");
                if (object == null && (object = System.getProperty("qftest.tmpdir")) != null) {
                    object = ((String)object).replace("{home}", System.getProperty("user.home"));
                }
                if (object != null && new File((String)object).isDirectory() && (!(file = new File((String)object, "_qftest.env")).exists() || System.currentTimeMillis() - file.lastModified() >= 120000L)) {
                    file = null;
                }
            }
            if (file != null) {
                try {
                    Environment.readFromFile(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (string != null) {
                for (String string3 : string.split("|")) {
                    int n = string3.indexOf("=");
                    if (n <= 0) continue;
                    Environment.setEnv(string3.substring(0, n), string3.substring(n + 1));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getEnv(String string) {
            String string2 = Environment.transformName(string);
            Map<String, String> map = environment;
            synchronized (map) {
                if (environment.containsKey(string2)) {
                    return environment.get(string2);
                }
                return System.getenv(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setEnv(String string, String string2) {
            Map<String, String> map = environment;
            synchronized (map) {
                environment.put(Environment.transformName(string), string2);
            }
        }

        public static String from7Bit(String string) {
            if (string == null) {
                return null;
            }
            int n = string.indexOf("*");
            if (n < 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
            for (int i = n; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c != '*') {
                    stringBuffer.append(c);
                    continue;
                }
                if (i + 4 >= string.length()) {
                    return stringBuffer.toString();
                }
                try {
                    int n2 = Integer.parseInt(string.substring(i + 1, i + 5), 16);
                    stringBuffer.append((char)n2);
                    i += 4;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return stringBuffer.toString();
                }
            }
            return stringBuffer.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void readFromFile(File file) throws IOException {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    int n = string.indexOf("=");
                    if (n > 0) {
                        Environment.setEnv(string.substring(0, n), string.substring(n + 1));
                    }
                    string = bufferedReader.readLine();
                }
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable) {}
            }
        }

        private static final String transformName(String string) {
            return OS_IS_WINDOWS ? string.toUpperCase() : string;
        }
    }
}

