/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.qftest.launch;

import de.qfs.qftest.Activator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsMainTab;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public class QFSInitSettingsTab
extends ExternalToolsMainTab {
    private ILaunchConfiguration launchConfiguration;
    private Label consoleParameterLabel;
    private Text consoleParameterTextfield;
    private Label licensePathLabel;
    private Text licensePathTextfield;
    private Button licensePathBrowseButton;
    private Label systemConfigPathLabel;
    private Text systemConfigPathTextfield;
    private Button systemConfigPathBrowseButton;
    private Label userConfigPathLabel;
    private Text userConfigPathTextfield;
    private Button userConfigPathBrowseButton;
    private Composite comp;

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createParameterComponent(mainComposite);
        Dialog.applyDialogFont((Control)parent);
    }

    public String getName() {
        return "Initial Settings";
    }

    protected void createParameterComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Parameter: (New settings will only take effect after a restart of QF-Test with Eclipse)");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.comp = SWTFactory.createComposite((Composite)group, (Font)parent.getFont(), (int)3, (int)2, (int)1808, (int)0, (int)0);
        this.licensePathLabel = new Label(this.comp, 0);
        this.licensePathLabel.setText("Path to license file:");
        this.licensePathTextfield = SWTFactory.createSingleText((Composite)this.comp, (int)1);
        this.licensePathTextfield.addModifyListener((ModifyListener)this.fListener);
        this.licensePathBrowseButton = this.createPushButton(this.comp, LaunchConfigurationsMessages.CommonTab__Browse_6, null);
        this.licensePathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                QFSInitSettingsTab.this.handleFileLocationButtonSelected(QFSInitSettingsTab.this.licensePathTextfield);
            }
        });
        this.systemConfigPathLabel = new Label(this.comp, 0);
        this.systemConfigPathLabel.setText("Path to system config file:");
        this.systemConfigPathTextfield = SWTFactory.createSingleText((Composite)this.comp, (int)1);
        this.systemConfigPathTextfield.addModifyListener((ModifyListener)this.fListener);
        this.systemConfigPathBrowseButton = this.createPushButton(this.comp, LaunchConfigurationsMessages.CommonTab__Browse_6, null);
        this.systemConfigPathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                QFSInitSettingsTab.this.handleFileLocationButtonSelected(QFSInitSettingsTab.this.systemConfigPathTextfield);
            }
        });
        this.userConfigPathLabel = new Label(this.comp, 0);
        this.userConfigPathLabel.setText("Path to user config file:");
        this.userConfigPathTextfield = SWTFactory.createSingleText((Composite)this.comp, (int)1);
        this.userConfigPathTextfield.addModifyListener((ModifyListener)this.fListener);
        this.userConfigPathBrowseButton = this.createPushButton(this.comp, LaunchConfigurationsMessages.CommonTab__Browse_6, null);
        this.userConfigPathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                QFSInitSettingsTab.this.handleFileLocationButtonSelected(QFSInitSettingsTab.this.userConfigPathTextfield);
            }
        });
        this.consoleParameterLabel = new Label(this.comp, 0);
        this.consoleParameterLabel.setText("QF-Test executable parameters:");
        this.consoleParameterTextfield = SWTFactory.createSingleText((Composite)this.comp, (int)2);
        this.consoleParameterTextfield.addModifyListener((ModifyListener)this.fListener);
    }

    public void handleFileLocationButtonSelected(Text textField) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFilterPath(textField.getText());
        String text = fileDialog.open();
        if (text != null) {
            textField.setText(text);
        }
    }

    protected void updateParameter(ILaunchConfiguration configuration) {
        try {
            String consoleParameters = configuration.getAttribute("qfs_exec_console_parameters", "");
            this.consoleParameterTextfield.setText(consoleParameters);
            String licensePathDir = configuration.getAttribute("qfs_path_to_license_dir", "");
            this.licensePathTextfield.setText(licensePathDir);
            String systemConfigPathDir = configuration.getAttribute("qfs_path_to_system_config_dir", "");
            this.systemConfigPathTextfield.setText(systemConfigPathDir);
            String userConfigPathDir = configuration.getAttribute("qfs_path_to_user_config_dir", "");
            this.userConfigPathTextfield.setText(userConfigPathDir);
        }
        catch (CoreException ce) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.qfs.qftest", "update parameter", (Throwable)ce));
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        this.fInitializing = true;
        this.updateParameter(configuration);
        this.fInitializing = false;
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String consoleParameters = this.consoleParameterTextfield.getText().trim();
        if (consoleParameters.length() == 0) {
            configuration.setAttribute("qfs_exec_console_parameters", null);
        } else {
            configuration.setAttribute("qfs_exec_console_parameters", consoleParameters);
        }
        String licensePathDir = this.licensePathTextfield.getText().trim();
        if (licensePathDir.length() == 0) {
            configuration.setAttribute("qfs_path_to_license_dir", null);
        } else {
            configuration.setAttribute("qfs_path_to_license_dir", licensePathDir);
        }
        String systemConfigPathDir = this.systemConfigPathTextfield.getText().trim();
        if (systemConfigPathDir.length() == 0) {
            configuration.setAttribute("qfs_path_to_system_config_dir", null);
        } else {
            configuration.setAttribute("qfs_path_to_system_config_dir", systemConfigPathDir);
        }
        String userConfigPathDir = this.userConfigPathTextfield.getText().trim();
        if (userConfigPathDir.length() == 0) {
            configuration.setAttribute("qfs_path_to_user_config_dir", null);
        } else {
            configuration.setAttribute("qfs_path_to_user_config_dir", userConfigPathDir);
        }
        if (this.argumentField != null) {
            String arguments = this.argumentField.getText().trim();
            if (arguments.length() == 0) {
                configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
            } else {
                configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
            }
        }
        configuration.setAttribute("editedByExternalToolsMainTab", false);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }
}

