/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.qftest.launch;

import org.eclipse.core.externaltools.internal.launchConfigurations.ExternalToolsCoreUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsMainTab;

public class QFSLaunchConfigurationTab
extends ExternalToolsMainTab {
    private static String os = System.getProperty("os.name").toLowerCase();
    private static boolean isUnix = os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    private static boolean isWindows = os.indexOf("win") >= 0;
    private static boolean isMac = os.indexOf("mac") >= 0;

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createLocationComponent(mainComposite);
        this.createArgumentComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 1);
        Dialog.applyDialogFont((Control)parent);
    }

    protected String getLocationLabel() {
        return "QF-Test executable";
    }

    protected void createWorkDirectoryComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = "QF-Test version directory";
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.workDirectoryField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.workDirectoryField.setLayoutData((Object)data);
        this.workDirectoryField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.workDirectoryField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.workspaceWorkingDirectoryButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Browse_Wor_kspace____6, null);
        this.workspaceWorkingDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.workspaceWorkingDirectoryButton, String.valueOf(group.getText()) + " " + this.workspaceWorkingDirectoryButton.getText());
        this.fileWorkingDirectoryButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Browse_F_ile_System____7, null);
        this.fileWorkingDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fileWorkingDirectoryButton, String.valueOf(group.getText()) + " " + this.fileWorkingDirectoryButton.getText());
        this.variablesWorkingDirectoryButton = this.createPushButton(buttonComposite, ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_32, null);
        this.variablesWorkingDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.variablesWorkingDirectoryButton, String.valueOf(group.getText()) + " " + this.variablesWorkingDirectoryButton.getText());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        this.updateLocation(configuration);
        this.updateArgument(configuration);
        this.fInitializing = false;
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String location = this.locationField.getText().trim();
        if (location.length() == 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", location);
        }
        String arguments = this.argumentField.getText().trim();
        if (arguments.length() == 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean newConfig = false;
        try {
            newConfig = launchConfig.getAttribute("editedByExternalToolsMainTab", false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (this.validateLocation(newConfig)) {
            IPath workingDirectory = null;
            try {
                workingDirectory = ExternalToolsCoreUtil.getLocation((ILaunchConfiguration)launchConfig);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return false;
            }
            IPath location = null;
            if (workingDirectory != null) {
                location = workingDirectory;
            }
            if (location != null && location.toFile() != null && location.toFile().exists()) {
                return true;
            }
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_External_tool_working_directory_does_not_exist_or_is_invalid_21);
            return false;
        }
        return false;
    }
}

