/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.qftest.launch;

import de.qfs.qftest.Activator;
import de.qfs.qftest.launch.QFSLauncher;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class QFSLaunchShortcut
implements ILaunchShortcut {
    public void lanuchQFTSuite(IPath path, String mode) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFile(path);
        ILaunchConfiguration configuration = this.getConfiguration(file);
        if (configuration != null) {
            String strPath = path.toOSString();
            QFSLauncher.setSuitePath(strPath);
            DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        IFile file;
        ILaunchConfiguration configuration;
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IFile && (configuration = this.getConfiguration(file = (IFile)element)) != null) {
            QFSLauncher.setSuitePath(file.getLocation().makeAbsolute().toOSString());
            DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
        }
    }

    public ILaunchConfiguration getConfiguration(IFile file) {
        ArrayList<ILaunchConfiguration> candiates = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configurations = this.getLaunchManager().getLaunchConfigurations(this.getLaunchType());
            int i = 0;
            while (i < configurations.length) {
                ILaunchConfiguration configuration = configurations[i];
                candiates.add(configuration);
                ++i;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.qfs.qftest", "get launch config", (Throwable)e));
        }
        if (!candiates.isEmpty()) {
            return this.chooseConfiguration(candiates);
        }
        return this.newConfiguration(file);
    }

    public ILaunchConfigurationType getLaunchType() {
        ILaunchManager manager = this.getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("de.qfs.qftest.launchConfigurationType_ID");
        return type;
    }

    public ILaunchManager getLaunchManager() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        return manager;
    }

    public ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        if (configList.size() == 1) {
            return configList.get(0);
        }
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(DebugUIPlugin.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Select Configuraiton");
        dialog.setMessage("&Select an existing configuration:");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        MessageDialog.openInformation((Shell)DebugUIPlugin.getShell(), (String)"Info", (String)"No QF-Test Launch Config, please create one.");
        return null;
    }

    public ILaunchConfiguration newConfiguration(IFile file) {
        ILaunchConfigurationType type = this.getLaunchType();
        try {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, file.getName());
            ILaunchConfiguration configuration = workingCopy.doSave();
            ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)"run");
            StructuredSelection sel = new StructuredSelection((Object)configuration);
            DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)DebugUIPlugin.getShell(), (IStructuredSelection)sel, (String)launchGroup.getIdentifier());
            return configuration;
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.qfs.qftest", "create new launch config", (Throwable)e));
            return null;
        }
    }

    public void launch(IEditorPart editor, String mode) {
    }
}

