/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.qftest.launch;

import de.qfs.lib.log.Logger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import de.qfs.lib.util.ProcessManager;
import de.qfs.qftest.Activator;
import de.qfs.qftest.command.CommandHandler;
import de.qfs.qftest.command.CommandListenerImpl;
import de.qfs.qftest.launch.QFSMainTab;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.externaltools.internal.launchConfigurations.ExternalToolsCoreUtil;
import org.eclipse.core.externaltools.internal.launchConfigurations.ProgramLaunchDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class QFSLauncher
extends ProgramLaunchDelegate
implements CommandHandler {
    private static final Logger logger = new Logger("de.qfs.qftest.launch.QFSLauncher");
    private static String suitePath;
    private Properties reuseProps;
    private CommandListenerImpl commandListener;

    public CommandListenerImpl getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new CommandListenerImpl();
        }
        return this.commandListener;
    }

    public static synchronized String getSuitePath() {
        return suitePath;
    }

    public static synchronized void setSuitePath(String sP) {
        suitePath = sP;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        this.launchQFTest(configuration, mode, launch, monitor);
        this.launchSUT(configuration, mode, launch, monitor);
    }

    public void launchSUT(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        String usedLaunchConfigID = configuration.getAttribute("qfs_used_launch_config", null);
        ILaunchConfiguration sutLaunchConfig = this.getSUTLaunchConfig(usedLaunchConfigID);
        if (sutLaunchConfig != null) {
            sutLaunchConfig = this.addQFTestEnvVars(configuration, sutLaunchConfig);
            String usedEngine = configuration.getAttribute("qfs_used_engine", "");
            if ("qfs_used_engine_swt".equals(usedEngine)) {
                String swtFolder = configuration.getAttribute("qfs_swt_dir", "");
                System.out.println("used swt engine, try to instrument swt.jar in folder: " + swtFolder);
                IPath location = ExternalToolsCoreUtil.getLocation((ILaunchConfiguration)configuration);
                String qftestBinFolder = location.uptoSegment(location.segmentCount() - 1).toOSString();
                String qftestExe = location.toOSString();
                File filesutdir = null;
                try {
                    filesutdir = new File(swtFolder);
                }
                catch (Exception e1) {
                    this.logException("build sut dir", e1);
                }
                String sutdir = "";
                if (filesutdir != null) {
                    sutdir = filesutdir.getAbsolutePath();
                }
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{qftestExe, "-batch", "-variable", "sutdir=" + sutdir, "-test", "qfs.swt.instrument.setup", String.valueOf(qftestBinFolder) + File.separator + ".." + File.separator + "include" + File.separator + "qfs.qft"});
                    int n = process.waitFor();
                }
                catch (InterruptedException e) {
                    this.logException("run instrument swt process", e);
                }
                catch (IOException e) {
                    this.logException("run instrument swt process", e);
                }
            }
            sutLaunchConfig.launch(mode, monitor);
        }
        if (monitor.isCanceled()) {
            return;
        }
    }

    private void logException(String message, Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "de.qfs.qftest", message, e));
    }

    private void logWarning(String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(2, "de.qfs.qftest", message));
    }

    private void logInfo(String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(1, "de.qfs.qftest", message));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launchQFTest(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        location = ExternalToolsCoreUtil.getLocation((ILaunchConfiguration)configuration);
        qftestBinFolder = location.uptoSegment(location.segmentCount() - 1);
        qftestFolder = location.uptoSegment(location.segmentCount() - 2);
        cmdLine = location.toOSString();
        running = false;
        counter = 0;
        consoleParameters = configuration.getAttribute("qfs_exec_console_parameters", "").trim();
        licensePathDir = configuration.getAttribute("qfs_path_to_license_dir", "").trim();
        systemConfigPathDir = configuration.getAttribute("qfs_path_to_system_config_dir", "").trim();
        userConfigPathDir = configuration.getAttribute("qfs_path_to_user_config_dir", "").trim();
        commandLine = new ArrayList<String>();
        commandLine.add(cmdLine);
        if (!Misc.emptyOrNull((String)licensePathDir)) {
            commandLine.add("-license");
            commandLine.add(licensePathDir);
        }
        if (!Misc.emptyOrNull((String)systemConfigPathDir)) {
            commandLine.add("-systemcfg");
            commandLine.add(systemConfigPathDir);
        }
        if (!Misc.emptyOrNull((String)userConfigPathDir)) {
            commandLine.add("-usercfg");
            commandLine.add(userConfigPathDir);
        }
        if (Misc.emptyOrNull((String)consoleParameters)) ** GOTO lbl-1000
        var19_16 = ProcessManager.translateCommandline((String)consoleParameters);
        var18_17 = var19_16.length;
        var17_18 = 0;
        while (var17_18 < var18_17) {
            argument = var19_16[var17_18];
            commandLine.add(argument);
            ++var17_18;
        }
        try lbl-1000:
        // 3 sources

        {
            while (!running) {
                try {
                    if (counter >= 180) {
                        this.logWarning("Could not connect to QF-Test, tried " + counter + " times.");
                        return;
                    }
                    running = this.testQFTestReuse(configuration, qftestFolder.toOSString());
                    System.out.println("QF-Test running: " + running);
                    v0 = firstRun = counter == 0;
                    if (!running && firstRun) {
                        this.logInfo("Start qftest: " + commandLine.toString());
                        Runtime.getRuntime().exec(commandLine.toArray(new String[commandLine.size()]), null, qftestFolder.toFile());
                        System.out.println("First start of QF-Test, initial wait time: 3000 ms.");
                        Thread.sleep(3000L);
                    } else if (running) {
                        this.setQFTestPluginProperties(configuration, qftestFolder.toOSString());
                        this.loadQFTestSuite(qftestFolder.toOSString());
                        return;
                    }
                    ++counter;
                    if (!monitor.isCanceled()) continue;
                    return;
                }
                catch (Exception e) {
                    this.logException("failed to check for a running qftest", e);
                    break;
                }
            }
        }
        catch (Throwable t) {
            this.logException("failed to check for a running qftest", t);
        }
        if (monitor.isCanceled()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testQFTestReuse(ILaunchConfiguration configuration, String qftestPath) {
        CommandListenerImpl cl;
        Properties props;
        block18: {
            if (QFSLauncher.logger.level >= 7) {
                logger.log(7, "testReuse(String)", QFSLauncher.logger.level < 8 ? "" : "qftestPath: " + qftestPath);
            }
            props = new Properties();
            props.put("dir", qftestPath);
            cl = this.getCommandListener();
            cl.addCommandHandler("acceptReuse", this);
            QFSLauncher qFSLauncher = this;
            synchronized (qFSLauncher) {
                block17: {
                    if (this.reuseProps == null) break block18;
                    if (!cl.reply(this.reuseProps, "ping", new Properties(), true)) break block17;
                    return true;
                }
                this.reuseProps = null;
            }
        }
        String display = null;
        if (!Misc.OS_IS_WINDOWS) {
            display = System.getenv("DISPLAY");
        }
        if (display != null) {
            props.put("display", display);
        }
        props.put("user", System.getProperty("user.name"));
        if (!QFSMainTab.isValidQFTestVersion(configuration)) {
            return false;
        }
        HashMap<String, Pair<Boolean, String>> versionMap = QFSMainTab.getVersionMap();
        Pair<Boolean, String> pathPair = versionMap.get(qftestPath);
        if (pathPair != null) {
            props.put("version", pathPair.getSecond());
        }
        cl.sendMulti("lookupReuse", props, 0, true);
        long until = System.currentTimeMillis() + 500L;
        while (true) {
            QFSLauncher qFSLauncher = this;
            synchronized (qFSLauncher) {
                if (this.reuseProps != null) {
                    break;
                }
                long rest = until - System.currentTimeMillis();
                if (rest <= 0L) {
                    break;
                }
                try {
                    this.wait(rest);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.reuseProps != null;
    }

    private boolean loadQFTestSuite(String qftestPath) {
        Properties props = new Properties();
        props.put("dir", qftestPath);
        CommandListenerImpl cl = this.getCommandListener();
        cl.addCommandHandler("loadFiles", this);
        String display = null;
        if (!Misc.OS_IS_WINDOWS) {
            display = System.getenv("DISPLAY");
        }
        if (display != null) {
            props.put("display", display);
        }
        if (QFSLauncher.getSuitePath() != null) {
            props.put("file0", QFSLauncher.getSuitePath());
            QFSLauncher.setSuitePath(null);
        }
        props.put("user", System.getProperty("user.name"));
        HashMap<String, Pair<Boolean, String>> versionMap = QFSMainTab.getVersionMap();
        Pair<Boolean, String> pathPair = versionMap.get(qftestPath);
        if (pathPair != null) {
            props.put("version", pathPair.getSecond());
        }
        cl.sendMulti("loadFiles", props, 0, true);
        return true;
    }

    private boolean setQFTestPluginProperties(ILaunchConfiguration configuration, String qftestPath) {
        Properties props = new Properties();
        props.put("dir", qftestPath);
        CommandListenerImpl cl = this.getCommandListener();
        cl.addCommandHandler("eclipsePlugin", this);
        if (configuration != null) {
            try {
                String runlogPathDir = configuration.getAttribute("qfs_path_to_runlog_dir", "");
                String licensePathDir = configuration.getAttribute("qfs_path_to_license_dir", "");
                String systemConfigPathDir = configuration.getAttribute("qfs_path_to_system_config_dir", "");
                String userConfigPathDir = configuration.getAttribute("qfs_path_to_user_config_dir", "");
                props.put("runlogdir", runlogPathDir);
                props.put("license", licensePathDir);
                props.put("systemcfg", systemConfigPathDir);
                props.put("usercfg", userConfigPathDir);
                List properties = configuration.getAttribute("qfs_commandline_variables", Collections.EMPTY_LIST);
                StringBuilder builder = new StringBuilder();
                for (String property : properties) {
                    builder.append(String.valueOf(property) + ",");
                }
                props.put("variables", builder.toString());
                properties = configuration.getAttribute("qfs_startup_nodes", Collections.EMPTY_LIST);
                builder = new StringBuilder();
                for (String property : properties) {
                    builder.append(String.valueOf(property) + ",");
                }
                props.put("startupnodes", builder.toString());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        cl.sendMulti("eclipsePlugin", props, 0, true);
        return true;
    }

    private ILaunchConfiguration addQFTestEnvVars(ILaunchConfiguration qftestLaunchConfig, ILaunchConfiguration sutLaunchConfig) {
        ILaunchConfigurationWorkingCopy workCopy = null;
        try {
            Map envVars = sutLaunchConfig.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap());
            IPath location = ExternalToolsCoreUtil.getLocation((ILaunchConfiguration)qftestLaunchConfig);
            String qftestHome = location.removeLastSegments(3).toOSString();
            String qftestVersionDir = location.removeLastSegments(2).toOSString();
            String qftestBinDir = location.removeLastSegments(1).toOSString();
            String qftestJavaToolOptions = "-javaagent:\"" + qftestVersionDir + File.separator + "misc" + File.separator + "qfconnect.jar\"";
            envVars.put("QFTEST_HOME", qftestHome);
            envVars.put("QFTEST_VERSIONDIR", qftestVersionDir);
            File logdir = new File(qftestHome, "log");
            if (!this.isLogdirWriteable(logdir)) {
                try {
                    File tempFile = File.createTempFile("qftest", "log");
                    logdir = new File(tempFile.getParentFile(), "qftest-log");
                    tempFile.delete();
                    logdir.mkdirs();
                    this.logWarning("Using temporary log dir: " + logdir);
                    envVars.put("QFTEST_LOGDIR", logdir.getAbsolutePath());
                }
                catch (IOException e) {
                    this.logException("Could not create temp log dir", e);
                }
            }
            envVars.put("QFTEST_BIN", qftestBinDir);
            envVars.put("QFTEST_SERVERNAME", "qftest");
            List properties = qftestLaunchConfig.getAttribute("qfs_commandline_variables", Collections.EMPTY_LIST);
            String clientName = "client";
            for (String property : properties) {
                String[] keyValueProp = property.split("=");
                if (keyValueProp.length != 2 || !"client".equals(keyValueProp[0])) continue;
                clientName = keyValueProp[1];
            }
            envVars.put("QFTEST_CLIENTNAME", clientName);
            envVars.put("QFTEST_SERVERHOST", "localhost:3543");
            envVars.put("QFTEST_CLIENTID", "0");
            envVars.put("SWT_DISPLAY_CREATION_HOOKS", "de.qfs.apps.qftest.start.Connector");
            envVars.put("JAVA_TOOL_OPTIONS", qftestJavaToolOptions);
            workCopy = sutLaunchConfig.getWorkingCopy();
            workCopy.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, envVars);
        }
        catch (CoreException e) {
            this.logException("setting qftest env variables", e);
        }
        if (workCopy != null) {
            return workCopy;
        }
        return sutLaunchConfig;
    }

    private boolean isLogdirWriteable(File logdir) {
        if (!(logdir.exists() && logdir.isDirectory() && logdir.canWrite())) {
            return false;
        }
        File testfile = new File(logdir, ".writetest");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(testfile);
            return true;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (Exception exception) {}
            testfile.delete();
        }
        return false;
    }

    public ILaunchConfiguration getSUTLaunchConfig(String id) {
        block5: {
            if (!"QF-Test only".equals(id)) break block5;
            return null;
        }
        try {
            ILaunchConfiguration[] configurations;
            ILaunchConfiguration[] iLaunchConfigurationArray = configurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                if (id != null && id.equals(configuration.getName())) {
                    return configuration;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            this.logException("find sut launchconfig", e);
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleCommand(String command, Properties parameters) {
        QFSLauncher qFSLauncher;
        if (QFSLauncher.logger.level >= 7) {
            logger.log(7, "handleCommand(String,Properties)", QFSLauncher.logger.level < 8 ? "" : "command: " + command + ", parameters: " + parameters);
        }
        if ("acceptReuse".equals(command)) {
            qFSLauncher = this;
            synchronized (qFSLauncher) {
                if (this.reuseProps == null) {
                    this.reuseProps = parameters;
                    this.notifyAll();
                }
            }
        }
        if ("loadFiles".equals(command)) {
            qFSLauncher = this;
            synchronized (qFSLauncher) {
                this.notifyAll();
            }
        }
        return false;
    }

    private String[] splitCommand(String cmd) {
        Vector<String> ret = new Vector<String>();
        int pos = 0;
        int start = -1;
        StringBuffer sb = new StringBuffer();
        boolean quote = false;
        while (pos < cmd.length()) {
            int next;
            if (Character.isWhitespace(cmd.charAt(pos))) {
                ++pos;
                continue;
            }
            if (cmd.charAt(pos) == '\"') {
                quote = true;
                ++pos;
                continue;
            }
            if (start == -1) {
                start = pos;
            }
            if ((next = Misc.unquotedIndexOf((String)cmd, (String)(quote ? "\"" : "\" \t\r\n"), (int)pos)) < 0) {
                sb.append(cmd.substring(start));
                ret.addElement(sb.toString());
                break;
            }
            sb.append(cmd.substring(start, next));
            start = -1;
            pos = next + 1;
            if (cmd.charAt(next) == '\"') {
                if (quote) {
                    quote = false;
                    if (pos < cmd.length() && !Character.isWhitespace(cmd.charAt(pos))) continue;
                    ret.addElement(sb.toString());
                    sb = new StringBuffer();
                    continue;
                }
                quote = true;
                continue;
            }
            ret.addElement(sb.toString());
            sb = new StringBuffer();
        }
        Object[] split = new String[ret.size()];
        ret.copyInto(split);
        return split;
    }
}

