/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.qftest.launch;

import de.qfs.qftest.Activator;
import de.qfs.qftest.launch.VariablesPropertyDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsMainTab;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public class QFSSettingsTab
extends ExternalToolsMainTab {
    private ILaunchConfiguration launchConfiguration;
    private Label runlogPathLabel;
    private Text runlogPathTextfield;
    private Button runlogPathBrowseButton;
    private Table propsTable;
    private Button removePropButton;
    private Button editPropButton;
    private Composite comp;

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createParameterComponent(mainComposite);
        this.createVariablesComponent(mainComposite);
        Dialog.applyDialogFont((Control)parent);
    }

    public String getName() {
        return "Settings";
    }

    protected void createParameterComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Parameter:");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.comp = SWTFactory.createComposite((Composite)group, (Font)parent.getFont(), (int)3, (int)2, (int)1808, (int)0, (int)0);
        this.runlogPathLabel = new Label(this.comp, 0);
        this.runlogPathLabel.setText("Path to run-log folder:");
        this.runlogPathTextfield = SWTFactory.createSingleText((Composite)this.comp, (int)1);
        this.runlogPathTextfield.addModifyListener((ModifyListener)this.fListener);
        this.runlogPathBrowseButton = this.createPushButton(this.comp, LaunchConfigurationsMessages.CommonTab__Browse_6, null);
        this.runlogPathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                QFSSettingsTab.this.handleRunlogDirectoryLocationButtonSelected();
            }
        });
    }

    protected void createVariablesComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Variables:");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(1808);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.comp = SWTFactory.createComposite((Composite)group, (Font)parent.getFont(), (int)2, (int)0, (int)1808, (int)0, (int)0);
        TableViewer tableViewer = new TableViewer(this.comp, 67586);
        tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem[] selection = QFSSettingsTab.this.propsTable.getSelection();
                if (selection.length == 1) {
                    QFSSettingsTab.this.editProperty(selection[0].getText(0), selection[0].getText(1));
                }
            }
        });
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableItem[] items = QFSSettingsTab.this.propsTable.getSelection();
                if (items == null || items.length == 0) {
                    QFSSettingsTab.this.editPropButton.setEnabled(false);
                    QFSSettingsTab.this.removePropButton.setEnabled(false);
                } else if (items.length == 1) {
                    QFSSettingsTab.this.editPropButton.setEnabled(true);
                    QFSSettingsTab.this.removePropButton.setEnabled(true);
                } else {
                    QFSSettingsTab.this.editPropButton.setEnabled(false);
                    QFSSettingsTab.this.removePropButton.setEnabled(true);
                }
            }
        });
        this.propsTable = tableViewer.getTable();
        this.propsTable.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        this.propsTable.setLinesVisible(true);
        this.propsTable.setHeaderVisible(true);
        final TableColumn propColumn = new TableColumn(this.propsTable, 0, 0);
        propColumn.setWidth(120);
        propColumn.setText("Variable name");
        final TableColumn valueColumn = new TableColumn(this.propsTable, 0, 1);
        valueColumn.setWidth(200);
        valueColumn.setText("Variable value");
        final Table tref = this.propsTable;
        final Composite tableComposite = this.comp;
        tableComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = tableComposite.getClientArea();
                Point size = tref.computeSize(-1, -1);
                ScrollBar vBar = tref.getVerticalBar();
                int width = area.width - tref.computeTrim((int)0, (int)0, (int)0, (int)0).width - 2;
                if (size.y > area.height + tref.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tref.getSize();
                if (oldSize.x > area.width) {
                    propColumn.setWidth(width / 2 - 1);
                    valueColumn.setWidth(width - propColumn.getWidth());
                    tref.setSize(area.width, area.height);
                } else {
                    tref.setSize(area.width, area.height);
                    propColumn.setWidth(width / 2 - 1);
                    valueColumn.setWidth(width - propColumn.getWidth());
                }
            }
        });
        Button addPropButton = new Button(this.comp, 0);
        addPropButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addPropButton.setText("Add..");
        addPropButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QFSSettingsTab.this.addProperty();
            }
        });
        new Label(this.comp, 0);
        this.editPropButton = new Button(this.comp, 0);
        this.editPropButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.editPropButton.setText("Edit..");
        this.editPropButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection;
                if (QFSSettingsTab.this.propsTable.getSelectionCount() > 0 && (selection = QFSSettingsTab.this.propsTable.getSelection()).length == 1) {
                    QFSSettingsTab.this.editProperty(selection[0].getText(0), selection[0].getText(1));
                }
            }
        });
        new Label(this.comp, 0);
        this.editPropButton.setEnabled(false);
        this.removePropButton = new Button(this.comp, 0);
        this.removePropButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.removePropButton.setText("Remove");
        this.removePropButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QFSSettingsTab.this.propsTable.getSelectionCount() > 0) {
                    QFSSettingsTab.this.propsTable.remove(QFSSettingsTab.this.propsTable.getSelectionIndices());
                    QFSSettingsTab.this.entriesChanged();
                }
            }
        });
        this.removePropButton.setEnabled(false);
    }

    private void addProperty() {
        VariablesPropertyDialog dialog = this.getVariablesPropertyDialog("Add", "", "");
        if (dialog.open() == 0) {
            TableItem item = new TableItem(this.propsTable, 0);
            item.setText(0, dialog.getName());
            item.setText(1, dialog.getValue());
            this.entriesChanged();
        }
    }

    private void editProperty(String name, String value) {
        VariablesPropertyDialog dialog = this.getVariablesPropertyDialog("Edit", name, value);
        if (dialog.open() == 0) {
            TableItem[] item = this.propsTable.getSelection();
            item[0].setText(0, dialog.getName());
            item[0].setText(1, dialog.getValue());
            this.entriesChanged();
        }
    }

    private void entriesChanged() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    private VariablesPropertyDialog getVariablesPropertyDialog(String title, String initName, String initValue) {
        return new VariablesPropertyDialog(this.getShell(), title, initName, initValue, null, "Variable name:", "Variable value:");
    }

    public void handleRunlogDirectoryLocationButtonSelected() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 0);
        directoryDialog.setFilterPath(this.runlogPathTextfield.getText());
        String text = directoryDialog.open();
        if (text != null) {
            this.runlogPathTextfield.setText(text);
        }
    }

    public void handleFileLocationButtonSelected(Text textField) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFilterPath(textField.getText());
        String text = fileDialog.open();
        if (text != null) {
            textField.setText(text);
        }
    }

    protected void updateParameter(ILaunchConfiguration configuration) {
        try {
            String runlogPathDir = configuration.getAttribute("qfs_path_to_runlog_dir", "");
            this.runlogPathTextfield.setText(runlogPathDir);
        }
        catch (CoreException ce) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.qfs.qftest", "update parameter", (Throwable)ce));
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
    }

    protected void updateVariables(ILaunchConfiguration configuration) {
        try {
            if (this.propsTable != null) {
                String name;
                int index;
                this.propsTable.removeAll();
                List properties = configuration.getAttribute("qfs_commandline_variables", Collections.EMPTY_LIST);
                boolean isClientVarSet = false;
                for (String property : properties) {
                    index = property.indexOf(61);
                    name = property;
                    if (index > -1) {
                        name = property.substring(0, index);
                    }
                    if (!"client".equals(name)) continue;
                    isClientVarSet = true;
                    break;
                }
                if (!isClientVarSet) {
                    TableItem item = new TableItem(this.propsTable, 0);
                    item.setText(0, "client");
                    item.setText(1, "client");
                }
                for (String property : properties) {
                    index = property.indexOf(61);
                    name = property;
                    String value = "";
                    if (index > -1) {
                        name = property.substring(0, index);
                        if (index > 1) {
                            value = property.substring(index + 1);
                        }
                    }
                    TableItem item = new TableItem(this.propsTable, 0);
                    item.setText(0, name);
                    item.setText(1, value);
                }
            }
        }
        catch (CoreException ce) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.qfs.qftest", "update variables", (Throwable)ce));
            ExternalToolsPlugin.getDefault().log(ExternalToolsLaunchConfigurationMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        this.fInitializing = true;
        this.updateParameter(configuration);
        this.updateVariables(configuration);
        this.fInitializing = false;
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String runlogPathDir = this.runlogPathTextfield.getText().trim();
        if (runlogPathDir.length() == 0) {
            configuration.setAttribute("qfs_path_to_runlog_dir", null);
        } else {
            configuration.setAttribute("qfs_path_to_runlog_dir", runlogPathDir);
        }
        if (this.argumentField != null) {
            String arguments = this.argumentField.getText().trim();
            if (arguments.length() == 0) {
                configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
            } else {
                configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
            }
        }
        if (this.propsTable != null) {
            ArrayList<String> properties = new ArrayList<String>();
            TableItem[] tableItemArray = this.propsTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                String name = item.getText(0);
                String value = item.getText(1);
                if (name != null && name.trim().length() > 0) {
                    String prop = String.valueOf(name.trim()) + "=" + (value == null ? "" : value);
                    properties.add(prop);
                }
                ++n2;
            }
            configuration.setAttribute("qfs_commandline_variables", properties);
        }
        configuration.setAttribute("editedByExternalToolsMainTab", false);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }
}

