/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import java.io.File;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final String SEPARATOR = File.separator;
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.DirectoryDialog");

    public DirectoryDialog(Shell shell) {
        this(shell, 65536);
    }

    public DirectoryDialog(Shell shell, int n) {
        super(shell, DirectoryDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        if ("true".equals(System.getProperty("qftest.swt.testing"))) {
            return this.openChooserDialog();
        }
        return this.openNativeChooserDialog();
    }

    String openNativeChooserDialog() {
        int n;
        long l;
        CharSequence charSequence;
        byte[] byArray = Converter.wcsToMbcs((String)this.title, (boolean)true);
        long l2 = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l3 = 0L;
        l3 = GTK.gtk_file_chooser_native_new((byte[])byArray, (long)l2, (int)2, null, null);
        if (l3 == 0L) {
            this.error(2);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            charSequence = new StringBuilder();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                charSequence.append(SEPARATOR);
            }
            charSequence.append(this.filterPath);
            byte[] byArray2 = Converter.wcsToMbcs((String)charSequence.toString(), (boolean)true);
            l = OS.realpath(byArray2, null);
            if (l != 0L) {
                if (GTK.GTK4) {
                    long l4 = OS.g_file_new_for_path(byArray2);
                    GTK.gtk_file_chooser_set_current_folder((long)l3, (long)l4, (long)0L);
                    OS.g_object_unref(l4);
                } else {
                    GTK.gtk_file_chooser_set_current_folder((long)l3, (long)l);
                }
                OS.g_free(l);
            }
        }
        this.GTK3setNativeDialogMessage(l3, this.message);
        charSequence = null;
        this._qfGetDisplay().runDialogShownHooks(this, l3);
        display.addIdleProc();
        int n2 = 0;
        l = 0L;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, l3, 0L);
        }
        if (GTK.GTK4) {
            n = SyncDialogUtil.run((Display)display, (long)l3, (boolean)true);
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            n = GTK.gtk_native_dialog_run((long)l3);
            GDK.gdk_threads_leave();
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, l);
        }
        if (n == -3) {
            long l5;
            long l6;
            if (GTK.GTK4) {
                l6 = GTK.gtk_file_chooser_get_file((long)l3);
                l5 = OS.g_file_get_path(l6);
            } else {
                l5 = GTK.gtk_file_chooser_get_filename((long)l3);
            }
            if (l5 != 0L) {
                l6 = OS.g_filename_to_utf8(l5, -1L, null, null, null);
                if (l6 == 0L) {
                    l6 = OS.g_filename_display_name(l5);
                }
                if (l5 != l6) {
                    OS.g_free(l5);
                }
                if (l6 != 0L) {
                    long[] lArray = new long[1];
                    long l7 = OS.g_utf8_to_utf16(l6, -1L, null, lArray, null);
                    OS.g_free(l6);
                    if (l7 != 0L) {
                        int n3 = (int)lArray[0];
                        char[] cArray = new char[n3];
                        C.memmove((char[])cArray, (long)l7, (long)(n3 * 2));
                        OS.g_free(l7);
                        charSequence = new String(cArray);
                        this.filterPath = charSequence;
                    }
                }
            }
        }
        Object object = this._qfGetDisplay().runDialogClosedHooks(this, charSequence);
        if (DirectoryDialog.logger.level >= 9) {
            logger.build("openChooserDialog()").add("ret: ").add(object).log(9);
        }
        if (object instanceof String || object == null) {
            charSequence = (String)object;
        }
        display.removeIdleProc();
        return charSequence;
    }

    String openChooserDialog() {
        long l;
        long l2;
        Object object;
        Object object2;
        byte[] byArray = Converter.wcsToMbcs((String)this.title, (boolean)true);
        long l3 = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l4 = 0L;
        l4 = display.getDismissalAlignment() == 131072 ? GTK.gtk_file_chooser_dialog_new((byte[])byArray, (long)l3, (int)2, (byte[])GTK.GTK_NAMED_LABEL_CANCEL, (int)-6, (byte[])GTK.GTK_NAMED_LABEL_OK, (int)-5, (long)0L) : GTK.gtk_file_chooser_dialog_new((byte[])byArray, (long)l3, (int)2, (byte[])GTK.GTK_NAMED_LABEL_OK, (int)-5, (byte[])GTK.GTK_NAMED_LABEL_CANCEL, (int)-6, (long)0L);
        if (l4 == 0L) {
            this.error(2);
        }
        long l5 = GTK.gtk_window_get_group((long)0L);
        GTK.gtk_window_group_add_window((long)l5, (long)l4);
        GTK.gtk_window_set_modal((long)l4, (boolean)true);
        long l6 = GTK.gtk_window_get_icon_list((long)l3);
        if (l6 != 0L) {
            GTK.gtk_window_set_icon_list((long)l4, (long)l6);
            OS.g_list_free(l6);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            object2 = new StringBuilder();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                ((StringBuilder)object2).append(SEPARATOR);
            }
            ((StringBuilder)object2).append(this.filterPath);
            object = Converter.wcsToMbcs((String)((StringBuilder)object2).toString(), (boolean)true);
            long l7 = OS.realpath((byte[])object, null);
            if (l7 != 0L) {
                GTK.gtk_file_chooser_set_current_folder((long)l4, (long)l7);
                OS.g_free(l7);
            }
        }
        if (this.message.length() > 0) {
            object2 = Converter.wcsToMbcs((String)this.message, (boolean)true);
            long l8 = GTK.gtk_box_new((int)0, (int)0);
            GTK.gtk_box_set_homogeneous((long)l8, (boolean)false);
            if (l8 == 0L) {
                this.error(2);
            }
            if ((l2 = GTK.gtk_label_new((byte[])object2)) == 0L) {
                this.error(2);
            }
            GTK.gtk_container_add((long)l8, (long)l2);
            GTK.gtk_widget_show((long)l2);
            GTK.gtk_label_set_line_wrap((long)l2, (boolean)true);
            GTK.gtk_label_set_justify((long)l2, (int)2);
            GTK.gtk_file_chooser_set_extra_widget((long)l4, (long)l8);
        }
        object2 = null;
        this._qfGetDisplay().runDialogShownHooks(this, l4);
        display.addIdleProc();
        object = null;
        if (GTK.gtk_window_get_modal((long)l4)) {
            object = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        l2 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l2 = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, l4, 0L);
        }
        display.externalEventLoop = true;
        display.sendPreExternalEventDispatchEvent();
        int n2 = GTK.gtk_dialog_run((long)l4);
        if (!GTK.GTK4) {
            GDK.gdk_threads_leave();
        }
        display.externalEventLoop = false;
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l2);
        }
        if (GTK.gtk_window_get_modal((long)l4)) {
            display.setModalDialog((Dialog)object);
        }
        if (n2 == -5 && (l = GTK.gtk_file_chooser_get_filename((long)l4)) != 0L) {
            long l9 = OS.g_filename_to_utf8(l, -1L, null, null, null);
            if (l9 == 0L) {
                l9 = OS.g_filename_display_name(l);
            }
            if (l != l9) {
                OS.g_free(l);
            }
            if (l9 != 0L) {
                long[] lArray = new long[1];
                long l10 = OS.g_utf8_to_utf16(l9, -1L, null, lArray, null);
                OS.g_free(l9);
                if (l10 != 0L) {
                    int n3 = (int)lArray[0];
                    char[] cArray = new char[n3];
                    C.memmove((char[])cArray, (long)l10, (long)(n3 * 2));
                    OS.g_free(l10);
                    this.filterPath = object2 = new String(cArray);
                }
            }
        }
        Object object3 = this._qfGetDisplay().runDialogClosedHooks(this, object2);
        if (DirectoryDialog.logger.level >= 9) {
            logger.build("openChooserDialog()").add("ret: ").add(object3).log(9);
        }
        if (object3 instanceof String || object3 == null) {
            object2 = (String)object3;
        }
        display.removeIdleProc();
        GTK.gtk_widget_destroy((long)l4);
        return object2;
    }

    void GTK3setNativeDialogMessage(long l, String string) {
        if (GTK.GTK4) {
            return;
        }
        if (string.length() > 0) {
            long l2;
            byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)true);
            long l3 = GTK.gtk_box_new((int)0, (int)0);
            if (l3 == 0L) {
                this.error(2);
            }
            if ((l2 = GTK.gtk_label_new((byte[])byArray)) == 0L) {
                this.error(2);
            }
            GTK.gtk_container_add((long)l3, (long)l2);
            GTK.gtk_widget_show((long)l2);
            GTK.gtk_label_set_line_wrap((long)l2, (boolean)true);
            GTK.gtk_box_set_homogeneous((long)l3, (boolean)false);
            GTK.gtk_label_set_justify((long)l2, (int)2);
            GTK.gtk_file_chooser_set_extra_widget((long)l, (long)l3);
        }
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

