/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int filterIndex = -1;
    boolean overwrite = false;
    boolean uriMode;
    long handle;
    static final char SEPARATOR = File.separatorChar;
    static final char EXTENSION_SEPARATOR = ';';
    static final char FILE_EXTENSION_SEPARATOR = '.';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        long l;
        int n;
        long l2;
        int n2;
        long l3;
        this.fullPath = null;
        if ((this.style & 2) != 0) {
            l3 = 0L;
            l3 = GTK.GTK4 ? GTK.gtk_file_chooser_get_files((long)this.handle) : (this.uriMode ? GTK.gtk_file_chooser_get_uris((long)this.handle) : GTK.gtk_file_chooser_get_filenames((long)this.handle));
            n2 = OS.g_slist_length(l3);
            this.fileNames = new String[n2];
            l2 = l3;
            n = 0;
            for (int i = 0; i < n2; ++i) {
                long l4 = OS.g_slist_data(l2);
                long l5 = 0L;
                if (this.uriMode) {
                    l5 = GTK.GTK4 ? OS.g_file_get_uri(l4) : l4;
                } else {
                    if (GTK.GTK4) {
                        l4 = OS.g_file_get_path(l4);
                    }
                    if ((l5 = OS.g_filename_to_utf8(l4, -1L, null, null, null)) == 0L) {
                        l5 = OS.g_filename_display_name(l4);
                    }
                }
                if (l4 != l5) {
                    OS.g_free(l4);
                }
                if (l5 != 0L) {
                    long[] lArray = new long[1];
                    long l6 = OS.g_utf8_to_utf16(l5, -1L, null, lArray, null);
                    OS.g_free(l5);
                    if (l6 != 0L) {
                        int n3 = (int)lArray[0];
                        char[] cArray = new char[n3];
                        C.memmove((char[])cArray, (long)l6, (long)(n3 * 2));
                        OS.g_free(l6);
                        this.fullPath = new String(cArray);
                        this.fileNames[n++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                l2 = OS.g_slist_next(l2);
            }
            if (n != 0 && n != n2) {
                String[] stringArray = new String[n];
                System.arraycopy(this.fileNames, 0, stringArray, 0, n);
                this.fileNames = stringArray;
            }
            OS.g_slist_free(l3);
        } else {
            long l7;
            l3 = 0L;
            if (this.uriMode) {
                if (GTK.GTK4) {
                    l7 = GTK.gtk_file_chooser_get_file((long)this.handle);
                    l3 = OS.g_file_get_uri(l7);
                } else {
                    l3 = GTK.gtk_file_chooser_get_uri((long)this.handle);
                }
            } else {
                if (GTK.GTK4) {
                    long l8 = GTK.gtk_file_chooser_get_file((long)this.handle);
                    l7 = OS.g_file_get_path(l8);
                } else {
                    l7 = GTK.gtk_file_chooser_get_filename((long)this.handle);
                }
                if (l7 != 0L) {
                    l3 = OS.g_filename_to_utf8(l7, -1L, null, null, null);
                    if (l3 == 0L) {
                        l3 = OS.g_filename_display_name(l7);
                    }
                    if (l7 != l3) {
                        OS.g_free(l7);
                    }
                }
            }
            if (l3 != 0L) {
                long[] lArray = new long[1];
                l2 = OS.g_utf8_to_utf16(l3, -1L, null, lArray, null);
                OS.g_free(l3);
                if (l2 != 0L) {
                    n = (int)lArray[0];
                    char[] cArray = new char[n];
                    C.memmove((char[])cArray, (long)l2, (long)(n * 2));
                    OS.g_free(l2);
                    this.fullPath = new String(cArray);
                    this.fileNames = new String[1];
                    this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                }
            }
        }
        this.filterIndex = -1;
        l3 = GTK.gtk_file_chooser_get_filter((long)this.handle);
        if (l3 != 0L && (l = GTK.gtk_file_filter_get_name((long)l3)) != 0L) {
            int n4 = C.strlen((long)l);
            byte[] byArray = new byte[n4];
            C.memmove((byte[])byArray, (long)l, (long)n4);
            String string = new String(Converter.mbcsToWcs((byte[])byArray));
            for (int i = 0; i < this.filterExtensions.length; ++i) {
                if (this.filterNames.length > 0) {
                    if (!this.filterNames[i].equals(string)) continue;
                    this.filterIndex = i;
                    break;
                }
                if (!this.filterExtensions[i].equals(string)) continue;
                this.filterIndex = i;
                break;
            }
        }
        if (this.fullPath != null) {
            n2 = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(n2 + 1);
            this.filterPath = this.fullPath.substring(0, n2);
        }
        return this.fullPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        if ("true".equals(System.getProperty("qftest.swt.testing"))) {
            return this.openChooserDialog();
        }
        return this.openNativeChooserDialog();
    }

    String openNativeChooserDialog() {
        Object object;
        int n;
        byte[] byArray = Converter.wcsToMbcs((String)this.title, (boolean)true);
        int n2 = (this.style & 0x2000) != 0 ? 1 : 0;
        long l = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = GTK.gtk_file_chooser_native_new((byte[])byArray, (long)l, (int)n2, null, null);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (this.uriMode && !GTK.GTK4) {
            GTK.gtk_file_chooser_set_local_only((long)this.handle, (boolean)false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        String string = null;
        this._qfGetDisplay().runDialogShownHooks(this, this.handle);
        int n3 = 0;
        long l2 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n3 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l2 = OS.g_signal_add_emission_hook(n3, 0, display.emissionProc, this.handle, 0L);
        }
        if (GTK.GTK4) {
            n = SyncDialogUtil.run((Display)display, (long)this.handle, (boolean)true);
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            n = GTK.gtk_native_dialog_run((long)this.handle);
            GDK.gdk_threads_leave();
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n3, l2);
        }
        if (n == -3) {
            string = this.computeResultChooserDialog();
        }
        if ((object = this._qfGetDisplay().runDialogClosedHooks(this, string)) instanceof String || object == null) {
            string = (String)object;
        }
        display.removeIdleProc();
        return string;
    }

    String openChooserDialog() {
        Object object;
        byte[] byArray = Converter.wcsToMbcs((String)this.title, (boolean)true);
        int n = (this.style & 0x2000) != 0 ? 1 : 0;
        long l = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = display.getDismissalAlignment() == 131072 ? GTK.gtk_file_chooser_dialog_new((byte[])byArray, (long)l, (int)n, (byte[])GTK.GTK_NAMED_LABEL_CANCEL, (int)-6, (byte[])GTK.GTK_NAMED_LABEL_OK, (int)-5, (long)0L) : GTK.gtk_file_chooser_dialog_new((byte[])byArray, (long)l, (int)n, (byte[])GTK.GTK_NAMED_LABEL_OK, (int)-5, (byte[])GTK.GTK_NAMED_LABEL_CANCEL, (int)-6, (long)0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        GTK.gtk_window_set_modal((long)this.handle, (boolean)true);
        long l2 = GTK.gtk_window_get_group((long)0L);
        GTK.gtk_window_group_add_window((long)l2, (long)this.handle);
        long l3 = GTK.gtk_window_get_icon_list((long)l);
        if (l3 != 0L) {
            GTK.gtk_window_set_icon_list((long)this.handle, (long)l3);
            OS.g_list_free(l3);
        }
        if (this.uriMode) {
            GTK.gtk_file_chooser_set_local_only((long)this.handle, (boolean)false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        String string = null;
        this._qfGetDisplay().runDialogShownHooks(this, this.handle);
        Dialog dialog = null;
        if (GTK.gtk_window_get_modal((long)this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n2 = 0;
        long l4 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l4 = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, this.handle, 0L);
        }
        display.externalEventLoop = true;
        display.sendPreExternalEventDispatchEvent();
        int n3 = GTK.gtk_dialog_run((long)this.handle);
        if (!GTK.GTK4) {
            GDK.gdk_threads_leave();
        }
        display.externalEventLoop = false;
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, l4);
        }
        if (GTK.gtk_window_get_modal((long)this.handle)) {
            display.setModalDialog(dialog);
        }
        if (n3 == -5) {
            string = this.computeResultChooserDialog();
        }
        if ((object = this._qfGetDisplay().runDialogClosedHooks(this, string)) instanceof String || object == null) {
            string = (String)object;
        }
        display.removeIdleProc();
        GTK.gtk_widget_destroy((long)this.handle);
        return string;
    }

    void presetChooserDialog() {
        Object object;
        long l;
        Object object2;
        if ((this.style & 0x2002) == 2) {
            GTK.gtk_file_chooser_set_select_multiple((long)this.handle, (boolean)true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if ((this.style & 0x2000) != 0) {
            if (this.fileName.equals("")) {
                this.fileName = "Untitled";
            }
            if (this.filterPath.length() > 0) {
                long l2;
                if (this.uriMode) {
                    object2 = Converter.wcsToMbcs((String)this.filterPath, (boolean)true);
                    if (GTK.GTK4) {
                        l2 = OS.g_file_new_for_uri((byte[])object2);
                        GTK.gtk_file_chooser_set_current_folder((long)this.handle, (long)l2, (long)0L);
                        OS.g_object_unref(l2);
                    } else {
                        GTK.gtk_file_chooser_set_current_folder_uri((long)this.handle, (byte[])object2);
                    }
                } else {
                    object2 = Converter.wcsToMbcs((String)(SEPARATOR + this.filterPath), (boolean)true);
                    l2 = OS.realpath((byte[])object2, null);
                    if (l2 != 0L) {
                        if (GTK.GTK4) {
                            l = OS.g_file_new_for_path((byte[])object2);
                            GTK.gtk_file_chooser_set_current_folder((long)this.handle, (long)l, (long)0L);
                            OS.g_object_unref(l);
                        } else {
                            GTK.gtk_file_chooser_set_current_folder((long)this.handle, (long)l2);
                        }
                        OS.g_free(l2);
                    }
                }
            }
            if (this.fileName.length() > 0) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(this.fileName);
                if (this.fileName.lastIndexOf(46) == -1 && this.filterExtensions.length != 0) {
                    int n;
                    String string = null;
                    string = this.filterIndex == -1 ? this.filterExtensions[0] : this.filterExtensions[this.filterIndex];
                    String string2 = null;
                    int n2 = string.indexOf(59);
                    string2 = n2 == -1 ? string.trim() : string.substring(0, n2).trim();
                    object = string2.substring(n = string2.lastIndexOf(46));
                    if (!this.isGlobPattern((String)object)) {
                        ((StringBuilder)object2).append((String)object);
                    }
                }
                byte[] byArray = Converter.wcsToMbcs((String)((StringBuilder)object2).toString(), (boolean)true);
                GTK.gtk_file_chooser_set_current_name((long)this.handle, (byte[])byArray);
            }
        } else {
            object2 = new StringBuilder();
            if (this.filterPath.length() > 0) {
                if (!this.uriMode) {
                    ((StringBuilder)object2).append(SEPARATOR);
                }
                ((StringBuilder)object2).append(this.filterPath);
                ((StringBuilder)object2).append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                ((StringBuilder)object2).append(this.fileName);
            }
            byte[] byArray = Converter.wcsToMbcs((String)((StringBuilder)object2).toString(), (boolean)true);
            if (GTK.GTK4) {
                long l3;
                if (this.uriMode) {
                    l3 = OS.g_file_new_for_uri(byArray);
                    GTK.gtk_file_chooser_set_file((long)this.handle, (long)l3, (long)0L);
                } else {
                    l3 = OS.g_file_new_for_path(byArray);
                    if (this.fileName.length() > 0) {
                        GTK.gtk_file_chooser_set_file((long)this.handle, (long)l3, (long)0L);
                    } else {
                        GTK.gtk_file_chooser_set_current_folder((long)this.handle, (long)l3, (long)0L);
                    }
                }
                OS.g_object_unref(l3);
            } else if (this.uriMode) {
                GTK.gtk_file_chooser_set_uri((long)this.handle, (byte[])byArray);
            } else {
                long l4 = OS.realpath(byArray, null);
                if (l4 != 0L) {
                    if (this.fileName.length() > 0) {
                        GTK.gtk_file_chooser_set_filename((long)this.handle, (long)l4);
                    } else {
                        GTK.gtk_file_chooser_set_current_folder((long)this.handle, (long)l4);
                    }
                    OS.g_free(l4);
                }
            }
        }
        if ((this.style & 0x2000) != 0 && !GTK.GTK4) {
            GTK.gtk_file_chooser_set_do_overwrite_confirmation((long)this.handle, (boolean)this.overwrite);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        long l5 = 0L;
        for (int i = 0; i < this.filterExtensions.length; ++i) {
            byte[] byArray;
            String string;
            if (this.filterExtensions[i] == null) continue;
            l = GTK.gtk_file_filter_new();
            if (this.filterNames.length > i && this.filterNames[i] != null) {
                object = Converter.wcsToMbcs((String)this.filterNames[i], (boolean)true);
                GTK.gtk_file_filter_set_name((long)l, (byte[])object);
            } else {
                object = Converter.wcsToMbcs((String)this.filterExtensions[i], (boolean)true);
                GTK.gtk_file_filter_set_name((long)l, (byte[])object);
            }
            int n = 0;
            int n3 = this.filterExtensions[i].indexOf(59);
            while (n3 != -1) {
                string = this.filterExtensions[i].substring(n, n3);
                byArray = Converter.wcsToMbcs((String)string, (boolean)true);
                GTK.gtk_file_filter_add_pattern((long)l, (byte[])byArray);
                n = n3 + 1;
                n3 = this.filterExtensions[i].indexOf(59, n);
            }
            string = this.filterExtensions[i].substring(n);
            byArray = Converter.wcsToMbcs((String)string, (boolean)true);
            GTK.gtk_file_filter_add_pattern((long)l, (byte[])byArray);
            GTK.gtk_file_chooser_add_filter((long)this.handle, (long)l);
            if (i != this.filterIndex) continue;
            l5 = l;
        }
        if (l5 != 0L) {
            GTK.gtk_file_chooser_set_filter((long)this.handle, (long)l5);
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    private boolean isGlobPattern(String string) {
        return string.contains("*") || string.contains("?") || string.contains("[") && string.contains("]");
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    void setURIMode(boolean bl) {
        this.uriMode = bl;
    }
}

