/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.Dialog");
    String message = "";
    long handle;

    public MessageBox(Shell shell) {
        this(shell, 65570);
    }

    public MessageBox(Shell shell, int n) {
        super(shell, MessageBox.checkStyle(shell, MessageBox.checkStyle(n)));
        this.checkSubclass();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public int open() {
        int n;
        long l = this.parent != null ? this.parent.topHandle() : 0L;
        int n2 = 2;
        if ((this.style & 0x38000) != 0) {
            n2 |= 1;
        }
        int n3 = 0;
        if ((this.style & 8) != 0) {
            n3 = 1;
        }
        if ((this.style & 4) != 0) {
            n3 = 2;
        }
        if ((this.style & 1) != 0) {
            n3 = 3;
        }
        byte[] byArray = Converter.wcsToMbcs((String)"%s", (boolean)true);
        byte[] byArray2 = Converter.wcsToMbcs((String)this.title, (boolean)true);
        this.handle = GTK.gtk_message_dialog_new((long)l, (int)n2, (int)n3, (int)0, (byte[])byArray, (byte[])byArray2);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (l != 0L) {
            long l2;
            if (GTK.GTK4) {
                l2 = GTK.gtk_window_get_icon_name((long)l);
                if (l2 != 0L) {
                    GTK.gtk_window_set_icon_name((long)this.handle, (long)l2);
                }
            } else {
                l2 = GTK.gtk_window_get_icon_list((long)l);
                if (l2 != 0L) {
                    GTK.gtk_window_set_icon_list((long)this.handle, (long)l2);
                    OS.g_list_free(l2);
                }
            }
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.createButtons(display.getDismissalAlignment());
        GTK.gtk_message_dialog_format_secondary_text((long)this.handle, (byte[])byArray, (byte[])Converter.javaStringToCString((String)this.message));
        this._qfGetDisplay().runDialogShownHooks(this, this.handle);
        display.addIdleProc();
        Dialog dialog = null;
        if (GTK.gtk_window_get_modal((long)this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        long l3 = GTK.gtk_window_get_group((long)0L);
        GTK.gtk_window_group_add_window((long)l3, (long)this.handle);
        int n4 = 0;
        long l4 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n4 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l4 = OS.g_signal_add_emission_hook(n4, 0, display.emissionProc, this.handle, 0L);
        }
        if (GTK.GTK4) {
            n = SyncDialogUtil.run((Display)display, (long)this.handle, (boolean)false);
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            n = GTK.gtk_dialog_run((long)this.handle);
            GDK.gdk_threads_leave();
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n4, l4);
        }
        if (GTK.gtk_window_get_modal((long)this.handle)) {
            display.setModalDialog(dialog);
        }
        display.removeIdleProc();
        Object object = this._qfGetDisplay().runDialogClosedHooks(this, new Integer(n));
        if (MessageBox.logger.level >= 9) {
            logger.build("open()").add("ret: ").add(object).log(9);
        }
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        GTK.gtk_widget_destroy((long)this.handle);
        return n;
    }

    private void createButtons(int n) {
        if (n == 16384) {
            if ((this.style & 0x20) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_OK"), (boolean)true), (int)32);
            }
            if ((this.style & 0x200) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_Abort"), (boolean)true), (int)512);
            }
            if ((this.style & 0x400) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_Retry"), (boolean)true), (int)1024);
            }
            if ((this.style & 0x40) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_Yes"), (boolean)true), (int)64);
            }
            if ((this.style & 0x80) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_No"), (boolean)true), (int)128);
            }
            if ((this.style & 0x800) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_Ignore"), (boolean)true), (int)2048);
            }
            if ((this.style & 0x100) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_Cancel"), (boolean)true), (int)256);
            }
        } else {
            if ((this.style & 0x100) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_Cancel"), (boolean)true), (int)256);
            }
            if ((this.style & 0x20) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_OK"), (boolean)true), (int)32);
            }
            if ((this.style & 0x80) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_No"), (boolean)true), (int)128);
            }
            if ((this.style & 0x40) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_Yes"), (boolean)true), (int)64);
            }
            if ((this.style & 0x800) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_Ignore"), (boolean)true), (int)2048);
            }
            if ((this.style & 0x400) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_Retry"), (boolean)true), (int)1024);
            }
            if ((this.style & 0x200) != 0) {
                GTK.gtk_dialog_add_button((long)this.handle, (byte[])Converter.wcsToMbcs((String)SWT.getMessage("SWT_Abort"), (boolean)true), (int)512);
            }
        }
    }

    private static int checkStyle(int n) {
        int n2 = 4064;
        int n3 = n & n2;
        if (n3 == 32 || n3 == 256 || n3 == 288) {
            return n;
        }
        if (n3 == 64 || n3 == 128 || n3 == 192 || n3 == 448) {
            return n;
        }
        if (n3 == 1280 || n3 == 3584) {
            return n;
        }
        n = n & ~n2 | 0x20;
        return n;
    }
}

