/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.util.stream.IntStream;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.formats.tiff.TiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffRasterDataType;
import org.apache.commons.imaging.formats.tiff.TiffRasterStatistics;

public class TiffRasterDataFloat
extends TiffRasterData {
    private final float[] data;

    public TiffRasterDataFloat(int width, int height) {
        super(width, height, 1);
        this.data = Allocator.floatArray(this.nCells);
    }

    public TiffRasterDataFloat(int width, int height, float[] data) {
        super(width, height, 1);
        if (data == null || data.length < this.nCells) {
            throw new IllegalArgumentException("Specified data does not contain sufficient elements");
        }
        this.data = data;
    }

    public TiffRasterDataFloat(int width, int height, int samplesPerPixel) {
        super(width, height, samplesPerPixel);
        this.data = Allocator.floatArray(this.nCells);
    }

    public TiffRasterDataFloat(int width, int height, int samplesPerCell, float[] data) {
        super(width, height, samplesPerCell);
        if (data == null || data.length < this.nCells) {
            throw new IllegalArgumentException("Specified data does not contain sufficient elements");
        }
        this.data = data;
    }

    @Override
    public float[] getData() {
        return this.data;
    }

    @Override
    public TiffRasterDataType getDataType() {
        return TiffRasterDataType.FLOAT;
    }

    @Override
    public int[] getIntData() {
        return IntStream.range(0, this.nCells).map(i -> (int)this.data[i]).toArray();
    }

    @Override
    public int getIntValue(int x, int y) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, 0);
        return (int)this.data[index];
    }

    @Override
    public int getIntValue(int x, int y, int i) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, 0);
        return (int)this.data[index];
    }

    @Override
    public TiffRasterStatistics getSimpleStatistics() {
        return new TiffRasterStatistics(this, Float.NaN);
    }

    @Override
    public TiffRasterStatistics getSimpleStatistics(float valueToExclude) {
        return new TiffRasterStatistics(this, valueToExclude);
    }

    @Override
    public float getValue(int x, int y) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, 0);
        return this.data[index];
    }

    @Override
    public float getValue(int x, int y, int i) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, i);
        return this.data[index];
    }

    @Override
    public void setIntValue(int x, int y, int value) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, 0);
        this.data[index] = value;
    }

    @Override
    public void setIntValue(int x, int y, int i, int value) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, 0);
        this.data[index] = value;
    }

    @Override
    public void setValue(int x, int y, float value) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, 0);
        this.data[index] = value;
    }

    @Override
    public void setValue(int x, int y, int i, float value) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, i);
        this.data[index] = value;
    }
}

