/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.LogEntry;

public class LogQueue {
    private boolean queueing = true;
    private LogEntry cubby;
    private int maxSize = 30000;
    private boolean drop = true;
    boolean mustPop;
    private LogEntry[] array = new LogEntry[this.maxSize];
    private int head;
    private int tail;
    private int size = 0;
    private boolean waitFlush;
    private int flushCount;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void push(LogEntry logEntry) {
        while (true) {
            block14: {
                if (this.waitFlush && this.flushCount > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (this.queueing) {
                    if (this.size == this.maxSize) {
                        if (this.drop) {
                            if (++this.tail == this.maxSize) {
                                this.tail = 0;
                            }
                            this.array[this.head++] = logEntry;
                            if (this.head == this.maxSize) {
                                this.head = 0;
                            }
                            this.notifyAll();
                            return;
                        }
                        break block14;
                    } else {
                        this.array[this.head++] = logEntry;
                        if (this.head == this.maxSize) {
                            this.head = 0;
                        }
                        ++this.size;
                        this.notifyAll();
                        return;
                    }
                }
                if (this.cubby == null) {
                    this.cubby = logEntry;
                    this.notifyAll();
                    return;
                }
            }
            try {
                this.mustPop = true;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mustPop = false;
        }
    }

    public synchronized LogEntry pop() {
        while (this.queueing ? this.size == 0 : this.cubby == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.queueing) {
            LogEntry logEntry = this.array[this.tail];
            this.array[this.tail++] = null;
            if (this.tail == this.maxSize) {
                this.tail = 0;
            }
            --this.size;
            ++this.flushCount;
            return logEntry;
        }
        LogEntry logEntry = this.cubby;
        this.cubby = null;
        ++this.flushCount;
        return logEntry;
    }

    public synchronized LogEntry[] popAll() {
        LogEntry[] logEntryArray;
        while (this.queueing ? this.size == 0 : this.cubby == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.queueing) {
            logEntryArray = new LogEntry[this.size];
            if (this.head > this.tail) {
                System.arraycopy(this.array, this.tail, logEntryArray, 0, this.size);
            } else {
                System.arraycopy(this.array, this.tail, logEntryArray, 0, this.maxSize - this.tail);
                if (this.head > 0) {
                    System.arraycopy(this.array, 0, logEntryArray, this.maxSize - this.tail, this.head);
                }
            }
            this.array = new LogEntry[this.maxSize];
            this.size = 0;
            this.tail = 0;
            this.head = 0;
        } else {
            logEntryArray = new LogEntry[]{this.cubby};
            this.cubby = null;
        }
        ++this.flushCount;
        return logEntryArray;
    }

    public synchronized void entriesProcessed() {
        --this.flushCount;
        this.notifyAll();
    }

    public final boolean isQueueing() {
        return this.queueing;
    }

    public final synchronized void setQueueing(boolean bl) {
        if (this.queueing != bl) {
            while (this.queueing ? this.size != 0 : this.cubby != null) {
                this.waitFlush = true;
                try {
                    this.mustPop = true;
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.mustPop = false;
            }
            this.queueing = bl;
            this.notifyAll();
            while (this.waitFlush && this.flushCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.waitFlush = false;
        }
    }

    public final int getQueueSize() {
        return this.maxSize;
    }

    public synchronized void setQueueSize(int n) {
        if (n == this.maxSize) {
            return;
        }
        while (this.queueing && this.size > n) {
            if (this.drop) {
                this.tail += this.size - n;
                if (this.tail > this.maxSize) {
                    this.tail -= this.maxSize;
                }
                this.size = n;
                continue;
            }
            try {
                this.mustPop = true;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mustPop = false;
        }
        LogEntry[] logEntryArray = new LogEntry[n];
        if (this.queueing && this.size > 0) {
            if (this.head > this.tail) {
                System.arraycopy(this.array, this.tail, logEntryArray, 0, this.size);
            } else {
                System.arraycopy(this.array, this.tail, logEntryArray, 0, this.maxSize - this.tail);
                if (this.head > 0) {
                    System.arraycopy(this.array, this.tail, logEntryArray, this.maxSize - this.tail, this.head);
                }
            }
        }
        this.maxSize = n;
        this.array = logEntryArray;
        this.head = this.size;
        this.tail = 0;
        this.notifyAll();
    }

    public final boolean isDropOnOverflow() {
        return this.drop;
    }

    public synchronized void setDropOnOverflow(boolean bl) {
        this.drop = bl;
        this.notifyAll();
    }
}

