/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import java.io.File;
import java.util.Optional;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.AsyncReadyCallback;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final String SEPARATOR = File.separator;
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.DirectoryDialog");

    public DirectoryDialog(Shell shell) {
        this(shell, 65536);
    }

    public DirectoryDialog(Shell shell, int n) {
        super(shell, DirectoryDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        try {
            return this.openDialog().orElse(null);
        }
        catch (SWTException sWTException) {
            if (sWTException.code == 51) {
                return null;
            }
            throw sWTException;
        }
    }

    public Optional<String> openDialog() {
        if ("true".equals(System.getProperty("qftest.swt.testing"))) {
            return Optional.ofNullable(this.openChooserDialog());
        }
        return this.openNativeChooserDialog();
    }

    Optional<String> openNativeChooserDialog() {
        int n;
        long l;
        CharSequence charSequence;
        long l2;
        Display display;
        byte[] byArray = Converter.wcsToMbcs((String)this.title, (boolean)true);
        final long l3 = this.parent.topHandle();
        Display display2 = display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
            l2 = GTK4.gtk_file_dialog_new();
            GTK4.gtk_file_dialog_set_title((long)l2, (byte[])byArray);
        } else {
            l2 = GTK.gtk_file_chooser_native_new((byte[])byArray, (long)l3, (int)2, null, null);
        }
        if (l2 == 0L) {
            this.error(2);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            charSequence = new StringBuilder();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                charSequence.append(SEPARATOR);
            }
            charSequence.append(this.filterPath);
            byte[] byArray2 = Converter.wcsToMbcs((String)charSequence.toString(), (boolean)true);
            l = OS.realpath(byArray2, null);
            if (l != 0L) {
                if (GTK.GTK4) {
                    long l4 = OS.g_file_new_for_path(byArray2);
                    if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                        GTK4.gtk_file_dialog_set_initial_folder((long)l2, (long)l4);
                    } else {
                        GTK4.gtk_file_chooser_set_current_folder((long)l2, (long)l4, (long)0L);
                    }
                    OS.g_object_unref(l4);
                } else {
                    GTK3.gtk_file_chooser_set_current_folder((long)l2, (long)l);
                }
                OS.g_free(l);
            }
        }
        this.GTK3setNativeDialogMessage(l2, this.message);
        charSequence = null;
        this._qfGetDisplay().runDialogShownHooks(this, l2);
        display.addIdleProc();
        int n2 = 0;
        l = 0L;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, l2, 0L);
        }
        long l5 = 0L;
        if (GTK.GTK4) {
            n = GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? ((l5 = SyncDialogUtil.run((Display)display, (AsyncReadyCallback)new AsyncReadyCallback(){

                public void async(long l) {
                    GTK4.gtk_file_dialog_select_folder((long)l2, (long)l3, (long)0L, (long)l, (long)0L);
                }

                public long await(long l) {
                    return GTK4.gtk_file_dialog_select_folder_finish((long)l2, (long)l, null);
                }
            })) != 0L ? -3 : -6) : SyncDialogUtil.run((Display)display, (long)l2, (boolean)true);
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            n = GTK3.gtk_native_dialog_run((long)l2);
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, l);
        }
        if (n == -3) {
            long l6;
            if (GTK.GTK4) {
                if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
                    l5 = GTK4.gtk_file_chooser_get_file((long)l2);
                }
                l6 = OS.g_file_get_path(l5);
            } else {
                l6 = GTK3.gtk_file_chooser_get_filename((long)l2);
            }
            if (l6 != 0L) {
                long l7 = OS.g_filename_to_utf8(l6, -1L, null, null, null);
                if (l7 == 0L) {
                    l7 = OS.g_filename_display_name(l6);
                }
                if (l6 != l7) {
                    OS.g_free(l6);
                }
                if (l7 != 0L) {
                    long[] lArray = new long[1];
                    long l8 = OS.g_utf8_to_utf16(l7, -1L, null, lArray, null);
                    OS.g_free(l7);
                    if (l8 != 0L) {
                        int n3 = (int)lArray[0];
                        char[] cArray = new char[n3];
                        C.memmove((char[])cArray, (long)l8, (long)(n3 * 2));
                        OS.g_free(l8);
                        charSequence = new String(cArray);
                        this.filterPath = charSequence;
                    }
                }
            }
        }
        Optional<Object> optional = Optional.empty();
        if (n == -3) {
            optional = Optional.ofNullable(charSequence);
        }
        Object object = this._qfGetDisplay().runDialogClosedHooks(this, optional.orElse(null));
        if (DirectoryDialog.logger.level >= 9) {
            logger.build("openChooserDialog()").add("ret: ").add(object).log(9);
        }
        if (object instanceof String || object == null) {
            optional = Optional.ofNullable((String)object);
        }
        display.removeIdleProc();
        OS.g_object_unref(l2);
        if (optional.isPresent() || n == -6) {
            return optional;
        }
        throw new SWTException(51);
    }

    String openChooserDialog() {
        long l;
        long l2;
        Object object;
        Object object2;
        byte[] byArray = Converter.wcsToMbcs((String)this.title, (boolean)true);
        long l3 = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l4 = 0L;
        l4 = display.getDismissalAlignment() == 131072 ? GTK.gtk_file_chooser_dialog_new((byte[])byArray, (long)l3, (int)2, (byte[])GTK.GTK_NAMED_LABEL_CANCEL, (int)-6, (byte[])GTK.GTK_NAMED_LABEL_OK, (int)-5, (long)0L) : GTK.gtk_file_chooser_dialog_new((byte[])byArray, (long)l3, (int)2, (byte[])GTK.GTK_NAMED_LABEL_OK, (int)-5, (byte[])GTK.GTK_NAMED_LABEL_CANCEL, (int)-6, (long)0L);
        if (l4 == 0L) {
            this.error(2);
        }
        long l5 = GTK.gtk_window_get_group((long)0L);
        GTK.gtk_window_group_add_window((long)l5, (long)l4);
        GTK.gtk_window_set_modal((long)l4, (boolean)true);
        long l6 = GTK3.gtk_window_get_icon_list((long)l3);
        if (l6 != 0L) {
            GTK3.gtk_window_set_icon_list((long)l4, (long)l6);
            OS.g_list_free(l6);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            object2 = new StringBuilder();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                ((StringBuilder)object2).append(SEPARATOR);
            }
            ((StringBuilder)object2).append(this.filterPath);
            object = Converter.wcsToMbcs((String)((StringBuilder)object2).toString(), (boolean)true);
            long l7 = OS.realpath((byte[])object, null);
            if (l7 != 0L) {
                GTK3.gtk_file_chooser_set_current_folder((long)l4, (long)l7);
                OS.g_free(l7);
            }
        }
        if (this.message.length() > 0) {
            object2 = Converter.wcsToMbcs((String)this.message, (boolean)true);
            long l8 = GTK.gtk_box_new((int)0, (int)0);
            GTK.gtk_box_set_homogeneous((long)l8, (boolean)false);
            if (l8 == 0L) {
                this.error(2);
            }
            if ((l2 = GTK.gtk_label_new((byte[])object2)) == 0L) {
                this.error(2);
            }
            GTK3.gtk_container_add((long)l8, (long)l2);
            GTK3.gtk_widget_show((long)l2);
            GTK3.gtk_label_set_line_wrap((long)l2, (boolean)true);
            GTK.gtk_label_set_justify((long)l2, (int)2);
            GTK3.gtk_file_chooser_set_extra_widget((long)l4, (long)l8);
        }
        object2 = null;
        this._qfGetDisplay().runDialogShownHooks(this, l4);
        display.addIdleProc();
        object = null;
        if (GTK.gtk_window_get_modal((long)l4)) {
            object = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        l2 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l2 = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, l4, 0L);
        }
        display.externalEventLoop = true;
        display.sendPreExternalEventDispatchEvent();
        int n2 = GTK3.gtk_dialog_run((long)l4);
        if (!GTK.GTK4) {
            GDK.gdk_threads_leave();
        }
        display.externalEventLoop = false;
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l2);
        }
        if (GTK.gtk_window_get_modal((long)l4)) {
            display.setModalDialog((Dialog)object);
        }
        if (n2 == -5 && (l = GTK3.gtk_file_chooser_get_filename((long)l4)) != 0L) {
            long l9 = OS.g_filename_to_utf8(l, -1L, null, null, null);
            if (l9 == 0L) {
                l9 = OS.g_filename_display_name(l);
            }
            if (l != l9) {
                OS.g_free(l);
            }
            if (l9 != 0L) {
                long[] lArray = new long[1];
                long l10 = OS.g_utf8_to_utf16(l9, -1L, null, lArray, null);
                OS.g_free(l9);
                if (l10 != 0L) {
                    int n3 = (int)lArray[0];
                    char[] cArray = new char[n3];
                    C.memmove((char[])cArray, (long)l10, (long)(n3 * 2));
                    OS.g_free(l10);
                    this.filterPath = object2 = new String(cArray);
                }
            }
        }
        Object object3 = this._qfGetDisplay().runDialogClosedHooks(this, object2);
        if (DirectoryDialog.logger.level >= 9) {
            logger.build("openChooserDialog()").add("ret: ").add(object3).log(9);
        }
        if (object3 instanceof String || object3 == null) {
            object2 = (String)object3;
        }
        display.removeIdleProc();
        GTK3.gtk_widget_destroy((long)l4);
        return object2;
    }

    void GTK3setNativeDialogMessage(long l, String string) {
        if (GTK.GTK4) {
            return;
        }
        if (string.length() > 0) {
            long l2;
            byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)true);
            long l3 = GTK.gtk_box_new((int)0, (int)0);
            if (l3 == 0L) {
                this.error(2);
            }
            if ((l2 = GTK.gtk_label_new((byte[])byArray)) == 0L) {
                this.error(2);
            }
            GTK3.gtk_container_add((long)l3, (long)l2);
            GTK3.gtk_widget_show((long)l2);
            GTK3.gtk_label_set_line_wrap((long)l2, (boolean)true);
            GTK.gtk_box_set_homogeneous((long)l3, (boolean)false);
            GTK.gtk_label_set_justify((long)l2, (int)2);
            GTK3.gtk_file_chooser_set_extra_widget((long)l, (long)l3);
        }
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

