/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Logger;
import jxl.biff.StringHelper;
import jxl.biff.formula.ExternalSheet;

public final class CellReferenceHelper {
    private static Logger logger = Logger.getLogger(CellReferenceHelper.class);
    private static final char fixedInd = '$';
    private static final char sheetInd = '!';

    private CellReferenceHelper() {
    }

    public static void getCellReference(int n, int n2, StringBuffer stringBuffer) {
        CellReferenceHelper.getColumnReference(n, stringBuffer);
        stringBuffer.append(Integer.toString(n2 + 1));
    }

    public static void getCellReference(int n, boolean bl, int n2, boolean bl2, StringBuffer stringBuffer) {
        if (bl) {
            stringBuffer.append('$');
        }
        CellReferenceHelper.getColumnReference(n, stringBuffer);
        if (bl2) {
            stringBuffer.append('$');
        }
        stringBuffer.append(Integer.toString(n2 + 1));
    }

    public static String getColumnReference(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        CellReferenceHelper.getColumnReference(n, stringBuffer);
        return stringBuffer.toString();
    }

    public static void getColumnReference(int n, StringBuffer stringBuffer) {
        char c;
        int n2 = n % 26;
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = n / 26; i != 0; i /= 26) {
            c = (char)(65 + n2);
            stringBuffer2.append(c);
            n2 = i % 26 - 1;
        }
        c = (char)(65 + n2);
        stringBuffer2.append(c);
        for (int i = stringBuffer2.length() - 1; i >= 0; --i) {
            stringBuffer.append(stringBuffer2.charAt(i));
        }
    }

    public static void getCellReference(int n, int n2, int n3, ExternalSheet externalSheet, StringBuffer stringBuffer) {
        String string = externalSheet.getExternalSheetName(n);
        stringBuffer.append(StringHelper.replace(string, "'", "''"));
        stringBuffer.append('!');
        CellReferenceHelper.getCellReference(n2, n3, stringBuffer);
    }

    public static void getCellReference(int n, int n2, boolean bl, int n3, boolean bl2, ExternalSheet externalSheet, StringBuffer stringBuffer) {
        String string = externalSheet.getExternalSheetName(n);
        stringBuffer.append(string);
        stringBuffer.append('!');
        CellReferenceHelper.getCellReference(n2, bl, n3, bl2, stringBuffer);
    }

    public static String getCellReference(int n, int n2, int n3, ExternalSheet externalSheet) {
        StringBuffer stringBuffer = new StringBuffer();
        CellReferenceHelper.getCellReference(n, n2, n3, externalSheet, stringBuffer);
        return stringBuffer.toString();
    }

    public static String getCellReference(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        CellReferenceHelper.getCellReference(n, n2, stringBuffer);
        return stringBuffer.toString();
    }

    public static int getColumn(String string) {
        int n = 0;
        int n2 = CellReferenceHelper.getNumberIndex(string);
        String string2 = string.toUpperCase();
        int n3 = string.lastIndexOf(33) + 1;
        if (string.charAt(n3) == '$') {
            ++n3;
        }
        int n4 = n2;
        if (string.charAt(n2 - 1) == '$') {
            --n4;
        }
        for (int i = n3; i < n4; ++i) {
            if (i != n3) {
                n = (n + 1) * 26;
            }
            n += string2.charAt(i) - 65;
        }
        return n;
    }

    public static int getRow(String string) {
        try {
            return Integer.parseInt(string.substring(CellReferenceHelper.getNumberIndex(string))) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn(numberFormatException, numberFormatException);
            return 65535;
        }
    }

    private static int getNumberIndex(String string) {
        boolean bl = false;
        int n = string.lastIndexOf(33) + 1;
        char c = '\u0000';
        while (!bl && n < string.length()) {
            c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                bl = true;
                continue;
            }
            ++n;
        }
        return n;
    }

    public static boolean isColumnRelative(String string) {
        return string.charAt(0) != '$';
    }

    public static boolean isRowRelative(String string) {
        return string.charAt(CellReferenceHelper.getNumberIndex(string) - 1) != '$';
    }

    public static String getSheet(String string) {
        int n = string.lastIndexOf(33);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }
}

