/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import common.Logger;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.biff.BuiltInStyle;
import jxl.biff.DisplayFormat;
import jxl.biff.Fonts;
import jxl.biff.FormatRecord;
import jxl.biff.IndexMapping;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.PaletteRecord;
import jxl.biff.XFRecord;
import jxl.format.Colour;
import jxl.format.RGB;
import jxl.write.biff.File;

public class FormattingRecords {
    private static Logger logger = Logger.getLogger(FormattingRecords.class);
    private HashMap formats;
    private ArrayList formatsList;
    private ArrayList xfRecords = new ArrayList(10);
    private int nextCustomIndexNumber;
    private Fonts fonts;
    private PaletteRecord palette;
    private static final int customFormatStartIndex = 164;
    private static final int maxFormatRecordsIndex = 441;
    private static final int minXFRecords = 21;

    public FormattingRecords(Fonts fonts) {
        this.formats = new HashMap(10);
        this.formatsList = new ArrayList(10);
        this.fonts = fonts;
        this.nextCustomIndexNumber = 164;
    }

    public final void addStyle(XFRecord xFRecord) throws NumFormatRecordsException {
        if (!xFRecord.isInitialized()) {
            int n = this.xfRecords.size();
            xFRecord.initialize(n, this, this.fonts);
            this.xfRecords.add(xFRecord);
        } else if (xFRecord.getXFIndex() >= this.xfRecords.size()) {
            this.xfRecords.add(xFRecord);
        }
    }

    public final void addFormat(DisplayFormat displayFormat) throws NumFormatRecordsException {
        if (displayFormat.isInitialized() && displayFormat.getFormatIndex() >= 441) {
            logger.warn("Format index exceeds Excel maximum - assigning custom number");
            displayFormat.initialize(this.nextCustomIndexNumber);
            ++this.nextCustomIndexNumber;
        }
        if (!displayFormat.isInitialized()) {
            displayFormat.initialize(this.nextCustomIndexNumber);
            ++this.nextCustomIndexNumber;
        }
        if (this.nextCustomIndexNumber > 441) {
            this.nextCustomIndexNumber = 441;
            throw new NumFormatRecordsException();
        }
        if (displayFormat.getFormatIndex() >= this.nextCustomIndexNumber) {
            this.nextCustomIndexNumber = displayFormat.getFormatIndex() + 1;
        }
        if (!displayFormat.isBuiltIn()) {
            this.formatsList.add(displayFormat);
            this.formats.put(new Integer(displayFormat.getFormatIndex()), displayFormat);
        }
    }

    public final boolean isDate(int n) {
        XFRecord xFRecord = (XFRecord)this.xfRecords.get(n);
        if (xFRecord.isDate()) {
            return true;
        }
        FormatRecord formatRecord = (FormatRecord)this.formats.get(new Integer(xFRecord.getFormatRecord()));
        return formatRecord == null ? false : formatRecord.isDate();
    }

    public final DateFormat getDateFormat(int n) {
        XFRecord xFRecord = (XFRecord)this.xfRecords.get(n);
        if (xFRecord.isDate()) {
            return xFRecord.getDateFormat();
        }
        FormatRecord formatRecord = (FormatRecord)this.formats.get(new Integer(xFRecord.getFormatRecord()));
        if (formatRecord == null) {
            return null;
        }
        return formatRecord.isDate() ? formatRecord.getDateFormat() : null;
    }

    public final NumberFormat getNumberFormat(int n) {
        XFRecord xFRecord = (XFRecord)this.xfRecords.get(n);
        if (xFRecord.isNumber()) {
            return xFRecord.getNumberFormat();
        }
        FormatRecord formatRecord = (FormatRecord)this.formats.get(new Integer(xFRecord.getFormatRecord()));
        if (formatRecord == null) {
            return null;
        }
        return formatRecord.isNumber() ? formatRecord.getNumberFormat() : null;
    }

    FormatRecord getFormatRecord(int n) {
        return (FormatRecord)this.formats.get(new Integer(n));
    }

    public void write(File file) throws IOException {
        Iterator iterator = this.formatsList.iterator();
        FormatRecord formatRecord = null;
        while (iterator.hasNext()) {
            formatRecord = (FormatRecord)iterator.next();
            file.write(formatRecord);
        }
        iterator = this.xfRecords.iterator();
        XFRecord xFRecord = null;
        while (iterator.hasNext()) {
            xFRecord = (XFRecord)iterator.next();
            file.write(xFRecord);
        }
        BuiltInStyle builtInStyle = new BuiltInStyle(16, 3);
        file.write(builtInStyle);
        builtInStyle = new BuiltInStyle(17, 6);
        file.write(builtInStyle);
        builtInStyle = new BuiltInStyle(18, 4);
        file.write(builtInStyle);
        builtInStyle = new BuiltInStyle(19, 7);
        file.write(builtInStyle);
        builtInStyle = new BuiltInStyle(0, 0);
        file.write(builtInStyle);
        builtInStyle = new BuiltInStyle(20, 5);
        file.write(builtInStyle);
    }

    protected final Fonts getFonts() {
        return this.fonts;
    }

    public final XFRecord getXFRecord(int n) {
        return (XFRecord)this.xfRecords.get(n);
    }

    protected final int getNumberOfFormatRecords() {
        return this.formatsList.size();
    }

    public IndexMapping rationalizeFonts() {
        return this.fonts.rationalize();
    }

    public IndexMapping rationalize(IndexMapping indexMapping, IndexMapping indexMapping2) {
        int n;
        XFRecord xFRecord2 = null;
        for (XFRecord xFRecord2 : this.xfRecords) {
            if (xFRecord2.getFormatRecord() >= 164) {
                xFRecord2.setFormatIndex(indexMapping2.getNewIndex(xFRecord2.getFormatRecord()));
            }
            xFRecord2.setFontIndex(indexMapping.getNewIndex(xFRecord2.getFontIndex()));
        }
        ArrayList arrayList = new ArrayList(21);
        IndexMapping indexMapping3 = new IndexMapping(this.xfRecords.size());
        int n2 = 0;
        int n3 = Math.min(21, this.xfRecords.size());
        for (n = 0; n < n3; ++n) {
            arrayList.add(this.xfRecords.get(n));
            indexMapping3.setMapping(n, n);
        }
        if (n3 < 21) {
            logger.warn("There are less than the expected minimum number of XF records");
            return indexMapping3;
        }
        for (n = 21; n < this.xfRecords.size(); ++n) {
            XFRecord xFRecord3 = (XFRecord)this.xfRecords.get(n);
            boolean bl = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && !bl) {
                XFRecord xFRecord4 = (XFRecord)iterator.next();
                if (!xFRecord4.equals(xFRecord3)) continue;
                bl = true;
                indexMapping3.setMapping(n, indexMapping3.getNewIndex(xFRecord4.getXFIndex()));
                ++n2;
            }
            if (bl) continue;
            arrayList.add(xFRecord3);
            indexMapping3.setMapping(n, n - n2);
        }
        for (XFRecord xFRecord3 : this.xfRecords) {
            xFRecord3.rationalize(indexMapping3);
        }
        this.xfRecords = arrayList;
        return indexMapping3;
    }

    public IndexMapping rationalizeDisplayFormats() {
        ArrayList<DisplayFormat> arrayList = new ArrayList<DisplayFormat>();
        int n = 0;
        IndexMapping indexMapping = new IndexMapping(this.nextCustomIndexNumber);
        Iterator iterator = this.formatsList.iterator();
        DisplayFormat displayFormat3 = null;
        DisplayFormat displayFormat2 = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            displayFormat3 = (DisplayFormat)iterator.next();
            Assert.verify(!displayFormat3.isBuiltIn());
            Iterator iterator2 = arrayList.iterator();
            bl = false;
            while (iterator2.hasNext() && !bl) {
                displayFormat2 = (DisplayFormat)iterator2.next();
                if (!displayFormat2.equals(displayFormat3)) continue;
                bl = true;
                indexMapping.setMapping(displayFormat3.getFormatIndex(), indexMapping.getNewIndex(displayFormat2.getFormatIndex()));
                ++n;
            }
            if (bl) continue;
            arrayList.add(displayFormat3);
            int n2 = displayFormat3.getFormatIndex() - n;
            if (n2 > 441) {
                logger.warn("Too many number formats - using default format.");
                n2 = 0;
            }
            indexMapping.setMapping(displayFormat3.getFormatIndex(), displayFormat3.getFormatIndex() - n);
        }
        this.formatsList = arrayList;
        for (DisplayFormat displayFormat3 : this.formatsList) {
            displayFormat3.initialize(indexMapping.getNewIndex(displayFormat3.getFormatIndex()));
        }
        return indexMapping;
    }

    public PaletteRecord getPalette() {
        return this.palette;
    }

    public void setPalette(PaletteRecord paletteRecord) {
        this.palette = paletteRecord;
    }

    public void setColourRGB(Colour colour, int n, int n2, int n3) {
        if (this.palette == null) {
            this.palette = new PaletteRecord();
        }
        this.palette.setColourRGB(colour, n, n2, n3);
    }

    public RGB getColourRGB(Colour colour) {
        if (this.palette == null) {
            return colour.getDefaultRGB();
        }
        return this.palette.getColourRGB(colour);
    }
}

