/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Logger;

public abstract class HeaderFooter {
    private static Logger logger = Logger.getLogger(HeaderFooter.class);
    private static final String BOLD_TOGGLE = "&B";
    private static final String UNDERLINE_TOGGLE = "&U";
    private static final String ITALICS_TOGGLE = "&I";
    private static final String STRIKETHROUGH_TOGGLE = "&S";
    private static final String DOUBLE_UNDERLINE_TOGGLE = "&E";
    private static final String SUPERSCRIPT_TOGGLE = "&X";
    private static final String SUBSCRIPT_TOGGLE = "&Y";
    private static final String OUTLINE_TOGGLE = "&O";
    private static final String SHADOW_TOGGLE = "&H";
    private static final String LEFT_ALIGN = "&L";
    private static final String CENTRE = "&C";
    private static final String RIGHT_ALIGN = "&R";
    private static final String PAGENUM = "&P";
    private static final String TOTAL_PAGENUM = "&N";
    private static final String DATE = "&D";
    private static final String TIME = "&T";
    private static final String WORKBOOK_NAME = "&F";
    private static final String WORKSHEET_NAME = "&A";
    private Contents left;
    private Contents right;
    private Contents centre;

    protected HeaderFooter() {
        this.left = this.createContents();
        this.right = this.createContents();
        this.centre = this.createContents();
    }

    protected HeaderFooter(HeaderFooter headerFooter) {
        this.left = this.createContents(headerFooter.left);
        this.right = this.createContents(headerFooter.right);
        this.centre = this.createContents(headerFooter.centre);
    }

    protected HeaderFooter(String string) {
        if (string == null || string.length() == 0) {
            this.left = this.createContents();
            this.right = this.createContents();
            this.centre = this.createContents();
            return;
        }
        int n = 0;
        int n2 = string.indexOf(LEFT_ALIGN);
        int n3 = string.indexOf(RIGHT_ALIGN);
        int n4 = string.indexOf(CENTRE);
        if (n == n2) {
            if (n4 != -1) {
                this.left = this.createContents(string.substring(n + 2, n4));
                n = n4;
            } else if (n3 != -1) {
                this.left = this.createContents(string.substring(n + 2, n3));
                n = n3;
            } else {
                this.left = this.createContents(string.substring(n + 2));
                n = string.length();
            }
        }
        if (n == n4 || n2 == -1 && n3 == -1 && n4 == -1) {
            if (n3 != -1) {
                this.centre = this.createContents(string.substring(n + 2, n3));
                n = n3;
            } else {
                int n5 = n == n4 ? n + 2 : n;
                this.centre = this.createContents(string.substring(n5));
                n = string.length();
            }
        }
        if (n == n3) {
            this.right = this.createContents(string.substring(n + 2));
            n = string.length();
        }
        if (this.left == null) {
            this.left = this.createContents();
        }
        if (this.centre == null) {
            this.centre = this.createContents();
        }
        if (this.right == null) {
            this.right = this.createContents();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.left.empty()) {
            stringBuffer.append(LEFT_ALIGN);
            stringBuffer.append(this.left.getContents());
        }
        if (!this.centre.empty()) {
            stringBuffer.append(CENTRE);
            stringBuffer.append(this.centre.getContents());
        }
        if (!this.right.empty()) {
            stringBuffer.append(RIGHT_ALIGN);
            stringBuffer.append(this.right.getContents());
        }
        return stringBuffer.toString();
    }

    protected Contents getRightText() {
        return this.right;
    }

    protected Contents getCentreText() {
        return this.centre;
    }

    protected Contents getLeftText() {
        return this.left;
    }

    protected void clear() {
        this.left.clear();
        this.right.clear();
        this.centre.clear();
    }

    protected abstract Contents createContents();

    protected abstract Contents createContents(String var1);

    protected abstract Contents createContents(Contents var1);

    protected static class Contents {
        private StringBuffer contents;

        protected Contents() {
            this.contents = new StringBuffer();
        }

        protected Contents(String string) {
            this.contents = new StringBuffer(string);
        }

        protected Contents(Contents contents) {
            this.contents = new StringBuffer(contents.getContents());
        }

        protected String getContents() {
            return this.contents != null ? this.contents.toString() : "";
        }

        private void appendInternal(String string) {
            if (this.contents == null) {
                this.contents = new StringBuffer();
            }
            this.contents.append(string);
        }

        private void appendInternal(char c) {
            if (this.contents == null) {
                this.contents = new StringBuffer();
            }
            this.contents.append(c);
        }

        protected void append(String string) {
            this.appendInternal(string);
        }

        protected void toggleBold() {
            this.appendInternal(HeaderFooter.BOLD_TOGGLE);
        }

        protected void toggleUnderline() {
            this.appendInternal(HeaderFooter.UNDERLINE_TOGGLE);
        }

        protected void toggleItalics() {
            this.appendInternal(HeaderFooter.ITALICS_TOGGLE);
        }

        protected void toggleStrikethrough() {
            this.appendInternal(HeaderFooter.STRIKETHROUGH_TOGGLE);
        }

        protected void toggleDoubleUnderline() {
            this.appendInternal(HeaderFooter.DOUBLE_UNDERLINE_TOGGLE);
        }

        protected void toggleSuperScript() {
            this.appendInternal(HeaderFooter.SUPERSCRIPT_TOGGLE);
        }

        protected void toggleSubScript() {
            this.appendInternal(HeaderFooter.SUBSCRIPT_TOGGLE);
        }

        protected void toggleOutline() {
            this.appendInternal(HeaderFooter.OUTLINE_TOGGLE);
        }

        protected void toggleShadow() {
            this.appendInternal(HeaderFooter.SHADOW_TOGGLE);
        }

        protected void setFontName(String string) {
            this.appendInternal("&\"");
            this.appendInternal(string);
            this.appendInternal('\"');
        }

        protected boolean setFontSize(int n) {
            if (n < 1 || n > 99) {
                return false;
            }
            String string = n < 10 ? "0" + n : Integer.toString(n);
            this.appendInternal('&');
            this.appendInternal(string);
            return true;
        }

        protected void appendPageNumber() {
            this.appendInternal(HeaderFooter.PAGENUM);
        }

        protected void appendTotalPages() {
            this.appendInternal(HeaderFooter.TOTAL_PAGENUM);
        }

        protected void appendDate() {
            this.appendInternal(HeaderFooter.DATE);
        }

        protected void appendTime() {
            this.appendInternal(HeaderFooter.TIME);
        }

        protected void appendWorkbookName() {
            this.appendInternal(HeaderFooter.WORKBOOK_NAME);
        }

        protected void appendWorkSheetName() {
            this.appendInternal(HeaderFooter.WORKSHEET_NAME);
        }

        protected void clear() {
            this.contents = null;
        }

        protected boolean empty() {
            return this.contents == null || this.contents.length() == 0;
        }
    }
}

