/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Logger;
import java.io.UnsupportedEncodingException;
import jxl.WorkbookSettings;

public final class StringHelper {
    private static Logger logger = Logger.getLogger(StringHelper.class);

    private StringHelper() {
    }

    public static byte[] getBytes(String string) {
        return string.getBytes();
    }

    public static byte[] getBytes(String string, WorkbookSettings workbookSettings) {
        try {
            return string.getBytes(workbookSettings.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] getUnicodeBytes(String string) {
        try {
            byte[] byArray = string.getBytes("UnicodeLittle");
            if (byArray.length == string.length() * 2 + 2) {
                byte[] byArray2 = new byte[byArray.length - 2];
                System.arraycopy(byArray, 2, byArray2, 0, byArray2.length);
                byArray = byArray2;
            }
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static void getBytes(String string, byte[] byArray, int n) {
        byte[] byArray2 = StringHelper.getBytes(string);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void getUnicodeBytes(String string, byte[] byArray, int n) {
        byte[] byArray2 = StringHelper.getUnicodeBytes(string);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static String getString(byte[] byArray, int n, int n2, WorkbookSettings workbookSettings) {
        try {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, n2, byArray2, 0, n);
            return new String(byArray2, workbookSettings.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.warn(unsupportedEncodingException.toString());
            return "";
        }
    }

    public static String getUnicodeString(byte[] byArray, int n, int n2) {
        try {
            byte[] byArray2 = new byte[n * 2];
            System.arraycopy(byArray, n2, byArray2, 0, n * 2);
            return new String(byArray2, "UnicodeLittle");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static final String replace(String string, String string2, String string3) {
        String string4 = string;
        int n = string4.indexOf(string2);
        while (n != -1) {
            StringBuffer stringBuffer = new StringBuffer(string4.substring(0, n));
            stringBuffer.append(string3);
            stringBuffer.append(string4.substring(n + string2.length()));
            string4 = stringBuffer.toString();
            n = string4.indexOf(string2, n + string3.length());
        }
        return string4;
    }
}

