/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.drawing.EscherAtom;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;

class ClientAnchor
extends EscherAtom {
    private static final Logger logger = Logger.getLogger(ClientAnchor.class);
    private byte[] data;
    private int properties;
    private double x1;
    private double y1;
    private double x2;
    private double y2;

    public ClientAnchor(EscherRecordData escherRecordData) {
        super(escherRecordData);
        byte[] byArray = this.getBytes();
        this.properties = IntegerHelper.getInt(byArray[0], byArray[1]);
        int n = IntegerHelper.getInt(byArray[2], byArray[3]);
        int n2 = IntegerHelper.getInt(byArray[4], byArray[5]);
        this.x1 = (double)n + (double)n2 / 1024.0;
        int n3 = IntegerHelper.getInt(byArray[6], byArray[7]);
        int n4 = IntegerHelper.getInt(byArray[8], byArray[9]);
        this.y1 = (double)n3 + (double)n4 / 256.0;
        int n5 = IntegerHelper.getInt(byArray[10], byArray[11]);
        int n6 = IntegerHelper.getInt(byArray[12], byArray[13]);
        this.x2 = (double)n5 + (double)n6 / 1024.0;
        int n7 = IntegerHelper.getInt(byArray[14], byArray[15]);
        int n8 = IntegerHelper.getInt(byArray[16], byArray[17]);
        this.y2 = (double)n7 + (double)n8 / 256.0;
    }

    public ClientAnchor(double d, double d2, double d3, double d4, int n) {
        super(EscherRecordType.CLIENT_ANCHOR);
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
        this.properties = n;
    }

    byte[] getData() {
        this.data = new byte[18];
        IntegerHelper.getTwoBytes(this.properties, this.data, 0);
        IntegerHelper.getTwoBytes((int)this.x1, this.data, 2);
        int n = (int)((this.x1 - (double)((int)this.x1)) * 1024.0);
        IntegerHelper.getTwoBytes(n, this.data, 4);
        IntegerHelper.getTwoBytes((int)this.y1, this.data, 6);
        int n2 = (int)((this.y1 - (double)((int)this.y1)) * 256.0);
        IntegerHelper.getTwoBytes(n2, this.data, 8);
        IntegerHelper.getTwoBytes((int)this.x2, this.data, 10);
        int n3 = (int)((this.x2 - (double)((int)this.x2)) * 1024.0);
        IntegerHelper.getTwoBytes(n3, this.data, 12);
        IntegerHelper.getTwoBytes((int)this.y2, this.data, 14);
        int n4 = (int)((this.y2 - (double)((int)this.y2)) * 256.0);
        IntegerHelper.getTwoBytes(n4, this.data, 16);
        return this.setHeaderData(this.data);
    }

    double getX1() {
        return this.x1;
    }

    double getY1() {
        return this.y1;
    }

    double getX2() {
        return this.x2;
    }

    double getY2() {
        return this.y2;
    }

    int getProperties() {
        return this.properties;
    }
}

