/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Logger;
import java.util.ArrayList;
import jxl.biff.IntegerHelper;
import jxl.biff.drawing.EscherAtom;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;

class Dgg
extends EscherAtom {
    private static Logger logger = Logger.getLogger(Dgg.class);
    private byte[] data;
    private int numClusters;
    private int maxShapeId;
    private int shapesSaved;
    private int drawingsSaved;
    private ArrayList clusters;

    public Dgg(EscherRecordData escherRecordData) {
        super(escherRecordData);
        this.clusters = new ArrayList();
        byte[] byArray = this.getBytes();
        this.maxShapeId = IntegerHelper.getInt(byArray[0], byArray[1], byArray[2], byArray[3]);
        this.numClusters = IntegerHelper.getInt(byArray[4], byArray[5], byArray[6], byArray[7]);
        this.shapesSaved = IntegerHelper.getInt(byArray[8], byArray[9], byArray[10], byArray[11]);
        this.drawingsSaved = IntegerHelper.getInt(byArray[12], byArray[13], byArray[14], byArray[15]);
        int n = 16;
        for (int i = 0; i < this.numClusters; ++i) {
            int n2 = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
            int n3 = IntegerHelper.getInt(byArray[n + 2], byArray[n + 3]);
            Cluster cluster = new Cluster(n2, n3);
            this.clusters.add(cluster);
            n += 4;
        }
    }

    public Dgg(int n, int n2) {
        super(EscherRecordType.DGG);
        this.shapesSaved = n;
        this.drawingsSaved = n2;
        this.clusters = new ArrayList();
    }

    void addCluster(int n, int n2) {
        Cluster cluster = new Cluster(n, n2);
        this.clusters.add(cluster);
    }

    byte[] getData() {
        this.numClusters = this.clusters.size();
        this.data = new byte[16 + this.numClusters * 4];
        IntegerHelper.getFourBytes(1024 + this.shapesSaved, this.data, 0);
        IntegerHelper.getFourBytes(this.numClusters, this.data, 4);
        IntegerHelper.getFourBytes(this.shapesSaved, this.data, 8);
        IntegerHelper.getFourBytes(1, this.data, 12);
        int n = 16;
        for (int i = 0; i < this.numClusters; ++i) {
            Cluster cluster = (Cluster)this.clusters.get(i);
            IntegerHelper.getTwoBytes(cluster.drawingGroupId, this.data, n);
            IntegerHelper.getTwoBytes(cluster.shapeIdsUsed, this.data, n + 2);
            n += 4;
        }
        return this.setHeaderData(this.data);
    }

    int getShapesSaved() {
        return this.shapesSaved;
    }

    int getDrawingsSaved() {
        return this.drawingsSaved;
    }

    Cluster getCluster(int n) {
        return (Cluster)this.clusters.get(n);
    }

    static final class Cluster {
        int drawingGroupId;
        int shapeIdsUsed;

        Cluster(int n, int n2) {
            this.drawingGroupId = n;
            this.shapeIdsUsed = n2;
        }
    }
}

