/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import jxl.biff.drawing.DrawingDataException;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;

public class DrawingData
implements EscherStream {
    private static Logger logger = Logger.getLogger(DrawingData.class);
    private byte[] drawingData = null;
    private int numDrawings = 0;
    private boolean initialized = false;
    private EscherRecord[] spContainers;

    private void initialize() {
        EscherRecordData escherRecordData = new EscherRecordData(this, 0);
        Assert.verify(escherRecordData.isContainer());
        EscherContainer escherContainer = new EscherContainer(escherRecordData);
        EscherRecord[] escherRecordArray = escherContainer.getChildren();
        escherRecordArray = escherContainer.getChildren();
        EscherContainer escherContainer2 = null;
        for (int i = 0; i < escherRecordArray.length && escherContainer2 == null; ++i) {
            EscherRecord escherRecord = escherRecordArray[i];
            if (escherRecord.getType() != EscherRecordType.SPGR_CONTAINER) continue;
            escherContainer2 = (EscherContainer)escherRecord;
        }
        Assert.verify(escherContainer2 != null);
        EscherRecord[] escherRecordArray2 = escherContainer2.getChildren();
        boolean bl = false;
        for (int i = 0; i < escherRecordArray2.length && !bl; ++i) {
            if (escherRecordArray2[i].getType() != EscherRecordType.SPGR_CONTAINER) continue;
            bl = true;
        }
        if (!bl) {
            this.spContainers = escherRecordArray2;
        } else {
            ArrayList arrayList = new ArrayList();
            this.getSpContainers(escherContainer2, arrayList);
            this.spContainers = new EscherRecord[arrayList.size()];
            this.spContainers = arrayList.toArray(this.spContainers);
        }
        this.initialized = true;
    }

    private void getSpContainers(EscherContainer escherContainer, ArrayList arrayList) {
        EscherRecord[] escherRecordArray = escherContainer.getChildren();
        for (int i = 0; i < escherRecordArray.length; ++i) {
            if (escherRecordArray[i].getType() == EscherRecordType.SP_CONTAINER) {
                arrayList.add(escherRecordArray[i]);
                continue;
            }
            if (escherRecordArray[i].getType() == EscherRecordType.SPGR_CONTAINER) {
                this.getSpContainers((EscherContainer)escherRecordArray[i], arrayList);
                continue;
            }
            logger.warn("Spgr Containers contains a record other than Sp/Spgr containers");
        }
    }

    public void addData(byte[] byArray) {
        this.addRawData(byArray);
        ++this.numDrawings;
    }

    public void addRawData(byte[] byArray) {
        if (this.drawingData == null) {
            this.drawingData = byArray;
            return;
        }
        byte[] byArray2 = new byte[this.drawingData.length + byArray.length];
        System.arraycopy(this.drawingData, 0, byArray2, 0, this.drawingData.length);
        System.arraycopy(byArray, 0, byArray2, this.drawingData.length, byArray.length);
        this.drawingData = byArray2;
        this.initialized = false;
    }

    final int getNumDrawings() {
        return this.numDrawings;
    }

    EscherContainer getSpContainer(int n) {
        if (!this.initialized) {
            this.initialize();
        }
        if (n + 1 >= this.spContainers.length) {
            throw new DrawingDataException();
        }
        EscherContainer escherContainer = (EscherContainer)this.spContainers[n + 1];
        Assert.verify(escherContainer != null);
        return escherContainer;
    }

    public byte[] getData() {
        return this.drawingData;
    }
}

