/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import jxl.biff.drawing.Chunk;
import jxl.biff.drawing.ChunkType;

public class PNGReader {
    private byte[] pngData;
    private Chunk ihdr;
    private Chunk phys;
    private int pixelWidth;
    private int pixelHeight;
    private int verticalResolution;
    private int horizontalResolution;
    private int resolutionUnit;
    private static byte[] PNG_MAGIC_NUMBER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public PNGReader(byte[] byArray) {
        this.pngData = byArray;
    }

    void read() {
        Object object;
        int n;
        byte[] byArray = new byte[PNG_MAGIC_NUMBER.length];
        System.arraycopy(this.pngData, 0, byArray, 0, byArray.length);
        boolean bl = Arrays.equals(PNG_MAGIC_NUMBER, byArray);
        if (!bl) {
            return;
        }
        for (int i = 8; i < this.pngData.length; i += n + 12) {
            n = this.getInt(this.pngData[i], this.pngData[i + 1], this.pngData[i + 2], this.pngData[i + 3]);
            object = ChunkType.getChunkType(this.pngData[i + 4], this.pngData[i + 5], this.pngData[i + 6], this.pngData[i + 7]);
            if (object == ChunkType.IHDR) {
                this.ihdr = new Chunk(i + 8, n, (ChunkType)object, this.pngData);
                continue;
            }
            if (object != ChunkType.PHYS) continue;
            this.phys = new Chunk(i + 8, n, (ChunkType)object, this.pngData);
        }
        byte[] byArray2 = this.ihdr.getData();
        this.pixelWidth = this.getInt(byArray2[0], byArray2[1], byArray2[2], byArray2[3]);
        this.pixelHeight = this.getInt(byArray2[4], byArray2[5], byArray2[6], byArray2[7]);
        if (this.phys != null) {
            object = this.phys.getData();
            this.resolutionUnit = object[8];
            this.horizontalResolution = this.getInt(object[0], object[1], object[2], object[3]);
            this.verticalResolution = this.getInt(object[4], object[5], object[6], object[7]);
        }
    }

    private int getInt(byte by, byte by2, byte by3, byte by4) {
        int n = by & 0xFF;
        int n2 = by2 & 0xFF;
        int n3 = by3 & 0xFF;
        int n4 = by4 & 0xFF;
        int n5 = n << 24 | n2 << 16 | n3 << 8 | n4;
        return n5;
    }

    public int getHeight() {
        return this.pixelHeight;
    }

    public int getWidth() {
        return this.pixelWidth;
    }

    public int getHorizontalResolution() {
        return this.resolutionUnit == 1 ? this.horizontalResolution : 0;
    }

    public int getVerticalResolution() {
        return this.resolutionUnit == 1 ? this.verticalResolution : 0;
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File(stringArray[0]);
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
            fileInputStream.close();
            PNGReader pNGReader = new PNGReader(byArray);
            pNGReader.read();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

