/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.drawing.EscherAtom;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.ShapeType;

class Sp
extends EscherAtom {
    private static Logger logger = Logger.getLogger(Sp.class);
    private byte[] data;
    private int shapeType;
    private int shapeId;
    private int persistenceFlags;

    public Sp(EscherRecordData escherRecordData) {
        super(escherRecordData);
        this.shapeType = this.getInstance();
        byte[] byArray = this.getBytes();
        this.shapeId = IntegerHelper.getInt(byArray[0], byArray[1], byArray[2], byArray[3]);
        this.persistenceFlags = IntegerHelper.getInt(byArray[4], byArray[5], byArray[6], byArray[7]);
    }

    public Sp(ShapeType shapeType, int n, int n2) {
        super(EscherRecordType.SP);
        this.setVersion(2);
        this.shapeType = shapeType.getValue();
        this.shapeId = n;
        this.persistenceFlags = n2;
        this.setInstance(this.shapeType);
    }

    int getShapeId() {
        return this.shapeId;
    }

    int getShapeType() {
        return this.shapeType;
    }

    byte[] getData() {
        this.data = new byte[8];
        IntegerHelper.getFourBytes(this.shapeId, this.data, 0);
        IntegerHelper.getFourBytes(this.persistenceFlags, this.data, 4);
        return this.setHeaderData(this.data);
    }
}

