/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Logger;
import java.util.Stack;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Function;
import jxl.biff.formula.Operator;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.StringFunction;
import jxl.biff.formula.Token;
import jxl.biff.formula.VariableArgFunction;

class Attribute
extends Operator
implements ParsedThing {
    private static Logger logger = Logger.getLogger(Attribute.class);
    private int options;
    private int word;
    private WorkbookSettings settings;
    private static final int SUM_MASK = 16;
    private static final int IF_MASK = 2;
    private static final int GOTO_MASK = 8;
    private VariableArgFunction ifConditions;

    public Attribute(WorkbookSettings workbookSettings) {
        this.settings = workbookSettings;
    }

    public Attribute(StringFunction stringFunction, WorkbookSettings workbookSettings) {
        this.settings = workbookSettings;
        if (stringFunction.getFunction(this.settings) == Function.SUM) {
            this.options |= 0x10;
        } else if (stringFunction.getFunction(this.settings) == Function.IF) {
            this.options |= 2;
        }
    }

    void setIfConditions(VariableArgFunction variableArgFunction) {
        this.ifConditions = variableArgFunction;
        this.options |= 2;
    }

    public int read(byte[] byArray, int n) {
        this.options = byArray[n];
        this.word = IntegerHelper.getInt(byArray[n + 1], byArray[n + 2]);
        return 3;
    }

    public boolean isFunction() {
        return (this.options & 0x12) != 0;
    }

    public boolean isSum() {
        return (this.options & 0x10) != 0;
    }

    public boolean isIf() {
        return (this.options & 2) != 0;
    }

    public boolean isGoto() {
        return (this.options & 8) != 0;
    }

    public void getOperands(Stack stack) {
        if ((this.options & 0x10) != 0) {
            ParseItem parseItem = (ParseItem)stack.pop();
            this.add(parseItem);
        } else if ((this.options & 2) != 0) {
            ParseItem parseItem = (ParseItem)stack.pop();
            this.add(parseItem);
        }
    }

    public void getString(StringBuffer stringBuffer) {
        if ((this.options & 0x10) != 0) {
            ParseItem[] parseItemArray = this.getOperands();
            stringBuffer.append(Function.SUM.getName(this.settings));
            stringBuffer.append('(');
            parseItemArray[0].getString(stringBuffer);
            stringBuffer.append(')');
        } else if ((this.options & 2) != 0) {
            stringBuffer.append(Function.IF.getName(this.settings));
            stringBuffer.append('(');
            ParseItem[] parseItemArray = this.ifConditions.getOperands();
            for (int i = 0; i < parseItemArray.length - 1; ++i) {
                parseItemArray[i].getString(stringBuffer);
                stringBuffer.append(',');
            }
            parseItemArray[parseItemArray.length - 1].getString(stringBuffer);
            stringBuffer.append(')');
        }
    }

    byte[] getBytes() {
        byte[] byArray = new byte[]{};
        if (this.isSum()) {
            ParseItem[] parseItemArray = this.getOperands();
            for (int i = parseItemArray.length - 1; i >= 0; --i) {
                byte[] byArray2 = parseItemArray[i].getBytes();
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                byArray = byArray3;
            }
            byte[] byArray4 = new byte[byArray.length + 4];
            System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
            byArray4[byArray.length] = Token.ATTRIBUTE.getCode();
            byArray4[byArray.length + 1] = 16;
            byArray = byArray4;
        } else if (this.isIf()) {
            return this.getIf();
        }
        return byArray;
    }

    private byte[] getIf() {
        ParseItem[] parseItemArray = this.ifConditions.getOperands();
        int n = 0;
        int n2 = 0;
        int n3 = parseItemArray.length;
        byte[] byArray = parseItemArray[0].getBytes();
        int n4 = byArray.length;
        byte[] byArray2 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray = byArray2;
        byArray[n4] = Token.ATTRIBUTE.getCode();
        byArray[n4 + 1] = 2;
        n = n4 + 2;
        byte[] byArray3 = parseItemArray[1].getBytes();
        byArray2 = new byte[byArray.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(byArray3, 0, byArray2, byArray.length, byArray3.length);
        byArray = byArray2;
        n4 = byArray.length;
        byArray2 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray = byArray2;
        byArray[n4] = Token.ATTRIBUTE.getCode();
        byArray[n4 + 1] = 8;
        n2 = n4 + 2;
        if (n3 > 2) {
            IntegerHelper.getTwoBytes(byArray.length - n - 2, byArray, n);
            byte[] byArray4 = parseItemArray[n3 - 1].getBytes();
            byArray2 = new byte[byArray.length + byArray4.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            System.arraycopy(byArray4, 0, byArray2, byArray.length, byArray4.length);
            byArray = byArray2;
            n4 = byArray.length;
            byArray2 = new byte[byArray.length + 4];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
            byArray[n4] = Token.ATTRIBUTE.getCode();
            byArray[n4 + 1] = 8;
            byArray[n4 + 2] = 3;
        }
        n4 = byArray.length;
        byArray2 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray = byArray2;
        byArray[n4] = Token.FUNCTIONVARARG.getCode();
        byArray[n4 + 1] = (byte)n3;
        byArray[n4 + 2] = 1;
        byArray[n4 + 3] = 0;
        int n5 = byArray.length - 1;
        if (n3 < 3) {
            IntegerHelper.getTwoBytes(n5 - n - 5, byArray, n);
        }
        IntegerHelper.getTwoBytes(n5 - n2 - 2, byArray, n2);
        return byArray;
    }

    int getPrecedence() {
        return 3;
    }

    public void adjustRelativeCellReferences(int n, int n2) {
        ParseItem[] parseItemArray = null;
        parseItemArray = this.isIf() ? this.ifConditions.getOperands() : this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].adjustRelativeCellReferences(n, n2);
        }
    }

    void columnInserted(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = null;
        parseItemArray = this.isIf() ? this.ifConditions.getOperands() : this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].columnInserted(n, n2, bl);
        }
    }

    void columnRemoved(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = null;
        parseItemArray = this.isIf() ? this.ifConditions.getOperands() : this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].columnRemoved(n, n2, bl);
        }
    }

    void rowInserted(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = null;
        parseItemArray = this.isIf() ? this.ifConditions.getOperands() : this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].rowInserted(n, n2, bl);
        }
    }

    void rowRemoved(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = null;
        parseItemArray = this.isIf() ? this.ifConditions.getOperands() : this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].rowRemoved(n, n2, bl);
        }
    }

    void handleImportedCellReferences() {
        ParseItem[] parseItemArray = null;
        parseItemArray = this.isIf() ? this.ifConditions.getOperands() : this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].handleImportedCellReferences();
        }
    }
}

