/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Assert;
import common.Logger;
import java.util.Stack;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Function;
import jxl.biff.formula.Operator;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class BuiltInFunction
extends Operator
implements ParsedThing {
    private static Logger logger = Logger.getLogger(BuiltInFunction.class);
    private Function function;
    private WorkbookSettings settings;

    public BuiltInFunction(WorkbookSettings workbookSettings) {
        this.settings = workbookSettings;
    }

    public BuiltInFunction(Function function, WorkbookSettings workbookSettings) {
        this.function = function;
        this.settings = workbookSettings;
    }

    public int read(byte[] byArray, int n) {
        int n2 = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
        this.function = Function.getFunction(n2);
        Assert.verify(this.function != Function.UNKNOWN, "function code " + n2);
        return 2;
    }

    public void getOperands(Stack stack) {
        int n;
        ParseItem[] parseItemArray = new ParseItem[this.function.getNumArgs()];
        for (n = this.function.getNumArgs() - 1; n >= 0; --n) {
            ParseItem parseItem;
            parseItemArray[n] = parseItem = (ParseItem)stack.pop();
        }
        for (n = 0; n < this.function.getNumArgs(); ++n) {
            this.add(parseItemArray[n]);
        }
    }

    public void getString(StringBuffer stringBuffer) {
        stringBuffer.append(this.function.getName(this.settings));
        stringBuffer.append('(');
        int n = this.function.getNumArgs();
        if (n > 0) {
            ParseItem[] parseItemArray = this.getOperands();
            parseItemArray[0].getString(stringBuffer);
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(',');
                parseItemArray[i].getString(stringBuffer);
            }
        }
        stringBuffer.append(')');
    }

    public void adjustRelativeCellReferences(int n, int n2) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].adjustRelativeCellReferences(n, n2);
        }
    }

    void columnInserted(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].columnInserted(n, n2, bl);
        }
    }

    void columnRemoved(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].columnRemoved(n, n2, bl);
        }
    }

    void rowInserted(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].rowInserted(n, n2, bl);
        }
    }

    void rowRemoved(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].rowRemoved(n, n2, bl);
        }
    }

    void handleImportedCellReferences() {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].handleImportedCellReferences();
        }
    }

    byte[] getBytes() {
        ParseItem[] parseItemArray = this.getOperands();
        byte[] byArray = new byte[]{};
        for (int i = 0; i < parseItemArray.length; ++i) {
            byte[] byArray2 = parseItemArray[i].getBytes();
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byArray = byArray3;
        }
        byte[] byArray4 = new byte[byArray.length + 3];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        byArray4[byArray.length] = !this.useAlternateCode() ? Token.FUNCTION.getCode() : Token.FUNCTION.getCode2();
        IntegerHelper.getTwoBytes(this.function.getCode(), byArray4, byArray.length + 1);
        return byArray4;
    }

    int getPrecedence() {
        return 3;
    }
}

