/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Logger;
import jxl.Cell;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class CellReference
extends Operand
implements ParsedThing {
    private static Logger logger = Logger.getLogger(CellReference.class);
    private boolean columnRelative;
    private boolean rowRelative;
    private int column;
    private int row;
    private Cell relativeTo;

    public CellReference(Cell cell) {
        this.relativeTo = cell;
    }

    public CellReference() {
    }

    public CellReference(String string) {
        this.column = CellReferenceHelper.getColumn(string);
        this.row = CellReferenceHelper.getRow(string);
        this.columnRelative = CellReferenceHelper.isColumnRelative(string);
        this.rowRelative = CellReferenceHelper.isRowRelative(string);
    }

    public int read(byte[] byArray, int n) {
        this.row = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
        int n2 = IntegerHelper.getInt(byArray[n + 2], byArray[n + 3]);
        this.column = n2 & 0xFF;
        this.columnRelative = (n2 & 0x4000) != 0;
        this.rowRelative = (n2 & 0x8000) != 0;
        return 4;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public void getString(StringBuffer stringBuffer) {
        CellReferenceHelper.getCellReference(this.column, !this.columnRelative, this.row, !this.rowRelative, stringBuffer);
    }

    byte[] getBytes() {
        byte[] byArray = new byte[5];
        byArray[0] = !this.useAlternateCode() ? Token.REF.getCode() : Token.REF.getCode2();
        IntegerHelper.getTwoBytes(this.row, byArray, 1);
        int n = this.column;
        if (this.rowRelative) {
            n |= 0x8000;
        }
        if (this.columnRelative) {
            n |= 0x4000;
        }
        IntegerHelper.getTwoBytes(n, byArray, 3);
        return byArray;
    }

    public void adjustRelativeCellReferences(int n, int n2) {
        if (this.columnRelative) {
            this.column += n;
        }
        if (this.rowRelative) {
            this.row += n2;
        }
    }

    public void columnInserted(int n, int n2, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.column >= n2) {
            ++this.column;
        }
    }

    void columnRemoved(int n, int n2, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.column >= n2) {
            --this.column;
        }
    }

    void rowInserted(int n, int n2, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.row >= n2) {
            ++this.row;
        }
    }

    void rowRemoved(int n, int n2, boolean bl) {
        if (!bl) {
            return;
        }
        if (this.row >= n2) {
            --this.row;
        }
    }

    void handleImportedCellReferences() {
    }
}

