/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import jxl.CellReferenceHelper;
import jxl.CellView;
import jxl.HeaderFooter;
import jxl.Range;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.WritableRecordData;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.ScriptStyle;
import jxl.format.UnderlineStyle;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateFormat;
import jxl.write.DateFormats;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.NumberFormats;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class Write {
    private String filename;
    private WritableWorkbook workbook;

    public Write(String string) {
        this.filename = string;
    }

    public void write() throws IOException, WriteException {
        WorkbookSettings workbookSettings = new WorkbookSettings();
        workbookSettings.setLocale(new Locale("en", "EN"));
        this.workbook = Workbook.createWorkbook(new File(this.filename), workbookSettings);
        WritableSheet writableSheet = this.workbook.createSheet("Number Formats", 0);
        WritableSheet writableSheet2 = this.workbook.createSheet("Date Formats", 1);
        WritableSheet writableSheet3 = this.workbook.createSheet("Label Formats", 2);
        WritableSheet writableSheet4 = this.workbook.createSheet("Borders", 3);
        WritableSheet writableSheet5 = this.workbook.createSheet("Labels", 4);
        WritableSheet writableSheet6 = this.workbook.createSheet("Formulas", 5);
        WritableSheet writableSheet7 = this.workbook.createSheet("Images", 6);
        this.workbook.setColourRGB(Colour.LIME, 255, 0, 0);
        this.workbook.addNameArea("namedrange", writableSheet4, 1, 11, 5, 14);
        this.workbook.addNameArea("validation_range", writableSheet3, 4, 65, 9, 65);
        writableSheet5.getSettings().setPrintArea(4, 4, 15, 35);
        this.writeLabelFormatSheet(writableSheet3);
        this.writeNumberFormatSheet(writableSheet);
        this.writeDateFormatSheet(writableSheet2);
        this.writeBordersSheet(writableSheet4);
        this.writeLabelsSheet(writableSheet5);
        this.writeFormulaSheet(writableSheet6);
        this.writeImageSheet(writableSheet7);
        this.workbook.write();
        this.workbook.close();
    }

    private void writeNumberFormatSheet(WritableSheet writableSheet) throws WriteException {
        int n;
        int n2;
        WritableCellFormat writableCellFormat = new WritableCellFormat(WritableWorkbook.ARIAL_10_PT);
        writableCellFormat.setWrap(true);
        writableSheet.setColumnView(0, 20);
        writableSheet.setColumnView(4, 20);
        writableSheet.setColumnView(5, 20);
        writableSheet.setColumnView(6, 20);
        Label label = new Label(0, 0, "+/- Pi - default format", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        Number number = new Number(1, 0, 3.1415926535);
        writableSheet.addCell(number);
        number = new Number(2, 0, -3.1415926535);
        writableSheet.addCell(number);
        label = new Label(0, 1, "+/- Pi - integer format", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat2 = new WritableCellFormat(NumberFormats.INTEGER);
        number = new Number(1, 1, 3.1415926535, (CellFormat)writableCellFormat2);
        writableSheet.addCell(number);
        number = new Number(2, 1, -3.1415926535, (CellFormat)writableCellFormat2);
        writableSheet.addCell(number);
        label = new Label(0, 2, "+/- Pi - float 2dps", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat3 = new WritableCellFormat(NumberFormats.FLOAT);
        number = new Number(1, 2, 3.1415926535, (CellFormat)writableCellFormat3);
        writableSheet.addCell(number);
        number = new Number(2, 2, -3.1415926535, (CellFormat)writableCellFormat3);
        writableSheet.addCell(number);
        label = new Label(0, 3, "+/- Pi - custom 3dps", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        NumberFormat numberFormat = new NumberFormat("#.###");
        WritableCellFormat writableCellFormat4 = new WritableCellFormat(numberFormat);
        number = new Number(1, 3, 3.1415926535, (CellFormat)writableCellFormat4);
        writableSheet.addCell(number);
        number = new Number(2, 3, -3.1415926535, (CellFormat)writableCellFormat4);
        writableSheet.addCell(number);
        label = new Label(0, 4, "+/- Pi - custom &3.14", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        NumberFormat numberFormat2 = new NumberFormat("&#.00");
        WritableCellFormat writableCellFormat5 = new WritableCellFormat(numberFormat2);
        number = new Number(1, 4, 3.1415926535, (CellFormat)writableCellFormat5);
        writableSheet.addCell(number);
        number = new Number(2, 4, -3.1415926535, (CellFormat)writableCellFormat5);
        writableSheet.addCell(number);
        label = new Label(0, 5, "+/- Pi - custom Text #.### Text", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        NumberFormat numberFormat3 = new NumberFormat("Text#.####Text");
        WritableCellFormat writableCellFormat6 = new WritableCellFormat(numberFormat3);
        number = new Number(1, 5, 3.1415926535, (CellFormat)writableCellFormat6);
        writableSheet.addCell(number);
        number = new Number(2, 5, -3.1415926535, (CellFormat)writableCellFormat6);
        writableSheet.addCell(number);
        label = new Label(4, 0, "+/- Bilko default format");
        writableSheet.addCell(label);
        number = new Number(5, 0, 1.5042699E7);
        writableSheet.addCell(number);
        number = new Number(6, 0, -1.5042699E7);
        writableSheet.addCell(number);
        label = new Label(4, 1, "+/- Bilko float format");
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat7 = new WritableCellFormat(NumberFormats.FLOAT);
        number = new Number(5, 1, 1.5042699E7, (CellFormat)writableCellFormat7);
        writableSheet.addCell(number);
        number = new Number(6, 1, -1.5042699E7, (CellFormat)writableCellFormat7);
        writableSheet.addCell(number);
        label = new Label(4, 2, "+/- Thousands separator");
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat8 = new WritableCellFormat(NumberFormats.THOUSANDS_INTEGER);
        number = new Number(5, 2, 1.5042699E7, (CellFormat)writableCellFormat8);
        writableSheet.addCell(number);
        number = new Number(6, 2, -1.5042699E7, (CellFormat)writableCellFormat8);
        writableSheet.addCell(number);
        label = new Label(4, 3, "+/- Accounting red - added 0.01");
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat9 = new WritableCellFormat(NumberFormats.ACCOUNTING_RED_FLOAT);
        number = new Number(5, 3, 1.504269901E7, (CellFormat)writableCellFormat9);
        writableSheet.addCell(number);
        number = new Number(6, 3, -1.504269901E7, (CellFormat)writableCellFormat9);
        writableSheet.addCell(number);
        label = new Label(4, 4, "+/- Percent");
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat10 = new WritableCellFormat(NumberFormats.PERCENT_INTEGER);
        number = new Number(5, 4, 1.5042699E7, (CellFormat)writableCellFormat10);
        writableSheet.addCell(number);
        number = new Number(6, 4, -1.5042699E7, (CellFormat)writableCellFormat10);
        writableSheet.addCell(number);
        label = new Label(4, 5, "+/- Exponential - 2dps");
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat11 = new WritableCellFormat(NumberFormats.EXPONENTIAL);
        number = new Number(5, 5, 1.5042699E7, (CellFormat)writableCellFormat11);
        writableSheet.addCell(number);
        number = new Number(6, 5, -1.5042699E7, (CellFormat)writableCellFormat11);
        writableSheet.addCell(number);
        label = new Label(4, 6, "+/- Custom exponentional - 3dps", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        NumberFormat numberFormat4 = new NumberFormat("0.000E0");
        WritableCellFormat writableCellFormat12 = new WritableCellFormat(numberFormat4);
        number = new Number(5, 6, 1.5042699E7, (CellFormat)writableCellFormat12);
        writableSheet.addCell(number);
        number = new Number(6, 6, -1.5042699E7, (CellFormat)writableCellFormat12);
        writableSheet.addCell(number);
        label = new Label(4, 7, "Custom neg brackets", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        NumberFormat numberFormat5 = new NumberFormat("#,##0;(#,##0)");
        WritableCellFormat writableCellFormat13 = new WritableCellFormat(numberFormat5);
        number = new Number(5, 7, 1.5042699E7, (CellFormat)writableCellFormat13);
        writableSheet.addCell(number);
        number = new Number(6, 7, -1.5042699E7, (CellFormat)writableCellFormat13);
        writableSheet.addCell(number);
        label = new Label(4, 8, "Custom neg brackets 2", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        NumberFormat numberFormat6 = new NumberFormat("#,##0;(#,##0)a");
        WritableCellFormat writableCellFormat14 = new WritableCellFormat(numberFormat6);
        number = new Number(5, 8, 1.5042699E7, (CellFormat)writableCellFormat14);
        writableSheet.addCell(number);
        number = new Number(6, 8, -1.5042699E7, (CellFormat)writableCellFormat14);
        writableSheet.addCell(number);
        label = new Label(4, 9, "Custom percent", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        NumberFormat numberFormat7 = new NumberFormat("0.0%");
        WritableCellFormat writableCellFormat15 = new WritableCellFormat(numberFormat7);
        number = new Number(5, 9, 3.14159265, (CellFormat)writableCellFormat15);
        writableSheet.addCell(number);
        label = new Label(0, 10, "Boolean - TRUE");
        writableSheet.addCell(label);
        Boolean boolean_ = new Boolean(1, 10, true);
        writableSheet.addCell(boolean_);
        label = new Label(0, 11, "Boolean - FALSE");
        writableSheet.addCell(label);
        boolean_ = new Boolean(1, 11, false);
        writableSheet.addCell(boolean_);
        label = new Label(0, 12, "A hidden cell->");
        writableSheet.addCell(label);
        number = new Number(1, 12, 17.0, (CellFormat)WritableWorkbook.HIDDEN_STYLE);
        writableSheet.addCell(number);
        label = new Label(4, 19, "Currency formats");
        writableSheet.addCell(label);
        label = new Label(4, 21, "UK Pound");
        writableSheet.addCell(label);
        NumberFormat numberFormat8 = new NumberFormat("\u00a3 #,###.00", NumberFormat.COMPLEX_FORMAT);
        WritableCellFormat writableCellFormat16 = new WritableCellFormat(numberFormat8);
        number = new Number(5, 21, 12345.0, (CellFormat)writableCellFormat16);
        writableSheet.addCell(number);
        label = new Label(4, 22, "Euro 1");
        writableSheet.addCell(label);
        NumberFormat numberFormat9 = new NumberFormat("[$\u0080-2] #,###.00", NumberFormat.COMPLEX_FORMAT);
        WritableCellFormat writableCellFormat17 = new WritableCellFormat(numberFormat9);
        number = new Number(5, 22, 12345.0, (CellFormat)writableCellFormat17);
        writableSheet.addCell(number);
        label = new Label(4, 23, "Euro 2");
        writableSheet.addCell(label);
        NumberFormat numberFormat10 = new NumberFormat("#,###.00[$\u0080-1]", NumberFormat.COMPLEX_FORMAT);
        WritableCellFormat writableCellFormat18 = new WritableCellFormat(numberFormat10);
        number = new Number(5, 23, 12345.0, (CellFormat)writableCellFormat18);
        writableSheet.addCell(number);
        label = new Label(4, 24, "Dollar");
        writableSheet.addCell(label);
        NumberFormat numberFormat11 = new NumberFormat("[$$-409] #,###.00", NumberFormat.COMPLEX_FORMAT);
        WritableCellFormat writableCellFormat19 = new WritableCellFormat(numberFormat11);
        number = new Number(5, 24, 12345.0, (CellFormat)writableCellFormat19);
        writableSheet.addCell(number);
        label = new Label(4, 25, "Japanese Yen");
        writableSheet.addCell(label);
        NumberFormat numberFormat12 = new NumberFormat("[$\u00a5-411] #,###.00", NumberFormat.COMPLEX_FORMAT);
        WritableCellFormat writableCellFormat20 = new WritableCellFormat(numberFormat12);
        number = new Number(5, 25, 12345.0, (CellFormat)writableCellFormat20);
        writableSheet.addCell(number);
        label = new Label(4, 30, "Fraction formats");
        writableSheet.addCell(label);
        label = new Label(4, 32, "One digit fraction format", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat21 = new WritableCellFormat(NumberFormats.FRACTION_ONE_DIGIT);
        number = new Number(5, 32, 3.18279, (CellFormat)writableCellFormat21);
        writableSheet.addCell(number);
        label = new Label(4, 33, "Two digit fraction format", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat22 = new WritableCellFormat(NumberFormats.FRACTION_TWO_DIGITS);
        number = new Number(5, 33, 3.18279, (CellFormat)writableCellFormat22);
        writableSheet.addCell(number);
        label = new Label(4, 34, "Three digit fraction format (improper)", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        NumberFormat numberFormat13 = new NumberFormat("???/???", NumberFormat.COMPLEX_FORMAT);
        WritableCellFormat writableCellFormat23 = new WritableCellFormat(numberFormat13);
        number = new Number(5, 34, 3.18927, (CellFormat)writableCellFormat23);
        writableSheet.addCell(number);
        label = new Label(4, 35, "Three digit fraction format (proper)", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        NumberFormat numberFormat14 = new NumberFormat("# ???/???", NumberFormat.COMPLEX_FORMAT);
        WritableCellFormat writableCellFormat24 = new WritableCellFormat(numberFormat14);
        number = new Number(5, 35, 3.18927, (CellFormat)writableCellFormat24);
        writableSheet.addCell(number);
        for (n2 = 0; n2 < 100; ++n2) {
            for (n = 8; n < 108; ++n) {
                number = new Number(n, n2, (double)(n + n2));
                writableSheet.addCell(number);
            }
        }
        for (n2 = 101; n2 < 3000; ++n2) {
            for (n = 0; n < 25; ++n) {
                number = new Number(n, n2, (double)(n + n2));
                writableSheet.addCell(number);
            }
        }
    }

    private void writeDateFormatSheet(WritableSheet writableSheet) throws WriteException {
        WritableCellFormat writableCellFormat = new WritableCellFormat(WritableWorkbook.ARIAL_10_PT);
        writableCellFormat.setWrap(true);
        writableSheet.setColumnView(0, 20);
        writableSheet.setColumnView(2, 20);
        writableSheet.setColumnView(3, 20);
        writableSheet.setColumnView(4, 20);
        writableSheet.getSettings().setFitWidth(2);
        writableSheet.getSettings().setFitHeight(2);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(1975, 4, 31, 15, 21, 45);
        calendar.set(14, 660);
        Date date = calendar.getTime();
        calendar.set(1900, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        calendar.set(1970, 0, 1, 0, 0, 0);
        Date date3 = calendar.getTime();
        calendar.set(1918, 10, 11, 11, 0, 0);
        Date date4 = calendar.getTime();
        calendar.set(1900, 0, 2, 0, 0, 0);
        Date date5 = calendar.getTime();
        calendar.set(1901, 0, 1, 0, 0, 0);
        Date date6 = calendar.getTime();
        calendar.set(1900, 4, 31, 0, 0, 0);
        Date date7 = calendar.getTime();
        calendar.set(1900, 1, 1, 0, 0, 0);
        Date date8 = calendar.getTime();
        calendar.set(1900, 0, 31, 0, 0, 0);
        Date date9 = calendar.getTime();
        calendar.set(1900, 2, 1, 0, 0, 0);
        Date date10 = calendar.getTime();
        calendar.set(1900, 1, 27, 0, 0, 0);
        Date date11 = calendar.getTime();
        calendar.set(1900, 1, 28, 0, 0, 0);
        Date date12 = calendar.getTime();
        calendar.set(1980, 5, 31, 12, 0, 0);
        Date date13 = calendar.getTime();
        calendar.set(1066, 9, 14, 0, 0, 0);
        Date date14 = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss.SSS");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Label label = new Label(0, 0, "All dates are " + simpleDateFormat.format(date), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        label = new Label(0, 1, "Built in formats", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        label = new Label(2, 1, "Custom formats");
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT1);
        DateTime dateTime = new DateTime(0, 2, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT2);
        dateTime = new DateTime(0, 3, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT3);
        dateTime = new DateTime(0, 4, date, (CellFormat)writableCellFormat2);
        writableSheet.addCell(dateTime);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT4);
        dateTime = new DateTime(0, 5, date, (CellFormat)writableCellFormat2);
        writableSheet.addCell(dateTime);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT5);
        dateTime = new DateTime(0, 6, date, (CellFormat)writableCellFormat2);
        writableSheet.addCell(dateTime);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT6);
        dateTime = new DateTime(0, 7, date, (CellFormat)writableCellFormat2);
        writableSheet.addCell(dateTime);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT7);
        dateTime = new DateTime(0, 8, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT8);
        dateTime = new DateTime(0, 9, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(0, 10, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT10);
        dateTime = new DateTime(0, 11, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT11);
        dateTime = new DateTime(0, 12, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT12);
        dateTime = new DateTime(0, 13, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        DateFormat dateFormat = new DateFormat("dd MM yyyy");
        writableCellFormat2 = new WritableCellFormat(dateFormat);
        label = new Label(2, 2, "dd MM yyyy");
        writableSheet.addCell(label);
        dateTime = new DateTime(3, 2, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        dateFormat = new DateFormat("dd MMM yyyy");
        writableCellFormat2 = new WritableCellFormat(dateFormat);
        label = new Label(2, 3, "dd MMM yyyy");
        writableSheet.addCell(label);
        dateTime = new DateTime(3, 3, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        dateFormat = new DateFormat("hh:mm");
        writableCellFormat2 = new WritableCellFormat(dateFormat);
        label = new Label(2, 4, "hh:mm");
        writableSheet.addCell(label);
        dateTime = new DateTime(3, 4, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        dateFormat = new DateFormat("hh:mm:ss");
        writableCellFormat2 = new WritableCellFormat(dateFormat);
        label = new Label(2, 5, "hh:mm:ss");
        writableSheet.addCell(label);
        dateTime = new DateTime(3, 5, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        dateFormat = new DateFormat("H:mm:ss a");
        writableCellFormat2 = new WritableCellFormat(dateFormat);
        label = new Label(2, 5, "H:mm:ss a");
        writableSheet.addCell(label);
        dateTime = new DateTime(3, 5, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        dateTime = new DateTime(4, 5, date13, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        dateFormat = new DateFormat("mm:ss.SSS");
        writableCellFormat2 = new WritableCellFormat(dateFormat);
        label = new Label(2, 6, "mm:ss.SSS");
        writableSheet.addCell(label);
        dateTime = new DateTime(3, 6, date, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        dateFormat = new DateFormat("hh:mm:ss a");
        writableCellFormat2 = new WritableCellFormat(dateFormat);
        label = new Label(2, 7, "hh:mm:ss a");
        writableSheet.addCell(label);
        dateTime = new DateTime(4, 7, date13, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(0, 16, "Zero date " + simpleDateFormat.format(date2), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(0, 17, date2, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(3, 16, "Zero date + 1 " + simpleDateFormat.format(date5), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(3, 17, date5, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(3, 19, simpleDateFormat.format(date6), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(3, 20, date6, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(3, 22, simpleDateFormat.format(date7), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(3, 23, date7, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(3, 25, simpleDateFormat.format(date8), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(3, 26, date8, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(3, 28, simpleDateFormat.format(date9), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(3, 29, date9, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(3, 28, simpleDateFormat.format(date9), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(3, 29, date9, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(3, 31, simpleDateFormat.format(date10), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(3, 32, date10, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(3, 34, simpleDateFormat.format(date11), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(3, 35, date11, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(3, 37, simpleDateFormat.format(date12), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(3, 38, date12, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(0, 19, "Zero UTC date " + simpleDateFormat.format(date3), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(0, 20, date3, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(0, 22, "Armistice date " + simpleDateFormat.format(date4), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT9);
        dateTime = new DateTime(0, 23, date4, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
        label = new Label(0, 25, "Battle of Hastings " + simpleDateFormat.format(date14), (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableCellFormat2 = new WritableCellFormat(DateFormats.FORMAT2);
        dateTime = new DateTime(0, 26, date14, (CellFormat)writableCellFormat2, DateTime.GMT);
        writableSheet.addCell(dateTime);
    }

    private void writeLabelFormatSheet(WritableSheet writableSheet) throws WriteException {
        Object object;
        WritableRecordData writableRecordData;
        WritableRecordData writableRecordData2;
        Object object2;
        Label label;
        writableSheet.setColumnView(0, 60);
        Label label2 = new Label(0, 0, "Arial Fonts");
        writableSheet.addCell(label2);
        label2 = new Label(1, 0, "10pt");
        writableSheet.addCell(label2);
        label2 = new Label(2, 0, "Normal");
        writableSheet.addCell(label2);
        label2 = new Label(3, 0, "12pt");
        writableSheet.addCell(label2);
        WritableFont writableFont = new WritableFont(WritableFont.ARIAL, 12);
        WritableCellFormat writableCellFormat = new WritableCellFormat(writableFont);
        writableCellFormat.setWrap(true);
        label2 = new Label(4, 0, "Normal", (CellFormat)writableCellFormat);
        writableSheet.addCell(label2);
        WritableFont writableFont2 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat writableCellFormat2 = new WritableCellFormat(writableFont2);
        label2 = new Label(2, 2, "BOLD", (CellFormat)writableCellFormat2);
        writableSheet.addCell(label2);
        WritableFont writableFont3 = new WritableFont(WritableFont.ARIAL, 12, WritableFont.BOLD);
        WritableCellFormat writableCellFormat3 = new WritableCellFormat(writableFont3);
        label2 = new Label(4, 2, "BOLD", (CellFormat)writableCellFormat3);
        writableSheet.addCell(label2);
        WritableFont writableFont4 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, true);
        WritableCellFormat writableCellFormat4 = new WritableCellFormat(writableFont4);
        label2 = new Label(2, 4, "Italic", (CellFormat)writableCellFormat4);
        writableSheet.addCell(label2);
        WritableFont writableFont5 = new WritableFont(WritableFont.ARIAL, 12, WritableFont.NO_BOLD, true);
        WritableCellFormat writableCellFormat5 = new WritableCellFormat(writableFont5);
        label2 = new Label(4, 4, "Italic", (CellFormat)writableCellFormat5);
        writableSheet.addCell(label2);
        WritableFont writableFont6 = new WritableFont(WritableFont.TIMES, 10);
        WritableCellFormat writableCellFormat6 = new WritableCellFormat(writableFont6);
        label2 = new Label(0, 7, "Times Fonts", (CellFormat)writableCellFormat6);
        writableSheet.addCell(label2);
        label2 = new Label(1, 7, "10pt", (CellFormat)writableCellFormat6);
        writableSheet.addCell(label2);
        label2 = new Label(2, 7, "Normal", (CellFormat)writableCellFormat6);
        writableSheet.addCell(label2);
        label2 = new Label(3, 7, "12pt", (CellFormat)writableCellFormat6);
        writableSheet.addCell(label2);
        WritableFont writableFont7 = new WritableFont(WritableFont.TIMES, 12);
        WritableCellFormat writableCellFormat7 = new WritableCellFormat(writableFont7);
        label2 = new Label(4, 7, "Normal", (CellFormat)writableCellFormat7);
        writableSheet.addCell(label2);
        WritableFont writableFont8 = new WritableFont(WritableFont.TIMES, 10, WritableFont.BOLD);
        WritableCellFormat writableCellFormat8 = new WritableCellFormat(writableFont8);
        label2 = new Label(2, 9, "BOLD", (CellFormat)writableCellFormat8);
        writableSheet.addCell(label2);
        WritableFont writableFont9 = new WritableFont(WritableFont.TIMES, 12, WritableFont.BOLD);
        WritableCellFormat writableCellFormat9 = new WritableCellFormat(writableFont9);
        label2 = new Label(4, 9, "BOLD", (CellFormat)writableCellFormat9);
        writableSheet.addCell(label2);
        writableSheet.setColumnView(6, 22);
        writableSheet.setColumnView(7, 22);
        writableSheet.setColumnView(8, 22);
        writableSheet.setColumnView(9, 22);
        label2 = new Label(0, 11, "Underlining");
        writableSheet.addCell(label2);
        WritableFont writableFont10 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.SINGLE);
        WritableCellFormat writableCellFormat10 = new WritableCellFormat(writableFont10);
        label2 = new Label(6, 11, "Underline", (CellFormat)writableCellFormat10);
        writableSheet.addCell(label2);
        WritableFont writableFont11 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.DOUBLE);
        WritableCellFormat writableCellFormat11 = new WritableCellFormat(writableFont11);
        label2 = new Label(7, 11, "Double Underline", (CellFormat)writableCellFormat11);
        writableSheet.addCell(label2);
        WritableFont writableFont12 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.SINGLE_ACCOUNTING);
        WritableCellFormat writableCellFormat12 = new WritableCellFormat(writableFont12);
        label2 = new Label(8, 11, "Single Accounting Underline", (CellFormat)writableCellFormat12);
        writableSheet.addCell(label2);
        WritableFont writableFont13 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.DOUBLE_ACCOUNTING);
        WritableCellFormat writableCellFormat13 = new WritableCellFormat(writableFont13);
        label2 = new Label(9, 11, "Double Accounting Underline", (CellFormat)writableCellFormat13);
        writableSheet.addCell(label2);
        WritableFont writableFont14 = new WritableFont(WritableFont.TIMES, 14, WritableFont.BOLD, false, UnderlineStyle.SINGLE);
        WritableCellFormat writableCellFormat14 = new WritableCellFormat(writableFont14);
        label2 = new Label(6, 12, "Times 14 Bold Underline", (CellFormat)writableCellFormat14);
        writableSheet.addCell(label2);
        WritableFont writableFont15 = new WritableFont(WritableFont.ARIAL, 18, WritableFont.BOLD, true, UnderlineStyle.SINGLE);
        WritableCellFormat writableCellFormat15 = new WritableCellFormat(writableFont15);
        label2 = new Label(6, 13, "Arial 18 Bold Italic Underline", (CellFormat)writableCellFormat15);
        writableSheet.addCell(label2);
        label2 = new Label(0, 15, "Script styles");
        writableSheet.addCell(label2);
        WritableFont writableFont16 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.SUPERSCRIPT);
        WritableCellFormat writableCellFormat16 = new WritableCellFormat(writableFont16);
        label2 = new Label(1, 15, "superscript", (CellFormat)writableCellFormat16);
        writableSheet.addCell(label2);
        WritableFont writableFont17 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.SUBSCRIPT);
        WritableCellFormat writableCellFormat17 = new WritableCellFormat(writableFont17);
        label2 = new Label(2, 15, "subscript", (CellFormat)writableCellFormat17);
        writableSheet.addCell(label2);
        label2 = new Label(0, 17, "Colours");
        writableSheet.addCell(label2);
        WritableFont writableFont18 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.RED);
        WritableCellFormat writableCellFormat18 = new WritableCellFormat(writableFont18);
        label2 = new Label(2, 17, "Red", (CellFormat)writableCellFormat18);
        writableSheet.addCell(label2);
        WritableFont writableFont19 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLUE);
        WritableCellFormat writableCellFormat19 = new WritableCellFormat(writableFont19);
        label2 = new Label(2, 18, "Blue", (CellFormat)writableCellFormat19);
        writableSheet.addCell(label2);
        WritableFont writableFont20 = new WritableFont(WritableFont.ARIAL);
        writableFont20.setColour(Colour.LIME);
        WritableCellFormat writableCellFormat20 = new WritableCellFormat(writableFont20);
        writableCellFormat20.setWrap(true);
        label2 = new Label(4, 18, "Modified palette - was lime, now red", (CellFormat)writableCellFormat20);
        writableSheet.addCell(label2);
        WritableCellFormat writableCellFormat21 = new WritableCellFormat();
        writableCellFormat21.setWrap(true);
        writableCellFormat21.setBackground(Colour.GRAY_50);
        label2 = new Label(2, 19, "Grey background", (CellFormat)writableCellFormat21);
        writableSheet.addCell(label2);
        WritableFont writableFont21 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.YELLOW);
        WritableCellFormat writableCellFormat22 = new WritableCellFormat(writableFont21);
        writableCellFormat22.setWrap(true);
        writableCellFormat22.setBackground(Colour.BLUE);
        label2 = new Label(2, 20, "Blue background, yellow foreground", (CellFormat)writableCellFormat22);
        writableSheet.addCell(label2);
        label2 = new Label(0, 22, "Null label");
        writableSheet.addCell(label2);
        label2 = new Label(2, 22, null);
        writableSheet.addCell(label2);
        label2 = new Label(0, 24, "A very long label, more than 255 characters\nRejoice O shores\nSing O bells\nBut I with mournful tread\nWalk the deck my captain lies\nFallen cold and dead\nSummer surprised, coming over the Starnbergersee\nWith a shower of rain. We stopped in the Colonnade\nA very long label, more than 255 characters\nRejoice O shores\nSing O bells\nBut I with mournful tread\nWalk the deck my captain lies\nFallen cold and dead\nSummer surprised, coming over the Starnbergersee\nWith a shower of rain. We stopped in the Colonnade\nA very long label, more than 255 characters\nRejoice O shores\nSing O bells\nBut I with mournful tread\nWalk the deck my captain lies\nFallen cold and dead\nSummer surprised, coming over the Starnbergersee\nWith a shower of rain. We stopped in the Colonnade\nA very long label, more than 255 characters\nRejoice O shores\nSing O bells\nBut I with mournful tread\nWalk the deck my captain lies\nFallen cold and dead\nSummer surprised, coming over the Starnbergersee\nWith a shower of rain. We stopped in the Colonnade\nAnd sat and drank coffee an talked for an hour\n", (CellFormat)writableCellFormat);
        writableSheet.addCell(label2);
        WritableCellFormat writableCellFormat23 = new WritableCellFormat();
        writableCellFormat23.setOrientation(Orientation.VERTICAL);
        label2 = new Label(0, 26, "Vertical orientation", (CellFormat)writableCellFormat23);
        writableSheet.addCell(label2);
        WritableCellFormat writableCellFormat24 = new WritableCellFormat();
        writableCellFormat24.setOrientation(Orientation.PLUS_90);
        label2 = new Label(1, 26, "Plus 90", (CellFormat)writableCellFormat24);
        writableSheet.addCell(label2);
        WritableCellFormat writableCellFormat25 = new WritableCellFormat();
        writableCellFormat25.setOrientation(Orientation.MINUS_90);
        label2 = new Label(2, 26, "Minus 90", (CellFormat)writableCellFormat25);
        writableSheet.addCell(label2);
        label2 = new Label(0, 28, "Modified row height");
        writableSheet.addCell(label2);
        writableSheet.setRowView(28, 480);
        label2 = new Label(0, 29, "Collapsed row");
        writableSheet.addCell(label2);
        writableSheet.setRowView(29, true);
        try {
            label = new Label(0, 30, "Hyperlink to home page");
            writableSheet.addCell(label);
            object2 = new URL("http://www.andykhan.com/jexcelapi");
            writableRecordData2 = new WritableHyperlink(0, 30, 8, 31, (URL)object2);
            writableSheet.addHyperlink((WritableHyperlink)writableRecordData2);
            writableRecordData = new WritableHyperlink(7, 30, 9, 31, (URL)object2);
            writableSheet.addHyperlink((WritableHyperlink)writableRecordData);
            label = new Label(4, 2, "File hyperlink to documentation");
            writableSheet.addCell(label);
            object = new File("../jexcelapi/docs/index.html");
            writableRecordData2 = new WritableHyperlink(0, 32, 8, 32, (File)object);
            writableSheet.addHyperlink((WritableHyperlink)writableRecordData2);
            writableRecordData2 = new WritableHyperlink(0, 34, 8, 34, "Link to another cell", writableSheet, 0, 180, 1, 181);
            writableSheet.addHyperlink((WritableHyperlink)writableRecordData2);
            object = new File("\\\\localhost\\file.txt");
            writableRecordData2 = new WritableHyperlink(0, 36, 8, 36, (File)object);
            writableSheet.addHyperlink((WritableHyperlink)writableRecordData2);
            object2 = new URL("http://www.amazon.co.uk/exec/obidos/ASIN/0571058086/qid=1099836249/sr=1-3/ref=sr_1_11_3/202-6017285-1620664");
            writableRecordData2 = new WritableHyperlink(0, 38, 0, 38, (URL)object2);
            writableSheet.addHyperlink((WritableHyperlink)writableRecordData2);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException.toString());
        }
        label = new Label(5, 35, "Merged cells", (CellFormat)writableCellFormat14);
        writableSheet.mergeCells(5, 35, 8, 37);
        writableSheet.addCell(label);
        label = new Label(5, 38, "More merged cells");
        writableSheet.addCell(label);
        object2 = writableSheet.mergeCells(5, 38, 8, 41);
        writableSheet.insertRow(40);
        writableSheet.removeRow(39);
        writableSheet.unmergeCells((Range)object2);
        writableRecordData2 = new WritableCellFormat();
        ((WritableCellFormat)writableRecordData2).setAlignment(Alignment.CENTRE);
        label = new Label(5, 42, "Centred across merged cells", (CellFormat)((Object)writableRecordData2));
        writableSheet.addCell(label);
        writableSheet.mergeCells(5, 42, 10, 42);
        writableRecordData2 = new WritableCellFormat();
        ((WritableCellFormat)writableRecordData2).setBorder(Border.ALL, BorderLineStyle.THIN);
        ((WritableCellFormat)writableRecordData2).setBackground(Colour.GRAY_25);
        label = new Label(3, 44, "Merged with border", (CellFormat)((Object)writableRecordData2));
        writableSheet.addCell(label);
        writableSheet.mergeCells(3, 44, 4, 46);
        writableRecordData = new WritableFont(WritableFont.COURIER, 10);
        object = new WritableCellFormat((WritableFont)writableRecordData);
        label = new Label(0, 49, "Courier fonts", (CellFormat)object);
        writableSheet.addCell(label);
        WritableFont writableFont22 = new WritableFont(WritableFont.TAHOMA, 12);
        WritableCellFormat writableCellFormat26 = new WritableCellFormat(writableFont22);
        label = new Label(0, 50, "Tahoma fonts", (CellFormat)writableCellFormat26);
        writableSheet.addCell(label);
        WritableFont.FontName fontName = WritableFont.createFont("Wingdings 2");
        WritableFont writableFont23 = new WritableFont(fontName, 10);
        WritableCellFormat writableCellFormat27 = new WritableCellFormat(writableFont23);
        label = new Label(0, 51, "Bespoke Windgdings 2", (CellFormat)writableCellFormat27);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat28 = new WritableCellFormat(writableFont7);
        writableCellFormat28.setShrinkToFit(true);
        label = new Label(3, 53, "Shrunk to fit", (CellFormat)writableCellFormat28);
        writableSheet.addCell(label);
        label = new Label(3, 55, "Some long wrapped text in a merged cell", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        writableSheet.mergeCells(3, 55, 4, 55);
        label = new Label(0, 57, "A cell with a comment");
        WritableCellFeatures writableCellFeatures = new WritableCellFeatures();
        writableCellFeatures.setComment("the cell comment");
        label.setCellFeatures(writableCellFeatures);
        writableSheet.addCell(label);
        label = new Label(0, 59, "A cell with a long comment");
        writableCellFeatures = new WritableCellFeatures();
        writableCellFeatures.setComment("a very long cell comment indeed that won't fit inside a standard comment box, so a larger comment box is used instead", 5.0, 6.0);
        label.setCellFeatures(writableCellFeatures);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat29 = new WritableCellFormat(writableFont7);
        writableCellFormat29.setIndentation(4);
        label = new Label(0, 61, "Some indented text", (CellFormat)writableCellFormat29);
        writableSheet.addCell(label);
        label = new Label(0, 63, "Data validation:  list");
        writableSheet.addCell(label);
        Blank blank = new Blank(1, 63);
        writableCellFeatures = new WritableCellFeatures();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("bagpuss");
        arrayList.add("clangers");
        arrayList.add("ivor the engine");
        arrayList.add("noggin the nog");
        writableCellFeatures.setDataValidationList(arrayList);
        blank.setCellFeatures(writableCellFeatures);
        writableSheet.addCell(blank);
        label = new Label(0, 64, "Data validation:  number > 4.5");
        writableSheet.addCell(label);
        blank = new Blank(1, 64);
        writableCellFeatures = new WritableCellFeatures();
        writableCellFeatures.setNumberValidation(4.5, WritableCellFeatures.GREATER_THAN);
        blank.setCellFeatures(writableCellFeatures);
        writableSheet.addCell(blank);
        label = new Label(0, 65, "Data validation:  named range");
        writableSheet.addCell(label);
        label = new Label(4, 65, "tiger");
        writableSheet.addCell(label);
        label = new Label(5, 65, "sword");
        writableSheet.addCell(label);
        label = new Label(6, 65, "honour");
        writableSheet.addCell(label);
        label = new Label(7, 65, "company");
        writableSheet.addCell(label);
        label = new Label(8, 65, "victory");
        writableSheet.addCell(label);
        label = new Label(9, 65, "fortress");
        writableSheet.addCell(label);
        blank = new Blank(1, 65);
        writableCellFeatures = new WritableCellFeatures();
        writableCellFeatures.setDataValidationRange("validation_range");
        blank.setCellFeatures(writableCellFeatures);
        writableSheet.addCell(blank);
    }

    private void writeBordersSheet(WritableSheet writableSheet) throws WriteException {
        writableSheet.getSettings().setProtected(true);
        writableSheet.setColumnView(1, 15);
        writableSheet.setColumnView(2, 15);
        writableSheet.setColumnView(4, 15);
        WritableCellFormat writableCellFormat = new WritableCellFormat();
        writableCellFormat.setBorder(Border.LEFT, BorderLineStyle.THICK);
        Label label = new Label(1, 0, "Thick left", (CellFormat)writableCellFormat);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat2 = new WritableCellFormat();
        writableCellFormat2.setBorder(Border.RIGHT, BorderLineStyle.DASHED);
        label = new Label(2, 0, "Dashed right", (CellFormat)writableCellFormat2);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat3 = new WritableCellFormat();
        writableCellFormat3.setBorder(Border.TOP, BorderLineStyle.DOUBLE);
        label = new Label(1, 2, "Double top", (CellFormat)writableCellFormat3);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat4 = new WritableCellFormat();
        writableCellFormat4.setBorder(Border.BOTTOM, BorderLineStyle.HAIR);
        label = new Label(2, 2, "Hair bottom", (CellFormat)writableCellFormat4);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat5 = new WritableCellFormat();
        writableCellFormat5.setBorder(Border.ALL, BorderLineStyle.THIN);
        label = new Label(4, 2, "All thin", (CellFormat)writableCellFormat5);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat6 = new WritableCellFormat();
        writableCellFormat6.setBorder(Border.TOP, BorderLineStyle.THICK);
        writableCellFormat6.setBorder(Border.LEFT, BorderLineStyle.THICK);
        label = new Label(6, 2, "Two borders", (CellFormat)writableCellFormat6);
        writableSheet.addCell(label);
        label = new Label(20, 20, "Dislocated cell - after a page break");
        writableSheet.addCell(label);
        writableSheet.getSettings().setPaperSize(PaperSize.A3);
        writableSheet.getSettings().setOrientation(PageOrientation.LANDSCAPE);
        writableSheet.getSettings().setHeaderMargin(2.0);
        writableSheet.getSettings().setFooterMargin(2.0);
        writableSheet.getSettings().setTopMargin(3.0);
        writableSheet.getSettings().setBottomMargin(3.0);
        HeaderFooter headerFooter = new HeaderFooter();
        headerFooter.getCentre().append("Page Header");
        writableSheet.getSettings().setHeader(headerFooter);
        HeaderFooter headerFooter2 = new HeaderFooter();
        headerFooter2.getRight().append("page ");
        headerFooter2.getRight().appendPageNumber();
        writableSheet.getSettings().setFooter(headerFooter2);
        writableSheet.addRowPageBreak(18);
        writableSheet.insertRow(17);
        writableSheet.insertRow(17);
        writableSheet.removeRow(17);
        writableSheet.addRowPageBreak(30);
        label = new Label(10, 1, "Hidden column");
        writableSheet.addCell(label);
        label = new Label(3, 8, "Hidden row");
        writableSheet.addCell(label);
        writableSheet.setRowView(8, true);
        WritableCellFormat writableCellFormat7 = new WritableCellFormat();
        writableCellFormat7.setBorder(Border.ALL, BorderLineStyle.THICK, Colour.RED);
        label = new Label(1, 5, "All thick red", (CellFormat)writableCellFormat7);
        writableSheet.addCell(label);
        WritableCellFormat writableCellFormat8 = new WritableCellFormat();
        writableCellFormat8.setBorder(Border.TOP, BorderLineStyle.THIN, Colour.BLUE);
        writableCellFormat8.setBorder(Border.BOTTOM, BorderLineStyle.THIN, Colour.BLUE);
        label = new Label(4, 5, "Top and bottom blue", (CellFormat)writableCellFormat8);
        writableSheet.addCell(label);
    }

    private void writeLabelsSheet(WritableSheet writableSheet) throws WriteException {
        Label label;
        Label label2;
        Label label3;
        Label label4;
        writableSheet.getSettings().setProtected(true);
        writableSheet.getSettings().setPassword("jxl");
        writableSheet.getSettings().setVerticalFreeze(5);
        WritableFont writableFont = new WritableFont(WritableFont.ARIAL, 12);
        writableFont.setItalic(true);
        WritableCellFormat writableCellFormat = new WritableCellFormat(writableFont);
        CellView cellView = new CellView();
        cellView.setSize(6400);
        cellView.setFormat(writableCellFormat);
        writableSheet.setColumnView(0, cellView);
        writableSheet.setColumnView(1, 15);
        for (int i = 0; i < 61; ++i) {
            label4 = new Label(0, i, "Common Label");
            label3 = new Label(1, i, "Distinct label number " + i);
            writableSheet.addCell(label4);
            writableSheet.addCell(label3);
        }
        Label label5 = new Label(0, 61, "Common Label", (CellFormat)writableCellFormat);
        label4 = new Label(1, 61, "1-1234567890", (CellFormat)writableCellFormat);
        label3 = new Label(2, 61, "2-1234567890", (CellFormat)writableCellFormat);
        writableSheet.addCell(label5);
        writableSheet.addCell(label4);
        writableSheet.addCell(label3);
        for (int i = 62; i < 200; ++i) {
            label2 = new Label(0, i, "Common Label");
            label = new Label(1, i, "Distinct label number " + i);
            writableSheet.addCell(label2);
            writableSheet.addCell(label);
        }
        writableFont = new WritableFont(WritableFont.TIMES, 10, WritableFont.BOLD);
        writableFont.setColour(Colour.RED);
        WritableCellFormat writableCellFormat2 = new WritableCellFormat(writableFont);
        writableCellFormat2.setWrap(true);
        label2 = new Label(0, 205, "Different format", (CellFormat)writableCellFormat2);
        writableSheet.addCell(label2);
        label = new Label(5, 2, "A column for autosizing", (CellFormat)writableCellFormat2);
        writableSheet.addCell(label);
        label = new Label(5, 4, "Another label, longer this time and in a different font");
        writableSheet.addCell(label);
        CellView cellView2 = new CellView();
        cellView2.setAutosize(true);
        writableSheet.setColumnView(5, cellView2);
    }

    private void writeFormulaSheet(WritableSheet writableSheet) throws WriteException {
        Number number = new Number(0, 0, 15.0);
        writableSheet.addCell(number);
        number = new Number(0, 1, 16.0);
        writableSheet.addCell(number);
        number = new Number(0, 2, 10.0);
        writableSheet.addCell(number);
        number = new Number(0, 3, 12.0);
        writableSheet.addCell(number);
        writableSheet.setColumnView(2, 20);
        WritableCellFormat writableCellFormat = new WritableCellFormat();
        writableCellFormat.setAlignment(Alignment.RIGHT);
        writableCellFormat.setWrap(true);
        CellView cellView = new CellView();
        cellView.setSize(6400);
        cellView.setFormat(writableCellFormat);
        writableSheet.setColumnView(3, cellView);
        Formula formula = null;
        Label label = null;
        formula = new Formula(2, 0, "A1+A2");
        writableSheet.addCell(formula);
        label = new Label(3, 0, "a1+a2");
        writableSheet.addCell(label);
        formula = new Formula(2, 1, "A2 * 3");
        writableSheet.addCell(formula);
        label = new Label(3, 1, "A2 * 3");
        writableSheet.addCell(label);
        formula = new Formula(2, 2, "A2+A1/2.5");
        writableSheet.addCell(formula);
        label = new Label(3, 2, "A2+A1/2.5");
        writableSheet.addCell(label);
        formula = new Formula(2, 3, "3+(a1+a2)/2.5");
        writableSheet.addCell(formula);
        label = new Label(3, 3, "3+(a1+a2)/2.5");
        writableSheet.addCell(label);
        formula = new Formula(2, 4, "(a1+a2)/2.5");
        writableSheet.addCell(formula);
        label = new Label(3, 4, "(a1+a2)/2.5");
        writableSheet.addCell(label);
        formula = new Formula(2, 5, "15+((a1+a2)/2.5)*17");
        writableSheet.addCell(formula);
        label = new Label(3, 5, "15+((a1+a2)/2.5)*17");
        writableSheet.addCell(label);
        formula = new Formula(2, 6, "SUM(a1:a4)");
        writableSheet.addCell(formula);
        label = new Label(3, 6, "SUM(a1:a4)");
        writableSheet.addCell(label);
        formula = new Formula(2, 7, "SUM(a1:a4)/4");
        writableSheet.addCell(formula);
        label = new Label(3, 7, "SUM(a1:a4)/4");
        writableSheet.addCell(label);
        formula = new Formula(2, 8, "AVERAGE(A1:A4)");
        writableSheet.addCell(formula);
        label = new Label(3, 8, "AVERAGE(a1:a4)");
        writableSheet.addCell(label);
        formula = new Formula(2, 9, "MIN(5,4,1,2,3)");
        writableSheet.addCell(formula);
        label = new Label(3, 9, "MIN(5,4,1,2,3)");
        writableSheet.addCell(label);
        formula = new Formula(2, 10, "ROUND(3.14159265, 3)");
        writableSheet.addCell(formula);
        label = new Label(3, 10, "ROUND(3.14159265, 3)");
        writableSheet.addCell(label);
        formula = new Formula(2, 11, "MAX(SUM(A1:A2), A1*A2, POWER(A1, 2))");
        writableSheet.addCell(formula);
        label = new Label(3, 11, "MAX(SUM(A1:A2), A1*A2, POWER(A1, 2))");
        writableSheet.addCell(label);
        formula = new Formula(2, 12, "IF(A2>A1, \"A2 bigger\", \"A1 bigger\")");
        writableSheet.addCell(formula);
        label = new Label(3, 12, "IF(A2>A1, \"A2 bigger\", \"A1 bigger\")");
        writableSheet.addCell(label);
        formula = new Formula(2, 13, "IF(A2<=A1, \"A2 smaller\", \"A1 smaller\")");
        writableSheet.addCell(formula);
        label = new Label(3, 13, "IF(A2<=A1, \"A2 smaller\", \"A1 smaller\")");
        writableSheet.addCell(label);
        formula = new Formula(2, 14, "IF(A3<=10, \"<= 10\")");
        writableSheet.addCell(formula);
        label = new Label(3, 14, "IF(A3<=10, \"<= 10\")");
        writableSheet.addCell(label);
        formula = new Formula(2, 15, "SUM(1,2,3,4,5)");
        writableSheet.addCell(formula);
        label = new Label(3, 15, "SUM(1,2,3,4,5)");
        writableSheet.addCell(label);
        formula = new Formula(2, 16, "HYPERLINK(\"http://www.andykhan.com/jexcelapi\", \"JExcelApi Home Page\")");
        writableSheet.addCell(formula);
        label = new Label(3, 16, "HYPERLINK(\"http://www.andykhan.com/jexcelapi\", \"JExcelApi Home Page\")");
        writableSheet.addCell(label);
        formula = new Formula(2, 17, "3*4+5");
        writableSheet.addCell(formula);
        label = new Label(3, 17, "3*4+5");
        writableSheet.addCell(label);
        formula = new Formula(2, 18, "\"Plain text formula\"");
        writableSheet.addCell(formula);
        label = new Label(3, 18, "Plain text formula");
        writableSheet.addCell(label);
        formula = new Formula(2, 19, "SUM(a1,a2,-a3,a4)");
        writableSheet.addCell(formula);
        label = new Label(3, 19, "SUM(a1,a2,-a3,a4)");
        writableSheet.addCell(label);
        formula = new Formula(2, 20, "2*-(a1+a2)");
        writableSheet.addCell(formula);
        label = new Label(3, 20, "2*-(a1+a2)");
        writableSheet.addCell(label);
        formula = new Formula(2, 21, "'Number Formats'!B1/2");
        writableSheet.addCell(formula);
        label = new Label(3, 21, "'Number Formats'!B1/2");
        writableSheet.addCell(label);
        formula = new Formula(2, 22, "IF(F22=0, 0, F21/F22)");
        writableSheet.addCell(formula);
        label = new Label(3, 22, "IF(F22=0, 0, F21/F22)");
        writableSheet.addCell(label);
        formula = new Formula(2, 23, "RAND()");
        writableSheet.addCell(formula);
        label = new Label(3, 23, "RAND()");
        writableSheet.addCell(label);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'");
        stringBuffer.append(this.workbook.getSheet(0).getName());
        stringBuffer.append("'!");
        stringBuffer.append(CellReferenceHelper.getCellReference(9, 18));
        stringBuffer.append("*25");
        formula = new Formula(2, 24, stringBuffer.toString());
        writableSheet.addCell(formula);
        label = new Label(3, 24, stringBuffer.toString());
        writableSheet.addCell(label);
        writableCellFormat = new WritableCellFormat(DateFormats.DEFAULT);
        formula = new Formula(2, 25, "NOW()", (CellFormat)writableCellFormat);
        writableSheet.addCell(formula);
        label = new Label(3, 25, "NOW()");
        writableSheet.addCell(label);
        formula = new Formula(2, 26, "$A$2+A3");
        writableSheet.addCell(formula);
        label = new Label(3, 26, "$A$2+A3");
        writableSheet.addCell(label);
        formula = new Formula(2, 27, "IF(COUNT(A1:A9,B1:B9)=0,\"\",COUNT(A1:A9,B1:B9))");
        writableSheet.addCell(formula);
        label = new Label(3, 27, "IF(COUNT(A1:A9,B1:B9)=0,\"\",COUNT(A1:A9,B1:B9))");
        writableSheet.addCell(label);
        formula = new Formula(2, 28, "SUM(A1,A2,A3,A4)");
        writableSheet.addCell(formula);
        label = new Label(3, 28, "SUM(A1,A2,A3,A4)");
        writableSheet.addCell(label);
        label = new Label(1, 29, "a1");
        writableSheet.addCell(label);
        formula = new Formula(2, 29, "SUM(INDIRECT(ADDRESS(2,29)):A4)");
        writableSheet.addCell(formula);
        label = new Label(3, 29, "SUM(INDIRECT(ADDRESS(2,29):A4)");
        writableSheet.addCell(label);
        formula = new Formula(2, 30, "COUNTIF(A1:A4, \">=12\")");
        writableSheet.addCell(formula);
        label = new Label(3, 30, "COUNTIF(A1:A4, \">=12\")");
        writableSheet.addCell(label);
        formula = new Formula(2, 31, "MAX($A$1:$A$4)");
        writableSheet.addCell(formula);
        label = new Label(3, 31, "MAX($A$1:$A$4)");
        writableSheet.addCell(label);
        formula = new Formula(2, 32, "OR(A1,TRUE)");
        writableSheet.addCell(formula);
        label = new Label(3, 32, "OR(A1,TRUE)");
        writableSheet.addCell(label);
        formula = new Formula(2, 33, "ROWS(A1:C14)");
        writableSheet.addCell(formula);
        label = new Label(3, 33, "ROWS(A1:C14)");
        writableSheet.addCell(label);
        formula = new Formula(2, 34, "COUNTBLANK(A1:C14)");
        writableSheet.addCell(formula);
        label = new Label(3, 34, "COUNTBLANK(A1:C14)");
        writableSheet.addCell(label);
        formula = new Formula(2, 35, "IF(((F1=\"Not Found\")*(F2=\"Not Found\")*(F3=\"\")*(F4=\"\")*(F5=\"\")),1,0)");
        writableSheet.addCell(formula);
        label = new Label(3, 35, "IF(((F1=\"Not Found\")*(F2=\"Not Found\")*(F3=\"\")*(F4=\"\")*(F5=\"\")),1,0)");
        writableSheet.addCell(label);
        formula = new Formula(2, 36, "HYPERLINK(\"http://www.amazon.co.uk/exec/obidos/ASIN/0571058086qid=1099836249/sr=1-3/ref=sr_1_11_3/202-6017285-1620664\",  \"Long hyperlink\")");
        writableSheet.addCell(formula);
        formula = new Formula(2, 37, "1234567+2699");
        writableSheet.addCell(formula);
        label = new Label(3, 37, "1234567+2699");
        writableSheet.addCell(label);
        formula = new Formula(2, 38, "IF(ISERROR(G25/G29),0,-1)");
        writableSheet.addCell(formula);
        label = new Label(3, 38, "IF(ISERROR(G25/G29),0,-1)");
        writableSheet.addCell(label);
        formula = new Formula(2, 39, "SEARCH(\"C\",D40)");
        writableSheet.addCell(formula);
        label = new Label(3, 39, "SEARCH(\"C\",D40)");
        writableSheet.addCell(label);
        formula = new Formula(2, 40, "#REF!");
        writableSheet.addCell(formula);
        label = new Label(3, 40, "#REF!");
        writableSheet.addCell(label);
        number = new Number(1, 41, 79.0);
        writableSheet.addCell(number);
        formula = new Formula(2, 41, "--B42");
        writableSheet.addCell(formula);
        label = new Label(3, 41, "--B42");
        writableSheet.addCell(label);
    }

    private void writeImageSheet(WritableSheet writableSheet) throws WriteException {
        Label label = new Label(0, 0, "Weald & Downland Open Air Museum, Sussex");
        writableSheet.addCell(label);
        WritableImage writableImage = new WritableImage(0.0, 3.0, 5.0, 7.0, new File("resources/wealdanddownland.png"));
        writableSheet.addImage(writableImage);
        label = new Label(0, 12, "Merchant Adventurers Hall, York");
        writableSheet.addCell(label);
        writableImage = new WritableImage(5.0, 12.0, 4.0, 10.0, new File("resources/merchantadventurers.png"));
        writableSheet.addImage(writableImage);
    }
}

