/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.XFRecord;
import jxl.format.CellFormat;
import jxl.read.biff.CellFeaturesAccessor;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.Record;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SheetImpl;

public abstract class CellValue
extends RecordData
implements Cell,
CellFeaturesAccessor {
    private static Logger logger = Logger.getLogger(CellValue.class);
    private int row;
    private int column;
    private int xfIndex;
    private FormattingRecords formattingRecords;
    private boolean initialized;
    private XFRecord format;
    private SheetImpl sheet;
    private CellFeatures features;

    protected CellValue(Record record, FormattingRecords formattingRecords, SheetImpl sheetImpl) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        this.row = IntegerHelper.getInt(byArray[0], byArray[1]);
        this.column = IntegerHelper.getInt(byArray[2], byArray[3]);
        this.xfIndex = IntegerHelper.getInt(byArray[4], byArray[5]);
        this.sheet = sheetImpl;
        this.formattingRecords = formattingRecords;
        this.initialized = false;
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public final int getXFIndex() {
        return this.xfIndex;
    }

    public CellFormat getCellFormat() {
        if (!this.initialized) {
            this.format = this.formattingRecords.getXFRecord(this.xfIndex);
            this.initialized = true;
        }
        return this.format;
    }

    public boolean isHidden() {
        ColumnInfoRecord columnInfoRecord = this.sheet.getColumnInfo(this.column);
        if (columnInfoRecord != null && (columnInfoRecord.getWidth() == 0 || columnInfoRecord.getHidden())) {
            return true;
        }
        RowRecord rowRecord = this.sheet.getRowInfo(this.row);
        return rowRecord != null && (rowRecord.getRowHeight() == 0 || rowRecord.isCollapsed());
    }

    protected SheetImpl getSheet() {
        return this.sheet;
    }

    public CellFeatures getCellFeatures() {
        return this.features;
    }

    public void setCellFeatures(CellFeatures cellFeatures) {
        if (this.features != null) {
            logger.warn("current cell features not null - overwriting");
        }
        this.features = cellFeatures;
    }
}

